// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about an address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByoipCidr {
    /// <p>The address range, in CIDR notation.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>The description of the address range.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Upon success, contains the ID of the address pool. Otherwise, contains an error message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The state of the address pool.</p>
    pub state: std::option::Option<crate::model::ByoipCidrState>,
}
impl ByoipCidr {
    /// <p>The address range, in CIDR notation.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>The description of the address range.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Upon success, contains the ID of the address pool. Otherwise, contains an error message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The state of the address pool.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ByoipCidrState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for ByoipCidr {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByoipCidr");
        formatter.field("cidr", &self.cidr);
        formatter.field("description", &self.description);
        formatter.field("status_message", &self.status_message);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`ByoipCidr`](crate::model::ByoipCidr)
pub mod byoip_cidr {
    /// A builder for [`ByoipCidr`](crate::model::ByoipCidr)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ByoipCidrState>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The description of the address range.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the address range.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Upon success, contains the ID of the address pool. Otherwise, contains an error message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Upon success, contains the ID of the address pool. Otherwise, contains an error message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The state of the address pool.</p>
        pub fn state(mut self, input: crate::model::ByoipCidrState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the address pool.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ByoipCidrState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`ByoipCidr`](crate::model::ByoipCidr)
        pub fn build(self) -> crate::model::ByoipCidr {
            crate::model::ByoipCidr {
                cidr: self.cidr,
                description: self.description,
                status_message: self.status_message,
                state: self.state,
            }
        }
    }
}
impl ByoipCidr {
    /// Creates a new builder-style object to manufacture [`ByoipCidr`](crate::model::ByoipCidr)
    pub fn builder() -> crate::model::byoip_cidr::Builder {
        crate::model::byoip_cidr::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ByoipCidrState {
    #[allow(missing_docs)] // documentation missing in model
    Advertised,
    #[allow(missing_docs)] // documentation missing in model
    Deprovisioned,
    #[allow(missing_docs)] // documentation missing in model
    FailedDeprovision,
    #[allow(missing_docs)] // documentation missing in model
    FailedProvision,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeprovision,
    #[allow(missing_docs)] // documentation missing in model
    PendingProvision,
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    #[allow(missing_docs)] // documentation missing in model
    ProvisionedNotPubliclyAdvertisable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ByoipCidrState {
    fn from(s: &str) -> Self {
        match s {
            "advertised" => ByoipCidrState::Advertised,
            "deprovisioned" => ByoipCidrState::Deprovisioned,
            "failed-deprovision" => ByoipCidrState::FailedDeprovision,
            "failed-provision" => ByoipCidrState::FailedProvision,
            "pending-deprovision" => ByoipCidrState::PendingDeprovision,
            "pending-provision" => ByoipCidrState::PendingProvision,
            "provisioned" => ByoipCidrState::Provisioned,
            "provisioned-not-publicly-advertisable" => {
                ByoipCidrState::ProvisionedNotPubliclyAdvertisable
            }
            other => ByoipCidrState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ByoipCidrState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ByoipCidrState::from(s))
    }
}
impl ByoipCidrState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ByoipCidrState::Advertised => "advertised",
            ByoipCidrState::Deprovisioned => "deprovisioned",
            ByoipCidrState::FailedDeprovision => "failed-deprovision",
            ByoipCidrState::FailedProvision => "failed-provision",
            ByoipCidrState::PendingDeprovision => "pending-deprovision",
            ByoipCidrState::PendingProvision => "pending-provision",
            ByoipCidrState::Provisioned => "provisioned",
            ByoipCidrState::ProvisionedNotPubliclyAdvertisable => {
                "provisioned-not-publicly-advertisable"
            }
            ByoipCidrState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "advertised",
            "deprovisioned",
            "failed-deprovision",
            "failed-provision",
            "pending-deprovision",
            "pending-provision",
            "provisioned",
            "provisioned-not-publicly-advertisable",
        ]
    }
}
impl AsRef<str> for ByoipCidrState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the description of a security group rule.</p>
/// <p>You can use this when you want to update the security group rule description for either an inbound or outbound rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupRuleDescription {
    /// <p>The ID of the security group rule.</p>
    pub security_group_rule_id: std::option::Option<std::string::String>,
    /// <p>The description of the security group rule.</p>
    pub description: std::option::Option<std::string::String>,
}
impl SecurityGroupRuleDescription {
    /// <p>The ID of the security group rule.</p>
    pub fn security_group_rule_id(&self) -> std::option::Option<&str> {
        self.security_group_rule_id.as_deref()
    }
    /// <p>The description of the security group rule.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupRuleDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupRuleDescription");
        formatter.field("security_group_rule_id", &self.security_group_rule_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
pub mod security_group_rule_description {
    /// A builder for [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_rule_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the security group rule.</p>
        pub fn security_group_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group rule.</p>
        pub fn set_security_group_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_rule_id = input;
            self
        }
        /// <p>The description of the security group rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the security group rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
        pub fn build(self) -> crate::model::SecurityGroupRuleDescription {
            crate::model::SecurityGroupRuleDescription {
                security_group_rule_id: self.security_group_rule_id,
                description: self.description,
            }
        }
    }
}
impl SecurityGroupRuleDescription {
    /// Creates a new builder-style object to manufacture [`SecurityGroupRuleDescription`](crate::model::SecurityGroupRuleDescription)
    pub fn builder() -> crate::model::security_group_rule_description::Builder {
        crate::model::security_group_rule_description::Builder::default()
    }
}

/// <p>Describes a set of permissions for a security group rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpPermission {
    /// <p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
    pub from_port: std::option::Option<i32>,
    /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).</p>
    /// <p>[VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.</p>
    pub ip_protocol: std::option::Option<std::string::String>,
    /// <p>The IPv4 ranges.</p>
    pub ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
    /// <p>[VPC only] The IPv6 ranges.</p>
    pub ipv6_ranges: std::option::Option<std::vec::Vec<crate::model::Ipv6Range>>,
    /// <p>[VPC only] The prefix list IDs.</p>
    pub prefix_list_ids: std::option::Option<std::vec::Vec<crate::model::PrefixListId>>,
    /// <p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
    pub to_port: std::option::Option<i32>,
    /// <p>The security group and Amazon Web Services account ID pairs.</p>
    pub user_id_group_pairs: std::option::Option<std::vec::Vec<crate::model::UserIdGroupPair>>,
}
impl IpPermission {
    /// <p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
    pub fn from_port(&self) -> std::option::Option<i32> {
        self.from_port
    }
    /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).</p>
    /// <p>[VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.</p>
    pub fn ip_protocol(&self) -> std::option::Option<&str> {
        self.ip_protocol.as_deref()
    }
    /// <p>The IPv4 ranges.</p>
    pub fn ip_ranges(&self) -> std::option::Option<&[crate::model::IpRange]> {
        self.ip_ranges.as_deref()
    }
    /// <p>[VPC only] The IPv6 ranges.</p>
    pub fn ipv6_ranges(&self) -> std::option::Option<&[crate::model::Ipv6Range]> {
        self.ipv6_ranges.as_deref()
    }
    /// <p>[VPC only] The prefix list IDs.</p>
    pub fn prefix_list_ids(&self) -> std::option::Option<&[crate::model::PrefixListId]> {
        self.prefix_list_ids.as_deref()
    }
    /// <p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
    pub fn to_port(&self) -> std::option::Option<i32> {
        self.to_port
    }
    /// <p>The security group and Amazon Web Services account ID pairs.</p>
    pub fn user_id_group_pairs(&self) -> std::option::Option<&[crate::model::UserIdGroupPair]> {
        self.user_id_group_pairs.as_deref()
    }
}
impl std::fmt::Debug for IpPermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpPermission");
        formatter.field("from_port", &self.from_port);
        formatter.field("ip_protocol", &self.ip_protocol);
        formatter.field("ip_ranges", &self.ip_ranges);
        formatter.field("ipv6_ranges", &self.ipv6_ranges);
        formatter.field("prefix_list_ids", &self.prefix_list_ids);
        formatter.field("to_port", &self.to_port);
        formatter.field("user_id_group_pairs", &self.user_id_group_pairs);
        formatter.finish()
    }
}
/// See [`IpPermission`](crate::model::IpPermission)
pub mod ip_permission {
    /// A builder for [`IpPermission`](crate::model::IpPermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) ip_protocol: std::option::Option<std::string::String>,
        pub(crate) ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        pub(crate) ipv6_ranges: std::option::Option<std::vec::Vec<crate::model::Ipv6Range>>,
        pub(crate) prefix_list_ids: std::option::Option<std::vec::Vec<crate::model::PrefixListId>>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) user_id_group_pairs:
            std::option::Option<std::vec::Vec<crate::model::UserIdGroupPair>>,
    }
    impl Builder {
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.</p>
        pub fn ip_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_protocol = Some(input.into());
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. When authorizing security group rules, specifying <code>-1</code> or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify. For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range. For <code>icmpv6</code>, the port range is optional; if you omit the port range, traffic for all types and codes is allowed.</p>
        pub fn set_ip_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_protocol = input;
            self
        }
        /// Appends an item to `ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>The IPv4 ranges.</p>
        pub fn ip_ranges(mut self, input: crate::model::IpRange) -> Self {
            let mut v = self.ip_ranges.unwrap_or_default();
            v.push(input);
            self.ip_ranges = Some(v);
            self
        }
        /// <p>The IPv4 ranges.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        ) -> Self {
            self.ip_ranges = input;
            self
        }
        /// Appends an item to `ipv6_ranges`.
        ///
        /// To override the contents of this collection use [`set_ipv6_ranges`](Self::set_ipv6_ranges).
        ///
        /// <p>[VPC only] The IPv6 ranges.</p>
        pub fn ipv6_ranges(mut self, input: crate::model::Ipv6Range) -> Self {
            let mut v = self.ipv6_ranges.unwrap_or_default();
            v.push(input);
            self.ipv6_ranges = Some(v);
            self
        }
        /// <p>[VPC only] The IPv6 ranges.</p>
        pub fn set_ipv6_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv6Range>>,
        ) -> Self {
            self.ipv6_ranges = input;
            self
        }
        /// Appends an item to `prefix_list_ids`.
        ///
        /// To override the contents of this collection use [`set_prefix_list_ids`](Self::set_prefix_list_ids).
        ///
        /// <p>[VPC only] The prefix list IDs.</p>
        pub fn prefix_list_ids(mut self, input: crate::model::PrefixListId) -> Self {
            let mut v = self.prefix_list_ids.unwrap_or_default();
            v.push(input);
            self.prefix_list_ids = Some(v);
            self
        }
        /// <p>[VPC only] The prefix list IDs.</p>
        pub fn set_prefix_list_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrefixListId>>,
        ) -> Self {
            self.prefix_list_ids = input;
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// Appends an item to `user_id_group_pairs`.
        ///
        /// To override the contents of this collection use [`set_user_id_group_pairs`](Self::set_user_id_group_pairs).
        ///
        /// <p>The security group and Amazon Web Services account ID pairs.</p>
        pub fn user_id_group_pairs(mut self, input: crate::model::UserIdGroupPair) -> Self {
            let mut v = self.user_id_group_pairs.unwrap_or_default();
            v.push(input);
            self.user_id_group_pairs = Some(v);
            self
        }
        /// <p>The security group and Amazon Web Services account ID pairs.</p>
        pub fn set_user_id_group_pairs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserIdGroupPair>>,
        ) -> Self {
            self.user_id_group_pairs = input;
            self
        }
        /// Consumes the builder and constructs a [`IpPermission`](crate::model::IpPermission)
        pub fn build(self) -> crate::model::IpPermission {
            crate::model::IpPermission {
                from_port: self.from_port,
                ip_protocol: self.ip_protocol,
                ip_ranges: self.ip_ranges,
                ipv6_ranges: self.ipv6_ranges,
                prefix_list_ids: self.prefix_list_ids,
                to_port: self.to_port,
                user_id_group_pairs: self.user_id_group_pairs,
            }
        }
    }
}
impl IpPermission {
    /// Creates a new builder-style object to manufacture [`IpPermission`](crate::model::IpPermission)
    pub fn builder() -> crate::model::ip_permission::Builder {
        crate::model::ip_permission::Builder::default()
    }
}

/// <p>Describes a security group and Amazon Web Services account ID pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserIdGroupPair {
    /// <p>A description for the security group rule that references this user ID group pair.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the security group.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the security group ID. </p>
    /// <p>For a referenced security group in another VPC, this value is not returned if the referenced security group is deleted.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The status of a VPC peering connection, if applicable.</p>
    pub peering_status: std::option::Option<std::string::String>,
    /// <p>The ID of an Amazon Web Services account.</p>
    /// <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p>
    /// <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another Amazon Web Services account.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC for the referenced security group, if applicable.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC peering connection, if applicable.</p>
    pub vpc_peering_connection_id: std::option::Option<std::string::String>,
}
impl UserIdGroupPair {
    /// <p>A description for the security group rule that references this user ID group pair.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the security group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the security group ID. </p>
    /// <p>For a referenced security group in another VPC, this value is not returned if the referenced security group is deleted.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The status of a VPC peering connection, if applicable.</p>
    pub fn peering_status(&self) -> std::option::Option<&str> {
        self.peering_status.as_deref()
    }
    /// <p>The ID of an Amazon Web Services account.</p>
    /// <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p>
    /// <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another Amazon Web Services account.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The ID of the VPC for the referenced security group, if applicable.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The ID of the VPC peering connection, if applicable.</p>
    pub fn vpc_peering_connection_id(&self) -> std::option::Option<&str> {
        self.vpc_peering_connection_id.as_deref()
    }
}
impl std::fmt::Debug for UserIdGroupPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserIdGroupPair");
        formatter.field("description", &self.description);
        formatter.field("group_id", &self.group_id);
        formatter.field("group_name", &self.group_name);
        formatter.field("peering_status", &self.peering_status);
        formatter.field("user_id", &self.user_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("vpc_peering_connection_id", &self.vpc_peering_connection_id);
        formatter.finish()
    }
}
/// See [`UserIdGroupPair`](crate::model::UserIdGroupPair)
pub mod user_id_group_pair {
    /// A builder for [`UserIdGroupPair`](crate::model::UserIdGroupPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) peering_status: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description for the security group rule that references this user ID group pair.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group rule that references this user ID group pair.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the security group ID. </p>
        /// <p>For a referenced security group in another VPC, this value is not returned if the referenced security group is deleted.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the security group ID. </p>
        /// <p>For a referenced security group in another VPC, this value is not returned if the referenced security group is deleted.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The status of a VPC peering connection, if applicable.</p>
        pub fn peering_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.peering_status = Some(input.into());
            self
        }
        /// <p>The status of a VPC peering connection, if applicable.</p>
        pub fn set_peering_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peering_status = input;
            self
        }
        /// <p>The ID of an Amazon Web Services account.</p>
        /// <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p>
        /// <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another Amazon Web Services account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of an Amazon Web Services account.</p>
        /// <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p>
        /// <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another Amazon Web Services account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The ID of the VPC for the referenced security group, if applicable.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC for the referenced security group, if applicable.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ID of the VPC peering connection, if applicable.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC peering connection, if applicable.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserIdGroupPair`](crate::model::UserIdGroupPair)
        pub fn build(self) -> crate::model::UserIdGroupPair {
            crate::model::UserIdGroupPair {
                description: self.description,
                group_id: self.group_id,
                group_name: self.group_name,
                peering_status: self.peering_status,
                user_id: self.user_id,
                vpc_id: self.vpc_id,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
            }
        }
    }
}
impl UserIdGroupPair {
    /// Creates a new builder-style object to manufacture [`UserIdGroupPair`](crate::model::UserIdGroupPair)
    pub fn builder() -> crate::model::user_id_group_pair::Builder {
        crate::model::user_id_group_pair::Builder::default()
    }
}

/// <p>Describes a prefix list ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrefixListId {
    /// <p>A description for the security group rule that references this prefix list ID.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the prefix.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
}
impl PrefixListId {
    /// <p>A description for the security group rule that references this prefix list ID.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The ID of the prefix.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
}
impl std::fmt::Debug for PrefixListId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrefixListId");
        formatter.field("description", &self.description);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.finish()
    }
}
/// See [`PrefixListId`](crate::model::PrefixListId)
pub mod prefix_list_id {
    /// A builder for [`PrefixListId`](crate::model::PrefixListId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description for the security group rule that references this prefix list ID.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group rule that references this prefix list ID.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the prefix.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the prefix.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PrefixListId`](crate::model::PrefixListId)
        pub fn build(self) -> crate::model::PrefixListId {
            crate::model::PrefixListId {
                description: self.description,
                prefix_list_id: self.prefix_list_id,
            }
        }
    }
}
impl PrefixListId {
    /// Creates a new builder-style object to manufacture [`PrefixListId`](crate::model::PrefixListId)
    pub fn builder() -> crate::model::prefix_list_id::Builder {
        crate::model::prefix_list_id::Builder::default()
    }
}

/// <p>[EC2-VPC only] Describes an IPv6 range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ipv6Range {
    /// <p>The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv6 address, use the /128 prefix length.</p>
    pub cidr_ipv6: std::option::Option<std::string::String>,
    /// <p>A description for the security group rule that references this IPv6 address range.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub description: std::option::Option<std::string::String>,
}
impl Ipv6Range {
    /// <p>The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv6 address, use the /128 prefix length.</p>
    pub fn cidr_ipv6(&self) -> std::option::Option<&str> {
        self.cidr_ipv6.as_deref()
    }
    /// <p>A description for the security group rule that references this IPv6 address range.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for Ipv6Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ipv6Range");
        formatter.field("cidr_ipv6", &self.cidr_ipv6);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`Ipv6Range`](crate::model::Ipv6Range)
pub mod ipv6_range {
    /// A builder for [`Ipv6Range`](crate::model::Ipv6Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_ipv6: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv6 address, use the /128 prefix length.</p>
        pub fn cidr_ipv6(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ipv6 = Some(input.into());
            self
        }
        /// <p>The IPv6 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv6 address, use the /128 prefix length.</p>
        pub fn set_cidr_ipv6(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ipv6 = input;
            self
        }
        /// <p>A description for the security group rule that references this IPv6 address range.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group rule that references this IPv6 address range.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`Ipv6Range`](crate::model::Ipv6Range)
        pub fn build(self) -> crate::model::Ipv6Range {
            crate::model::Ipv6Range {
                cidr_ipv6: self.cidr_ipv6,
                description: self.description,
            }
        }
    }
}
impl Ipv6Range {
    /// Creates a new builder-style object to manufacture [`Ipv6Range`](crate::model::Ipv6Range)
    pub fn builder() -> crate::model::ipv6_range::Builder {
        crate::model::ipv6_range::Builder::default()
    }
}

/// <p>Describes an IPv4 range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRange {
    /// <p>The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv4 address, use the /32 prefix length.</p>
    pub cidr_ip: std::option::Option<std::string::String>,
    /// <p>A description for the security group rule that references this IPv4 address range.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub description: std::option::Option<std::string::String>,
}
impl IpRange {
    /// <p>The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv4 address, use the /32 prefix length.</p>
    pub fn cidr_ip(&self) -> std::option::Option<&str> {
        self.cidr_ip.as_deref()
    }
    /// <p>A description for the security group rule that references this IPv4 address range.</p>
    /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for IpRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRange");
        formatter.field("cidr_ip", &self.cidr_ip);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`IpRange`](crate::model::IpRange)
pub mod ip_range {
    /// A builder for [`IpRange`](crate::model::IpRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_ip: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv4 address, use the /32 prefix length.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ip = Some(input.into());
            self
        }
        /// <p>The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a single IPv4 address, use the /32 prefix length.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ip = input;
            self
        }
        /// <p>A description for the security group rule that references this IPv4 address range.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group rule that references this IPv4 address range.</p>
        /// <p>Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRange`](crate::model::IpRange)
        pub fn build(self) -> crate::model::IpRange {
            crate::model::IpRange {
                cidr_ip: self.cidr_ip,
                description: self.description,
            }
        }
    }
}
impl IpRange {
    /// Creates a new builder-style object to manufacture [`IpRange`](crate::model::IpRange)
    pub fn builder() -> crate::model::ip_range::Builder {
        crate::model::ip_range::Builder::default()
    }
}

/// <p>Describes the monitoring of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMonitoring {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The monitoring for the instance.</p>
    pub monitoring: std::option::Option<crate::model::Monitoring>,
}
impl InstanceMonitoring {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The monitoring for the instance.</p>
    pub fn monitoring(&self) -> std::option::Option<&crate::model::Monitoring> {
        self.monitoring.as_ref()
    }
}
impl std::fmt::Debug for InstanceMonitoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMonitoring");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("monitoring", &self.monitoring);
        formatter.finish()
    }
}
/// See [`InstanceMonitoring`](crate::model::InstanceMonitoring)
pub mod instance_monitoring {
    /// A builder for [`InstanceMonitoring`](crate::model::InstanceMonitoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) monitoring: std::option::Option<crate::model::Monitoring>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The monitoring for the instance.</p>
        pub fn monitoring(mut self, input: crate::model::Monitoring) -> Self {
            self.monitoring = Some(input);
            self
        }
        /// <p>The monitoring for the instance.</p>
        pub fn set_monitoring(
            mut self,
            input: std::option::Option<crate::model::Monitoring>,
        ) -> Self {
            self.monitoring = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMonitoring`](crate::model::InstanceMonitoring)
        pub fn build(self) -> crate::model::InstanceMonitoring {
            crate::model::InstanceMonitoring {
                instance_id: self.instance_id,
                monitoring: self.monitoring,
            }
        }
    }
}
impl InstanceMonitoring {
    /// Creates a new builder-style object to manufacture [`InstanceMonitoring`](crate::model::InstanceMonitoring)
    pub fn builder() -> crate::model::instance_monitoring::Builder {
        crate::model::instance_monitoring::Builder::default()
    }
}

/// <p>Describes the monitoring of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Monitoring {
    /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
    pub state: std::option::Option<crate::model::MonitoringState>,
}
impl Monitoring {
    /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::MonitoringState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for Monitoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Monitoring");
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`Monitoring`](crate::model::Monitoring)
pub mod monitoring {
    /// A builder for [`Monitoring`](crate::model::Monitoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::MonitoringState>,
    }
    impl Builder {
        /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
        pub fn state(mut self, input: crate::model::MonitoringState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MonitoringState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`Monitoring`](crate::model::Monitoring)
        pub fn build(self) -> crate::model::Monitoring {
            crate::model::Monitoring { state: self.state }
        }
    }
}
impl Monitoring {
    /// Creates a new builder-style object to manufacture [`Monitoring`](crate::model::Monitoring)
    pub fn builder() -> crate::model::monitoring::Builder {
        crate::model::monitoring::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MonitoringState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MonitoringState {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => MonitoringState::Disabled,
            "disabling" => MonitoringState::Disabling,
            "enabled" => MonitoringState::Enabled,
            "pending" => MonitoringState::Pending,
            other => MonitoringState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MonitoringState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MonitoringState::from(s))
    }
}
impl MonitoringState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MonitoringState::Disabled => "disabled",
            MonitoringState::Disabling => "disabling",
            MonitoringState::Enabled => "enabled",
            MonitoringState::Pending => "pending",
            MonitoringState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "disabling", "enabled", "pending"]
    }
}
impl AsRef<str> for MonitoringState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an instance state change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceStateChange {
    /// <p>The current state of the instance.</p>
    pub current_state: std::option::Option<crate::model::InstanceState>,
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The previous state of the instance.</p>
    pub previous_state: std::option::Option<crate::model::InstanceState>,
}
impl InstanceStateChange {
    /// <p>The current state of the instance.</p>
    pub fn current_state(&self) -> std::option::Option<&crate::model::InstanceState> {
        self.current_state.as_ref()
    }
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The previous state of the instance.</p>
    pub fn previous_state(&self) -> std::option::Option<&crate::model::InstanceState> {
        self.previous_state.as_ref()
    }
}
impl std::fmt::Debug for InstanceStateChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceStateChange");
        formatter.field("current_state", &self.current_state);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("previous_state", &self.previous_state);
        formatter.finish()
    }
}
/// See [`InstanceStateChange`](crate::model::InstanceStateChange)
pub mod instance_state_change {
    /// A builder for [`InstanceStateChange`](crate::model::InstanceStateChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current_state: std::option::Option<crate::model::InstanceState>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) previous_state: std::option::Option<crate::model::InstanceState>,
    }
    impl Builder {
        /// <p>The current state of the instance.</p>
        pub fn current_state(mut self, input: crate::model::InstanceState) -> Self {
            self.current_state = Some(input);
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn set_current_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.current_state = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The previous state of the instance.</p>
        pub fn previous_state(mut self, input: crate::model::InstanceState) -> Self {
            self.previous_state = Some(input);
            self
        }
        /// <p>The previous state of the instance.</p>
        pub fn set_previous_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.previous_state = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceStateChange`](crate::model::InstanceStateChange)
        pub fn build(self) -> crate::model::InstanceStateChange {
            crate::model::InstanceStateChange {
                current_state: self.current_state,
                instance_id: self.instance_id,
                previous_state: self.previous_state,
            }
        }
    }
}
impl InstanceStateChange {
    /// Creates a new builder-style object to manufacture [`InstanceStateChange`](crate::model::InstanceStateChange)
    pub fn builder() -> crate::model::instance_state_change::Builder {
        crate::model::instance_state_change::Builder::default()
    }
}

/// <p>Describes the current state of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceState {
    /// <p>The state of the instance as a 16-bit unsigned integer. </p>
    /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535. These numerical values are used for internal purposes and should be ignored.</p>
    /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255. </p>
    /// <p>The valid values for instance-state-code will all be in the range of the low byte and they are:</p>
    /// <ul>
    /// <li> <p> <code>0</code> : <code>pending</code> </p> </li>
    /// <li> <p> <code>16</code> : <code>running</code> </p> </li>
    /// <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li>
    /// <li> <p> <code>48</code> : <code>terminated</code> </p> </li>
    /// <li> <p> <code>64</code> : <code>stopping</code> </p> </li>
    /// <li> <p> <code>80</code> : <code>stopped</code> </p> </li>
    /// </ul>
    /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.</p>
    pub code: std::option::Option<i32>,
    /// <p>The current state of the instance.</p>
    pub name: std::option::Option<crate::model::InstanceStateName>,
}
impl InstanceState {
    /// <p>The state of the instance as a 16-bit unsigned integer. </p>
    /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535. These numerical values are used for internal purposes and should be ignored.</p>
    /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255. </p>
    /// <p>The valid values for instance-state-code will all be in the range of the low byte and they are:</p>
    /// <ul>
    /// <li> <p> <code>0</code> : <code>pending</code> </p> </li>
    /// <li> <p> <code>16</code> : <code>running</code> </p> </li>
    /// <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li>
    /// <li> <p> <code>48</code> : <code>terminated</code> </p> </li>
    /// <li> <p> <code>64</code> : <code>stopping</code> </p> </li>
    /// <li> <p> <code>80</code> : <code>stopped</code> </p> </li>
    /// </ul>
    /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.</p>
    pub fn code(&self) -> std::option::Option<i32> {
        self.code
    }
    /// <p>The current state of the instance.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::InstanceStateName> {
        self.name.as_ref()
    }
}
impl std::fmt::Debug for InstanceState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceState");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InstanceState`](crate::model::InstanceState)
pub mod instance_state {
    /// A builder for [`InstanceState`](crate::model::InstanceState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<i32>,
        pub(crate) name: std::option::Option<crate::model::InstanceStateName>,
    }
    impl Builder {
        /// <p>The state of the instance as a 16-bit unsigned integer. </p>
        /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535. These numerical values are used for internal purposes and should be ignored.</p>
        /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255. </p>
        /// <p>The valid values for instance-state-code will all be in the range of the low byte and they are:</p>
        /// <ul>
        /// <li> <p> <code>0</code> : <code>pending</code> </p> </li>
        /// <li> <p> <code>16</code> : <code>running</code> </p> </li>
        /// <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li>
        /// <li> <p> <code>48</code> : <code>terminated</code> </p> </li>
        /// <li> <p> <code>64</code> : <code>stopping</code> </p> </li>
        /// <li> <p> <code>80</code> : <code>stopped</code> </p> </li>
        /// </ul>
        /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.</p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state of the instance as a 16-bit unsigned integer. </p>
        /// <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535. These numerical values are used for internal purposes and should be ignored.</p>
        /// <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255. </p>
        /// <p>The valid values for instance-state-code will all be in the range of the low byte and they are:</p>
        /// <ul>
        /// <li> <p> <code>0</code> : <code>pending</code> </p> </li>
        /// <li> <p> <code>16</code> : <code>running</code> </p> </li>
        /// <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li>
        /// <li> <p> <code>48</code> : <code>terminated</code> </p> </li>
        /// <li> <p> <code>64</code> : <code>stopping</code> </p> </li>
        /// <li> <p> <code>80</code> : <code>stopped</code> </p> </li>
        /// </ul>
        /// <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.</p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn name(mut self, input: crate::model::InstanceStateName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::InstanceStateName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceState`](crate::model::InstanceState)
        pub fn build(self) -> crate::model::InstanceState {
            crate::model::InstanceState {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl InstanceState {
    /// Creates a new builder-style object to manufacture [`InstanceState`](crate::model::InstanceState)
    pub fn builder() -> crate::model::instance_state::Builder {
        crate::model::instance_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceStateName {
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    ShuttingDown,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceStateName {
    fn from(s: &str) -> Self {
        match s {
            "pending" => InstanceStateName::Pending,
            "running" => InstanceStateName::Running,
            "shutting-down" => InstanceStateName::ShuttingDown,
            "stopped" => InstanceStateName::Stopped,
            "stopping" => InstanceStateName::Stopping,
            "terminated" => InstanceStateName::Terminated,
            other => InstanceStateName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceStateName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceStateName::from(s))
    }
}
impl InstanceStateName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceStateName::Pending => "pending",
            InstanceStateName::Running => "running",
            InstanceStateName::ShuttingDown => "shutting-down",
            InstanceStateName::Stopped => "stopped",
            InstanceStateName::Stopping => "stopping",
            InstanceStateName::Terminated => "terminated",
            InstanceStateName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "pending",
            "running",
            "shutting-down",
            "stopped",
            "stopping",
            "terminated",
        ]
    }
}
impl AsRef<str> for InstanceStateName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a terminated Client VPN endpoint client connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateConnectionStatus {
    /// <p>The ID of the client connection.</p>
    pub connection_id: std::option::Option<std::string::String>,
    /// <p>The state of the client connection.</p>
    pub previous_status: std::option::Option<crate::model::ClientVpnConnectionStatus>,
    /// <p>A message about the status of the client connection, if applicable.</p>
    pub current_status: std::option::Option<crate::model::ClientVpnConnectionStatus>,
}
impl TerminateConnectionStatus {
    /// <p>The ID of the client connection.</p>
    pub fn connection_id(&self) -> std::option::Option<&str> {
        self.connection_id.as_deref()
    }
    /// <p>The state of the client connection.</p>
    pub fn previous_status(&self) -> std::option::Option<&crate::model::ClientVpnConnectionStatus> {
        self.previous_status.as_ref()
    }
    /// <p>A message about the status of the client connection, if applicable.</p>
    pub fn current_status(&self) -> std::option::Option<&crate::model::ClientVpnConnectionStatus> {
        self.current_status.as_ref()
    }
}
impl std::fmt::Debug for TerminateConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateConnectionStatus");
        formatter.field("connection_id", &self.connection_id);
        formatter.field("previous_status", &self.previous_status);
        formatter.field("current_status", &self.current_status);
        formatter.finish()
    }
}
/// See [`TerminateConnectionStatus`](crate::model::TerminateConnectionStatus)
pub mod terminate_connection_status {
    /// A builder for [`TerminateConnectionStatus`](crate::model::TerminateConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_id: std::option::Option<std::string::String>,
        pub(crate) previous_status: std::option::Option<crate::model::ClientVpnConnectionStatus>,
        pub(crate) current_status: std::option::Option<crate::model::ClientVpnConnectionStatus>,
    }
    impl Builder {
        /// <p>The ID of the client connection.</p>
        pub fn connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the client connection.</p>
        pub fn set_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_id = input;
            self
        }
        /// <p>The state of the client connection.</p>
        pub fn previous_status(mut self, input: crate::model::ClientVpnConnectionStatus) -> Self {
            self.previous_status = Some(input);
            self
        }
        /// <p>The state of the client connection.</p>
        pub fn set_previous_status(
            mut self,
            input: std::option::Option<crate::model::ClientVpnConnectionStatus>,
        ) -> Self {
            self.previous_status = input;
            self
        }
        /// <p>A message about the status of the client connection, if applicable.</p>
        pub fn current_status(mut self, input: crate::model::ClientVpnConnectionStatus) -> Self {
            self.current_status = Some(input);
            self
        }
        /// <p>A message about the status of the client connection, if applicable.</p>
        pub fn set_current_status(
            mut self,
            input: std::option::Option<crate::model::ClientVpnConnectionStatus>,
        ) -> Self {
            self.current_status = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateConnectionStatus`](crate::model::TerminateConnectionStatus)
        pub fn build(self) -> crate::model::TerminateConnectionStatus {
            crate::model::TerminateConnectionStatus {
                connection_id: self.connection_id,
                previous_status: self.previous_status,
                current_status: self.current_status,
            }
        }
    }
}
impl TerminateConnectionStatus {
    /// Creates a new builder-style object to manufacture [`TerminateConnectionStatus`](crate::model::TerminateConnectionStatus)
    pub fn builder() -> crate::model::terminate_connection_status::Builder {
        crate::model::terminate_connection_status::Builder::default()
    }
}

/// <p>Describes the status of a client connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientVpnConnectionStatus {
    /// <p>The state of the client connection.</p>
    pub code: std::option::Option<crate::model::ClientVpnConnectionStatusCode>,
    /// <p>A message about the status of the client connection, if applicable.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ClientVpnConnectionStatus {
    /// <p>The state of the client connection.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ClientVpnConnectionStatusCode> {
        self.code.as_ref()
    }
    /// <p>A message about the status of the client connection, if applicable.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ClientVpnConnectionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientVpnConnectionStatus");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ClientVpnConnectionStatus`](crate::model::ClientVpnConnectionStatus)
pub mod client_vpn_connection_status {
    /// A builder for [`ClientVpnConnectionStatus`](crate::model::ClientVpnConnectionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ClientVpnConnectionStatusCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the client connection.</p>
        pub fn code(mut self, input: crate::model::ClientVpnConnectionStatusCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state of the client connection.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ClientVpnConnectionStatusCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message about the status of the client connection, if applicable.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the status of the client connection, if applicable.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientVpnConnectionStatus`](crate::model::ClientVpnConnectionStatus)
        pub fn build(self) -> crate::model::ClientVpnConnectionStatus {
            crate::model::ClientVpnConnectionStatus {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ClientVpnConnectionStatus {
    /// Creates a new builder-style object to manufacture [`ClientVpnConnectionStatus`](crate::model::ClientVpnConnectionStatus)
    pub fn builder() -> crate::model::client_vpn_connection_status::Builder {
        crate::model::client_vpn_connection_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClientVpnConnectionStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    FailedToTerminate,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClientVpnConnectionStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "active" => ClientVpnConnectionStatusCode::Active,
            "failed-to-terminate" => ClientVpnConnectionStatusCode::FailedToTerminate,
            "terminated" => ClientVpnConnectionStatusCode::Terminated,
            "terminating" => ClientVpnConnectionStatusCode::Terminating,
            other => ClientVpnConnectionStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClientVpnConnectionStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClientVpnConnectionStatusCode::from(s))
    }
}
impl ClientVpnConnectionStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClientVpnConnectionStatusCode::Active => "active",
            ClientVpnConnectionStatusCode::FailedToTerminate => "failed-to-terminate",
            ClientVpnConnectionStatusCode::Terminated => "terminated",
            ClientVpnConnectionStatusCode::Terminating => "terminating",
            ClientVpnConnectionStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "failed-to-terminate", "terminated", "terminating"]
    }
}
impl AsRef<str> for ClientVpnConnectionStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a network insights analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInsightsAnalysis {
    /// <p>The ID of the network insights analysis.</p>
    pub network_insights_analysis_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the network insights analysis.</p>
    pub network_insights_analysis_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the path.</p>
    pub network_insights_path_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.</p>
    pub filter_in_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time the analysis started.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the network insights analysis.</p>
    pub status: std::option::Option<crate::model::AnalysisStatus>,
    /// <p>The status message, if the status is <code>failed</code>.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The warning message.</p>
    pub warning_message: std::option::Option<std::string::String>,
    /// <p>Indicates whether the destination is reachable from the source.</p>
    pub network_path_found: std::option::Option<bool>,
    /// <p>The components in the path from source to destination.</p>
    pub forward_path_components: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
    /// <p>The components in the path from destination to source.</p>
    pub return_path_components: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
    /// <p>The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>
    pub explanations: std::option::Option<std::vec::Vec<crate::model::Explanation>>,
    /// <p>Potential intermediate components.</p>
    pub alternate_path_hints: std::option::Option<std::vec::Vec<crate::model::AlternatePathHint>>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NetworkInsightsAnalysis {
    /// <p>The ID of the network insights analysis.</p>
    pub fn network_insights_analysis_id(&self) -> std::option::Option<&str> {
        self.network_insights_analysis_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the network insights analysis.</p>
    pub fn network_insights_analysis_arn(&self) -> std::option::Option<&str> {
        self.network_insights_analysis_arn.as_deref()
    }
    /// <p>The ID of the path.</p>
    pub fn network_insights_path_id(&self) -> std::option::Option<&str> {
        self.network_insights_path_id.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.</p>
    pub fn filter_in_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.filter_in_arns.as_deref()
    }
    /// <p>The time the analysis started.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The status of the network insights analysis.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnalysisStatus> {
        self.status.as_ref()
    }
    /// <p>The status message, if the status is <code>failed</code>.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The warning message.</p>
    pub fn warning_message(&self) -> std::option::Option<&str> {
        self.warning_message.as_deref()
    }
    /// <p>Indicates whether the destination is reachable from the source.</p>
    pub fn network_path_found(&self) -> std::option::Option<bool> {
        self.network_path_found
    }
    /// <p>The components in the path from source to destination.</p>
    pub fn forward_path_components(&self) -> std::option::Option<&[crate::model::PathComponent]> {
        self.forward_path_components.as_deref()
    }
    /// <p>The components in the path from destination to source.</p>
    pub fn return_path_components(&self) -> std::option::Option<&[crate::model::PathComponent]> {
        self.return_path_components.as_deref()
    }
    /// <p>The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>
    pub fn explanations(&self) -> std::option::Option<&[crate::model::Explanation]> {
        self.explanations.as_deref()
    }
    /// <p>Potential intermediate components.</p>
    pub fn alternate_path_hints(&self) -> std::option::Option<&[crate::model::AlternatePathHint]> {
        self.alternate_path_hints.as_deref()
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NetworkInsightsAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInsightsAnalysis");
        formatter.field(
            "network_insights_analysis_id",
            &self.network_insights_analysis_id,
        );
        formatter.field(
            "network_insights_analysis_arn",
            &self.network_insights_analysis_arn,
        );
        formatter.field("network_insights_path_id", &self.network_insights_path_id);
        formatter.field("filter_in_arns", &self.filter_in_arns);
        formatter.field("start_date", &self.start_date);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("warning_message", &self.warning_message);
        formatter.field("network_path_found", &self.network_path_found);
        formatter.field("forward_path_components", &self.forward_path_components);
        formatter.field("return_path_components", &self.return_path_components);
        formatter.field("explanations", &self.explanations);
        formatter.field("alternate_path_hints", &self.alternate_path_hints);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NetworkInsightsAnalysis`](crate::model::NetworkInsightsAnalysis)
pub mod network_insights_analysis {
    /// A builder for [`NetworkInsightsAnalysis`](crate::model::NetworkInsightsAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_insights_analysis_id: std::option::Option<std::string::String>,
        pub(crate) network_insights_analysis_arn: std::option::Option<std::string::String>,
        pub(crate) network_insights_path_id: std::option::Option<std::string::String>,
        pub(crate) filter_in_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AnalysisStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) warning_message: std::option::Option<std::string::String>,
        pub(crate) network_path_found: std::option::Option<bool>,
        pub(crate) forward_path_components:
            std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
        pub(crate) return_path_components:
            std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
        pub(crate) explanations: std::option::Option<std::vec::Vec<crate::model::Explanation>>,
        pub(crate) alternate_path_hints:
            std::option::Option<std::vec::Vec<crate::model::AlternatePathHint>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the network insights analysis.</p>
        pub fn network_insights_analysis_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_insights_analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the network insights analysis.</p>
        pub fn set_network_insights_analysis_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_analysis_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network insights analysis.</p>
        pub fn network_insights_analysis_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_insights_analysis_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network insights analysis.</p>
        pub fn set_network_insights_analysis_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_analysis_arn = input;
            self
        }
        /// <p>The ID of the path.</p>
        pub fn network_insights_path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_insights_path_id = Some(input.into());
            self
        }
        /// <p>The ID of the path.</p>
        pub fn set_network_insights_path_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_path_id = input;
            self
        }
        /// Appends an item to `filter_in_arns`.
        ///
        /// To override the contents of this collection use [`set_filter_in_arns`](Self::set_filter_in_arns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.</p>
        pub fn filter_in_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_in_arns.unwrap_or_default();
            v.push(input.into());
            self.filter_in_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the Amazon Web Services resources that the path must traverse.</p>
        pub fn set_filter_in_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_in_arns = input;
            self
        }
        /// <p>The time the analysis started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The time the analysis started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The status of the network insights analysis.</p>
        pub fn status(mut self, input: crate::model::AnalysisStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the network insights analysis.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnalysisStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message, if the status is <code>failed</code>.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message, if the status is <code>failed</code>.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The warning message.</p>
        pub fn warning_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_message = Some(input.into());
            self
        }
        /// <p>The warning message.</p>
        pub fn set_warning_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_message = input;
            self
        }
        /// <p>Indicates whether the destination is reachable from the source.</p>
        pub fn network_path_found(mut self, input: bool) -> Self {
            self.network_path_found = Some(input);
            self
        }
        /// <p>Indicates whether the destination is reachable from the source.</p>
        pub fn set_network_path_found(mut self, input: std::option::Option<bool>) -> Self {
            self.network_path_found = input;
            self
        }
        /// Appends an item to `forward_path_components`.
        ///
        /// To override the contents of this collection use [`set_forward_path_components`](Self::set_forward_path_components).
        ///
        /// <p>The components in the path from source to destination.</p>
        pub fn forward_path_components(mut self, input: crate::model::PathComponent) -> Self {
            let mut v = self.forward_path_components.unwrap_or_default();
            v.push(input);
            self.forward_path_components = Some(v);
            self
        }
        /// <p>The components in the path from source to destination.</p>
        pub fn set_forward_path_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
        ) -> Self {
            self.forward_path_components = input;
            self
        }
        /// Appends an item to `return_path_components`.
        ///
        /// To override the contents of this collection use [`set_return_path_components`](Self::set_return_path_components).
        ///
        /// <p>The components in the path from destination to source.</p>
        pub fn return_path_components(mut self, input: crate::model::PathComponent) -> Self {
            let mut v = self.return_path_components.unwrap_or_default();
            v.push(input);
            self.return_path_components = Some(v);
            self
        }
        /// <p>The components in the path from destination to source.</p>
        pub fn set_return_path_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PathComponent>>,
        ) -> Self {
            self.return_path_components = input;
            self
        }
        /// Appends an item to `explanations`.
        ///
        /// To override the contents of this collection use [`set_explanations`](Self::set_explanations).
        ///
        /// <p>The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>
        pub fn explanations(mut self, input: crate::model::Explanation) -> Self {
            let mut v = self.explanations.unwrap_or_default();
            v.push(input);
            self.explanations = Some(v);
            self
        }
        /// <p>The explanations. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>
        pub fn set_explanations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Explanation>>,
        ) -> Self {
            self.explanations = input;
            self
        }
        /// Appends an item to `alternate_path_hints`.
        ///
        /// To override the contents of this collection use [`set_alternate_path_hints`](Self::set_alternate_path_hints).
        ///
        /// <p>Potential intermediate components.</p>
        pub fn alternate_path_hints(mut self, input: crate::model::AlternatePathHint) -> Self {
            let mut v = self.alternate_path_hints.unwrap_or_default();
            v.push(input);
            self.alternate_path_hints = Some(v);
            self
        }
        /// <p>Potential intermediate components.</p>
        pub fn set_alternate_path_hints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlternatePathHint>>,
        ) -> Self {
            self.alternate_path_hints = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInsightsAnalysis`](crate::model::NetworkInsightsAnalysis)
        pub fn build(self) -> crate::model::NetworkInsightsAnalysis {
            crate::model::NetworkInsightsAnalysis {
                network_insights_analysis_id: self.network_insights_analysis_id,
                network_insights_analysis_arn: self.network_insights_analysis_arn,
                network_insights_path_id: self.network_insights_path_id,
                filter_in_arns: self.filter_in_arns,
                start_date: self.start_date,
                status: self.status,
                status_message: self.status_message,
                warning_message: self.warning_message,
                network_path_found: self.network_path_found,
                forward_path_components: self.forward_path_components,
                return_path_components: self.return_path_components,
                explanations: self.explanations,
                alternate_path_hints: self.alternate_path_hints,
                tags: self.tags,
            }
        }
    }
}
impl NetworkInsightsAnalysis {
    /// Creates a new builder-style object to manufacture [`NetworkInsightsAnalysis`](crate::model::NetworkInsightsAnalysis)
    pub fn builder() -> crate::model::network_insights_analysis::Builder {
        crate::model::network_insights_analysis::Builder::default()
    }
}

/// <p>Describes a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    /// <p>Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with <code>aws:</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    /// <p>Constraints: Tag values are case-sensitive and accept a maximum of 256 Unicode characters.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    /// <p>Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with <code>aws:</code>.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    /// <p>Constraints: Tag values are case-sensitive and accept a maximum of 256 Unicode characters.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        /// <p>Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with <code>aws:</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        /// <p>Constraints: Tag keys are case-sensitive and accept a maximum of 127 Unicode characters. May not begin with <code>aws:</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        /// <p>Constraints: Tag values are case-sensitive and accept a maximum of 256 Unicode characters.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        /// <p>Constraints: Tag values are case-sensitive and accept a maximum of 256 Unicode characters.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes an potential intermediate component of a feasible path.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlternatePathHint {
    /// <p>The ID of the component.</p>
    pub component_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub component_arn: std::option::Option<std::string::String>,
}
impl AlternatePathHint {
    /// <p>The ID of the component.</p>
    pub fn component_id(&self) -> std::option::Option<&str> {
        self.component_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub fn component_arn(&self) -> std::option::Option<&str> {
        self.component_arn.as_deref()
    }
}
impl std::fmt::Debug for AlternatePathHint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlternatePathHint");
        formatter.field("component_id", &self.component_id);
        formatter.field("component_arn", &self.component_arn);
        formatter.finish()
    }
}
/// See [`AlternatePathHint`](crate::model::AlternatePathHint)
pub mod alternate_path_hint {
    /// A builder for [`AlternatePathHint`](crate::model::AlternatePathHint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_id: std::option::Option<std::string::String>,
        pub(crate) component_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the component.</p>
        pub fn component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_id = Some(input.into());
            self
        }
        /// <p>The ID of the component.</p>
        pub fn set_component_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.component_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AlternatePathHint`](crate::model::AlternatePathHint)
        pub fn build(self) -> crate::model::AlternatePathHint {
            crate::model::AlternatePathHint {
                component_id: self.component_id,
                component_arn: self.component_arn,
            }
        }
    }
}
impl AlternatePathHint {
    /// Creates a new builder-style object to manufacture [`AlternatePathHint`](crate::model::AlternatePathHint)
    pub fn builder() -> crate::model::alternate_path_hint::Builder {
        crate::model::alternate_path_hint::Builder::default()
    }
}

/// <p>Describes an explanation code for an unreachable path. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html">Reachability Analyzer explanation codes</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Explanation {
    /// <p>The network ACL.</p>
    pub acl: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The network ACL rule.</p>
    pub acl_rule: std::option::Option<crate::model::AnalysisAclRule>,
    /// <p>The IPv4 address, in CIDR notation.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The IPv4 addresses, in CIDR notation.</p>
    pub addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The resource to which the component is attached.</p>
    pub attached_to: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The Availability Zones.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The CIDR ranges.</p>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The component.</p>
    pub component: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The customer gateway.</p>
    pub customer_gateway: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The destination.</p>
    pub destination: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The destination VPC.</p>
    pub destination_vpc: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The direction. The following are possible values:</p>
    /// <ul>
    /// <li> <p>egress</p> </li>
    /// <li> <p>ingress</p> </li>
    /// </ul>
    pub direction: std::option::Option<std::string::String>,
    /// <p>The explanation code.</p>
    pub explanation_code: std::option::Option<std::string::String>,
    /// <p>The route table.</p>
    pub ingress_route_table: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The internet gateway.</p>
    pub internet_gateway: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub load_balancer_arn: std::option::Option<std::string::String>,
    /// <p>The listener for a Classic Load Balancer.</p>
    pub classic_load_balancer_listener:
        std::option::Option<crate::model::AnalysisLoadBalancerListener>,
    /// <p>The listener port of the load balancer.</p>
    pub load_balancer_listener_port: std::option::Option<i32>,
    /// <p>The target.</p>
    pub load_balancer_target: std::option::Option<crate::model::AnalysisLoadBalancerTarget>,
    /// <p>The target group.</p>
    pub load_balancer_target_group: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The target groups.</p>
    pub load_balancer_target_groups:
        std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
    /// <p>The target port.</p>
    pub load_balancer_target_port: std::option::Option<i32>,
    /// <p>The load balancer listener.</p>
    pub elastic_load_balancer_listener: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The missing component.</p>
    pub missing_component: std::option::Option<std::string::String>,
    /// <p>The NAT gateway.</p>
    pub nat_gateway: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The network interface.</p>
    pub network_interface: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The packet field.</p>
    pub packet_field: std::option::Option<std::string::String>,
    /// <p>The VPC peering connection.</p>
    pub vpc_peering_connection: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The port.</p>
    pub port: std::option::Option<i32>,
    /// <p>The port ranges.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The prefix list.</p>
    pub prefix_list: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The protocols.</p>
    pub protocols: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The route table route.</p>
    pub route_table_route: std::option::Option<crate::model::AnalysisRouteTableRoute>,
    /// <p>The route table.</p>
    pub route_table: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The security group.</p>
    pub security_group: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The security group rule.</p>
    pub security_group_rule: std::option::Option<crate::model::AnalysisSecurityGroupRule>,
    /// <p>The security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
    /// <p>The source VPC.</p>
    pub source_vpc: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The state.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The subnet.</p>
    pub subnet: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The route table for the subnet.</p>
    pub subnet_route_table: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The component VPC.</p>
    pub vpc: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The VPC endpoint.</p>
    pub vpc_endpoint: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The VPN connection.</p>
    pub vpn_connection: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The VPN gateway.</p>
    pub vpn_gateway: std::option::Option<crate::model::AnalysisComponent>,
}
impl Explanation {
    /// <p>The network ACL.</p>
    pub fn acl(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.acl.as_ref()
    }
    /// <p>The network ACL rule.</p>
    pub fn acl_rule(&self) -> std::option::Option<&crate::model::AnalysisAclRule> {
        self.acl_rule.as_ref()
    }
    /// <p>The IPv4 address, in CIDR notation.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The IPv4 addresses, in CIDR notation.</p>
    pub fn addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.addresses.as_deref()
    }
    /// <p>The resource to which the component is attached.</p>
    pub fn attached_to(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.attached_to.as_ref()
    }
    /// <p>The Availability Zones.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The CIDR ranges.</p>
    pub fn cidrs(&self) -> std::option::Option<&[std::string::String]> {
        self.cidrs.as_deref()
    }
    /// <p>The component.</p>
    pub fn component(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.component.as_ref()
    }
    /// <p>The customer gateway.</p>
    pub fn customer_gateway(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.customer_gateway.as_ref()
    }
    /// <p>The destination.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.destination.as_ref()
    }
    /// <p>The destination VPC.</p>
    pub fn destination_vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.destination_vpc.as_ref()
    }
    /// <p>The direction. The following are possible values:</p>
    /// <ul>
    /// <li> <p>egress</p> </li>
    /// <li> <p>ingress</p> </li>
    /// </ul>
    pub fn direction(&self) -> std::option::Option<&str> {
        self.direction.as_deref()
    }
    /// <p>The explanation code.</p>
    pub fn explanation_code(&self) -> std::option::Option<&str> {
        self.explanation_code.as_deref()
    }
    /// <p>The route table.</p>
    pub fn ingress_route_table(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.ingress_route_table.as_ref()
    }
    /// <p>The internet gateway.</p>
    pub fn internet_gateway(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.internet_gateway.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub fn load_balancer_arn(&self) -> std::option::Option<&str> {
        self.load_balancer_arn.as_deref()
    }
    /// <p>The listener for a Classic Load Balancer.</p>
    pub fn classic_load_balancer_listener(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisLoadBalancerListener> {
        self.classic_load_balancer_listener.as_ref()
    }
    /// <p>The listener port of the load balancer.</p>
    pub fn load_balancer_listener_port(&self) -> std::option::Option<i32> {
        self.load_balancer_listener_port
    }
    /// <p>The target.</p>
    pub fn load_balancer_target(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisLoadBalancerTarget> {
        self.load_balancer_target.as_ref()
    }
    /// <p>The target group.</p>
    pub fn load_balancer_target_group(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.load_balancer_target_group.as_ref()
    }
    /// <p>The target groups.</p>
    pub fn load_balancer_target_groups(
        &self,
    ) -> std::option::Option<&[crate::model::AnalysisComponent]> {
        self.load_balancer_target_groups.as_deref()
    }
    /// <p>The target port.</p>
    pub fn load_balancer_target_port(&self) -> std::option::Option<i32> {
        self.load_balancer_target_port
    }
    /// <p>The load balancer listener.</p>
    pub fn elastic_load_balancer_listener(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.elastic_load_balancer_listener.as_ref()
    }
    /// <p>The missing component.</p>
    pub fn missing_component(&self) -> std::option::Option<&str> {
        self.missing_component.as_deref()
    }
    /// <p>The NAT gateway.</p>
    pub fn nat_gateway(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.nat_gateway.as_ref()
    }
    /// <p>The network interface.</p>
    pub fn network_interface(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.network_interface.as_ref()
    }
    /// <p>The packet field.</p>
    pub fn packet_field(&self) -> std::option::Option<&str> {
        self.packet_field.as_deref()
    }
    /// <p>The VPC peering connection.</p>
    pub fn vpc_peering_connection(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpc_peering_connection.as_ref()
    }
    /// <p>The port.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The port ranges.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
    /// <p>The prefix list.</p>
    pub fn prefix_list(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.prefix_list.as_ref()
    }
    /// <p>The protocols.</p>
    pub fn protocols(&self) -> std::option::Option<&[std::string::String]> {
        self.protocols.as_deref()
    }
    /// <p>The route table route.</p>
    pub fn route_table_route(&self) -> std::option::Option<&crate::model::AnalysisRouteTableRoute> {
        self.route_table_route.as_ref()
    }
    /// <p>The route table.</p>
    pub fn route_table(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.route_table.as_ref()
    }
    /// <p>The security group.</p>
    pub fn security_group(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.security_group.as_ref()
    }
    /// <p>The security group rule.</p>
    pub fn security_group_rule(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisSecurityGroupRule> {
        self.security_group_rule.as_ref()
    }
    /// <p>The security groups.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::AnalysisComponent]> {
        self.security_groups.as_deref()
    }
    /// <p>The source VPC.</p>
    pub fn source_vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.source_vpc.as_ref()
    }
    /// <p>The state.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The subnet.</p>
    pub fn subnet(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.subnet.as_ref()
    }
    /// <p>The route table for the subnet.</p>
    pub fn subnet_route_table(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.subnet_route_table.as_ref()
    }
    /// <p>The component VPC.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpc.as_ref()
    }
    /// <p>The VPC endpoint.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpc_endpoint.as_ref()
    }
    /// <p>The VPN connection.</p>
    pub fn vpn_connection(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpn_connection.as_ref()
    }
    /// <p>The VPN gateway.</p>
    pub fn vpn_gateway(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpn_gateway.as_ref()
    }
}
impl std::fmt::Debug for Explanation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Explanation");
        formatter.field("acl", &self.acl);
        formatter.field("acl_rule", &self.acl_rule);
        formatter.field("address", &self.address);
        formatter.field("addresses", &self.addresses);
        formatter.field("attached_to", &self.attached_to);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("cidrs", &self.cidrs);
        formatter.field("component", &self.component);
        formatter.field("customer_gateway", &self.customer_gateway);
        formatter.field("destination", &self.destination);
        formatter.field("destination_vpc", &self.destination_vpc);
        formatter.field("direction", &self.direction);
        formatter.field("explanation_code", &self.explanation_code);
        formatter.field("ingress_route_table", &self.ingress_route_table);
        formatter.field("internet_gateway", &self.internet_gateway);
        formatter.field("load_balancer_arn", &self.load_balancer_arn);
        formatter.field(
            "classic_load_balancer_listener",
            &self.classic_load_balancer_listener,
        );
        formatter.field(
            "load_balancer_listener_port",
            &self.load_balancer_listener_port,
        );
        formatter.field("load_balancer_target", &self.load_balancer_target);
        formatter.field(
            "load_balancer_target_group",
            &self.load_balancer_target_group,
        );
        formatter.field(
            "load_balancer_target_groups",
            &self.load_balancer_target_groups,
        );
        formatter.field("load_balancer_target_port", &self.load_balancer_target_port);
        formatter.field(
            "elastic_load_balancer_listener",
            &self.elastic_load_balancer_listener,
        );
        formatter.field("missing_component", &self.missing_component);
        formatter.field("nat_gateway", &self.nat_gateway);
        formatter.field("network_interface", &self.network_interface);
        formatter.field("packet_field", &self.packet_field);
        formatter.field("vpc_peering_connection", &self.vpc_peering_connection);
        formatter.field("port", &self.port);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.field("prefix_list", &self.prefix_list);
        formatter.field("protocols", &self.protocols);
        formatter.field("route_table_route", &self.route_table_route);
        formatter.field("route_table", &self.route_table);
        formatter.field("security_group", &self.security_group);
        formatter.field("security_group_rule", &self.security_group_rule);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("source_vpc", &self.source_vpc);
        formatter.field("state", &self.state);
        formatter.field("subnet", &self.subnet);
        formatter.field("subnet_route_table", &self.subnet_route_table);
        formatter.field("vpc", &self.vpc);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.field("vpn_connection", &self.vpn_connection);
        formatter.field("vpn_gateway", &self.vpn_gateway);
        formatter.finish()
    }
}
/// See [`Explanation`](crate::model::Explanation)
pub mod explanation {
    /// A builder for [`Explanation`](crate::model::Explanation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) acl_rule: std::option::Option<crate::model::AnalysisAclRule>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attached_to: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) component: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) customer_gateway: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) destination: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) destination_vpc: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) direction: std::option::Option<std::string::String>,
        pub(crate) explanation_code: std::option::Option<std::string::String>,
        pub(crate) ingress_route_table: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) internet_gateway: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) load_balancer_arn: std::option::Option<std::string::String>,
        pub(crate) classic_load_balancer_listener:
            std::option::Option<crate::model::AnalysisLoadBalancerListener>,
        pub(crate) load_balancer_listener_port: std::option::Option<i32>,
        pub(crate) load_balancer_target:
            std::option::Option<crate::model::AnalysisLoadBalancerTarget>,
        pub(crate) load_balancer_target_group: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) load_balancer_target_groups:
            std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
        pub(crate) load_balancer_target_port: std::option::Option<i32>,
        pub(crate) elastic_load_balancer_listener:
            std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) missing_component: std::option::Option<std::string::String>,
        pub(crate) nat_gateway: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) network_interface: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) packet_field: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) prefix_list: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) route_table_route: std::option::Option<crate::model::AnalysisRouteTableRoute>,
        pub(crate) route_table: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) security_group: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) security_group_rule:
            std::option::Option<crate::model::AnalysisSecurityGroupRule>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
        pub(crate) source_vpc: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) subnet: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) subnet_route_table: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) vpc: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) vpc_endpoint: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) vpn_connection: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) vpn_gateway: std::option::Option<crate::model::AnalysisComponent>,
    }
    impl Builder {
        /// <p>The network ACL.</p>
        pub fn acl(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The network ACL.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The network ACL rule.</p>
        pub fn acl_rule(mut self, input: crate::model::AnalysisAclRule) -> Self {
            self.acl_rule = Some(input);
            self
        }
        /// <p>The network ACL rule.</p>
        pub fn set_acl_rule(
            mut self,
            input: std::option::Option<crate::model::AnalysisAclRule>,
        ) -> Self {
            self.acl_rule = input;
            self
        }
        /// <p>The IPv4 address, in CIDR notation.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The IPv4 address, in CIDR notation.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Appends an item to `addresses`.
        ///
        /// To override the contents of this collection use [`set_addresses`](Self::set_addresses).
        ///
        /// <p>The IPv4 addresses, in CIDR notation.</p>
        pub fn addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.addresses.unwrap_or_default();
            v.push(input.into());
            self.addresses = Some(v);
            self
        }
        /// <p>The IPv4 addresses, in CIDR notation.</p>
        pub fn set_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.addresses = input;
            self
        }
        /// <p>The resource to which the component is attached.</p>
        pub fn attached_to(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.attached_to = Some(input);
            self
        }
        /// <p>The resource to which the component is attached.</p>
        pub fn set_attached_to(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.attached_to = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>The CIDR ranges.</p>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>The CIDR ranges.</p>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// <p>The component.</p>
        pub fn component(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.component = Some(input);
            self
        }
        /// <p>The component.</p>
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.component = input;
            self
        }
        /// <p>The customer gateway.</p>
        pub fn customer_gateway(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.customer_gateway = Some(input);
            self
        }
        /// <p>The customer gateway.</p>
        pub fn set_customer_gateway(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.customer_gateway = input;
            self
        }
        /// <p>The destination.</p>
        pub fn destination(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The destination VPC.</p>
        pub fn destination_vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.destination_vpc = Some(input);
            self
        }
        /// <p>The destination VPC.</p>
        pub fn set_destination_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.destination_vpc = input;
            self
        }
        /// <p>The direction. The following are possible values:</p>
        /// <ul>
        /// <li> <p>egress</p> </li>
        /// <li> <p>ingress</p> </li>
        /// </ul>
        pub fn direction(mut self, input: impl Into<std::string::String>) -> Self {
            self.direction = Some(input.into());
            self
        }
        /// <p>The direction. The following are possible values:</p>
        /// <ul>
        /// <li> <p>egress</p> </li>
        /// <li> <p>ingress</p> </li>
        /// </ul>
        pub fn set_direction(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.direction = input;
            self
        }
        /// <p>The explanation code.</p>
        pub fn explanation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.explanation_code = Some(input.into());
            self
        }
        /// <p>The explanation code.</p>
        pub fn set_explanation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.explanation_code = input;
            self
        }
        /// <p>The route table.</p>
        pub fn ingress_route_table(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.ingress_route_table = Some(input);
            self
        }
        /// <p>The route table.</p>
        pub fn set_ingress_route_table(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.ingress_route_table = input;
            self
        }
        /// <p>The internet gateway.</p>
        pub fn internet_gateway(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.internet_gateway = Some(input);
            self
        }
        /// <p>The internet gateway.</p>
        pub fn set_internet_gateway(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.internet_gateway = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn load_balancer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_load_balancer_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_arn = input;
            self
        }
        /// <p>The listener for a Classic Load Balancer.</p>
        pub fn classic_load_balancer_listener(
            mut self,
            input: crate::model::AnalysisLoadBalancerListener,
        ) -> Self {
            self.classic_load_balancer_listener = Some(input);
            self
        }
        /// <p>The listener for a Classic Load Balancer.</p>
        pub fn set_classic_load_balancer_listener(
            mut self,
            input: std::option::Option<crate::model::AnalysisLoadBalancerListener>,
        ) -> Self {
            self.classic_load_balancer_listener = input;
            self
        }
        /// <p>The listener port of the load balancer.</p>
        pub fn load_balancer_listener_port(mut self, input: i32) -> Self {
            self.load_balancer_listener_port = Some(input);
            self
        }
        /// <p>The listener port of the load balancer.</p>
        pub fn set_load_balancer_listener_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_listener_port = input;
            self
        }
        /// <p>The target.</p>
        pub fn load_balancer_target(
            mut self,
            input: crate::model::AnalysisLoadBalancerTarget,
        ) -> Self {
            self.load_balancer_target = Some(input);
            self
        }
        /// <p>The target.</p>
        pub fn set_load_balancer_target(
            mut self,
            input: std::option::Option<crate::model::AnalysisLoadBalancerTarget>,
        ) -> Self {
            self.load_balancer_target = input;
            self
        }
        /// <p>The target group.</p>
        pub fn load_balancer_target_group(
            mut self,
            input: crate::model::AnalysisComponent,
        ) -> Self {
            self.load_balancer_target_group = Some(input);
            self
        }
        /// <p>The target group.</p>
        pub fn set_load_balancer_target_group(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.load_balancer_target_group = input;
            self
        }
        /// Appends an item to `load_balancer_target_groups`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_target_groups`](Self::set_load_balancer_target_groups).
        ///
        /// <p>The target groups.</p>
        pub fn load_balancer_target_groups(
            mut self,
            input: crate::model::AnalysisComponent,
        ) -> Self {
            let mut v = self.load_balancer_target_groups.unwrap_or_default();
            v.push(input);
            self.load_balancer_target_groups = Some(v);
            self
        }
        /// <p>The target groups.</p>
        pub fn set_load_balancer_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
        ) -> Self {
            self.load_balancer_target_groups = input;
            self
        }
        /// <p>The target port.</p>
        pub fn load_balancer_target_port(mut self, input: i32) -> Self {
            self.load_balancer_target_port = Some(input);
            self
        }
        /// <p>The target port.</p>
        pub fn set_load_balancer_target_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_target_port = input;
            self
        }
        /// <p>The load balancer listener.</p>
        pub fn elastic_load_balancer_listener(
            mut self,
            input: crate::model::AnalysisComponent,
        ) -> Self {
            self.elastic_load_balancer_listener = Some(input);
            self
        }
        /// <p>The load balancer listener.</p>
        pub fn set_elastic_load_balancer_listener(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.elastic_load_balancer_listener = input;
            self
        }
        /// <p>The missing component.</p>
        pub fn missing_component(mut self, input: impl Into<std::string::String>) -> Self {
            self.missing_component = Some(input.into());
            self
        }
        /// <p>The missing component.</p>
        pub fn set_missing_component(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.missing_component = input;
            self
        }
        /// <p>The NAT gateway.</p>
        pub fn nat_gateway(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.nat_gateway = Some(input);
            self
        }
        /// <p>The NAT gateway.</p>
        pub fn set_nat_gateway(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.nat_gateway = input;
            self
        }
        /// <p>The network interface.</p>
        pub fn network_interface(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.network_interface = Some(input);
            self
        }
        /// <p>The network interface.</p>
        pub fn set_network_interface(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.network_interface = input;
            self
        }
        /// <p>The packet field.</p>
        pub fn packet_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.packet_field = Some(input.into());
            self
        }
        /// <p>The packet field.</p>
        pub fn set_packet_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.packet_field = input;
            self
        }
        /// <p>The VPC peering connection.</p>
        pub fn vpc_peering_connection(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpc_peering_connection = Some(input);
            self
        }
        /// <p>The VPC peering connection.</p>
        pub fn set_vpc_peering_connection(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpc_peering_connection = input;
            self
        }
        /// <p>The port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The port ranges.</p>
        pub fn port_ranges(mut self, input: crate::model::PortRange) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input);
            self.port_ranges = Some(v);
            self
        }
        /// <p>The port ranges.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// <p>The prefix list.</p>
        pub fn prefix_list(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.prefix_list = Some(input);
            self
        }
        /// <p>The prefix list.</p>
        pub fn set_prefix_list(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.prefix_list = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocols.</p>
        pub fn protocols(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocols.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>The route table route.</p>
        pub fn route_table_route(mut self, input: crate::model::AnalysisRouteTableRoute) -> Self {
            self.route_table_route = Some(input);
            self
        }
        /// <p>The route table route.</p>
        pub fn set_route_table_route(
            mut self,
            input: std::option::Option<crate::model::AnalysisRouteTableRoute>,
        ) -> Self {
            self.route_table_route = input;
            self
        }
        /// <p>The route table.</p>
        pub fn route_table(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.route_table = Some(input);
            self
        }
        /// <p>The route table.</p>
        pub fn set_route_table(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.route_table = input;
            self
        }
        /// <p>The security group.</p>
        pub fn security_group(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.security_group = Some(input);
            self
        }
        /// <p>The security group.</p>
        pub fn set_security_group(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.security_group = input;
            self
        }
        /// <p>The security group rule.</p>
        pub fn security_group_rule(
            mut self,
            input: crate::model::AnalysisSecurityGroupRule,
        ) -> Self {
            self.security_group_rule = Some(input);
            self
        }
        /// <p>The security group rule.</p>
        pub fn set_security_group_rule(
            mut self,
            input: std::option::Option<crate::model::AnalysisSecurityGroupRule>,
        ) -> Self {
            self.security_group_rule = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups.</p>
        pub fn security_groups(mut self, input: crate::model::AnalysisComponent) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input);
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalysisComponent>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The source VPC.</p>
        pub fn source_vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.source_vpc = Some(input);
            self
        }
        /// <p>The source VPC.</p>
        pub fn set_source_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.source_vpc = input;
            self
        }
        /// <p>The state.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The subnet.</p>
        pub fn subnet(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.subnet = Some(input);
            self
        }
        /// <p>The subnet.</p>
        pub fn set_subnet(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.subnet = input;
            self
        }
        /// <p>The route table for the subnet.</p>
        pub fn subnet_route_table(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.subnet_route_table = Some(input);
            self
        }
        /// <p>The route table for the subnet.</p>
        pub fn set_subnet_route_table(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.subnet_route_table = input;
            self
        }
        /// <p>The component VPC.</p>
        pub fn vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>The component VPC.</p>
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The VPC endpoint.</p>
        pub fn vpc_endpoint(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpc_endpoint = Some(input);
            self
        }
        /// <p>The VPC endpoint.</p>
        pub fn set_vpc_endpoint(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// <p>The VPN connection.</p>
        pub fn vpn_connection(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpn_connection = Some(input);
            self
        }
        /// <p>The VPN connection.</p>
        pub fn set_vpn_connection(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpn_connection = input;
            self
        }
        /// <p>The VPN gateway.</p>
        pub fn vpn_gateway(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpn_gateway = Some(input);
            self
        }
        /// <p>The VPN gateway.</p>
        pub fn set_vpn_gateway(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpn_gateway = input;
            self
        }
        /// Consumes the builder and constructs a [`Explanation`](crate::model::Explanation)
        pub fn build(self) -> crate::model::Explanation {
            crate::model::Explanation {
                acl: self.acl,
                acl_rule: self.acl_rule,
                address: self.address,
                addresses: self.addresses,
                attached_to: self.attached_to,
                availability_zones: self.availability_zones,
                cidrs: self.cidrs,
                component: self.component,
                customer_gateway: self.customer_gateway,
                destination: self.destination,
                destination_vpc: self.destination_vpc,
                direction: self.direction,
                explanation_code: self.explanation_code,
                ingress_route_table: self.ingress_route_table,
                internet_gateway: self.internet_gateway,
                load_balancer_arn: self.load_balancer_arn,
                classic_load_balancer_listener: self.classic_load_balancer_listener,
                load_balancer_listener_port: self.load_balancer_listener_port,
                load_balancer_target: self.load_balancer_target,
                load_balancer_target_group: self.load_balancer_target_group,
                load_balancer_target_groups: self.load_balancer_target_groups,
                load_balancer_target_port: self.load_balancer_target_port,
                elastic_load_balancer_listener: self.elastic_load_balancer_listener,
                missing_component: self.missing_component,
                nat_gateway: self.nat_gateway,
                network_interface: self.network_interface,
                packet_field: self.packet_field,
                vpc_peering_connection: self.vpc_peering_connection,
                port: self.port,
                port_ranges: self.port_ranges,
                prefix_list: self.prefix_list,
                protocols: self.protocols,
                route_table_route: self.route_table_route,
                route_table: self.route_table,
                security_group: self.security_group,
                security_group_rule: self.security_group_rule,
                security_groups: self.security_groups,
                source_vpc: self.source_vpc,
                state: self.state,
                subnet: self.subnet,
                subnet_route_table: self.subnet_route_table,
                vpc: self.vpc,
                vpc_endpoint: self.vpc_endpoint,
                vpn_connection: self.vpn_connection,
                vpn_gateway: self.vpn_gateway,
            }
        }
    }
}
impl Explanation {
    /// Creates a new builder-style object to manufacture [`Explanation`](crate::model::Explanation)
    pub fn builder() -> crate::model::explanation::Builder {
        crate::model::explanation::Builder::default()
    }
}

/// <p>Describes a path component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisComponent {
    /// <p>The ID of the component.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the analysis component.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AnalysisComponent {
    /// <p>The ID of the component.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the analysis component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AnalysisComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisComponent");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AnalysisComponent`](crate::model::AnalysisComponent)
pub mod analysis_component {
    /// A builder for [`AnalysisComponent`](crate::model::AnalysisComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the component.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the component.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the analysis component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the analysis component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisComponent`](crate::model::AnalysisComponent)
        pub fn build(self) -> crate::model::AnalysisComponent {
            crate::model::AnalysisComponent {
                id: self.id,
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl AnalysisComponent {
    /// Creates a new builder-style object to manufacture [`AnalysisComponent`](crate::model::AnalysisComponent)
    pub fn builder() -> crate::model::analysis_component::Builder {
        crate::model::analysis_component::Builder::default()
    }
}

/// <p>Describes a security group rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisSecurityGroupRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>The direction. The following are possible values:</p>
    /// <ul>
    /// <li> <p>egress</p> </li>
    /// <li> <p>ingress</p> </li>
    /// </ul>
    pub direction: std::option::Option<std::string::String>,
    /// <p>The security group ID.</p>
    pub security_group_id: std::option::Option<std::string::String>,
    /// <p>The port range.</p>
    pub port_range: std::option::Option<crate::model::PortRange>,
    /// <p>The prefix list ID.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The protocol name.</p>
    pub protocol: std::option::Option<std::string::String>,
}
impl AnalysisSecurityGroupRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>The direction. The following are possible values:</p>
    /// <ul>
    /// <li> <p>egress</p> </li>
    /// <li> <p>ingress</p> </li>
    /// </ul>
    pub fn direction(&self) -> std::option::Option<&str> {
        self.direction.as_deref()
    }
    /// <p>The security group ID.</p>
    pub fn security_group_id(&self) -> std::option::Option<&str> {
        self.security_group_id.as_deref()
    }
    /// <p>The port range.</p>
    pub fn port_range(&self) -> std::option::Option<&crate::model::PortRange> {
        self.port_range.as_ref()
    }
    /// <p>The prefix list ID.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>The protocol name.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
}
impl std::fmt::Debug for AnalysisSecurityGroupRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisSecurityGroupRule");
        formatter.field("cidr", &self.cidr);
        formatter.field("direction", &self.direction);
        formatter.field("security_group_id", &self.security_group_id);
        formatter.field("port_range", &self.port_range);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`AnalysisSecurityGroupRule`](crate::model::AnalysisSecurityGroupRule)
pub mod analysis_security_group_rule {
    /// A builder for [`AnalysisSecurityGroupRule`](crate::model::AnalysisSecurityGroupRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) direction: std::option::Option<std::string::String>,
        pub(crate) security_group_id: std::option::Option<std::string::String>,
        pub(crate) port_range: std::option::Option<crate::model::PortRange>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv4 address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The direction. The following are possible values:</p>
        /// <ul>
        /// <li> <p>egress</p> </li>
        /// <li> <p>ingress</p> </li>
        /// </ul>
        pub fn direction(mut self, input: impl Into<std::string::String>) -> Self {
            self.direction = Some(input.into());
            self
        }
        /// <p>The direction. The following are possible values:</p>
        /// <ul>
        /// <li> <p>egress</p> </li>
        /// <li> <p>ingress</p> </li>
        /// </ul>
        pub fn set_direction(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.direction = input;
            self
        }
        /// <p>The security group ID.</p>
        pub fn security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_group_id = Some(input.into());
            self
        }
        /// <p>The security group ID.</p>
        pub fn set_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_group_id = input;
            self
        }
        /// <p>The port range.</p>
        pub fn port_range(mut self, input: crate::model::PortRange) -> Self {
            self.port_range = Some(input);
            self
        }
        /// <p>The port range.</p>
        pub fn set_port_range(
            mut self,
            input: std::option::Option<crate::model::PortRange>,
        ) -> Self {
            self.port_range = input;
            self
        }
        /// <p>The prefix list ID.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The prefix list ID.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// <p>The protocol name.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol name.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisSecurityGroupRule`](crate::model::AnalysisSecurityGroupRule)
        pub fn build(self) -> crate::model::AnalysisSecurityGroupRule {
            crate::model::AnalysisSecurityGroupRule {
                cidr: self.cidr,
                direction: self.direction,
                security_group_id: self.security_group_id,
                port_range: self.port_range,
                prefix_list_id: self.prefix_list_id,
                protocol: self.protocol,
            }
        }
    }
}
impl AnalysisSecurityGroupRule {
    /// Creates a new builder-style object to manufacture [`AnalysisSecurityGroupRule`](crate::model::AnalysisSecurityGroupRule)
    pub fn builder() -> crate::model::analysis_security_group_rule::Builder {
        crate::model::analysis_security_group_rule::Builder::default()
    }
}

/// <p>Describes a range of ports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRange {
    /// <p>The first port in the range.</p>
    pub from: std::option::Option<i32>,
    /// <p>The last port in the range.</p>
    pub to: std::option::Option<i32>,
}
impl PortRange {
    /// <p>The first port in the range.</p>
    pub fn from(&self) -> std::option::Option<i32> {
        self.from
    }
    /// <p>The last port in the range.</p>
    pub fn to(&self) -> std::option::Option<i32> {
        self.to
    }
}
impl std::fmt::Debug for PortRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRange");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`PortRange`](crate::model::PortRange)
pub mod port_range {
    /// A builder for [`PortRange`](crate::model::PortRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<i32>,
        pub(crate) to: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The first port in the range.</p>
        pub fn from(mut self, input: i32) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The first port in the range.</p>
        pub fn set_from(mut self, input: std::option::Option<i32>) -> Self {
            self.from = input;
            self
        }
        /// <p>The last port in the range.</p>
        pub fn to(mut self, input: i32) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The last port in the range.</p>
        pub fn set_to(mut self, input: std::option::Option<i32>) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRange`](crate::model::PortRange)
        pub fn build(self) -> crate::model::PortRange {
            crate::model::PortRange {
                from: self.from,
                to: self.to,
            }
        }
    }
}
impl PortRange {
    /// Creates a new builder-style object to manufacture [`PortRange`](crate::model::PortRange)
    pub fn builder() -> crate::model::port_range::Builder {
        crate::model::port_range::Builder::default()
    }
}

/// <p>Describes a route table route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisRouteTableRoute {
    /// <p>The destination IPv4 address, in CIDR notation.</p>
    pub destination_cidr: std::option::Option<std::string::String>,
    /// <p>The prefix of the Amazon Web Service.</p>
    pub destination_prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The ID of an egress-only internet gateway.</p>
    pub egress_only_internet_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the gateway, such as an internet gateway or virtual private gateway.</p>
    pub gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of the instance, such as a NAT instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The ID of a NAT gateway.</p>
    pub nat_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of a network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>Describes how the route was created. The following are possible values:</p>
    /// <ul>
    /// <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li>
    /// <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li>
    /// <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li>
    /// </ul>
    pub origin: std::option::Option<std::string::String>,
    /// <p>The ID of a transit gateway.</p>
    pub transit_gateway_id: std::option::Option<std::string::String>,
    /// <p>The ID of a VPC peering connection.</p>
    pub vpc_peering_connection_id: std::option::Option<std::string::String>,
}
impl AnalysisRouteTableRoute {
    /// <p>The destination IPv4 address, in CIDR notation.</p>
    pub fn destination_cidr(&self) -> std::option::Option<&str> {
        self.destination_cidr.as_deref()
    }
    /// <p>The prefix of the Amazon Web Service.</p>
    pub fn destination_prefix_list_id(&self) -> std::option::Option<&str> {
        self.destination_prefix_list_id.as_deref()
    }
    /// <p>The ID of an egress-only internet gateway.</p>
    pub fn egress_only_internet_gateway_id(&self) -> std::option::Option<&str> {
        self.egress_only_internet_gateway_id.as_deref()
    }
    /// <p>The ID of the gateway, such as an internet gateway or virtual private gateway.</p>
    pub fn gateway_id(&self) -> std::option::Option<&str> {
        self.gateway_id.as_deref()
    }
    /// <p>The ID of the instance, such as a NAT instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The ID of a NAT gateway.</p>
    pub fn nat_gateway_id(&self) -> std::option::Option<&str> {
        self.nat_gateway_id.as_deref()
    }
    /// <p>The ID of a network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>Describes how the route was created. The following are possible values:</p>
    /// <ul>
    /// <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li>
    /// <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li>
    /// <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li>
    /// </ul>
    pub fn origin(&self) -> std::option::Option<&str> {
        self.origin.as_deref()
    }
    /// <p>The ID of a transit gateway.</p>
    pub fn transit_gateway_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_id.as_deref()
    }
    /// <p>The ID of a VPC peering connection.</p>
    pub fn vpc_peering_connection_id(&self) -> std::option::Option<&str> {
        self.vpc_peering_connection_id.as_deref()
    }
}
impl std::fmt::Debug for AnalysisRouteTableRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisRouteTableRoute");
        formatter.field("destination_cidr", &self.destination_cidr);
        formatter.field(
            "destination_prefix_list_id",
            &self.destination_prefix_list_id,
        );
        formatter.field(
            "egress_only_internet_gateway_id",
            &self.egress_only_internet_gateway_id,
        );
        formatter.field("gateway_id", &self.gateway_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("nat_gateway_id", &self.nat_gateway_id);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("origin", &self.origin);
        formatter.field("transit_gateway_id", &self.transit_gateway_id);
        formatter.field("vpc_peering_connection_id", &self.vpc_peering_connection_id);
        formatter.finish()
    }
}
/// See [`AnalysisRouteTableRoute`](crate::model::AnalysisRouteTableRoute)
pub mod analysis_route_table_route {
    /// A builder for [`AnalysisRouteTableRoute`](crate::model::AnalysisRouteTableRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr: std::option::Option<std::string::String>,
        pub(crate) destination_prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) egress_only_internet_gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) nat_gateway_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_id: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination IPv4 address, in CIDR notation.</p>
        pub fn destination_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr = Some(input.into());
            self
        }
        /// <p>The destination IPv4 address, in CIDR notation.</p>
        pub fn set_destination_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr = input;
            self
        }
        /// <p>The prefix of the Amazon Web Service.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix_list_id = Some(input.into());
            self
        }
        /// <p>The prefix of the Amazon Web Service.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix_list_id = input;
            self
        }
        /// <p>The ID of an egress-only internet gateway.</p>
        pub fn egress_only_internet_gateway_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.egress_only_internet_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of an egress-only internet gateway.</p>
        pub fn set_egress_only_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.egress_only_internet_gateway_id = input;
            self
        }
        /// <p>The ID of the gateway, such as an internet gateway or virtual private gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the gateway, such as an internet gateway or virtual private gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The ID of the instance, such as a NAT instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance, such as a NAT instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID of a NAT gateway.</p>
        pub fn nat_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.nat_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of a NAT gateway.</p>
        pub fn set_nat_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nat_gateway_id = input;
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>Describes how the route was created. The following are possible values:</p>
        /// <ul>
        /// <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li>
        /// <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li>
        /// <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li>
        /// </ul>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin = Some(input.into());
            self
        }
        /// <p>Describes how the route was created. The following are possible values:</p>
        /// <ul>
        /// <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li>
        /// <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li>
        /// <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li>
        /// </ul>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin = input;
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_id = input;
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisRouteTableRoute`](crate::model::AnalysisRouteTableRoute)
        pub fn build(self) -> crate::model::AnalysisRouteTableRoute {
            crate::model::AnalysisRouteTableRoute {
                destination_cidr: self.destination_cidr,
                destination_prefix_list_id: self.destination_prefix_list_id,
                egress_only_internet_gateway_id: self.egress_only_internet_gateway_id,
                gateway_id: self.gateway_id,
                instance_id: self.instance_id,
                nat_gateway_id: self.nat_gateway_id,
                network_interface_id: self.network_interface_id,
                origin: self.origin,
                transit_gateway_id: self.transit_gateway_id,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
            }
        }
    }
}
impl AnalysisRouteTableRoute {
    /// Creates a new builder-style object to manufacture [`AnalysisRouteTableRoute`](crate::model::AnalysisRouteTableRoute)
    pub fn builder() -> crate::model::analysis_route_table_route::Builder {
        crate::model::analysis_route_table_route::Builder::default()
    }
}

/// <p>Describes a load balancer target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisLoadBalancerTarget {
    /// <p>The IP address.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Information about the instance.</p>
    pub instance: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The port on which the target is listening.</p>
    pub port: std::option::Option<i32>,
}
impl AnalysisLoadBalancerTarget {
    /// <p>The IP address.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The Availability Zone.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>Information about the instance.</p>
    pub fn instance(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.instance.as_ref()
    }
    /// <p>The port on which the target is listening.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
}
impl std::fmt::Debug for AnalysisLoadBalancerTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisLoadBalancerTarget");
        formatter.field("address", &self.address);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("instance", &self.instance);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`AnalysisLoadBalancerTarget`](crate::model::AnalysisLoadBalancerTarget)
pub mod analysis_load_balancer_target {
    /// A builder for [`AnalysisLoadBalancerTarget`](crate::model::AnalysisLoadBalancerTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) instance: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The IP address.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The IP address.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Information about the instance.</p>
        pub fn instance(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.instance = Some(input);
            self
        }
        /// <p>Information about the instance.</p>
        pub fn set_instance(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.instance = input;
            self
        }
        /// <p>The port on which the target is listening.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port on which the target is listening.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisLoadBalancerTarget`](crate::model::AnalysisLoadBalancerTarget)
        pub fn build(self) -> crate::model::AnalysisLoadBalancerTarget {
            crate::model::AnalysisLoadBalancerTarget {
                address: self.address,
                availability_zone: self.availability_zone,
                instance: self.instance,
                port: self.port,
            }
        }
    }
}
impl AnalysisLoadBalancerTarget {
    /// Creates a new builder-style object to manufacture [`AnalysisLoadBalancerTarget`](crate::model::AnalysisLoadBalancerTarget)
    pub fn builder() -> crate::model::analysis_load_balancer_target::Builder {
        crate::model::analysis_load_balancer_target::Builder::default()
    }
}

/// <p>Describes a load balancer listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisLoadBalancerListener {
    /// <p>The port on which the load balancer is listening.</p>
    pub load_balancer_port: std::option::Option<i32>,
    /// <p>[Classic Load Balancers] The back-end port for the listener.</p>
    pub instance_port: std::option::Option<i32>,
}
impl AnalysisLoadBalancerListener {
    /// <p>The port on which the load balancer is listening.</p>
    pub fn load_balancer_port(&self) -> std::option::Option<i32> {
        self.load_balancer_port
    }
    /// <p>[Classic Load Balancers] The back-end port for the listener.</p>
    pub fn instance_port(&self) -> std::option::Option<i32> {
        self.instance_port
    }
}
impl std::fmt::Debug for AnalysisLoadBalancerListener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisLoadBalancerListener");
        formatter.field("load_balancer_port", &self.load_balancer_port);
        formatter.field("instance_port", &self.instance_port);
        formatter.finish()
    }
}
/// See [`AnalysisLoadBalancerListener`](crate::model::AnalysisLoadBalancerListener)
pub mod analysis_load_balancer_listener {
    /// A builder for [`AnalysisLoadBalancerListener`](crate::model::AnalysisLoadBalancerListener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_port: std::option::Option<i32>,
        pub(crate) instance_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The port on which the load balancer is listening.</p>
        pub fn load_balancer_port(mut self, input: i32) -> Self {
            self.load_balancer_port = Some(input);
            self
        }
        /// <p>The port on which the load balancer is listening.</p>
        pub fn set_load_balancer_port(mut self, input: std::option::Option<i32>) -> Self {
            self.load_balancer_port = input;
            self
        }
        /// <p>[Classic Load Balancers] The back-end port for the listener.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>[Classic Load Balancers] The back-end port for the listener.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisLoadBalancerListener`](crate::model::AnalysisLoadBalancerListener)
        pub fn build(self) -> crate::model::AnalysisLoadBalancerListener {
            crate::model::AnalysisLoadBalancerListener {
                load_balancer_port: self.load_balancer_port,
                instance_port: self.instance_port,
            }
        }
    }
}
impl AnalysisLoadBalancerListener {
    /// Creates a new builder-style object to manufacture [`AnalysisLoadBalancerListener`](crate::model::AnalysisLoadBalancerListener)
    pub fn builder() -> crate::model::analysis_load_balancer_listener::Builder {
        crate::model::analysis_load_balancer_listener::Builder::default()
    }
}

/// <p>Describes a network access control (ACL) rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisAclRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>Indicates whether the rule is an outbound rule.</p>
    pub egress: std::option::Option<bool>,
    /// <p>The range of ports.</p>
    pub port_range: std::option::Option<crate::model::PortRange>,
    /// <p>The protocol.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>Indicates whether to allow or deny traffic that matches the rule.</p>
    pub rule_action: std::option::Option<std::string::String>,
    /// <p>The rule number.</p>
    pub rule_number: std::option::Option<i32>,
}
impl AnalysisAclRule {
    /// <p>The IPv4 address range, in CIDR notation.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>Indicates whether the rule is an outbound rule.</p>
    pub fn egress(&self) -> std::option::Option<bool> {
        self.egress
    }
    /// <p>The range of ports.</p>
    pub fn port_range(&self) -> std::option::Option<&crate::model::PortRange> {
        self.port_range.as_ref()
    }
    /// <p>The protocol.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>Indicates whether to allow or deny traffic that matches the rule.</p>
    pub fn rule_action(&self) -> std::option::Option<&str> {
        self.rule_action.as_deref()
    }
    /// <p>The rule number.</p>
    pub fn rule_number(&self) -> std::option::Option<i32> {
        self.rule_number
    }
}
impl std::fmt::Debug for AnalysisAclRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisAclRule");
        formatter.field("cidr", &self.cidr);
        formatter.field("egress", &self.egress);
        formatter.field("port_range", &self.port_range);
        formatter.field("protocol", &self.protocol);
        formatter.field("rule_action", &self.rule_action);
        formatter.field("rule_number", &self.rule_number);
        formatter.finish()
    }
}
/// See [`AnalysisAclRule`](crate::model::AnalysisAclRule)
pub mod analysis_acl_rule {
    /// A builder for [`AnalysisAclRule`](crate::model::AnalysisAclRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) egress: std::option::Option<bool>,
        pub(crate) port_range: std::option::Option<crate::model::PortRange>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) rule_action: std::option::Option<std::string::String>,
        pub(crate) rule_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The IPv4 address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>Indicates whether the rule is an outbound rule.</p>
        pub fn egress(mut self, input: bool) -> Self {
            self.egress = Some(input);
            self
        }
        /// <p>Indicates whether the rule is an outbound rule.</p>
        pub fn set_egress(mut self, input: std::option::Option<bool>) -> Self {
            self.egress = input;
            self
        }
        /// <p>The range of ports.</p>
        pub fn port_range(mut self, input: crate::model::PortRange) -> Self {
            self.port_range = Some(input);
            self
        }
        /// <p>The range of ports.</p>
        pub fn set_port_range(
            mut self,
            input: std::option::Option<crate::model::PortRange>,
        ) -> Self {
            self.port_range = input;
            self
        }
        /// <p>The protocol.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Indicates whether to allow or deny traffic that matches the rule.</p>
        pub fn rule_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_action = Some(input.into());
            self
        }
        /// <p>Indicates whether to allow or deny traffic that matches the rule.</p>
        pub fn set_rule_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_action = input;
            self
        }
        /// <p>The rule number.</p>
        pub fn rule_number(mut self, input: i32) -> Self {
            self.rule_number = Some(input);
            self
        }
        /// <p>The rule number.</p>
        pub fn set_rule_number(mut self, input: std::option::Option<i32>) -> Self {
            self.rule_number = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisAclRule`](crate::model::AnalysisAclRule)
        pub fn build(self) -> crate::model::AnalysisAclRule {
            crate::model::AnalysisAclRule {
                cidr: self.cidr,
                egress: self.egress,
                port_range: self.port_range,
                protocol: self.protocol,
                rule_action: self.rule_action,
                rule_number: self.rule_number,
            }
        }
    }
}
impl AnalysisAclRule {
    /// Creates a new builder-style object to manufacture [`AnalysisAclRule`](crate::model::AnalysisAclRule)
    pub fn builder() -> crate::model::analysis_acl_rule::Builder {
        crate::model::analysis_acl_rule::Builder::default()
    }
}

/// <p>Describes a path component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PathComponent {
    /// <p>The sequence number.</p>
    pub sequence_number: std::option::Option<i32>,
    /// <p>The network ACL rule.</p>
    pub acl_rule: std::option::Option<crate::model::AnalysisAclRule>,
    /// <p>The resource to which the path component is attached.</p>
    pub attached_to: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The component.</p>
    pub component: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The destination VPC.</p>
    pub destination_vpc: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The outbound header.</p>
    pub outbound_header: std::option::Option<crate::model::AnalysisPacketHeader>,
    /// <p>The inbound header.</p>
    pub inbound_header: std::option::Option<crate::model::AnalysisPacketHeader>,
    /// <p>The route table route.</p>
    pub route_table_route: std::option::Option<crate::model::AnalysisRouteTableRoute>,
    /// <p>The security group rule.</p>
    pub security_group_rule: std::option::Option<crate::model::AnalysisSecurityGroupRule>,
    /// <p>The source VPC.</p>
    pub source_vpc: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The subnet.</p>
    pub subnet: std::option::Option<crate::model::AnalysisComponent>,
    /// <p>The component VPC.</p>
    pub vpc: std::option::Option<crate::model::AnalysisComponent>,
}
impl PathComponent {
    /// <p>The sequence number.</p>
    pub fn sequence_number(&self) -> std::option::Option<i32> {
        self.sequence_number
    }
    /// <p>The network ACL rule.</p>
    pub fn acl_rule(&self) -> std::option::Option<&crate::model::AnalysisAclRule> {
        self.acl_rule.as_ref()
    }
    /// <p>The resource to which the path component is attached.</p>
    pub fn attached_to(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.attached_to.as_ref()
    }
    /// <p>The component.</p>
    pub fn component(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.component.as_ref()
    }
    /// <p>The destination VPC.</p>
    pub fn destination_vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.destination_vpc.as_ref()
    }
    /// <p>The outbound header.</p>
    pub fn outbound_header(&self) -> std::option::Option<&crate::model::AnalysisPacketHeader> {
        self.outbound_header.as_ref()
    }
    /// <p>The inbound header.</p>
    pub fn inbound_header(&self) -> std::option::Option<&crate::model::AnalysisPacketHeader> {
        self.inbound_header.as_ref()
    }
    /// <p>The route table route.</p>
    pub fn route_table_route(&self) -> std::option::Option<&crate::model::AnalysisRouteTableRoute> {
        self.route_table_route.as_ref()
    }
    /// <p>The security group rule.</p>
    pub fn security_group_rule(
        &self,
    ) -> std::option::Option<&crate::model::AnalysisSecurityGroupRule> {
        self.security_group_rule.as_ref()
    }
    /// <p>The source VPC.</p>
    pub fn source_vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.source_vpc.as_ref()
    }
    /// <p>The subnet.</p>
    pub fn subnet(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.subnet.as_ref()
    }
    /// <p>The component VPC.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::AnalysisComponent> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for PathComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PathComponent");
        formatter.field("sequence_number", &self.sequence_number);
        formatter.field("acl_rule", &self.acl_rule);
        formatter.field("attached_to", &self.attached_to);
        formatter.field("component", &self.component);
        formatter.field("destination_vpc", &self.destination_vpc);
        formatter.field("outbound_header", &self.outbound_header);
        formatter.field("inbound_header", &self.inbound_header);
        formatter.field("route_table_route", &self.route_table_route);
        formatter.field("security_group_rule", &self.security_group_rule);
        formatter.field("source_vpc", &self.source_vpc);
        formatter.field("subnet", &self.subnet);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`PathComponent`](crate::model::PathComponent)
pub mod path_component {
    /// A builder for [`PathComponent`](crate::model::PathComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sequence_number: std::option::Option<i32>,
        pub(crate) acl_rule: std::option::Option<crate::model::AnalysisAclRule>,
        pub(crate) attached_to: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) component: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) destination_vpc: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) outbound_header: std::option::Option<crate::model::AnalysisPacketHeader>,
        pub(crate) inbound_header: std::option::Option<crate::model::AnalysisPacketHeader>,
        pub(crate) route_table_route: std::option::Option<crate::model::AnalysisRouteTableRoute>,
        pub(crate) security_group_rule:
            std::option::Option<crate::model::AnalysisSecurityGroupRule>,
        pub(crate) source_vpc: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) subnet: std::option::Option<crate::model::AnalysisComponent>,
        pub(crate) vpc: std::option::Option<crate::model::AnalysisComponent>,
    }
    impl Builder {
        /// <p>The sequence number.</p>
        pub fn sequence_number(mut self, input: i32) -> Self {
            self.sequence_number = Some(input);
            self
        }
        /// <p>The sequence number.</p>
        pub fn set_sequence_number(mut self, input: std::option::Option<i32>) -> Self {
            self.sequence_number = input;
            self
        }
        /// <p>The network ACL rule.</p>
        pub fn acl_rule(mut self, input: crate::model::AnalysisAclRule) -> Self {
            self.acl_rule = Some(input);
            self
        }
        /// <p>The network ACL rule.</p>
        pub fn set_acl_rule(
            mut self,
            input: std::option::Option<crate::model::AnalysisAclRule>,
        ) -> Self {
            self.acl_rule = input;
            self
        }
        /// <p>The resource to which the path component is attached.</p>
        pub fn attached_to(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.attached_to = Some(input);
            self
        }
        /// <p>The resource to which the path component is attached.</p>
        pub fn set_attached_to(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.attached_to = input;
            self
        }
        /// <p>The component.</p>
        pub fn component(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.component = Some(input);
            self
        }
        /// <p>The component.</p>
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.component = input;
            self
        }
        /// <p>The destination VPC.</p>
        pub fn destination_vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.destination_vpc = Some(input);
            self
        }
        /// <p>The destination VPC.</p>
        pub fn set_destination_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.destination_vpc = input;
            self
        }
        /// <p>The outbound header.</p>
        pub fn outbound_header(mut self, input: crate::model::AnalysisPacketHeader) -> Self {
            self.outbound_header = Some(input);
            self
        }
        /// <p>The outbound header.</p>
        pub fn set_outbound_header(
            mut self,
            input: std::option::Option<crate::model::AnalysisPacketHeader>,
        ) -> Self {
            self.outbound_header = input;
            self
        }
        /// <p>The inbound header.</p>
        pub fn inbound_header(mut self, input: crate::model::AnalysisPacketHeader) -> Self {
            self.inbound_header = Some(input);
            self
        }
        /// <p>The inbound header.</p>
        pub fn set_inbound_header(
            mut self,
            input: std::option::Option<crate::model::AnalysisPacketHeader>,
        ) -> Self {
            self.inbound_header = input;
            self
        }
        /// <p>The route table route.</p>
        pub fn route_table_route(mut self, input: crate::model::AnalysisRouteTableRoute) -> Self {
            self.route_table_route = Some(input);
            self
        }
        /// <p>The route table route.</p>
        pub fn set_route_table_route(
            mut self,
            input: std::option::Option<crate::model::AnalysisRouteTableRoute>,
        ) -> Self {
            self.route_table_route = input;
            self
        }
        /// <p>The security group rule.</p>
        pub fn security_group_rule(
            mut self,
            input: crate::model::AnalysisSecurityGroupRule,
        ) -> Self {
            self.security_group_rule = Some(input);
            self
        }
        /// <p>The security group rule.</p>
        pub fn set_security_group_rule(
            mut self,
            input: std::option::Option<crate::model::AnalysisSecurityGroupRule>,
        ) -> Self {
            self.security_group_rule = input;
            self
        }
        /// <p>The source VPC.</p>
        pub fn source_vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.source_vpc = Some(input);
            self
        }
        /// <p>The source VPC.</p>
        pub fn set_source_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.source_vpc = input;
            self
        }
        /// <p>The subnet.</p>
        pub fn subnet(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.subnet = Some(input);
            self
        }
        /// <p>The subnet.</p>
        pub fn set_subnet(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.subnet = input;
            self
        }
        /// <p>The component VPC.</p>
        pub fn vpc(mut self, input: crate::model::AnalysisComponent) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>The component VPC.</p>
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::AnalysisComponent>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`PathComponent`](crate::model::PathComponent)
        pub fn build(self) -> crate::model::PathComponent {
            crate::model::PathComponent {
                sequence_number: self.sequence_number,
                acl_rule: self.acl_rule,
                attached_to: self.attached_to,
                component: self.component,
                destination_vpc: self.destination_vpc,
                outbound_header: self.outbound_header,
                inbound_header: self.inbound_header,
                route_table_route: self.route_table_route,
                security_group_rule: self.security_group_rule,
                source_vpc: self.source_vpc,
                subnet: self.subnet,
                vpc: self.vpc,
            }
        }
    }
}
impl PathComponent {
    /// Creates a new builder-style object to manufacture [`PathComponent`](crate::model::PathComponent)
    pub fn builder() -> crate::model::path_component::Builder {
        crate::model::path_component::Builder::default()
    }
}

/// <p>Describes a header. Reflects any changes made by a component as traffic passes through. The fields of an inbound header are null except for the first component of a path.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalysisPacketHeader {
    /// <p>The destination addresses.</p>
    pub destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The destination port ranges.</p>
    pub destination_port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The protocol.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The source addresses.</p>
    pub source_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The source port ranges.</p>
    pub source_port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
}
impl AnalysisPacketHeader {
    /// <p>The destination addresses.</p>
    pub fn destination_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.destination_addresses.as_deref()
    }
    /// <p>The destination port ranges.</p>
    pub fn destination_port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.destination_port_ranges.as_deref()
    }
    /// <p>The protocol.</p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
    /// <p>The source addresses.</p>
    pub fn source_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.source_addresses.as_deref()
    }
    /// <p>The source port ranges.</p>
    pub fn source_port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.source_port_ranges.as_deref()
    }
}
impl std::fmt::Debug for AnalysisPacketHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalysisPacketHeader");
        formatter.field("destination_addresses", &self.destination_addresses);
        formatter.field("destination_port_ranges", &self.destination_port_ranges);
        formatter.field("protocol", &self.protocol);
        formatter.field("source_addresses", &self.source_addresses);
        formatter.field("source_port_ranges", &self.source_port_ranges);
        formatter.finish()
    }
}
/// See [`AnalysisPacketHeader`](crate::model::AnalysisPacketHeader)
pub mod analysis_packet_header {
    /// A builder for [`AnalysisPacketHeader`](crate::model::AnalysisPacketHeader)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destination_port_ranges:
            std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) source_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    }
    impl Builder {
        /// Appends an item to `destination_addresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>The destination addresses.</p>
        pub fn destination_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.destination_addresses.unwrap_or_default();
            v.push(input.into());
            self.destination_addresses = Some(v);
            self
        }
        /// <p>The destination addresses.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.destination_addresses = input;
            self
        }
        /// Appends an item to `destination_port_ranges`.
        ///
        /// To override the contents of this collection use [`set_destination_port_ranges`](Self::set_destination_port_ranges).
        ///
        /// <p>The destination port ranges.</p>
        pub fn destination_port_ranges(mut self, input: crate::model::PortRange) -> Self {
            let mut v = self.destination_port_ranges.unwrap_or_default();
            v.push(input);
            self.destination_port_ranges = Some(v);
            self
        }
        /// <p>The destination port ranges.</p>
        pub fn set_destination_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.destination_port_ranges = input;
            self
        }
        /// <p>The protocol.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// Appends an item to `source_addresses`.
        ///
        /// To override the contents of this collection use [`set_source_addresses`](Self::set_source_addresses).
        ///
        /// <p>The source addresses.</p>
        pub fn source_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_addresses.unwrap_or_default();
            v.push(input.into());
            self.source_addresses = Some(v);
            self
        }
        /// <p>The source addresses.</p>
        pub fn set_source_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_addresses = input;
            self
        }
        /// Appends an item to `source_port_ranges`.
        ///
        /// To override the contents of this collection use [`set_source_port_ranges`](Self::set_source_port_ranges).
        ///
        /// <p>The source port ranges.</p>
        pub fn source_port_ranges(mut self, input: crate::model::PortRange) -> Self {
            let mut v = self.source_port_ranges.unwrap_or_default();
            v.push(input);
            self.source_port_ranges = Some(v);
            self
        }
        /// <p>The source port ranges.</p>
        pub fn set_source_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.source_port_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalysisPacketHeader`](crate::model::AnalysisPacketHeader)
        pub fn build(self) -> crate::model::AnalysisPacketHeader {
            crate::model::AnalysisPacketHeader {
                destination_addresses: self.destination_addresses,
                destination_port_ranges: self.destination_port_ranges,
                protocol: self.protocol,
                source_addresses: self.source_addresses,
                source_port_ranges: self.source_port_ranges,
            }
        }
    }
}
impl AnalysisPacketHeader {
    /// Creates a new builder-style object to manufacture [`AnalysisPacketHeader`](crate::model::AnalysisPacketHeader)
    pub fn builder() -> crate::model::analysis_packet_header::Builder {
        crate::model::analysis_packet_header::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalysisStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalysisStatus {
    fn from(s: &str) -> Self {
        match s {
            "failed" => AnalysisStatus::Failed,
            "running" => AnalysisStatus::Running,
            "succeeded" => AnalysisStatus::Succeeded,
            other => AnalysisStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalysisStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalysisStatus::from(s))
    }
}
impl AnalysisStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalysisStatus::Failed => "failed",
            AnalysisStatus::Running => "running",
            AnalysisStatus::Succeeded => "succeeded",
            AnalysisStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["failed", "running", "succeeded"]
    }
}
impl AsRef<str> for AnalysisStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The tags to apply to a resource when the resource is being created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagSpecification {
    /// <p>The type of resource to tag on creation.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tags to apply to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagSpecification {
    /// <p>The type of resource to tag on creation.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The tags to apply to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagSpecification");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagSpecification`](crate::model::TagSpecification)
pub mod tag_specification {
    /// A builder for [`TagSpecification`](crate::model::TagSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The type of resource to tag on creation.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource to tag on creation.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagSpecification`](crate::model::TagSpecification)
        pub fn build(self) -> crate::model::TagSpecification {
            crate::model::TagSpecification {
                resource_type: self.resource_type,
                tags: self.tags,
            }
        }
    }
}
impl TagSpecification {
    /// Creates a new builder-style object to manufacture [`TagSpecification`](crate::model::TagSpecification)
    pub fn builder() -> crate::model::tag_specification::Builder {
        crate::model::tag_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    CapacityReservation,
    #[allow(missing_docs)] // documentation missing in model
    CarrierGateway,
    #[allow(missing_docs)] // documentation missing in model
    ClientVpnEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    CustomerGateway,
    #[allow(missing_docs)] // documentation missing in model
    DedicatedHost,
    #[allow(missing_docs)] // documentation missing in model
    DhcpOptions,
    #[allow(missing_docs)] // documentation missing in model
    EgressOnlyInternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    ElasticGpu,
    #[allow(missing_docs)] // documentation missing in model
    ElasticIp,
    #[allow(missing_docs)] // documentation missing in model
    ExportImageTask,
    #[allow(missing_docs)] // documentation missing in model
    ExportInstanceTask,
    #[allow(missing_docs)] // documentation missing in model
    Fleet,
    #[allow(missing_docs)] // documentation missing in model
    FpgaImage,
    #[allow(missing_docs)] // documentation missing in model
    HostReservation,
    #[allow(missing_docs)] // documentation missing in model
    Image,
    #[allow(missing_docs)] // documentation missing in model
    ImportImageTask,
    #[allow(missing_docs)] // documentation missing in model
    ImportSnapshotTask,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    InstanceEventWindow,
    #[allow(missing_docs)] // documentation missing in model
    InternetGateway,
    #[allow(missing_docs)] // documentation missing in model
    Ipam,
    #[allow(missing_docs)] // documentation missing in model
    IpamPool,
    #[allow(missing_docs)] // documentation missing in model
    IpamScope,
    #[allow(missing_docs)] // documentation missing in model
    Ipv4poolEc2,
    #[allow(missing_docs)] // documentation missing in model
    Ipv6poolEc2,
    #[allow(missing_docs)] // documentation missing in model
    KeyPair,
    #[allow(missing_docs)] // documentation missing in model
    LaunchTemplate,
    #[allow(missing_docs)] // documentation missing in model
    LocalGateway,
    #[allow(missing_docs)] // documentation missing in model
    LocalGatewayRouteTable,
    #[allow(missing_docs)] // documentation missing in model
    LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
    #[allow(missing_docs)] // documentation missing in model
    LocalGatewayRouteTableVpcAssociation,
    #[allow(missing_docs)] // documentation missing in model
    LocalGatewayVirtualInterface,
    #[allow(missing_docs)] // documentation missing in model
    LocalGatewayVirtualInterfaceGroup,
    #[allow(missing_docs)] // documentation missing in model
    Natgateway,
    #[allow(missing_docs)] // documentation missing in model
    NetworkAcl,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInsightsAccessScope,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInsightsAccessScopeAnalysis,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInsightsAnalysis,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInsightsPath,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    PlacementGroup,
    #[allow(missing_docs)] // documentation missing in model
    PrefixList,
    #[allow(missing_docs)] // documentation missing in model
    ReplaceRootVolumeTask,
    #[allow(missing_docs)] // documentation missing in model
    ReservedInstances,
    #[allow(missing_docs)] // documentation missing in model
    RouteTable,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupRule,
    #[allow(missing_docs)] // documentation missing in model
    Snapshot,
    #[allow(missing_docs)] // documentation missing in model
    SpotFleetRequest,
    #[allow(missing_docs)] // documentation missing in model
    SpotInstancesRequest,
    #[allow(missing_docs)] // documentation missing in model
    Subnet,
    #[allow(missing_docs)] // documentation missing in model
    SubnetCidrReservation,
    #[allow(missing_docs)] // documentation missing in model
    TrafficMirrorFilter,
    #[allow(missing_docs)] // documentation missing in model
    TrafficMirrorSession,
    #[allow(missing_docs)] // documentation missing in model
    TrafficMirrorTarget,
    #[allow(missing_docs)] // documentation missing in model
    TransitGateway,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayAttachment,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayConnectPeer,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayMulticastDomain,
    #[allow(missing_docs)] // documentation missing in model
    TransitGatewayRouteTable,
    #[allow(missing_docs)] // documentation missing in model
    Volume,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    VpcEndpointService,
    #[allow(missing_docs)] // documentation missing in model
    VpcFlowLog,
    #[allow(missing_docs)] // documentation missing in model
    VpcPeeringConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnConnection,
    #[allow(missing_docs)] // documentation missing in model
    VpnGateway,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "capacity-reservation" => ResourceType::CapacityReservation,
            "carrier-gateway" => ResourceType::CarrierGateway,
            "client-vpn-endpoint" => ResourceType::ClientVpnEndpoint,
            "customer-gateway" => ResourceType::CustomerGateway,
            "dedicated-host" => ResourceType::DedicatedHost,
            "dhcp-options" => ResourceType::DhcpOptions,
            "egress-only-internet-gateway" => ResourceType::EgressOnlyInternetGateway,
            "elastic-gpu" => ResourceType::ElasticGpu,
            "elastic-ip" => ResourceType::ElasticIp,
            "export-image-task" => ResourceType::ExportImageTask,
            "export-instance-task" => ResourceType::ExportInstanceTask,
            "fleet" => ResourceType::Fleet,
            "fpga-image" => ResourceType::FpgaImage,
            "host-reservation" => ResourceType::HostReservation,
            "image" => ResourceType::Image,
            "import-image-task" => ResourceType::ImportImageTask,
            "import-snapshot-task" => ResourceType::ImportSnapshotTask,
            "instance" => ResourceType::Instance,
            "instance-event-window" => ResourceType::InstanceEventWindow,
            "internet-gateway" => ResourceType::InternetGateway,
            "ipam" => ResourceType::Ipam,
            "ipam-pool" => ResourceType::IpamPool,
            "ipam-scope" => ResourceType::IpamScope,
            "ipv4pool-ec2" => ResourceType::Ipv4poolEc2,
            "ipv6pool-ec2" => ResourceType::Ipv6poolEc2,
            "key-pair" => ResourceType::KeyPair,
            "launch-template" => ResourceType::LaunchTemplate,
            "local-gateway" => ResourceType::LocalGateway,
            "local-gateway-route-table" => ResourceType::LocalGatewayRouteTable,
            "local-gateway-route-table-virtual-interface-group-association" => {
                ResourceType::LocalGatewayRouteTableVirtualInterfaceGroupAssociation
            }
            "local-gateway-route-table-vpc-association" => {
                ResourceType::LocalGatewayRouteTableVpcAssociation
            }
            "local-gateway-virtual-interface" => ResourceType::LocalGatewayVirtualInterface,
            "local-gateway-virtual-interface-group" => {
                ResourceType::LocalGatewayVirtualInterfaceGroup
            }
            "natgateway" => ResourceType::Natgateway,
            "network-acl" => ResourceType::NetworkAcl,
            "network-insights-access-scope" => ResourceType::NetworkInsightsAccessScope,
            "network-insights-access-scope-analysis" => {
                ResourceType::NetworkInsightsAccessScopeAnalysis
            }
            "network-insights-analysis" => ResourceType::NetworkInsightsAnalysis,
            "network-insights-path" => ResourceType::NetworkInsightsPath,
            "network-interface" => ResourceType::NetworkInterface,
            "placement-group" => ResourceType::PlacementGroup,
            "prefix-list" => ResourceType::PrefixList,
            "replace-root-volume-task" => ResourceType::ReplaceRootVolumeTask,
            "reserved-instances" => ResourceType::ReservedInstances,
            "route-table" => ResourceType::RouteTable,
            "security-group" => ResourceType::SecurityGroup,
            "security-group-rule" => ResourceType::SecurityGroupRule,
            "snapshot" => ResourceType::Snapshot,
            "spot-fleet-request" => ResourceType::SpotFleetRequest,
            "spot-instances-request" => ResourceType::SpotInstancesRequest,
            "subnet" => ResourceType::Subnet,
            "subnet-cidr-reservation" => ResourceType::SubnetCidrReservation,
            "traffic-mirror-filter" => ResourceType::TrafficMirrorFilter,
            "traffic-mirror-session" => ResourceType::TrafficMirrorSession,
            "traffic-mirror-target" => ResourceType::TrafficMirrorTarget,
            "transit-gateway" => ResourceType::TransitGateway,
            "transit-gateway-attachment" => ResourceType::TransitGatewayAttachment,
            "transit-gateway-connect-peer" => ResourceType::TransitGatewayConnectPeer,
            "transit-gateway-multicast-domain" => ResourceType::TransitGatewayMulticastDomain,
            "transit-gateway-route-table" => ResourceType::TransitGatewayRouteTable,
            "volume" => ResourceType::Volume,
            "vpc" => ResourceType::Vpc,
            "vpc-endpoint" => ResourceType::VpcEndpoint,
            "vpc-endpoint-service" => ResourceType::VpcEndpointService,
            "vpc-flow-log" => ResourceType::VpcFlowLog,
            "vpc-peering-connection" => ResourceType::VpcPeeringConnection,
            "vpn-connection" => ResourceType::VpnConnection,
            "vpn-gateway" => ResourceType::VpnGateway,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::CapacityReservation => "capacity-reservation",
            ResourceType::CarrierGateway => "carrier-gateway",
            ResourceType::ClientVpnEndpoint => "client-vpn-endpoint",
            ResourceType::CustomerGateway => "customer-gateway",
            ResourceType::DedicatedHost => "dedicated-host",
            ResourceType::DhcpOptions => "dhcp-options",
            ResourceType::EgressOnlyInternetGateway => "egress-only-internet-gateway",
            ResourceType::ElasticGpu => "elastic-gpu",
            ResourceType::ElasticIp => "elastic-ip",
            ResourceType::ExportImageTask => "export-image-task",
            ResourceType::ExportInstanceTask => "export-instance-task",
            ResourceType::Fleet => "fleet",
            ResourceType::FpgaImage => "fpga-image",
            ResourceType::HostReservation => "host-reservation",
            ResourceType::Image => "image",
            ResourceType::ImportImageTask => "import-image-task",
            ResourceType::ImportSnapshotTask => "import-snapshot-task",
            ResourceType::Instance => "instance",
            ResourceType::InstanceEventWindow => "instance-event-window",
            ResourceType::InternetGateway => "internet-gateway",
            ResourceType::Ipam => "ipam",
            ResourceType::IpamPool => "ipam-pool",
            ResourceType::IpamScope => "ipam-scope",
            ResourceType::Ipv4poolEc2 => "ipv4pool-ec2",
            ResourceType::Ipv6poolEc2 => "ipv6pool-ec2",
            ResourceType::KeyPair => "key-pair",
            ResourceType::LaunchTemplate => "launch-template",
            ResourceType::LocalGateway => "local-gateway",
            ResourceType::LocalGatewayRouteTable => "local-gateway-route-table",
            ResourceType::LocalGatewayRouteTableVirtualInterfaceGroupAssociation => {
                "local-gateway-route-table-virtual-interface-group-association"
            }
            ResourceType::LocalGatewayRouteTableVpcAssociation => {
                "local-gateway-route-table-vpc-association"
            }
            ResourceType::LocalGatewayVirtualInterface => "local-gateway-virtual-interface",
            ResourceType::LocalGatewayVirtualInterfaceGroup => {
                "local-gateway-virtual-interface-group"
            }
            ResourceType::Natgateway => "natgateway",
            ResourceType::NetworkAcl => "network-acl",
            ResourceType::NetworkInsightsAccessScope => "network-insights-access-scope",
            ResourceType::NetworkInsightsAccessScopeAnalysis => {
                "network-insights-access-scope-analysis"
            }
            ResourceType::NetworkInsightsAnalysis => "network-insights-analysis",
            ResourceType::NetworkInsightsPath => "network-insights-path",
            ResourceType::NetworkInterface => "network-interface",
            ResourceType::PlacementGroup => "placement-group",
            ResourceType::PrefixList => "prefix-list",
            ResourceType::ReplaceRootVolumeTask => "replace-root-volume-task",
            ResourceType::ReservedInstances => "reserved-instances",
            ResourceType::RouteTable => "route-table",
            ResourceType::SecurityGroup => "security-group",
            ResourceType::SecurityGroupRule => "security-group-rule",
            ResourceType::Snapshot => "snapshot",
            ResourceType::SpotFleetRequest => "spot-fleet-request",
            ResourceType::SpotInstancesRequest => "spot-instances-request",
            ResourceType::Subnet => "subnet",
            ResourceType::SubnetCidrReservation => "subnet-cidr-reservation",
            ResourceType::TrafficMirrorFilter => "traffic-mirror-filter",
            ResourceType::TrafficMirrorSession => "traffic-mirror-session",
            ResourceType::TrafficMirrorTarget => "traffic-mirror-target",
            ResourceType::TransitGateway => "transit-gateway",
            ResourceType::TransitGatewayAttachment => "transit-gateway-attachment",
            ResourceType::TransitGatewayConnectPeer => "transit-gateway-connect-peer",
            ResourceType::TransitGatewayMulticastDomain => "transit-gateway-multicast-domain",
            ResourceType::TransitGatewayRouteTable => "transit-gateway-route-table",
            ResourceType::Volume => "volume",
            ResourceType::Vpc => "vpc",
            ResourceType::VpcEndpoint => "vpc-endpoint",
            ResourceType::VpcEndpointService => "vpc-endpoint-service",
            ResourceType::VpcFlowLog => "vpc-flow-log",
            ResourceType::VpcPeeringConnection => "vpc-peering-connection",
            ResourceType::VpnConnection => "vpn-connection",
            ResourceType::VpnGateway => "vpn-gateway",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "capacity-reservation",
            "carrier-gateway",
            "client-vpn-endpoint",
            "customer-gateway",
            "dedicated-host",
            "dhcp-options",
            "egress-only-internet-gateway",
            "elastic-gpu",
            "elastic-ip",
            "export-image-task",
            "export-instance-task",
            "fleet",
            "fpga-image",
            "host-reservation",
            "image",
            "import-image-task",
            "import-snapshot-task",
            "instance",
            "instance-event-window",
            "internet-gateway",
            "ipam",
            "ipam-pool",
            "ipam-scope",
            "ipv4pool-ec2",
            "ipv6pool-ec2",
            "key-pair",
            "launch-template",
            "local-gateway",
            "local-gateway-route-table",
            "local-gateway-route-table-virtual-interface-group-association",
            "local-gateway-route-table-vpc-association",
            "local-gateway-virtual-interface",
            "local-gateway-virtual-interface-group",
            "natgateway",
            "network-acl",
            "network-insights-access-scope",
            "network-insights-access-scope-analysis",
            "network-insights-analysis",
            "network-insights-path",
            "network-interface",
            "placement-group",
            "prefix-list",
            "replace-root-volume-task",
            "reserved-instances",
            "route-table",
            "security-group",
            "security-group-rule",
            "snapshot",
            "spot-fleet-request",
            "spot-instances-request",
            "subnet",
            "subnet-cidr-reservation",
            "traffic-mirror-filter",
            "traffic-mirror-session",
            "traffic-mirror-target",
            "transit-gateway",
            "transit-gateway-attachment",
            "transit-gateway-connect-peer",
            "transit-gateway-multicast-domain",
            "transit-gateway-route-table",
            "volume",
            "vpc",
            "vpc-endpoint",
            "vpc-endpoint-service",
            "vpc-flow-log",
            "vpc-peering-connection",
            "vpn-connection",
            "vpn-gateway",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a Network Access Scope analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInsightsAccessScopeAnalysis {
    /// <p>The ID of the Network Access Scope analysis.</p>
    pub network_insights_access_scope_analysis_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Network Access Scope analysis.</p>
    pub network_insights_access_scope_analysis_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Network Access Scope.</p>
    pub network_insights_access_scope_id: std::option::Option<std::string::String>,
    /// <p>The status.</p>
    pub status: std::option::Option<crate::model::AnalysisStatus>,
    /// <p>The status message.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The warning message.</p>
    pub warning_message: std::option::Option<std::string::String>,
    /// <p>The analysis start date.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The analysis end date.</p>
    pub end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether there are findings.</p>
    pub findings_found: std::option::Option<crate::model::FindingsFound>,
    /// <p>The number of network interfaces analyzed.</p>
    pub analyzed_eni_count: std::option::Option<i32>,
    /// <p>The tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl NetworkInsightsAccessScopeAnalysis {
    /// <p>The ID of the Network Access Scope analysis.</p>
    pub fn network_insights_access_scope_analysis_id(&self) -> std::option::Option<&str> {
        self.network_insights_access_scope_analysis_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Network Access Scope analysis.</p>
    pub fn network_insights_access_scope_analysis_arn(&self) -> std::option::Option<&str> {
        self.network_insights_access_scope_analysis_arn.as_deref()
    }
    /// <p>The ID of the Network Access Scope.</p>
    pub fn network_insights_access_scope_id(&self) -> std::option::Option<&str> {
        self.network_insights_access_scope_id.as_deref()
    }
    /// <p>The status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnalysisStatus> {
        self.status.as_ref()
    }
    /// <p>The status message.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The warning message.</p>
    pub fn warning_message(&self) -> std::option::Option<&str> {
        self.warning_message.as_deref()
    }
    /// <p>The analysis start date.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The analysis end date.</p>
    pub fn end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_date.as_ref()
    }
    /// <p>Indicates whether there are findings.</p>
    pub fn findings_found(&self) -> std::option::Option<&crate::model::FindingsFound> {
        self.findings_found.as_ref()
    }
    /// <p>The number of network interfaces analyzed.</p>
    pub fn analyzed_eni_count(&self) -> std::option::Option<i32> {
        self.analyzed_eni_count
    }
    /// <p>The tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for NetworkInsightsAccessScopeAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInsightsAccessScopeAnalysis");
        formatter.field(
            "network_insights_access_scope_analysis_id",
            &self.network_insights_access_scope_analysis_id,
        );
        formatter.field(
            "network_insights_access_scope_analysis_arn",
            &self.network_insights_access_scope_analysis_arn,
        );
        formatter.field(
            "network_insights_access_scope_id",
            &self.network_insights_access_scope_id,
        );
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("warning_message", &self.warning_message);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.field("findings_found", &self.findings_found);
        formatter.field("analyzed_eni_count", &self.analyzed_eni_count);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`NetworkInsightsAccessScopeAnalysis`](crate::model::NetworkInsightsAccessScopeAnalysis)
pub mod network_insights_access_scope_analysis {
    /// A builder for [`NetworkInsightsAccessScopeAnalysis`](crate::model::NetworkInsightsAccessScopeAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_insights_access_scope_analysis_id:
            std::option::Option<std::string::String>,
        pub(crate) network_insights_access_scope_analysis_arn:
            std::option::Option<std::string::String>,
        pub(crate) network_insights_access_scope_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AnalysisStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) warning_message: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) findings_found: std::option::Option<crate::model::FindingsFound>,
        pub(crate) analyzed_eni_count: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the Network Access Scope analysis.</p>
        pub fn network_insights_access_scope_analysis_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_analysis_id = Some(input.into());
            self
        }
        /// <p>The ID of the Network Access Scope analysis.</p>
        pub fn set_network_insights_access_scope_analysis_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_analysis_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Access Scope analysis.</p>
        pub fn network_insights_access_scope_analysis_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_analysis_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Network Access Scope analysis.</p>
        pub fn set_network_insights_access_scope_analysis_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_analysis_arn = input;
            self
        }
        /// <p>The ID of the Network Access Scope.</p>
        pub fn network_insights_access_scope_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_id = Some(input.into());
            self
        }
        /// <p>The ID of the Network Access Scope.</p>
        pub fn set_network_insights_access_scope_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_insights_access_scope_id = input;
            self
        }
        /// <p>The status.</p>
        pub fn status(mut self, input: crate::model::AnalysisStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnalysisStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The warning message.</p>
        pub fn warning_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_message = Some(input.into());
            self
        }
        /// <p>The warning message.</p>
        pub fn set_warning_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_message = input;
            self
        }
        /// <p>The analysis start date.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The analysis start date.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The analysis end date.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The analysis end date.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>Indicates whether there are findings.</p>
        pub fn findings_found(mut self, input: crate::model::FindingsFound) -> Self {
            self.findings_found = Some(input);
            self
        }
        /// <p>Indicates whether there are findings.</p>
        pub fn set_findings_found(
            mut self,
            input: std::option::Option<crate::model::FindingsFound>,
        ) -> Self {
            self.findings_found = input;
            self
        }
        /// <p>The number of network interfaces analyzed.</p>
        pub fn analyzed_eni_count(mut self, input: i32) -> Self {
            self.analyzed_eni_count = Some(input);
            self
        }
        /// <p>The number of network interfaces analyzed.</p>
        pub fn set_analyzed_eni_count(mut self, input: std::option::Option<i32>) -> Self {
            self.analyzed_eni_count = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInsightsAccessScopeAnalysis`](crate::model::NetworkInsightsAccessScopeAnalysis)
        pub fn build(self) -> crate::model::NetworkInsightsAccessScopeAnalysis {
            crate::model::NetworkInsightsAccessScopeAnalysis {
                network_insights_access_scope_analysis_id: self
                    .network_insights_access_scope_analysis_id,
                network_insights_access_scope_analysis_arn: self
                    .network_insights_access_scope_analysis_arn,
                network_insights_access_scope_id: self.network_insights_access_scope_id,
                status: self.status,
                status_message: self.status_message,
                warning_message: self.warning_message,
                start_date: self.start_date,
                end_date: self.end_date,
                findings_found: self.findings_found,
                analyzed_eni_count: self.analyzed_eni_count,
                tags: self.tags,
            }
        }
    }
}
impl NetworkInsightsAccessScopeAnalysis {
    /// Creates a new builder-style object to manufacture [`NetworkInsightsAccessScopeAnalysis`](crate::model::NetworkInsightsAccessScopeAnalysis)
    pub fn builder() -> crate::model::network_insights_access_scope_analysis::Builder {
        crate::model::network_insights_access_scope_analysis::Builder::default()
    }
}

/// _Note: `FindingsFound::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingsFound {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingsFound {
    fn from(s: &str) -> Self {
        match s {
            "false" => FindingsFound::False,
            "true" => FindingsFound::True,
            "unknown" => FindingsFound::UnknownValue,
            other => FindingsFound::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingsFound {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingsFound::from(s))
    }
}
impl FindingsFound {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingsFound::False => "false",
            FindingsFound::True => "true",
            FindingsFound::UnknownValue => "unknown",
            FindingsFound::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["false", "true", "unknown"]
    }
}
impl AsRef<str> for FindingsFound {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a route for a transit gateway route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRoute {
    /// <p>The CIDR block used for destination matches.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>The ID of the prefix list used for destination matches.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The attachments.</p>
    pub transit_gateway_attachments:
        std::option::Option<std::vec::Vec<crate::model::TransitGatewayRouteAttachment>>,
    /// <p>The route type.</p>
    pub r#type: std::option::Option<crate::model::TransitGatewayRouteType>,
    /// <p>The state of the route.</p>
    pub state: std::option::Option<crate::model::TransitGatewayRouteState>,
}
impl TransitGatewayRoute {
    /// <p>The CIDR block used for destination matches.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>The ID of the prefix list used for destination matches.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>The attachments.</p>
    pub fn transit_gateway_attachments(
        &self,
    ) -> std::option::Option<&[crate::model::TransitGatewayRouteAttachment]> {
        self.transit_gateway_attachments.as_deref()
    }
    /// <p>The route type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TransitGatewayRouteType> {
        self.r#type.as_ref()
    }
    /// <p>The state of the route.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::TransitGatewayRouteState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for TransitGatewayRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRoute");
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field(
            "transit_gateway_attachments",
            &self.transit_gateway_attachments,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`TransitGatewayRoute`](crate::model::TransitGatewayRoute)
pub mod transit_gateway_route {
    /// A builder for [`TransitGatewayRoute`](crate::model::TransitGatewayRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachments:
            std::option::Option<std::vec::Vec<crate::model::TransitGatewayRouteAttachment>>,
        pub(crate) r#type: std::option::Option<crate::model::TransitGatewayRouteType>,
        pub(crate) state: std::option::Option<crate::model::TransitGatewayRouteState>,
    }
    impl Builder {
        /// <p>The CIDR block used for destination matches.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The CIDR block used for destination matches.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The ID of the prefix list used for destination matches.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the prefix list used for destination matches.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// Appends an item to `transit_gateway_attachments`.
        ///
        /// To override the contents of this collection use [`set_transit_gateway_attachments`](Self::set_transit_gateway_attachments).
        ///
        /// <p>The attachments.</p>
        pub fn transit_gateway_attachments(
            mut self,
            input: crate::model::TransitGatewayRouteAttachment,
        ) -> Self {
            let mut v = self.transit_gateway_attachments.unwrap_or_default();
            v.push(input);
            self.transit_gateway_attachments = Some(v);
            self
        }
        /// <p>The attachments.</p>
        pub fn set_transit_gateway_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransitGatewayRouteAttachment>>,
        ) -> Self {
            self.transit_gateway_attachments = input;
            self
        }
        /// <p>The route type.</p>
        pub fn r#type(mut self, input: crate::model::TransitGatewayRouteType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The route type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRouteType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the route.</p>
        pub fn state(mut self, input: crate::model::TransitGatewayRouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the route.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayRouteState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRoute`](crate::model::TransitGatewayRoute)
        pub fn build(self) -> crate::model::TransitGatewayRoute {
            crate::model::TransitGatewayRoute {
                destination_cidr_block: self.destination_cidr_block,
                prefix_list_id: self.prefix_list_id,
                transit_gateway_attachments: self.transit_gateway_attachments,
                r#type: self.r#type,
                state: self.state,
            }
        }
    }
}
impl TransitGatewayRoute {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRoute`](crate::model::TransitGatewayRoute)
    pub fn builder() -> crate::model::transit_gateway_route::Builder {
        crate::model::transit_gateway_route::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayRouteState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Blackhole,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayRouteState {
    fn from(s: &str) -> Self {
        match s {
            "active" => TransitGatewayRouteState::Active,
            "blackhole" => TransitGatewayRouteState::Blackhole,
            "deleted" => TransitGatewayRouteState::Deleted,
            "deleting" => TransitGatewayRouteState::Deleting,
            "pending" => TransitGatewayRouteState::Pending,
            other => TransitGatewayRouteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayRouteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayRouteState::from(s))
    }
}
impl TransitGatewayRouteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayRouteState::Active => "active",
            TransitGatewayRouteState::Blackhole => "blackhole",
            TransitGatewayRouteState::Deleted => "deleted",
            TransitGatewayRouteState::Deleting => "deleting",
            TransitGatewayRouteState::Pending => "pending",
            TransitGatewayRouteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "blackhole", "deleted", "deleting", "pending"]
    }
}
impl AsRef<str> for TransitGatewayRouteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayRouteType {
    #[allow(missing_docs)] // documentation missing in model
    Propagated,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayRouteType {
    fn from(s: &str) -> Self {
        match s {
            "propagated" => TransitGatewayRouteType::Propagated,
            "static" => TransitGatewayRouteType::Static,
            other => TransitGatewayRouteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayRouteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayRouteType::from(s))
    }
}
impl TransitGatewayRouteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayRouteType::Propagated => "propagated",
            TransitGatewayRouteType::Static => "static",
            TransitGatewayRouteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["propagated", "static"]
    }
}
impl AsRef<str> for TransitGatewayRouteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a route attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayRouteAttachment {
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The ID of the attachment.</p>
    pub transit_gateway_attachment_id: std::option::Option<std::string::String>,
    /// <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated. </p>
    pub resource_type: std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
}
impl TransitGatewayRouteAttachment {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The ID of the attachment.</p>
    pub fn transit_gateway_attachment_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_attachment_id.as_deref()
    }
    /// <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated. </p>
    pub fn resource_type(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayAttachmentResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for TransitGatewayRouteAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayRouteAttachment");
        formatter.field("resource_id", &self.resource_id);
        formatter.field(
            "transit_gateway_attachment_id",
            &self.transit_gateway_attachment_id,
        );
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`TransitGatewayRouteAttachment`](crate::model::TransitGatewayRouteAttachment)
pub mod transit_gateway_route_attachment {
    /// A builder for [`TransitGatewayRouteAttachment`](crate::model::TransitGatewayRouteAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) resource_type:
            std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
    }
    impl Builder {
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated. </p>
        pub fn resource_type(
            mut self,
            input: crate::model::TransitGatewayAttachmentResourceType,
        ) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayRouteAttachment`](crate::model::TransitGatewayRouteAttachment)
        pub fn build(self) -> crate::model::TransitGatewayRouteAttachment {
            crate::model::TransitGatewayRouteAttachment {
                resource_id: self.resource_id,
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl TransitGatewayRouteAttachment {
    /// Creates a new builder-style object to manufacture [`TransitGatewayRouteAttachment`](crate::model::TransitGatewayRouteAttachment)
    pub fn builder() -> crate::model::transit_gateway_route_attachment::Builder {
        crate::model::transit_gateway_route_attachment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitGatewayAttachmentResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Connect,
    #[allow(missing_docs)] // documentation missing in model
    DirectConnectGateway,
    #[allow(missing_docs)] // documentation missing in model
    Peering,
    #[allow(missing_docs)] // documentation missing in model
    TgwPeering,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    #[allow(missing_docs)] // documentation missing in model
    Vpn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitGatewayAttachmentResourceType {
    fn from(s: &str) -> Self {
        match s {
            "connect" => TransitGatewayAttachmentResourceType::Connect,
            "direct-connect-gateway" => TransitGatewayAttachmentResourceType::DirectConnectGateway,
            "peering" => TransitGatewayAttachmentResourceType::Peering,
            "tgw-peering" => TransitGatewayAttachmentResourceType::TgwPeering,
            "vpc" => TransitGatewayAttachmentResourceType::Vpc,
            "vpn" => TransitGatewayAttachmentResourceType::Vpn,
            other => TransitGatewayAttachmentResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitGatewayAttachmentResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitGatewayAttachmentResourceType::from(s))
    }
}
impl TransitGatewayAttachmentResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitGatewayAttachmentResourceType::Connect => "connect",
            TransitGatewayAttachmentResourceType::DirectConnectGateway => "direct-connect-gateway",
            TransitGatewayAttachmentResourceType::Peering => "peering",
            TransitGatewayAttachmentResourceType::TgwPeering => "tgw-peering",
            TransitGatewayAttachmentResourceType::Vpc => "vpc",
            TransitGatewayAttachmentResourceType::Vpn => "vpn",
            TransitGatewayAttachmentResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "connect",
            "direct-connect-gateway",
            "peering",
            "tgw-peering",
            "vpc",
            "vpn",
        ]
    }
}
impl AsRef<str> for TransitGatewayAttachmentResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p>
/// <p>If you specify multiple filters, the filters are joined with an <code>AND</code>, and the request returns only results that match all of the specified filters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values. Filter values are case-sensitive. If you specify multiple values for a filter, the values are joined with an <code>OR</code>, and the request returns all results that match any of the specified values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Describes the transit gateway multicast group resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransitGatewayMulticastGroup {
    /// <p>The IP address assigned to the transit gateway multicast group.</p>
    pub group_ip_address: std::option::Option<std::string::String>,
    /// <p>The ID of the transit gateway attachment.</p>
    pub transit_gateway_attachment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource, for example a VPC attachment.</p>
    pub resource_type: std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
    /// <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.</p>
    pub resource_owner_id: std::option::Option<std::string::String>,
    /// <p>The ID of the transit gateway attachment.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
    pub group_member: std::option::Option<bool>,
    /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
    pub group_source: std::option::Option<bool>,
    /// <p>The member type (for example, <code>static</code>).</p>
    pub member_type: std::option::Option<crate::model::MembershipType>,
    /// <p>The source type.</p>
    pub source_type: std::option::Option<crate::model::MembershipType>,
}
impl TransitGatewayMulticastGroup {
    /// <p>The IP address assigned to the transit gateway multicast group.</p>
    pub fn group_ip_address(&self) -> std::option::Option<&str> {
        self.group_ip_address.as_deref()
    }
    /// <p>The ID of the transit gateway attachment.</p>
    pub fn transit_gateway_attachment_id(&self) -> std::option::Option<&str> {
        self.transit_gateway_attachment_id.as_deref()
    }
    /// <p>The ID of the subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource, for example a VPC attachment.</p>
    pub fn resource_type(
        &self,
    ) -> std::option::Option<&crate::model::TransitGatewayAttachmentResourceType> {
        self.resource_type.as_ref()
    }
    /// <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.</p>
    pub fn resource_owner_id(&self) -> std::option::Option<&str> {
        self.resource_owner_id.as_deref()
    }
    /// <p>The ID of the transit gateway attachment.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
    pub fn group_member(&self) -> std::option::Option<bool> {
        self.group_member
    }
    /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
    pub fn group_source(&self) -> std::option::Option<bool> {
        self.group_source
    }
    /// <p>The member type (for example, <code>static</code>).</p>
    pub fn member_type(&self) -> std::option::Option<&crate::model::MembershipType> {
        self.member_type.as_ref()
    }
    /// <p>The source type.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::MembershipType> {
        self.source_type.as_ref()
    }
}
impl std::fmt::Debug for TransitGatewayMulticastGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransitGatewayMulticastGroup");
        formatter.field("group_ip_address", &self.group_ip_address);
        formatter.field(
            "transit_gateway_attachment_id",
            &self.transit_gateway_attachment_id,
        );
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_owner_id", &self.resource_owner_id);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("group_member", &self.group_member);
        formatter.field("group_source", &self.group_source);
        formatter.field("member_type", &self.member_type);
        formatter.field("source_type", &self.source_type);
        formatter.finish()
    }
}
/// See [`TransitGatewayMulticastGroup`](crate::model::TransitGatewayMulticastGroup)
pub mod transit_gateway_multicast_group {
    /// A builder for [`TransitGatewayMulticastGroup`](crate::model::TransitGatewayMulticastGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_ip_address: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type:
            std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
        pub(crate) resource_owner_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) group_member: std::option::Option<bool>,
        pub(crate) group_source: std::option::Option<bool>,
        pub(crate) member_type: std::option::Option<crate::model::MembershipType>,
        pub(crate) source_type: std::option::Option<crate::model::MembershipType>,
    }
    impl Builder {
        /// <p>The IP address assigned to the transit gateway multicast group.</p>
        pub fn group_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_ip_address = Some(input.into());
            self
        }
        /// <p>The IP address assigned to the transit gateway multicast group.</p>
        pub fn set_group_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_ip_address = input;
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource, for example a VPC attachment.</p>
        pub fn resource_type(
            mut self,
            input: crate::model::TransitGatewayAttachmentResourceType,
        ) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource, for example a VPC attachment.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TransitGatewayAttachmentResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.</p>
        pub fn resource_owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_id = Some(input.into());
            self
        }
        /// <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.</p>
        pub fn set_resource_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_id = input;
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
        pub fn group_member(mut self, input: bool) -> Self {
            self.group_member = Some(input);
            self
        }
        /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
        pub fn set_group_member(mut self, input: std::option::Option<bool>) -> Self {
            self.group_member = input;
            self
        }
        /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
        pub fn group_source(mut self, input: bool) -> Self {
            self.group_source = Some(input);
            self
        }
        /// <p>Indicates that the resource is a transit gateway multicast group member.</p>
        pub fn set_group_source(mut self, input: std::option::Option<bool>) -> Self {
            self.group_source = input;
            self
        }
        /// <p>The member type (for example, <code>static</code>).</p>
        pub fn member_type(mut self, input: crate::model::MembershipType) -> Self {
            self.member_type = Some(input);
            self
        }
        /// <p>The member type (for example, <code>static</code>).</p>
        pub fn set_member_type(
            mut self,
            input: std::option::Option<crate::model::MembershipType>,
        ) -> Self {
            self.member_type = input;
            self
        }
        /// <p>The source type.</p>
        pub fn source_type(mut self, input: crate::model::MembershipType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The source type.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::MembershipType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// Consumes the builder and constructs a [`TransitGatewayMulticastGroup`](crate::model::TransitGatewayMulticastGroup)
        pub fn build(self) -> crate::model::TransitGatewayMulticastGroup {
            crate::model::TransitGatewayMulticastGroup {
                group_ip_address: self.group_ip_address,
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                subnet_id: self.subnet_id,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                resource_owner_id: self.resource_owner_id,
                network_interface_id: self.network_interface_id,
                group_member: self.group_member,
                group_source: self.group_source,
                member_type: self.member_type,
                source_type: self.source_type,
            }
        }
    }
}
impl TransitGatewayMulticastGroup {
    /// Creates a new builder-style object to manufacture [`TransitGatewayMulticastGroup`](crate::model::TransitGatewayMulticastGroup)
    pub fn builder() -> crate::model::transit_gateway_multicast_group::Builder {
        crate::model::transit_gateway_multicast_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MembershipType {
    #[allow(missing_docs)] // documentation missing in model
    Igmp,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MembershipType {
    fn from(s: &str) -> Self {
        match s {
            "igmp" => MembershipType::Igmp,
            "static" => MembershipType::Static,
            other => MembershipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MembershipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MembershipType::from(s))
    }
}
impl MembershipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MembershipType::Igmp => "igmp",
            MembershipType::Static => "static",
            MembershipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["igmp", "static"]
    }
}
impl AsRef<str> for MembershipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a route for a local gateway route table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalGatewayRoute {
    /// <p>The CIDR block used for destination matches.</p>
    pub destination_cidr_block: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual interface group.</p>
    pub local_gateway_virtual_interface_group_id: std::option::Option<std::string::String>,
    /// <p>The route type.</p>
    pub r#type: std::option::Option<crate::model::LocalGatewayRouteType>,
    /// <p>The state of the route.</p>
    pub state: std::option::Option<crate::model::LocalGatewayRouteState>,
    /// <p>The ID of the local gateway route table.</p>
    pub local_gateway_route_table_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the local gateway route table.</p>
    pub local_gateway_route_table_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the local gateway route.</p>
    pub owner_id: std::option::Option<std::string::String>,
}
impl LocalGatewayRoute {
    /// <p>The CIDR block used for destination matches.</p>
    pub fn destination_cidr_block(&self) -> std::option::Option<&str> {
        self.destination_cidr_block.as_deref()
    }
    /// <p>The ID of the virtual interface group.</p>
    pub fn local_gateway_virtual_interface_group_id(&self) -> std::option::Option<&str> {
        self.local_gateway_virtual_interface_group_id.as_deref()
    }
    /// <p>The route type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LocalGatewayRouteType> {
        self.r#type.as_ref()
    }
    /// <p>The state of the route.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::LocalGatewayRouteState> {
        self.state.as_ref()
    }
    /// <p>The ID of the local gateway route table.</p>
    pub fn local_gateway_route_table_id(&self) -> std::option::Option<&str> {
        self.local_gateway_route_table_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the local gateway route table.</p>
    pub fn local_gateway_route_table_arn(&self) -> std::option::Option<&str> {
        self.local_gateway_route_table_arn.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the local gateway route.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
}
impl std::fmt::Debug for LocalGatewayRoute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalGatewayRoute");
        formatter.field("destination_cidr_block", &self.destination_cidr_block);
        formatter.field(
            "local_gateway_virtual_interface_group_id",
            &self.local_gateway_virtual_interface_group_id,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field(
            "local_gateway_route_table_id",
            &self.local_gateway_route_table_id,
        );
        formatter.field(
            "local_gateway_route_table_arn",
            &self.local_gateway_route_table_arn,
        );
        formatter.field("owner_id", &self.owner_id);
        formatter.finish()
    }
}
/// See [`LocalGatewayRoute`](crate::model::LocalGatewayRoute)
pub mod local_gateway_route {
    /// A builder for [`LocalGatewayRoute`](crate::model::LocalGatewayRoute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) local_gateway_virtual_interface_group_id:
            std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LocalGatewayRouteType>,
        pub(crate) state: std::option::Option<crate::model::LocalGatewayRouteState>,
        pub(crate) local_gateway_route_table_id: std::option::Option<std::string::String>,
        pub(crate) local_gateway_route_table_arn: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CIDR block used for destination matches.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The CIDR block used for destination matches.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn local_gateway_virtual_interface_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_virtual_interface_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn set_local_gateway_virtual_interface_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_virtual_interface_group_id = input;
            self
        }
        /// <p>The route type.</p>
        pub fn r#type(mut self, input: crate::model::LocalGatewayRouteType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The route type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LocalGatewayRouteType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The state of the route.</p>
        pub fn state(mut self, input: crate::model::LocalGatewayRouteState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the route.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::LocalGatewayRouteState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn local_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the local gateway route table.</p>
        pub fn local_gateway_route_table_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_arn = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the local gateway route.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the local gateway route.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalGatewayRoute`](crate::model::LocalGatewayRoute)
        pub fn build(self) -> crate::model::LocalGatewayRoute {
            crate::model::LocalGatewayRoute {
                destination_cidr_block: self.destination_cidr_block,
                local_gateway_virtual_interface_group_id: self
                    .local_gateway_virtual_interface_group_id,
                r#type: self.r#type,
                state: self.state,
                local_gateway_route_table_id: self.local_gateway_route_table_id,
                local_gateway_route_table_arn: self.local_gateway_route_table_arn,
                owner_id: self.owner_id,
            }
        }
    }
}
impl LocalGatewayRoute {
    /// Creates a new builder-style object to manufacture [`LocalGatewayRoute`](crate::model::LocalGatewayRoute)
    pub fn builder() -> crate::model::local_gateway_route::Builder {
        crate::model::local_gateway_route::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocalGatewayRouteState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Blackhole,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocalGatewayRouteState {
    fn from(s: &str) -> Self {
        match s {
            "active" => LocalGatewayRouteState::Active,
            "blackhole" => LocalGatewayRouteState::Blackhole,
            "deleted" => LocalGatewayRouteState::Deleted,
            "deleting" => LocalGatewayRouteState::Deleting,
            "pending" => LocalGatewayRouteState::Pending,
            other => LocalGatewayRouteState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocalGatewayRouteState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocalGatewayRouteState::from(s))
    }
}
impl LocalGatewayRouteState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocalGatewayRouteState::Active => "active",
            LocalGatewayRouteState::Blackhole => "blackhole",
            LocalGatewayRouteState::Deleted => "deleted",
            LocalGatewayRouteState::Deleting => "deleting",
            LocalGatewayRouteState::Pending => "pending",
            LocalGatewayRouteState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "blackhole", "deleted", "deleting", "pending"]
    }
}
impl AsRef<str> for LocalGatewayRouteState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocalGatewayRouteType {
    #[allow(missing_docs)] // documentation missing in model
    Propagated,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocalGatewayRouteType {
    fn from(s: &str) -> Self {
        match s {
            "propagated" => LocalGatewayRouteType::Propagated,
            "static" => LocalGatewayRouteType::Static,
            other => LocalGatewayRouteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocalGatewayRouteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocalGatewayRouteType::from(s))
    }
}
impl LocalGatewayRouteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocalGatewayRouteType::Propagated => "propagated",
            LocalGatewayRouteType::Static => "static",
            LocalGatewayRouteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["propagated", "static"]
    }
}
impl AsRef<str> for LocalGatewayRouteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the launch specification for a Scheduled Instance.</p>
/// <p>If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesLaunchSpecification {
    /// <p>The block device mapping entries.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesBlockDeviceMapping>>,
    /// <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The IAM instance profile.</p>
    pub iam_instance_profile:
        std::option::Option<crate::model::ScheduledInstancesIamInstanceProfile>,
    /// <p>The ID of the Amazon Machine Image (AMI).</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The ID of the kernel.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>Enable or disable monitoring for the instances.</p>
    pub monitoring: std::option::Option<crate::model::ScheduledInstancesMonitoring>,
    /// <p>The network interfaces.</p>
    pub network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesNetworkInterface>>,
    /// <p>The placement information.</p>
    pub placement: std::option::Option<crate::model::ScheduledInstancesPlacement>,
    /// <p>The ID of the RAM disk.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the security groups.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the subnet in which to launch the instances.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The base64-encoded MIME user data.</p>
    pub user_data: std::option::Option<std::string::String>,
}
impl ScheduledInstancesLaunchSpecification {
    /// <p>The block device mapping entries.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledInstancesBlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The IAM instance profile.</p>
    pub fn iam_instance_profile(
        &self,
    ) -> std::option::Option<&crate::model::ScheduledInstancesIamInstanceProfile> {
        self.iam_instance_profile.as_ref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI).</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The ID of the kernel.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The name of the key pair.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>Enable or disable monitoring for the instances.</p>
    pub fn monitoring(&self) -> std::option::Option<&crate::model::ScheduledInstancesMonitoring> {
        self.monitoring.as_ref()
    }
    /// <p>The network interfaces.</p>
    pub fn network_interfaces(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledInstancesNetworkInterface]> {
        self.network_interfaces.as_deref()
    }
    /// <p>The placement information.</p>
    pub fn placement(&self) -> std::option::Option<&crate::model::ScheduledInstancesPlacement> {
        self.placement.as_ref()
    }
    /// <p>The ID of the RAM disk.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>The IDs of the security groups.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The ID of the subnet in which to launch the instances.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The base64-encoded MIME user data.</p>
    pub fn user_data(&self) -> std::option::Option<&str> {
        self.user_data.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesLaunchSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesLaunchSpecification");
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("monitoring", &self.monitoring);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("placement", &self.placement);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("user_data", &self.user_data);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesLaunchSpecification`](crate::model::ScheduledInstancesLaunchSpecification)
pub mod scheduled_instances_launch_specification {
    /// A builder for [`ScheduledInstancesLaunchSpecification`](crate::model::ScheduledInstancesLaunchSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesBlockDeviceMapping>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) iam_instance_profile:
            std::option::Option<crate::model::ScheduledInstancesIamInstanceProfile>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) monitoring: std::option::Option<crate::model::ScheduledInstancesMonitoring>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesNetworkInterface>>,
        pub(crate) placement: std::option::Option<crate::model::ScheduledInstancesPlacement>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) user_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mapping entries.</p>
        pub fn block_device_mappings(
            mut self,
            input: crate::model::ScheduledInstancesBlockDeviceMapping,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>The block device mapping entries.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ScheduledInstancesBlockDeviceMapping>,
            >,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn iam_instance_profile(
            mut self,
            input: crate::model::ScheduledInstancesIamInstanceProfile,
        ) -> Self {
            self.iam_instance_profile = Some(input);
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::ScheduledInstancesIamInstanceProfile>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI).</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI).</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the kernel.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The ID of the kernel.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// <p>Enable or disable monitoring for the instances.</p>
        pub fn monitoring(mut self, input: crate::model::ScheduledInstancesMonitoring) -> Self {
            self.monitoring = Some(input);
            self
        }
        /// <p>Enable or disable monitoring for the instances.</p>
        pub fn set_monitoring(
            mut self,
            input: std::option::Option<crate::model::ScheduledInstancesMonitoring>,
        ) -> Self {
            self.monitoring = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>The network interfaces.</p>
        pub fn network_interfaces(
            mut self,
            input: crate::model::ScheduledInstancesNetworkInterface,
        ) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>The network interfaces.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ScheduledInstancesNetworkInterface>,
            >,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// <p>The placement information.</p>
        pub fn placement(mut self, input: crate::model::ScheduledInstancesPlacement) -> Self {
            self.placement = Some(input);
            self
        }
        /// <p>The placement information.</p>
        pub fn set_placement(
            mut self,
            input: std::option::Option<crate::model::ScheduledInstancesPlacement>,
        ) -> Self {
            self.placement = input;
            self
        }
        /// <p>The ID of the RAM disk.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The ID of the RAM disk.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The ID of the subnet in which to launch the instances.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet in which to launch the instances.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The base64-encoded MIME user data.</p>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>The base64-encoded MIME user data.</p>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesLaunchSpecification`](crate::model::ScheduledInstancesLaunchSpecification)
        pub fn build(self) -> crate::model::ScheduledInstancesLaunchSpecification {
            crate::model::ScheduledInstancesLaunchSpecification {
                block_device_mappings: self.block_device_mappings,
                ebs_optimized: self.ebs_optimized,
                iam_instance_profile: self.iam_instance_profile,
                image_id: self.image_id,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                key_name: self.key_name,
                monitoring: self.monitoring,
                network_interfaces: self.network_interfaces,
                placement: self.placement,
                ramdisk_id: self.ramdisk_id,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                user_data: self.user_data,
            }
        }
    }
}
impl ScheduledInstancesLaunchSpecification {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesLaunchSpecification`](crate::model::ScheduledInstancesLaunchSpecification)
    pub fn builder() -> crate::model::scheduled_instances_launch_specification::Builder {
        crate::model::scheduled_instances_launch_specification::Builder::default()
    }
}

/// <p>Describes the placement for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesPlacement {
    /// <p>The Availability Zone.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The name of the placement group.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl ScheduledInstancesPlacement {
    /// <p>The Availability Zone.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The name of the placement group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesPlacement");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesPlacement`](crate::model::ScheduledInstancesPlacement)
pub mod scheduled_instances_placement {
    /// A builder for [`ScheduledInstancesPlacement`](crate::model::ScheduledInstancesPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The name of the placement group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the placement group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesPlacement`](crate::model::ScheduledInstancesPlacement)
        pub fn build(self) -> crate::model::ScheduledInstancesPlacement {
            crate::model::ScheduledInstancesPlacement {
                availability_zone: self.availability_zone,
                group_name: self.group_name,
            }
        }
    }
}
impl ScheduledInstancesPlacement {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesPlacement`](crate::model::ScheduledInstancesPlacement)
    pub fn builder() -> crate::model::scheduled_instances_placement::Builder {
        crate::model::scheduled_instances_placement::Builder::default()
    }
}

/// <p>Describes a network interface for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesNetworkInterface {
    /// <p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>Indicates whether to delete the interface when the instance is terminated.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The index of the device for the network interface attachment.</p>
    pub device_index: std::option::Option<i32>,
    /// <p>The IDs of the security groups.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>
    pub ipv6_address_count: std::option::Option<i32>,
    /// <p>The specific IPv6 addresses from the subnet range.</p>
    pub ipv6_addresses:
        std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesIpv6Address>>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The private IPv4 addresses.</p>
    pub private_ip_address_configs:
        std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesPrivateIpAddressConfig>>,
    /// <p>The number of secondary private IPv4 addresses.</p>
    pub secondary_private_ip_address_count: std::option::Option<i32>,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
}
impl ScheduledInstancesNetworkInterface {
    /// <p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
    pub fn associate_public_ip_address(&self) -> std::option::Option<bool> {
        self.associate_public_ip_address
    }
    /// <p>Indicates whether to delete the interface when the instance is terminated.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The index of the device for the network interface attachment.</p>
    pub fn device_index(&self) -> std::option::Option<i32> {
        self.device_index
    }
    /// <p>The IDs of the security groups.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>
    pub fn ipv6_address_count(&self) -> std::option::Option<i32> {
        self.ipv6_address_count
    }
    /// <p>The specific IPv6 addresses from the subnet range.</p>
    pub fn ipv6_addresses(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledInstancesIpv6Address]> {
        self.ipv6_addresses.as_deref()
    }
    /// <p>The ID of the network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The private IPv4 addresses.</p>
    pub fn private_ip_address_configs(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledInstancesPrivateIpAddressConfig]> {
        self.private_ip_address_configs.as_deref()
    }
    /// <p>The number of secondary private IPv4 addresses.</p>
    pub fn secondary_private_ip_address_count(&self) -> std::option::Option<i32> {
        self.secondary_private_ip_address_count
    }
    /// <p>The ID of the subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesNetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesNetworkInterface");
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("description", &self.description);
        formatter.field("device_index", &self.device_index);
        formatter.field("groups", &self.groups);
        formatter.field("ipv6_address_count", &self.ipv6_address_count);
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field(
            "private_ip_address_configs",
            &self.private_ip_address_configs,
        );
        formatter.field(
            "secondary_private_ip_address_count",
            &self.secondary_private_ip_address_count,
        );
        formatter.field("subnet_id", &self.subnet_id);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesNetworkInterface`](crate::model::ScheduledInstancesNetworkInterface)
pub mod scheduled_instances_network_interface {
    /// A builder for [`ScheduledInstancesNetworkInterface`](crate::model::ScheduledInstancesNetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) device_index: std::option::Option<i32>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_address_count: std::option::Option<i32>,
        pub(crate) ipv6_addresses:
            std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesIpv6Address>>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_address_configs: std::option::Option<
            std::vec::Vec<crate::model::ScheduledInstancesPrivateIpAddressConfig>,
        >,
        pub(crate) secondary_private_ip_address_count: std::option::Option<i32>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>Indicates whether to delete the interface when the instance is terminated.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether to delete the interface when the instance is terminated.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn device_index(mut self, input: i32) -> Self {
            self.device_index = Some(input);
            self
        }
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn set_device_index(mut self, input: std::option::Option<i32>) -> Self {
            self.device_index = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The IDs of the security groups.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.ipv6_address_count = Some(input);
            self
        }
        /// <p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_address_count = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>The specific IPv6 addresses from the subnet range.</p>
        pub fn ipv6_addresses(
            mut self,
            input: crate::model::ScheduledInstancesIpv6Address,
        ) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input);
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>The specific IPv6 addresses from the subnet range.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledInstancesIpv6Address>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_address_configs`.
        ///
        /// To override the contents of this collection use [`set_private_ip_address_configs`](Self::set_private_ip_address_configs).
        ///
        /// <p>The private IPv4 addresses.</p>
        pub fn private_ip_address_configs(
            mut self,
            input: crate::model::ScheduledInstancesPrivateIpAddressConfig,
        ) -> Self {
            let mut v = self.private_ip_address_configs.unwrap_or_default();
            v.push(input);
            self.private_ip_address_configs = Some(v);
            self
        }
        /// <p>The private IPv4 addresses.</p>
        pub fn set_private_ip_address_configs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ScheduledInstancesPrivateIpAddressConfig>,
            >,
        ) -> Self {
            self.private_ip_address_configs = input;
            self
        }
        /// <p>The number of secondary private IPv4 addresses.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.secondary_private_ip_address_count = Some(input);
            self
        }
        /// <p>The number of secondary private IPv4 addresses.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.secondary_private_ip_address_count = input;
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesNetworkInterface`](crate::model::ScheduledInstancesNetworkInterface)
        pub fn build(self) -> crate::model::ScheduledInstancesNetworkInterface {
            crate::model::ScheduledInstancesNetworkInterface {
                associate_public_ip_address: self.associate_public_ip_address,
                delete_on_termination: self.delete_on_termination,
                description: self.description,
                device_index: self.device_index,
                groups: self.groups,
                ipv6_address_count: self.ipv6_address_count,
                ipv6_addresses: self.ipv6_addresses,
                network_interface_id: self.network_interface_id,
                private_ip_address: self.private_ip_address,
                private_ip_address_configs: self.private_ip_address_configs,
                secondary_private_ip_address_count: self.secondary_private_ip_address_count,
                subnet_id: self.subnet_id,
            }
        }
    }
}
impl ScheduledInstancesNetworkInterface {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesNetworkInterface`](crate::model::ScheduledInstancesNetworkInterface)
    pub fn builder() -> crate::model::scheduled_instances_network_interface::Builder {
        crate::model::scheduled_instances_network_interface::Builder::default()
    }
}

/// <p>Describes a private IPv4 address for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesPrivateIpAddressConfig {
    /// <p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>
    pub primary: std::option::Option<bool>,
    /// <p>The IPv4 address.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
}
impl ScheduledInstancesPrivateIpAddressConfig {
    /// <p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>
    pub fn primary(&self) -> std::option::Option<bool> {
        self.primary
    }
    /// <p>The IPv4 address.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesPrivateIpAddressConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesPrivateIpAddressConfig");
        formatter.field("primary", &self.primary);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesPrivateIpAddressConfig`](crate::model::ScheduledInstancesPrivateIpAddressConfig)
pub mod scheduled_instances_private_ip_address_config {
    /// A builder for [`ScheduledInstancesPrivateIpAddressConfig`](crate::model::ScheduledInstancesPrivateIpAddressConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary: std::option::Option<bool>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>
        pub fn primary(mut self, input: bool) -> Self {
            self.primary = Some(input);
            self
        }
        /// <p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>
        pub fn set_primary(mut self, input: std::option::Option<bool>) -> Self {
            self.primary = input;
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesPrivateIpAddressConfig`](crate::model::ScheduledInstancesPrivateIpAddressConfig)
        pub fn build(self) -> crate::model::ScheduledInstancesPrivateIpAddressConfig {
            crate::model::ScheduledInstancesPrivateIpAddressConfig {
                primary: self.primary,
                private_ip_address: self.private_ip_address,
            }
        }
    }
}
impl ScheduledInstancesPrivateIpAddressConfig {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesPrivateIpAddressConfig`](crate::model::ScheduledInstancesPrivateIpAddressConfig)
    pub fn builder() -> crate::model::scheduled_instances_private_ip_address_config::Builder {
        crate::model::scheduled_instances_private_ip_address_config::Builder::default()
    }
}

/// <p>Describes an IPv6 address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesIpv6Address {
    /// <p>The IPv6 address.</p>
    pub ipv6_address: std::option::Option<std::string::String>,
}
impl ScheduledInstancesIpv6Address {
    /// <p>The IPv6 address.</p>
    pub fn ipv6_address(&self) -> std::option::Option<&str> {
        self.ipv6_address.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesIpv6Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesIpv6Address");
        formatter.field("ipv6_address", &self.ipv6_address);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesIpv6Address`](crate::model::ScheduledInstancesIpv6Address)
pub mod scheduled_instances_ipv6_address {
    /// A builder for [`ScheduledInstancesIpv6Address`](crate::model::ScheduledInstancesIpv6Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv6 address.</p>
        pub fn ipv6_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_address = Some(input.into());
            self
        }
        /// <p>The IPv6 address.</p>
        pub fn set_ipv6_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_address = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesIpv6Address`](crate::model::ScheduledInstancesIpv6Address)
        pub fn build(self) -> crate::model::ScheduledInstancesIpv6Address {
            crate::model::ScheduledInstancesIpv6Address {
                ipv6_address: self.ipv6_address,
            }
        }
    }
}
impl ScheduledInstancesIpv6Address {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesIpv6Address`](crate::model::ScheduledInstancesIpv6Address)
    pub fn builder() -> crate::model::scheduled_instances_ipv6_address::Builder {
        crate::model::scheduled_instances_ipv6_address::Builder::default()
    }
}

/// <p>Describes whether monitoring is enabled for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesMonitoring {
    /// <p>Indicates whether monitoring is enabled.</p>
    pub enabled: std::option::Option<bool>,
}
impl ScheduledInstancesMonitoring {
    /// <p>Indicates whether monitoring is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for ScheduledInstancesMonitoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesMonitoring");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesMonitoring`](crate::model::ScheduledInstancesMonitoring)
pub mod scheduled_instances_monitoring {
    /// A builder for [`ScheduledInstancesMonitoring`](crate::model::ScheduledInstancesMonitoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether monitoring is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether monitoring is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesMonitoring`](crate::model::ScheduledInstancesMonitoring)
        pub fn build(self) -> crate::model::ScheduledInstancesMonitoring {
            crate::model::ScheduledInstancesMonitoring {
                enabled: self.enabled,
            }
        }
    }
}
impl ScheduledInstancesMonitoring {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesMonitoring`](crate::model::ScheduledInstancesMonitoring)
    pub fn builder() -> crate::model::scheduled_instances_monitoring::Builder {
        crate::model::scheduled_instances_monitoring::Builder::default()
    }
}

/// <p>Describes an IAM instance profile for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesIamInstanceProfile {
    /// <p>The Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ScheduledInstancesIamInstanceProfile {
    /// <p>The Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesIamInstanceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesIamInstanceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesIamInstanceProfile`](crate::model::ScheduledInstancesIamInstanceProfile)
pub mod scheduled_instances_iam_instance_profile {
    /// A builder for [`ScheduledInstancesIamInstanceProfile`](crate::model::ScheduledInstancesIamInstanceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesIamInstanceProfile`](crate::model::ScheduledInstancesIamInstanceProfile)
        pub fn build(self) -> crate::model::ScheduledInstancesIamInstanceProfile {
            crate::model::ScheduledInstancesIamInstanceProfile {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl ScheduledInstancesIamInstanceProfile {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesIamInstanceProfile`](crate::model::ScheduledInstancesIamInstanceProfile)
    pub fn builder() -> crate::model::scheduled_instances_iam_instance_profile::Builder {
        crate::model::scheduled_instances_iam_instance_profile::Builder::default()
    }
}

/// <p>Describes a block device mapping for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesBlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>
    pub ebs: std::option::Option<crate::model::ScheduledInstancesEbs>,
    /// <p>To omit the device from the block device mapping, specify an empty string.</p>
    pub no_device: std::option::Option<std::string::String>,
    /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
    /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
    pub virtual_name: std::option::Option<std::string::String>,
}
impl ScheduledInstancesBlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::ScheduledInstancesEbs> {
        self.ebs.as_ref()
    }
    /// <p>To omit the device from the block device mapping, specify an empty string.</p>
    pub fn no_device(&self) -> std::option::Option<&str> {
        self.no_device.as_deref()
    }
    /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
    /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
    pub fn virtual_name(&self) -> std::option::Option<&str> {
        self.virtual_name.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesBlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesBlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.field("no_device", &self.no_device);
        formatter.field("virtual_name", &self.virtual_name);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesBlockDeviceMapping`](crate::model::ScheduledInstancesBlockDeviceMapping)
pub mod scheduled_instances_block_device_mapping {
    /// A builder for [`ScheduledInstancesBlockDeviceMapping`](crate::model::ScheduledInstancesBlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::ScheduledInstancesEbs>,
        pub(crate) no_device: std::option::Option<std::string::String>,
        pub(crate) virtual_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>
        pub fn ebs(mut self, input: crate::model::ScheduledInstancesEbs) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>
        pub fn set_ebs(
            mut self,
            input: std::option::Option<crate::model::ScheduledInstancesEbs>,
        ) -> Self {
            self.ebs = input;
            self
        }
        /// <p>To omit the device from the block device mapping, specify an empty string.</p>
        pub fn no_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.no_device = Some(input.into());
            self
        }
        /// <p>To omit the device from the block device mapping, specify an empty string.</p>
        pub fn set_no_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.no_device = input;
            self
        }
        /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
        /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
        /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesBlockDeviceMapping`](crate::model::ScheduledInstancesBlockDeviceMapping)
        pub fn build(self) -> crate::model::ScheduledInstancesBlockDeviceMapping {
            crate::model::ScheduledInstancesBlockDeviceMapping {
                device_name: self.device_name,
                ebs: self.ebs,
                no_device: self.no_device,
                virtual_name: self.virtual_name,
            }
        }
    }
}
impl ScheduledInstancesBlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesBlockDeviceMapping`](crate::model::ScheduledInstancesBlockDeviceMapping)
    pub fn builder() -> crate::model::scheduled_instances_block_device_mapping::Builder {
        crate::model::scheduled_instances_block_device_mapping::Builder::default()
    }
}

/// <p>Describes an EBS volume for a Scheduled Instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledInstancesEbs {
    /// <p>Indicates whether the volume is deleted on instance termination.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The number of I/O operations per second (IOPS) to provision for an <code>io1</code> or <code>io2</code> volume, with a maximum ratio of 50 IOPS/GiB for <code>io1</code>, and 500 IOPS/GiB for <code>io2</code>. Range is 100 to 64,000 IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p>This parameter is valid only for Provisioned IOPS SSD (<code>io1</code> and <code>io2</code>) volumes.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The size of the volume, in GiB.</p>
    /// <p>Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.</p>
    pub volume_size: std::option::Option<i32>,
    /// <p>The volume type. <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code> io2</code> for Provisioned IOPS SSD, Throughput Optimized HDD for <code>st1</code>, Cold HDD for <code>sc1</code>, or <code>standard</code> for Magnetic.</p>
    /// <p>Default: <code>gp2</code> </p>
    pub volume_type: std::option::Option<std::string::String>,
}
impl ScheduledInstancesEbs {
    /// <p>Indicates whether the volume is deleted on instance termination.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The number of I/O operations per second (IOPS) to provision for an <code>io1</code> or <code>io2</code> volume, with a maximum ratio of 50 IOPS/GiB for <code>io1</code>, and 500 IOPS/GiB for <code>io2</code>. Range is 100 to 64,000 IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p>This parameter is valid only for Provisioned IOPS SSD (<code>io1</code> and <code>io2</code>) volumes.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>The ID of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The size of the volume, in GiB.</p>
    /// <p>Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.</p>
    pub fn volume_size(&self) -> std::option::Option<i32> {
        self.volume_size
    }
    /// <p>The volume type. <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code> io2</code> for Provisioned IOPS SSD, Throughput Optimized HDD for <code>st1</code>, Cold HDD for <code>sc1</code>, or <code>standard</code> for Magnetic.</p>
    /// <p>Default: <code>gp2</code> </p>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
}
impl std::fmt::Debug for ScheduledInstancesEbs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledInstancesEbs");
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("iops", &self.iops);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.finish()
    }
}
/// See [`ScheduledInstancesEbs`](crate::model::ScheduledInstancesEbs)
pub mod scheduled_instances_ebs {
    /// A builder for [`ScheduledInstancesEbs`](crate::model::ScheduledInstancesEbs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the volume is deleted on instance termination.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether the volume is deleted on instance termination.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The number of I/O operations per second (IOPS) to provision for an <code>io1</code> or <code>io2</code> volume, with a maximum ratio of 50 IOPS/GiB for <code>io1</code>, and 500 IOPS/GiB for <code>io2</code>. Range is 100 to 64,000 IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>This parameter is valid only for Provisioned IOPS SSD (<code>io1</code> and <code>io2</code>) volumes.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of I/O operations per second (IOPS) to provision for an <code>io1</code> or <code>io2</code> volume, with a maximum ratio of 50 IOPS/GiB for <code>io1</code>, and 500 IOPS/GiB for <code>io2</code>. Range is 100 to 64,000 IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>This parameter is valid only for Provisioned IOPS SSD (<code>io1</code> and <code>io2</code>) volumes.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The size of the volume, in GiB.</p>
        /// <p>Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The size of the volume, in GiB.</p>
        /// <p>Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the snapshot size.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The volume type. <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code> io2</code> for Provisioned IOPS SSD, Throughput Optimized HDD for <code>st1</code>, Cold HDD for <code>sc1</code>, or <code>standard</code> for Magnetic.</p>
        /// <p>Default: <code>gp2</code> </p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type. <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code> io2</code> for Provisioned IOPS SSD, Throughput Optimized HDD for <code>st1</code>, Cold HDD for <code>sc1</code>, or <code>standard</code> for Magnetic.</p>
        /// <p>Default: <code>gp2</code> </p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledInstancesEbs`](crate::model::ScheduledInstancesEbs)
        pub fn build(self) -> crate::model::ScheduledInstancesEbs {
            crate::model::ScheduledInstancesEbs {
                delete_on_termination: self.delete_on_termination,
                encrypted: self.encrypted,
                iops: self.iops,
                snapshot_id: self.snapshot_id,
                volume_size: self.volume_size,
                volume_type: self.volume_type,
            }
        }
    }
}
impl ScheduledInstancesEbs {
    /// Creates a new builder-style object to manufacture [`ScheduledInstancesEbs`](crate::model::ScheduledInstancesEbs)
    pub fn builder() -> crate::model::scheduled_instances_ebs::Builder {
        crate::model::scheduled_instances_ebs::Builder::default()
    }
}

/// <p>Describes an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The AMI launch index, which can be used to find this instance in the launch group.</p>
    pub ami_launch_index: std::option::Option<i32>,
    /// <p>The ID of the AMI used to launch the instance.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<crate::model::InstanceType>,
    /// <p>The kernel associated with this instance, if applicable.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair, if this instance was launched with an associated key pair.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>The time the instance was launched.</p>
    pub launch_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The monitoring for the instance.</p>
    pub monitoring: std::option::Option<crate::model::Monitoring>,
    /// <p>The location where the instance launched, if applicable.</p>
    pub placement: std::option::Option<crate::model::Placement>,
    /// <p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>
    pub platform: std::option::Option<crate::model::PlatformValues>,
    /// <p>(IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state. </p>
    /// <p>[EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IPv4 address assigned to the instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The product codes attached to this instance, if applicable.</p>
    pub product_codes: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
    /// <p>(IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.</p>
    pub public_dns_name: std::option::Option<std::string::String>,
    /// <p>The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
    /// <p>A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
    /// <p>The RAM disk associated with this instance, if applicable.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>The current state of the instance.</p>
    pub state: std::option::Option<crate::model::InstanceState>,
    /// <p>The reason for the most recent state transition. This might be an empty string.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>[EC2-VPC] The ID of the subnet in which the instance is running.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>[EC2-VPC] The ID of the VPC in which the instance is running.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The architecture of the image.</p>
    pub architecture: std::option::Option<crate::model::ArchitectureValues>,
    /// <p>Any block device mapping entries for the instance.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
    /// <p>The idempotency token you provided when you launched the instance, if applicable.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>Specifies whether enhanced networking with ENA is enabled.</p>
    pub ena_support: std::option::Option<bool>,
    /// <p>The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p>
    pub hypervisor: std::option::Option<crate::model::HypervisorType>,
    /// <p>The IAM instance profile associated with the instance, if applicable.</p>
    pub iam_instance_profile: std::option::Option<crate::model::IamInstanceProfile>,
    /// <p>Indicates whether this is a Spot Instance or a Scheduled Instance.</p>
    pub instance_lifecycle: std::option::Option<crate::model::InstanceLifecycleType>,
    /// <p>The Elastic GPU associated with the instance.</p>
    pub elastic_gpu_associations:
        std::option::Option<std::vec::Vec<crate::model::ElasticGpuAssociation>>,
    /// <p> The elastic inference accelerator associated with the instance.</p>
    pub elastic_inference_accelerator_associations:
        std::option::Option<std::vec::Vec<crate::model::ElasticInferenceAcceleratorAssociation>>,
    /// <p>[EC2-VPC] The network interfaces for the instance.</p>
    pub network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterface>>,
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
    pub root_device_name: std::option::Option<std::string::String>,
    /// <p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>
    pub root_device_type: std::option::Option<crate::model::DeviceType>,
    /// <p>The security groups for the instance.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
    /// <p>Indicates whether source/destination checking is enabled.</p>
    pub source_dest_check: std::option::Option<bool>,
    /// <p>If the request is a Spot Instance request, the ID of the request.</p>
    pub spot_instance_request_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
    pub sriov_net_support: std::option::Option<std::string::String>,
    /// <p>The reason for the most recent state transition.</p>
    pub state_reason: std::option::Option<crate::model::StateReason>,
    /// <p>Any tags assigned to the instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The virtualization type of the instance.</p>
    pub virtualization_type: std::option::Option<crate::model::VirtualizationType>,
    /// <p>The CPU options for the instance.</p>
    pub cpu_options: std::option::Option<crate::model::CpuOptions>,
    /// <p>The ID of the Capacity Reservation.</p>
    pub capacity_reservation_id: std::option::Option<std::string::String>,
    /// <p>Information about the Capacity Reservation targeting option.</p>
    pub capacity_reservation_specification:
        std::option::Option<crate::model::CapacityReservationSpecificationResponse>,
    /// <p>Indicates whether the instance is enabled for hibernation.</p>
    pub hibernation_options: std::option::Option<crate::model::HibernationOptions>,
    /// <p>The license configurations for the instance.</p>
    pub licenses: std::option::Option<std::vec::Vec<crate::model::LicenseConfiguration>>,
    /// <p>The metadata options for the instance.</p>
    pub metadata_options: std::option::Option<crate::model::InstanceMetadataOptionsResponse>,
    /// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>
    pub enclave_options: std::option::Option<crate::model::EnclaveOptions>,
    /// <p>The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub boot_mode: std::option::Option<crate::model::BootModeValues>,
    /// <p>The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub platform_details: std::option::Option<std::string::String>,
    /// <p>The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub usage_operation: std::option::Option<std::string::String>,
    /// <p>The time that the usage operation was last updated.</p>
    pub usage_operation_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The options for the instance hostname.</p>
    pub private_dns_name_options: std::option::Option<crate::model::PrivateDnsNameOptionsResponse>,
    /// <p>The IPv6 address assigned to the instance.</p>
    pub ipv6_address: std::option::Option<std::string::String>,
}
impl Instance {
    /// <p>The AMI launch index, which can be used to find this instance in the launch group.</p>
    pub fn ami_launch_index(&self) -> std::option::Option<i32> {
        self.ami_launch_index
    }
    /// <p>The ID of the AMI used to launch the instance.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The kernel associated with this instance, if applicable.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The name of the key pair, if this instance was launched with an associated key pair.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>The time the instance was launched.</p>
    pub fn launch_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.launch_time.as_ref()
    }
    /// <p>The monitoring for the instance.</p>
    pub fn monitoring(&self) -> std::option::Option<&crate::model::Monitoring> {
        self.monitoring.as_ref()
    }
    /// <p>The location where the instance launched, if applicable.</p>
    pub fn placement(&self) -> std::option::Option<&crate::model::Placement> {
        self.placement.as_ref()
    }
    /// <p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformValues> {
        self.platform.as_ref()
    }
    /// <p>(IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state. </p>
    /// <p>[EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.</p>
    pub fn private_dns_name(&self) -> std::option::Option<&str> {
        self.private_dns_name.as_deref()
    }
    /// <p>The private IPv4 address assigned to the instance.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The product codes attached to this instance, if applicable.</p>
    pub fn product_codes(&self) -> std::option::Option<&[crate::model::ProductCode]> {
        self.product_codes.as_deref()
    }
    /// <p>(IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.</p>
    pub fn public_dns_name(&self) -> std::option::Option<&str> {
        self.public_dns_name.as_deref()
    }
    /// <p>The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
    /// <p>A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.</p>
    pub fn public_ip_address(&self) -> std::option::Option<&str> {
        self.public_ip_address.as_deref()
    }
    /// <p>The RAM disk associated with this instance, if applicable.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>The current state of the instance.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::InstanceState> {
        self.state.as_ref()
    }
    /// <p>The reason for the most recent state transition. This might be an empty string.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>[EC2-VPC] The ID of the subnet in which the instance is running.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>[EC2-VPC] The ID of the VPC in which the instance is running.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The architecture of the image.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::ArchitectureValues> {
        self.architecture.as_ref()
    }
    /// <p>Any block device mapping entries for the instance.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceBlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>The idempotency token you provided when you launched the instance, if applicable.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>Specifies whether enhanced networking with ENA is enabled.</p>
    pub fn ena_support(&self) -> std::option::Option<bool> {
        self.ena_support
    }
    /// <p>The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p>
    pub fn hypervisor(&self) -> std::option::Option<&crate::model::HypervisorType> {
        self.hypervisor.as_ref()
    }
    /// <p>The IAM instance profile associated with the instance, if applicable.</p>
    pub fn iam_instance_profile(&self) -> std::option::Option<&crate::model::IamInstanceProfile> {
        self.iam_instance_profile.as_ref()
    }
    /// <p>Indicates whether this is a Spot Instance or a Scheduled Instance.</p>
    pub fn instance_lifecycle(&self) -> std::option::Option<&crate::model::InstanceLifecycleType> {
        self.instance_lifecycle.as_ref()
    }
    /// <p>The Elastic GPU associated with the instance.</p>
    pub fn elastic_gpu_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ElasticGpuAssociation]> {
        self.elastic_gpu_associations.as_deref()
    }
    /// <p> The elastic inference accelerator associated with the instance.</p>
    pub fn elastic_inference_accelerator_associations(
        &self,
    ) -> std::option::Option<&[crate::model::ElasticInferenceAcceleratorAssociation]> {
        self.elastic_inference_accelerator_associations.as_deref()
    }
    /// <p>[EC2-VPC] The network interfaces for the instance.</p>
    pub fn network_interfaces(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceNetworkInterface]> {
        self.network_interfaces.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub fn outpost_arn(&self) -> std::option::Option<&str> {
        self.outpost_arn.as_deref()
    }
    /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
    pub fn root_device_name(&self) -> std::option::Option<&str> {
        self.root_device_name.as_deref()
    }
    /// <p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>
    pub fn root_device_type(&self) -> std::option::Option<&crate::model::DeviceType> {
        self.root_device_type.as_ref()
    }
    /// <p>The security groups for the instance.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::GroupIdentifier]> {
        self.security_groups.as_deref()
    }
    /// <p>Indicates whether source/destination checking is enabled.</p>
    pub fn source_dest_check(&self) -> std::option::Option<bool> {
        self.source_dest_check
    }
    /// <p>If the request is a Spot Instance request, the ID of the request.</p>
    pub fn spot_instance_request_id(&self) -> std::option::Option<&str> {
        self.spot_instance_request_id.as_deref()
    }
    /// <p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
    pub fn sriov_net_support(&self) -> std::option::Option<&str> {
        self.sriov_net_support.as_deref()
    }
    /// <p>The reason for the most recent state transition.</p>
    pub fn state_reason(&self) -> std::option::Option<&crate::model::StateReason> {
        self.state_reason.as_ref()
    }
    /// <p>Any tags assigned to the instance.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The virtualization type of the instance.</p>
    pub fn virtualization_type(&self) -> std::option::Option<&crate::model::VirtualizationType> {
        self.virtualization_type.as_ref()
    }
    /// <p>The CPU options for the instance.</p>
    pub fn cpu_options(&self) -> std::option::Option<&crate::model::CpuOptions> {
        self.cpu_options.as_ref()
    }
    /// <p>The ID of the Capacity Reservation.</p>
    pub fn capacity_reservation_id(&self) -> std::option::Option<&str> {
        self.capacity_reservation_id.as_deref()
    }
    /// <p>Information about the Capacity Reservation targeting option.</p>
    pub fn capacity_reservation_specification(
        &self,
    ) -> std::option::Option<&crate::model::CapacityReservationSpecificationResponse> {
        self.capacity_reservation_specification.as_ref()
    }
    /// <p>Indicates whether the instance is enabled for hibernation.</p>
    pub fn hibernation_options(&self) -> std::option::Option<&crate::model::HibernationOptions> {
        self.hibernation_options.as_ref()
    }
    /// <p>The license configurations for the instance.</p>
    pub fn licenses(&self) -> std::option::Option<&[crate::model::LicenseConfiguration]> {
        self.licenses.as_deref()
    }
    /// <p>The metadata options for the instance.</p>
    pub fn metadata_options(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataOptionsResponse> {
        self.metadata_options.as_ref()
    }
    /// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>
    pub fn enclave_options(&self) -> std::option::Option<&crate::model::EnclaveOptions> {
        self.enclave_options.as_ref()
    }
    /// <p>The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub fn boot_mode(&self) -> std::option::Option<&crate::model::BootModeValues> {
        self.boot_mode.as_ref()
    }
    /// <p>The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub fn platform_details(&self) -> std::option::Option<&str> {
        self.platform_details.as_deref()
    }
    /// <p>The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub fn usage_operation(&self) -> std::option::Option<&str> {
        self.usage_operation.as_deref()
    }
    /// <p>The time that the usage operation was last updated.</p>
    pub fn usage_operation_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.usage_operation_update_time.as_ref()
    }
    /// <p>The options for the instance hostname.</p>
    pub fn private_dns_name_options(
        &self,
    ) -> std::option::Option<&crate::model::PrivateDnsNameOptionsResponse> {
        self.private_dns_name_options.as_ref()
    }
    /// <p>The IPv6 address assigned to the instance.</p>
    pub fn ipv6_address(&self) -> std::option::Option<&str> {
        self.ipv6_address.as_deref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("ami_launch_index", &self.ami_launch_index);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("launch_time", &self.launch_time);
        formatter.field("monitoring", &self.monitoring);
        formatter.field("placement", &self.placement);
        formatter.field("platform", &self.platform);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("product_codes", &self.product_codes);
        formatter.field("public_dns_name", &self.public_dns_name);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("architecture", &self.architecture);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("client_token", &self.client_token);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("ena_support", &self.ena_support);
        formatter.field("hypervisor", &self.hypervisor);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("instance_lifecycle", &self.instance_lifecycle);
        formatter.field("elastic_gpu_associations", &self.elastic_gpu_associations);
        formatter.field(
            "elastic_inference_accelerator_associations",
            &self.elastic_inference_accelerator_associations,
        );
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("root_device_name", &self.root_device_name);
        formatter.field("root_device_type", &self.root_device_type);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("source_dest_check", &self.source_dest_check);
        formatter.field("spot_instance_request_id", &self.spot_instance_request_id);
        formatter.field("sriov_net_support", &self.sriov_net_support);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("tags", &self.tags);
        formatter.field("virtualization_type", &self.virtualization_type);
        formatter.field("cpu_options", &self.cpu_options);
        formatter.field("capacity_reservation_id", &self.capacity_reservation_id);
        formatter.field(
            "capacity_reservation_specification",
            &self.capacity_reservation_specification,
        );
        formatter.field("hibernation_options", &self.hibernation_options);
        formatter.field("licenses", &self.licenses);
        formatter.field("metadata_options", &self.metadata_options);
        formatter.field("enclave_options", &self.enclave_options);
        formatter.field("boot_mode", &self.boot_mode);
        formatter.field("platform_details", &self.platform_details);
        formatter.field("usage_operation", &self.usage_operation);
        formatter.field(
            "usage_operation_update_time",
            &self.usage_operation_update_time,
        );
        formatter.field("private_dns_name_options", &self.private_dns_name_options);
        formatter.field("ipv6_address", &self.ipv6_address);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ami_launch_index: std::option::Option<i32>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::InstanceType>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) launch_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring: std::option::Option<crate::model::Monitoring>,
        pub(crate) placement: std::option::Option<crate::model::Placement>,
        pub(crate) platform: std::option::Option<crate::model::PlatformValues>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) product_codes: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
        pub(crate) public_dns_name: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::InstanceState>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::ArchitectureValues>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) ena_support: std::option::Option<bool>,
        pub(crate) hypervisor: std::option::Option<crate::model::HypervisorType>,
        pub(crate) iam_instance_profile: std::option::Option<crate::model::IamInstanceProfile>,
        pub(crate) instance_lifecycle: std::option::Option<crate::model::InstanceLifecycleType>,
        pub(crate) elastic_gpu_associations:
            std::option::Option<std::vec::Vec<crate::model::ElasticGpuAssociation>>,
        pub(crate) elastic_inference_accelerator_associations: std::option::Option<
            std::vec::Vec<crate::model::ElasticInferenceAcceleratorAssociation>,
        >,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterface>>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) root_device_name: std::option::Option<std::string::String>,
        pub(crate) root_device_type: std::option::Option<crate::model::DeviceType>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        pub(crate) source_dest_check: std::option::Option<bool>,
        pub(crate) spot_instance_request_id: std::option::Option<std::string::String>,
        pub(crate) sriov_net_support: std::option::Option<std::string::String>,
        pub(crate) state_reason: std::option::Option<crate::model::StateReason>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) virtualization_type: std::option::Option<crate::model::VirtualizationType>,
        pub(crate) cpu_options: std::option::Option<crate::model::CpuOptions>,
        pub(crate) capacity_reservation_id: std::option::Option<std::string::String>,
        pub(crate) capacity_reservation_specification:
            std::option::Option<crate::model::CapacityReservationSpecificationResponse>,
        pub(crate) hibernation_options: std::option::Option<crate::model::HibernationOptions>,
        pub(crate) licenses: std::option::Option<std::vec::Vec<crate::model::LicenseConfiguration>>,
        pub(crate) metadata_options:
            std::option::Option<crate::model::InstanceMetadataOptionsResponse>,
        pub(crate) enclave_options: std::option::Option<crate::model::EnclaveOptions>,
        pub(crate) boot_mode: std::option::Option<crate::model::BootModeValues>,
        pub(crate) platform_details: std::option::Option<std::string::String>,
        pub(crate) usage_operation: std::option::Option<std::string::String>,
        pub(crate) usage_operation_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) private_dns_name_options:
            std::option::Option<crate::model::PrivateDnsNameOptionsResponse>,
        pub(crate) ipv6_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AMI launch index, which can be used to find this instance in the launch group.</p>
        pub fn ami_launch_index(mut self, input: i32) -> Self {
            self.ami_launch_index = Some(input);
            self
        }
        /// <p>The AMI launch index, which can be used to find this instance in the launch group.</p>
        pub fn set_ami_launch_index(mut self, input: std::option::Option<i32>) -> Self {
            self.ami_launch_index = input;
            self
        }
        /// <p>The ID of the AMI used to launch the instance.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI used to launch the instance.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The kernel associated with this instance, if applicable.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The kernel associated with this instance, if applicable.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The name of the key pair, if this instance was launched with an associated key pair.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair, if this instance was launched with an associated key pair.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// <p>The time the instance was launched.</p>
        pub fn launch_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.launch_time = Some(input);
            self
        }
        /// <p>The time the instance was launched.</p>
        pub fn set_launch_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.launch_time = input;
            self
        }
        /// <p>The monitoring for the instance.</p>
        pub fn monitoring(mut self, input: crate::model::Monitoring) -> Self {
            self.monitoring = Some(input);
            self
        }
        /// <p>The monitoring for the instance.</p>
        pub fn set_monitoring(
            mut self,
            input: std::option::Option<crate::model::Monitoring>,
        ) -> Self {
            self.monitoring = input;
            self
        }
        /// <p>The location where the instance launched, if applicable.</p>
        pub fn placement(mut self, input: crate::model::Placement) -> Self {
            self.placement = Some(input);
            self
        }
        /// <p>The location where the instance launched, if applicable.</p>
        pub fn set_placement(
            mut self,
            input: std::option::Option<crate::model::Placement>,
        ) -> Self {
            self.placement = input;
            self
        }
        /// <p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>
        pub fn platform(mut self, input: crate::model::PlatformValues) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformValues>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>(IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state. </p>
        /// <p>[EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>(IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the <code>running</code> state. </p>
        /// <p>[EC2-VPC] The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IPv4 address assigned to the instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 address assigned to the instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `product_codes`.
        ///
        /// To override the contents of this collection use [`set_product_codes`](Self::set_product_codes).
        ///
        /// <p>The product codes attached to this instance, if applicable.</p>
        pub fn product_codes(mut self, input: crate::model::ProductCode) -> Self {
            let mut v = self.product_codes.unwrap_or_default();
            v.push(input);
            self.product_codes = Some(v);
            self
        }
        /// <p>The product codes attached to this instance, if applicable.</p>
        pub fn set_product_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
        ) -> Self {
            self.product_codes = input;
            self
        }
        /// <p>(IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.</p>
        pub fn public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns_name = Some(input.into());
            self
        }
        /// <p>(IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the <code>running</code> state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.</p>
        pub fn set_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_dns_name = input;
            self
        }
        /// <p>The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
        /// <p>A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.</p>
        /// <p>A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// <p>The RAM disk associated with this instance, if applicable.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The RAM disk associated with this instance, if applicable.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn state(mut self, input: crate::model::InstanceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the instance.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the most recent state transition. This might be an empty string.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>The reason for the most recent state transition. This might be an empty string.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>[EC2-VPC] The ID of the subnet in which the instance is running.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the subnet in which the instance is running.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC in which the instance is running.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC in which the instance is running.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The architecture of the image.</p>
        pub fn architecture(mut self, input: crate::model::ArchitectureValues) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The architecture of the image.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::ArchitectureValues>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>Any block device mapping entries for the instance.</p>
        pub fn block_device_mappings(
            mut self,
            input: crate::model::InstanceBlockDeviceMapping,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>Any block device mapping entries for the instance.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>The idempotency token you provided when you launched the instance, if applicable.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token you provided when you launched the instance, if applicable.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>Specifies whether enhanced networking with ENA is enabled.</p>
        pub fn ena_support(mut self, input: bool) -> Self {
            self.ena_support = Some(input);
            self
        }
        /// <p>Specifies whether enhanced networking with ENA is enabled.</p>
        pub fn set_ena_support(mut self, input: std::option::Option<bool>) -> Self {
            self.ena_support = input;
            self
        }
        /// <p>The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p>
        pub fn hypervisor(mut self, input: crate::model::HypervisorType) -> Self {
            self.hypervisor = Some(input);
            self
        }
        /// <p>The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p>
        pub fn set_hypervisor(
            mut self,
            input: std::option::Option<crate::model::HypervisorType>,
        ) -> Self {
            self.hypervisor = input;
            self
        }
        /// <p>The IAM instance profile associated with the instance, if applicable.</p>
        pub fn iam_instance_profile(mut self, input: crate::model::IamInstanceProfile) -> Self {
            self.iam_instance_profile = Some(input);
            self
        }
        /// <p>The IAM instance profile associated with the instance, if applicable.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::IamInstanceProfile>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>Indicates whether this is a Spot Instance or a Scheduled Instance.</p>
        pub fn instance_lifecycle(mut self, input: crate::model::InstanceLifecycleType) -> Self {
            self.instance_lifecycle = Some(input);
            self
        }
        /// <p>Indicates whether this is a Spot Instance or a Scheduled Instance.</p>
        pub fn set_instance_lifecycle(
            mut self,
            input: std::option::Option<crate::model::InstanceLifecycleType>,
        ) -> Self {
            self.instance_lifecycle = input;
            self
        }
        /// Appends an item to `elastic_gpu_associations`.
        ///
        /// To override the contents of this collection use [`set_elastic_gpu_associations`](Self::set_elastic_gpu_associations).
        ///
        /// <p>The Elastic GPU associated with the instance.</p>
        pub fn elastic_gpu_associations(
            mut self,
            input: crate::model::ElasticGpuAssociation,
        ) -> Self {
            let mut v = self.elastic_gpu_associations.unwrap_or_default();
            v.push(input);
            self.elastic_gpu_associations = Some(v);
            self
        }
        /// <p>The Elastic GPU associated with the instance.</p>
        pub fn set_elastic_gpu_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ElasticGpuAssociation>>,
        ) -> Self {
            self.elastic_gpu_associations = input;
            self
        }
        /// Appends an item to `elastic_inference_accelerator_associations`.
        ///
        /// To override the contents of this collection use [`set_elastic_inference_accelerator_associations`](Self::set_elastic_inference_accelerator_associations).
        ///
        /// <p> The elastic inference accelerator associated with the instance.</p>
        pub fn elastic_inference_accelerator_associations(
            mut self,
            input: crate::model::ElasticInferenceAcceleratorAssociation,
        ) -> Self {
            let mut v = self
                .elastic_inference_accelerator_associations
                .unwrap_or_default();
            v.push(input);
            self.elastic_inference_accelerator_associations = Some(v);
            self
        }
        /// <p> The elastic inference accelerator associated with the instance.</p>
        pub fn set_elastic_inference_accelerator_associations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ElasticInferenceAcceleratorAssociation>,
            >,
        ) -> Self {
            self.elastic_inference_accelerator_associations = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>[EC2-VPC] The network interfaces for the instance.</p>
        pub fn network_interfaces(mut self, input: crate::model::InstanceNetworkInterface) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>[EC2-VPC] The network interfaces for the instance.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
        pub fn root_device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_device_name = Some(input.into());
            self
        }
        /// <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
        pub fn set_root_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_device_name = input;
            self
        }
        /// <p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>
        pub fn root_device_type(mut self, input: crate::model::DeviceType) -> Self {
            self.root_device_type = Some(input);
            self
        }
        /// <p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>
        pub fn set_root_device_type(
            mut self,
            input: std::option::Option<crate::model::DeviceType>,
        ) -> Self {
            self.root_device_type = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the instance.</p>
        pub fn security_groups(mut self, input: crate::model::GroupIdentifier) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input);
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the instance.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>Indicates whether source/destination checking is enabled.</p>
        pub fn source_dest_check(mut self, input: bool) -> Self {
            self.source_dest_check = Some(input);
            self
        }
        /// <p>Indicates whether source/destination checking is enabled.</p>
        pub fn set_source_dest_check(mut self, input: std::option::Option<bool>) -> Self {
            self.source_dest_check = input;
            self
        }
        /// <p>If the request is a Spot Instance request, the ID of the request.</p>
        pub fn spot_instance_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_instance_request_id = Some(input.into());
            self
        }
        /// <p>If the request is a Spot Instance request, the ID of the request.</p>
        pub fn set_spot_instance_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spot_instance_request_id = input;
            self
        }
        /// <p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
        pub fn sriov_net_support(mut self, input: impl Into<std::string::String>) -> Self {
            self.sriov_net_support = Some(input.into());
            self
        }
        /// <p>Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
        pub fn set_sriov_net_support(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sriov_net_support = input;
            self
        }
        /// <p>The reason for the most recent state transition.</p>
        pub fn state_reason(mut self, input: crate::model::StateReason) -> Self {
            self.state_reason = Some(input);
            self
        }
        /// <p>The reason for the most recent state transition.</p>
        pub fn set_state_reason(
            mut self,
            input: std::option::Option<crate::model::StateReason>,
        ) -> Self {
            self.state_reason = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Any tags assigned to the instance.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Any tags assigned to the instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The virtualization type of the instance.</p>
        pub fn virtualization_type(mut self, input: crate::model::VirtualizationType) -> Self {
            self.virtualization_type = Some(input);
            self
        }
        /// <p>The virtualization type of the instance.</p>
        pub fn set_virtualization_type(
            mut self,
            input: std::option::Option<crate::model::VirtualizationType>,
        ) -> Self {
            self.virtualization_type = input;
            self
        }
        /// <p>The CPU options for the instance.</p>
        pub fn cpu_options(mut self, input: crate::model::CpuOptions) -> Self {
            self.cpu_options = Some(input);
            self
        }
        /// <p>The CPU options for the instance.</p>
        pub fn set_cpu_options(
            mut self,
            input: std::option::Option<crate::model::CpuOptions>,
        ) -> Self {
            self.cpu_options = input;
            self
        }
        /// <p>The ID of the Capacity Reservation.</p>
        pub fn capacity_reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_reservation_id = Some(input.into());
            self
        }
        /// <p>The ID of the Capacity Reservation.</p>
        pub fn set_capacity_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_id = input;
            self
        }
        /// <p>Information about the Capacity Reservation targeting option.</p>
        pub fn capacity_reservation_specification(
            mut self,
            input: crate::model::CapacityReservationSpecificationResponse,
        ) -> Self {
            self.capacity_reservation_specification = Some(input);
            self
        }
        /// <p>Information about the Capacity Reservation targeting option.</p>
        pub fn set_capacity_reservation_specification(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationSpecificationResponse>,
        ) -> Self {
            self.capacity_reservation_specification = input;
            self
        }
        /// <p>Indicates whether the instance is enabled for hibernation.</p>
        pub fn hibernation_options(mut self, input: crate::model::HibernationOptions) -> Self {
            self.hibernation_options = Some(input);
            self
        }
        /// <p>Indicates whether the instance is enabled for hibernation.</p>
        pub fn set_hibernation_options(
            mut self,
            input: std::option::Option<crate::model::HibernationOptions>,
        ) -> Self {
            self.hibernation_options = input;
            self
        }
        /// Appends an item to `licenses`.
        ///
        /// To override the contents of this collection use [`set_licenses`](Self::set_licenses).
        ///
        /// <p>The license configurations for the instance.</p>
        pub fn licenses(mut self, input: crate::model::LicenseConfiguration) -> Self {
            let mut v = self.licenses.unwrap_or_default();
            v.push(input);
            self.licenses = Some(v);
            self
        }
        /// <p>The license configurations for the instance.</p>
        pub fn set_licenses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseConfiguration>>,
        ) -> Self {
            self.licenses = input;
            self
        }
        /// <p>The metadata options for the instance.</p>
        pub fn metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptionsResponse,
        ) -> Self {
            self.metadata_options = Some(input);
            self
        }
        /// <p>The metadata options for the instance.</p>
        pub fn set_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptionsResponse>,
        ) -> Self {
            self.metadata_options = input;
            self
        }
        /// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>
        pub fn enclave_options(mut self, input: crate::model::EnclaveOptions) -> Self {
            self.enclave_options = Some(input);
            self
        }
        /// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>
        pub fn set_enclave_options(
            mut self,
            input: std::option::Option<crate::model::EnclaveOptions>,
        ) -> Self {
            self.enclave_options = input;
            self
        }
        /// <p>The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn boot_mode(mut self, input: crate::model::BootModeValues) -> Self {
            self.boot_mode = Some(input);
            self
        }
        /// <p>The boot mode of the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html">Boot modes</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_boot_mode(
            mut self,
            input: std::option::Option<crate::model::BootModeValues>,
        ) -> Self {
            self.boot_mode = input;
            self
        }
        /// <p>The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn platform_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_details = Some(input.into());
            self
        }
        /// <p>The platform details value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_platform_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_details = input;
            self
        }
        /// <p>The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn usage_operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_operation = Some(input.into());
            self
        }
        /// <p>The usage operation value for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html">AMI billing information fields</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_usage_operation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_operation = input;
            self
        }
        /// <p>The time that the usage operation was last updated.</p>
        pub fn usage_operation_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.usage_operation_update_time = Some(input);
            self
        }
        /// <p>The time that the usage operation was last updated.</p>
        pub fn set_usage_operation_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.usage_operation_update_time = input;
            self
        }
        /// <p>The options for the instance hostname.</p>
        pub fn private_dns_name_options(
            mut self,
            input: crate::model::PrivateDnsNameOptionsResponse,
        ) -> Self {
            self.private_dns_name_options = Some(input);
            self
        }
        /// <p>The options for the instance hostname.</p>
        pub fn set_private_dns_name_options(
            mut self,
            input: std::option::Option<crate::model::PrivateDnsNameOptionsResponse>,
        ) -> Self {
            self.private_dns_name_options = input;
            self
        }
        /// <p>The IPv6 address assigned to the instance.</p>
        pub fn ipv6_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_address = Some(input.into());
            self
        }
        /// <p>The IPv6 address assigned to the instance.</p>
        pub fn set_ipv6_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_address = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                ami_launch_index: self.ami_launch_index,
                image_id: self.image_id,
                instance_id: self.instance_id,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                key_name: self.key_name,
                launch_time: self.launch_time,
                monitoring: self.monitoring,
                placement: self.placement,
                platform: self.platform,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
                product_codes: self.product_codes,
                public_dns_name: self.public_dns_name,
                public_ip_address: self.public_ip_address,
                ramdisk_id: self.ramdisk_id,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                subnet_id: self.subnet_id,
                vpc_id: self.vpc_id,
                architecture: self.architecture,
                block_device_mappings: self.block_device_mappings,
                client_token: self.client_token,
                ebs_optimized: self.ebs_optimized,
                ena_support: self.ena_support,
                hypervisor: self.hypervisor,
                iam_instance_profile: self.iam_instance_profile,
                instance_lifecycle: self.instance_lifecycle,
                elastic_gpu_associations: self.elastic_gpu_associations,
                elastic_inference_accelerator_associations: self
                    .elastic_inference_accelerator_associations,
                network_interfaces: self.network_interfaces,
                outpost_arn: self.outpost_arn,
                root_device_name: self.root_device_name,
                root_device_type: self.root_device_type,
                security_groups: self.security_groups,
                source_dest_check: self.source_dest_check,
                spot_instance_request_id: self.spot_instance_request_id,
                sriov_net_support: self.sriov_net_support,
                state_reason: self.state_reason,
                tags: self.tags,
                virtualization_type: self.virtualization_type,
                cpu_options: self.cpu_options,
                capacity_reservation_id: self.capacity_reservation_id,
                capacity_reservation_specification: self.capacity_reservation_specification,
                hibernation_options: self.hibernation_options,
                licenses: self.licenses,
                metadata_options: self.metadata_options,
                enclave_options: self.enclave_options,
                boot_mode: self.boot_mode,
                platform_details: self.platform_details,
                usage_operation: self.usage_operation,
                usage_operation_update_time: self.usage_operation_update_time,
                private_dns_name_options: self.private_dns_name_options,
                ipv6_address: self.ipv6_address,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>Describes the options for instance hostnames.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsNameOptionsResponse {
    /// <p>The type of hostname to assign to an instance.</p>
    pub hostname_type: std::option::Option<crate::model::HostnameType>,
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
    pub enable_resource_name_dns_a_record: std::option::Option<bool>,
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
    pub enable_resource_name_dns_aaaa_record: std::option::Option<bool>,
}
impl PrivateDnsNameOptionsResponse {
    /// <p>The type of hostname to assign to an instance.</p>
    pub fn hostname_type(&self) -> std::option::Option<&crate::model::HostnameType> {
        self.hostname_type.as_ref()
    }
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
    pub fn enable_resource_name_dns_a_record(&self) -> std::option::Option<bool> {
        self.enable_resource_name_dns_a_record
    }
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
    pub fn enable_resource_name_dns_aaaa_record(&self) -> std::option::Option<bool> {
        self.enable_resource_name_dns_aaaa_record
    }
}
impl std::fmt::Debug for PrivateDnsNameOptionsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsNameOptionsResponse");
        formatter.field("hostname_type", &self.hostname_type);
        formatter.field(
            "enable_resource_name_dns_a_record",
            &self.enable_resource_name_dns_a_record,
        );
        formatter.field(
            "enable_resource_name_dns_aaaa_record",
            &self.enable_resource_name_dns_aaaa_record,
        );
        formatter.finish()
    }
}
/// See [`PrivateDnsNameOptionsResponse`](crate::model::PrivateDnsNameOptionsResponse)
pub mod private_dns_name_options_response {
    /// A builder for [`PrivateDnsNameOptionsResponse`](crate::model::PrivateDnsNameOptionsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname_type: std::option::Option<crate::model::HostnameType>,
        pub(crate) enable_resource_name_dns_a_record: std::option::Option<bool>,
        pub(crate) enable_resource_name_dns_aaaa_record: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of hostname to assign to an instance.</p>
        pub fn hostname_type(mut self, input: crate::model::HostnameType) -> Self {
            self.hostname_type = Some(input);
            self
        }
        /// <p>The type of hostname to assign to an instance.</p>
        pub fn set_hostname_type(
            mut self,
            input: std::option::Option<crate::model::HostnameType>,
        ) -> Self {
            self.hostname_type = input;
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
        pub fn enable_resource_name_dns_a_record(mut self, input: bool) -> Self {
            self.enable_resource_name_dns_a_record = Some(input);
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
        pub fn set_enable_resource_name_dns_a_record(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_resource_name_dns_a_record = input;
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
        pub fn enable_resource_name_dns_aaaa_record(mut self, input: bool) -> Self {
            self.enable_resource_name_dns_aaaa_record = Some(input);
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
        pub fn set_enable_resource_name_dns_aaaa_record(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_resource_name_dns_aaaa_record = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsNameOptionsResponse`](crate::model::PrivateDnsNameOptionsResponse)
        pub fn build(self) -> crate::model::PrivateDnsNameOptionsResponse {
            crate::model::PrivateDnsNameOptionsResponse {
                hostname_type: self.hostname_type,
                enable_resource_name_dns_a_record: self.enable_resource_name_dns_a_record,
                enable_resource_name_dns_aaaa_record: self.enable_resource_name_dns_aaaa_record,
            }
        }
    }
}
impl PrivateDnsNameOptionsResponse {
    /// Creates a new builder-style object to manufacture [`PrivateDnsNameOptionsResponse`](crate::model::PrivateDnsNameOptionsResponse)
    pub fn builder() -> crate::model::private_dns_name_options_response::Builder {
        crate::model::private_dns_name_options_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HostnameType {
    #[allow(missing_docs)] // documentation missing in model
    IpName,
    #[allow(missing_docs)] // documentation missing in model
    ResourceName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HostnameType {
    fn from(s: &str) -> Self {
        match s {
            "ip-name" => HostnameType::IpName,
            "resource-name" => HostnameType::ResourceName,
            other => HostnameType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HostnameType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HostnameType::from(s))
    }
}
impl HostnameType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HostnameType::IpName => "ip-name",
            HostnameType::ResourceName => "resource-name",
            HostnameType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ip-name", "resource-name"]
    }
}
impl AsRef<str> for HostnameType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BootModeValues {
    #[allow(missing_docs)] // documentation missing in model
    LegacyBios,
    #[allow(missing_docs)] // documentation missing in model
    Uefi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BootModeValues {
    fn from(s: &str) -> Self {
        match s {
            "legacy-bios" => BootModeValues::LegacyBios,
            "uefi" => BootModeValues::Uefi,
            other => BootModeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BootModeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BootModeValues::from(s))
    }
}
impl BootModeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BootModeValues::LegacyBios => "legacy-bios",
            BootModeValues::Uefi => "uefi",
            BootModeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["legacy-bios", "uefi"]
    }
}
impl AsRef<str> for BootModeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnclaveOptions {
    /// <p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>
    pub enabled: std::option::Option<bool>,
}
impl EnclaveOptions {
    /// <p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for EnclaveOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnclaveOptions");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`EnclaveOptions`](crate::model::EnclaveOptions)
pub mod enclave_options {
    /// A builder for [`EnclaveOptions`](crate::model::EnclaveOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If this parameter is set to <code>true</code>, the instance is enabled for Amazon Web Services Nitro Enclaves; otherwise, it is not enabled for Amazon Web Services Nitro Enclaves.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EnclaveOptions`](crate::model::EnclaveOptions)
        pub fn build(self) -> crate::model::EnclaveOptions {
            crate::model::EnclaveOptions {
                enabled: self.enabled,
            }
        }
    }
}
impl EnclaveOptions {
    /// Creates a new builder-style object to manufacture [`EnclaveOptions`](crate::model::EnclaveOptions)
    pub fn builder() -> crate::model::enclave_options::Builder {
        crate::model::enclave_options::Builder::default()
    }
}

/// <p>The metadata options for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMetadataOptionsResponse {
    /// <p>The state of the metadata option changes.</p>
    /// <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p>
    /// <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>
    pub state: std::option::Option<crate::model::InstanceMetadataOptionsState>,
    /// <p>The state of token usage for your instance metadata requests.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
    /// <p>Default: <code>optional</code> </p>
    pub http_tokens: std::option::Option<crate::model::HttpTokensState>,
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    /// <p>Possible values: Integers from 1 to 64</p>
    pub http_put_response_hop_limit: std::option::Option<i32>,
    /// <p>Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.</p>
    /// <p>If the value is <code>disabled</code>, you cannot access your instance metadata.</p>
    pub http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
    /// <p>Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.</p>
    pub http_protocol_ipv6: std::option::Option<crate::model::InstanceMetadataProtocolState>,
    /// <p>Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
    pub instance_metadata_tags: std::option::Option<crate::model::InstanceMetadataTagsState>,
}
impl InstanceMetadataOptionsResponse {
    /// <p>The state of the metadata option changes.</p>
    /// <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p>
    /// <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::InstanceMetadataOptionsState> {
        self.state.as_ref()
    }
    /// <p>The state of token usage for your instance metadata requests.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
    /// <p>Default: <code>optional</code> </p>
    pub fn http_tokens(&self) -> std::option::Option<&crate::model::HttpTokensState> {
        self.http_tokens.as_ref()
    }
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    /// <p>Possible values: Integers from 1 to 64</p>
    pub fn http_put_response_hop_limit(&self) -> std::option::Option<i32> {
        self.http_put_response_hop_limit
    }
    /// <p>Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.</p>
    /// <p>If the value is <code>disabled</code>, you cannot access your instance metadata.</p>
    pub fn http_endpoint(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataEndpointState> {
        self.http_endpoint.as_ref()
    }
    /// <p>Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.</p>
    pub fn http_protocol_ipv6(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataProtocolState> {
        self.http_protocol_ipv6.as_ref()
    }
    /// <p>Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
    pub fn instance_metadata_tags(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataTagsState> {
        self.instance_metadata_tags.as_ref()
    }
}
impl std::fmt::Debug for InstanceMetadataOptionsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMetadataOptionsResponse");
        formatter.field("state", &self.state);
        formatter.field("http_tokens", &self.http_tokens);
        formatter.field(
            "http_put_response_hop_limit",
            &self.http_put_response_hop_limit,
        );
        formatter.field("http_endpoint", &self.http_endpoint);
        formatter.field("http_protocol_ipv6", &self.http_protocol_ipv6);
        formatter.field("instance_metadata_tags", &self.instance_metadata_tags);
        formatter.finish()
    }
}
/// See [`InstanceMetadataOptionsResponse`](crate::model::InstanceMetadataOptionsResponse)
pub mod instance_metadata_options_response {
    /// A builder for [`InstanceMetadataOptionsResponse`](crate::model::InstanceMetadataOptionsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::InstanceMetadataOptionsState>,
        pub(crate) http_tokens: std::option::Option<crate::model::HttpTokensState>,
        pub(crate) http_put_response_hop_limit: std::option::Option<i32>,
        pub(crate) http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
        pub(crate) http_protocol_ipv6:
            std::option::Option<crate::model::InstanceMetadataProtocolState>,
        pub(crate) instance_metadata_tags:
            std::option::Option<crate::model::InstanceMetadataTagsState>,
    }
    impl Builder {
        /// <p>The state of the metadata option changes.</p>
        /// <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p>
        /// <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>
        pub fn state(mut self, input: crate::model::InstanceMetadataOptionsState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the metadata option changes.</p>
        /// <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p>
        /// <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptionsState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The state of token usage for your instance metadata requests.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
        /// <p>Default: <code>optional</code> </p>
        pub fn http_tokens(mut self, input: crate::model::HttpTokensState) -> Self {
            self.http_tokens = Some(input);
            self
        }
        /// <p>The state of token usage for your instance metadata requests.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
        /// <p>Default: <code>optional</code> </p>
        pub fn set_http_tokens(
            mut self,
            input: std::option::Option<crate::model::HttpTokensState>,
        ) -> Self {
            self.http_tokens = input;
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        /// <p>Possible values: Integers from 1 to 64</p>
        pub fn http_put_response_hop_limit(mut self, input: i32) -> Self {
            self.http_put_response_hop_limit = Some(input);
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        /// <p>Possible values: Integers from 1 to 64</p>
        pub fn set_http_put_response_hop_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.http_put_response_hop_limit = input;
            self
        }
        /// <p>Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.</p>
        /// <p>If the value is <code>disabled</code>, you cannot access your instance metadata.</p>
        pub fn http_endpoint(mut self, input: crate::model::InstanceMetadataEndpointState) -> Self {
            self.http_endpoint = Some(input);
            self
        }
        /// <p>Indicates whether the HTTP metadata endpoint on your instances is enabled or disabled.</p>
        /// <p>If the value is <code>disabled</code>, you cannot access your instance metadata.</p>
        pub fn set_http_endpoint(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataEndpointState>,
        ) -> Self {
            self.http_endpoint = input;
            self
        }
        /// <p>Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.</p>
        pub fn http_protocol_ipv6(
            mut self,
            input: crate::model::InstanceMetadataProtocolState,
        ) -> Self {
            self.http_protocol_ipv6 = Some(input);
            self
        }
        /// <p>Indicates whether the IPv6 endpoint for the instance metadata service is enabled or disabled.</p>
        pub fn set_http_protocol_ipv6(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataProtocolState>,
        ) -> Self {
            self.http_protocol_ipv6 = input;
            self
        }
        /// <p>Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
        pub fn instance_metadata_tags(
            mut self,
            input: crate::model::InstanceMetadataTagsState,
        ) -> Self {
            self.instance_metadata_tags = Some(input);
            self
        }
        /// <p>Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
        pub fn set_instance_metadata_tags(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataTagsState>,
        ) -> Self {
            self.instance_metadata_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMetadataOptionsResponse`](crate::model::InstanceMetadataOptionsResponse)
        pub fn build(self) -> crate::model::InstanceMetadataOptionsResponse {
            crate::model::InstanceMetadataOptionsResponse {
                state: self.state,
                http_tokens: self.http_tokens,
                http_put_response_hop_limit: self.http_put_response_hop_limit,
                http_endpoint: self.http_endpoint,
                http_protocol_ipv6: self.http_protocol_ipv6,
                instance_metadata_tags: self.instance_metadata_tags,
            }
        }
    }
}
impl InstanceMetadataOptionsResponse {
    /// Creates a new builder-style object to manufacture [`InstanceMetadataOptionsResponse`](crate::model::InstanceMetadataOptionsResponse)
    pub fn builder() -> crate::model::instance_metadata_options_response::Builder {
        crate::model::instance_metadata_options_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataTagsState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataTagsState {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => InstanceMetadataTagsState::Disabled,
            "enabled" => InstanceMetadataTagsState::Enabled,
            other => InstanceMetadataTagsState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataTagsState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataTagsState::from(s))
    }
}
impl InstanceMetadataTagsState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataTagsState::Disabled => "disabled",
            InstanceMetadataTagsState::Enabled => "enabled",
            InstanceMetadataTagsState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for InstanceMetadataTagsState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataProtocolState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataProtocolState {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => InstanceMetadataProtocolState::Disabled,
            "enabled" => InstanceMetadataProtocolState::Enabled,
            other => InstanceMetadataProtocolState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataProtocolState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataProtocolState::from(s))
    }
}
impl InstanceMetadataProtocolState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataProtocolState::Disabled => "disabled",
            InstanceMetadataProtocolState::Enabled => "enabled",
            InstanceMetadataProtocolState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for InstanceMetadataProtocolState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataEndpointState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataEndpointState {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => InstanceMetadataEndpointState::Disabled,
            "enabled" => InstanceMetadataEndpointState::Enabled,
            other => InstanceMetadataEndpointState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataEndpointState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataEndpointState::from(s))
    }
}
impl InstanceMetadataEndpointState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataEndpointState::Disabled => "disabled",
            InstanceMetadataEndpointState::Enabled => "enabled",
            InstanceMetadataEndpointState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for InstanceMetadataEndpointState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HttpTokensState {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HttpTokensState {
    fn from(s: &str) -> Self {
        match s {
            "optional" => HttpTokensState::Optional,
            "required" => HttpTokensState::Required,
            other => HttpTokensState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HttpTokensState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HttpTokensState::from(s))
    }
}
impl HttpTokensState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HttpTokensState::Optional => "optional",
            HttpTokensState::Required => "required",
            HttpTokensState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["optional", "required"]
    }
}
impl AsRef<str> for HttpTokensState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataOptionsState {
    #[allow(missing_docs)] // documentation missing in model
    Applied,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataOptionsState {
    fn from(s: &str) -> Self {
        match s {
            "applied" => InstanceMetadataOptionsState::Applied,
            "pending" => InstanceMetadataOptionsState::Pending,
            other => InstanceMetadataOptionsState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataOptionsState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataOptionsState::from(s))
    }
}
impl InstanceMetadataOptionsState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataOptionsState::Applied => "applied",
            InstanceMetadataOptionsState::Pending => "pending",
            InstanceMetadataOptionsState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["applied", "pending"]
    }
}
impl AsRef<str> for InstanceMetadataOptionsState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
}
impl LicenseConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for LicenseConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConfiguration");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.finish()
    }
}
/// See [`LicenseConfiguration`](crate::model::LicenseConfiguration)
pub mod license_configuration {
    /// A builder for [`LicenseConfiguration`](crate::model::LicenseConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConfiguration`](crate::model::LicenseConfiguration)
        pub fn build(self) -> crate::model::LicenseConfiguration {
            crate::model::LicenseConfiguration {
                license_configuration_arn: self.license_configuration_arn,
            }
        }
    }
}
impl LicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`LicenseConfiguration`](crate::model::LicenseConfiguration)
    pub fn builder() -> crate::model::license_configuration::Builder {
        crate::model::license_configuration::Builder::default()
    }
}

/// <p>Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HibernationOptions {
    /// <p>If this parameter is set to <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>
    pub configured: std::option::Option<bool>,
}
impl HibernationOptions {
    /// <p>If this parameter is set to <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>
    pub fn configured(&self) -> std::option::Option<bool> {
        self.configured
    }
}
impl std::fmt::Debug for HibernationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HibernationOptions");
        formatter.field("configured", &self.configured);
        formatter.finish()
    }
}
/// See [`HibernationOptions`](crate::model::HibernationOptions)
pub mod hibernation_options {
    /// A builder for [`HibernationOptions`](crate::model::HibernationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configured: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If this parameter is set to <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>
        pub fn configured(mut self, input: bool) -> Self {
            self.configured = Some(input);
            self
        }
        /// <p>If this parameter is set to <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>
        pub fn set_configured(mut self, input: std::option::Option<bool>) -> Self {
            self.configured = input;
            self
        }
        /// Consumes the builder and constructs a [`HibernationOptions`](crate::model::HibernationOptions)
        pub fn build(self) -> crate::model::HibernationOptions {
            crate::model::HibernationOptions {
                configured: self.configured,
            }
        }
    }
}
impl HibernationOptions {
    /// Creates a new builder-style object to manufacture [`HibernationOptions`](crate::model::HibernationOptions)
    pub fn builder() -> crate::model::hibernation_options::Builder {
        crate::model::hibernation_options::Builder::default()
    }
}

/// <p>Describes the instance's Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityReservationSpecificationResponse {
    /// <p>Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
    /// <ul>
    /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
    /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li>
    /// </ul>
    pub capacity_reservation_preference:
        std::option::Option<crate::model::CapacityReservationPreference>,
    /// <p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>
    pub capacity_reservation_target:
        std::option::Option<crate::model::CapacityReservationTargetResponse>,
}
impl CapacityReservationSpecificationResponse {
    /// <p>Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
    /// <ul>
    /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
    /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li>
    /// </ul>
    pub fn capacity_reservation_preference(
        &self,
    ) -> std::option::Option<&crate::model::CapacityReservationPreference> {
        self.capacity_reservation_preference.as_ref()
    }
    /// <p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>
    pub fn capacity_reservation_target(
        &self,
    ) -> std::option::Option<&crate::model::CapacityReservationTargetResponse> {
        self.capacity_reservation_target.as_ref()
    }
}
impl std::fmt::Debug for CapacityReservationSpecificationResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityReservationSpecificationResponse");
        formatter.field(
            "capacity_reservation_preference",
            &self.capacity_reservation_preference,
        );
        formatter.field(
            "capacity_reservation_target",
            &self.capacity_reservation_target,
        );
        formatter.finish()
    }
}
/// See [`CapacityReservationSpecificationResponse`](crate::model::CapacityReservationSpecificationResponse)
pub mod capacity_reservation_specification_response {
    /// A builder for [`CapacityReservationSpecificationResponse`](crate::model::CapacityReservationSpecificationResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_reservation_preference:
            std::option::Option<crate::model::CapacityReservationPreference>,
        pub(crate) capacity_reservation_target:
            std::option::Option<crate::model::CapacityReservationTargetResponse>,
    }
    impl Builder {
        /// <p>Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
        /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li>
        /// </ul>
        pub fn capacity_reservation_preference(
            mut self,
            input: crate::model::CapacityReservationPreference,
        ) -> Self {
            self.capacity_reservation_preference = Some(input);
            self
        }
        /// <p>Describes the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
        /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li>
        /// </ul>
        pub fn set_capacity_reservation_preference(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationPreference>,
        ) -> Self {
            self.capacity_reservation_preference = input;
            self
        }
        /// <p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>
        pub fn capacity_reservation_target(
            mut self,
            input: crate::model::CapacityReservationTargetResponse,
        ) -> Self {
            self.capacity_reservation_target = Some(input);
            self
        }
        /// <p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>
        pub fn set_capacity_reservation_target(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationTargetResponse>,
        ) -> Self {
            self.capacity_reservation_target = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityReservationSpecificationResponse`](crate::model::CapacityReservationSpecificationResponse)
        pub fn build(self) -> crate::model::CapacityReservationSpecificationResponse {
            crate::model::CapacityReservationSpecificationResponse {
                capacity_reservation_preference: self.capacity_reservation_preference,
                capacity_reservation_target: self.capacity_reservation_target,
            }
        }
    }
}
impl CapacityReservationSpecificationResponse {
    /// Creates a new builder-style object to manufacture [`CapacityReservationSpecificationResponse`](crate::model::CapacityReservationSpecificationResponse)
    pub fn builder() -> crate::model::capacity_reservation_specification_response::Builder {
        crate::model::capacity_reservation_specification_response::Builder::default()
    }
}

/// <p>Describes a target Capacity Reservation or Capacity Reservation group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityReservationTargetResponse {
    /// <p>The ID of the targeted Capacity Reservation.</p>
    pub capacity_reservation_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the targeted Capacity Reservation group.</p>
    pub capacity_reservation_resource_group_arn: std::option::Option<std::string::String>,
}
impl CapacityReservationTargetResponse {
    /// <p>The ID of the targeted Capacity Reservation.</p>
    pub fn capacity_reservation_id(&self) -> std::option::Option<&str> {
        self.capacity_reservation_id.as_deref()
    }
    /// <p>The ARN of the targeted Capacity Reservation group.</p>
    pub fn capacity_reservation_resource_group_arn(&self) -> std::option::Option<&str> {
        self.capacity_reservation_resource_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CapacityReservationTargetResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityReservationTargetResponse");
        formatter.field("capacity_reservation_id", &self.capacity_reservation_id);
        formatter.field(
            "capacity_reservation_resource_group_arn",
            &self.capacity_reservation_resource_group_arn,
        );
        formatter.finish()
    }
}
/// See [`CapacityReservationTargetResponse`](crate::model::CapacityReservationTargetResponse)
pub mod capacity_reservation_target_response {
    /// A builder for [`CapacityReservationTargetResponse`](crate::model::CapacityReservationTargetResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_reservation_id: std::option::Option<std::string::String>,
        pub(crate) capacity_reservation_resource_group_arn:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the targeted Capacity Reservation.</p>
        pub fn capacity_reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_reservation_id = Some(input.into());
            self
        }
        /// <p>The ID of the targeted Capacity Reservation.</p>
        pub fn set_capacity_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_id = input;
            self
        }
        /// <p>The ARN of the targeted Capacity Reservation group.</p>
        pub fn capacity_reservation_resource_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the targeted Capacity Reservation group.</p>
        pub fn set_capacity_reservation_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityReservationTargetResponse`](crate::model::CapacityReservationTargetResponse)
        pub fn build(self) -> crate::model::CapacityReservationTargetResponse {
            crate::model::CapacityReservationTargetResponse {
                capacity_reservation_id: self.capacity_reservation_id,
                capacity_reservation_resource_group_arn: self
                    .capacity_reservation_resource_group_arn,
            }
        }
    }
}
impl CapacityReservationTargetResponse {
    /// Creates a new builder-style object to manufacture [`CapacityReservationTargetResponse`](crate::model::CapacityReservationTargetResponse)
    pub fn builder() -> crate::model::capacity_reservation_target_response::Builder {
        crate::model::capacity_reservation_target_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapacityReservationPreference {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapacityReservationPreference {
    fn from(s: &str) -> Self {
        match s {
            "none" => CapacityReservationPreference::None,
            "open" => CapacityReservationPreference::Open,
            other => CapacityReservationPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapacityReservationPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapacityReservationPreference::from(s))
    }
}
impl CapacityReservationPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapacityReservationPreference::None => "none",
            CapacityReservationPreference::Open => "open",
            CapacityReservationPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["none", "open"]
    }
}
impl AsRef<str> for CapacityReservationPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The CPU options for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CpuOptions {
    /// <p>The number of CPU cores for the instance.</p>
    pub core_count: std::option::Option<i32>,
    /// <p>The number of threads per CPU core.</p>
    pub threads_per_core: std::option::Option<i32>,
}
impl CpuOptions {
    /// <p>The number of CPU cores for the instance.</p>
    pub fn core_count(&self) -> std::option::Option<i32> {
        self.core_count
    }
    /// <p>The number of threads per CPU core.</p>
    pub fn threads_per_core(&self) -> std::option::Option<i32> {
        self.threads_per_core
    }
}
impl std::fmt::Debug for CpuOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CpuOptions");
        formatter.field("core_count", &self.core_count);
        formatter.field("threads_per_core", &self.threads_per_core);
        formatter.finish()
    }
}
/// See [`CpuOptions`](crate::model::CpuOptions)
pub mod cpu_options {
    /// A builder for [`CpuOptions`](crate::model::CpuOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_count: std::option::Option<i32>,
        pub(crate) threads_per_core: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of CPU cores for the instance.</p>
        pub fn core_count(mut self, input: i32) -> Self {
            self.core_count = Some(input);
            self
        }
        /// <p>The number of CPU cores for the instance.</p>
        pub fn set_core_count(mut self, input: std::option::Option<i32>) -> Self {
            self.core_count = input;
            self
        }
        /// <p>The number of threads per CPU core.</p>
        pub fn threads_per_core(mut self, input: i32) -> Self {
            self.threads_per_core = Some(input);
            self
        }
        /// <p>The number of threads per CPU core.</p>
        pub fn set_threads_per_core(mut self, input: std::option::Option<i32>) -> Self {
            self.threads_per_core = input;
            self
        }
        /// Consumes the builder and constructs a [`CpuOptions`](crate::model::CpuOptions)
        pub fn build(self) -> crate::model::CpuOptions {
            crate::model::CpuOptions {
                core_count: self.core_count,
                threads_per_core: self.threads_per_core,
            }
        }
    }
}
impl CpuOptions {
    /// Creates a new builder-style object to manufacture [`CpuOptions`](crate::model::CpuOptions)
    pub fn builder() -> crate::model::cpu_options::Builder {
        crate::model::cpu_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VirtualizationType {
    #[allow(missing_docs)] // documentation missing in model
    Hvm,
    #[allow(missing_docs)] // documentation missing in model
    Paravirtual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VirtualizationType {
    fn from(s: &str) -> Self {
        match s {
            "hvm" => VirtualizationType::Hvm,
            "paravirtual" => VirtualizationType::Paravirtual,
            other => VirtualizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VirtualizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VirtualizationType::from(s))
    }
}
impl VirtualizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VirtualizationType::Hvm => "hvm",
            VirtualizationType::Paravirtual => "paravirtual",
            VirtualizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["hvm", "paravirtual"]
    }
}
impl AsRef<str> for VirtualizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a state change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StateReason {
    /// <p>The reason code for the state change.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message for the state change.</p>
    /// <ul>
    /// <li> <p> <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the launch request.</p> </li>
    /// <li> <p> <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.</p> </li>
    /// <li> <p> <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.</p> </li>
    /// <li> <p> <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
    /// <li> <p> <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
    /// <li> <p> <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code> command from the instance.</p> </li>
    /// <li> <p> <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.</p> </li>
    /// <li> <p> <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.</p> </li>
    /// <li> <p> <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.</p> </li>
    /// <li> <p> <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.</p> </li>
    /// <li> <p> <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.</p> </li>
    /// <li> <p> <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded. Decrease usage or request an increase in your account limits.</p> </li>
    /// </ul>
    pub message: std::option::Option<std::string::String>,
}
impl StateReason {
    /// <p>The reason code for the state change.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The message for the state change.</p>
    /// <ul>
    /// <li> <p> <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the launch request.</p> </li>
    /// <li> <p> <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.</p> </li>
    /// <li> <p> <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.</p> </li>
    /// <li> <p> <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
    /// <li> <p> <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
    /// <li> <p> <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code> command from the instance.</p> </li>
    /// <li> <p> <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.</p> </li>
    /// <li> <p> <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.</p> </li>
    /// <li> <p> <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.</p> </li>
    /// <li> <p> <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.</p> </li>
    /// <li> <p> <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.</p> </li>
    /// <li> <p> <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded. Decrease usage or request an increase in your account limits.</p> </li>
    /// </ul>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for StateReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StateReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`StateReason`](crate::model::StateReason)
pub mod state_reason {
    /// A builder for [`StateReason`](crate::model::StateReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reason code for the state change.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The reason code for the state change.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message for the state change.</p>
        /// <ul>
        /// <li> <p> <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the launch request.</p> </li>
        /// <li> <p> <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.</p> </li>
        /// <li> <p> <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.</p> </li>
        /// <li> <p> <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
        /// <li> <p> <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
        /// <li> <p> <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code> command from the instance.</p> </li>
        /// <li> <p> <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.</p> </li>
        /// <li> <p> <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.</p> </li>
        /// <li> <p> <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.</p> </li>
        /// <li> <p> <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.</p> </li>
        /// <li> <p> <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.</p> </li>
        /// <li> <p> <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded. Decrease usage or request an increase in your account limits.</p> </li>
        /// </ul>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the state change.</p>
        /// <ul>
        /// <li> <p> <code>Server.InsufficientInstanceCapacity</code>: There was insufficient capacity available to satisfy the launch request.</p> </li>
        /// <li> <p> <code>Server.InternalError</code>: An internal error caused the instance to terminate during launch.</p> </li>
        /// <li> <p> <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.</p> </li>
        /// <li> <p> <code>Server.SpotInstanceShutdown</code>: The instance was stopped because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
        /// <li> <p> <code>Server.SpotInstanceTermination</code>: The instance was terminated because the number of Spot requests with a maximum price equal to or higher than the Spot price exceeded available capacity or because of an increase in the Spot price.</p> </li>
        /// <li> <p> <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code> command from the instance.</p> </li>
        /// <li> <p> <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.</p> </li>
        /// <li> <p> <code>Client.InternalError</code>: A client error caused the instance to terminate during launch.</p> </li>
        /// <li> <p> <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.</p> </li>
        /// <li> <p> <code>Client.UserInitiatedHibernate</code>: Hibernation was initiated on the instance.</p> </li>
        /// <li> <p> <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.</p> </li>
        /// <li> <p> <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded. Decrease usage or request an increase in your account limits.</p> </li>
        /// </ul>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StateReason`](crate::model::StateReason)
        pub fn build(self) -> crate::model::StateReason {
            crate::model::StateReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl StateReason {
    /// Creates a new builder-style object to manufacture [`StateReason`](crate::model::StateReason)
    pub fn builder() -> crate::model::state_reason::Builder {
        crate::model::state_reason::Builder::default()
    }
}

/// <p>Describes a security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupIdentifier {
    /// <p>The name of the security group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The ID of the security group.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl GroupIdentifier {
    /// <p>The name of the security group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The ID of the security group.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for GroupIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupIdentifier");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}
/// See [`GroupIdentifier`](crate::model::GroupIdentifier)
pub mod group_identifier {
    /// A builder for [`GroupIdentifier`](crate::model::GroupIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupIdentifier`](crate::model::GroupIdentifier)
        pub fn build(self) -> crate::model::GroupIdentifier {
            crate::model::GroupIdentifier {
                group_name: self.group_name,
                group_id: self.group_id,
            }
        }
    }
}
impl GroupIdentifier {
    /// Creates a new builder-style object to manufacture [`GroupIdentifier`](crate::model::GroupIdentifier)
    pub fn builder() -> crate::model::group_identifier::Builder {
        crate::model::group_identifier::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceType {
    #[allow(missing_docs)] // documentation missing in model
    Ebs,
    #[allow(missing_docs)] // documentation missing in model
    InstanceStore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceType {
    fn from(s: &str) -> Self {
        match s {
            "ebs" => DeviceType::Ebs,
            "instance-store" => DeviceType::InstanceStore,
            other => DeviceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceType::from(s))
    }
}
impl DeviceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceType::Ebs => "ebs",
            DeviceType::InstanceStore => "instance-store",
            DeviceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ebs", "instance-store"]
    }
}
impl AsRef<str> for DeviceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNetworkInterface {
    /// <p>The association information for an Elastic IPv4 associated with the network interface.</p>
    pub association: std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
    /// <p>The network interface attachment.</p>
    pub attachment: std::option::Option<crate::model::InstanceNetworkInterfaceAttachment>,
    /// <p>The description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>One or more security groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
    /// <p>One or more IPv6 addresses associated with the network interface.</p>
    pub ipv6_addresses: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
    /// <p>The MAC address.</p>
    pub mac_address: std::option::Option<std::string::String>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that created the network interface.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The private DNS name.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>One or more private IPv4 addresses associated with the network interface.</p>
    pub private_ip_addresses:
        std::option::Option<std::vec::Vec<crate::model::InstancePrivateIpAddress>>,
    /// <p>Indicates whether source/destination checking is enabled.</p>
    pub source_dest_check: std::option::Option<bool>,
    /// <p>The status of the network interface.</p>
    pub status: std::option::Option<crate::model::NetworkInterfaceStatus>,
    /// <p>The ID of the subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The type of network interface.</p>
    /// <p>Valid values: <code>interface</code> | <code>efa</code> | <code>trunk</code> </p>
    pub interface_type: std::option::Option<std::string::String>,
    /// <p>The IPv4 delegated prefixes that are assigned to the network interface.</p>
    pub ipv4_prefixes: std::option::Option<std::vec::Vec<crate::model::InstanceIpv4Prefix>>,
    /// <p>The IPv6 delegated prefixes that are assigned to the network interface.</p>
    pub ipv6_prefixes: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Prefix>>,
}
impl InstanceNetworkInterface {
    /// <p>The association information for an Elastic IPv4 associated with the network interface.</p>
    pub fn association(
        &self,
    ) -> std::option::Option<&crate::model::InstanceNetworkInterfaceAssociation> {
        self.association.as_ref()
    }
    /// <p>The network interface attachment.</p>
    pub fn attachment(
        &self,
    ) -> std::option::Option<&crate::model::InstanceNetworkInterfaceAttachment> {
        self.attachment.as_ref()
    }
    /// <p>The description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>One or more security groups.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::GroupIdentifier]> {
        self.groups.as_deref()
    }
    /// <p>One or more IPv6 addresses associated with the network interface.</p>
    pub fn ipv6_addresses(&self) -> std::option::Option<&[crate::model::InstanceIpv6Address]> {
        self.ipv6_addresses.as_deref()
    }
    /// <p>The MAC address.</p>
    pub fn mac_address(&self) -> std::option::Option<&str> {
        self.mac_address.as_deref()
    }
    /// <p>The ID of the network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that created the network interface.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The private DNS name.</p>
    pub fn private_dns_name(&self) -> std::option::Option<&str> {
        self.private_dns_name.as_deref()
    }
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>One or more private IPv4 addresses associated with the network interface.</p>
    pub fn private_ip_addresses(
        &self,
    ) -> std::option::Option<&[crate::model::InstancePrivateIpAddress]> {
        self.private_ip_addresses.as_deref()
    }
    /// <p>Indicates whether source/destination checking is enabled.</p>
    pub fn source_dest_check(&self) -> std::option::Option<bool> {
        self.source_dest_check
    }
    /// <p>The status of the network interface.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NetworkInterfaceStatus> {
        self.status.as_ref()
    }
    /// <p>The ID of the subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The type of network interface.</p>
    /// <p>Valid values: <code>interface</code> | <code>efa</code> | <code>trunk</code> </p>
    pub fn interface_type(&self) -> std::option::Option<&str> {
        self.interface_type.as_deref()
    }
    /// <p>The IPv4 delegated prefixes that are assigned to the network interface.</p>
    pub fn ipv4_prefixes(&self) -> std::option::Option<&[crate::model::InstanceIpv4Prefix]> {
        self.ipv4_prefixes.as_deref()
    }
    /// <p>The IPv6 delegated prefixes that are assigned to the network interface.</p>
    pub fn ipv6_prefixes(&self) -> std::option::Option<&[crate::model::InstanceIpv6Prefix]> {
        self.ipv6_prefixes.as_deref()
    }
}
impl std::fmt::Debug for InstanceNetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNetworkInterface");
        formatter.field("association", &self.association);
        formatter.field("attachment", &self.attachment);
        formatter.field("description", &self.description);
        formatter.field("groups", &self.groups);
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("mac_address", &self.mac_address);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("private_ip_addresses", &self.private_ip_addresses);
        formatter.field("source_dest_check", &self.source_dest_check);
        formatter.field("status", &self.status);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("interface_type", &self.interface_type);
        formatter.field("ipv4_prefixes", &self.ipv4_prefixes);
        formatter.field("ipv6_prefixes", &self.ipv6_prefixes);
        formatter.finish()
    }
}
/// See [`InstanceNetworkInterface`](crate::model::InstanceNetworkInterface)
pub mod instance_network_interface {
    /// A builder for [`InstanceNetworkInterface`](crate::model::InstanceNetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association:
            std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
        pub(crate) attachment:
            std::option::Option<crate::model::InstanceNetworkInterfaceAttachment>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        pub(crate) ipv6_addresses:
            std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        pub(crate) mac_address: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::InstancePrivateIpAddress>>,
        pub(crate) source_dest_check: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::NetworkInterfaceStatus>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) interface_type: std::option::Option<std::string::String>,
        pub(crate) ipv4_prefixes:
            std::option::Option<std::vec::Vec<crate::model::InstanceIpv4Prefix>>,
        pub(crate) ipv6_prefixes:
            std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Prefix>>,
    }
    impl Builder {
        /// <p>The association information for an Elastic IPv4 associated with the network interface.</p>
        pub fn association(
            mut self,
            input: crate::model::InstanceNetworkInterfaceAssociation,
        ) -> Self {
            self.association = Some(input);
            self
        }
        /// <p>The association information for an Elastic IPv4 associated with the network interface.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
        ) -> Self {
            self.association = input;
            self
        }
        /// <p>The network interface attachment.</p>
        pub fn attachment(
            mut self,
            input: crate::model::InstanceNetworkInterfaceAttachment,
        ) -> Self {
            self.attachment = Some(input);
            self
        }
        /// <p>The network interface attachment.</p>
        pub fn set_attachment(
            mut self,
            input: std::option::Option<crate::model::InstanceNetworkInterfaceAttachment>,
        ) -> Self {
            self.attachment = input;
            self
        }
        /// <p>The description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>One or more security groups.</p>
        pub fn groups(mut self, input: crate::model::GroupIdentifier) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>One or more security groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more IPv6 addresses associated with the network interface.</p>
        pub fn ipv6_addresses(mut self, input: crate::model::InstanceIpv6Address) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input);
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>One or more IPv6 addresses associated with the network interface.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The MAC address.</p>
        pub fn mac_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mac_address = Some(input.into());
            self
        }
        /// <p>The MAC address.</p>
        pub fn set_mac_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mac_address = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that created the network interface.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that created the network interface.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The private DNS name.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private DNS name.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more private IPv4 addresses associated with the network interface.</p>
        pub fn private_ip_addresses(
            mut self,
            input: crate::model::InstancePrivateIpAddress,
        ) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input);
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>One or more private IPv4 addresses associated with the network interface.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePrivateIpAddress>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>Indicates whether source/destination checking is enabled.</p>
        pub fn source_dest_check(mut self, input: bool) -> Self {
            self.source_dest_check = Some(input);
            self
        }
        /// <p>Indicates whether source/destination checking is enabled.</p>
        pub fn set_source_dest_check(mut self, input: std::option::Option<bool>) -> Self {
            self.source_dest_check = input;
            self
        }
        /// <p>The status of the network interface.</p>
        pub fn status(mut self, input: crate::model::NetworkInterfaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the network interface.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The type of network interface.</p>
        /// <p>Valid values: <code>interface</code> | <code>efa</code> | <code>trunk</code> </p>
        pub fn interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.interface_type = Some(input.into());
            self
        }
        /// <p>The type of network interface.</p>
        /// <p>Valid values: <code>interface</code> | <code>efa</code> | <code>trunk</code> </p>
        pub fn set_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interface_type = input;
            self
        }
        /// Appends an item to `ipv4_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>The IPv4 delegated prefixes that are assigned to the network interface.</p>
        pub fn ipv4_prefixes(mut self, input: crate::model::InstanceIpv4Prefix) -> Self {
            let mut v = self.ipv4_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv4_prefixes = Some(v);
            self
        }
        /// <p>The IPv4 delegated prefixes that are assigned to the network interface.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv4Prefix>>,
        ) -> Self {
            self.ipv4_prefixes = input;
            self
        }
        /// Appends an item to `ipv6_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>The IPv6 delegated prefixes that are assigned to the network interface.</p>
        pub fn ipv6_prefixes(mut self, input: crate::model::InstanceIpv6Prefix) -> Self {
            let mut v = self.ipv6_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv6_prefixes = Some(v);
            self
        }
        /// <p>The IPv6 delegated prefixes that are assigned to the network interface.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Prefix>>,
        ) -> Self {
            self.ipv6_prefixes = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNetworkInterface`](crate::model::InstanceNetworkInterface)
        pub fn build(self) -> crate::model::InstanceNetworkInterface {
            crate::model::InstanceNetworkInterface {
                association: self.association,
                attachment: self.attachment,
                description: self.description,
                groups: self.groups,
                ipv6_addresses: self.ipv6_addresses,
                mac_address: self.mac_address,
                network_interface_id: self.network_interface_id,
                owner_id: self.owner_id,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
                private_ip_addresses: self.private_ip_addresses,
                source_dest_check: self.source_dest_check,
                status: self.status,
                subnet_id: self.subnet_id,
                vpc_id: self.vpc_id,
                interface_type: self.interface_type,
                ipv4_prefixes: self.ipv4_prefixes,
                ipv6_prefixes: self.ipv6_prefixes,
            }
        }
    }
}
impl InstanceNetworkInterface {
    /// Creates a new builder-style object to manufacture [`InstanceNetworkInterface`](crate::model::InstanceNetworkInterface)
    pub fn builder() -> crate::model::instance_network_interface::Builder {
        crate::model::instance_network_interface::Builder::default()
    }
}

/// <p>Information about an IPv6 prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIpv6Prefix {
    /// <p>One or more IPv6 prefixes assigned to the network interface.</p>
    pub ipv6_prefix: std::option::Option<std::string::String>,
}
impl InstanceIpv6Prefix {
    /// <p>One or more IPv6 prefixes assigned to the network interface.</p>
    pub fn ipv6_prefix(&self) -> std::option::Option<&str> {
        self.ipv6_prefix.as_deref()
    }
}
impl std::fmt::Debug for InstanceIpv6Prefix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIpv6Prefix");
        formatter.field("ipv6_prefix", &self.ipv6_prefix);
        formatter.finish()
    }
}
/// See [`InstanceIpv6Prefix`](crate::model::InstanceIpv6Prefix)
pub mod instance_ipv6_prefix {
    /// A builder for [`InstanceIpv6Prefix`](crate::model::InstanceIpv6Prefix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One or more IPv6 prefixes assigned to the network interface.</p>
        pub fn ipv6_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_prefix = Some(input.into());
            self
        }
        /// <p>One or more IPv6 prefixes assigned to the network interface.</p>
        pub fn set_ipv6_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIpv6Prefix`](crate::model::InstanceIpv6Prefix)
        pub fn build(self) -> crate::model::InstanceIpv6Prefix {
            crate::model::InstanceIpv6Prefix {
                ipv6_prefix: self.ipv6_prefix,
            }
        }
    }
}
impl InstanceIpv6Prefix {
    /// Creates a new builder-style object to manufacture [`InstanceIpv6Prefix`](crate::model::InstanceIpv6Prefix)
    pub fn builder() -> crate::model::instance_ipv6_prefix::Builder {
        crate::model::instance_ipv6_prefix::Builder::default()
    }
}

/// <p>Information about an IPv4 prefix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIpv4Prefix {
    /// <p>One or more IPv4 prefixes assigned to the network interface.</p>
    pub ipv4_prefix: std::option::Option<std::string::String>,
}
impl InstanceIpv4Prefix {
    /// <p>One or more IPv4 prefixes assigned to the network interface.</p>
    pub fn ipv4_prefix(&self) -> std::option::Option<&str> {
        self.ipv4_prefix.as_deref()
    }
}
impl std::fmt::Debug for InstanceIpv4Prefix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIpv4Prefix");
        formatter.field("ipv4_prefix", &self.ipv4_prefix);
        formatter.finish()
    }
}
/// See [`InstanceIpv4Prefix`](crate::model::InstanceIpv4Prefix)
pub mod instance_ipv4_prefix {
    /// A builder for [`InstanceIpv4Prefix`](crate::model::InstanceIpv4Prefix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv4_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One or more IPv4 prefixes assigned to the network interface.</p>
        pub fn ipv4_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_prefix = Some(input.into());
            self
        }
        /// <p>One or more IPv4 prefixes assigned to the network interface.</p>
        pub fn set_ipv4_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv4_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIpv4Prefix`](crate::model::InstanceIpv4Prefix)
        pub fn build(self) -> crate::model::InstanceIpv4Prefix {
            crate::model::InstanceIpv4Prefix {
                ipv4_prefix: self.ipv4_prefix,
            }
        }
    }
}
impl InstanceIpv4Prefix {
    /// Creates a new builder-style object to manufacture [`InstanceIpv4Prefix`](crate::model::InstanceIpv4Prefix)
    pub fn builder() -> crate::model::instance_ipv4_prefix::Builder {
        crate::model::instance_ipv4_prefix::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkInterfaceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Associated,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    #[allow(missing_docs)] // documentation missing in model
    InUse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkInterfaceStatus {
    fn from(s: &str) -> Self {
        match s {
            "associated" => NetworkInterfaceStatus::Associated,
            "attaching" => NetworkInterfaceStatus::Attaching,
            "available" => NetworkInterfaceStatus::Available,
            "detaching" => NetworkInterfaceStatus::Detaching,
            "in-use" => NetworkInterfaceStatus::InUse,
            other => NetworkInterfaceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkInterfaceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkInterfaceStatus::from(s))
    }
}
impl NetworkInterfaceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkInterfaceStatus::Associated => "associated",
            NetworkInterfaceStatus::Attaching => "attaching",
            NetworkInterfaceStatus::Available => "available",
            NetworkInterfaceStatus::Detaching => "detaching",
            NetworkInterfaceStatus::InUse => "in-use",
            NetworkInterfaceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "associated",
            "attaching",
            "available",
            "detaching",
            "in-use",
        ]
    }
}
impl AsRef<str> for NetworkInterfaceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a private IPv4 address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstancePrivateIpAddress {
    /// <p>The association information for an Elastic IP address for the network interface.</p>
    pub association: std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
    /// <p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>
    pub primary: std::option::Option<bool>,
    /// <p>The private IPv4 DNS name.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IPv4 address of the network interface.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
}
impl InstancePrivateIpAddress {
    /// <p>The association information for an Elastic IP address for the network interface.</p>
    pub fn association(
        &self,
    ) -> std::option::Option<&crate::model::InstanceNetworkInterfaceAssociation> {
        self.association.as_ref()
    }
    /// <p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>
    pub fn primary(&self) -> std::option::Option<bool> {
        self.primary
    }
    /// <p>The private IPv4 DNS name.</p>
    pub fn private_dns_name(&self) -> std::option::Option<&str> {
        self.private_dns_name.as_deref()
    }
    /// <p>The private IPv4 address of the network interface.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
}
impl std::fmt::Debug for InstancePrivateIpAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstancePrivateIpAddress");
        formatter.field("association", &self.association);
        formatter.field("primary", &self.primary);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.finish()
    }
}
/// See [`InstancePrivateIpAddress`](crate::model::InstancePrivateIpAddress)
pub mod instance_private_ip_address {
    /// A builder for [`InstancePrivateIpAddress`](crate::model::InstancePrivateIpAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association:
            std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
        pub(crate) primary: std::option::Option<bool>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The association information for an Elastic IP address for the network interface.</p>
        pub fn association(
            mut self,
            input: crate::model::InstanceNetworkInterfaceAssociation,
        ) -> Self {
            self.association = Some(input);
            self
        }
        /// <p>The association information for an Elastic IP address for the network interface.</p>
        pub fn set_association(
            mut self,
            input: std::option::Option<crate::model::InstanceNetworkInterfaceAssociation>,
        ) -> Self {
            self.association = input;
            self
        }
        /// <p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>
        pub fn primary(mut self, input: bool) -> Self {
            self.primary = Some(input);
            self
        }
        /// <p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>
        pub fn set_primary(mut self, input: std::option::Option<bool>) -> Self {
            self.primary = input;
            self
        }
        /// <p>The private IPv4 DNS name.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private IPv4 DNS name.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IPv4 address of the network interface.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 address of the network interface.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`InstancePrivateIpAddress`](crate::model::InstancePrivateIpAddress)
        pub fn build(self) -> crate::model::InstancePrivateIpAddress {
            crate::model::InstancePrivateIpAddress {
                association: self.association,
                primary: self.primary,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
            }
        }
    }
}
impl InstancePrivateIpAddress {
    /// Creates a new builder-style object to manufacture [`InstancePrivateIpAddress`](crate::model::InstancePrivateIpAddress)
    pub fn builder() -> crate::model::instance_private_ip_address::Builder {
        crate::model::instance_private_ip_address::Builder::default()
    }
}

/// <p>Describes association information for an Elastic IP address (IPv4).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNetworkInterfaceAssociation {
    /// <p>The carrier IP address associated with the network interface.</p>
    pub carrier_ip: std::option::Option<std::string::String>,
    /// <p>The customer-owned IP address associated with the network interface.</p>
    pub customer_owned_ip: std::option::Option<std::string::String>,
    /// <p>The ID of the owner of the Elastic IP address.</p>
    pub ip_owner_id: std::option::Option<std::string::String>,
    /// <p>The public DNS name.</p>
    pub public_dns_name: std::option::Option<std::string::String>,
    /// <p>The public IP address or Elastic IP address bound to the network interface.</p>
    pub public_ip: std::option::Option<std::string::String>,
}
impl InstanceNetworkInterfaceAssociation {
    /// <p>The carrier IP address associated with the network interface.</p>
    pub fn carrier_ip(&self) -> std::option::Option<&str> {
        self.carrier_ip.as_deref()
    }
    /// <p>The customer-owned IP address associated with the network interface.</p>
    pub fn customer_owned_ip(&self) -> std::option::Option<&str> {
        self.customer_owned_ip.as_deref()
    }
    /// <p>The ID of the owner of the Elastic IP address.</p>
    pub fn ip_owner_id(&self) -> std::option::Option<&str> {
        self.ip_owner_id.as_deref()
    }
    /// <p>The public DNS name.</p>
    pub fn public_dns_name(&self) -> std::option::Option<&str> {
        self.public_dns_name.as_deref()
    }
    /// <p>The public IP address or Elastic IP address bound to the network interface.</p>
    pub fn public_ip(&self) -> std::option::Option<&str> {
        self.public_ip.as_deref()
    }
}
impl std::fmt::Debug for InstanceNetworkInterfaceAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNetworkInterfaceAssociation");
        formatter.field("carrier_ip", &self.carrier_ip);
        formatter.field("customer_owned_ip", &self.customer_owned_ip);
        formatter.field("ip_owner_id", &self.ip_owner_id);
        formatter.field("public_dns_name", &self.public_dns_name);
        formatter.field("public_ip", &self.public_ip);
        formatter.finish()
    }
}
/// See [`InstanceNetworkInterfaceAssociation`](crate::model::InstanceNetworkInterfaceAssociation)
pub mod instance_network_interface_association {
    /// A builder for [`InstanceNetworkInterfaceAssociation`](crate::model::InstanceNetworkInterfaceAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) carrier_ip: std::option::Option<std::string::String>,
        pub(crate) customer_owned_ip: std::option::Option<std::string::String>,
        pub(crate) ip_owner_id: std::option::Option<std::string::String>,
        pub(crate) public_dns_name: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The carrier IP address associated with the network interface.</p>
        pub fn carrier_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.carrier_ip = Some(input.into());
            self
        }
        /// <p>The carrier IP address associated with the network interface.</p>
        pub fn set_carrier_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.carrier_ip = input;
            self
        }
        /// <p>The customer-owned IP address associated with the network interface.</p>
        pub fn customer_owned_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_owned_ip = Some(input.into());
            self
        }
        /// <p>The customer-owned IP address associated with the network interface.</p>
        pub fn set_customer_owned_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_owned_ip = input;
            self
        }
        /// <p>The ID of the owner of the Elastic IP address.</p>
        pub fn ip_owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_owner_id = Some(input.into());
            self
        }
        /// <p>The ID of the owner of the Elastic IP address.</p>
        pub fn set_ip_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_owner_id = input;
            self
        }
        /// <p>The public DNS name.</p>
        pub fn public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns_name = Some(input.into());
            self
        }
        /// <p>The public DNS name.</p>
        pub fn set_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_dns_name = input;
            self
        }
        /// <p>The public IP address or Elastic IP address bound to the network interface.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The public IP address or Elastic IP address bound to the network interface.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNetworkInterfaceAssociation`](crate::model::InstanceNetworkInterfaceAssociation)
        pub fn build(self) -> crate::model::InstanceNetworkInterfaceAssociation {
            crate::model::InstanceNetworkInterfaceAssociation {
                carrier_ip: self.carrier_ip,
                customer_owned_ip: self.customer_owned_ip,
                ip_owner_id: self.ip_owner_id,
                public_dns_name: self.public_dns_name,
                public_ip: self.public_ip,
            }
        }
    }
}
impl InstanceNetworkInterfaceAssociation {
    /// Creates a new builder-style object to manufacture [`InstanceNetworkInterfaceAssociation`](crate::model::InstanceNetworkInterfaceAssociation)
    pub fn builder() -> crate::model::instance_network_interface_association::Builder {
        crate::model::instance_network_interface_association::Builder::default()
    }
}

/// <p>Describes an IPv6 address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceIpv6Address {
    /// <p>The IPv6 address.</p>
    pub ipv6_address: std::option::Option<std::string::String>,
}
impl InstanceIpv6Address {
    /// <p>The IPv6 address.</p>
    pub fn ipv6_address(&self) -> std::option::Option<&str> {
        self.ipv6_address.as_deref()
    }
}
impl std::fmt::Debug for InstanceIpv6Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceIpv6Address");
        formatter.field("ipv6_address", &self.ipv6_address);
        formatter.finish()
    }
}
/// See [`InstanceIpv6Address`](crate::model::InstanceIpv6Address)
pub mod instance_ipv6_address {
    /// A builder for [`InstanceIpv6Address`](crate::model::InstanceIpv6Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv6 address.</p>
        pub fn ipv6_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_address = Some(input.into());
            self
        }
        /// <p>The IPv6 address.</p>
        pub fn set_ipv6_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_address = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceIpv6Address`](crate::model::InstanceIpv6Address)
        pub fn build(self) -> crate::model::InstanceIpv6Address {
            crate::model::InstanceIpv6Address {
                ipv6_address: self.ipv6_address,
            }
        }
    }
}
impl InstanceIpv6Address {
    /// Creates a new builder-style object to manufacture [`InstanceIpv6Address`](crate::model::InstanceIpv6Address)
    pub fn builder() -> crate::model::instance_ipv6_address::Builder {
        crate::model::instance_ipv6_address::Builder::default()
    }
}

/// <p>Describes a network interface attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNetworkInterfaceAttachment {
    /// <p>The time stamp when the attachment initiated.</p>
    pub attach_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ID of the network interface attachment.</p>
    pub attachment_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the network interface is deleted when the instance is terminated.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The index of the device on the instance for the network interface attachment.</p>
    pub device_index: std::option::Option<i32>,
    /// <p>The attachment state.</p>
    pub status: std::option::Option<crate::model::AttachmentStatus>,
    /// <p>The index of the network card.</p>
    pub network_card_index: std::option::Option<i32>,
}
impl InstanceNetworkInterfaceAttachment {
    /// <p>The time stamp when the attachment initiated.</p>
    pub fn attach_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.attach_time.as_ref()
    }
    /// <p>The ID of the network interface attachment.</p>
    pub fn attachment_id(&self) -> std::option::Option<&str> {
        self.attachment_id.as_deref()
    }
    /// <p>Indicates whether the network interface is deleted when the instance is terminated.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The index of the device on the instance for the network interface attachment.</p>
    pub fn device_index(&self) -> std::option::Option<i32> {
        self.device_index
    }
    /// <p>The attachment state.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AttachmentStatus> {
        self.status.as_ref()
    }
    /// <p>The index of the network card.</p>
    pub fn network_card_index(&self) -> std::option::Option<i32> {
        self.network_card_index
    }
}
impl std::fmt::Debug for InstanceNetworkInterfaceAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNetworkInterfaceAttachment");
        formatter.field("attach_time", &self.attach_time);
        formatter.field("attachment_id", &self.attachment_id);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("device_index", &self.device_index);
        formatter.field("status", &self.status);
        formatter.field("network_card_index", &self.network_card_index);
        formatter.finish()
    }
}
/// See [`InstanceNetworkInterfaceAttachment`](crate::model::InstanceNetworkInterfaceAttachment)
pub mod instance_network_interface_attachment {
    /// A builder for [`InstanceNetworkInterfaceAttachment`](crate::model::InstanceNetworkInterfaceAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attach_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) attachment_id: std::option::Option<std::string::String>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) device_index: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::AttachmentStatus>,
        pub(crate) network_card_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The time stamp when the attachment initiated.</p>
        pub fn attach_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.attach_time = Some(input);
            self
        }
        /// <p>The time stamp when the attachment initiated.</p>
        pub fn set_attach_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.attach_time = input;
            self
        }
        /// <p>The ID of the network interface attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// <p>Indicates whether the network interface is deleted when the instance is terminated.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether the network interface is deleted when the instance is terminated.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The index of the device on the instance for the network interface attachment.</p>
        pub fn device_index(mut self, input: i32) -> Self {
            self.device_index = Some(input);
            self
        }
        /// <p>The index of the device on the instance for the network interface attachment.</p>
        pub fn set_device_index(mut self, input: std::option::Option<i32>) -> Self {
            self.device_index = input;
            self
        }
        /// <p>The attachment state.</p>
        pub fn status(mut self, input: crate::model::AttachmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The attachment state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AttachmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The index of the network card.</p>
        pub fn network_card_index(mut self, input: i32) -> Self {
            self.network_card_index = Some(input);
            self
        }
        /// <p>The index of the network card.</p>
        pub fn set_network_card_index(mut self, input: std::option::Option<i32>) -> Self {
            self.network_card_index = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNetworkInterfaceAttachment`](crate::model::InstanceNetworkInterfaceAttachment)
        pub fn build(self) -> crate::model::InstanceNetworkInterfaceAttachment {
            crate::model::InstanceNetworkInterfaceAttachment {
                attach_time: self.attach_time,
                attachment_id: self.attachment_id,
                delete_on_termination: self.delete_on_termination,
                device_index: self.device_index,
                status: self.status,
                network_card_index: self.network_card_index,
            }
        }
    }
}
impl InstanceNetworkInterfaceAttachment {
    /// Creates a new builder-style object to manufacture [`InstanceNetworkInterfaceAttachment`](crate::model::InstanceNetworkInterfaceAttachment)
    pub fn builder() -> crate::model::instance_network_interface_attachment::Builder {
        crate::model::instance_network_interface_attachment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttachmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttachmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "attached" => AttachmentStatus::Attached,
            "attaching" => AttachmentStatus::Attaching,
            "detached" => AttachmentStatus::Detached,
            "detaching" => AttachmentStatus::Detaching,
            other => AttachmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttachmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttachmentStatus::from(s))
    }
}
impl AttachmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttachmentStatus::Attached => "attached",
            AttachmentStatus::Attaching => "attaching",
            AttachmentStatus::Detached => "detached",
            AttachmentStatus::Detaching => "detaching",
            AttachmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["attached", "attaching", "detached", "detaching"]
    }
}
impl AsRef<str> for AttachmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes the association between an instance and an elastic inference accelerator. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticInferenceAcceleratorAssociation {
    /// <p> The Amazon Resource Name (ARN) of the elastic inference accelerator. </p>
    pub elastic_inference_accelerator_arn: std::option::Option<std::string::String>,
    /// <p> The ID of the association. </p>
    pub elastic_inference_accelerator_association_id: std::option::Option<std::string::String>,
    /// <p> The state of the elastic inference accelerator. </p>
    pub elastic_inference_accelerator_association_state: std::option::Option<std::string::String>,
    /// <p> The time at which the elastic inference accelerator is associated with an instance. </p>
    pub elastic_inference_accelerator_association_time:
        std::option::Option<aws_smithy_types::DateTime>,
}
impl ElasticInferenceAcceleratorAssociation {
    /// <p> The Amazon Resource Name (ARN) of the elastic inference accelerator. </p>
    pub fn elastic_inference_accelerator_arn(&self) -> std::option::Option<&str> {
        self.elastic_inference_accelerator_arn.as_deref()
    }
    /// <p> The ID of the association. </p>
    pub fn elastic_inference_accelerator_association_id(&self) -> std::option::Option<&str> {
        self.elastic_inference_accelerator_association_id.as_deref()
    }
    /// <p> The state of the elastic inference accelerator. </p>
    pub fn elastic_inference_accelerator_association_state(&self) -> std::option::Option<&str> {
        self.elastic_inference_accelerator_association_state
            .as_deref()
    }
    /// <p> The time at which the elastic inference accelerator is associated with an instance. </p>
    pub fn elastic_inference_accelerator_association_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.elastic_inference_accelerator_association_time.as_ref()
    }
}
impl std::fmt::Debug for ElasticInferenceAcceleratorAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticInferenceAcceleratorAssociation");
        formatter.field(
            "elastic_inference_accelerator_arn",
            &self.elastic_inference_accelerator_arn,
        );
        formatter.field(
            "elastic_inference_accelerator_association_id",
            &self.elastic_inference_accelerator_association_id,
        );
        formatter.field(
            "elastic_inference_accelerator_association_state",
            &self.elastic_inference_accelerator_association_state,
        );
        formatter.field(
            "elastic_inference_accelerator_association_time",
            &self.elastic_inference_accelerator_association_time,
        );
        formatter.finish()
    }
}
/// See [`ElasticInferenceAcceleratorAssociation`](crate::model::ElasticInferenceAcceleratorAssociation)
pub mod elastic_inference_accelerator_association {
    /// A builder for [`ElasticInferenceAcceleratorAssociation`](crate::model::ElasticInferenceAcceleratorAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_inference_accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) elastic_inference_accelerator_association_id:
            std::option::Option<std::string::String>,
        pub(crate) elastic_inference_accelerator_association_state:
            std::option::Option<std::string::String>,
        pub(crate) elastic_inference_accelerator_association_time:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the elastic inference accelerator. </p>
        pub fn elastic_inference_accelerator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the elastic inference accelerator. </p>
        pub fn set_elastic_inference_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_arn = input;
            self
        }
        /// <p> The ID of the association. </p>
        pub fn elastic_inference_accelerator_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_association_id = Some(input.into());
            self
        }
        /// <p> The ID of the association. </p>
        pub fn set_elastic_inference_accelerator_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_association_id = input;
            self
        }
        /// <p> The state of the elastic inference accelerator. </p>
        pub fn elastic_inference_accelerator_association_state(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_association_state = Some(input.into());
            self
        }
        /// <p> The state of the elastic inference accelerator. </p>
        pub fn set_elastic_inference_accelerator_association_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_inference_accelerator_association_state = input;
            self
        }
        /// <p> The time at which the elastic inference accelerator is associated with an instance. </p>
        pub fn elastic_inference_accelerator_association_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.elastic_inference_accelerator_association_time = Some(input);
            self
        }
        /// <p> The time at which the elastic inference accelerator is associated with an instance. </p>
        pub fn set_elastic_inference_accelerator_association_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.elastic_inference_accelerator_association_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticInferenceAcceleratorAssociation`](crate::model::ElasticInferenceAcceleratorAssociation)
        pub fn build(self) -> crate::model::ElasticInferenceAcceleratorAssociation {
            crate::model::ElasticInferenceAcceleratorAssociation {
                elastic_inference_accelerator_arn: self.elastic_inference_accelerator_arn,
                elastic_inference_accelerator_association_id: self
                    .elastic_inference_accelerator_association_id,
                elastic_inference_accelerator_association_state: self
                    .elastic_inference_accelerator_association_state,
                elastic_inference_accelerator_association_time: self
                    .elastic_inference_accelerator_association_time,
            }
        }
    }
}
impl ElasticInferenceAcceleratorAssociation {
    /// Creates a new builder-style object to manufacture [`ElasticInferenceAcceleratorAssociation`](crate::model::ElasticInferenceAcceleratorAssociation)
    pub fn builder() -> crate::model::elastic_inference_accelerator_association::Builder {
        crate::model::elastic_inference_accelerator_association::Builder::default()
    }
}

/// <p>Describes the association between an instance and an Elastic Graphics accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticGpuAssociation {
    /// <p>The ID of the Elastic Graphics accelerator.</p>
    pub elastic_gpu_id: std::option::Option<std::string::String>,
    /// <p>The ID of the association.</p>
    pub elastic_gpu_association_id: std::option::Option<std::string::String>,
    /// <p>The state of the association between the instance and the Elastic Graphics accelerator.</p>
    pub elastic_gpu_association_state: std::option::Option<std::string::String>,
    /// <p>The time the Elastic Graphics accelerator was associated with the instance.</p>
    pub elastic_gpu_association_time: std::option::Option<std::string::String>,
}
impl ElasticGpuAssociation {
    /// <p>The ID of the Elastic Graphics accelerator.</p>
    pub fn elastic_gpu_id(&self) -> std::option::Option<&str> {
        self.elastic_gpu_id.as_deref()
    }
    /// <p>The ID of the association.</p>
    pub fn elastic_gpu_association_id(&self) -> std::option::Option<&str> {
        self.elastic_gpu_association_id.as_deref()
    }
    /// <p>The state of the association between the instance and the Elastic Graphics accelerator.</p>
    pub fn elastic_gpu_association_state(&self) -> std::option::Option<&str> {
        self.elastic_gpu_association_state.as_deref()
    }
    /// <p>The time the Elastic Graphics accelerator was associated with the instance.</p>
    pub fn elastic_gpu_association_time(&self) -> std::option::Option<&str> {
        self.elastic_gpu_association_time.as_deref()
    }
}
impl std::fmt::Debug for ElasticGpuAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticGpuAssociation");
        formatter.field("elastic_gpu_id", &self.elastic_gpu_id);
        formatter.field(
            "elastic_gpu_association_id",
            &self.elastic_gpu_association_id,
        );
        formatter.field(
            "elastic_gpu_association_state",
            &self.elastic_gpu_association_state,
        );
        formatter.field(
            "elastic_gpu_association_time",
            &self.elastic_gpu_association_time,
        );
        formatter.finish()
    }
}
/// See [`ElasticGpuAssociation`](crate::model::ElasticGpuAssociation)
pub mod elastic_gpu_association {
    /// A builder for [`ElasticGpuAssociation`](crate::model::ElasticGpuAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_gpu_id: std::option::Option<std::string::String>,
        pub(crate) elastic_gpu_association_id: std::option::Option<std::string::String>,
        pub(crate) elastic_gpu_association_state: std::option::Option<std::string::String>,
        pub(crate) elastic_gpu_association_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Elastic Graphics accelerator.</p>
        pub fn elastic_gpu_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_gpu_id = Some(input.into());
            self
        }
        /// <p>The ID of the Elastic Graphics accelerator.</p>
        pub fn set_elastic_gpu_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_gpu_id = input;
            self
        }
        /// <p>The ID of the association.</p>
        pub fn elastic_gpu_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_gpu_association_id = Some(input.into());
            self
        }
        /// <p>The ID of the association.</p>
        pub fn set_elastic_gpu_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_gpu_association_id = input;
            self
        }
        /// <p>The state of the association between the instance and the Elastic Graphics accelerator.</p>
        pub fn elastic_gpu_association_state(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_gpu_association_state = Some(input.into());
            self
        }
        /// <p>The state of the association between the instance and the Elastic Graphics accelerator.</p>
        pub fn set_elastic_gpu_association_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_gpu_association_state = input;
            self
        }
        /// <p>The time the Elastic Graphics accelerator was associated with the instance.</p>
        pub fn elastic_gpu_association_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_gpu_association_time = Some(input.into());
            self
        }
        /// <p>The time the Elastic Graphics accelerator was associated with the instance.</p>
        pub fn set_elastic_gpu_association_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_gpu_association_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticGpuAssociation`](crate::model::ElasticGpuAssociation)
        pub fn build(self) -> crate::model::ElasticGpuAssociation {
            crate::model::ElasticGpuAssociation {
                elastic_gpu_id: self.elastic_gpu_id,
                elastic_gpu_association_id: self.elastic_gpu_association_id,
                elastic_gpu_association_state: self.elastic_gpu_association_state,
                elastic_gpu_association_time: self.elastic_gpu_association_time,
            }
        }
    }
}
impl ElasticGpuAssociation {
    /// Creates a new builder-style object to manufacture [`ElasticGpuAssociation`](crate::model::ElasticGpuAssociation)
    pub fn builder() -> crate::model::elastic_gpu_association::Builder {
        crate::model::elastic_gpu_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceLifecycleType {
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Spot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceLifecycleType {
    fn from(s: &str) -> Self {
        match s {
            "scheduled" => InstanceLifecycleType::Scheduled,
            "spot" => InstanceLifecycleType::Spot,
            other => InstanceLifecycleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceLifecycleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceLifecycleType::from(s))
    }
}
impl InstanceLifecycleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceLifecycleType::Scheduled => "scheduled",
            InstanceLifecycleType::Spot => "spot",
            InstanceLifecycleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["scheduled", "spot"]
    }
}
impl AsRef<str> for InstanceLifecycleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an IAM instance profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamInstanceProfile {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the instance profile.</p>
    pub id: std::option::Option<std::string::String>,
}
impl IamInstanceProfile {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ID of the instance profile.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for IamInstanceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamInstanceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`IamInstanceProfile`](crate::model::IamInstanceProfile)
pub mod iam_instance_profile {
    /// A builder for [`IamInstanceProfile`](crate::model::IamInstanceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the instance profile.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the instance profile.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`IamInstanceProfile`](crate::model::IamInstanceProfile)
        pub fn build(self) -> crate::model::IamInstanceProfile {
            crate::model::IamInstanceProfile {
                arn: self.arn,
                id: self.id,
            }
        }
    }
}
impl IamInstanceProfile {
    /// Creates a new builder-style object to manufacture [`IamInstanceProfile`](crate::model::IamInstanceProfile)
    pub fn builder() -> crate::model::iam_instance_profile::Builder {
        crate::model::iam_instance_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HypervisorType {
    #[allow(missing_docs)] // documentation missing in model
    Ovm,
    #[allow(missing_docs)] // documentation missing in model
    Xen,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HypervisorType {
    fn from(s: &str) -> Self {
        match s {
            "ovm" => HypervisorType::Ovm,
            "xen" => HypervisorType::Xen,
            other => HypervisorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HypervisorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HypervisorType::from(s))
    }
}
impl HypervisorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HypervisorType::Ovm => "ovm",
            HypervisorType::Xen => "xen",
            HypervisorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ovm", "xen"]
    }
}
impl AsRef<str> for HypervisorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a block device mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceBlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
    pub ebs: std::option::Option<crate::model::EbsInstanceBlockDevice>,
}
impl InstanceBlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::EbsInstanceBlockDevice> {
        self.ebs.as_ref()
    }
}
impl std::fmt::Debug for InstanceBlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceBlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.finish()
    }
}
/// See [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
pub mod instance_block_device_mapping {
    /// A builder for [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::EbsInstanceBlockDevice>,
    }
    impl Builder {
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
        pub fn ebs(mut self, input: crate::model::EbsInstanceBlockDevice) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
        pub fn set_ebs(
            mut self,
            input: std::option::Option<crate::model::EbsInstanceBlockDevice>,
        ) -> Self {
            self.ebs = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
        pub fn build(self) -> crate::model::InstanceBlockDeviceMapping {
            crate::model::InstanceBlockDeviceMapping {
                device_name: self.device_name,
                ebs: self.ebs,
            }
        }
    }
}
impl InstanceBlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    pub fn builder() -> crate::model::instance_block_device_mapping::Builder {
        crate::model::instance_block_device_mapping::Builder::default()
    }
}

/// <p>Describes a parameter used to set up an EBS volume in a block device mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsInstanceBlockDevice {
    /// <p>The time stamp when the attachment initiated.</p>
    pub attach_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the volume is deleted on instance termination.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The attachment state.</p>
    pub status: std::option::Option<crate::model::AttachmentStatus>,
    /// <p>The ID of the EBS volume.</p>
    pub volume_id: std::option::Option<std::string::String>,
}
impl EbsInstanceBlockDevice {
    /// <p>The time stamp when the attachment initiated.</p>
    pub fn attach_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.attach_time.as_ref()
    }
    /// <p>Indicates whether the volume is deleted on instance termination.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The attachment state.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AttachmentStatus> {
        self.status.as_ref()
    }
    /// <p>The ID of the EBS volume.</p>
    pub fn volume_id(&self) -> std::option::Option<&str> {
        self.volume_id.as_deref()
    }
}
impl std::fmt::Debug for EbsInstanceBlockDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsInstanceBlockDevice");
        formatter.field("attach_time", &self.attach_time);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("status", &self.status);
        formatter.field("volume_id", &self.volume_id);
        formatter.finish()
    }
}
/// See [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
pub mod ebs_instance_block_device {
    /// A builder for [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attach_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::AttachmentStatus>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time stamp when the attachment initiated.</p>
        pub fn attach_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.attach_time = Some(input);
            self
        }
        /// <p>The time stamp when the attachment initiated.</p>
        pub fn set_attach_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.attach_time = input;
            self
        }
        /// <p>Indicates whether the volume is deleted on instance termination.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether the volume is deleted on instance termination.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The attachment state.</p>
        pub fn status(mut self, input: crate::model::AttachmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The attachment state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AttachmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The ID of the EBS volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the EBS volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
        pub fn build(self) -> crate::model::EbsInstanceBlockDevice {
            crate::model::EbsInstanceBlockDevice {
                attach_time: self.attach_time,
                delete_on_termination: self.delete_on_termination,
                status: self.status,
                volume_id: self.volume_id,
            }
        }
    }
}
impl EbsInstanceBlockDevice {
    /// Creates a new builder-style object to manufacture [`EbsInstanceBlockDevice`](crate::model::EbsInstanceBlockDevice)
    pub fn builder() -> crate::model::ebs_instance_block_device::Builder {
        crate::model::ebs_instance_block_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArchitectureValues {
    #[allow(missing_docs)] // documentation missing in model
    Arm64,
    #[allow(missing_docs)] // documentation missing in model
    I386,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    #[allow(missing_docs)] // documentation missing in model
    X8664Mac,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArchitectureValues {
    fn from(s: &str) -> Self {
        match s {
            "arm64" => ArchitectureValues::Arm64,
            "i386" => ArchitectureValues::I386,
            "x86_64" => ArchitectureValues::X8664,
            "x86_64_mac" => ArchitectureValues::X8664Mac,
            other => ArchitectureValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArchitectureValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArchitectureValues::from(s))
    }
}
impl ArchitectureValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArchitectureValues::Arm64 => "arm64",
            ArchitectureValues::I386 => "i386",
            ArchitectureValues::X8664 => "x86_64",
            ArchitectureValues::X8664Mac => "x86_64_mac",
            ArchitectureValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["arm64", "i386", "x86_64", "x86_64_mac"]
    }
}
impl AsRef<str> for ArchitectureValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a product code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductCode {
    /// <p>The product code.</p>
    pub product_code_id: std::option::Option<std::string::String>,
    /// <p>The type of product code.</p>
    pub product_code_type: std::option::Option<crate::model::ProductCodeValues>,
}
impl ProductCode {
    /// <p>The product code.</p>
    pub fn product_code_id(&self) -> std::option::Option<&str> {
        self.product_code_id.as_deref()
    }
    /// <p>The type of product code.</p>
    pub fn product_code_type(&self) -> std::option::Option<&crate::model::ProductCodeValues> {
        self.product_code_type.as_ref()
    }
}
impl std::fmt::Debug for ProductCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductCode");
        formatter.field("product_code_id", &self.product_code_id);
        formatter.field("product_code_type", &self.product_code_type);
        formatter.finish()
    }
}
/// See [`ProductCode`](crate::model::ProductCode)
pub mod product_code {
    /// A builder for [`ProductCode`](crate::model::ProductCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_code_id: std::option::Option<std::string::String>,
        pub(crate) product_code_type: std::option::Option<crate::model::ProductCodeValues>,
    }
    impl Builder {
        /// <p>The product code.</p>
        pub fn product_code_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code_id = Some(input.into());
            self
        }
        /// <p>The product code.</p>
        pub fn set_product_code_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_code_id = input;
            self
        }
        /// <p>The type of product code.</p>
        pub fn product_code_type(mut self, input: crate::model::ProductCodeValues) -> Self {
            self.product_code_type = Some(input);
            self
        }
        /// <p>The type of product code.</p>
        pub fn set_product_code_type(
            mut self,
            input: std::option::Option<crate::model::ProductCodeValues>,
        ) -> Self {
            self.product_code_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductCode`](crate::model::ProductCode)
        pub fn build(self) -> crate::model::ProductCode {
            crate::model::ProductCode {
                product_code_id: self.product_code_id,
                product_code_type: self.product_code_type,
            }
        }
    }
}
impl ProductCode {
    /// Creates a new builder-style object to manufacture [`ProductCode`](crate::model::ProductCode)
    pub fn builder() -> crate::model::product_code::Builder {
        crate::model::product_code::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductCodeValues {
    #[allow(missing_docs)] // documentation missing in model
    Devpay,
    #[allow(missing_docs)] // documentation missing in model
    Marketplace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductCodeValues {
    fn from(s: &str) -> Self {
        match s {
            "devpay" => ProductCodeValues::Devpay,
            "marketplace" => ProductCodeValues::Marketplace,
            other => ProductCodeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductCodeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductCodeValues::from(s))
    }
}
impl ProductCodeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductCodeValues::Devpay => "devpay",
            ProductCodeValues::Marketplace => "marketplace",
            ProductCodeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["devpay", "marketplace"]
    }
}
impl AsRef<str> for ProductCodeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformValues {
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformValues {
    fn from(s: &str) -> Self {
        match s {
            "Windows" => PlatformValues::Windows,
            other => PlatformValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformValues::from(s))
    }
}
impl PlatformValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformValues::Windows => "Windows",
            PlatformValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Windows"]
    }
}
impl AsRef<str> for PlatformValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the placement of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Placement {
    /// <p>The Availability Zone of the instance.</p>
    /// <p>If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub affinity: std::option::Option<std::string::String>,
    /// <p>The name of the placement group the instance is in.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The number of the partition that the instance is in. Valid only if the placement group strategy is set to <code>partition</code>.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub partition_number: std::option::Option<i32>,
    /// <p>The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub host_id: std::option::Option<std::string::String>,
    /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    /// <p>T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.</p>
    pub tenancy: std::option::Option<crate::model::Tenancy>,
    /// <p>Reserved for future use.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub spread_domain: std::option::Option<std::string::String>,
    /// <p>The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub host_resource_group_arn: std::option::Option<std::string::String>,
}
impl Placement {
    /// <p>The Availability Zone of the instance.</p>
    /// <p>If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn affinity(&self) -> std::option::Option<&str> {
        self.affinity.as_deref()
    }
    /// <p>The name of the placement group the instance is in.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The number of the partition that the instance is in. Valid only if the placement group strategy is set to <code>partition</code>.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn partition_number(&self) -> std::option::Option<i32> {
        self.partition_number
    }
    /// <p>The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn host_id(&self) -> std::option::Option<&str> {
        self.host_id.as_deref()
    }
    /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    /// <p>T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.</p>
    pub fn tenancy(&self) -> std::option::Option<&crate::model::Tenancy> {
        self.tenancy.as_ref()
    }
    /// <p>Reserved for future use.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn spread_domain(&self) -> std::option::Option<&str> {
        self.spread_domain.as_deref()
    }
    /// <p>The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.</p>
    /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
    pub fn host_resource_group_arn(&self) -> std::option::Option<&str> {
        self.host_resource_group_arn.as_deref()
    }
}
impl std::fmt::Debug for Placement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Placement");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("affinity", &self.affinity);
        formatter.field("group_name", &self.group_name);
        formatter.field("partition_number", &self.partition_number);
        formatter.field("host_id", &self.host_id);
        formatter.field("tenancy", &self.tenancy);
        formatter.field("spread_domain", &self.spread_domain);
        formatter.field("host_resource_group_arn", &self.host_resource_group_arn);
        formatter.finish()
    }
}
/// See [`Placement`](crate::model::Placement)
pub mod placement {
    /// A builder for [`Placement`](crate::model::Placement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) affinity: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) partition_number: std::option::Option<i32>,
        pub(crate) host_id: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<crate::model::Tenancy>,
        pub(crate) spread_domain: std::option::Option<std::string::String>,
        pub(crate) host_resource_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Availability Zone of the instance.</p>
        /// <p>If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of the instance.</p>
        /// <p>If not specified, an Availability Zone will be automatically chosen for you based on the load balancing criteria for the Region.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn affinity(mut self, input: impl Into<std::string::String>) -> Self {
            self.affinity = Some(input.into());
            self
        }
        /// <p>The affinity setting for the instance on the Dedicated Host. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_affinity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.affinity = input;
            self
        }
        /// <p>The name of the placement group the instance is in.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the placement group the instance is in.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The number of the partition that the instance is in. Valid only if the placement group strategy is set to <code>partition</code>.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn partition_number(mut self, input: i32) -> Self {
            self.partition_number = Some(input);
            self
        }
        /// <p>The number of the partition that the instance is in. Valid only if the placement group strategy is set to <code>partition</code>.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_partition_number(mut self, input: std::option::Option<i32>) -> Self {
            self.partition_number = input;
            self
        }
        /// <p>The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn host_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_id = Some(input.into());
            self
        }
        /// <p>The ID of the Dedicated Host on which the instance resides. This parameter is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_host_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_id = input;
            self
        }
        /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        /// <p>T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html">ImportInstance</a> command.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        /// <p>T3 instances that use the <code>unlimited</code> CPU credit option do not support <code>host</code> tenancy.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>Reserved for future use.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn spread_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.spread_domain = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_spread_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spread_domain = input;
            self
        }
        /// <p>The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn host_resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the <b>Tenancy</b> parameter or set it to <code>host</code>.</p>
        /// <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>
        pub fn set_host_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.host_resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Placement`](crate::model::Placement)
        pub fn build(self) -> crate::model::Placement {
            crate::model::Placement {
                availability_zone: self.availability_zone,
                affinity: self.affinity,
                group_name: self.group_name,
                partition_number: self.partition_number,
                host_id: self.host_id,
                tenancy: self.tenancy,
                spread_domain: self.spread_domain,
                host_resource_group_arn: self.host_resource_group_arn,
            }
        }
    }
}
impl Placement {
    /// Creates a new builder-style object to manufacture [`Placement`](crate::model::Placement)
    pub fn builder() -> crate::model::placement::Builder {
        crate::model::placement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Tenancy {
    #[allow(missing_docs)] // documentation missing in model
    Dedicated,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Tenancy {
    fn from(s: &str) -> Self {
        match s {
            "dedicated" => Tenancy::Dedicated,
            "default" => Tenancy::Default,
            "host" => Tenancy::Host,
            other => Tenancy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Tenancy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Tenancy::from(s))
    }
}
impl Tenancy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Tenancy::Dedicated => "dedicated",
            Tenancy::Default => "default",
            Tenancy::Host => "host",
            Tenancy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["dedicated", "default", "host"]
    }
}
impl AsRef<str> for Tenancy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceType {
    #[allow(missing_docs)] // documentation missing in model
    A12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    A14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    A1Large,
    #[allow(missing_docs)] // documentation missing in model
    A1Medium,
    #[allow(missing_docs)] // documentation missing in model
    A1Metal,
    #[allow(missing_docs)] // documentation missing in model
    A1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C1Medium,
    #[allow(missing_docs)] // documentation missing in model
    C1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C3Large,
    #[allow(missing_docs)] // documentation missing in model
    C3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C4Large,
    #[allow(missing_docs)] // documentation missing in model
    C4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C518xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C59xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5Large,
    #[allow(missing_docs)] // documentation missing in model
    C5Metal,
    #[allow(missing_docs)] // documentation missing in model
    C5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5ad8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5adLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5adXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d18xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5d9xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5dLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5dMetal,
    #[allow(missing_docs)] // documentation missing in model
    C5dXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5n18xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5n2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5n4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5n9xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C5nLarge,
    #[allow(missing_docs)] // documentation missing in model
    C5nMetal,
    #[allow(missing_docs)] // documentation missing in model
    C5nXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    C6gMetal,
    #[allow(missing_docs)] // documentation missing in model
    C6gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gd12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gd16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gd2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gd4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gd8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gdLarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gdMedium,
    #[allow(missing_docs)] // documentation missing in model
    C6gdMetal,
    #[allow(missing_docs)] // documentation missing in model
    C6gdXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gnLarge,
    #[allow(missing_docs)] // documentation missing in model
    C6gnMedium,
    #[allow(missing_docs)] // documentation missing in model
    C6gnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6i8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    C6iLarge,
    #[allow(missing_docs)] // documentation missing in model
    C6iMetal,
    #[allow(missing_docs)] // documentation missing in model
    C6iXlarge,
    #[allow(missing_docs)] // documentation missing in model
    Cc14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Cc28xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Cg14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Cr18xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D28xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3en12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3en2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3en4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3en6xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3en8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    D3enXlarge,
    #[allow(missing_docs)] // documentation missing in model
    Dl124xlarge,
    #[allow(missing_docs)] // documentation missing in model
    F116xlarge,
    #[allow(missing_docs)] // documentation missing in model
    F12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    F14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G28xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G316xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G3sXlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4ad16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4ad2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4ad4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4ad8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4adXlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G4dnMetal,
    #[allow(missing_docs)] // documentation missing in model
    G4dnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    G512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G548xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    G5gMetal,
    #[allow(missing_docs)] // documentation missing in model
    G5gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    H116xlarge,
    #[allow(missing_docs)] // documentation missing in model
    H12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    H14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    H18xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Hi14xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Hpc6a48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Hs18xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I28xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I316xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3Large,
    #[allow(missing_docs)] // documentation missing in model
    I3Metal,
    #[allow(missing_docs)] // documentation missing in model
    I3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3en12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3en24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3en2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3en3xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3en6xlarge,
    #[allow(missing_docs)] // documentation missing in model
    I3enLarge,
    #[allow(missing_docs)] // documentation missing in model
    I3enMetal,
    #[allow(missing_docs)] // documentation missing in model
    I3enXlarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gnLarge,
    #[allow(missing_docs)] // documentation missing in model
    Im4gnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    Inf124xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Inf12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Inf16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Inf1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Is4gen2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Is4gen4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Is4gen8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Is4genLarge,
    #[allow(missing_docs)] // documentation missing in model
    Is4genMedium,
    #[allow(missing_docs)] // documentation missing in model
    Is4genXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M1Large,
    #[allow(missing_docs)] // documentation missing in model
    M1Medium,
    #[allow(missing_docs)] // documentation missing in model
    M1Small,
    #[allow(missing_docs)] // documentation missing in model
    M1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M3Large,
    #[allow(missing_docs)] // documentation missing in model
    M3Medium,
    #[allow(missing_docs)] // documentation missing in model
    M3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M410xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M416xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M4Large,
    #[allow(missing_docs)] // documentation missing in model
    M4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5Large,
    #[allow(missing_docs)] // documentation missing in model
    M5Metal,
    #[allow(missing_docs)] // documentation missing in model
    M5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5ad8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5adLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5adXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5d8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dMetal,
    #[allow(missing_docs)] // documentation missing in model
    M5dXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dnLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5dnMetal,
    #[allow(missing_docs)] // documentation missing in model
    M5dnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5n8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5nLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5nMetal,
    #[allow(missing_docs)] // documentation missing in model
    M5nXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5zn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5zn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5zn3xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5zn6xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M5znLarge,
    #[allow(missing_docs)] // documentation missing in model
    M5znMetal,
    #[allow(missing_docs)] // documentation missing in model
    M5znXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6aLarge,
    #[allow(missing_docs)] // documentation missing in model
    M6aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    M6gMetal,
    #[allow(missing_docs)] // documentation missing in model
    M6gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gd12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gd16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gd2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gd4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gd8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gdLarge,
    #[allow(missing_docs)] // documentation missing in model
    M6gdMedium,
    #[allow(missing_docs)] // documentation missing in model
    M6gdMetal,
    #[allow(missing_docs)] // documentation missing in model
    M6gdXlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6i8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    M6iLarge,
    #[allow(missing_docs)] // documentation missing in model
    M6iMetal,
    #[allow(missing_docs)] // documentation missing in model
    M6iXlarge,
    #[allow(missing_docs)] // documentation missing in model
    Mac1Metal,
    #[allow(missing_docs)] // documentation missing in model
    P216xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P28xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P316xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P3dn24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    P4d24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R34xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R38xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R3Large,
    #[allow(missing_docs)] // documentation missing in model
    R3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R416xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R42xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R44xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R48xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R4Large,
    #[allow(missing_docs)] // documentation missing in model
    R4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R512xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R516xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R524xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R52xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R54xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R58xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5Large,
    #[allow(missing_docs)] // documentation missing in model
    R5Metal,
    #[allow(missing_docs)] // documentation missing in model
    R5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5a8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5ad8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5adLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5adXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5b8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5bLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5bMetal,
    #[allow(missing_docs)] // documentation missing in model
    R5bXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5d8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dMetal,
    #[allow(missing_docs)] // documentation missing in model
    R5dXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dnLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5dnMetal,
    #[allow(missing_docs)] // documentation missing in model
    R5dnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5n8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R5nLarge,
    #[allow(missing_docs)] // documentation missing in model
    R5nMetal,
    #[allow(missing_docs)] // documentation missing in model
    R5nXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6g8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gLarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gMedium,
    #[allow(missing_docs)] // documentation missing in model
    R6gMetal,
    #[allow(missing_docs)] // documentation missing in model
    R6gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gd12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gd16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gd2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gd4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gd8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gdLarge,
    #[allow(missing_docs)] // documentation missing in model
    R6gdMedium,
    #[allow(missing_docs)] // documentation missing in model
    R6gdMetal,
    #[allow(missing_docs)] // documentation missing in model
    R6gdXlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i24xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6i8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R6iLarge,
    #[allow(missing_docs)] // documentation missing in model
    R6iMetal,
    #[allow(missing_docs)] // documentation missing in model
    R6iXlarge,
    #[allow(missing_docs)] // documentation missing in model
    T1Micro,
    #[allow(missing_docs)] // documentation missing in model
    T22xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T2Large,
    #[allow(missing_docs)] // documentation missing in model
    T2Medium,
    #[allow(missing_docs)] // documentation missing in model
    T2Micro,
    #[allow(missing_docs)] // documentation missing in model
    T2Nano,
    #[allow(missing_docs)] // documentation missing in model
    T2Small,
    #[allow(missing_docs)] // documentation missing in model
    T2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T3Large,
    #[allow(missing_docs)] // documentation missing in model
    T3Medium,
    #[allow(missing_docs)] // documentation missing in model
    T3Micro,
    #[allow(missing_docs)] // documentation missing in model
    T3Nano,
    #[allow(missing_docs)] // documentation missing in model
    T3Small,
    #[allow(missing_docs)] // documentation missing in model
    T3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T3a2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T3aLarge,
    #[allow(missing_docs)] // documentation missing in model
    T3aMedium,
    #[allow(missing_docs)] // documentation missing in model
    T3aMicro,
    #[allow(missing_docs)] // documentation missing in model
    T3aNano,
    #[allow(missing_docs)] // documentation missing in model
    T3aSmall,
    #[allow(missing_docs)] // documentation missing in model
    T3aXlarge,
    #[allow(missing_docs)] // documentation missing in model
    T4g2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    T4gLarge,
    #[allow(missing_docs)] // documentation missing in model
    T4gMedium,
    #[allow(missing_docs)] // documentation missing in model
    T4gMicro,
    #[allow(missing_docs)] // documentation missing in model
    T4gNano,
    #[allow(missing_docs)] // documentation missing in model
    T4gSmall,
    #[allow(missing_docs)] // documentation missing in model
    T4gXlarge,
    #[allow(missing_docs)] // documentation missing in model
    U12tb1112xlarge,
    #[allow(missing_docs)] // documentation missing in model
    U12tb1Metal,
    #[allow(missing_docs)] // documentation missing in model
    U18tb1Metal,
    #[allow(missing_docs)] // documentation missing in model
    U24tb1Metal,
    #[allow(missing_docs)] // documentation missing in model
    U6tb1112xlarge,
    #[allow(missing_docs)] // documentation missing in model
    U6tb156xlarge,
    #[allow(missing_docs)] // documentation missing in model
    U6tb1Metal,
    #[allow(missing_docs)] // documentation missing in model
    U9tb1112xlarge,
    #[allow(missing_docs)] // documentation missing in model
    U9tb1Metal,
    #[allow(missing_docs)] // documentation missing in model
    Vt124xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Vt13xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Vt16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X116xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X132xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1e16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1e2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1e32xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1e4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1e8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X1eXlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gd12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gd16xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gd2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gd4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gd8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gdLarge,
    #[allow(missing_docs)] // documentation missing in model
    X2gdMedium,
    #[allow(missing_docs)] // documentation missing in model
    X2gdMetal,
    #[allow(missing_docs)] // documentation missing in model
    X2gdXlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2iezn12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2iezn2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2iezn4xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2iezn6xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2iezn8xlarge,
    #[allow(missing_docs)] // documentation missing in model
    X2ieznMetal,
    #[allow(missing_docs)] // documentation missing in model
    Z1d12xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Z1d2xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Z1d3xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Z1d6xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Z1dLarge,
    #[allow(missing_docs)] // documentation missing in model
    Z1dMetal,
    #[allow(missing_docs)] // documentation missing in model
    Z1dXlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceType {
    fn from(s: &str) -> Self {
        match s {
            "a1.2xlarge" => InstanceType::A12xlarge,
            "a1.4xlarge" => InstanceType::A14xlarge,
            "a1.large" => InstanceType::A1Large,
            "a1.medium" => InstanceType::A1Medium,
            "a1.metal" => InstanceType::A1Metal,
            "a1.xlarge" => InstanceType::A1Xlarge,
            "c1.medium" => InstanceType::C1Medium,
            "c1.xlarge" => InstanceType::C1Xlarge,
            "c3.2xlarge" => InstanceType::C32xlarge,
            "c3.4xlarge" => InstanceType::C34xlarge,
            "c3.8xlarge" => InstanceType::C38xlarge,
            "c3.large" => InstanceType::C3Large,
            "c3.xlarge" => InstanceType::C3Xlarge,
            "c4.2xlarge" => InstanceType::C42xlarge,
            "c4.4xlarge" => InstanceType::C44xlarge,
            "c4.8xlarge" => InstanceType::C48xlarge,
            "c4.large" => InstanceType::C4Large,
            "c4.xlarge" => InstanceType::C4Xlarge,
            "c5.12xlarge" => InstanceType::C512xlarge,
            "c5.18xlarge" => InstanceType::C518xlarge,
            "c5.24xlarge" => InstanceType::C524xlarge,
            "c5.2xlarge" => InstanceType::C52xlarge,
            "c5.4xlarge" => InstanceType::C54xlarge,
            "c5.9xlarge" => InstanceType::C59xlarge,
            "c5.large" => InstanceType::C5Large,
            "c5.metal" => InstanceType::C5Metal,
            "c5.xlarge" => InstanceType::C5Xlarge,
            "c5a.12xlarge" => InstanceType::C5a12xlarge,
            "c5a.16xlarge" => InstanceType::C5a16xlarge,
            "c5a.24xlarge" => InstanceType::C5a24xlarge,
            "c5a.2xlarge" => InstanceType::C5a2xlarge,
            "c5a.4xlarge" => InstanceType::C5a4xlarge,
            "c5a.8xlarge" => InstanceType::C5a8xlarge,
            "c5a.large" => InstanceType::C5aLarge,
            "c5a.xlarge" => InstanceType::C5aXlarge,
            "c5ad.12xlarge" => InstanceType::C5ad12xlarge,
            "c5ad.16xlarge" => InstanceType::C5ad16xlarge,
            "c5ad.24xlarge" => InstanceType::C5ad24xlarge,
            "c5ad.2xlarge" => InstanceType::C5ad2xlarge,
            "c5ad.4xlarge" => InstanceType::C5ad4xlarge,
            "c5ad.8xlarge" => InstanceType::C5ad8xlarge,
            "c5ad.large" => InstanceType::C5adLarge,
            "c5ad.xlarge" => InstanceType::C5adXlarge,
            "c5d.12xlarge" => InstanceType::C5d12xlarge,
            "c5d.18xlarge" => InstanceType::C5d18xlarge,
            "c5d.24xlarge" => InstanceType::C5d24xlarge,
            "c5d.2xlarge" => InstanceType::C5d2xlarge,
            "c5d.4xlarge" => InstanceType::C5d4xlarge,
            "c5d.9xlarge" => InstanceType::C5d9xlarge,
            "c5d.large" => InstanceType::C5dLarge,
            "c5d.metal" => InstanceType::C5dMetal,
            "c5d.xlarge" => InstanceType::C5dXlarge,
            "c5n.18xlarge" => InstanceType::C5n18xlarge,
            "c5n.2xlarge" => InstanceType::C5n2xlarge,
            "c5n.4xlarge" => InstanceType::C5n4xlarge,
            "c5n.9xlarge" => InstanceType::C5n9xlarge,
            "c5n.large" => InstanceType::C5nLarge,
            "c5n.metal" => InstanceType::C5nMetal,
            "c5n.xlarge" => InstanceType::C5nXlarge,
            "c6g.12xlarge" => InstanceType::C6g12xlarge,
            "c6g.16xlarge" => InstanceType::C6g16xlarge,
            "c6g.2xlarge" => InstanceType::C6g2xlarge,
            "c6g.4xlarge" => InstanceType::C6g4xlarge,
            "c6g.8xlarge" => InstanceType::C6g8xlarge,
            "c6g.large" => InstanceType::C6gLarge,
            "c6g.medium" => InstanceType::C6gMedium,
            "c6g.metal" => InstanceType::C6gMetal,
            "c6g.xlarge" => InstanceType::C6gXlarge,
            "c6gd.12xlarge" => InstanceType::C6gd12xlarge,
            "c6gd.16xlarge" => InstanceType::C6gd16xlarge,
            "c6gd.2xlarge" => InstanceType::C6gd2xlarge,
            "c6gd.4xlarge" => InstanceType::C6gd4xlarge,
            "c6gd.8xlarge" => InstanceType::C6gd8xlarge,
            "c6gd.large" => InstanceType::C6gdLarge,
            "c6gd.medium" => InstanceType::C6gdMedium,
            "c6gd.metal" => InstanceType::C6gdMetal,
            "c6gd.xlarge" => InstanceType::C6gdXlarge,
            "c6gn.12xlarge" => InstanceType::C6gn12xlarge,
            "c6gn.16xlarge" => InstanceType::C6gn16xlarge,
            "c6gn.2xlarge" => InstanceType::C6gn2xlarge,
            "c6gn.4xlarge" => InstanceType::C6gn4xlarge,
            "c6gn.8xlarge" => InstanceType::C6gn8xlarge,
            "c6gn.large" => InstanceType::C6gnLarge,
            "c6gn.medium" => InstanceType::C6gnMedium,
            "c6gn.xlarge" => InstanceType::C6gnXlarge,
            "c6i.12xlarge" => InstanceType::C6i12xlarge,
            "c6i.16xlarge" => InstanceType::C6i16xlarge,
            "c6i.24xlarge" => InstanceType::C6i24xlarge,
            "c6i.2xlarge" => InstanceType::C6i2xlarge,
            "c6i.32xlarge" => InstanceType::C6i32xlarge,
            "c6i.4xlarge" => InstanceType::C6i4xlarge,
            "c6i.8xlarge" => InstanceType::C6i8xlarge,
            "c6i.large" => InstanceType::C6iLarge,
            "c6i.metal" => InstanceType::C6iMetal,
            "c6i.xlarge" => InstanceType::C6iXlarge,
            "cc1.4xlarge" => InstanceType::Cc14xlarge,
            "cc2.8xlarge" => InstanceType::Cc28xlarge,
            "cg1.4xlarge" => InstanceType::Cg14xlarge,
            "cr1.8xlarge" => InstanceType::Cr18xlarge,
            "d2.2xlarge" => InstanceType::D22xlarge,
            "d2.4xlarge" => InstanceType::D24xlarge,
            "d2.8xlarge" => InstanceType::D28xlarge,
            "d2.xlarge" => InstanceType::D2Xlarge,
            "d3.2xlarge" => InstanceType::D32xlarge,
            "d3.4xlarge" => InstanceType::D34xlarge,
            "d3.8xlarge" => InstanceType::D38xlarge,
            "d3.xlarge" => InstanceType::D3Xlarge,
            "d3en.12xlarge" => InstanceType::D3en12xlarge,
            "d3en.2xlarge" => InstanceType::D3en2xlarge,
            "d3en.4xlarge" => InstanceType::D3en4xlarge,
            "d3en.6xlarge" => InstanceType::D3en6xlarge,
            "d3en.8xlarge" => InstanceType::D3en8xlarge,
            "d3en.xlarge" => InstanceType::D3enXlarge,
            "dl1.24xlarge" => InstanceType::Dl124xlarge,
            "f1.16xlarge" => InstanceType::F116xlarge,
            "f1.2xlarge" => InstanceType::F12xlarge,
            "f1.4xlarge" => InstanceType::F14xlarge,
            "g2.2xlarge" => InstanceType::G22xlarge,
            "g2.8xlarge" => InstanceType::G28xlarge,
            "g3.16xlarge" => InstanceType::G316xlarge,
            "g3.4xlarge" => InstanceType::G34xlarge,
            "g3.8xlarge" => InstanceType::G38xlarge,
            "g3s.xlarge" => InstanceType::G3sXlarge,
            "g4ad.16xlarge" => InstanceType::G4ad16xlarge,
            "g4ad.2xlarge" => InstanceType::G4ad2xlarge,
            "g4ad.4xlarge" => InstanceType::G4ad4xlarge,
            "g4ad.8xlarge" => InstanceType::G4ad8xlarge,
            "g4ad.xlarge" => InstanceType::G4adXlarge,
            "g4dn.12xlarge" => InstanceType::G4dn12xlarge,
            "g4dn.16xlarge" => InstanceType::G4dn16xlarge,
            "g4dn.2xlarge" => InstanceType::G4dn2xlarge,
            "g4dn.4xlarge" => InstanceType::G4dn4xlarge,
            "g4dn.8xlarge" => InstanceType::G4dn8xlarge,
            "g4dn.metal" => InstanceType::G4dnMetal,
            "g4dn.xlarge" => InstanceType::G4dnXlarge,
            "g5.12xlarge" => InstanceType::G512xlarge,
            "g5.16xlarge" => InstanceType::G516xlarge,
            "g5.24xlarge" => InstanceType::G524xlarge,
            "g5.2xlarge" => InstanceType::G52xlarge,
            "g5.48xlarge" => InstanceType::G548xlarge,
            "g5.4xlarge" => InstanceType::G54xlarge,
            "g5.8xlarge" => InstanceType::G58xlarge,
            "g5.xlarge" => InstanceType::G5Xlarge,
            "g5g.16xlarge" => InstanceType::G5g16xlarge,
            "g5g.2xlarge" => InstanceType::G5g2xlarge,
            "g5g.4xlarge" => InstanceType::G5g4xlarge,
            "g5g.8xlarge" => InstanceType::G5g8xlarge,
            "g5g.metal" => InstanceType::G5gMetal,
            "g5g.xlarge" => InstanceType::G5gXlarge,
            "h1.16xlarge" => InstanceType::H116xlarge,
            "h1.2xlarge" => InstanceType::H12xlarge,
            "h1.4xlarge" => InstanceType::H14xlarge,
            "h1.8xlarge" => InstanceType::H18xlarge,
            "hi1.4xlarge" => InstanceType::Hi14xlarge,
            "hpc6a.48xlarge" => InstanceType::Hpc6a48xlarge,
            "hs1.8xlarge" => InstanceType::Hs18xlarge,
            "i2.2xlarge" => InstanceType::I22xlarge,
            "i2.4xlarge" => InstanceType::I24xlarge,
            "i2.8xlarge" => InstanceType::I28xlarge,
            "i2.xlarge" => InstanceType::I2Xlarge,
            "i3.16xlarge" => InstanceType::I316xlarge,
            "i3.2xlarge" => InstanceType::I32xlarge,
            "i3.4xlarge" => InstanceType::I34xlarge,
            "i3.8xlarge" => InstanceType::I38xlarge,
            "i3.large" => InstanceType::I3Large,
            "i3.metal" => InstanceType::I3Metal,
            "i3.xlarge" => InstanceType::I3Xlarge,
            "i3en.12xlarge" => InstanceType::I3en12xlarge,
            "i3en.24xlarge" => InstanceType::I3en24xlarge,
            "i3en.2xlarge" => InstanceType::I3en2xlarge,
            "i3en.3xlarge" => InstanceType::I3en3xlarge,
            "i3en.6xlarge" => InstanceType::I3en6xlarge,
            "i3en.large" => InstanceType::I3enLarge,
            "i3en.metal" => InstanceType::I3enMetal,
            "i3en.xlarge" => InstanceType::I3enXlarge,
            "im4gn.16xlarge" => InstanceType::Im4gn16xlarge,
            "im4gn.2xlarge" => InstanceType::Im4gn2xlarge,
            "im4gn.4xlarge" => InstanceType::Im4gn4xlarge,
            "im4gn.8xlarge" => InstanceType::Im4gn8xlarge,
            "im4gn.large" => InstanceType::Im4gnLarge,
            "im4gn.xlarge" => InstanceType::Im4gnXlarge,
            "inf1.24xlarge" => InstanceType::Inf124xlarge,
            "inf1.2xlarge" => InstanceType::Inf12xlarge,
            "inf1.6xlarge" => InstanceType::Inf16xlarge,
            "inf1.xlarge" => InstanceType::Inf1Xlarge,
            "is4gen.2xlarge" => InstanceType::Is4gen2xlarge,
            "is4gen.4xlarge" => InstanceType::Is4gen4xlarge,
            "is4gen.8xlarge" => InstanceType::Is4gen8xlarge,
            "is4gen.large" => InstanceType::Is4genLarge,
            "is4gen.medium" => InstanceType::Is4genMedium,
            "is4gen.xlarge" => InstanceType::Is4genXlarge,
            "m1.large" => InstanceType::M1Large,
            "m1.medium" => InstanceType::M1Medium,
            "m1.small" => InstanceType::M1Small,
            "m1.xlarge" => InstanceType::M1Xlarge,
            "m2.2xlarge" => InstanceType::M22xlarge,
            "m2.4xlarge" => InstanceType::M24xlarge,
            "m2.xlarge" => InstanceType::M2Xlarge,
            "m3.2xlarge" => InstanceType::M32xlarge,
            "m3.large" => InstanceType::M3Large,
            "m3.medium" => InstanceType::M3Medium,
            "m3.xlarge" => InstanceType::M3Xlarge,
            "m4.10xlarge" => InstanceType::M410xlarge,
            "m4.16xlarge" => InstanceType::M416xlarge,
            "m4.2xlarge" => InstanceType::M42xlarge,
            "m4.4xlarge" => InstanceType::M44xlarge,
            "m4.large" => InstanceType::M4Large,
            "m4.xlarge" => InstanceType::M4Xlarge,
            "m5.12xlarge" => InstanceType::M512xlarge,
            "m5.16xlarge" => InstanceType::M516xlarge,
            "m5.24xlarge" => InstanceType::M524xlarge,
            "m5.2xlarge" => InstanceType::M52xlarge,
            "m5.4xlarge" => InstanceType::M54xlarge,
            "m5.8xlarge" => InstanceType::M58xlarge,
            "m5.large" => InstanceType::M5Large,
            "m5.metal" => InstanceType::M5Metal,
            "m5.xlarge" => InstanceType::M5Xlarge,
            "m5a.12xlarge" => InstanceType::M5a12xlarge,
            "m5a.16xlarge" => InstanceType::M5a16xlarge,
            "m5a.24xlarge" => InstanceType::M5a24xlarge,
            "m5a.2xlarge" => InstanceType::M5a2xlarge,
            "m5a.4xlarge" => InstanceType::M5a4xlarge,
            "m5a.8xlarge" => InstanceType::M5a8xlarge,
            "m5a.large" => InstanceType::M5aLarge,
            "m5a.xlarge" => InstanceType::M5aXlarge,
            "m5ad.12xlarge" => InstanceType::M5ad12xlarge,
            "m5ad.16xlarge" => InstanceType::M5ad16xlarge,
            "m5ad.24xlarge" => InstanceType::M5ad24xlarge,
            "m5ad.2xlarge" => InstanceType::M5ad2xlarge,
            "m5ad.4xlarge" => InstanceType::M5ad4xlarge,
            "m5ad.8xlarge" => InstanceType::M5ad8xlarge,
            "m5ad.large" => InstanceType::M5adLarge,
            "m5ad.xlarge" => InstanceType::M5adXlarge,
            "m5d.12xlarge" => InstanceType::M5d12xlarge,
            "m5d.16xlarge" => InstanceType::M5d16xlarge,
            "m5d.24xlarge" => InstanceType::M5d24xlarge,
            "m5d.2xlarge" => InstanceType::M5d2xlarge,
            "m5d.4xlarge" => InstanceType::M5d4xlarge,
            "m5d.8xlarge" => InstanceType::M5d8xlarge,
            "m5d.large" => InstanceType::M5dLarge,
            "m5d.metal" => InstanceType::M5dMetal,
            "m5d.xlarge" => InstanceType::M5dXlarge,
            "m5dn.12xlarge" => InstanceType::M5dn12xlarge,
            "m5dn.16xlarge" => InstanceType::M5dn16xlarge,
            "m5dn.24xlarge" => InstanceType::M5dn24xlarge,
            "m5dn.2xlarge" => InstanceType::M5dn2xlarge,
            "m5dn.4xlarge" => InstanceType::M5dn4xlarge,
            "m5dn.8xlarge" => InstanceType::M5dn8xlarge,
            "m5dn.large" => InstanceType::M5dnLarge,
            "m5dn.metal" => InstanceType::M5dnMetal,
            "m5dn.xlarge" => InstanceType::M5dnXlarge,
            "m5n.12xlarge" => InstanceType::M5n12xlarge,
            "m5n.16xlarge" => InstanceType::M5n16xlarge,
            "m5n.24xlarge" => InstanceType::M5n24xlarge,
            "m5n.2xlarge" => InstanceType::M5n2xlarge,
            "m5n.4xlarge" => InstanceType::M5n4xlarge,
            "m5n.8xlarge" => InstanceType::M5n8xlarge,
            "m5n.large" => InstanceType::M5nLarge,
            "m5n.metal" => InstanceType::M5nMetal,
            "m5n.xlarge" => InstanceType::M5nXlarge,
            "m5zn.12xlarge" => InstanceType::M5zn12xlarge,
            "m5zn.2xlarge" => InstanceType::M5zn2xlarge,
            "m5zn.3xlarge" => InstanceType::M5zn3xlarge,
            "m5zn.6xlarge" => InstanceType::M5zn6xlarge,
            "m5zn.large" => InstanceType::M5znLarge,
            "m5zn.metal" => InstanceType::M5znMetal,
            "m5zn.xlarge" => InstanceType::M5znXlarge,
            "m6a.12xlarge" => InstanceType::M6a12xlarge,
            "m6a.16xlarge" => InstanceType::M6a16xlarge,
            "m6a.24xlarge" => InstanceType::M6a24xlarge,
            "m6a.2xlarge" => InstanceType::M6a2xlarge,
            "m6a.32xlarge" => InstanceType::M6a32xlarge,
            "m6a.48xlarge" => InstanceType::M6a48xlarge,
            "m6a.4xlarge" => InstanceType::M6a4xlarge,
            "m6a.8xlarge" => InstanceType::M6a8xlarge,
            "m6a.large" => InstanceType::M6aLarge,
            "m6a.xlarge" => InstanceType::M6aXlarge,
            "m6g.12xlarge" => InstanceType::M6g12xlarge,
            "m6g.16xlarge" => InstanceType::M6g16xlarge,
            "m6g.2xlarge" => InstanceType::M6g2xlarge,
            "m6g.4xlarge" => InstanceType::M6g4xlarge,
            "m6g.8xlarge" => InstanceType::M6g8xlarge,
            "m6g.large" => InstanceType::M6gLarge,
            "m6g.medium" => InstanceType::M6gMedium,
            "m6g.metal" => InstanceType::M6gMetal,
            "m6g.xlarge" => InstanceType::M6gXlarge,
            "m6gd.12xlarge" => InstanceType::M6gd12xlarge,
            "m6gd.16xlarge" => InstanceType::M6gd16xlarge,
            "m6gd.2xlarge" => InstanceType::M6gd2xlarge,
            "m6gd.4xlarge" => InstanceType::M6gd4xlarge,
            "m6gd.8xlarge" => InstanceType::M6gd8xlarge,
            "m6gd.large" => InstanceType::M6gdLarge,
            "m6gd.medium" => InstanceType::M6gdMedium,
            "m6gd.metal" => InstanceType::M6gdMetal,
            "m6gd.xlarge" => InstanceType::M6gdXlarge,
            "m6i.12xlarge" => InstanceType::M6i12xlarge,
            "m6i.16xlarge" => InstanceType::M6i16xlarge,
            "m6i.24xlarge" => InstanceType::M6i24xlarge,
            "m6i.2xlarge" => InstanceType::M6i2xlarge,
            "m6i.32xlarge" => InstanceType::M6i32xlarge,
            "m6i.4xlarge" => InstanceType::M6i4xlarge,
            "m6i.8xlarge" => InstanceType::M6i8xlarge,
            "m6i.large" => InstanceType::M6iLarge,
            "m6i.metal" => InstanceType::M6iMetal,
            "m6i.xlarge" => InstanceType::M6iXlarge,
            "mac1.metal" => InstanceType::Mac1Metal,
            "p2.16xlarge" => InstanceType::P216xlarge,
            "p2.8xlarge" => InstanceType::P28xlarge,
            "p2.xlarge" => InstanceType::P2Xlarge,
            "p3.16xlarge" => InstanceType::P316xlarge,
            "p3.2xlarge" => InstanceType::P32xlarge,
            "p3.8xlarge" => InstanceType::P38xlarge,
            "p3dn.24xlarge" => InstanceType::P3dn24xlarge,
            "p4d.24xlarge" => InstanceType::P4d24xlarge,
            "r3.2xlarge" => InstanceType::R32xlarge,
            "r3.4xlarge" => InstanceType::R34xlarge,
            "r3.8xlarge" => InstanceType::R38xlarge,
            "r3.large" => InstanceType::R3Large,
            "r3.xlarge" => InstanceType::R3Xlarge,
            "r4.16xlarge" => InstanceType::R416xlarge,
            "r4.2xlarge" => InstanceType::R42xlarge,
            "r4.4xlarge" => InstanceType::R44xlarge,
            "r4.8xlarge" => InstanceType::R48xlarge,
            "r4.large" => InstanceType::R4Large,
            "r4.xlarge" => InstanceType::R4Xlarge,
            "r5.12xlarge" => InstanceType::R512xlarge,
            "r5.16xlarge" => InstanceType::R516xlarge,
            "r5.24xlarge" => InstanceType::R524xlarge,
            "r5.2xlarge" => InstanceType::R52xlarge,
            "r5.4xlarge" => InstanceType::R54xlarge,
            "r5.8xlarge" => InstanceType::R58xlarge,
            "r5.large" => InstanceType::R5Large,
            "r5.metal" => InstanceType::R5Metal,
            "r5.xlarge" => InstanceType::R5Xlarge,
            "r5a.12xlarge" => InstanceType::R5a12xlarge,
            "r5a.16xlarge" => InstanceType::R5a16xlarge,
            "r5a.24xlarge" => InstanceType::R5a24xlarge,
            "r5a.2xlarge" => InstanceType::R5a2xlarge,
            "r5a.4xlarge" => InstanceType::R5a4xlarge,
            "r5a.8xlarge" => InstanceType::R5a8xlarge,
            "r5a.large" => InstanceType::R5aLarge,
            "r5a.xlarge" => InstanceType::R5aXlarge,
            "r5ad.12xlarge" => InstanceType::R5ad12xlarge,
            "r5ad.16xlarge" => InstanceType::R5ad16xlarge,
            "r5ad.24xlarge" => InstanceType::R5ad24xlarge,
            "r5ad.2xlarge" => InstanceType::R5ad2xlarge,
            "r5ad.4xlarge" => InstanceType::R5ad4xlarge,
            "r5ad.8xlarge" => InstanceType::R5ad8xlarge,
            "r5ad.large" => InstanceType::R5adLarge,
            "r5ad.xlarge" => InstanceType::R5adXlarge,
            "r5b.12xlarge" => InstanceType::R5b12xlarge,
            "r5b.16xlarge" => InstanceType::R5b16xlarge,
            "r5b.24xlarge" => InstanceType::R5b24xlarge,
            "r5b.2xlarge" => InstanceType::R5b2xlarge,
            "r5b.4xlarge" => InstanceType::R5b4xlarge,
            "r5b.8xlarge" => InstanceType::R5b8xlarge,
            "r5b.large" => InstanceType::R5bLarge,
            "r5b.metal" => InstanceType::R5bMetal,
            "r5b.xlarge" => InstanceType::R5bXlarge,
            "r5d.12xlarge" => InstanceType::R5d12xlarge,
            "r5d.16xlarge" => InstanceType::R5d16xlarge,
            "r5d.24xlarge" => InstanceType::R5d24xlarge,
            "r5d.2xlarge" => InstanceType::R5d2xlarge,
            "r5d.4xlarge" => InstanceType::R5d4xlarge,
            "r5d.8xlarge" => InstanceType::R5d8xlarge,
            "r5d.large" => InstanceType::R5dLarge,
            "r5d.metal" => InstanceType::R5dMetal,
            "r5d.xlarge" => InstanceType::R5dXlarge,
            "r5dn.12xlarge" => InstanceType::R5dn12xlarge,
            "r5dn.16xlarge" => InstanceType::R5dn16xlarge,
            "r5dn.24xlarge" => InstanceType::R5dn24xlarge,
            "r5dn.2xlarge" => InstanceType::R5dn2xlarge,
            "r5dn.4xlarge" => InstanceType::R5dn4xlarge,
            "r5dn.8xlarge" => InstanceType::R5dn8xlarge,
            "r5dn.large" => InstanceType::R5dnLarge,
            "r5dn.metal" => InstanceType::R5dnMetal,
            "r5dn.xlarge" => InstanceType::R5dnXlarge,
            "r5n.12xlarge" => InstanceType::R5n12xlarge,
            "r5n.16xlarge" => InstanceType::R5n16xlarge,
            "r5n.24xlarge" => InstanceType::R5n24xlarge,
            "r5n.2xlarge" => InstanceType::R5n2xlarge,
            "r5n.4xlarge" => InstanceType::R5n4xlarge,
            "r5n.8xlarge" => InstanceType::R5n8xlarge,
            "r5n.large" => InstanceType::R5nLarge,
            "r5n.metal" => InstanceType::R5nMetal,
            "r5n.xlarge" => InstanceType::R5nXlarge,
            "r6g.12xlarge" => InstanceType::R6g12xlarge,
            "r6g.16xlarge" => InstanceType::R6g16xlarge,
            "r6g.2xlarge" => InstanceType::R6g2xlarge,
            "r6g.4xlarge" => InstanceType::R6g4xlarge,
            "r6g.8xlarge" => InstanceType::R6g8xlarge,
            "r6g.large" => InstanceType::R6gLarge,
            "r6g.medium" => InstanceType::R6gMedium,
            "r6g.metal" => InstanceType::R6gMetal,
            "r6g.xlarge" => InstanceType::R6gXlarge,
            "r6gd.12xlarge" => InstanceType::R6gd12xlarge,
            "r6gd.16xlarge" => InstanceType::R6gd16xlarge,
            "r6gd.2xlarge" => InstanceType::R6gd2xlarge,
            "r6gd.4xlarge" => InstanceType::R6gd4xlarge,
            "r6gd.8xlarge" => InstanceType::R6gd8xlarge,
            "r6gd.large" => InstanceType::R6gdLarge,
            "r6gd.medium" => InstanceType::R6gdMedium,
            "r6gd.metal" => InstanceType::R6gdMetal,
            "r6gd.xlarge" => InstanceType::R6gdXlarge,
            "r6i.12xlarge" => InstanceType::R6i12xlarge,
            "r6i.16xlarge" => InstanceType::R6i16xlarge,
            "r6i.24xlarge" => InstanceType::R6i24xlarge,
            "r6i.2xlarge" => InstanceType::R6i2xlarge,
            "r6i.32xlarge" => InstanceType::R6i32xlarge,
            "r6i.4xlarge" => InstanceType::R6i4xlarge,
            "r6i.8xlarge" => InstanceType::R6i8xlarge,
            "r6i.large" => InstanceType::R6iLarge,
            "r6i.metal" => InstanceType::R6iMetal,
            "r6i.xlarge" => InstanceType::R6iXlarge,
            "t1.micro" => InstanceType::T1Micro,
            "t2.2xlarge" => InstanceType::T22xlarge,
            "t2.large" => InstanceType::T2Large,
            "t2.medium" => InstanceType::T2Medium,
            "t2.micro" => InstanceType::T2Micro,
            "t2.nano" => InstanceType::T2Nano,
            "t2.small" => InstanceType::T2Small,
            "t2.xlarge" => InstanceType::T2Xlarge,
            "t3.2xlarge" => InstanceType::T32xlarge,
            "t3.large" => InstanceType::T3Large,
            "t3.medium" => InstanceType::T3Medium,
            "t3.micro" => InstanceType::T3Micro,
            "t3.nano" => InstanceType::T3Nano,
            "t3.small" => InstanceType::T3Small,
            "t3.xlarge" => InstanceType::T3Xlarge,
            "t3a.2xlarge" => InstanceType::T3a2xlarge,
            "t3a.large" => InstanceType::T3aLarge,
            "t3a.medium" => InstanceType::T3aMedium,
            "t3a.micro" => InstanceType::T3aMicro,
            "t3a.nano" => InstanceType::T3aNano,
            "t3a.small" => InstanceType::T3aSmall,
            "t3a.xlarge" => InstanceType::T3aXlarge,
            "t4g.2xlarge" => InstanceType::T4g2xlarge,
            "t4g.large" => InstanceType::T4gLarge,
            "t4g.medium" => InstanceType::T4gMedium,
            "t4g.micro" => InstanceType::T4gMicro,
            "t4g.nano" => InstanceType::T4gNano,
            "t4g.small" => InstanceType::T4gSmall,
            "t4g.xlarge" => InstanceType::T4gXlarge,
            "u-12tb1.112xlarge" => InstanceType::U12tb1112xlarge,
            "u-12tb1.metal" => InstanceType::U12tb1Metal,
            "u-18tb1.metal" => InstanceType::U18tb1Metal,
            "u-24tb1.metal" => InstanceType::U24tb1Metal,
            "u-6tb1.112xlarge" => InstanceType::U6tb1112xlarge,
            "u-6tb1.56xlarge" => InstanceType::U6tb156xlarge,
            "u-6tb1.metal" => InstanceType::U6tb1Metal,
            "u-9tb1.112xlarge" => InstanceType::U9tb1112xlarge,
            "u-9tb1.metal" => InstanceType::U9tb1Metal,
            "vt1.24xlarge" => InstanceType::Vt124xlarge,
            "vt1.3xlarge" => InstanceType::Vt13xlarge,
            "vt1.6xlarge" => InstanceType::Vt16xlarge,
            "x1.16xlarge" => InstanceType::X116xlarge,
            "x1.32xlarge" => InstanceType::X132xlarge,
            "x1e.16xlarge" => InstanceType::X1e16xlarge,
            "x1e.2xlarge" => InstanceType::X1e2xlarge,
            "x1e.32xlarge" => InstanceType::X1e32xlarge,
            "x1e.4xlarge" => InstanceType::X1e4xlarge,
            "x1e.8xlarge" => InstanceType::X1e8xlarge,
            "x1e.xlarge" => InstanceType::X1eXlarge,
            "x2gd.12xlarge" => InstanceType::X2gd12xlarge,
            "x2gd.16xlarge" => InstanceType::X2gd16xlarge,
            "x2gd.2xlarge" => InstanceType::X2gd2xlarge,
            "x2gd.4xlarge" => InstanceType::X2gd4xlarge,
            "x2gd.8xlarge" => InstanceType::X2gd8xlarge,
            "x2gd.large" => InstanceType::X2gdLarge,
            "x2gd.medium" => InstanceType::X2gdMedium,
            "x2gd.metal" => InstanceType::X2gdMetal,
            "x2gd.xlarge" => InstanceType::X2gdXlarge,
            "x2iezn.12xlarge" => InstanceType::X2iezn12xlarge,
            "x2iezn.2xlarge" => InstanceType::X2iezn2xlarge,
            "x2iezn.4xlarge" => InstanceType::X2iezn4xlarge,
            "x2iezn.6xlarge" => InstanceType::X2iezn6xlarge,
            "x2iezn.8xlarge" => InstanceType::X2iezn8xlarge,
            "x2iezn.metal" => InstanceType::X2ieznMetal,
            "z1d.12xlarge" => InstanceType::Z1d12xlarge,
            "z1d.2xlarge" => InstanceType::Z1d2xlarge,
            "z1d.3xlarge" => InstanceType::Z1d3xlarge,
            "z1d.6xlarge" => InstanceType::Z1d6xlarge,
            "z1d.large" => InstanceType::Z1dLarge,
            "z1d.metal" => InstanceType::Z1dMetal,
            "z1d.xlarge" => InstanceType::Z1dXlarge,
            other => InstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceType::from(s))
    }
}
impl InstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceType::A12xlarge => "a1.2xlarge",
            InstanceType::A14xlarge => "a1.4xlarge",
            InstanceType::A1Large => "a1.large",
            InstanceType::A1Medium => "a1.medium",
            InstanceType::A1Metal => "a1.metal",
            InstanceType::A1Xlarge => "a1.xlarge",
            InstanceType::C1Medium => "c1.medium",
            InstanceType::C1Xlarge => "c1.xlarge",
            InstanceType::C32xlarge => "c3.2xlarge",
            InstanceType::C34xlarge => "c3.4xlarge",
            InstanceType::C38xlarge => "c3.8xlarge",
            InstanceType::C3Large => "c3.large",
            InstanceType::C3Xlarge => "c3.xlarge",
            InstanceType::C42xlarge => "c4.2xlarge",
            InstanceType::C44xlarge => "c4.4xlarge",
            InstanceType::C48xlarge => "c4.8xlarge",
            InstanceType::C4Large => "c4.large",
            InstanceType::C4Xlarge => "c4.xlarge",
            InstanceType::C512xlarge => "c5.12xlarge",
            InstanceType::C518xlarge => "c5.18xlarge",
            InstanceType::C524xlarge => "c5.24xlarge",
            InstanceType::C52xlarge => "c5.2xlarge",
            InstanceType::C54xlarge => "c5.4xlarge",
            InstanceType::C59xlarge => "c5.9xlarge",
            InstanceType::C5Large => "c5.large",
            InstanceType::C5Metal => "c5.metal",
            InstanceType::C5Xlarge => "c5.xlarge",
            InstanceType::C5a12xlarge => "c5a.12xlarge",
            InstanceType::C5a16xlarge => "c5a.16xlarge",
            InstanceType::C5a24xlarge => "c5a.24xlarge",
            InstanceType::C5a2xlarge => "c5a.2xlarge",
            InstanceType::C5a4xlarge => "c5a.4xlarge",
            InstanceType::C5a8xlarge => "c5a.8xlarge",
            InstanceType::C5aLarge => "c5a.large",
            InstanceType::C5aXlarge => "c5a.xlarge",
            InstanceType::C5ad12xlarge => "c5ad.12xlarge",
            InstanceType::C5ad16xlarge => "c5ad.16xlarge",
            InstanceType::C5ad24xlarge => "c5ad.24xlarge",
            InstanceType::C5ad2xlarge => "c5ad.2xlarge",
            InstanceType::C5ad4xlarge => "c5ad.4xlarge",
            InstanceType::C5ad8xlarge => "c5ad.8xlarge",
            InstanceType::C5adLarge => "c5ad.large",
            InstanceType::C5adXlarge => "c5ad.xlarge",
            InstanceType::C5d12xlarge => "c5d.12xlarge",
            InstanceType::C5d18xlarge => "c5d.18xlarge",
            InstanceType::C5d24xlarge => "c5d.24xlarge",
            InstanceType::C5d2xlarge => "c5d.2xlarge",
            InstanceType::C5d4xlarge => "c5d.4xlarge",
            InstanceType::C5d9xlarge => "c5d.9xlarge",
            InstanceType::C5dLarge => "c5d.large",
            InstanceType::C5dMetal => "c5d.metal",
            InstanceType::C5dXlarge => "c5d.xlarge",
            InstanceType::C5n18xlarge => "c5n.18xlarge",
            InstanceType::C5n2xlarge => "c5n.2xlarge",
            InstanceType::C5n4xlarge => "c5n.4xlarge",
            InstanceType::C5n9xlarge => "c5n.9xlarge",
            InstanceType::C5nLarge => "c5n.large",
            InstanceType::C5nMetal => "c5n.metal",
            InstanceType::C5nXlarge => "c5n.xlarge",
            InstanceType::C6g12xlarge => "c6g.12xlarge",
            InstanceType::C6g16xlarge => "c6g.16xlarge",
            InstanceType::C6g2xlarge => "c6g.2xlarge",
            InstanceType::C6g4xlarge => "c6g.4xlarge",
            InstanceType::C6g8xlarge => "c6g.8xlarge",
            InstanceType::C6gLarge => "c6g.large",
            InstanceType::C6gMedium => "c6g.medium",
            InstanceType::C6gMetal => "c6g.metal",
            InstanceType::C6gXlarge => "c6g.xlarge",
            InstanceType::C6gd12xlarge => "c6gd.12xlarge",
            InstanceType::C6gd16xlarge => "c6gd.16xlarge",
            InstanceType::C6gd2xlarge => "c6gd.2xlarge",
            InstanceType::C6gd4xlarge => "c6gd.4xlarge",
            InstanceType::C6gd8xlarge => "c6gd.8xlarge",
            InstanceType::C6gdLarge => "c6gd.large",
            InstanceType::C6gdMedium => "c6gd.medium",
            InstanceType::C6gdMetal => "c6gd.metal",
            InstanceType::C6gdXlarge => "c6gd.xlarge",
            InstanceType::C6gn12xlarge => "c6gn.12xlarge",
            InstanceType::C6gn16xlarge => "c6gn.16xlarge",
            InstanceType::C6gn2xlarge => "c6gn.2xlarge",
            InstanceType::C6gn4xlarge => "c6gn.4xlarge",
            InstanceType::C6gn8xlarge => "c6gn.8xlarge",
            InstanceType::C6gnLarge => "c6gn.large",
            InstanceType::C6gnMedium => "c6gn.medium",
            InstanceType::C6gnXlarge => "c6gn.xlarge",
            InstanceType::C6i12xlarge => "c6i.12xlarge",
            InstanceType::C6i16xlarge => "c6i.16xlarge",
            InstanceType::C6i24xlarge => "c6i.24xlarge",
            InstanceType::C6i2xlarge => "c6i.2xlarge",
            InstanceType::C6i32xlarge => "c6i.32xlarge",
            InstanceType::C6i4xlarge => "c6i.4xlarge",
            InstanceType::C6i8xlarge => "c6i.8xlarge",
            InstanceType::C6iLarge => "c6i.large",
            InstanceType::C6iMetal => "c6i.metal",
            InstanceType::C6iXlarge => "c6i.xlarge",
            InstanceType::Cc14xlarge => "cc1.4xlarge",
            InstanceType::Cc28xlarge => "cc2.8xlarge",
            InstanceType::Cg14xlarge => "cg1.4xlarge",
            InstanceType::Cr18xlarge => "cr1.8xlarge",
            InstanceType::D22xlarge => "d2.2xlarge",
            InstanceType::D24xlarge => "d2.4xlarge",
            InstanceType::D28xlarge => "d2.8xlarge",
            InstanceType::D2Xlarge => "d2.xlarge",
            InstanceType::D32xlarge => "d3.2xlarge",
            InstanceType::D34xlarge => "d3.4xlarge",
            InstanceType::D38xlarge => "d3.8xlarge",
            InstanceType::D3Xlarge => "d3.xlarge",
            InstanceType::D3en12xlarge => "d3en.12xlarge",
            InstanceType::D3en2xlarge => "d3en.2xlarge",
            InstanceType::D3en4xlarge => "d3en.4xlarge",
            InstanceType::D3en6xlarge => "d3en.6xlarge",
            InstanceType::D3en8xlarge => "d3en.8xlarge",
            InstanceType::D3enXlarge => "d3en.xlarge",
            InstanceType::Dl124xlarge => "dl1.24xlarge",
            InstanceType::F116xlarge => "f1.16xlarge",
            InstanceType::F12xlarge => "f1.2xlarge",
            InstanceType::F14xlarge => "f1.4xlarge",
            InstanceType::G22xlarge => "g2.2xlarge",
            InstanceType::G28xlarge => "g2.8xlarge",
            InstanceType::G316xlarge => "g3.16xlarge",
            InstanceType::G34xlarge => "g3.4xlarge",
            InstanceType::G38xlarge => "g3.8xlarge",
            InstanceType::G3sXlarge => "g3s.xlarge",
            InstanceType::G4ad16xlarge => "g4ad.16xlarge",
            InstanceType::G4ad2xlarge => "g4ad.2xlarge",
            InstanceType::G4ad4xlarge => "g4ad.4xlarge",
            InstanceType::G4ad8xlarge => "g4ad.8xlarge",
            InstanceType::G4adXlarge => "g4ad.xlarge",
            InstanceType::G4dn12xlarge => "g4dn.12xlarge",
            InstanceType::G4dn16xlarge => "g4dn.16xlarge",
            InstanceType::G4dn2xlarge => "g4dn.2xlarge",
            InstanceType::G4dn4xlarge => "g4dn.4xlarge",
            InstanceType::G4dn8xlarge => "g4dn.8xlarge",
            InstanceType::G4dnMetal => "g4dn.metal",
            InstanceType::G4dnXlarge => "g4dn.xlarge",
            InstanceType::G512xlarge => "g5.12xlarge",
            InstanceType::G516xlarge => "g5.16xlarge",
            InstanceType::G524xlarge => "g5.24xlarge",
            InstanceType::G52xlarge => "g5.2xlarge",
            InstanceType::G548xlarge => "g5.48xlarge",
            InstanceType::G54xlarge => "g5.4xlarge",
            InstanceType::G58xlarge => "g5.8xlarge",
            InstanceType::G5Xlarge => "g5.xlarge",
            InstanceType::G5g16xlarge => "g5g.16xlarge",
            InstanceType::G5g2xlarge => "g5g.2xlarge",
            InstanceType::G5g4xlarge => "g5g.4xlarge",
            InstanceType::G5g8xlarge => "g5g.8xlarge",
            InstanceType::G5gMetal => "g5g.metal",
            InstanceType::G5gXlarge => "g5g.xlarge",
            InstanceType::H116xlarge => "h1.16xlarge",
            InstanceType::H12xlarge => "h1.2xlarge",
            InstanceType::H14xlarge => "h1.4xlarge",
            InstanceType::H18xlarge => "h1.8xlarge",
            InstanceType::Hi14xlarge => "hi1.4xlarge",
            InstanceType::Hpc6a48xlarge => "hpc6a.48xlarge",
            InstanceType::Hs18xlarge => "hs1.8xlarge",
            InstanceType::I22xlarge => "i2.2xlarge",
            InstanceType::I24xlarge => "i2.4xlarge",
            InstanceType::I28xlarge => "i2.8xlarge",
            InstanceType::I2Xlarge => "i2.xlarge",
            InstanceType::I316xlarge => "i3.16xlarge",
            InstanceType::I32xlarge => "i3.2xlarge",
            InstanceType::I34xlarge => "i3.4xlarge",
            InstanceType::I38xlarge => "i3.8xlarge",
            InstanceType::I3Large => "i3.large",
            InstanceType::I3Metal => "i3.metal",
            InstanceType::I3Xlarge => "i3.xlarge",
            InstanceType::I3en12xlarge => "i3en.12xlarge",
            InstanceType::I3en24xlarge => "i3en.24xlarge",
            InstanceType::I3en2xlarge => "i3en.2xlarge",
            InstanceType::I3en3xlarge => "i3en.3xlarge",
            InstanceType::I3en6xlarge => "i3en.6xlarge",
            InstanceType::I3enLarge => "i3en.large",
            InstanceType::I3enMetal => "i3en.metal",
            InstanceType::I3enXlarge => "i3en.xlarge",
            InstanceType::Im4gn16xlarge => "im4gn.16xlarge",
            InstanceType::Im4gn2xlarge => "im4gn.2xlarge",
            InstanceType::Im4gn4xlarge => "im4gn.4xlarge",
            InstanceType::Im4gn8xlarge => "im4gn.8xlarge",
            InstanceType::Im4gnLarge => "im4gn.large",
            InstanceType::Im4gnXlarge => "im4gn.xlarge",
            InstanceType::Inf124xlarge => "inf1.24xlarge",
            InstanceType::Inf12xlarge => "inf1.2xlarge",
            InstanceType::Inf16xlarge => "inf1.6xlarge",
            InstanceType::Inf1Xlarge => "inf1.xlarge",
            InstanceType::Is4gen2xlarge => "is4gen.2xlarge",
            InstanceType::Is4gen4xlarge => "is4gen.4xlarge",
            InstanceType::Is4gen8xlarge => "is4gen.8xlarge",
            InstanceType::Is4genLarge => "is4gen.large",
            InstanceType::Is4genMedium => "is4gen.medium",
            InstanceType::Is4genXlarge => "is4gen.xlarge",
            InstanceType::M1Large => "m1.large",
            InstanceType::M1Medium => "m1.medium",
            InstanceType::M1Small => "m1.small",
            InstanceType::M1Xlarge => "m1.xlarge",
            InstanceType::M22xlarge => "m2.2xlarge",
            InstanceType::M24xlarge => "m2.4xlarge",
            InstanceType::M2Xlarge => "m2.xlarge",
            InstanceType::M32xlarge => "m3.2xlarge",
            InstanceType::M3Large => "m3.large",
            InstanceType::M3Medium => "m3.medium",
            InstanceType::M3Xlarge => "m3.xlarge",
            InstanceType::M410xlarge => "m4.10xlarge",
            InstanceType::M416xlarge => "m4.16xlarge",
            InstanceType::M42xlarge => "m4.2xlarge",
            InstanceType::M44xlarge => "m4.4xlarge",
            InstanceType::M4Large => "m4.large",
            InstanceType::M4Xlarge => "m4.xlarge",
            InstanceType::M512xlarge => "m5.12xlarge",
            InstanceType::M516xlarge => "m5.16xlarge",
            InstanceType::M524xlarge => "m5.24xlarge",
            InstanceType::M52xlarge => "m5.2xlarge",
            InstanceType::M54xlarge => "m5.4xlarge",
            InstanceType::M58xlarge => "m5.8xlarge",
            InstanceType::M5Large => "m5.large",
            InstanceType::M5Metal => "m5.metal",
            InstanceType::M5Xlarge => "m5.xlarge",
            InstanceType::M5a12xlarge => "m5a.12xlarge",
            InstanceType::M5a16xlarge => "m5a.16xlarge",
            InstanceType::M5a24xlarge => "m5a.24xlarge",
            InstanceType::M5a2xlarge => "m5a.2xlarge",
            InstanceType::M5a4xlarge => "m5a.4xlarge",
            InstanceType::M5a8xlarge => "m5a.8xlarge",
            InstanceType::M5aLarge => "m5a.large",
            InstanceType::M5aXlarge => "m5a.xlarge",
            InstanceType::M5ad12xlarge => "m5ad.12xlarge",
            InstanceType::M5ad16xlarge => "m5ad.16xlarge",
            InstanceType::M5ad24xlarge => "m5ad.24xlarge",
            InstanceType::M5ad2xlarge => "m5ad.2xlarge",
            InstanceType::M5ad4xlarge => "m5ad.4xlarge",
            InstanceType::M5ad8xlarge => "m5ad.8xlarge",
            InstanceType::M5adLarge => "m5ad.large",
            InstanceType::M5adXlarge => "m5ad.xlarge",
            InstanceType::M5d12xlarge => "m5d.12xlarge",
            InstanceType::M5d16xlarge => "m5d.16xlarge",
            InstanceType::M5d24xlarge => "m5d.24xlarge",
            InstanceType::M5d2xlarge => "m5d.2xlarge",
            InstanceType::M5d4xlarge => "m5d.4xlarge",
            InstanceType::M5d8xlarge => "m5d.8xlarge",
            InstanceType::M5dLarge => "m5d.large",
            InstanceType::M5dMetal => "m5d.metal",
            InstanceType::M5dXlarge => "m5d.xlarge",
            InstanceType::M5dn12xlarge => "m5dn.12xlarge",
            InstanceType::M5dn16xlarge => "m5dn.16xlarge",
            InstanceType::M5dn24xlarge => "m5dn.24xlarge",
            InstanceType::M5dn2xlarge => "m5dn.2xlarge",
            InstanceType::M5dn4xlarge => "m5dn.4xlarge",
            InstanceType::M5dn8xlarge => "m5dn.8xlarge",
            InstanceType::M5dnLarge => "m5dn.large",
            InstanceType::M5dnMetal => "m5dn.metal",
            InstanceType::M5dnXlarge => "m5dn.xlarge",
            InstanceType::M5n12xlarge => "m5n.12xlarge",
            InstanceType::M5n16xlarge => "m5n.16xlarge",
            InstanceType::M5n24xlarge => "m5n.24xlarge",
            InstanceType::M5n2xlarge => "m5n.2xlarge",
            InstanceType::M5n4xlarge => "m5n.4xlarge",
            InstanceType::M5n8xlarge => "m5n.8xlarge",
            InstanceType::M5nLarge => "m5n.large",
            InstanceType::M5nMetal => "m5n.metal",
            InstanceType::M5nXlarge => "m5n.xlarge",
            InstanceType::M5zn12xlarge => "m5zn.12xlarge",
            InstanceType::M5zn2xlarge => "m5zn.2xlarge",
            InstanceType::M5zn3xlarge => "m5zn.3xlarge",
            InstanceType::M5zn6xlarge => "m5zn.6xlarge",
            InstanceType::M5znLarge => "m5zn.large",
            InstanceType::M5znMetal => "m5zn.metal",
            InstanceType::M5znXlarge => "m5zn.xlarge",
            InstanceType::M6a12xlarge => "m6a.12xlarge",
            InstanceType::M6a16xlarge => "m6a.16xlarge",
            InstanceType::M6a24xlarge => "m6a.24xlarge",
            InstanceType::M6a2xlarge => "m6a.2xlarge",
            InstanceType::M6a32xlarge => "m6a.32xlarge",
            InstanceType::M6a48xlarge => "m6a.48xlarge",
            InstanceType::M6a4xlarge => "m6a.4xlarge",
            InstanceType::M6a8xlarge => "m6a.8xlarge",
            InstanceType::M6aLarge => "m6a.large",
            InstanceType::M6aXlarge => "m6a.xlarge",
            InstanceType::M6g12xlarge => "m6g.12xlarge",
            InstanceType::M6g16xlarge => "m6g.16xlarge",
            InstanceType::M6g2xlarge => "m6g.2xlarge",
            InstanceType::M6g4xlarge => "m6g.4xlarge",
            InstanceType::M6g8xlarge => "m6g.8xlarge",
            InstanceType::M6gLarge => "m6g.large",
            InstanceType::M6gMedium => "m6g.medium",
            InstanceType::M6gMetal => "m6g.metal",
            InstanceType::M6gXlarge => "m6g.xlarge",
            InstanceType::M6gd12xlarge => "m6gd.12xlarge",
            InstanceType::M6gd16xlarge => "m6gd.16xlarge",
            InstanceType::M6gd2xlarge => "m6gd.2xlarge",
            InstanceType::M6gd4xlarge => "m6gd.4xlarge",
            InstanceType::M6gd8xlarge => "m6gd.8xlarge",
            InstanceType::M6gdLarge => "m6gd.large",
            InstanceType::M6gdMedium => "m6gd.medium",
            InstanceType::M6gdMetal => "m6gd.metal",
            InstanceType::M6gdXlarge => "m6gd.xlarge",
            InstanceType::M6i12xlarge => "m6i.12xlarge",
            InstanceType::M6i16xlarge => "m6i.16xlarge",
            InstanceType::M6i24xlarge => "m6i.24xlarge",
            InstanceType::M6i2xlarge => "m6i.2xlarge",
            InstanceType::M6i32xlarge => "m6i.32xlarge",
            InstanceType::M6i4xlarge => "m6i.4xlarge",
            InstanceType::M6i8xlarge => "m6i.8xlarge",
            InstanceType::M6iLarge => "m6i.large",
            InstanceType::M6iMetal => "m6i.metal",
            InstanceType::M6iXlarge => "m6i.xlarge",
            InstanceType::Mac1Metal => "mac1.metal",
            InstanceType::P216xlarge => "p2.16xlarge",
            InstanceType::P28xlarge => "p2.8xlarge",
            InstanceType::P2Xlarge => "p2.xlarge",
            InstanceType::P316xlarge => "p3.16xlarge",
            InstanceType::P32xlarge => "p3.2xlarge",
            InstanceType::P38xlarge => "p3.8xlarge",
            InstanceType::P3dn24xlarge => "p3dn.24xlarge",
            InstanceType::P4d24xlarge => "p4d.24xlarge",
            InstanceType::R32xlarge => "r3.2xlarge",
            InstanceType::R34xlarge => "r3.4xlarge",
            InstanceType::R38xlarge => "r3.8xlarge",
            InstanceType::R3Large => "r3.large",
            InstanceType::R3Xlarge => "r3.xlarge",
            InstanceType::R416xlarge => "r4.16xlarge",
            InstanceType::R42xlarge => "r4.2xlarge",
            InstanceType::R44xlarge => "r4.4xlarge",
            InstanceType::R48xlarge => "r4.8xlarge",
            InstanceType::R4Large => "r4.large",
            InstanceType::R4Xlarge => "r4.xlarge",
            InstanceType::R512xlarge => "r5.12xlarge",
            InstanceType::R516xlarge => "r5.16xlarge",
            InstanceType::R524xlarge => "r5.24xlarge",
            InstanceType::R52xlarge => "r5.2xlarge",
            InstanceType::R54xlarge => "r5.4xlarge",
            InstanceType::R58xlarge => "r5.8xlarge",
            InstanceType::R5Large => "r5.large",
            InstanceType::R5Metal => "r5.metal",
            InstanceType::R5Xlarge => "r5.xlarge",
            InstanceType::R5a12xlarge => "r5a.12xlarge",
            InstanceType::R5a16xlarge => "r5a.16xlarge",
            InstanceType::R5a24xlarge => "r5a.24xlarge",
            InstanceType::R5a2xlarge => "r5a.2xlarge",
            InstanceType::R5a4xlarge => "r5a.4xlarge",
            InstanceType::R5a8xlarge => "r5a.8xlarge",
            InstanceType::R5aLarge => "r5a.large",
            InstanceType::R5aXlarge => "r5a.xlarge",
            InstanceType::R5ad12xlarge => "r5ad.12xlarge",
            InstanceType::R5ad16xlarge => "r5ad.16xlarge",
            InstanceType::R5ad24xlarge => "r5ad.24xlarge",
            InstanceType::R5ad2xlarge => "r5ad.2xlarge",
            InstanceType::R5ad4xlarge => "r5ad.4xlarge",
            InstanceType::R5ad8xlarge => "r5ad.8xlarge",
            InstanceType::R5adLarge => "r5ad.large",
            InstanceType::R5adXlarge => "r5ad.xlarge",
            InstanceType::R5b12xlarge => "r5b.12xlarge",
            InstanceType::R5b16xlarge => "r5b.16xlarge",
            InstanceType::R5b24xlarge => "r5b.24xlarge",
            InstanceType::R5b2xlarge => "r5b.2xlarge",
            InstanceType::R5b4xlarge => "r5b.4xlarge",
            InstanceType::R5b8xlarge => "r5b.8xlarge",
            InstanceType::R5bLarge => "r5b.large",
            InstanceType::R5bMetal => "r5b.metal",
            InstanceType::R5bXlarge => "r5b.xlarge",
            InstanceType::R5d12xlarge => "r5d.12xlarge",
            InstanceType::R5d16xlarge => "r5d.16xlarge",
            InstanceType::R5d24xlarge => "r5d.24xlarge",
            InstanceType::R5d2xlarge => "r5d.2xlarge",
            InstanceType::R5d4xlarge => "r5d.4xlarge",
            InstanceType::R5d8xlarge => "r5d.8xlarge",
            InstanceType::R5dLarge => "r5d.large",
            InstanceType::R5dMetal => "r5d.metal",
            InstanceType::R5dXlarge => "r5d.xlarge",
            InstanceType::R5dn12xlarge => "r5dn.12xlarge",
            InstanceType::R5dn16xlarge => "r5dn.16xlarge",
            InstanceType::R5dn24xlarge => "r5dn.24xlarge",
            InstanceType::R5dn2xlarge => "r5dn.2xlarge",
            InstanceType::R5dn4xlarge => "r5dn.4xlarge",
            InstanceType::R5dn8xlarge => "r5dn.8xlarge",
            InstanceType::R5dnLarge => "r5dn.large",
            InstanceType::R5dnMetal => "r5dn.metal",
            InstanceType::R5dnXlarge => "r5dn.xlarge",
            InstanceType::R5n12xlarge => "r5n.12xlarge",
            InstanceType::R5n16xlarge => "r5n.16xlarge",
            InstanceType::R5n24xlarge => "r5n.24xlarge",
            InstanceType::R5n2xlarge => "r5n.2xlarge",
            InstanceType::R5n4xlarge => "r5n.4xlarge",
            InstanceType::R5n8xlarge => "r5n.8xlarge",
            InstanceType::R5nLarge => "r5n.large",
            InstanceType::R5nMetal => "r5n.metal",
            InstanceType::R5nXlarge => "r5n.xlarge",
            InstanceType::R6g12xlarge => "r6g.12xlarge",
            InstanceType::R6g16xlarge => "r6g.16xlarge",
            InstanceType::R6g2xlarge => "r6g.2xlarge",
            InstanceType::R6g4xlarge => "r6g.4xlarge",
            InstanceType::R6g8xlarge => "r6g.8xlarge",
            InstanceType::R6gLarge => "r6g.large",
            InstanceType::R6gMedium => "r6g.medium",
            InstanceType::R6gMetal => "r6g.metal",
            InstanceType::R6gXlarge => "r6g.xlarge",
            InstanceType::R6gd12xlarge => "r6gd.12xlarge",
            InstanceType::R6gd16xlarge => "r6gd.16xlarge",
            InstanceType::R6gd2xlarge => "r6gd.2xlarge",
            InstanceType::R6gd4xlarge => "r6gd.4xlarge",
            InstanceType::R6gd8xlarge => "r6gd.8xlarge",
            InstanceType::R6gdLarge => "r6gd.large",
            InstanceType::R6gdMedium => "r6gd.medium",
            InstanceType::R6gdMetal => "r6gd.metal",
            InstanceType::R6gdXlarge => "r6gd.xlarge",
            InstanceType::R6i12xlarge => "r6i.12xlarge",
            InstanceType::R6i16xlarge => "r6i.16xlarge",
            InstanceType::R6i24xlarge => "r6i.24xlarge",
            InstanceType::R6i2xlarge => "r6i.2xlarge",
            InstanceType::R6i32xlarge => "r6i.32xlarge",
            InstanceType::R6i4xlarge => "r6i.4xlarge",
            InstanceType::R6i8xlarge => "r6i.8xlarge",
            InstanceType::R6iLarge => "r6i.large",
            InstanceType::R6iMetal => "r6i.metal",
            InstanceType::R6iXlarge => "r6i.xlarge",
            InstanceType::T1Micro => "t1.micro",
            InstanceType::T22xlarge => "t2.2xlarge",
            InstanceType::T2Large => "t2.large",
            InstanceType::T2Medium => "t2.medium",
            InstanceType::T2Micro => "t2.micro",
            InstanceType::T2Nano => "t2.nano",
            InstanceType::T2Small => "t2.small",
            InstanceType::T2Xlarge => "t2.xlarge",
            InstanceType::T32xlarge => "t3.2xlarge",
            InstanceType::T3Large => "t3.large",
            InstanceType::T3Medium => "t3.medium",
            InstanceType::T3Micro => "t3.micro",
            InstanceType::T3Nano => "t3.nano",
            InstanceType::T3Small => "t3.small",
            InstanceType::T3Xlarge => "t3.xlarge",
            InstanceType::T3a2xlarge => "t3a.2xlarge",
            InstanceType::T3aLarge => "t3a.large",
            InstanceType::T3aMedium => "t3a.medium",
            InstanceType::T3aMicro => "t3a.micro",
            InstanceType::T3aNano => "t3a.nano",
            InstanceType::T3aSmall => "t3a.small",
            InstanceType::T3aXlarge => "t3a.xlarge",
            InstanceType::T4g2xlarge => "t4g.2xlarge",
            InstanceType::T4gLarge => "t4g.large",
            InstanceType::T4gMedium => "t4g.medium",
            InstanceType::T4gMicro => "t4g.micro",
            InstanceType::T4gNano => "t4g.nano",
            InstanceType::T4gSmall => "t4g.small",
            InstanceType::T4gXlarge => "t4g.xlarge",
            InstanceType::U12tb1112xlarge => "u-12tb1.112xlarge",
            InstanceType::U12tb1Metal => "u-12tb1.metal",
            InstanceType::U18tb1Metal => "u-18tb1.metal",
            InstanceType::U24tb1Metal => "u-24tb1.metal",
            InstanceType::U6tb1112xlarge => "u-6tb1.112xlarge",
            InstanceType::U6tb156xlarge => "u-6tb1.56xlarge",
            InstanceType::U6tb1Metal => "u-6tb1.metal",
            InstanceType::U9tb1112xlarge => "u-9tb1.112xlarge",
            InstanceType::U9tb1Metal => "u-9tb1.metal",
            InstanceType::Vt124xlarge => "vt1.24xlarge",
            InstanceType::Vt13xlarge => "vt1.3xlarge",
            InstanceType::Vt16xlarge => "vt1.6xlarge",
            InstanceType::X116xlarge => "x1.16xlarge",
            InstanceType::X132xlarge => "x1.32xlarge",
            InstanceType::X1e16xlarge => "x1e.16xlarge",
            InstanceType::X1e2xlarge => "x1e.2xlarge",
            InstanceType::X1e32xlarge => "x1e.32xlarge",
            InstanceType::X1e4xlarge => "x1e.4xlarge",
            InstanceType::X1e8xlarge => "x1e.8xlarge",
            InstanceType::X1eXlarge => "x1e.xlarge",
            InstanceType::X2gd12xlarge => "x2gd.12xlarge",
            InstanceType::X2gd16xlarge => "x2gd.16xlarge",
            InstanceType::X2gd2xlarge => "x2gd.2xlarge",
            InstanceType::X2gd4xlarge => "x2gd.4xlarge",
            InstanceType::X2gd8xlarge => "x2gd.8xlarge",
            InstanceType::X2gdLarge => "x2gd.large",
            InstanceType::X2gdMedium => "x2gd.medium",
            InstanceType::X2gdMetal => "x2gd.metal",
            InstanceType::X2gdXlarge => "x2gd.xlarge",
            InstanceType::X2iezn12xlarge => "x2iezn.12xlarge",
            InstanceType::X2iezn2xlarge => "x2iezn.2xlarge",
            InstanceType::X2iezn4xlarge => "x2iezn.4xlarge",
            InstanceType::X2iezn6xlarge => "x2iezn.6xlarge",
            InstanceType::X2iezn8xlarge => "x2iezn.8xlarge",
            InstanceType::X2ieznMetal => "x2iezn.metal",
            InstanceType::Z1d12xlarge => "z1d.12xlarge",
            InstanceType::Z1d2xlarge => "z1d.2xlarge",
            InstanceType::Z1d3xlarge => "z1d.3xlarge",
            InstanceType::Z1d6xlarge => "z1d.6xlarge",
            InstanceType::Z1dLarge => "z1d.large",
            InstanceType::Z1dMetal => "z1d.metal",
            InstanceType::Z1dXlarge => "z1d.xlarge",
            InstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "a1.2xlarge",
            "a1.4xlarge",
            "a1.large",
            "a1.medium",
            "a1.metal",
            "a1.xlarge",
            "c1.medium",
            "c1.xlarge",
            "c3.2xlarge",
            "c3.4xlarge",
            "c3.8xlarge",
            "c3.large",
            "c3.xlarge",
            "c4.2xlarge",
            "c4.4xlarge",
            "c4.8xlarge",
            "c4.large",
            "c4.xlarge",
            "c5.12xlarge",
            "c5.18xlarge",
            "c5.24xlarge",
            "c5.2xlarge",
            "c5.4xlarge",
            "c5.9xlarge",
            "c5.large",
            "c5.metal",
            "c5.xlarge",
            "c5a.12xlarge",
            "c5a.16xlarge",
            "c5a.24xlarge",
            "c5a.2xlarge",
            "c5a.4xlarge",
            "c5a.8xlarge",
            "c5a.large",
            "c5a.xlarge",
            "c5ad.12xlarge",
            "c5ad.16xlarge",
            "c5ad.24xlarge",
            "c5ad.2xlarge",
            "c5ad.4xlarge",
            "c5ad.8xlarge",
            "c5ad.large",
            "c5ad.xlarge",
            "c5d.12xlarge",
            "c5d.18xlarge",
            "c5d.24xlarge",
            "c5d.2xlarge",
            "c5d.4xlarge",
            "c5d.9xlarge",
            "c5d.large",
            "c5d.metal",
            "c5d.xlarge",
            "c5n.18xlarge",
            "c5n.2xlarge",
            "c5n.4xlarge",
            "c5n.9xlarge",
            "c5n.large",
            "c5n.metal",
            "c5n.xlarge",
            "c6g.12xlarge",
            "c6g.16xlarge",
            "c6g.2xlarge",
            "c6g.4xlarge",
            "c6g.8xlarge",
            "c6g.large",
            "c6g.medium",
            "c6g.metal",
            "c6g.xlarge",
            "c6gd.12xlarge",
            "c6gd.16xlarge",
            "c6gd.2xlarge",
            "c6gd.4xlarge",
            "c6gd.8xlarge",
            "c6gd.large",
            "c6gd.medium",
            "c6gd.metal",
            "c6gd.xlarge",
            "c6gn.12xlarge",
            "c6gn.16xlarge",
            "c6gn.2xlarge",
            "c6gn.4xlarge",
            "c6gn.8xlarge",
            "c6gn.large",
            "c6gn.medium",
            "c6gn.xlarge",
            "c6i.12xlarge",
            "c6i.16xlarge",
            "c6i.24xlarge",
            "c6i.2xlarge",
            "c6i.32xlarge",
            "c6i.4xlarge",
            "c6i.8xlarge",
            "c6i.large",
            "c6i.metal",
            "c6i.xlarge",
            "cc1.4xlarge",
            "cc2.8xlarge",
            "cg1.4xlarge",
            "cr1.8xlarge",
            "d2.2xlarge",
            "d2.4xlarge",
            "d2.8xlarge",
            "d2.xlarge",
            "d3.2xlarge",
            "d3.4xlarge",
            "d3.8xlarge",
            "d3.xlarge",
            "d3en.12xlarge",
            "d3en.2xlarge",
            "d3en.4xlarge",
            "d3en.6xlarge",
            "d3en.8xlarge",
            "d3en.xlarge",
            "dl1.24xlarge",
            "f1.16xlarge",
            "f1.2xlarge",
            "f1.4xlarge",
            "g2.2xlarge",
            "g2.8xlarge",
            "g3.16xlarge",
            "g3.4xlarge",
            "g3.8xlarge",
            "g3s.xlarge",
            "g4ad.16xlarge",
            "g4ad.2xlarge",
            "g4ad.4xlarge",
            "g4ad.8xlarge",
            "g4ad.xlarge",
            "g4dn.12xlarge",
            "g4dn.16xlarge",
            "g4dn.2xlarge",
            "g4dn.4xlarge",
            "g4dn.8xlarge",
            "g4dn.metal",
            "g4dn.xlarge",
            "g5.12xlarge",
            "g5.16xlarge",
            "g5.24xlarge",
            "g5.2xlarge",
            "g5.48xlarge",
            "g5.4xlarge",
            "g5.8xlarge",
            "g5.xlarge",
            "g5g.16xlarge",
            "g5g.2xlarge",
            "g5g.4xlarge",
            "g5g.8xlarge",
            "g5g.metal",
            "g5g.xlarge",
            "h1.16xlarge",
            "h1.2xlarge",
            "h1.4xlarge",
            "h1.8xlarge",
            "hi1.4xlarge",
            "hpc6a.48xlarge",
            "hs1.8xlarge",
            "i2.2xlarge",
            "i2.4xlarge",
            "i2.8xlarge",
            "i2.xlarge",
            "i3.16xlarge",
            "i3.2xlarge",
            "i3.4xlarge",
            "i3.8xlarge",
            "i3.large",
            "i3.metal",
            "i3.xlarge",
            "i3en.12xlarge",
            "i3en.24xlarge",
            "i3en.2xlarge",
            "i3en.3xlarge",
            "i3en.6xlarge",
            "i3en.large",
            "i3en.metal",
            "i3en.xlarge",
            "im4gn.16xlarge",
            "im4gn.2xlarge",
            "im4gn.4xlarge",
            "im4gn.8xlarge",
            "im4gn.large",
            "im4gn.xlarge",
            "inf1.24xlarge",
            "inf1.2xlarge",
            "inf1.6xlarge",
            "inf1.xlarge",
            "is4gen.2xlarge",
            "is4gen.4xlarge",
            "is4gen.8xlarge",
            "is4gen.large",
            "is4gen.medium",
            "is4gen.xlarge",
            "m1.large",
            "m1.medium",
            "m1.small",
            "m1.xlarge",
            "m2.2xlarge",
            "m2.4xlarge",
            "m2.xlarge",
            "m3.2xlarge",
            "m3.large",
            "m3.medium",
            "m3.xlarge",
            "m4.10xlarge",
            "m4.16xlarge",
            "m4.2xlarge",
            "m4.4xlarge",
            "m4.large",
            "m4.xlarge",
            "m5.12xlarge",
            "m5.16xlarge",
            "m5.24xlarge",
            "m5.2xlarge",
            "m5.4xlarge",
            "m5.8xlarge",
            "m5.large",
            "m5.metal",
            "m5.xlarge",
            "m5a.12xlarge",
            "m5a.16xlarge",
            "m5a.24xlarge",
            "m5a.2xlarge",
            "m5a.4xlarge",
            "m5a.8xlarge",
            "m5a.large",
            "m5a.xlarge",
            "m5ad.12xlarge",
            "m5ad.16xlarge",
            "m5ad.24xlarge",
            "m5ad.2xlarge",
            "m5ad.4xlarge",
            "m5ad.8xlarge",
            "m5ad.large",
            "m5ad.xlarge",
            "m5d.12xlarge",
            "m5d.16xlarge",
            "m5d.24xlarge",
            "m5d.2xlarge",
            "m5d.4xlarge",
            "m5d.8xlarge",
            "m5d.large",
            "m5d.metal",
            "m5d.xlarge",
            "m5dn.12xlarge",
            "m5dn.16xlarge",
            "m5dn.24xlarge",
            "m5dn.2xlarge",
            "m5dn.4xlarge",
            "m5dn.8xlarge",
            "m5dn.large",
            "m5dn.metal",
            "m5dn.xlarge",
            "m5n.12xlarge",
            "m5n.16xlarge",
            "m5n.24xlarge",
            "m5n.2xlarge",
            "m5n.4xlarge",
            "m5n.8xlarge",
            "m5n.large",
            "m5n.metal",
            "m5n.xlarge",
            "m5zn.12xlarge",
            "m5zn.2xlarge",
            "m5zn.3xlarge",
            "m5zn.6xlarge",
            "m5zn.large",
            "m5zn.metal",
            "m5zn.xlarge",
            "m6a.12xlarge",
            "m6a.16xlarge",
            "m6a.24xlarge",
            "m6a.2xlarge",
            "m6a.32xlarge",
            "m6a.48xlarge",
            "m6a.4xlarge",
            "m6a.8xlarge",
            "m6a.large",
            "m6a.xlarge",
            "m6g.12xlarge",
            "m6g.16xlarge",
            "m6g.2xlarge",
            "m6g.4xlarge",
            "m6g.8xlarge",
            "m6g.large",
            "m6g.medium",
            "m6g.metal",
            "m6g.xlarge",
            "m6gd.12xlarge",
            "m6gd.16xlarge",
            "m6gd.2xlarge",
            "m6gd.4xlarge",
            "m6gd.8xlarge",
            "m6gd.large",
            "m6gd.medium",
            "m6gd.metal",
            "m6gd.xlarge",
            "m6i.12xlarge",
            "m6i.16xlarge",
            "m6i.24xlarge",
            "m6i.2xlarge",
            "m6i.32xlarge",
            "m6i.4xlarge",
            "m6i.8xlarge",
            "m6i.large",
            "m6i.metal",
            "m6i.xlarge",
            "mac1.metal",
            "p2.16xlarge",
            "p2.8xlarge",
            "p2.xlarge",
            "p3.16xlarge",
            "p3.2xlarge",
            "p3.8xlarge",
            "p3dn.24xlarge",
            "p4d.24xlarge",
            "r3.2xlarge",
            "r3.4xlarge",
            "r3.8xlarge",
            "r3.large",
            "r3.xlarge",
            "r4.16xlarge",
            "r4.2xlarge",
            "r4.4xlarge",
            "r4.8xlarge",
            "r4.large",
            "r4.xlarge",
            "r5.12xlarge",
            "r5.16xlarge",
            "r5.24xlarge",
            "r5.2xlarge",
            "r5.4xlarge",
            "r5.8xlarge",
            "r5.large",
            "r5.metal",
            "r5.xlarge",
            "r5a.12xlarge",
            "r5a.16xlarge",
            "r5a.24xlarge",
            "r5a.2xlarge",
            "r5a.4xlarge",
            "r5a.8xlarge",
            "r5a.large",
            "r5a.xlarge",
            "r5ad.12xlarge",
            "r5ad.16xlarge",
            "r5ad.24xlarge",
            "r5ad.2xlarge",
            "r5ad.4xlarge",
            "r5ad.8xlarge",
            "r5ad.large",
            "r5ad.xlarge",
            "r5b.12xlarge",
            "r5b.16xlarge",
            "r5b.24xlarge",
            "r5b.2xlarge",
            "r5b.4xlarge",
            "r5b.8xlarge",
            "r5b.large",
            "r5b.metal",
            "r5b.xlarge",
            "r5d.12xlarge",
            "r5d.16xlarge",
            "r5d.24xlarge",
            "r5d.2xlarge",
            "r5d.4xlarge",
            "r5d.8xlarge",
            "r5d.large",
            "r5d.metal",
            "r5d.xlarge",
            "r5dn.12xlarge",
            "r5dn.16xlarge",
            "r5dn.24xlarge",
            "r5dn.2xlarge",
            "r5dn.4xlarge",
            "r5dn.8xlarge",
            "r5dn.large",
            "r5dn.metal",
            "r5dn.xlarge",
            "r5n.12xlarge",
            "r5n.16xlarge",
            "r5n.24xlarge",
            "r5n.2xlarge",
            "r5n.4xlarge",
            "r5n.8xlarge",
            "r5n.large",
            "r5n.metal",
            "r5n.xlarge",
            "r6g.12xlarge",
            "r6g.16xlarge",
            "r6g.2xlarge",
            "r6g.4xlarge",
            "r6g.8xlarge",
            "r6g.large",
            "r6g.medium",
            "r6g.metal",
            "r6g.xlarge",
            "r6gd.12xlarge",
            "r6gd.16xlarge",
            "r6gd.2xlarge",
            "r6gd.4xlarge",
            "r6gd.8xlarge",
            "r6gd.large",
            "r6gd.medium",
            "r6gd.metal",
            "r6gd.xlarge",
            "r6i.12xlarge",
            "r6i.16xlarge",
            "r6i.24xlarge",
            "r6i.2xlarge",
            "r6i.32xlarge",
            "r6i.4xlarge",
            "r6i.8xlarge",
            "r6i.large",
            "r6i.metal",
            "r6i.xlarge",
            "t1.micro",
            "t2.2xlarge",
            "t2.large",
            "t2.medium",
            "t2.micro",
            "t2.nano",
            "t2.small",
            "t2.xlarge",
            "t3.2xlarge",
            "t3.large",
            "t3.medium",
            "t3.micro",
            "t3.nano",
            "t3.small",
            "t3.xlarge",
            "t3a.2xlarge",
            "t3a.large",
            "t3a.medium",
            "t3a.micro",
            "t3a.nano",
            "t3a.small",
            "t3a.xlarge",
            "t4g.2xlarge",
            "t4g.large",
            "t4g.medium",
            "t4g.micro",
            "t4g.nano",
            "t4g.small",
            "t4g.xlarge",
            "u-12tb1.112xlarge",
            "u-12tb1.metal",
            "u-18tb1.metal",
            "u-24tb1.metal",
            "u-6tb1.112xlarge",
            "u-6tb1.56xlarge",
            "u-6tb1.metal",
            "u-9tb1.112xlarge",
            "u-9tb1.metal",
            "vt1.24xlarge",
            "vt1.3xlarge",
            "vt1.6xlarge",
            "x1.16xlarge",
            "x1.32xlarge",
            "x1e.16xlarge",
            "x1e.2xlarge",
            "x1e.32xlarge",
            "x1e.4xlarge",
            "x1e.8xlarge",
            "x1e.xlarge",
            "x2gd.12xlarge",
            "x2gd.16xlarge",
            "x2gd.2xlarge",
            "x2gd.4xlarge",
            "x2gd.8xlarge",
            "x2gd.large",
            "x2gd.medium",
            "x2gd.metal",
            "x2gd.xlarge",
            "x2iezn.12xlarge",
            "x2iezn.2xlarge",
            "x2iezn.4xlarge",
            "x2iezn.6xlarge",
            "x2iezn.8xlarge",
            "x2iezn.metal",
            "z1d.12xlarge",
            "z1d.2xlarge",
            "z1d.3xlarge",
            "z1d.6xlarge",
            "z1d.large",
            "z1d.metal",
            "z1d.xlarge",
        ]
    }
}
impl AsRef<str> for InstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the options for instance hostnames.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateDnsNameOptionsRequest {
    /// <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.</p>
    pub hostname_type: std::option::Option<crate::model::HostnameType>,
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
    pub enable_resource_name_dns_a_record: std::option::Option<bool>,
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
    pub enable_resource_name_dns_aaaa_record: std::option::Option<bool>,
}
impl PrivateDnsNameOptionsRequest {
    /// <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.</p>
    pub fn hostname_type(&self) -> std::option::Option<&crate::model::HostnameType> {
        self.hostname_type.as_ref()
    }
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
    pub fn enable_resource_name_dns_a_record(&self) -> std::option::Option<bool> {
        self.enable_resource_name_dns_a_record
    }
    /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
    pub fn enable_resource_name_dns_aaaa_record(&self) -> std::option::Option<bool> {
        self.enable_resource_name_dns_aaaa_record
    }
}
impl std::fmt::Debug for PrivateDnsNameOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateDnsNameOptionsRequest");
        formatter.field("hostname_type", &self.hostname_type);
        formatter.field(
            "enable_resource_name_dns_a_record",
            &self.enable_resource_name_dns_a_record,
        );
        formatter.field(
            "enable_resource_name_dns_aaaa_record",
            &self.enable_resource_name_dns_aaaa_record,
        );
        formatter.finish()
    }
}
/// See [`PrivateDnsNameOptionsRequest`](crate::model::PrivateDnsNameOptionsRequest)
pub mod private_dns_name_options_request {
    /// A builder for [`PrivateDnsNameOptionsRequest`](crate::model::PrivateDnsNameOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname_type: std::option::Option<crate::model::HostnameType>,
        pub(crate) enable_resource_name_dns_a_record: std::option::Option<bool>,
        pub(crate) enable_resource_name_dns_aaaa_record: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.</p>
        pub fn hostname_type(mut self, input: crate::model::HostnameType) -> Self {
            self.hostname_type = Some(input);
            self
        }
        /// <p>The type of hostname for EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 only subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID.</p>
        pub fn set_hostname_type(
            mut self,
            input: std::option::Option<crate::model::HostnameType>,
        ) -> Self {
            self.hostname_type = input;
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
        pub fn enable_resource_name_dns_a_record(mut self, input: bool) -> Self {
            self.enable_resource_name_dns_a_record = Some(input);
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS A records.</p>
        pub fn set_enable_resource_name_dns_a_record(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_resource_name_dns_a_record = input;
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
        pub fn enable_resource_name_dns_aaaa_record(mut self, input: bool) -> Self {
            self.enable_resource_name_dns_aaaa_record = Some(input);
            self
        }
        /// <p>Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.</p>
        pub fn set_enable_resource_name_dns_aaaa_record(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_resource_name_dns_aaaa_record = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateDnsNameOptionsRequest`](crate::model::PrivateDnsNameOptionsRequest)
        pub fn build(self) -> crate::model::PrivateDnsNameOptionsRequest {
            crate::model::PrivateDnsNameOptionsRequest {
                hostname_type: self.hostname_type,
                enable_resource_name_dns_a_record: self.enable_resource_name_dns_a_record,
                enable_resource_name_dns_aaaa_record: self.enable_resource_name_dns_aaaa_record,
            }
        }
    }
}
impl PrivateDnsNameOptionsRequest {
    /// Creates a new builder-style object to manufacture [`PrivateDnsNameOptionsRequest`](crate::model::PrivateDnsNameOptionsRequest)
    pub fn builder() -> crate::model::private_dns_name_options_request::Builder {
        crate::model::private_dns_name_options_request::Builder::default()
    }
}

/// <p>Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html"> What is Amazon Web Services Nitro Enclaves?</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnclaveOptionsRequest {
    /// <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>
    pub enabled: std::option::Option<bool>,
}
impl EnclaveOptionsRequest {
    /// <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for EnclaveOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnclaveOptionsRequest");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`EnclaveOptionsRequest`](crate::model::EnclaveOptionsRequest)
pub mod enclave_options_request {
    /// A builder for [`EnclaveOptionsRequest`](crate::model::EnclaveOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EnclaveOptionsRequest`](crate::model::EnclaveOptionsRequest)
        pub fn build(self) -> crate::model::EnclaveOptionsRequest {
            crate::model::EnclaveOptionsRequest {
                enabled: self.enabled,
            }
        }
    }
}
impl EnclaveOptionsRequest {
    /// Creates a new builder-style object to manufacture [`EnclaveOptionsRequest`](crate::model::EnclaveOptionsRequest)
    pub fn builder() -> crate::model::enclave_options_request::Builder {
        crate::model::enclave_options_request::Builder::default()
    }
}

/// <p>The metadata options for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMetadataOptionsRequest {
    /// <p>The state of token usage for your instance metadata requests.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
    /// <p>Default: <code>optional</code> </p>
    pub http_tokens: std::option::Option<crate::model::HttpTokensState>,
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    /// <p>Possible values: Integers from 1 to 64</p>
    pub http_put_response_hop_limit: std::option::Option<i32>,
    /// <p>Enables or disables the HTTP metadata endpoint on your instances.</p>
    /// <p>If you specify a value of <code>disabled</code>, you cannot access your instance metadata.</p>
    /// <p>Default: <code>enabled</code> </p>
    pub http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
    /// <p>Enables or disables the IPv6 endpoint for the instance metadata service.</p>
    pub http_protocol_ipv6: std::option::Option<crate::model::InstanceMetadataProtocolState>,
    /// <p>Set to <code>enabled</code> to allow access to instance tags from the instance metadata. Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
    /// <p>Default: <code>disabled</code> </p>
    pub instance_metadata_tags: std::option::Option<crate::model::InstanceMetadataTagsState>,
}
impl InstanceMetadataOptionsRequest {
    /// <p>The state of token usage for your instance metadata requests.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
    /// <p>Default: <code>optional</code> </p>
    pub fn http_tokens(&self) -> std::option::Option<&crate::model::HttpTokensState> {
        self.http_tokens.as_ref()
    }
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    /// <p>Possible values: Integers from 1 to 64</p>
    pub fn http_put_response_hop_limit(&self) -> std::option::Option<i32> {
        self.http_put_response_hop_limit
    }
    /// <p>Enables or disables the HTTP metadata endpoint on your instances.</p>
    /// <p>If you specify a value of <code>disabled</code>, you cannot access your instance metadata.</p>
    /// <p>Default: <code>enabled</code> </p>
    pub fn http_endpoint(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataEndpointState> {
        self.http_endpoint.as_ref()
    }
    /// <p>Enables or disables the IPv6 endpoint for the instance metadata service.</p>
    pub fn http_protocol_ipv6(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataProtocolState> {
        self.http_protocol_ipv6.as_ref()
    }
    /// <p>Set to <code>enabled</code> to allow access to instance tags from the instance metadata. Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
    /// <p>Default: <code>disabled</code> </p>
    pub fn instance_metadata_tags(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataTagsState> {
        self.instance_metadata_tags.as_ref()
    }
}
impl std::fmt::Debug for InstanceMetadataOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMetadataOptionsRequest");
        formatter.field("http_tokens", &self.http_tokens);
        formatter.field(
            "http_put_response_hop_limit",
            &self.http_put_response_hop_limit,
        );
        formatter.field("http_endpoint", &self.http_endpoint);
        formatter.field("http_protocol_ipv6", &self.http_protocol_ipv6);
        formatter.field("instance_metadata_tags", &self.instance_metadata_tags);
        formatter.finish()
    }
}
/// See [`InstanceMetadataOptionsRequest`](crate::model::InstanceMetadataOptionsRequest)
pub mod instance_metadata_options_request {
    /// A builder for [`InstanceMetadataOptionsRequest`](crate::model::InstanceMetadataOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_tokens: std::option::Option<crate::model::HttpTokensState>,
        pub(crate) http_put_response_hop_limit: std::option::Option<i32>,
        pub(crate) http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
        pub(crate) http_protocol_ipv6:
            std::option::Option<crate::model::InstanceMetadataProtocolState>,
        pub(crate) instance_metadata_tags:
            std::option::Option<crate::model::InstanceMetadataTagsState>,
    }
    impl Builder {
        /// <p>The state of token usage for your instance metadata requests.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
        /// <p>Default: <code>optional</code> </p>
        pub fn http_tokens(mut self, input: crate::model::HttpTokensState) -> Self {
            self.http_tokens = Some(input);
            self
        }
        /// <p>The state of token usage for your instance metadata requests.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>
        /// <p>Default: <code>optional</code> </p>
        pub fn set_http_tokens(
            mut self,
            input: std::option::Option<crate::model::HttpTokensState>,
        ) -> Self {
            self.http_tokens = input;
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        /// <p>Possible values: Integers from 1 to 64</p>
        pub fn http_put_response_hop_limit(mut self, input: i32) -> Self {
            self.http_put_response_hop_limit = Some(input);
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        /// <p>Possible values: Integers from 1 to 64</p>
        pub fn set_http_put_response_hop_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.http_put_response_hop_limit = input;
            self
        }
        /// <p>Enables or disables the HTTP metadata endpoint on your instances.</p>
        /// <p>If you specify a value of <code>disabled</code>, you cannot access your instance metadata.</p>
        /// <p>Default: <code>enabled</code> </p>
        pub fn http_endpoint(mut self, input: crate::model::InstanceMetadataEndpointState) -> Self {
            self.http_endpoint = Some(input);
            self
        }
        /// <p>Enables or disables the HTTP metadata endpoint on your instances.</p>
        /// <p>If you specify a value of <code>disabled</code>, you cannot access your instance metadata.</p>
        /// <p>Default: <code>enabled</code> </p>
        pub fn set_http_endpoint(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataEndpointState>,
        ) -> Self {
            self.http_endpoint = input;
            self
        }
        /// <p>Enables or disables the IPv6 endpoint for the instance metadata service.</p>
        pub fn http_protocol_ipv6(
            mut self,
            input: crate::model::InstanceMetadataProtocolState,
        ) -> Self {
            self.http_protocol_ipv6 = Some(input);
            self
        }
        /// <p>Enables or disables the IPv6 endpoint for the instance metadata service.</p>
        pub fn set_http_protocol_ipv6(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataProtocolState>,
        ) -> Self {
            self.http_protocol_ipv6 = input;
            self
        }
        /// <p>Set to <code>enabled</code> to allow access to instance tags from the instance metadata. Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
        /// <p>Default: <code>disabled</code> </p>
        pub fn instance_metadata_tags(
            mut self,
            input: crate::model::InstanceMetadataTagsState,
        ) -> Self {
            self.instance_metadata_tags = Some(input);
            self
        }
        /// <p>Set to <code>enabled</code> to allow access to instance tags from the instance metadata. Set to <code>disabled</code> to turn off access to instance tags from the instance metadata. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with instance tags using the instance metadata</a>.</p>
        /// <p>Default: <code>disabled</code> </p>
        pub fn set_instance_metadata_tags(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataTagsState>,
        ) -> Self {
            self.instance_metadata_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMetadataOptionsRequest`](crate::model::InstanceMetadataOptionsRequest)
        pub fn build(self) -> crate::model::InstanceMetadataOptionsRequest {
            crate::model::InstanceMetadataOptionsRequest {
                http_tokens: self.http_tokens,
                http_put_response_hop_limit: self.http_put_response_hop_limit,
                http_endpoint: self.http_endpoint,
                http_protocol_ipv6: self.http_protocol_ipv6,
                instance_metadata_tags: self.instance_metadata_tags,
            }
        }
    }
}
impl InstanceMetadataOptionsRequest {
    /// Creates a new builder-style object to manufacture [`InstanceMetadataOptionsRequest`](crate::model::InstanceMetadataOptionsRequest)
    pub fn builder() -> crate::model::instance_metadata_options_request::Builder {
        crate::model::instance_metadata_options_request::Builder::default()
    }
}

/// <p>Describes a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConfigurationRequest {
    /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
}
impl LicenseConfigurationRequest {
    /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for LicenseConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConfigurationRequest");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.finish()
    }
}
/// See [`LicenseConfigurationRequest`](crate::model::LicenseConfigurationRequest)
pub mod license_configuration_request {
    /// A builder for [`LicenseConfigurationRequest`](crate::model::LicenseConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConfigurationRequest`](crate::model::LicenseConfigurationRequest)
        pub fn build(self) -> crate::model::LicenseConfigurationRequest {
            crate::model::LicenseConfigurationRequest {
                license_configuration_arn: self.license_configuration_arn,
            }
        }
    }
}
impl LicenseConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`LicenseConfigurationRequest`](crate::model::LicenseConfigurationRequest)
    pub fn builder() -> crate::model::license_configuration_request::Builder {
        crate::model::license_configuration_request::Builder::default()
    }
}

/// <p>Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon EC2 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HibernationOptionsRequest {
    /// <p>If you set this parameter to <code>true</code>, your instance is enabled for hibernation.</p>
    /// <p>Default: <code>false</code> </p>
    pub configured: std::option::Option<bool>,
}
impl HibernationOptionsRequest {
    /// <p>If you set this parameter to <code>true</code>, your instance is enabled for hibernation.</p>
    /// <p>Default: <code>false</code> </p>
    pub fn configured(&self) -> std::option::Option<bool> {
        self.configured
    }
}
impl std::fmt::Debug for HibernationOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HibernationOptionsRequest");
        formatter.field("configured", &self.configured);
        formatter.finish()
    }
}
/// See [`HibernationOptionsRequest`](crate::model::HibernationOptionsRequest)
pub mod hibernation_options_request {
    /// A builder for [`HibernationOptionsRequest`](crate::model::HibernationOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configured: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If you set this parameter to <code>true</code>, your instance is enabled for hibernation.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn configured(mut self, input: bool) -> Self {
            self.configured = Some(input);
            self
        }
        /// <p>If you set this parameter to <code>true</code>, your instance is enabled for hibernation.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_configured(mut self, input: std::option::Option<bool>) -> Self {
            self.configured = input;
            self
        }
        /// Consumes the builder and constructs a [`HibernationOptionsRequest`](crate::model::HibernationOptionsRequest)
        pub fn build(self) -> crate::model::HibernationOptionsRequest {
            crate::model::HibernationOptionsRequest {
                configured: self.configured,
            }
        }
    }
}
impl HibernationOptionsRequest {
    /// Creates a new builder-style object to manufacture [`HibernationOptionsRequest`](crate::model::HibernationOptionsRequest)
    pub fn builder() -> crate::model::hibernation_options_request::Builder {
        crate::model::hibernation_options_request::Builder::default()
    }
}

/// <p>Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.</p>
/// <p>Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityReservationSpecification {
    /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
    /// <ul>
    /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
    /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li>
    /// </ul>
    pub capacity_reservation_preference:
        std::option::Option<crate::model::CapacityReservationPreference>,
    /// <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
    pub capacity_reservation_target: std::option::Option<crate::model::CapacityReservationTarget>,
}
impl CapacityReservationSpecification {
    /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
    /// <ul>
    /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
    /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li>
    /// </ul>
    pub fn capacity_reservation_preference(
        &self,
    ) -> std::option::Option<&crate::model::CapacityReservationPreference> {
        self.capacity_reservation_preference.as_ref()
    }
    /// <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
    pub fn capacity_reservation_target(
        &self,
    ) -> std::option::Option<&crate::model::CapacityReservationTarget> {
        self.capacity_reservation_target.as_ref()
    }
}
impl std::fmt::Debug for CapacityReservationSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityReservationSpecification");
        formatter.field(
            "capacity_reservation_preference",
            &self.capacity_reservation_preference,
        );
        formatter.field(
            "capacity_reservation_target",
            &self.capacity_reservation_target,
        );
        formatter.finish()
    }
}
/// See [`CapacityReservationSpecification`](crate::model::CapacityReservationSpecification)
pub mod capacity_reservation_specification {
    /// A builder for [`CapacityReservationSpecification`](crate::model::CapacityReservationSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_reservation_preference:
            std::option::Option<crate::model::CapacityReservationPreference>,
        pub(crate) capacity_reservation_target:
            std::option::Option<crate::model::CapacityReservationTarget>,
    }
    impl Builder {
        /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
        /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li>
        /// </ul>
        pub fn capacity_reservation_preference(
            mut self,
            input: crate::model::CapacityReservationPreference,
        ) -> Self {
            self.capacity_reservation_preference = Some(input);
            self
        }
        /// <p>Indicates the instance's Capacity Reservation preferences. Possible preferences include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li>
        /// <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li>
        /// </ul>
        pub fn set_capacity_reservation_preference(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationPreference>,
        ) -> Self {
            self.capacity_reservation_preference = input;
            self
        }
        /// <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
        pub fn capacity_reservation_target(
            mut self,
            input: crate::model::CapacityReservationTarget,
        ) -> Self {
            self.capacity_reservation_target = Some(input);
            self
        }
        /// <p>Information about the target Capacity Reservation or Capacity Reservation group.</p>
        pub fn set_capacity_reservation_target(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationTarget>,
        ) -> Self {
            self.capacity_reservation_target = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityReservationSpecification`](crate::model::CapacityReservationSpecification)
        pub fn build(self) -> crate::model::CapacityReservationSpecification {
            crate::model::CapacityReservationSpecification {
                capacity_reservation_preference: self.capacity_reservation_preference,
                capacity_reservation_target: self.capacity_reservation_target,
            }
        }
    }
}
impl CapacityReservationSpecification {
    /// Creates a new builder-style object to manufacture [`CapacityReservationSpecification`](crate::model::CapacityReservationSpecification)
    pub fn builder() -> crate::model::capacity_reservation_specification::Builder {
        crate::model::capacity_reservation_specification::Builder::default()
    }
}

/// <p>Describes a target Capacity Reservation or Capacity Reservation group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityReservationTarget {
    /// <p>The ID of the Capacity Reservation in which to run the instance.</p>
    pub capacity_reservation_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
    pub capacity_reservation_resource_group_arn: std::option::Option<std::string::String>,
}
impl CapacityReservationTarget {
    /// <p>The ID of the Capacity Reservation in which to run the instance.</p>
    pub fn capacity_reservation_id(&self) -> std::option::Option<&str> {
        self.capacity_reservation_id.as_deref()
    }
    /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
    pub fn capacity_reservation_resource_group_arn(&self) -> std::option::Option<&str> {
        self.capacity_reservation_resource_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CapacityReservationTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityReservationTarget");
        formatter.field("capacity_reservation_id", &self.capacity_reservation_id);
        formatter.field(
            "capacity_reservation_resource_group_arn",
            &self.capacity_reservation_resource_group_arn,
        );
        formatter.finish()
    }
}
/// See [`CapacityReservationTarget`](crate::model::CapacityReservationTarget)
pub mod capacity_reservation_target {
    /// A builder for [`CapacityReservationTarget`](crate::model::CapacityReservationTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_reservation_id: std::option::Option<std::string::String>,
        pub(crate) capacity_reservation_resource_group_arn:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Capacity Reservation in which to run the instance.</p>
        pub fn capacity_reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_reservation_id = Some(input.into());
            self
        }
        /// <p>The ID of the Capacity Reservation in which to run the instance.</p>
        pub fn set_capacity_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_id = input;
            self
        }
        /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
        pub fn capacity_reservation_resource_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>
        pub fn set_capacity_reservation_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_resource_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityReservationTarget`](crate::model::CapacityReservationTarget)
        pub fn build(self) -> crate::model::CapacityReservationTarget {
            crate::model::CapacityReservationTarget {
                capacity_reservation_id: self.capacity_reservation_id,
                capacity_reservation_resource_group_arn: self
                    .capacity_reservation_resource_group_arn,
            }
        }
    }
}
impl CapacityReservationTarget {
    /// Creates a new builder-style object to manufacture [`CapacityReservationTarget`](crate::model::CapacityReservationTarget)
    pub fn builder() -> crate::model::capacity_reservation_target::Builder {
        crate::model::capacity_reservation_target::Builder::default()
    }
}

/// <p>The CPU options for the instance. Both the core count and threads per core must be specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CpuOptionsRequest {
    /// <p>The number of CPU cores for the instance.</p>
    pub core_count: std::option::Option<i32>,
    /// <p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>
    pub threads_per_core: std::option::Option<i32>,
}
impl CpuOptionsRequest {
    /// <p>The number of CPU cores for the instance.</p>
    pub fn core_count(&self) -> std::option::Option<i32> {
        self.core_count
    }
    /// <p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>
    pub fn threads_per_core(&self) -> std::option::Option<i32> {
        self.threads_per_core
    }
}
impl std::fmt::Debug for CpuOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CpuOptionsRequest");
        formatter.field("core_count", &self.core_count);
        formatter.field("threads_per_core", &self.threads_per_core);
        formatter.finish()
    }
}
/// See [`CpuOptionsRequest`](crate::model::CpuOptionsRequest)
pub mod cpu_options_request {
    /// A builder for [`CpuOptionsRequest`](crate::model::CpuOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_count: std::option::Option<i32>,
        pub(crate) threads_per_core: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of CPU cores for the instance.</p>
        pub fn core_count(mut self, input: i32) -> Self {
            self.core_count = Some(input);
            self
        }
        /// <p>The number of CPU cores for the instance.</p>
        pub fn set_core_count(mut self, input: std::option::Option<i32>) -> Self {
            self.core_count = input;
            self
        }
        /// <p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>
        pub fn threads_per_core(mut self, input: i32) -> Self {
            self.threads_per_core = Some(input);
            self
        }
        /// <p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>
        pub fn set_threads_per_core(mut self, input: std::option::Option<i32>) -> Self {
            self.threads_per_core = input;
            self
        }
        /// Consumes the builder and constructs a [`CpuOptionsRequest`](crate::model::CpuOptionsRequest)
        pub fn build(self) -> crate::model::CpuOptionsRequest {
            crate::model::CpuOptionsRequest {
                core_count: self.core_count,
                threads_per_core: self.threads_per_core,
            }
        }
    }
}
impl CpuOptionsRequest {
    /// Creates a new builder-style object to manufacture [`CpuOptionsRequest`](crate::model::CpuOptionsRequest)
    pub fn builder() -> crate::model::cpu_options_request::Builder {
        crate::model::cpu_options_request::Builder::default()
    }
}

/// <p>The credit option for CPU usage of a T2, T3, or T3a instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreditSpecificationRequest {
    /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
    pub cpu_credits: std::option::Option<std::string::String>,
}
impl CreditSpecificationRequest {
    /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
    pub fn cpu_credits(&self) -> std::option::Option<&str> {
        self.cpu_credits.as_deref()
    }
}
impl std::fmt::Debug for CreditSpecificationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreditSpecificationRequest");
        formatter.field("cpu_credits", &self.cpu_credits);
        formatter.finish()
    }
}
/// See [`CreditSpecificationRequest`](crate::model::CreditSpecificationRequest)
pub mod credit_specification_request {
    /// A builder for [`CreditSpecificationRequest`](crate::model::CreditSpecificationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_credits: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
        pub fn cpu_credits(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu_credits = Some(input.into());
            self
        }
        /// <p>The credit option for CPU usage of a T2, T3, or T3a instance. Valid values are <code>standard</code> and <code>unlimited</code>.</p>
        pub fn set_cpu_credits(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu_credits = input;
            self
        }
        /// Consumes the builder and constructs a [`CreditSpecificationRequest`](crate::model::CreditSpecificationRequest)
        pub fn build(self) -> crate::model::CreditSpecificationRequest {
            crate::model::CreditSpecificationRequest {
                cpu_credits: self.cpu_credits,
            }
        }
    }
}
impl CreditSpecificationRequest {
    /// Creates a new builder-style object to manufacture [`CreditSpecificationRequest`](crate::model::CreditSpecificationRequest)
    pub fn builder() -> crate::model::credit_specification_request::Builder {
        crate::model::credit_specification_request::Builder::default()
    }
}

/// <p>Describes the market (purchasing) option for the instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMarketOptionsRequest {
    /// <p>The market type.</p>
    pub market_type: std::option::Option<crate::model::MarketType>,
    /// <p>The options for Spot Instances.</p>
    pub spot_options: std::option::Option<crate::model::SpotMarketOptions>,
}
impl InstanceMarketOptionsRequest {
    /// <p>The market type.</p>
    pub fn market_type(&self) -> std::option::Option<&crate::model::MarketType> {
        self.market_type.as_ref()
    }
    /// <p>The options for Spot Instances.</p>
    pub fn spot_options(&self) -> std::option::Option<&crate::model::SpotMarketOptions> {
        self.spot_options.as_ref()
    }
}
impl std::fmt::Debug for InstanceMarketOptionsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMarketOptionsRequest");
        formatter.field("market_type", &self.market_type);
        formatter.field("spot_options", &self.spot_options);
        formatter.finish()
    }
}
/// See [`InstanceMarketOptionsRequest`](crate::model::InstanceMarketOptionsRequest)
pub mod instance_market_options_request {
    /// A builder for [`InstanceMarketOptionsRequest`](crate::model::InstanceMarketOptionsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) market_type: std::option::Option<crate::model::MarketType>,
        pub(crate) spot_options: std::option::Option<crate::model::SpotMarketOptions>,
    }
    impl Builder {
        /// <p>The market type.</p>
        pub fn market_type(mut self, input: crate::model::MarketType) -> Self {
            self.market_type = Some(input);
            self
        }
        /// <p>The market type.</p>
        pub fn set_market_type(
            mut self,
            input: std::option::Option<crate::model::MarketType>,
        ) -> Self {
            self.market_type = input;
            self
        }
        /// <p>The options for Spot Instances.</p>
        pub fn spot_options(mut self, input: crate::model::SpotMarketOptions) -> Self {
            self.spot_options = Some(input);
            self
        }
        /// <p>The options for Spot Instances.</p>
        pub fn set_spot_options(
            mut self,
            input: std::option::Option<crate::model::SpotMarketOptions>,
        ) -> Self {
            self.spot_options = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMarketOptionsRequest`](crate::model::InstanceMarketOptionsRequest)
        pub fn build(self) -> crate::model::InstanceMarketOptionsRequest {
            crate::model::InstanceMarketOptionsRequest {
                market_type: self.market_type,
                spot_options: self.spot_options,
            }
        }
    }
}
impl InstanceMarketOptionsRequest {
    /// Creates a new builder-style object to manufacture [`InstanceMarketOptionsRequest`](crate::model::InstanceMarketOptionsRequest)
    pub fn builder() -> crate::model::instance_market_options_request::Builder {
        crate::model::instance_market_options_request::Builder::default()
    }
}

/// <p>The options for Spot Instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotMarketOptions {
    /// <p>The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.</p>
    pub max_price: std::option::Option<std::string::String>,
    /// <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or <code>stop</code>.</p>
    pub spot_instance_type: std::option::Option<crate::model::SpotInstanceType>,
    /// <p>Deprecated.</p>
    pub block_duration_minutes: std::option::Option<i32>,
    /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent requests.</p>
    /// <ul>
    /// <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li>
    /// <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li>
    /// </ul>
    pub valid_until: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
    pub instance_interruption_behavior:
        std::option::Option<crate::model::InstanceInterruptionBehavior>,
}
impl SpotMarketOptions {
    /// <p>The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.</p>
    pub fn max_price(&self) -> std::option::Option<&str> {
        self.max_price.as_deref()
    }
    /// <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or <code>stop</code>.</p>
    pub fn spot_instance_type(&self) -> std::option::Option<&crate::model::SpotInstanceType> {
        self.spot_instance_type.as_ref()
    }
    /// <p>Deprecated.</p>
    pub fn block_duration_minutes(&self) -> std::option::Option<i32> {
        self.block_duration_minutes
    }
    /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent requests.</p>
    /// <ul>
    /// <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li>
    /// <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li>
    /// </ul>
    pub fn valid_until(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_until.as_ref()
    }
    /// <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
    pub fn instance_interruption_behavior(
        &self,
    ) -> std::option::Option<&crate::model::InstanceInterruptionBehavior> {
        self.instance_interruption_behavior.as_ref()
    }
}
impl std::fmt::Debug for SpotMarketOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotMarketOptions");
        formatter.field("max_price", &self.max_price);
        formatter.field("spot_instance_type", &self.spot_instance_type);
        formatter.field("block_duration_minutes", &self.block_duration_minutes);
        formatter.field("valid_until", &self.valid_until);
        formatter.field(
            "instance_interruption_behavior",
            &self.instance_interruption_behavior,
        );
        formatter.finish()
    }
}
/// See [`SpotMarketOptions`](crate::model::SpotMarketOptions)
pub mod spot_market_options {
    /// A builder for [`SpotMarketOptions`](crate::model::SpotMarketOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_price: std::option::Option<std::string::String>,
        pub(crate) spot_instance_type: std::option::Option<crate::model::SpotInstanceType>,
        pub(crate) block_duration_minutes: std::option::Option<i32>,
        pub(crate) valid_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) instance_interruption_behavior:
            std::option::Option<crate::model::InstanceInterruptionBehavior>,
    }
    impl Builder {
        /// <p>The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.</p>
        pub fn max_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_price = Some(input.into());
            self
        }
        /// <p>The maximum hourly price you're willing to pay for the Spot Instances. The default is the On-Demand price.</p>
        pub fn set_max_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_price = input;
            self
        }
        /// <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or <code>stop</code>.</p>
        pub fn spot_instance_type(mut self, input: crate::model::SpotInstanceType) -> Self {
            self.spot_instance_type = Some(input);
            self
        }
        /// <p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot Instance requests are only supported when the instance interruption behavior is either <code>hibernate</code> or <code>stop</code>.</p>
        pub fn set_spot_instance_type(
            mut self,
            input: std::option::Option<crate::model::SpotInstanceType>,
        ) -> Self {
            self.spot_instance_type = input;
            self
        }
        /// <p>Deprecated.</p>
        pub fn block_duration_minutes(mut self, input: i32) -> Self {
            self.block_duration_minutes = Some(input);
            self
        }
        /// <p>Deprecated.</p>
        pub fn set_block_duration_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.block_duration_minutes = input;
            self
        }
        /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent requests.</p>
        /// <ul>
        /// <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li>
        /// <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li>
        /// </ul>
        pub fn valid_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_until = Some(input);
            self
        }
        /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). Supported only for persistent requests.</p>
        /// <ul>
        /// <li> <p>For a persistent request, the request remains active until the <code>ValidUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it.</p> </li>
        /// <li> <p>For a one-time request, <code>ValidUntil</code> is not supported. The request remains active until all instances launch or you cancel the request.</p> </li>
        /// </ul>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_until = input;
            self
        }
        /// <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
        pub fn instance_interruption_behavior(
            mut self,
            input: crate::model::InstanceInterruptionBehavior,
        ) -> Self {
            self.instance_interruption_behavior = Some(input);
            self
        }
        /// <p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>
        pub fn set_instance_interruption_behavior(
            mut self,
            input: std::option::Option<crate::model::InstanceInterruptionBehavior>,
        ) -> Self {
            self.instance_interruption_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotMarketOptions`](crate::model::SpotMarketOptions)
        pub fn build(self) -> crate::model::SpotMarketOptions {
            crate::model::SpotMarketOptions {
                max_price: self.max_price,
                spot_instance_type: self.spot_instance_type,
                block_duration_minutes: self.block_duration_minutes,
                valid_until: self.valid_until,
                instance_interruption_behavior: self.instance_interruption_behavior,
            }
        }
    }
}
impl SpotMarketOptions {
    /// Creates a new builder-style object to manufacture [`SpotMarketOptions`](crate::model::SpotMarketOptions)
    pub fn builder() -> crate::model::spot_market_options::Builder {
        crate::model::spot_market_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceInterruptionBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Hibernate,
    #[allow(missing_docs)] // documentation missing in model
    Stop,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceInterruptionBehavior {
    fn from(s: &str) -> Self {
        match s {
            "hibernate" => InstanceInterruptionBehavior::Hibernate,
            "stop" => InstanceInterruptionBehavior::Stop,
            "terminate" => InstanceInterruptionBehavior::Terminate,
            other => InstanceInterruptionBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceInterruptionBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceInterruptionBehavior::from(s))
    }
}
impl InstanceInterruptionBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceInterruptionBehavior::Hibernate => "hibernate",
            InstanceInterruptionBehavior::Stop => "stop",
            InstanceInterruptionBehavior::Terminate => "terminate",
            InstanceInterruptionBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["hibernate", "stop", "terminate"]
    }
}
impl AsRef<str> for InstanceInterruptionBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpotInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    OneTime,
    #[allow(missing_docs)] // documentation missing in model
    Persistent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpotInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "one-time" => SpotInstanceType::OneTime,
            "persistent" => SpotInstanceType::Persistent,
            other => SpotInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpotInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpotInstanceType::from(s))
    }
}
impl SpotInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpotInstanceType::OneTime => "one-time",
            SpotInstanceType::Persistent => "persistent",
            SpotInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["one-time", "persistent"]
    }
}
impl AsRef<str> for SpotInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MarketType {
    #[allow(missing_docs)] // documentation missing in model
    Spot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MarketType {
    fn from(s: &str) -> Self {
        match s {
            "spot" => MarketType::Spot,
            other => MarketType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MarketType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MarketType::from(s))
    }
}
impl MarketType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MarketType::Spot => "spot",
            MarketType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["spot"]
    }
}
impl AsRef<str> for MarketType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The launch template to use. You must specify either the launch template ID or launch template name in the request, but not both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateSpecification {
    /// <p>The ID of the launch template.</p>
    pub launch_template_id: std::option::Option<std::string::String>,
    /// <p>The name of the launch template.</p>
    pub launch_template_name: std::option::Option<std::string::String>,
    /// <p>The version number of the launch template.</p>
    /// <p>Default: The default version for the launch template.</p>
    pub version: std::option::Option<std::string::String>,
}
impl LaunchTemplateSpecification {
    /// <p>The ID of the launch template.</p>
    pub fn launch_template_id(&self) -> std::option::Option<&str> {
        self.launch_template_id.as_deref()
    }
    /// <p>The name of the launch template.</p>
    pub fn launch_template_name(&self) -> std::option::Option<&str> {
        self.launch_template_name.as_deref()
    }
    /// <p>The version number of the launch template.</p>
    /// <p>Default: The default version for the launch template.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for LaunchTemplateSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateSpecification");
        formatter.field("launch_template_id", &self.launch_template_id);
        formatter.field("launch_template_name", &self.launch_template_name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
pub mod launch_template_specification {
    /// A builder for [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the launch template.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the launch template.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_id = input;
            self
        }
        /// <p>The name of the launch template.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_name = Some(input.into());
            self
        }
        /// <p>The name of the launch template.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_name = input;
            self
        }
        /// <p>The version number of the launch template.</p>
        /// <p>Default: The default version for the launch template.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number of the launch template.</p>
        /// <p>Default: The default version for the launch template.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
        pub fn build(self) -> crate::model::LaunchTemplateSpecification {
            crate::model::LaunchTemplateSpecification {
                launch_template_id: self.launch_template_id,
                launch_template_name: self.launch_template_name,
                version: self.version,
            }
        }
    }
}
impl LaunchTemplateSpecification {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    pub fn builder() -> crate::model::launch_template_specification::Builder {
        crate::model::launch_template_specification::Builder::default()
    }
}

/// <p> Describes an elastic inference accelerator. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticInferenceAccelerator {
    /// <p> The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>. </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p> The number of elastic inference accelerators to attach to the instance. </p>
    /// <p>Default: 1</p>
    pub count: std::option::Option<i32>,
}
impl ElasticInferenceAccelerator {
    /// <p> The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p> The number of elastic inference accelerators to attach to the instance. </p>
    /// <p>Default: 1</p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
}
impl std::fmt::Debug for ElasticInferenceAccelerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticInferenceAccelerator");
        formatter.field("r#type", &self.r#type);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`ElasticInferenceAccelerator`](crate::model::ElasticInferenceAccelerator)
pub mod elastic_inference_accelerator {
    /// A builder for [`ElasticInferenceAccelerator`](crate::model::ElasticInferenceAccelerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>. </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p> The type of elastic inference accelerator. The possible values are <code>eia1.medium</code>, <code>eia1.large</code>, <code>eia1.xlarge</code>, <code>eia2.medium</code>, <code>eia2.large</code>, and <code>eia2.xlarge</code>. </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The number of elastic inference accelerators to attach to the instance. </p>
        /// <p>Default: 1</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p> The number of elastic inference accelerators to attach to the instance. </p>
        /// <p>Default: 1</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticInferenceAccelerator`](crate::model::ElasticInferenceAccelerator)
        pub fn build(self) -> crate::model::ElasticInferenceAccelerator {
            crate::model::ElasticInferenceAccelerator {
                r#type: self.r#type,
                count: self.count,
            }
        }
    }
}
impl ElasticInferenceAccelerator {
    /// Creates a new builder-style object to manufacture [`ElasticInferenceAccelerator`](crate::model::ElasticInferenceAccelerator)
    pub fn builder() -> crate::model::elastic_inference_accelerator::Builder {
        crate::model::elastic_inference_accelerator::Builder::default()
    }
}

/// <p>A specification for an Elastic Graphics accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticGpuSpecification {
    /// <p>The type of Elastic Graphics accelerator. For more information about the values to specify for <code>Type</code>, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a>, specifically the Elastic Graphics accelerator column, in the <i>Amazon Elastic Compute Cloud User Guide for Windows Instances</i>.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl ElasticGpuSpecification {
    /// <p>The type of Elastic Graphics accelerator. For more information about the values to specify for <code>Type</code>, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a>, specifically the Elastic Graphics accelerator column, in the <i>Amazon Elastic Compute Cloud User Guide for Windows Instances</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ElasticGpuSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticGpuSpecification");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ElasticGpuSpecification`](crate::model::ElasticGpuSpecification)
pub mod elastic_gpu_specification {
    /// A builder for [`ElasticGpuSpecification`](crate::model::ElasticGpuSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of Elastic Graphics accelerator. For more information about the values to specify for <code>Type</code>, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a>, specifically the Elastic Graphics accelerator column, in the <i>Amazon Elastic Compute Cloud User Guide for Windows Instances</i>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of Elastic Graphics accelerator. For more information about the values to specify for <code>Type</code>, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html#elastic-graphics-basics">Elastic Graphics Basics</a>, specifically the Elastic Graphics accelerator column, in the <i>Amazon Elastic Compute Cloud User Guide for Windows Instances</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticGpuSpecification`](crate::model::ElasticGpuSpecification)
        pub fn build(self) -> crate::model::ElasticGpuSpecification {
            crate::model::ElasticGpuSpecification {
                r#type: self.r#type,
            }
        }
    }
}
impl ElasticGpuSpecification {
    /// Creates a new builder-style object to manufacture [`ElasticGpuSpecification`](crate::model::ElasticGpuSpecification)
    pub fn builder() -> crate::model::elastic_gpu_specification::Builder {
        crate::model::elastic_gpu_specification::Builder::default()
    }
}

/// <p>Describes a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNetworkInterfaceSpecification {
    /// <p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The position of the network interface in the attachment order. A primary network interface has a device index of 0.</p>
    /// <p>If you specify a network interface when launching an instance, you must specify the device index.</p>
    pub device_index: std::option::Option<i32>,
    /// <p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.</p>
    pub ipv6_address_count: std::option::Option<i32>,
    /// <p>One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.</p>
    pub ipv6_addresses: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
    /// <p>The ID of the network interface.</p>
    /// <p>If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub private_ip_addresses:
        std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
    /// <p>The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub secondary_private_ip_address_count: std::option::Option<i32>,
    /// <p>The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether to assign a carrier IP address to the network interface.</p>
    /// <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.</p>
    pub associate_carrier_ip_address: std::option::Option<bool>,
    /// <p>The type of network interface.</p>
    /// <p>Valid values: <code>interface</code> | <code>efa</code> </p>
    pub interface_type: std::option::Option<std::string::String>,
    /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
    /// <p>If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a> to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>
    pub network_card_index: std::option::Option<i32>,
    /// <p>One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
    pub ipv4_prefixes:
        std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
    /// <p>The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv4Prefix</code> option.</p>
    pub ipv4_prefix_count: std::option::Option<i32>,
    /// <p>One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
    pub ipv6_prefixes:
        std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
    /// <p>The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv6Prefix</code> option.</p>
    pub ipv6_prefix_count: std::option::Option<i32>,
}
impl InstanceNetworkInterfaceSpecification {
    /// <p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
    pub fn associate_public_ip_address(&self) -> std::option::Option<bool> {
        self.associate_public_ip_address
    }
    /// <p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The position of the network interface in the attachment order. A primary network interface has a device index of 0.</p>
    /// <p>If you specify a network interface when launching an instance, you must specify the device index.</p>
    pub fn device_index(&self) -> std::option::Option<i32> {
        self.device_index
    }
    /// <p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
    /// <p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.</p>
    pub fn ipv6_address_count(&self) -> std::option::Option<i32> {
        self.ipv6_address_count
    }
    /// <p>One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.</p>
    pub fn ipv6_addresses(&self) -> std::option::Option<&[crate::model::InstanceIpv6Address]> {
        self.ipv6_addresses.as_deref()
    }
    /// <p>The ID of the network interface.</p>
    /// <p>If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub fn private_ip_addresses(
        &self,
    ) -> std::option::Option<&[crate::model::PrivateIpAddressSpecification]> {
        self.private_ip_addresses.as_deref()
    }
    /// <p>The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
    pub fn secondary_private_ip_address_count(&self) -> std::option::Option<i32> {
        self.secondary_private_ip_address_count
    }
    /// <p>The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>Indicates whether to assign a carrier IP address to the network interface.</p>
    /// <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.</p>
    pub fn associate_carrier_ip_address(&self) -> std::option::Option<bool> {
        self.associate_carrier_ip_address
    }
    /// <p>The type of network interface.</p>
    /// <p>Valid values: <code>interface</code> | <code>efa</code> </p>
    pub fn interface_type(&self) -> std::option::Option<&str> {
        self.interface_type.as_deref()
    }
    /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
    /// <p>If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a> to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>
    pub fn network_card_index(&self) -> std::option::Option<i32> {
        self.network_card_index
    }
    /// <p>One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
    pub fn ipv4_prefixes(
        &self,
    ) -> std::option::Option<&[crate::model::Ipv4PrefixSpecificationRequest]> {
        self.ipv4_prefixes.as_deref()
    }
    /// <p>The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv4Prefix</code> option.</p>
    pub fn ipv4_prefix_count(&self) -> std::option::Option<i32> {
        self.ipv4_prefix_count
    }
    /// <p>One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
    pub fn ipv6_prefixes(
        &self,
    ) -> std::option::Option<&[crate::model::Ipv6PrefixSpecificationRequest]> {
        self.ipv6_prefixes.as_deref()
    }
    /// <p>The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv6Prefix</code> option.</p>
    pub fn ipv6_prefix_count(&self) -> std::option::Option<i32> {
        self.ipv6_prefix_count
    }
}
impl std::fmt::Debug for InstanceNetworkInterfaceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNetworkInterfaceSpecification");
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("description", &self.description);
        formatter.field("device_index", &self.device_index);
        formatter.field("groups", &self.groups);
        formatter.field("ipv6_address_count", &self.ipv6_address_count);
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("private_ip_addresses", &self.private_ip_addresses);
        formatter.field(
            "secondary_private_ip_address_count",
            &self.secondary_private_ip_address_count,
        );
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field(
            "associate_carrier_ip_address",
            &self.associate_carrier_ip_address,
        );
        formatter.field("interface_type", &self.interface_type);
        formatter.field("network_card_index", &self.network_card_index);
        formatter.field("ipv4_prefixes", &self.ipv4_prefixes);
        formatter.field("ipv4_prefix_count", &self.ipv4_prefix_count);
        formatter.field("ipv6_prefixes", &self.ipv6_prefixes);
        formatter.field("ipv6_prefix_count", &self.ipv6_prefix_count);
        formatter.finish()
    }
}
/// See [`InstanceNetworkInterfaceSpecification`](crate::model::InstanceNetworkInterfaceSpecification)
pub mod instance_network_interface_specification {
    /// A builder for [`InstanceNetworkInterfaceSpecification`](crate::model::InstanceNetworkInterfaceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) device_index: std::option::Option<i32>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_address_count: std::option::Option<i32>,
        pub(crate) ipv6_addresses:
            std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
        pub(crate) secondary_private_ip_address_count: std::option::Option<i32>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) associate_carrier_ip_address: std::option::Option<bool>,
        pub(crate) interface_type: std::option::Option<std::string::String>,
        pub(crate) network_card_index: std::option::Option<i32>,
        pub(crate) ipv4_prefixes:
            std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
        pub(crate) ipv4_prefix_count: std::option::Option<i32>,
        pub(crate) ipv6_prefixes:
            std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
        pub(crate) ipv6_prefix_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The position of the network interface in the attachment order. A primary network interface has a device index of 0.</p>
        /// <p>If you specify a network interface when launching an instance, you must specify the device index.</p>
        pub fn device_index(mut self, input: i32) -> Self {
            self.device_index = Some(input);
            self
        }
        /// <p>The position of the network interface in the attachment order. A primary network interface has a device index of 0.</p>
        /// <p>If you specify a network interface when launching an instance, you must specify the device index.</p>
        pub fn set_device_index(mut self, input: std::option::Option<i32>) -> Self {
            self.device_index = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.ipv6_address_count = Some(input);
            self
        }
        /// <p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number of instances to launch.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_address_count = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.</p>
        pub fn ipv6_addresses(mut self, input: crate::model::InstanceIpv6Address) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input);
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you've specified a minimum number of instances to launch.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        /// <p>If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        /// <p>If you are creating a Spot Fleet, omit this parameter because you can’t specify a network interface ID in a launch specification.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 address of the network interface. Applies only if creating a network interface when launching an instance. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn private_ip_addresses(
            mut self,
            input: crate::model::PrivateIpAddressSpecification,
        ) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input);
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.secondary_private_ip_address_count = Some(input);
            self
        }
        /// <p>The number of secondary private IPv4 addresses. You can't specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you're launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.secondary_private_ip_address_count = input;
            self
        }
        /// <p>The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet associated with the network interface. Applies only if creating a network interface when launching an instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Indicates whether to assign a carrier IP address to the network interface.</p>
        /// <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.</p>
        pub fn associate_carrier_ip_address(mut self, input: bool) -> Self {
            self.associate_carrier_ip_address = Some(input);
            self
        }
        /// <p>Indicates whether to assign a carrier IP address to the network interface.</p>
        /// <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see Carrier IP addresses in the Amazon Web Services Wavelength Developer Guide.</p>
        pub fn set_associate_carrier_ip_address(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.associate_carrier_ip_address = input;
            self
        }
        /// <p>The type of network interface.</p>
        /// <p>Valid values: <code>interface</code> | <code>efa</code> </p>
        pub fn interface_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.interface_type = Some(input.into());
            self
        }
        /// <p>The type of network interface.</p>
        /// <p>Valid values: <code>interface</code> | <code>efa</code> </p>
        pub fn set_interface_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interface_type = input;
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        /// <p>If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a> to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>
        pub fn network_card_index(mut self, input: i32) -> Self {
            self.network_card_index = Some(input);
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        /// <p>If you are using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a> to create Spot Instances, omit this parameter because you can’t specify the network card index when using this API. To specify the network card index, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>.</p>
        pub fn set_network_card_index(mut self, input: std::option::Option<i32>) -> Self {
            self.network_card_index = input;
            self
        }
        /// Appends an item to `ipv4_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn ipv4_prefixes(
            mut self,
            input: crate::model::Ipv4PrefixSpecificationRequest,
        ) -> Self {
            let mut v = self.ipv4_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv4_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv4 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
        ) -> Self {
            self.ipv4_prefixes = input;
            self
        }
        /// <p>The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv4Prefix</code> option.</p>
        pub fn ipv4_prefix_count(mut self, input: i32) -> Self {
            self.ipv4_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv4 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv4Prefix</code> option.</p>
        pub fn set_ipv4_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv4_prefix_count = input;
            self
        }
        /// Appends an item to `ipv6_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn ipv6_prefixes(
            mut self,
            input: crate::model::Ipv6PrefixSpecificationRequest,
        ) -> Self {
            let mut v = self.ipv6_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv6_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv6 delegated prefixes to be assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
        ) -> Self {
            self.ipv6_prefixes = input;
            self
        }
        /// <p>The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv6Prefix</code> option.</p>
        pub fn ipv6_prefix_count(mut self, input: i32) -> Self {
            self.ipv6_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv6 delegated prefixes to be automatically assigned to the network interface. You cannot use this option if you use the <code>Ipv6Prefix</code> option.</p>
        pub fn set_ipv6_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_prefix_count = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNetworkInterfaceSpecification`](crate::model::InstanceNetworkInterfaceSpecification)
        pub fn build(self) -> crate::model::InstanceNetworkInterfaceSpecification {
            crate::model::InstanceNetworkInterfaceSpecification {
                associate_public_ip_address: self.associate_public_ip_address,
                delete_on_termination: self.delete_on_termination,
                description: self.description,
                device_index: self.device_index,
                groups: self.groups,
                ipv6_address_count: self.ipv6_address_count,
                ipv6_addresses: self.ipv6_addresses,
                network_interface_id: self.network_interface_id,
                private_ip_address: self.private_ip_address,
                private_ip_addresses: self.private_ip_addresses,
                secondary_private_ip_address_count: self.secondary_private_ip_address_count,
                subnet_id: self.subnet_id,
                associate_carrier_ip_address: self.associate_carrier_ip_address,
                interface_type: self.interface_type,
                network_card_index: self.network_card_index,
                ipv4_prefixes: self.ipv4_prefixes,
                ipv4_prefix_count: self.ipv4_prefix_count,
                ipv6_prefixes: self.ipv6_prefixes,
                ipv6_prefix_count: self.ipv6_prefix_count,
            }
        }
    }
}
impl InstanceNetworkInterfaceSpecification {
    /// Creates a new builder-style object to manufacture [`InstanceNetworkInterfaceSpecification`](crate::model::InstanceNetworkInterfaceSpecification)
    pub fn builder() -> crate::model::instance_network_interface_specification::Builder {
        crate::model::instance_network_interface_specification::Builder::default()
    }
}

/// <p>Describes the IPv4 prefix option for a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ipv6PrefixSpecificationRequest {
    /// <p>The IPv6 prefix.</p>
    pub ipv6_prefix: std::option::Option<std::string::String>,
}
impl Ipv6PrefixSpecificationRequest {
    /// <p>The IPv6 prefix.</p>
    pub fn ipv6_prefix(&self) -> std::option::Option<&str> {
        self.ipv6_prefix.as_deref()
    }
}
impl std::fmt::Debug for Ipv6PrefixSpecificationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ipv6PrefixSpecificationRequest");
        formatter.field("ipv6_prefix", &self.ipv6_prefix);
        formatter.finish()
    }
}
/// See [`Ipv6PrefixSpecificationRequest`](crate::model::Ipv6PrefixSpecificationRequest)
pub mod ipv6_prefix_specification_request {
    /// A builder for [`Ipv6PrefixSpecificationRequest`](crate::model::Ipv6PrefixSpecificationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv6 prefix.</p>
        pub fn ipv6_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_prefix = Some(input.into());
            self
        }
        /// <p>The IPv6 prefix.</p>
        pub fn set_ipv6_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`Ipv6PrefixSpecificationRequest`](crate::model::Ipv6PrefixSpecificationRequest)
        pub fn build(self) -> crate::model::Ipv6PrefixSpecificationRequest {
            crate::model::Ipv6PrefixSpecificationRequest {
                ipv6_prefix: self.ipv6_prefix,
            }
        }
    }
}
impl Ipv6PrefixSpecificationRequest {
    /// Creates a new builder-style object to manufacture [`Ipv6PrefixSpecificationRequest`](crate::model::Ipv6PrefixSpecificationRequest)
    pub fn builder() -> crate::model::ipv6_prefix_specification_request::Builder {
        crate::model::ipv6_prefix_specification_request::Builder::default()
    }
}

/// <p>Describes the IPv4 prefix option for a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ipv4PrefixSpecificationRequest {
    /// <p>The IPv4 prefix. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub ipv4_prefix: std::option::Option<std::string::String>,
}
impl Ipv4PrefixSpecificationRequest {
    /// <p>The IPv4 prefix. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub fn ipv4_prefix(&self) -> std::option::Option<&str> {
        self.ipv4_prefix.as_deref()
    }
}
impl std::fmt::Debug for Ipv4PrefixSpecificationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ipv4PrefixSpecificationRequest");
        formatter.field("ipv4_prefix", &self.ipv4_prefix);
        formatter.finish()
    }
}
/// See [`Ipv4PrefixSpecificationRequest`](crate::model::Ipv4PrefixSpecificationRequest)
pub mod ipv4_prefix_specification_request {
    /// A builder for [`Ipv4PrefixSpecificationRequest`](crate::model::Ipv4PrefixSpecificationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv4_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv4 prefix. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn ipv4_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_prefix = Some(input.into());
            self
        }
        /// <p>The IPv4 prefix. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_ipv4_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv4_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`Ipv4PrefixSpecificationRequest`](crate::model::Ipv4PrefixSpecificationRequest)
        pub fn build(self) -> crate::model::Ipv4PrefixSpecificationRequest {
            crate::model::Ipv4PrefixSpecificationRequest {
                ipv4_prefix: self.ipv4_prefix,
            }
        }
    }
}
impl Ipv4PrefixSpecificationRequest {
    /// Creates a new builder-style object to manufacture [`Ipv4PrefixSpecificationRequest`](crate::model::Ipv4PrefixSpecificationRequest)
    pub fn builder() -> crate::model::ipv4_prefix_specification_request::Builder {
        crate::model::ipv4_prefix_specification_request::Builder::default()
    }
}

/// <p>Describes a secondary private IPv4 address for a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateIpAddressSpecification {
    /// <p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>
    pub primary: std::option::Option<bool>,
    /// <p>The private IPv4 addresses.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
}
impl PrivateIpAddressSpecification {
    /// <p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>
    pub fn primary(&self) -> std::option::Option<bool> {
        self.primary
    }
    /// <p>The private IPv4 addresses.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
}
impl std::fmt::Debug for PrivateIpAddressSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateIpAddressSpecification");
        formatter.field("primary", &self.primary);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.finish()
    }
}
/// See [`PrivateIpAddressSpecification`](crate::model::PrivateIpAddressSpecification)
pub mod private_ip_address_specification {
    /// A builder for [`PrivateIpAddressSpecification`](crate::model::PrivateIpAddressSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary: std::option::Option<bool>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>
        pub fn primary(mut self, input: bool) -> Self {
            self.primary = Some(input);
            self
        }
        /// <p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>
        pub fn set_primary(mut self, input: std::option::Option<bool>) -> Self {
            self.primary = input;
            self
        }
        /// <p>The private IPv4 addresses.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 addresses.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateIpAddressSpecification`](crate::model::PrivateIpAddressSpecification)
        pub fn build(self) -> crate::model::PrivateIpAddressSpecification {
            crate::model::PrivateIpAddressSpecification {
                primary: self.primary,
                private_ip_address: self.private_ip_address,
            }
        }
    }
}
impl PrivateIpAddressSpecification {
    /// Creates a new builder-style object to manufacture [`PrivateIpAddressSpecification`](crate::model::PrivateIpAddressSpecification)
    pub fn builder() -> crate::model::private_ip_address_specification::Builder {
        crate::model::private_ip_address_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShutdownBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Stop,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShutdownBehavior {
    fn from(s: &str) -> Self {
        match s {
            "stop" => ShutdownBehavior::Stop,
            "terminate" => ShutdownBehavior::Terminate,
            other => ShutdownBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShutdownBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShutdownBehavior::from(s))
    }
}
impl ShutdownBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShutdownBehavior::Stop => "stop",
            ShutdownBehavior::Terminate => "terminate",
            ShutdownBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["stop", "terminate"]
    }
}
impl AsRef<str> for ShutdownBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an IAM instance profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamInstanceProfileSpecification {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the instance profile.</p>
    pub name: std::option::Option<std::string::String>,
}
impl IamInstanceProfileSpecification {
    /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the instance profile.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for IamInstanceProfileSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamInstanceProfileSpecification");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`IamInstanceProfileSpecification`](crate::model::IamInstanceProfileSpecification)
pub mod iam_instance_profile_specification {
    /// A builder for [`IamInstanceProfileSpecification`](crate::model::IamInstanceProfileSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance profile.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the instance profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`IamInstanceProfileSpecification`](crate::model::IamInstanceProfileSpecification)
        pub fn build(self) -> crate::model::IamInstanceProfileSpecification {
            crate::model::IamInstanceProfileSpecification {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl IamInstanceProfileSpecification {
    /// Creates a new builder-style object to manufacture [`IamInstanceProfileSpecification`](crate::model::IamInstanceProfileSpecification)
    pub fn builder() -> crate::model::iam_instance_profile_specification::Builder {
        crate::model::iam_instance_profile_specification::Builder::default()
    }
}

/// <p>Describes the monitoring of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunInstancesMonitoringEnabled {
    /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
    pub enabled: std::option::Option<bool>,
}
impl RunInstancesMonitoringEnabled {
    /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for RunInstancesMonitoringEnabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunInstancesMonitoringEnabled");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`RunInstancesMonitoringEnabled`](crate::model::RunInstancesMonitoringEnabled)
pub mod run_instances_monitoring_enabled {
    /// A builder for [`RunInstancesMonitoringEnabled`](crate::model::RunInstancesMonitoringEnabled)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`RunInstancesMonitoringEnabled`](crate::model::RunInstancesMonitoringEnabled)
        pub fn build(self) -> crate::model::RunInstancesMonitoringEnabled {
            crate::model::RunInstancesMonitoringEnabled {
                enabled: self.enabled,
            }
        }
    }
}
impl RunInstancesMonitoringEnabled {
    /// Creates a new builder-style object to manufacture [`RunInstancesMonitoringEnabled`](crate::model::RunInstancesMonitoringEnabled)
    pub fn builder() -> crate::model::run_instances_monitoring_enabled::Builder {
        crate::model::run_instances_monitoring_enabled::Builder::default()
    }
}

/// <p>Describes a block device mapping, which defines the EBS volumes and instance store volumes to attach to an instance at launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
    /// <p>NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.</p>
    /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
    pub virtual_name: std::option::Option<std::string::String>,
    /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
    pub ebs: std::option::Option<crate::model::EbsBlockDevice>,
    /// <p>To omit the device from the block device mapping, specify an empty string. When this property is specified, the device is removed from the block device mapping regardless of the assigned value.</p>
    pub no_device: std::option::Option<std::string::String>,
}
impl BlockDeviceMapping {
    /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
    /// <p>NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.</p>
    /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
    pub fn virtual_name(&self) -> std::option::Option<&str> {
        self.virtual_name.as_deref()
    }
    /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::EbsBlockDevice> {
        self.ebs.as_ref()
    }
    /// <p>To omit the device from the block device mapping, specify an empty string. When this property is specified, the device is removed from the block device mapping regardless of the assigned value.</p>
    pub fn no_device(&self) -> std::option::Option<&str> {
        self.no_device.as_deref()
    }
}
impl std::fmt::Debug for BlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("virtual_name", &self.virtual_name);
        formatter.field("ebs", &self.ebs);
        formatter.field("no_device", &self.no_device);
        formatter.finish()
    }
}
/// See [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
pub mod block_device_mapping {
    /// A builder for [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) virtual_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::EbsBlockDevice>,
        pub(crate) no_device: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
        /// <p>NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.</p>
        /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you connect to the instance, you must mount the volume.</p>
        /// <p>NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block device mapping has no effect.</p>
        /// <p>Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device mapping for the AMI.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
        pub fn ebs(mut self, input: crate::model::EbsBlockDevice) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>
        pub fn set_ebs(mut self, input: std::option::Option<crate::model::EbsBlockDevice>) -> Self {
            self.ebs = input;
            self
        }
        /// <p>To omit the device from the block device mapping, specify an empty string. When this property is specified, the device is removed from the block device mapping regardless of the assigned value.</p>
        pub fn no_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.no_device = Some(input.into());
            self
        }
        /// <p>To omit the device from the block device mapping, specify an empty string. When this property is specified, the device is removed from the block device mapping regardless of the assigned value.</p>
        pub fn set_no_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.no_device = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
        pub fn build(self) -> crate::model::BlockDeviceMapping {
            crate::model::BlockDeviceMapping {
                device_name: self.device_name,
                virtual_name: self.virtual_name,
                ebs: self.ebs,
                no_device: self.no_device,
            }
        }
    }
}
impl BlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    pub fn builder() -> crate::model::block_device_mapping::Builder {
        crate::model::block_device_mapping::Builder::default()
    }
}

/// <p>Describes a block device for an EBS volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsBlockDevice {
    /// <p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
    /// <p>The following are the supported values for each volume type:</p>
    /// <ul>
    /// <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li>
    /// <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li>
    /// <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li>
    /// </ul>
    /// <p>For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.</p>
    /// <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p>
    /// <p>The following are the supported volumes sizes for each volume type:</p>
    /// <ul>
    /// <li> <p> <code>gp2</code> and <code>gp3</code>:1-16,384</p> </li>
    /// <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li>
    /// <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li>
    /// <li> <p> <code>standard</code>: 1-1,024</p> </li>
    /// </ul>
    pub volume_size: std::option::Option<i32>,
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>. If the volume type is <code>io1</code> or <code>io2</code>, you must specify the IOPS that the volume supports.</p>
    pub volume_type: std::option::Option<crate::model::VolumeType>,
    /// <p>Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.</p>
    /// <p>This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html">RequestSpotFleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The throughput that the volume supports, in MiB/s.</p>
    /// <p>This parameter is valid only for <code>gp3</code> volumes.</p>
    /// <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
    pub throughput: std::option::Option<i32>,
    /// <p>The ARN of the Outpost on which the snapshot is stored.</p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS encryption</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p>In no case can you remove encryption from an encrypted volume.</p>
    /// <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
    /// <p>This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a>.</p>
    pub encrypted: std::option::Option<bool>,
}
impl EbsBlockDevice {
    /// <p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <i>Amazon EC2 User Guide</i>.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
    /// <p>The following are the supported values for each volume type:</p>
    /// <ul>
    /// <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li>
    /// <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li>
    /// <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li>
    /// </ul>
    /// <p>For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.</p>
    /// <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>The ID of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p>
    /// <p>The following are the supported volumes sizes for each volume type:</p>
    /// <ul>
    /// <li> <p> <code>gp2</code> and <code>gp3</code>:1-16,384</p> </li>
    /// <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li>
    /// <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li>
    /// <li> <p> <code>standard</code>: 1-1,024</p> </li>
    /// </ul>
    pub fn volume_size(&self) -> std::option::Option<i32> {
        self.volume_size
    }
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>. If the volume type is <code>io1</code> or <code>io2</code>, you must specify the IOPS that the volume supports.</p>
    pub fn volume_type(&self) -> std::option::Option<&crate::model::VolumeType> {
        self.volume_type.as_ref()
    }
    /// <p>Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.</p>
    /// <p>This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html">RequestSpotFleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The throughput that the volume supports, in MiB/s.</p>
    /// <p>This parameter is valid only for <code>gp3</code> volumes.</p>
    /// <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
    pub fn throughput(&self) -> std::option::Option<i32> {
        self.throughput
    }
    /// <p>The ARN of the Outpost on which the snapshot is stored.</p>
    pub fn outpost_arn(&self) -> std::option::Option<&str> {
        self.outpost_arn.as_deref()
    }
    /// <p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS encryption</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p>In no case can you remove encryption from an encrypted volume.</p>
    /// <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
    /// <p>This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a>.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
}
impl std::fmt::Debug for EbsBlockDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsBlockDevice");
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("iops", &self.iops);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("throughput", &self.throughput);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("encrypted", &self.encrypted);
        formatter.finish()
    }
}
/// See [`EbsBlockDevice`](crate::model::EbsBlockDevice)
pub mod ebs_block_device {
    /// A builder for [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<crate::model::VolumeType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) throughput: std::option::Option<i32>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
        /// <p>The following are the supported values for each volume type:</p>
        /// <ul>
        /// <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li>
        /// <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li>
        /// <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li>
        /// </ul>
        /// <p>For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.</p>
        /// <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
        /// <p>The following are the supported values for each volume type:</p>
        /// <ul>
        /// <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li>
        /// <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li>
        /// <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li>
        /// </ul>
        /// <p>For <code>io1</code> and <code>io2</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families guarantee performance up to 32,000 IOPS.</p>
        /// <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p>
        /// <p>The following are the supported volumes sizes for each volume type:</p>
        /// <ul>
        /// <li> <p> <code>gp2</code> and <code>gp3</code>:1-16,384</p> </li>
        /// <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li>
        /// <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li>
        /// <li> <p> <code>standard</code>: 1-1,024</p> </li>
        /// </ul>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p>
        /// <p>The following are the supported volumes sizes for each volume type:</p>
        /// <ul>
        /// <li> <p> <code>gp2</code> and <code>gp3</code>:1-16,384</p> </li>
        /// <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li>
        /// <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li>
        /// <li> <p> <code>standard</code>: 1-1,024</p> </li>
        /// </ul>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>. If the volume type is <code>io1</code> or <code>io2</code>, you must specify the IOPS that the volume supports.</p>
        pub fn volume_type(mut self, input: crate::model::VolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon EC2 User Guide</i>. If the volume type is <code>io1</code> or <code>io2</code>, you must specify the IOPS that the volume supports.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::VolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.</p>
        /// <p>This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html">RequestSpotFleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.</p>
        /// <p>This parameter is only supported on <code>BlockDeviceMapping</code> objects called by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html">RequestSpotFleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">RequestSpotInstances</a>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The throughput that the volume supports, in MiB/s.</p>
        /// <p>This parameter is valid only for <code>gp3</code> volumes.</p>
        /// <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
        pub fn throughput(mut self, input: i32) -> Self {
            self.throughput = Some(input);
            self
        }
        /// <p>The throughput that the volume supports, in MiB/s.</p>
        /// <p>This parameter is valid only for <code>gp3</code> volumes.</p>
        /// <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
        pub fn set_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput = input;
            self
        }
        /// <p>The ARN of the Outpost on which the snapshot is stored.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Outpost on which the snapshot is stored.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS encryption</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>In no case can you remove encryption from an encrypted volume.</p>
        /// <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
        /// <p>This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS encryption</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>In no case can you remove encryption from an encrypted volume.</p>
        /// <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
        /// <p>This parameter is not returned by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html">DescribeImageAttribute</a>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsBlockDevice`](crate::model::EbsBlockDevice)
        pub fn build(self) -> crate::model::EbsBlockDevice {
            crate::model::EbsBlockDevice {
                delete_on_termination: self.delete_on_termination,
                iops: self.iops,
                snapshot_id: self.snapshot_id,
                volume_size: self.volume_size,
                volume_type: self.volume_type,
                kms_key_id: self.kms_key_id,
                throughput: self.throughput,
                outpost_arn: self.outpost_arn,
                encrypted: self.encrypted,
            }
        }
    }
}
impl EbsBlockDevice {
    /// Creates a new builder-style object to manufacture [`EbsBlockDevice`](crate::model::EbsBlockDevice)
    pub fn builder() -> crate::model::ebs_block_device::Builder {
        crate::model::ebs_block_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Io2,
    #[allow(missing_docs)] // documentation missing in model
    Sc1,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VolumeType {
    fn from(s: &str) -> Self {
        match s {
            "gp2" => VolumeType::Gp2,
            "gp3" => VolumeType::Gp3,
            "io1" => VolumeType::Io1,
            "io2" => VolumeType::Io2,
            "sc1" => VolumeType::Sc1,
            "st1" => VolumeType::St1,
            "standard" => VolumeType::Standard,
            other => VolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VolumeType::from(s))
    }
}
impl VolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VolumeType::Gp2 => "gp2",
            VolumeType::Gp3 => "gp3",
            VolumeType::Io1 => "io1",
            VolumeType::Io2 => "io2",
            VolumeType::Sc1 => "sc1",
            VolumeType::St1 => "st1",
            VolumeType::Standard => "standard",
            VolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["gp2", "gp3", "io1", "io2", "sc1", "st1", "standard"]
    }
}
impl AsRef<str> for VolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the state of an authorization rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientVpnAuthorizationRuleStatus {
    /// <p>The state of the authorization rule.</p>
    pub code: std::option::Option<crate::model::ClientVpnAuthorizationRuleStatusCode>,
    /// <p>A message about the status of the authorization rule, if applicable.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ClientVpnAuthorizationRuleStatus {
    /// <p>The state of the authorization rule.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ClientVpnAuthorizationRuleStatusCode> {
        self.code.as_ref()
    }
    /// <p>A message about the status of the authorization rule, if applicable.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ClientVpnAuthorizationRuleStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientVpnAuthorizationRuleStatus");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ClientVpnAuthorizationRuleStatus`](crate::model::ClientVpnAuthorizationRuleStatus)
pub mod client_vpn_authorization_rule_status {
    /// A builder for [`ClientVpnAuthorizationRuleStatus`](crate::model::ClientVpnAuthorizationRuleStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ClientVpnAuthorizationRuleStatusCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the authorization rule.</p>
        pub fn code(mut self, input: crate::model::ClientVpnAuthorizationRuleStatusCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state of the authorization rule.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ClientVpnAuthorizationRuleStatusCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message about the status of the authorization rule, if applicable.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the status of the authorization rule, if applicable.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientVpnAuthorizationRuleStatus`](crate::model::ClientVpnAuthorizationRuleStatus)
        pub fn build(self) -> crate::model::ClientVpnAuthorizationRuleStatus {
            crate::model::ClientVpnAuthorizationRuleStatus {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ClientVpnAuthorizationRuleStatus {
    /// Creates a new builder-style object to manufacture [`ClientVpnAuthorizationRuleStatus`](crate::model::ClientVpnAuthorizationRuleStatus)
    pub fn builder() -> crate::model::client_vpn_authorization_rule_status::Builder {
        crate::model::client_vpn_authorization_rule_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClientVpnAuthorizationRuleStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Authorizing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Revoking,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClientVpnAuthorizationRuleStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "active" => ClientVpnAuthorizationRuleStatusCode::Active,
            "authorizing" => ClientVpnAuthorizationRuleStatusCode::Authorizing,
            "failed" => ClientVpnAuthorizationRuleStatusCode::Failed,
            "revoking" => ClientVpnAuthorizationRuleStatusCode::Revoking,
            other => ClientVpnAuthorizationRuleStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClientVpnAuthorizationRuleStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClientVpnAuthorizationRuleStatusCode::from(s))
    }
}
impl ClientVpnAuthorizationRuleStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClientVpnAuthorizationRuleStatusCode::Active => "active",
            ClientVpnAuthorizationRuleStatusCode::Authorizing => "authorizing",
            ClientVpnAuthorizationRuleStatusCode::Failed => "failed",
            ClientVpnAuthorizationRuleStatusCode::Revoking => "revoking",
            ClientVpnAuthorizationRuleStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "authorizing", "failed", "revoking"]
    }
}
impl AsRef<str> for ClientVpnAuthorizationRuleStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnapshotState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Recoverable,
    #[allow(missing_docs)] // documentation missing in model
    Recovering,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnapshotState {
    fn from(s: &str) -> Self {
        match s {
            "completed" => SnapshotState::Completed,
            "error" => SnapshotState::Error,
            "pending" => SnapshotState::Pending,
            "recoverable" => SnapshotState::Recoverable,
            "recovering" => SnapshotState::Recovering,
            other => SnapshotState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnapshotState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnapshotState::from(s))
    }
}
impl SnapshotState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnapshotState::Completed => "completed",
            SnapshotState::Error => "error",
            SnapshotState::Pending => "pending",
            SnapshotState::Recoverable => "recoverable",
            SnapshotState::Recovering => "recovering",
            SnapshotState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["completed", "error", "pending", "recoverable", "recovering"]
    }
}
impl AsRef<str> for SnapshotState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a managed prefix list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedPrefixList {
    /// <p>The ID of the prefix list.</p>
    pub prefix_list_id: std::option::Option<std::string::String>,
    /// <p>The IP address version.</p>
    pub address_family: std::option::Option<std::string::String>,
    /// <p>The current state of the prefix list.</p>
    pub state: std::option::Option<crate::model::PrefixListState>,
    /// <p>The state message.</p>
    pub state_message: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the prefix list.</p>
    pub prefix_list_arn: std::option::Option<std::string::String>,
    /// <p>The name of the prefix list.</p>
    pub prefix_list_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of entries for the prefix list.</p>
    pub max_entries: std::option::Option<i32>,
    /// <p>The version of the prefix list.</p>
    pub version: std::option::Option<i64>,
    /// <p>The tags for the prefix list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the owner of the prefix list.</p>
    pub owner_id: std::option::Option<std::string::String>,
}
impl ManagedPrefixList {
    /// <p>The ID of the prefix list.</p>
    pub fn prefix_list_id(&self) -> std::option::Option<&str> {
        self.prefix_list_id.as_deref()
    }
    /// <p>The IP address version.</p>
    pub fn address_family(&self) -> std::option::Option<&str> {
        self.address_family.as_deref()
    }
    /// <p>The current state of the prefix list.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::PrefixListState> {
        self.state.as_ref()
    }
    /// <p>The state message.</p>
    pub fn state_message(&self) -> std::option::Option<&str> {
        self.state_message.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the prefix list.</p>
    pub fn prefix_list_arn(&self) -> std::option::Option<&str> {
        self.prefix_list_arn.as_deref()
    }
    /// <p>The name of the prefix list.</p>
    pub fn prefix_list_name(&self) -> std::option::Option<&str> {
        self.prefix_list_name.as_deref()
    }
    /// <p>The maximum number of entries for the prefix list.</p>
    pub fn max_entries(&self) -> std::option::Option<i32> {
        self.max_entries
    }
    /// <p>The version of the prefix list.</p>
    pub fn version(&self) -> std::option::Option<i64> {
        self.version
    }
    /// <p>The tags for the prefix list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of the owner of the prefix list.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
}
impl std::fmt::Debug for ManagedPrefixList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedPrefixList");
        formatter.field("prefix_list_id", &self.prefix_list_id);
        formatter.field("address_family", &self.address_family);
        formatter.field("state", &self.state);
        formatter.field("state_message", &self.state_message);
        formatter.field("prefix_list_arn", &self.prefix_list_arn);
        formatter.field("prefix_list_name", &self.prefix_list_name);
        formatter.field("max_entries", &self.max_entries);
        formatter.field("version", &self.version);
        formatter.field("tags", &self.tags);
        formatter.field("owner_id", &self.owner_id);
        formatter.finish()
    }
}
/// See [`ManagedPrefixList`](crate::model::ManagedPrefixList)
pub mod managed_prefix_list {
    /// A builder for [`ManagedPrefixList`](crate::model::ManagedPrefixList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::PrefixListState>,
        pub(crate) state_message: std::option::Option<std::string::String>,
        pub(crate) prefix_list_arn: std::option::Option<std::string::String>,
        pub(crate) prefix_list_name: std::option::Option<std::string::String>,
        pub(crate) max_entries: std::option::Option<i32>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the prefix list.</p>
        pub fn prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the prefix list.</p>
        pub fn set_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_id = input;
            self
        }
        /// <p>The IP address version.</p>
        pub fn address_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_family = Some(input.into());
            self
        }
        /// <p>The IP address version.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>The current state of the prefix list.</p>
        pub fn state(mut self, input: crate::model::PrefixListState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the prefix list.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::PrefixListState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The state message.</p>
        pub fn state_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_message = Some(input.into());
            self
        }
        /// <p>The state message.</p>
        pub fn set_state_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_message = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the prefix list.</p>
        pub fn prefix_list_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the prefix list.</p>
        pub fn set_prefix_list_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_arn = input;
            self
        }
        /// <p>The name of the prefix list.</p>
        pub fn prefix_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_name = Some(input.into());
            self
        }
        /// <p>The name of the prefix list.</p>
        pub fn set_prefix_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_name = input;
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn max_entries(mut self, input: i32) -> Self {
            self.max_entries = Some(input);
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn set_max_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_entries = input;
            self
        }
        /// <p>The version of the prefix list.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the prefix list.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the prefix list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the prefix list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the owner of the prefix list.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The ID of the owner of the prefix list.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedPrefixList`](crate::model::ManagedPrefixList)
        pub fn build(self) -> crate::model::ManagedPrefixList {
            crate::model::ManagedPrefixList {
                prefix_list_id: self.prefix_list_id,
                address_family: self.address_family,
                state: self.state,
                state_message: self.state_message,
                prefix_list_arn: self.prefix_list_arn,
                prefix_list_name: self.prefix_list_name,
                max_entries: self.max_entries,
                version: self.version,
                tags: self.tags,
                owner_id: self.owner_id,
            }
        }
    }
}
impl ManagedPrefixList {
    /// Creates a new builder-style object to manufacture [`ManagedPrefixList`](crate::model::ManagedPrefixList)
    pub fn builder() -> crate::model::managed_prefix_list::Builder {
        crate::model::managed_prefix_list::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrefixListState {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    ModifyComplete,
    #[allow(missing_docs)] // documentation missing in model
    ModifyFailed,
    #[allow(missing_docs)] // documentation missing in model
    ModifyInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RestoreComplete,
    #[allow(missing_docs)] // documentation missing in model
    RestoreFailed,
    #[allow(missing_docs)] // documentation missing in model
    RestoreInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrefixListState {
    fn from(s: &str) -> Self {
        match s {
            "create-complete" => PrefixListState::CreateComplete,
            "create-failed" => PrefixListState::CreateFailed,
            "create-in-progress" => PrefixListState::CreateInProgress,
            "delete-complete" => PrefixListState::DeleteComplete,
            "delete-failed" => PrefixListState::DeleteFailed,
            "delete-in-progress" => PrefixListState::DeleteInProgress,
            "modify-complete" => PrefixListState::ModifyComplete,
            "modify-failed" => PrefixListState::ModifyFailed,
            "modify-in-progress" => PrefixListState::ModifyInProgress,
            "restore-complete" => PrefixListState::RestoreComplete,
            "restore-failed" => PrefixListState::RestoreFailed,
            "restore-in-progress" => PrefixListState::RestoreInProgress,
            other => PrefixListState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrefixListState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrefixListState::from(s))
    }
}
impl PrefixListState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrefixListState::CreateComplete => "create-complete",
            PrefixListState::CreateFailed => "create-failed",
            PrefixListState::CreateInProgress => "create-in-progress",
            PrefixListState::DeleteComplete => "delete-complete",
            PrefixListState::DeleteFailed => "delete-failed",
            PrefixListState::DeleteInProgress => "delete-in-progress",
            PrefixListState::ModifyComplete => "modify-complete",
            PrefixListState::ModifyFailed => "modify-failed",
            PrefixListState::ModifyInProgress => "modify-in-progress",
            PrefixListState::RestoreComplete => "restore-complete",
            PrefixListState::RestoreFailed => "restore-failed",
            PrefixListState::RestoreInProgress => "restore-in-progress",
            PrefixListState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "create-complete",
            "create-failed",
            "create-in-progress",
            "delete-complete",
            "delete-failed",
            "delete-in-progress",
            "modify-complete",
            "modify-failed",
            "modify-in-progress",
            "restore-complete",
            "restore-failed",
            "restore-in-progress",
        ]
    }
}
impl AsRef<str> for PrefixListState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    InClassic,
    #[allow(missing_docs)] // documentation missing in model
    InVpc,
    #[allow(missing_docs)] // documentation missing in model
    MoveInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "InClassic" => Status::InClassic,
            "InVpc" => Status::InVpc,
            "MoveInProgress" => Status::MoveInProgress,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::InClassic => "InClassic",
            Status::InVpc => "InVpc",
            Status::MoveInProgress => "MoveInProgress",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InClassic", "InVpc", "MoveInProgress"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnapshotAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    CreateVolumePermission,
    #[allow(missing_docs)] // documentation missing in model
    ProductCodes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnapshotAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "createVolumePermission" => SnapshotAttributeName::CreateVolumePermission,
            "productCodes" => SnapshotAttributeName::ProductCodes,
            other => SnapshotAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnapshotAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnapshotAttributeName::from(s))
    }
}
impl SnapshotAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnapshotAttributeName::CreateVolumePermission => "createVolumePermission",
            SnapshotAttributeName::ProductCodes => "productCodes",
            SnapshotAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["createVolumePermission", "productCodes"]
    }
}
impl AsRef<str> for SnapshotAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    BlockDeviceMapping,
    #[allow(missing_docs)] // documentation missing in model
    DisableApiTermination,
    #[allow(missing_docs)] // documentation missing in model
    EbsOptimized,
    #[allow(missing_docs)] // documentation missing in model
    EnaSupport,
    #[allow(missing_docs)] // documentation missing in model
    EnclaveOptions,
    #[allow(missing_docs)] // documentation missing in model
    GroupSet,
    #[allow(missing_docs)] // documentation missing in model
    InstanceInitiatedShutdownBehavior,
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    Kernel,
    #[allow(missing_docs)] // documentation missing in model
    ProductCodes,
    #[allow(missing_docs)] // documentation missing in model
    Ramdisk,
    #[allow(missing_docs)] // documentation missing in model
    RootDeviceName,
    #[allow(missing_docs)] // documentation missing in model
    SourceDestCheck,
    #[allow(missing_docs)] // documentation missing in model
    SriovNetSupport,
    #[allow(missing_docs)] // documentation missing in model
    UserData,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "blockDeviceMapping" => InstanceAttributeName::BlockDeviceMapping,
            "disableApiTermination" => InstanceAttributeName::DisableApiTermination,
            "ebsOptimized" => InstanceAttributeName::EbsOptimized,
            "enaSupport" => InstanceAttributeName::EnaSupport,
            "enclaveOptions" => InstanceAttributeName::EnclaveOptions,
            "groupSet" => InstanceAttributeName::GroupSet,
            "instanceInitiatedShutdownBehavior" => {
                InstanceAttributeName::InstanceInitiatedShutdownBehavior
            }
            "instanceType" => InstanceAttributeName::InstanceType,
            "kernel" => InstanceAttributeName::Kernel,
            "productCodes" => InstanceAttributeName::ProductCodes,
            "ramdisk" => InstanceAttributeName::Ramdisk,
            "rootDeviceName" => InstanceAttributeName::RootDeviceName,
            "sourceDestCheck" => InstanceAttributeName::SourceDestCheck,
            "sriovNetSupport" => InstanceAttributeName::SriovNetSupport,
            "userData" => InstanceAttributeName::UserData,
            other => InstanceAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceAttributeName::from(s))
    }
}
impl InstanceAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceAttributeName::BlockDeviceMapping => "blockDeviceMapping",
            InstanceAttributeName::DisableApiTermination => "disableApiTermination",
            InstanceAttributeName::EbsOptimized => "ebsOptimized",
            InstanceAttributeName::EnaSupport => "enaSupport",
            InstanceAttributeName::EnclaveOptions => "enclaveOptions",
            InstanceAttributeName::GroupSet => "groupSet",
            InstanceAttributeName::InstanceInitiatedShutdownBehavior => {
                "instanceInitiatedShutdownBehavior"
            }
            InstanceAttributeName::InstanceType => "instanceType",
            InstanceAttributeName::Kernel => "kernel",
            InstanceAttributeName::ProductCodes => "productCodes",
            InstanceAttributeName::Ramdisk => "ramdisk",
            InstanceAttributeName::RootDeviceName => "rootDeviceName",
            InstanceAttributeName::SourceDestCheck => "sourceDestCheck",
            InstanceAttributeName::SriovNetSupport => "sriovNetSupport",
            InstanceAttributeName::UserData => "userData",
            InstanceAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "blockDeviceMapping",
            "disableApiTermination",
            "ebsOptimized",
            "enaSupport",
            "enclaveOptions",
            "groupSet",
            "instanceInitiatedShutdownBehavior",
            "instanceType",
            "kernel",
            "productCodes",
            "ramdisk",
            "rootDeviceName",
            "sourceDestCheck",
            "sriovNetSupport",
            "userData",
        ]
    }
}
impl AsRef<str> for InstanceAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResetImageAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    LaunchPermission,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResetImageAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "launchPermission" => ResetImageAttributeName::LaunchPermission,
            other => ResetImageAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResetImageAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResetImageAttributeName::from(s))
    }
}
impl ResetImageAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResetImageAttributeName::LaunchPermission => "launchPermission",
            ResetImageAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["launchPermission"]
    }
}
impl AsRef<str> for ResetImageAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResetFpgaImageAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    LoadPermission,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResetFpgaImageAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "loadPermission" => ResetFpgaImageAttributeName::LoadPermission,
            other => ResetFpgaImageAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResetFpgaImageAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResetFpgaImageAttributeName::from(s))
    }
}
impl ResetFpgaImageAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResetFpgaImageAttributeName::LoadPermission => "loadPermission",
            ResetFpgaImageAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["loadPermission"]
    }
}
impl AsRef<str> for ResetFpgaImageAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The attributes associated with an Elastic IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddressAttribute {
    /// <p>The public IP address.</p>
    pub public_ip: std::option::Option<std::string::String>,
    /// <p>[EC2-VPC] The allocation ID.</p>
    pub allocation_id: std::option::Option<std::string::String>,
    /// <p>The pointer (PTR) record for the IP address.</p>
    pub ptr_record: std::option::Option<std::string::String>,
    /// <p>The updated PTR record for the IP address.</p>
    pub ptr_record_update: std::option::Option<crate::model::PtrUpdateStatus>,
}
impl AddressAttribute {
    /// <p>The public IP address.</p>
    pub fn public_ip(&self) -> std::option::Option<&str> {
        self.public_ip.as_deref()
    }
    /// <p>[EC2-VPC] The allocation ID.</p>
    pub fn allocation_id(&self) -> std::option::Option<&str> {
        self.allocation_id.as_deref()
    }
    /// <p>The pointer (PTR) record for the IP address.</p>
    pub fn ptr_record(&self) -> std::option::Option<&str> {
        self.ptr_record.as_deref()
    }
    /// <p>The updated PTR record for the IP address.</p>
    pub fn ptr_record_update(&self) -> std::option::Option<&crate::model::PtrUpdateStatus> {
        self.ptr_record_update.as_ref()
    }
}
impl std::fmt::Debug for AddressAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddressAttribute");
        formatter.field("public_ip", &self.public_ip);
        formatter.field("allocation_id", &self.allocation_id);
        formatter.field("ptr_record", &self.ptr_record);
        formatter.field("ptr_record_update", &self.ptr_record_update);
        formatter.finish()
    }
}
/// See [`AddressAttribute`](crate::model::AddressAttribute)
pub mod address_attribute {
    /// A builder for [`AddressAttribute`](crate::model::AddressAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) allocation_id: std::option::Option<std::string::String>,
        pub(crate) ptr_record: std::option::Option<std::string::String>,
        pub(crate) ptr_record_update: std::option::Option<crate::model::PtrUpdateStatus>,
    }
    impl Builder {
        /// <p>The public IP address.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The public IP address.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// <p>[EC2-VPC] The allocation ID.</p>
        pub fn allocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.allocation_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The allocation ID.</p>
        pub fn set_allocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allocation_id = input;
            self
        }
        /// <p>The pointer (PTR) record for the IP address.</p>
        pub fn ptr_record(mut self, input: impl Into<std::string::String>) -> Self {
            self.ptr_record = Some(input.into());
            self
        }
        /// <p>The pointer (PTR) record for the IP address.</p>
        pub fn set_ptr_record(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ptr_record = input;
            self
        }
        /// <p>The updated PTR record for the IP address.</p>
        pub fn ptr_record_update(mut self, input: crate::model::PtrUpdateStatus) -> Self {
            self.ptr_record_update = Some(input);
            self
        }
        /// <p>The updated PTR record for the IP address.</p>
        pub fn set_ptr_record_update(
            mut self,
            input: std::option::Option<crate::model::PtrUpdateStatus>,
        ) -> Self {
            self.ptr_record_update = input;
            self
        }
        /// Consumes the builder and constructs a [`AddressAttribute`](crate::model::AddressAttribute)
        pub fn build(self) -> crate::model::AddressAttribute {
            crate::model::AddressAttribute {
                public_ip: self.public_ip,
                allocation_id: self.allocation_id,
                ptr_record: self.ptr_record,
                ptr_record_update: self.ptr_record_update,
            }
        }
    }
}
impl AddressAttribute {
    /// Creates a new builder-style object to manufacture [`AddressAttribute`](crate::model::AddressAttribute)
    pub fn builder() -> crate::model::address_attribute::Builder {
        crate::model::address_attribute::Builder::default()
    }
}

/// <p>The status of an updated pointer (PTR) record for an Elastic IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PtrUpdateStatus {
    /// <p>The value for the PTR record update.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The status of the PTR record update.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The reason for the PTR record update.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl PtrUpdateStatus {
    /// <p>The value for the PTR record update.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The status of the PTR record update.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The reason for the PTR record update.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for PtrUpdateStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PtrUpdateStatus");
        formatter.field("value", &self.value);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`PtrUpdateStatus`](crate::model::PtrUpdateStatus)
pub mod ptr_update_status {
    /// A builder for [`PtrUpdateStatus`](crate::model::PtrUpdateStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value for the PTR record update.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the PTR record update.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The status of the PTR record update.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the PTR record update.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the PTR record update.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the PTR record update.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`PtrUpdateStatus`](crate::model::PtrUpdateStatus)
        pub fn build(self) -> crate::model::PtrUpdateStatus {
            crate::model::PtrUpdateStatus {
                value: self.value,
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl PtrUpdateStatus {
    /// Creates a new builder-style object to manufacture [`PtrUpdateStatus`](crate::model::PtrUpdateStatus)
    pub fn builder() -> crate::model::ptr_update_status::Builder {
        crate::model::ptr_update_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AddressAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    DomainName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AddressAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "domain-name" => AddressAttributeName::DomainName,
            other => AddressAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AddressAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AddressAttributeName::from(s))
    }
}
impl AddressAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AddressAttributeName::DomainName => "domain-name",
            AddressAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["domain-name"]
    }
}
impl AsRef<str> for AddressAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a Spot Instance request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotInstanceRequest {
    /// <p>Deprecated.</p>
    pub actual_block_hourly_price: std::option::Option<std::string::String>,
    /// <p>The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.</p>
    pub availability_zone_group: std::option::Option<std::string::String>,
    /// <p>Deprecated.</p>
    pub block_duration_minutes: std::option::Option<i32>,
    /// <p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The fault codes for the Spot Instance request, if any.</p>
    pub fault: std::option::Option<crate::model::SpotInstanceStateFault>,
    /// <p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The instance launch group. Launch groups are Spot Instances that launch together and terminate together.</p>
    pub launch_group: std::option::Option<std::string::String>,
    /// <p>Additional information for launching instances.</p>
    pub launch_specification: std::option::Option<crate::model::LaunchSpecification>,
    /// <p>The Availability Zone in which the request is launched.</p>
    pub launched_availability_zone: std::option::Option<std::string::String>,
    /// <p>The product description associated with the Spot Instance.</p>
    pub product_description: std::option::Option<crate::model::RiProductDescription>,
    /// <p>The ID of the Spot Instance request.</p>
    pub spot_instance_request_id: std::option::Option<std::string::String>,
    /// <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
    pub spot_price: std::option::Option<std::string::String>,
    /// <p>The state of the Spot Instance request. Spot status information helps track your Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub state: std::option::Option<crate::model::SpotInstanceState>,
    /// <p>The status code and status message describing the Spot Instance request.</p>
    pub status: std::option::Option<crate::model::SpotInstanceStatus>,
    /// <p>Any tags assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Spot Instance request type.</p>
    pub r#type: std::option::Option<crate::model::SpotInstanceType>,
    /// <p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>
    pub valid_from: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// <ul>
    /// <li> <p>For a persistent request, the request remains active until the <code>validUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li>
    /// <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li>
    /// </ul>
    pub valid_until: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The behavior when a Spot Instance is interrupted.</p>
    pub instance_interruption_behavior:
        std::option::Option<crate::model::InstanceInterruptionBehavior>,
}
impl SpotInstanceRequest {
    /// <p>Deprecated.</p>
    pub fn actual_block_hourly_price(&self) -> std::option::Option<&str> {
        self.actual_block_hourly_price.as_deref()
    }
    /// <p>The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.</p>
    pub fn availability_zone_group(&self) -> std::option::Option<&str> {
        self.availability_zone_group.as_deref()
    }
    /// <p>Deprecated.</p>
    pub fn block_duration_minutes(&self) -> std::option::Option<i32> {
        self.block_duration_minutes
    }
    /// <p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The fault codes for the Spot Instance request, if any.</p>
    pub fn fault(&self) -> std::option::Option<&crate::model::SpotInstanceStateFault> {
        self.fault.as_ref()
    }
    /// <p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The instance launch group. Launch groups are Spot Instances that launch together and terminate together.</p>
    pub fn launch_group(&self) -> std::option::Option<&str> {
        self.launch_group.as_deref()
    }
    /// <p>Additional information for launching instances.</p>
    pub fn launch_specification(&self) -> std::option::Option<&crate::model::LaunchSpecification> {
        self.launch_specification.as_ref()
    }
    /// <p>The Availability Zone in which the request is launched.</p>
    pub fn launched_availability_zone(&self) -> std::option::Option<&str> {
        self.launched_availability_zone.as_deref()
    }
    /// <p>The product description associated with the Spot Instance.</p>
    pub fn product_description(&self) -> std::option::Option<&crate::model::RiProductDescription> {
        self.product_description.as_ref()
    }
    /// <p>The ID of the Spot Instance request.</p>
    pub fn spot_instance_request_id(&self) -> std::option::Option<&str> {
        self.spot_instance_request_id.as_deref()
    }
    /// <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
    pub fn spot_price(&self) -> std::option::Option<&str> {
        self.spot_price.as_deref()
    }
    /// <p>The state of the Spot Instance request. Spot status information helps track your Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::SpotInstanceState> {
        self.state.as_ref()
    }
    /// <p>The status code and status message describing the Spot Instance request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SpotInstanceStatus> {
        self.status.as_ref()
    }
    /// <p>Any tags assigned to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The Spot Instance request type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SpotInstanceType> {
        self.r#type.as_ref()
    }
    /// <p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>
    pub fn valid_from(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_from.as_ref()
    }
    /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// <ul>
    /// <li> <p>For a persistent request, the request remains active until the <code>validUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li>
    /// <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li>
    /// </ul>
    pub fn valid_until(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_until.as_ref()
    }
    /// <p>The behavior when a Spot Instance is interrupted.</p>
    pub fn instance_interruption_behavior(
        &self,
    ) -> std::option::Option<&crate::model::InstanceInterruptionBehavior> {
        self.instance_interruption_behavior.as_ref()
    }
}
impl std::fmt::Debug for SpotInstanceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotInstanceRequest");
        formatter.field("actual_block_hourly_price", &self.actual_block_hourly_price);
        formatter.field("availability_zone_group", &self.availability_zone_group);
        formatter.field("block_duration_minutes", &self.block_duration_minutes);
        formatter.field("create_time", &self.create_time);
        formatter.field("fault", &self.fault);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("launch_group", &self.launch_group);
        formatter.field("launch_specification", &self.launch_specification);
        formatter.field(
            "launched_availability_zone",
            &self.launched_availability_zone,
        );
        formatter.field("product_description", &self.product_description);
        formatter.field("spot_instance_request_id", &self.spot_instance_request_id);
        formatter.field("spot_price", &self.spot_price);
        formatter.field("state", &self.state);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.field("valid_from", &self.valid_from);
        formatter.field("valid_until", &self.valid_until);
        formatter.field(
            "instance_interruption_behavior",
            &self.instance_interruption_behavior,
        );
        formatter.finish()
    }
}
/// See [`SpotInstanceRequest`](crate::model::SpotInstanceRequest)
pub mod spot_instance_request {
    /// A builder for [`SpotInstanceRequest`](crate::model::SpotInstanceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actual_block_hourly_price: std::option::Option<std::string::String>,
        pub(crate) availability_zone_group: std::option::Option<std::string::String>,
        pub(crate) block_duration_minutes: std::option::Option<i32>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) fault: std::option::Option<crate::model::SpotInstanceStateFault>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) launch_group: std::option::Option<std::string::String>,
        pub(crate) launch_specification: std::option::Option<crate::model::LaunchSpecification>,
        pub(crate) launched_availability_zone: std::option::Option<std::string::String>,
        pub(crate) product_description: std::option::Option<crate::model::RiProductDescription>,
        pub(crate) spot_instance_request_id: std::option::Option<std::string::String>,
        pub(crate) spot_price: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::SpotInstanceState>,
        pub(crate) status: std::option::Option<crate::model::SpotInstanceStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) r#type: std::option::Option<crate::model::SpotInstanceType>,
        pub(crate) valid_from: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) instance_interruption_behavior:
            std::option::Option<crate::model::InstanceInterruptionBehavior>,
    }
    impl Builder {
        /// <p>Deprecated.</p>
        pub fn actual_block_hourly_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.actual_block_hourly_price = Some(input.into());
            self
        }
        /// <p>Deprecated.</p>
        pub fn set_actual_block_hourly_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.actual_block_hourly_price = input;
            self
        }
        /// <p>The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.</p>
        pub fn availability_zone_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_group = Some(input.into());
            self
        }
        /// <p>The Availability Zone group. If you specify the same Availability Zone group for all Spot Instance requests, all Spot Instances are launched in the same Availability Zone.</p>
        pub fn set_availability_zone_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_group = input;
            self
        }
        /// <p>Deprecated.</p>
        pub fn block_duration_minutes(mut self, input: i32) -> Self {
            self.block_duration_minutes = Some(input);
            self
        }
        /// <p>Deprecated.</p>
        pub fn set_block_duration_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.block_duration_minutes = input;
            self
        }
        /// <p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The fault codes for the Spot Instance request, if any.</p>
        pub fn fault(mut self, input: crate::model::SpotInstanceStateFault) -> Self {
            self.fault = Some(input);
            self
        }
        /// <p>The fault codes for the Spot Instance request, if any.</p>
        pub fn set_fault(
            mut self,
            input: std::option::Option<crate::model::SpotInstanceStateFault>,
        ) -> Self {
            self.fault = input;
            self
        }
        /// <p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The instance launch group. Launch groups are Spot Instances that launch together and terminate together.</p>
        pub fn launch_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_group = Some(input.into());
            self
        }
        /// <p>The instance launch group. Launch groups are Spot Instances that launch together and terminate together.</p>
        pub fn set_launch_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_group = input;
            self
        }
        /// <p>Additional information for launching instances.</p>
        pub fn launch_specification(mut self, input: crate::model::LaunchSpecification) -> Self {
            self.launch_specification = Some(input);
            self
        }
        /// <p>Additional information for launching instances.</p>
        pub fn set_launch_specification(
            mut self,
            input: std::option::Option<crate::model::LaunchSpecification>,
        ) -> Self {
            self.launch_specification = input;
            self
        }
        /// <p>The Availability Zone in which the request is launched.</p>
        pub fn launched_availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.launched_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the request is launched.</p>
        pub fn set_launched_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launched_availability_zone = input;
            self
        }
        /// <p>The product description associated with the Spot Instance.</p>
        pub fn product_description(mut self, input: crate::model::RiProductDescription) -> Self {
            self.product_description = Some(input);
            self
        }
        /// <p>The product description associated with the Spot Instance.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<crate::model::RiProductDescription>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The ID of the Spot Instance request.</p>
        pub fn spot_instance_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_instance_request_id = Some(input.into());
            self
        }
        /// <p>The ID of the Spot Instance request.</p>
        pub fn set_spot_instance_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spot_instance_request_id = input;
            self
        }
        /// <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
        pub fn spot_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_price = Some(input.into());
            self
        }
        /// <p>The maximum price per hour that you are willing to pay for a Spot Instance.</p>
        pub fn set_spot_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spot_price = input;
            self
        }
        /// <p>The state of the Spot Instance request. Spot status information helps track your Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn state(mut self, input: crate::model::SpotInstanceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the Spot Instance request. Spot status information helps track your Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::SpotInstanceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The status code and status message describing the Spot Instance request.</p>
        pub fn status(mut self, input: crate::model::SpotInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status code and status message describing the Spot Instance request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SpotInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Any tags assigned to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Any tags assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Spot Instance request type.</p>
        pub fn r#type(mut self, input: crate::model::SpotInstanceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The Spot Instance request type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SpotInstanceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>
        pub fn valid_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_from = Some(input);
            self
        }
        /// <p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>
        pub fn set_valid_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_from = input;
            self
        }
        /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        /// <ul>
        /// <li> <p>For a persistent request, the request remains active until the <code>validUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li>
        /// <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li>
        /// </ul>
        pub fn valid_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_until = Some(input);
            self
        }
        /// <p>The end date of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        /// <ul>
        /// <li> <p>For a persistent request, the request remains active until the <code>validUntil</code> date and time is reached. Otherwise, the request remains active until you cancel it. </p> </li>
        /// <li> <p>For a one-time request, the request remains active until all instances launch, the request is canceled, or the <code>validUntil</code> date and time is reached. By default, the request is valid for 7 days from the date the request was created.</p> </li>
        /// </ul>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_until = input;
            self
        }
        /// <p>The behavior when a Spot Instance is interrupted.</p>
        pub fn instance_interruption_behavior(
            mut self,
            input: crate::model::InstanceInterruptionBehavior,
        ) -> Self {
            self.instance_interruption_behavior = Some(input);
            self
        }
        /// <p>The behavior when a Spot Instance is interrupted.</p>
        pub fn set_instance_interruption_behavior(
            mut self,
            input: std::option::Option<crate::model::InstanceInterruptionBehavior>,
        ) -> Self {
            self.instance_interruption_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotInstanceRequest`](crate::model::SpotInstanceRequest)
        pub fn build(self) -> crate::model::SpotInstanceRequest {
            crate::model::SpotInstanceRequest {
                actual_block_hourly_price: self.actual_block_hourly_price,
                availability_zone_group: self.availability_zone_group,
                block_duration_minutes: self.block_duration_minutes,
                create_time: self.create_time,
                fault: self.fault,
                instance_id: self.instance_id,
                launch_group: self.launch_group,
                launch_specification: self.launch_specification,
                launched_availability_zone: self.launched_availability_zone,
                product_description: self.product_description,
                spot_instance_request_id: self.spot_instance_request_id,
                spot_price: self.spot_price,
                state: self.state,
                status: self.status,
                tags: self.tags,
                r#type: self.r#type,
                valid_from: self.valid_from,
                valid_until: self.valid_until,
                instance_interruption_behavior: self.instance_interruption_behavior,
            }
        }
    }
}
impl SpotInstanceRequest {
    /// Creates a new builder-style object to manufacture [`SpotInstanceRequest`](crate::model::SpotInstanceRequest)
    pub fn builder() -> crate::model::spot_instance_request::Builder {
        crate::model::spot_instance_request::Builder::default()
    }
}

/// <p>Describes the status of a Spot Instance request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotInstanceStatus {
    /// <p>The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The description for the status code.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SpotInstanceStatus {
    /// <p>The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The description for the status code.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for SpotInstanceStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotInstanceStatus");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`SpotInstanceStatus`](crate::model::SpotInstanceStatus)
pub mod spot_instance_status {
    /// A builder for [`SpotInstanceStatus`](crate::model::SpotInstanceStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The status code. For a list of status codes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand">Spot status codes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The description for the status code.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The description for the status code.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotInstanceStatus`](crate::model::SpotInstanceStatus)
        pub fn build(self) -> crate::model::SpotInstanceStatus {
            crate::model::SpotInstanceStatus {
                code: self.code,
                message: self.message,
                update_time: self.update_time,
            }
        }
    }
}
impl SpotInstanceStatus {
    /// Creates a new builder-style object to manufacture [`SpotInstanceStatus`](crate::model::SpotInstanceStatus)
    pub fn builder() -> crate::model::spot_instance_status::Builder {
        crate::model::spot_instance_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SpotInstanceState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SpotInstanceState {
    fn from(s: &str) -> Self {
        match s {
            "active" => SpotInstanceState::Active,
            "cancelled" => SpotInstanceState::Cancelled,
            "closed" => SpotInstanceState::Closed,
            "failed" => SpotInstanceState::Failed,
            "open" => SpotInstanceState::Open,
            other => SpotInstanceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SpotInstanceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SpotInstanceState::from(s))
    }
}
impl SpotInstanceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SpotInstanceState::Active => "active",
            SpotInstanceState::Cancelled => "cancelled",
            SpotInstanceState::Closed => "closed",
            SpotInstanceState::Failed => "failed",
            SpotInstanceState::Open => "open",
            SpotInstanceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["active", "cancelled", "closed", "failed", "open"]
    }
}
impl AsRef<str> for SpotInstanceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct RiProductDescription(String);
impl RiProductDescription {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Linux/UNIX",
            "Linux/UNIX (Amazon VPC)",
            "Windows",
            "Windows (Amazon VPC)",
        ]
    }
}
impl<T> std::convert::From<T> for RiProductDescription
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        RiProductDescription(s.as_ref().to_owned())
    }
}

/// <p>Describes the launch specification for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchSpecification {
    /// <p>The Base64-encoded user data for the instance.</p>
    pub user_data: std::option::Option<std::string::String>,
    /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
    /// <p>Deprecated.</p>
    pub addressing_type: std::option::Option<std::string::String>,
    /// <p>One or more block device mapping entries.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The IAM instance profile.</p>
    pub iam_instance_profile: std::option::Option<crate::model::IamInstanceProfileSpecification>,
    /// <p>The ID of the AMI.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<crate::model::InstanceType>,
    /// <p>The ID of the kernel.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
    pub network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterfaceSpecification>>,
    /// <p>The placement information for the instance.</p>
    pub placement: std::option::Option<crate::model::SpotPlacement>,
    /// <p>The ID of the RAM disk.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet in which to launch the instance.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>Describes the monitoring of an instance.</p>
    pub monitoring: std::option::Option<crate::model::RunInstancesMonitoringEnabled>,
}
impl LaunchSpecification {
    /// <p>The Base64-encoded user data for the instance.</p>
    pub fn user_data(&self) -> std::option::Option<&str> {
        self.user_data.as_deref()
    }
    /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
    pub fn security_groups(&self) -> std::option::Option<&[crate::model::GroupIdentifier]> {
        self.security_groups.as_deref()
    }
    /// <p>Deprecated.</p>
    pub fn addressing_type(&self) -> std::option::Option<&str> {
        self.addressing_type.as_deref()
    }
    /// <p>One or more block device mapping entries.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The IAM instance profile.</p>
    pub fn iam_instance_profile(
        &self,
    ) -> std::option::Option<&crate::model::IamInstanceProfileSpecification> {
        self.iam_instance_profile.as_ref()
    }
    /// <p>The ID of the AMI.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The ID of the kernel.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The name of the key pair.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
    pub fn network_interfaces(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceNetworkInterfaceSpecification]> {
        self.network_interfaces.as_deref()
    }
    /// <p>The placement information for the instance.</p>
    pub fn placement(&self) -> std::option::Option<&crate::model::SpotPlacement> {
        self.placement.as_ref()
    }
    /// <p>The ID of the RAM disk.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>The ID of the subnet in which to launch the instance.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>Describes the monitoring of an instance.</p>
    pub fn monitoring(&self) -> std::option::Option<&crate::model::RunInstancesMonitoringEnabled> {
        self.monitoring.as_ref()
    }
}
impl std::fmt::Debug for LaunchSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchSpecification");
        formatter.field("user_data", &self.user_data);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("addressing_type", &self.addressing_type);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("placement", &self.placement);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("monitoring", &self.monitoring);
        formatter.finish()
    }
}
/// See [`LaunchSpecification`](crate::model::LaunchSpecification)
pub mod launch_specification {
    /// A builder for [`LaunchSpecification`](crate::model::LaunchSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_data: std::option::Option<std::string::String>,
        pub(crate) security_groups:
            std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        pub(crate) addressing_type: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) iam_instance_profile:
            std::option::Option<crate::model::IamInstanceProfileSpecification>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::InstanceType>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterfaceSpecification>>,
        pub(crate) placement: std::option::Option<crate::model::SpotPlacement>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) monitoring: std::option::Option<crate::model::RunInstancesMonitoringEnabled>,
    }
    impl Builder {
        /// <p>The Base64-encoded user data for the instance.</p>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>The Base64-encoded user data for the instance.</p>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
        pub fn security_groups(mut self, input: crate::model::GroupIdentifier) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input);
            self.security_groups = Some(v);
            self
        }
        /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>Deprecated.</p>
        pub fn addressing_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.addressing_type = Some(input.into());
            self
        }
        /// <p>Deprecated.</p>
        pub fn set_addressing_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.addressing_type = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>One or more block device mapping entries.</p>
        pub fn block_device_mappings(mut self, input: crate::model::BlockDeviceMapping) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>One or more block device mapping entries.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn iam_instance_profile(
            mut self,
            input: crate::model::IamInstanceProfileSpecification,
        ) -> Self {
            self.iam_instance_profile = Some(input);
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::IamInstanceProfileSpecification>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The ID of the AMI.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The instance type.</p>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The instance type.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the kernel.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The ID of the kernel.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
        pub fn network_interfaces(
            mut self,
            input: crate::model::InstanceNetworkInterfaceSpecification,
        ) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceNetworkInterfaceSpecification>,
            >,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// <p>The placement information for the instance.</p>
        pub fn placement(mut self, input: crate::model::SpotPlacement) -> Self {
            self.placement = Some(input);
            self
        }
        /// <p>The placement information for the instance.</p>
        pub fn set_placement(
            mut self,
            input: std::option::Option<crate::model::SpotPlacement>,
        ) -> Self {
            self.placement = input;
            self
        }
        /// <p>The ID of the RAM disk.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The ID of the RAM disk.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// <p>The ID of the subnet in which to launch the instance.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet in which to launch the instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Describes the monitoring of an instance.</p>
        pub fn monitoring(mut self, input: crate::model::RunInstancesMonitoringEnabled) -> Self {
            self.monitoring = Some(input);
            self
        }
        /// <p>Describes the monitoring of an instance.</p>
        pub fn set_monitoring(
            mut self,
            input: std::option::Option<crate::model::RunInstancesMonitoringEnabled>,
        ) -> Self {
            self.monitoring = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchSpecification`](crate::model::LaunchSpecification)
        pub fn build(self) -> crate::model::LaunchSpecification {
            crate::model::LaunchSpecification {
                user_data: self.user_data,
                security_groups: self.security_groups,
                addressing_type: self.addressing_type,
                block_device_mappings: self.block_device_mappings,
                ebs_optimized: self.ebs_optimized,
                iam_instance_profile: self.iam_instance_profile,
                image_id: self.image_id,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                key_name: self.key_name,
                network_interfaces: self.network_interfaces,
                placement: self.placement,
                ramdisk_id: self.ramdisk_id,
                subnet_id: self.subnet_id,
                monitoring: self.monitoring,
            }
        }
    }
}
impl LaunchSpecification {
    /// Creates a new builder-style object to manufacture [`LaunchSpecification`](crate::model::LaunchSpecification)
    pub fn builder() -> crate::model::launch_specification::Builder {
        crate::model::launch_specification::Builder::default()
    }
}

/// <p>Describes Spot Instance placement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotPlacement {
    /// <p>The Availability Zone.</p>
    /// <p>[Spot Fleet only] To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The name of the placement group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.</p>
    pub tenancy: std::option::Option<crate::model::Tenancy>,
}
impl SpotPlacement {
    /// <p>The Availability Zone.</p>
    /// <p>[Spot Fleet only] To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The name of the placement group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.</p>
    pub fn tenancy(&self) -> std::option::Option<&crate::model::Tenancy> {
        self.tenancy.as_ref()
    }
}
impl std::fmt::Debug for SpotPlacement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotPlacement");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("group_name", &self.group_name);
        formatter.field("tenancy", &self.tenancy);
        formatter.finish()
    }
}
/// See [`SpotPlacement`](crate::model::SpotPlacement)
pub mod spot_placement {
    /// A builder for [`SpotPlacement`](crate::model::SpotPlacement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<crate::model::Tenancy>,
    }
    impl Builder {
        /// <p>The Availability Zone.</p>
        /// <p>[Spot Fleet only] To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone.</p>
        /// <p>[Spot Fleet only] To specify multiple Availability Zones, separate them using commas; for example, "us-west-2a, us-west-2b".</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The name of the placement group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the placement group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.</p>
        pub fn tenancy(mut self, input: crate::model::Tenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot Instances.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<crate::model::Tenancy>) -> Self {
            self.tenancy = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotPlacement`](crate::model::SpotPlacement)
        pub fn build(self) -> crate::model::SpotPlacement {
            crate::model::SpotPlacement {
                availability_zone: self.availability_zone,
                group_name: self.group_name,
                tenancy: self.tenancy,
            }
        }
    }
}
impl SpotPlacement {
    /// Creates a new builder-style object to manufacture [`SpotPlacement`](crate::model::SpotPlacement)
    pub fn builder() -> crate::model::spot_placement::Builder {
        crate::model::spot_placement::Builder::default()
    }
}

/// <p>Describes a Spot Instance state change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpotInstanceStateFault {
    /// <p>The reason code for the Spot Instance state change.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message for the Spot Instance state change.</p>
    pub message: std::option::Option<std::string::String>,
}
impl SpotInstanceStateFault {
    /// <p>The reason code for the Spot Instance state change.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The message for the Spot Instance state change.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for SpotInstanceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpotInstanceStateFault");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`SpotInstanceStateFault`](crate::model::SpotInstanceStateFault)
pub mod spot_instance_state_fault {
    /// A builder for [`SpotInstanceStateFault`](crate::model::SpotInstanceStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reason code for the Spot Instance state change.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The reason code for the Spot Instance state change.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message for the Spot Instance state change.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the Spot Instance state change.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SpotInstanceStateFault`](crate::model::SpotInstanceStateFault)
        pub fn build(self) -> crate::model::SpotInstanceStateFault {
            crate::model::SpotInstanceStateFault {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl SpotInstanceStateFault {
    /// Creates a new builder-style object to manufacture [`SpotInstanceStateFault`](crate::model::SpotInstanceStateFault)
    pub fn builder() -> crate::model::spot_instance_state_fault::Builder {
        crate::model::spot_instance_state_fault::Builder::default()
    }
}

/// <p>Describes the launch specification for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestSpotLaunchSpecification {
    /// <p>One or more security group IDs.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Deprecated.</p>
    pub addressing_type: std::option::Option<std::string::String>,
    /// <p>One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>The IAM instance profile.</p>
    pub iam_instance_profile: std::option::Option<crate::model::IamInstanceProfileSpecification>,
    /// <p>The ID of the AMI.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The instance type.</p>
    pub instance_type: std::option::Option<crate::model::InstanceType>,
    /// <p>The ID of the kernel.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether basic or detailed monitoring is enabled for the instance.</p>
    /// <p>Default: Disabled</p>
    pub monitoring: std::option::Option<crate::model::RunInstancesMonitoringEnabled>,
    /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
    pub network_interfaces:
        std::option::Option<std::vec::Vec<crate::model::InstanceNetworkInterfaceSpecification>>,
    /// <p>The placement information for the instance.</p>
    pub placement: std::option::Option<crate::model::SpotPlacement>,
    /// <p>The ID of the RAM disk.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet in which to launch the instance.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The Base64-encoded user data for the instance. User data is limited to 16 KB.</p>
    pub user_data: std::option::Option<std::string::String>,
}
impl RequestSpotLaunchSpecification {
    /// <p>One or more security group IDs.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>Deprecated.</p>
    pub fn addressing_type(&self) -> std::option::Option<&str> {
        self.addressing_type.as_deref()
    }
    /// <p>One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>
    /// <p>Default: <code>false</code> </p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>The IAM instance profile.</p>
    pub fn iam_instance_profile(
        &self,
    ) -> std::option::Option<&crate::model::IamInstanceProfileSpecification> {
        self.iam_instance_profile.as_ref()
    }
    /// <p>The ID of the AMI.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The instance type.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The ID of the kernel.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The name of the key pair.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>Indicates whether basic or detailed monitoring is enabled for the instance.</p>
    /// <p>Default: Disabled</p>
    pub fn monitoring(&self) -> std::option::Option<&crate::model::RunInstancesMonitoringEnabled> {
        self.monitoring.as_ref()
    }
    /// <p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>
    pub fn network_interfaces(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceNetworkInterfaceSpecification]> {
        self.network_interfaces.as_deref()
    }
    /// <p>The placement information for the instance.</p>
    pub fn placement(&self) -> std::option::Option<&crate::model::SpotPlacement> {
        self.placement.as_ref()
    }
    /// <p>The ID of the RAM disk.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>The ID of the subnet in which to launch the instance.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The Base64-encoded user data for the instance. User data is limited to 16 KB.</p>
    pub fn user_data(&self) -> std::option::Option<&str> {
        self.user_data.as_deref()
    }
}
impl std::fmt::Debug for RequestSpotLaunchSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestSpotLaunchSpecification");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("addressing_type", &self.addressing_type);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("monitoring", &self.monitoring);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("placement", &self.placement);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("user_data", &self.user_data);
        formatter.finish()
    }
}
/// See [`RequestSpotLaunchSpecification`](crate::model::RequestSpotLaunchSpecification)
pub mod request_spot_launch_specification {
    /// A builder for [`RequestSpotLaunchSpecification`](crate::model::RequestSpotLaunchSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) addressing_type: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) iam_instance_profile:
            std::option::Option<crate::model::IamInstanceProfileSpecification>,
        pub(crate) image_id: std::option::Option