// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptReservedInstancesExchangeQuote`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_reserved_instances_exchange_quote`](crate::client::Client::accept_reserved_instances_exchange_quote).
///
/// See [`crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptReservedInstancesExchangeQuote {
    _private: (),
}
impl AcceptReservedInstancesExchangeQuote {
    /// Creates a new builder-style object to manufacture [`AcceptReservedInstancesExchangeQuoteInput`](crate::input::AcceptReservedInstancesExchangeQuoteInput)
    pub fn builder() -> crate::input::accept_reserved_instances_exchange_quote_input::Builder {
        crate::input::accept_reserved_instances_exchange_quote_input::Builder::default()
    }
    /// Creates a new `AcceptReservedInstancesExchangeQuote` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptReservedInstancesExchangeQuote {
    type Output = std::result::Result<
        crate::output::AcceptReservedInstancesExchangeQuoteOutput,
        crate::error::AcceptReservedInstancesExchangeQuoteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_reserved_instances_exchange_quote_error(response)
        } else {
            crate::operation_deser::parse_accept_reserved_instances_exchange_quote_response(
                response,
            )
        }
    }
}

/// Operation shape for `AcceptTransitGatewayMulticastDomainAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_transit_gateway_multicast_domain_associations`](crate::client::Client::accept_transit_gateway_multicast_domain_associations).
///
/// See [`crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptTransitGatewayMulticastDomainAssociations {
    _private: (),
}
impl AcceptTransitGatewayMulticastDomainAssociations {
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayMulticastDomainAssociationsInput`](crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput)
    pub fn builder(
    ) -> crate::input::accept_transit_gateway_multicast_domain_associations_input::Builder {
        crate::input::accept_transit_gateway_multicast_domain_associations_input::Builder::default()
    }
    /// Creates a new `AcceptTransitGatewayMulticastDomainAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for AcceptTransitGatewayMulticastDomainAssociations
{
    type Output = std::result::Result<
        crate::output::AcceptTransitGatewayMulticastDomainAssociationsOutput,
        crate::error::AcceptTransitGatewayMulticastDomainAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_transit_gateway_multicast_domain_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_accept_transit_gateway_multicast_domain_associations_response(response)
        }
    }
}

/// Operation shape for `AcceptTransitGatewayPeeringAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_transit_gateway_peering_attachment`](crate::client::Client::accept_transit_gateway_peering_attachment).
///
/// See [`crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptTransitGatewayPeeringAttachment {
    _private: (),
}
impl AcceptTransitGatewayPeeringAttachment {
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayPeeringAttachmentInput`](crate::input::AcceptTransitGatewayPeeringAttachmentInput)
    pub fn builder() -> crate::input::accept_transit_gateway_peering_attachment_input::Builder {
        crate::input::accept_transit_gateway_peering_attachment_input::Builder::default()
    }
    /// Creates a new `AcceptTransitGatewayPeeringAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptTransitGatewayPeeringAttachment {
    type Output = std::result::Result<
        crate::output::AcceptTransitGatewayPeeringAttachmentOutput,
        crate::error::AcceptTransitGatewayPeeringAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_transit_gateway_peering_attachment_error(response)
        } else {
            crate::operation_deser::parse_accept_transit_gateway_peering_attachment_response(
                response,
            )
        }
    }
}

/// Operation shape for `AcceptTransitGatewayVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_transit_gateway_vpc_attachment`](crate::client::Client::accept_transit_gateway_vpc_attachment).
///
/// See [`crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptTransitGatewayVpcAttachment {
    _private: (),
}
impl AcceptTransitGatewayVpcAttachment {
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayVpcAttachmentInput`](crate::input::AcceptTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::accept_transit_gateway_vpc_attachment_input::Builder {
        crate::input::accept_transit_gateway_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `AcceptTransitGatewayVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptTransitGatewayVpcAttachment {
    type Output = std::result::Result<
        crate::output::AcceptTransitGatewayVpcAttachmentOutput,
        crate::error::AcceptTransitGatewayVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_transit_gateway_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_accept_transit_gateway_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `AcceptVpcEndpointConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_vpc_endpoint_connections`](crate::client::Client::accept_vpc_endpoint_connections).
///
/// See [`crate::client::fluent_builders::AcceptVpcEndpointConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptVpcEndpointConnections {
    _private: (),
}
impl AcceptVpcEndpointConnections {
    /// Creates a new builder-style object to manufacture [`AcceptVpcEndpointConnectionsInput`](crate::input::AcceptVpcEndpointConnectionsInput)
    pub fn builder() -> crate::input::accept_vpc_endpoint_connections_input::Builder {
        crate::input::accept_vpc_endpoint_connections_input::Builder::default()
    }
    /// Creates a new `AcceptVpcEndpointConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptVpcEndpointConnections {
    type Output = std::result::Result<
        crate::output::AcceptVpcEndpointConnectionsOutput,
        crate::error::AcceptVpcEndpointConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_vpc_endpoint_connections_error(response)
        } else {
            crate::operation_deser::parse_accept_vpc_endpoint_connections_response(response)
        }
    }
}

/// Operation shape for `AcceptVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_vpc_peering_connection`](crate::client::Client::accept_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::AcceptVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptVpcPeeringConnection {
    _private: (),
}
impl AcceptVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`AcceptVpcPeeringConnectionInput`](crate::input::AcceptVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::accept_vpc_peering_connection_input::Builder {
        crate::input::accept_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `AcceptVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::AcceptVpcPeeringConnectionOutput,
        crate::error::AcceptVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_accept_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `AdvertiseByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`advertise_byoip_cidr`](crate::client::Client::advertise_byoip_cidr).
///
/// See [`crate::client::fluent_builders::AdvertiseByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdvertiseByoipCidr {
    _private: (),
}
impl AdvertiseByoipCidr {
    /// Creates a new builder-style object to manufacture [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    pub fn builder() -> crate::input::advertise_byoip_cidr_input::Builder {
        crate::input::advertise_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `AdvertiseByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdvertiseByoipCidr {
    type Output = std::result::Result<
        crate::output::AdvertiseByoipCidrOutput,
        crate::error::AdvertiseByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_advertise_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_advertise_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `AllocateAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`allocate_address`](crate::client::Client::allocate_address).
///
/// See [`crate::client::fluent_builders::AllocateAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AllocateAddress {
    _private: (),
}
impl AllocateAddress {
    /// Creates a new builder-style object to manufacture [`AllocateAddressInput`](crate::input::AllocateAddressInput)
    pub fn builder() -> crate::input::allocate_address_input::Builder {
        crate::input::allocate_address_input::Builder::default()
    }
    /// Creates a new `AllocateAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AllocateAddress {
    type Output = std::result::Result<
        crate::output::AllocateAddressOutput,
        crate::error::AllocateAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_allocate_address_error(response)
        } else {
            crate::operation_deser::parse_allocate_address_response(response)
        }
    }
}

/// Operation shape for `AllocateHosts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`allocate_hosts`](crate::client::Client::allocate_hosts).
///
/// See [`crate::client::fluent_builders::AllocateHosts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AllocateHosts {
    _private: (),
}
impl AllocateHosts {
    /// Creates a new builder-style object to manufacture [`AllocateHostsInput`](crate::input::AllocateHostsInput)
    pub fn builder() -> crate::input::allocate_hosts_input::Builder {
        crate::input::allocate_hosts_input::Builder::default()
    }
    /// Creates a new `AllocateHosts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AllocateHosts {
    type Output =
        std::result::Result<crate::output::AllocateHostsOutput, crate::error::AllocateHostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_allocate_hosts_error(response)
        } else {
            crate::operation_deser::parse_allocate_hosts_response(response)
        }
    }
}

/// Operation shape for `AllocateIpamPoolCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`allocate_ipam_pool_cidr`](crate::client::Client::allocate_ipam_pool_cidr).
///
/// See [`crate::client::fluent_builders::AllocateIpamPoolCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AllocateIpamPoolCidr {
    _private: (),
}
impl AllocateIpamPoolCidr {
    /// Creates a new builder-style object to manufacture [`AllocateIpamPoolCidrInput`](crate::input::AllocateIpamPoolCidrInput)
    pub fn builder() -> crate::input::allocate_ipam_pool_cidr_input::Builder {
        crate::input::allocate_ipam_pool_cidr_input::Builder::default()
    }
    /// Creates a new `AllocateIpamPoolCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AllocateIpamPoolCidr {
    type Output = std::result::Result<
        crate::output::AllocateIpamPoolCidrOutput,
        crate::error::AllocateIpamPoolCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_allocate_ipam_pool_cidr_error(response)
        } else {
            crate::operation_deser::parse_allocate_ipam_pool_cidr_response(response)
        }
    }
}

/// Operation shape for `ApplySecurityGroupsToClientVpnTargetNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`apply_security_groups_to_client_vpn_target_network`](crate::client::Client::apply_security_groups_to_client_vpn_target_network).
///
/// See [`crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ApplySecurityGroupsToClientVpnTargetNetwork {
    _private: (),
}
impl ApplySecurityGroupsToClientVpnTargetNetwork {
    /// Creates a new builder-style object to manufacture [`ApplySecurityGroupsToClientVpnTargetNetworkInput`](crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput)
    pub fn builder(
    ) -> crate::input::apply_security_groups_to_client_vpn_target_network_input::Builder {
        crate::input::apply_security_groups_to_client_vpn_target_network_input::Builder::default()
    }
    /// Creates a new `ApplySecurityGroupsToClientVpnTargetNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ApplySecurityGroupsToClientVpnTargetNetwork
{
    type Output = std::result::Result<
        crate::output::ApplySecurityGroupsToClientVpnTargetNetworkOutput,
        crate::error::ApplySecurityGroupsToClientVpnTargetNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_apply_security_groups_to_client_vpn_target_network_error(
                response,
            )
        } else {
            crate::operation_deser::parse_apply_security_groups_to_client_vpn_target_network_response(response)
        }
    }
}

/// Operation shape for `AssignIpv6Addresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`assign_ipv6_addresses`](crate::client::Client::assign_ipv6_addresses).
///
/// See [`crate::client::fluent_builders::AssignIpv6Addresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssignIpv6Addresses {
    _private: (),
}
impl AssignIpv6Addresses {
    /// Creates a new builder-style object to manufacture [`AssignIpv6AddressesInput`](crate::input::AssignIpv6AddressesInput)
    pub fn builder() -> crate::input::assign_ipv6_addresses_input::Builder {
        crate::input::assign_ipv6_addresses_input::Builder::default()
    }
    /// Creates a new `AssignIpv6Addresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssignIpv6Addresses {
    type Output = std::result::Result<
        crate::output::AssignIpv6AddressesOutput,
        crate::error::AssignIpv6AddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_assign_ipv6_addresses_error(response)
        } else {
            crate::operation_deser::parse_assign_ipv6_addresses_response(response)
        }
    }
}

/// Operation shape for `AssignPrivateIpAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`assign_private_ip_addresses`](crate::client::Client::assign_private_ip_addresses).
///
/// See [`crate::client::fluent_builders::AssignPrivateIpAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssignPrivateIpAddresses {
    _private: (),
}
impl AssignPrivateIpAddresses {
    /// Creates a new builder-style object to manufacture [`AssignPrivateIpAddressesInput`](crate::input::AssignPrivateIpAddressesInput)
    pub fn builder() -> crate::input::assign_private_ip_addresses_input::Builder {
        crate::input::assign_private_ip_addresses_input::Builder::default()
    }
    /// Creates a new `AssignPrivateIpAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssignPrivateIpAddresses {
    type Output = std::result::Result<
        crate::output::AssignPrivateIpAddressesOutput,
        crate::error::AssignPrivateIpAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_assign_private_ip_addresses_error(response)
        } else {
            crate::operation_deser::parse_assign_private_ip_addresses_response(response)
        }
    }
}

/// Operation shape for `AssociateAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_address`](crate::client::Client::associate_address).
///
/// See [`crate::client::fluent_builders::AssociateAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAddress {
    _private: (),
}
impl AssociateAddress {
    /// Creates a new builder-style object to manufacture [`AssociateAddressInput`](crate::input::AssociateAddressInput)
    pub fn builder() -> crate::input::associate_address_input::Builder {
        crate::input::associate_address_input::Builder::default()
    }
    /// Creates a new `AssociateAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAddress {
    type Output = std::result::Result<
        crate::output::AssociateAddressOutput,
        crate::error::AssociateAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_address_error(response)
        } else {
            crate::operation_deser::parse_associate_address_response(response)
        }
    }
}

/// Operation shape for `AssociateClientVpnTargetNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_client_vpn_target_network`](crate::client::Client::associate_client_vpn_target_network).
///
/// See [`crate::client::fluent_builders::AssociateClientVpnTargetNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateClientVpnTargetNetwork {
    _private: (),
}
impl AssociateClientVpnTargetNetwork {
    /// Creates a new builder-style object to manufacture [`AssociateClientVpnTargetNetworkInput`](crate::input::AssociateClientVpnTargetNetworkInput)
    pub fn builder() -> crate::input::associate_client_vpn_target_network_input::Builder {
        crate::input::associate_client_vpn_target_network_input::Builder::default()
    }
    /// Creates a new `AssociateClientVpnTargetNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateClientVpnTargetNetwork {
    type Output = std::result::Result<
        crate::output::AssociateClientVpnTargetNetworkOutput,
        crate::error::AssociateClientVpnTargetNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_client_vpn_target_network_error(response)
        } else {
            crate::operation_deser::parse_associate_client_vpn_target_network_response(response)
        }
    }
}

/// Operation shape for `AssociateDhcpOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_dhcp_options`](crate::client::Client::associate_dhcp_options).
///
/// See [`crate::client::fluent_builders::AssociateDhcpOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDhcpOptions {
    _private: (),
}
impl AssociateDhcpOptions {
    /// Creates a new builder-style object to manufacture [`AssociateDhcpOptionsInput`](crate::input::AssociateDhcpOptionsInput)
    pub fn builder() -> crate::input::associate_dhcp_options_input::Builder {
        crate::input::associate_dhcp_options_input::Builder::default()
    }
    /// Creates a new `AssociateDhcpOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDhcpOptions {
    type Output = std::result::Result<
        crate::output::AssociateDhcpOptionsOutput,
        crate::error::AssociateDhcpOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_dhcp_options_error(response)
        } else {
            crate::operation_deser::parse_associate_dhcp_options_response(response)
        }
    }
}

/// Operation shape for `AssociateEnclaveCertificateIamRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_enclave_certificate_iam_role`](crate::client::Client::associate_enclave_certificate_iam_role).
///
/// See [`crate::client::fluent_builders::AssociateEnclaveCertificateIamRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateEnclaveCertificateIamRole {
    _private: (),
}
impl AssociateEnclaveCertificateIamRole {
    /// Creates a new builder-style object to manufacture [`AssociateEnclaveCertificateIamRoleInput`](crate::input::AssociateEnclaveCertificateIamRoleInput)
    pub fn builder() -> crate::input::associate_enclave_certificate_iam_role_input::Builder {
        crate::input::associate_enclave_certificate_iam_role_input::Builder::default()
    }
    /// Creates a new `AssociateEnclaveCertificateIamRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateEnclaveCertificateIamRole {
    type Output = std::result::Result<
        crate::output::AssociateEnclaveCertificateIamRoleOutput,
        crate::error::AssociateEnclaveCertificateIamRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_enclave_certificate_iam_role_error(response)
        } else {
            crate::operation_deser::parse_associate_enclave_certificate_iam_role_response(response)
        }
    }
}

/// Operation shape for `AssociateIamInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_iam_instance_profile`](crate::client::Client::associate_iam_instance_profile).
///
/// See [`crate::client::fluent_builders::AssociateIamInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateIamInstanceProfile {
    _private: (),
}
impl AssociateIamInstanceProfile {
    /// Creates a new builder-style object to manufacture [`AssociateIamInstanceProfileInput`](crate::input::AssociateIamInstanceProfileInput)
    pub fn builder() -> crate::input::associate_iam_instance_profile_input::Builder {
        crate::input::associate_iam_instance_profile_input::Builder::default()
    }
    /// Creates a new `AssociateIamInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateIamInstanceProfile {
    type Output = std::result::Result<
        crate::output::AssociateIamInstanceProfileOutput,
        crate::error::AssociateIamInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_iam_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_associate_iam_instance_profile_response(response)
        }
    }
}

/// Operation shape for `AssociateInstanceEventWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_instance_event_window`](crate::client::Client::associate_instance_event_window).
///
/// See [`crate::client::fluent_builders::AssociateInstanceEventWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateInstanceEventWindow {
    _private: (),
}
impl AssociateInstanceEventWindow {
    /// Creates a new builder-style object to manufacture [`AssociateInstanceEventWindowInput`](crate::input::AssociateInstanceEventWindowInput)
    pub fn builder() -> crate::input::associate_instance_event_window_input::Builder {
        crate::input::associate_instance_event_window_input::Builder::default()
    }
    /// Creates a new `AssociateInstanceEventWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateInstanceEventWindow {
    type Output = std::result::Result<
        crate::output::AssociateInstanceEventWindowOutput,
        crate::error::AssociateInstanceEventWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_instance_event_window_error(response)
        } else {
            crate::operation_deser::parse_associate_instance_event_window_response(response)
        }
    }
}

/// Operation shape for `AssociateRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_route_table`](crate::client::Client::associate_route_table).
///
/// See [`crate::client::fluent_builders::AssociateRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateRouteTable {
    _private: (),
}
impl AssociateRouteTable {
    /// Creates a new builder-style object to manufacture [`AssociateRouteTableInput`](crate::input::AssociateRouteTableInput)
    pub fn builder() -> crate::input::associate_route_table_input::Builder {
        crate::input::associate_route_table_input::Builder::default()
    }
    /// Creates a new `AssociateRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateRouteTable {
    type Output = std::result::Result<
        crate::output::AssociateRouteTableOutput,
        crate::error::AssociateRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_route_table_error(response)
        } else {
            crate::operation_deser::parse_associate_route_table_response(response)
        }
    }
}

/// Operation shape for `AssociateSubnetCidrBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_subnet_cidr_block`](crate::client::Client::associate_subnet_cidr_block).
///
/// See [`crate::client::fluent_builders::AssociateSubnetCidrBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateSubnetCidrBlock {
    _private: (),
}
impl AssociateSubnetCidrBlock {
    /// Creates a new builder-style object to manufacture [`AssociateSubnetCidrBlockInput`](crate::input::AssociateSubnetCidrBlockInput)
    pub fn builder() -> crate::input::associate_subnet_cidr_block_input::Builder {
        crate::input::associate_subnet_cidr_block_input::Builder::default()
    }
    /// Creates a new `AssociateSubnetCidrBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateSubnetCidrBlock {
    type Output = std::result::Result<
        crate::output::AssociateSubnetCidrBlockOutput,
        crate::error::AssociateSubnetCidrBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_subnet_cidr_block_error(response)
        } else {
            crate::operation_deser::parse_associate_subnet_cidr_block_response(response)
        }
    }
}

/// Operation shape for `AssociateTransitGatewayMulticastDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_transit_gateway_multicast_domain`](crate::client::Client::associate_transit_gateway_multicast_domain).
///
/// See [`crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTransitGatewayMulticastDomain {
    _private: (),
}
impl AssociateTransitGatewayMulticastDomain {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayMulticastDomainInput`](crate::input::AssociateTransitGatewayMulticastDomainInput)
    pub fn builder() -> crate::input::associate_transit_gateway_multicast_domain_input::Builder {
        crate::input::associate_transit_gateway_multicast_domain_input::Builder::default()
    }
    /// Creates a new `AssociateTransitGatewayMulticastDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTransitGatewayMulticastDomain {
    type Output = std::result::Result<
        crate::output::AssociateTransitGatewayMulticastDomainOutput,
        crate::error::AssociateTransitGatewayMulticastDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_transit_gateway_multicast_domain_error(response)
        } else {
            crate::operation_deser::parse_associate_transit_gateway_multicast_domain_response(
                response,
            )
        }
    }
}

/// Operation shape for `AssociateTransitGatewayRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_transit_gateway_route_table`](crate::client::Client::associate_transit_gateway_route_table).
///
/// See [`crate::client::fluent_builders::AssociateTransitGatewayRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTransitGatewayRouteTable {
    _private: (),
}
impl AssociateTransitGatewayRouteTable {
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayRouteTableInput`](crate::input::AssociateTransitGatewayRouteTableInput)
    pub fn builder() -> crate::input::associate_transit_gateway_route_table_input::Builder {
        crate::input::associate_transit_gateway_route_table_input::Builder::default()
    }
    /// Creates a new `AssociateTransitGatewayRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTransitGatewayRouteTable {
    type Output = std::result::Result<
        crate::output::AssociateTransitGatewayRouteTableOutput,
        crate::error::AssociateTransitGatewayRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_transit_gateway_route_table_error(response)
        } else {
            crate::operation_deser::parse_associate_transit_gateway_route_table_response(response)
        }
    }
}

/// Operation shape for `AssociateTrunkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_trunk_interface`](crate::client::Client::associate_trunk_interface).
///
/// See [`crate::client::fluent_builders::AssociateTrunkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTrunkInterface {
    _private: (),
}
impl AssociateTrunkInterface {
    /// Creates a new builder-style object to manufacture [`AssociateTrunkInterfaceInput`](crate::input::AssociateTrunkInterfaceInput)
    pub fn builder() -> crate::input::associate_trunk_interface_input::Builder {
        crate::input::associate_trunk_interface_input::Builder::default()
    }
    /// Creates a new `AssociateTrunkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTrunkInterface {
    type Output = std::result::Result<
        crate::output::AssociateTrunkInterfaceOutput,
        crate::error::AssociateTrunkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_trunk_interface_error(response)
        } else {
            crate::operation_deser::parse_associate_trunk_interface_response(response)
        }
    }
}

/// Operation shape for `AssociateVpcCidrBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_vpc_cidr_block`](crate::client::Client::associate_vpc_cidr_block).
///
/// See [`crate::client::fluent_builders::AssociateVpcCidrBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateVpcCidrBlock {
    _private: (),
}
impl AssociateVpcCidrBlock {
    /// Creates a new builder-style object to manufacture [`AssociateVpcCidrBlockInput`](crate::input::AssociateVpcCidrBlockInput)
    pub fn builder() -> crate::input::associate_vpc_cidr_block_input::Builder {
        crate::input::associate_vpc_cidr_block_input::Builder::default()
    }
    /// Creates a new `AssociateVpcCidrBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateVpcCidrBlock {
    type Output = std::result::Result<
        crate::output::AssociateVpcCidrBlockOutput,
        crate::error::AssociateVpcCidrBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_vpc_cidr_block_error(response)
        } else {
            crate::operation_deser::parse_associate_vpc_cidr_block_response(response)
        }
    }
}

/// Operation shape for `AttachClassicLinkVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_classic_link_vpc`](crate::client::Client::attach_classic_link_vpc).
///
/// See [`crate::client::fluent_builders::AttachClassicLinkVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachClassicLinkVpc {
    _private: (),
}
impl AttachClassicLinkVpc {
    /// Creates a new builder-style object to manufacture [`AttachClassicLinkVpcInput`](crate::input::AttachClassicLinkVpcInput)
    pub fn builder() -> crate::input::attach_classic_link_vpc_input::Builder {
        crate::input::attach_classic_link_vpc_input::Builder::default()
    }
    /// Creates a new `AttachClassicLinkVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachClassicLinkVpc {
    type Output = std::result::Result<
        crate::output::AttachClassicLinkVpcOutput,
        crate::error::AttachClassicLinkVpcError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_classic_link_vpc_error(response)
        } else {
            crate::operation_deser::parse_attach_classic_link_vpc_response(response)
        }
    }
}

/// Operation shape for `AttachInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_internet_gateway`](crate::client::Client::attach_internet_gateway).
///
/// See [`crate::client::fluent_builders::AttachInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachInternetGateway {
    _private: (),
}
impl AttachInternetGateway {
    /// Creates a new builder-style object to manufacture [`AttachInternetGatewayInput`](crate::input::AttachInternetGatewayInput)
    pub fn builder() -> crate::input::attach_internet_gateway_input::Builder {
        crate::input::attach_internet_gateway_input::Builder::default()
    }
    /// Creates a new `AttachInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachInternetGateway {
    type Output = std::result::Result<
        crate::output::AttachInternetGatewayOutput,
        crate::error::AttachInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_attach_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `AttachNetworkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_network_interface`](crate::client::Client::attach_network_interface).
///
/// See [`crate::client::fluent_builders::AttachNetworkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachNetworkInterface {
    _private: (),
}
impl AttachNetworkInterface {
    /// Creates a new builder-style object to manufacture [`AttachNetworkInterfaceInput`](crate::input::AttachNetworkInterfaceInput)
    pub fn builder() -> crate::input::attach_network_interface_input::Builder {
        crate::input::attach_network_interface_input::Builder::default()
    }
    /// Creates a new `AttachNetworkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachNetworkInterface {
    type Output = std::result::Result<
        crate::output::AttachNetworkInterfaceOutput,
        crate::error::AttachNetworkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_network_interface_error(response)
        } else {
            crate::operation_deser::parse_attach_network_interface_response(response)
        }
    }
}

/// Operation shape for `AttachVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_volume`](crate::client::Client::attach_volume).
///
/// See [`crate::client::fluent_builders::AttachVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachVolume {
    _private: (),
}
impl AttachVolume {
    /// Creates a new builder-style object to manufacture [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    pub fn builder() -> crate::input::attach_volume_input::Builder {
        crate::input::attach_volume_input::Builder::default()
    }
    /// Creates a new `AttachVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachVolume {
    type Output =
        std::result::Result<crate::output::AttachVolumeOutput, crate::error::AttachVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_volume_error(response)
        } else {
            crate::operation_deser::parse_attach_volume_response(response)
        }
    }
}

/// Operation shape for `AttachVpnGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_vpn_gateway`](crate::client::Client::attach_vpn_gateway).
///
/// See [`crate::client::fluent_builders::AttachVpnGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachVpnGateway {
    _private: (),
}
impl AttachVpnGateway {
    /// Creates a new builder-style object to manufacture [`AttachVpnGatewayInput`](crate::input::AttachVpnGatewayInput)
    pub fn builder() -> crate::input::attach_vpn_gateway_input::Builder {
        crate::input::attach_vpn_gateway_input::Builder::default()
    }
    /// Creates a new `AttachVpnGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachVpnGateway {
    type Output = std::result::Result<
        crate::output::AttachVpnGatewayOutput,
        crate::error::AttachVpnGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_vpn_gateway_error(response)
        } else {
            crate::operation_deser::parse_attach_vpn_gateway_response(response)
        }
    }
}

/// Operation shape for `AuthorizeClientVpnIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_client_vpn_ingress`](crate::client::Client::authorize_client_vpn_ingress).
///
/// See [`crate::client::fluent_builders::AuthorizeClientVpnIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeClientVpnIngress {
    _private: (),
}
impl AuthorizeClientVpnIngress {
    /// Creates a new builder-style object to manufacture [`AuthorizeClientVpnIngressInput`](crate::input::AuthorizeClientVpnIngressInput)
    pub fn builder() -> crate::input::authorize_client_vpn_ingress_input::Builder {
        crate::input::authorize_client_vpn_ingress_input::Builder::default()
    }
    /// Creates a new `AuthorizeClientVpnIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeClientVpnIngress {
    type Output = std::result::Result<
        crate::output::AuthorizeClientVpnIngressOutput,
        crate::error::AuthorizeClientVpnIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_client_vpn_ingress_error(response)
        } else {
            crate::operation_deser::parse_authorize_client_vpn_ingress_response(response)
        }
    }
}

/// Operation shape for `AuthorizeSecurityGroupEgress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_security_group_egress`](crate::client::Client::authorize_security_group_egress).
///
/// See [`crate::client::fluent_builders::AuthorizeSecurityGroupEgress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeSecurityGroupEgress {
    _private: (),
}
impl AuthorizeSecurityGroupEgress {
    /// Creates a new builder-style object to manufacture [`AuthorizeSecurityGroupEgressInput`](crate::input::AuthorizeSecurityGroupEgressInput)
    pub fn builder() -> crate::input::authorize_security_group_egress_input::Builder {
        crate::input::authorize_security_group_egress_input::Builder::default()
    }
    /// Creates a new `AuthorizeSecurityGroupEgress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeSecurityGroupEgress {
    type Output = std::result::Result<
        crate::output::AuthorizeSecurityGroupEgressOutput,
        crate::error::AuthorizeSecurityGroupEgressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_security_group_egress_error(response)
        } else {
            crate::operation_deser::parse_authorize_security_group_egress_response(response)
        }
    }
}

/// Operation shape for `AuthorizeSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_security_group_ingress`](crate::client::Client::authorize_security_group_ingress).
///
/// See [`crate::client::fluent_builders::AuthorizeSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeSecurityGroupIngress {
    _private: (),
}
impl AuthorizeSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`AuthorizeSecurityGroupIngressInput`](crate::input::AuthorizeSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_security_group_ingress_input::Builder {
        crate::input::authorize_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `AuthorizeSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::AuthorizeSecurityGroupIngressOutput,
        crate::error::AuthorizeSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_authorize_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `BundleInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`bundle_instance`](crate::client::Client::bundle_instance).
///
/// See [`crate::client::fluent_builders::BundleInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BundleInstance {
    _private: (),
}
impl BundleInstance {
    /// Creates a new builder-style object to manufacture [`BundleInstanceInput`](crate::input::BundleInstanceInput)
    pub fn builder() -> crate::input::bundle_instance_input::Builder {
        crate::input::bundle_instance_input::Builder::default()
    }
    /// Creates a new `BundleInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BundleInstance {
    type Output =
        std::result::Result<crate::output::BundleInstanceOutput, crate::error::BundleInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_bundle_instance_error(response)
        } else {
            crate::operation_deser::parse_bundle_instance_response(response)
        }
    }
}

/// Operation shape for `CancelBundleTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_bundle_task`](crate::client::Client::cancel_bundle_task).
///
/// See [`crate::client::fluent_builders::CancelBundleTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelBundleTask {
    _private: (),
}
impl CancelBundleTask {
    /// Creates a new builder-style object to manufacture [`CancelBundleTaskInput`](crate::input::CancelBundleTaskInput)
    pub fn builder() -> crate::input::cancel_bundle_task_input::Builder {
        crate::input::cancel_bundle_task_input::Builder::default()
    }
    /// Creates a new `CancelBundleTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelBundleTask {
    type Output = std::result::Result<
        crate::output::CancelBundleTaskOutput,
        crate::error::CancelBundleTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_bundle_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_bundle_task_response(response)
        }
    }
}

/// Operation shape for `CancelCapacityReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_capacity_reservation`](crate::client::Client::cancel_capacity_reservation).
///
/// See [`crate::client::fluent_builders::CancelCapacityReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelCapacityReservation {
    _private: (),
}
impl CancelCapacityReservation {
    /// Creates a new builder-style object to manufacture [`CancelCapacityReservationInput`](crate::input::CancelCapacityReservationInput)
    pub fn builder() -> crate::input::cancel_capacity_reservation_input::Builder {
        crate::input::cancel_capacity_reservation_input::Builder::default()
    }
    /// Creates a new `CancelCapacityReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelCapacityReservation {
    type Output = std::result::Result<
        crate::output::CancelCapacityReservationOutput,
        crate::error::CancelCapacityReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_capacity_reservation_error(response)
        } else {
            crate::operation_deser::parse_cancel_capacity_reservation_response(response)
        }
    }
}

/// Operation shape for `CancelCapacityReservationFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_capacity_reservation_fleets`](crate::client::Client::cancel_capacity_reservation_fleets).
///
/// See [`crate::client::fluent_builders::CancelCapacityReservationFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelCapacityReservationFleets {
    _private: (),
}
impl CancelCapacityReservationFleets {
    /// Creates a new builder-style object to manufacture [`CancelCapacityReservationFleetsInput`](crate::input::CancelCapacityReservationFleetsInput)
    pub fn builder() -> crate::input::cancel_capacity_reservation_fleets_input::Builder {
        crate::input::cancel_capacity_reservation_fleets_input::Builder::default()
    }
    /// Creates a new `CancelCapacityReservationFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelCapacityReservationFleets {
    type Output = std::result::Result<
        crate::output::CancelCapacityReservationFleetsOutput,
        crate::error::CancelCapacityReservationFleetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_capacity_reservation_fleets_error(response)
        } else {
            crate::operation_deser::parse_cancel_capacity_reservation_fleets_response(response)
        }
    }
}

/// Operation shape for `CancelConversionTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_conversion_task`](crate::client::Client::cancel_conversion_task).
///
/// See [`crate::client::fluent_builders::CancelConversionTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelConversionTask {
    _private: (),
}
impl CancelConversionTask {
    /// Creates a new builder-style object to manufacture [`CancelConversionTaskInput`](crate::input::CancelConversionTaskInput)
    pub fn builder() -> crate::input::cancel_conversion_task_input::Builder {
        crate::input::cancel_conversion_task_input::Builder::default()
    }
    /// Creates a new `CancelConversionTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelConversionTask {
    type Output = std::result::Result<
        crate::output::CancelConversionTaskOutput,
        crate::error::CancelConversionTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_conversion_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_conversion_task_response(response)
        }
    }
}

/// Operation shape for `CancelExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_export_task`](crate::client::Client::cancel_export_task).
///
/// See [`crate::client::fluent_builders::CancelExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelExportTask {
    _private: (),
}
impl CancelExportTask {
    /// Creates a new builder-style object to manufacture [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    pub fn builder() -> crate::input::cancel_export_task_input::Builder {
        crate::input::cancel_export_task_input::Builder::default()
    }
    /// Creates a new `CancelExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelExportTask {
    type Output = std::result::Result<
        crate::output::CancelExportTaskOutput,
        crate::error::CancelExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_export_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_export_task_response(response)
        }
    }
}

/// Operation shape for `CancelImportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_import_task`](crate::client::Client::cancel_import_task).
///
/// See [`crate::client::fluent_builders::CancelImportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelImportTask {
    _private: (),
}
impl CancelImportTask {
    /// Creates a new builder-style object to manufacture [`CancelImportTaskInput`](crate::input::CancelImportTaskInput)
    pub fn builder() -> crate::input::cancel_import_task_input::Builder {
        crate::input::cancel_import_task_input::Builder::default()
    }
    /// Creates a new `CancelImportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelImportTask {
    type Output = std::result::Result<
        crate::output::CancelImportTaskOutput,
        crate::error::CancelImportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_import_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_import_task_response(response)
        }
    }
}

/// Operation shape for `CancelReservedInstancesListing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_reserved_instances_listing`](crate::client::Client::cancel_reserved_instances_listing).
///
/// See [`crate::client::fluent_builders::CancelReservedInstancesListing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelReservedInstancesListing {
    _private: (),
}
impl CancelReservedInstancesListing {
    /// Creates a new builder-style object to manufacture [`CancelReservedInstancesListingInput`](crate::input::CancelReservedInstancesListingInput)
    pub fn builder() -> crate::input::cancel_reserved_instances_listing_input::Builder {
        crate::input::cancel_reserved_instances_listing_input::Builder::default()
    }
    /// Creates a new `CancelReservedInstancesListing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelReservedInstancesListing {
    type Output = std::result::Result<
        crate::output::CancelReservedInstancesListingOutput,
        crate::error::CancelReservedInstancesListingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_reserved_instances_listing_error(response)
        } else {
            crate::operation_deser::parse_cancel_reserved_instances_listing_response(response)
        }
    }
}

/// Operation shape for `CancelSpotFleetRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_spot_fleet_requests`](crate::client::Client::cancel_spot_fleet_requests).
///
/// See [`crate::client::fluent_builders::CancelSpotFleetRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSpotFleetRequests {
    _private: (),
}
impl CancelSpotFleetRequests {
    /// Creates a new builder-style object to manufacture [`CancelSpotFleetRequestsInput`](crate::input::CancelSpotFleetRequestsInput)
    pub fn builder() -> crate::input::cancel_spot_fleet_requests_input::Builder {
        crate::input::cancel_spot_fleet_requests_input::Builder::default()
    }
    /// Creates a new `CancelSpotFleetRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSpotFleetRequests {
    type Output = std::result::Result<
        crate::output::CancelSpotFleetRequestsOutput,
        crate::error::CancelSpotFleetRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_spot_fleet_requests_error(response)
        } else {
            crate::operation_deser::parse_cancel_spot_fleet_requests_response(response)
        }
    }
}

/// Operation shape for `CancelSpotInstanceRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_spot_instance_requests`](crate::client::Client::cancel_spot_instance_requests).
///
/// See [`crate::client::fluent_builders::CancelSpotInstanceRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSpotInstanceRequests {
    _private: (),
}
impl CancelSpotInstanceRequests {
    /// Creates a new builder-style object to manufacture [`CancelSpotInstanceRequestsInput`](crate::input::CancelSpotInstanceRequestsInput)
    pub fn builder() -> crate::input::cancel_spot_instance_requests_input::Builder {
        crate::input::cancel_spot_instance_requests_input::Builder::default()
    }
    /// Creates a new `CancelSpotInstanceRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSpotInstanceRequests {
    type Output = std::result::Result<
        crate::output::CancelSpotInstanceRequestsOutput,
        crate::error::CancelSpotInstanceRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_spot_instance_requests_error(response)
        } else {
            crate::operation_deser::parse_cancel_spot_instance_requests_response(response)
        }
    }
}

/// Operation shape for `ConfirmProductInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`confirm_product_instance`](crate::client::Client::confirm_product_instance).
///
/// See [`crate::client::fluent_builders::ConfirmProductInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ConfirmProductInstance {
    _private: (),
}
impl ConfirmProductInstance {
    /// Creates a new builder-style object to manufacture [`ConfirmProductInstanceInput`](crate::input::ConfirmProductInstanceInput)
    pub fn builder() -> crate::input::confirm_product_instance_input::Builder {
        crate::input::confirm_product_instance_input::Builder::default()
    }
    /// Creates a new `ConfirmProductInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ConfirmProductInstance {
    type Output = std::result::Result<
        crate::output::ConfirmProductInstanceOutput,
        crate::error::ConfirmProductInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_confirm_product_instance_error(response)
        } else {
            crate::operation_deser::parse_confirm_product_instance_response(response)
        }
    }
}

/// Operation shape for `CopyFpgaImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_fpga_image`](crate::client::Client::copy_fpga_image).
///
/// See [`crate::client::fluent_builders::CopyFpgaImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyFpgaImage {
    _private: (),
}
impl CopyFpgaImage {
    /// Creates a new builder-style object to manufacture [`CopyFpgaImageInput`](crate::input::CopyFpgaImageInput)
    pub fn builder() -> crate::input::copy_fpga_image_input::Builder {
        crate::input::copy_fpga_image_input::Builder::default()
    }
    /// Creates a new `CopyFpgaImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyFpgaImage {
    type Output =
        std::result::Result<crate::output::CopyFpgaImageOutput, crate::error::CopyFpgaImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_fpga_image_error(response)
        } else {
            crate::operation_deser::parse_copy_fpga_image_response(response)
        }
    }
}

/// Operation shape for `CopyImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_image`](crate::client::Client::copy_image).
///
/// See [`crate::client::fluent_builders::CopyImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyImage {
    _private: (),
}
impl CopyImage {
    /// Creates a new builder-style object to manufacture [`CopyImageInput`](crate::input::CopyImageInput)
    pub fn builder() -> crate::input::copy_image_input::Builder {
        crate::input::copy_image_input::Builder::default()
    }
    /// Creates a new `CopyImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyImage {
    type Output = std::result::Result<crate::output::CopyImageOutput, crate::error::CopyImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_image_error(response)
        } else {
            crate::operation_deser::parse_copy_image_response(response)
        }
    }
}

/// Operation shape for `CopySnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_snapshot`](crate::client::Client::copy_snapshot).
///
/// See [`crate::client::fluent_builders::CopySnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopySnapshot {
    _private: (),
}
impl CopySnapshot {
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
    /// Creates a new `CopySnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopySnapshot {
    type Output =
        std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateCapacityReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_capacity_reservation`](crate::client::Client::create_capacity_reservation).
///
/// See [`crate::client::fluent_builders::CreateCapacityReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCapacityReservation {
    _private: (),
}
impl CreateCapacityReservation {
    /// Creates a new builder-style object to manufacture [`CreateCapacityReservationInput`](crate::input::CreateCapacityReservationInput)
    pub fn builder() -> crate::input::create_capacity_reservation_input::Builder {
        crate::input::create_capacity_reservation_input::Builder::default()
    }
    /// Creates a new `CreateCapacityReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCapacityReservation {
    type Output = std::result::Result<
        crate::output::CreateCapacityReservationOutput,
        crate::error::CreateCapacityReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_capacity_reservation_error(response)
        } else {
            crate::operation_deser::parse_create_capacity_reservation_response(response)
        }
    }
}

/// Operation shape for `CreateCapacityReservationFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_capacity_reservation_fleet`](crate::client::Client::create_capacity_reservation_fleet).
///
/// See [`crate::client::fluent_builders::CreateCapacityReservationFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCapacityReservationFleet {
    _private: (),
}
impl CreateCapacityReservationFleet {
    /// Creates a new builder-style object to manufacture [`CreateCapacityReservationFleetInput`](crate::input::CreateCapacityReservationFleetInput)
    pub fn builder() -> crate::input::create_capacity_reservation_fleet_input::Builder {
        crate::input::create_capacity_reservation_fleet_input::Builder::default()
    }
    /// Creates a new `CreateCapacityReservationFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCapacityReservationFleet {
    type Output = std::result::Result<
        crate::output::CreateCapacityReservationFleetOutput,
        crate::error::CreateCapacityReservationFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_capacity_reservation_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_capacity_reservation_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateCarrierGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_carrier_gateway`](crate::client::Client::create_carrier_gateway).
///
/// See [`crate::client::fluent_builders::CreateCarrierGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCarrierGateway {
    _private: (),
}
impl CreateCarrierGateway {
    /// Creates a new builder-style object to manufacture [`CreateCarrierGatewayInput`](crate::input::CreateCarrierGatewayInput)
    pub fn builder() -> crate::input::create_carrier_gateway_input::Builder {
        crate::input::create_carrier_gateway_input::Builder::default()
    }
    /// Creates a new `CreateCarrierGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCarrierGateway {
    type Output = std::result::Result<
        crate::output::CreateCarrierGatewayOutput,
        crate::error::CreateCarrierGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_carrier_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_carrier_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateClientVpnEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_client_vpn_endpoint`](crate::client::Client::create_client_vpn_endpoint).
///
/// See [`crate::client::fluent_builders::CreateClientVpnEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClientVpnEndpoint {
    _private: (),
}
impl CreateClientVpnEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateClientVpnEndpointInput`](crate::input::CreateClientVpnEndpointInput)
    pub fn builder() -> crate::input::create_client_vpn_endpoint_input::Builder {
        crate::input::create_client_vpn_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateClientVpnEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClientVpnEndpoint {
    type Output = std::result::Result<
        crate::output::CreateClientVpnEndpointOutput,
        crate::error::CreateClientVpnEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_client_vpn_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_client_vpn_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateClientVpnRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_client_vpn_route`](crate::client::Client::create_client_vpn_route).
///
/// See [`crate::client::fluent_builders::CreateClientVpnRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClientVpnRoute {
    _private: (),
}
impl CreateClientVpnRoute {
    /// Creates a new builder-style object to manufacture [`CreateClientVpnRouteInput`](crate::input::CreateClientVpnRouteInput)
    pub fn builder() -> crate::input::create_client_vpn_route_input::Builder {
        crate::input::create_client_vpn_route_input::Builder::default()
    }
    /// Creates a new `CreateClientVpnRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClientVpnRoute {
    type Output = std::result::Result<
        crate::output::CreateClientVpnRouteOutput,
        crate::error::CreateClientVpnRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_client_vpn_route_error(response)
        } else {
            crate::operation_deser::parse_create_client_vpn_route_response(response)
        }
    }
}

/// Operation shape for `CreateCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_customer_gateway`](crate::client::Client::create_customer_gateway).
///
/// See [`crate::client::fluent_builders::CreateCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomerGateway {
    _private: (),
}
impl CreateCustomerGateway {
    /// Creates a new builder-style object to manufacture [`CreateCustomerGatewayInput`](crate::input::CreateCustomerGatewayInput)
    pub fn builder() -> crate::input::create_customer_gateway_input::Builder {
        crate::input::create_customer_gateway_input::Builder::default()
    }
    /// Creates a new `CreateCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomerGateway {
    type Output = std::result::Result<
        crate::output::CreateCustomerGatewayOutput,
        crate::error::CreateCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateDefaultSubnet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_default_subnet`](crate::client::Client::create_default_subnet).
///
/// See [`crate::client::fluent_builders::CreateDefaultSubnet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDefaultSubnet {
    _private: (),
}
impl CreateDefaultSubnet {
    /// Creates a new builder-style object to manufacture [`CreateDefaultSubnetInput`](crate::input::CreateDefaultSubnetInput)
    pub fn builder() -> crate::input::create_default_subnet_input::Builder {
        crate::input::create_default_subnet_input::Builder::default()
    }
    /// Creates a new `CreateDefaultSubnet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDefaultSubnet {
    type Output = std::result::Result<
        crate::output::CreateDefaultSubnetOutput,
        crate::error::CreateDefaultSubnetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_default_subnet_error(response)
        } else {
            crate::operation_deser::parse_create_default_subnet_response(response)
        }
    }
}

/// Operation shape for `CreateDefaultVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_default_vpc`](crate::client::Client::create_default_vpc).
///
/// See [`crate::client::fluent_builders::CreateDefaultVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDefaultVpc {
    _private: (),
}
impl CreateDefaultVpc {
    /// Creates a new builder-style object to manufacture [`CreateDefaultVpcInput`](crate::input::CreateDefaultVpcInput)
    pub fn builder() -> crate::input::create_default_vpc_input::Builder {
        crate::input::create_default_vpc_input::Builder::default()
    }
    /// Creates a new `CreateDefaultVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDefaultVpc {
    type Output = std::result::Result<
        crate::output::CreateDefaultVpcOutput,
        crate::error::CreateDefaultVpcError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_default_vpc_error(response)
        } else {
            crate::operation_deser::parse_create_default_vpc_response(response)
        }
    }
}

/// Operation shape for `CreateDhcpOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dhcp_options`](crate::client::Client::create_dhcp_options).
///
/// See [`crate::client::fluent_builders::CreateDhcpOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDhcpOptions {
    _private: (),
}
impl CreateDhcpOptions {
    /// Creates a new builder-style object to manufacture [`CreateDhcpOptionsInput`](crate::input::CreateDhcpOptionsInput)
    pub fn builder() -> crate::input::create_dhcp_options_input::Builder {
        crate::input::create_dhcp_options_input::Builder::default()
    }
    /// Creates a new `CreateDhcpOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDhcpOptions {
    type Output = std::result::Result<
        crate::output::CreateDhcpOptionsOutput,
        crate::error::CreateDhcpOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dhcp_options_error(response)
        } else {
            crate::operation_deser::parse_create_dhcp_options_response(response)
        }
    }
}

/// Operation shape for `CreateEgressOnlyInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_egress_only_internet_gateway`](crate::client::Client::create_egress_only_internet_gateway).
///
/// See [`crate::client::fluent_builders::CreateEgressOnlyInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEgressOnlyInternetGateway {
    _private: (),
}
impl CreateEgressOnlyInternetGateway {
    /// Creates a new builder-style object to manufacture [`CreateEgressOnlyInternetGatewayInput`](crate::input::CreateEgressOnlyInternetGatewayInput)
    pub fn builder() -> crate::input::create_egress_only_internet_gateway_input::Builder {
        crate::input::create_egress_only_internet_gateway_input::Builder::default()
    }
    /// Creates a new `CreateEgressOnlyInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEgressOnlyInternetGateway {
    type Output = std::result::Result<
        crate::output::CreateEgressOnlyInternetGatewayOutput,
        crate::error::CreateEgressOnlyInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_egress_only_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_egress_only_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet`](crate::client::Client::create_fleet).
///
/// See [`crate::client::fluent_builders::CreateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleet {
    _private: (),
}
impl CreateFleet {
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
    /// Creates a new `CreateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleet {
    type Output =
        std::result::Result<crate::output::CreateFleetOutput, crate::error::CreateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateFlowLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_flow_logs`](crate::client::Client::create_flow_logs).
///
/// See [`crate::client::fluent_builders::CreateFlowLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFlowLogs {
    _private: (),
}
impl CreateFlowLogs {
    /// Creates a new builder-style object to manufacture [`CreateFlowLogsInput`](crate::input::CreateFlowLogsInput)
    pub fn builder() -> crate::input::create_flow_logs_input::Builder {
        crate::input::create_flow_logs_input::Builder::default()
    }
    /// Creates a new `CreateFlowLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFlowLogs {
    type Output =
        std::result::Result<crate::output::CreateFlowLogsOutput, crate::error::CreateFlowLogsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_flow_logs_error(response)
        } else {
            crate::operation_deser::parse_create_flow_logs_response(response)
        }
    }
}

/// Operation shape for `CreateFpgaImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fpga_image`](crate::client::Client::create_fpga_image).
///
/// See [`crate::client::fluent_builders::CreateFpgaImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFpgaImage {
    _private: (),
}
impl CreateFpgaImage {
    /// Creates a new builder-style object to manufacture [`CreateFpgaImageInput`](crate::input::CreateFpgaImageInput)
    pub fn builder() -> crate::input::create_fpga_image_input::Builder {
        crate::input::create_fpga_image_input::Builder::default()
    }
    /// Creates a new `CreateFpgaImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFpgaImage {
    type Output = std::result::Result<
        crate::output::CreateFpgaImageOutput,
        crate::error::CreateFpgaImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fpga_image_error(response)
        } else {
            crate::operation_deser::parse_create_fpga_image_response(response)
        }
    }
}

/// Operation shape for `CreateImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image`](crate::client::Client::create_image).
///
/// See [`crate::client::fluent_builders::CreateImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImage {
    _private: (),
}
impl CreateImage {
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
    /// Creates a new `CreateImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImage {
    type Output =
        std::result::Result<crate::output::CreateImageOutput, crate::error::CreateImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_error(response)
        } else {
            crate::operation_deser::parse_create_image_response(response)
        }
    }
}

/// Operation shape for `CreateInstanceEventWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance_event_window`](crate::client::Client::create_instance_event_window).
///
/// See [`crate::client::fluent_builders::CreateInstanceEventWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstanceEventWindow {
    _private: (),
}
impl CreateInstanceEventWindow {
    /// Creates a new builder-style object to manufacture [`CreateInstanceEventWindowInput`](crate::input::CreateInstanceEventWindowInput)
    pub fn builder() -> crate::input::create_instance_event_window_input::Builder {
        crate::input::create_instance_event_window_input::Builder::default()
    }
    /// Creates a new `CreateInstanceEventWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstanceEventWindow {
    type Output = std::result::Result<
        crate::output::CreateInstanceEventWindowOutput,
        crate::error::CreateInstanceEventWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_event_window_error(response)
        } else {
            crate::operation_deser::parse_create_instance_event_window_response(response)
        }
    }
}

/// Operation shape for `CreateInstanceExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance_export_task`](crate::client::Client::create_instance_export_task).
///
/// See [`crate::client::fluent_builders::CreateInstanceExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstanceExportTask {
    _private: (),
}
impl CreateInstanceExportTask {
    /// Creates a new builder-style object to manufacture [`CreateInstanceExportTaskInput`](crate::input::CreateInstanceExportTaskInput)
    pub fn builder() -> crate::input::create_instance_export_task_input::Builder {
        crate::input::create_instance_export_task_input::Builder::default()
    }
    /// Creates a new `CreateInstanceExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstanceExportTask {
    type Output = std::result::Result<
        crate::output::CreateInstanceExportTaskOutput,
        crate::error::CreateInstanceExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_export_task_error(response)
        } else {
            crate::operation_deser::parse_create_instance_export_task_response(response)
        }
    }
}

/// Operation shape for `CreateInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_internet_gateway`](crate::client::Client::create_internet_gateway).
///
/// See [`crate::client::fluent_builders::CreateInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInternetGateway {
    _private: (),
}
impl CreateInternetGateway {
    /// Creates a new builder-style object to manufacture [`CreateInternetGatewayInput`](crate::input::CreateInternetGatewayInput)
    pub fn builder() -> crate::input::create_internet_gateway_input::Builder {
        crate::input::create_internet_gateway_input::Builder::default()
    }
    /// Creates a new `CreateInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInternetGateway {
    type Output = std::result::Result<
        crate::output::CreateInternetGatewayOutput,
        crate::error::CreateInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateIpam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ipam`](crate::client::Client::create_ipam).
///
/// See [`crate::client::fluent_builders::CreateIpam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIpam {
    _private: (),
}
impl CreateIpam {
    /// Creates a new builder-style object to manufacture [`CreateIpamInput`](crate::input::CreateIpamInput)
    pub fn builder() -> crate::input::create_ipam_input::Builder {
        crate::input::create_ipam_input::Builder::default()
    }
    /// Creates a new `CreateIpam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIpam {
    type Output =
        std::result::Result<crate::output::CreateIpamOutput, crate::error::CreateIpamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ipam_error(response)
        } else {
            crate::operation_deser::parse_create_ipam_response(response)
        }
    }
}

/// Operation shape for `CreateIpamPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ipam_pool`](crate::client::Client::create_ipam_pool).
///
/// See [`crate::client::fluent_builders::CreateIpamPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIpamPool {
    _private: (),
}
impl CreateIpamPool {
    /// Creates a new builder-style object to manufacture [`CreateIpamPoolInput`](crate::input::CreateIpamPoolInput)
    pub fn builder() -> crate::input::create_ipam_pool_input::Builder {
        crate::input::create_ipam_pool_input::Builder::default()
    }
    /// Creates a new `CreateIpamPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIpamPool {
    type Output =
        std::result::Result<crate::output::CreateIpamPoolOutput, crate::error::CreateIpamPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ipam_pool_error(response)
        } else {
            crate::operation_deser::parse_create_ipam_pool_response(response)
        }
    }
}

/// Operation shape for `CreateIpamScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ipam_scope`](crate::client::Client::create_ipam_scope).
///
/// See [`crate::client::fluent_builders::CreateIpamScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIpamScope {
    _private: (),
}
impl CreateIpamScope {
    /// Creates a new builder-style object to manufacture [`CreateIpamScopeInput`](crate::input::CreateIpamScopeInput)
    pub fn builder() -> crate::input::create_ipam_scope_input::Builder {
        crate::input::create_ipam_scope_input::Builder::default()
    }
    /// Creates a new `CreateIpamScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIpamScope {
    type Output = std::result::Result<
        crate::output::CreateIpamScopeOutput,
        crate::error::CreateIpamScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ipam_scope_error(response)
        } else {
            crate::operation_deser::parse_create_ipam_scope_response(response)
        }
    }
}

/// Operation shape for `CreateKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_key_pair`](crate::client::Client::create_key_pair).
///
/// See [`crate::client::fluent_builders::CreateKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKeyPair {
    _private: (),
}
impl CreateKeyPair {
    /// Creates a new builder-style object to manufacture [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    pub fn builder() -> crate::input::create_key_pair_input::Builder {
        crate::input::create_key_pair_input::Builder::default()
    }
    /// Creates a new `CreateKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKeyPair {
    type Output =
        std::result::Result<crate::output::CreateKeyPairOutput, crate::error::CreateKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_key_pair_error(response)
        } else {
            crate::operation_deser::parse_create_key_pair_response(response)
        }
    }
}

/// Operation shape for `CreateLaunchTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_launch_template`](crate::client::Client::create_launch_template).
///
/// See [`crate::client::fluent_builders::CreateLaunchTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLaunchTemplate {
    _private: (),
}
impl CreateLaunchTemplate {
    /// Creates a new builder-style object to manufacture [`CreateLaunchTemplateInput`](crate::input::CreateLaunchTemplateInput)
    pub fn builder() -> crate::input::create_launch_template_input::Builder {
        crate::input::create_launch_template_input::Builder::default()
    }
    /// Creates a new `CreateLaunchTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLaunchTemplate {
    type Output = std::result::Result<
        crate::output::CreateLaunchTemplateOutput,
        crate::error::CreateLaunchTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_launch_template_error(response)
        } else {
            crate::operation_deser::parse_create_launch_template_response(response)
        }
    }
}

/// Operation shape for `CreateLaunchTemplateVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_launch_template_version`](crate::client::Client::create_launch_template_version).
///
/// See [`crate::client::fluent_builders::CreateLaunchTemplateVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLaunchTemplateVersion {
    _private: (),
}
impl CreateLaunchTemplateVersion {
    /// Creates a new builder-style object to manufacture [`CreateLaunchTemplateVersionInput`](crate::input::CreateLaunchTemplateVersionInput)
    pub fn builder() -> crate::input::create_launch_template_version_input::Builder {
        crate::input::create_launch_template_version_input::Builder::default()
    }
    /// Creates a new `CreateLaunchTemplateVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLaunchTemplateVersion {
    type Output = std::result::Result<
        crate::output::CreateLaunchTemplateVersionOutput,
        crate::error::CreateLaunchTemplateVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_launch_template_version_error(response)
        } else {
            crate::operation_deser::parse_create_launch_template_version_response(response)
        }
    }
}

/// Operation shape for `CreateLocalGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_local_gateway_route`](crate::client::Client::create_local_gateway_route).
///
/// See [`crate::client::fluent_builders::CreateLocalGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocalGatewayRoute {
    _private: (),
}
impl CreateLocalGatewayRoute {
    /// Creates a new builder-style object to manufacture [`CreateLocalGatewayRouteInput`](crate::input::CreateLocalGatewayRouteInput)
    pub fn builder() -> crate::input::create_local_gateway_route_input::Builder {
        crate::input::create_local_gateway_route_input::Builder::default()
    }
    /// Creates a new `CreateLocalGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocalGatewayRoute {
    type Output = std::result::Result<
        crate::output::CreateLocalGatewayRouteOutput,
        crate::error::CreateLocalGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_local_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_create_local_gateway_route_response(response)
        }
    }
}

/// Operation shape for `CreateLocalGatewayRouteTableVpcAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_local_gateway_route_table_vpc_association`](crate::client::Client::create_local_gateway_route_table_vpc_association).
///
/// See [`crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLocalGatewayRouteTableVpcAssociation {
    _private: (),
}
impl CreateLocalGatewayRouteTableVpcAssociation {
    /// Creates a new builder-style object to manufacture [`CreateLocalGatewayRouteTableVpcAssociationInput`](crate::input::CreateLocalGatewayRouteTableVpcAssociationInput)
    pub fn builder() -> crate::input::create_local_gateway_route_table_vpc_association_input::Builder
    {
        crate::input::create_local_gateway_route_table_vpc_association_input::Builder::default()
    }
    /// Creates a new `CreateLocalGatewayRouteTableVpcAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLocalGatewayRouteTableVpcAssociation {
    type Output = std::result::Result<
        crate::output::CreateLocalGatewayRouteTableVpcAssociationOutput,
        crate::error::CreateLocalGatewayRouteTableVpcAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_local_gateway_route_table_vpc_association_error(
                response,
            )
        } else {
            crate::operation_deser::parse_create_local_gateway_route_table_vpc_association_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateManagedPrefixList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_managed_prefix_list`](crate::client::Client::create_managed_prefix_list).
///
/// See [`crate::client::fluent_builders::CreateManagedPrefixList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateManagedPrefixList {
    _private: (),
}
impl CreateManagedPrefixList {
    /// Creates a new builder-style object to manufacture [`CreateManagedPrefixListInput`](crate::input::CreateManagedPrefixListInput)
    pub fn builder() -> crate::input::create_managed_prefix_list_input::Builder {
        crate::input::create_managed_prefix_list_input::Builder::default()
    }
    /// Creates a new `CreateManagedPrefixList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateManagedPrefixList {
    type Output = std::result::Result<
        crate::output::CreateManagedPrefixListOutput,
        crate::error::CreateManagedPrefixListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_managed_prefix_list_error(response)
        } else {
            crate::operation_deser::parse_create_managed_prefix_list_response(response)
        }
    }
}

/// Operation shape for `CreateNatGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_nat_gateway`](crate::client::Client::create_nat_gateway).
///
/// See [`crate::client::fluent_builders::CreateNatGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNatGateway {
    _private: (),
}
impl CreateNatGateway {
    /// Creates a new builder-style object to manufacture [`CreateNatGatewayInput`](crate::input::CreateNatGatewayInput)
    pub fn builder() -> crate::input::create_nat_gateway_input::Builder {
        crate::input::create_nat_gateway_input::Builder::default()
    }
    /// Creates a new `CreateNatGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNatGateway {
    type Output = std::result::Result<
        crate::output::CreateNatGatewayOutput,
        crate::error::CreateNatGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_nat_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_nat_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_acl`](crate::client::Client::create_network_acl).
///
/// See [`crate::client::fluent_builders::CreateNetworkAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkAcl {
    _private: (),
}
impl CreateNetworkAcl {
    /// Creates a new builder-style object to manufacture [`CreateNetworkAclInput`](crate::input::CreateNetworkAclInput)
    pub fn builder() -> crate::input::create_network_acl_input::Builder {
        crate::input::create_network_acl_input::Builder::default()
    }
    /// Creates a new `CreateNetworkAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkAcl {
    type Output = std::result::Result<
        crate::output::CreateNetworkAclOutput,
        crate::error::CreateNetworkAclError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_acl_error(response)
        } else {
            crate::operation_deser::parse_create_network_acl_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkAclEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_acl_entry`](crate::client::Client::create_network_acl_entry).
///
/// See [`crate::client::fluent_builders::CreateNetworkAclEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkAclEntry {
    _private: (),
}
impl CreateNetworkAclEntry {
    /// Creates a new builder-style object to manufacture [`CreateNetworkAclEntryInput`](crate::input::CreateNetworkAclEntryInput)
    pub fn builder() -> crate::input::create_network_acl_entry_input::Builder {
        crate::input::create_network_acl_entry_input::Builder::default()
    }
    /// Creates a new `CreateNetworkAclEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkAclEntry {
    type Output = std::result::Result<
        crate::output::CreateNetworkAclEntryOutput,
        crate::error::CreateNetworkAclEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_acl_entry_error(response)
        } else {
            crate::operation_deser::parse_create_network_acl_entry_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkInsightsAccessScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_insights_access_scope`](crate::client::Client::create_network_insights_access_scope).
///
/// See [`crate::client::fluent_builders::CreateNetworkInsightsAccessScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkInsightsAccessScope {
    _private: (),
}
impl CreateNetworkInsightsAccessScope {
    /// Creates a new builder-style object to manufacture [`CreateNetworkInsightsAccessScopeInput`](crate::input::CreateNetworkInsightsAccessScopeInput)
    pub fn builder() -> crate::input::create_network_insights_access_scope_input::Builder {
        crate::input::create_network_insights_access_scope_input::Builder::default()
    }
    /// Creates a new `CreateNetworkInsightsAccessScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkInsightsAccessScope {
    type Output = std::result::Result<
        crate::output::CreateNetworkInsightsAccessScopeOutput,
        crate::error::CreateNetworkInsightsAccessScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_insights_access_scope_error(response)
        } else {
            crate::operation_deser::parse_create_network_insights_access_scope_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkInsightsPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_insights_path`](crate::client::Client::create_network_insights_path).
///
/// See [`crate::client::fluent_builders::CreateNetworkInsightsPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkInsightsPath {
    _private: (),
}
impl CreateNetworkInsightsPath {
    /// Creates a new builder-style object to manufacture [`CreateNetworkInsightsPathInput`](crate::input::CreateNetworkInsightsPathInput)
    pub fn builder() -> crate::input::create_network_insights_path_input::Builder {
        crate::input::create_network_insights_path_input::Builder::default()
    }
    /// Creates a new `CreateNetworkInsightsPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkInsightsPath {
    type Output = std::result::Result<
        crate::output::CreateNetworkInsightsPathOutput,
        crate::error::CreateNetworkInsightsPathError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_insights_path_error(response)
        } else {
            crate::operation_deser::parse_create_network_insights_path_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_interface`](crate::client::Client::create_network_interface).
///
/// See [`crate::client::fluent_builders::CreateNetworkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkInterface {
    _private: (),
}
impl CreateNetworkInterface {
    /// Creates a new builder-style object to manufacture [`CreateNetworkInterfaceInput`](crate::input::CreateNetworkInterfaceInput)
    pub fn builder() -> crate::input::create_network_interface_input::Builder {
        crate::input::create_network_interface_input::Builder::default()
    }
    /// Creates a new `CreateNetworkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkInterface {
    type Output = std::result::Result<
        crate::output::CreateNetworkInterfaceOutput,
        crate::error::CreateNetworkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_interface_error(response)
        } else {
            crate::operation_deser::parse_create_network_interface_response(response)
        }
    }
}

/// Operation shape for `CreateNetworkInterfacePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network_interface_permission`](crate::client::Client::create_network_interface_permission).
///
/// See [`crate::client::fluent_builders::CreateNetworkInterfacePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetworkInterfacePermission {
    _private: (),
}
impl CreateNetworkInterfacePermission {
    /// Creates a new builder-style object to manufacture [`CreateNetworkInterfacePermissionInput`](crate::input::CreateNetworkInterfacePermissionInput)
    pub fn builder() -> crate::input::create_network_interface_permission_input::Builder {
        crate::input::create_network_interface_permission_input::Builder::default()
    }
    /// Creates a new `CreateNetworkInterfacePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetworkInterfacePermission {
    type Output = std::result::Result<
        crate::output::CreateNetworkInterfacePermissionOutput,
        crate::error::CreateNetworkInterfacePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_interface_permission_error(response)
        } else {
            crate::operation_deser::parse_create_network_interface_permission_response(response)
        }
    }
}

/// Operation shape for `CreatePlacementGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_placement_group`](crate::client::Client::create_placement_group).
///
/// See [`crate::client::fluent_builders::CreatePlacementGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlacementGroup {
    _private: (),
}
impl CreatePlacementGroup {
    /// Creates a new builder-style object to manufacture [`CreatePlacementGroupInput`](crate::input::CreatePlacementGroupInput)
    pub fn builder() -> crate::input::create_placement_group_input::Builder {
        crate::input::create_placement_group_input::Builder::default()
    }
    /// Creates a new `CreatePlacementGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlacementGroup {
    type Output = std::result::Result<
        crate::output::CreatePlacementGroupOutput,
        crate::error::CreatePlacementGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_placement_group_error(response)
        } else {
            crate::operation_deser::parse_create_placement_group_response(response)
        }
    }
}

/// Operation shape for `CreatePublicIpv4Pool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_public_ipv4_pool`](crate::client::Client::create_public_ipv4_pool).
///
/// See [`crate::client::fluent_builders::CreatePublicIpv4Pool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePublicIpv4Pool {
    _private: (),
}
impl CreatePublicIpv4Pool {
    /// Creates a new builder-style object to manufacture [`CreatePublicIpv4PoolInput`](crate::input::CreatePublicIpv4PoolInput)
    pub fn builder() -> crate::input::create_public_ipv4_pool_input::Builder {
        crate::input::create_public_ipv4_pool_input::Builder::default()
    }
    /// Creates a new `CreatePublicIpv4Pool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePublicIpv4Pool {
    type Output = std::result::Result<
        crate::output::CreatePublicIpv4PoolOutput,
        crate::error::CreatePublicIpv4PoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_public_ipv4_pool_error(response)
        } else {
            crate::operation_deser::parse_create_public_ipv4_pool_response(response)
        }
    }
}

/// Operation shape for `CreateReplaceRootVolumeTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replace_root_volume_task`](crate::client::Client::create_replace_root_volume_task).
///
/// See [`crate::client::fluent_builders::CreateReplaceRootVolumeTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplaceRootVolumeTask {
    _private: (),
}
impl CreateReplaceRootVolumeTask {
    /// Creates a new builder-style object to manufacture [`CreateReplaceRootVolumeTaskInput`](crate::input::CreateReplaceRootVolumeTaskInput)
    pub fn builder() -> crate::input::create_replace_root_volume_task_input::Builder {
        crate::input::create_replace_root_volume_task_input::Builder::default()
    }
    /// Creates a new `CreateReplaceRootVolumeTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplaceRootVolumeTask {
    type Output = std::result::Result<
        crate::output::CreateReplaceRootVolumeTaskOutput,
        crate::error::CreateReplaceRootVolumeTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replace_root_volume_task_error(response)
        } else {
            crate::operation_deser::parse_create_replace_root_volume_task_response(response)
        }
    }
}

/// Operation shape for `CreateReservedInstancesListing`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_reserved_instances_listing`](crate::client::Client::create_reserved_instances_listing).
///
/// See [`crate::client::fluent_builders::CreateReservedInstancesListing`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReservedInstancesListing {
    _private: (),
}
impl CreateReservedInstancesListing {
    /// Creates a new builder-style object to manufacture [`CreateReservedInstancesListingInput`](crate::input::CreateReservedInstancesListingInput)
    pub fn builder() -> crate::input::create_reserved_instances_listing_input::Builder {
        crate::input::create_reserved_instances_listing_input::Builder::default()
    }
    /// Creates a new `CreateReservedInstancesListing` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReservedInstancesListing {
    type Output = std::result::Result<
        crate::output::CreateReservedInstancesListingOutput,
        crate::error::CreateReservedInstancesListingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_reserved_instances_listing_error(response)
        } else {
            crate::operation_deser::parse_create_reserved_instances_listing_response(response)
        }
    }
}

/// Operation shape for `CreateRestoreImageTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_restore_image_task`](crate::client::Client::create_restore_image_task).
///
/// See [`crate::client::fluent_builders::CreateRestoreImageTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRestoreImageTask {
    _private: (),
}
impl CreateRestoreImageTask {
    /// Creates a new builder-style object to manufacture [`CreateRestoreImageTaskInput`](crate::input::CreateRestoreImageTaskInput)
    pub fn builder() -> crate::input::create_restore_image_task_input::Builder {
        crate::input::create_restore_image_task_input::Builder::default()
    }
    /// Creates a new `CreateRestoreImageTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRestoreImageTask {
    type Output = std::result::Result<
        crate::output::CreateRestoreImageTaskOutput,
        crate::error::CreateRestoreImageTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_restore_image_task_error(response)
        } else {
            crate::operation_deser::parse_create_restore_image_task_response(response)
        }
    }
}

/// Operation shape for `CreateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route`](crate::client::Client::create_route).
///
/// See [`crate::client::fluent_builders::CreateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRoute {
    _private: (),
}
impl CreateRoute {
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
    /// Creates a new `CreateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRoute {
    type Output =
        std::result::Result<crate::output::CreateRouteOutput, crate::error::CreateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_route_error(response)
        } else {
            crate::operation_deser::parse_create_route_response(response)
        }
    }
}

/// Operation shape for `CreateRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route_table`](crate::client::Client::create_route_table).
///
/// See [`crate::client::fluent_builders::CreateRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRouteTable {
    _private: (),
}
impl CreateRouteTable {
    /// Creates a new builder-style object to manufacture [`CreateRouteTableInput`](crate::input::CreateRouteTableInput)
    pub fn builder() -> crate::input::create_route_table_input::Builder {
        crate::input::create_route_table_input::Builder::default()
    }
    /// Creates a new `CreateRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRouteTable {
    type Output = std::result::Result<
        crate::output::CreateRouteTableOutput,
        crate::error::CreateRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_route_table_error(response)
        } else {
            crate::operation_deser::parse_create_route_table_response(response)
        }
    }
}

/// Operation shape for `CreateSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_security_group`](crate::client::Client::create_security_group).
///
/// See [`crate::client::fluent_builders::CreateSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSecurityGroup {
    _private: (),
}
impl CreateSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CreateSecurityGroupInput`](crate::input::CreateSecurityGroupInput)
    pub fn builder() -> crate::input::create_security_group_input::Builder {
        crate::input::create_security_group_input::Builder::default()
    }
    /// Creates a new `CreateSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSecurityGroup {
    type Output = std::result::Result<
        crate::output::CreateSecurityGroupOutput,
        crate::error::CreateSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_security_group_error(response)
        } else {
            crate::operation_deser::parse_create_security_group_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshots`](crate::client::Client::create_snapshots).
///
/// See [`crate::client::fluent_builders::CreateSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshots {
    _private: (),
}
impl CreateSnapshots {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotsInput`](crate::input::CreateSnapshotsInput)
    pub fn builder() -> crate::input::create_snapshots_input::Builder {
        crate::input::create_snapshots_input::Builder::default()
    }
    /// Creates a new `CreateSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshots {
    type Output = std::result::Result<
        crate::output::CreateSnapshotsOutput,
        crate::error::CreateSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshots_error(response)
        } else {
            crate::operation_deser::parse_create_snapshots_response(response)
        }
    }
}

/// Operation shape for `CreateSpotDatafeedSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_spot_datafeed_subscription`](crate::client::Client::create_spot_datafeed_subscription).
///
/// See [`crate::client::fluent_builders::CreateSpotDatafeedSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSpotDatafeedSubscription {
    _private: (),
}
impl CreateSpotDatafeedSubscription {
    /// Creates a new builder-style object to manufacture [`CreateSpotDatafeedSubscriptionInput`](crate::input::CreateSpotDatafeedSubscriptionInput)
    pub fn builder() -> crate::input::create_spot_datafeed_subscription_input::Builder {
        crate::input::create_spot_datafeed_subscription_input::Builder::default()
    }
    /// Creates a new `CreateSpotDatafeedSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSpotDatafeedSubscription {
    type Output = std::result::Result<
        crate::output::CreateSpotDatafeedSubscriptionOutput,
        crate::error::CreateSpotDatafeedSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_spot_datafeed_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_spot_datafeed_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateStoreImageTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_store_image_task`](crate::client::Client::create_store_image_task).
///
/// See [`crate::client::fluent_builders::CreateStoreImageTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStoreImageTask {
    _private: (),
}
impl CreateStoreImageTask {
    /// Creates a new builder-style object to manufacture [`CreateStoreImageTaskInput`](crate::input::CreateStoreImageTaskInput)
    pub fn builder() -> crate::input::create_store_image_task_input::Builder {
        crate::input::create_store_image_task_input::Builder::default()
    }
    /// Creates a new `CreateStoreImageTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStoreImageTask {
    type Output = std::result::Result<
        crate::output::CreateStoreImageTaskOutput,
        crate::error::CreateStoreImageTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_store_image_task_error(response)
        } else {
            crate::operation_deser::parse_create_store_image_task_response(response)
        }
    }
}

/// Operation shape for `CreateSubnet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subnet`](crate::client::Client::create_subnet).
///
/// See [`crate::client::fluent_builders::CreateSubnet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubnet {
    _private: (),
}
impl CreateSubnet {
    /// Creates a new builder-style object to manufacture [`CreateSubnetInput`](crate::input::CreateSubnetInput)
    pub fn builder() -> crate::input::create_subnet_input::Builder {
        crate::input::create_subnet_input::Builder::default()
    }
    /// Creates a new `CreateSubnet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubnet {
    type Output =
        std::result::Result<crate::output::CreateSubnetOutput, crate::error::CreateSubnetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subnet_error(response)
        } else {
            crate::operation_deser::parse_create_subnet_response(response)
        }
    }
}

/// Operation shape for `CreateSubnetCidrReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subnet_cidr_reservation`](crate::client::Client::create_subnet_cidr_reservation).
///
/// See [`crate::client::fluent_builders::CreateSubnetCidrReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubnetCidrReservation {
    _private: (),
}
impl CreateSubnetCidrReservation {
    /// Creates a new builder-style object to manufacture [`CreateSubnetCidrReservationInput`](crate::input::CreateSubnetCidrReservationInput)
    pub fn builder() -> crate::input::create_subnet_cidr_reservation_input::Builder {
        crate::input::create_subnet_cidr_reservation_input::Builder::default()
    }
    /// Creates a new `CreateSubnetCidrReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubnetCidrReservation {
    type Output = std::result::Result<
        crate::output::CreateSubnetCidrReservationOutput,
        crate::error::CreateSubnetCidrReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subnet_cidr_reservation_error(response)
        } else {
            crate::operation_deser::parse_create_subnet_cidr_reservation_response(response)
        }
    }
}

/// Operation shape for `CreateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tags`](crate::client::Client::create_tags).
///
/// See [`crate::client::fluent_builders::CreateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTags {
    _private: (),
}
impl CreateTags {
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
    /// Creates a new `CreateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTags {
    type Output =
        std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tags_error(response)
        } else {
            crate::operation_deser::parse_create_tags_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficMirrorFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_mirror_filter`](crate::client::Client::create_traffic_mirror_filter).
///
/// See [`crate::client::fluent_builders::CreateTrafficMirrorFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficMirrorFilter {
    _private: (),
}
impl CreateTrafficMirrorFilter {
    /// Creates a new builder-style object to manufacture [`CreateTrafficMirrorFilterInput`](crate::input::CreateTrafficMirrorFilterInput)
    pub fn builder() -> crate::input::create_traffic_mirror_filter_input::Builder {
        crate::input::create_traffic_mirror_filter_input::Builder::default()
    }
    /// Creates a new `CreateTrafficMirrorFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficMirrorFilter {
    type Output = std::result::Result<
        crate::output::CreateTrafficMirrorFilterOutput,
        crate::error::CreateTrafficMirrorFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_traffic_mirror_filter_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_mirror_filter_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficMirrorFilterRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_mirror_filter_rule`](crate::client::Client::create_traffic_mirror_filter_rule).
///
/// See [`crate::client::fluent_builders::CreateTrafficMirrorFilterRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficMirrorFilterRule {
    _private: (),
}
impl CreateTrafficMirrorFilterRule {
    /// Creates a new builder-style object to manufacture [`CreateTrafficMirrorFilterRuleInput`](crate::input::CreateTrafficMirrorFilterRuleInput)
    pub fn builder() -> crate::input::create_traffic_mirror_filter_rule_input::Builder {
        crate::input::create_traffic_mirror_filter_rule_input::Builder::default()
    }
    /// Creates a new `CreateTrafficMirrorFilterRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficMirrorFilterRule {
    type Output = std::result::Result<
        crate::output::CreateTrafficMirrorFilterRuleOutput,
        crate::error::CreateTrafficMirrorFilterRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_traffic_mirror_filter_rule_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_mirror_filter_rule_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficMirrorSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_mirror_session`](crate::client::Client::create_traffic_mirror_session).
///
/// See [`crate::client::fluent_builders::CreateTrafficMirrorSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficMirrorSession {
    _private: (),
}
impl CreateTrafficMirrorSession {
    /// Creates a new builder-style object to manufacture [`CreateTrafficMirrorSessionInput`](crate::input::CreateTrafficMirrorSessionInput)
    pub fn builder() -> crate::input::create_traffic_mirror_session_input::Builder {
        crate::input::create_traffic_mirror_session_input::Builder::default()
    }
    /// Creates a new `CreateTrafficMirrorSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficMirrorSession {
    type Output = std::result::Result<
        crate::output::CreateTrafficMirrorSessionOutput,
        crate::error::CreateTrafficMirrorSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_traffic_mirror_session_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_mirror_session_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficMirrorTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_mirror_target`](crate::client::Client::create_traffic_mirror_target).
///
/// See [`crate::client::fluent_builders::CreateTrafficMirrorTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficMirrorTarget {
    _private: (),
}
impl CreateTrafficMirrorTarget {
    /// Creates a new builder-style object to manufacture [`CreateTrafficMirrorTargetInput`](crate::input::CreateTrafficMirrorTargetInput)
    pub fn builder() -> crate::input::create_traffic_mirror_target_input::Builder {
        crate::input::create_traffic_mirror_target_input::Builder::default()
    }
    /// Creates a new `CreateTrafficMirrorTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficMirrorTarget {
    type Output = std::result::Result<
        crate::output::CreateTrafficMirrorTargetOutput,
        crate::error::CreateTrafficMirrorTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_traffic_mirror_target_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_mirror_target_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway`](crate::client::Client::create_transit_gateway).
///
/// See [`crate::client::fluent_builders::CreateTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGateway {
    _private: (),
}
impl CreateTransitGateway {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayInput`](crate::input::CreateTransitGatewayInput)
    pub fn builder() -> crate::input::create_transit_gateway_input::Builder {
        crate::input::create_transit_gateway_input::Builder::default()
    }
    /// Creates a new `CreateTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGateway {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayOutput,
        crate::error::CreateTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayConnect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_connect`](crate::client::Client::create_transit_gateway_connect).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayConnect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayConnect {
    _private: (),
}
impl CreateTransitGatewayConnect {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayConnectInput`](crate::input::CreateTransitGatewayConnectInput)
    pub fn builder() -> crate::input::create_transit_gateway_connect_input::Builder {
        crate::input::create_transit_gateway_connect_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayConnect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayConnect {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayConnectOutput,
        crate::error::CreateTransitGatewayConnectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_connect_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_connect_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_connect_peer`](crate::client::Client::create_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayConnectPeer {
    _private: (),
}
impl CreateTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayConnectPeerInput`](crate::input::CreateTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::create_transit_gateway_connect_peer_input::Builder {
        crate::input::create_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayConnectPeerOutput,
        crate::error::CreateTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_connect_peer_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayMulticastDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_multicast_domain`](crate::client::Client::create_transit_gateway_multicast_domain).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayMulticastDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayMulticastDomain {
    _private: (),
}
impl CreateTransitGatewayMulticastDomain {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayMulticastDomainInput`](crate::input::CreateTransitGatewayMulticastDomainInput)
    pub fn builder() -> crate::input::create_transit_gateway_multicast_domain_input::Builder {
        crate::input::create_transit_gateway_multicast_domain_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayMulticastDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayMulticastDomain {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayMulticastDomainOutput,
        crate::error::CreateTransitGatewayMulticastDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_multicast_domain_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_multicast_domain_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayPeeringAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_peering_attachment`](crate::client::Client::create_transit_gateway_peering_attachment).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayPeeringAttachment {
    _private: (),
}
impl CreateTransitGatewayPeeringAttachment {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayPeeringAttachmentInput`](crate::input::CreateTransitGatewayPeeringAttachmentInput)
    pub fn builder() -> crate::input::create_transit_gateway_peering_attachment_input::Builder {
        crate::input::create_transit_gateway_peering_attachment_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayPeeringAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayPeeringAttachment {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayPeeringAttachmentOutput,
        crate::error::CreateTransitGatewayPeeringAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_peering_attachment_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_peering_attachment_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateTransitGatewayPrefixListReference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_prefix_list_reference`](crate::client::Client::create_transit_gateway_prefix_list_reference).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayPrefixListReference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayPrefixListReference {
    _private: (),
}
impl CreateTransitGatewayPrefixListReference {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayPrefixListReferenceInput`](crate::input::CreateTransitGatewayPrefixListReferenceInput)
    pub fn builder() -> crate::input::create_transit_gateway_prefix_list_reference_input::Builder {
        crate::input::create_transit_gateway_prefix_list_reference_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayPrefixListReference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayPrefixListReference {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayPrefixListReferenceOutput,
        crate::error::CreateTransitGatewayPrefixListReferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_prefix_list_reference_error(
                response,
            )
        } else {
            crate::operation_deser::parse_create_transit_gateway_prefix_list_reference_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateTransitGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_route`](crate::client::Client::create_transit_gateway_route).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayRoute {
    _private: (),
}
impl CreateTransitGatewayRoute {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayRouteInput`](crate::input::CreateTransitGatewayRouteInput)
    pub fn builder() -> crate::input::create_transit_gateway_route_input::Builder {
        crate::input::create_transit_gateway_route_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayRoute {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayRouteOutput,
        crate::error::CreateTransitGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_route_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_route_table`](crate::client::Client::create_transit_gateway_route_table).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayRouteTable {
    _private: (),
}
impl CreateTransitGatewayRouteTable {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayRouteTableInput`](crate::input::CreateTransitGatewayRouteTableInput)
    pub fn builder() -> crate::input::create_transit_gateway_route_table_input::Builder {
        crate::input::create_transit_gateway_route_table_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayRouteTable {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayRouteTableOutput,
        crate::error::CreateTransitGatewayRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_route_table_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_route_table_response(response)
        }
    }
}

/// Operation shape for `CreateTransitGatewayVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transit_gateway_vpc_attachment`](crate::client::Client::create_transit_gateway_vpc_attachment).
///
/// See [`crate::client::fluent_builders::CreateTransitGatewayVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransitGatewayVpcAttachment {
    _private: (),
}
impl CreateTransitGatewayVpcAttachment {
    /// Creates a new builder-style object to manufacture [`CreateTransitGatewayVpcAttachmentInput`](crate::input::CreateTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::create_transit_gateway_vpc_attachment_input::Builder {
        crate::input::create_transit_gateway_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `CreateTransitGatewayVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransitGatewayVpcAttachment {
    type Output = std::result::Result<
        crate::output::CreateTransitGatewayVpcAttachmentOutput,
        crate::error::CreateTransitGatewayVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transit_gateway_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_create_transit_gateway_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `CreateVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_volume`](crate::client::Client::create_volume).
///
/// See [`crate::client::fluent_builders::CreateVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVolume {
    _private: (),
}
impl CreateVolume {
    /// Creates a new builder-style object to manufacture [`CreateVolumeInput`](crate::input::CreateVolumeInput)
    pub fn builder() -> crate::input::create_volume_input::Builder {
        crate::input::create_volume_input::Builder::default()
    }
    /// Creates a new `CreateVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVolume {
    type Output =
        std::result::Result<crate::output::CreateVolumeOutput, crate::error::CreateVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_volume_error(response)
        } else {
            crate::operation_deser::parse_create_volume_response(response)
        }
    }
}

/// Operation shape for `CreateVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc`](crate::client::Client::create_vpc).
///
/// See [`crate::client::fluent_builders::CreateVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpc {
    _private: (),
}
impl CreateVpc {
    /// Creates a new builder-style object to manufacture [`CreateVpcInput`](crate::input::CreateVpcInput)
    pub fn builder() -> crate::input::create_vpc_input::Builder {
        crate::input::create_vpc_input::Builder::default()
    }
    /// Creates a new `CreateVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpc {
    type Output = std::result::Result<crate::output::CreateVpcOutput, crate::error::CreateVpcError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_response(response)
        }
    }
}

/// Operation shape for `CreateVpcEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_endpoint`](crate::client::Client::create_vpc_endpoint).
///
/// See [`crate::client::fluent_builders::CreateVpcEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcEndpoint {
    _private: (),
}
impl CreateVpcEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateVpcEndpointInput`](crate::input::CreateVpcEndpointInput)
    pub fn builder() -> crate::input::create_vpc_endpoint_input::Builder {
        crate::input::create_vpc_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateVpcEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcEndpoint {
    type Output = std::result::Result<
        crate::output::CreateVpcEndpointOutput,
        crate::error::CreateVpcEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateVpcEndpointConnectionNotification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_endpoint_connection_notification`](crate::client::Client::create_vpc_endpoint_connection_notification).
///
/// See [`crate::client::fluent_builders::CreateVpcEndpointConnectionNotification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcEndpointConnectionNotification {
    _private: (),
}
impl CreateVpcEndpointConnectionNotification {
    /// Creates a new builder-style object to manufacture [`CreateVpcEndpointConnectionNotificationInput`](crate::input::CreateVpcEndpointConnectionNotificationInput)
    pub fn builder() -> crate::input::create_vpc_endpoint_connection_notification_input::Builder {
        crate::input::create_vpc_endpoint_connection_notification_input::Builder::default()
    }
    /// Creates a new `CreateVpcEndpointConnectionNotification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcEndpointConnectionNotification {
    type Output = std::result::Result<
        crate::output::CreateVpcEndpointConnectionNotificationOutput,
        crate::error::CreateVpcEndpointConnectionNotificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_endpoint_connection_notification_error(
                response,
            )
        } else {
            crate::operation_deser::parse_create_vpc_endpoint_connection_notification_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateVpcEndpointServiceConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_endpoint_service_configuration`](crate::client::Client::create_vpc_endpoint_service_configuration).
///
/// See [`crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcEndpointServiceConfiguration {
    _private: (),
}
impl CreateVpcEndpointServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateVpcEndpointServiceConfigurationInput`](crate::input::CreateVpcEndpointServiceConfigurationInput)
    pub fn builder() -> crate::input::create_vpc_endpoint_service_configuration_input::Builder {
        crate::input::create_vpc_endpoint_service_configuration_input::Builder::default()
    }
    /// Creates a new `CreateVpcEndpointServiceConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcEndpointServiceConfiguration {
    type Output = std::result::Result<
        crate::output::CreateVpcEndpointServiceConfigurationOutput,
        crate::error::CreateVpcEndpointServiceConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_endpoint_service_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_endpoint_service_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_peering_connection`](crate::client::Client::create_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::CreateVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcPeeringConnection {
    _private: (),
}
impl CreateVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`CreateVpcPeeringConnectionInput`](crate::input::CreateVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::create_vpc_peering_connection_input::Builder {
        crate::input::create_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `CreateVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::CreateVpcPeeringConnectionOutput,
        crate::error::CreateVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `CreateVpnConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpn_connection`](crate::client::Client::create_vpn_connection).
///
/// See [`crate::client::fluent_builders::CreateVpnConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpnConnection {
    _private: (),
}
impl CreateVpnConnection {
    /// Creates a new builder-style object to manufacture [`CreateVpnConnectionInput`](crate::input::CreateVpnConnectionInput)
    pub fn builder() -> crate::input::create_vpn_connection_input::Builder {
        crate::input::create_vpn_connection_input::Builder::default()
    }
    /// Creates a new `CreateVpnConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpnConnection {
    type Output = std::result::Result<
        crate::output::CreateVpnConnectionOutput,
        crate::error::CreateVpnConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpn_connection_error(response)
        } else {
            crate::operation_deser::parse_create_vpn_connection_response(response)
        }
    }
}

/// Operation shape for `CreateVpnConnectionRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpn_connection_route`](crate::client::Client::create_vpn_connection_route).
///
/// See [`crate::client::fluent_builders::CreateVpnConnectionRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpnConnectionRoute {
    _private: (),
}
impl CreateVpnConnectionRoute {
    /// Creates a new builder-style object to manufacture [`CreateVpnConnectionRouteInput`](crate::input::CreateVpnConnectionRouteInput)
    pub fn builder() -> crate::input::create_vpn_connection_route_input::Builder {
        crate::input::create_vpn_connection_route_input::Builder::default()
    }
    /// Creates a new `CreateVpnConnectionRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpnConnectionRoute {
    type Output = std::result::Result<
        crate::output::CreateVpnConnectionRouteOutput,
        crate::error::CreateVpnConnectionRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpn_connection_route_error(response)
        } else {
            crate::operation_deser::parse_create_vpn_connection_route_response(response)
        }
    }
}

/// Operation shape for `CreateVpnGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpn_gateway`](crate::client::Client::create_vpn_gateway).
///
/// See [`crate::client::fluent_builders::CreateVpnGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpnGateway {
    _private: (),
}
impl CreateVpnGateway {
    /// Creates a new builder-style object to manufacture [`CreateVpnGatewayInput`](crate::input::CreateVpnGatewayInput)
    pub fn builder() -> crate::input::create_vpn_gateway_input::Builder {
        crate::input::create_vpn_gateway_input::Builder::default()
    }
    /// Creates a new `CreateVpnGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpnGateway {
    type Output = std::result::Result<
        crate::output::CreateVpnGatewayOutput,
        crate::error::CreateVpnGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpn_gateway_error(response)
        } else {
            crate::operation_deser::parse_create_vpn_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteCarrierGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_carrier_gateway`](crate::client::Client::delete_carrier_gateway).
///
/// See [`crate::client::fluent_builders::DeleteCarrierGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCarrierGateway {
    _private: (),
}
impl DeleteCarrierGateway {
    /// Creates a new builder-style object to manufacture [`DeleteCarrierGatewayInput`](crate::input::DeleteCarrierGatewayInput)
    pub fn builder() -> crate::input::delete_carrier_gateway_input::Builder {
        crate::input::delete_carrier_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteCarrierGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCarrierGateway {
    type Output = std::result::Result<
        crate::output::DeleteCarrierGatewayOutput,
        crate::error::DeleteCarrierGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_carrier_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_carrier_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteClientVpnEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_client_vpn_endpoint`](crate::client::Client::delete_client_vpn_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteClientVpnEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClientVpnEndpoint {
    _private: (),
}
impl DeleteClientVpnEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteClientVpnEndpointInput`](crate::input::DeleteClientVpnEndpointInput)
    pub fn builder() -> crate::input::delete_client_vpn_endpoint_input::Builder {
        crate::input::delete_client_vpn_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteClientVpnEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClientVpnEndpoint {
    type Output = std::result::Result<
        crate::output::DeleteClientVpnEndpointOutput,
        crate::error::DeleteClientVpnEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_client_vpn_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_client_vpn_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteClientVpnRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_client_vpn_route`](crate::client::Client::delete_client_vpn_route).
///
/// See [`crate::client::fluent_builders::DeleteClientVpnRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClientVpnRoute {
    _private: (),
}
impl DeleteClientVpnRoute {
    /// Creates a new builder-style object to manufacture [`DeleteClientVpnRouteInput`](crate::input::DeleteClientVpnRouteInput)
    pub fn builder() -> crate::input::delete_client_vpn_route_input::Builder {
        crate::input::delete_client_vpn_route_input::Builder::default()
    }
    /// Creates a new `DeleteClientVpnRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClientVpnRoute {
    type Output = std::result::Result<
        crate::output::DeleteClientVpnRouteOutput,
        crate::error::DeleteClientVpnRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_client_vpn_route_error(response)
        } else {
            crate::operation_deser::parse_delete_client_vpn_route_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomerGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_customer_gateway`](crate::client::Client::delete_customer_gateway).
///
/// See [`crate::client::fluent_builders::DeleteCustomerGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomerGateway {
    _private: (),
}
impl DeleteCustomerGateway {
    /// Creates a new builder-style object to manufacture [`DeleteCustomerGatewayInput`](crate::input::DeleteCustomerGatewayInput)
    pub fn builder() -> crate::input::delete_customer_gateway_input::Builder {
        crate::input::delete_customer_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteCustomerGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomerGateway {
    type Output = std::result::Result<
        crate::output::DeleteCustomerGatewayOutput,
        crate::error::DeleteCustomerGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_customer_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_customer_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteDhcpOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dhcp_options`](crate::client::Client::delete_dhcp_options).
///
/// See [`crate::client::fluent_builders::DeleteDhcpOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDhcpOptions {
    _private: (),
}
impl DeleteDhcpOptions {
    /// Creates a new builder-style object to manufacture [`DeleteDhcpOptionsInput`](crate::input::DeleteDhcpOptionsInput)
    pub fn builder() -> crate::input::delete_dhcp_options_input::Builder {
        crate::input::delete_dhcp_options_input::Builder::default()
    }
    /// Creates a new `DeleteDhcpOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDhcpOptions {
    type Output = std::result::Result<
        crate::output::DeleteDhcpOptionsOutput,
        crate::error::DeleteDhcpOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dhcp_options_error(response)
        } else {
            crate::operation_deser::parse_delete_dhcp_options_response(response)
        }
    }
}

/// Operation shape for `DeleteEgressOnlyInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_egress_only_internet_gateway`](crate::client::Client::delete_egress_only_internet_gateway).
///
/// See [`crate::client::fluent_builders::DeleteEgressOnlyInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEgressOnlyInternetGateway {
    _private: (),
}
impl DeleteEgressOnlyInternetGateway {
    /// Creates a new builder-style object to manufacture [`DeleteEgressOnlyInternetGatewayInput`](crate::input::DeleteEgressOnlyInternetGatewayInput)
    pub fn builder() -> crate::input::delete_egress_only_internet_gateway_input::Builder {
        crate::input::delete_egress_only_internet_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteEgressOnlyInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEgressOnlyInternetGateway {
    type Output = std::result::Result<
        crate::output::DeleteEgressOnlyInternetGatewayOutput,
        crate::error::DeleteEgressOnlyInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_egress_only_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_egress_only_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleets`](crate::client::Client::delete_fleets).
///
/// See [`crate::client::fluent_builders::DeleteFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleets {
    _private: (),
}
impl DeleteFleets {
    /// Creates a new builder-style object to manufacture [`DeleteFleetsInput`](crate::input::DeleteFleetsInput)
    pub fn builder() -> crate::input::delete_fleets_input::Builder {
        crate::input::delete_fleets_input::Builder::default()
    }
    /// Creates a new `DeleteFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleets {
    type Output =
        std::result::Result<crate::output::DeleteFleetsOutput, crate::error::DeleteFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleets_error(response)
        } else {
            crate::operation_deser::parse_delete_fleets_response(response)
        }
    }
}

/// Operation shape for `DeleteFlowLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_flow_logs`](crate::client::Client::delete_flow_logs).
///
/// See [`crate::client::fluent_builders::DeleteFlowLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFlowLogs {
    _private: (),
}
impl DeleteFlowLogs {
    /// Creates a new builder-style object to manufacture [`DeleteFlowLogsInput`](crate::input::DeleteFlowLogsInput)
    pub fn builder() -> crate::input::delete_flow_logs_input::Builder {
        crate::input::delete_flow_logs_input::Builder::default()
    }
    /// Creates a new `DeleteFlowLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFlowLogs {
    type Output =
        std::result::Result<crate::output::DeleteFlowLogsOutput, crate::error::DeleteFlowLogsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_flow_logs_error(response)
        } else {
            crate::operation_deser::parse_delete_flow_logs_response(response)
        }
    }
}

/// Operation shape for `DeleteFpgaImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fpga_image`](crate::client::Client::delete_fpga_image).
///
/// See [`crate::client::fluent_builders::DeleteFpgaImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFpgaImage {
    _private: (),
}
impl DeleteFpgaImage {
    /// Creates a new builder-style object to manufacture [`DeleteFpgaImageInput`](crate::input::DeleteFpgaImageInput)
    pub fn builder() -> crate::input::delete_fpga_image_input::Builder {
        crate::input::delete_fpga_image_input::Builder::default()
    }
    /// Creates a new `DeleteFpgaImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFpgaImage {
    type Output = std::result::Result<
        crate::output::DeleteFpgaImageOutput,
        crate::error::DeleteFpgaImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fpga_image_error(response)
        } else {
            crate::operation_deser::parse_delete_fpga_image_response(response)
        }
    }
}

/// Operation shape for `DeleteInstanceEventWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance_event_window`](crate::client::Client::delete_instance_event_window).
///
/// See [`crate::client::fluent_builders::DeleteInstanceEventWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstanceEventWindow {
    _private: (),
}
impl DeleteInstanceEventWindow {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceEventWindowInput`](crate::input::DeleteInstanceEventWindowInput)
    pub fn builder() -> crate::input::delete_instance_event_window_input::Builder {
        crate::input::delete_instance_event_window_input::Builder::default()
    }
    /// Creates a new `DeleteInstanceEventWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstanceEventWindow {
    type Output = std::result::Result<
        crate::output::DeleteInstanceEventWindowOutput,
        crate::error::DeleteInstanceEventWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_event_window_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_event_window_response(response)
        }
    }
}

/// Operation shape for `DeleteInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_internet_gateway`](crate::client::Client::delete_internet_gateway).
///
/// See [`crate::client::fluent_builders::DeleteInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInternetGateway {
    _private: (),
}
impl DeleteInternetGateway {
    /// Creates a new builder-style object to manufacture [`DeleteInternetGatewayInput`](crate::input::DeleteInternetGatewayInput)
    pub fn builder() -> crate::input::delete_internet_gateway_input::Builder {
        crate::input::delete_internet_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInternetGateway {
    type Output = std::result::Result<
        crate::output::DeleteInternetGatewayOutput,
        crate::error::DeleteInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteIpam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ipam`](crate::client::Client::delete_ipam).
///
/// See [`crate::client::fluent_builders::DeleteIpam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIpam {
    _private: (),
}
impl DeleteIpam {
    /// Creates a new builder-style object to manufacture [`DeleteIpamInput`](crate::input::DeleteIpamInput)
    pub fn builder() -> crate::input::delete_ipam_input::Builder {
        crate::input::delete_ipam_input::Builder::default()
    }
    /// Creates a new `DeleteIpam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIpam {
    type Output =
        std::result::Result<crate::output::DeleteIpamOutput, crate::error::DeleteIpamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ipam_error(response)
        } else {
            crate::operation_deser::parse_delete_ipam_response(response)
        }
    }
}

/// Operation shape for `DeleteIpamPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ipam_pool`](crate::client::Client::delete_ipam_pool).
///
/// See [`crate::client::fluent_builders::DeleteIpamPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIpamPool {
    _private: (),
}
impl DeleteIpamPool {
    /// Creates a new builder-style object to manufacture [`DeleteIpamPoolInput`](crate::input::DeleteIpamPoolInput)
    pub fn builder() -> crate::input::delete_ipam_pool_input::Builder {
        crate::input::delete_ipam_pool_input::Builder::default()
    }
    /// Creates a new `DeleteIpamPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIpamPool {
    type Output =
        std::result::Result<crate::output::DeleteIpamPoolOutput, crate::error::DeleteIpamPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ipam_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_ipam_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteIpamScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ipam_scope`](crate::client::Client::delete_ipam_scope).
///
/// See [`crate::client::fluent_builders::DeleteIpamScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIpamScope {
    _private: (),
}
impl DeleteIpamScope {
    /// Creates a new builder-style object to manufacture [`DeleteIpamScopeInput`](crate::input::DeleteIpamScopeInput)
    pub fn builder() -> crate::input::delete_ipam_scope_input::Builder {
        crate::input::delete_ipam_scope_input::Builder::default()
    }
    /// Creates a new `DeleteIpamScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIpamScope {
    type Output = std::result::Result<
        crate::output::DeleteIpamScopeOutput,
        crate::error::DeleteIpamScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ipam_scope_error(response)
        } else {
            crate::operation_deser::parse_delete_ipam_scope_response(response)
        }
    }
}

/// Operation shape for `DeleteKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_key_pair`](crate::client::Client::delete_key_pair).
///
/// See [`crate::client::fluent_builders::DeleteKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKeyPair {
    _private: (),
}
impl DeleteKeyPair {
    /// Creates a new builder-style object to manufacture [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
    pub fn builder() -> crate::input::delete_key_pair_input::Builder {
        crate::input::delete_key_pair_input::Builder::default()
    }
    /// Creates a new `DeleteKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKeyPair {
    type Output =
        std::result::Result<crate::output::DeleteKeyPairOutput, crate::error::DeleteKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_key_pair_error(response)
        } else {
            crate::operation_deser::parse_delete_key_pair_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunchTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch_template`](crate::client::Client::delete_launch_template).
///
/// See [`crate::client::fluent_builders::DeleteLaunchTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunchTemplate {
    _private: (),
}
impl DeleteLaunchTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchTemplateInput`](crate::input::DeleteLaunchTemplateInput)
    pub fn builder() -> crate::input::delete_launch_template_input::Builder {
        crate::input::delete_launch_template_input::Builder::default()
    }
    /// Creates a new `DeleteLaunchTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunchTemplate {
    type Output = std::result::Result<
        crate::output::DeleteLaunchTemplateOutput,
        crate::error::DeleteLaunchTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_template_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_template_response(response)
        }
    }
}

/// Operation shape for `DeleteLaunchTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_launch_template_versions`](crate::client::Client::delete_launch_template_versions).
///
/// See [`crate::client::fluent_builders::DeleteLaunchTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLaunchTemplateVersions {
    _private: (),
}
impl DeleteLaunchTemplateVersions {
    /// Creates a new builder-style object to manufacture [`DeleteLaunchTemplateVersionsInput`](crate::input::DeleteLaunchTemplateVersionsInput)
    pub fn builder() -> crate::input::delete_launch_template_versions_input::Builder {
        crate::input::delete_launch_template_versions_input::Builder::default()
    }
    /// Creates a new `DeleteLaunchTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLaunchTemplateVersions {
    type Output = std::result::Result<
        crate::output::DeleteLaunchTemplateVersionsOutput,
        crate::error::DeleteLaunchTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_launch_template_versions_error(response)
        } else {
            crate::operation_deser::parse_delete_launch_template_versions_response(response)
        }
    }
}

/// Operation shape for `DeleteLocalGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_local_gateway_route`](crate::client::Client::delete_local_gateway_route).
///
/// See [`crate::client::fluent_builders::DeleteLocalGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLocalGatewayRoute {
    _private: (),
}
impl DeleteLocalGatewayRoute {
    /// Creates a new builder-style object to manufacture [`DeleteLocalGatewayRouteInput`](crate::input::DeleteLocalGatewayRouteInput)
    pub fn builder() -> crate::input::delete_local_gateway_route_input::Builder {
        crate::input::delete_local_gateway_route_input::Builder::default()
    }
    /// Creates a new `DeleteLocalGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLocalGatewayRoute {
    type Output = std::result::Result<
        crate::output::DeleteLocalGatewayRouteOutput,
        crate::error::DeleteLocalGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_local_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_delete_local_gateway_route_response(response)
        }
    }
}

/// Operation shape for `DeleteLocalGatewayRouteTableVpcAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_local_gateway_route_table_vpc_association`](crate::client::Client::delete_local_gateway_route_table_vpc_association).
///
/// See [`crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLocalGatewayRouteTableVpcAssociation {
    _private: (),
}
impl DeleteLocalGatewayRouteTableVpcAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteLocalGatewayRouteTableVpcAssociationInput`](crate::input::DeleteLocalGatewayRouteTableVpcAssociationInput)
    pub fn builder() -> crate::input::delete_local_gateway_route_table_vpc_association_input::Builder
    {
        crate::input::delete_local_gateway_route_table_vpc_association_input::Builder::default()
    }
    /// Creates a new `DeleteLocalGatewayRouteTableVpcAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLocalGatewayRouteTableVpcAssociation {
    type Output = std::result::Result<
        crate::output::DeleteLocalGatewayRouteTableVpcAssociationOutput,
        crate::error::DeleteLocalGatewayRouteTableVpcAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_local_gateway_route_table_vpc_association_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_local_gateway_route_table_vpc_association_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteManagedPrefixList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_managed_prefix_list`](crate::client::Client::delete_managed_prefix_list).
///
/// See [`crate::client::fluent_builders::DeleteManagedPrefixList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteManagedPrefixList {
    _private: (),
}
impl DeleteManagedPrefixList {
    /// Creates a new builder-style object to manufacture [`DeleteManagedPrefixListInput`](crate::input::DeleteManagedPrefixListInput)
    pub fn builder() -> crate::input::delete_managed_prefix_list_input::Builder {
        crate::input::delete_managed_prefix_list_input::Builder::default()
    }
    /// Creates a new `DeleteManagedPrefixList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteManagedPrefixList {
    type Output = std::result::Result<
        crate::output::DeleteManagedPrefixListOutput,
        crate::error::DeleteManagedPrefixListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_managed_prefix_list_error(response)
        } else {
            crate::operation_deser::parse_delete_managed_prefix_list_response(response)
        }
    }
}

/// Operation shape for `DeleteNatGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_nat_gateway`](crate::client::Client::delete_nat_gateway).
///
/// See [`crate::client::fluent_builders::DeleteNatGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNatGateway {
    _private: (),
}
impl DeleteNatGateway {
    /// Creates a new builder-style object to manufacture [`DeleteNatGatewayInput`](crate::input::DeleteNatGatewayInput)
    pub fn builder() -> crate::input::delete_nat_gateway_input::Builder {
        crate::input::delete_nat_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteNatGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNatGateway {
    type Output = std::result::Result<
        crate::output::DeleteNatGatewayOutput,
        crate::error::DeleteNatGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_nat_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_nat_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_acl`](crate::client::Client::delete_network_acl).
///
/// See [`crate::client::fluent_builders::DeleteNetworkAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkAcl {
    _private: (),
}
impl DeleteNetworkAcl {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkAclInput`](crate::input::DeleteNetworkAclInput)
    pub fn builder() -> crate::input::delete_network_acl_input::Builder {
        crate::input::delete_network_acl_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkAcl {
    type Output = std::result::Result<
        crate::output::DeleteNetworkAclOutput,
        crate::error::DeleteNetworkAclError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_acl_error(response)
        } else {
            crate::operation_deser::parse_delete_network_acl_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkAclEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_acl_entry`](crate::client::Client::delete_network_acl_entry).
///
/// See [`crate::client::fluent_builders::DeleteNetworkAclEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkAclEntry {
    _private: (),
}
impl DeleteNetworkAclEntry {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkAclEntryInput`](crate::input::DeleteNetworkAclEntryInput)
    pub fn builder() -> crate::input::delete_network_acl_entry_input::Builder {
        crate::input::delete_network_acl_entry_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkAclEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkAclEntry {
    type Output = std::result::Result<
        crate::output::DeleteNetworkAclEntryOutput,
        crate::error::DeleteNetworkAclEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_acl_entry_error(response)
        } else {
            crate::operation_deser::parse_delete_network_acl_entry_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkInsightsAccessScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_insights_access_scope`](crate::client::Client::delete_network_insights_access_scope).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInsightsAccessScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInsightsAccessScope {
    _private: (),
}
impl DeleteNetworkInsightsAccessScope {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInsightsAccessScopeInput`](crate::input::DeleteNetworkInsightsAccessScopeInput)
    pub fn builder() -> crate::input::delete_network_insights_access_scope_input::Builder {
        crate::input::delete_network_insights_access_scope_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInsightsAccessScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInsightsAccessScope {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInsightsAccessScopeOutput,
        crate::error::DeleteNetworkInsightsAccessScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_insights_access_scope_error(response)
        } else {
            crate::operation_deser::parse_delete_network_insights_access_scope_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkInsightsAccessScopeAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_insights_access_scope_analysis`](crate::client::Client::delete_network_insights_access_scope_analysis).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInsightsAccessScopeAnalysis {
    _private: (),
}
impl DeleteNetworkInsightsAccessScopeAnalysis {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInsightsAccessScopeAnalysisInput`](crate::input::DeleteNetworkInsightsAccessScopeAnalysisInput)
    pub fn builder() -> crate::input::delete_network_insights_access_scope_analysis_input::Builder {
        crate::input::delete_network_insights_access_scope_analysis_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInsightsAccessScopeAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInsightsAccessScopeAnalysis {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInsightsAccessScopeAnalysisOutput,
        crate::error::DeleteNetworkInsightsAccessScopeAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_insights_access_scope_analysis_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_network_insights_access_scope_analysis_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteNetworkInsightsAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_insights_analysis`](crate::client::Client::delete_network_insights_analysis).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInsightsAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInsightsAnalysis {
    _private: (),
}
impl DeleteNetworkInsightsAnalysis {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInsightsAnalysisInput`](crate::input::DeleteNetworkInsightsAnalysisInput)
    pub fn builder() -> crate::input::delete_network_insights_analysis_input::Builder {
        crate::input::delete_network_insights_analysis_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInsightsAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInsightsAnalysis {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInsightsAnalysisOutput,
        crate::error::DeleteNetworkInsightsAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_insights_analysis_error(response)
        } else {
            crate::operation_deser::parse_delete_network_insights_analysis_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkInsightsPath`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_insights_path`](crate::client::Client::delete_network_insights_path).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInsightsPath`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInsightsPath {
    _private: (),
}
impl DeleteNetworkInsightsPath {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInsightsPathInput`](crate::input::DeleteNetworkInsightsPathInput)
    pub fn builder() -> crate::input::delete_network_insights_path_input::Builder {
        crate::input::delete_network_insights_path_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInsightsPath` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInsightsPath {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInsightsPathOutput,
        crate::error::DeleteNetworkInsightsPathError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_insights_path_error(response)
        } else {
            crate::operation_deser::parse_delete_network_insights_path_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_interface`](crate::client::Client::delete_network_interface).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInterface {
    _private: (),
}
impl DeleteNetworkInterface {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInterfaceInput`](crate::input::DeleteNetworkInterfaceInput)
    pub fn builder() -> crate::input::delete_network_interface_input::Builder {
        crate::input::delete_network_interface_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInterface {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInterfaceOutput,
        crate::error::DeleteNetworkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_interface_error(response)
        } else {
            crate::operation_deser::parse_delete_network_interface_response(response)
        }
    }
}

/// Operation shape for `DeleteNetworkInterfacePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_network_interface_permission`](crate::client::Client::delete_network_interface_permission).
///
/// See [`crate::client::fluent_builders::DeleteNetworkInterfacePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNetworkInterfacePermission {
    _private: (),
}
impl DeleteNetworkInterfacePermission {
    /// Creates a new builder-style object to manufacture [`DeleteNetworkInterfacePermissionInput`](crate::input::DeleteNetworkInterfacePermissionInput)
    pub fn builder() -> crate::input::delete_network_interface_permission_input::Builder {
        crate::input::delete_network_interface_permission_input::Builder::default()
    }
    /// Creates a new `DeleteNetworkInterfacePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNetworkInterfacePermission {
    type Output = std::result::Result<
        crate::output::DeleteNetworkInterfacePermissionOutput,
        crate::error::DeleteNetworkInterfacePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_network_interface_permission_error(response)
        } else {
            crate::operation_deser::parse_delete_network_interface_permission_response(response)
        }
    }
}

/// Operation shape for `DeletePlacementGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_placement_group`](crate::client::Client::delete_placement_group).
///
/// See [`crate::client::fluent_builders::DeletePlacementGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePlacementGroup {
    _private: (),
}
impl DeletePlacementGroup {
    /// Creates a new builder-style object to manufacture [`DeletePlacementGroupInput`](crate::input::DeletePlacementGroupInput)
    pub fn builder() -> crate::input::delete_placement_group_input::Builder {
        crate::input::delete_placement_group_input::Builder::default()
    }
    /// Creates a new `DeletePlacementGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePlacementGroup {
    type Output = std::result::Result<
        crate::output::DeletePlacementGroupOutput,
        crate::error::DeletePlacementGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_placement_group_error(response)
        } else {
            crate::operation_deser::parse_delete_placement_group_response(response)
        }
    }
}

/// Operation shape for `DeletePublicIpv4Pool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_public_ipv4_pool`](crate::client::Client::delete_public_ipv4_pool).
///
/// See [`crate::client::fluent_builders::DeletePublicIpv4Pool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePublicIpv4Pool {
    _private: (),
}
impl DeletePublicIpv4Pool {
    /// Creates a new builder-style object to manufacture [`DeletePublicIpv4PoolInput`](crate::input::DeletePublicIpv4PoolInput)
    pub fn builder() -> crate::input::delete_public_ipv4_pool_input::Builder {
        crate::input::delete_public_ipv4_pool_input::Builder::default()
    }
    /// Creates a new `DeletePublicIpv4Pool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePublicIpv4Pool {
    type Output = std::result::Result<
        crate::output::DeletePublicIpv4PoolOutput,
        crate::error::DeletePublicIpv4PoolError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_public_ipv4_pool_error(response)
        } else {
            crate::operation_deser::parse_delete_public_ipv4_pool_response(response)
        }
    }
}

/// Operation shape for `DeleteQueuedReservedInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_queued_reserved_instances`](crate::client::Client::delete_queued_reserved_instances).
///
/// See [`crate::client::fluent_builders::DeleteQueuedReservedInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQueuedReservedInstances {
    _private: (),
}
impl DeleteQueuedReservedInstances {
    /// Creates a new builder-style object to manufacture [`DeleteQueuedReservedInstancesInput`](crate::input::DeleteQueuedReservedInstancesInput)
    pub fn builder() -> crate::input::delete_queued_reserved_instances_input::Builder {
        crate::input::delete_queued_reserved_instances_input::Builder::default()
    }
    /// Creates a new `DeleteQueuedReservedInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQueuedReservedInstances {
    type Output = std::result::Result<
        crate::output::DeleteQueuedReservedInstancesOutput,
        crate::error::DeleteQueuedReservedInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_queued_reserved_instances_error(response)
        } else {
            crate::operation_deser::parse_delete_queued_reserved_instances_response(response)
        }
    }
}

/// Operation shape for `DeleteRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route`](crate::client::Client::delete_route).
///
/// See [`crate::client::fluent_builders::DeleteRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRoute {
    _private: (),
}
impl DeleteRoute {
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
    /// Creates a new `DeleteRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRoute {
    type Output =
        std::result::Result<crate::output::DeleteRouteOutput, crate::error::DeleteRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_route_error(response)
        } else {
            crate::operation_deser::parse_delete_route_response(response)
        }
    }
}

/// Operation shape for `DeleteRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route_table`](crate::client::Client::delete_route_table).
///
/// See [`crate::client::fluent_builders::DeleteRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRouteTable {
    _private: (),
}
impl DeleteRouteTable {
    /// Creates a new builder-style object to manufacture [`DeleteRouteTableInput`](crate::input::DeleteRouteTableInput)
    pub fn builder() -> crate::input::delete_route_table_input::Builder {
        crate::input::delete_route_table_input::Builder::default()
    }
    /// Creates a new `DeleteRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRouteTable {
    type Output = std::result::Result<
        crate::output::DeleteRouteTableOutput,
        crate::error::DeleteRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_route_table_error(response)
        } else {
            crate::operation_deser::parse_delete_route_table_response(response)
        }
    }
}

/// Operation shape for `DeleteSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_security_group`](crate::client::Client::delete_security_group).
///
/// See [`crate::client::fluent_builders::DeleteSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSecurityGroup {
    _private: (),
}
impl DeleteSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityGroupInput`](crate::input::DeleteSecurityGroupInput)
    pub fn builder() -> crate::input::delete_security_group_input::Builder {
        crate::input::delete_security_group_input::Builder::default()
    }
    /// Creates a new `DeleteSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSecurityGroup {
    type Output = std::result::Result<
        crate::output::DeleteSecurityGroupOutput,
        crate::error::DeleteSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_security_group_error(response)
        } else {
            crate::operation_deser::parse_delete_security_group_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot`](crate::client::Client::delete_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshot {
    _private: (),
}
impl DeleteSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshot {
    type Output =
        std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteSpotDatafeedSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_spot_datafeed_subscription`](crate::client::Client::delete_spot_datafeed_subscription).
///
/// See [`crate::client::fluent_builders::DeleteSpotDatafeedSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSpotDatafeedSubscription {
    _private: (),
}
impl DeleteSpotDatafeedSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteSpotDatafeedSubscriptionInput`](crate::input::DeleteSpotDatafeedSubscriptionInput)
    pub fn builder() -> crate::input::delete_spot_datafeed_subscription_input::Builder {
        crate::input::delete_spot_datafeed_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteSpotDatafeedSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSpotDatafeedSubscription {
    type Output = std::result::Result<
        crate::output::DeleteSpotDatafeedSubscriptionOutput,
        crate::error::DeleteSpotDatafeedSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_spot_datafeed_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_spot_datafeed_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteSubnet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subnet`](crate::client::Client::delete_subnet).
///
/// See [`crate::client::fluent_builders::DeleteSubnet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubnet {
    _private: (),
}
impl DeleteSubnet {
    /// Creates a new builder-style object to manufacture [`DeleteSubnetInput`](crate::input::DeleteSubnetInput)
    pub fn builder() -> crate::input::delete_subnet_input::Builder {
        crate::input::delete_subnet_input::Builder::default()
    }
    /// Creates a new `DeleteSubnet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubnet {
    type Output =
        std::result::Result<crate::output::DeleteSubnetOutput, crate::error::DeleteSubnetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subnet_error(response)
        } else {
            crate::operation_deser::parse_delete_subnet_response(response)
        }
    }
}

/// Operation shape for `DeleteSubnetCidrReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subnet_cidr_reservation`](crate::client::Client::delete_subnet_cidr_reservation).
///
/// See [`crate::client::fluent_builders::DeleteSubnetCidrReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubnetCidrReservation {
    _private: (),
}
impl DeleteSubnetCidrReservation {
    /// Creates a new builder-style object to manufacture [`DeleteSubnetCidrReservationInput`](crate::input::DeleteSubnetCidrReservationInput)
    pub fn builder() -> crate::input::delete_subnet_cidr_reservation_input::Builder {
        crate::input::delete_subnet_cidr_reservation_input::Builder::default()
    }
    /// Creates a new `DeleteSubnetCidrReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubnetCidrReservation {
    type Output = std::result::Result<
        crate::output::DeleteSubnetCidrReservationOutput,
        crate::error::DeleteSubnetCidrReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subnet_cidr_reservation_error(response)
        } else {
            crate::operation_deser::parse_delete_subnet_cidr_reservation_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficMirrorFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_mirror_filter`](crate::client::Client::delete_traffic_mirror_filter).
///
/// See [`crate::client::fluent_builders::DeleteTrafficMirrorFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficMirrorFilter {
    _private: (),
}
impl DeleteTrafficMirrorFilter {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficMirrorFilterInput`](crate::input::DeleteTrafficMirrorFilterInput)
    pub fn builder() -> crate::input::delete_traffic_mirror_filter_input::Builder {
        crate::input::delete_traffic_mirror_filter_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficMirrorFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficMirrorFilter {
    type Output = std::result::Result<
        crate::output::DeleteTrafficMirrorFilterOutput,
        crate::error::DeleteTrafficMirrorFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_mirror_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_mirror_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficMirrorFilterRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_mirror_filter_rule`](crate::client::Client::delete_traffic_mirror_filter_rule).
///
/// See [`crate::client::fluent_builders::DeleteTrafficMirrorFilterRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficMirrorFilterRule {
    _private: (),
}
impl DeleteTrafficMirrorFilterRule {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficMirrorFilterRuleInput`](crate::input::DeleteTrafficMirrorFilterRuleInput)
    pub fn builder() -> crate::input::delete_traffic_mirror_filter_rule_input::Builder {
        crate::input::delete_traffic_mirror_filter_rule_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficMirrorFilterRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficMirrorFilterRule {
    type Output = std::result::Result<
        crate::output::DeleteTrafficMirrorFilterRuleOutput,
        crate::error::DeleteTrafficMirrorFilterRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_mirror_filter_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_mirror_filter_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficMirrorSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_mirror_session`](crate::client::Client::delete_traffic_mirror_session).
///
/// See [`crate::client::fluent_builders::DeleteTrafficMirrorSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficMirrorSession {
    _private: (),
}
impl DeleteTrafficMirrorSession {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficMirrorSessionInput`](crate::input::DeleteTrafficMirrorSessionInput)
    pub fn builder() -> crate::input::delete_traffic_mirror_session_input::Builder {
        crate::input::delete_traffic_mirror_session_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficMirrorSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficMirrorSession {
    type Output = std::result::Result<
        crate::output::DeleteTrafficMirrorSessionOutput,
        crate::error::DeleteTrafficMirrorSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_mirror_session_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_mirror_session_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficMirrorTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_mirror_target`](crate::client::Client::delete_traffic_mirror_target).
///
/// See [`crate::client::fluent_builders::DeleteTrafficMirrorTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficMirrorTarget {
    _private: (),
}
impl DeleteTrafficMirrorTarget {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficMirrorTargetInput`](crate::input::DeleteTrafficMirrorTargetInput)
    pub fn builder() -> crate::input::delete_traffic_mirror_target_input::Builder {
        crate::input::delete_traffic_mirror_target_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficMirrorTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficMirrorTarget {
    type Output = std::result::Result<
        crate::output::DeleteTrafficMirrorTargetOutput,
        crate::error::DeleteTrafficMirrorTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_mirror_target_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_mirror_target_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway`](crate::client::Client::delete_transit_gateway).
///
/// See [`crate::client::fluent_builders::DeleteTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGateway {
    _private: (),
}
impl DeleteTransitGateway {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayInput`](crate::input::DeleteTransitGatewayInput)
    pub fn builder() -> crate::input::delete_transit_gateway_input::Builder {
        crate::input::delete_transit_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGateway {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayOutput,
        crate::error::DeleteTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayConnect`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_connect`](crate::client::Client::delete_transit_gateway_connect).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayConnect`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayConnect {
    _private: (),
}
impl DeleteTransitGatewayConnect {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayConnectInput`](crate::input::DeleteTransitGatewayConnectInput)
    pub fn builder() -> crate::input::delete_transit_gateway_connect_input::Builder {
        crate::input::delete_transit_gateway_connect_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayConnect` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayConnect {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayConnectOutput,
        crate::error::DeleteTransitGatewayConnectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_connect_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_connect_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayConnectPeer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_connect_peer`](crate::client::Client::delete_transit_gateway_connect_peer).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayConnectPeer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayConnectPeer {
    _private: (),
}
impl DeleteTransitGatewayConnectPeer {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayConnectPeerInput`](crate::input::DeleteTransitGatewayConnectPeerInput)
    pub fn builder() -> crate::input::delete_transit_gateway_connect_peer_input::Builder {
        crate::input::delete_transit_gateway_connect_peer_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayConnectPeer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayConnectPeer {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayConnectPeerOutput,
        crate::error::DeleteTransitGatewayConnectPeerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_connect_peer_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_connect_peer_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayMulticastDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_multicast_domain`](crate::client::Client::delete_transit_gateway_multicast_domain).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayMulticastDomain {
    _private: (),
}
impl DeleteTransitGatewayMulticastDomain {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayMulticastDomainInput`](crate::input::DeleteTransitGatewayMulticastDomainInput)
    pub fn builder() -> crate::input::delete_transit_gateway_multicast_domain_input::Builder {
        crate::input::delete_transit_gateway_multicast_domain_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayMulticastDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayMulticastDomain {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayMulticastDomainOutput,
        crate::error::DeleteTransitGatewayMulticastDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_multicast_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_multicast_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayPeeringAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_peering_attachment`](crate::client::Client::delete_transit_gateway_peering_attachment).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayPeeringAttachment {
    _private: (),
}
impl DeleteTransitGatewayPeeringAttachment {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayPeeringAttachmentInput`](crate::input::DeleteTransitGatewayPeeringAttachmentInput)
    pub fn builder() -> crate::input::delete_transit_gateway_peering_attachment_input::Builder {
        crate::input::delete_transit_gateway_peering_attachment_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayPeeringAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayPeeringAttachment {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayPeeringAttachmentOutput,
        crate::error::DeleteTransitGatewayPeeringAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_peering_attachment_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_peering_attachment_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteTransitGatewayPrefixListReference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_prefix_list_reference`](crate::client::Client::delete_transit_gateway_prefix_list_reference).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayPrefixListReference {
    _private: (),
}
impl DeleteTransitGatewayPrefixListReference {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayPrefixListReferenceInput`](crate::input::DeleteTransitGatewayPrefixListReferenceInput)
    pub fn builder() -> crate::input::delete_transit_gateway_prefix_list_reference_input::Builder {
        crate::input::delete_transit_gateway_prefix_list_reference_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayPrefixListReference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayPrefixListReference {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayPrefixListReferenceOutput,
        crate::error::DeleteTransitGatewayPrefixListReferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_prefix_list_reference_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_transit_gateway_prefix_list_reference_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteTransitGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_route`](crate::client::Client::delete_transit_gateway_route).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayRoute {
    _private: (),
}
impl DeleteTransitGatewayRoute {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayRouteInput`](crate::input::DeleteTransitGatewayRouteInput)
    pub fn builder() -> crate::input::delete_transit_gateway_route_input::Builder {
        crate::input::delete_transit_gateway_route_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayRoute {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayRouteOutput,
        crate::error::DeleteTransitGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_route_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_route_table`](crate::client::Client::delete_transit_gateway_route_table).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayRouteTable {
    _private: (),
}
impl DeleteTransitGatewayRouteTable {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayRouteTableInput`](crate::input::DeleteTransitGatewayRouteTableInput)
    pub fn builder() -> crate::input::delete_transit_gateway_route_table_input::Builder {
        crate::input::delete_transit_gateway_route_table_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayRouteTable {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayRouteTableOutput,
        crate::error::DeleteTransitGatewayRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_route_table_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_route_table_response(response)
        }
    }
}

/// Operation shape for `DeleteTransitGatewayVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_transit_gateway_vpc_attachment`](crate::client::Client::delete_transit_gateway_vpc_attachment).
///
/// See [`crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTransitGatewayVpcAttachment {
    _private: (),
}
impl DeleteTransitGatewayVpcAttachment {
    /// Creates a new builder-style object to manufacture [`DeleteTransitGatewayVpcAttachmentInput`](crate::input::DeleteTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::delete_transit_gateway_vpc_attachment_input::Builder {
        crate::input::delete_transit_gateway_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `DeleteTransitGatewayVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTransitGatewayVpcAttachment {
    type Output = std::result::Result<
        crate::output::DeleteTransitGatewayVpcAttachmentOutput,
        crate::error::DeleteTransitGatewayVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_transit_gateway_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_delete_transit_gateway_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `DeleteVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_volume`](crate::client::Client::delete_volume).
///
/// See [`crate::client::fluent_builders::DeleteVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVolume {
    _private: (),
}
impl DeleteVolume {
    /// Creates a new builder-style object to manufacture [`DeleteVolumeInput`](crate::input::DeleteVolumeInput)
    pub fn builder() -> crate::input::delete_volume_input::Builder {
        crate::input::delete_volume_input::Builder::default()
    }
    /// Creates a new `DeleteVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVolume {
    type Output =
        std::result::Result<crate::output::DeleteVolumeOutput, crate::error::DeleteVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_volume_error(response)
        } else {
            crate::operation_deser::parse_delete_volume_response(response)
        }
    }
}

/// Operation shape for `DeleteVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc`](crate::client::Client::delete_vpc).
///
/// See [`crate::client::fluent_builders::DeleteVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpc {
    _private: (),
}
impl DeleteVpc {
    /// Creates a new builder-style object to manufacture [`DeleteVpcInput`](crate::input::DeleteVpcInput)
    pub fn builder() -> crate::input::delete_vpc_input::Builder {
        crate::input::delete_vpc_input::Builder::default()
    }
    /// Creates a new `DeleteVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpc {
    type Output = std::result::Result<crate::output::DeleteVpcOutput, crate::error::DeleteVpcError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcEndpointConnectionNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_endpoint_connection_notifications`](crate::client::Client::delete_vpc_endpoint_connection_notifications).
///
/// See [`crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcEndpointConnectionNotifications {
    _private: (),
}
impl DeleteVpcEndpointConnectionNotifications {
    /// Creates a new builder-style object to manufacture [`DeleteVpcEndpointConnectionNotificationsInput`](crate::input::DeleteVpcEndpointConnectionNotificationsInput)
    pub fn builder() -> crate::input::delete_vpc_endpoint_connection_notifications_input::Builder {
        crate::input::delete_vpc_endpoint_connection_notifications_input::Builder::default()
    }
    /// Creates a new `DeleteVpcEndpointConnectionNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcEndpointConnectionNotifications {
    type Output = std::result::Result<
        crate::output::DeleteVpcEndpointConnectionNotificationsOutput,
        crate::error::DeleteVpcEndpointConnectionNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_endpoint_connection_notifications_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_vpc_endpoint_connection_notifications_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteVpcEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_endpoints`](crate::client::Client::delete_vpc_endpoints).
///
/// See [`crate::client::fluent_builders::DeleteVpcEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcEndpoints {
    _private: (),
}
impl DeleteVpcEndpoints {
    /// Creates a new builder-style object to manufacture [`DeleteVpcEndpointsInput`](crate::input::DeleteVpcEndpointsInput)
    pub fn builder() -> crate::input::delete_vpc_endpoints_input::Builder {
        crate::input::delete_vpc_endpoints_input::Builder::default()
    }
    /// Creates a new `DeleteVpcEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcEndpoints {
    type Output = std::result::Result<
        crate::output::DeleteVpcEndpointsOutput,
        crate::error::DeleteVpcEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_endpoints_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_endpoints_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcEndpointServiceConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_endpoint_service_configurations`](crate::client::Client::delete_vpc_endpoint_service_configurations).
///
/// See [`crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcEndpointServiceConfigurations {
    _private: (),
}
impl DeleteVpcEndpointServiceConfigurations {
    /// Creates a new builder-style object to manufacture [`DeleteVpcEndpointServiceConfigurationsInput`](crate::input::DeleteVpcEndpointServiceConfigurationsInput)
    pub fn builder() -> crate::input::delete_vpc_endpoint_service_configurations_input::Builder {
        crate::input::delete_vpc_endpoint_service_configurations_input::Builder::default()
    }
    /// Creates a new `DeleteVpcEndpointServiceConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcEndpointServiceConfigurations {
    type Output = std::result::Result<
        crate::output::DeleteVpcEndpointServiceConfigurationsOutput,
        crate::error::DeleteVpcEndpointServiceConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_endpoint_service_configurations_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_endpoint_service_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_peering_connection`](crate::client::Client::delete_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::DeleteVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcPeeringConnection {
    _private: (),
}
impl DeleteVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`DeleteVpcPeeringConnectionInput`](crate::input::DeleteVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::delete_vpc_peering_connection_input::Builder {
        crate::input::delete_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `DeleteVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::DeleteVpcPeeringConnectionOutput,
        crate::error::DeleteVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteVpnConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpn_connection`](crate::client::Client::delete_vpn_connection).
///
/// See [`crate::client::fluent_builders::DeleteVpnConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpnConnection {
    _private: (),
}
impl DeleteVpnConnection {
    /// Creates a new builder-style object to manufacture [`DeleteVpnConnectionInput`](crate::input::DeleteVpnConnectionInput)
    pub fn builder() -> crate::input::delete_vpn_connection_input::Builder {
        crate::input::delete_vpn_connection_input::Builder::default()
    }
    /// Creates a new `DeleteVpnConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpnConnection {
    type Output = std::result::Result<
        crate::output::DeleteVpnConnectionOutput,
        crate::error::DeleteVpnConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpn_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_vpn_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteVpnConnectionRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpn_connection_route`](crate::client::Client::delete_vpn_connection_route).
///
/// See [`crate::client::fluent_builders::DeleteVpnConnectionRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpnConnectionRoute {
    _private: (),
}
impl DeleteVpnConnectionRoute {
    /// Creates a new builder-style object to manufacture [`DeleteVpnConnectionRouteInput`](crate::input::DeleteVpnConnectionRouteInput)
    pub fn builder() -> crate::input::delete_vpn_connection_route_input::Builder {
        crate::input::delete_vpn_connection_route_input::Builder::default()
    }
    /// Creates a new `DeleteVpnConnectionRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpnConnectionRoute {
    type Output = std::result::Result<
        crate::output::DeleteVpnConnectionRouteOutput,
        crate::error::DeleteVpnConnectionRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpn_connection_route_error(response)
        } else {
            crate::operation_deser::parse_delete_vpn_connection_route_response(response)
        }
    }
}

/// Operation shape for `DeleteVpnGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpn_gateway`](crate::client::Client::delete_vpn_gateway).
///
/// See [`crate::client::fluent_builders::DeleteVpnGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpnGateway {
    _private: (),
}
impl DeleteVpnGateway {
    /// Creates a new builder-style object to manufacture [`DeleteVpnGatewayInput`](crate::input::DeleteVpnGatewayInput)
    pub fn builder() -> crate::input::delete_vpn_gateway_input::Builder {
        crate::input::delete_vpn_gateway_input::Builder::default()
    }
    /// Creates a new `DeleteVpnGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpnGateway {
    type Output = std::result::Result<
        crate::output::DeleteVpnGatewayOutput,
        crate::error::DeleteVpnGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpn_gateway_error(response)
        } else {
            crate::operation_deser::parse_delete_vpn_gateway_response(response)
        }
    }
}

/// Operation shape for `DeprovisionByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprovision_byoip_cidr`](crate::client::Client::deprovision_byoip_cidr).
///
/// See [`crate::client::fluent_builders::DeprovisionByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprovisionByoipCidr {
    _private: (),
}
impl DeprovisionByoipCidr {
    /// Creates a new builder-style object to manufacture [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
    pub fn builder() -> crate::input::deprovision_byoip_cidr_input::Builder {
        crate::input::deprovision_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `DeprovisionByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprovisionByoipCidr {
    type Output = std::result::Result<
        crate::output::DeprovisionByoipCidrOutput,
        crate::error::DeprovisionByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprovision_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_deprovision_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `DeprovisionIpamPoolCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprovision_ipam_pool_cidr`](crate::client::Client::deprovision_ipam_pool_cidr).
///
/// See [`crate::client::fluent_builders::DeprovisionIpamPoolCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprovisionIpamPoolCidr {
    _private: (),
}
impl DeprovisionIpamPoolCidr {
    /// Creates a new builder-style object to manufacture [`DeprovisionIpamPoolCidrInput`](crate::input::DeprovisionIpamPoolCidrInput)
    pub fn builder() -> crate::input::deprovision_ipam_pool_cidr_input::Builder {
        crate::input::deprovision_ipam_pool_cidr_input::Builder::default()
    }
    /// Creates a new `DeprovisionIpamPoolCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprovisionIpamPoolCidr {
    type Output = std::result::Result<
        crate::output::DeprovisionIpamPoolCidrOutput,
        crate::error::DeprovisionIpamPoolCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprovision_ipam_pool_cidr_error(response)
        } else {
            crate::operation_deser::parse_deprovision_ipam_pool_cidr_response(response)
        }
    }
}

/// Operation shape for `DeprovisionPublicIpv4PoolCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprovision_public_ipv4_pool_cidr`](crate::client::Client::deprovision_public_ipv4_pool_cidr).
///
/// See [`crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprovisionPublicIpv4PoolCidr {
    _private: (),
}
impl DeprovisionPublicIpv4PoolCidr {
    /// Creates a new builder-style object to manufacture [`DeprovisionPublicIpv4PoolCidrInput`](crate::input::DeprovisionPublicIpv4PoolCidrInput)
    pub fn builder() -> crate::input::deprovision_public_ipv4_pool_cidr_input::Builder {
        crate::input::deprovision_public_ipv4_pool_cidr_input::Builder::default()
    }
    /// Creates a new `DeprovisionPublicIpv4PoolCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprovisionPublicIpv4PoolCidr {
    type Output = std::result::Result<
        crate::output::DeprovisionPublicIpv4PoolCidrOutput,
        crate::error::DeprovisionPublicIpv4PoolCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprovision_public_ipv4_pool_cidr_error(response)
        } else {
            crate::operation_deser::parse_deprovision_public_ipv4_pool_cidr_response(response)
        }
    }
}

/// Operation shape for `DeregisterImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_image`](crate::client::Client::deregister_image).
///
/// See [`crate::client::fluent_builders::DeregisterImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterImage {
    _private: (),
}
impl DeregisterImage {
    /// Creates a new builder-style object to manufacture [`DeregisterImageInput`](crate::input::DeregisterImageInput)
    pub fn builder() -> crate::input::deregister_image_input::Builder {
        crate::input::deregister_image_input::Builder::default()
    }
    /// Creates a new `DeregisterImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterImage {
    type Output = std::result::Result<
        crate::output::DeregisterImageOutput,
        crate::error::DeregisterImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_image_error(response)
        } else {
            crate::operation_deser::parse_deregister_image_response(response)
        }
    }
}

/// Operation shape for `DeregisterInstanceEventNotificationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_instance_event_notification_attributes`](crate::client::Client::deregister_instance_event_notification_attributes).
///
/// See [`crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterInstanceEventNotificationAttributes {
    _private: (),
}
impl DeregisterInstanceEventNotificationAttributes {
    /// Creates a new builder-style object to manufacture [`DeregisterInstanceEventNotificationAttributesInput`](crate::input::DeregisterInstanceEventNotificationAttributesInput)
    pub fn builder(
    ) -> crate::input::deregister_instance_event_notification_attributes_input::Builder {
        crate::input::deregister_instance_event_notification_attributes_input::Builder::default()
    }
    /// Creates a new `DeregisterInstanceEventNotificationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeregisterInstanceEventNotificationAttributes
{
    type Output = std::result::Result<
        crate::output::DeregisterInstanceEventNotificationAttributesOutput,
        crate::error::DeregisterInstanceEventNotificationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_instance_event_notification_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_deregister_instance_event_notification_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeregisterTransitGatewayMulticastGroupMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_transit_gateway_multicast_group_members`](crate::client::Client::deregister_transit_gateway_multicast_group_members).
///
/// See [`crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTransitGatewayMulticastGroupMembers {
    _private: (),
}
impl DeregisterTransitGatewayMulticastGroupMembers {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayMulticastGroupMembersInput`](crate::input::DeregisterTransitGatewayMulticastGroupMembersInput)
    pub fn builder(
    ) -> crate::input::deregister_transit_gateway_multicast_group_members_input::Builder {
        crate::input::deregister_transit_gateway_multicast_group_members_input::Builder::default()
    }
    /// Creates a new `DeregisterTransitGatewayMulticastGroupMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeregisterTransitGatewayMulticastGroupMembers
{
    type Output = std::result::Result<
        crate::output::DeregisterTransitGatewayMulticastGroupMembersOutput,
        crate::error::DeregisterTransitGatewayMulticastGroupMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_transit_gateway_multicast_group_members_error(
                response,
            )
        } else {
            crate::operation_deser::parse_deregister_transit_gateway_multicast_group_members_response(response)
        }
    }
}

/// Operation shape for `DeregisterTransitGatewayMulticastGroupSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_transit_gateway_multicast_group_sources`](crate::client::Client::deregister_transit_gateway_multicast_group_sources).
///
/// See [`crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTransitGatewayMulticastGroupSources {
    _private: (),
}
impl DeregisterTransitGatewayMulticastGroupSources {
    /// Creates a new builder-style object to manufacture [`DeregisterTransitGatewayMulticastGroupSourcesInput`](crate::input::DeregisterTransitGatewayMulticastGroupSourcesInput)
    pub fn builder(
    ) -> crate::input::deregister_transit_gateway_multicast_group_sources_input::Builder {
        crate::input::deregister_transit_gateway_multicast_group_sources_input::Builder::default()
    }
    /// Creates a new `DeregisterTransitGatewayMulticastGroupSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeregisterTransitGatewayMulticastGroupSources
{
    type Output = std::result::Result<
        crate::output::DeregisterTransitGatewayMulticastGroupSourcesOutput,
        crate::error::DeregisterTransitGatewayMulticastGroupSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_transit_gateway_multicast_group_sources_error(
                response,
            )
        } else {
            crate::operation_deser::parse_deregister_transit_gateway_multicast_group_sources_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_addresses`](crate::client::Client::describe_addresses).
///
/// See [`crate::client::fluent_builders::DescribeAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAddresses {
    _private: (),
}
impl DescribeAddresses {
    /// Creates a new builder-style object to manufacture [`DescribeAddressesInput`](crate::input::DescribeAddressesInput)
    pub fn builder() -> crate::input::describe_addresses_input::Builder {
        crate::input::describe_addresses_input::Builder::default()
    }
    /// Creates a new `DescribeAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAddresses {
    type Output = std::result::Result<
        crate::output::DescribeAddressesOutput,
        crate::error::DescribeAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_addresses_error(response)
        } else {
            crate::operation_deser::parse_describe_addresses_response(response)
        }
    }
}

/// Operation shape for `DescribeAddressesAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_addresses_attribute`](crate::client::Client::describe_addresses_attribute).
///
/// See [`crate::client::fluent_builders::DescribeAddressesAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAddressesAttribute {
    _private: (),
}
impl DescribeAddressesAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeAddressesAttributeInput`](crate::input::DescribeAddressesAttributeInput)
    pub fn builder() -> crate::input::describe_addresses_attribute_input::Builder {
        crate::input::describe_addresses_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeAddressesAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAddressesAttribute {
    type Output = std::result::Result<
        crate::output::DescribeAddressesAttributeOutput,
        crate::error::DescribeAddressesAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_addresses_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_addresses_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeAggregateIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_aggregate_id_format`](crate::client::Client::describe_aggregate_id_format).
///
/// See [`crate::client::fluent_builders::DescribeAggregateIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAggregateIdFormat {
    _private: (),
}
impl DescribeAggregateIdFormat {
    /// Creates a new builder-style object to manufacture [`DescribeAggregateIdFormatInput`](crate::input::DescribeAggregateIdFormatInput)
    pub fn builder() -> crate::input::describe_aggregate_id_format_input::Builder {
        crate::input::describe_aggregate_id_format_input::Builder::default()
    }
    /// Creates a new `DescribeAggregateIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAggregateIdFormat {
    type Output = std::result::Result<
        crate::output::DescribeAggregateIdFormatOutput,
        crate::error::DescribeAggregateIdFormatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_aggregate_id_format_error(response)
        } else {
            crate::operation_deser::parse_describe_aggregate_id_format_response(response)
        }
    }
}

/// Operation shape for `DescribeAvailabilityZones`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_availability_zones`](crate::client::Client::describe_availability_zones).
///
/// See [`crate::client::fluent_builders::DescribeAvailabilityZones`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAvailabilityZones {
    _private: (),
}
impl DescribeAvailabilityZones {
    /// Creates a new builder-style object to manufacture [`DescribeAvailabilityZonesInput`](crate::input::DescribeAvailabilityZonesInput)
    pub fn builder() -> crate::input::describe_availability_zones_input::Builder {
        crate::input::describe_availability_zones_input::Builder::default()
    }
    /// Creates a new `DescribeAvailabilityZones` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAvailabilityZones {
    type Output = std::result::Result<
        crate::output::DescribeAvailabilityZonesOutput,
        crate::error::DescribeAvailabilityZonesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_availability_zones_error(response)
        } else {
            crate::operation_deser::parse_describe_availability_zones_response(response)
        }
    }
}

/// Operation shape for `DescribeBundleTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bundle_tasks`](crate::client::Client::describe_bundle_tasks).
///
/// See [`crate::client::fluent_builders::DescribeBundleTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBundleTasks {
    _private: (),
}
impl DescribeBundleTasks {
    /// Creates a new builder-style object to manufacture [`DescribeBundleTasksInput`](crate::input::DescribeBundleTasksInput)
    pub fn builder() -> crate::input::describe_bundle_tasks_input::Builder {
        crate::input::describe_bundle_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeBundleTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBundleTasks {
    type Output = std::result::Result<
        crate::output::DescribeBundleTasksOutput,
        crate::error::DescribeBundleTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bundle_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_bundle_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeByoipCidrs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_byoip_cidrs`](crate::client::Client::describe_byoip_cidrs).
///
/// See [`crate::client::fluent_builders::DescribeByoipCidrs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeByoipCidrs {
    _private: (),
}
impl DescribeByoipCidrs {
    /// Creates a new builder-style object to manufacture [`DescribeByoipCidrsInput`](crate::input::DescribeByoipCidrsInput)
    pub fn builder() -> crate::input::describe_byoip_cidrs_input::Builder {
        crate::input::describe_byoip_cidrs_input::Builder::default()
    }
    /// Creates a new `DescribeByoipCidrs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeByoipCidrs {
    type Output = std::result::Result<
        crate::output::DescribeByoipCidrsOutput,
        crate::error::DescribeByoipCidrsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_byoip_cidrs_error(response)
        } else {
            crate::operation_deser::parse_describe_byoip_cidrs_response(response)
        }
    }
}

/// Operation shape for `DescribeCapacityReservationFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_capacity_reservation_fleets`](crate::client::Client::describe_capacity_reservation_fleets).
///
/// See [`crate::client::fluent_builders::DescribeCapacityReservationFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCapacityReservationFleets {
    _private: (),
}
impl DescribeCapacityReservationFleets {
    /// Creates a new builder-style object to manufacture [`DescribeCapacityReservationFleetsInput`](crate::input::DescribeCapacityReservationFleetsInput)
    pub fn builder() -> crate::input::describe_capacity_reservation_fleets_input::Builder {
        crate::input::describe_capacity_reservation_fleets_input::Builder::default()
    }
    /// Creates a new `DescribeCapacityReservationFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCapacityReservationFleets {
    type Output = std::result::Result<
        crate::output::DescribeCapacityReservationFleetsOutput,
        crate::error::DescribeCapacityReservationFleetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_capacity_reservation_fleets_error(response)
        } else {
            crate::operation_deser::parse_describe_capacity_reservation_fleets_response(response)
        }
    }
}

/// Operation shape for `DescribeCapacityReservations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_capacity_reservations`](crate::client::Client::describe_capacity_reservations).
///
/// See [`crate::client::fluent_builders::DescribeCapacityReservations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCapacityReservations {
    _private: (),
}
impl DescribeCapacityReservations {
    /// Creates a new builder-style object to manufacture [`DescribeCapacityReservationsInput`](crate::input::DescribeCapacityReservationsInput)
    pub fn builder() -> crate::input::describe_capacity_reservations_input::Builder {
        crate::input::describe_capacity_reservations_input::Builder::default()
    }
    /// Creates a new `DescribeCapacityReservations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCapacityReservations {
    type Output = std::result::Result<
        crate::output::DescribeCapacityReservationsOutput,
        crate::error::DescribeCapacityReservationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_capacity_reservations_error(response)
        } else {
            crate::operation_deser::parse_describe_capacity_reservations_response(response)
        }
    }
}

/// Operation shape for `DescribeCarrierGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_carrier_gateways`](crate::client::Client::describe_carrier_gateways).
///
/// See [`crate::client::fluent_builders::DescribeCarrierGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCarrierGateways {
    _private: (),
}
impl DescribeCarrierGateways {
    /// Creates a new builder-style object to manufacture [`DescribeCarrierGatewaysInput`](crate::input::DescribeCarrierGatewaysInput)
    pub fn builder() -> crate::input::describe_carrier_gateways_input::Builder {
        crate::input::describe_carrier_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeCarrierGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCarrierGateways {
    type Output = std::result::Result<
        crate::output::DescribeCarrierGatewaysOutput,
        crate::error::DescribeCarrierGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_carrier_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_carrier_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeClassicLinkInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_classic_link_instances`](crate::client::Client::describe_classic_link_instances).
///
/// See [`crate::client::fluent_builders::DescribeClassicLinkInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClassicLinkInstances {
    _private: (),
}
impl DescribeClassicLinkInstances {
    /// Creates a new builder-style object to manufacture [`DescribeClassicLinkInstancesInput`](crate::input::DescribeClassicLinkInstancesInput)
    pub fn builder() -> crate::input::describe_classic_link_instances_input::Builder {
        crate::input::describe_classic_link_instances_input::Builder::default()
    }
    /// Creates a new `DescribeClassicLinkInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClassicLinkInstances {
    type Output = std::result::Result<
        crate::output::DescribeClassicLinkInstancesOutput,
        crate::error::DescribeClassicLinkInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_classic_link_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_classic_link_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeClientVpnAuthorizationRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_vpn_authorization_rules`](crate::client::Client::describe_client_vpn_authorization_rules).
///
/// See [`crate::client::fluent_builders::DescribeClientVpnAuthorizationRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientVpnAuthorizationRules {
    _private: (),
}
impl DescribeClientVpnAuthorizationRules {
    /// Creates a new builder-style object to manufacture [`DescribeClientVpnAuthorizationRulesInput`](crate::input::DescribeClientVpnAuthorizationRulesInput)
    pub fn builder() -> crate::input::describe_client_vpn_authorization_rules_input::Builder {
        crate::input::describe_client_vpn_authorization_rules_input::Builder::default()
    }
    /// Creates a new `DescribeClientVpnAuthorizationRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientVpnAuthorizationRules {
    type Output = std::result::Result<
        crate::output::DescribeClientVpnAuthorizationRulesOutput,
        crate::error::DescribeClientVpnAuthorizationRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_vpn_authorization_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_client_vpn_authorization_rules_response(response)
        }
    }
}

/// Operation shape for `DescribeClientVpnConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_vpn_connections`](crate::client::Client::describe_client_vpn_connections).
///
/// See [`crate::client::fluent_builders::DescribeClientVpnConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientVpnConnections {
    _private: (),
}
impl DescribeClientVpnConnections {
    /// Creates a new builder-style object to manufacture [`DescribeClientVpnConnectionsInput`](crate::input::DescribeClientVpnConnectionsInput)
    pub fn builder() -> crate::input::describe_client_vpn_connections_input::Builder {
        crate::input::describe_client_vpn_connections_input::Builder::default()
    }
    /// Creates a new `DescribeClientVpnConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientVpnConnections {
    type Output = std::result::Result<
        crate::output::DescribeClientVpnConnectionsOutput,
        crate::error::DescribeClientVpnConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_vpn_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_client_vpn_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeClientVpnEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_vpn_endpoints`](crate::client::Client::describe_client_vpn_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeClientVpnEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientVpnEndpoints {
    _private: (),
}
impl DescribeClientVpnEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeClientVpnEndpointsInput`](crate::input::DescribeClientVpnEndpointsInput)
    pub fn builder() -> crate::input::describe_client_vpn_endpoints_input::Builder {
        crate::input::describe_client_vpn_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeClientVpnEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientVpnEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeClientVpnEndpointsOutput,
        crate::error::DescribeClientVpnEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_vpn_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_client_vpn_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeClientVpnRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_vpn_routes`](crate::client::Client::describe_client_vpn_routes).
///
/// See [`crate::client::fluent_builders::DescribeClientVpnRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientVpnRoutes {
    _private: (),
}
impl DescribeClientVpnRoutes {
    /// Creates a new builder-style object to manufacture [`DescribeClientVpnRoutesInput`](crate::input::DescribeClientVpnRoutesInput)
    pub fn builder() -> crate::input::describe_client_vpn_routes_input::Builder {
        crate::input::describe_client_vpn_routes_input::Builder::default()
    }
    /// Creates a new `DescribeClientVpnRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientVpnRoutes {
    type Output = std::result::Result<
        crate::output::DescribeClientVpnRoutesOutput,
        crate::error::DescribeClientVpnRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_vpn_routes_error(response)
        } else {
            crate::operation_deser::parse_describe_client_vpn_routes_response(response)
        }
    }
}

/// Operation shape for `DescribeClientVpnTargetNetworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_client_vpn_target_networks`](crate::client::Client::describe_client_vpn_target_networks).
///
/// See [`crate::client::fluent_builders::DescribeClientVpnTargetNetworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClientVpnTargetNetworks {
    _private: (),
}
impl DescribeClientVpnTargetNetworks {
    /// Creates a new builder-style object to manufacture [`DescribeClientVpnTargetNetworksInput`](crate::input::DescribeClientVpnTargetNetworksInput)
    pub fn builder() -> crate::input::describe_client_vpn_target_networks_input::Builder {
        crate::input::describe_client_vpn_target_networks_input::Builder::default()
    }
    /// Creates a new `DescribeClientVpnTargetNetworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClientVpnTargetNetworks {
    type Output = std::result::Result<
        crate::output::DescribeClientVpnTargetNetworksOutput,
        crate::error::DescribeClientVpnTargetNetworksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_client_vpn_target_networks_error(response)
        } else {
            crate::operation_deser::parse_describe_client_vpn_target_networks_response(response)
        }
    }
}

/// Operation shape for `DescribeCoipPools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_coip_pools`](crate::client::Client::describe_coip_pools).
///
/// See [`crate::client::fluent_builders::DescribeCoipPools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCoipPools {
    _private: (),
}
impl DescribeCoipPools {
    /// Creates a new builder-style object to manufacture [`DescribeCoipPoolsInput`](crate::input::DescribeCoipPoolsInput)
    pub fn builder() -> crate::input::describe_coip_pools_input::Builder {
        crate::input::describe_coip_pools_input::Builder::default()
    }
    /// Creates a new `DescribeCoipPools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCoipPools {
    type Output = std::result::Result<
        crate::output::DescribeCoipPoolsOutput,
        crate::error::DescribeCoipPoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_coip_pools_error(response)
        } else {
            crate::operation_deser::parse_describe_coip_pools_response(response)
        }
    }
}

/// Operation shape for `DescribeConversionTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_conversion_tasks`](crate::client::Client::describe_conversion_tasks).
///
/// See [`crate::client::fluent_builders::DescribeConversionTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeConversionTasks {
    _private: (),
}
impl DescribeConversionTasks {
    /// Creates a new builder-style object to manufacture [`DescribeConversionTasksInput`](crate::input::DescribeConversionTasksInput)
    pub fn builder() -> crate::input::describe_conversion_tasks_input::Builder {
        crate::input::describe_conversion_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeConversionTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeConversionTasks {
    type Output = std::result::Result<
        crate::output::DescribeConversionTasksOutput,
        crate::error::DescribeConversionTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_conversion_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_conversion_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomerGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_customer_gateways`](crate::client::Client::describe_customer_gateways).
///
/// See [`crate::client::fluent_builders::DescribeCustomerGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomerGateways {
    _private: (),
}
impl DescribeCustomerGateways {
    /// Creates a new builder-style object to manufacture [`DescribeCustomerGatewaysInput`](crate::input::DescribeCustomerGatewaysInput)
    pub fn builder() -> crate::input::describe_customer_gateways_input::Builder {
        crate::input::describe_customer_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeCustomerGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomerGateways {
    type Output = std::result::Result<
        crate::output::DescribeCustomerGatewaysOutput,
        crate::error::DescribeCustomerGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_customer_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_customer_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeDhcpOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dhcp_options`](crate::client::Client::describe_dhcp_options).
///
/// See [`crate::client::fluent_builders::DescribeDhcpOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDhcpOptions {
    _private: (),
}
impl DescribeDhcpOptions {
    /// Creates a new builder-style object to manufacture [`DescribeDhcpOptionsInput`](crate::input::DescribeDhcpOptionsInput)
    pub fn builder() -> crate::input::describe_dhcp_options_input::Builder {
        crate::input::describe_dhcp_options_input::Builder::default()
    }
    /// Creates a new `DescribeDhcpOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDhcpOptions {
    type Output = std::result::Result<
        crate::output::DescribeDhcpOptionsOutput,
        crate::error::DescribeDhcpOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dhcp_options_error(response)
        } else {
            crate::operation_deser::parse_describe_dhcp_options_response(response)
        }
    }
}

/// Operation shape for `DescribeEgressOnlyInternetGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_egress_only_internet_gateways`](crate::client::Client::describe_egress_only_internet_gateways).
///
/// See [`crate::client::fluent_builders::DescribeEgressOnlyInternetGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEgressOnlyInternetGateways {
    _private: (),
}
impl DescribeEgressOnlyInternetGateways {
    /// Creates a new builder-style object to manufacture [`DescribeEgressOnlyInternetGatewaysInput`](crate::input::DescribeEgressOnlyInternetGatewaysInput)
    pub fn builder() -> crate::input::describe_egress_only_internet_gateways_input::Builder {
        crate::input::describe_egress_only_internet_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeEgressOnlyInternetGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEgressOnlyInternetGateways {
    type Output = std::result::Result<
        crate::output::DescribeEgressOnlyInternetGatewaysOutput,
        crate::error::DescribeEgressOnlyInternetGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_egress_only_internet_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_egress_only_internet_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeElasticGpus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_elastic_gpus`](crate::client::Client::describe_elastic_gpus).
///
/// See [`crate::client::fluent_builders::DescribeElasticGpus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeElasticGpus {
    _private: (),
}
impl DescribeElasticGpus {
    /// Creates a new builder-style object to manufacture [`DescribeElasticGpusInput`](crate::input::DescribeElasticGpusInput)
    pub fn builder() -> crate::input::describe_elastic_gpus_input::Builder {
        crate::input::describe_elastic_gpus_input::Builder::default()
    }
    /// Creates a new `DescribeElasticGpus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeElasticGpus {
    type Output = std::result::Result<
        crate::output::DescribeElasticGpusOutput,
        crate::error::DescribeElasticGpusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_elastic_gpus_error(response)
        } else {
            crate::operation_deser::parse_describe_elastic_gpus_response(response)
        }
    }
}

/// Operation shape for `DescribeExportImageTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export_image_tasks`](crate::client::Client::describe_export_image_tasks).
///
/// See [`crate::client::fluent_builders::DescribeExportImageTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExportImageTasks {
    _private: (),
}
impl DescribeExportImageTasks {
    /// Creates a new builder-style object to manufacture [`DescribeExportImageTasksInput`](crate::input::DescribeExportImageTasksInput)
    pub fn builder() -> crate::input::describe_export_image_tasks_input::Builder {
        crate::input::describe_export_image_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeExportImageTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExportImageTasks {
    type Output = std::result::Result<
        crate::output::DescribeExportImageTasksOutput,
        crate::error::DescribeExportImageTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_image_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_export_image_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeExportTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export_tasks`](crate::client::Client::describe_export_tasks).
///
/// See [`crate::client::fluent_builders::DescribeExportTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExportTasks {
    _private: (),
}
impl DescribeExportTasks {
    /// Creates a new builder-style object to manufacture [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
    pub fn builder() -> crate::input::describe_export_tasks_input::Builder {
        crate::input::describe_export_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeExportTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExportTasks {
    type Output = std::result::Result<
        crate::output::DescribeExportTasksOutput,
        crate::error::DescribeExportTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_export_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeFastLaunchImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fast_launch_images`](crate::client::Client::describe_fast_launch_images).
///
/// See [`crate::client::fluent_builders::DescribeFastLaunchImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFastLaunchImages {
    _private: (),
}
impl DescribeFastLaunchImages {
    /// Creates a new builder-style object to manufacture [`DescribeFastLaunchImagesInput`](crate::input::DescribeFastLaunchImagesInput)
    pub fn builder() -> crate::input::describe_fast_launch_images_input::Builder {
        crate::input::describe_fast_launch_images_input::Builder::default()
    }
    /// Creates a new `DescribeFastLaunchImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFastLaunchImages {
    type Output = std::result::Result<
        crate::output::DescribeFastLaunchImagesOutput,
        crate::error::DescribeFastLaunchImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fast_launch_images_error(response)
        } else {
            crate::operation_deser::parse_describe_fast_launch_images_response(response)
        }
    }
}

/// Operation shape for `DescribeFastSnapshotRestores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fast_snapshot_restores`](crate::client::Client::describe_fast_snapshot_restores).
///
/// See [`crate::client::fluent_builders::DescribeFastSnapshotRestores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFastSnapshotRestores {
    _private: (),
}
impl DescribeFastSnapshotRestores {
    /// Creates a new builder-style object to manufacture [`DescribeFastSnapshotRestoresInput`](crate::input::DescribeFastSnapshotRestoresInput)
    pub fn builder() -> crate::input::describe_fast_snapshot_restores_input::Builder {
        crate::input::describe_fast_snapshot_restores_input::Builder::default()
    }
    /// Creates a new `DescribeFastSnapshotRestores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFastSnapshotRestores {
    type Output = std::result::Result<
        crate::output::DescribeFastSnapshotRestoresOutput,
        crate::error::DescribeFastSnapshotRestoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fast_snapshot_restores_error(response)
        } else {
            crate::operation_deser::parse_describe_fast_snapshot_restores_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_history`](crate::client::Client::describe_fleet_history).
///
/// See [`crate::client::fluent_builders::DescribeFleetHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetHistory {
    _private: (),
}
impl DescribeFleetHistory {
    /// Creates a new builder-style object to manufacture [`DescribeFleetHistoryInput`](crate::input::DescribeFleetHistoryInput)
    pub fn builder() -> crate::input::describe_fleet_history_input::Builder {
        crate::input::describe_fleet_history_input::Builder::default()
    }
    /// Creates a new `DescribeFleetHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetHistory {
    type Output = std::result::Result<
        crate::output::DescribeFleetHistoryOutput,
        crate::error::DescribeFleetHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_history_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_history_response(response)
        }
    }
}

/// Operation shape for `DescribeFleetInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet_instances`](crate::client::Client::describe_fleet_instances).
///
/// See [`crate::client::fluent_builders::DescribeFleetInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleetInstances {
    _private: (),
}
impl DescribeFleetInstances {
    /// Creates a new builder-style object to manufacture [`DescribeFleetInstancesInput`](crate::input::DescribeFleetInstancesInput)
    pub fn builder() -> crate::input::describe_fleet_instances_input::Builder {
        crate::input::describe_fleet_instances_input::Builder::default()
    }
    /// Creates a new `DescribeFleetInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleetInstances {
    type Output = std::result::Result<
        crate::output::DescribeFleetInstancesOutput,
        crate::error::DescribeFleetInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleets`](crate::client::Client::describe_fleets).
///
/// See [`crate::client::fluent_builders::DescribeFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleets {
    _private: (),
}
impl DescribeFleets {
    /// Creates a new builder-style object to manufacture [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
    pub fn builder() -> crate::input::describe_fleets_input::Builder {
        crate::input::describe_fleets_input::Builder::default()
    }
    /// Creates a new `DescribeFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleets {
    type Output =
        std::result::Result<crate::output::DescribeFleetsOutput, crate::error::DescribeFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleets_error(response)
        } else {
            crate::operation_deser::parse_describe_fleets_response(response)
        }
    }
}

/// Operation shape for `DescribeFlowLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_flow_logs`](crate::client::Client::describe_flow_logs).
///
/// See [`crate::client::fluent_builders::DescribeFlowLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFlowLogs {
    _private: (),
}
impl DescribeFlowLogs {
    /// Creates a new builder-style object to manufacture [`DescribeFlowLogsInput`](crate::input::DescribeFlowLogsInput)
    pub fn builder() -> crate::input::describe_flow_logs_input::Builder {
        crate::input::describe_flow_logs_input::Builder::default()
    }
    /// Creates a new `DescribeFlowLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFlowLogs {
    type Output = std::result::Result<
        crate::output::DescribeFlowLogsOutput,
        crate::error::DescribeFlowLogsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_flow_logs_error(response)
        } else {
            crate::operation_deser::parse_describe_flow_logs_response(response)
        }
    }
}

/// Operation shape for `DescribeFpgaImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fpga_image_attribute`](crate::client::Client::describe_fpga_image_attribute).
///
/// See [`crate::client::fluent_builders::DescribeFpgaImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFpgaImageAttribute {
    _private: (),
}
impl DescribeFpgaImageAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeFpgaImageAttributeInput`](crate::input::DescribeFpgaImageAttributeInput)
    pub fn builder() -> crate::input::describe_fpga_image_attribute_input::Builder {
        crate::input::describe_fpga_image_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeFpgaImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFpgaImageAttribute {
    type Output = std::result::Result<
        crate::output::DescribeFpgaImageAttributeOutput,
        crate::error::DescribeFpgaImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fpga_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_fpga_image_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeFpgaImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fpga_images`](crate::client::Client::describe_fpga_images).
///
/// See [`crate::client::fluent_builders::DescribeFpgaImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFpgaImages {
    _private: (),
}
impl DescribeFpgaImages {
    /// Creates a new builder-style object to manufacture [`DescribeFpgaImagesInput`](crate::input::DescribeFpgaImagesInput)
    pub fn builder() -> crate::input::describe_fpga_images_input::Builder {
        crate::input::describe_fpga_images_input::Builder::default()
    }
    /// Creates a new `DescribeFpgaImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFpgaImages {
    type Output = std::result::Result<
        crate::output::DescribeFpgaImagesOutput,
        crate::error::DescribeFpgaImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fpga_images_error(response)
        } else {
            crate::operation_deser::parse_describe_fpga_images_response(response)
        }
    }
}

/// Operation shape for `DescribeHostReservationOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_host_reservation_offerings`](crate::client::Client::describe_host_reservation_offerings).
///
/// See [`crate::client::fluent_builders::DescribeHostReservationOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHostReservationOfferings {
    _private: (),
}
impl DescribeHostReservationOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeHostReservationOfferingsInput`](crate::input::DescribeHostReservationOfferingsInput)
    pub fn builder() -> crate::input::describe_host_reservation_offerings_input::Builder {
        crate::input::describe_host_reservation_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeHostReservationOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHostReservationOfferings {
    type Output = std::result::Result<
        crate::output::DescribeHostReservationOfferingsOutput,
        crate::error::DescribeHostReservationOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_host_reservation_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_host_reservation_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeHostReservations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_host_reservations`](crate::client::Client::describe_host_reservations).
///
/// See [`crate::client::fluent_builders::DescribeHostReservations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHostReservations {
    _private: (),
}
impl DescribeHostReservations {
    /// Creates a new builder-style object to manufacture [`DescribeHostReservationsInput`](crate::input::DescribeHostReservationsInput)
    pub fn builder() -> crate::input::describe_host_reservations_input::Builder {
        crate::input::describe_host_reservations_input::Builder::default()
    }
    /// Creates a new `DescribeHostReservations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHostReservations {
    type Output = std::result::Result<
        crate::output::DescribeHostReservationsOutput,
        crate::error::DescribeHostReservationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_host_reservations_error(response)
        } else {
            crate::operation_deser::parse_describe_host_reservations_response(response)
        }
    }
}

/// Operation shape for `DescribeHosts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hosts`](crate::client::Client::describe_hosts).
///
/// See [`crate::client::fluent_builders::DescribeHosts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHosts {
    _private: (),
}
impl DescribeHosts {
    /// Creates a new builder-style object to manufacture [`DescribeHostsInput`](crate::input::DescribeHostsInput)
    pub fn builder() -> crate::input::describe_hosts_input::Builder {
        crate::input::describe_hosts_input::Builder::default()
    }
    /// Creates a new `DescribeHosts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHosts {
    type Output =
        std::result::Result<crate::output::DescribeHostsOutput, crate::error::DescribeHostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hosts_error(response)
        } else {
            crate::operation_deser::parse_describe_hosts_response(response)
        }
    }
}

/// Operation shape for `DescribeIamInstanceProfileAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_iam_instance_profile_associations`](crate::client::Client::describe_iam_instance_profile_associations).
///
/// See [`crate::client::fluent_builders::DescribeIamInstanceProfileAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIamInstanceProfileAssociations {
    _private: (),
}
impl DescribeIamInstanceProfileAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeIamInstanceProfileAssociationsInput`](crate::input::DescribeIamInstanceProfileAssociationsInput)
    pub fn builder() -> crate::input::describe_iam_instance_profile_associations_input::Builder {
        crate::input::describe_iam_instance_profile_associations_input::Builder::default()
    }
    /// Creates a new `DescribeIamInstanceProfileAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIamInstanceProfileAssociations {
    type Output = std::result::Result<
        crate::output::DescribeIamInstanceProfileAssociationsOutput,
        crate::error::DescribeIamInstanceProfileAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_iam_instance_profile_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_iam_instance_profile_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeIdentityIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_identity_id_format`](crate::client::Client::describe_identity_id_format).
///
/// See [`crate::client::fluent_builders::DescribeIdentityIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIdentityIdFormat {
    _private: (),
}
impl DescribeIdentityIdFormat {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityIdFormatInput`](crate::input::DescribeIdentityIdFormatInput)
    pub fn builder() -> crate::input::describe_identity_id_format_input::Builder {
        crate::input::describe_identity_id_format_input::Builder::default()
    }
    /// Creates a new `DescribeIdentityIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIdentityIdFormat {
    type Output = std::result::Result<
        crate::output::DescribeIdentityIdFormatOutput,
        crate::error::DescribeIdentityIdFormatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_identity_id_format_error(response)
        } else {
            crate::operation_deser::parse_describe_identity_id_format_response(response)
        }
    }
}

/// Operation shape for `DescribeIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_id_format`](crate::client::Client::describe_id_format).
///
/// See [`crate::client::fluent_builders::DescribeIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIdFormat {
    _private: (),
}
impl DescribeIdFormat {
    /// Creates a new builder-style object to manufacture [`DescribeIdFormatInput`](crate::input::DescribeIdFormatInput)
    pub fn builder() -> crate::input::describe_id_format_input::Builder {
        crate::input::describe_id_format_input::Builder::default()
    }
    /// Creates a new `DescribeIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIdFormat {
    type Output = std::result::Result<
        crate::output::DescribeIdFormatOutput,
        crate::error::DescribeIdFormatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_id_format_error(response)
        } else {
            crate::operation_deser::parse_describe_id_format_response(response)
        }
    }
}

/// Operation shape for `DescribeImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_attribute`](crate::client::Client::describe_image_attribute).
///
/// See [`crate::client::fluent_builders::DescribeImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageAttribute {
    _private: (),
}
impl DescribeImageAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeImageAttributeInput`](crate::input::DescribeImageAttributeInput)
    pub fn builder() -> crate::input::describe_image_attribute_input::Builder {
        crate::input::describe_image_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageAttribute {
    type Output = std::result::Result<
        crate::output::DescribeImageAttributeOutput,
        crate::error::DescribeImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_image_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_images`](crate::client::Client::describe_images).
///
/// See [`crate::client::fluent_builders::DescribeImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImages {
    _private: (),
}
impl DescribeImages {
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
    /// Creates a new `DescribeImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImages {
    type Output =
        std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_images_error(response)
        } else {
            crate::operation_deser::parse_describe_images_response(response)
        }
    }
}

/// Operation shape for `DescribeImportImageTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_import_image_tasks`](crate::client::Client::describe_import_image_tasks).
///
/// See [`crate::client::fluent_builders::DescribeImportImageTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImportImageTasks {
    _private: (),
}
impl DescribeImportImageTasks {
    /// Creates a new builder-style object to manufacture [`DescribeImportImageTasksInput`](crate::input::DescribeImportImageTasksInput)
    pub fn builder() -> crate::input::describe_import_image_tasks_input::Builder {
        crate::input::describe_import_image_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeImportImageTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImportImageTasks {
    type Output = std::result::Result<
        crate::output::DescribeImportImageTasksOutput,
        crate::error::DescribeImportImageTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_import_image_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_import_image_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeImportSnapshotTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_import_snapshot_tasks`](crate::client::Client::describe_import_snapshot_tasks).
///
/// See [`crate::client::fluent_builders::DescribeImportSnapshotTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImportSnapshotTasks {
    _private: (),
}
impl DescribeImportSnapshotTasks {
    /// Creates a new builder-style object to manufacture [`DescribeImportSnapshotTasksInput`](crate::input::DescribeImportSnapshotTasksInput)
    pub fn builder() -> crate::input::describe_import_snapshot_tasks_input::Builder {
        crate::input::describe_import_snapshot_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeImportSnapshotTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImportSnapshotTasks {
    type Output = std::result::Result<
        crate::output::DescribeImportSnapshotTasksOutput,
        crate::error::DescribeImportSnapshotTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_import_snapshot_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_import_snapshot_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_attribute`](crate::client::Client::describe_instance_attribute).
///
/// See [`crate::client::fluent_builders::DescribeInstanceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceAttribute {
    _private: (),
}
impl DescribeInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
    pub fn builder() -> crate::input::describe_instance_attribute_input::Builder {
        crate::input::describe_instance_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceAttribute {
    type Output = std::result::Result<
        crate::output::DescribeInstanceAttributeOutput,
        crate::error::DescribeInstanceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceCreditSpecifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_credit_specifications`](crate::client::Client::describe_instance_credit_specifications).
///
/// See [`crate::client::fluent_builders::DescribeInstanceCreditSpecifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceCreditSpecifications {
    _private: (),
}
impl DescribeInstanceCreditSpecifications {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceCreditSpecificationsInput`](crate::input::DescribeInstanceCreditSpecificationsInput)
    pub fn builder() -> crate::input::describe_instance_credit_specifications_input::Builder {
        crate::input::describe_instance_credit_specifications_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceCreditSpecifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceCreditSpecifications {
    type Output = std::result::Result<
        crate::output::DescribeInstanceCreditSpecificationsOutput,
        crate::error::DescribeInstanceCreditSpecificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_credit_specifications_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_credit_specifications_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceEventNotificationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_event_notification_attributes`](crate::client::Client::describe_instance_event_notification_attributes).
///
/// See [`crate::client::fluent_builders::DescribeInstanceEventNotificationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceEventNotificationAttributes {
    _private: (),
}
impl DescribeInstanceEventNotificationAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceEventNotificationAttributesInput`](crate::input::DescribeInstanceEventNotificationAttributesInput)
    pub fn builder() -> crate::input::describe_instance_event_notification_attributes_input::Builder
    {
        crate::input::describe_instance_event_notification_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceEventNotificationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeInstanceEventNotificationAttributes
{
    type Output = std::result::Result<
        crate::output::DescribeInstanceEventNotificationAttributesOutput,
        crate::error::DescribeInstanceEventNotificationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_event_notification_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_instance_event_notification_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeInstanceEventWindows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_event_windows`](crate::client::Client::describe_instance_event_windows).
///
/// See [`crate::client::fluent_builders::DescribeInstanceEventWindows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceEventWindows {
    _private: (),
}
impl DescribeInstanceEventWindows {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceEventWindowsInput`](crate::input::DescribeInstanceEventWindowsInput)
    pub fn builder() -> crate::input::describe_instance_event_windows_input::Builder {
        crate::input::describe_instance_event_windows_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceEventWindows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceEventWindows {
    type Output = std::result::Result<
        crate::output::DescribeInstanceEventWindowsOutput,
        crate::error::DescribeInstanceEventWindowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_event_windows_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_event_windows_response(response)
        }
    }
}

/// Operation shape for `DescribeInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instances`](crate::client::Client::describe_instances).
///
/// See [`crate::client::fluent_builders::DescribeInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstances {
    _private: (),
}
impl DescribeInstances {
    /// Creates a new builder-style object to manufacture [`DescribeInstancesInput`](crate::input::DescribeInstancesInput)
    pub fn builder() -> crate::input::describe_instances_input::Builder {
        crate::input::describe_instances_input::Builder::default()
    }
    /// Creates a new `DescribeInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstances {
    type Output = std::result::Result<
        crate::output::DescribeInstancesOutput,
        crate::error::DescribeInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_status`](crate::client::Client::describe_instance_status).
///
/// See [`crate::client::fluent_builders::DescribeInstanceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceStatus {
    _private: (),
}
impl DescribeInstanceStatus {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceStatusInput`](crate::input::DescribeInstanceStatusInput)
    pub fn builder() -> crate::input::describe_instance_status_input::Builder {
        crate::input::describe_instance_status_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceStatus {
    type Output = std::result::Result<
        crate::output::DescribeInstanceStatusOutput,
        crate::error::DescribeInstanceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_status_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_status_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceTypeOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_type_offerings`](crate::client::Client::describe_instance_type_offerings).
///
/// See [`crate::client::fluent_builders::DescribeInstanceTypeOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceTypeOfferings {
    _private: (),
}
impl DescribeInstanceTypeOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceTypeOfferingsInput`](crate::input::DescribeInstanceTypeOfferingsInput)
    pub fn builder() -> crate::input::describe_instance_type_offerings_input::Builder {
        crate::input::describe_instance_type_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceTypeOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceTypeOfferings {
    type Output = std::result::Result<
        crate::output::DescribeInstanceTypeOfferingsOutput,
        crate::error::DescribeInstanceTypeOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_type_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_type_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeInstanceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_instance_types`](crate::client::Client::describe_instance_types).
///
/// See [`crate::client::fluent_builders::DescribeInstanceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInstanceTypes {
    _private: (),
}
impl DescribeInstanceTypes {
    /// Creates a new builder-style object to manufacture [`DescribeInstanceTypesInput`](crate::input::DescribeInstanceTypesInput)
    pub fn builder() -> crate::input::describe_instance_types_input::Builder {
        crate::input::describe_instance_types_input::Builder::default()
    }
    /// Creates a new `DescribeInstanceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInstanceTypes {
    type Output = std::result::Result<
        crate::output::DescribeInstanceTypesOutput,
        crate::error::DescribeInstanceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_instance_types_error(response)
        } else {
            crate::operation_deser::parse_describe_instance_types_response(response)
        }
    }
}

/// Operation shape for `DescribeInternetGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_internet_gateways`](crate::client::Client::describe_internet_gateways).
///
/// See [`crate::client::fluent_builders::DescribeInternetGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInternetGateways {
    _private: (),
}
impl DescribeInternetGateways {
    /// Creates a new builder-style object to manufacture [`DescribeInternetGatewaysInput`](crate::input::DescribeInternetGatewaysInput)
    pub fn builder() -> crate::input::describe_internet_gateways_input::Builder {
        crate::input::describe_internet_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeInternetGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInternetGateways {
    type Output = std::result::Result<
        crate::output::DescribeInternetGatewaysOutput,
        crate::error::DescribeInternetGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_internet_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_internet_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeIpamPools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ipam_pools`](crate::client::Client::describe_ipam_pools).
///
/// See [`crate::client::fluent_builders::DescribeIpamPools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpamPools {
    _private: (),
}
impl DescribeIpamPools {
    /// Creates a new builder-style object to manufacture [`DescribeIpamPoolsInput`](crate::input::DescribeIpamPoolsInput)
    pub fn builder() -> crate::input::describe_ipam_pools_input::Builder {
        crate::input::describe_ipam_pools_input::Builder::default()
    }
    /// Creates a new `DescribeIpamPools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpamPools {
    type Output = std::result::Result<
        crate::output::DescribeIpamPoolsOutput,
        crate::error::DescribeIpamPoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ipam_pools_error(response)
        } else {
            crate::operation_deser::parse_describe_ipam_pools_response(response)
        }
    }
}

/// Operation shape for `DescribeIpams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ipams`](crate::client::Client::describe_ipams).
///
/// See [`crate::client::fluent_builders::DescribeIpams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpams {
    _private: (),
}
impl DescribeIpams {
    /// Creates a new builder-style object to manufacture [`DescribeIpamsInput`](crate::input::DescribeIpamsInput)
    pub fn builder() -> crate::input::describe_ipams_input::Builder {
        crate::input::describe_ipams_input::Builder::default()
    }
    /// Creates a new `DescribeIpams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpams {
    type Output =
        std::result::Result<crate::output::DescribeIpamsOutput, crate::error::DescribeIpamsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ipams_error(response)
        } else {
            crate::operation_deser::parse_describe_ipams_response(response)
        }
    }
}

/// Operation shape for `DescribeIpamScopes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ipam_scopes`](crate::client::Client::describe_ipam_scopes).
///
/// See [`crate::client::fluent_builders::DescribeIpamScopes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpamScopes {
    _private: (),
}
impl DescribeIpamScopes {
    /// Creates a new builder-style object to manufacture [`DescribeIpamScopesInput`](crate::input::DescribeIpamScopesInput)
    pub fn builder() -> crate::input::describe_ipam_scopes_input::Builder {
        crate::input::describe_ipam_scopes_input::Builder::default()
    }
    /// Creates a new `DescribeIpamScopes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpamScopes {
    type Output = std::result::Result<
        crate::output::DescribeIpamScopesOutput,
        crate::error::DescribeIpamScopesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ipam_scopes_error(response)
        } else {
            crate::operation_deser::parse_describe_ipam_scopes_response(response)
        }
    }
}

/// Operation shape for `DescribeIpv6Pools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_ipv6_pools`](crate::client::Client::describe_ipv6_pools).
///
/// See [`crate::client::fluent_builders::DescribeIpv6Pools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIpv6Pools {
    _private: (),
}
impl DescribeIpv6Pools {
    /// Creates a new builder-style object to manufacture [`DescribeIpv6PoolsInput`](crate::input::DescribeIpv6PoolsInput)
    pub fn builder() -> crate::input::describe_ipv6_pools_input::Builder {
        crate::input::describe_ipv6_pools_input::Builder::default()
    }
    /// Creates a new `DescribeIpv6Pools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIpv6Pools {
    type Output = std::result::Result<
        crate::output::DescribeIpv6PoolsOutput,
        crate::error::DescribeIpv6PoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_ipv6_pools_error(response)
        } else {
            crate::operation_deser::parse_describe_ipv6_pools_response(response)
        }
    }
}

/// Operation shape for `DescribeKeyPairs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_key_pairs`](crate::client::Client::describe_key_pairs).
///
/// See [`crate::client::fluent_builders::DescribeKeyPairs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeKeyPairs {
    _private: (),
}
impl DescribeKeyPairs {
    /// Creates a new builder-style object to manufacture [`DescribeKeyPairsInput`](crate::input::DescribeKeyPairsInput)
    pub fn builder() -> crate::input::describe_key_pairs_input::Builder {
        crate::input::describe_key_pairs_input::Builder::default()
    }
    /// Creates a new `DescribeKeyPairs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeKeyPairs {
    type Output = std::result::Result<
        crate::output::DescribeKeyPairsOutput,
        crate::error::DescribeKeyPairsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_key_pairs_error(response)
        } else {
            crate::operation_deser::parse_describe_key_pairs_response(response)
        }
    }
}

/// Operation shape for `DescribeLaunchTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_launch_templates`](crate::client::Client::describe_launch_templates).
///
/// See [`crate::client::fluent_builders::DescribeLaunchTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLaunchTemplates {
    _private: (),
}
impl DescribeLaunchTemplates {
    /// Creates a new builder-style object to manufacture [`DescribeLaunchTemplatesInput`](crate::input::DescribeLaunchTemplatesInput)
    pub fn builder() -> crate::input::describe_launch_templates_input::Builder {
        crate::input::describe_launch_templates_input::Builder::default()
    }
    /// Creates a new `DescribeLaunchTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLaunchTemplates {
    type Output = std::result::Result<
        crate::output::DescribeLaunchTemplatesOutput,
        crate::error::DescribeLaunchTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_launch_templates_error(response)
        } else {
            crate::operation_deser::parse_describe_launch_templates_response(response)
        }
    }
}

/// Operation shape for `DescribeLaunchTemplateVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_launch_template_versions`](crate::client::Client::describe_launch_template_versions).
///
/// See [`crate::client::fluent_builders::DescribeLaunchTemplateVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLaunchTemplateVersions {
    _private: (),
}
impl DescribeLaunchTemplateVersions {
    /// Creates a new builder-style object to manufacture [`DescribeLaunchTemplateVersionsInput`](crate::input::DescribeLaunchTemplateVersionsInput)
    pub fn builder() -> crate::input::describe_launch_template_versions_input::Builder {
        crate::input::describe_launch_template_versions_input::Builder::default()
    }
    /// Creates a new `DescribeLaunchTemplateVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLaunchTemplateVersions {
    type Output = std::result::Result<
        crate::output::DescribeLaunchTemplateVersionsOutput,
        crate::error::DescribeLaunchTemplateVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_launch_template_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_launch_template_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeLocalGatewayRouteTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateway_route_tables`](crate::client::Client::describe_local_gateway_route_tables).
///
/// See [`crate::client::fluent_builders::DescribeLocalGatewayRouteTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGatewayRouteTables {
    _private: (),
}
impl DescribeLocalGatewayRouteTables {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewayRouteTablesInput`](crate::input::DescribeLocalGatewayRouteTablesInput)
    pub fn builder() -> crate::input::describe_local_gateway_route_tables_input::Builder {
        crate::input::describe_local_gateway_route_tables_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGatewayRouteTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocalGatewayRouteTables {
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewayRouteTablesOutput,
        crate::error::DescribeLocalGatewayRouteTablesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateway_route_tables_error(response)
        } else {
            crate::operation_deser::parse_describe_local_gateway_route_tables_response(response)
        }
    }
}

/// Operation shape for `DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateway_route_table_virtual_interface_group_associations`](crate::client::Client::describe_local_gateway_route_table_virtual_interface_group_associations).
///
/// See [`crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations {
    _private: (),
}
impl DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput`](crate::input::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput)
    pub fn builder() -> crate::input::describe_local_gateway_route_table_virtual_interface_group_associations_input::Builder{
        crate::input::describe_local_gateway_route_table_virtual_interface_group_associations_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
{
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput,
        crate::error::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateway_route_table_virtual_interface_group_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_local_gateway_route_table_virtual_interface_group_associations_response(response)
        }
    }
}

/// Operation shape for `DescribeLocalGatewayRouteTableVpcAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateway_route_table_vpc_associations`](crate::client::Client::describe_local_gateway_route_table_vpc_associations).
///
/// See [`crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGatewayRouteTableVpcAssociations {
    _private: (),
}
impl DescribeLocalGatewayRouteTableVpcAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewayRouteTableVpcAssociationsInput`](crate::input::DescribeLocalGatewayRouteTableVpcAssociationsInput)
    pub fn builder(
    ) -> crate::input::describe_local_gateway_route_table_vpc_associations_input::Builder {
        crate::input::describe_local_gateway_route_table_vpc_associations_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGatewayRouteTableVpcAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeLocalGatewayRouteTableVpcAssociations
{
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewayRouteTableVpcAssociationsOutput,
        crate::error::DescribeLocalGatewayRouteTableVpcAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateway_route_table_vpc_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_local_gateway_route_table_vpc_associations_response(response)
        }
    }
}

/// Operation shape for `DescribeLocalGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateways`](crate::client::Client::describe_local_gateways).
///
/// See [`crate::client::fluent_builders::DescribeLocalGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGateways {
    _private: (),
}
impl DescribeLocalGateways {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewaysInput`](crate::input::DescribeLocalGatewaysInput)
    pub fn builder() -> crate::input::describe_local_gateways_input::Builder {
        crate::input::describe_local_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocalGateways {
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewaysOutput,
        crate::error::DescribeLocalGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_local_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeLocalGatewayVirtualInterfaceGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateway_virtual_interface_groups`](crate::client::Client::describe_local_gateway_virtual_interface_groups).
///
/// See [`crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGatewayVirtualInterfaceGroups {
    _private: (),
}
impl DescribeLocalGatewayVirtualInterfaceGroups {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewayVirtualInterfaceGroupsInput`](crate::input::DescribeLocalGatewayVirtualInterfaceGroupsInput)
    pub fn builder() -> crate::input::describe_local_gateway_virtual_interface_groups_input::Builder
    {
        crate::input::describe_local_gateway_virtual_interface_groups_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGatewayVirtualInterfaceGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocalGatewayVirtualInterfaceGroups {
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewayVirtualInterfaceGroupsOutput,
        crate::error::DescribeLocalGatewayVirtualInterfaceGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateway_virtual_interface_groups_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_local_gateway_virtual_interface_groups_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeLocalGatewayVirtualInterfaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_local_gateway_virtual_interfaces`](crate::client::Client::describe_local_gateway_virtual_interfaces).
///
/// See [`crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLocalGatewayVirtualInterfaces {
    _private: (),
}
impl DescribeLocalGatewayVirtualInterfaces {
    /// Creates a new builder-style object to manufacture [`DescribeLocalGatewayVirtualInterfacesInput`](crate::input::DescribeLocalGatewayVirtualInterfacesInput)
    pub fn builder() -> crate::input::describe_local_gateway_virtual_interfaces_input::Builder {
        crate::input::describe_local_gateway_virtual_interfaces_input::Builder::default()
    }
    /// Creates a new `DescribeLocalGatewayVirtualInterfaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLocalGatewayVirtualInterfaces {
    type Output = std::result::Result<
        crate::output::DescribeLocalGatewayVirtualInterfacesOutput,
        crate::error::DescribeLocalGatewayVirtualInterfacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_local_gateway_virtual_interfaces_error(response)
        } else {
            crate::operation_deser::parse_describe_local_gateway_virtual_interfaces_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeManagedPrefixLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_managed_prefix_lists`](crate::client::Client::describe_managed_prefix_lists).
///
/// See [`crate::client::fluent_builders::DescribeManagedPrefixLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeManagedPrefixLists {
    _private: (),
}
impl DescribeManagedPrefixLists {
    /// Creates a new builder-style object to manufacture [`DescribeManagedPrefixListsInput`](crate::input::DescribeManagedPrefixListsInput)
    pub fn builder() -> crate::input::describe_managed_prefix_lists_input::Builder {
        crate::input::describe_managed_prefix_lists_input::Builder::default()
    }
    /// Creates a new `DescribeManagedPrefixLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeManagedPrefixLists {
    type Output = std::result::Result<
        crate::output::DescribeManagedPrefixListsOutput,
        crate::error::DescribeManagedPrefixListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_managed_prefix_lists_error(response)
        } else {
            crate::operation_deser::parse_describe_managed_prefix_lists_response(response)
        }
    }
}

/// Operation shape for `DescribeMovingAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_moving_addresses`](crate::client::Client::describe_moving_addresses).
///
/// See [`crate::client::fluent_builders::DescribeMovingAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMovingAddresses {
    _private: (),
}
impl DescribeMovingAddresses {
    /// Creates a new builder-style object to manufacture [`DescribeMovingAddressesInput`](crate::input::DescribeMovingAddressesInput)
    pub fn builder() -> crate::input::describe_moving_addresses_input::Builder {
        crate::input::describe_moving_addresses_input::Builder::default()
    }
    /// Creates a new `DescribeMovingAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMovingAddresses {
    type Output = std::result::Result<
        crate::output::DescribeMovingAddressesOutput,
        crate::error::DescribeMovingAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_moving_addresses_error(response)
        } else {
            crate::operation_deser::parse_describe_moving_addresses_response(response)
        }
    }
}

/// Operation shape for `DescribeNatGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_nat_gateways`](crate::client::Client::describe_nat_gateways).
///
/// See [`crate::client::fluent_builders::DescribeNatGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNatGateways {
    _private: (),
}
impl DescribeNatGateways {
    /// Creates a new builder-style object to manufacture [`DescribeNatGatewaysInput`](crate::input::DescribeNatGatewaysInput)
    pub fn builder() -> crate::input::describe_nat_gateways_input::Builder {
        crate::input::describe_nat_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeNatGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNatGateways {
    type Output = std::result::Result<
        crate::output::DescribeNatGatewaysOutput,
        crate::error::DescribeNatGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_nat_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_nat_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkAcls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_acls`](crate::client::Client::describe_network_acls).
///
/// See [`crate::client::fluent_builders::DescribeNetworkAcls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkAcls {
    _private: (),
}
impl DescribeNetworkAcls {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkAclsInput`](crate::input::DescribeNetworkAclsInput)
    pub fn builder() -> crate::input::describe_network_acls_input::Builder {
        crate::input::describe_network_acls_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkAcls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkAcls {
    type Output = std::result::Result<
        crate::output::DescribeNetworkAclsOutput,
        crate::error::DescribeNetworkAclsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_acls_error(response)
        } else {
            crate::operation_deser::parse_describe_network_acls_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInsightsAccessScopeAnalyses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_insights_access_scope_analyses`](crate::client::Client::describe_network_insights_access_scope_analyses).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInsightsAccessScopeAnalyses {
    _private: (),
}
impl DescribeNetworkInsightsAccessScopeAnalyses {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInsightsAccessScopeAnalysesInput`](crate::input::DescribeNetworkInsightsAccessScopeAnalysesInput)
    pub fn builder() -> crate::input::describe_network_insights_access_scope_analyses_input::Builder
    {
        crate::input::describe_network_insights_access_scope_analyses_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInsightsAccessScopeAnalyses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInsightsAccessScopeAnalyses {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInsightsAccessScopeAnalysesOutput,
        crate::error::DescribeNetworkInsightsAccessScopeAnalysesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_insights_access_scope_analyses_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_network_insights_access_scope_analyses_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeNetworkInsightsAccessScopes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_insights_access_scopes`](crate::client::Client::describe_network_insights_access_scopes).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInsightsAccessScopes {
    _private: (),
}
impl DescribeNetworkInsightsAccessScopes {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInsightsAccessScopesInput`](crate::input::DescribeNetworkInsightsAccessScopesInput)
    pub fn builder() -> crate::input::describe_network_insights_access_scopes_input::Builder {
        crate::input::describe_network_insights_access_scopes_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInsightsAccessScopes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInsightsAccessScopes {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInsightsAccessScopesOutput,
        crate::error::DescribeNetworkInsightsAccessScopesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_insights_access_scopes_error(response)
        } else {
            crate::operation_deser::parse_describe_network_insights_access_scopes_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInsightsAnalyses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_insights_analyses`](crate::client::Client::describe_network_insights_analyses).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInsightsAnalyses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInsightsAnalyses {
    _private: (),
}
impl DescribeNetworkInsightsAnalyses {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInsightsAnalysesInput`](crate::input::DescribeNetworkInsightsAnalysesInput)
    pub fn builder() -> crate::input::describe_network_insights_analyses_input::Builder {
        crate::input::describe_network_insights_analyses_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInsightsAnalyses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInsightsAnalyses {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInsightsAnalysesOutput,
        crate::error::DescribeNetworkInsightsAnalysesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_insights_analyses_error(response)
        } else {
            crate::operation_deser::parse_describe_network_insights_analyses_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInsightsPaths`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_insights_paths`](crate::client::Client::describe_network_insights_paths).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInsightsPaths`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInsightsPaths {
    _private: (),
}
impl DescribeNetworkInsightsPaths {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInsightsPathsInput`](crate::input::DescribeNetworkInsightsPathsInput)
    pub fn builder() -> crate::input::describe_network_insights_paths_input::Builder {
        crate::input::describe_network_insights_paths_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInsightsPaths` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInsightsPaths {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInsightsPathsOutput,
        crate::error::DescribeNetworkInsightsPathsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_insights_paths_error(response)
        } else {
            crate::operation_deser::parse_describe_network_insights_paths_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInterfaceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_interface_attribute`](crate::client::Client::describe_network_interface_attribute).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInterfaceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInterfaceAttribute {
    _private: (),
}
impl DescribeNetworkInterfaceAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInterfaceAttributeInput`](crate::input::DescribeNetworkInterfaceAttributeInput)
    pub fn builder() -> crate::input::describe_network_interface_attribute_input::Builder {
        crate::input::describe_network_interface_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInterfaceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInterfaceAttribute {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInterfaceAttributeOutput,
        crate::error::DescribeNetworkInterfaceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_interface_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_network_interface_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInterfacePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_interface_permissions`](crate::client::Client::describe_network_interface_permissions).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInterfacePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInterfacePermissions {
    _private: (),
}
impl DescribeNetworkInterfacePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInterfacePermissionsInput`](crate::input::DescribeNetworkInterfacePermissionsInput)
    pub fn builder() -> crate::input::describe_network_interface_permissions_input::Builder {
        crate::input::describe_network_interface_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInterfacePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInterfacePermissions {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInterfacePermissionsOutput,
        crate::error::DescribeNetworkInterfacePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_interface_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_network_interface_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeNetworkInterfaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_network_interfaces`](crate::client::Client::describe_network_interfaces).
///
/// See [`crate::client::fluent_builders::DescribeNetworkInterfaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNetworkInterfaces {
    _private: (),
}
impl DescribeNetworkInterfaces {
    /// Creates a new builder-style object to manufacture [`DescribeNetworkInterfacesInput`](crate::input::DescribeNetworkInterfacesInput)
    pub fn builder() -> crate::input::describe_network_interfaces_input::Builder {
        crate::input::describe_network_interfaces_input::Builder::default()
    }
    /// Creates a new `DescribeNetworkInterfaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNetworkInterfaces {
    type Output = std::result::Result<
        crate::output::DescribeNetworkInterfacesOutput,
        crate::error::DescribeNetworkInterfacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_network_interfaces_error(response)
        } else {
            crate::operation_deser::parse_describe_network_interfaces_response(response)
        }
    }
}

/// Operation shape for `DescribePlacementGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_placement_groups`](crate::client::Client::describe_placement_groups).
///
/// See [`crate::client::fluent_builders::DescribePlacementGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePlacementGroups {
    _private: (),
}
impl DescribePlacementGroups {
    /// Creates a new builder-style object to manufacture [`DescribePlacementGroupsInput`](crate::input::DescribePlacementGroupsInput)
    pub fn builder() -> crate::input::describe_placement_groups_input::Builder {
        crate::input::describe_placement_groups_input::Builder::default()
    }
    /// Creates a new `DescribePlacementGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePlacementGroups {
    type Output = std::result::Result<
        crate::output::DescribePlacementGroupsOutput,
        crate::error::DescribePlacementGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_placement_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_placement_groups_response(response)
        }
    }
}

/// Operation shape for `DescribePrefixLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_prefix_lists`](crate::client::Client::describe_prefix_lists).
///
/// See [`crate::client::fluent_builders::DescribePrefixLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePrefixLists {
    _private: (),
}
impl DescribePrefixLists {
    /// Creates a new builder-style object to manufacture [`DescribePrefixListsInput`](crate::input::DescribePrefixListsInput)
    pub fn builder() -> crate::input::describe_prefix_lists_input::Builder {
        crate::input::describe_prefix_lists_input::Builder::default()
    }
    /// Creates a new `DescribePrefixLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePrefixLists {
    type Output = std::result::Result<
        crate::output::DescribePrefixListsOutput,
        crate::error::DescribePrefixListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_prefix_lists_error(response)
        } else {
            crate::operation_deser::parse_describe_prefix_lists_response(response)
        }
    }
}

/// Operation shape for `DescribePrincipalIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_principal_id_format`](crate::client::Client::describe_principal_id_format).
///
/// See [`crate::client::fluent_builders::DescribePrincipalIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePrincipalIdFormat {
    _private: (),
}
impl DescribePrincipalIdFormat {
    /// Creates a new builder-style object to manufacture [`DescribePrincipalIdFormatInput`](crate::input::DescribePrincipalIdFormatInput)
    pub fn builder() -> crate::input::describe_principal_id_format_input::Builder {
        crate::input::describe_principal_id_format_input::Builder::default()
    }
    /// Creates a new `DescribePrincipalIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePrincipalIdFormat {
    type Output = std::result::Result<
        crate::output::DescribePrincipalIdFormatOutput,
        crate::error::DescribePrincipalIdFormatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_principal_id_format_error(response)
        } else {
            crate::operation_deser::parse_describe_principal_id_format_response(response)
        }
    }
}

/// Operation shape for `DescribePublicIpv4Pools`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_public_ipv4_pools`](crate::client::Client::describe_public_ipv4_pools).
///
/// See [`crate::client::fluent_builders::DescribePublicIpv4Pools`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePublicIpv4Pools {
    _private: (),
}
impl DescribePublicIpv4Pools {
    /// Creates a new builder-style object to manufacture [`DescribePublicIpv4PoolsInput`](crate::input::DescribePublicIpv4PoolsInput)
    pub fn builder() -> crate::input::describe_public_ipv4_pools_input::Builder {
        crate::input::describe_public_ipv4_pools_input::Builder::default()
    }
    /// Creates a new `DescribePublicIpv4Pools` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePublicIpv4Pools {
    type Output = std::result::Result<
        crate::output::DescribePublicIpv4PoolsOutput,
        crate::error::DescribePublicIpv4PoolsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_public_ipv4_pools_error(response)
        } else {
            crate::operation_deser::parse_describe_public_ipv4_pools_response(response)
        }
    }
}

/// Operation shape for `DescribeRegions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_regions`](crate::client::Client::describe_regions).
///
/// See [`crate::client::fluent_builders::DescribeRegions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegions {
    _private: (),
}
impl DescribeRegions {
    /// Creates a new builder-style object to manufacture [`DescribeRegionsInput`](crate::input::DescribeRegionsInput)
    pub fn builder() -> crate::input::describe_regions_input::Builder {
        crate::input::describe_regions_input::Builder::default()
    }
    /// Creates a new `DescribeRegions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegions {
    type Output = std::result::Result<
        crate::output::DescribeRegionsOutput,
        crate::error::DescribeRegionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_regions_error(response)
        } else {
            crate::operation_deser::parse_describe_regions_response(response)
        }
    }
}

/// Operation shape for `DescribeReplaceRootVolumeTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replace_root_volume_tasks`](crate::client::Client::describe_replace_root_volume_tasks).
///
/// See [`crate::client::fluent_builders::DescribeReplaceRootVolumeTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplaceRootVolumeTasks {
    _private: (),
}
impl DescribeReplaceRootVolumeTasks {
    /// Creates a new builder-style object to manufacture [`DescribeReplaceRootVolumeTasksInput`](crate::input::DescribeReplaceRootVolumeTasksInput)
    pub fn builder() -> crate::input::describe_replace_root_volume_tasks_input::Builder {
        crate::input::describe_replace_root_volume_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeReplaceRootVolumeTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplaceRootVolumeTasks {
    type Output = std::result::Result<
        crate::output::DescribeReplaceRootVolumeTasksOutput,
        crate::error::DescribeReplaceRootVolumeTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replace_root_volume_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_replace_root_volume_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instances`](crate::client::Client::describe_reserved_instances).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstances {
    _private: (),
}
impl DescribeReservedInstances {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesInput`](crate::input::DescribeReservedInstancesInput)
    pub fn builder() -> crate::input::describe_reserved_instances_input::Builder {
        crate::input::describe_reserved_instances_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstances {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstancesOutput,
        crate::error::DescribeReservedInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedInstancesListings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instances_listings`](crate::client::Client::describe_reserved_instances_listings).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstancesListings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstancesListings {
    _private: (),
}
impl DescribeReservedInstancesListings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesListingsInput`](crate::input::DescribeReservedInstancesListingsInput)
    pub fn builder() -> crate::input::describe_reserved_instances_listings_input::Builder {
        crate::input::describe_reserved_instances_listings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstancesListings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstancesListings {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstancesListingsOutput,
        crate::error::DescribeReservedInstancesListingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instances_listings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instances_listings_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedInstancesModifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instances_modifications`](crate::client::Client::describe_reserved_instances_modifications).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstancesModifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstancesModifications {
    _private: (),
}
impl DescribeReservedInstancesModifications {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesModificationsInput`](crate::input::DescribeReservedInstancesModificationsInput)
    pub fn builder() -> crate::input::describe_reserved_instances_modifications_input::Builder {
        crate::input::describe_reserved_instances_modifications_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstancesModifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstancesModifications {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstancesModificationsOutput,
        crate::error::DescribeReservedInstancesModificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instances_modifications_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instances_modifications_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeReservedInstancesOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_instances_offerings`](crate::client::Client::describe_reserved_instances_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedInstancesOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedInstancesOfferings {
    _private: (),
}
impl DescribeReservedInstancesOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedInstancesOfferingsInput`](crate::input::DescribeReservedInstancesOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_instances_offerings_input::Builder {
        crate::input::describe_reserved_instances_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedInstancesOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedInstancesOfferings {
    type Output = std::result::Result<
        crate::output::DescribeReservedInstancesOfferingsOutput,
        crate::error::DescribeReservedInstancesOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_instances_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_instances_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeRouteTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_route_tables`](crate::client::Client::describe_route_tables).
///
/// See [`crate::client::fluent_builders::DescribeRouteTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRouteTables {
    _private: (),
}
impl DescribeRouteTables {
    /// Creates a new builder-style object to manufacture [`DescribeRouteTablesInput`](crate::input::DescribeRouteTablesInput)
    pub fn builder() -> crate::input::describe_route_tables_input::Builder {
        crate::input::describe_route_tables_input::Builder::default()
    }
    /// Creates a new `DescribeRouteTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRouteTables {
    type Output = std::result::Result<
        crate::output::DescribeRouteTablesOutput,
        crate::error::DescribeRouteTablesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_route_tables_error(response)
        } else {
            crate::operation_deser::parse_describe_route_tables_response(response)
        }
    }
}

/// Operation shape for `DescribeScheduledInstanceAvailability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scheduled_instance_availability`](crate::client::Client::describe_scheduled_instance_availability).
///
/// See [`crate::client::fluent_builders::DescribeScheduledInstanceAvailability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScheduledInstanceAvailability {
    _private: (),
}
impl DescribeScheduledInstanceAvailability {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledInstanceAvailabilityInput`](crate::input::DescribeScheduledInstanceAvailabilityInput)
    pub fn builder() -> crate::input::describe_scheduled_instance_availability_input::Builder {
        crate::input::describe_scheduled_instance_availability_input::Builder::default()
    }
    /// Creates a new `DescribeScheduledInstanceAvailability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScheduledInstanceAvailability {
    type Output = std::result::Result<
        crate::output::DescribeScheduledInstanceAvailabilityOutput,
        crate::error::DescribeScheduledInstanceAvailabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scheduled_instance_availability_error(response)
        } else {
            crate::operation_deser::parse_describe_scheduled_instance_availability_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeScheduledInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scheduled_instances`](crate::client::Client::describe_scheduled_instances).
///
/// See [`crate::client::fluent_builders::DescribeScheduledInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScheduledInstances {
    _private: (),
}
impl DescribeScheduledInstances {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledInstancesInput`](crate::input::DescribeScheduledInstancesInput)
    pub fn builder() -> crate::input::describe_scheduled_instances_input::Builder {
        crate::input::describe_scheduled_instances_input::Builder::default()
    }
    /// Creates a new `DescribeScheduledInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScheduledInstances {
    type Output = std::result::Result<
        crate::output::DescribeScheduledInstancesOutput,
        crate::error::DescribeScheduledInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scheduled_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_scheduled_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityGroupReferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_group_references`](crate::client::Client::describe_security_group_references).
///
/// See [`crate::client::fluent_builders::DescribeSecurityGroupReferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityGroupReferences {
    _private: (),
}
impl DescribeSecurityGroupReferences {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityGroupReferencesInput`](crate::input::DescribeSecurityGroupReferencesInput)
    pub fn builder() -> crate::input::describe_security_group_references_input::Builder {
        crate::input::describe_security_group_references_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityGroupReferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityGroupReferences {
    type Output = std::result::Result<
        crate::output::DescribeSecurityGroupReferencesOutput,
        crate::error::DescribeSecurityGroupReferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_group_references_error(response)
        } else {
            crate::operation_deser::parse_describe_security_group_references_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityGroupRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_group_rules`](crate::client::Client::describe_security_group_rules).
///
/// See [`crate::client::fluent_builders::DescribeSecurityGroupRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityGroupRules {
    _private: (),
}
impl DescribeSecurityGroupRules {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityGroupRulesInput`](crate::input::DescribeSecurityGroupRulesInput)
    pub fn builder() -> crate::input::describe_security_group_rules_input::Builder {
        crate::input::describe_security_group_rules_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityGroupRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityGroupRules {
    type Output = std::result::Result<
        crate::output::DescribeSecurityGroupRulesOutput,
        crate::error::DescribeSecurityGroupRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_group_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_security_group_rules_response(response)
        }
    }
}

/// Operation shape for `DescribeSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_security_groups`](crate::client::Client::describe_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSecurityGroups {
    _private: (),
}
impl DescribeSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeSecurityGroupsInput`](crate::input::DescribeSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_security_groups_input::Builder {
        crate::input::describe_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeSecurityGroupsOutput,
        crate::error::DescribeSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshot_attribute`](crate::client::Client::describe_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::DescribeSnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshotAttribute {
    _private: (),
}
impl DescribeSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotAttributeInput`](crate::input::DescribeSnapshotAttributeInput)
    pub fn builder() -> crate::input::describe_snapshot_attribute_input::Builder {
        crate::input::describe_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshotAttribute {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotAttributeOutput,
        crate::error::DescribeSnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshots`](crate::client::Client::describe_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshots {
    _private: (),
}
impl DescribeSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotsOutput,
        crate::error::DescribeSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshotTierStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshot_tier_status`](crate::client::Client::describe_snapshot_tier_status).
///
/// See [`crate::client::fluent_builders::DescribeSnapshotTierStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshotTierStatus {
    _private: (),
}
impl DescribeSnapshotTierStatus {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotTierStatusInput`](crate::input::DescribeSnapshotTierStatusInput)
    pub fn builder() -> crate::input::describe_snapshot_tier_status_input::Builder {
        crate::input::describe_snapshot_tier_status_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshotTierStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshotTierStatus {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotTierStatusOutput,
        crate::error::DescribeSnapshotTierStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshot_tier_status_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshot_tier_status_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotDatafeedSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_datafeed_subscription`](crate::client::Client::describe_spot_datafeed_subscription).
///
/// See [`crate::client::fluent_builders::DescribeSpotDatafeedSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotDatafeedSubscription {
    _private: (),
}
impl DescribeSpotDatafeedSubscription {
    /// Creates a new builder-style object to manufacture [`DescribeSpotDatafeedSubscriptionInput`](crate::input::DescribeSpotDatafeedSubscriptionInput)
    pub fn builder() -> crate::input::describe_spot_datafeed_subscription_input::Builder {
        crate::input::describe_spot_datafeed_subscription_input::Builder::default()
    }
    /// Creates a new `DescribeSpotDatafeedSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotDatafeedSubscription {
    type Output = std::result::Result<
        crate::output::DescribeSpotDatafeedSubscriptionOutput,
        crate::error::DescribeSpotDatafeedSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_datafeed_subscription_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_datafeed_subscription_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotFleetInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_fleet_instances`](crate::client::Client::describe_spot_fleet_instances).
///
/// See [`crate::client::fluent_builders::DescribeSpotFleetInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotFleetInstances {
    _private: (),
}
impl DescribeSpotFleetInstances {
    /// Creates a new builder-style object to manufacture [`DescribeSpotFleetInstancesInput`](crate::input::DescribeSpotFleetInstancesInput)
    pub fn builder() -> crate::input::describe_spot_fleet_instances_input::Builder {
        crate::input::describe_spot_fleet_instances_input::Builder::default()
    }
    /// Creates a new `DescribeSpotFleetInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotFleetInstances {
    type Output = std::result::Result<
        crate::output::DescribeSpotFleetInstancesOutput,
        crate::error::DescribeSpotFleetInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_fleet_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_fleet_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotFleetRequestHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_fleet_request_history`](crate::client::Client::describe_spot_fleet_request_history).
///
/// See [`crate::client::fluent_builders::DescribeSpotFleetRequestHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotFleetRequestHistory {
    _private: (),
}
impl DescribeSpotFleetRequestHistory {
    /// Creates a new builder-style object to manufacture [`DescribeSpotFleetRequestHistoryInput`](crate::input::DescribeSpotFleetRequestHistoryInput)
    pub fn builder() -> crate::input::describe_spot_fleet_request_history_input::Builder {
        crate::input::describe_spot_fleet_request_history_input::Builder::default()
    }
    /// Creates a new `DescribeSpotFleetRequestHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotFleetRequestHistory {
    type Output = std::result::Result<
        crate::output::DescribeSpotFleetRequestHistoryOutput,
        crate::error::DescribeSpotFleetRequestHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_fleet_request_history_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_fleet_request_history_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotFleetRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_fleet_requests`](crate::client::Client::describe_spot_fleet_requests).
///
/// See [`crate::client::fluent_builders::DescribeSpotFleetRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotFleetRequests {
    _private: (),
}
impl DescribeSpotFleetRequests {
    /// Creates a new builder-style object to manufacture [`DescribeSpotFleetRequestsInput`](crate::input::DescribeSpotFleetRequestsInput)
    pub fn builder() -> crate::input::describe_spot_fleet_requests_input::Builder {
        crate::input::describe_spot_fleet_requests_input::Builder::default()
    }
    /// Creates a new `DescribeSpotFleetRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotFleetRequests {
    type Output = std::result::Result<
        crate::output::DescribeSpotFleetRequestsOutput,
        crate::error::DescribeSpotFleetRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_fleet_requests_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_fleet_requests_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotInstanceRequests`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_instance_requests`](crate::client::Client::describe_spot_instance_requests).
///
/// See [`crate::client::fluent_builders::DescribeSpotInstanceRequests`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotInstanceRequests {
    _private: (),
}
impl DescribeSpotInstanceRequests {
    /// Creates a new builder-style object to manufacture [`DescribeSpotInstanceRequestsInput`](crate::input::DescribeSpotInstanceRequestsInput)
    pub fn builder() -> crate::input::describe_spot_instance_requests_input::Builder {
        crate::input::describe_spot_instance_requests_input::Builder::default()
    }
    /// Creates a new `DescribeSpotInstanceRequests` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotInstanceRequests {
    type Output = std::result::Result<
        crate::output::DescribeSpotInstanceRequestsOutput,
        crate::error::DescribeSpotInstanceRequestsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_instance_requests_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_instance_requests_response(response)
        }
    }
}

/// Operation shape for `DescribeSpotPriceHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_spot_price_history`](crate::client::Client::describe_spot_price_history).
///
/// See [`crate::client::fluent_builders::DescribeSpotPriceHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSpotPriceHistory {
    _private: (),
}
impl DescribeSpotPriceHistory {
    /// Creates a new builder-style object to manufacture [`DescribeSpotPriceHistoryInput`](crate::input::DescribeSpotPriceHistoryInput)
    pub fn builder() -> crate::input::describe_spot_price_history_input::Builder {
        crate::input::describe_spot_price_history_input::Builder::default()
    }
    /// Creates a new `DescribeSpotPriceHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSpotPriceHistory {
    type Output = std::result::Result<
        crate::output::DescribeSpotPriceHistoryOutput,
        crate::error::DescribeSpotPriceHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_spot_price_history_error(response)
        } else {
            crate::operation_deser::parse_describe_spot_price_history_response(response)
        }
    }
}

/// Operation shape for `DescribeStaleSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stale_security_groups`](crate::client::Client::describe_stale_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeStaleSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStaleSecurityGroups {
    _private: (),
}
impl DescribeStaleSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeStaleSecurityGroupsInput`](crate::input::DescribeStaleSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_stale_security_groups_input::Builder {
        crate::input::describe_stale_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeStaleSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStaleSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeStaleSecurityGroupsOutput,
        crate::error::DescribeStaleSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stale_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_stale_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeStoreImageTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_store_image_tasks`](crate::client::Client::describe_store_image_tasks).
///
/// See [`crate::client::fluent_builders::DescribeStoreImageTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStoreImageTasks {
    _private: (),
}
impl DescribeStoreImageTasks {
    /// Creates a new builder-style object to manufacture [`DescribeStoreImageTasksInput`](crate::input::DescribeStoreImageTasksInput)
    pub fn builder() -> crate::input::describe_store_image_tasks_input::Builder {
        crate::input::describe_store_image_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeStoreImageTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStoreImageTasks {
    type Output = std::result::Result<
        crate::output::DescribeStoreImageTasksOutput,
        crate::error::DescribeStoreImageTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_store_image_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_store_image_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeSubnets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_subnets`](crate::client::Client::describe_subnets).
///
/// See [`crate::client::fluent_builders::DescribeSubnets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSubnets {
    _private: (),
}
impl DescribeSubnets {
    /// Creates a new builder-style object to manufacture [`DescribeSubnetsInput`](crate::input::DescribeSubnetsInput)
    pub fn builder() -> crate::input::describe_subnets_input::Builder {
        crate::input::describe_subnets_input::Builder::default()
    }
    /// Creates a new `DescribeSubnets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSubnets {
    type Output = std::result::Result<
        crate::output::DescribeSubnetsOutput,
        crate::error::DescribeSubnetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_subnets_error(response)
        } else {
            crate::operation_deser::parse_describe_subnets_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeTrafficMirrorFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_traffic_mirror_filters`](crate::client::Client::describe_traffic_mirror_filters).
///
/// See [`crate::client::fluent_builders::DescribeTrafficMirrorFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrafficMirrorFilters {
    _private: (),
}
impl DescribeTrafficMirrorFilters {
    /// Creates a new builder-style object to manufacture [`DescribeTrafficMirrorFiltersInput`](crate::input::DescribeTrafficMirrorFiltersInput)
    pub fn builder() -> crate::input::describe_traffic_mirror_filters_input::Builder {
        crate::input::describe_traffic_mirror_filters_input::Builder::default()
    }
    /// Creates a new `DescribeTrafficMirrorFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrafficMirrorFilters {
    type Output = std::result::Result<
        crate::output::DescribeTrafficMirrorFiltersOutput,
        crate::error::DescribeTrafficMirrorFiltersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_traffic_mirror_filters_error(response)
        } else {
            crate::operation_deser::parse_describe_traffic_mirror_filters_response(response)
        }
    }
}

/// Operation shape for `DescribeTrafficMirrorSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_traffic_mirror_sessions`](crate::client::Client::describe_traffic_mirror_sessions).
///
/// See [`crate::client::fluent_builders::DescribeTrafficMirrorSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrafficMirrorSessions {
    _private: (),
}
impl DescribeTrafficMirrorSessions {
    /// Creates a new builder-style object to manufacture [`DescribeTrafficMirrorSessionsInput`](crate::input::DescribeTrafficMirrorSessionsInput)
    pub fn builder() -> crate::input::describe_traffic_mirror_sessions_input::Builder {
        crate::input::describe_traffic_mirror_sessions_input::Builder::default()
    }
    /// Creates a new `DescribeTrafficMirrorSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrafficMirrorSessions {
    type Output = std::result::Result<
        crate::output::DescribeTrafficMirrorSessionsOutput,
        crate::error::DescribeTrafficMirrorSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_traffic_mirror_sessions_error(response)
        } else {
            crate::operation_deser::parse_describe_traffic_mirror_sessions_response(response)
        }
    }
}

/// Operation shape for `DescribeTrafficMirrorTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_traffic_mirror_targets`](crate::client::Client::describe_traffic_mirror_targets).
///
/// See [`crate::client::fluent_builders::DescribeTrafficMirrorTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrafficMirrorTargets {
    _private: (),
}
impl DescribeTrafficMirrorTargets {
    /// Creates a new builder-style object to manufacture [`DescribeTrafficMirrorTargetsInput`](crate::input::DescribeTrafficMirrorTargetsInput)
    pub fn builder() -> crate::input::describe_traffic_mirror_targets_input::Builder {
        crate::input::describe_traffic_mirror_targets_input::Builder::default()
    }
    /// Creates a new `DescribeTrafficMirrorTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrafficMirrorTargets {
    type Output = std::result::Result<
        crate::output::DescribeTrafficMirrorTargetsOutput,
        crate::error::DescribeTrafficMirrorTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_traffic_mirror_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_traffic_mirror_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGatewayAttachments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_attachments`](crate::client::Client::describe_transit_gateway_attachments).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayAttachments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayAttachments {
    _private: (),
}
impl DescribeTransitGatewayAttachments {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayAttachmentsInput`](crate::input::DescribeTransitGatewayAttachmentsInput)
    pub fn builder() -> crate::input::describe_transit_gateway_attachments_input::Builder {
        crate::input::describe_transit_gateway_attachments_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayAttachments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayAttachments {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayAttachmentsOutput,
        crate::error::DescribeTransitGatewayAttachmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_attachments_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_attachments_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGatewayConnectPeers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_connect_peers`](crate::client::Client::describe_transit_gateway_connect_peers).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayConnectPeers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayConnectPeers {
    _private: (),
}
impl DescribeTransitGatewayConnectPeers {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayConnectPeersInput`](crate::input::DescribeTransitGatewayConnectPeersInput)
    pub fn builder() -> crate::input::describe_transit_gateway_connect_peers_input::Builder {
        crate::input::describe_transit_gateway_connect_peers_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayConnectPeers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayConnectPeers {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayConnectPeersOutput,
        crate::error::DescribeTransitGatewayConnectPeersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_connect_peers_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_connect_peers_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGatewayConnects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_connects`](crate::client::Client::describe_transit_gateway_connects).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayConnects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayConnects {
    _private: (),
}
impl DescribeTransitGatewayConnects {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayConnectsInput`](crate::input::DescribeTransitGatewayConnectsInput)
    pub fn builder() -> crate::input::describe_transit_gateway_connects_input::Builder {
        crate::input::describe_transit_gateway_connects_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayConnects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayConnects {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayConnectsOutput,
        crate::error::DescribeTransitGatewayConnectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_connects_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_connects_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGatewayMulticastDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_multicast_domains`](crate::client::Client::describe_transit_gateway_multicast_domains).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayMulticastDomains {
    _private: (),
}
impl DescribeTransitGatewayMulticastDomains {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayMulticastDomainsInput`](crate::input::DescribeTransitGatewayMulticastDomainsInput)
    pub fn builder() -> crate::input::describe_transit_gateway_multicast_domains_input::Builder {
        crate::input::describe_transit_gateway_multicast_domains_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayMulticastDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayMulticastDomains {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayMulticastDomainsOutput,
        crate::error::DescribeTransitGatewayMulticastDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_multicast_domains_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_multicast_domains_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeTransitGatewayPeeringAttachments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_peering_attachments`](crate::client::Client::describe_transit_gateway_peering_attachments).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayPeeringAttachments {
    _private: (),
}
impl DescribeTransitGatewayPeeringAttachments {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayPeeringAttachmentsInput`](crate::input::DescribeTransitGatewayPeeringAttachmentsInput)
    pub fn builder() -> crate::input::describe_transit_gateway_peering_attachments_input::Builder {
        crate::input::describe_transit_gateway_peering_attachments_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayPeeringAttachments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayPeeringAttachments {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayPeeringAttachmentsOutput,
        crate::error::DescribeTransitGatewayPeeringAttachmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_peering_attachments_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_transit_gateway_peering_attachments_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeTransitGatewayRouteTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_route_tables`](crate::client::Client::describe_transit_gateway_route_tables).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayRouteTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayRouteTables {
    _private: (),
}
impl DescribeTransitGatewayRouteTables {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayRouteTablesInput`](crate::input::DescribeTransitGatewayRouteTablesInput)
    pub fn builder() -> crate::input::describe_transit_gateway_route_tables_input::Builder {
        crate::input::describe_transit_gateway_route_tables_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayRouteTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayRouteTables {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayRouteTablesOutput,
        crate::error::DescribeTransitGatewayRouteTablesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_route_tables_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_route_tables_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateways`](crate::client::Client::describe_transit_gateways).
///
/// See [`crate::client::fluent_builders::DescribeTransitGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGateways {
    _private: (),
}
impl DescribeTransitGateways {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewaysInput`](crate::input::DescribeTransitGatewaysInput)
    pub fn builder() -> crate::input::describe_transit_gateways_input::Builder {
        crate::input::describe_transit_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGateways {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewaysOutput,
        crate::error::DescribeTransitGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateways_response(response)
        }
    }
}

/// Operation shape for `DescribeTransitGatewayVpcAttachments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transit_gateway_vpc_attachments`](crate::client::Client::describe_transit_gateway_vpc_attachments).
///
/// See [`crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransitGatewayVpcAttachments {
    _private: (),
}
impl DescribeTransitGatewayVpcAttachments {
    /// Creates a new builder-style object to manufacture [`DescribeTransitGatewayVpcAttachmentsInput`](crate::input::DescribeTransitGatewayVpcAttachmentsInput)
    pub fn builder() -> crate::input::describe_transit_gateway_vpc_attachments_input::Builder {
        crate::input::describe_transit_gateway_vpc_attachments_input::Builder::default()
    }
    /// Creates a new `DescribeTransitGatewayVpcAttachments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransitGatewayVpcAttachments {
    type Output = std::result::Result<
        crate::output::DescribeTransitGatewayVpcAttachmentsOutput,
        crate::error::DescribeTransitGatewayVpcAttachmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transit_gateway_vpc_attachments_error(response)
        } else {
            crate::operation_deser::parse_describe_transit_gateway_vpc_attachments_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeTrunkInterfaceAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_trunk_interface_associations`](crate::client::Client::describe_trunk_interface_associations).
///
/// See [`crate::client::fluent_builders::DescribeTrunkInterfaceAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrunkInterfaceAssociations {
    _private: (),
}
impl DescribeTrunkInterfaceAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeTrunkInterfaceAssociationsInput`](crate::input::DescribeTrunkInterfaceAssociationsInput)
    pub fn builder() -> crate::input::describe_trunk_interface_associations_input::Builder {
        crate::input::describe_trunk_interface_associations_input::Builder::default()
    }
    /// Creates a new `DescribeTrunkInterfaceAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrunkInterfaceAssociations {
    type Output = std::result::Result<
        crate::output::DescribeTrunkInterfaceAssociationsOutput,
        crate::error::DescribeTrunkInterfaceAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_trunk_interface_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_trunk_interface_associations_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumeAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volume_attribute`](crate::client::Client::describe_volume_attribute).
///
/// See [`crate::client::fluent_builders::DescribeVolumeAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumeAttribute {
    _private: (),
}
impl DescribeVolumeAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeVolumeAttributeInput`](crate::input::DescribeVolumeAttributeInput)
    pub fn builder() -> crate::input::describe_volume_attribute_input::Builder {
        crate::input::describe_volume_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeVolumeAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumeAttribute {
    type Output = std::result::Result<
        crate::output::DescribeVolumeAttributeOutput,
        crate::error::DescribeVolumeAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volume_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_volume_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volumes`](crate::client::Client::describe_volumes).
///
/// See [`crate::client::fluent_builders::DescribeVolumes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumes {
    _private: (),
}
impl DescribeVolumes {
    /// Creates a new builder-style object to manufacture [`DescribeVolumesInput`](crate::input::DescribeVolumesInput)
    pub fn builder() -> crate::input::describe_volumes_input::Builder {
        crate::input::describe_volumes_input::Builder::default()
    }
    /// Creates a new `DescribeVolumes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumes {
    type Output = std::result::Result<
        crate::output::DescribeVolumesOutput,
        crate::error::DescribeVolumesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volumes_error(response)
        } else {
            crate::operation_deser::parse_describe_volumes_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumesModifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volumes_modifications`](crate::client::Client::describe_volumes_modifications).
///
/// See [`crate::client::fluent_builders::DescribeVolumesModifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumesModifications {
    _private: (),
}
impl DescribeVolumesModifications {
    /// Creates a new builder-style object to manufacture [`DescribeVolumesModificationsInput`](crate::input::DescribeVolumesModificationsInput)
    pub fn builder() -> crate::input::describe_volumes_modifications_input::Builder {
        crate::input::describe_volumes_modifications_input::Builder::default()
    }
    /// Creates a new `DescribeVolumesModifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumesModifications {
    type Output = std::result::Result<
        crate::output::DescribeVolumesModificationsOutput,
        crate::error::DescribeVolumesModificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volumes_modifications_error(response)
        } else {
            crate::operation_deser::parse_describe_volumes_modifications_response(response)
        }
    }
}

/// Operation shape for `DescribeVolumeStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_volume_status`](crate::client::Client::describe_volume_status).
///
/// See [`crate::client::fluent_builders::DescribeVolumeStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVolumeStatus {
    _private: (),
}
impl DescribeVolumeStatus {
    /// Creates a new builder-style object to manufacture [`DescribeVolumeStatusInput`](crate::input::DescribeVolumeStatusInput)
    pub fn builder() -> crate::input::describe_volume_status_input::Builder {
        crate::input::describe_volume_status_input::Builder::default()
    }
    /// Creates a new `DescribeVolumeStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVolumeStatus {
    type Output = std::result::Result<
        crate::output::DescribeVolumeStatusOutput,
        crate::error::DescribeVolumeStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_volume_status_error(response)
        } else {
            crate::operation_deser::parse_describe_volume_status_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_attribute`](crate::client::Client::describe_vpc_attribute).
///
/// See [`crate::client::fluent_builders::DescribeVpcAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcAttribute {
    _private: (),
}
impl DescribeVpcAttribute {
    /// Creates a new builder-style object to manufacture [`DescribeVpcAttributeInput`](crate::input::DescribeVpcAttributeInput)
    pub fn builder() -> crate::input::describe_vpc_attribute_input::Builder {
        crate::input::describe_vpc_attribute_input::Builder::default()
    }
    /// Creates a new `DescribeVpcAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcAttribute {
    type Output = std::result::Result<
        crate::output::DescribeVpcAttributeOutput,
        crate::error::DescribeVpcAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_attribute_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_attribute_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcClassicLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_classic_link`](crate::client::Client::describe_vpc_classic_link).
///
/// See [`crate::client::fluent_builders::DescribeVpcClassicLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcClassicLink {
    _private: (),
}
impl DescribeVpcClassicLink {
    /// Creates a new builder-style object to manufacture [`DescribeVpcClassicLinkInput`](crate::input::DescribeVpcClassicLinkInput)
    pub fn builder() -> crate::input::describe_vpc_classic_link_input::Builder {
        crate::input::describe_vpc_classic_link_input::Builder::default()
    }
    /// Creates a new `DescribeVpcClassicLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcClassicLink {
    type Output = std::result::Result<
        crate::output::DescribeVpcClassicLinkOutput,
        crate::error::DescribeVpcClassicLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_classic_link_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_classic_link_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcClassicLinkDnsSupport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_classic_link_dns_support`](crate::client::Client::describe_vpc_classic_link_dns_support).
///
/// See [`crate::client::fluent_builders::DescribeVpcClassicLinkDnsSupport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcClassicLinkDnsSupport {
    _private: (),
}
impl DescribeVpcClassicLinkDnsSupport {
    /// Creates a new builder-style object to manufacture [`DescribeVpcClassicLinkDnsSupportInput`](crate::input::DescribeVpcClassicLinkDnsSupportInput)
    pub fn builder() -> crate::input::describe_vpc_classic_link_dns_support_input::Builder {
        crate::input::describe_vpc_classic_link_dns_support_input::Builder::default()
    }
    /// Creates a new `DescribeVpcClassicLinkDnsSupport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcClassicLinkDnsSupport {
    type Output = std::result::Result<
        crate::output::DescribeVpcClassicLinkDnsSupportOutput,
        crate::error::DescribeVpcClassicLinkDnsSupportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_classic_link_dns_support_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_classic_link_dns_support_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcEndpointConnectionNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoint_connection_notifications`](crate::client::Client::describe_vpc_endpoint_connection_notifications).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpointConnectionNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpointConnectionNotifications {
    _private: (),
}
impl DescribeVpcEndpointConnectionNotifications {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointConnectionNotificationsInput`](crate::input::DescribeVpcEndpointConnectionNotificationsInput)
    pub fn builder() -> crate::input::describe_vpc_endpoint_connection_notifications_input::Builder
    {
        crate::input::describe_vpc_endpoint_connection_notifications_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpointConnectionNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpointConnectionNotifications {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointConnectionNotificationsOutput,
        crate::error::DescribeVpcEndpointConnectionNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoint_connection_notifications_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_vpc_endpoint_connection_notifications_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeVpcEndpointConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoint_connections`](crate::client::Client::describe_vpc_endpoint_connections).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpointConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpointConnections {
    _private: (),
}
impl DescribeVpcEndpointConnections {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointConnectionsInput`](crate::input::DescribeVpcEndpointConnectionsInput)
    pub fn builder() -> crate::input::describe_vpc_endpoint_connections_input::Builder {
        crate::input::describe_vpc_endpoint_connections_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpointConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpointConnections {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointConnectionsOutput,
        crate::error::DescribeVpcEndpointConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoint_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_endpoint_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoints`](crate::client::Client::describe_vpc_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpoints {
    _private: (),
}
impl DescribeVpcEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointsInput`](crate::input::DescribeVpcEndpointsInput)
    pub fn builder() -> crate::input::describe_vpc_endpoints_input::Builder {
        crate::input::describe_vpc_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointsOutput,
        crate::error::DescribeVpcEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcEndpointServiceConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoint_service_configurations`](crate::client::Client::describe_vpc_endpoint_service_configurations).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpointServiceConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpointServiceConfigurations {
    _private: (),
}
impl DescribeVpcEndpointServiceConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointServiceConfigurationsInput`](crate::input::DescribeVpcEndpointServiceConfigurationsInput)
    pub fn builder() -> crate::input::describe_vpc_endpoint_service_configurations_input::Builder {
        crate::input::describe_vpc_endpoint_service_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpointServiceConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpointServiceConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointServiceConfigurationsOutput,
        crate::error::DescribeVpcEndpointServiceConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoint_service_configurations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_vpc_endpoint_service_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeVpcEndpointServicePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoint_service_permissions`](crate::client::Client::describe_vpc_endpoint_service_permissions).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpointServicePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpointServicePermissions {
    _private: (),
}
impl DescribeVpcEndpointServicePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointServicePermissionsInput`](crate::input::DescribeVpcEndpointServicePermissionsInput)
    pub fn builder() -> crate::input::describe_vpc_endpoint_service_permissions_input::Builder {
        crate::input::describe_vpc_endpoint_service_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpointServicePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpointServicePermissions {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointServicePermissionsOutput,
        crate::error::DescribeVpcEndpointServicePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoint_service_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_endpoint_service_permissions_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeVpcEndpointServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_endpoint_services`](crate::client::Client::describe_vpc_endpoint_services).
///
/// See [`crate::client::fluent_builders::DescribeVpcEndpointServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcEndpointServices {
    _private: (),
}
impl DescribeVpcEndpointServices {
    /// Creates a new builder-style object to manufacture [`DescribeVpcEndpointServicesInput`](crate::input::DescribeVpcEndpointServicesInput)
    pub fn builder() -> crate::input::describe_vpc_endpoint_services_input::Builder {
        crate::input::describe_vpc_endpoint_services_input::Builder::default()
    }
    /// Creates a new `DescribeVpcEndpointServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcEndpointServices {
    type Output = std::result::Result<
        crate::output::DescribeVpcEndpointServicesOutput,
        crate::error::DescribeVpcEndpointServicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_endpoint_services_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_endpoint_services_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcPeeringConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_peering_connections`](crate::client::Client::describe_vpc_peering_connections).
///
/// See [`crate::client::fluent_builders::DescribeVpcPeeringConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcPeeringConnections {
    _private: (),
}
impl DescribeVpcPeeringConnections {
    /// Creates a new builder-style object to manufacture [`DescribeVpcPeeringConnectionsInput`](crate::input::DescribeVpcPeeringConnectionsInput)
    pub fn builder() -> crate::input::describe_vpc_peering_connections_input::Builder {
        crate::input::describe_vpc_peering_connections_input::Builder::default()
    }
    /// Creates a new `DescribeVpcPeeringConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcPeeringConnections {
    type Output = std::result::Result<
        crate::output::DescribeVpcPeeringConnectionsOutput,
        crate::error::DescribeVpcPeeringConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_peering_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_peering_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpcs`](crate::client::Client::describe_vpcs).
///
/// See [`crate::client::fluent_builders::DescribeVpcs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcs {
    _private: (),
}
impl DescribeVpcs {
    /// Creates a new builder-style object to manufacture [`DescribeVpcsInput`](crate::input::DescribeVpcsInput)
    pub fn builder() -> crate::input::describe_vpcs_input::Builder {
        crate::input::describe_vpcs_input::Builder::default()
    }
    /// Creates a new `DescribeVpcs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcs {
    type Output =
        std::result::Result<crate::output::DescribeVpcsOutput, crate::error::DescribeVpcsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpcs_error(response)
        } else {
            crate::operation_deser::parse_describe_vpcs_response(response)
        }
    }
}

/// Operation shape for `DescribeVpnConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpn_connections`](crate::client::Client::describe_vpn_connections).
///
/// See [`crate::client::fluent_builders::DescribeVpnConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpnConnections {
    _private: (),
}
impl DescribeVpnConnections {
    /// Creates a new builder-style object to manufacture [`DescribeVpnConnectionsInput`](crate::input::DescribeVpnConnectionsInput)
    pub fn builder() -> crate::input::describe_vpn_connections_input::Builder {
        crate::input::describe_vpn_connections_input::Builder::default()
    }
    /// Creates a new `DescribeVpnConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpnConnections {
    type Output = std::result::Result<
        crate::output::DescribeVpnConnectionsOutput,
        crate::error::DescribeVpnConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpn_connections_error(response)
        } else {
            crate::operation_deser::parse_describe_vpn_connections_response(response)
        }
    }
}

/// Operation shape for `DescribeVpnGateways`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpn_gateways`](crate::client::Client::describe_vpn_gateways).
///
/// See [`crate::client::fluent_builders::DescribeVpnGateways`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpnGateways {
    _private: (),
}
impl DescribeVpnGateways {
    /// Creates a new builder-style object to manufacture [`DescribeVpnGatewaysInput`](crate::input::DescribeVpnGatewaysInput)
    pub fn builder() -> crate::input::describe_vpn_gateways_input::Builder {
        crate::input::describe_vpn_gateways_input::Builder::default()
    }
    /// Creates a new `DescribeVpnGateways` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpnGateways {
    type Output = std::result::Result<
        crate::output::DescribeVpnGatewaysOutput,
        crate::error::DescribeVpnGatewaysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpn_gateways_error(response)
        } else {
            crate::operation_deser::parse_describe_vpn_gateways_response(response)
        }
    }
}

/// Operation shape for `DetachClassicLinkVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_classic_link_vpc`](crate::client::Client::detach_classic_link_vpc).
///
/// See [`crate::client::fluent_builders::DetachClassicLinkVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachClassicLinkVpc {
    _private: (),
}
impl DetachClassicLinkVpc {
    /// Creates a new builder-style object to manufacture [`DetachClassicLinkVpcInput`](crate::input::DetachClassicLinkVpcInput)
    pub fn builder() -> crate::input::detach_classic_link_vpc_input::Builder {
        crate::input::detach_classic_link_vpc_input::Builder::default()
    }
    /// Creates a new `DetachClassicLinkVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachClassicLinkVpc {
    type Output = std::result::Result<
        crate::output::DetachClassicLinkVpcOutput,
        crate::error::DetachClassicLinkVpcError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_classic_link_vpc_error(response)
        } else {
            crate::operation_deser::parse_detach_classic_link_vpc_response(response)
        }
    }
}

/// Operation shape for `DetachInternetGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_internet_gateway`](crate::client::Client::detach_internet_gateway).
///
/// See [`crate::client::fluent_builders::DetachInternetGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachInternetGateway {
    _private: (),
}
impl DetachInternetGateway {
    /// Creates a new builder-style object to manufacture [`DetachInternetGatewayInput`](crate::input::DetachInternetGatewayInput)
    pub fn builder() -> crate::input::detach_internet_gateway_input::Builder {
        crate::input::detach_internet_gateway_input::Builder::default()
    }
    /// Creates a new `DetachInternetGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachInternetGateway {
    type Output = std::result::Result<
        crate::output::DetachInternetGatewayOutput,
        crate::error::DetachInternetGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_internet_gateway_error(response)
        } else {
            crate::operation_deser::parse_detach_internet_gateway_response(response)
        }
    }
}

/// Operation shape for `DetachNetworkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_network_interface`](crate::client::Client::detach_network_interface).
///
/// See [`crate::client::fluent_builders::DetachNetworkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachNetworkInterface {
    _private: (),
}
impl DetachNetworkInterface {
    /// Creates a new builder-style object to manufacture [`DetachNetworkInterfaceInput`](crate::input::DetachNetworkInterfaceInput)
    pub fn builder() -> crate::input::detach_network_interface_input::Builder {
        crate::input::detach_network_interface_input::Builder::default()
    }
    /// Creates a new `DetachNetworkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachNetworkInterface {
    type Output = std::result::Result<
        crate::output::DetachNetworkInterfaceOutput,
        crate::error::DetachNetworkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_network_interface_error(response)
        } else {
            crate::operation_deser::parse_detach_network_interface_response(response)
        }
    }
}

/// Operation shape for `DetachVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_volume`](crate::client::Client::detach_volume).
///
/// See [`crate::client::fluent_builders::DetachVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachVolume {
    _private: (),
}
impl DetachVolume {
    /// Creates a new builder-style object to manufacture [`DetachVolumeInput`](crate::input::DetachVolumeInput)
    pub fn builder() -> crate::input::detach_volume_input::Builder {
        crate::input::detach_volume_input::Builder::default()
    }
    /// Creates a new `DetachVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachVolume {
    type Output =
        std::result::Result<crate::output::DetachVolumeOutput, crate::error::DetachVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_volume_error(response)
        } else {
            crate::operation_deser::parse_detach_volume_response(response)
        }
    }
}

/// Operation shape for `DetachVpnGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_vpn_gateway`](crate::client::Client::detach_vpn_gateway).
///
/// See [`crate::client::fluent_builders::DetachVpnGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachVpnGateway {
    _private: (),
}
impl DetachVpnGateway {
    /// Creates a new builder-style object to manufacture [`DetachVpnGatewayInput`](crate::input::DetachVpnGatewayInput)
    pub fn builder() -> crate::input::detach_vpn_gateway_input::Builder {
        crate::input::detach_vpn_gateway_input::Builder::default()
    }
    /// Creates a new `DetachVpnGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachVpnGateway {
    type Output = std::result::Result<
        crate::output::DetachVpnGatewayOutput,
        crate::error::DetachVpnGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_vpn_gateway_error(response)
        } else {
            crate::operation_deser::parse_detach_vpn_gateway_response(response)
        }
    }
}

/// Operation shape for `DisableEbsEncryptionByDefault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_ebs_encryption_by_default`](crate::client::Client::disable_ebs_encryption_by_default).
///
/// See [`crate::client::fluent_builders::DisableEbsEncryptionByDefault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableEbsEncryptionByDefault {
    _private: (),
}
impl DisableEbsEncryptionByDefault {
    /// Creates a new builder-style object to manufacture [`DisableEbsEncryptionByDefaultInput`](crate::input::DisableEbsEncryptionByDefaultInput)
    pub fn builder() -> crate::input::disable_ebs_encryption_by_default_input::Builder {
        crate::input::disable_ebs_encryption_by_default_input::Builder::default()
    }
    /// Creates a new `DisableEbsEncryptionByDefault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableEbsEncryptionByDefault {
    type Output = std::result::Result<
        crate::output::DisableEbsEncryptionByDefaultOutput,
        crate::error::DisableEbsEncryptionByDefaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_ebs_encryption_by_default_error(response)
        } else {
            crate::operation_deser::parse_disable_ebs_encryption_by_default_response(response)
        }
    }
}

/// Operation shape for `DisableFastLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_fast_launch`](crate::client::Client::disable_fast_launch).
///
/// See [`crate::client::fluent_builders::DisableFastLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableFastLaunch {
    _private: (),
}
impl DisableFastLaunch {
    /// Creates a new builder-style object to manufacture [`DisableFastLaunchInput`](crate::input::DisableFastLaunchInput)
    pub fn builder() -> crate::input::disable_fast_launch_input::Builder {
        crate::input::disable_fast_launch_input::Builder::default()
    }
    /// Creates a new `DisableFastLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableFastLaunch {
    type Output = std::result::Result<
        crate::output::DisableFastLaunchOutput,
        crate::error::DisableFastLaunchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_fast_launch_error(response)
        } else {
            crate::operation_deser::parse_disable_fast_launch_response(response)
        }
    }
}

/// Operation shape for `DisableFastSnapshotRestores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_fast_snapshot_restores`](crate::client::Client::disable_fast_snapshot_restores).
///
/// See [`crate::client::fluent_builders::DisableFastSnapshotRestores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableFastSnapshotRestores {
    _private: (),
}
impl DisableFastSnapshotRestores {
    /// Creates a new builder-style object to manufacture [`DisableFastSnapshotRestoresInput`](crate::input::DisableFastSnapshotRestoresInput)
    pub fn builder() -> crate::input::disable_fast_snapshot_restores_input::Builder {
        crate::input::disable_fast_snapshot_restores_input::Builder::default()
    }
    /// Creates a new `DisableFastSnapshotRestores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableFastSnapshotRestores {
    type Output = std::result::Result<
        crate::output::DisableFastSnapshotRestoresOutput,
        crate::error::DisableFastSnapshotRestoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_fast_snapshot_restores_error(response)
        } else {
            crate::operation_deser::parse_disable_fast_snapshot_restores_response(response)
        }
    }
}

/// Operation shape for `DisableImageDeprecation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_image_deprecation`](crate::client::Client::disable_image_deprecation).
///
/// See [`crate::client::fluent_builders::DisableImageDeprecation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableImageDeprecation {
    _private: (),
}
impl DisableImageDeprecation {
    /// Creates a new builder-style object to manufacture [`DisableImageDeprecationInput`](crate::input::DisableImageDeprecationInput)
    pub fn builder() -> crate::input::disable_image_deprecation_input::Builder {
        crate::input::disable_image_deprecation_input::Builder::default()
    }
    /// Creates a new `DisableImageDeprecation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableImageDeprecation {
    type Output = std::result::Result<
        crate::output::DisableImageDeprecationOutput,
        crate::error::DisableImageDeprecationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_image_deprecation_error(response)
        } else {
            crate::operation_deser::parse_disable_image_deprecation_response(response)
        }
    }
}

/// Operation shape for `DisableIpamOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_ipam_organization_admin_account`](crate::client::Client::disable_ipam_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DisableIpamOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableIpamOrganizationAdminAccount {
    _private: (),
}
impl DisableIpamOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableIpamOrganizationAdminAccountInput`](crate::input::DisableIpamOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_ipam_organization_admin_account_input::Builder {
        crate::input::disable_ipam_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableIpamOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableIpamOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableIpamOrganizationAdminAccountOutput,
        crate::error::DisableIpamOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_ipam_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_ipam_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisableSerialConsoleAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_serial_console_access`](crate::client::Client::disable_serial_console_access).
///
/// See [`crate::client::fluent_builders::DisableSerialConsoleAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableSerialConsoleAccess {
    _private: (),
}
impl DisableSerialConsoleAccess {
    /// Creates a new builder-style object to manufacture [`DisableSerialConsoleAccessInput`](crate::input::DisableSerialConsoleAccessInput)
    pub fn builder() -> crate::input::disable_serial_console_access_input::Builder {
        crate::input::disable_serial_console_access_input::Builder::default()
    }
    /// Creates a new `DisableSerialConsoleAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableSerialConsoleAccess {
    type Output = std::result::Result<
        crate::output::DisableSerialConsoleAccessOutput,
        crate::error::DisableSerialConsoleAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_serial_console_access_error(response)
        } else {
            crate::operation_deser::parse_disable_serial_console_access_response(response)
        }
    }
}

/// Operation shape for `DisableTransitGatewayRouteTablePropagation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_transit_gateway_route_table_propagation`](crate::client::Client::disable_transit_gateway_route_table_propagation).
///
/// See [`crate::client::fluent_builders::DisableTransitGatewayRouteTablePropagation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableTransitGatewayRouteTablePropagation {
    _private: (),
}
impl DisableTransitGatewayRouteTablePropagation {
    /// Creates a new builder-style object to manufacture [`DisableTransitGatewayRouteTablePropagationInput`](crate::input::DisableTransitGatewayRouteTablePropagationInput)
    pub fn builder() -> crate::input::disable_transit_gateway_route_table_propagation_input::Builder
    {
        crate::input::disable_transit_gateway_route_table_propagation_input::Builder::default()
    }
    /// Creates a new `DisableTransitGatewayRouteTablePropagation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableTransitGatewayRouteTablePropagation {
    type Output = std::result::Result<
        crate::output::DisableTransitGatewayRouteTablePropagationOutput,
        crate::error::DisableTransitGatewayRouteTablePropagationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_transit_gateway_route_table_propagation_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disable_transit_gateway_route_table_propagation_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisableVgwRoutePropagation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_vgw_route_propagation`](crate::client::Client::disable_vgw_route_propagation).
///
/// See [`crate::client::fluent_builders::DisableVgwRoutePropagation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableVgwRoutePropagation {
    _private: (),
}
impl DisableVgwRoutePropagation {
    /// Creates a new builder-style object to manufacture [`DisableVgwRoutePropagationInput`](crate::input::DisableVgwRoutePropagationInput)
    pub fn builder() -> crate::input::disable_vgw_route_propagation_input::Builder {
        crate::input::disable_vgw_route_propagation_input::Builder::default()
    }
    /// Creates a new `DisableVgwRoutePropagation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableVgwRoutePropagation {
    type Output = std::result::Result<
        crate::output::DisableVgwRoutePropagationOutput,
        crate::error::DisableVgwRoutePropagationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_vgw_route_propagation_error(response)
        } else {
            crate::operation_deser::parse_disable_vgw_route_propagation_response(response)
        }
    }
}

/// Operation shape for `DisableVpcClassicLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_vpc_classic_link`](crate::client::Client::disable_vpc_classic_link).
///
/// See [`crate::client::fluent_builders::DisableVpcClassicLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableVpcClassicLink {
    _private: (),
}
impl DisableVpcClassicLink {
    /// Creates a new builder-style object to manufacture [`DisableVpcClassicLinkInput`](crate::input::DisableVpcClassicLinkInput)
    pub fn builder() -> crate::input::disable_vpc_classic_link_input::Builder {
        crate::input::disable_vpc_classic_link_input::Builder::default()
    }
    /// Creates a new `DisableVpcClassicLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableVpcClassicLink {
    type Output = std::result::Result<
        crate::output::DisableVpcClassicLinkOutput,
        crate::error::DisableVpcClassicLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_vpc_classic_link_error(response)
        } else {
            crate::operation_deser::parse_disable_vpc_classic_link_response(response)
        }
    }
}

/// Operation shape for `DisableVpcClassicLinkDnsSupport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_vpc_classic_link_dns_support`](crate::client::Client::disable_vpc_classic_link_dns_support).
///
/// See [`crate::client::fluent_builders::DisableVpcClassicLinkDnsSupport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableVpcClassicLinkDnsSupport {
    _private: (),
}
impl DisableVpcClassicLinkDnsSupport {
    /// Creates a new builder-style object to manufacture [`DisableVpcClassicLinkDnsSupportInput`](crate::input::DisableVpcClassicLinkDnsSupportInput)
    pub fn builder() -> crate::input::disable_vpc_classic_link_dns_support_input::Builder {
        crate::input::disable_vpc_classic_link_dns_support_input::Builder::default()
    }
    /// Creates a new `DisableVpcClassicLinkDnsSupport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableVpcClassicLinkDnsSupport {
    type Output = std::result::Result<
        crate::output::DisableVpcClassicLinkDnsSupportOutput,
        crate::error::DisableVpcClassicLinkDnsSupportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_vpc_classic_link_dns_support_error(response)
        } else {
            crate::operation_deser::parse_disable_vpc_classic_link_dns_support_response(response)
        }
    }
}

/// Operation shape for `DisassociateAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_address`](crate::client::Client::disassociate_address).
///
/// See [`crate::client::fluent_builders::DisassociateAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAddress {
    _private: (),
}
impl DisassociateAddress {
    /// Creates a new builder-style object to manufacture [`DisassociateAddressInput`](crate::input::DisassociateAddressInput)
    pub fn builder() -> crate::input::disassociate_address_input::Builder {
        crate::input::disassociate_address_input::Builder::default()
    }
    /// Creates a new `DisassociateAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAddress {
    type Output = std::result::Result<
        crate::output::DisassociateAddressOutput,
        crate::error::DisassociateAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_address_error(response)
        } else {
            crate::operation_deser::parse_disassociate_address_response(response)
        }
    }
}

/// Operation shape for `DisassociateClientVpnTargetNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_client_vpn_target_network`](crate::client::Client::disassociate_client_vpn_target_network).
///
/// See [`crate::client::fluent_builders::DisassociateClientVpnTargetNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateClientVpnTargetNetwork {
    _private: (),
}
impl DisassociateClientVpnTargetNetwork {
    /// Creates a new builder-style object to manufacture [`DisassociateClientVpnTargetNetworkInput`](crate::input::DisassociateClientVpnTargetNetworkInput)
    pub fn builder() -> crate::input::disassociate_client_vpn_target_network_input::Builder {
        crate::input::disassociate_client_vpn_target_network_input::Builder::default()
    }
    /// Creates a new `DisassociateClientVpnTargetNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateClientVpnTargetNetwork {
    type Output = std::result::Result<
        crate::output::DisassociateClientVpnTargetNetworkOutput,
        crate::error::DisassociateClientVpnTargetNetworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_client_vpn_target_network_error(response)
        } else {
            crate::operation_deser::parse_disassociate_client_vpn_target_network_response(response)
        }
    }
}

/// Operation shape for `DisassociateEnclaveCertificateIamRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_enclave_certificate_iam_role`](crate::client::Client::disassociate_enclave_certificate_iam_role).
///
/// See [`crate::client::fluent_builders::DisassociateEnclaveCertificateIamRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateEnclaveCertificateIamRole {
    _private: (),
}
impl DisassociateEnclaveCertificateIamRole {
    /// Creates a new builder-style object to manufacture [`DisassociateEnclaveCertificateIamRoleInput`](crate::input::DisassociateEnclaveCertificateIamRoleInput)
    pub fn builder() -> crate::input::disassociate_enclave_certificate_iam_role_input::Builder {
        crate::input::disassociate_enclave_certificate_iam_role_input::Builder::default()
    }
    /// Creates a new `DisassociateEnclaveCertificateIamRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateEnclaveCertificateIamRole {
    type Output = std::result::Result<
        crate::output::DisassociateEnclaveCertificateIamRoleOutput,
        crate::error::DisassociateEnclaveCertificateIamRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_enclave_certificate_iam_role_error(response)
        } else {
            crate::operation_deser::parse_disassociate_enclave_certificate_iam_role_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateIamInstanceProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_iam_instance_profile`](crate::client::Client::disassociate_iam_instance_profile).
///
/// See [`crate::client::fluent_builders::DisassociateIamInstanceProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateIamInstanceProfile {
    _private: (),
}
impl DisassociateIamInstanceProfile {
    /// Creates a new builder-style object to manufacture [`DisassociateIamInstanceProfileInput`](crate::input::DisassociateIamInstanceProfileInput)
    pub fn builder() -> crate::input::disassociate_iam_instance_profile_input::Builder {
        crate::input::disassociate_iam_instance_profile_input::Builder::default()
    }
    /// Creates a new `DisassociateIamInstanceProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateIamInstanceProfile {
    type Output = std::result::Result<
        crate::output::DisassociateIamInstanceProfileOutput,
        crate::error::DisassociateIamInstanceProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_iam_instance_profile_error(response)
        } else {
            crate::operation_deser::parse_disassociate_iam_instance_profile_response(response)
        }
    }
}

/// Operation shape for `DisassociateInstanceEventWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_instance_event_window`](crate::client::Client::disassociate_instance_event_window).
///
/// See [`crate::client::fluent_builders::DisassociateInstanceEventWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateInstanceEventWindow {
    _private: (),
}
impl DisassociateInstanceEventWindow {
    /// Creates a new builder-style object to manufacture [`DisassociateInstanceEventWindowInput`](crate::input::DisassociateInstanceEventWindowInput)
    pub fn builder() -> crate::input::disassociate_instance_event_window_input::Builder {
        crate::input::disassociate_instance_event_window_input::Builder::default()
    }
    /// Creates a new `DisassociateInstanceEventWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateInstanceEventWindow {
    type Output = std::result::Result<
        crate::output::DisassociateInstanceEventWindowOutput,
        crate::error::DisassociateInstanceEventWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_instance_event_window_error(response)
        } else {
            crate::operation_deser::parse_disassociate_instance_event_window_response(response)
        }
    }
}

/// Operation shape for `DisassociateRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_route_table`](crate::client::Client::disassociate_route_table).
///
/// See [`crate::client::fluent_builders::DisassociateRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateRouteTable {
    _private: (),
}
impl DisassociateRouteTable {
    /// Creates a new builder-style object to manufacture [`DisassociateRouteTableInput`](crate::input::DisassociateRouteTableInput)
    pub fn builder() -> crate::input::disassociate_route_table_input::Builder {
        crate::input::disassociate_route_table_input::Builder::default()
    }
    /// Creates a new `DisassociateRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateRouteTable {
    type Output = std::result::Result<
        crate::output::DisassociateRouteTableOutput,
        crate::error::DisassociateRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_route_table_error(response)
        } else {
            crate::operation_deser::parse_disassociate_route_table_response(response)
        }
    }
}

/// Operation shape for `DisassociateSubnetCidrBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_subnet_cidr_block`](crate::client::Client::disassociate_subnet_cidr_block).
///
/// See [`crate::client::fluent_builders::DisassociateSubnetCidrBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateSubnetCidrBlock {
    _private: (),
}
impl DisassociateSubnetCidrBlock {
    /// Creates a new builder-style object to manufacture [`DisassociateSubnetCidrBlockInput`](crate::input::DisassociateSubnetCidrBlockInput)
    pub fn builder() -> crate::input::disassociate_subnet_cidr_block_input::Builder {
        crate::input::disassociate_subnet_cidr_block_input::Builder::default()
    }
    /// Creates a new `DisassociateSubnetCidrBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateSubnetCidrBlock {
    type Output = std::result::Result<
        crate::output::DisassociateSubnetCidrBlockOutput,
        crate::error::DisassociateSubnetCidrBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_subnet_cidr_block_error(response)
        } else {
            crate::operation_deser::parse_disassociate_subnet_cidr_block_response(response)
        }
    }
}

/// Operation shape for `DisassociateTransitGatewayMulticastDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_transit_gateway_multicast_domain`](crate::client::Client::disassociate_transit_gateway_multicast_domain).
///
/// See [`crate::client::fluent_builders::DisassociateTransitGatewayMulticastDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTransitGatewayMulticastDomain {
    _private: (),
}
impl DisassociateTransitGatewayMulticastDomain {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayMulticastDomainInput`](crate::input::DisassociateTransitGatewayMulticastDomainInput)
    pub fn builder() -> crate::input::disassociate_transit_gateway_multicast_domain_input::Builder {
        crate::input::disassociate_transit_gateway_multicast_domain_input::Builder::default()
    }
    /// Creates a new `DisassociateTransitGatewayMulticastDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTransitGatewayMulticastDomain {
    type Output = std::result::Result<
        crate::output::DisassociateTransitGatewayMulticastDomainOutput,
        crate::error::DisassociateTransitGatewayMulticastDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_transit_gateway_multicast_domain_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_transit_gateway_multicast_domain_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateTransitGatewayRouteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_transit_gateway_route_table`](crate::client::Client::disassociate_transit_gateway_route_table).
///
/// See [`crate::client::fluent_builders::DisassociateTransitGatewayRouteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTransitGatewayRouteTable {
    _private: (),
}
impl DisassociateTransitGatewayRouteTable {
    /// Creates a new builder-style object to manufacture [`DisassociateTransitGatewayRouteTableInput`](crate::input::DisassociateTransitGatewayRouteTableInput)
    pub fn builder() -> crate::input::disassociate_transit_gateway_route_table_input::Builder {
        crate::input::disassociate_transit_gateway_route_table_input::Builder::default()
    }
    /// Creates a new `DisassociateTransitGatewayRouteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTransitGatewayRouteTable {
    type Output = std::result::Result<
        crate::output::DisassociateTransitGatewayRouteTableOutput,
        crate::error::DisassociateTransitGatewayRouteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_transit_gateway_route_table_error(response)
        } else {
            crate::operation_deser::parse_disassociate_transit_gateway_route_table_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateTrunkInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_trunk_interface`](crate::client::Client::disassociate_trunk_interface).
///
/// See [`crate::client::fluent_builders::DisassociateTrunkInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTrunkInterface {
    _private: (),
}
impl DisassociateTrunkInterface {
    /// Creates a new builder-style object to manufacture [`DisassociateTrunkInterfaceInput`](crate::input::DisassociateTrunkInterfaceInput)
    pub fn builder() -> crate::input::disassociate_trunk_interface_input::Builder {
        crate::input::disassociate_trunk_interface_input::Builder::default()
    }
    /// Creates a new `DisassociateTrunkInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTrunkInterface {
    type Output = std::result::Result<
        crate::output::DisassociateTrunkInterfaceOutput,
        crate::error::DisassociateTrunkInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_trunk_interface_error(response)
        } else {
            crate::operation_deser::parse_disassociate_trunk_interface_response(response)
        }
    }
}

/// Operation shape for `DisassociateVpcCidrBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_vpc_cidr_block`](crate::client::Client::disassociate_vpc_cidr_block).
///
/// See [`crate::client::fluent_builders::DisassociateVpcCidrBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateVpcCidrBlock {
    _private: (),
}
impl DisassociateVpcCidrBlock {
    /// Creates a new builder-style object to manufacture [`DisassociateVpcCidrBlockInput`](crate::input::DisassociateVpcCidrBlockInput)
    pub fn builder() -> crate::input::disassociate_vpc_cidr_block_input::Builder {
        crate::input::disassociate_vpc_cidr_block_input::Builder::default()
    }
    /// Creates a new `DisassociateVpcCidrBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateVpcCidrBlock {
    type Output = std::result::Result<
        crate::output::DisassociateVpcCidrBlockOutput,
        crate::error::DisassociateVpcCidrBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_vpc_cidr_block_error(response)
        } else {
            crate::operation_deser::parse_disassociate_vpc_cidr_block_response(response)
        }
    }
}

/// Operation shape for `EnableEbsEncryptionByDefault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_ebs_encryption_by_default`](crate::client::Client::enable_ebs_encryption_by_default).
///
/// See [`crate::client::fluent_builders::EnableEbsEncryptionByDefault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableEbsEncryptionByDefault {
    _private: (),
}
impl EnableEbsEncryptionByDefault {
    /// Creates a new builder-style object to manufacture [`EnableEbsEncryptionByDefaultInput`](crate::input::EnableEbsEncryptionByDefaultInput)
    pub fn builder() -> crate::input::enable_ebs_encryption_by_default_input::Builder {
        crate::input::enable_ebs_encryption_by_default_input::Builder::default()
    }
    /// Creates a new `EnableEbsEncryptionByDefault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableEbsEncryptionByDefault {
    type Output = std::result::Result<
        crate::output::EnableEbsEncryptionByDefaultOutput,
        crate::error::EnableEbsEncryptionByDefaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_ebs_encryption_by_default_error(response)
        } else {
            crate::operation_deser::parse_enable_ebs_encryption_by_default_response(response)
        }
    }
}

/// Operation shape for `EnableFastLaunch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_fast_launch`](crate::client::Client::enable_fast_launch).
///
/// See [`crate::client::fluent_builders::EnableFastLaunch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableFastLaunch {
    _private: (),
}
impl EnableFastLaunch {
    /// Creates a new builder-style object to manufacture [`EnableFastLaunchInput`](crate::input::EnableFastLaunchInput)
    pub fn builder() -> crate::input::enable_fast_launch_input::Builder {
        crate::input::enable_fast_launch_input::Builder::default()
    }
    /// Creates a new `EnableFastLaunch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableFastLaunch {
    type Output = std::result::Result<
        crate::output::EnableFastLaunchOutput,
        crate::error::EnableFastLaunchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_fast_launch_error(response)
        } else {
            crate::operation_deser::parse_enable_fast_launch_response(response)
        }
    }
}

/// Operation shape for `EnableFastSnapshotRestores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_fast_snapshot_restores`](crate::client::Client::enable_fast_snapshot_restores).
///
/// See [`crate::client::fluent_builders::EnableFastSnapshotRestores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableFastSnapshotRestores {
    _private: (),
}
impl EnableFastSnapshotRestores {
    /// Creates a new builder-style object to manufacture [`EnableFastSnapshotRestoresInput`](crate::input::EnableFastSnapshotRestoresInput)
    pub fn builder() -> crate::input::enable_fast_snapshot_restores_input::Builder {
        crate::input::enable_fast_snapshot_restores_input::Builder::default()
    }
    /// Creates a new `EnableFastSnapshotRestores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableFastSnapshotRestores {
    type Output = std::result::Result<
        crate::output::EnableFastSnapshotRestoresOutput,
        crate::error::EnableFastSnapshotRestoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_fast_snapshot_restores_error(response)
        } else {
            crate::operation_deser::parse_enable_fast_snapshot_restores_response(response)
        }
    }
}

/// Operation shape for `EnableImageDeprecation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_image_deprecation`](crate::client::Client::enable_image_deprecation).
///
/// See [`crate::client::fluent_builders::EnableImageDeprecation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableImageDeprecation {
    _private: (),
}
impl EnableImageDeprecation {
    /// Creates a new builder-style object to manufacture [`EnableImageDeprecationInput`](crate::input::EnableImageDeprecationInput)
    pub fn builder() -> crate::input::enable_image_deprecation_input::Builder {
        crate::input::enable_image_deprecation_input::Builder::default()
    }
    /// Creates a new `EnableImageDeprecation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableImageDeprecation {
    type Output = std::result::Result<
        crate::output::EnableImageDeprecationOutput,
        crate::error::EnableImageDeprecationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_image_deprecation_error(response)
        } else {
            crate::operation_deser::parse_enable_image_deprecation_response(response)
        }
    }
}

/// Operation shape for `EnableIpamOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_ipam_organization_admin_account`](crate::client::Client::enable_ipam_organization_admin_account).
///
/// See [`crate::client::fluent_builders::EnableIpamOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableIpamOrganizationAdminAccount {
    _private: (),
}
impl EnableIpamOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableIpamOrganizationAdminAccountInput`](crate::input::EnableIpamOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_ipam_organization_admin_account_input::Builder {
        crate::input::enable_ipam_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableIpamOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableIpamOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableIpamOrganizationAdminAccountOutput,
        crate::error::EnableIpamOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_ipam_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_ipam_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `EnableSerialConsoleAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_serial_console_access`](crate::client::Client::enable_serial_console_access).
///
/// See [`crate::client::fluent_builders::EnableSerialConsoleAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableSerialConsoleAccess {
    _private: (),
}
impl EnableSerialConsoleAccess {
    /// Creates a new builder-style object to manufacture [`EnableSerialConsoleAccessInput`](crate::input::EnableSerialConsoleAccessInput)
    pub fn builder() -> crate::input::enable_serial_console_access_input::Builder {
        crate::input::enable_serial_console_access_input::Builder::default()
    }
    /// Creates a new `EnableSerialConsoleAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableSerialConsoleAccess {
    type Output = std::result::Result<
        crate::output::EnableSerialConsoleAccessOutput,
        crate::error::EnableSerialConsoleAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_serial_console_access_error(response)
        } else {
            crate::operation_deser::parse_enable_serial_console_access_response(response)
        }
    }
}

/// Operation shape for `EnableTransitGatewayRouteTablePropagation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_transit_gateway_route_table_propagation`](crate::client::Client::enable_transit_gateway_route_table_propagation).
///
/// See [`crate::client::fluent_builders::EnableTransitGatewayRouteTablePropagation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableTransitGatewayRouteTablePropagation {
    _private: (),
}
impl EnableTransitGatewayRouteTablePropagation {
    /// Creates a new builder-style object to manufacture [`EnableTransitGatewayRouteTablePropagationInput`](crate::input::EnableTransitGatewayRouteTablePropagationInput)
    pub fn builder() -> crate::input::enable_transit_gateway_route_table_propagation_input::Builder
    {
        crate::input::enable_transit_gateway_route_table_propagation_input::Builder::default()
    }
    /// Creates a new `EnableTransitGatewayRouteTablePropagation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableTransitGatewayRouteTablePropagation {
    type Output = std::result::Result<
        crate::output::EnableTransitGatewayRouteTablePropagationOutput,
        crate::error::EnableTransitGatewayRouteTablePropagationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_transit_gateway_route_table_propagation_error(
                response,
            )
        } else {
            crate::operation_deser::parse_enable_transit_gateway_route_table_propagation_response(
                response,
            )
        }
    }
}

/// Operation shape for `EnableVgwRoutePropagation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_vgw_route_propagation`](crate::client::Client::enable_vgw_route_propagation).
///
/// See [`crate::client::fluent_builders::EnableVgwRoutePropagation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableVgwRoutePropagation {
    _private: (),
}
impl EnableVgwRoutePropagation {
    /// Creates a new builder-style object to manufacture [`EnableVgwRoutePropagationInput`](crate::input::EnableVgwRoutePropagationInput)
    pub fn builder() -> crate::input::enable_vgw_route_propagation_input::Builder {
        crate::input::enable_vgw_route_propagation_input::Builder::default()
    }
    /// Creates a new `EnableVgwRoutePropagation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableVgwRoutePropagation {
    type Output = std::result::Result<
        crate::output::EnableVgwRoutePropagationOutput,
        crate::error::EnableVgwRoutePropagationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_vgw_route_propagation_error(response)
        } else {
            crate::operation_deser::parse_enable_vgw_route_propagation_response(response)
        }
    }
}

/// Operation shape for `EnableVolumeIO`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_volume_io`](crate::client::Client::enable_volume_io).
///
/// See [`crate::client::fluent_builders::EnableVolumeIO`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableVolumeIO {
    _private: (),
}
impl EnableVolumeIO {
    /// Creates a new builder-style object to manufacture [`EnableVolumeIoInput`](crate::input::EnableVolumeIoInput)
    pub fn builder() -> crate::input::enable_volume_io_input::Builder {
        crate::input::enable_volume_io_input::Builder::default()
    }
    /// Creates a new `EnableVolumeIO` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableVolumeIO {
    type Output =
        std::result::Result<crate::output::EnableVolumeIoOutput, crate::error::EnableVolumeIOError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_volume_io_error(response)
        } else {
            crate::operation_deser::parse_enable_volume_io_response(response)
        }
    }
}

/// Operation shape for `EnableVpcClassicLink`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_vpc_classic_link`](crate::client::Client::enable_vpc_classic_link).
///
/// See [`crate::client::fluent_builders::EnableVpcClassicLink`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableVpcClassicLink {
    _private: (),
}
impl EnableVpcClassicLink {
    /// Creates a new builder-style object to manufacture [`EnableVpcClassicLinkInput`](crate::input::EnableVpcClassicLinkInput)
    pub fn builder() -> crate::input::enable_vpc_classic_link_input::Builder {
        crate::input::enable_vpc_classic_link_input::Builder::default()
    }
    /// Creates a new `EnableVpcClassicLink` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableVpcClassicLink {
    type Output = std::result::Result<
        crate::output::EnableVpcClassicLinkOutput,
        crate::error::EnableVpcClassicLinkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_vpc_classic_link_error(response)
        } else {
            crate::operation_deser::parse_enable_vpc_classic_link_response(response)
        }
    }
}

/// Operation shape for `EnableVpcClassicLinkDnsSupport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_vpc_classic_link_dns_support`](crate::client::Client::enable_vpc_classic_link_dns_support).
///
/// See [`crate::client::fluent_builders::EnableVpcClassicLinkDnsSupport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableVpcClassicLinkDnsSupport {
    _private: (),
}
impl EnableVpcClassicLinkDnsSupport {
    /// Creates a new builder-style object to manufacture [`EnableVpcClassicLinkDnsSupportInput`](crate::input::EnableVpcClassicLinkDnsSupportInput)
    pub fn builder() -> crate::input::enable_vpc_classic_link_dns_support_input::Builder {
        crate::input::enable_vpc_classic_link_dns_support_input::Builder::default()
    }
    /// Creates a new `EnableVpcClassicLinkDnsSupport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableVpcClassicLinkDnsSupport {
    type Output = std::result::Result<
        crate::output::EnableVpcClassicLinkDnsSupportOutput,
        crate::error::EnableVpcClassicLinkDnsSupportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_vpc_classic_link_dns_support_error(response)
        } else {
            crate::operation_deser::parse_enable_vpc_classic_link_dns_support_response(response)
        }
    }
}

/// Operation shape for `ExportClientVpnClientCertificateRevocationList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_client_vpn_client_certificate_revocation_list`](crate::client::Client::export_client_vpn_client_certificate_revocation_list).
///
/// See [`crate::client::fluent_builders::ExportClientVpnClientCertificateRevocationList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportClientVpnClientCertificateRevocationList {
    _private: (),
}
impl ExportClientVpnClientCertificateRevocationList {
    /// Creates a new builder-style object to manufacture [`ExportClientVpnClientCertificateRevocationListInput`](crate::input::ExportClientVpnClientCertificateRevocationListInput)
    pub fn builder(
    ) -> crate::input::export_client_vpn_client_certificate_revocation_list_input::Builder {
        crate::input::export_client_vpn_client_certificate_revocation_list_input::Builder::default()
    }
    /// Creates a new `ExportClientVpnClientCertificateRevocationList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ExportClientVpnClientCertificateRevocationList
{
    type Output = std::result::Result<
        crate::output::ExportClientVpnClientCertificateRevocationListOutput,
        crate::error::ExportClientVpnClientCertificateRevocationListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_client_vpn_client_certificate_revocation_list_error(
                response,
            )
        } else {
            crate::operation_deser::parse_export_client_vpn_client_certificate_revocation_list_response(response)
        }
    }
}

/// Operation shape for `ExportClientVpnClientConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_client_vpn_client_configuration`](crate::client::Client::export_client_vpn_client_configuration).
///
/// See [`crate::client::fluent_builders::ExportClientVpnClientConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportClientVpnClientConfiguration {
    _private: (),
}
impl ExportClientVpnClientConfiguration {
    /// Creates a new builder-style object to manufacture [`ExportClientVpnClientConfigurationInput`](crate::input::ExportClientVpnClientConfigurationInput)
    pub fn builder() -> crate::input::export_client_vpn_client_configuration_input::Builder {
        crate::input::export_client_vpn_client_configuration_input::Builder::default()
    }
    /// Creates a new `ExportClientVpnClientConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportClientVpnClientConfiguration {
    type Output = std::result::Result<
        crate::output::ExportClientVpnClientConfigurationOutput,
        crate::error::ExportClientVpnClientConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_client_vpn_client_configuration_error(response)
        } else {
            crate::operation_deser::parse_export_client_vpn_client_configuration_response(response)
        }
    }
}

/// Operation shape for `ExportImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_image`](crate::client::Client::export_image).
///
/// See [`crate::client::fluent_builders::ExportImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportImage {
    _private: (),
}
impl ExportImage {
    /// Creates a new builder-style object to manufacture [`ExportImageInput`](crate::input::ExportImageInput)
    pub fn builder() -> crate::input::export_image_input::Builder {
        crate::input::export_image_input::Builder::default()
    }
    /// Creates a new `ExportImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportImage {
    type Output =
        std::result::Result<crate::output::ExportImageOutput, crate::error::ExportImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_image_error(response)
        } else {
            crate::operation_deser::parse_export_image_response(response)
        }
    }
}

/// Operation shape for `ExportTransitGatewayRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_transit_gateway_routes`](crate::client::Client::export_transit_gateway_routes).
///
/// See [`crate::client::fluent_builders::ExportTransitGatewayRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportTransitGatewayRoutes {
    _private: (),
}
impl ExportTransitGatewayRoutes {
    /// Creates a new builder-style object to manufacture [`ExportTransitGatewayRoutesInput`](crate::input::ExportTransitGatewayRoutesInput)
    pub fn builder() -> crate::input::export_transit_gateway_routes_input::Builder {
        crate::input::export_transit_gateway_routes_input::Builder::default()
    }
    /// Creates a new `ExportTransitGatewayRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportTransitGatewayRoutes {
    type Output = std::result::Result<
        crate::output::ExportTransitGatewayRoutesOutput,
        crate::error::ExportTransitGatewayRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_transit_gateway_routes_error(response)
        } else {
            crate::operation_deser::parse_export_transit_gateway_routes_response(response)
        }
    }
}

/// Operation shape for `GetAssociatedEnclaveCertificateIamRoles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_associated_enclave_certificate_iam_roles`](crate::client::Client::get_associated_enclave_certificate_iam_roles).
///
/// See [`crate::client::fluent_builders::GetAssociatedEnclaveCertificateIamRoles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssociatedEnclaveCertificateIamRoles {
    _private: (),
}
impl GetAssociatedEnclaveCertificateIamRoles {
    /// Creates a new builder-style object to manufacture [`GetAssociatedEnclaveCertificateIamRolesInput`](crate::input::GetAssociatedEnclaveCertificateIamRolesInput)
    pub fn builder() -> crate::input::get_associated_enclave_certificate_iam_roles_input::Builder {
        crate::input::get_associated_enclave_certificate_iam_roles_input::Builder::default()
    }
    /// Creates a new `GetAssociatedEnclaveCertificateIamRoles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssociatedEnclaveCertificateIamRoles {
    type Output = std::result::Result<
        crate::output::GetAssociatedEnclaveCertificateIamRolesOutput,
        crate::error::GetAssociatedEnclaveCertificateIamRolesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_associated_enclave_certificate_iam_roles_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_associated_enclave_certificate_iam_roles_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAssociatedIpv6PoolCidrs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_associated_ipv6_pool_cidrs`](crate::client::Client::get_associated_ipv6_pool_cidrs).
///
/// See [`crate::client::fluent_builders::GetAssociatedIpv6PoolCidrs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssociatedIpv6PoolCidrs {
    _private: (),
}
impl GetAssociatedIpv6PoolCidrs {
    /// Creates a new builder-style object to manufacture [`GetAssociatedIpv6PoolCidrsInput`](crate::input::GetAssociatedIpv6PoolCidrsInput)
    pub fn builder() -> crate::input::get_associated_ipv6_pool_cidrs_input::Builder {
        crate::input::get_associated_ipv6_pool_cidrs_input::Builder::default()
    }
    /// Creates a new `GetAssociatedIpv6PoolCidrs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssociatedIpv6PoolCidrs {
    type Output = std::result::Result<
        crate::output::GetAssociatedIpv6PoolCidrsOutput,
        crate::error::GetAssociatedIpv6PoolCidrsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_associated_ipv6_pool_cidrs_error(response)
        } else {
            crate::operation_deser::parse_get_associated_ipv6_pool_cidrs_response(response)
        }
    }
}

/// Operation shape for `GetCapacityReservationUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_capacity_reservation_usage`](crate::client::Client::get_capacity_reservation_usage).
///
/// See [`crate::client::fluent_builders::GetCapacityReservationUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCapacityReservationUsage {
    _private: (),
}
impl GetCapacityReservationUsage {
    /// Creates a new builder-style object to manufacture [`GetCapacityReservationUsageInput`](crate::input::GetCapacityReservationUsageInput)
    pub fn builder() -> crate::input::get_capacity_reservation_usage_input::Builder {
        crate::input::get_capacity_reservation_usage_input::Builder::default()
    }
    /// Creates a new `GetCapacityReservationUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCapacityReservationUsage {
    type Output = std::result::Result<
        crate::output::GetCapacityReservationUsageOutput,
        crate::error::GetCapacityReservationUsageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_capacity_reservation_usage_error(response)
        } else {
            crate::operation_deser::parse_get_capacity_reservation_usage_response(response)
        }
    }
}

/// Operation shape for `GetCoipPoolUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_coip_pool_usage`](crate::client::Client::get_coip_pool_usage).
///
/// See [`crate::client::fluent_builders::GetCoipPoolUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoipPoolUsage {
    _private: (),
}
impl GetCoipPoolUsage {
    /// Creates a new builder-style object to manufacture [`GetCoipPoolUsageInput`](crate::input::GetCoipPoolUsageInput)
    pub fn builder() -> crate::input::get_coip_pool_usage_input::Builder {
        crate::input::get_coip_pool_usage_input::Builder::default()
    }
    /// Creates a new `GetCoipPoolUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoipPoolUsage {
    type Output = std::result::Result<
        crate::output::GetCoipPoolUsageOutput,
        crate::error::GetCoipPoolUsageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_coip_pool_usage_error(response)
        } else {
            crate::operation_deser::parse_get_coip_pool_usage_response(response)
        }
    }
}

/// Operation shape for `GetConsoleOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_console_output`](crate::client::Client::get_console_output).
///
/// See [`crate::client::fluent_builders::GetConsoleOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConsoleOutput {
    _private: (),
}
impl GetConsoleOutput {
    /// Creates a new builder-style object to manufacture [`GetConsoleOutputInput`](crate::input::GetConsoleOutputInput)
    pub fn builder() -> crate::input::get_console_output_input::Builder {
        crate::input::get_console_output_input::Builder::default()
    }
    /// Creates a new `GetConsoleOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConsoleOutput {
    type Output = std::result::Result<
        crate::output::GetConsoleOutputOutput,
        crate::error::GetConsoleOutputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_console_output_error(response)
        } else {
            crate::operation_deser::parse_get_console_output_response(response)
        }
    }
}

/// Operation shape for `GetConsoleScreenshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_console_screenshot`](crate::client::Client::get_console_screenshot).
///
/// See [`crate::client::fluent_builders::GetConsoleScreenshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConsoleScreenshot {
    _private: (),
}
impl GetConsoleScreenshot {
    /// Creates a new builder-style object to manufacture [`GetConsoleScreenshotInput`](crate::input::GetConsoleScreenshotInput)
    pub fn builder() -> crate::input::get_console_screenshot_input::Builder {
        crate::input::get_console_screenshot_input::Builder::default()
    }
    /// Creates a new `GetConsoleScreenshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConsoleScreenshot {
    type Output = std::result::Result<
        crate::output::GetConsoleScreenshotOutput,
        crate::error::GetConsoleScreenshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_console_screenshot_error(response)
        } else {
            crate::operation_deser::parse_get_console_screenshot_response(response)
        }
    }
}

/// Operation shape for `GetDefaultCreditSpecification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_default_credit_specification`](crate::client::Client::get_default_credit_specification).
///
/// See [`crate::client::fluent_builders::GetDefaultCreditSpecification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDefaultCreditSpecification {
    _private: (),
}
impl GetDefaultCreditSpecification {
    /// Creates a new builder-style object to manufacture [`GetDefaultCreditSpecificationInput`](crate::input::GetDefaultCreditSpecificationInput)
    pub fn builder() -> crate::input::get_default_credit_specification_input::Builder {
        crate::input::get_default_credit_specification_input::Builder::default()
    }
    /// Creates a new `GetDefaultCreditSpecification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDefaultCreditSpecification {
    type Output = std::result::Result<
        crate::output::GetDefaultCreditSpecificationOutput,
        crate::error::GetDefaultCreditSpecificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_default_credit_specification_error(response)
        } else {
            crate::operation_deser::parse_get_default_credit_specification_response(response)
        }
    }
}

/// Operation shape for `GetEbsDefaultKmsKeyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ebs_default_kms_key_id`](crate::client::Client::get_ebs_default_kms_key_id).
///
/// See [`crate::client::fluent_builders::GetEbsDefaultKmsKeyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEbsDefaultKmsKeyId {
    _private: (),
}
impl GetEbsDefaultKmsKeyId {
    /// Creates a new builder-style object to manufacture [`GetEbsDefaultKmsKeyIdInput`](crate::input::GetEbsDefaultKmsKeyIdInput)
    pub fn builder() -> crate::input::get_ebs_default_kms_key_id_input::Builder {
        crate::input::get_ebs_default_kms_key_id_input::Builder::default()
    }
    /// Creates a new `GetEbsDefaultKmsKeyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEbsDefaultKmsKeyId {
    type Output = std::result::Result<
        crate::output::GetEbsDefaultKmsKeyIdOutput,
        crate::error::GetEbsDefaultKmsKeyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ebs_default_kms_key_id_error(response)
        } else {
            crate::operation_deser::parse_get_ebs_default_kms_key_id_response(response)
        }
    }
}

/// Operation shape for `GetEbsEncryptionByDefault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ebs_encryption_by_default`](crate::client::Client::get_ebs_encryption_by_default).
///
/// See [`crate::client::fluent_builders::GetEbsEncryptionByDefault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEbsEncryptionByDefault {
    _private: (),
}
impl GetEbsEncryptionByDefault {
    /// Creates a new builder-style object to manufacture [`GetEbsEncryptionByDefaultInput`](crate::input::GetEbsEncryptionByDefaultInput)
    pub fn builder() -> crate::input::get_ebs_encryption_by_default_input::Builder {
        crate::input::get_ebs_encryption_by_default_input::Builder::default()
    }
    /// Creates a new `GetEbsEncryptionByDefault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEbsEncryptionByDefault {
    type Output = std::result::Result<
        crate::output::GetEbsEncryptionByDefaultOutput,
        crate::error::GetEbsEncryptionByDefaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ebs_encryption_by_default_error(response)
        } else {
            crate::operation_deser::parse_get_ebs_encryption_by_default_response(response)
        }
    }
}

/// Operation shape for `GetFlowLogsIntegrationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_flow_logs_integration_template`](crate::client::Client::get_flow_logs_integration_template).
///
/// See [`crate::client::fluent_builders::GetFlowLogsIntegrationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFlowLogsIntegrationTemplate {
    _private: (),
}
impl GetFlowLogsIntegrationTemplate {
    /// Creates a new builder-style object to manufacture [`GetFlowLogsIntegrationTemplateInput`](crate::input::GetFlowLogsIntegrationTemplateInput)
    pub fn builder() -> crate::input::get_flow_logs_integration_template_input::Builder {
        crate::input::get_flow_logs_integration_template_input::Builder::default()
    }
    /// Creates a new `GetFlowLogsIntegrationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFlowLogsIntegrationTemplate {
    type Output = std::result::Result<
        crate::output::GetFlowLogsIntegrationTemplateOutput,
        crate::error::GetFlowLogsIntegrationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_flow_logs_integration_template_error(response)
        } else {
            crate::operation_deser::parse_get_flow_logs_integration_template_response(response)
        }
    }
}

/// Operation shape for `GetGroupsForCapacityReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_groups_for_capacity_reservation`](crate::client::Client::get_groups_for_capacity_reservation).
///
/// See [`crate::client::fluent_builders::GetGroupsForCapacityReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroupsForCapacityReservation {
    _private: (),
}
impl GetGroupsForCapacityReservation {
    /// Creates a new builder-style object to manufacture [`GetGroupsForCapacityReservationInput`](crate::input::GetGroupsForCapacityReservationInput)
    pub fn builder() -> crate::input::get_groups_for_capacity_reservation_input::Builder {
        crate::input::get_groups_for_capacity_reservation_input::Builder::default()
    }
    /// Creates a new `GetGroupsForCapacityReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroupsForCapacityReservation {
    type Output = std::result::Result<
        crate::output::GetGroupsForCapacityReservationOutput,
        crate::error::GetGroupsForCapacityReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_groups_for_capacity_reservation_error(response)
        } else {
            crate::operation_deser::parse_get_groups_for_capacity_reservation_response(response)
        }
    }
}

/// Operation shape for `GetHostReservationPurchasePreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_host_reservation_purchase_preview`](crate::client::Client::get_host_reservation_purchase_preview).
///
/// See [`crate::client::fluent_builders::GetHostReservationPurchasePreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostReservationPurchasePreview {
    _private: (),
}
impl GetHostReservationPurchasePreview {
    /// Creates a new builder-style object to manufacture [`GetHostReservationPurchasePreviewInput`](crate::input::GetHostReservationPurchasePreviewInput)
    pub fn builder() -> crate::input::get_host_reservation_purchase_preview_input::Builder {
        crate::input::get_host_reservation_purchase_preview_input::Builder::default()
    }
    /// Creates a new `GetHostReservationPurchasePreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostReservationPurchasePreview {
    type Output = std::result::Result<
        crate::output::GetHostReservationPurchasePreviewOutput,
        crate::error::GetHostReservationPurchasePreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_host_reservation_purchase_preview_error(response)
        } else {
            crate::operation_deser::parse_get_host_reservation_purchase_preview_response(response)
        }
    }
}

/// Operation shape for `GetInstanceTypesFromInstanceRequirements`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_types_from_instance_requirements`](crate::client::Client::get_instance_types_from_instance_requirements).
///
/// See [`crate::client::fluent_builders::GetInstanceTypesFromInstanceRequirements`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceTypesFromInstanceRequirements {
    _private: (),
}
impl GetInstanceTypesFromInstanceRequirements {
    /// Creates a new builder-style object to manufacture [`GetInstanceTypesFromInstanceRequirementsInput`](crate::input::GetInstanceTypesFromInstanceRequirementsInput)
    pub fn builder() -> crate::input::get_instance_types_from_instance_requirements_input::Builder {
        crate::input::get_instance_types_from_instance_requirements_input::Builder::default()
    }
    /// Creates a new `GetInstanceTypesFromInstanceRequirements` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceTypesFromInstanceRequirements {
    type Output = std::result::Result<
        crate::output::GetInstanceTypesFromInstanceRequirementsOutput,
        crate::error::GetInstanceTypesFromInstanceRequirementsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_types_from_instance_requirements_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_instance_types_from_instance_requirements_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetIpamAddressHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ipam_address_history`](crate::client::Client::get_ipam_address_history).
///
/// See [`crate::client::fluent_builders::GetIpamAddressHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIpamAddressHistory {
    _private: (),
}
impl GetIpamAddressHistory {
    /// Creates a new builder-style object to manufacture [`GetIpamAddressHistoryInput`](crate::input::GetIpamAddressHistoryInput)
    pub fn builder() -> crate::input::get_ipam_address_history_input::Builder {
        crate::input::get_ipam_address_history_input::Builder::default()
    }
    /// Creates a new `GetIpamAddressHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIpamAddressHistory {
    type Output = std::result::Result<
        crate::output::GetIpamAddressHistoryOutput,
        crate::error::GetIpamAddressHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ipam_address_history_error(response)
        } else {
            crate::operation_deser::parse_get_ipam_address_history_response(response)
        }
    }
}

/// Operation shape for `GetIpamPoolAllocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ipam_pool_allocations`](crate::client::Client::get_ipam_pool_allocations).
///
/// See [`crate::client::fluent_builders::GetIpamPoolAllocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIpamPoolAllocations {
    _private: (),
}
impl GetIpamPoolAllocations {
    /// Creates a new builder-style object to manufacture [`GetIpamPoolAllocationsInput`](crate::input::GetIpamPoolAllocationsInput)
    pub fn builder() -> crate::input::get_ipam_pool_allocations_input::Builder {
        crate::input::get_ipam_pool_allocations_input::Builder::default()
    }
    /// Creates a new `GetIpamPoolAllocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIpamPoolAllocations {
    type Output = std::result::Result<
        crate::output::GetIpamPoolAllocationsOutput,
        crate::error::GetIpamPoolAllocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ipam_pool_allocations_error(response)
        } else {
            crate::operation_deser::parse_get_ipam_pool_allocations_response(response)
        }
    }
}

/// Operation shape for `GetIpamPoolCidrs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ipam_pool_cidrs`](crate::client::Client::get_ipam_pool_cidrs).
///
/// See [`crate::client::fluent_builders::GetIpamPoolCidrs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIpamPoolCidrs {
    _private: (),
}
impl GetIpamPoolCidrs {
    /// Creates a new builder-style object to manufacture [`GetIpamPoolCidrsInput`](crate::input::GetIpamPoolCidrsInput)
    pub fn builder() -> crate::input::get_ipam_pool_cidrs_input::Builder {
        crate::input::get_ipam_pool_cidrs_input::Builder::default()
    }
    /// Creates a new `GetIpamPoolCidrs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIpamPoolCidrs {
    type Output = std::result::Result<
        crate::output::GetIpamPoolCidrsOutput,
        crate::error::GetIpamPoolCidrsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ipam_pool_cidrs_error(response)
        } else {
            crate::operation_deser::parse_get_ipam_pool_cidrs_response(response)
        }
    }
}

/// Operation shape for `GetIpamResourceCidrs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ipam_resource_cidrs`](crate::client::Client::get_ipam_resource_cidrs).
///
/// See [`crate::client::fluent_builders::GetIpamResourceCidrs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIpamResourceCidrs {
    _private: (),
}
impl GetIpamResourceCidrs {
    /// Creates a new builder-style object to manufacture [`GetIpamResourceCidrsInput`](crate::input::GetIpamResourceCidrsInput)
    pub fn builder() -> crate::input::get_ipam_resource_cidrs_input::Builder {
        crate::input::get_ipam_resource_cidrs_input::Builder::default()
    }
    /// Creates a new `GetIpamResourceCidrs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIpamResourceCidrs {
    type Output = std::result::Result<
        crate::output::GetIpamResourceCidrsOutput,
        crate::error::GetIpamResourceCidrsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ipam_resource_cidrs_error(response)
        } else {
            crate::operation_deser::parse_get_ipam_resource_cidrs_response(response)
        }
    }
}

/// Operation shape for `GetLaunchTemplateData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_launch_template_data`](crate::client::Client::get_launch_template_data).
///
/// See [`crate::client::fluent_builders::GetLaunchTemplateData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLaunchTemplateData {
    _private: (),
}
impl GetLaunchTemplateData {
    /// Creates a new builder-style object to manufacture [`GetLaunchTemplateDataInput`](crate::input::GetLaunchTemplateDataInput)
    pub fn builder() -> crate::input::get_launch_template_data_input::Builder {
        crate::input::get_launch_template_data_input::Builder::default()
    }
    /// Creates a new `GetLaunchTemplateData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLaunchTemplateData {
    type Output = std::result::Result<
        crate::output::GetLaunchTemplateDataOutput,
        crate::error::GetLaunchTemplateDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_launch_template_data_error(response)
        } else {
            crate::operation_deser::parse_get_launch_template_data_response(response)
        }
    }
}

/// Operation shape for `GetManagedPrefixListAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_managed_prefix_list_associations`](crate::client::Client::get_managed_prefix_list_associations).
///
/// See [`crate::client::fluent_builders::GetManagedPrefixListAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetManagedPrefixListAssociations {
    _private: (),
}
impl GetManagedPrefixListAssociations {
    /// Creates a new builder-style object to manufacture [`GetManagedPrefixListAssociationsInput`](crate::input::GetManagedPrefixListAssociationsInput)
    pub fn builder() -> crate::input::get_managed_prefix_list_associations_input::Builder {
        crate::input::get_managed_prefix_list_associations_input::Builder::default()
    }
    /// Creates a new `GetManagedPrefixListAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetManagedPrefixListAssociations {
    type Output = std::result::Result<
        crate::output::GetManagedPrefixListAssociationsOutput,
        crate::error::GetManagedPrefixListAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_managed_prefix_list_associations_error(response)
        } else {
            crate::operation_deser::parse_get_managed_prefix_list_associations_response(response)
        }
    }
}

/// Operation shape for `GetManagedPrefixListEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_managed_prefix_list_entries`](crate::client::Client::get_managed_prefix_list_entries).
///
/// See [`crate::client::fluent_builders::GetManagedPrefixListEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetManagedPrefixListEntries {
    _private: (),
}
impl GetManagedPrefixListEntries {
    /// Creates a new builder-style object to manufacture [`GetManagedPrefixListEntriesInput`](crate::input::GetManagedPrefixListEntriesInput)
    pub fn builder() -> crate::input::get_managed_prefix_list_entries_input::Builder {
        crate::input::get_managed_prefix_list_entries_input::Builder::default()
    }
    /// Creates a new `GetManagedPrefixListEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetManagedPrefixListEntries {
    type Output = std::result::Result<
        crate::output::GetManagedPrefixListEntriesOutput,
        crate::error::GetManagedPrefixListEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_managed_prefix_list_entries_error(response)
        } else {
            crate::operation_deser::parse_get_managed_prefix_list_entries_response(response)
        }
    }
}

/// Operation shape for `GetNetworkInsightsAccessScopeAnalysisFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_insights_access_scope_analysis_findings`](crate::client::Client::get_network_insights_access_scope_analysis_findings).
///
/// See [`crate::client::fluent_builders::GetNetworkInsightsAccessScopeAnalysisFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkInsightsAccessScopeAnalysisFindings {
    _private: (),
}
impl GetNetworkInsightsAccessScopeAnalysisFindings {
    /// Creates a new builder-style object to manufacture [`GetNetworkInsightsAccessScopeAnalysisFindingsInput`](crate::input::GetNetworkInsightsAccessScopeAnalysisFindingsInput)
    pub fn builder(
    ) -> crate::input::get_network_insights_access_scope_analysis_findings_input::Builder {
        crate::input::get_network_insights_access_scope_analysis_findings_input::Builder::default()
    }
    /// Creates a new `GetNetworkInsightsAccessScopeAnalysisFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetNetworkInsightsAccessScopeAnalysisFindings
{
    type Output = std::result::Result<
        crate::output::GetNetworkInsightsAccessScopeAnalysisFindingsOutput,
        crate::error::GetNetworkInsightsAccessScopeAnalysisFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_insights_access_scope_analysis_findings_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_network_insights_access_scope_analysis_findings_response(response)
        }
    }
}

/// Operation shape for `GetNetworkInsightsAccessScopeContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network_insights_access_scope_content`](crate::client::Client::get_network_insights_access_scope_content).
///
/// See [`crate::client::fluent_builders::GetNetworkInsightsAccessScopeContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetworkInsightsAccessScopeContent {
    _private: (),
}
impl GetNetworkInsightsAccessScopeContent {
    /// Creates a new builder-style object to manufacture [`GetNetworkInsightsAccessScopeContentInput`](crate::input::GetNetworkInsightsAccessScopeContentInput)
    pub fn builder() -> crate::input::get_network_insights_access_scope_content_input::Builder {
        crate::input::get_network_insights_access_scope_content_input::Builder::default()
    }
    /// Creates a new `GetNetworkInsightsAccessScopeContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetworkInsightsAccessScopeContent {
    type Output = std::result::Result<
        crate::output::GetNetworkInsightsAccessScopeContentOutput,
        crate::error::GetNetworkInsightsAccessScopeContentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_insights_access_scope_content_error(response)
        } else {
            crate::operation_deser::parse_get_network_insights_access_scope_content_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetPasswordData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_password_data`](crate::client::Client::get_password_data).
///
/// See [`crate::client::fluent_builders::GetPasswordData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPasswordData {
    _private: (),
}
impl GetPasswordData {
    /// Creates a new builder-style object to manufacture [`GetPasswordDataInput`](crate::input::GetPasswordDataInput)
    pub fn builder() -> crate::input::get_password_data_input::Builder {
        crate::input::get_password_data_input::Builder::default()
    }
    /// Creates a new `GetPasswordData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPasswordData {
    type Output = std::result::Result<
        crate::output::GetPasswordDataOutput,
        crate::error::GetPasswordDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_password_data_error(response)
        } else {
            crate::operation_deser::parse_get_password_data_response(response)
        }
    }
}

/// Operation shape for `GetReservedInstancesExchangeQuote`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reserved_instances_exchange_quote`](crate::client::Client::get_reserved_instances_exchange_quote).
///
/// See [`crate::client::fluent_builders::GetReservedInstancesExchangeQuote`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservedInstancesExchangeQuote {
    _private: (),
}
impl GetReservedInstancesExchangeQuote {
    /// Creates a new builder-style object to manufacture [`GetReservedInstancesExchangeQuoteInput`](crate::input::GetReservedInstancesExchangeQuoteInput)
    pub fn builder() -> crate::input::get_reserved_instances_exchange_quote_input::Builder {
        crate::input::get_reserved_instances_exchange_quote_input::Builder::default()
    }
    /// Creates a new `GetReservedInstancesExchangeQuote` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReservedInstancesExchangeQuote {
    type Output = std::result::Result<
        crate::output::GetReservedInstancesExchangeQuoteOutput,
        crate::error::GetReservedInstancesExchangeQuoteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reserved_instances_exchange_quote_error(response)
        } else {
            crate::operation_deser::parse_get_reserved_instances_exchange_quote_response(response)
        }
    }
}

/// Operation shape for `GetSerialConsoleAccessStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_serial_console_access_status`](crate::client::Client::get_serial_console_access_status).
///
/// See [`crate::client::fluent_builders::GetSerialConsoleAccessStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSerialConsoleAccessStatus {
    _private: (),
}
impl GetSerialConsoleAccessStatus {
    /// Creates a new builder-style object to manufacture [`GetSerialConsoleAccessStatusInput`](crate::input::GetSerialConsoleAccessStatusInput)
    pub fn builder() -> crate::input::get_serial_console_access_status_input::Builder {
        crate::input::get_serial_console_access_status_input::Builder::default()
    }
    /// Creates a new `GetSerialConsoleAccessStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSerialConsoleAccessStatus {
    type Output = std::result::Result<
        crate::output::GetSerialConsoleAccessStatusOutput,
        crate::error::GetSerialConsoleAccessStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_serial_console_access_status_error(response)
        } else {
            crate::operation_deser::parse_get_serial_console_access_status_response(response)
        }
    }
}

/// Operation shape for `GetSpotPlacementScores`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_spot_placement_scores`](crate::client::Client::get_spot_placement_scores).
///
/// See [`crate::client::fluent_builders::GetSpotPlacementScores`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSpotPlacementScores {
    _private: (),
}
impl GetSpotPlacementScores {
    /// Creates a new builder-style object to manufacture [`GetSpotPlacementScoresInput`](crate::input::GetSpotPlacementScoresInput)
    pub fn builder() -> crate::input::get_spot_placement_scores_input::Builder {
        crate::input::get_spot_placement_scores_input::Builder::default()
    }
    /// Creates a new `GetSpotPlacementScores` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSpotPlacementScores {
    type Output = std::result::Result<
        crate::output::GetSpotPlacementScoresOutput,
        crate::error::GetSpotPlacementScoresError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_spot_placement_scores_error(response)
        } else {
            crate::operation_deser::parse_get_spot_placement_scores_response(response)
        }
    }
}

/// Operation shape for `GetSubnetCidrReservations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_subnet_cidr_reservations`](crate::client::Client::get_subnet_cidr_reservations).
///
/// See [`crate::client::fluent_builders::GetSubnetCidrReservations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSubnetCidrReservations {
    _private: (),
}
impl GetSubnetCidrReservations {
    /// Creates a new builder-style object to manufacture [`GetSubnetCidrReservationsInput`](crate::input::GetSubnetCidrReservationsInput)
    pub fn builder() -> crate::input::get_subnet_cidr_reservations_input::Builder {
        crate::input::get_subnet_cidr_reservations_input::Builder::default()
    }
    /// Creates a new `GetSubnetCidrReservations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSubnetCidrReservations {
    type Output = std::result::Result<
        crate::output::GetSubnetCidrReservationsOutput,
        crate::error::GetSubnetCidrReservationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_subnet_cidr_reservations_error(response)
        } else {
            crate::operation_deser::parse_get_subnet_cidr_reservations_response(response)
        }
    }
}

/// Operation shape for `GetTransitGatewayAttachmentPropagations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_attachment_propagations`](crate::client::Client::get_transit_gateway_attachment_propagations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayAttachmentPropagations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayAttachmentPropagations {
    _private: (),
}
impl GetTransitGatewayAttachmentPropagations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayAttachmentPropagationsInput`](crate::input::GetTransitGatewayAttachmentPropagationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_attachment_propagations_input::Builder {
        crate::input::get_transit_gateway_attachment_propagations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayAttachmentPropagations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayAttachmentPropagations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayAttachmentPropagationsOutput,
        crate::error::GetTransitGatewayAttachmentPropagationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_attachment_propagations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_attachment_propagations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayMulticastDomainAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_multicast_domain_associations`](crate::client::Client::get_transit_gateway_multicast_domain_associations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayMulticastDomainAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayMulticastDomainAssociations {
    _private: (),
}
impl GetTransitGatewayMulticastDomainAssociations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayMulticastDomainAssociationsInput`](crate::input::GetTransitGatewayMulticastDomainAssociationsInput)
    pub fn builder(
    ) -> crate::input::get_transit_gateway_multicast_domain_associations_input::Builder {
        crate::input::get_transit_gateway_multicast_domain_associations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayMulticastDomainAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetTransitGatewayMulticastDomainAssociations
{
    type Output = std::result::Result<
        crate::output::GetTransitGatewayMulticastDomainAssociationsOutput,
        crate::error::GetTransitGatewayMulticastDomainAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_multicast_domain_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_multicast_domain_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayPrefixListReferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_prefix_list_references`](crate::client::Client::get_transit_gateway_prefix_list_references).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayPrefixListReferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayPrefixListReferences {
    _private: (),
}
impl GetTransitGatewayPrefixListReferences {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayPrefixListReferencesInput`](crate::input::GetTransitGatewayPrefixListReferencesInput)
    pub fn builder() -> crate::input::get_transit_gateway_prefix_list_references_input::Builder {
        crate::input::get_transit_gateway_prefix_list_references_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayPrefixListReferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayPrefixListReferences {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayPrefixListReferencesOutput,
        crate::error::GetTransitGatewayPrefixListReferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_prefix_list_references_error(response)
        } else {
            crate::operation_deser::parse_get_transit_gateway_prefix_list_references_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayRouteTableAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_route_table_associations`](crate::client::Client::get_transit_gateway_route_table_associations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayRouteTableAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayRouteTableAssociations {
    _private: (),
}
impl GetTransitGatewayRouteTableAssociations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRouteTableAssociationsInput`](crate::input::GetTransitGatewayRouteTableAssociationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_route_table_associations_input::Builder {
        crate::input::get_transit_gateway_route_table_associations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayRouteTableAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayRouteTableAssociations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayRouteTableAssociationsOutput,
        crate::error::GetTransitGatewayRouteTableAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_route_table_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_route_table_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetTransitGatewayRouteTablePropagations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transit_gateway_route_table_propagations`](crate::client::Client::get_transit_gateway_route_table_propagations).
///
/// See [`crate::client::fluent_builders::GetTransitGatewayRouteTablePropagations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTransitGatewayRouteTablePropagations {
    _private: (),
}
impl GetTransitGatewayRouteTablePropagations {
    /// Creates a new builder-style object to manufacture [`GetTransitGatewayRouteTablePropagationsInput`](crate::input::GetTransitGatewayRouteTablePropagationsInput)
    pub fn builder() -> crate::input::get_transit_gateway_route_table_propagations_input::Builder {
        crate::input::get_transit_gateway_route_table_propagations_input::Builder::default()
    }
    /// Creates a new `GetTransitGatewayRouteTablePropagations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTransitGatewayRouteTablePropagations {
    type Output = std::result::Result<
        crate::output::GetTransitGatewayRouteTablePropagationsOutput,
        crate::error::GetTransitGatewayRouteTablePropagationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transit_gateway_route_table_propagations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_transit_gateway_route_table_propagations_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetVpnConnectionDeviceSampleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpn_connection_device_sample_configuration`](crate::client::Client::get_vpn_connection_device_sample_configuration).
///
/// See [`crate::client::fluent_builders::GetVpnConnectionDeviceSampleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpnConnectionDeviceSampleConfiguration {
    _private: (),
}
impl GetVpnConnectionDeviceSampleConfiguration {
    /// Creates a new builder-style object to manufacture [`GetVpnConnectionDeviceSampleConfigurationInput`](crate::input::GetVpnConnectionDeviceSampleConfigurationInput)
    pub fn builder() -> crate::input::get_vpn_connection_device_sample_configuration_input::Builder
    {
        crate::input::get_vpn_connection_device_sample_configuration_input::Builder::default()
    }
    /// Creates a new `GetVpnConnectionDeviceSampleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpnConnectionDeviceSampleConfiguration {
    type Output = std::result::Result<
        crate::output::GetVpnConnectionDeviceSampleConfigurationOutput,
        crate::error::GetVpnConnectionDeviceSampleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpn_connection_device_sample_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_vpn_connection_device_sample_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetVpnConnectionDeviceTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_vpn_connection_device_types`](crate::client::Client::get_vpn_connection_device_types).
///
/// See [`crate::client::fluent_builders::GetVpnConnectionDeviceTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetVpnConnectionDeviceTypes {
    _private: (),
}
impl GetVpnConnectionDeviceTypes {
    /// Creates a new builder-style object to manufacture [`GetVpnConnectionDeviceTypesInput`](crate::input::GetVpnConnectionDeviceTypesInput)
    pub fn builder() -> crate::input::get_vpn_connection_device_types_input::Builder {
        crate::input::get_vpn_connection_device_types_input::Builder::default()
    }
    /// Creates a new `GetVpnConnectionDeviceTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetVpnConnectionDeviceTypes {
    type Output = std::result::Result<
        crate::output::GetVpnConnectionDeviceTypesOutput,
        crate::error::GetVpnConnectionDeviceTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_vpn_connection_device_types_error(response)
        } else {
            crate::operation_deser::parse_get_vpn_connection_device_types_response(response)
        }
    }
}

/// Operation shape for `ImportClientVpnClientCertificateRevocationList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_client_vpn_client_certificate_revocation_list`](crate::client::Client::import_client_vpn_client_certificate_revocation_list).
///
/// See [`crate::client::fluent_builders::ImportClientVpnClientCertificateRevocationList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportClientVpnClientCertificateRevocationList {
    _private: (),
}
impl ImportClientVpnClientCertificateRevocationList {
    /// Creates a new builder-style object to manufacture [`ImportClientVpnClientCertificateRevocationListInput`](crate::input::ImportClientVpnClientCertificateRevocationListInput)
    pub fn builder(
    ) -> crate::input::import_client_vpn_client_certificate_revocation_list_input::Builder {
        crate::input::import_client_vpn_client_certificate_revocation_list_input::Builder::default()
    }
    /// Creates a new `ImportClientVpnClientCertificateRevocationList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ImportClientVpnClientCertificateRevocationList
{
    type Output = std::result::Result<
        crate::output::ImportClientVpnClientCertificateRevocationListOutput,
        crate::error::ImportClientVpnClientCertificateRevocationListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_client_vpn_client_certificate_revocation_list_error(
                response,
            )
        } else {
            crate::operation_deser::parse_import_client_vpn_client_certificate_revocation_list_response(response)
        }
    }
}

/// Operation shape for `ImportImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_image`](crate::client::Client::import_image).
///
/// See [`crate::client::fluent_builders::ImportImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportImage {
    _private: (),
}
impl ImportImage {
    /// Creates a new builder-style object to manufacture [`ImportImageInput`](crate::input::ImportImageInput)
    pub fn builder() -> crate::input::import_image_input::Builder {
        crate::input::import_image_input::Builder::default()
    }
    /// Creates a new `ImportImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportImage {
    type Output =
        std::result::Result<crate::output::ImportImageOutput, crate::error::ImportImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_image_error(response)
        } else {
            crate::operation_deser::parse_import_image_response(response)
        }
    }
}

/// Operation shape for `ImportInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_instance`](crate::client::Client::import_instance).
///
/// See [`crate::client::fluent_builders::ImportInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportInstance {
    _private: (),
}
impl ImportInstance {
    /// Creates a new builder-style object to manufacture [`ImportInstanceInput`](crate::input::ImportInstanceInput)
    pub fn builder() -> crate::input::import_instance_input::Builder {
        crate::input::import_instance_input::Builder::default()
    }
    /// Creates a new `ImportInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportInstance {
    type Output =
        std::result::Result<crate::output::ImportInstanceOutput, crate::error::ImportInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_instance_error(response)
        } else {
            crate::operation_deser::parse_import_instance_response(response)
        }
    }
}

/// Operation shape for `ImportKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_key_pair`](crate::client::Client::import_key_pair).
///
/// See [`crate::client::fluent_builders::ImportKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportKeyPair {
    _private: (),
}
impl ImportKeyPair {
    /// Creates a new builder-style object to manufacture [`ImportKeyPairInput`](crate::input::ImportKeyPairInput)
    pub fn builder() -> crate::input::import_key_pair_input::Builder {
        crate::input::import_key_pair_input::Builder::default()
    }
    /// Creates a new `ImportKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportKeyPair {
    type Output =
        std::result::Result<crate::output::ImportKeyPairOutput, crate::error::ImportKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_key_pair_error(response)
        } else {
            crate::operation_deser::parse_import_key_pair_response(response)
        }
    }
}

/// Operation shape for `ImportSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_snapshot`](crate::client::Client::import_snapshot).
///
/// See [`crate::client::fluent_builders::ImportSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportSnapshot {
    _private: (),
}
impl ImportSnapshot {
    /// Creates a new builder-style object to manufacture [`ImportSnapshotInput`](crate::input::ImportSnapshotInput)
    pub fn builder() -> crate::input::import_snapshot_input::Builder {
        crate::input::import_snapshot_input::Builder::default()
    }
    /// Creates a new `ImportSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportSnapshot {
    type Output =
        std::result::Result<crate::output::ImportSnapshotOutput, crate::error::ImportSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_snapshot_error(response)
        } else {
            crate::operation_deser::parse_import_snapshot_response(response)
        }
    }
}

/// Operation shape for `ImportVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_volume`](crate::client::Client::import_volume).
///
/// See [`crate::client::fluent_builders::ImportVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportVolume {
    _private: (),
}
impl ImportVolume {
    /// Creates a new builder-style object to manufacture [`ImportVolumeInput`](crate::input::ImportVolumeInput)
    pub fn builder() -> crate::input::import_volume_input::Builder {
        crate::input::import_volume_input::Builder::default()
    }
    /// Creates a new `ImportVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportVolume {
    type Output =
        std::result::Result<crate::output::ImportVolumeOutput, crate::error::ImportVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_volume_error(response)
        } else {
            crate::operation_deser::parse_import_volume_response(response)
        }
    }
}

/// Operation shape for `ListSnapshotsInRecycleBin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_snapshots_in_recycle_bin`](crate::client::Client::list_snapshots_in_recycle_bin).
///
/// See [`crate::client::fluent_builders::ListSnapshotsInRecycleBin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSnapshotsInRecycleBin {
    _private: (),
}
impl ListSnapshotsInRecycleBin {
    /// Creates a new builder-style object to manufacture [`ListSnapshotsInRecycleBinInput`](crate::input::ListSnapshotsInRecycleBinInput)
    pub fn builder() -> crate::input::list_snapshots_in_recycle_bin_input::Builder {
        crate::input::list_snapshots_in_recycle_bin_input::Builder::default()
    }
    /// Creates a new `ListSnapshotsInRecycleBin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSnapshotsInRecycleBin {
    type Output = std::result::Result<
        crate::output::ListSnapshotsInRecycleBinOutput,
        crate::error::ListSnapshotsInRecycleBinError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_snapshots_in_recycle_bin_error(response)
        } else {
            crate::operation_deser::parse_list_snapshots_in_recycle_bin_response(response)
        }
    }
}

/// Operation shape for `ModifyAddressAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_address_attribute`](crate::client::Client::modify_address_attribute).
///
/// See [`crate::client::fluent_builders::ModifyAddressAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyAddressAttribute {
    _private: (),
}
impl ModifyAddressAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyAddressAttributeInput`](crate::input::ModifyAddressAttributeInput)
    pub fn builder() -> crate::input::modify_address_attribute_input::Builder {
        crate::input::modify_address_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyAddressAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyAddressAttribute {
    type Output = std::result::Result<
        crate::output::ModifyAddressAttributeOutput,
        crate::error::ModifyAddressAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_address_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_address_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyAvailabilityZoneGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_availability_zone_group`](crate::client::Client::modify_availability_zone_group).
///
/// See [`crate::client::fluent_builders::ModifyAvailabilityZoneGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyAvailabilityZoneGroup {
    _private: (),
}
impl ModifyAvailabilityZoneGroup {
    /// Creates a new builder-style object to manufacture [`ModifyAvailabilityZoneGroupInput`](crate::input::ModifyAvailabilityZoneGroupInput)
    pub fn builder() -> crate::input::modify_availability_zone_group_input::Builder {
        crate::input::modify_availability_zone_group_input::Builder::default()
    }
    /// Creates a new `ModifyAvailabilityZoneGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyAvailabilityZoneGroup {
    type Output = std::result::Result<
        crate::output::ModifyAvailabilityZoneGroupOutput,
        crate::error::ModifyAvailabilityZoneGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_availability_zone_group_error(response)
        } else {
            crate::operation_deser::parse_modify_availability_zone_group_response(response)
        }
    }
}

/// Operation shape for `ModifyCapacityReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_capacity_reservation`](crate::client::Client::modify_capacity_reservation).
///
/// See [`crate::client::fluent_builders::ModifyCapacityReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCapacityReservation {
    _private: (),
}
impl ModifyCapacityReservation {
    /// Creates a new builder-style object to manufacture [`ModifyCapacityReservationInput`](crate::input::ModifyCapacityReservationInput)
    pub fn builder() -> crate::input::modify_capacity_reservation_input::Builder {
        crate::input::modify_capacity_reservation_input::Builder::default()
    }
    /// Creates a new `ModifyCapacityReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCapacityReservation {
    type Output = std::result::Result<
        crate::output::ModifyCapacityReservationOutput,
        crate::error::ModifyCapacityReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_capacity_reservation_error(response)
        } else {
            crate::operation_deser::parse_modify_capacity_reservation_response(response)
        }
    }
}

/// Operation shape for `ModifyCapacityReservationFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_capacity_reservation_fleet`](crate::client::Client::modify_capacity_reservation_fleet).
///
/// See [`crate::client::fluent_builders::ModifyCapacityReservationFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCapacityReservationFleet {
    _private: (),
}
impl ModifyCapacityReservationFleet {
    /// Creates a new builder-style object to manufacture [`ModifyCapacityReservationFleetInput`](crate::input::ModifyCapacityReservationFleetInput)
    pub fn builder() -> crate::input::modify_capacity_reservation_fleet_input::Builder {
        crate::input::modify_capacity_reservation_fleet_input::Builder::default()
    }
    /// Creates a new `ModifyCapacityReservationFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCapacityReservationFleet {
    type Output = std::result::Result<
        crate::output::ModifyCapacityReservationFleetOutput,
        crate::error::ModifyCapacityReservationFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_capacity_reservation_fleet_error(response)
        } else {
            crate::operation_deser::parse_modify_capacity_reservation_fleet_response(response)
        }
    }
}

/// Operation shape for `ModifyClientVpnEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_client_vpn_endpoint`](crate::client::Client::modify_client_vpn_endpoint).
///
/// See [`crate::client::fluent_builders::ModifyClientVpnEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClientVpnEndpoint {
    _private: (),
}
impl ModifyClientVpnEndpoint {
    /// Creates a new builder-style object to manufacture [`ModifyClientVpnEndpointInput`](crate::input::ModifyClientVpnEndpointInput)
    pub fn builder() -> crate::input::modify_client_vpn_endpoint_input::Builder {
        crate::input::modify_client_vpn_endpoint_input::Builder::default()
    }
    /// Creates a new `ModifyClientVpnEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClientVpnEndpoint {
    type Output = std::result::Result<
        crate::output::ModifyClientVpnEndpointOutput,
        crate::error::ModifyClientVpnEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_client_vpn_endpoint_error(response)
        } else {
            crate::operation_deser::parse_modify_client_vpn_endpoint_response(response)
        }
    }
}

/// Operation shape for `ModifyDefaultCreditSpecification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_default_credit_specification`](crate::client::Client::modify_default_credit_specification).
///
/// See [`crate::client::fluent_builders::ModifyDefaultCreditSpecification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyDefaultCreditSpecification {
    _private: (),
}
impl ModifyDefaultCreditSpecification {
    /// Creates a new builder-style object to manufacture [`ModifyDefaultCreditSpecificationInput`](crate::input::ModifyDefaultCreditSpecificationInput)
    pub fn builder() -> crate::input::modify_default_credit_specification_input::Builder {
        crate::input::modify_default_credit_specification_input::Builder::default()
    }
    /// Creates a new `ModifyDefaultCreditSpecification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyDefaultCreditSpecification {
    type Output = std::result::Result<
        crate::output::ModifyDefaultCreditSpecificationOutput,
        crate::error::ModifyDefaultCreditSpecificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_default_credit_specification_error(response)
        } else {
            crate::operation_deser::parse_modify_default_credit_specification_response(response)
        }
    }
}

/// Operation shape for `ModifyEbsDefaultKmsKeyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_ebs_default_kms_key_id`](crate::client::Client::modify_ebs_default_kms_key_id).
///
/// See [`crate::client::fluent_builders::ModifyEbsDefaultKmsKeyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEbsDefaultKmsKeyId {
    _private: (),
}
impl ModifyEbsDefaultKmsKeyId {
    /// Creates a new builder-style object to manufacture [`ModifyEbsDefaultKmsKeyIdInput`](crate::input::ModifyEbsDefaultKmsKeyIdInput)
    pub fn builder() -> crate::input::modify_ebs_default_kms_key_id_input::Builder {
        crate::input::modify_ebs_default_kms_key_id_input::Builder::default()
    }
    /// Creates a new `ModifyEbsDefaultKmsKeyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEbsDefaultKmsKeyId {
    type Output = std::result::Result<
        crate::output::ModifyEbsDefaultKmsKeyIdOutput,
        crate::error::ModifyEbsDefaultKmsKeyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_ebs_default_kms_key_id_error(response)
        } else {
            crate::operation_deser::parse_modify_ebs_default_kms_key_id_response(response)
        }
    }
}

/// Operation shape for `ModifyFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_fleet`](crate::client::Client::modify_fleet).
///
/// See [`crate::client::fluent_builders::ModifyFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyFleet {
    _private: (),
}
impl ModifyFleet {
    /// Creates a new builder-style object to manufacture [`ModifyFleetInput`](crate::input::ModifyFleetInput)
    pub fn builder() -> crate::input::modify_fleet_input::Builder {
        crate::input::modify_fleet_input::Builder::default()
    }
    /// Creates a new `ModifyFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyFleet {
    type Output =
        std::result::Result<crate::output::ModifyFleetOutput, crate::error::ModifyFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_fleet_error(response)
        } else {
            crate::operation_deser::parse_modify_fleet_response(response)
        }
    }
}

/// Operation shape for `ModifyFpgaImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_fpga_image_attribute`](crate::client::Client::modify_fpga_image_attribute).
///
/// See [`crate::client::fluent_builders::ModifyFpgaImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyFpgaImageAttribute {
    _private: (),
}
impl ModifyFpgaImageAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyFpgaImageAttributeInput`](crate::input::ModifyFpgaImageAttributeInput)
    pub fn builder() -> crate::input::modify_fpga_image_attribute_input::Builder {
        crate::input::modify_fpga_image_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyFpgaImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyFpgaImageAttribute {
    type Output = std::result::Result<
        crate::output::ModifyFpgaImageAttributeOutput,
        crate::error::ModifyFpgaImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_fpga_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_fpga_image_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyHosts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_hosts`](crate::client::Client::modify_hosts).
///
/// See [`crate::client::fluent_builders::ModifyHosts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyHosts {
    _private: (),
}
impl ModifyHosts {
    /// Creates a new builder-style object to manufacture [`ModifyHostsInput`](crate::input::ModifyHostsInput)
    pub fn builder() -> crate::input::modify_hosts_input::Builder {
        crate::input::modify_hosts_input::Builder::default()
    }
    /// Creates a new `ModifyHosts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyHosts {
    type Output =
        std::result::Result<crate::output::ModifyHostsOutput, crate::error::ModifyHostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_hosts_error(response)
        } else {
            crate::operation_deser::parse_modify_hosts_response(response)
        }
    }
}

/// Operation shape for `ModifyIdentityIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_identity_id_format`](crate::client::Client::modify_identity_id_format).
///
/// See [`crate::client::fluent_builders::ModifyIdentityIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIdentityIdFormat {
    _private: (),
}
impl ModifyIdentityIdFormat {
    /// Creates a new builder-style object to manufacture [`ModifyIdentityIdFormatInput`](crate::input::ModifyIdentityIdFormatInput)
    pub fn builder() -> crate::input::modify_identity_id_format_input::Builder {
        crate::input::modify_identity_id_format_input::Builder::default()
    }
    /// Creates a new `ModifyIdentityIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIdentityIdFormat {
    type Output = std::result::Result<
        crate::output::ModifyIdentityIdFormatOutput,
        crate::error::ModifyIdentityIdFormatError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_identity_id_format_error(response)
        } else {
            crate::operation_deser::parse_modify_identity_id_format_response(response)
        }
    }
}

/// Operation shape for `ModifyIdFormat`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_id_format`](crate::client::Client::modify_id_format).
///
/// See [`crate::client::fluent_builders::ModifyIdFormat`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIdFormat {
    _private: (),
}
impl ModifyIdFormat {
    /// Creates a new builder-style object to manufacture [`ModifyIdFormatInput`](crate::input::ModifyIdFormatInput)
    pub fn builder() -> crate::input::modify_id_format_input::Builder {
        crate::input::modify_id_format_input::Builder::default()
    }
    /// Creates a new `ModifyIdFormat` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIdFormat {
    type Output =
        std::result::Result<crate::output::ModifyIdFormatOutput, crate::error::ModifyIdFormatError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_id_format_error(response)
        } else {
            crate::operation_deser::parse_modify_id_format_response(response)
        }
    }
}

/// Operation shape for `ModifyImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_image_attribute`](crate::client::Client::modify_image_attribute).
///
/// See [`crate::client::fluent_builders::ModifyImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyImageAttribute {
    _private: (),
}
impl ModifyImageAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyImageAttributeInput`](crate::input::ModifyImageAttributeInput)
    pub fn builder() -> crate::input::modify_image_attribute_input::Builder {
        crate::input::modify_image_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyImageAttribute {
    type Output = std::result::Result<
        crate::output::ModifyImageAttributeOutput,
        crate::error::ModifyImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_image_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_attribute`](crate::client::Client::modify_instance_attribute).
///
/// See [`crate::client::fluent_builders::ModifyInstanceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceAttribute {
    _private: (),
}
impl ModifyInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceAttributeInput`](crate::input::ModifyInstanceAttributeInput)
    pub fn builder() -> crate::input::modify_instance_attribute_input::Builder {
        crate::input::modify_instance_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceAttribute {
    type Output = std::result::Result<
        crate::output::ModifyInstanceAttributeOutput,
        crate::error::ModifyInstanceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceCapacityReservationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_capacity_reservation_attributes`](crate::client::Client::modify_instance_capacity_reservation_attributes).
///
/// See [`crate::client::fluent_builders::ModifyInstanceCapacityReservationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceCapacityReservationAttributes {
    _private: (),
}
impl ModifyInstanceCapacityReservationAttributes {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceCapacityReservationAttributesInput`](crate::input::ModifyInstanceCapacityReservationAttributesInput)
    pub fn builder() -> crate::input::modify_instance_capacity_reservation_attributes_input::Builder
    {
        crate::input::modify_instance_capacity_reservation_attributes_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceCapacityReservationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ModifyInstanceCapacityReservationAttributes
{
    type Output = std::result::Result<
        crate::output::ModifyInstanceCapacityReservationAttributesOutput,
        crate::error::ModifyInstanceCapacityReservationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_capacity_reservation_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_instance_capacity_reservation_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyInstanceCreditSpecification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_credit_specification`](crate::client::Client::modify_instance_credit_specification).
///
/// See [`crate::client::fluent_builders::ModifyInstanceCreditSpecification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceCreditSpecification {
    _private: (),
}
impl ModifyInstanceCreditSpecification {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceCreditSpecificationInput`](crate::input::ModifyInstanceCreditSpecificationInput)
    pub fn builder() -> crate::input::modify_instance_credit_specification_input::Builder {
        crate::input::modify_instance_credit_specification_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceCreditSpecification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceCreditSpecification {
    type Output = std::result::Result<
        crate::output::ModifyInstanceCreditSpecificationOutput,
        crate::error::ModifyInstanceCreditSpecificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_credit_specification_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_credit_specification_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceEventStartTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_event_start_time`](crate::client::Client::modify_instance_event_start_time).
///
/// See [`crate::client::fluent_builders::ModifyInstanceEventStartTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceEventStartTime {
    _private: (),
}
impl ModifyInstanceEventStartTime {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceEventStartTimeInput`](crate::input::ModifyInstanceEventStartTimeInput)
    pub fn builder() -> crate::input::modify_instance_event_start_time_input::Builder {
        crate::input::modify_instance_event_start_time_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceEventStartTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceEventStartTime {
    type Output = std::result::Result<
        crate::output::ModifyInstanceEventStartTimeOutput,
        crate::error::ModifyInstanceEventStartTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_event_start_time_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_event_start_time_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceEventWindow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_event_window`](crate::client::Client::modify_instance_event_window).
///
/// See [`crate::client::fluent_builders::ModifyInstanceEventWindow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceEventWindow {
    _private: (),
}
impl ModifyInstanceEventWindow {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceEventWindowInput`](crate::input::ModifyInstanceEventWindowInput)
    pub fn builder() -> crate::input::modify_instance_event_window_input::Builder {
        crate::input::modify_instance_event_window_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceEventWindow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceEventWindow {
    type Output = std::result::Result<
        crate::output::ModifyInstanceEventWindowOutput,
        crate::error::ModifyInstanceEventWindowError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_event_window_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_event_window_response(response)
        }
    }
}

/// Operation shape for `ModifyInstanceMetadataOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_metadata_options`](crate::client::Client::modify_instance_metadata_options).
///
/// See [`crate::client::fluent_builders::ModifyInstanceMetadataOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstanceMetadataOptions {
    _private: (),
}
impl ModifyInstanceMetadataOptions {
    /// Creates a new builder-style object to manufacture [`ModifyInstanceMetadataOptionsInput`](crate::input::ModifyInstanceMetadataOptionsInput)
    pub fn builder() -> crate::input::modify_instance_metadata_options_input::Builder {
        crate::input::modify_instance_metadata_options_input::Builder::default()
    }
    /// Creates a new `ModifyInstanceMetadataOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstanceMetadataOptions {
    type Output = std::result::Result<
        crate::output::ModifyInstanceMetadataOptionsOutput,
        crate::error::ModifyInstanceMetadataOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_metadata_options_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_metadata_options_response(response)
        }
    }
}

/// Operation shape for `ModifyInstancePlacement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_instance_placement`](crate::client::Client::modify_instance_placement).
///
/// See [`crate::client::fluent_builders::ModifyInstancePlacement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyInstancePlacement {
    _private: (),
}
impl ModifyInstancePlacement {
    /// Creates a new builder-style object to manufacture [`ModifyInstancePlacementInput`](crate::input::ModifyInstancePlacementInput)
    pub fn builder() -> crate::input::modify_instance_placement_input::Builder {
        crate::input::modify_instance_placement_input::Builder::default()
    }
    /// Creates a new `ModifyInstancePlacement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyInstancePlacement {
    type Output = std::result::Result<
        crate::output::ModifyInstancePlacementOutput,
        crate::error::ModifyInstancePlacementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_instance_placement_error(response)
        } else {
            crate::operation_deser::parse_modify_instance_placement_response(response)
        }
    }
}

/// Operation shape for `ModifyIpam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_ipam`](crate::client::Client::modify_ipam).
///
/// See [`crate::client::fluent_builders::ModifyIpam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIpam {
    _private: (),
}
impl ModifyIpam {
    /// Creates a new builder-style object to manufacture [`ModifyIpamInput`](crate::input::ModifyIpamInput)
    pub fn builder() -> crate::input::modify_ipam_input::Builder {
        crate::input::modify_ipam_input::Builder::default()
    }
    /// Creates a new `ModifyIpam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIpam {
    type Output =
        std::result::Result<crate::output::ModifyIpamOutput, crate::error::ModifyIpamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_ipam_error(response)
        } else {
            crate::operation_deser::parse_modify_ipam_response(response)
        }
    }
}

/// Operation shape for `ModifyIpamPool`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_ipam_pool`](crate::client::Client::modify_ipam_pool).
///
/// See [`crate::client::fluent_builders::ModifyIpamPool`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIpamPool {
    _private: (),
}
impl ModifyIpamPool {
    /// Creates a new builder-style object to manufacture [`ModifyIpamPoolInput`](crate::input::ModifyIpamPoolInput)
    pub fn builder() -> crate::input::modify_ipam_pool_input::Builder {
        crate::input::modify_ipam_pool_input::Builder::default()
    }
    /// Creates a new `ModifyIpamPool` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIpamPool {
    type Output =
        std::result::Result<crate::output::ModifyIpamPoolOutput, crate::error::ModifyIpamPoolError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_ipam_pool_error(response)
        } else {
            crate::operation_deser::parse_modify_ipam_pool_response(response)
        }
    }
}

/// Operation shape for `ModifyIpamResourceCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_ipam_resource_cidr`](crate::client::Client::modify_ipam_resource_cidr).
///
/// See [`crate::client::fluent_builders::ModifyIpamResourceCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIpamResourceCidr {
    _private: (),
}
impl ModifyIpamResourceCidr {
    /// Creates a new builder-style object to manufacture [`ModifyIpamResourceCidrInput`](crate::input::ModifyIpamResourceCidrInput)
    pub fn builder() -> crate::input::modify_ipam_resource_cidr_input::Builder {
        crate::input::modify_ipam_resource_cidr_input::Builder::default()
    }
    /// Creates a new `ModifyIpamResourceCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIpamResourceCidr {
    type Output = std::result::Result<
        crate::output::ModifyIpamResourceCidrOutput,
        crate::error::ModifyIpamResourceCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_ipam_resource_cidr_error(response)
        } else {
            crate::operation_deser::parse_modify_ipam_resource_cidr_response(response)
        }
    }
}

/// Operation shape for `ModifyIpamScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_ipam_scope`](crate::client::Client::modify_ipam_scope).
///
/// See [`crate::client::fluent_builders::ModifyIpamScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyIpamScope {
    _private: (),
}
impl ModifyIpamScope {
    /// Creates a new builder-style object to manufacture [`ModifyIpamScopeInput`](crate::input::ModifyIpamScopeInput)
    pub fn builder() -> crate::input::modify_ipam_scope_input::Builder {
        crate::input::modify_ipam_scope_input::Builder::default()
    }
    /// Creates a new `ModifyIpamScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyIpamScope {
    type Output = std::result::Result<
        crate::output::ModifyIpamScopeOutput,
        crate::error::ModifyIpamScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_ipam_scope_error(response)
        } else {
            crate::operation_deser::parse_modify_ipam_scope_response(response)
        }
    }
}

/// Operation shape for `ModifyLaunchTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_launch_template`](crate::client::Client::modify_launch_template).
///
/// See [`crate::client::fluent_builders::ModifyLaunchTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyLaunchTemplate {
    _private: (),
}
impl ModifyLaunchTemplate {
    /// Creates a new builder-style object to manufacture [`ModifyLaunchTemplateInput`](crate::input::ModifyLaunchTemplateInput)
    pub fn builder() -> crate::input::modify_launch_template_input::Builder {
        crate::input::modify_launch_template_input::Builder::default()
    }
    /// Creates a new `ModifyLaunchTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyLaunchTemplate {
    type Output = std::result::Result<
        crate::output::ModifyLaunchTemplateOutput,
        crate::error::ModifyLaunchTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_launch_template_error(response)
        } else {
            crate::operation_deser::parse_modify_launch_template_response(response)
        }
    }
}

/// Operation shape for `ModifyManagedPrefixList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_managed_prefix_list`](crate::client::Client::modify_managed_prefix_list).
///
/// See [`crate::client::fluent_builders::ModifyManagedPrefixList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyManagedPrefixList {
    _private: (),
}
impl ModifyManagedPrefixList {
    /// Creates a new builder-style object to manufacture [`ModifyManagedPrefixListInput`](crate::input::ModifyManagedPrefixListInput)
    pub fn builder() -> crate::input::modify_managed_prefix_list_input::Builder {
        crate::input::modify_managed_prefix_list_input::Builder::default()
    }
    /// Creates a new `ModifyManagedPrefixList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyManagedPrefixList {
    type Output = std::result::Result<
        crate::output::ModifyManagedPrefixListOutput,
        crate::error::ModifyManagedPrefixListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_managed_prefix_list_error(response)
        } else {
            crate::operation_deser::parse_modify_managed_prefix_list_response(response)
        }
    }
}

/// Operation shape for `ModifyNetworkInterfaceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_network_interface_attribute`](crate::client::Client::modify_network_interface_attribute).
///
/// See [`crate::client::fluent_builders::ModifyNetworkInterfaceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyNetworkInterfaceAttribute {
    _private: (),
}
impl ModifyNetworkInterfaceAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyNetworkInterfaceAttributeInput`](crate::input::ModifyNetworkInterfaceAttributeInput)
    pub fn builder() -> crate::input::modify_network_interface_attribute_input::Builder {
        crate::input::modify_network_interface_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyNetworkInterfaceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyNetworkInterfaceAttribute {
    type Output = std::result::Result<
        crate::output::ModifyNetworkInterfaceAttributeOutput,
        crate::error::ModifyNetworkInterfaceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_network_interface_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_network_interface_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyPrivateDnsNameOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_private_dns_name_options`](crate::client::Client::modify_private_dns_name_options).
///
/// See [`crate::client::fluent_builders::ModifyPrivateDnsNameOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyPrivateDnsNameOptions {
    _private: (),
}
impl ModifyPrivateDnsNameOptions {
    /// Creates a new builder-style object to manufacture [`ModifyPrivateDnsNameOptionsInput`](crate::input::ModifyPrivateDnsNameOptionsInput)
    pub fn builder() -> crate::input::modify_private_dns_name_options_input::Builder {
        crate::input::modify_private_dns_name_options_input::Builder::default()
    }
    /// Creates a new `ModifyPrivateDnsNameOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyPrivateDnsNameOptions {
    type Output = std::result::Result<
        crate::output::ModifyPrivateDnsNameOptionsOutput,
        crate::error::ModifyPrivateDnsNameOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_private_dns_name_options_error(response)
        } else {
            crate::operation_deser::parse_modify_private_dns_name_options_response(response)
        }
    }
}

/// Operation shape for `ModifyReservedInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_reserved_instances`](crate::client::Client::modify_reserved_instances).
///
/// See [`crate::client::fluent_builders::ModifyReservedInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReservedInstances {
    _private: (),
}
impl ModifyReservedInstances {
    /// Creates a new builder-style object to manufacture [`ModifyReservedInstancesInput`](crate::input::ModifyReservedInstancesInput)
    pub fn builder() -> crate::input::modify_reserved_instances_input::Builder {
        crate::input::modify_reserved_instances_input::Builder::default()
    }
    /// Creates a new `ModifyReservedInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReservedInstances {
    type Output = std::result::Result<
        crate::output::ModifyReservedInstancesOutput,
        crate::error::ModifyReservedInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_reserved_instances_error(response)
        } else {
            crate::operation_deser::parse_modify_reserved_instances_response(response)
        }
    }
}

/// Operation shape for `ModifySecurityGroupRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_security_group_rules`](crate::client::Client::modify_security_group_rules).
///
/// See [`crate::client::fluent_builders::ModifySecurityGroupRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySecurityGroupRules {
    _private: (),
}
impl ModifySecurityGroupRules {
    /// Creates a new builder-style object to manufacture [`ModifySecurityGroupRulesInput`](crate::input::ModifySecurityGroupRulesInput)
    pub fn builder() -> crate::input::modify_security_group_rules_input::Builder {
        crate::input::modify_security_group_rules_input::Builder::default()
    }
    /// Creates a new `ModifySecurityGroupRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySecurityGroupRules {
    type Output = std::result::Result<
        crate::output::ModifySecurityGroupRulesOutput,
        crate::error::ModifySecurityGroupRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_security_group_rules_error(response)
        } else {
            crate::operation_deser::parse_modify_security_group_rules_response(response)
        }
    }
}

/// Operation shape for `ModifySnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_snapshot_attribute`](crate::client::Client::modify_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::ModifySnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySnapshotAttribute {
    _private: (),
}
impl ModifySnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotAttributeInput`](crate::input::ModifySnapshotAttributeInput)
    pub fn builder() -> crate::input::modify_snapshot_attribute_input::Builder {
        crate::input::modify_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `ModifySnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySnapshotAttribute {
    type Output = std::result::Result<
        crate::output::ModifySnapshotAttributeOutput,
        crate::error::ModifySnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifySnapshotTier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_snapshot_tier`](crate::client::Client::modify_snapshot_tier).
///
/// See [`crate::client::fluent_builders::ModifySnapshotTier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySnapshotTier {
    _private: (),
}
impl ModifySnapshotTier {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotTierInput`](crate::input::ModifySnapshotTierInput)
    pub fn builder() -> crate::input::modify_snapshot_tier_input::Builder {
        crate::input::modify_snapshot_tier_input::Builder::default()
    }
    /// Creates a new `ModifySnapshotTier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySnapshotTier {
    type Output = std::result::Result<
        crate::output::ModifySnapshotTierOutput,
        crate::error::ModifySnapshotTierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_snapshot_tier_error(response)
        } else {
            crate::operation_deser::parse_modify_snapshot_tier_response(response)
        }
    }
}

/// Operation shape for `ModifySpotFleetRequest`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_spot_fleet_request`](crate::client::Client::modify_spot_fleet_request).
///
/// See [`crate::client::fluent_builders::ModifySpotFleetRequest`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySpotFleetRequest {
    _private: (),
}
impl ModifySpotFleetRequest {
    /// Creates a new builder-style object to manufacture [`ModifySpotFleetRequestInput`](crate::input::ModifySpotFleetRequestInput)
    pub fn builder() -> crate::input::modify_spot_fleet_request_input::Builder {
        crate::input::modify_spot_fleet_request_input::Builder::default()
    }
    /// Creates a new `ModifySpotFleetRequest` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySpotFleetRequest {
    type Output = std::result::Result<
        crate::output::ModifySpotFleetRequestOutput,
        crate::error::ModifySpotFleetRequestError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_spot_fleet_request_error(response)
        } else {
            crate::operation_deser::parse_modify_spot_fleet_request_response(response)
        }
    }
}

/// Operation shape for `ModifySubnetAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_subnet_attribute`](crate::client::Client::modify_subnet_attribute).
///
/// See [`crate::client::fluent_builders::ModifySubnetAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySubnetAttribute {
    _private: (),
}
impl ModifySubnetAttribute {
    /// Creates a new builder-style object to manufacture [`ModifySubnetAttributeInput`](crate::input::ModifySubnetAttributeInput)
    pub fn builder() -> crate::input::modify_subnet_attribute_input::Builder {
        crate::input::modify_subnet_attribute_input::Builder::default()
    }
    /// Creates a new `ModifySubnetAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySubnetAttribute {
    type Output = std::result::Result<
        crate::output::ModifySubnetAttributeOutput,
        crate::error::ModifySubnetAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_subnet_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_subnet_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyTrafficMirrorFilterNetworkServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_traffic_mirror_filter_network_services`](crate::client::Client::modify_traffic_mirror_filter_network_services).
///
/// See [`crate::client::fluent_builders::ModifyTrafficMirrorFilterNetworkServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTrafficMirrorFilterNetworkServices {
    _private: (),
}
impl ModifyTrafficMirrorFilterNetworkServices {
    /// Creates a new builder-style object to manufacture [`ModifyTrafficMirrorFilterNetworkServicesInput`](crate::input::ModifyTrafficMirrorFilterNetworkServicesInput)
    pub fn builder() -> crate::input::modify_traffic_mirror_filter_network_services_input::Builder {
        crate::input::modify_traffic_mirror_filter_network_services_input::Builder::default()
    }
    /// Creates a new `ModifyTrafficMirrorFilterNetworkServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTrafficMirrorFilterNetworkServices {
    type Output = std::result::Result<
        crate::output::ModifyTrafficMirrorFilterNetworkServicesOutput,
        crate::error::ModifyTrafficMirrorFilterNetworkServicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_traffic_mirror_filter_network_services_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_traffic_mirror_filter_network_services_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyTrafficMirrorFilterRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_traffic_mirror_filter_rule`](crate::client::Client::modify_traffic_mirror_filter_rule).
///
/// See [`crate::client::fluent_builders::ModifyTrafficMirrorFilterRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTrafficMirrorFilterRule {
    _private: (),
}
impl ModifyTrafficMirrorFilterRule {
    /// Creates a new builder-style object to manufacture [`ModifyTrafficMirrorFilterRuleInput`](crate::input::ModifyTrafficMirrorFilterRuleInput)
    pub fn builder() -> crate::input::modify_traffic_mirror_filter_rule_input::Builder {
        crate::input::modify_traffic_mirror_filter_rule_input::Builder::default()
    }
    /// Creates a new `ModifyTrafficMirrorFilterRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTrafficMirrorFilterRule {
    type Output = std::result::Result<
        crate::output::ModifyTrafficMirrorFilterRuleOutput,
        crate::error::ModifyTrafficMirrorFilterRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_traffic_mirror_filter_rule_error(response)
        } else {
            crate::operation_deser::parse_modify_traffic_mirror_filter_rule_response(response)
        }
    }
}

/// Operation shape for `ModifyTrafficMirrorSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_traffic_mirror_session`](crate::client::Client::modify_traffic_mirror_session).
///
/// See [`crate::client::fluent_builders::ModifyTrafficMirrorSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTrafficMirrorSession {
    _private: (),
}
impl ModifyTrafficMirrorSession {
    /// Creates a new builder-style object to manufacture [`ModifyTrafficMirrorSessionInput`](crate::input::ModifyTrafficMirrorSessionInput)
    pub fn builder() -> crate::input::modify_traffic_mirror_session_input::Builder {
        crate::input::modify_traffic_mirror_session_input::Builder::default()
    }
    /// Creates a new `ModifyTrafficMirrorSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTrafficMirrorSession {
    type Output = std::result::Result<
        crate::output::ModifyTrafficMirrorSessionOutput,
        crate::error::ModifyTrafficMirrorSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_traffic_mirror_session_error(response)
        } else {
            crate::operation_deser::parse_modify_traffic_mirror_session_response(response)
        }
    }
}

/// Operation shape for `ModifyTransitGateway`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_transit_gateway`](crate::client::Client::modify_transit_gateway).
///
/// See [`crate::client::fluent_builders::ModifyTransitGateway`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTransitGateway {
    _private: (),
}
impl ModifyTransitGateway {
    /// Creates a new builder-style object to manufacture [`ModifyTransitGatewayInput`](crate::input::ModifyTransitGatewayInput)
    pub fn builder() -> crate::input::modify_transit_gateway_input::Builder {
        crate::input::modify_transit_gateway_input::Builder::default()
    }
    /// Creates a new `ModifyTransitGateway` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTransitGateway {
    type Output = std::result::Result<
        crate::output::ModifyTransitGatewayOutput,
        crate::error::ModifyTransitGatewayError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_transit_gateway_error(response)
        } else {
            crate::operation_deser::parse_modify_transit_gateway_response(response)
        }
    }
}

/// Operation shape for `ModifyTransitGatewayPrefixListReference`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_transit_gateway_prefix_list_reference`](crate::client::Client::modify_transit_gateway_prefix_list_reference).
///
/// See [`crate::client::fluent_builders::ModifyTransitGatewayPrefixListReference`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTransitGatewayPrefixListReference {
    _private: (),
}
impl ModifyTransitGatewayPrefixListReference {
    /// Creates a new builder-style object to manufacture [`ModifyTransitGatewayPrefixListReferenceInput`](crate::input::ModifyTransitGatewayPrefixListReferenceInput)
    pub fn builder() -> crate::input::modify_transit_gateway_prefix_list_reference_input::Builder {
        crate::input::modify_transit_gateway_prefix_list_reference_input::Builder::default()
    }
    /// Creates a new `ModifyTransitGatewayPrefixListReference` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTransitGatewayPrefixListReference {
    type Output = std::result::Result<
        crate::output::ModifyTransitGatewayPrefixListReferenceOutput,
        crate::error::ModifyTransitGatewayPrefixListReferenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_transit_gateway_prefix_list_reference_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_transit_gateway_prefix_list_reference_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyTransitGatewayVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_transit_gateway_vpc_attachment`](crate::client::Client::modify_transit_gateway_vpc_attachment).
///
/// See [`crate::client::fluent_builders::ModifyTransitGatewayVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyTransitGatewayVpcAttachment {
    _private: (),
}
impl ModifyTransitGatewayVpcAttachment {
    /// Creates a new builder-style object to manufacture [`ModifyTransitGatewayVpcAttachmentInput`](crate::input::ModifyTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::modify_transit_gateway_vpc_attachment_input::Builder {
        crate::input::modify_transit_gateway_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `ModifyTransitGatewayVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyTransitGatewayVpcAttachment {
    type Output = std::result::Result<
        crate::output::ModifyTransitGatewayVpcAttachmentOutput,
        crate::error::ModifyTransitGatewayVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_transit_gateway_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_modify_transit_gateway_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `ModifyVolume`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_volume`](crate::client::Client::modify_volume).
///
/// See [`crate::client::fluent_builders::ModifyVolume`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVolume {
    _private: (),
}
impl ModifyVolume {
    /// Creates a new builder-style object to manufacture [`ModifyVolumeInput`](crate::input::ModifyVolumeInput)
    pub fn builder() -> crate::input::modify_volume_input::Builder {
        crate::input::modify_volume_input::Builder::default()
    }
    /// Creates a new `ModifyVolume` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVolume {
    type Output =
        std::result::Result<crate::output::ModifyVolumeOutput, crate::error::ModifyVolumeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_volume_error(response)
        } else {
            crate::operation_deser::parse_modify_volume_response(response)
        }
    }
}

/// Operation shape for `ModifyVolumeAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_volume_attribute`](crate::client::Client::modify_volume_attribute).
///
/// See [`crate::client::fluent_builders::ModifyVolumeAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVolumeAttribute {
    _private: (),
}
impl ModifyVolumeAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyVolumeAttributeInput`](crate::input::ModifyVolumeAttributeInput)
    pub fn builder() -> crate::input::modify_volume_attribute_input::Builder {
        crate::input::modify_volume_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyVolumeAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVolumeAttribute {
    type Output = std::result::Result<
        crate::output::ModifyVolumeAttributeOutput,
        crate::error::ModifyVolumeAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_volume_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_volume_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyVpcAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_attribute`](crate::client::Client::modify_vpc_attribute).
///
/// See [`crate::client::fluent_builders::ModifyVpcAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcAttribute {
    _private: (),
}
impl ModifyVpcAttribute {
    /// Creates a new builder-style object to manufacture [`ModifyVpcAttributeInput`](crate::input::ModifyVpcAttributeInput)
    pub fn builder() -> crate::input::modify_vpc_attribute_input::Builder {
        crate::input::modify_vpc_attribute_input::Builder::default()
    }
    /// Creates a new `ModifyVpcAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcAttribute {
    type Output = std::result::Result<
        crate::output::ModifyVpcAttributeOutput,
        crate::error::ModifyVpcAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_attribute_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_attribute_response(response)
        }
    }
}

/// Operation shape for `ModifyVpcEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_endpoint`](crate::client::Client::modify_vpc_endpoint).
///
/// See [`crate::client::fluent_builders::ModifyVpcEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcEndpoint {
    _private: (),
}
impl ModifyVpcEndpoint {
    /// Creates a new builder-style object to manufacture [`ModifyVpcEndpointInput`](crate::input::ModifyVpcEndpointInput)
    pub fn builder() -> crate::input::modify_vpc_endpoint_input::Builder {
        crate::input::modify_vpc_endpoint_input::Builder::default()
    }
    /// Creates a new `ModifyVpcEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcEndpoint {
    type Output = std::result::Result<
        crate::output::ModifyVpcEndpointOutput,
        crate::error::ModifyVpcEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_endpoint_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_endpoint_response(response)
        }
    }
}

/// Operation shape for `ModifyVpcEndpointConnectionNotification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_endpoint_connection_notification`](crate::client::Client::modify_vpc_endpoint_connection_notification).
///
/// See [`crate::client::fluent_builders::ModifyVpcEndpointConnectionNotification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcEndpointConnectionNotification {
    _private: (),
}
impl ModifyVpcEndpointConnectionNotification {
    /// Creates a new builder-style object to manufacture [`ModifyVpcEndpointConnectionNotificationInput`](crate::input::ModifyVpcEndpointConnectionNotificationInput)
    pub fn builder() -> crate::input::modify_vpc_endpoint_connection_notification_input::Builder {
        crate::input::modify_vpc_endpoint_connection_notification_input::Builder::default()
    }
    /// Creates a new `ModifyVpcEndpointConnectionNotification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcEndpointConnectionNotification {
    type Output = std::result::Result<
        crate::output::ModifyVpcEndpointConnectionNotificationOutput,
        crate::error::ModifyVpcEndpointConnectionNotificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_endpoint_connection_notification_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_vpc_endpoint_connection_notification_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyVpcEndpointServiceConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_endpoint_service_configuration`](crate::client::Client::modify_vpc_endpoint_service_configuration).
///
/// See [`crate::client::fluent_builders::ModifyVpcEndpointServiceConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcEndpointServiceConfiguration {
    _private: (),
}
impl ModifyVpcEndpointServiceConfiguration {
    /// Creates a new builder-style object to manufacture [`ModifyVpcEndpointServiceConfigurationInput`](crate::input::ModifyVpcEndpointServiceConfigurationInput)
    pub fn builder() -> crate::input::modify_vpc_endpoint_service_configuration_input::Builder {
        crate::input::modify_vpc_endpoint_service_configuration_input::Builder::default()
    }
    /// Creates a new `ModifyVpcEndpointServiceConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcEndpointServiceConfiguration {
    type Output = std::result::Result<
        crate::output::ModifyVpcEndpointServiceConfigurationOutput,
        crate::error::ModifyVpcEndpointServiceConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_endpoint_service_configuration_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_endpoint_service_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyVpcEndpointServicePayerResponsibility`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_endpoint_service_payer_responsibility`](crate::client::Client::modify_vpc_endpoint_service_payer_responsibility).
///
/// See [`crate::client::fluent_builders::ModifyVpcEndpointServicePayerResponsibility`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcEndpointServicePayerResponsibility {
    _private: (),
}
impl ModifyVpcEndpointServicePayerResponsibility {
    /// Creates a new builder-style object to manufacture [`ModifyVpcEndpointServicePayerResponsibilityInput`](crate::input::ModifyVpcEndpointServicePayerResponsibilityInput)
    pub fn builder() -> crate::input::modify_vpc_endpoint_service_payer_responsibility_input::Builder
    {
        crate::input::modify_vpc_endpoint_service_payer_responsibility_input::Builder::default()
    }
    /// Creates a new `ModifyVpcEndpointServicePayerResponsibility` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ModifyVpcEndpointServicePayerResponsibility
{
    type Output = std::result::Result<
        crate::output::ModifyVpcEndpointServicePayerResponsibilityOutput,
        crate::error::ModifyVpcEndpointServicePayerResponsibilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_endpoint_service_payer_responsibility_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_vpc_endpoint_service_payer_responsibility_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyVpcEndpointServicePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_endpoint_service_permissions`](crate::client::Client::modify_vpc_endpoint_service_permissions).
///
/// See [`crate::client::fluent_builders::ModifyVpcEndpointServicePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcEndpointServicePermissions {
    _private: (),
}
impl ModifyVpcEndpointServicePermissions {
    /// Creates a new builder-style object to manufacture [`ModifyVpcEndpointServicePermissionsInput`](crate::input::ModifyVpcEndpointServicePermissionsInput)
    pub fn builder() -> crate::input::modify_vpc_endpoint_service_permissions_input::Builder {
        crate::input::modify_vpc_endpoint_service_permissions_input::Builder::default()
    }
    /// Creates a new `ModifyVpcEndpointServicePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcEndpointServicePermissions {
    type Output = std::result::Result<
        crate::output::ModifyVpcEndpointServicePermissionsOutput,
        crate::error::ModifyVpcEndpointServicePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_endpoint_service_permissions_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_endpoint_service_permissions_response(response)
        }
    }
}

/// Operation shape for `ModifyVpcPeeringConnectionOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_peering_connection_options`](crate::client::Client::modify_vpc_peering_connection_options).
///
/// See [`crate::client::fluent_builders::ModifyVpcPeeringConnectionOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcPeeringConnectionOptions {
    _private: (),
}
impl ModifyVpcPeeringConnectionOptions {
    /// Creates a new builder-style object to manufacture [`ModifyVpcPeeringConnectionOptionsInput`](crate::input::ModifyVpcPeeringConnectionOptionsInput)
    pub fn builder() -> crate::input::modify_vpc_peering_connection_options_input::Builder {
        crate::input::modify_vpc_peering_connection_options_input::Builder::default()
    }
    /// Creates a new `ModifyVpcPeeringConnectionOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcPeeringConnectionOptions {
    type Output = std::result::Result<
        crate::output::ModifyVpcPeeringConnectionOptionsOutput,
        crate::error::ModifyVpcPeeringConnectionOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_peering_connection_options_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_peering_connection_options_response(response)
        }
    }
}

/// Operation shape for `ModifyVpcTenancy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpc_tenancy`](crate::client::Client::modify_vpc_tenancy).
///
/// See [`crate::client::fluent_builders::ModifyVpcTenancy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpcTenancy {
    _private: (),
}
impl ModifyVpcTenancy {
    /// Creates a new builder-style object to manufacture [`ModifyVpcTenancyInput`](crate::input::ModifyVpcTenancyInput)
    pub fn builder() -> crate::input::modify_vpc_tenancy_input::Builder {
        crate::input::modify_vpc_tenancy_input::Builder::default()
    }
    /// Creates a new `ModifyVpcTenancy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpcTenancy {
    type Output = std::result::Result<
        crate::output::ModifyVpcTenancyOutput,
        crate::error::ModifyVpcTenancyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpc_tenancy_error(response)
        } else {
            crate::operation_deser::parse_modify_vpc_tenancy_response(response)
        }
    }
}

/// Operation shape for `ModifyVpnConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpn_connection`](crate::client::Client::modify_vpn_connection).
///
/// See [`crate::client::fluent_builders::ModifyVpnConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpnConnection {
    _private: (),
}
impl ModifyVpnConnection {
    /// Creates a new builder-style object to manufacture [`ModifyVpnConnectionInput`](crate::input::ModifyVpnConnectionInput)
    pub fn builder() -> crate::input::modify_vpn_connection_input::Builder {
        crate::input::modify_vpn_connection_input::Builder::default()
    }
    /// Creates a new `ModifyVpnConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpnConnection {
    type Output = std::result::Result<
        crate::output::ModifyVpnConnectionOutput,
        crate::error::ModifyVpnConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpn_connection_error(response)
        } else {
            crate::operation_deser::parse_modify_vpn_connection_response(response)
        }
    }
}

/// Operation shape for `ModifyVpnConnectionOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpn_connection_options`](crate::client::Client::modify_vpn_connection_options).
///
/// See [`crate::client::fluent_builders::ModifyVpnConnectionOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpnConnectionOptions {
    _private: (),
}
impl ModifyVpnConnectionOptions {
    /// Creates a new builder-style object to manufacture [`ModifyVpnConnectionOptionsInput`](crate::input::ModifyVpnConnectionOptionsInput)
    pub fn builder() -> crate::input::modify_vpn_connection_options_input::Builder {
        crate::input::modify_vpn_connection_options_input::Builder::default()
    }
    /// Creates a new `ModifyVpnConnectionOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpnConnectionOptions {
    type Output = std::result::Result<
        crate::output::ModifyVpnConnectionOptionsOutput,
        crate::error::ModifyVpnConnectionOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpn_connection_options_error(response)
        } else {
            crate::operation_deser::parse_modify_vpn_connection_options_response(response)
        }
    }
}

/// Operation shape for `ModifyVpnTunnelCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpn_tunnel_certificate`](crate::client::Client::modify_vpn_tunnel_certificate).
///
/// See [`crate::client::fluent_builders::ModifyVpnTunnelCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpnTunnelCertificate {
    _private: (),
}
impl ModifyVpnTunnelCertificate {
    /// Creates a new builder-style object to manufacture [`ModifyVpnTunnelCertificateInput`](crate::input::ModifyVpnTunnelCertificateInput)
    pub fn builder() -> crate::input::modify_vpn_tunnel_certificate_input::Builder {
        crate::input::modify_vpn_tunnel_certificate_input::Builder::default()
    }
    /// Creates a new `ModifyVpnTunnelCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpnTunnelCertificate {
    type Output = std::result::Result<
        crate::output::ModifyVpnTunnelCertificateOutput,
        crate::error::ModifyVpnTunnelCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpn_tunnel_certificate_error(response)
        } else {
            crate::operation_deser::parse_modify_vpn_tunnel_certificate_response(response)
        }
    }
}

/// Operation shape for `ModifyVpnTunnelOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_vpn_tunnel_options`](crate::client::Client::modify_vpn_tunnel_options).
///
/// See [`crate::client::fluent_builders::ModifyVpnTunnelOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyVpnTunnelOptions {
    _private: (),
}
impl ModifyVpnTunnelOptions {
    /// Creates a new builder-style object to manufacture [`ModifyVpnTunnelOptionsInput`](crate::input::ModifyVpnTunnelOptionsInput)
    pub fn builder() -> crate::input::modify_vpn_tunnel_options_input::Builder {
        crate::input::modify_vpn_tunnel_options_input::Builder::default()
    }
    /// Creates a new `ModifyVpnTunnelOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyVpnTunnelOptions {
    type Output = std::result::Result<
        crate::output::ModifyVpnTunnelOptionsOutput,
        crate::error::ModifyVpnTunnelOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_vpn_tunnel_options_error(response)
        } else {
            crate::operation_deser::parse_modify_vpn_tunnel_options_response(response)
        }
    }
}

/// Operation shape for `MonitorInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`monitor_instances`](crate::client::Client::monitor_instances).
///
/// See [`crate::client::fluent_builders::MonitorInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MonitorInstances {
    _private: (),
}
impl MonitorInstances {
    /// Creates a new builder-style object to manufacture [`MonitorInstancesInput`](crate::input::MonitorInstancesInput)
    pub fn builder() -> crate::input::monitor_instances_input::Builder {
        crate::input::monitor_instances_input::Builder::default()
    }
    /// Creates a new `MonitorInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MonitorInstances {
    type Output = std::result::Result<
        crate::output::MonitorInstancesOutput,
        crate::error::MonitorInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_monitor_instances_error(response)
        } else {
            crate::operation_deser::parse_monitor_instances_response(response)
        }
    }
}

/// Operation shape for `MoveAddressToVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`move_address_to_vpc`](crate::client::Client::move_address_to_vpc).
///
/// See [`crate::client::fluent_builders::MoveAddressToVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MoveAddressToVpc {
    _private: (),
}
impl MoveAddressToVpc {
    /// Creates a new builder-style object to manufacture [`MoveAddressToVpcInput`](crate::input::MoveAddressToVpcInput)
    pub fn builder() -> crate::input::move_address_to_vpc_input::Builder {
        crate::input::move_address_to_vpc_input::Builder::default()
    }
    /// Creates a new `MoveAddressToVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MoveAddressToVpc {
    type Output = std::result::Result<
        crate::output::MoveAddressToVpcOutput,
        crate::error::MoveAddressToVpcError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_move_address_to_vpc_error(response)
        } else {
            crate::operation_deser::parse_move_address_to_vpc_response(response)
        }
    }
}

/// Operation shape for `MoveByoipCidrToIpam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`move_byoip_cidr_to_ipam`](crate::client::Client::move_byoip_cidr_to_ipam).
///
/// See [`crate::client::fluent_builders::MoveByoipCidrToIpam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MoveByoipCidrToIpam {
    _private: (),
}
impl MoveByoipCidrToIpam {
    /// Creates a new builder-style object to manufacture [`MoveByoipCidrToIpamInput`](crate::input::MoveByoipCidrToIpamInput)
    pub fn builder() -> crate::input::move_byoip_cidr_to_ipam_input::Builder {
        crate::input::move_byoip_cidr_to_ipam_input::Builder::default()
    }
    /// Creates a new `MoveByoipCidrToIpam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MoveByoipCidrToIpam {
    type Output = std::result::Result<
        crate::output::MoveByoipCidrToIpamOutput,
        crate::error::MoveByoipCidrToIpamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_move_byoip_cidr_to_ipam_error(response)
        } else {
            crate::operation_deser::parse_move_byoip_cidr_to_ipam_response(response)
        }
    }
}

/// Operation shape for `ProvisionByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_byoip_cidr`](crate::client::Client::provision_byoip_cidr).
///
/// See [`crate::client::fluent_builders::ProvisionByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionByoipCidr {
    _private: (),
}
impl ProvisionByoipCidr {
    /// Creates a new builder-style object to manufacture [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
    pub fn builder() -> crate::input::provision_byoip_cidr_input::Builder {
        crate::input::provision_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `ProvisionByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionByoipCidr {
    type Output = std::result::Result<
        crate::output::ProvisionByoipCidrOutput,
        crate::error::ProvisionByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_provision_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `ProvisionIpamPoolCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_ipam_pool_cidr`](crate::client::Client::provision_ipam_pool_cidr).
///
/// See [`crate::client::fluent_builders::ProvisionIpamPoolCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionIpamPoolCidr {
    _private: (),
}
impl ProvisionIpamPoolCidr {
    /// Creates a new builder-style object to manufacture [`ProvisionIpamPoolCidrInput`](crate::input::ProvisionIpamPoolCidrInput)
    pub fn builder() -> crate::input::provision_ipam_pool_cidr_input::Builder {
        crate::input::provision_ipam_pool_cidr_input::Builder::default()
    }
    /// Creates a new `ProvisionIpamPoolCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionIpamPoolCidr {
    type Output = std::result::Result<
        crate::output::ProvisionIpamPoolCidrOutput,
        crate::error::ProvisionIpamPoolCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_ipam_pool_cidr_error(response)
        } else {
            crate::operation_deser::parse_provision_ipam_pool_cidr_response(response)
        }
    }
}

/// Operation shape for `ProvisionPublicIpv4PoolCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_public_ipv4_pool_cidr`](crate::client::Client::provision_public_ipv4_pool_cidr).
///
/// See [`crate::client::fluent_builders::ProvisionPublicIpv4PoolCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionPublicIpv4PoolCidr {
    _private: (),
}
impl ProvisionPublicIpv4PoolCidr {
    /// Creates a new builder-style object to manufacture [`ProvisionPublicIpv4PoolCidrInput`](crate::input::ProvisionPublicIpv4PoolCidrInput)
    pub fn builder() -> crate::input::provision_public_ipv4_pool_cidr_input::Builder {
        crate::input::provision_public_ipv4_pool_cidr_input::Builder::default()
    }
    /// Creates a new `ProvisionPublicIpv4PoolCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionPublicIpv4PoolCidr {
    type Output = std::result::Result<
        crate::output::ProvisionPublicIpv4PoolCidrOutput,
        crate::error::ProvisionPublicIpv4PoolCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_public_ipv4_pool_cidr_error(response)
        } else {
            crate::operation_deser::parse_provision_public_ipv4_pool_cidr_response(response)
        }
    }
}

/// Operation shape for `PurchaseHostReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_host_reservation`](crate::client::Client::purchase_host_reservation).
///
/// See [`crate::client::fluent_builders::PurchaseHostReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseHostReservation {
    _private: (),
}
impl PurchaseHostReservation {
    /// Creates a new builder-style object to manufacture [`PurchaseHostReservationInput`](crate::input::PurchaseHostReservationInput)
    pub fn builder() -> crate::input::purchase_host_reservation_input::Builder {
        crate::input::purchase_host_reservation_input::Builder::default()
    }
    /// Creates a new `PurchaseHostReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseHostReservation {
    type Output = std::result::Result<
        crate::output::PurchaseHostReservationOutput,
        crate::error::PurchaseHostReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_host_reservation_error(response)
        } else {
            crate::operation_deser::parse_purchase_host_reservation_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedInstancesOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_instances_offering`](crate::client::Client::purchase_reserved_instances_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedInstancesOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedInstancesOffering {
    _private: (),
}
impl PurchaseReservedInstancesOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedInstancesOfferingInput`](crate::input::PurchaseReservedInstancesOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_instances_offering_input::Builder {
        crate::input::purchase_reserved_instances_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedInstancesOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseReservedInstancesOffering {
    type Output = std::result::Result<
        crate::output::PurchaseReservedInstancesOfferingOutput,
        crate::error::PurchaseReservedInstancesOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_instances_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_reserved_instances_offering_response(response)
        }
    }
}

/// Operation shape for `PurchaseScheduledInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_scheduled_instances`](crate::client::Client::purchase_scheduled_instances).
///
/// See [`crate::client::fluent_builders::PurchaseScheduledInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseScheduledInstances {
    _private: (),
}
impl PurchaseScheduledInstances {
    /// Creates a new builder-style object to manufacture [`PurchaseScheduledInstancesInput`](crate::input::PurchaseScheduledInstancesInput)
    pub fn builder() -> crate::input::purchase_scheduled_instances_input::Builder {
        crate::input::purchase_scheduled_instances_input::Builder::default()
    }
    /// Creates a new `PurchaseScheduledInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseScheduledInstances {
    type Output = std::result::Result<
        crate::output::PurchaseScheduledInstancesOutput,
        crate::error::PurchaseScheduledInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_scheduled_instances_error(response)
        } else {
            crate::operation_deser::parse_purchase_scheduled_instances_response(response)
        }
    }
}

/// Operation shape for `RebootInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_instances`](crate::client::Client::reboot_instances).
///
/// See [`crate::client::fluent_builders::RebootInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootInstances {
    _private: (),
}
impl RebootInstances {
    /// Creates a new builder-style object to manufacture [`RebootInstancesInput`](crate::input::RebootInstancesInput)
    pub fn builder() -> crate::input::reboot_instances_input::Builder {
        crate::input::reboot_instances_input::Builder::default()
    }
    /// Creates a new `RebootInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootInstances {
    type Output = std::result::Result<
        crate::output::RebootInstancesOutput,
        crate::error::RebootInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_instances_error(response)
        } else {
            crate::operation_deser::parse_reboot_instances_response(response)
        }
    }
}

/// Operation shape for `RegisterImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_image`](crate::client::Client::register_image).
///
/// See [`crate::client::fluent_builders::RegisterImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterImage {
    _private: (),
}
impl RegisterImage {
    /// Creates a new builder-style object to manufacture [`RegisterImageInput`](crate::input::RegisterImageInput)
    pub fn builder() -> crate::input::register_image_input::Builder {
        crate::input::register_image_input::Builder::default()
    }
    /// Creates a new `RegisterImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterImage {
    type Output =
        std::result::Result<crate::output::RegisterImageOutput, crate::error::RegisterImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_image_error(response)
        } else {
            crate::operation_deser::parse_register_image_response(response)
        }
    }
}

/// Operation shape for `RegisterInstanceEventNotificationAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_instance_event_notification_attributes`](crate::client::Client::register_instance_event_notification_attributes).
///
/// See [`crate::client::fluent_builders::RegisterInstanceEventNotificationAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterInstanceEventNotificationAttributes {
    _private: (),
}
impl RegisterInstanceEventNotificationAttributes {
    /// Creates a new builder-style object to manufacture [`RegisterInstanceEventNotificationAttributesInput`](crate::input::RegisterInstanceEventNotificationAttributesInput)
    pub fn builder() -> crate::input::register_instance_event_notification_attributes_input::Builder
    {
        crate::input::register_instance_event_notification_attributes_input::Builder::default()
    }
    /// Creates a new `RegisterInstanceEventNotificationAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for RegisterInstanceEventNotificationAttributes
{
    type Output = std::result::Result<
        crate::output::RegisterInstanceEventNotificationAttributesOutput,
        crate::error::RegisterInstanceEventNotificationAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_instance_event_notification_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_register_instance_event_notification_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `RegisterTransitGatewayMulticastGroupMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_transit_gateway_multicast_group_members`](crate::client::Client::register_transit_gateway_multicast_group_members).
///
/// See [`crate::client::fluent_builders::RegisterTransitGatewayMulticastGroupMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTransitGatewayMulticastGroupMembers {
    _private: (),
}
impl RegisterTransitGatewayMulticastGroupMembers {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayMulticastGroupMembersInput`](crate::input::RegisterTransitGatewayMulticastGroupMembersInput)
    pub fn builder() -> crate::input::register_transit_gateway_multicast_group_members_input::Builder
    {
        crate::input::register_transit_gateway_multicast_group_members_input::Builder::default()
    }
    /// Creates a new `RegisterTransitGatewayMulticastGroupMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for RegisterTransitGatewayMulticastGroupMembers
{
    type Output = std::result::Result<
        crate::output::RegisterTransitGatewayMulticastGroupMembersOutput,
        crate::error::RegisterTransitGatewayMulticastGroupMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_transit_gateway_multicast_group_members_error(
                response,
            )
        } else {
            crate::operation_deser::parse_register_transit_gateway_multicast_group_members_response(
                response,
            )
        }
    }
}

/// Operation shape for `RegisterTransitGatewayMulticastGroupSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_transit_gateway_multicast_group_sources`](crate::client::Client::register_transit_gateway_multicast_group_sources).
///
/// See [`crate::client::fluent_builders::RegisterTransitGatewayMulticastGroupSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTransitGatewayMulticastGroupSources {
    _private: (),
}
impl RegisterTransitGatewayMulticastGroupSources {
    /// Creates a new builder-style object to manufacture [`RegisterTransitGatewayMulticastGroupSourcesInput`](crate::input::RegisterTransitGatewayMulticastGroupSourcesInput)
    pub fn builder() -> crate::input::register_transit_gateway_multicast_group_sources_input::Builder
    {
        crate::input::register_transit_gateway_multicast_group_sources_input::Builder::default()
    }
    /// Creates a new `RegisterTransitGatewayMulticastGroupSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for RegisterTransitGatewayMulticastGroupSources
{
    type Output = std::result::Result<
        crate::output::RegisterTransitGatewayMulticastGroupSourcesOutput,
        crate::error::RegisterTransitGatewayMulticastGroupSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_transit_gateway_multicast_group_sources_error(
                response,
            )
        } else {
            crate::operation_deser::parse_register_transit_gateway_multicast_group_sources_response(
                response,
            )
        }
    }
}

/// Operation shape for `RejectTransitGatewayMulticastDomainAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_transit_gateway_multicast_domain_associations`](crate::client::Client::reject_transit_gateway_multicast_domain_associations).
///
/// See [`crate::client::fluent_builders::RejectTransitGatewayMulticastDomainAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectTransitGatewayMulticastDomainAssociations {
    _private: (),
}
impl RejectTransitGatewayMulticastDomainAssociations {
    /// Creates a new builder-style object to manufacture [`RejectTransitGatewayMulticastDomainAssociationsInput`](crate::input::RejectTransitGatewayMulticastDomainAssociationsInput)
    pub fn builder(
    ) -> crate::input::reject_transit_gateway_multicast_domain_associations_input::Builder {
        crate::input::reject_transit_gateway_multicast_domain_associations_input::Builder::default()
    }
    /// Creates a new `RejectTransitGatewayMulticastDomainAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for RejectTransitGatewayMulticastDomainAssociations
{
    type Output = std::result::Result<
        crate::output::RejectTransitGatewayMulticastDomainAssociationsOutput,
        crate::error::RejectTransitGatewayMulticastDomainAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_transit_gateway_multicast_domain_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_reject_transit_gateway_multicast_domain_associations_response(response)
        }
    }
}

/// Operation shape for `RejectTransitGatewayPeeringAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_transit_gateway_peering_attachment`](crate::client::Client::reject_transit_gateway_peering_attachment).
///
/// See [`crate::client::fluent_builders::RejectTransitGatewayPeeringAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectTransitGatewayPeeringAttachment {
    _private: (),
}
impl RejectTransitGatewayPeeringAttachment {
    /// Creates a new builder-style object to manufacture [`RejectTransitGatewayPeeringAttachmentInput`](crate::input::RejectTransitGatewayPeeringAttachmentInput)
    pub fn builder() -> crate::input::reject_transit_gateway_peering_attachment_input::Builder {
        crate::input::reject_transit_gateway_peering_attachment_input::Builder::default()
    }
    /// Creates a new `RejectTransitGatewayPeeringAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectTransitGatewayPeeringAttachment {
    type Output = std::result::Result<
        crate::output::RejectTransitGatewayPeeringAttachmentOutput,
        crate::error::RejectTransitGatewayPeeringAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_transit_gateway_peering_attachment_error(response)
        } else {
            crate::operation_deser::parse_reject_transit_gateway_peering_attachment_response(
                response,
            )
        }
    }
}

/// Operation shape for `RejectTransitGatewayVpcAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_transit_gateway_vpc_attachment`](crate::client::Client::reject_transit_gateway_vpc_attachment).
///
/// See [`crate::client::fluent_builders::RejectTransitGatewayVpcAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectTransitGatewayVpcAttachment {
    _private: (),
}
impl RejectTransitGatewayVpcAttachment {
    /// Creates a new builder-style object to manufacture [`RejectTransitGatewayVpcAttachmentInput`](crate::input::RejectTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::reject_transit_gateway_vpc_attachment_input::Builder {
        crate::input::reject_transit_gateway_vpc_attachment_input::Builder::default()
    }
    /// Creates a new `RejectTransitGatewayVpcAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectTransitGatewayVpcAttachment {
    type Output = std::result::Result<
        crate::output::RejectTransitGatewayVpcAttachmentOutput,
        crate::error::RejectTransitGatewayVpcAttachmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_transit_gateway_vpc_attachment_error(response)
        } else {
            crate::operation_deser::parse_reject_transit_gateway_vpc_attachment_response(response)
        }
    }
}

/// Operation shape for `RejectVpcEndpointConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_vpc_endpoint_connections`](crate::client::Client::reject_vpc_endpoint_connections).
///
/// See [`crate::client::fluent_builders::RejectVpcEndpointConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectVpcEndpointConnections {
    _private: (),
}
impl RejectVpcEndpointConnections {
    /// Creates a new builder-style object to manufacture [`RejectVpcEndpointConnectionsInput`](crate::input::RejectVpcEndpointConnectionsInput)
    pub fn builder() -> crate::input::reject_vpc_endpoint_connections_input::Builder {
        crate::input::reject_vpc_endpoint_connections_input::Builder::default()
    }
    /// Creates a new `RejectVpcEndpointConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectVpcEndpointConnections {
    type Output = std::result::Result<
        crate::output::RejectVpcEndpointConnectionsOutput,
        crate::error::RejectVpcEndpointConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_vpc_endpoint_connections_error(response)
        } else {
            crate::operation_deser::parse_reject_vpc_endpoint_connections_response(response)
        }
    }
}

/// Operation shape for `RejectVpcPeeringConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_vpc_peering_connection`](crate::client::Client::reject_vpc_peering_connection).
///
/// See [`crate::client::fluent_builders::RejectVpcPeeringConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectVpcPeeringConnection {
    _private: (),
}
impl RejectVpcPeeringConnection {
    /// Creates a new builder-style object to manufacture [`RejectVpcPeeringConnectionInput`](crate::input::RejectVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::reject_vpc_peering_connection_input::Builder {
        crate::input::reject_vpc_peering_connection_input::Builder::default()
    }
    /// Creates a new `RejectVpcPeeringConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectVpcPeeringConnection {
    type Output = std::result::Result<
        crate::output::RejectVpcPeeringConnectionOutput,
        crate::error::RejectVpcPeeringConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_vpc_peering_connection_error(response)
        } else {
            crate::operation_deser::parse_reject_vpc_peering_connection_response(response)
        }
    }
}

/// Operation shape for `ReleaseAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`release_address`](crate::client::Client::release_address).
///
/// See [`crate::client::fluent_builders::ReleaseAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReleaseAddress {
    _private: (),
}
impl ReleaseAddress {
    /// Creates a new builder-style object to manufacture [`ReleaseAddressInput`](crate::input::ReleaseAddressInput)
    pub fn builder() -> crate::input::release_address_input::Builder {
        crate::input::release_address_input::Builder::default()
    }
    /// Creates a new `ReleaseAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReleaseAddress {
    type Output =
        std::result::Result<crate::output::ReleaseAddressOutput, crate::error::ReleaseAddressError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_release_address_error(response)
        } else {
            crate::operation_deser::parse_release_address_response(response)
        }
    }
}

/// Operation shape for `ReleaseHosts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`release_hosts`](crate::client::Client::release_hosts).
///
/// See [`crate::client::fluent_builders::ReleaseHosts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReleaseHosts {
    _private: (),
}
impl ReleaseHosts {
    /// Creates a new builder-style object to manufacture [`ReleaseHostsInput`](crate::input::ReleaseHostsInput)
    pub fn builder() -> crate::input::release_hosts_input::Builder {
        crate::input::release_hosts_input::Builder::default()
    }
    /// Creates a new `ReleaseHosts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReleaseHosts {
    type Output =
        std::result::Result<crate::output::ReleaseHostsOutput, crate::error::ReleaseHostsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_release_hosts_error(response)
        } else {
            crate::operation_deser::parse_release_hosts_response(response)
        }
    }
}

/// Operation shape for `ReleaseIpamPoolAllocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`release_ipam_pool_allocation`](crate::client::Client::release_ipam_pool_allocation).
///
/// See [`crate::client::fluent_builders::ReleaseIpamPoolAllocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReleaseIpamPoolAllocation {
    _private: (),
}
impl ReleaseIpamPoolAllocation {
    /// Creates a new builder-style object to manufacture [`ReleaseIpamPoolAllocationInput`](crate::input::ReleaseIpamPoolAllocationInput)
    pub fn builder() -> crate::input::release_ipam_pool_allocation_input::Builder {
        crate::input::release_ipam_pool_allocation_input::Builder::default()
    }
    /// Creates a new `ReleaseIpamPoolAllocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReleaseIpamPoolAllocation {
    type Output = std::result::Result<
        crate::output::ReleaseIpamPoolAllocationOutput,
        crate::error::ReleaseIpamPoolAllocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_release_ipam_pool_allocation_error(response)
        } else {
            crate::operation_deser::parse_release_ipam_pool_allocation_response(response)
        }
    }
}

/// Operation shape for `ReplaceIamInstanceProfileAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_iam_instance_profile_association`](crate::client::Client::replace_iam_instance_profile_association).
///
/// See [`crate::client::fluent_builders::ReplaceIamInstanceProfileAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceIamInstanceProfileAssociation {
    _private: (),
}
impl ReplaceIamInstanceProfileAssociation {
    /// Creates a new builder-style object to manufacture [`ReplaceIamInstanceProfileAssociationInput`](crate::input::ReplaceIamInstanceProfileAssociationInput)
    pub fn builder() -> crate::input::replace_iam_instance_profile_association_input::Builder {
        crate::input::replace_iam_instance_profile_association_input::Builder::default()
    }
    /// Creates a new `ReplaceIamInstanceProfileAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceIamInstanceProfileAssociation {
    type Output = std::result::Result<
        crate::output::ReplaceIamInstanceProfileAssociationOutput,
        crate::error::ReplaceIamInstanceProfileAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_iam_instance_profile_association_error(response)
        } else {
            crate::operation_deser::parse_replace_iam_instance_profile_association_response(
                response,
            )
        }
    }
}

/// Operation shape for `ReplaceNetworkAclAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_network_acl_association`](crate::client::Client::replace_network_acl_association).
///
/// See [`crate::client::fluent_builders::ReplaceNetworkAclAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceNetworkAclAssociation {
    _private: (),
}
impl ReplaceNetworkAclAssociation {
    /// Creates a new builder-style object to manufacture [`ReplaceNetworkAclAssociationInput`](crate::input::ReplaceNetworkAclAssociationInput)
    pub fn builder() -> crate::input::replace_network_acl_association_input::Builder {
        crate::input::replace_network_acl_association_input::Builder::default()
    }
    /// Creates a new `ReplaceNetworkAclAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceNetworkAclAssociation {
    type Output = std::result::Result<
        crate::output::ReplaceNetworkAclAssociationOutput,
        crate::error::ReplaceNetworkAclAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_network_acl_association_error(response)
        } else {
            crate::operation_deser::parse_replace_network_acl_association_response(response)
        }
    }
}

/// Operation shape for `ReplaceNetworkAclEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_network_acl_entry`](crate::client::Client::replace_network_acl_entry).
///
/// See [`crate::client::fluent_builders::ReplaceNetworkAclEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceNetworkAclEntry {
    _private: (),
}
impl ReplaceNetworkAclEntry {
    /// Creates a new builder-style object to manufacture [`ReplaceNetworkAclEntryInput`](crate::input::ReplaceNetworkAclEntryInput)
    pub fn builder() -> crate::input::replace_network_acl_entry_input::Builder {
        crate::input::replace_network_acl_entry_input::Builder::default()
    }
    /// Creates a new `ReplaceNetworkAclEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceNetworkAclEntry {
    type Output = std::result::Result<
        crate::output::ReplaceNetworkAclEntryOutput,
        crate::error::ReplaceNetworkAclEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_network_acl_entry_error(response)
        } else {
            crate::operation_deser::parse_replace_network_acl_entry_response(response)
        }
    }
}

/// Operation shape for `ReplaceRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_route`](crate::client::Client::replace_route).
///
/// See [`crate::client::fluent_builders::ReplaceRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceRoute {
    _private: (),
}
impl ReplaceRoute {
    /// Creates a new builder-style object to manufacture [`ReplaceRouteInput`](crate::input::ReplaceRouteInput)
    pub fn builder() -> crate::input::replace_route_input::Builder {
        crate::input::replace_route_input::Builder::default()
    }
    /// Creates a new `ReplaceRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceRoute {
    type Output =
        std::result::Result<crate::output::ReplaceRouteOutput, crate::error::ReplaceRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_route_error(response)
        } else {
            crate::operation_deser::parse_replace_route_response(response)
        }
    }
}

/// Operation shape for `ReplaceRouteTableAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_route_table_association`](crate::client::Client::replace_route_table_association).
///
/// See [`crate::client::fluent_builders::ReplaceRouteTableAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceRouteTableAssociation {
    _private: (),
}
impl ReplaceRouteTableAssociation {
    /// Creates a new builder-style object to manufacture [`ReplaceRouteTableAssociationInput`](crate::input::ReplaceRouteTableAssociationInput)
    pub fn builder() -> crate::input::replace_route_table_association_input::Builder {
        crate::input::replace_route_table_association_input::Builder::default()
    }
    /// Creates a new `ReplaceRouteTableAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceRouteTableAssociation {
    type Output = std::result::Result<
        crate::output::ReplaceRouteTableAssociationOutput,
        crate::error::ReplaceRouteTableAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_route_table_association_error(response)
        } else {
            crate::operation_deser::parse_replace_route_table_association_response(response)
        }
    }
}

/// Operation shape for `ReplaceTransitGatewayRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`replace_transit_gateway_route`](crate::client::Client::replace_transit_gateway_route).
///
/// See [`crate::client::fluent_builders::ReplaceTransitGatewayRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReplaceTransitGatewayRoute {
    _private: (),
}
impl ReplaceTransitGatewayRoute {
    /// Creates a new builder-style object to manufacture [`ReplaceTransitGatewayRouteInput`](crate::input::ReplaceTransitGatewayRouteInput)
    pub fn builder() -> crate::input::replace_transit_gateway_route_input::Builder {
        crate::input::replace_transit_gateway_route_input::Builder::default()
    }
    /// Creates a new `ReplaceTransitGatewayRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReplaceTransitGatewayRoute {
    type Output = std::result::Result<
        crate::output::ReplaceTransitGatewayRouteOutput,
        crate::error::ReplaceTransitGatewayRouteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_replace_transit_gateway_route_error(response)
        } else {
            crate::operation_deser::parse_replace_transit_gateway_route_response(response)
        }
    }
}

/// Operation shape for `ReportInstanceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`report_instance_status`](crate::client::Client::report_instance_status).
///
/// See [`crate::client::fluent_builders::ReportInstanceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReportInstanceStatus {
    _private: (),
}
impl ReportInstanceStatus {
    /// Creates a new builder-style object to manufacture [`ReportInstanceStatusInput`](crate::input::ReportInstanceStatusInput)
    pub fn builder() -> crate::input::report_instance_status_input::Builder {
        crate::input::report_instance_status_input::Builder::default()
    }
    /// Creates a new `ReportInstanceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReportInstanceStatus {
    type Output = std::result::Result<
        crate::output::ReportInstanceStatusOutput,
        crate::error::ReportInstanceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_report_instance_status_error(response)
        } else {
            crate::operation_deser::parse_report_instance_status_response(response)
        }
    }
}

/// Operation shape for `RequestSpotFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_spot_fleet`](crate::client::Client::request_spot_fleet).
///
/// See [`crate::client::fluent_builders::RequestSpotFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestSpotFleet {
    _private: (),
}
impl RequestSpotFleet {
    /// Creates a new builder-style object to manufacture [`RequestSpotFleetInput`](crate::input::RequestSpotFleetInput)
    pub fn builder() -> crate::input::request_spot_fleet_input::Builder {
        crate::input::request_spot_fleet_input::Builder::default()
    }
    /// Creates a new `RequestSpotFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestSpotFleet {
    type Output = std::result::Result<
        crate::output::RequestSpotFleetOutput,
        crate::error::RequestSpotFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_spot_fleet_error(response)
        } else {
            crate::operation_deser::parse_request_spot_fleet_response(response)
        }
    }
}

/// Operation shape for `RequestSpotInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`request_spot_instances`](crate::client::Client::request_spot_instances).
///
/// See [`crate::client::fluent_builders::RequestSpotInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RequestSpotInstances {
    _private: (),
}
impl RequestSpotInstances {
    /// Creates a new builder-style object to manufacture [`RequestSpotInstancesInput`](crate::input::RequestSpotInstancesInput)
    pub fn builder() -> crate::input::request_spot_instances_input::Builder {
        crate::input::request_spot_instances_input::Builder::default()
    }
    /// Creates a new `RequestSpotInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RequestSpotInstances {
    type Output = std::result::Result<
        crate::output::RequestSpotInstancesOutput,
        crate::error::RequestSpotInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_request_spot_instances_error(response)
        } else {
            crate::operation_deser::parse_request_spot_instances_response(response)
        }
    }
}

/// Operation shape for `ResetAddressAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_address_attribute`](crate::client::Client::reset_address_attribute).
///
/// See [`crate::client::fluent_builders::ResetAddressAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetAddressAttribute {
    _private: (),
}
impl ResetAddressAttribute {
    /// Creates a new builder-style object to manufacture [`ResetAddressAttributeInput`](crate::input::ResetAddressAttributeInput)
    pub fn builder() -> crate::input::reset_address_attribute_input::Builder {
        crate::input::reset_address_attribute_input::Builder::default()
    }
    /// Creates a new `ResetAddressAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetAddressAttribute {
    type Output = std::result::Result<
        crate::output::ResetAddressAttributeOutput,
        crate::error::ResetAddressAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_address_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_address_attribute_response(response)
        }
    }
}

/// Operation shape for `ResetEbsDefaultKmsKeyId`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_ebs_default_kms_key_id`](crate::client::Client::reset_ebs_default_kms_key_id).
///
/// See [`crate::client::fluent_builders::ResetEbsDefaultKmsKeyId`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetEbsDefaultKmsKeyId {
    _private: (),
}
impl ResetEbsDefaultKmsKeyId {
    /// Creates a new builder-style object to manufacture [`ResetEbsDefaultKmsKeyIdInput`](crate::input::ResetEbsDefaultKmsKeyIdInput)
    pub fn builder() -> crate::input::reset_ebs_default_kms_key_id_input::Builder {
        crate::input::reset_ebs_default_kms_key_id_input::Builder::default()
    }
    /// Creates a new `ResetEbsDefaultKmsKeyId` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetEbsDefaultKmsKeyId {
    type Output = std::result::Result<
        crate::output::ResetEbsDefaultKmsKeyIdOutput,
        crate::error::ResetEbsDefaultKmsKeyIdError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_ebs_default_kms_key_id_error(response)
        } else {
            crate::operation_deser::parse_reset_ebs_default_kms_key_id_response(response)
        }
    }
}

/// Operation shape for `ResetFpgaImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_fpga_image_attribute`](crate::client::Client::reset_fpga_image_attribute).
///
/// See [`crate::client::fluent_builders::ResetFpgaImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetFpgaImageAttribute {
    _private: (),
}
impl ResetFpgaImageAttribute {
    /// Creates a new builder-style object to manufacture [`ResetFpgaImageAttributeInput`](crate::input::ResetFpgaImageAttributeInput)
    pub fn builder() -> crate::input::reset_fpga_image_attribute_input::Builder {
        crate::input::reset_fpga_image_attribute_input::Builder::default()
    }
    /// Creates a new `ResetFpgaImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetFpgaImageAttribute {
    type Output = std::result::Result<
        crate::output::ResetFpgaImageAttributeOutput,
        crate::error::ResetFpgaImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_fpga_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_fpga_image_attribute_response(response)
        }
    }
}

/// Operation shape for `ResetImageAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_image_attribute`](crate::client::Client::reset_image_attribute).
///
/// See [`crate::client::fluent_builders::ResetImageAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetImageAttribute {
    _private: (),
}
impl ResetImageAttribute {
    /// Creates a new builder-style object to manufacture [`ResetImageAttributeInput`](crate::input::ResetImageAttributeInput)
    pub fn builder() -> crate::input::reset_image_attribute_input::Builder {
        crate::input::reset_image_attribute_input::Builder::default()
    }
    /// Creates a new `ResetImageAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetImageAttribute {
    type Output = std::result::Result<
        crate::output::ResetImageAttributeOutput,
        crate::error::ResetImageAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_image_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_image_attribute_response(response)
        }
    }
}

/// Operation shape for `ResetInstanceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_instance_attribute`](crate::client::Client::reset_instance_attribute).
///
/// See [`crate::client::fluent_builders::ResetInstanceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetInstanceAttribute {
    _private: (),
}
impl ResetInstanceAttribute {
    /// Creates a new builder-style object to manufacture [`ResetInstanceAttributeInput`](crate::input::ResetInstanceAttributeInput)
    pub fn builder() -> crate::input::reset_instance_attribute_input::Builder {
        crate::input::reset_instance_attribute_input::Builder::default()
    }
    /// Creates a new `ResetInstanceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetInstanceAttribute {
    type Output = std::result::Result<
        crate::output::ResetInstanceAttributeOutput,
        crate::error::ResetInstanceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_instance_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_instance_attribute_response(response)
        }
    }
}

/// Operation shape for `ResetNetworkInterfaceAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_network_interface_attribute`](crate::client::Client::reset_network_interface_attribute).
///
/// See [`crate::client::fluent_builders::ResetNetworkInterfaceAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetNetworkInterfaceAttribute {
    _private: (),
}
impl ResetNetworkInterfaceAttribute {
    /// Creates a new builder-style object to manufacture [`ResetNetworkInterfaceAttributeInput`](crate::input::ResetNetworkInterfaceAttributeInput)
    pub fn builder() -> crate::input::reset_network_interface_attribute_input::Builder {
        crate::input::reset_network_interface_attribute_input::Builder::default()
    }
    /// Creates a new `ResetNetworkInterfaceAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetNetworkInterfaceAttribute {
    type Output = std::result::Result<
        crate::output::ResetNetworkInterfaceAttributeOutput,
        crate::error::ResetNetworkInterfaceAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_network_interface_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_network_interface_attribute_response(response)
        }
    }
}

/// Operation shape for `ResetSnapshotAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_snapshot_attribute`](crate::client::Client::reset_snapshot_attribute).
///
/// See [`crate::client::fluent_builders::ResetSnapshotAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetSnapshotAttribute {
    _private: (),
}
impl ResetSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`ResetSnapshotAttributeInput`](crate::input::ResetSnapshotAttributeInput)
    pub fn builder() -> crate::input::reset_snapshot_attribute_input::Builder {
        crate::input::reset_snapshot_attribute_input::Builder::default()
    }
    /// Creates a new `ResetSnapshotAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetSnapshotAttribute {
    type Output = std::result::Result<
        crate::output::ResetSnapshotAttributeOutput,
        crate::error::ResetSnapshotAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_snapshot_attribute_error(response)
        } else {
            crate::operation_deser::parse_reset_snapshot_attribute_response(response)
        }
    }
}

/// Operation shape for `RestoreAddressToClassic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_address_to_classic`](crate::client::Client::restore_address_to_classic).
///
/// See [`crate::client::fluent_builders::RestoreAddressToClassic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreAddressToClassic {
    _private: (),
}
impl RestoreAddressToClassic {
    /// Creates a new builder-style object to manufacture [`RestoreAddressToClassicInput`](crate::input::RestoreAddressToClassicInput)
    pub fn builder() -> crate::input::restore_address_to_classic_input::Builder {
        crate::input::restore_address_to_classic_input::Builder::default()
    }
    /// Creates a new `RestoreAddressToClassic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreAddressToClassic {
    type Output = std::result::Result<
        crate::output::RestoreAddressToClassicOutput,
        crate::error::RestoreAddressToClassicError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_address_to_classic_error(response)
        } else {
            crate::operation_deser::parse_restore_address_to_classic_response(response)
        }
    }
}

/// Operation shape for `RestoreManagedPrefixListVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_managed_prefix_list_version`](crate::client::Client::restore_managed_prefix_list_version).
///
/// See [`crate::client::fluent_builders::RestoreManagedPrefixListVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreManagedPrefixListVersion {
    _private: (),
}
impl RestoreManagedPrefixListVersion {
    /// Creates a new builder-style object to manufacture [`RestoreManagedPrefixListVersionInput`](crate::input::RestoreManagedPrefixListVersionInput)
    pub fn builder() -> crate::input::restore_managed_prefix_list_version_input::Builder {
        crate::input::restore_managed_prefix_list_version_input::Builder::default()
    }
    /// Creates a new `RestoreManagedPrefixListVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreManagedPrefixListVersion {
    type Output = std::result::Result<
        crate::output::RestoreManagedPrefixListVersionOutput,
        crate::error::RestoreManagedPrefixListVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_managed_prefix_list_version_error(response)
        } else {
            crate::operation_deser::parse_restore_managed_prefix_list_version_response(response)
        }
    }
}

/// Operation shape for `RestoreSnapshotFromRecycleBin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_snapshot_from_recycle_bin`](crate::client::Client::restore_snapshot_from_recycle_bin).
///
/// See [`crate::client::fluent_builders::RestoreSnapshotFromRecycleBin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreSnapshotFromRecycleBin {
    _private: (),
}
impl RestoreSnapshotFromRecycleBin {
    /// Creates a new builder-style object to manufacture [`RestoreSnapshotFromRecycleBinInput`](crate::input::RestoreSnapshotFromRecycleBinInput)
    pub fn builder() -> crate::input::restore_snapshot_from_recycle_bin_input::Builder {
        crate::input::restore_snapshot_from_recycle_bin_input::Builder::default()
    }
    /// Creates a new `RestoreSnapshotFromRecycleBin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreSnapshotFromRecycleBin {
    type Output = std::result::Result<
        crate::output::RestoreSnapshotFromRecycleBinOutput,
        crate::error::RestoreSnapshotFromRecycleBinError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_snapshot_from_recycle_bin_error(response)
        } else {
            crate::operation_deser::parse_restore_snapshot_from_recycle_bin_response(response)
        }
    }
}

/// Operation shape for `RestoreSnapshotTier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_snapshot_tier`](crate::client::Client::restore_snapshot_tier).
///
/// See [`crate::client::fluent_builders::RestoreSnapshotTier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreSnapshotTier {
    _private: (),
}
impl RestoreSnapshotTier {
    /// Creates a new builder-style object to manufacture [`RestoreSnapshotTierInput`](crate::input::RestoreSnapshotTierInput)
    pub fn builder() -> crate::input::restore_snapshot_tier_input::Builder {
        crate::input::restore_snapshot_tier_input::Builder::default()
    }
    /// Creates a new `RestoreSnapshotTier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreSnapshotTier {
    type Output = std::result::Result<
        crate::output::RestoreSnapshotTierOutput,
        crate::error::RestoreSnapshotTierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_snapshot_tier_error(response)
        } else {
            crate::operation_deser::parse_restore_snapshot_tier_response(response)
        }
    }
}

/// Operation shape for `RevokeClientVpnIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_client_vpn_ingress`](crate::client::Client::revoke_client_vpn_ingress).
///
/// See [`crate::client::fluent_builders::RevokeClientVpnIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeClientVpnIngress {
    _private: (),
}
impl RevokeClientVpnIngress {
    /// Creates a new builder-style object to manufacture [`RevokeClientVpnIngressInput`](crate::input::RevokeClientVpnIngressInput)
    pub fn builder() -> crate::input::revoke_client_vpn_ingress_input::Builder {
        crate::input::revoke_client_vpn_ingress_input::Builder::default()
    }
    /// Creates a new `RevokeClientVpnIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeClientVpnIngress {
    type Output = std::result::Result<
        crate::output::RevokeClientVpnIngressOutput,
        crate::error::RevokeClientVpnIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_client_vpn_ingress_error(response)
        } else {
            crate::operation_deser::parse_revoke_client_vpn_ingress_response(response)
        }
    }
}

/// Operation shape for `RevokeSecurityGroupEgress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_security_group_egress`](crate::client::Client::revoke_security_group_egress).
///
/// See [`crate::client::fluent_builders::RevokeSecurityGroupEgress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeSecurityGroupEgress {
    _private: (),
}
impl RevokeSecurityGroupEgress {
    /// Creates a new builder-style object to manufacture [`RevokeSecurityGroupEgressInput`](crate::input::RevokeSecurityGroupEgressInput)
    pub fn builder() -> crate::input::revoke_security_group_egress_input::Builder {
        crate::input::revoke_security_group_egress_input::Builder::default()
    }
    /// Creates a new `RevokeSecurityGroupEgress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeSecurityGroupEgress {
    type Output = std::result::Result<
        crate::output::RevokeSecurityGroupEgressOutput,
        crate::error::RevokeSecurityGroupEgressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_security_group_egress_error(response)
        } else {
            crate::operation_deser::parse_revoke_security_group_egress_response(response)
        }
    }
}

/// Operation shape for `RevokeSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_security_group_ingress`](crate::client::Client::revoke_security_group_ingress).
///
/// See [`crate::client::fluent_builders::RevokeSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeSecurityGroupIngress {
    _private: (),
}
impl RevokeSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`RevokeSecurityGroupIngressInput`](crate::input::RevokeSecurityGroupIngressInput)
    pub fn builder() -> crate::input::revoke_security_group_ingress_input::Builder {
        crate::input::revoke_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `RevokeSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::RevokeSecurityGroupIngressOutput,
        crate::error::RevokeSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_revoke_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `RunInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`run_instances`](crate::client::Client::run_instances).
///
/// See [`crate::client::fluent_builders::RunInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RunInstances {
    _private: (),
}
impl RunInstances {
    /// Creates a new builder-style object to manufacture [`RunInstancesInput`](crate::input::RunInstancesInput)
    pub fn builder() -> crate::input::run_instances_input::Builder {
        crate::input::run_instances_input::Builder::default()
    }
    /// Creates a new `RunInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RunInstances {
    type Output =
        std::result::Result<crate::output::RunInstancesOutput, crate::error::RunInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_run_instances_error(response)
        } else {
            crate::operation_deser::parse_run_instances_response(response)
        }
    }
}

/// Operation shape for `RunScheduledInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`run_scheduled_instances`](crate::client::Client::run_scheduled_instances).
///
/// See [`crate::client::fluent_builders::RunScheduledInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RunScheduledInstances {
    _private: (),
}
impl RunScheduledInstances {
    /// Creates a new builder-style object to manufacture [`RunScheduledInstancesInput`](crate::input::RunScheduledInstancesInput)
    pub fn builder() -> crate::input::run_scheduled_instances_input::Builder {
        crate::input::run_scheduled_instances_input::Builder::default()
    }
    /// Creates a new `RunScheduledInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RunScheduledInstances {
    type Output = std::result::Result<
        crate::output::RunScheduledInstancesOutput,
        crate::error::RunScheduledInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_run_scheduled_instances_error(response)
        } else {
            crate::operation_deser::parse_run_scheduled_instances_response(response)
        }
    }
}

/// Operation shape for `SearchLocalGatewayRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_local_gateway_routes`](crate::client::Client::search_local_gateway_routes).
///
/// See [`crate::client::fluent_builders::SearchLocalGatewayRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchLocalGatewayRoutes {
    _private: (),
}
impl SearchLocalGatewayRoutes {
    /// Creates a new builder-style object to manufacture [`SearchLocalGatewayRoutesInput`](crate::input::SearchLocalGatewayRoutesInput)
    pub fn builder() -> crate::input::search_local_gateway_routes_input::Builder {
        crate::input::search_local_gateway_routes_input::Builder::default()
    }
    /// Creates a new `SearchLocalGatewayRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchLocalGatewayRoutes {
    type Output = std::result::Result<
        crate::output::SearchLocalGatewayRoutesOutput,
        crate::error::SearchLocalGatewayRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_local_gateway_routes_error(response)
        } else {
            crate::operation_deser::parse_search_local_gateway_routes_response(response)
        }
    }
}

/// Operation shape for `SearchTransitGatewayMulticastGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_transit_gateway_multicast_groups`](crate::client::Client::search_transit_gateway_multicast_groups).
///
/// See [`crate::client::fluent_builders::SearchTransitGatewayMulticastGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchTransitGatewayMulticastGroups {
    _private: (),
}
impl SearchTransitGatewayMulticastGroups {
    /// Creates a new builder-style object to manufacture [`SearchTransitGatewayMulticastGroupsInput`](crate::input::SearchTransitGatewayMulticastGroupsInput)
    pub fn builder() -> crate::input::search_transit_gateway_multicast_groups_input::Builder {
        crate::input::search_transit_gateway_multicast_groups_input::Builder::default()
    }
    /// Creates a new `SearchTransitGatewayMulticastGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchTransitGatewayMulticastGroups {
    type Output = std::result::Result<
        crate::output::SearchTransitGatewayMulticastGroupsOutput,
        crate::error::SearchTransitGatewayMulticastGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_transit_gateway_multicast_groups_error(response)
        } else {
            crate::operation_deser::parse_search_transit_gateway_multicast_groups_response(response)
        }
    }
}

/// Operation shape for `SearchTransitGatewayRoutes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_transit_gateway_routes`](crate::client::Client::search_transit_gateway_routes).
///
/// See [`crate::client::fluent_builders::SearchTransitGatewayRoutes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchTransitGatewayRoutes {
    _private: (),
}
impl SearchTransitGatewayRoutes {
    /// Creates a new builder-style object to manufacture [`SearchTransitGatewayRoutesInput`](crate::input::SearchTransitGatewayRoutesInput)
    pub fn builder() -> crate::input::search_transit_gateway_routes_input::Builder {
        crate::input::search_transit_gateway_routes_input::Builder::default()
    }
    /// Creates a new `SearchTransitGatewayRoutes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchTransitGatewayRoutes {
    type Output = std::result::Result<
        crate::output::SearchTransitGatewayRoutesOutput,
        crate::error::SearchTransitGatewayRoutesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_transit_gateway_routes_error(response)
        } else {
            crate::operation_deser::parse_search_transit_gateway_routes_response(response)
        }
    }
}

/// Operation shape for `SendDiagnosticInterrupt`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_diagnostic_interrupt`](crate::client::Client::send_diagnostic_interrupt).
///
/// See [`crate::client::fluent_builders::SendDiagnosticInterrupt`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendDiagnosticInterrupt {
    _private: (),
}
impl SendDiagnosticInterrupt {
    /// Creates a new builder-style object to manufacture [`SendDiagnosticInterruptInput`](crate::input::SendDiagnosticInterruptInput)
    pub fn builder() -> crate::input::send_diagnostic_interrupt_input::Builder {
        crate::input::send_diagnostic_interrupt_input::Builder::default()
    }
    /// Creates a new `SendDiagnosticInterrupt` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendDiagnosticInterrupt {
    type Output = std::result::Result<
        crate::output::SendDiagnosticInterruptOutput,
        crate::error::SendDiagnosticInterruptError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_diagnostic_interrupt_error(response)
        } else {
            crate::operation_deser::parse_send_diagnostic_interrupt_response(response)
        }
    }
}

/// Operation shape for `StartInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_instances`](crate::client::Client::start_instances).
///
/// See [`crate::client::fluent_builders::StartInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartInstances {
    _private: (),
}
impl StartInstances {
    /// Creates a new builder-style object to manufacture [`StartInstancesInput`](crate::input::StartInstancesInput)
    pub fn builder() -> crate::input::start_instances_input::Builder {
        crate::input::start_instances_input::Builder::default()
    }
    /// Creates a new `StartInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartInstances {
    type Output =
        std::result::Result<crate::output::StartInstancesOutput, crate::error::StartInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_instances_error(response)
        } else {
            crate::operation_deser::parse_start_instances_response(response)
        }
    }
}

/// Operation shape for `StartNetworkInsightsAccessScopeAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_network_insights_access_scope_analysis`](crate::client::Client::start_network_insights_access_scope_analysis).
///
/// See [`crate::client::fluent_builders::StartNetworkInsightsAccessScopeAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartNetworkInsightsAccessScopeAnalysis {
    _private: (),
}
impl StartNetworkInsightsAccessScopeAnalysis {
    /// Creates a new builder-style object to manufacture [`StartNetworkInsightsAccessScopeAnalysisInput`](crate::input::StartNetworkInsightsAccessScopeAnalysisInput)
    pub fn builder() -> crate::input::start_network_insights_access_scope_analysis_input::Builder {
        crate::input::start_network_insights_access_scope_analysis_input::Builder::default()
    }
    /// Creates a new `StartNetworkInsightsAccessScopeAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartNetworkInsightsAccessScopeAnalysis {
    type Output = std::result::Result<
        crate::output::StartNetworkInsightsAccessScopeAnalysisOutput,
        crate::error::StartNetworkInsightsAccessScopeAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_network_insights_access_scope_analysis_error(
                response,
            )
        } else {
            crate::operation_deser::parse_start_network_insights_access_scope_analysis_response(
                response,
            )
        }
    }
}

/// Operation shape for `StartNetworkInsightsAnalysis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_network_insights_analysis`](crate::client::Client::start_network_insights_analysis).
///
/// See [`crate::client::fluent_builders::StartNetworkInsightsAnalysis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartNetworkInsightsAnalysis {
    _private: (),
}
impl StartNetworkInsightsAnalysis {
    /// Creates a new builder-style object to manufacture [`StartNetworkInsightsAnalysisInput`](crate::input::StartNetworkInsightsAnalysisInput)
    pub fn builder() -> crate::input::start_network_insights_analysis_input::Builder {
        crate::input::start_network_insights_analysis_input::Builder::default()
    }
    /// Creates a new `StartNetworkInsightsAnalysis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartNetworkInsightsAnalysis {
    type Output = std::result::Result<
        crate::output::StartNetworkInsightsAnalysisOutput,
        crate::error::StartNetworkInsightsAnalysisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_network_insights_analysis_error(response)
        } else {
            crate::operation_deser::parse_start_network_insights_analysis_response(response)
        }
    }
}

/// Operation shape for `StartVpcEndpointServicePrivateDnsVerification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_vpc_endpoint_service_private_dns_verification`](crate::client::Client::start_vpc_endpoint_service_private_dns_verification).
///
/// See [`crate::client::fluent_builders::StartVpcEndpointServicePrivateDnsVerification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartVpcEndpointServicePrivateDnsVerification {
    _private: (),
}
impl StartVpcEndpointServicePrivateDnsVerification {
    /// Creates a new builder-style object to manufacture [`StartVpcEndpointServicePrivateDnsVerificationInput`](crate::input::StartVpcEndpointServicePrivateDnsVerificationInput)
    pub fn builder(
    ) -> crate::input::start_vpc_endpoint_service_private_dns_verification_input::Builder {
        crate::input::start_vpc_endpoint_service_private_dns_verification_input::Builder::default()
    }
    /// Creates a new `StartVpcEndpointServicePrivateDnsVerification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for StartVpcEndpointServicePrivateDnsVerification
{
    type Output = std::result::Result<
        crate::output::StartVpcEndpointServicePrivateDnsVerificationOutput,
        crate::error::StartVpcEndpointServicePrivateDnsVerificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_vpc_endpoint_service_private_dns_verification_error(
                response,
            )
        } else {
            crate::operation_deser::parse_start_vpc_endpoint_service_private_dns_verification_response(response)
        }
    }
}

/// Operation shape for `StopInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_instances`](crate::client::Client::stop_instances).
///
/// See [`crate::client::fluent_builders::StopInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopInstances {
    _private: (),
}
impl StopInstances {
    /// Creates a new builder-style object to manufacture [`StopInstancesInput`](crate::input::StopInstancesInput)
    pub fn builder() -> crate::input::stop_instances_input::Builder {
        crate::input::stop_instances_input::Builder::default()
    }
    /// Creates a new `StopInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopInstances {
    type Output =
        std::result::Result<crate::output::StopInstancesOutput, crate::error::StopInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_instances_error(response)
        } else {
            crate::operation_deser::parse_stop_instances_response(response)
        }
    }
}

/// Operation shape for `TerminateClientVpnConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_client_vpn_connections`](crate::client::Client::terminate_client_vpn_connections).
///
/// See [`crate::client::fluent_builders::TerminateClientVpnConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateClientVpnConnections {
    _private: (),
}
impl TerminateClientVpnConnections {
    /// Creates a new builder-style object to manufacture [`TerminateClientVpnConnectionsInput`](crate::input::TerminateClientVpnConnectionsInput)
    pub fn builder() -> crate::input::terminate_client_vpn_connections_input::Builder {
        crate::input::terminate_client_vpn_connections_input::Builder::default()
    }
    /// Creates a new `TerminateClientVpnConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateClientVpnConnections {
    type Output = std::result::Result<
        crate::output::TerminateClientVpnConnectionsOutput,
        crate::error::TerminateClientVpnConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_client_vpn_connections_error(response)
        } else {
            crate::operation_deser::parse_terminate_client_vpn_connections_response(response)
        }
    }
}

/// Operation shape for `TerminateInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`terminate_instances`](crate::client::Client::terminate_instances).
///
/// See [`crate::client::fluent_builders::TerminateInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TerminateInstances {
    _private: (),
}
impl TerminateInstances {
    /// Creates a new builder-style object to manufacture [`TerminateInstancesInput`](crate::input::TerminateInstancesInput)
    pub fn builder() -> crate::input::terminate_instances_input::Builder {
        crate::input::terminate_instances_input::Builder::default()
    }
    /// Creates a new `TerminateInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TerminateInstances {
    type Output = std::result::Result<
        crate::output::TerminateInstancesOutput,
        crate::error::TerminateInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_terminate_instances_error(response)
        } else {
            crate::operation_deser::parse_terminate_instances_response(response)
        }
    }
}

/// Operation shape for `UnassignIpv6Addresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unassign_ipv6_addresses`](crate::client::Client::unassign_ipv6_addresses).
///
/// See [`crate::client::fluent_builders::UnassignIpv6Addresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnassignIpv6Addresses {
    _private: (),
}
impl UnassignIpv6Addresses {
    /// Creates a new builder-style object to manufacture [`UnassignIpv6AddressesInput`](crate::input::UnassignIpv6AddressesInput)
    pub fn builder() -> crate::input::unassign_ipv6_addresses_input::Builder {
        crate::input::unassign_ipv6_addresses_input::Builder::default()
    }
    /// Creates a new `UnassignIpv6Addresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnassignIpv6Addresses {
    type Output = std::result::Result<
        crate::output::UnassignIpv6AddressesOutput,
        crate::error::UnassignIpv6AddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unassign_ipv6_addresses_error(response)
        } else {
            crate::operation_deser::parse_unassign_ipv6_addresses_response(response)
        }
    }
}

/// Operation shape for `UnassignPrivateIpAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unassign_private_ip_addresses`](crate::client::Client::unassign_private_ip_addresses).
///
/// See [`crate::client::fluent_builders::UnassignPrivateIpAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnassignPrivateIpAddresses {
    _private: (),
}
impl UnassignPrivateIpAddresses {
    /// Creates a new builder-style object to manufacture [`UnassignPrivateIpAddressesInput`](crate::input::UnassignPrivateIpAddressesInput)
    pub fn builder() -> crate::input::unassign_private_ip_addresses_input::Builder {
        crate::input::unassign_private_ip_addresses_input::Builder::default()
    }
    /// Creates a new `UnassignPrivateIpAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnassignPrivateIpAddresses {
    type Output = std::result::Result<
        crate::output::UnassignPrivateIpAddressesOutput,
        crate::error::UnassignPrivateIpAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unassign_private_ip_addresses_error(response)
        } else {
            crate::operation_deser::parse_unassign_private_ip_addresses_response(response)
        }
    }
}

/// Operation shape for `UnmonitorInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unmonitor_instances`](crate::client::Client::unmonitor_instances).
///
/// See [`crate::client::fluent_builders::UnmonitorInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnmonitorInstances {
    _private: (),
}
impl UnmonitorInstances {
    /// Creates a new builder-style object to manufacture [`UnmonitorInstancesInput`](crate::input::UnmonitorInstancesInput)
    pub fn builder() -> crate::input::unmonitor_instances_input::Builder {
        crate::input::unmonitor_instances_input::Builder::default()
    }
    /// Creates a new `UnmonitorInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnmonitorInstances {
    type Output = std::result::Result<
        crate::output::UnmonitorInstancesOutput,
        crate::error::UnmonitorInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unmonitor_instances_error(response)
        } else {
            crate::operation_deser::parse_unmonitor_instances_response(response)
        }
    }
}

/// Operation shape for `UpdateSecurityGroupRuleDescriptionsEgress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_security_group_rule_descriptions_egress`](crate::client::Client::update_security_group_rule_descriptions_egress).
///
/// See [`crate::client::fluent_builders::UpdateSecurityGroupRuleDescriptionsEgress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSecurityGroupRuleDescriptionsEgress {
    _private: (),
}
impl UpdateSecurityGroupRuleDescriptionsEgress {
    /// Creates a new builder-style object to manufacture [`UpdateSecurityGroupRuleDescriptionsEgressInput`](crate::input::UpdateSecurityGroupRuleDescriptionsEgressInput)
    pub fn builder() -> crate::input::update_security_group_rule_descriptions_egress_input::Builder
    {
        crate::input::update_security_group_rule_descriptions_egress_input::Builder::default()
    }
    /// Creates a new `UpdateSecurityGroupRuleDescriptionsEgress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSecurityGroupRuleDescriptionsEgress {
    type Output = std::result::Result<
        crate::output::UpdateSecurityGroupRuleDescriptionsEgressOutput,
        crate::error::UpdateSecurityGroupRuleDescriptionsEgressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_security_group_rule_descriptions_egress_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_security_group_rule_descriptions_egress_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateSecurityGroupRuleDescriptionsIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_security_group_rule_descriptions_ingress`](crate::client::Client::update_security_group_rule_descriptions_ingress).
///
/// See [`crate::client::fluent_builders::UpdateSecurityGroupRuleDescriptionsIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSecurityGroupRuleDescriptionsIngress {
    _private: (),
}
impl UpdateSecurityGroupRuleDescriptionsIngress {
    /// Creates a new builder-style object to manufacture [`UpdateSecurityGroupRuleDescriptionsIngressInput`](crate::input::UpdateSecurityGroupRuleDescriptionsIngressInput)
    pub fn builder() -> crate::input::update_security_group_rule_descriptions_ingress_input::Builder
    {
        crate::input::update_security_group_rule_descriptions_ingress_input::Builder::default()
    }
    /// Creates a new `UpdateSecurityGroupRuleDescriptionsIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSecurityGroupRuleDescriptionsIngress {
    type Output = std::result::Result<
        crate::output::UpdateSecurityGroupRuleDescriptionsIngressOutput,
        crate::error::UpdateSecurityGroupRuleDescriptionsIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_security_group_rule_descriptions_ingress_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_security_group_rule_descriptions_ingress_response(
                response,
            )
        }
    }
}

/// Operation shape for `WithdrawByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`withdraw_byoip_cidr`](crate::client::Client::withdraw_byoip_cidr).
///
/// See [`crate::client::fluent_builders::WithdrawByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct WithdrawByoipCidr {
    _private: (),
}
impl WithdrawByoipCidr {
    /// Creates a new builder-style object to manufacture [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
    pub fn builder() -> crate::input::withdraw_byoip_cidr_input::Builder {
        crate::input::withdraw_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `WithdrawByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for WithdrawByoipCidr {
    type Output = std::result::Result<
        crate::output::WithdrawByoipCidrOutput,
        crate::error::WithdrawByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_withdraw_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_withdraw_byoip_cidr_response(response)
        }
    }
}
