// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elastic Compute Cloud
///
/// Client for invoking operations on Amazon Elastic Compute Cloud. Each operation on Amazon Elastic Compute Cloud is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ec2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ec2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ec2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptReservedInstancesExchangeQuote`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`reserved_instance_ids(Vec<String>)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::reserved_instance_ids) / [`set_reserved_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::set_reserved_instance_ids): <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
    ///   - [`target_configurations(Vec<TargetConfigurationRequest>)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::target_configurations) / [`set_target_configurations(Option<Vec<TargetConfigurationRequest>>)`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote::set_target_configurations): <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
    /// - On success, responds with [`AcceptReservedInstancesExchangeQuoteOutput`](crate::output::AcceptReservedInstancesExchangeQuoteOutput) with field(s):
    ///   - [`exchange_id(Option<String>)`](crate::output::AcceptReservedInstancesExchangeQuoteOutput::exchange_id): <p>The ID of the successful exchange.</p>
    /// - On failure, responds with [`SdkError<AcceptReservedInstancesExchangeQuoteError>`](crate::error::AcceptReservedInstancesExchangeQuoteError)
    pub fn accept_reserved_instances_exchange_quote(
        &self,
    ) -> fluent_builders::AcceptReservedInstancesExchangeQuote<C, M, R> {
        fluent_builders::AcceptReservedInstancesExchangeQuote::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptTransitGatewayMulticastDomainAssociations`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_id(impl Into<String>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::transit_gateway_multicast_domain_id) / [`set_transit_gateway_multicast_domain_id(Option<String>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::set_transit_gateway_multicast_domain_id): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::set_transit_gateway_attachment_id): <p>The ID of the transit gateway attachment.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::set_subnet_ids): <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AcceptTransitGatewayMulticastDomainAssociationsOutput`](crate::output::AcceptTransitGatewayMulticastDomainAssociationsOutput) with field(s):
    ///   - [`associations(Option<TransitGatewayMulticastDomainAssociations>)`](crate::output::AcceptTransitGatewayMulticastDomainAssociationsOutput::associations): <p>Describes the multicast domain associations.</p>
    /// - On failure, responds with [`SdkError<AcceptTransitGatewayMulticastDomainAssociationsError>`](crate::error::AcceptTransitGatewayMulticastDomainAssociationsError)
    pub fn accept_transit_gateway_multicast_domain_associations(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayMulticastDomainAssociations<C, M, R> {
        fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptTransitGatewayPeeringAttachment`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment::set_transit_gateway_attachment_id): <p>The ID of the transit gateway attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AcceptTransitGatewayPeeringAttachmentOutput`](crate::output::AcceptTransitGatewayPeeringAttachmentOutput) with field(s):
    ///   - [`transit_gateway_peering_attachment(Option<TransitGatewayPeeringAttachment>)`](crate::output::AcceptTransitGatewayPeeringAttachmentOutput::transit_gateway_peering_attachment): <p>The transit gateway peering attachment.</p>
    /// - On failure, responds with [`SdkError<AcceptTransitGatewayPeeringAttachmentError>`](crate::error::AcceptTransitGatewayPeeringAttachmentError)
    pub fn accept_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::AcceptTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptTransitGatewayVpcAttachment`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment::set_transit_gateway_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AcceptTransitGatewayVpcAttachmentOutput`](crate::output::AcceptTransitGatewayVpcAttachmentOutput) with field(s):
    ///   - [`transit_gateway_vpc_attachment(Option<TransitGatewayVpcAttachment>)`](crate::output::AcceptTransitGatewayVpcAttachmentOutput::transit_gateway_vpc_attachment): <p>The VPC attachment.</p>
    /// - On failure, responds with [`SdkError<AcceptTransitGatewayVpcAttachmentError>`](crate::error::AcceptTransitGatewayVpcAttachmentError)
    pub fn accept_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::AcceptTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptVpcEndpointConnections`](crate::client::fluent_builders::AcceptVpcEndpointConnections) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::set_service_id): <p>The ID of the VPC endpoint service.</p>
    ///   - [`vpc_endpoint_ids(Vec<String>)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::vpc_endpoint_ids) / [`set_vpc_endpoint_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AcceptVpcEndpointConnections::set_vpc_endpoint_ids): <p>The IDs of one or more interface VPC endpoints.</p>
    /// - On success, responds with [`AcceptVpcEndpointConnectionsOutput`](crate::output::AcceptVpcEndpointConnectionsOutput) with field(s):
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::AcceptVpcEndpointConnectionsOutput::unsuccessful): <p>Information about the interface endpoints that were not accepted, if applicable.</p>
    /// - On failure, responds with [`SdkError<AcceptVpcEndpointConnectionsError>`](crate::error::AcceptVpcEndpointConnectionsError)
    pub fn accept_vpc_endpoint_connections(
        &self,
    ) -> fluent_builders::AcceptVpcEndpointConnections<C, M, R> {
        fluent_builders::AcceptVpcEndpointConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AcceptVpcPeeringConnection`](crate::client::fluent_builders::AcceptVpcPeeringConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AcceptVpcPeeringConnection::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AcceptVpcPeeringConnection::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_peering_connection_id(impl Into<String>)`](crate::client::fluent_builders::AcceptVpcPeeringConnection::vpc_peering_connection_id) / [`set_vpc_peering_connection_id(Option<String>)`](crate::client::fluent_builders::AcceptVpcPeeringConnection::set_vpc_peering_connection_id): <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
    /// - On success, responds with [`AcceptVpcPeeringConnectionOutput`](crate::output::AcceptVpcPeeringConnectionOutput) with field(s):
    ///   - [`vpc_peering_connection(Option<VpcPeeringConnection>)`](crate::output::AcceptVpcPeeringConnectionOutput::vpc_peering_connection): <p>Information about the VPC peering connection.</p>
    /// - On failure, responds with [`SdkError<AcceptVpcPeeringConnectionError>`](crate::error::AcceptVpcPeeringConnectionError)
    pub fn accept_vpc_peering_connection(
        &self,
    ) -> fluent_builders::AcceptVpcPeeringConnection<C, M, R> {
        fluent_builders::AcceptVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdvertiseByoipCidr`](crate::client::fluent_builders::AdvertiseByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::AdvertiseByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::AdvertiseByoipCidr::set_cidr): <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AdvertiseByoipCidr::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AdvertiseByoipCidr::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AdvertiseByoipCidrOutput`](crate::output::AdvertiseByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::AdvertiseByoipCidrOutput::byoip_cidr): <p>Information about the address range.</p>
    /// - On failure, responds with [`SdkError<AdvertiseByoipCidrError>`](crate::error::AdvertiseByoipCidrError)
    pub fn advertise_byoip_cidr(&self) -> fluent_builders::AdvertiseByoipCidr<C, M, R> {
        fluent_builders::AdvertiseByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateAddress`](crate::client::fluent_builders::AllocateAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(DomainType)`](crate::client::fluent_builders::AllocateAddress::domain) / [`set_domain(Option<DomainType>)`](crate::client::fluent_builders::AllocateAddress::set_domain): <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p>  <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
    ///   - [`address(impl Into<String>)`](crate::client::fluent_builders::AllocateAddress::address) / [`set_address(Option<String>)`](crate::client::fluent_builders::AllocateAddress::set_address): <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
    ///   - [`public_ipv4_pool(impl Into<String>)`](crate::client::fluent_builders::AllocateAddress::public_ipv4_pool) / [`set_public_ipv4_pool(Option<String>)`](crate::client::fluent_builders::AllocateAddress::set_public_ipv4_pool): <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
    ///   - [`network_border_group(impl Into<String>)`](crate::client::fluent_builders::AllocateAddress::network_border_group) / [`set_network_border_group(Option<String>)`](crate::client::fluent_builders::AllocateAddress::set_network_border_group): <p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p>  <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p>  <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an <code>InvalidParameterCombination</code> error.</p>
    ///   - [`customer_owned_ipv4_pool(impl Into<String>)`](crate::client::fluent_builders::AllocateAddress::customer_owned_ipv4_pool) / [`set_customer_owned_ipv4_pool(Option<String>)`](crate::client::fluent_builders::AllocateAddress::set_customer_owned_ipv4_pool): <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AllocateAddress::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AllocateAddress::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::AllocateAddress::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::AllocateAddress::set_tag_specifications): <p>The tags to assign to the Elastic IP address.</p>
    /// - On success, responds with [`AllocateAddressOutput`](crate::output::AllocateAddressOutput) with field(s):
    ///   - [`public_ip(Option<String>)`](crate::output::AllocateAddressOutput::public_ip): <p>The Elastic IP address.</p>
    ///   - [`allocation_id(Option<String>)`](crate::output::AllocateAddressOutput::allocation_id): <p>[EC2-VPC] The ID that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.</p>
    ///   - [`public_ipv4_pool(Option<String>)`](crate::output::AllocateAddressOutput::public_ipv4_pool): <p>The ID of an address pool.</p>
    ///   - [`network_border_group(Option<String>)`](crate::output::AllocateAddressOutput::network_border_group): <p>The set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses.</p>
    ///   - [`domain(Option<DomainType>)`](crate::output::AllocateAddressOutput::domain): <p>Indicates whether the Elastic IP address is for use with instances in a VPC (<code>vpc</code>) or instances in EC2-Classic (<code>standard</code>).</p>
    ///   - [`customer_owned_ip(Option<String>)`](crate::output::AllocateAddressOutput::customer_owned_ip): <p>The customer-owned IP address.</p>
    ///   - [`customer_owned_ipv4_pool(Option<String>)`](crate::output::AllocateAddressOutput::customer_owned_ipv4_pool): <p>The ID of the customer-owned address pool.</p>
    ///   - [`carrier_ip(Option<String>)`](crate::output::AllocateAddressOutput::carrier_ip): <p>The carrier IP address. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). </p>
    /// - On failure, responds with [`SdkError<AllocateAddressError>`](crate::error::AllocateAddressError)
    pub fn allocate_address(&self) -> fluent_builders::AllocateAddress<C, M, R> {
        fluent_builders::AllocateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateHosts`](crate::client::fluent_builders::AllocateHosts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_placement(AutoPlacement)`](crate::client::fluent_builders::AllocateHosts::auto_placement) / [`set_auto_placement(Option<AutoPlacement>)`](crate::client::fluent_builders::AllocateHosts::set_auto_placement): <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>  <p>Default: <code>on</code> </p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::AllocateHosts::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::AllocateHosts::set_availability_zone): <p>The Availability Zone in which to allocate the Dedicated Host.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AllocateHosts::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AllocateHosts::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::AllocateHosts::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::AllocateHosts::set_instance_type): <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p>  <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
    ///   - [`instance_family(impl Into<String>)`](crate::client::fluent_builders::AllocateHosts::instance_family) / [`set_instance_family(Option<String>)`](crate::client::fluent_builders::AllocateHosts::set_instance_family): <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p>  <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
    ///   - [`quantity(i32)`](crate::client::fluent_builders::AllocateHosts::quantity) / [`set_quantity(Option<i32>)`](crate::client::fluent_builders::AllocateHosts::set_quantity): <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::AllocateHosts::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::AllocateHosts::set_tag_specifications): <p>The tags to apply to the Dedicated Host during creation.</p>
    ///   - [`host_recovery(HostRecovery)`](crate::client::fluent_builders::AllocateHosts::host_recovery) / [`set_host_recovery(Option<HostRecovery>)`](crate::client::fluent_builders::AllocateHosts::set_host_recovery): <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>  <p>Default: <code>off</code> </p>
    /// - On success, responds with [`AllocateHostsOutput`](crate::output::AllocateHostsOutput) with field(s):
    ///   - [`host_ids(Option<Vec<String>>)`](crate::output::AllocateHostsOutput::host_ids): <p>The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.</p>
    /// - On failure, responds with [`SdkError<AllocateHostsError>`](crate::error::AllocateHostsError)
    pub fn allocate_hosts(&self) -> fluent_builders::AllocateHosts<C, M, R> {
        fluent_builders::AllocateHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllocateIpamPoolCidr`](crate::client::fluent_builders::AllocateIpamPoolCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AllocateIpamPoolCidr::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::ipam_pool_id) / [`set_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_ipam_pool_id): <p>The ID of the IPAM pool from which you would like to allocate a CIDR.</p>
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_cidr): <p>The CIDR you would like to allocate from the IPAM pool. Note the following:</p>  <ul>   <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>   <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>  </ul>  <p>Possible values: Any available IPv4 or IPv6 CIDR.</p>
    ///   - [`netmask_length(i32)`](crate::client::fluent_builders::AllocateIpamPoolCidr::netmask_length) / [`set_netmask_length(Option<i32>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_netmask_length): <p>The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>  <ul>   <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>   <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>  </ul>  <p>Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_description): <p>A description for the allocation.</p>
    ///   - [`preview_next_cidr(bool)`](crate::client::fluent_builders::AllocateIpamPoolCidr::preview_next_cidr) / [`set_preview_next_cidr(Option<bool>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_preview_next_cidr): <p>A preview of the next available CIDR in a pool.</p>
    ///   - [`disallowed_cidrs(Vec<String>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::disallowed_cidrs) / [`set_disallowed_cidrs(Option<Vec<String>>)`](crate::client::fluent_builders::AllocateIpamPoolCidr::set_disallowed_cidrs): <p>Exclude a particular CIDR range from being returned by the pool.</p>
    /// - On success, responds with [`AllocateIpamPoolCidrOutput`](crate::output::AllocateIpamPoolCidrOutput) with field(s):
    ///   - [`ipam_pool_allocation(Option<IpamPoolAllocation>)`](crate::output::AllocateIpamPoolCidrOutput::ipam_pool_allocation): <p>Information about the allocation created.</p>
    /// - On failure, responds with [`SdkError<AllocateIpamPoolCidrError>`](crate::error::AllocateIpamPoolCidrError)
    pub fn allocate_ipam_pool_cidr(&self) -> fluent_builders::AllocateIpamPoolCidr<C, M, R> {
        fluent_builders::AllocateIpamPoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplySecurityGroupsToClientVpnTargetNetwork`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::set_vpc_id): <p>The ID of the VPC in which the associated target network is located.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::set_security_group_ids): <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`ApplySecurityGroupsToClientVpnTargetNetworkOutput`](crate::output::ApplySecurityGroupsToClientVpnTargetNetworkOutput) with field(s):
    ///   - [`security_group_ids(Option<Vec<String>>)`](crate::output::ApplySecurityGroupsToClientVpnTargetNetworkOutput::security_group_ids): <p>The IDs of the applied security groups.</p>
    /// - On failure, responds with [`SdkError<ApplySecurityGroupsToClientVpnTargetNetworkError>`](crate::error::ApplySecurityGroupsToClientVpnTargetNetworkError)
    pub fn apply_security_groups_to_client_vpn_target_network(
        &self,
    ) -> fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork<C, M, R> {
        fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssignIpv6Addresses`](crate::client::fluent_builders::AssignIpv6Addresses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ipv6_address_count(i32)`](crate::client::fluent_builders::AssignIpv6Addresses::ipv6_address_count) / [`set_ipv6_address_count(Option<i32>)`](crate::client::fluent_builders::AssignIpv6Addresses::set_ipv6_address_count): <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
    ///   - [`ipv6_addresses(Vec<String>)`](crate::client::fluent_builders::AssignIpv6Addresses::ipv6_addresses) / [`set_ipv6_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::AssignIpv6Addresses::set_ipv6_addresses): <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
    ///   - [`ipv6_prefix_count(i32)`](crate::client::fluent_builders::AssignIpv6Addresses::ipv6_prefix_count) / [`set_ipv6_prefix_count(Option<i32>)`](crate::client::fluent_builders::AssignIpv6Addresses::set_ipv6_prefix_count): <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
    ///   - [`ipv6_prefixes(Vec<String>)`](crate::client::fluent_builders::AssignIpv6Addresses::ipv6_prefixes) / [`set_ipv6_prefixes(Option<Vec<String>>)`](crate::client::fluent_builders::AssignIpv6Addresses::set_ipv6_prefixes): <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssignIpv6Addresses::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::AssignIpv6Addresses::set_network_interface_id): <p>The ID of the network interface.</p>
    /// - On success, responds with [`AssignIpv6AddressesOutput`](crate::output::AssignIpv6AddressesOutput) with field(s):
    ///   - [`assigned_ipv6_addresses(Option<Vec<String>>)`](crate::output::AssignIpv6AddressesOutput::assigned_ipv6_addresses): <p>The new IPv6 addresses assigned to the network interface. Existing IPv6 addresses that were assigned to the network interface before the request are not included.</p>
    ///   - [`assigned_ipv6_prefixes(Option<Vec<String>>)`](crate::output::AssignIpv6AddressesOutput::assigned_ipv6_prefixes): <p>The IPv6 prefixes that are assigned to the network interface.</p>
    ///   - [`network_interface_id(Option<String>)`](crate::output::AssignIpv6AddressesOutput::network_interface_id): <p>The ID of the network interface.</p>
    /// - On failure, responds with [`SdkError<AssignIpv6AddressesError>`](crate::error::AssignIpv6AddressesError)
    pub fn assign_ipv6_addresses(&self) -> fluent_builders::AssignIpv6Addresses<C, M, R> {
        fluent_builders::AssignIpv6Addresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssignPrivateIpAddresses`](crate::client::fluent_builders::AssignPrivateIpAddresses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`allow_reassignment(bool)`](crate::client::fluent_builders::AssignPrivateIpAddresses::allow_reassignment) / [`set_allow_reassignment(Option<bool>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_allow_reassignment): <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_network_interface_id): <p>The ID of the network interface.</p>
    ///   - [`private_ip_addresses(Vec<String>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::private_ip_addresses) / [`set_private_ip_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_private_ip_addresses): <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p>  <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
    ///   - [`secondary_private_ip_address_count(i32)`](crate::client::fluent_builders::AssignPrivateIpAddresses::secondary_private_ip_address_count) / [`set_secondary_private_ip_address_count(Option<i32>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_secondary_private_ip_address_count): <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
    ///   - [`ipv4_prefixes(Vec<String>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::ipv4_prefixes) / [`set_ipv4_prefixes(Option<Vec<String>>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_ipv4_prefixes): <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
    ///   - [`ipv4_prefix_count(i32)`](crate::client::fluent_builders::AssignPrivateIpAddresses::ipv4_prefix_count) / [`set_ipv4_prefix_count(Option<i32>)`](crate::client::fluent_builders::AssignPrivateIpAddresses::set_ipv4_prefix_count): <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
    /// - On success, responds with [`AssignPrivateIpAddressesOutput`](crate::output::AssignPrivateIpAddressesOutput) with field(s):
    ///   - [`network_interface_id(Option<String>)`](crate::output::AssignPrivateIpAddressesOutput::network_interface_id): <p>The ID of the network interface.</p>
    ///   - [`assigned_private_ip_addresses(Option<Vec<AssignedPrivateIpAddress>>)`](crate::output::AssignPrivateIpAddressesOutput::assigned_private_ip_addresses): <p>The private IP addresses assigned to the network interface.</p>
    ///   - [`assigned_ipv4_prefixes(Option<Vec<Ipv4PrefixSpecification>>)`](crate::output::AssignPrivateIpAddressesOutput::assigned_ipv4_prefixes): <p>The IPv4 prefixes that are assigned to the network interface.</p>
    /// - On failure, responds with [`SdkError<AssignPrivateIpAddressesError>`](crate::error::AssignPrivateIpAddressesError)
    pub fn assign_private_ip_addresses(
        &self,
    ) -> fluent_builders::AssignPrivateIpAddresses<C, M, R> {
        fluent_builders::AssignPrivateIpAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateAddress`](crate::client::fluent_builders::AssociateAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`allocation_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAddress::allocation_id) / [`set_allocation_id(Option<String>)`](crate::client::fluent_builders::AssociateAddress::set_allocation_id): <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAddress::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateAddress::set_instance_id): <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
    ///   - [`public_ip(impl Into<String>)`](crate::client::fluent_builders::AssociateAddress::public_ip) / [`set_public_ip(Option<String>)`](crate::client::fluent_builders::AssociateAddress::set_public_ip): <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
    ///   - [`allow_reassociation(bool)`](crate::client::fluent_builders::AssociateAddress::allow_reassociation) / [`set_allow_reassociation(Option<bool>)`](crate::client::fluent_builders::AssociateAddress::set_allow_reassociation): <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateAddress::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateAddress::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAddress::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::AssociateAddress::set_network_interface_id): <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>  <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
    ///   - [`private_ip_address(impl Into<String>)`](crate::client::fluent_builders::AssociateAddress::private_ip_address) / [`set_private_ip_address(Option<String>)`](crate::client::fluent_builders::AssociateAddress::set_private_ip_address): <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
    /// - On success, responds with [`AssociateAddressOutput`](crate::output::AssociateAddressOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateAddressOutput::association_id): <p>[EC2-VPC] The ID that represents the association of the Elastic IP address with an instance.</p>
    /// - On failure, responds with [`SdkError<AssociateAddressError>`](crate::error::AssociateAddressError)
    pub fn associate_address(&self) -> fluent_builders::AssociateAddress<C, M, R> {
        fluent_builders::AssociateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateClientVpnTargetNetwork`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::set_subnet_id): <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateClientVpnTargetNetworkOutput`](crate::output::AssociateClientVpnTargetNetworkOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateClientVpnTargetNetworkOutput::association_id): <p>The unique ID of the target network association.</p>
    ///   - [`status(Option<AssociationStatus>)`](crate::output::AssociateClientVpnTargetNetworkOutput::status): <p>The current state of the target network association.</p>
    /// - On failure, responds with [`SdkError<AssociateClientVpnTargetNetworkError>`](crate::error::AssociateClientVpnTargetNetworkError)
    pub fn associate_client_vpn_target_network(
        &self,
    ) -> fluent_builders::AssociateClientVpnTargetNetwork<C, M, R> {
        fluent_builders::AssociateClientVpnTargetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateDhcpOptions`](crate::client::fluent_builders::AssociateDhcpOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dhcp_options_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDhcpOptions::dhcp_options_id) / [`set_dhcp_options_id(Option<String>)`](crate::client::fluent_builders::AssociateDhcpOptions::set_dhcp_options_id): <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDhcpOptions::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AssociateDhcpOptions::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateDhcpOptions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateDhcpOptions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateDhcpOptionsOutput`](crate::output::AssociateDhcpOptionsOutput)

    /// - On failure, responds with [`SdkError<AssociateDhcpOptionsError>`](crate::error::AssociateDhcpOptionsError)
    pub fn associate_dhcp_options(&self) -> fluent_builders::AssociateDhcpOptions<C, M, R> {
        fluent_builders::AssociateDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateEnclaveCertificateIamRole`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::set_certificate_arn): <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::set_role_arn): <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateEnclaveCertificateIamRoleOutput`](crate::output::AssociateEnclaveCertificateIamRoleOutput) with field(s):
    ///   - [`certificate_s3_bucket_name(Option<String>)`](crate::output::AssociateEnclaveCertificateIamRoleOutput::certificate_s3_bucket_name): <p>The name of the Amazon S3 bucket to which the certificate was uploaded.</p>
    ///   - [`certificate_s3_object_key(Option<String>)`](crate::output::AssociateEnclaveCertificateIamRoleOutput::certificate_s3_object_key): <p>The Amazon S3 object key where the certificate, certificate chain, and encrypted private key bundle are stored. The object key is formatted as follows: <code>role_arn</code>/<code>certificate_arn</code>.</p>
    ///   - [`encryption_kms_key_id(Option<String>)`](crate::output::AssociateEnclaveCertificateIamRoleOutput::encryption_kms_key_id): <p>The ID of the KMS key used to encrypt the private key of the certificate.</p>
    /// - On failure, responds with [`SdkError<AssociateEnclaveCertificateIamRoleError>`](crate::error::AssociateEnclaveCertificateIamRoleError)
    pub fn associate_enclave_certificate_iam_role(
        &self,
    ) -> fluent_builders::AssociateEnclaveCertificateIamRole<C, M, R> {
        fluent_builders::AssociateEnclaveCertificateIamRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateIamInstanceProfile`](crate::client::fluent_builders::AssociateIamInstanceProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`iam_instance_profile(IamInstanceProfileSpecification)`](crate::client::fluent_builders::AssociateIamInstanceProfile::iam_instance_profile) / [`set_iam_instance_profile(Option<IamInstanceProfileSpecification>)`](crate::client::fluent_builders::AssociateIamInstanceProfile::set_iam_instance_profile): <p>The IAM instance profile.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateIamInstanceProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateIamInstanceProfile::set_instance_id): <p>The ID of the instance.</p>
    /// - On success, responds with [`AssociateIamInstanceProfileOutput`](crate::output::AssociateIamInstanceProfileOutput) with field(s):
    ///   - [`iam_instance_profile_association(Option<IamInstanceProfileAssociation>)`](crate::output::AssociateIamInstanceProfileOutput::iam_instance_profile_association): <p>Information about the IAM instance profile association.</p>
    /// - On failure, responds with [`SdkError<AssociateIamInstanceProfileError>`](crate::error::AssociateIamInstanceProfileError)
    pub fn associate_iam_instance_profile(
        &self,
    ) -> fluent_builders::AssociateIamInstanceProfile<C, M, R> {
        fluent_builders::AssociateIamInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateInstanceEventWindow`](crate::client::fluent_builders::AssociateInstanceEventWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateInstanceEventWindow::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateInstanceEventWindow::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_event_window_id(impl Into<String>)`](crate::client::fluent_builders::AssociateInstanceEventWindow::instance_event_window_id) / [`set_instance_event_window_id(Option<String>)`](crate::client::fluent_builders::AssociateInstanceEventWindow::set_instance_event_window_id): <p>The ID of the event window.</p>
    ///   - [`association_target(InstanceEventWindowAssociationRequest)`](crate::client::fluent_builders::AssociateInstanceEventWindow::association_target) / [`set_association_target(Option<InstanceEventWindowAssociationRequest>)`](crate::client::fluent_builders::AssociateInstanceEventWindow::set_association_target): <p>One or more targets associated with the specified event window.</p>
    /// - On success, responds with [`AssociateInstanceEventWindowOutput`](crate::output::AssociateInstanceEventWindowOutput) with field(s):
    ///   - [`instance_event_window(Option<InstanceEventWindow>)`](crate::output::AssociateInstanceEventWindowOutput::instance_event_window): <p>Information about the event window.</p>
    /// - On failure, responds with [`SdkError<AssociateInstanceEventWindowError>`](crate::error::AssociateInstanceEventWindowError)
    pub fn associate_instance_event_window(
        &self,
    ) -> fluent_builders::AssociateInstanceEventWindow<C, M, R> {
        fluent_builders::AssociateInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateRouteTable`](crate::client::fluent_builders::AssociateRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`route_table_id(impl Into<String>)`](crate::client::fluent_builders::AssociateRouteTable::route_table_id) / [`set_route_table_id(Option<String>)`](crate::client::fluent_builders::AssociateRouteTable::set_route_table_id): <p>The ID of the route table.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::AssociateRouteTable::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::AssociateRouteTable::set_subnet_id): <p>The ID of the subnet.</p>
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::AssociateRouteTable::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::AssociateRouteTable::set_gateway_id): <p>The ID of the internet gateway or virtual private gateway.</p>
    /// - On success, responds with [`AssociateRouteTableOutput`](crate::output::AssociateRouteTableOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateRouteTableOutput::association_id): <p>The route table association ID. This ID is required for disassociating the route table.</p>
    ///   - [`association_state(Option<RouteTableAssociationState>)`](crate::output::AssociateRouteTableOutput::association_state): <p>The state of the association.</p>
    /// - On failure, responds with [`SdkError<AssociateRouteTableError>`](crate::error::AssociateRouteTableError)
    pub fn associate_route_table(&self) -> fluent_builders::AssociateRouteTable<C, M, R> {
        fluent_builders::AssociateRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateSubnetCidrBlock`](crate::client::fluent_builders::AssociateSubnetCidrBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::AssociateSubnetCidrBlock::ipv6_cidr_block) / [`set_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::AssociateSubnetCidrBlock::set_ipv6_cidr_block): <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::AssociateSubnetCidrBlock::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::AssociateSubnetCidrBlock::set_subnet_id): <p>The ID of your subnet.</p>
    /// - On success, responds with [`AssociateSubnetCidrBlockOutput`](crate::output::AssociateSubnetCidrBlockOutput) with field(s):
    ///   - [`ipv6_cidr_block_association(Option<SubnetIpv6CidrBlockAssociation>)`](crate::output::AssociateSubnetCidrBlockOutput::ipv6_cidr_block_association): <p>Information about the IPv6 association.</p>
    ///   - [`subnet_id(Option<String>)`](crate::output::AssociateSubnetCidrBlockOutput::subnet_id): <p>The ID of the subnet.</p>
    /// - On failure, responds with [`SdkError<AssociateSubnetCidrBlockError>`](crate::error::AssociateSubnetCidrBlockError)
    pub fn associate_subnet_cidr_block(
        &self,
    ) -> fluent_builders::AssociateSubnetCidrBlock<C, M, R> {
        fluent_builders::AssociateSubnetCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTransitGatewayMulticastDomain`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::transit_gateway_multicast_domain_id) / [`set_transit_gateway_multicast_domain_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::set_transit_gateway_multicast_domain_id): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::set_transit_gateway_attachment_id): <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::set_subnet_ids): <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateTransitGatewayMulticastDomainOutput`](crate::output::AssociateTransitGatewayMulticastDomainOutput) with field(s):
    ///   - [`associations(Option<TransitGatewayMulticastDomainAssociations>)`](crate::output::AssociateTransitGatewayMulticastDomainOutput::associations): <p>Information about the transit gateway multicast domain associations.</p>
    /// - On failure, responds with [`SdkError<AssociateTransitGatewayMulticastDomainError>`](crate::error::AssociateTransitGatewayMulticastDomainError)
    pub fn associate_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::AssociateTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTransitGatewayRouteTable`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::set_transit_gateway_route_table_id): <p>The ID of the transit gateway route table.</p>
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::set_transit_gateway_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateTransitGatewayRouteTableOutput`](crate::output::AssociateTransitGatewayRouteTableOutput) with field(s):
    ///   - [`association(Option<TransitGatewayAssociation>)`](crate::output::AssociateTransitGatewayRouteTableOutput::association): <p>The ID of the association.</p>
    /// - On failure, responds with [`SdkError<AssociateTransitGatewayRouteTableError>`](crate::error::AssociateTransitGatewayRouteTableError)
    pub fn associate_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayRouteTable<C, M, R> {
        fluent_builders::AssociateTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateTrunkInterface`](crate::client::fluent_builders::AssociateTrunkInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`branch_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::branch_interface_id) / [`set_branch_interface_id(Option<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_branch_interface_id): <p>The ID of the branch network interface.</p>
    ///   - [`trunk_interface_id(impl Into<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::trunk_interface_id) / [`set_trunk_interface_id(Option<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_trunk_interface_id): <p>The ID of the trunk network interface.</p>
    ///   - [`vlan_id(i32)`](crate::client::fluent_builders::AssociateTrunkInterface::vlan_id) / [`set_vlan_id(Option<i32>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_vlan_id): <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
    ///   - [`gre_key(i32)`](crate::client::fluent_builders::AssociateTrunkInterface::gre_key) / [`set_gre_key(Option<i32>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_gre_key): <p>The application key. This applies to the GRE protocol.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AssociateTrunkInterface::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AssociateTrunkInterface::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AssociateTrunkInterfaceOutput`](crate::output::AssociateTrunkInterfaceOutput) with field(s):
    ///   - [`interface_association(Option<TrunkInterfaceAssociation>)`](crate::output::AssociateTrunkInterfaceOutput::interface_association): <p>Information about the association between the trunk network interface and branch network interface.</p>
    ///   - [`client_token(Option<String>)`](crate::output::AssociateTrunkInterfaceOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
    /// - On failure, responds with [`SdkError<AssociateTrunkInterfaceError>`](crate::error::AssociateTrunkInterfaceError)
    pub fn associate_trunk_interface(&self) -> fluent_builders::AssociateTrunkInterface<C, M, R> {
        fluent_builders::AssociateTrunkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateVpcCidrBlock`](crate::client::fluent_builders::AssociateVpcCidrBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`amazon_provided_ipv6_cidr_block(bool)`](crate::client::fluent_builders::AssociateVpcCidrBlock::amazon_provided_ipv6_cidr_block) / [`set_amazon_provided_ipv6_cidr_block(Option<bool>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_amazon_provided_ipv6_cidr_block): <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
    ///   - [`cidr_block(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::cidr_block) / [`set_cidr_block(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_cidr_block): <p>An IPv4 CIDR block to associate with the VPC.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`ipv6_cidr_block_network_border_group(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv6_cidr_block_network_border_group) / [`set_ipv6_cidr_block_network_border_group(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv6_cidr_block_network_border_group): <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p>  <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>  <p> You can have one IPv6 CIDR block association per network border group.</p>
    ///   - [`ipv6_pool(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv6_pool) / [`set_ipv6_pool(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv6_pool): <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
    ///   - [`ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv6_cidr_block) / [`set_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv6_cidr_block): <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>  <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
    ///   - [`ipv4_ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv4_ipam_pool_id) / [`set_ipv4_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv4_ipam_pool_id): <p>Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    ///   - [`ipv4_netmask_length(i32)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv4_netmask_length) / [`set_ipv4_netmask_length(Option<i32>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv4_netmask_length): <p>The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    ///   - [`ipv6_ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv6_ipam_pool_id) / [`set_ipv6_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv6_ipam_pool_id): <p>Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    ///   - [`ipv6_netmask_length(i32)`](crate::client::fluent_builders::AssociateVpcCidrBlock::ipv6_netmask_length) / [`set_ipv6_netmask_length(Option<i32>)`](crate::client::fluent_builders::AssociateVpcCidrBlock::set_ipv6_netmask_length): <p>The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    /// - On success, responds with [`AssociateVpcCidrBlockOutput`](crate::output::AssociateVpcCidrBlockOutput) with field(s):
    ///   - [`ipv6_cidr_block_association(Option<VpcIpv6CidrBlockAssociation>)`](crate::output::AssociateVpcCidrBlockOutput::ipv6_cidr_block_association): <p>Information about the IPv6 CIDR block association.</p>
    ///   - [`cidr_block_association(Option<VpcCidrBlockAssociation>)`](crate::output::AssociateVpcCidrBlockOutput::cidr_block_association): <p>Information about the IPv4 CIDR block association.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::AssociateVpcCidrBlockOutput::vpc_id): <p>The ID of the VPC.</p>
    /// - On failure, responds with [`SdkError<AssociateVpcCidrBlockError>`](crate::error::AssociateVpcCidrBlockError)
    pub fn associate_vpc_cidr_block(&self) -> fluent_builders::AssociateVpcCidrBlock<C, M, R> {
        fluent_builders::AssociateVpcCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachClassicLinkVpc`](crate::client::fluent_builders::AttachClassicLinkVpc) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AttachClassicLinkVpc::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AttachClassicLinkVpc::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`groups(Vec<String>)`](crate::client::fluent_builders::AttachClassicLinkVpc::groups) / [`set_groups(Option<Vec<String>>)`](crate::client::fluent_builders::AttachClassicLinkVpc::set_groups): <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AttachClassicLinkVpc::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AttachClassicLinkVpc::set_instance_id): <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AttachClassicLinkVpc::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AttachClassicLinkVpc::set_vpc_id): <p>The ID of a ClassicLink-enabled VPC.</p>
    /// - On success, responds with [`AttachClassicLinkVpcOutput`](crate::output::AttachClassicLinkVpcOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::AttachClassicLinkVpcOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    /// - On failure, responds with [`SdkError<AttachClassicLinkVpcError>`](crate::error::AttachClassicLinkVpcError)
    pub fn attach_classic_link_vpc(&self) -> fluent_builders::AttachClassicLinkVpc<C, M, R> {
        fluent_builders::AttachClassicLinkVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachInternetGateway`](crate::client::fluent_builders::AttachInternetGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AttachInternetGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AttachInternetGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`internet_gateway_id(impl Into<String>)`](crate::client::fluent_builders::AttachInternetGateway::internet_gateway_id) / [`set_internet_gateway_id(Option<String>)`](crate::client::fluent_builders::AttachInternetGateway::set_internet_gateway_id): <p>The ID of the internet gateway.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AttachInternetGateway::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AttachInternetGateway::set_vpc_id): <p>The ID of the VPC.</p>
    /// - On success, responds with [`AttachInternetGatewayOutput`](crate::output::AttachInternetGatewayOutput)

    /// - On failure, responds with [`SdkError<AttachInternetGatewayError>`](crate::error::AttachInternetGatewayError)
    pub fn attach_internet_gateway(&self) -> fluent_builders::AttachInternetGateway<C, M, R> {
        fluent_builders::AttachInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachNetworkInterface`](crate::client::fluent_builders::AttachNetworkInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_index(i32)`](crate::client::fluent_builders::AttachNetworkInterface::device_index) / [`set_device_index(Option<i32>)`](crate::client::fluent_builders::AttachNetworkInterface::set_device_index): <p>The index of the device for the network interface attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AttachNetworkInterface::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AttachNetworkInterface::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AttachNetworkInterface::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AttachNetworkInterface::set_instance_id): <p>The ID of the instance.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::AttachNetworkInterface::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::AttachNetworkInterface::set_network_interface_id): <p>The ID of the network interface.</p>
    ///   - [`network_card_index(i32)`](crate::client::fluent_builders::AttachNetworkInterface::network_card_index) / [`set_network_card_index(Option<i32>)`](crate::client::fluent_builders::AttachNetworkInterface::set_network_card_index): <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
    /// - On success, responds with [`AttachNetworkInterfaceOutput`](crate::output::AttachNetworkInterfaceOutput) with field(s):
    ///   - [`attachment_id(Option<String>)`](crate::output::AttachNetworkInterfaceOutput::attachment_id): <p>The ID of the network interface attachment.</p>
    ///   - [`network_card_index(Option<i32>)`](crate::output::AttachNetworkInterfaceOutput::network_card_index): <p>The index of the network card.</p>
    /// - On failure, responds with [`SdkError<AttachNetworkInterfaceError>`](crate::error::AttachNetworkInterfaceError)
    pub fn attach_network_interface(&self) -> fluent_builders::AttachNetworkInterface<C, M, R> {
        fluent_builders::AttachNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachVolume`](crate::client::fluent_builders::AttachVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::device) / [`set_device(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_device): <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_instance_id): <p>The ID of the instance.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::AttachVolume::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::AttachVolume::set_volume_id): <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AttachVolume::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AttachVolume::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AttachVolumeOutput`](crate::output::AttachVolumeOutput) with field(s):
    ///   - [`attach_time(Option<DateTime>)`](crate::output::AttachVolumeOutput::attach_time): <p>The time stamp when the attachment initiated.</p>
    ///   - [`device(Option<String>)`](crate::output::AttachVolumeOutput::device): <p>The device name.</p>
    ///   - [`instance_id(Option<String>)`](crate::output::AttachVolumeOutput::instance_id): <p>The ID of the instance.</p>
    ///   - [`state(Option<VolumeAttachmentState>)`](crate::output::AttachVolumeOutput::state): <p>The attachment state of the volume.</p>
    ///   - [`volume_id(Option<String>)`](crate::output::AttachVolumeOutput::volume_id): <p>The ID of the volume.</p>
    ///   - [`delete_on_termination(Option<bool>)`](crate::output::AttachVolumeOutput::delete_on_termination): <p>Indicates whether the EBS volume is deleted on instance termination.</p>
    /// - On failure, responds with [`SdkError<AttachVolumeError>`](crate::error::AttachVolumeError)
    pub fn attach_volume(&self) -> fluent_builders::AttachVolume<C, M, R> {
        fluent_builders::AttachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AttachVpnGateway`](crate::client::fluent_builders::AttachVpnGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AttachVpnGateway::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AttachVpnGateway::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`vpn_gateway_id(impl Into<String>)`](crate::client::fluent_builders::AttachVpnGateway::vpn_gateway_id) / [`set_vpn_gateway_id(Option<String>)`](crate::client::fluent_builders::AttachVpnGateway::set_vpn_gateway_id): <p>The ID of the virtual private gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AttachVpnGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AttachVpnGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AttachVpnGatewayOutput`](crate::output::AttachVpnGatewayOutput) with field(s):
    ///   - [`vpc_attachment(Option<VpcAttachment>)`](crate::output::AttachVpnGatewayOutput::vpc_attachment): <p>Information about the attachment.</p>
    /// - On failure, responds with [`SdkError<AttachVpnGatewayError>`](crate::error::AttachVpnGatewayError)
    pub fn attach_vpn_gateway(&self) -> fluent_builders::AttachVpnGateway<C, M, R> {
        fluent_builders::AttachVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeClientVpnIngress`](crate::client::fluent_builders::AuthorizeClientVpnIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`target_network_cidr(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::target_network_cidr) / [`set_target_network_cidr(Option<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_target_network_cidr): <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
    ///   - [`access_group_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::access_group_id) / [`set_access_group_id(Option<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_access_group_id): <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
    ///   - [`authorize_all_groups(bool)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::authorize_all_groups) / [`set_authorize_all_groups(Option<bool>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_authorize_all_groups): <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_description): <p>A brief description of the authorization rule.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AuthorizeClientVpnIngress::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`AuthorizeClientVpnIngressOutput`](crate::output::AuthorizeClientVpnIngressOutput) with field(s):
    ///   - [`status(Option<ClientVpnAuthorizationRuleStatus>)`](crate::output::AuthorizeClientVpnIngressOutput::status): <p>The current state of the authorization rule.</p>
    /// - On failure, responds with [`SdkError<AuthorizeClientVpnIngressError>`](crate::error::AuthorizeClientVpnIngressError)
    pub fn authorize_client_vpn_ingress(
        &self,
    ) -> fluent_builders::AuthorizeClientVpnIngress<C, M, R> {
        fluent_builders::AuthorizeClientVpnIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeSecurityGroupEgress`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_group_id): <p>The ID of the security group.</p>
    ///   - [`ip_permissions(Vec<IpPermission>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::ip_permissions) / [`set_ip_permissions(Option<Vec<IpPermission>>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_ip_permissions): <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_tag_specifications): <p>The tags applied to the security group rule.</p>
    ///   - [`cidr_ip(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::cidr_ip) / [`set_cidr_ip(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_cidr_ip): <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
    ///   - [`from_port(i32)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::from_port) / [`set_from_port(Option<i32>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_from_port): <p>Not supported. Use a set of IP permissions to specify the port.</p>
    ///   - [`ip_protocol(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::ip_protocol) / [`set_ip_protocol(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_ip_protocol): <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
    ///   - [`to_port(i32)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::to_port) / [`set_to_port(Option<i32>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_to_port): <p>Not supported. Use a set of IP permissions to specify the port.</p>
    ///   - [`source_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::source_security_group_name) / [`set_source_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_source_security_group_name): <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
    ///   - [`source_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::source_security_group_owner_id) / [`set_source_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress::set_source_security_group_owner_id): <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
    /// - On success, responds with [`AuthorizeSecurityGroupEgressOutput`](crate::output::AuthorizeSecurityGroupEgressOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::AuthorizeSecurityGroupEgressOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
    ///   - [`security_group_rules(Option<Vec<SecurityGroupRule>>)`](crate::output::AuthorizeSecurityGroupEgressOutput::security_group_rules): <p>Information about the outbound (egress) security group rules that were added.</p>
    /// - On failure, responds with [`SdkError<AuthorizeSecurityGroupEgressError>`](crate::error::AuthorizeSecurityGroupEgressError)
    pub fn authorize_security_group_egress(
        &self,
    ) -> fluent_builders::AuthorizeSecurityGroupEgress<C, M, R> {
        fluent_builders::AuthorizeSecurityGroupEgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr_ip(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::cidr_ip) / [`set_cidr_ip(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_cidr_ip): <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p>  <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    ///   - [`from_port(i32)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::from_port) / [`set_from_port(Option<i32>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_from_port): <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p>  <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_group_id): <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_group_name): <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
    ///   - [`ip_permissions(Vec<IpPermission>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::ip_permissions) / [`set_ip_permissions(Option<Vec<IpPermission>>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_ip_permissions): <p>The sets of IP permissions.</p>
    ///   - [`ip_protocol(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::ip_protocol) / [`set_ip_protocol(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_ip_protocol): <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p>  <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>  <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    ///   - [`source_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::source_security_group_name) / [`set_source_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_source_security_group_name): <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
    ///   - [`source_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::source_security_group_owner_id) / [`set_source_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_source_security_group_owner_id): <p>[nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
    ///   - [`to_port(i32)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::to_port) / [`set_to_port(Option<i32>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_to_port): <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p>  <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress::set_tag_specifications): <p>[VPC Only] The tags applied to the security group rule.</p>
    /// - On success, responds with [`AuthorizeSecurityGroupIngressOutput`](crate::output::AuthorizeSecurityGroupIngressOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::AuthorizeSecurityGroupIngressOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>
    ///   - [`security_group_rules(Option<Vec<SecurityGroupRule>>)`](crate::output::AuthorizeSecurityGroupIngressOutput::security_group_rules): <p>Information about the inbound (ingress) security group rules that were added.</p>
    /// - On failure, responds with [`SdkError<AuthorizeSecurityGroupIngressError>`](crate::error::AuthorizeSecurityGroupIngressError)
    pub fn authorize_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeSecurityGroupIngress<C, M, R> {
        fluent_builders::AuthorizeSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BundleInstance`](crate::client::fluent_builders::BundleInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::BundleInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::BundleInstance::set_instance_id): <p>The ID of the instance to bundle.</p>  <p>Type: String</p>  <p>Default: None</p>  <p>Required: Yes</p>
    ///   - [`storage(Storage)`](crate::client::fluent_builders::BundleInstance::storage) / [`set_storage(Option<Storage>)`](crate::client::fluent_builders::BundleInstance::set_storage): <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::BundleInstance::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::BundleInstance::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`BundleInstanceOutput`](crate::output::BundleInstanceOutput) with field(s):
    ///   - [`bundle_task(Option<BundleTask>)`](crate::output::BundleInstanceOutput::bundle_task): <p>Information about the bundle task.</p>
    /// - On failure, responds with [`SdkError<BundleInstanceError>`](crate::error::BundleInstanceError)
    pub fn bundle_instance(&self) -> fluent_builders::BundleInstance<C, M, R> {
        fluent_builders::BundleInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelBundleTask`](crate::client::fluent_builders::CancelBundleTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_id(impl Into<String>)`](crate::client::fluent_builders::CancelBundleTask::bundle_id) / [`set_bundle_id(Option<String>)`](crate::client::fluent_builders::CancelBundleTask::set_bundle_id): <p>The ID of the bundle task.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelBundleTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelBundleTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CancelBundleTaskOutput`](crate::output::CancelBundleTaskOutput) with field(s):
    ///   - [`bundle_task(Option<BundleTask>)`](crate::output::CancelBundleTaskOutput::bundle_task): <p>Information about the bundle task.</p>
    /// - On failure, responds with [`SdkError<CancelBundleTaskError>`](crate::error::CancelBundleTaskError)
    pub fn cancel_bundle_task(&self) -> fluent_builders::CancelBundleTask<C, M, R> {
        fluent_builders::CancelBundleTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelCapacityReservation`](crate::client::fluent_builders::CancelCapacityReservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_reservation_id(impl Into<String>)`](crate::client::fluent_builders::CancelCapacityReservation::capacity_reservation_id) / [`set_capacity_reservation_id(Option<String>)`](crate::client::fluent_builders::CancelCapacityReservation::set_capacity_reservation_id): <p>The ID of the Capacity Reservation to be cancelled.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelCapacityReservation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelCapacityReservation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CancelCapacityReservationOutput`](crate::output::CancelCapacityReservationOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::CancelCapacityReservationOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    /// - On failure, responds with [`SdkError<CancelCapacityReservationError>`](crate::error::CancelCapacityReservationError)
    pub fn cancel_capacity_reservation(
        &self,
    ) -> fluent_builders::CancelCapacityReservation<C, M, R> {
        fluent_builders::CancelCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelCapacityReservationFleets`](crate::client::fluent_builders::CancelCapacityReservationFleets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelCapacityReservationFleets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelCapacityReservationFleets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`capacity_reservation_fleet_ids(Vec<String>)`](crate::client::fluent_builders::CancelCapacityReservationFleets::capacity_reservation_fleet_ids) / [`set_capacity_reservation_fleet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CancelCapacityReservationFleets::set_capacity_reservation_fleet_ids): <p>The IDs of the Capacity Reservation Fleets to cancel.</p>
    /// - On success, responds with [`CancelCapacityReservationFleetsOutput`](crate::output::CancelCapacityReservationFleetsOutput) with field(s):
    ///   - [`successful_fleet_cancellations(Option<Vec<CapacityReservationFleetCancellationState>>)`](crate::output::CancelCapacityReservationFleetsOutput::successful_fleet_cancellations): <p>Information about the Capacity Reservation Fleets that were successfully cancelled.</p>
    ///   - [`failed_fleet_cancellations(Option<Vec<FailedCapacityReservationFleetCancellationResult>>)`](crate::output::CancelCapacityReservationFleetsOutput::failed_fleet_cancellations): <p>Information about the Capacity Reservation Fleets that could not be cancelled.</p>
    /// - On failure, responds with [`SdkError<CancelCapacityReservationFleetsError>`](crate::error::CancelCapacityReservationFleetsError)
    pub fn cancel_capacity_reservation_fleets(
        &self,
    ) -> fluent_builders::CancelCapacityReservationFleets<C, M, R> {
        fluent_builders::CancelCapacityReservationFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelConversionTask`](crate::client::fluent_builders::CancelConversionTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`conversion_task_id(impl Into<String>)`](crate::client::fluent_builders::CancelConversionTask::conversion_task_id) / [`set_conversion_task_id(Option<String>)`](crate::client::fluent_builders::CancelConversionTask::set_conversion_task_id): <p>The ID of the conversion task.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelConversionTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelConversionTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`reason_message(impl Into<String>)`](crate::client::fluent_builders::CancelConversionTask::reason_message) / [`set_reason_message(Option<String>)`](crate::client::fluent_builders::CancelConversionTask::set_reason_message): <p>The reason for canceling the conversion task.</p>
    /// - On success, responds with [`CancelConversionTaskOutput`](crate::output::CancelConversionTaskOutput)

    /// - On failure, responds with [`SdkError<CancelConversionTaskError>`](crate::error::CancelConversionTaskError)
    pub fn cancel_conversion_task(&self) -> fluent_builders::CancelConversionTask<C, M, R> {
        fluent_builders::CancelConversionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelExportTask`](crate::client::fluent_builders::CancelExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_task_id(impl Into<String>)`](crate::client::fluent_builders::CancelExportTask::export_task_id) / [`set_export_task_id(Option<String>)`](crate::client::fluent_builders::CancelExportTask::set_export_task_id): <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
    /// - On success, responds with [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)

    /// - On failure, responds with [`SdkError<CancelExportTaskError>`](crate::error::CancelExportTaskError)
    pub fn cancel_export_task(&self) -> fluent_builders::CancelExportTask<C, M, R> {
        fluent_builders::CancelExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelImportTask`](crate::client::fluent_builders::CancelImportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cancel_reason(impl Into<String>)`](crate::client::fluent_builders::CancelImportTask::cancel_reason) / [`set_cancel_reason(Option<String>)`](crate::client::fluent_builders::CancelImportTask::set_cancel_reason): <p>The reason for canceling the task.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelImportTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelImportTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`import_task_id(impl Into<String>)`](crate::client::fluent_builders::CancelImportTask::import_task_id) / [`set_import_task_id(Option<String>)`](crate::client::fluent_builders::CancelImportTask::set_import_task_id): <p>The ID of the import image or import snapshot task to be canceled.</p>
    /// - On success, responds with [`CancelImportTaskOutput`](crate::output::CancelImportTaskOutput) with field(s):
    ///   - [`import_task_id(Option<String>)`](crate::output::CancelImportTaskOutput::import_task_id): <p>The ID of the task being canceled.</p>
    ///   - [`previous_state(Option<String>)`](crate::output::CancelImportTaskOutput::previous_state): <p>The current state of the task being canceled.</p>
    ///   - [`state(Option<String>)`](crate::output::CancelImportTaskOutput::state): <p>The current state of the task being canceled.</p>
    /// - On failure, responds with [`SdkError<CancelImportTaskError>`](crate::error::CancelImportTaskError)
    pub fn cancel_import_task(&self) -> fluent_builders::CancelImportTask<C, M, R> {
        fluent_builders::CancelImportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelReservedInstancesListing`](crate::client::fluent_builders::CancelReservedInstancesListing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_instances_listing_id(impl Into<String>)`](crate::client::fluent_builders::CancelReservedInstancesListing::reserved_instances_listing_id) / [`set_reserved_instances_listing_id(Option<String>)`](crate::client::fluent_builders::CancelReservedInstancesListing::set_reserved_instances_listing_id): <p>The ID of the Reserved Instance listing.</p>
    /// - On success, responds with [`CancelReservedInstancesListingOutput`](crate::output::CancelReservedInstancesListingOutput) with field(s):
    ///   - [`reserved_instances_listings(Option<Vec<ReservedInstancesListing>>)`](crate::output::CancelReservedInstancesListingOutput::reserved_instances_listings): <p>The Reserved Instance listing.</p>
    /// - On failure, responds with [`SdkError<CancelReservedInstancesListingError>`](crate::error::CancelReservedInstancesListingError)
    pub fn cancel_reserved_instances_listing(
        &self,
    ) -> fluent_builders::CancelReservedInstancesListing<C, M, R> {
        fluent_builders::CancelReservedInstancesListing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelSpotFleetRequests`](crate::client::fluent_builders::CancelSpotFleetRequests) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelSpotFleetRequests::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelSpotFleetRequests::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`spot_fleet_request_ids(Vec<String>)`](crate::client::fluent_builders::CancelSpotFleetRequests::spot_fleet_request_ids) / [`set_spot_fleet_request_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CancelSpotFleetRequests::set_spot_fleet_request_ids): <p>The IDs of the Spot Fleet requests.</p>
    ///   - [`terminate_instances(bool)`](crate::client::fluent_builders::CancelSpotFleetRequests::terminate_instances) / [`set_terminate_instances(Option<bool>)`](crate::client::fluent_builders::CancelSpotFleetRequests::set_terminate_instances): <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
    /// - On success, responds with [`CancelSpotFleetRequestsOutput`](crate::output::CancelSpotFleetRequestsOutput) with field(s):
    ///   - [`successful_fleet_requests(Option<Vec<CancelSpotFleetRequestsSuccessItem>>)`](crate::output::CancelSpotFleetRequestsOutput::successful_fleet_requests): <p>Information about the Spot Fleet requests that are successfully canceled.</p>
    ///   - [`unsuccessful_fleet_requests(Option<Vec<CancelSpotFleetRequestsErrorItem>>)`](crate::output::CancelSpotFleetRequestsOutput::unsuccessful_fleet_requests): <p>Information about the Spot Fleet requests that are not successfully canceled.</p>
    /// - On failure, responds with [`SdkError<CancelSpotFleetRequestsError>`](crate::error::CancelSpotFleetRequestsError)
    pub fn cancel_spot_fleet_requests(&self) -> fluent_builders::CancelSpotFleetRequests<C, M, R> {
        fluent_builders::CancelSpotFleetRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelSpotInstanceRequests`](crate::client::fluent_builders::CancelSpotInstanceRequests) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CancelSpotInstanceRequests::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CancelSpotInstanceRequests::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`spot_instance_request_ids(Vec<String>)`](crate::client::fluent_builders::CancelSpotInstanceRequests::spot_instance_request_ids) / [`set_spot_instance_request_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CancelSpotInstanceRequests::set_spot_instance_request_ids): <p>One or more Spot Instance request IDs.</p>
    /// - On success, responds with [`CancelSpotInstanceRequestsOutput`](crate::output::CancelSpotInstanceRequestsOutput) with field(s):
    ///   - [`cancelled_spot_instance_requests(Option<Vec<CancelledSpotInstanceRequest>>)`](crate::output::CancelSpotInstanceRequestsOutput::cancelled_spot_instance_requests): <p>One or more Spot Instance requests.</p>
    /// - On failure, responds with [`SdkError<CancelSpotInstanceRequestsError>`](crate::error::CancelSpotInstanceRequestsError)
    pub fn cancel_spot_instance_requests(
        &self,
    ) -> fluent_builders::CancelSpotInstanceRequests<C, M, R> {
        fluent_builders::CancelSpotInstanceRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ConfirmProductInstance`](crate::client::fluent_builders::ConfirmProductInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ConfirmProductInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ConfirmProductInstance::set_instance_id): <p>The ID of the instance.</p>
    ///   - [`product_code(impl Into<String>)`](crate::client::fluent_builders::ConfirmProductInstance::product_code) / [`set_product_code(Option<String>)`](crate::client::fluent_builders::ConfirmProductInstance::set_product_code): <p>The product code. This must be a product code that you own.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::ConfirmProductInstance::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::ConfirmProductInstance::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`ConfirmProductInstanceOutput`](crate::output::ConfirmProductInstanceOutput) with field(s):
    ///   - [`owner_id(Option<String>)`](crate::output::ConfirmProductInstanceOutput::owner_id): <p>The Amazon Web Services account ID of the instance owner. This is only present if the product code is attached to the instance.</p>
    ///   - [`r#return(Option<bool>)`](crate::output::ConfirmProductInstanceOutput::return): <p>The return value of the request. Returns <code>true</code> if the specified product code is owned by the requester and associated with the specified instance.</p>
    /// - On failure, responds with [`SdkError<ConfirmProductInstanceError>`](crate::error::ConfirmProductInstanceError)
    pub fn confirm_product_instance(&self) -> fluent_builders::ConfirmProductInstance<C, M, R> {
        fluent_builders::ConfirmProductInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyFpgaImage`](crate::client::fluent_builders::CopyFpgaImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CopyFpgaImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CopyFpgaImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`source_fpga_image_id(impl Into<String>)`](crate::client::fluent_builders::CopyFpgaImage::source_fpga_image_id) / [`set_source_fpga_image_id(Option<String>)`](crate::client::fluent_builders::CopyFpgaImage::set_source_fpga_image_id): <p>The ID of the source AFI.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CopyFpgaImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CopyFpgaImage::set_description): <p>The description for the new AFI.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CopyFpgaImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CopyFpgaImage::set_name): <p>The name for the new AFI. The default is the name of the source AFI.</p>
    ///   - [`source_region(impl Into<String>)`](crate::client::fluent_builders::CopyFpgaImage::source_region) / [`set_source_region(Option<String>)`](crate::client::fluent_builders::CopyFpgaImage::set_source_region): <p>The Region that contains the source AFI.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CopyFpgaImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CopyFpgaImage::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
    /// - On success, responds with [`CopyFpgaImageOutput`](crate::output::CopyFpgaImageOutput) with field(s):
    ///   - [`fpga_image_id(Option<String>)`](crate::output::CopyFpgaImageOutput::fpga_image_id): <p>The ID of the new AFI.</p>
    /// - On failure, responds with [`SdkError<CopyFpgaImageError>`](crate::error::CopyFpgaImageError)
    pub fn copy_fpga_image(&self) -> fluent_builders::CopyFpgaImage<C, M, R> {
        fluent_builders::CopyFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyImage`](crate::client::fluent_builders::CopyImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CopyImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CopyImage::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CopyImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CopyImage::set_description): <p>A description for the new AMI in the destination Region.</p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::CopyImage::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::CopyImage::set_encrypted): <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyImage::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopyImage::set_kms_key_id): <p>The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to <code>true</code>.</p>  <p>You can specify a KMS key using any of the following:</p>  <ul>   <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>   <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>  </ul>  <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p>  <p>The specified KMS key must exist in the destination Region.</p>  <p>Amazon EBS does not support asymmetric KMS keys.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CopyImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CopyImage::set_name): <p>The name of the new AMI in the destination Region.</p>
    ///   - [`source_image_id(impl Into<String>)`](crate::client::fluent_builders::CopyImage::source_image_id) / [`set_source_image_id(Option<String>)`](crate::client::fluent_builders::CopyImage::set_source_image_id): <p>The ID of the AMI to copy.</p>
    ///   - [`source_region(impl Into<String>)`](crate::client::fluent_builders::CopyImage::source_region) / [`set_source_region(Option<String>)`](crate::client::fluent_builders::CopyImage::set_source_region): <p>The name of the Region that contains the AMI to copy.</p>
    ///   - [`destination_outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CopyImage::destination_outpost_arn) / [`set_destination_outpost_arn(Option<String>)`](crate::client::fluent_builders::CopyImage::set_destination_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CopyImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CopyImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CopyImageOutput`](crate::output::CopyImageOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::CopyImageOutput::image_id): <p>The ID of the new AMI.</p>
    /// - On failure, responds with [`SdkError<CopyImageError>`](crate::error::CopyImageError)
    pub fn copy_image(&self) -> fluent_builders::CopyImage<C, M, R> {
        fluent_builders::CopyImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_description): <p>A description for the EBS snapshot.</p>
    ///   - [`destination_outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::destination_outpost_arn) / [`set_destination_outpost_arn(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_destination_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copy snapshots from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`destination_region(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::destination_region) / [`set_destination_region(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_destination_region): <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p>  <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the CLI, this is specified using the <code>--region</code> parameter or the default Region in your Amazon Web Services configuration file.</p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::CopySnapshot::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::CopySnapshot::set_encrypted): <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_kms_key_id): <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>  <p>You can specify the KMS key using any of the following:</p>  <ul>   <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>   <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>  </ul>  <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
    ///   - [`presigned_url(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::presigned_url) / [`set_presigned_url(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_presigned_url): <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p>  <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
    ///   - [`source_region(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::source_region) / [`set_source_region(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_source_region): <p>The ID of the Region that contains the snapshot to be copied.</p>
    ///   - [`source_snapshot_id(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::source_snapshot_id) / [`set_source_snapshot_id(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_source_snapshot_id): <p>The ID of the EBS snapshot to copy.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CopySnapshot::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CopySnapshot::set_tag_specifications): <p>The tags to apply to the new snapshot.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CopySnapshot::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CopySnapshot::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CopySnapshotOutput`](crate::output::CopySnapshotOutput) with field(s):
    ///   - [`snapshot_id(Option<String>)`](crate::output::CopySnapshotOutput::snapshot_id): <p>The ID of the new snapshot.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CopySnapshotOutput::tags): <p>Any tags applied to the new snapshot.</p>
    /// - On failure, responds with [`SdkError<CopySnapshotError>`](crate::error::CopySnapshotError)
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot<C, M, R> {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCapacityReservation`](crate::client::fluent_builders::CreateCapacityReservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_instance_type): <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`instance_platform(CapacityReservationInstancePlatform)`](crate::client::fluent_builders::CreateCapacityReservation::instance_platform) / [`set_instance_platform(Option<CapacityReservationInstancePlatform>)`](crate::client::fluent_builders::CreateCapacityReservation::set_instance_platform): <p>The type of operating system for which to reserve capacity.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_availability_zone): <p>The Availability Zone in which to create the Capacity Reservation.</p>
    ///   - [`availability_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::availability_zone_id) / [`set_availability_zone_id(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_availability_zone_id): <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
    ///   - [`tenancy(CapacityReservationTenancy)`](crate::client::fluent_builders::CreateCapacityReservation::tenancy) / [`set_tenancy(Option<CapacityReservationTenancy>)`](crate::client::fluent_builders::CreateCapacityReservation::set_tenancy): <p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>  <ul>   <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>   <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>  </ul>
    ///   - [`instance_count(i32)`](crate::client::fluent_builders::CreateCapacityReservation::instance_count) / [`set_instance_count(Option<i32>)`](crate::client::fluent_builders::CreateCapacityReservation::set_instance_count): <p>The number of instances for which to reserve capacity.</p>  <p>Valid range: 1 - 1000</p>
    ///   - [`ebs_optimized(bool)`](crate::client::fluent_builders::CreateCapacityReservation::ebs_optimized) / [`set_ebs_optimized(Option<bool>)`](crate::client::fluent_builders::CreateCapacityReservation::set_ebs_optimized): <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
    ///   - [`ephemeral_storage(bool)`](crate::client::fluent_builders::CreateCapacityReservation::ephemeral_storage) / [`set_ephemeral_storage(Option<bool>)`](crate::client::fluent_builders::CreateCapacityReservation::set_ephemeral_storage): <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::CreateCapacityReservation::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::CreateCapacityReservation::set_end_date): <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>  <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>  <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
    ///   - [`end_date_type(EndDateType)`](crate::client::fluent_builders::CreateCapacityReservation::end_date_type) / [`set_end_date_type(Option<EndDateType>)`](crate::client::fluent_builders::CreateCapacityReservation::set_end_date_type): <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>  <ul>   <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li>   <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li>  </ul>
    ///   - [`instance_match_criteria(InstanceMatchCriteria)`](crate::client::fluent_builders::CreateCapacityReservation::instance_match_criteria) / [`set_instance_match_criteria(Option<InstanceMatchCriteria>)`](crate::client::fluent_builders::CreateCapacityReservation::set_instance_match_criteria): <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>  <ul>   <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li>   <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li>  </ul>  <p>Default: <code>open</code> </p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateCapacityReservation::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateCapacityReservation::set_tag_specifications): <p>The tags to apply to the Capacity Reservation during launch.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateCapacityReservation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateCapacityReservation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::outpost_arn) / [`set_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
    ///   - [`placement_group_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservation::placement_group_arn) / [`set_placement_group_arn(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservation::set_placement_group_arn): <p>The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// - On success, responds with [`CreateCapacityReservationOutput`](crate::output::CreateCapacityReservationOutput) with field(s):
    ///   - [`capacity_reservation(Option<CapacityReservation>)`](crate::output::CreateCapacityReservationOutput::capacity_reservation): <p>Information about the Capacity Reservation.</p>
    /// - On failure, responds with [`SdkError<CreateCapacityReservationError>`](crate::error::CreateCapacityReservationError)
    pub fn create_capacity_reservation(
        &self,
    ) -> fluent_builders::CreateCapacityReservation<C, M, R> {
        fluent_builders::CreateCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCapacityReservationFleet`](crate::client::fluent_builders::CreateCapacityReservationFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`allocation_strategy(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::allocation_strategy) / [`set_allocation_strategy(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_allocation_strategy): <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy"> Allocation strategy</a> in the Amazon EC2 User Guide.</p>  <p>Valid values: <code>prioritized</code> </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
    ///   - [`instance_type_specifications(Vec<ReservationFleetInstanceSpecification>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::instance_type_specifications) / [`set_instance_type_specifications(Option<Vec<ReservationFleetInstanceSpecification>>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_instance_type_specifications): <p>Information about the instance types for which to reserve the capacity.</p>
    ///   - [`tenancy(FleetCapacityReservationTenancy)`](crate::client::fluent_builders::CreateCapacityReservationFleet::tenancy) / [`set_tenancy(Option<FleetCapacityReservationTenancy>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_tenancy): <p>Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:</p>  <ul>   <li> <p> <code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>   <li> <p> <code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>  </ul>
    ///   - [`total_target_capacity(i32)`](crate::client::fluent_builders::CreateCapacityReservationFleet::total_target_capacity) / [`set_total_target_capacity(Option<i32>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_total_target_capacity): <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity"> Total target capacity</a> in the Amazon EC2 User Guide.</p>
    ///   - [`end_date(DateTime)`](crate::client::fluent_builders::CreateCapacityReservationFleet::end_date) / [`set_end_date(Option<DateTime>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_end_date): <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.</p>  <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>. </p>
    ///   - [`instance_match_criteria(FleetInstanceMatchCriteria)`](crate::client::fluent_builders::CreateCapacityReservationFleet::instance_match_criteria) / [`set_instance_match_criteria(Option<FleetInstanceMatchCriteria>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_instance_match_criteria): <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.</p>  <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_tag_specifications): <p>The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateCapacityReservationFleet::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateCapacityReservationFleet::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateCapacityReservationFleetOutput`](crate::output::CreateCapacityReservationFleetOutput) with field(s):
    ///   - [`capacity_reservation_fleet_id(Option<String>)`](crate::output::CreateCapacityReservationFleetOutput::capacity_reservation_fleet_id): <p>The ID of the Capacity Reservation Fleet.</p>
    ///   - [`state(Option<CapacityReservationFleetState>)`](crate::output::CreateCapacityReservationFleetOutput::state): <p>The status of the Capacity Reservation Fleet.</p>
    ///   - [`total_target_capacity(Option<i32>)`](crate::output::CreateCapacityReservationFleetOutput::total_target_capacity): <p>The total number of capacity units for which the Capacity Reservation Fleet reserves capacity.</p>
    ///   - [`total_fulfilled_capacity(Option<f64>)`](crate::output::CreateCapacityReservationFleetOutput::total_fulfilled_capacity): <p>The requested capacity units that have been successfully reserved.</p>
    ///   - [`instance_match_criteria(Option<FleetInstanceMatchCriteria>)`](crate::output::CreateCapacityReservationFleetOutput::instance_match_criteria): <p>The instance matching criteria for the Capacity Reservation Fleet.</p>
    ///   - [`allocation_strategy(Option<String>)`](crate::output::CreateCapacityReservationFleetOutput::allocation_strategy): <p>The allocation strategy used by the Capacity Reservation Fleet.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateCapacityReservationFleetOutput::create_time): <p>The date and time at which the Capacity Reservation Fleet was created.</p>
    ///   - [`end_date(Option<DateTime>)`](crate::output::CreateCapacityReservationFleetOutput::end_date): <p>The date and time at which the Capacity Reservation Fleet expires.</p>
    ///   - [`tenancy(Option<FleetCapacityReservationTenancy>)`](crate::output::CreateCapacityReservationFleetOutput::tenancy): <p>Indicates the tenancy of Capacity Reservation Fleet.</p>
    ///   - [`fleet_capacity_reservations(Option<Vec<FleetCapacityReservation>>)`](crate::output::CreateCapacityReservationFleetOutput::fleet_capacity_reservations): <p>Information about the individual Capacity Reservations in the Capacity Reservation Fleet.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateCapacityReservationFleetOutput::tags): <p>The tags assigned to the Capacity Reservation Fleet.</p>
    /// - On failure, responds with [`SdkError<CreateCapacityReservationFleetError>`](crate::error::CreateCapacityReservationFleetError)
    pub fn create_capacity_reservation_fleet(
        &self,
    ) -> fluent_builders::CreateCapacityReservationFleet<C, M, R> {
        fluent_builders::CreateCapacityReservationFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCarrierGateway`](crate::client::fluent_builders::CreateCarrierGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateCarrierGateway::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateCarrierGateway::set_vpc_id): <p>The ID of the VPC to associate with the carrier gateway.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateCarrierGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateCarrierGateway::set_tag_specifications): <p>The tags to associate with the carrier gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateCarrierGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateCarrierGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCarrierGateway::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCarrierGateway::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateCarrierGatewayOutput`](crate::output::CreateCarrierGatewayOutput) with field(s):
    ///   - [`carrier_gateway(Option<CarrierGateway>)`](crate::output::CreateCarrierGatewayOutput::carrier_gateway): <p>Information about the carrier gateway.</p>
    /// - On failure, responds with [`SdkError<CreateCarrierGatewayError>`](crate::error::CreateCarrierGatewayError)
    pub fn create_carrier_gateway(&self) -> fluent_builders::CreateCarrierGateway<C, M, R> {
        fluent_builders::CreateCarrierGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClientVpnEndpoint`](crate::client::fluent_builders::CreateClientVpnEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::client_cidr_block) / [`set_client_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_client_cidr_block): <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
    ///   - [`server_certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::server_certificate_arn) / [`set_server_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_server_certificate_arn): <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>
    ///   - [`authentication_options(Vec<ClientVpnAuthenticationRequest>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::authentication_options) / [`set_authentication_options(Option<Vec<ClientVpnAuthenticationRequest>>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_authentication_options): <p>Information about the authentication method to be used to authenticate clients.</p>
    ///   - [`connection_log_options(ConnectionLogOptions)`](crate::client::fluent_builders::CreateClientVpnEndpoint::connection_log_options) / [`set_connection_log_options(Option<ConnectionLogOptions>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_connection_log_options): <p>Information about the client connection logging options.</p>  <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p>  <ul>   <li> <p>Client connection requests</p> </li>   <li> <p>Client connection results (successful and unsuccessful)</p> </li>   <li> <p>Reasons for unsuccessful client connection requests</p> </li>   <li> <p>Client connection termination time</p> </li>  </ul>
    ///   - [`dns_servers(Vec<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::dns_servers) / [`set_dns_servers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_dns_servers): <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
    ///   - [`transport_protocol(TransportProtocol)`](crate::client::fluent_builders::CreateClientVpnEndpoint::transport_protocol) / [`set_transport_protocol(Option<TransportProtocol>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_transport_protocol): <p>The transport protocol to be used by the VPN session.</p>  <p>Default value: <code>udp</code> </p>
    ///   - [`vpn_port(i32)`](crate::client::fluent_builders::CreateClientVpnEndpoint::vpn_port) / [`set_vpn_port(Option<i32>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_vpn_port): <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>  <p>Valid Values: <code>443</code> | <code>1194</code> </p>  <p>Default Value: <code>443</code> </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_description): <p>A brief description of the Client VPN endpoint.</p>
    ///   - [`split_tunnel(bool)`](crate::client::fluent_builders::CreateClientVpnEndpoint::split_tunnel) / [`set_split_tunnel(Option<bool>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_split_tunnel): <p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>  <p>By default, split-tunnel on a VPN endpoint is disabled.</p>  <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateClientVpnEndpoint::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_tag_specifications): <p>The tags to apply to the Client VPN endpoint during creation.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_security_group_ids): <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_vpc_id): <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
    ///   - [`self_service_portal(SelfServicePortal)`](crate::client::fluent_builders::CreateClientVpnEndpoint::self_service_portal) / [`set_self_service_portal(Option<SelfServicePortal>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_self_service_portal): <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>  <p>Default Value: <code>enabled</code> </p>
    ///   - [`client_connect_options(ClientConnectOptions)`](crate::client::fluent_builders::CreateClientVpnEndpoint::client_connect_options) / [`set_client_connect_options(Option<ClientConnectOptions>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_client_connect_options): <p>The options for managing connection authorization for new client connections.</p>
    ///   - [`session_timeout_hours(i32)`](crate::client::fluent_builders::CreateClientVpnEndpoint::session_timeout_hours) / [`set_session_timeout_hours(Option<i32>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_session_timeout_hours): (undocumented)
    ///   - [`client_login_banner_options(ClientLoginBannerOptions)`](crate::client::fluent_builders::CreateClientVpnEndpoint::client_login_banner_options) / [`set_client_login_banner_options(Option<ClientLoginBannerOptions>)`](crate::client::fluent_builders::CreateClientVpnEndpoint::set_client_login_banner_options): (undocumented)
    /// - On success, responds with [`CreateClientVpnEndpointOutput`](crate::output::CreateClientVpnEndpointOutput) with field(s):
    ///   - [`client_vpn_endpoint_id(Option<String>)`](crate::output::CreateClientVpnEndpointOutput::client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`status(Option<ClientVpnEndpointStatus>)`](crate::output::CreateClientVpnEndpointOutput::status): <p>The current state of the Client VPN endpoint.</p>
    ///   - [`dns_name(Option<String>)`](crate::output::CreateClientVpnEndpointOutput::dns_name): <p>The DNS name to be used by clients when establishing their VPN session.</p>
    /// - On failure, responds with [`SdkError<CreateClientVpnEndpointError>`](crate::error::CreateClientVpnEndpointError)
    pub fn create_client_vpn_endpoint(&self) -> fluent_builders::CreateClientVpnEndpoint<C, M, R> {
        fluent_builders::CreateClientVpnEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClientVpnRoute`](crate::client::fluent_builders::CreateClientVpnRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint to which to add the route.</p>
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_destination_cidr_block): <p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p>  <ul>   <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li>   <li> <p>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</p> </li>   <li> <p>To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range</p> </li>   <li> <p>To add a route for the local network, enter the client CIDR range</p> </li>  </ul>
    ///   - [`target_vpc_subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::target_vpc_subnet_id) / [`set_target_vpc_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_target_vpc_subnet_id): <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p>  <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_description): <p>A brief description of the route.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateClientVpnRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateClientVpnRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateClientVpnRouteOutput`](crate::output::CreateClientVpnRouteOutput) with field(s):
    ///   - [`status(Option<ClientVpnRouteStatus>)`](crate::output::CreateClientVpnRouteOutput::status): <p>The current state of the route.</p>
    /// - On failure, responds with [`SdkError<CreateClientVpnRouteError>`](crate::error::CreateClientVpnRouteError)
    pub fn create_client_vpn_route(&self) -> fluent_builders::CreateClientVpnRoute<C, M, R> {
        fluent_builders::CreateClientVpnRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomerGateway`](crate::client::fluent_builders::CreateCustomerGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bgp_asn(i32)`](crate::client::fluent_builders::CreateCustomerGateway::bgp_asn) / [`set_bgp_asn(Option<i32>)`](crate::client::fluent_builders::CreateCustomerGateway::set_bgp_asn): <p>For devices that support BGP, the customer gateway's BGP ASN.</p>  <p>Default: 65000</p>
    ///   - [`public_ip(impl Into<String>)`](crate::client::fluent_builders::CreateCustomerGateway::public_ip) / [`set_public_ip(Option<String>)`](crate::client::fluent_builders::CreateCustomerGateway::set_public_ip): <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCustomerGateway::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateCustomerGateway::set_certificate_arn): <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
    ///   - [`r#type(GatewayType)`](crate::client::fluent_builders::CreateCustomerGateway::r#type) / [`set_type(Option<GatewayType>)`](crate::client::fluent_builders::CreateCustomerGateway::set_type): <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateCustomerGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateCustomerGateway::set_tag_specifications): <p>The tags to apply to the customer gateway.</p>
    ///   - [`device_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomerGateway::device_name) / [`set_device_name(Option<String>)`](crate::client::fluent_builders::CreateCustomerGateway::set_device_name): <p>A name for the customer gateway device.</p>  <p>Length Constraints: Up to 255 characters.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateCustomerGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateCustomerGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateCustomerGatewayOutput`](crate::output::CreateCustomerGatewayOutput) with field(s):
    ///   - [`customer_gateway(Option<CustomerGateway>)`](crate::output::CreateCustomerGatewayOutput::customer_gateway): <p>Information about the customer gateway.</p>
    /// - On failure, responds with [`SdkError<CreateCustomerGatewayError>`](crate::error::CreateCustomerGatewayError)
    pub fn create_customer_gateway(&self) -> fluent_builders::CreateCustomerGateway<C, M, R> {
        fluent_builders::CreateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDefaultSubnet`](crate::client::fluent_builders::CreateDefaultSubnet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateDefaultSubnet::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateDefaultSubnet::set_availability_zone): <p>The Availability Zone in which to create the default subnet.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateDefaultSubnet::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateDefaultSubnet::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipv6_native(bool)`](crate::client::fluent_builders::CreateDefaultSubnet::ipv6_native) / [`set_ipv6_native(Option<bool>)`](crate::client::fluent_builders::CreateDefaultSubnet::set_ipv6_native): <p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>
    /// - On success, responds with [`CreateDefaultSubnetOutput`](crate::output::CreateDefaultSubnetOutput) with field(s):
    ///   - [`subnet(Option<Subnet>)`](crate::output::CreateDefaultSubnetOutput::subnet): <p>Information about the subnet.</p>
    /// - On failure, responds with [`SdkError<CreateDefaultSubnetError>`](crate::error::CreateDefaultSubnetError)
    pub fn create_default_subnet(&self) -> fluent_builders::CreateDefaultSubnet<C, M, R> {
        fluent_builders::CreateDefaultSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDefaultVpc`](crate::client::fluent_builders::CreateDefaultVpc) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateDefaultVpc::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateDefaultVpc::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateDefaultVpcOutput`](crate::output::CreateDefaultVpcOutput) with field(s):
    ///   - [`vpc(Option<Vpc>)`](crate::output::CreateDefaultVpcOutput::vpc): <p>Information about the VPC.</p>
    /// - On failure, responds with [`SdkError<CreateDefaultVpcError>`](crate::error::CreateDefaultVpcError)
    pub fn create_default_vpc(&self) -> fluent_builders::CreateDefaultVpc<C, M, R> {
        fluent_builders::CreateDefaultVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDhcpOptions`](crate::client::fluent_builders::CreateDhcpOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dhcp_configurations(Vec<NewDhcpConfiguration>)`](crate::client::fluent_builders::CreateDhcpOptions::dhcp_configurations) / [`set_dhcp_configurations(Option<Vec<NewDhcpConfiguration>>)`](crate::client::fluent_builders::CreateDhcpOptions::set_dhcp_configurations): <p>A DHCP configuration option.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateDhcpOptions::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateDhcpOptions::set_tag_specifications): <p>The tags to assign to the DHCP option.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateDhcpOptions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateDhcpOptions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateDhcpOptionsOutput`](crate::output::CreateDhcpOptionsOutput) with field(s):
    ///   - [`dhcp_options(Option<DhcpOptions>)`](crate::output::CreateDhcpOptionsOutput::dhcp_options): <p>A set of DHCP options.</p>
    /// - On failure, responds with [`SdkError<CreateDhcpOptionsError>`](crate::error::CreateDhcpOptionsError)
    pub fn create_dhcp_options(&self) -> fluent_builders::CreateDhcpOptions<C, M, R> {
        fluent_builders::CreateDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEgressOnlyInternetGateway`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::set_vpc_id): <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway::set_tag_specifications): <p>The tags to assign to the egress-only internet gateway.</p>
    /// - On success, responds with [`CreateEgressOnlyInternetGatewayOutput`](crate::output::CreateEgressOnlyInternetGatewayOutput) with field(s):
    ///   - [`client_token(Option<String>)`](crate::output::CreateEgressOnlyInternetGatewayOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`egress_only_internet_gateway(Option<EgressOnlyInternetGateway>)`](crate::output::CreateEgressOnlyInternetGatewayOutput::egress_only_internet_gateway): <p>Information about the egress-only internet gateway.</p>
    /// - On failure, responds with [`SdkError<CreateEgressOnlyInternetGatewayError>`](crate::error::CreateEgressOnlyInternetGatewayError)
    pub fn create_egress_only_internet_gateway(
        &self,
    ) -> fluent_builders::CreateEgressOnlyInternetGateway<C, M, R> {
        fluent_builders::CreateEgressOnlyInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFleet`](crate::client::fluent_builders::CreateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateFleet::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateFleet::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`spot_options(SpotOptionsRequest)`](crate::client::fluent_builders::CreateFleet::spot_options) / [`set_spot_options(Option<SpotOptionsRequest>)`](crate::client::fluent_builders::CreateFleet::set_spot_options): <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
    ///   - [`on_demand_options(OnDemandOptionsRequest)`](crate::client::fluent_builders::CreateFleet::on_demand_options) / [`set_on_demand_options(Option<OnDemandOptionsRequest>)`](crate::client::fluent_builders::CreateFleet::set_on_demand_options): <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
    ///   - [`excess_capacity_termination_policy(FleetExcessCapacityTerminationPolicy)`](crate::client::fluent_builders::CreateFleet::excess_capacity_termination_policy) / [`set_excess_capacity_termination_policy(Option<FleetExcessCapacityTerminationPolicy>)`](crate::client::fluent_builders::CreateFleet::set_excess_capacity_termination_policy): <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
    ///   - [`launch_template_configs(Vec<FleetLaunchTemplateConfigRequest>)`](crate::client::fluent_builders::CreateFleet::launch_template_configs) / [`set_launch_template_configs(Option<Vec<FleetLaunchTemplateConfigRequest>>)`](crate::client::fluent_builders::CreateFleet::set_launch_template_configs): <p>The configuration for the EC2 Fleet.</p>
    ///   - [`target_capacity_specification(TargetCapacitySpecificationRequest)`](crate::client::fluent_builders::CreateFleet::target_capacity_specification) / [`set_target_capacity_specification(Option<TargetCapacitySpecificationRequest>)`](crate::client::fluent_builders::CreateFleet::set_target_capacity_specification): <p>The number of units to request.</p>
    ///   - [`terminate_instances_with_expiration(bool)`](crate::client::fluent_builders::CreateFleet::terminate_instances_with_expiration) / [`set_terminate_instances_with_expiration(Option<bool>)`](crate::client::fluent_builders::CreateFleet::set_terminate_instances_with_expiration): <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
    ///   - [`r#type(FleetType)`](crate::client::fluent_builders::CreateFleet::r#type) / [`set_type(Option<FleetType>)`](crate::client::fluent_builders::CreateFleet::set_type): <p>The fleet type. The default value is <code>maintain</code>.</p>  <ul>   <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li>   <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li>   <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`valid_from(DateTime)`](crate::client::fluent_builders::CreateFleet::valid_from) / [`set_valid_from(Option<DateTime>)`](crate::client::fluent_builders::CreateFleet::set_valid_from): <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
    ///   - [`valid_until(DateTime)`](crate::client::fluent_builders::CreateFleet::valid_until) / [`set_valid_until(Option<DateTime>)`](crate::client::fluent_builders::CreateFleet::set_valid_until): <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
    ///   - [`replace_unhealthy_instances(bool)`](crate::client::fluent_builders::CreateFleet::replace_unhealthy_instances) / [`set_replace_unhealthy_instances(Option<bool>)`](crate::client::fluent_builders::CreateFleet::set_replace_unhealthy_instances): <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateFleet::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateFleet::set_tag_specifications): <p>The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>  <p>If the fleet type is <code>instant</code>, specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.</p>  <p>If the fleet type is <code>maintain</code> or <code>request</code>, specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code>. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>.</p>
    ///   - [`context(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::context) / [`set_context(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_context): <p>Reserved.</p>
    /// - On success, responds with [`CreateFleetOutput`](crate::output::CreateFleetOutput) with field(s):
    ///   - [`fleet_id(Option<String>)`](crate::output::CreateFleetOutput::fleet_id): <p>The ID of the EC2 Fleet.</p>
    ///   - [`errors(Option<Vec<CreateFleetError>>)`](crate::output::CreateFleetOutput::errors): <p>Information about the instances that could not be launched by the fleet. Supported only for fleets of type <code>instant</code>.</p>
    ///   - [`instances(Option<Vec<CreateFleetInstance>>)`](crate::output::CreateFleetOutput::instances): <p>Information about the instances that were launched by the fleet. Supported only for fleets of type <code>instant</code>.</p>
    /// - On failure, responds with [`SdkError<CreateFleetError>`](crate::error::CreateFleetError)
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFlowLogs`](crate::client::fluent_builders::CreateFlowLogs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateFlowLogs::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateFlowLogs::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateFlowLogs::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateFlowLogs::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`deliver_logs_permission_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFlowLogs::deliver_logs_permission_arn) / [`set_deliver_logs_permission_arn(Option<String>)`](crate::client::fluent_builders::CreateFlowLogs::set_deliver_logs_permission_arn): <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p>  <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateFlowLogs::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::CreateFlowLogs::set_log_group_name): <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p>  <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
    ///   - [`resource_ids(Vec<String>)`](crate::client::fluent_builders::CreateFlowLogs::resource_ids) / [`set_resource_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFlowLogs::set_resource_ids): <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p>  <p>Constraints: Maximum of 1000 resources</p>
    ///   - [`resource_type(FlowLogsResourceType)`](crate::client::fluent_builders::CreateFlowLogs::resource_type) / [`set_resource_type(Option<FlowLogsResourceType>)`](crate::client::fluent_builders::CreateFlowLogs::set_resource_type): <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
    ///   - [`traffic_type(TrafficType)`](crate::client::fluent_builders::CreateFlowLogs::traffic_type) / [`set_traffic_type(Option<TrafficType>)`](crate::client::fluent_builders::CreateFlowLogs::set_traffic_type): <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
    ///   - [`log_destination_type(LogDestinationType)`](crate::client::fluent_builders::CreateFlowLogs::log_destination_type) / [`set_log_destination_type(Option<LogDestinationType>)`](crate::client::fluent_builders::CreateFlowLogs::set_log_destination_type): <p>The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p>  <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>  <p>Default: <code>cloud-watch-logs</code> </p>
    ///   - [`log_destination(impl Into<String>)`](crate::client::fluent_builders::CreateFlowLogs::log_destination) / [`set_log_destination(Option<String>)`](crate::client::fluent_builders::CreateFlowLogs::set_log_destination): <p>The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p>  <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p>  <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
    ///   - [`log_format(impl Into<String>)`](crate::client::fluent_builders::CreateFlowLogs::log_format) / [`set_log_format(Option<String>)`](crate::client::fluent_builders::CreateFlowLogs::set_log_format): <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p>  <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateFlowLogs::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateFlowLogs::set_tag_specifications): <p>The tags to apply to the flow logs.</p>
    ///   - [`max_aggregation_interval(i32)`](crate::client::fluent_builders::CreateFlowLogs::max_aggregation_interval) / [`set_max_aggregation_interval(Option<i32>)`](crate::client::fluent_builders::CreateFlowLogs::set_max_aggregation_interval): <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p>  <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p>  <p>Default: 600</p>
    ///   - [`destination_options(DestinationOptionsRequest)`](crate::client::fluent_builders::CreateFlowLogs::destination_options) / [`set_destination_options(Option<DestinationOptionsRequest>)`](crate::client::fluent_builders::CreateFlowLogs::set_destination_options): <p>The destination options.</p>
    /// - On success, responds with [`CreateFlowLogsOutput`](crate::output::CreateFlowLogsOutput) with field(s):
    ///   - [`client_token(Option<String>)`](crate::output::CreateFlowLogsOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`flow_log_ids(Option<Vec<String>>)`](crate::output::CreateFlowLogsOutput::flow_log_ids): <p>The IDs of the flow logs.</p>
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::CreateFlowLogsOutput::unsuccessful): <p>Information about the flow logs that could not be created successfully.</p>
    /// - On failure, responds with [`SdkError<CreateFlowLogsError>`](crate::error::CreateFlowLogsError)
    pub fn create_flow_logs(&self) -> fluent_builders::CreateFlowLogs<C, M, R> {
        fluent_builders::CreateFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFpgaImage`](crate::client::fluent_builders::CreateFpgaImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateFpgaImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateFpgaImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`input_storage_location(StorageLocation)`](crate::client::fluent_builders::CreateFpgaImage::input_storage_location) / [`set_input_storage_location(Option<StorageLocation>)`](crate::client::fluent_builders::CreateFpgaImage::set_input_storage_location): <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
    ///   - [`logs_storage_location(StorageLocation)`](crate::client::fluent_builders::CreateFpgaImage::logs_storage_location) / [`set_logs_storage_location(Option<StorageLocation>)`](crate::client::fluent_builders::CreateFpgaImage::set_logs_storage_location): <p>The location in Amazon S3 for the output logs.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFpgaImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFpgaImage::set_description): <p>A description for the AFI.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFpgaImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFpgaImage::set_name): <p>A name for the AFI.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateFpgaImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateFpgaImage::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateFpgaImage::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateFpgaImage::set_tag_specifications): <p>The tags to apply to the FPGA image during creation.</p>
    /// - On success, responds with [`CreateFpgaImageOutput`](crate::output::CreateFpgaImageOutput) with field(s):
    ///   - [`fpga_image_id(Option<String>)`](crate::output::CreateFpgaImageOutput::fpga_image_id): <p>The FPGA image identifier (AFI ID).</p>
    ///   - [`fpga_image_global_id(Option<String>)`](crate::output::CreateFpgaImageOutput::fpga_image_global_id): <p>The global FPGA image identifier (AGFI ID).</p>
    /// - On failure, responds with [`SdkError<CreateFpgaImageError>`](crate::error::CreateFpgaImageError)
    pub fn create_fpga_image(&self) -> fluent_builders::CreateFpgaImage<C, M, R> {
        fluent_builders::CreateFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImage`](crate::client::fluent_builders::CreateImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`block_device_mappings(Vec<BlockDeviceMapping>)`](crate::client::fluent_builders::CreateImage::block_device_mappings) / [`set_block_device_mappings(Option<Vec<BlockDeviceMapping>>)`](crate::client::fluent_builders::CreateImage::set_block_device_mappings): <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <code>CopyImage</code> action.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateImage::set_description): <p>A description for the new image.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateImage::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateImage::set_instance_id): <p>The ID of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateImage::set_name): <p>A name for the new image.</p>  <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
    ///   - [`no_reboot(bool)`](crate::client::fluent_builders::CreateImage::no_reboot) / [`set_no_reboot(Option<bool>)`](crate::client::fluent_builders::CreateImage::set_no_reboot): <p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the <code>No Reboot</code> option is set, Amazon EC2 doesn't shut down the instance before creating the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted at the same time), but not application consistent (all the operating system buffers are not flushed to disk before the snapshots are created).</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateImage::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateImage::set_tag_specifications): <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>  <ul>   <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>   <li> <p>To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>  </ul>  <p>If you specify other values for <code>ResourceType</code>, the request fails.</p>  <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
    /// - On success, responds with [`CreateImageOutput`](crate::output::CreateImageOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::CreateImageOutput::image_id): <p>The ID of the new AMI.</p>
    /// - On failure, responds with [`SdkError<CreateImageError>`](crate::error::CreateImageError)
    pub fn create_image(&self) -> fluent_builders::CreateImage<C, M, R> {
        fluent_builders::CreateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInstanceEventWindow`](crate::client::fluent_builders::CreateInstanceEventWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateInstanceEventWindow::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateInstanceEventWindow::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateInstanceEventWindow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateInstanceEventWindow::set_name): <p>The name of the event window.</p>
    ///   - [`time_ranges(Vec<InstanceEventWindowTimeRangeRequest>)`](crate::client::fluent_builders::CreateInstanceEventWindow::time_ranges) / [`set_time_ranges(Option<Vec<InstanceEventWindowTimeRangeRequest>>)`](crate::client::fluent_builders::CreateInstanceEventWindow::set_time_ranges): <p>The time range for the event window. If you specify a time range, you can't specify a cron expression.</p>
    ///   - [`cron_expression(impl Into<String>)`](crate::client::fluent_builders::CreateInstanceEventWindow::cron_expression) / [`set_cron_expression(Option<String>)`](crate::client::fluent_builders::CreateInstanceEventWindow::set_cron_expression): <p>The cron expression for the event window, for example, <code>* 0-4,20-23 * * 1,5</code>. If you specify a cron expression, you can't specify a time range.</p>  <p>Constraints:</p>  <ul>   <li> <p>Only hour and day of the week values are supported.</p> </li>   <li> <p>For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative single values <code>SUN</code> through <code>SAT</code>.</p> </li>   <li> <p>The minute, month, and year must be specified by <code>*</code>.</p> </li>   <li> <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.</p> </li>   <li> <p>Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.</p> </li>   <li> <p>The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.</p> </li>  </ul>  <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia website</i>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateInstanceEventWindow::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateInstanceEventWindow::set_tag_specifications): <p>The tags to apply to the event window.</p>
    /// - On success, responds with [`CreateInstanceEventWindowOutput`](crate::output::CreateInstanceEventWindowOutput) with field(s):
    ///   - [`instance_event_window(Option<InstanceEventWindow>)`](crate::output::CreateInstanceEventWindowOutput::instance_event_window): <p>Information about the event window.</p>
    /// - On failure, responds with [`SdkError<CreateInstanceEventWindowError>`](crate::error::CreateInstanceEventWindowError)
    pub fn create_instance_event_window(
        &self,
    ) -> fluent_builders::CreateInstanceEventWindow<C, M, R> {
        fluent_builders::CreateInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInstanceExportTask`](crate::client::fluent_builders::CreateInstanceExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateInstanceExportTask::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateInstanceExportTask::set_description): <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
    ///   - [`export_to_s3_task(ExportToS3TaskSpecification)`](crate::client::fluent_builders::CreateInstanceExportTask::export_to_s3_task) / [`set_export_to_s3_task(Option<ExportToS3TaskSpecification>)`](crate::client::fluent_builders::CreateInstanceExportTask::set_export_to_s3_task): <p>The format and location for an export instance task.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateInstanceExportTask::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateInstanceExportTask::set_instance_id): <p>The ID of the instance.</p>
    ///   - [`target_environment(ExportEnvironment)`](crate::client::fluent_builders::CreateInstanceExportTask::target_environment) / [`set_target_environment(Option<ExportEnvironment>)`](crate::client::fluent_builders::CreateInstanceExportTask::set_target_environment): <p>The target virtualization environment.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateInstanceExportTask::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateInstanceExportTask::set_tag_specifications): <p>The tags to apply to the export instance task during creation.</p>
    /// - On success, responds with [`CreateInstanceExportTaskOutput`](crate::output::CreateInstanceExportTaskOutput) with field(s):
    ///   - [`export_task(Option<ExportTask>)`](crate::output::CreateInstanceExportTaskOutput::export_task): <p>Information about the export instance task.</p>
    /// - On failure, responds with [`SdkError<CreateInstanceExportTaskError>`](crate::error::CreateInstanceExportTaskError)
    pub fn create_instance_export_task(
        &self,
    ) -> fluent_builders::CreateInstanceExportTask<C, M, R> {
        fluent_builders::CreateInstanceExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInternetGateway`](crate::client::fluent_builders::CreateInternetGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateInternetGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateInternetGateway::set_tag_specifications): <p>The tags to assign to the internet gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateInternetGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateInternetGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateInternetGatewayOutput`](crate::output::CreateInternetGatewayOutput) with field(s):
    ///   - [`internet_gateway(Option<InternetGateway>)`](crate::output::CreateInternetGatewayOutput::internet_gateway): <p>Information about the internet gateway.</p>
    /// - On failure, responds with [`SdkError<CreateInternetGatewayError>`](crate::error::CreateInternetGatewayError)
    pub fn create_internet_gateway(&self) -> fluent_builders::CreateInternetGateway<C, M, R> {
        fluent_builders::CreateInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIpam`](crate::client::fluent_builders::CreateIpam) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateIpam::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateIpam::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIpam::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIpam::set_description): <p>A description for the IPAM.</p>
    ///   - [`operating_regions(Vec<AddIpamOperatingRegion>)`](crate::client::fluent_builders::CreateIpam::operating_regions) / [`set_operating_regions(Option<Vec<AddIpamOperatingRegion>>)`](crate::client::fluent_builders::CreateIpam::set_operating_regions): <p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>  <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateIpam::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateIpam::set_tag_specifications): <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateIpam::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateIpam::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    /// - On success, responds with [`CreateIpamOutput`](crate::output::CreateIpamOutput) with field(s):
    ///   - [`ipam(Option<Ipam>)`](crate::output::CreateIpamOutput::ipam): <p>Information about the IPAM created.</p>
    /// - On failure, responds with [`SdkError<CreateIpamError>`](crate::error::CreateIpamError)
    pub fn create_ipam(&self) -> fluent_builders::CreateIpam<C, M, R> {
        fluent_builders::CreateIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIpamPool`](crate::client::fluent_builders::CreateIpamPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateIpamPool::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateIpamPool::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_scope_id(impl Into<String>)`](crate::client::fluent_builders::CreateIpamPool::ipam_scope_id) / [`set_ipam_scope_id(Option<String>)`](crate::client::fluent_builders::CreateIpamPool::set_ipam_scope_id): <p>The ID of the scope in which you would like to create the IPAM pool.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::CreateIpamPool::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::CreateIpamPool::set_locale): <p>In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.</p>  <p>Possible values: Any Amazon Web Services Region, such as us-east-1.</p>
    ///   - [`source_ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateIpamPool::source_ipam_pool_id) / [`set_source_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::CreateIpamPool::set_source_ipam_pool_id): <p>The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIpamPool::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIpamPool::set_description): <p>A description for the IPAM pool.</p>
    ///   - [`address_family(AddressFamily)`](crate::client::fluent_builders::CreateIpamPool::address_family) / [`set_address_family(Option<AddressFamily>)`](crate::client::fluent_builders::CreateIpamPool::set_address_family): <p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>
    ///   - [`auto_import(bool)`](crate::client::fluent_builders::CreateIpamPool::auto_import) / [`set_auto_import(Option<bool>)`](crate::client::fluent_builders::CreateIpamPool::set_auto_import): <p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p>  <p>A locale must be set on the pool for this feature to work.</p>
    ///   - [`publicly_advertisable(bool)`](crate::client::fluent_builders::CreateIpamPool::publicly_advertisable) / [`set_publicly_advertisable(Option<bool>)`](crate::client::fluent_builders::CreateIpamPool::set_publicly_advertisable): <p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>
    ///   - [`allocation_min_netmask_length(i32)`](crate::client::fluent_builders::CreateIpamPool::allocation_min_netmask_length) / [`set_allocation_min_netmask_length(Option<i32>)`](crate::client::fluent_builders::CreateIpamPool::set_allocation_min_netmask_length): <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
    ///   - [`allocation_max_netmask_length(i32)`](crate::client::fluent_builders::CreateIpamPool::allocation_max_netmask_length) / [`set_allocation_max_netmask_length(Option<i32>)`](crate::client::fluent_builders::CreateIpamPool::set_allocation_max_netmask_length): <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
    ///   - [`allocation_default_netmask_length(i32)`](crate::client::fluent_builders::CreateIpamPool::allocation_default_netmask_length) / [`set_allocation_default_netmask_length(Option<i32>)`](crate::client::fluent_builders::CreateIpamPool::set_allocation_default_netmask_length): <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
    ///   - [`allocation_resource_tags(Vec<RequestIpamResourceTag>)`](crate::client::fluent_builders::CreateIpamPool::allocation_resource_tags) / [`set_allocation_resource_tags(Option<Vec<RequestIpamResourceTag>>)`](crate::client::fluent_builders::CreateIpamPool::set_allocation_resource_tags): <p>Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateIpamPool::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateIpamPool::set_tag_specifications): <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateIpamPool::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateIpamPool::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`aws_service(IpamPoolAwsService)`](crate::client::fluent_builders::CreateIpamPool::aws_service) / [`set_aws_service(Option<IpamPoolAwsService>)`](crate::client::fluent_builders::CreateIpamPool::set_aws_service): <p>Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.</p>
    /// - On success, responds with [`CreateIpamPoolOutput`](crate::output::CreateIpamPoolOutput) with field(s):
    ///   - [`ipam_pool(Option<IpamPool>)`](crate::output::CreateIpamPoolOutput::ipam_pool): <p>Information about the IPAM pool created.</p>
    /// - On failure, responds with [`SdkError<CreateIpamPoolError>`](crate::error::CreateIpamPoolError)
    pub fn create_ipam_pool(&self) -> fluent_builders::CreateIpamPool<C, M, R> {
        fluent_builders::CreateIpamPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIpamScope`](crate::client::fluent_builders::CreateIpamScope) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateIpamScope::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateIpamScope::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_id(impl Into<String>)`](crate::client::fluent_builders::CreateIpamScope::ipam_id) / [`set_ipam_id(Option<String>)`](crate::client::fluent_builders::CreateIpamScope::set_ipam_id): <p>The ID of the IPAM for which you're creating this scope.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIpamScope::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIpamScope::set_description): <p>A description for the scope you're creating.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateIpamScope::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateIpamScope::set_tag_specifications): <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateIpamScope::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateIpamScope::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    /// - On success, responds with [`CreateIpamScopeOutput`](crate::output::CreateIpamScopeOutput) with field(s):
    ///   - [`ipam_scope(Option<IpamScope>)`](crate::output::CreateIpamScopeOutput::ipam_scope): <p>Information about the created scope.</p>
    /// - On failure, responds with [`SdkError<CreateIpamScopeError>`](crate::error::CreateIpamScopeError)
    pub fn create_ipam_scope(&self) -> fluent_builders::CreateIpamScope<C, M, R> {
        fluent_builders::CreateIpamScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKeyPair`](crate::client::fluent_builders::CreateKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_name(impl Into<String>)`](crate::client::fluent_builders::CreateKeyPair::key_name) / [`set_key_name(Option<String>)`](crate::client::fluent_builders::CreateKeyPair::set_key_name): <p>A unique name for the key pair.</p>  <p>Constraints: Up to 255 ASCII characters</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateKeyPair::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateKeyPair::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`key_type(KeyType)`](crate::client::fluent_builders::CreateKeyPair::key_type) / [`set_key_type(Option<KeyType>)`](crate::client::fluent_builders::CreateKeyPair::set_key_type): <p>The type of key pair. Note that ED25519 keys are not supported for Windows instances, EC2 Instance Connect, and EC2 Serial Console.</p>  <p>Default: <code>rsa</code> </p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateKeyPair::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateKeyPair::set_tag_specifications): <p>The tags to apply to the new key pair.</p>
    /// - On success, responds with [`CreateKeyPairOutput`](crate::output::CreateKeyPairOutput) with field(s):
    ///   - [`key_fingerprint(Option<String>)`](crate::output::CreateKeyPairOutput::key_fingerprint): <p>The SHA-1 digest of the DER encoded private key.</p>
    ///   - [`key_material(Option<String>)`](crate::output::CreateKeyPairOutput::key_material): <p>An unencrypted PEM encoded RSA or ED25519 private key.</p>
    ///   - [`key_name(Option<String>)`](crate::output::CreateKeyPairOutput::key_name): <p>The name of the key pair.</p>
    ///   - [`key_pair_id(Option<String>)`](crate::output::CreateKeyPairOutput::key_pair_id): <p>The ID of the key pair.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateKeyPairOutput::tags): <p>Any tags applied to the key pair.</p>
    /// - On failure, responds with [`SdkError<CreateKeyPairError>`](crate::error::CreateKeyPairError)
    pub fn create_key_pair(&self) -> fluent_builders::CreateKeyPair<C, M, R> {
        fluent_builders::CreateKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLaunchTemplate`](crate::client::fluent_builders::CreateLaunchTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateLaunchTemplate::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>  <p>Constraint: Maximum 128 ASCII characters.</p>
    ///   - [`launch_template_name(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::launch_template_name) / [`set_launch_template_name(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_launch_template_name): <p>A name for the launch template.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_version_description): <p>A description for the first version of the launch template.</p>
    ///   - [`launch_template_data(RequestLaunchTemplateData)`](crate::client::fluent_builders::CreateLaunchTemplate::launch_template_data) / [`set_launch_template_data(Option<RequestLaunchTemplateData>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_launch_template_data): <p>The information for the launch template.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateLaunchTemplate::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateLaunchTemplate::set_tag_specifications): <p>The tags to apply to the launch template during creation.</p>
    /// - On success, responds with [`CreateLaunchTemplateOutput`](crate::output::CreateLaunchTemplateOutput) with field(s):
    ///   - [`launch_template(Option<LaunchTemplate>)`](crate::output::CreateLaunchTemplateOutput::launch_template): <p>Information about the launch template.</p>
    ///   - [`warning(Option<ValidationWarning>)`](crate::output::CreateLaunchTemplateOutput::warning): <p>If the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.</p>
    /// - On failure, responds with [`SdkError<CreateLaunchTemplateError>`](crate::error::CreateLaunchTemplateError)
    pub fn create_launch_template(&self) -> fluent_builders::CreateLaunchTemplate<C, M, R> {
        fluent_builders::CreateLaunchTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLaunchTemplateVersion`](crate::client::fluent_builders::CreateLaunchTemplateVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>  <p>Constraint: Maximum 128 ASCII characters.</p>
    ///   - [`launch_template_id(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::launch_template_id) / [`set_launch_template_id(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_launch_template_id): <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    ///   - [`launch_template_name(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::launch_template_name) / [`set_launch_template_name(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_launch_template_name): <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_source_version): <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
    ///   - [`version_description(impl Into<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::version_description) / [`set_version_description(Option<String>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_version_description): <p>A description for the version of the launch template.</p>
    ///   - [`launch_template_data(RequestLaunchTemplateData)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::launch_template_data) / [`set_launch_template_data(Option<RequestLaunchTemplateData>)`](crate::client::fluent_builders::CreateLaunchTemplateVersion::set_launch_template_data): <p>The information for the launch template.</p>
    /// - On success, responds with [`CreateLaunchTemplateVersionOutput`](crate::output::CreateLaunchTemplateVersionOutput) with field(s):
    ///   - [`launch_template_version(Option<LaunchTemplateVersion>)`](crate::output::CreateLaunchTemplateVersionOutput::launch_template_version): <p>Information about the launch template version.</p>
    ///   - [`warning(Option<ValidationWarning>)`](crate::output::CreateLaunchTemplateVersionOutput::warning): <p>If the new version of the launch template contains parameters or parameter combinations that are not valid, an error code and an error message are returned for each issue that's found.</p>
    /// - On failure, responds with [`SdkError<CreateLaunchTemplateVersionError>`](crate::error::CreateLaunchTemplateVersionError)
    pub fn create_launch_template_version(
        &self,
    ) -> fluent_builders::CreateLaunchTemplateVersion<C, M, R> {
        fluent_builders::CreateLaunchTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocalGatewayRoute`](crate::client::fluent_builders::CreateLocalGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::set_destination_cidr_block): <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
    ///   - [`local_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::local_gateway_route_table_id) / [`set_local_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::set_local_gateway_route_table_id): <p>The ID of the local gateway route table.</p>
    ///   - [`local_gateway_virtual_interface_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::local_gateway_virtual_interface_group_id) / [`set_local_gateway_virtual_interface_group_id(Option<String>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::set_local_gateway_virtual_interface_group_id): <p>The ID of the virtual interface group.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateLocalGatewayRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateLocalGatewayRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateLocalGatewayRouteOutput`](crate::output::CreateLocalGatewayRouteOutput) with field(s):
    ///   - [`route(Option<LocalGatewayRoute>)`](crate::output::CreateLocalGatewayRouteOutput::route): <p>Information about the route.</p>
    /// - On failure, responds with [`SdkError<CreateLocalGatewayRouteError>`](crate::error::CreateLocalGatewayRouteError)
    pub fn create_local_gateway_route(&self) -> fluent_builders::CreateLocalGatewayRoute<C, M, R> {
        fluent_builders::CreateLocalGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLocalGatewayRouteTableVpcAssociation`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::local_gateway_route_table_id) / [`set_local_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::set_local_gateway_route_table_id): <p>The ID of the local gateway route table.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::set_tag_specifications): <p>The tags to assign to the local gateway route table VPC association.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateLocalGatewayRouteTableVpcAssociationOutput`](crate::output::CreateLocalGatewayRouteTableVpcAssociationOutput) with field(s):
    ///   - [`local_gateway_route_table_vpc_association(Option<LocalGatewayRouteTableVpcAssociation>)`](crate::output::CreateLocalGatewayRouteTableVpcAssociationOutput::local_gateway_route_table_vpc_association): <p>Information about the association.</p>
    /// - On failure, responds with [`SdkError<CreateLocalGatewayRouteTableVpcAssociationError>`](crate::error::CreateLocalGatewayRouteTableVpcAssociationError)
    pub fn create_local_gateway_route_table_vpc_association(
        &self,
    ) -> fluent_builders::CreateLocalGatewayRouteTableVpcAssociation<C, M, R> {
        fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateManagedPrefixList`](crate::client::fluent_builders::CreateManagedPrefixList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateManagedPrefixList::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`prefix_list_name(impl Into<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::prefix_list_name) / [`set_prefix_list_name(Option<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_prefix_list_name): <p>A name for the prefix list.</p>  <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
    ///   - [`entries(Vec<AddPrefixListEntry>)`](crate::client::fluent_builders::CreateManagedPrefixList::entries) / [`set_entries(Option<Vec<AddPrefixListEntry>>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_entries): <p>One or more entries for the prefix list.</p>
    ///   - [`max_entries(i32)`](crate::client::fluent_builders::CreateManagedPrefixList::max_entries) / [`set_max_entries(Option<i32>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_max_entries): <p>The maximum number of entries for the prefix list.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateManagedPrefixList::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_tag_specifications): <p>The tags to apply to the prefix list during creation.</p>
    ///   - [`address_family(impl Into<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::address_family) / [`set_address_family(Option<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_address_family): <p>The IP address type.</p>  <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateManagedPrefixList::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>  <p>Constraints: Up to 255 UTF-8 characters in length.</p>
    /// - On success, responds with [`CreateManagedPrefixListOutput`](crate::output::CreateManagedPrefixListOutput) with field(s):
    ///   - [`prefix_list(Option<ManagedPrefixList>)`](crate::output::CreateManagedPrefixListOutput::prefix_list): <p>Information about the prefix list.</p>
    /// - On failure, responds with [`SdkError<CreateManagedPrefixListError>`](crate::error::CreateManagedPrefixListError)
    pub fn create_managed_prefix_list(&self) -> fluent_builders::CreateManagedPrefixList<C, M, R> {
        fluent_builders::CreateManagedPrefixList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNatGateway`](crate::client::fluent_builders::CreateNatGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`allocation_id(impl Into<String>)`](crate::client::fluent_builders::CreateNatGateway::allocation_id) / [`set_allocation_id(Option<String>)`](crate::client::fluent_builders::CreateNatGateway::set_allocation_id): <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNatGateway::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNatGateway::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>  <p>Constraint: Maximum 64 ASCII characters.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNatGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNatGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateNatGateway::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateNatGateway::set_subnet_id): <p>The subnet in which to create the NAT gateway.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateNatGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateNatGateway::set_tag_specifications): <p>The tags to assign to the NAT gateway.</p>
    ///   - [`connectivity_type(ConnectivityType)`](crate::client::fluent_builders::CreateNatGateway::connectivity_type) / [`set_connectivity_type(Option<ConnectivityType>)`](crate::client::fluent_builders::CreateNatGateway::set_connectivity_type): <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
    /// - On success, responds with [`CreateNatGatewayOutput`](crate::output::CreateNatGatewayOutput) with field(s):
    ///   - [`client_token(Option<String>)`](crate::output::CreateNatGatewayOutput::client_token): <p>Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.</p>
    ///   - [`nat_gateway(Option<NatGateway>)`](crate::output::CreateNatGatewayOutput::nat_gateway): <p>Information about the NAT gateway.</p>
    /// - On failure, responds with [`SdkError<CreateNatGatewayError>`](crate::error::CreateNatGatewayError)
    pub fn create_nat_gateway(&self) -> fluent_builders::CreateNatGateway<C, M, R> {
        fluent_builders::CreateNatGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkAcl`](crate::client::fluent_builders::CreateNetworkAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkAcl::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkAcl::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkAcl::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkAcl::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateNetworkAcl::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateNetworkAcl::set_tag_specifications): <p>The tags to assign to the network ACL.</p>
    /// - On success, responds with [`CreateNetworkAclOutput`](crate::output::CreateNetworkAclOutput) with field(s):
    ///   - [`network_acl(Option<NetworkAcl>)`](crate::output::CreateNetworkAclOutput::network_acl): <p>Information about the network ACL.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkAclError>`](crate::error::CreateNetworkAclError)
    pub fn create_network_acl(&self) -> fluent_builders::CreateNetworkAcl<C, M, R> {
        fluent_builders::CreateNetworkAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkAclEntry`](crate::client::fluent_builders::CreateNetworkAclEntry) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::cidr_block) / [`set_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_cidr_block): <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkAclEntry::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`egress(bool)`](crate::client::fluent_builders::CreateNetworkAclEntry::egress) / [`set_egress(Option<bool>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_egress): <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
    ///   - [`icmp_type_code(IcmpTypeCode)`](crate::client::fluent_builders::CreateNetworkAclEntry::icmp_type_code) / [`set_icmp_type_code(Option<IcmpTypeCode>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_icmp_type_code): <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
    ///   - [`ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::ipv6_cidr_block) / [`set_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_ipv6_cidr_block): <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
    ///   - [`network_acl_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::network_acl_id) / [`set_network_acl_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_network_acl_id): <p>The ID of the network ACL.</p>
    ///   - [`port_range(PortRange)`](crate::client::fluent_builders::CreateNetworkAclEntry::port_range) / [`set_port_range(Option<PortRange>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_port_range): <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
    ///   - [`protocol(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::protocol) / [`set_protocol(Option<String>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_protocol): <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
    ///   - [`rule_action(RuleAction)`](crate::client::fluent_builders::CreateNetworkAclEntry::rule_action) / [`set_rule_action(Option<RuleAction>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_rule_action): <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
    ///   - [`rule_number(i32)`](crate::client::fluent_builders::CreateNetworkAclEntry::rule_number) / [`set_rule_number(Option<i32>)`](crate::client::fluent_builders::CreateNetworkAclEntry::set_rule_number): <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p>  <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
    /// - On success, responds with [`CreateNetworkAclEntryOutput`](crate::output::CreateNetworkAclEntryOutput)

    /// - On failure, responds with [`SdkError<CreateNetworkAclEntryError>`](crate::error::CreateNetworkAclEntryError)
    pub fn create_network_acl_entry(&self) -> fluent_builders::CreateNetworkAclEntry<C, M, R> {
        fluent_builders::CreateNetworkAclEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkInsightsAccessScope`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`match_paths(Vec<AccessScopePathRequest>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::match_paths) / [`set_match_paths(Option<Vec<AccessScopePathRequest>>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::set_match_paths): <p>The paths to match.</p>
    ///   - [`exclude_paths(Vec<AccessScopePathRequest>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::exclude_paths) / [`set_exclude_paths(Option<Vec<AccessScopePathRequest>>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::set_exclude_paths): <p>The paths to exclude.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::set_tag_specifications): <p>The tags to apply.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateNetworkInsightsAccessScopeOutput`](crate::output::CreateNetworkInsightsAccessScopeOutput) with field(s):
    ///   - [`network_insights_access_scope(Option<NetworkInsightsAccessScope>)`](crate::output::CreateNetworkInsightsAccessScopeOutput::network_insights_access_scope): <p>The Network Access Scope.</p>
    ///   - [`network_insights_access_scope_content(Option<NetworkInsightsAccessScopeContent>)`](crate::output::CreateNetworkInsightsAccessScopeOutput::network_insights_access_scope_content): <p>The Network Access Scope content.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkInsightsAccessScopeError>`](crate::error::CreateNetworkInsightsAccessScopeError)
    pub fn create_network_insights_access_scope(
        &self,
    ) -> fluent_builders::CreateNetworkInsightsAccessScope<C, M, R> {
        fluent_builders::CreateNetworkInsightsAccessScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkInsightsPath`](crate::client::fluent_builders::CreateNetworkInsightsPath) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_ip(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::source_ip) / [`set_source_ip(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_source_ip): <p>The IP address of the Amazon Web Services resource that is the source of the path.</p>
    ///   - [`destination_ip(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::destination_ip) / [`set_destination_ip(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_destination_ip): <p>The IP address of the Amazon Web Services resource that is the destination of the path.</p>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_source): <p>The Amazon Web Services resource that is the source of the path.</p>
    ///   - [`destination(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::destination) / [`set_destination(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_destination): <p>The Amazon Web Services resource that is the destination of the path.</p>
    ///   - [`protocol(Protocol)`](crate::client::fluent_builders::CreateNetworkInsightsPath::protocol) / [`set_protocol(Option<Protocol>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_protocol): <p>The protocol.</p>
    ///   - [`destination_port(i32)`](crate::client::fluent_builders::CreateNetworkInsightsPath::destination_port) / [`set_destination_port(Option<i32>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_destination_port): <p>The destination port.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_tag_specifications): <p>The tags to add to the path.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkInsightsPath::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNetworkInsightsPath::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateNetworkInsightsPathOutput`](crate::output::CreateNetworkInsightsPathOutput) with field(s):
    ///   - [`network_insights_path(Option<NetworkInsightsPath>)`](crate::output::CreateNetworkInsightsPathOutput::network_insights_path): <p>Information about the path.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkInsightsPathError>`](crate::error::CreateNetworkInsightsPathError)
    pub fn create_network_insights_path(
        &self,
    ) -> fluent_builders::CreateNetworkInsightsPath<C, M, R> {
        fluent_builders::CreateNetworkInsightsPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkInterface`](crate::client::fluent_builders::CreateNetworkInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterface::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterface::set_description): <p>A description for the network interface.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkInterface::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkInterface::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`groups(Vec<String>)`](crate::client::fluent_builders::CreateNetworkInterface::groups) / [`set_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_groups): <p>The IDs of one or more security groups.</p>
    ///   - [`ipv6_address_count(i32)`](crate::client::fluent_builders::CreateNetworkInterface::ipv6_address_count) / [`set_ipv6_address_count(Option<i32>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv6_address_count): <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
    ///   - [`ipv6_addresses(Vec<InstanceIpv6Address>)`](crate::client::fluent_builders::CreateNetworkInterface::ipv6_addresses) / [`set_ipv6_addresses(Option<Vec<InstanceIpv6Address>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv6_addresses): <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
    ///   - [`private_ip_address(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterface::private_ip_address) / [`set_private_ip_address(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterface::set_private_ip_address): <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
    ///   - [`private_ip_addresses(Vec<PrivateIpAddressSpecification>)`](crate::client::fluent_builders::CreateNetworkInterface::private_ip_addresses) / [`set_private_ip_addresses(Option<Vec<PrivateIpAddressSpecification>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_private_ip_addresses): <p>One or more private IPv4 addresses.</p>
    ///   - [`secondary_private_ip_address_count(i32)`](crate::client::fluent_builders::CreateNetworkInterface::secondary_private_ip_address_count) / [`set_secondary_private_ip_address_count(Option<i32>)`](crate::client::fluent_builders::CreateNetworkInterface::set_secondary_private_ip_address_count): <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p>  <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    ///   - [`ipv4_prefixes(Vec<Ipv4PrefixSpecificationRequest>)`](crate::client::fluent_builders::CreateNetworkInterface::ipv4_prefixes) / [`set_ipv4_prefixes(Option<Vec<Ipv4PrefixSpecificationRequest>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv4_prefixes): <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
    ///   - [`ipv4_prefix_count(i32)`](crate::client::fluent_builders::CreateNetworkInterface::ipv4_prefix_count) / [`set_ipv4_prefix_count(Option<i32>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv4_prefix_count): <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
    ///   - [`ipv6_prefixes(Vec<Ipv6PrefixSpecificationRequest>)`](crate::client::fluent_builders::CreateNetworkInterface::ipv6_prefixes) / [`set_ipv6_prefixes(Option<Vec<Ipv6PrefixSpecificationRequest>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv6_prefixes): <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
    ///   - [`ipv6_prefix_count(i32)`](crate::client::fluent_builders::CreateNetworkInterface::ipv6_prefix_count) / [`set_ipv6_prefix_count(Option<i32>)`](crate::client::fluent_builders::CreateNetworkInterface::set_ipv6_prefix_count): <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
    ///   - [`interface_type(NetworkInterfaceCreationType)`](crate::client::fluent_builders::CreateNetworkInterface::interface_type) / [`set_interface_type(Option<NetworkInterfaceCreationType>)`](crate::client::fluent_builders::CreateNetworkInterface::set_interface_type): <p>Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html"> Elastic Fabric Adapter</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. To create a trunk network interface, specify <code>trunk</code>.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterface::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterface::set_subnet_id): <p>The ID of the subnet to associate with the network interface.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateNetworkInterface::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateNetworkInterface::set_tag_specifications): <p>The tags to apply to the new network interface.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterface::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterface::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    /// - On success, responds with [`CreateNetworkInterfaceOutput`](crate::output::CreateNetworkInterfaceOutput) with field(s):
    ///   - [`network_interface(Option<NetworkInterface>)`](crate::output::CreateNetworkInterfaceOutput::network_interface): <p>Information about the network interface.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateNetworkInterfaceOutput::client_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkInterfaceError>`](crate::error::CreateNetworkInterfaceError)
    pub fn create_network_interface(&self) -> fluent_builders::CreateNetworkInterface<C, M, R> {
        fluent_builders::CreateNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetworkInterfacePermission`](crate::client::fluent_builders::CreateNetworkInterfacePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::set_network_interface_id): <p>The ID of the network interface.</p>
    ///   - [`aws_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::aws_account_id) / [`set_aws_account_id(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::set_aws_account_id): <p>The Amazon Web Services account ID.</p>
    ///   - [`aws_service(impl Into<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::aws_service) / [`set_aws_service(Option<String>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::set_aws_service): <p>The Amazon Web Service. Currently not supported.</p>
    ///   - [`permission(InterfacePermissionType)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::permission) / [`set_permission(Option<InterfacePermissionType>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::set_permission): <p>The type of permission to grant.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateNetworkInterfacePermission::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateNetworkInterfacePermissionOutput`](crate::output::CreateNetworkInterfacePermissionOutput) with field(s):
    ///   - [`interface_permission(Option<NetworkInterfacePermission>)`](crate::output::CreateNetworkInterfacePermissionOutput::interface_permission): <p>Information about the permission for the network interface.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkInterfacePermissionError>`](crate::error::CreateNetworkInterfacePermissionError)
    pub fn create_network_interface_permission(
        &self,
    ) -> fluent_builders::CreateNetworkInterfacePermission<C, M, R> {
        fluent_builders::CreateNetworkInterfacePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePlacementGroup`](crate::client::fluent_builders::CreatePlacementGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreatePlacementGroup::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreatePlacementGroup::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreatePlacementGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreatePlacementGroup::set_group_name): <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p>  <p>Constraints: Up to 255 ASCII characters</p>
    ///   - [`strategy(PlacementStrategy)`](crate::client::fluent_builders::CreatePlacementGroup::strategy) / [`set_strategy(Option<PlacementStrategy>)`](crate::client::fluent_builders::CreatePlacementGroup::set_strategy): <p>The placement strategy.</p>
    ///   - [`partition_count(i32)`](crate::client::fluent_builders::CreatePlacementGroup::partition_count) / [`set_partition_count(Option<i32>)`](crate::client::fluent_builders::CreatePlacementGroup::set_partition_count): <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreatePlacementGroup::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreatePlacementGroup::set_tag_specifications): <p>The tags to apply to the new placement group.</p>
    /// - On success, responds with [`CreatePlacementGroupOutput`](crate::output::CreatePlacementGroupOutput) with field(s):
    ///   - [`placement_group(Option<PlacementGroup>)`](crate::output::CreatePlacementGroupOutput::placement_group): <p>Describes a placement group.</p>
    /// - On failure, responds with [`SdkError<CreatePlacementGroupError>`](crate::error::CreatePlacementGroupError)
    pub fn create_placement_group(&self) -> fluent_builders::CreatePlacementGroup<C, M, R> {
        fluent_builders::CreatePlacementGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePublicIpv4Pool`](crate::client::fluent_builders::CreatePublicIpv4Pool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreatePublicIpv4Pool::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreatePublicIpv4Pool::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreatePublicIpv4Pool::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreatePublicIpv4Pool::set_tag_specifications): <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
    /// - On success, responds with [`CreatePublicIpv4PoolOutput`](crate::output::CreatePublicIpv4PoolOutput) with field(s):
    ///   - [`pool_id(Option<String>)`](crate::output::CreatePublicIpv4PoolOutput::pool_id): <p>The ID of the public IPv4 pool.</p>
    /// - On failure, responds with [`SdkError<CreatePublicIpv4PoolError>`](crate::error::CreatePublicIpv4PoolError)
    pub fn create_public_ipv4_pool(&self) -> fluent_builders::CreatePublicIpv4Pool<C, M, R> {
        fluent_builders::CreatePublicIpv4Pool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplaceRootVolumeTask`](crate::client::fluent_builders::CreateReplaceRootVolumeTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::set_instance_id): <p>The ID of the instance for which to replace the root volume.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::set_snapshot_id): <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateReplaceRootVolumeTask::set_tag_specifications): <p>The tags to apply to the root volume replacement task.</p>
    /// - On success, responds with [`CreateReplaceRootVolumeTaskOutput`](crate::output::CreateReplaceRootVolumeTaskOutput) with field(s):
    ///   - [`replace_root_volume_task(Option<ReplaceRootVolumeTask>)`](crate::output::CreateReplaceRootVolumeTaskOutput::replace_root_volume_task): <p>Information about the root volume replacement task.</p>
    /// - On failure, responds with [`SdkError<CreateReplaceRootVolumeTaskError>`](crate::error::CreateReplaceRootVolumeTaskError)
    pub fn create_replace_root_volume_task(
        &self,
    ) -> fluent_builders::CreateReplaceRootVolumeTask<C, M, R> {
        fluent_builders::CreateReplaceRootVolumeTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReservedInstancesListing`](crate::client::fluent_builders::CreateReservedInstancesListing) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateReservedInstancesListing::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateReservedInstancesListing::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
    ///   - [`instance_count(i32)`](crate::client::fluent_builders::CreateReservedInstancesListing::instance_count) / [`set_instance_count(Option<i32>)`](crate::client::fluent_builders::CreateReservedInstancesListing::set_instance_count): <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
    ///   - [`price_schedules(Vec<PriceScheduleSpecification>)`](crate::client::fluent_builders::CreateReservedInstancesListing::price_schedules) / [`set_price_schedules(Option<Vec<PriceScheduleSpecification>>)`](crate::client::fluent_builders::CreateReservedInstancesListing::set_price_schedules): <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
    ///   - [`reserved_instances_id(impl Into<String>)`](crate::client::fluent_builders::CreateReservedInstancesListing::reserved_instances_id) / [`set_reserved_instances_id(Option<String>)`](crate::client::fluent_builders::CreateReservedInstancesListing::set_reserved_instances_id): <p>The ID of the active Standard Reserved Instance.</p>
    /// - On success, responds with [`CreateReservedInstancesListingOutput`](crate::output::CreateReservedInstancesListingOutput) with field(s):
    ///   - [`reserved_instances_listings(Option<Vec<ReservedInstancesListing>>)`](crate::output::CreateReservedInstancesListingOutput::reserved_instances_listings): <p>Information about the Standard Reserved Instance listing.</p>
    /// - On failure, responds with [`SdkError<CreateReservedInstancesListingError>`](crate::error::CreateReservedInstancesListingError)
    pub fn create_reserved_instances_listing(
        &self,
    ) -> fluent_builders::CreateReservedInstancesListing<C, M, R> {
        fluent_builders::CreateReservedInstancesListing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRestoreImageTask`](crate::client::fluent_builders::CreateRestoreImageTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::set_bucket): <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
    ///   - [`object_key(impl Into<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::object_key) / [`set_object_key(Option<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::set_object_key): <p>The name of the stored AMI object in the bucket.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRestoreImageTask::set_name): <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateRestoreImageTask::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateRestoreImageTask::set_tag_specifications): <p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p>  <ul>   <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>   <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateRestoreImageTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateRestoreImageTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateRestoreImageTaskOutput`](crate::output::CreateRestoreImageTaskOutput) with field(s):
    ///   - [`image_id(Option<String>)`](crate::output::CreateRestoreImageTaskOutput::image_id): <p>The AMI ID.</p>
    /// - On failure, responds with [`SdkError<CreateRestoreImageTaskError>`](crate::error::CreateRestoreImageTaskError)
    pub fn create_restore_image_task(&self) -> fluent_builders::CreateRestoreImageTask<C, M, R> {
        fluent_builders::CreateRestoreImageTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoute`](crate::client::fluent_builders::CreateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_destination_cidr_block): <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    ///   - [`destination_ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::destination_ipv6_cidr_block) / [`set_destination_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_destination_ipv6_cidr_block): <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
    ///   - [`destination_prefix_list_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::destination_prefix_list_id) / [`set_destination_prefix_list_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_destination_prefix_list_id): <p>The ID of a prefix list used for the destination match.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::vpc_endpoint_id) / [`set_vpc_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_vpc_endpoint_id): <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
    ///   - [`egress_only_internet_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::egress_only_internet_gateway_id) / [`set_egress_only_internet_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_egress_only_internet_gateway_id): <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
    ///   - [`gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::gateway_id) / [`set_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_gateway_id): <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_instance_id): <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
    ///   - [`nat_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::nat_gateway_id) / [`set_nat_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_nat_gateway_id): <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_transit_gateway_id): <p>The ID of a transit gateway.</p>
    ///   - [`local_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::local_gateway_id) / [`set_local_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_local_gateway_id): <p>The ID of the local gateway.</p>
    ///   - [`carrier_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::carrier_gateway_id) / [`set_carrier_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_carrier_gateway_id): <p>The ID of the carrier gateway.</p>  <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_network_interface_id): <p>The ID of a network interface.</p>
    ///   - [`route_table_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::route_table_id) / [`set_route_table_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_route_table_id): <p>The ID of the route table for the route.</p>
    ///   - [`vpc_peering_connection_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::vpc_peering_connection_id) / [`set_vpc_peering_connection_id(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_vpc_peering_connection_id): <p>The ID of a VPC peering connection.</p>
    ///   - [`core_network_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::core_network_arn) / [`set_core_network_arn(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_core_network_arn): <p>The Amazon Resource Name (ARN) of the core network.</p>
    /// - On success, responds with [`CreateRouteOutput`](crate::output::CreateRouteOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::CreateRouteOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    /// - On failure, responds with [`SdkError<CreateRouteError>`](crate::error::CreateRouteError)
    pub fn create_route(&self) -> fluent_builders::CreateRoute<C, M, R> {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRouteTable`](crate::client::fluent_builders::CreateRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateRouteTable::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateRouteTable::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateRouteTable::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateRouteTable::set_tag_specifications): <p>The tags to assign to the route table.</p>
    /// - On success, responds with [`CreateRouteTableOutput`](crate::output::CreateRouteTableOutput) with field(s):
    ///   - [`route_table(Option<RouteTable>)`](crate::output::CreateRouteTableOutput::route_table): <p>Information about the route table.</p>
    /// - On failure, responds with [`SdkError<CreateRouteTableError>`](crate::error::CreateRouteTableError)
    pub fn create_route_table(&self) -> fluent_builders::CreateRouteTable<C, M, R> {
        fluent_builders::CreateRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSecurityGroup`](crate::client::fluent_builders::CreateSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSecurityGroup::set_description): <p>A description for the security group. This is informational only.</p>  <p>Constraints: Up to 255 characters in length</p>  <p>Constraints for EC2-Classic: ASCII characters</p>  <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::CreateSecurityGroup::set_group_name): <p>The name of the security group.</p>  <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p>  <p>Constraints for EC2-Classic: ASCII characters</p>  <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityGroup::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateSecurityGroup::set_vpc_id): <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateSecurityGroup::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateSecurityGroup::set_tag_specifications): <p>The tags to assign to the security group.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSecurityGroup::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSecurityGroup::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateSecurityGroupOutput`](crate::output::CreateSecurityGroupOutput) with field(s):
    ///   - [`group_id(Option<String>)`](crate::output::CreateSecurityGroupOutput::group_id): <p>The ID of the security group.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateSecurityGroupOutput::tags): <p>The tags assigned to the security group.</p>
    /// - On failure, responds with [`SdkError<CreateSecurityGroupError>`](crate::error::CreateSecurityGroupError)
    pub fn create_security_group(&self) -> fluent_builders::CreateSecurityGroup<C, M, R> {
        fluent_builders::CreateSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_description): <p>A description for the snapshot.</p>
    ///   - [`outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::outpost_arn) / [`set_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>  <ul>   <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li>   <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li>   <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_volume_id): <p>The ID of the Amazon EBS volume.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateSnapshot::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateSnapshot::set_tag_specifications): <p>The tags to apply to the snapshot during creation.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSnapshot::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSnapshot::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`data_encryption_key_id(Option<String>)`](crate::output::CreateSnapshotOutput::data_encryption_key_id): <p>The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by <code>DescribeSnapshots</code>.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateSnapshotOutput::description): <p>The description for the snapshot.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::CreateSnapshotOutput::encrypted): <p>Indicates whether the snapshot is encrypted.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::CreateSnapshotOutput::kms_key_id): <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the parent volume.</p>
    ///   - [`owner_id(Option<String>)`](crate::output::CreateSnapshotOutput::owner_id): <p>The ID of the Amazon Web Services account that owns the EBS snapshot.</p>
    ///   - [`progress(Option<String>)`](crate::output::CreateSnapshotOutput::progress): <p>The progress of the snapshot, as a percentage.</p>
    ///   - [`snapshot_id(Option<String>)`](crate::output::CreateSnapshotOutput::snapshot_id): <p>The ID of the snapshot. Each snapshot receives a unique identifier when it is created.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::CreateSnapshotOutput::start_time): <p>The time stamp when the snapshot was initiated.</p>
    ///   - [`state(Option<SnapshotState>)`](crate::output::CreateSnapshotOutput::state): <p>The snapshot state.</p>
    ///   - [`state_message(Option<String>)`](crate::output::CreateSnapshotOutput::state_message): <p>Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error state details to help you diagnose why the error occurred. This parameter is only returned by <code>DescribeSnapshots</code>.</p>
    ///   - [`volume_id(Option<String>)`](crate::output::CreateSnapshotOutput::volume_id): <p>The ID of the volume that was used to create the snapshot. Snapshots created by the <code>CopySnapshot</code> action have an arbitrary volume ID that should not be used for any purpose.</p>
    ///   - [`volume_size(Option<i32>)`](crate::output::CreateSnapshotOutput::volume_size): <p>The size of the volume, in GiB.</p>
    ///   - [`owner_alias(Option<String>)`](crate::output::CreateSnapshotOutput::owner_alias): <p>The Amazon Web Services owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured Amazon Web Services account alias set using the IAM console.</p>
    ///   - [`outpost_arn(Option<String>)`](crate::output::CreateSnapshotOutput::outpost_arn): <p>The ARN of the Outpost on which the snapshot is stored. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html">Amazon EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateSnapshotOutput::tags): <p>Any tags assigned to the snapshot.</p>
    ///   - [`storage_tier(Option<StorageTier>)`](crate::output::CreateSnapshotOutput::storage_tier): <p>The storage tier in which the snapshot is stored. <code>standard</code> indicates that the snapshot is stored in the standard snapshot storage tier and that it is ready for use. <code>archive</code> indicates that the snapshot is currently archived and that it must be restored before it can be used.</p>
    ///   - [`restore_expiry_time(Option<DateTime>)`](crate::output::CreateSnapshotOutput::restore_expiry_time): <p>Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily restored snapshot will be automatically re-archived.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshots`](crate::client::fluent_builders::CreateSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshots::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshots::set_description): <p> A description propagated to every snapshot specified by the instance.</p>
    ///   - [`instance_specification(InstanceSpecification)`](crate::client::fluent_builders::CreateSnapshots::instance_specification) / [`set_instance_specification(Option<InstanceSpecification>)`](crate::client::fluent_builders::CreateSnapshots::set_instance_specification): <p>The instance to specify which volumes should be included in the snapshots.</p>
    ///   - [`outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshots::outpost_arn) / [`set_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateSnapshots::set_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.</p>  <ul>   <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li>   <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li>   <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Create multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateSnapshots::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateSnapshots::set_tag_specifications): <p>Tags to apply to every snapshot specified by the instance.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSnapshots::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSnapshots::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`copy_tags_from_source(CopyTagsFromSource)`](crate::client::fluent_builders::CreateSnapshots::copy_tags_from_source) / [`set_copy_tags_from_source(Option<CopyTagsFromSource>)`](crate::client::fluent_builders::CreateSnapshots::set_copy_tags_from_source): <p>Copies the tags from the specified volume to corresponding snapshot.</p>
    /// - On success, responds with [`CreateSnapshotsOutput`](crate::output::CreateSnapshotsOutput) with field(s):
    ///   - [`snapshots(Option<Vec<SnapshotInfo>>)`](crate::output::CreateSnapshotsOutput::snapshots): <p>List of snapshots.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotsError>`](crate::error::CreateSnapshotsError)
    pub fn create_snapshots(&self) -> fluent_builders::CreateSnapshots<C, M, R> {
        fluent_builders::CreateSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSpotDatafeedSubscription`](crate::client::fluent_builders::CreateSpotDatafeedSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::set_bucket): <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::CreateSpotDatafeedSubscription::set_prefix): <p>The prefix for the data feed file names.</p>
    /// - On success, responds with [`CreateSpotDatafeedSubscriptionOutput`](crate::output::CreateSpotDatafeedSubscriptionOutput) with field(s):
    ///   - [`spot_datafeed_subscription(Option<SpotDatafeedSubscription>)`](crate::output::CreateSpotDatafeedSubscriptionOutput::spot_datafeed_subscription): <p>The Spot Instance data feed subscription.</p>
    /// - On failure, responds with [`SdkError<CreateSpotDatafeedSubscriptionError>`](crate::error::CreateSpotDatafeedSubscriptionError)
    pub fn create_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::CreateSpotDatafeedSubscription<C, M, R> {
        fluent_builders::CreateSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStoreImageTask`](crate::client::fluent_builders::CreateStoreImageTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::CreateStoreImageTask::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::CreateStoreImageTask::set_image_id): <p>The ID of the AMI.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateStoreImageTask::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateStoreImageTask::set_bucket): <p>The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
    ///   - [`s3_object_tags(Vec<S3ObjectTag>)`](crate::client::fluent_builders::CreateStoreImageTask::s3_object_tags) / [`set_s3_object_tags(Option<Vec<S3ObjectTag>>)`](crate::client::fluent_builders::CreateStoreImageTask::set_s3_object_tags): <p>The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. </p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateStoreImageTask::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateStoreImageTask::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateStoreImageTaskOutput`](crate::output::CreateStoreImageTaskOutput) with field(s):
    ///   - [`object_key(Option<String>)`](crate::output::CreateStoreImageTaskOutput::object_key): <p>The name of the stored AMI object in the S3 bucket.</p>
    /// - On failure, responds with [`SdkError<CreateStoreImageTaskError>`](crate::error::CreateStoreImageTaskError)
    pub fn create_store_image_task(&self) -> fluent_builders::CreateStoreImageTask<C, M, R> {
        fluent_builders::CreateStoreImageTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSubnet`](crate::client::fluent_builders::CreateSubnet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateSubnet::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateSubnet::set_tag_specifications): <p>The tags to assign to the subnet.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_availability_zone): <p>The Availability Zone or Local Zone for the subnet.</p>  <p>Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p>  <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>  <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
    ///   - [`availability_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::availability_zone_id) / [`set_availability_zone_id(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_availability_zone_id): <p>The AZ ID or the Local Zone ID of the subnet.</p>
    ///   - [`cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::cidr_block) / [`set_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_cidr_block): <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>  <p>This parameter is not supported for an IPv6 only subnet.</p>
    ///   - [`ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::ipv6_cidr_block) / [`set_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_ipv6_cidr_block): <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>  <p>This parameter is required for an IPv6 only subnet.</p>
    ///   - [`outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::outpost_arn) / [`set_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateSubnet::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateSubnet::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSubnet::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSubnet::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipv6_native(bool)`](crate::client::fluent_builders::CreateSubnet::ipv6_native) / [`set_ipv6_native(Option<bool>)`](crate::client::fluent_builders::CreateSubnet::set_ipv6_native): <p>Indicates whether to create an IPv6 only subnet.</p>
    /// - On success, responds with [`CreateSubnetOutput`](crate::output::CreateSubnetOutput) with field(s):
    ///   - [`subnet(Option<Subnet>)`](crate::output::CreateSubnetOutput::subnet): <p>Information about the subnet.</p>
    /// - On failure, responds with [`SdkError<CreateSubnetError>`](crate::error::CreateSubnetError)
    pub fn create_subnet(&self) -> fluent_builders::CreateSubnet<C, M, R> {
        fluent_builders::CreateSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSubnetCidrReservation`](crate::client::fluent_builders::CreateSubnetCidrReservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_tag_specifications): <p>The tags to assign to the subnet CIDR reservation.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_subnet_id): <p>The ID of the subnet.</p>
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_cidr): <p>The IPv4 or IPV6 CIDR range to reserve.</p>
    ///   - [`reservation_type(SubnetCidrReservationType)`](crate::client::fluent_builders::CreateSubnetCidrReservation::reservation_type) / [`set_reservation_type(Option<SubnetCidrReservationType>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_reservation_type): <p>The type of reservation.</p>  <p>The following are valid values:</p>  <ul>   <li> <p> <code>prefix</code>: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation for Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li>   <li> <p> <code>explicit</code>: You manually assign the IP addresses to resources that reside in your subnet. </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_description): <p>The description to assign to the subnet CIDR reservation.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSubnetCidrReservation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSubnetCidrReservation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateSubnetCidrReservationOutput`](crate::output::CreateSubnetCidrReservationOutput) with field(s):
    ///   - [`subnet_cidr_reservation(Option<SubnetCidrReservation>)`](crate::output::CreateSubnetCidrReservationOutput::subnet_cidr_reservation): <p>Information about the created subnet CIDR reservation.</p>
    /// - On failure, responds with [`SdkError<CreateSubnetCidrReservationError>`](crate::error::CreateSubnetCidrReservationError)
    pub fn create_subnet_cidr_reservation(
        &self,
    ) -> fluent_builders::CreateSubnetCidrReservation<C, M, R> {
        fluent_builders::CreateSubnetCidrReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTags::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTags::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`resources(Vec<String>)`](crate::client::fluent_builders::CreateTags::resources) / [`set_resources(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTags::set_resources): <p>The IDs of the resources, separated by spaces.</p>  <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>The tags. The <code>value</code> parameter is required, but if you don't want the tag to have a value, specify the parameter with no value, and we set the value to an empty string.</p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficMirrorFilter`](crate::client::fluent_builders::CreateTrafficMirrorFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::set_description): <p>The description of the Traffic Mirror filter.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::set_tag_specifications): <p>The tags to assign to a Traffic Mirror filter.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilter::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateTrafficMirrorFilterOutput`](crate::output::CreateTrafficMirrorFilterOutput) with field(s):
    ///   - [`traffic_mirror_filter(Option<TrafficMirrorFilter>)`](crate::output::CreateTrafficMirrorFilterOutput::traffic_mirror_filter): <p>Information about the Traffic Mirror filter.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateTrafficMirrorFilterOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficMirrorFilterError>`](crate::error::CreateTrafficMirrorFilterError)
    pub fn create_traffic_mirror_filter(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorFilter<C, M, R> {
        fluent_builders::CreateTrafficMirrorFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficMirrorFilterRule`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_filter_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::traffic_mirror_filter_id) / [`set_traffic_mirror_filter_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_traffic_mirror_filter_id): <p>The ID of the filter that this rule is associated with.</p>
    ///   - [`traffic_direction(TrafficDirection)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::traffic_direction) / [`set_traffic_direction(Option<TrafficDirection>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_traffic_direction): <p>The type of traffic.</p>
    ///   - [`rule_number(i32)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::rule_number) / [`set_rule_number(Option<i32>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_rule_number): <p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>
    ///   - [`rule_action(TrafficMirrorRuleAction)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::rule_action) / [`set_rule_action(Option<TrafficMirrorRuleAction>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_rule_action): <p>The action to take on the filtered traffic.</p>
    ///   - [`destination_port_range(TrafficMirrorPortRangeRequest)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::destination_port_range) / [`set_destination_port_range(Option<TrafficMirrorPortRangeRequest>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_destination_port_range): <p>The destination port range.</p>
    ///   - [`source_port_range(TrafficMirrorPortRangeRequest)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::source_port_range) / [`set_source_port_range(Option<TrafficMirrorPortRangeRequest>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_source_port_range): <p>The source port range.</p>
    ///   - [`protocol(i32)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::protocol) / [`set_protocol(Option<i32>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_protocol): <p>The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>  <p>For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the Internet Assigned Numbers Authority (IANA) website.</p>
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_destination_cidr_block): <p>The destination CIDR block to assign to the Traffic Mirror rule.</p>
    ///   - [`source_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::source_cidr_block) / [`set_source_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_source_cidr_block): <p>The source CIDR block to assign to the Traffic Mirror rule.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_description): <p>The description of the Traffic Mirror rule.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateTrafficMirrorFilterRuleOutput`](crate::output::CreateTrafficMirrorFilterRuleOutput) with field(s):
    ///   - [`traffic_mirror_filter_rule(Option<TrafficMirrorFilterRule>)`](crate::output::CreateTrafficMirrorFilterRuleOutput::traffic_mirror_filter_rule): <p>The Traffic Mirror rule.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateTrafficMirrorFilterRuleOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficMirrorFilterRuleError>`](crate::error::CreateTrafficMirrorFilterRuleError)
    pub fn create_traffic_mirror_filter_rule(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorFilterRule<C, M, R> {
        fluent_builders::CreateTrafficMirrorFilterRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficMirrorSession`](crate::client::fluent_builders::CreateTrafficMirrorSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_network_interface_id): <p>The ID of the source network interface.</p>
    ///   - [`traffic_mirror_target_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::traffic_mirror_target_id) / [`set_traffic_mirror_target_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_traffic_mirror_target_id): <p>The ID of the Traffic Mirror target.</p>
    ///   - [`traffic_mirror_filter_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::traffic_mirror_filter_id) / [`set_traffic_mirror_filter_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_traffic_mirror_filter_id): <p>The ID of the Traffic Mirror filter.</p>
    ///   - [`packet_length(i32)`](crate::client::fluent_builders::CreateTrafficMirrorSession::packet_length) / [`set_packet_length(Option<i32>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_packet_length): <p>The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target.</p>  <p>If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify the number of bytes in each packet to mirror.</p>
    ///   - [`session_number(i32)`](crate::client::fluent_builders::CreateTrafficMirrorSession::session_number) / [`set_session_number(Option<i32>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_session_number): <p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>  <p>Valid values are 1-32766.</p>
    ///   - [`virtual_network_id(i32)`](crate::client::fluent_builders::CreateTrafficMirrorSession::virtual_network_id) / [`set_virtual_network_id(Option<i32>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_virtual_network_id): <p>The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_description): <p>The description of the Traffic Mirror session.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_tag_specifications): <p>The tags to assign to a Traffic Mirror session.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTrafficMirrorSession::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorSession::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateTrafficMirrorSessionOutput`](crate::output::CreateTrafficMirrorSessionOutput) with field(s):
    ///   - [`traffic_mirror_session(Option<TrafficMirrorSession>)`](crate::output::CreateTrafficMirrorSessionOutput::traffic_mirror_session): <p>Information about the Traffic Mirror session.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateTrafficMirrorSessionOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficMirrorSessionError>`](crate::error::CreateTrafficMirrorSessionError)
    pub fn create_traffic_mirror_session(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorSession<C, M, R> {
        fluent_builders::CreateTrafficMirrorSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficMirrorTarget`](crate::client::fluent_builders::CreateTrafficMirrorTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_network_interface_id): <p>The network interface ID that is associated with the target.</p>
    ///   - [`network_load_balancer_arn(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::network_load_balancer_arn) / [`set_network_load_balancer_arn(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_network_load_balancer_arn): <p>The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_description): <p>The description of the Traffic Mirror target.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_tag_specifications): <p>The tags to assign to the Traffic Mirror target.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTrafficMirrorTarget::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateTrafficMirrorTargetOutput`](crate::output::CreateTrafficMirrorTargetOutput) with field(s):
    ///   - [`traffic_mirror_target(Option<TrafficMirrorTarget>)`](crate::output::CreateTrafficMirrorTargetOutput::traffic_mirror_target): <p>Information about the Traffic Mirror target.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateTrafficMirrorTargetOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficMirrorTargetError>`](crate::error::CreateTrafficMirrorTargetError)
    pub fn create_traffic_mirror_target(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorTarget<C, M, R> {
        fluent_builders::CreateTrafficMirrorTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGateway`](crate::client::fluent_builders::CreateTransitGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGateway::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTransitGateway::set_description): <p>A description of the transit gateway.</p>
    ///   - [`options(TransitGatewayRequestOptions)`](crate::client::fluent_builders::CreateTransitGateway::options) / [`set_options(Option<TransitGatewayRequestOptions>)`](crate::client::fluent_builders::CreateTransitGateway::set_options): <p>The transit gateway options.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGateway::set_tag_specifications): <p>The tags to apply to the transit gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayOutput`](crate::output::CreateTransitGatewayOutput) with field(s):
    ///   - [`transit_gateway(Option<TransitGateway>)`](crate::output::CreateTransitGatewayOutput::transit_gateway): <p>Information about the transit gateway.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayError>`](crate::error::CreateTransitGatewayError)
    pub fn create_transit_gateway(&self) -> fluent_builders::CreateTransitGateway<C, M, R> {
        fluent_builders::CreateTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayConnect`](crate::client::fluent_builders::CreateTransitGatewayConnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transport_transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::transport_transit_gateway_attachment_id) / [`set_transport_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::set_transport_transit_gateway_attachment_id): <p>The ID of the transit gateway attachment. You can specify a VPC attachment or Amazon Web Services Direct Connect attachment.</p>
    ///   - [`options(CreateTransitGatewayConnectRequestOptions)`](crate::client::fluent_builders::CreateTransitGatewayConnect::options) / [`set_options(Option<CreateTransitGatewayConnectRequestOptions>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::set_options): <p>The Connect attachment options.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::set_tag_specifications): <p>The tags to apply to the Connect attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayConnect::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayConnect::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayConnectOutput`](crate::output::CreateTransitGatewayConnectOutput) with field(s):
    ///   - [`transit_gateway_connect(Option<TransitGatewayConnect>)`](crate::output::CreateTransitGatewayConnectOutput::transit_gateway_connect): <p>Information about the Connect attachment.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayConnectError>`](crate::error::CreateTransitGatewayConnectError)
    pub fn create_transit_gateway_connect(
        &self,
    ) -> fluent_builders::CreateTransitGatewayConnect<C, M, R> {
        fluent_builders::CreateTransitGatewayConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayConnectPeer`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_transit_gateway_attachment_id): <p>The ID of the Connect attachment.</p>
    ///   - [`transit_gateway_address(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::transit_gateway_address) / [`set_transit_gateway_address(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_transit_gateway_address): <p>The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first available IP address from the transit gateway CIDR block.</p>
    ///   - [`peer_address(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::peer_address) / [`set_peer_address(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_peer_address): <p>The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.</p>
    ///   - [`bgp_options(TransitGatewayConnectRequestBgpOptions)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::bgp_options) / [`set_bgp_options(Option<TransitGatewayConnectRequestBgpOptions>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_bgp_options): <p>The BGP options for the Connect peer.</p>
    ///   - [`inside_cidr_blocks(Vec<String>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::inside_cidr_blocks) / [`set_inside_cidr_blocks(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_inside_cidr_blocks): <p>The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block from the <code>169.254.0.0/16</code> range. The first address from the range must be configured on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the <code>fd00::/8</code> range.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_tag_specifications): <p>The tags to apply to the Connect peer.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayConnectPeerOutput`](crate::output::CreateTransitGatewayConnectPeerOutput) with field(s):
    ///   - [`transit_gateway_connect_peer(Option<TransitGatewayConnectPeer>)`](crate::output::CreateTransitGatewayConnectPeerOutput::transit_gateway_connect_peer): <p>Information about the Connect peer.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayConnectPeerError>`](crate::error::CreateTransitGatewayConnectPeerError)
    pub fn create_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::CreateTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::CreateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayMulticastDomain`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::set_transit_gateway_id): <p>The ID of the transit gateway.</p>
    ///   - [`options(CreateTransitGatewayMulticastDomainRequestOptions)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::options) / [`set_options(Option<CreateTransitGatewayMulticastDomainRequestOptions>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::set_options): <p>The options for the transit gateway multicast domain.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::set_tag_specifications): <p>The tags for the transit gateway multicast domain.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayMulticastDomainOutput`](crate::output::CreateTransitGatewayMulticastDomainOutput) with field(s):
    ///   - [`transit_gateway_multicast_domain(Option<TransitGatewayMulticastDomain>)`](crate::output::CreateTransitGatewayMulticastDomainOutput::transit_gateway_multicast_domain): <p>Information about the transit gateway multicast domain.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayMulticastDomainError>`](crate::error::CreateTransitGatewayMulticastDomainError)
    pub fn create_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::CreateTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::CreateTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayPeeringAttachment`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_transit_gateway_id): <p>The ID of the transit gateway.</p>
    ///   - [`peer_transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::peer_transit_gateway_id) / [`set_peer_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_peer_transit_gateway_id): <p>The ID of the peer transit gateway with which to create the peering attachment.</p>
    ///   - [`peer_account_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::peer_account_id) / [`set_peer_account_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_peer_account_id): <p>The ID of the Amazon Web Services account that owns the peer transit gateway.</p>
    ///   - [`peer_region(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::peer_region) / [`set_peer_region(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_peer_region): <p>The Region where the peer transit gateway is located.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_tag_specifications): <p>The tags to apply to the transit gateway peering attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayPeeringAttachmentOutput`](crate::output::CreateTransitGatewayPeeringAttachmentOutput) with field(s):
    ///   - [`transit_gateway_peering_attachment(Option<TransitGatewayPeeringAttachment>)`](crate::output::CreateTransitGatewayPeeringAttachmentOutput::transit_gateway_peering_attachment): <p>The transit gateway peering attachment.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayPeeringAttachmentError>`](crate::error::CreateTransitGatewayPeeringAttachmentError)
    pub fn create_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::CreateTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::CreateTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayPrefixListReference`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::set_transit_gateway_route_table_id): <p>The ID of the transit gateway route table.</p>
    ///   - [`prefix_list_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::prefix_list_id) / [`set_prefix_list_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::set_prefix_list_id): <p>The ID of the prefix list that is used for destination matches.</p>
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::set_transit_gateway_attachment_id): <p>The ID of the attachment to which traffic is routed.</p>
    ///   - [`blackhole(bool)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::blackhole) / [`set_blackhole(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::set_blackhole): <p>Indicates whether to drop traffic that matches this route.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayPrefixListReferenceOutput`](crate::output::CreateTransitGatewayPrefixListReferenceOutput) with field(s):
    ///   - [`transit_gateway_prefix_list_reference(Option<TransitGatewayPrefixListReference>)`](crate::output::CreateTransitGatewayPrefixListReferenceOutput::transit_gateway_prefix_list_reference): <p>Information about the prefix list reference.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayPrefixListReferenceError>`](crate::error::CreateTransitGatewayPrefixListReferenceError)
    pub fn create_transit_gateway_prefix_list_reference(
        &self,
    ) -> fluent_builders::CreateTransitGatewayPrefixListReference<C, M, R> {
        fluent_builders::CreateTransitGatewayPrefixListReference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayRoute`](crate::client::fluent_builders::CreateTransitGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::set_destination_cidr_block): <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::set_transit_gateway_route_table_id): <p>The ID of the transit gateway route table.</p>
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::set_transit_gateway_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`blackhole(bool)`](crate::client::fluent_builders::CreateTransitGatewayRoute::blackhole) / [`set_blackhole(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::set_blackhole): <p>Indicates whether to drop traffic that matches this route.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayRouteOutput`](crate::output::CreateTransitGatewayRouteOutput) with field(s):
    ///   - [`route(Option<TransitGatewayRoute>)`](crate::output::CreateTransitGatewayRouteOutput::route): <p>Information about the route.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayRouteError>`](crate::error::CreateTransitGatewayRouteError)
    pub fn create_transit_gateway_route(
        &self,
    ) -> fluent_builders::CreateTransitGatewayRoute<C, M, R> {
        fluent_builders::CreateTransitGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayRouteTable`](crate::client::fluent_builders::CreateTransitGatewayRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::set_transit_gateway_id): <p>The ID of the transit gateway.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::set_tag_specifications): <p>The tags to apply to the transit gateway route table.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayRouteTableOutput`](crate::output::CreateTransitGatewayRouteTableOutput) with field(s):
    ///   - [`transit_gateway_route_table(Option<TransitGatewayRouteTable>)`](crate::output::CreateTransitGatewayRouteTableOutput::transit_gateway_route_table): <p>Information about the transit gateway route table.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayRouteTableError>`](crate::error::CreateTransitGatewayRouteTableError)
    pub fn create_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::CreateTransitGatewayRouteTable<C, M, R> {
        fluent_builders::CreateTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTransitGatewayVpcAttachment`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_transit_gateway_id): <p>The ID of the transit gateway.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_subnet_ids): <p>The IDs of one or more subnets. You can specify only one subnet per Availability Zone. You must specify at least one subnet, but we recommend that you specify two subnets for better availability. The transit gateway uses one IP address from each specified subnet.</p>
    ///   - [`options(CreateTransitGatewayVpcAttachmentRequestOptions)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::options) / [`set_options(Option<CreateTransitGatewayVpcAttachmentRequestOptions>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_options): <p>The VPC attachment options.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_tag_specifications): <p>The tags to apply to the VPC attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateTransitGatewayVpcAttachmentOutput`](crate::output::CreateTransitGatewayVpcAttachmentOutput) with field(s):
    ///   - [`transit_gateway_vpc_attachment(Option<TransitGatewayVpcAttachment>)`](crate::output::CreateTransitGatewayVpcAttachmentOutput::transit_gateway_vpc_attachment): <p>Information about the VPC attachment.</p>
    /// - On failure, responds with [`SdkError<CreateTransitGatewayVpcAttachmentError>`](crate::error::CreateTransitGatewayVpcAttachmentError)
    pub fn create_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::CreateTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::CreateTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVolume`](crate::client::fluent_builders::CreateVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_availability_zone): <p>The Availability Zone in which to create the volume.</p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::CreateVolume::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateVolume::set_encrypted): <p>Indicates whether the volume should be encrypted. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>  <p>Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::CreateVolume::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::CreateVolume::set_iops): <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>  <p>The following are the supported values for each volume type:</p>  <ul>   <li> <p> <code>gp3</code>: 3,000-16,000 IOPS</p> </li>   <li> <p> <code>io1</code>: 100-64,000 IOPS</p> </li>   <li> <p> <code>io2</code>: 100-64,000 IOPS</p> </li>  </ul>  <p> <code>io1</code> and <code>io2</code> volumes support up to 64,000 IOPS only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families support performance up to 32,000 IOPS.</p>  <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes. The default for <code>gp3</code> volumes is 3,000 IOPS. This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_kms_key_id): <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>  <p>You can specify the KMS key using any of the following:</p>  <ul>   <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>   <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>   <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>  </ul>  <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
    ///   - [`outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::outpost_arn) / [`set_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    ///   - [`size(i32)`](crate::client::fluent_builders::CreateVolume::size) / [`set_size(Option<i32>)`](crate::client::fluent_builders::CreateVolume::set_size): <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.</p>  <p>The following are the supported volumes sizes for each volume type:</p>  <ul>   <li> <p> <code>gp2</code> and <code>gp3</code>: 1-16,384</p> </li>   <li> <p> <code>io1</code> and <code>io2</code>: 4-16,384</p> </li>   <li> <p> <code>st1</code> and <code>sc1</code>: 125-16,384</p> </li>   <li> <p> <code>standard</code>: 1-1,024</p> </li>  </ul>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_snapshot_id): <p>The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.</p>
    ///   - [`volume_type(VolumeType)`](crate::client::fluent_builders::CreateVolume::volume_type) / [`set_volume_type(Option<VolumeType>)`](crate::client::fluent_builders::CreateVolume::set_volume_type): <p>The volume type. This parameter can be one of the following values:</p>  <ul>   <li> <p>General Purpose SSD: <code>gp2</code> | <code>gp3</code> </p> </li>   <li> <p>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code> </p> </li>   <li> <p>Throughput Optimized HDD: <code>st1</code> </p> </li>   <li> <p>Cold HDD: <code>sc1</code> </p> </li>   <li> <p>Magnetic: <code>standard</code> </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>  <p>Default: <code>gp2</code> </p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVolume::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVolume::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVolume::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVolume::set_tag_specifications): <p>The tags to apply to the volume during creation.</p>
    ///   - [`multi_attach_enabled(bool)`](crate::client::fluent_builders::CreateVolume::multi_attach_enabled) / [`set_multi_attach_enabled(Option<bool>)`](crate::client::fluent_builders::CreateVolume::set_multi_attach_enabled): <p>Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the same Availability Zone. This parameter is supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    ///   - [`throughput(i32)`](crate::client::fluent_builders::CreateVolume::throughput) / [`set_throughput(Option<i32>)`](crate::client::fluent_builders::CreateVolume::set_throughput): <p>The throughput to provision for a volume, with a maximum of 1,000 MiB/s.</p>  <p>This parameter is valid only for <code>gp3</code> volumes.</p>  <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVolume::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVolume::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
    /// - On success, responds with [`CreateVolumeOutput`](crate::output::CreateVolumeOutput) with field(s):
    ///   - [`attachments(Option<Vec<VolumeAttachment>>)`](crate::output::CreateVolumeOutput::attachments): <p>Information about the volume attachments.</p>
    ///   - [`availability_zone(Option<String>)`](crate::output::CreateVolumeOutput::availability_zone): <p>The Availability Zone for the volume.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateVolumeOutput::create_time): <p>The time stamp when volume creation was initiated.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::CreateVolumeOutput::encrypted): <p>Indicates whether the volume is encrypted.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::CreateVolumeOutput::kms_key_id): <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the volume.</p>
    ///   - [`outpost_arn(Option<String>)`](crate::output::CreateVolumeOutput::outpost_arn): <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    ///   - [`size(Option<i32>)`](crate::output::CreateVolumeOutput::size): <p>The size of the volume, in GiBs.</p>
    ///   - [`snapshot_id(Option<String>)`](crate::output::CreateVolumeOutput::snapshot_id): <p>The snapshot from which the volume was created, if applicable.</p>
    ///   - [`state(Option<VolumeState>)`](crate::output::CreateVolumeOutput::state): <p>The volume state.</p>
    ///   - [`volume_id(Option<String>)`](crate::output::CreateVolumeOutput::volume_id): <p>The ID of the volume.</p>
    ///   - [`iops(Option<i32>)`](crate::output::CreateVolumeOutput::iops): <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateVolumeOutput::tags): <p>Any tags assigned to the volume.</p>
    ///   - [`volume_type(Option<VolumeType>)`](crate::output::CreateVolumeOutput::volume_type): <p>The volume type.</p>
    ///   - [`fast_restored(Option<bool>)`](crate::output::CreateVolumeOutput::fast_restored): <p>Indicates whether the volume was created using fast snapshot restore.</p>
    ///   - [`multi_attach_enabled(Option<bool>)`](crate::output::CreateVolumeOutput::multi_attach_enabled): <p>Indicates whether Amazon EBS Multi-Attach is enabled.</p>
    ///   - [`throughput(Option<i32>)`](crate::output::CreateVolumeOutput::throughput): <p>The throughput that the volume supports, in MiB/s.</p>
    /// - On failure, responds with [`SdkError<CreateVolumeError>`](crate::error::CreateVolumeError)
    pub fn create_volume(&self) -> fluent_builders::CreateVolume<C, M, R> {
        fluent_builders::CreateVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpc`](crate::client::fluent_builders::CreateVpc) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::cidr_block) / [`set_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_cidr_block): <p>The IPv4 network range for the VPC, in CIDR notation. For example, <code>10.0.0.0/16</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
    ///   - [`amazon_provided_ipv6_cidr_block(bool)`](crate::client::fluent_builders::CreateVpc::amazon_provided_ipv6_cidr_block) / [`set_amazon_provided_ipv6_cidr_block(Option<bool>)`](crate::client::fluent_builders::CreateVpc::set_amazon_provided_ipv6_cidr_block): <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.</p>
    ///   - [`ipv6_pool(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::ipv6_pool) / [`set_ipv6_pool(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_ipv6_pool): <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
    ///   - [`ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::ipv6_cidr_block) / [`set_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_ipv6_cidr_block): <p>The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>  <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
    ///   - [`ipv4_ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::ipv4_ipam_pool_id) / [`set_ipv4_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_ipv4_ipam_pool_id): <p>The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. For more information, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    ///   - [`ipv4_netmask_length(i32)`](crate::client::fluent_builders::CreateVpc::ipv4_netmask_length) / [`set_ipv4_netmask_length(Option<i32>)`](crate::client::fluent_builders::CreateVpc::set_ipv4_netmask_length): <p>The netmask length of the IPv4 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    ///   - [`ipv6_ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::ipv6_ipam_pool_id) / [`set_ipv6_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_ipv6_ipam_pool_id): <p>The ID of an IPv6 IPAM pool which will be used to allocate this VPC an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    ///   - [`ipv6_netmask_length(i32)`](crate::client::fluent_builders::CreateVpc::ipv6_netmask_length) / [`set_ipv6_netmask_length(Option<i32>)`](crate::client::fluent_builders::CreateVpc::set_ipv6_netmask_length): <p>The netmask length of the IPv6 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpc::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpc::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_tenancy(Tenancy)`](crate::client::fluent_builders::CreateVpc::instance_tenancy) / [`set_instance_tenancy(Option<Tenancy>)`](crate::client::fluent_builders::CreateVpc::set_instance_tenancy): <p>The tenancy options for instances launched into the VPC. For <code>default</code>, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of <code>dedicated</code> or <code>host</code> into a dedicated tenancy VPC. </p>  <p> <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p>  <p>Default: <code>default</code> </p>
    ///   - [`ipv6_cidr_block_network_border_group(impl Into<String>)`](crate::client::fluent_builders::CreateVpc::ipv6_cidr_block_network_border_group) / [`set_ipv6_cidr_block_network_border_group(Option<String>)`](crate::client::fluent_builders::CreateVpc::set_ipv6_cidr_block_network_border_group): <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.</p>  <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpc::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpc::set_tag_specifications): <p>The tags to assign to the VPC.</p>
    /// - On success, responds with [`CreateVpcOutput`](crate::output::CreateVpcOutput) with field(s):
    ///   - [`vpc(Option<Vpc>)`](crate::output::CreateVpcOutput::vpc): <p>Information about the VPC.</p>
    /// - On failure, responds with [`SdkError<CreateVpcError>`](crate::error::CreateVpcError)
    pub fn create_vpc(&self) -> fluent_builders::CreateVpc<C, M, R> {
        fluent_builders::CreateVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcEndpoint`](crate::client::fluent_builders::CreateVpcEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpcEndpoint::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_endpoint_type(VpcEndpointType)`](crate::client::fluent_builders::CreateVpcEndpoint::vpc_endpoint_type) / [`set_vpc_endpoint_type(Option<VpcEndpointType>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_vpc_endpoint_type): <p>The type of endpoint.</p>  <p>Default: Gateway</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_vpc_id): <p>The ID of the VPC in which the endpoint will be used.</p>
    ///   - [`service_name(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::service_name) / [`set_service_name(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_service_name): <p>The service name. To get a list of available services, use the <code>DescribeVpcEndpointServices</code> request, or get the name from the service provider.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_policy_document): <p>(Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service.</p>
    ///   - [`route_table_ids(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::route_table_ids) / [`set_route_table_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_route_table_ids): <p>(Gateway endpoint) One or more route table IDs.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_subnet_ids): <p>(Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_security_group_ids): <p>(Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`private_dns_enabled(bool)`](crate::client::fluent_builders::CreateVpcEndpoint::private_dns_enabled) / [`set_private_dns_enabled(Option<bool>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_private_dns_enabled): <p>(Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.</p>  <p>To use a private hosted zone, you must set the following VPC attributes to <code>true</code>: <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <code>ModifyVpcAttribute</code> to set the VPC attributes.</p>  <p>Default: <code>true</code> </p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpcEndpoint::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpcEndpoint::set_tag_specifications): <p>The tags to associate with the endpoint.</p>
    /// - On success, responds with [`CreateVpcEndpointOutput`](crate::output::CreateVpcEndpointOutput) with field(s):
    ///   - [`vpc_endpoint(Option<VpcEndpoint>)`](crate::output::CreateVpcEndpointOutput::vpc_endpoint): <p>Information about the endpoint.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateVpcEndpointOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On failure, responds with [`SdkError<CreateVpcEndpointError>`](crate::error::CreateVpcEndpointError)
    pub fn create_vpc_endpoint(&self) -> fluent_builders::CreateVpcEndpoint<C, M, R> {
        fluent_builders::CreateVpcEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcEndpointConnectionNotification`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`service_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::service_id) / [`set_service_id(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_service_id): <p>The ID of the endpoint service.</p>
    ///   - [`vpc_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::vpc_endpoint_id) / [`set_vpc_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_vpc_endpoint_id): <p>The ID of the endpoint.</p>
    ///   - [`connection_notification_arn(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::connection_notification_arn) / [`set_connection_notification_arn(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_connection_notification_arn): <p>The ARN of the SNS topic for the notifications.</p>
    ///   - [`connection_events(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::connection_events) / [`set_connection_events(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_connection_events): <p>One or more endpoint events for which to receive notifications. Valid values are <code>Accept</code>, <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    /// - On success, responds with [`CreateVpcEndpointConnectionNotificationOutput`](crate::output::CreateVpcEndpointConnectionNotificationOutput) with field(s):
    ///   - [`connection_notification(Option<ConnectionNotification>)`](crate::output::CreateVpcEndpointConnectionNotificationOutput::connection_notification): <p>Information about the notification.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateVpcEndpointConnectionNotificationOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On failure, responds with [`SdkError<CreateVpcEndpointConnectionNotificationError>`](crate::error::CreateVpcEndpointConnectionNotificationError)
    pub fn create_vpc_endpoint_connection_notification(
        &self,
    ) -> fluent_builders::CreateVpcEndpointConnectionNotification<C, M, R> {
        fluent_builders::CreateVpcEndpointConnectionNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcEndpointServiceConfiguration`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`acceptance_required(bool)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::acceptance_required) / [`set_acceptance_required(Option<bool>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_acceptance_required): <p>Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To accept a request, use <code>AcceptVpcEndpointConnections</code>.</p>
    ///   - [`private_dns_name(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::private_dns_name) / [`set_private_dns_name(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_private_dns_name): <p>(Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.</p>
    ///   - [`network_load_balancer_arns(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::network_load_balancer_arns) / [`set_network_load_balancer_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_network_load_balancer_arns): <p>The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.</p>
    ///   - [`gateway_load_balancer_arns(Vec<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::gateway_load_balancer_arns) / [`set_gateway_load_balancer_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_gateway_load_balancer_arns): <p>The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration::set_tag_specifications): <p>The tags to associate with the service.</p>
    /// - On success, responds with [`CreateVpcEndpointServiceConfigurationOutput`](crate::output::CreateVpcEndpointServiceConfigurationOutput) with field(s):
    ///   - [`service_configuration(Option<ServiceConfiguration>)`](crate::output::CreateVpcEndpointServiceConfigurationOutput::service_configuration): <p>Information about the service configuration.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateVpcEndpointServiceConfigurationOutput::client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On failure, responds with [`SdkError<CreateVpcEndpointServiceConfigurationError>`](crate::error::CreateVpcEndpointServiceConfigurationError)
    pub fn create_vpc_endpoint_service_configuration(
        &self,
    ) -> fluent_builders::CreateVpcEndpointServiceConfiguration<C, M, R> {
        fluent_builders::CreateVpcEndpointServiceConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpcPeeringConnection`](crate::client::fluent_builders::CreateVpcPeeringConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpcPeeringConnection::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`peer_owner_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::peer_owner_id) / [`set_peer_owner_id(Option<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_peer_owner_id): <p>The Amazon Web Services account ID of the owner of the accepter VPC.</p>  <p>Default: Your Amazon Web Services account ID</p>
    ///   - [`peer_vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::peer_vpc_id) / [`set_peer_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_peer_vpc_id): <p>The ID of the VPC with which you are creating the VPC peering connection. You must specify this parameter in the request.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_vpc_id): <p>The ID of the requester VPC. You must specify this parameter in the request.</p>
    ///   - [`peer_region(impl Into<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::peer_region) / [`set_peer_region(Option<String>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_peer_region): <p>The Region code for the accepter VPC, if the accepter VPC is located in a Region other than the Region in which you make the request.</p>  <p>Default: The Region in which you make the request.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpcPeeringConnection::set_tag_specifications): <p>The tags to assign to the peering connection.</p>
    /// - On success, responds with [`CreateVpcPeeringConnectionOutput`](crate::output::CreateVpcPeeringConnectionOutput) with field(s):
    ///   - [`vpc_peering_connection(Option<VpcPeeringConnection>)`](crate::output::CreateVpcPeeringConnectionOutput::vpc_peering_connection): <p>Information about the VPC peering connection.</p>
    /// - On failure, responds with [`SdkError<CreateVpcPeeringConnectionError>`](crate::error::CreateVpcPeeringConnectionError)
    pub fn create_vpc_peering_connection(
        &self,
    ) -> fluent_builders::CreateVpcPeeringConnection<C, M, R> {
        fluent_builders::CreateVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpnConnection`](crate::client::fluent_builders::CreateVpnConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`customer_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnection::customer_gateway_id) / [`set_customer_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateVpnConnection::set_customer_gateway_id): <p>The ID of the customer gateway.</p>
    ///   - [`r#type(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnection::r#type) / [`set_type(Option<String>)`](crate::client::fluent_builders::CreateVpnConnection::set_type): <p>The type of VPN connection (<code>ipsec.1</code>).</p>
    ///   - [`vpn_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnection::vpn_gateway_id) / [`set_vpn_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateVpnConnection::set_vpn_gateway_id): <p>The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit gateway.</p>
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnection::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::CreateVpnConnection::set_transit_gateway_id): <p>The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpnConnection::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpnConnection::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`options(VpnConnectionOptionsSpecification)`](crate::client::fluent_builders::CreateVpnConnection::options) / [`set_options(Option<VpnConnectionOptionsSpecification>)`](crate::client::fluent_builders::CreateVpnConnection::set_options): <p>The options for the VPN connection.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpnConnection::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpnConnection::set_tag_specifications): <p>The tags to apply to the VPN connection.</p>
    /// - On success, responds with [`CreateVpnConnectionOutput`](crate::output::CreateVpnConnectionOutput) with field(s):
    ///   - [`vpn_connection(Option<VpnConnection>)`](crate::output::CreateVpnConnectionOutput::vpn_connection): <p>Information about the VPN connection.</p>
    /// - On failure, responds with [`SdkError<CreateVpnConnectionError>`](crate::error::CreateVpnConnectionError)
    pub fn create_vpn_connection(&self) -> fluent_builders::CreateVpnConnection<C, M, R> {
        fluent_builders::CreateVpnConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpnConnectionRoute`](crate::client::fluent_builders::CreateVpnConnectionRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnectionRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::CreateVpnConnectionRoute::set_destination_cidr_block): <p>The CIDR block associated with the local subnet of the customer network.</p>
    ///   - [`vpn_connection_id(impl Into<String>)`](crate::client::fluent_builders::CreateVpnConnectionRoute::vpn_connection_id) / [`set_vpn_connection_id(Option<String>)`](crate::client::fluent_builders::CreateVpnConnectionRoute::set_vpn_connection_id): <p>The ID of the VPN connection.</p>
    /// - On success, responds with [`CreateVpnConnectionRouteOutput`](crate::output::CreateVpnConnectionRouteOutput)

    /// - On failure, responds with [`SdkError<CreateVpnConnectionRouteError>`](crate::error::CreateVpnConnectionRouteError)
    pub fn create_vpn_connection_route(
        &self,
    ) -> fluent_builders::CreateVpnConnectionRoute<C, M, R> {
        fluent_builders::CreateVpnConnectionRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVpnGateway`](crate::client::fluent_builders::CreateVpnGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateVpnGateway::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateVpnGateway::set_availability_zone): <p>The Availability Zone for the virtual private gateway.</p>
    ///   - [`r#type(GatewayType)`](crate::client::fluent_builders::CreateVpnGateway::r#type) / [`set_type(Option<GatewayType>)`](crate::client::fluent_builders::CreateVpnGateway::set_type): <p>The type of VPN connection this virtual private gateway supports.</p>
    ///   - [`tag_specifications(Vec<TagSpecification>)`](crate::client::fluent_builders::CreateVpnGateway::tag_specifications) / [`set_tag_specifications(Option<Vec<TagSpecification>>)`](crate::client::fluent_builders::CreateVpnGateway::set_tag_specifications): <p>The tags to apply to the virtual private gateway.</p>
    ///   - [`amazon_side_asn(i64)`](crate::client::fluent_builders::CreateVpnGateway::amazon_side_asn) / [`set_amazon_side_asn(Option<i64>)`](crate::client::fluent_builders::CreateVpnGateway::set_amazon_side_asn): <p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you're using a 16-bit ASN, it must be in the 64512 to 65534 range. If you're using a 32-bit ASN, it must be in the 4200000000 to 4294967294 range.</p>  <p>Default: 64512</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateVpnGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateVpnGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`CreateVpnGatewayOutput`](crate::output::CreateVpnGatewayOutput) with field(s):
    ///   - [`vpn_gateway(Option<VpnGateway>)`](crate::output::CreateVpnGatewayOutput::vpn_gateway): <p>Information about the virtual private gateway.</p>
    /// - On failure, responds with [`SdkError<CreateVpnGatewayError>`](crate::error::CreateVpnGatewayError)
    pub fn create_vpn_gateway(&self) -> fluent_builders::CreateVpnGateway<C, M, R> {
        fluent_builders::CreateVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCarrierGateway`](crate::client::fluent_builders::DeleteCarrierGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`carrier_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCarrierGateway::carrier_gateway_id) / [`set_carrier_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteCarrierGateway::set_carrier_gateway_id): <p>The ID of the carrier gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteCarrierGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteCarrierGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteCarrierGatewayOutput`](crate::output::DeleteCarrierGatewayOutput) with field(s):
    ///   - [`carrier_gateway(Option<CarrierGateway>)`](crate::output::DeleteCarrierGatewayOutput::carrier_gateway): <p>Information about the carrier gateway.</p>
    /// - On failure, responds with [`SdkError<DeleteCarrierGatewayError>`](crate::error::DeleteCarrierGatewayError)
    pub fn delete_carrier_gateway(&self) -> fluent_builders::DeleteCarrierGateway<C, M, R> {
        fluent_builders::DeleteCarrierGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClientVpnEndpoint`](crate::client::fluent_builders::DeleteClientVpnEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DeleteClientVpnEndpoint::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DeleteClientVpnEndpoint::set_client_vpn_endpoint_id): <p>The ID of the Client VPN to be deleted.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteClientVpnEndpoint::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteClientVpnEndpoint::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteClientVpnEndpointOutput`](crate::output::DeleteClientVpnEndpointOutput) with field(s):
    ///   - [`status(Option<ClientVpnEndpointStatus>)`](crate::output::DeleteClientVpnEndpointOutput::status): <p>The current state of the Client VPN endpoint.</p>
    /// - On failure, responds with [`SdkError<DeleteClientVpnEndpointError>`](crate::error::DeleteClientVpnEndpointError)
    pub fn delete_client_vpn_endpoint(&self) -> fluent_builders::DeleteClientVpnEndpoint<C, M, R> {
        fluent_builders::DeleteClientVpnEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClientVpnRoute`](crate::client::fluent_builders::DeleteClientVpnRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint from which the route is to be deleted.</p>
    ///   - [`target_vpc_subnet_id(impl Into<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::target_vpc_subnet_id) / [`set_target_vpc_subnet_id(Option<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::set_target_vpc_subnet_id): <p>The ID of the target subnet used by the route.</p>
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteClientVpnRoute::set_destination_cidr_block): <p>The IPv4 address range, in CIDR notation, of the route to be deleted.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteClientVpnRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteClientVpnRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteClientVpnRouteOutput`](crate::output::DeleteClientVpnRouteOutput) with field(s):
    ///   - [`status(Option<ClientVpnRouteStatus>)`](crate::output::DeleteClientVpnRouteOutput::status): <p>The current state of the route.</p>
    /// - On failure, responds with [`SdkError<DeleteClientVpnRouteError>`](crate::error::DeleteClientVpnRouteError)
    pub fn delete_client_vpn_route(&self) -> fluent_builders::DeleteClientVpnRoute<C, M, R> {
        fluent_builders::DeleteClientVpnRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomerGateway`](crate::client::fluent_builders::DeleteCustomerGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`customer_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomerGateway::customer_gateway_id) / [`set_customer_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomerGateway::set_customer_gateway_id): <p>The ID of the customer gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteCustomerGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteCustomerGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteCustomerGatewayOutput`](crate::output::DeleteCustomerGatewayOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomerGatewayError>`](crate::error::DeleteCustomerGatewayError)
    pub fn delete_customer_gateway(&self) -> fluent_builders::DeleteCustomerGateway<C, M, R> {
        fluent_builders::DeleteCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDhcpOptions`](crate::client::fluent_builders::DeleteDhcpOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dhcp_options_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDhcpOptions::dhcp_options_id) / [`set_dhcp_options_id(Option<String>)`](crate::client::fluent_builders::DeleteDhcpOptions::set_dhcp_options_id): <p>The ID of the DHCP options set.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteDhcpOptions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteDhcpOptions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteDhcpOptionsOutput`](crate::output::DeleteDhcpOptionsOutput)

    /// - On failure, responds with [`SdkError<DeleteDhcpOptionsError>`](crate::error::DeleteDhcpOptionsError)
    pub fn delete_dhcp_options(&self) -> fluent_builders::DeleteDhcpOptions<C, M, R> {
        fluent_builders::DeleteDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEgressOnlyInternetGateway`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`egress_only_internet_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway::egress_only_internet_gateway_id) / [`set_egress_only_internet_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway::set_egress_only_internet_gateway_id): <p>The ID of the egress-only internet gateway.</p>
    /// - On success, responds with [`DeleteEgressOnlyInternetGatewayOutput`](crate::output::DeleteEgressOnlyInternetGatewayOutput) with field(s):
    ///   - [`return_code(Option<bool>)`](crate::output::DeleteEgressOnlyInternetGatewayOutput::return_code): <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    /// - On failure, responds with [`SdkError<DeleteEgressOnlyInternetGatewayError>`](crate::error::DeleteEgressOnlyInternetGatewayError)
    pub fn delete_egress_only_internet_gateway(
        &self,
    ) -> fluent_builders::DeleteEgressOnlyInternetGateway<C, M, R> {
        fluent_builders::DeleteEgressOnlyInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFleets`](crate::client::fluent_builders::DeleteFleets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteFleets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteFleets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`fleet_ids(Vec<String>)`](crate::client::fluent_builders::DeleteFleets::fleet_ids) / [`set_fleet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteFleets::set_fleet_ids): <p>The IDs of the EC2 Fleets.</p>
    ///   - [`terminate_instances(bool)`](crate::client::fluent_builders::DeleteFleets::terminate_instances) / [`set_terminate_instances(Option<bool>)`](crate::client::fluent_builders::DeleteFleets::set_terminate_instances): <p>Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to terminate the instances.</p>  <p>To let the instances continue to run after the EC2 Fleet is deleted, specify <code>NoTerminateInstances</code>. Supported only for fleets of type <code>maintain</code> and <code>request</code>.</p>  <p>For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A deleted <code>instant</code> fleet with running instances is not supported.</p>
    /// - On success, responds with [`DeleteFleetsOutput`](crate::output::DeleteFleetsOutput) with field(s):
    ///   - [`successful_fleet_deletions(Option<Vec<DeleteFleetSuccessItem>>)`](crate::output::DeleteFleetsOutput::successful_fleet_deletions): <p>Information about the EC2 Fleets that are successfully deleted.</p>
    ///   - [`unsuccessful_fleet_deletions(Option<Vec<DeleteFleetErrorItem>>)`](crate::output::DeleteFleetsOutput::unsuccessful_fleet_deletions): <p>Information about the EC2 Fleets that are not successfully deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteFleetsError>`](crate::error::DeleteFleetsError)
    pub fn delete_fleets(&self) -> fluent_builders::DeleteFleets<C, M, R> {
        fluent_builders::DeleteFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFlowLogs`](crate::client::fluent_builders::DeleteFlowLogs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteFlowLogs::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteFlowLogs::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`flow_log_ids(Vec<String>)`](crate::client::fluent_builders::DeleteFlowLogs::flow_log_ids) / [`set_flow_log_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteFlowLogs::set_flow_log_ids): <p>One or more flow log IDs.</p>  <p>Constraint: Maximum of 1000 flow log IDs.</p>
    /// - On success, responds with [`DeleteFlowLogsOutput`](crate::output::DeleteFlowLogsOutput) with field(s):
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::DeleteFlowLogsOutput::unsuccessful): <p>Information about the flow logs that could not be deleted successfully.</p>
    /// - On failure, responds with [`SdkError<DeleteFlowLogsError>`](crate::error::DeleteFlowLogsError)
    pub fn delete_flow_logs(&self) -> fluent_builders::DeleteFlowLogs<C, M, R> {
        fluent_builders::DeleteFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFpgaImage`](crate::client::fluent_builders::DeleteFpgaImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteFpgaImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteFpgaImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`fpga_image_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFpgaImage::fpga_image_id) / [`set_fpga_image_id(Option<String>)`](crate::client::fluent_builders::DeleteFpgaImage::set_fpga_image_id): <p>The ID of the AFI.</p>
    /// - On success, responds with [`DeleteFpgaImageOutput`](crate::output::DeleteFpgaImageOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::DeleteFpgaImageOutput::return): <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
    /// - On failure, responds with [`SdkError<DeleteFpgaImageError>`](crate::error::DeleteFpgaImageError)
    pub fn delete_fpga_image(&self) -> fluent_builders::DeleteFpgaImage<C, M, R> {
        fluent_builders::DeleteFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInstanceEventWindow`](crate::client::fluent_builders::DeleteInstanceEventWindow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteInstanceEventWindow::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteInstanceEventWindow::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteInstanceEventWindow::force_delete) / [`set_force_delete(Option<bool>)`](crate::client::fluent_builders::DeleteInstanceEventWindow::set_force_delete): <p>Specify <code>true</code> to force delete the event window. Use the force delete parameter if the event window is currently associated with targets.</p>
    ///   - [`instance_event_window_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInstanceEventWindow::instance_event_window_id) / [`set_instance_event_window_id(Option<String>)`](crate::client::fluent_builders::DeleteInstanceEventWindow::set_instance_event_window_id): <p>The ID of the event window.</p>
    /// - On success, responds with [`DeleteInstanceEventWindowOutput`](crate::output::DeleteInstanceEventWindowOutput) with field(s):
    ///   - [`instance_event_window_state(Option<InstanceEventWindowStateChange>)`](crate::output::DeleteInstanceEventWindowOutput::instance_event_window_state): <p>The state of the event window.</p>
    /// - On failure, responds with [`SdkError<DeleteInstanceEventWindowError>`](crate::error::DeleteInstanceEventWindowError)
    pub fn delete_instance_event_window(
        &self,
    ) -> fluent_builders::DeleteInstanceEventWindow<C, M, R> {
        fluent_builders::DeleteInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInternetGateway`](crate::client::fluent_builders::DeleteInternetGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteInternetGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteInternetGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`internet_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInternetGateway::internet_gateway_id) / [`set_internet_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteInternetGateway::set_internet_gateway_id): <p>The ID of the internet gateway.</p>
    /// - On success, responds with [`DeleteInternetGatewayOutput`](crate::output::DeleteInternetGatewayOutput)

    /// - On failure, responds with [`SdkError<DeleteInternetGatewayError>`](crate::error::DeleteInternetGatewayError)
    pub fn delete_internet_gateway(&self) -> fluent_builders::DeleteInternetGateway<C, M, R> {
        fluent_builders::DeleteInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIpam`](crate::client::fluent_builders::DeleteIpam) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteIpam::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteIpam::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIpam::ipam_id) / [`set_ipam_id(Option<String>)`](crate::client::fluent_builders::DeleteIpam::set_ipam_id): <p>The ID of the IPAM to delete.</p>
    /// - On success, responds with [`DeleteIpamOutput`](crate::output::DeleteIpamOutput) with field(s):
    ///   - [`ipam(Option<Ipam>)`](crate::output::DeleteIpamOutput::ipam): <p>Information about the results of the deletion.</p>
    /// - On failure, responds with [`SdkError<DeleteIpamError>`](crate::error::DeleteIpamError)
    pub fn delete_ipam(&self) -> fluent_builders::DeleteIpam<C, M, R> {
        fluent_builders::DeleteIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIpamPool`](crate::client::fluent_builders::DeleteIpamPool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteIpamPool::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteIpamPool::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIpamPool::ipam_pool_id) / [`set_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::DeleteIpamPool::set_ipam_pool_id): <p>The ID of the pool to delete.</p>
    /// - On success, responds with [`DeleteIpamPoolOutput`](crate::output::DeleteIpamPoolOutput) with field(s):
    ///   - [`ipam_pool(Option<IpamPool>)`](crate::output::DeleteIpamPoolOutput::ipam_pool): <p>Information about the results of the deletion.</p>
    /// - On failure, responds with [`SdkError<DeleteIpamPoolError>`](crate::error::DeleteIpamPoolError)
    pub fn delete_ipam_pool(&self) -> fluent_builders::DeleteIpamPool<C, M, R> {
        fluent_builders::DeleteIpamPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIpamScope`](crate::client::fluent_builders::DeleteIpamScope) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteIpamScope::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteIpamScope::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_scope_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIpamScope::ipam_scope_id) / [`set_ipam_scope_id(Option<String>)`](crate::client::fluent_builders::DeleteIpamScope::set_ipam_scope_id): <p>The ID of the scope to delete.</p>
    /// - On success, responds with [`DeleteIpamScopeOutput`](crate::output::DeleteIpamScopeOutput) with field(s):
    ///   - [`ipam_scope(Option<IpamScope>)`](crate::output::DeleteIpamScopeOutput::ipam_scope): <p>Information about the results of the deletion.</p>
    /// - On failure, responds with [`SdkError<DeleteIpamScopeError>`](crate::error::DeleteIpamScopeError)
    pub fn delete_ipam_scope(&self) -> fluent_builders::DeleteIpamScope<C, M, R> {
        fluent_builders::DeleteIpamScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKeyPair`](crate::client::fluent_builders::DeleteKeyPair) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`key_name(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyPair::key_name) / [`set_key_name(Option<String>)`](crate::client::fluent_builders::DeleteKeyPair::set_key_name): <p>The name of the key pair.</p>
    ///   - [`key_pair_id(impl Into<String>)`](crate::client::fluent_builders::DeleteKeyPair::key_pair_id) / [`set_key_pair_id(Option<String>)`](crate::client::fluent_builders::DeleteKeyPair::set_key_pair_id): <p>The ID of the key pair.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteKeyPair::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteKeyPair::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteKeyPairOutput`](crate::output::DeleteKeyPairOutput)

    /// - On failure, responds with [`SdkError<DeleteKeyPairError>`](crate::error::DeleteKeyPairError)
    pub fn delete_key_pair(&self) -> fluent_builders::DeleteKeyPair<C, M, R> {
        fluent_builders::DeleteKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLaunchTemplate`](crate::client::fluent_builders::DeleteLaunchTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteLaunchTemplate::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteLaunchTemplate::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`launch_template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchTemplate::launch_template_id) / [`set_launch_template_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchTemplate::set_launch_template_id): <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    ///   - [`launch_template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchTemplate::launch_template_name) / [`set_launch_template_name(Option<String>)`](crate::client::fluent_builders::DeleteLaunchTemplate::set_launch_template_name): <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    /// - On success, responds with [`DeleteLaunchTemplateOutput`](crate::output::DeleteLaunchTemplateOutput) with field(s):
    ///   - [`launch_template(Option<LaunchTemplate>)`](crate::output::DeleteLaunchTemplateOutput::launch_template): <p>Information about the launch template.</p>
    /// - On failure, responds with [`SdkError<DeleteLaunchTemplateError>`](crate::error::DeleteLaunchTemplateError)
    pub fn delete_launch_template(&self) -> fluent_builders::DeleteLaunchTemplate<C, M, R> {
        fluent_builders::DeleteLaunchTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLaunchTemplateVersions`](crate::client::fluent_builders::DeleteLaunchTemplateVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`launch_template_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::launch_template_id) / [`set_launch_template_id(Option<String>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::set_launch_template_id): <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    ///   - [`launch_template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::launch_template_name) / [`set_launch_template_name(Option<String>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::set_launch_template_name): <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteLaunchTemplateVersions::set_versions): <p>The version numbers of one or more launch template versions to delete.</p>
    /// - On success, responds with [`DeleteLaunchTemplateVersionsOutput`](crate::output::DeleteLaunchTemplateVersionsOutput) with field(s):
    ///   - [`successfully_deleted_launch_template_versions(Option<Vec<DeleteLaunchTemplateVersionsResponseSuccessItem>>)`](crate::output::DeleteLaunchTemplateVersionsOutput::successfully_deleted_launch_template_versions): <p>Information about the launch template versions that were successfully deleted.</p>
    ///   - [`unsuccessfully_deleted_launch_template_versions(Option<Vec<DeleteLaunchTemplateVersionsResponseErrorItem>>)`](crate::output::DeleteLaunchTemplateVersionsOutput::unsuccessfully_deleted_launch_template_versions): <p>Information about the launch template versions that could not be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteLaunchTemplateVersionsError>`](crate::error::DeleteLaunchTemplateVersionsError)
    pub fn delete_launch_template_versions(
        &self,
    ) -> fluent_builders::DeleteLaunchTemplateVersions<C, M, R> {
        fluent_builders::DeleteLaunchTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLocalGatewayRoute`](crate::client::fluent_builders::DeleteLocalGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::set_destination_cidr_block): <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
    ///   - [`local_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::local_gateway_route_table_id) / [`set_local_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::set_local_gateway_route_table_id): <p>The ID of the local gateway route table.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteLocalGatewayRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteLocalGatewayRouteOutput`](crate::output::DeleteLocalGatewayRouteOutput) with field(s):
    ///   - [`route(Option<LocalGatewayRoute>)`](crate::output::DeleteLocalGatewayRouteOutput::route): <p>Information about the route.</p>
    /// - On failure, responds with [`SdkError<DeleteLocalGatewayRouteError>`](crate::error::DeleteLocalGatewayRouteError)
    pub fn delete_local_gateway_route(&self) -> fluent_builders::DeleteLocalGatewayRoute<C, M, R> {
        fluent_builders::DeleteLocalGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLocalGatewayRouteTableVpcAssociation`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_route_table_vpc_association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::local_gateway_route_table_vpc_association_id) / [`set_local_gateway_route_table_vpc_association_id(Option<String>)`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::set_local_gateway_route_table_vpc_association_id): <p>The ID of the association.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteLocalGatewayRouteTableVpcAssociationOutput`](crate::output::DeleteLocalGatewayRouteTableVpcAssociationOutput) with field(s):
    ///   - [`local_gateway_route_table_vpc_association(Option<LocalGatewayRouteTableVpcAssociation>)`](crate::output::DeleteLocalGatewayRouteTableVpcAssociationOutput::local_gateway_route_table_vpc_association): <p>Information about the association.</p>
    /// - On failure, responds with [`SdkError<DeleteLocalGatewayRouteTableVpcAssociationError>`](crate::error::DeleteLocalGatewayRouteTableVpcAssociationError)
    pub fn delete_local_gateway_route_table_vpc_association(
        &self,
    ) -> fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation<C, M, R> {
        fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteManagedPrefixList`](crate::client::fluent_builders::DeleteManagedPrefixList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteManagedPrefixList::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteManagedPrefixList::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`prefix_list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteManagedPrefixList::prefix_list_id) / [`set_prefix_list_id(Option<String>)`](crate::client::fluent_builders::DeleteManagedPrefixList::set_prefix_list_id): <p>The ID of the prefix list.</p>
    /// - On success, responds with [`DeleteManagedPrefixListOutput`](crate::output::DeleteManagedPrefixListOutput) with field(s):
    ///   - [`prefix_list(Option<ManagedPrefixList>)`](crate::output::DeleteManagedPrefixListOutput::prefix_list): <p>Information about the prefix list.</p>
    /// - On failure, responds with [`SdkError<DeleteManagedPrefixListError>`](crate::error::DeleteManagedPrefixListError)
    pub fn delete_managed_prefix_list(&self) -> fluent_builders::DeleteManagedPrefixList<C, M, R> {
        fluent_builders::DeleteManagedPrefixList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNatGateway`](crate::client::fluent_builders::DeleteNatGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNatGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNatGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`nat_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNatGateway::nat_gateway_id) / [`set_nat_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteNatGateway::set_nat_gateway_id): <p>The ID of the NAT gateway.</p>
    /// - On success, responds with [`DeleteNatGatewayOutput`](crate::output::DeleteNatGatewayOutput) with field(s):
    ///   - [`nat_gateway_id(Option<String>)`](crate::output::DeleteNatGatewayOutput::nat_gateway_id): <p>The ID of the NAT gateway.</p>
    /// - On failure, responds with [`SdkError<DeleteNatGatewayError>`](crate::error::DeleteNatGatewayError)
    pub fn delete_nat_gateway(&self) -> fluent_builders::DeleteNatGateway<C, M, R> {
        fluent_builders::DeleteNatGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkAcl`](crate::client::fluent_builders::DeleteNetworkAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkAcl::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkAcl::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_acl_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkAcl::network_acl_id) / [`set_network_acl_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkAcl::set_network_acl_id): <p>The ID of the network ACL.</p>
    /// - On success, responds with [`DeleteNetworkAclOutput`](crate::output::DeleteNetworkAclOutput)

    /// - On failure, responds with [`SdkError<DeleteNetworkAclError>`](crate::error::DeleteNetworkAclError)
    pub fn delete_network_acl(&self) -> fluent_builders::DeleteNetworkAcl<C, M, R> {
        fluent_builders::DeleteNetworkAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkAclEntry`](crate::client::fluent_builders::DeleteNetworkAclEntry) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkAclEntry::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkAclEntry::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`egress(bool)`](crate::client::fluent_builders::DeleteNetworkAclEntry::egress) / [`set_egress(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkAclEntry::set_egress): <p>Indicates whether the rule is an egress rule.</p>
    ///   - [`network_acl_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkAclEntry::network_acl_id) / [`set_network_acl_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkAclEntry::set_network_acl_id): <p>The ID of the network ACL.</p>
    ///   - [`rule_number(i32)`](crate::client::fluent_builders::DeleteNetworkAclEntry::rule_number) / [`set_rule_number(Option<i32>)`](crate::client::fluent_builders::DeleteNetworkAclEntry::set_rule_number): <p>The rule number of the entry to delete.</p>
    /// - On success, responds with [`DeleteNetworkAclEntryOutput`](crate::output::DeleteNetworkAclEntryOutput)

    /// - On failure, responds with [`SdkError<DeleteNetworkAclEntryError>`](crate::error::DeleteNetworkAclEntryError)
    pub fn delete_network_acl_entry(&self) -> fluent_builders::DeleteNetworkAclEntry<C, M, R> {
        fluent_builders::DeleteNetworkAclEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInsightsAccessScope`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_insights_access_scope_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope::network_insights_access_scope_id) / [`set_network_insights_access_scope_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope::set_network_insights_access_scope_id): <p>The ID of the Network Access Scope.</p>
    /// - On success, responds with [`DeleteNetworkInsightsAccessScopeOutput`](crate::output::DeleteNetworkInsightsAccessScopeOutput) with field(s):
    ///   - [`network_insights_access_scope_id(Option<String>)`](crate::output::DeleteNetworkInsightsAccessScopeOutput::network_insights_access_scope_id): <p>The ID of the Network Access Scope.</p>
    /// - On failure, responds with [`SdkError<DeleteNetworkInsightsAccessScopeError>`](crate::error::DeleteNetworkInsightsAccessScopeError)
    pub fn delete_network_insights_access_scope(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAccessScope<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAccessScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInsightsAccessScopeAnalysis`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_insights_access_scope_analysis_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::network_insights_access_scope_analysis_id) / [`set_network_insights_access_scope_analysis_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::set_network_insights_access_scope_analysis_id): <p>The ID of the Network Access Scope analysis.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteNetworkInsightsAccessScopeAnalysisOutput`](crate::output::DeleteNetworkInsightsAccessScopeAnalysisOutput) with field(s):
    ///   - [`network_insights_access_scope_analysis_id(Option<String>)`](crate::output::DeleteNetworkInsightsAccessScopeAnalysisOutput::network_insights_access_scope_analysis_id): <p>The ID of the Network Access Scope analysis.</p>
    /// - On failure, responds with [`SdkError<DeleteNetworkInsightsAccessScopeAnalysisError>`](crate::error::DeleteNetworkInsightsAccessScopeAnalysisError)
    pub fn delete_network_insights_access_scope_analysis(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInsightsAnalysis`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_insights_analysis_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis::network_insights_analysis_id) / [`set_network_insights_analysis_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis::set_network_insights_analysis_id): <p>The ID of the network insights analysis.</p>
    /// - On success, responds with [`DeleteNetworkInsightsAnalysisOutput`](crate::output::DeleteNetworkInsightsAnalysisOutput) with field(s):
    ///   - [`network_insights_analysis_id(Option<String>)`](crate::output::DeleteNetworkInsightsAnalysisOutput::network_insights_analysis_id): <p>The ID of the network insights analysis.</p>
    /// - On failure, responds with [`SdkError<DeleteNetworkInsightsAnalysisError>`](crate::error::DeleteNetworkInsightsAnalysisError)
    pub fn delete_network_insights_analysis(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAnalysis<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInsightsPath`](crate::client::fluent_builders::DeleteNetworkInsightsPath) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInsightsPath::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInsightsPath::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_insights_path_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsPath::network_insights_path_id) / [`set_network_insights_path_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInsightsPath::set_network_insights_path_id): <p>The ID of the path.</p>
    /// - On success, responds with [`DeleteNetworkInsightsPathOutput`](crate::output::DeleteNetworkInsightsPathOutput) with field(s):
    ///   - [`network_insights_path_id(Option<String>)`](crate::output::DeleteNetworkInsightsPathOutput::network_insights_path_id): <p>The ID of the path.</p>
    /// - On failure, responds with [`SdkError<DeleteNetworkInsightsPathError>`](crate::error::DeleteNetworkInsightsPathError)
    pub fn delete_network_insights_path(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsPath<C, M, R> {
        fluent_builders::DeleteNetworkInsightsPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInterface`](crate::client::fluent_builders::DeleteNetworkInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInterface::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInterface::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInterface::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInterface::set_network_interface_id): <p>The ID of the network interface.</p>
    /// - On success, responds with [`DeleteNetworkInterfaceOutput`](crate::output::DeleteNetworkInterfaceOutput)

    /// - On failure, responds with [`SdkError<DeleteNetworkInterfaceError>`](crate::error::DeleteNetworkInterfaceError)
    pub fn delete_network_interface(&self) -> fluent_builders::DeleteNetworkInterface<C, M, R> {
        fluent_builders::DeleteNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNetworkInterfacePermission`](crate::client::fluent_builders::DeleteNetworkInterfacePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_interface_permission_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::network_interface_permission_id) / [`set_network_interface_permission_id(Option<String>)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::set_network_interface_permission_id): <p>The ID of the network interface permission.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::force) / [`set_force(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::set_force): <p>Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteNetworkInterfacePermission::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteNetworkInterfacePermissionOutput`](crate::output::DeleteNetworkInterfacePermissionOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::DeleteNetworkInterfacePermissionOutput::return): <p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>
    /// - On failure, responds with [`SdkError<DeleteNetworkInterfacePermissionError>`](crate::error::DeleteNetworkInterfacePermissionError)
    pub fn delete_network_interface_permission(
        &self,
    ) -> fluent_builders::DeleteNetworkInterfacePermission<C, M, R> {
        fluent_builders::DeleteNetworkInterfacePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePlacementGroup`](crate::client::fluent_builders::DeletePlacementGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeletePlacementGroup::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeletePlacementGroup::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeletePlacementGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeletePlacementGroup::set_group_name): <p>The name of the placement group.</p>
    /// - On success, responds with [`DeletePlacementGroupOutput`](crate::output::DeletePlacementGroupOutput)

    /// - On failure, responds with [`SdkError<DeletePlacementGroupError>`](crate::error::DeletePlacementGroupError)
    pub fn delete_placement_group(&self) -> fluent_builders::DeletePlacementGroup<C, M, R> {
        fluent_builders::DeletePlacementGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePublicIpv4Pool`](crate::client::fluent_builders::DeletePublicIpv4Pool) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeletePublicIpv4Pool::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeletePublicIpv4Pool::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::DeletePublicIpv4Pool::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::DeletePublicIpv4Pool::set_pool_id): <p>The ID of the public IPv4 pool you want to delete.</p>
    /// - On success, responds with [`DeletePublicIpv4PoolOutput`](crate::output::DeletePublicIpv4PoolOutput) with field(s):
    ///   - [`return_value(Option<bool>)`](crate::output::DeletePublicIpv4PoolOutput::return_value): <p>Information about the result of deleting the public IPv4 pool.</p>
    /// - On failure, responds with [`SdkError<DeletePublicIpv4PoolError>`](crate::error::DeletePublicIpv4PoolError)
    pub fn delete_public_ipv4_pool(&self) -> fluent_builders::DeletePublicIpv4Pool<C, M, R> {
        fluent_builders::DeletePublicIpv4Pool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQueuedReservedInstances`](crate::client::fluent_builders::DeleteQueuedReservedInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteQueuedReservedInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteQueuedReservedInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`reserved_instances_ids(Vec<String>)`](crate::client::fluent_builders::DeleteQueuedReservedInstances::reserved_instances_ids) / [`set_reserved_instances_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteQueuedReservedInstances::set_reserved_instances_ids): <p>The IDs of the Reserved Instances.</p>
    /// - On success, responds with [`DeleteQueuedReservedInstancesOutput`](crate::output::DeleteQueuedReservedInstancesOutput) with field(s):
    ///   - [`successful_queued_purchase_deletions(Option<Vec<SuccessfulQueuedPurchaseDeletion>>)`](crate::output::DeleteQueuedReservedInstancesOutput::successful_queued_purchase_deletions): <p>Information about the queued purchases that were successfully deleted.</p>
    ///   - [`failed_queued_purchase_deletions(Option<Vec<FailedQueuedPurchaseDeletion>>)`](crate::output::DeleteQueuedReservedInstancesOutput::failed_queued_purchase_deletions): <p>Information about the queued purchases that could not be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteQueuedReservedInstancesError>`](crate::error::DeleteQueuedReservedInstancesError)
    pub fn delete_queued_reserved_instances(
        &self,
    ) -> fluent_builders::DeleteQueuedReservedInstances<C, M, R> {
        fluent_builders::DeleteQueuedReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_destination_cidr_block): <p>The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    ///   - [`destination_ipv6_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::destination_ipv6_cidr_block) / [`set_destination_ipv6_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_destination_ipv6_cidr_block): <p>The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
    ///   - [`destination_prefix_list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::destination_prefix_list_id) / [`set_destination_prefix_list_id(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_destination_prefix_list_id): <p>The ID of the prefix list for the route.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::route_table_id) / [`set_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_route_table_id): <p>The ID of the route table.</p>
    /// - On success, responds with [`DeleteRouteOutput`](crate::output::DeleteRouteOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteError>`](crate::error::DeleteRouteError)
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute<C, M, R> {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRouteTable`](crate::client::fluent_builders::DeleteRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteTable::route_table_id) / [`set_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteRouteTable::set_route_table_id): <p>The ID of the route table.</p>
    /// - On success, responds with [`DeleteRouteTableOutput`](crate::output::DeleteRouteTableOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteTableError>`](crate::error::DeleteRouteTableError)
    pub fn delete_route_table(&self) -> fluent_builders::DeleteRouteTable<C, M, R> {
        fluent_builders::DeleteRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSecurityGroup`](crate::client::fluent_builders::DeleteSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityGroup::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::DeleteSecurityGroup::set_group_id): <p>The ID of the security group. Required for a nondefault VPC.</p>
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteSecurityGroup::set_group_name): <p>[EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteSecurityGroup::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteSecurityGroup::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteSecurityGroupOutput`](crate::output::DeleteSecurityGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteSecurityGroupError>`](crate::error::DeleteSecurityGroupError)
    pub fn delete_security_group(&self) -> fluent_builders::DeleteSecurityGroup<C, M, R> {
        fluent_builders::DeleteSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_snapshot_id): <p>The ID of the EBS snapshot.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteSnapshot::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteSnapshot::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput)

    /// - On failure, responds with [`SdkError<DeleteSnapshotError>`](crate::error::DeleteSnapshotError)
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot<C, M, R> {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSpotDatafeedSubscription`](crate::client::fluent_builders::DeleteSpotDatafeedSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteSpotDatafeedSubscription::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteSpotDatafeedSubscription::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteSpotDatafeedSubscriptionOutput`](crate::output::DeleteSpotDatafeedSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteSpotDatafeedSubscriptionError>`](crate::error::DeleteSpotDatafeedSubscriptionError)
    pub fn delete_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::DeleteSpotDatafeedSubscription<C, M, R> {
        fluent_builders::DeleteSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubnet`](crate::client::fluent_builders::DeleteSubnet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSubnet::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::DeleteSubnet::set_subnet_id): <p>The ID of the subnet.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteSubnet::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteSubnet::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteSubnetOutput`](crate::output::DeleteSubnetOutput)

    /// - On failure, responds with [`SdkError<DeleteSubnetError>`](crate::error::DeleteSubnetError)
    pub fn delete_subnet(&self) -> fluent_builders::DeleteSubnet<C, M, R> {
        fluent_builders::DeleteSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubnetCidrReservation`](crate::client::fluent_builders::DeleteSubnetCidrReservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subnet_cidr_reservation_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSubnetCidrReservation::subnet_cidr_reservation_id) / [`set_subnet_cidr_reservation_id(Option<String>)`](crate::client::fluent_builders::DeleteSubnetCidrReservation::set_subnet_cidr_reservation_id): <p>The ID of the subnet CIDR reservation.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteSubnetCidrReservation::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteSubnetCidrReservation::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteSubnetCidrReservationOutput`](crate::output::DeleteSubnetCidrReservationOutput) with field(s):
    ///   - [`deleted_subnet_cidr_reservation(Option<SubnetCidrReservation>)`](crate::output::DeleteSubnetCidrReservationOutput::deleted_subnet_cidr_reservation): <p>Information about the deleted subnet CIDR reservation.</p>
    /// - On failure, responds with [`SdkError<DeleteSubnetCidrReservationError>`](crate::error::DeleteSubnetCidrReservationError)
    pub fn delete_subnet_cidr_reservation(
        &self,
    ) -> fluent_builders::DeleteSubnetCidrReservation<C, M, R> {
        fluent_builders::DeleteSubnetCidrReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTags::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTags::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`resources(Vec<String>)`](crate::client::fluent_builders::DeleteTags::resources) / [`set_resources(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_resources): <p>The IDs of the resources, separated by spaces.</p>  <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::DeleteTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::DeleteTags::set_tags): <p>The tags to delete. Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string as the tag value, we delete the tag only if its value is an empty string.</p>  <p>If you omit this parameter, we delete all user-defined tags for the specified resources. We do not delete Amazon Web Services-generated tags (tags that have the <code>aws:</code> prefix).</p>  <p>Constraints: Up to 1000 tags.</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficMirrorFilter`](crate::client::fluent_builders::DeleteTrafficMirrorFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_filter_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilter::traffic_mirror_filter_id) / [`set_traffic_mirror_filter_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilter::set_traffic_mirror_filter_id): <p>The ID of the Traffic Mirror filter.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTrafficMirrorFilter::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilter::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTrafficMirrorFilterOutput`](crate::output::DeleteTrafficMirrorFilterOutput) with field(s):
    ///   - [`traffic_mirror_filter_id(Option<String>)`](crate::output::DeleteTrafficMirrorFilterOutput::traffic_mirror_filter_id): <p>The ID of the Traffic Mirror filter.</p>
    /// - On failure, responds with [`SdkError<DeleteTrafficMirrorFilterError>`](crate::error::DeleteTrafficMirrorFilterError)
    pub fn delete_traffic_mirror_filter(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorFilter<C, M, R> {
        fluent_builders::DeleteTrafficMirrorFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficMirrorFilterRule`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_filter_rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule::traffic_mirror_filter_rule_id) / [`set_traffic_mirror_filter_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule::set_traffic_mirror_filter_rule_id): <p>The ID of the Traffic Mirror rule.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTrafficMirrorFilterRuleOutput`](crate::output::DeleteTrafficMirrorFilterRuleOutput) with field(s):
    ///   - [`traffic_mirror_filter_rule_id(Option<String>)`](crate::output::DeleteTrafficMirrorFilterRuleOutput::traffic_mirror_filter_rule_id): <p>The ID of the deleted Traffic Mirror rule.</p>
    /// - On failure, responds with [`SdkError<DeleteTrafficMirrorFilterRuleError>`](crate::error::DeleteTrafficMirrorFilterRuleError)
    pub fn delete_traffic_mirror_filter_rule(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorFilterRule<C, M, R> {
        fluent_builders::DeleteTrafficMirrorFilterRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficMirrorSession`](crate::client::fluent_builders::DeleteTrafficMirrorSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_session_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorSession::traffic_mirror_session_id) / [`set_traffic_mirror_session_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorSession::set_traffic_mirror_session_id): <p>The ID of the Traffic Mirror session.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTrafficMirrorSession::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTrafficMirrorSession::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTrafficMirrorSessionOutput`](crate::output::DeleteTrafficMirrorSessionOutput) with field(s):
    ///   - [`traffic_mirror_session_id(Option<String>)`](crate::output::DeleteTrafficMirrorSessionOutput::traffic_mirror_session_id): <p>The ID of the deleted Traffic Mirror session.</p>
    /// - On failure, responds with [`SdkError<DeleteTrafficMirrorSessionError>`](crate::error::DeleteTrafficMirrorSessionError)
    pub fn delete_traffic_mirror_session(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorSession<C, M, R> {
        fluent_builders::DeleteTrafficMirrorSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficMirrorTarget`](crate::client::fluent_builders::DeleteTrafficMirrorTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_target_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorTarget::traffic_mirror_target_id) / [`set_traffic_mirror_target_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficMirrorTarget::set_traffic_mirror_target_id): <p>The ID of the Traffic Mirror target.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTrafficMirrorTarget::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTrafficMirrorTarget::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTrafficMirrorTargetOutput`](crate::output::DeleteTrafficMirrorTargetOutput) with field(s):
    ///   - [`traffic_mirror_target_id(Option<String>)`](crate::output::DeleteTrafficMirrorTargetOutput::traffic_mirror_target_id): <p>The ID of the deleted Traffic Mirror target.</p>
    /// - On failure, responds with [`SdkError<DeleteTrafficMirrorTargetError>`](crate::error::DeleteTrafficMirrorTargetError)
    pub fn delete_traffic_mirror_target(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorTarget<C, M, R> {
        fluent_builders::DeleteTrafficMirrorTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGateway`](crate::client::fluent_builders::DeleteTransitGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGateway::transit_gateway_id) / [`set_transit_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGateway::set_transit_gateway_id): <p>The ID of the transit gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayOutput`](crate::output::DeleteTransitGatewayOutput) with field(s):
    ///   - [`transit_gateway(Option<TransitGateway>)`](crate::output::DeleteTransitGatewayOutput::transit_gateway): <p>Information about the deleted transit gateway.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayError>`](crate::error::DeleteTransitGatewayError)
    pub fn delete_transit_gateway(&self) -> fluent_builders::DeleteTransitGateway<C, M, R> {
        fluent_builders::DeleteTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayConnect`](crate::client::fluent_builders::DeleteTransitGatewayConnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayConnect::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayConnect::set_transit_gateway_attachment_id): <p>The ID of the Connect attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayConnect::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayConnect::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayConnectOutput`](crate::output::DeleteTransitGatewayConnectOutput) with field(s):
    ///   - [`transit_gateway_connect(Option<TransitGatewayConnect>)`](crate::output::DeleteTransitGatewayConnectOutput::transit_gateway_connect): <p>Information about the deleted Connect attachment.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayConnectError>`](crate::error::DeleteTransitGatewayConnectError)
    pub fn delete_transit_gateway_connect(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayConnect<C, M, R> {
        fluent_builders::DeleteTransitGatewayConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayConnectPeer`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_connect_peer_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer::transit_gateway_connect_peer_id) / [`set_transit_gateway_connect_peer_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer::set_transit_gateway_connect_peer_id): <p>The ID of the Connect peer.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayConnectPeerOutput`](crate::output::DeleteTransitGatewayConnectPeerOutput) with field(s):
    ///   - [`transit_gateway_connect_peer(Option<TransitGatewayConnectPeer>)`](crate::output::DeleteTransitGatewayConnectPeerOutput::transit_gateway_connect_peer): <p>Information about the deleted Connect peer.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayConnectPeerError>`](crate::error::DeleteTransitGatewayConnectPeerError)
    pub fn delete_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::DeleteTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayMulticastDomain`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain::transit_gateway_multicast_domain_id) / [`set_transit_gateway_multicast_domain_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain::set_transit_gateway_multicast_domain_id): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayMulticastDomainOutput`](crate::output::DeleteTransitGatewayMulticastDomainOutput) with field(s):
    ///   - [`transit_gateway_multicast_domain(Option<TransitGatewayMulticastDomain>)`](crate::output::DeleteTransitGatewayMulticastDomainOutput::transit_gateway_multicast_domain): <p>Information about the deleted transit gateway multicast domain.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayMulticastDomainError>`](crate::error::DeleteTransitGatewayMulticastDomainError)
    pub fn delete_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::DeleteTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayPeeringAttachment`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment::set_transit_gateway_attachment_id): <p>The ID of the transit gateway peering attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayPeeringAttachmentOutput`](crate::output::DeleteTransitGatewayPeeringAttachmentOutput) with field(s):
    ///   - [`transit_gateway_peering_attachment(Option<TransitGatewayPeeringAttachment>)`](crate::output::DeleteTransitGatewayPeeringAttachmentOutput::transit_gateway_peering_attachment): <p>The transit gateway peering attachment.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayPeeringAttachmentError>`](crate::error::DeleteTransitGatewayPeeringAttachmentError)
    pub fn delete_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::DeleteTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayPrefixListReference`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::set_transit_gateway_route_table_id): <p>The ID of the route table.</p>
    ///   - [`prefix_list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::prefix_list_id) / [`set_prefix_list_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::set_prefix_list_id): <p>The ID of the prefix list.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayPrefixListReferenceOutput`](crate::output::DeleteTransitGatewayPrefixListReferenceOutput) with field(s):
    ///   - [`transit_gateway_prefix_list_reference(Option<TransitGatewayPrefixListReference>)`](crate::output::DeleteTransitGatewayPrefixListReferenceOutput::transit_gateway_prefix_list_reference): <p>Information about the deleted prefix list reference.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayPrefixListReferenceError>`](crate::error::DeleteTransitGatewayPrefixListReferenceError)
    pub fn delete_transit_gateway_prefix_list_reference(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayPrefixListReference<C, M, R> {
        fluent_builders::DeleteTransitGatewayPrefixListReference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayRoute`](crate::client::fluent_builders::DeleteTransitGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::set_transit_gateway_route_table_id): <p>The ID of the transit gateway route table.</p>
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::set_destination_cidr_block): <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayRoute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayRouteOutput`](crate::output::DeleteTransitGatewayRouteOutput) with field(s):
    ///   - [`route(Option<TransitGatewayRoute>)`](crate::output::DeleteTransitGatewayRouteOutput::route): <p>Information about the route.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayRouteError>`](crate::error::DeleteTransitGatewayRouteError)
    pub fn delete_transit_gateway_route(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayRoute<C, M, R> {
        fluent_builders::DeleteTransitGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayRouteTable`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable::transit_gateway_route_table_id) / [`set_transit_gateway_route_table_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable::set_transit_gateway_route_table_id): <p>The ID of the transit gateway route table.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayRouteTableOutput`](crate::output::DeleteTransitGatewayRouteTableOutput) with field(s):
    ///   - [`transit_gateway_route_table(Option<TransitGatewayRouteTable>)`](crate::output::DeleteTransitGatewayRouteTableOutput::transit_gateway_route_table): <p>Information about the deleted transit gateway route table.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayRouteTableError>`](crate::error::DeleteTransitGatewayRouteTableError)
    pub fn delete_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayRouteTable<C, M, R> {
        fluent_builders::DeleteTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTransitGatewayVpcAttachment`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment::transit_gateway_attachment_id) / [`set_transit_gateway_attachment_id(Option<String>)`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment::set_transit_gateway_attachment_id): <p>The ID of the attachment.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteTransitGatewayVpcAttachmentOutput`](crate::output::DeleteTransitGatewayVpcAttachmentOutput) with field(s):
    ///   - [`transit_gateway_vpc_attachment(Option<TransitGatewayVpcAttachment>)`](crate::output::DeleteTransitGatewayVpcAttachmentOutput::transit_gateway_vpc_attachment): <p>Information about the deleted VPC attachment.</p>
    /// - On failure, responds with [`SdkError<DeleteTransitGatewayVpcAttachmentError>`](crate::error::DeleteTransitGatewayVpcAttachmentError)
    pub fn delete_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::DeleteTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVolume`](crate::client::fluent_builders::DeleteVolume) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVolume::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::DeleteVolume::set_volume_id): <p>The ID of the volume.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVolume::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVolume::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteVolumeOutput`](crate::output::DeleteVolumeOutput)

    /// - On failure, responds with [`SdkError<DeleteVolumeError>`](crate::error::DeleteVolumeError)
    pub fn delete_volume(&self) -> fluent_builders::DeleteVolume<C, M, R> {
        fluent_builders::DeleteVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpc`](crate::client::fluent_builders::DeleteVpc) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpc::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::DeleteVpc::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpc::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpc::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteVpcOutput`](crate::output::DeleteVpcOutput)

    /// - On failure, responds with [`SdkError<DeleteVpcError>`](crate::error::DeleteVpcError)
    pub fn delete_vpc(&self) -> fluent_builders::DeleteVpc<C, M, R> {
        fluent_builders::DeleteVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcEndpointConnectionNotifications`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`connection_notification_ids(Vec<String>)`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications::connection_notification_ids) / [`set_connection_notification_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications::set_connection_notification_ids): <p>One or more notification IDs.</p>
    /// - On success, responds with [`DeleteVpcEndpointConnectionNotificationsOutput`](crate::output::DeleteVpcEndpointConnectionNotificationsOutput) with field(s):
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::DeleteVpcEndpointConnectionNotificationsOutput::unsuccessful): <p>Information about the notifications that could not be deleted successfully.</p>
    /// - On failure, responds with [`SdkError<DeleteVpcEndpointConnectionNotificationsError>`](crate::error::DeleteVpcEndpointConnectionNotificationsError)
    pub fn delete_vpc_endpoint_connection_notifications(
        &self,
    ) -> fluent_builders::DeleteVpcEndpointConnectionNotifications<C, M, R> {
        fluent_builders::DeleteVpcEndpointConnectionNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcEndpoints`](crate::client::fluent_builders::DeleteVpcEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpcEndpoints::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpcEndpoints::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_endpoint_ids(Vec<String>)`](crate::client::fluent_builders::DeleteVpcEndpoints::vpc_endpoint_ids) / [`set_vpc_endpoint_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteVpcEndpoints::set_vpc_endpoint_ids): <p>One or more VPC endpoint IDs.</p>
    /// - On success, responds with [`DeleteVpcEndpointsOutput`](crate::output::DeleteVpcEndpointsOutput) with field(s):
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::DeleteVpcEndpointsOutput::unsuccessful): <p>Information about the VPC endpoints that were not successfully deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteVpcEndpointsError>`](crate::error::DeleteVpcEndpointsError)
    pub fn delete_vpc_endpoints(&self) -> fluent_builders::DeleteVpcEndpoints<C, M, R> {
        fluent_builders::DeleteVpcEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcEndpointServiceConfigurations`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`service_ids(Vec<String>)`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations::service_ids) / [`set_service_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations::set_service_ids): <p>The IDs of one or more services.</p>
    /// - On success, responds with [`DeleteVpcEndpointServiceConfigurationsOutput`](crate::output::DeleteVpcEndpointServiceConfigurationsOutput) with field(s):
    ///   - [`unsuccessful(Option<Vec<UnsuccessfulItem>>)`](crate::output::DeleteVpcEndpointServiceConfigurationsOutput::unsuccessful): <p>Information about the service configurations that were not deleted, if applicable.</p>
    /// - On failure, responds with [`SdkError<DeleteVpcEndpointServiceConfigurationsError>`](crate::error::DeleteVpcEndpointServiceConfigurationsError)
    pub fn delete_vpc_endpoint_service_configurations(
        &self,
    ) -> fluent_builders::DeleteVpcEndpointServiceConfigurations<C, M, R> {
        fluent_builders::DeleteVpcEndpointServiceConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpcPeeringConnection`](crate::client::fluent_builders::DeleteVpcPeeringConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpcPeeringConnection::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpcPeeringConnection::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`vpc_peering_connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpcPeeringConnection::vpc_peering_connection_id) / [`set_vpc_peering_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteVpcPeeringConnection::set_vpc_peering_connection_id): <p>The ID of the VPC peering connection.</p>
    /// - On success, responds with [`DeleteVpcPeeringConnectionOutput`](crate::output::DeleteVpcPeeringConnectionOutput) with field(s):
    ///   - [`r#return(Option<bool>)`](crate::output::DeleteVpcPeeringConnectionOutput::return): <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
    /// - On failure, responds with [`SdkError<DeleteVpcPeeringConnectionError>`](crate::error::DeleteVpcPeeringConnectionError)
    pub fn delete_vpc_peering_connection(
        &self,
    ) -> fluent_builders::DeleteVpcPeeringConnection<C, M, R> {
        fluent_builders::DeleteVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpnConnection`](crate::client::fluent_builders::DeleteVpnConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpn_connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpnConnection::vpn_connection_id) / [`set_vpn_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteVpnConnection::set_vpn_connection_id): <p>The ID of the VPN connection.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpnConnection::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpnConnection::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteVpnConnectionOutput`](crate::output::DeleteVpnConnectionOutput)

    /// - On failure, responds with [`SdkError<DeleteVpnConnectionError>`](crate::error::DeleteVpnConnectionError)
    pub fn delete_vpn_connection(&self) -> fluent_builders::DeleteVpnConnection<C, M, R> {
        fluent_builders::DeleteVpnConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpnConnectionRoute`](crate::client::fluent_builders::DeleteVpnConnectionRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_cidr_block(impl Into<String>)`](crate::client::fluent_builders::DeleteVpnConnectionRoute::destination_cidr_block) / [`set_destination_cidr_block(Option<String>)`](crate::client::fluent_builders::DeleteVpnConnectionRoute::set_destination_cidr_block): <p>The CIDR block associated with the local subnet of the customer network.</p>
    ///   - [`vpn_connection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpnConnectionRoute::vpn_connection_id) / [`set_vpn_connection_id(Option<String>)`](crate::client::fluent_builders::DeleteVpnConnectionRoute::set_vpn_connection_id): <p>The ID of the VPN connection.</p>
    /// - On success, responds with [`DeleteVpnConnectionRouteOutput`](crate::output::DeleteVpnConnectionRouteOutput)

    /// - On failure, responds with [`SdkError<DeleteVpnConnectionRouteError>`](crate::error::DeleteVpnConnectionRouteError)
    pub fn delete_vpn_connection_route(
        &self,
    ) -> fluent_builders::DeleteVpnConnectionRoute<C, M, R> {
        fluent_builders::DeleteVpnConnectionRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVpnGateway`](crate::client::fluent_builders::DeleteVpnGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpn_gateway_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVpnGateway::vpn_gateway_id) / [`set_vpn_gateway_id(Option<String>)`](crate::client::fluent_builders::DeleteVpnGateway::set_vpn_gateway_id): <p>The ID of the virtual private gateway.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeleteVpnGateway::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeleteVpnGateway::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeleteVpnGatewayOutput`](crate::output::DeleteVpnGatewayOutput)

    /// - On failure, responds with [`SdkError<DeleteVpnGatewayError>`](crate::error::DeleteVpnGatewayError)
    pub fn delete_vpn_gateway(&self) -> fluent_builders::DeleteVpnGateway<C, M, R> {
        fluent_builders::DeleteVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprovisionByoipCidr`](crate::client::fluent_builders::DeprovisionByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::DeprovisionByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::DeprovisionByoipCidr::set_cidr): <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeprovisionByoipCidr::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeprovisionByoipCidr::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeprovisionByoipCidrOutput`](crate::output::DeprovisionByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::DeprovisionByoipCidrOutput::byoip_cidr): <p>Information about the address range.</p>
    /// - On failure, responds with [`SdkError<DeprovisionByoipCidrError>`](crate::error::DeprovisionByoipCidrError)
    pub fn deprovision_byoip_cidr(&self) -> fluent_builders::DeprovisionByoipCidr<C, M, R> {
        fluent_builders::DeprovisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprovisionIpamPoolCidr`](crate::client::fluent_builders::DeprovisionIpamPoolCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`ipam_pool_id(impl Into<String>)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::ipam_pool_id) / [`set_ipam_pool_id(Option<String>)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::set_ipam_pool_id): <p>The ID of the pool that has the CIDR you want to deprovision.</p>
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::DeprovisionIpamPoolCidr::set_cidr): <p>The CIDR which you want to deprovision from the pool.</p>
    /// - On success, responds with [`DeprovisionIpamPoolCidrOutput`](crate::output::DeprovisionIpamPoolCidrOutput) with field(s):
    ///   - [`ipam_pool_cidr(Option<IpamPoolCidr>)`](crate::output::DeprovisionIpamPoolCidrOutput::ipam_pool_cidr): <p>The deprovisioned pool CIDR.</p>
    /// - On failure, responds with [`SdkError<DeprovisionIpamPoolCidrError>`](crate::error::DeprovisionIpamPoolCidrError)
    pub fn deprovision_ipam_pool_cidr(&self) -> fluent_builders::DeprovisionIpamPoolCidr<C, M, R> {
        fluent_builders::DeprovisionIpamPoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprovisionPublicIpv4PoolCidr`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`pool_id(impl Into<String>)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::pool_id) / [`set_pool_id(Option<String>)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::set_pool_id): <p>The ID of the pool that you want to deprovision the CIDR from.</p>
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr::set_cidr): <p>The CIDR you want to deprovision from the pool.</p>
    /// - On success, responds with [`DeprovisionPublicIpv4PoolCidrOutput`](crate::output::DeprovisionPublicIpv4PoolCidrOutput) with field(s):
    ///   - [`pool_id(Option<String>)`](crate::output::DeprovisionPublicIpv4PoolCidrOutput::pool_id): <p>The ID of the pool that you deprovisioned the CIDR from.</p>
    ///   - [`deprovisioned_addresses(Option<Vec<String>>)`](crate::output::DeprovisionPublicIpv4PoolCidrOutput::deprovisioned_addresses): <p>The deprovisioned CIDRs.</p>
    /// - On failure, responds with [`SdkError<DeprovisionPublicIpv4PoolCidrError>`](crate::error::DeprovisionPublicIpv4PoolCidrError)
    pub fn deprovision_public_ipv4_pool_cidr(
        &self,
    ) -> fluent_builders::DeprovisionPublicIpv4PoolCidr<C, M, R> {
        fluent_builders::DeprovisionPublicIpv4PoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterImage`](crate::client::fluent_builders::DeregisterImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterImage::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::DeregisterImage::set_image_id): <p>The ID of the AMI.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeregisterImage::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeregisterImage::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeregisterImageOutput`](crate::output::DeregisterImageOutput)

    /// - On failure, responds with [`SdkError<DeregisterImageError>`](crate::error::DeregisterImageError)
    pub fn deregister_image(&self) -> fluent_builders::DeregisterImage<C, M, R> {
        fluent_builders::DeregisterImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterInstanceEventNotificationAttributes`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_tag_attribute(DeregisterInstanceTagAttributeRequest)`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes::instance_tag_attribute) / [`set_instance_tag_attribute(Option<DeregisterInstanceTagAttributeRequest>)`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes::set_instance_tag_attribute): <p>Information about the tag keys to deregister.</p>
    /// - On success, responds with [`DeregisterInstanceEventNotificationAttributesOutput`](crate::output::DeregisterInstanceEventNotificationAttributesOutput) with field(s):
    ///   - [`instance_tag_attribute(Option<InstanceTagNotificationAttribute>)`](crate::output::DeregisterInstanceEventNotificationAttributesOutput::instance_tag_attribute): <p>The resulting set of tag keys.</p>
    /// - On failure, responds with [`SdkError<DeregisterInstanceEventNotificationAttributesError>`](crate::error::DeregisterInstanceEventNotificationAttributesError)
    pub fn deregister_instance_event_notification_attributes(
        &self,
    ) -> fluent_builders::DeregisterInstanceEventNotificationAttributes<C, M, R> {
        fluent_builders::DeregisterInstanceEventNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTransitGatewayMulticastGroupMembers`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::transit_gateway_multicast_domain_id) / [`set_transit_gateway_multicast_domain_id(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::set_transit_gateway_multicast_domain_id): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`group_ip_address(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::group_ip_address) / [`set_group_ip_address(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::set_group_ip_address): <p>The IP address assigned to the transit gateway multicast group.</p>
    ///   - [`network_interface_ids(Vec<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::network_interface_ids) / [`set_network_interface_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::set_network_interface_ids): <p>The IDs of the group members' network interfaces.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeregisterTransitGatewayMulticastGroupMembersOutput`](crate::output::DeregisterTransitGatewayMulticastGroupMembersOutput) with field(s):
    ///   - [`deregistered_multicast_group_members(Option<TransitGatewayMulticastDeregisteredGroupMembers>)`](crate::output::DeregisterTransitGatewayMulticastGroupMembersOutput::deregistered_multicast_group_members): <p>Information about the deregistered members.</p>
    /// - On failure, responds with [`SdkError<DeregisterTransitGatewayMulticastGroupMembersError>`](crate::error::DeregisterTransitGatewayMulticastGroupMembersError)
    pub fn deregister_transit_gateway_multicast_group_members(
        &self,
    ) -> fluent_builders::DeregisterTransitGatewayMulticastGroupMembers<C, M, R> {
        fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTransitGatewayMulticastGroupSources`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::transit_gateway_multicast_domain_id) / [`set_transit_gateway_multicast_domain_id(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::set_transit_gateway_multicast_domain_id): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`group_ip_address(impl Into<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::group_ip_address) / [`set_group_ip_address(Option<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::set_group_ip_address): <p>The IP address assigned to the transit gateway multicast group.</p>
    ///   - [`network_interface_ids(Vec<String>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::network_interface_ids) / [`set_network_interface_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::set_network_interface_ids): <p>The IDs of the group sources' network interfaces.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DeregisterTransitGatewayMulticastGroupSourcesOutput`](crate::output::DeregisterTransitGatewayMulticastGroupSourcesOutput) with field(s):
    ///   - [`deregistered_multicast_group_sources(Option<TransitGatewayMulticastDeregisteredGroupSources>)`](crate::output::DeregisterTransitGatewayMulticastGroupSourcesOutput::deregistered_multicast_group_sources): <p>Information about the deregistered group sources.</p>
    /// - On failure, responds with [`SdkError<DeregisterTransitGatewayMulticastGroupSourcesError>`](crate::error::DeregisterTransitGatewayMulticastGroupSourcesError)
    pub fn deregister_transit_gateway_multicast_group_sources(
        &self,
    ) -> fluent_builders::DeregisterTransitGatewayMulticastGroupSources<C, M, R> {
        fluent_builders::DeregisterTransitGatewayMulticastGroupSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_names(Vec<AccountAttributeName>)`](crate::client::fluent_builders::DescribeAccountAttributes::attribute_names) / [`set_attribute_names(Option<Vec<AccountAttributeName>>)`](crate::client::fluent_builders::DescribeAccountAttributes::set_attribute_names): <p>The account attribute names.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeAccountAttributes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeAccountAttributes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`account_attributes(Option<Vec<AccountAttribute>>)`](crate::output::DescribeAccountAttributesOutput::account_attributes): <p>Information about the account attributes.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddresses`](crate::client::fluent_builders::DescribeAddresses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeAddresses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeAddresses::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.</p> </li>   <li> <p> <code>association-id</code> - [EC2-VPC] The association ID for the address.</p> </li>   <li> <p> <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a VPC (<code>vpc</code>).</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p> </li>   <li> <p> <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where Amazon Web Services advertises IP addresses. </p> </li>   <li> <p> <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated with, if any.</p> </li>   <li> <p> <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.</p> </li>   <li> <p> <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.</p> </li>   <li> <p> <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`public_ips(Vec<String>)`](crate::client::fluent_builders::DescribeAddresses::public_ips) / [`set_public_ips(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAddresses::set_public_ips): <p>One or more Elastic IP addresses.</p>  <p>Default: Describes all your Elastic IP addresses.</p>
    ///   - [`allocation_ids(Vec<String>)`](crate::client::fluent_builders::DescribeAddresses::allocation_ids) / [`set_allocation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAddresses::set_allocation_ids): <p>[EC2-VPC] Information about the allocation IDs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeAddresses::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeAddresses::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeAddressesOutput`](crate::output::DescribeAddressesOutput) with field(s):
    ///   - [`addresses(Option<Vec<Address>>)`](crate::output::DescribeAddressesOutput::addresses): <p>Information about the Elastic IP addresses.</p>
    /// - On failure, responds with [`SdkError<DescribeAddressesError>`](crate::error::DescribeAddressesError)
    pub fn describe_addresses(&self) -> fluent_builders::DescribeAddresses<C, M, R> {
        fluent_builders::DescribeAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddressesAttribute`](crate::client::fluent_builders::DescribeAddressesAttribute) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAddressesAttribute::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`allocation_ids(Vec<String>)`](crate::client::fluent_builders::DescribeAddressesAttribute::allocation_ids) / [`set_allocation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAddressesAttribute::set_allocation_ids): <p>[EC2-VPC] The allocation IDs.</p>
    ///   - [`attribute(AddressAttributeName)`](crate::client::fluent_builders::DescribeAddressesAttribute::attribute) / [`set_attribute(Option<AddressAttributeName>)`](crate::client::fluent_builders::DescribeAddressesAttribute::set_attribute): <p>The attribute of the IP address.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAddressesAttribute::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAddressesAttribute::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAddressesAttribute::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAddressesAttribute::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeAddressesAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeAddressesAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeAddressesAttributeOutput`](crate::output::DescribeAddressesAttributeOutput) with field(s):
    ///   - [`addresses(Option<Vec<AddressAttribute>>)`](crate::output::DescribeAddressesAttributeOutput::addresses): <p>Information about the IP addresses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAddressesAttributeOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeAddressesAttributeError>`](crate::error::DescribeAddressesAttributeError)
    pub fn describe_addresses_attribute(
        &self,
    ) -> fluent_builders::DescribeAddressesAttribute<C, M, R> {
        fluent_builders::DescribeAddressesAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAggregateIdFormat`](crate::client::fluent_builders::DescribeAggregateIdFormat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeAggregateIdFormat::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeAggregateIdFormat::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeAggregateIdFormatOutput`](crate::output::DescribeAggregateIdFormatOutput) with field(s):
    ///   - [`use_long_ids_aggregated(Option<bool>)`](crate::output::DescribeAggregateIdFormatOutput::use_long_ids_aggregated): <p>Indicates whether all resource types in the Region are configured to use longer IDs. This value is only <code>true</code> if all users are configured to use longer IDs for all resources types in the Region.</p>
    ///   - [`statuses(Option<Vec<IdFormat>>)`](crate::output::DescribeAggregateIdFormatOutput::statuses): <p>Information about each resource's ID format.</p>
    /// - On failure, responds with [`SdkError<DescribeAggregateIdFormatError>`](crate::error::DescribeAggregateIdFormatError)
    pub fn describe_aggregate_id_format(
        &self,
    ) -> fluent_builders::DescribeAggregateIdFormat<C, M, R> {
        fluent_builders::DescribeAggregateIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAvailabilityZones`](crate::client::fluent_builders::DescribeAvailabilityZones) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeAvailabilityZones::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeAvailabilityZones::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li>   <li> <p> <code>message</code> - The Zone message.</p> </li>   <li> <p> <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p> </li>   <li> <p> <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li>   <li> <p> <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li>   <li> <p> <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).</p> </li>   <li> <p> <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (<code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).</p> </li>   <li> <p> <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li>   <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li>   <li> <p> <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li>   <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li>  </ul>
    ///   - [`zone_names(Vec<String>)`](crate::client::fluent_builders::DescribeAvailabilityZones::zone_names) / [`set_zone_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAvailabilityZones::set_zone_names): <p>The names of the Availability Zones, Local Zones, and Wavelength Zones.</p>
    ///   - [`zone_ids(Vec<String>)`](crate::client::fluent_builders::DescribeAvailabilityZones::zone_ids) / [`set_zone_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAvailabilityZones::set_zone_ids): <p>The IDs of the Availability Zones, Local Zones, and Wavelength Zones.</p>
    ///   - [`all_availability_zones(bool)`](crate::client::fluent_builders::DescribeAvailabilityZones::all_availability_zones) / [`set_all_availability_zones(Option<bool>)`](crate::client::fluent_builders::DescribeAvailabilityZones::set_all_availability_zones): <p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.</p>  <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeAvailabilityZones::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeAvailabilityZones::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeAvailabilityZonesOutput`](crate::output::DescribeAvailabilityZonesOutput) with field(s):
    ///   - [`availability_zones(Option<Vec<AvailabilityZone>>)`](crate::output::DescribeAvailabilityZonesOutput::availability_zones): <p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>
    /// - On failure, responds with [`SdkError<DescribeAvailabilityZonesError>`](crate::error::DescribeAvailabilityZonesError)
    pub fn describe_availability_zones(
        &self,
    ) -> fluent_builders::DescribeAvailabilityZones<C, M, R> {
        fluent_builders::DescribeAvailabilityZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBundleTasks`](crate::client::fluent_builders::DescribeBundleTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bundle_ids(Vec<String>)`](crate::client::fluent_builders::DescribeBundleTasks::bundle_ids) / [`set_bundle_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeBundleTasks::set_bundle_ids): <p>The bundle task IDs.</p>  <p>Default: Describes all your bundle tasks.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeBundleTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeBundleTasks::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>bundle-id</code> - The ID of the bundle task.</p> </li>   <li> <p> <code>error-code</code> - If the task failed, the error code returned.</p> </li>   <li> <p> <code>error-message</code> - If the task failed, the error message returned.</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li>   <li> <p> <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p> </li>   <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p> </li>   <li> <p> <code>s3-prefix</code> - The beginning of the AMI name.</p> </li>   <li> <p> <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p> </li>   <li> <p> <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p> </li>   <li> <p> <code>update-time</code> - The time of the most recent update for the task.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeBundleTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeBundleTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeBundleTasksOutput`](crate::output::DescribeBundleTasksOutput) with field(s):
    ///   - [`bundle_tasks(Option<Vec<BundleTask>>)`](crate::output::DescribeBundleTasksOutput::bundle_tasks): <p>Information about the bundle tasks.</p>
    /// - On failure, responds with [`SdkError<DescribeBundleTasksError>`](crate::error::DescribeBundleTasksError)
    pub fn describe_bundle_tasks(&self) -> fluent_builders::DescribeBundleTasks<C, M, R> {
        fluent_builders::DescribeBundleTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeByoipCidrs`](crate::client::fluent_builders::DescribeByoipCidrs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeByoipCidrs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeByoipCidrs::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeByoipCidrs::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeByoipCidrs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeByoipCidrs::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeByoipCidrs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeByoipCidrs::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeByoipCidrsOutput`](crate::output::DescribeByoipCidrsOutput) with field(s):
    ///   - [`byoip_cidrs(Option<Vec<ByoipCidr>>)`](crate::output::DescribeByoipCidrsOutput::byoip_cidrs): <p>Information about your address ranges.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeByoipCidrsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeByoipCidrsError>`](crate::error::DescribeByoipCidrsError)
    pub fn describe_byoip_cidrs(&self) -> fluent_builders::DescribeByoipCidrs<C, M, R> {
        fluent_builders::DescribeByoipCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCapacityReservationFleets`](crate::client::fluent_builders::DescribeCapacityReservationFleets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCapacityReservationFleets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_reservation_fleet_ids(Vec<String>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::capacity_reservation_fleet_ids) / [`set_capacity_reservation_fleet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::set_capacity_reservation_fleet_ids): <p>The IDs of the Capacity Reservation Fleets to describe.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>state</code> - The state of the Fleet (<code>submitted</code> | <code>modifying</code> | <code>active</code> | <code>partially_fulfilled</code> | <code>expiring</code> | <code>expired</code> | <code>cancelling</code> | <code>cancelled</code> | <code>failed</code>).</p> </li>   <li> <p> <code>instance-match-criteria</code> - The instance matching criteria for the Fleet. Only <code>open</code> is supported.</p> </li>   <li> <p> <code>tenancy</code> - The tenancy of the Fleet (<code>default</code> | <code>dedicated</code>).</p> </li>   <li> <p> <code>allocation-strategy</code> - The allocation strategy used by the Fleet. Only <code>prioritized</code> is supported.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeCapacityReservationFleets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeCapacityReservationFleetsOutput`](crate::output::DescribeCapacityReservationFleetsOutput) with field(s):
    ///   - [`capacity_reservation_fleets(Option<Vec<CapacityReservationFleet>>)`](crate::output::DescribeCapacityReservationFleetsOutput::capacity_reservation_fleets): <p>Information about the Capacity Reservation Fleets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCapacityReservationFleetsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeCapacityReservationFleetsError>`](crate::error::DescribeCapacityReservationFleetsError)
    pub fn describe_capacity_reservation_fleets(
        &self,
    ) -> fluent_builders::DescribeCapacityReservationFleets<C, M, R> {
        fluent_builders::DescribeCapacityReservationFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCapacityReservations`](crate::client::fluent_builders::DescribeCapacityReservations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCapacityReservations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_reservation_ids(Vec<String>)`](crate::client::fluent_builders::DescribeCapacityReservations::capacity_reservation_ids) / [`set_capacity_reservation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCapacityReservations::set_capacity_reservation_ids): <p>The ID of the Capacity Reservation.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCapacityReservations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCapacityReservations::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCapacityReservations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCapacityReservations::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCapacityReservations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCapacityReservations::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.</p> </li>   <li> <p> <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone of the Capacity Reservation.</p> </li>   <li> <p> <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>    <ul>     <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>     <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>    </ul> </li>   <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p> </li>   <li> <p> <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p>    <ul>     <li> <p> <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p> </li>     <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li>     <li> <p> <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p> </li>     <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li>     <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li>    </ul> </li>   <li> <p> <code>start-date</code> - The date and time at which the Capacity Reservation was started.</p> </li>   <li> <p> <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.</p> </li>   <li> <p> <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>    <ul>     <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li>     <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li>    </ul> </li>   <li> <p> <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>    <ul>     <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li>     <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</p> </li>    </ul> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeCapacityReservations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeCapacityReservations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeCapacityReservationsOutput`](crate::output::DescribeCapacityReservationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCapacityReservationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`capacity_reservations(Option<Vec<CapacityReservation>>)`](crate::output::DescribeCapacityReservationsOutput::capacity_reservations): <p>Information about the Capacity Reservations.</p>
    /// - On failure, responds with [`SdkError<DescribeCapacityReservationsError>`](crate::error::DescribeCapacityReservationsError)
    pub fn describe_capacity_reservations(
        &self,
    ) -> fluent_builders::DescribeCapacityReservations<C, M, R> {
        fluent_builders::DescribeCapacityReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCarrierGateways`](crate::client::fluent_builders::DescribeCarrierGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCarrierGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`carrier_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeCarrierGateways::carrier_gateway_ids) / [`set_carrier_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCarrierGateways::set_carrier_gateway_ids): <p>One or more carrier gateway IDs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCarrierGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCarrierGateways::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p> </li>   <li> <p> <code>state</code> - The state of the carrier gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner of the carrier gateway.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCarrierGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCarrierGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCarrierGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCarrierGateways::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeCarrierGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeCarrierGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeCarrierGatewaysOutput`](crate::output::DescribeCarrierGatewaysOutput) with field(s):
    ///   - [`carrier_gateways(Option<Vec<CarrierGateway>>)`](crate::output::DescribeCarrierGatewaysOutput::carrier_gateways): <p>Information about the carrier gateway.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCarrierGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeCarrierGatewaysError>`](crate::error::DescribeCarrierGatewaysError)
    pub fn describe_carrier_gateways(&self) -> fluent_builders::DescribeCarrierGateways<C, M, R> {
        fluent_builders::DescribeCarrierGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClassicLinkInstances`](crate::client::fluent_builders::DescribeClassicLinkInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClassicLinkInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>group-id</code> - The ID of a VPC security group that's associated with the instance.</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC to which the instance is linked.</p> <p> <code>vpc-id</code> - The ID of the VPC that the instance is linked to.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClassicLinkInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::set_instance_ids): <p>One or more instance IDs. Must be instances linked to a VPC through ClassicLink.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClassicLinkInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>  <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClassicLinkInstances::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeClassicLinkInstancesOutput`](crate::output::DescribeClassicLinkInstancesOutput) with field(s):
    ///   - [`instances(Option<Vec<ClassicLinkInstance>>)`](crate::output::DescribeClassicLinkInstancesOutput::instances): <p>Information about one or more linked EC2-Classic instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClassicLinkInstancesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClassicLinkInstancesError>`](crate::error::DescribeClassicLinkInstancesError)
    pub fn describe_classic_link_instances(
        &self,
    ) -> fluent_builders::DescribeClassicLinkInstances<C, M, R> {
        fluent_builders::DescribeClassicLinkInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientVpnAuthorizationRules`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>description</code> - The description of the authorization rule.</p> </li>   <li> <p> <code>destination-cidr</code> - The CIDR of the network to which the authorization rule applies.</p> </li>   <li> <p> <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    /// - On success, responds with [`DescribeClientVpnAuthorizationRulesOutput`](crate::output::DescribeClientVpnAuthorizationRulesOutput) with field(s):
    ///   - [`authorization_rules(Option<Vec<AuthorizationRule>>)`](crate::output::DescribeClientVpnAuthorizationRulesOutput::authorization_rules): <p>Information about the authorization rules.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientVpnAuthorizationRulesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClientVpnAuthorizationRulesError>`](crate::error::DescribeClientVpnAuthorizationRulesError)
    pub fn describe_client_vpn_authorization_rules(
        &self,
    ) -> fluent_builders::DescribeClientVpnAuthorizationRules<C, M, R> {
        fluent_builders::DescribeClientVpnAuthorizationRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientVpnConnections`](crate::client::fluent_builders::DescribeClientVpnConnections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnConnections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnConnections::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnConnections::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClientVpnConnections::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClientVpnConnections::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>connection-id</code> - The ID of the connection.</p> </li>   <li> <p> <code>username</code> - For Active Directory client authentication, the user name of the client who established the client connection.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnConnections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnConnections::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClientVpnConnections::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClientVpnConnections::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClientVpnConnections::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClientVpnConnections::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeClientVpnConnectionsOutput`](crate::output::DescribeClientVpnConnectionsOutput) with field(s):
    ///   - [`connections(Option<Vec<ClientVpnConnection>>)`](crate::output::DescribeClientVpnConnectionsOutput::connections): <p>Information about the active and terminated client connections.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientVpnConnectionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClientVpnConnectionsError>`](crate::error::DescribeClientVpnConnectionsError)
    pub fn describe_client_vpn_connections(
        &self,
    ) -> fluent_builders::DescribeClientVpnConnections<C, M, R> {
        fluent_builders::DescribeClientVpnConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientVpnEndpoints`](crate::client::fluent_builders::DescribeClientVpnEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_ids(Vec<String>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::client_vpn_endpoint_ids) / [`set_client_vpn_endpoint_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::set_client_vpn_endpoint_ids): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p> </li>   <li> <p> <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClientVpnEndpoints::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeClientVpnEndpointsOutput`](crate::output::DescribeClientVpnEndpointsOutput) with field(s):
    ///   - [`client_vpn_endpoints(Option<Vec<ClientVpnEndpoint>>)`](crate::output::DescribeClientVpnEndpointsOutput::client_vpn_endpoints): <p>Information about the Client VPN endpoints.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientVpnEndpointsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClientVpnEndpointsError>`](crate::error::DescribeClientVpnEndpointsError)
    pub fn describe_client_vpn_endpoints(
        &self,
    ) -> fluent_builders::DescribeClientVpnEndpoints<C, M, R> {
        fluent_builders::DescribeClientVpnEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientVpnRoutes`](crate::client::fluent_builders::DescribeClientVpnRoutes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnRoutes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>destination-cidr</code> - The CIDR of the route destination.</p> </li>   <li> <p> <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p> </li>   <li> <p> <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClientVpnRoutes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClientVpnRoutes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClientVpnRoutes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeClientVpnRoutesOutput`](crate::output::DescribeClientVpnRoutesOutput) with field(s):
    ///   - [`routes(Option<Vec<ClientVpnRoute>>)`](crate::output::DescribeClientVpnRoutesOutput::routes): <p>Information about the Client VPN endpoint routes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientVpnRoutesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClientVpnRoutesError>`](crate::error::DescribeClientVpnRoutesError)
    pub fn describe_client_vpn_routes(&self) -> fluent_builders::DescribeClientVpnRoutes<C, M, R> {
        fluent_builders::DescribeClientVpnRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClientVpnTargetNetworks`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_vpn_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::client_vpn_endpoint_id) / [`set_client_vpn_endpoint_id(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_client_vpn_endpoint_id): <p>The ID of the Client VPN endpoint.</p>
    ///   - [`association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::association_ids) / [`set_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_association_ids): <p>The IDs of the target network associations.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>association-id</code> - The ID of the association.</p> </li>   <li> <p> <code>target-network-id</code> - The ID of the subnet specified as the target network.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeClientVpnTargetNetworksOutput`](crate::output::DescribeClientVpnTargetNetworksOutput) with field(s):
    ///   - [`client_vpn_target_networks(Option<Vec<TargetNetwork>>)`](crate::output::DescribeClientVpnTargetNetworksOutput::client_vpn_target_networks): <p>Information about the associated target networks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeClientVpnTargetNetworksOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeClientVpnTargetNetworksError>`](crate::error::DescribeClientVpnTargetNetworksError)
    pub fn describe_client_vpn_target_networks(
        &self,
    ) -> fluent_builders::DescribeClientVpnTargetNetworks<C, M, R> {
        fluent_builders::DescribeClientVpnTargetNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCoipPools`](crate::client::fluent_builders::DescribeCoipPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCoipPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_ids(Vec<String>)`](crate::client::fluent_builders::DescribeCoipPools::pool_ids) / [`set_pool_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCoipPools::set_pool_ids): <p>The IDs of the address pools.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCoipPools::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCoipPools::set_filters): <p>The filters. The following are the possible values:</p>  <ul>   <li> <p> <code>coip-pool.pool-id</code> </p> </li>  </ul>  <ul>   <li> <p> <code>coip-pool.local-gateway-route-table-id</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCoipPools::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCoipPools::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCoipPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCoipPools::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeCoipPools::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeCoipPools::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeCoipPoolsOutput`](crate::output::DescribeCoipPoolsOutput) with field(s):
    ///   - [`coip_pools(Option<Vec<CoipPool>>)`](crate::output::DescribeCoipPoolsOutput::coip_pools): <p>Information about the address pools.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCoipPoolsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeCoipPoolsError>`](crate::error::DescribeCoipPoolsError)
    pub fn describe_coip_pools(&self) -> fluent_builders::DescribeCoipPools<C, M, R> {
        fluent_builders::DescribeCoipPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeConversionTasks`](crate::client::fluent_builders::DescribeConversionTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`conversion_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeConversionTasks::conversion_task_ids) / [`set_conversion_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeConversionTasks::set_conversion_task_ids): <p>The conversion task IDs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeConversionTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeConversionTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeConversionTasksOutput`](crate::output::DescribeConversionTasksOutput) with field(s):
    ///   - [`conversion_tasks(Option<Vec<ConversionTask>>)`](crate::output::DescribeConversionTasksOutput::conversion_tasks): <p>Information about the conversion tasks.</p>
    /// - On failure, responds with [`SdkError<DescribeConversionTasksError>`](crate::error::DescribeConversionTasksError)
    pub fn describe_conversion_tasks(&self) -> fluent_builders::DescribeConversionTasks<C, M, R> {
        fluent_builders::DescribeConversionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomerGateways`](crate::client::fluent_builders::DescribeCustomerGateways) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`customer_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeCustomerGateways::customer_gateway_ids) / [`set_customer_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCustomerGateways::set_customer_gateway_ids): <p>One or more customer gateway IDs.</p>  <p>Default: Describes all your customer gateways.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCustomerGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCustomerGateways::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>bgp-asn</code> - The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p> </li>   <li> <p> <code>customer-gateway-id</code> - The ID of the customer gateway.</p> </li>   <li> <p> <code>ip-address</code> - The IP address of the customer gateway's Internet-routable external interface.</p> </li>   <li> <p> <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li>   <li> <p> <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeCustomerGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeCustomerGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeCustomerGatewaysOutput`](crate::output::DescribeCustomerGatewaysOutput) with field(s):
    ///   - [`customer_gateways(Option<Vec<CustomerGateway>>)`](crate::output::DescribeCustomerGatewaysOutput::customer_gateways): <p>Information about one or more customer gateways.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomerGatewaysError>`](crate::error::DescribeCustomerGatewaysError)
    pub fn describe_customer_gateways(&self) -> fluent_builders::DescribeCustomerGateways<C, M, R> {
        fluent_builders::DescribeCustomerGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDhcpOptions`](crate::client::fluent_builders::DescribeDhcpOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDhcpOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dhcp_options_ids(Vec<String>)`](crate::client::fluent_builders::DescribeDhcpOptions::dhcp_options_ids) / [`set_dhcp_options_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDhcpOptions::set_dhcp_options_ids): <p>The IDs of one or more DHCP options sets.</p>  <p>Default: Describes all your DHCP options sets.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDhcpOptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDhcpOptions::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>dhcp-options-id</code> - The ID of a DHCP options set.</p> </li>   <li> <p> <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p> </li>   <li> <p> <code>value</code> - The value for one of the options.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the DHCP options set.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeDhcpOptions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeDhcpOptions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDhcpOptions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDhcpOptions::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDhcpOptions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDhcpOptions::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeDhcpOptionsOutput`](crate::output::DescribeDhcpOptionsOutput) with field(s):
    ///   - [`dhcp_options(Option<Vec<DhcpOptions>>)`](crate::output::DescribeDhcpOptionsOutput::dhcp_options): <p>Information about one or more DHCP options sets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDhcpOptionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeDhcpOptionsError>`](crate::error::DescribeDhcpOptionsError)
    pub fn describe_dhcp_options(&self) -> fluent_builders::DescribeDhcpOptions<C, M, R> {
        fluent_builders::DescribeDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEgressOnlyInternetGateways`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`egress_only_internet_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::egress_only_internet_gateway_ids) / [`set_egress_only_internet_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::set_egress_only_internet_gateway_ids): <p>One or more egress-only internet gateway IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    /// - On success, responds with [`DescribeEgressOnlyInternetGatewaysOutput`](crate::output::DescribeEgressOnlyInternetGatewaysOutput) with field(s):
    ///   - [`egress_only_internet_gateways(Option<Vec<EgressOnlyInternetGateway>>)`](crate::output::DescribeEgressOnlyInternetGatewaysOutput::egress_only_internet_gateways): <p>Information about the egress-only internet gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEgressOnlyInternetGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeEgressOnlyInternetGatewaysError>`](crate::error::DescribeEgressOnlyInternetGatewaysError)
    pub fn describe_egress_only_internet_gateways(
        &self,
    ) -> fluent_builders::DescribeEgressOnlyInternetGateways<C, M, R> {
        fluent_builders::DescribeEgressOnlyInternetGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeElasticGpus`](crate::client::fluent_builders::DescribeElasticGpus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`elastic_gpu_ids(Vec<String>)`](crate::client::fluent_builders::DescribeElasticGpus::elastic_gpu_ids) / [`set_elastic_gpu_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeElasticGpus::set_elastic_gpu_ids): <p>The Elastic Graphics accelerator IDs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeElasticGpus::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeElasticGpus::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeElasticGpus::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeElasticGpus::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.</p> </li>   <li> <p> <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> | <code>IMPAIRED</code>).</p> </li>   <li> <p> <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).</p> </li>   <li> <p> <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeElasticGpus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeElasticGpus::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeElasticGpus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeElasticGpus::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`DescribeElasticGpusOutput`](crate::output::DescribeElasticGpusOutput) with field(s):
    ///   - [`elastic_gpu_set(Option<Vec<ElasticGpus>>)`](crate::output::DescribeElasticGpusOutput::elastic_gpu_set): <p>Information about the Elastic Graphics accelerators.</p>
    ///   - [`max_results(Option<i32>)`](crate::output::DescribeElasticGpusOutput::max_results): <p>The total number of items to return. If the total number of items available is more than the value specified in max-items then a Next-Token will be provided in the output that you can use to resume pagination.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeElasticGpusOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeElasticGpusError>`](crate::error::DescribeElasticGpusError)
    pub fn describe_elastic_gpus(&self) -> fluent_builders::DescribeElasticGpus<C, M, R> {
        fluent_builders::DescribeElasticGpus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportImageTasks`](crate::client::fluent_builders::DescribeExportImageTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeExportImageTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeExportImageTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeExportImageTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeExportImageTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeExportImageTasks::set_filters): <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
    ///   - [`export_image_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeExportImageTasks::export_image_task_ids) / [`set_export_image_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeExportImageTasks::set_export_image_task_ids): <p>The IDs of the export image tasks.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeExportImageTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeExportImageTasks::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeExportImageTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeExportImageTasks::set_next_token): <p>A token that indicates the next page of results.</p>
    /// - On success, responds with [`DescribeExportImageTasksOutput`](crate::output::DescribeExportImageTasksOutput) with field(s):
    ///   - [`export_image_tasks(Option<Vec<ExportImageTask>>)`](crate::output::DescribeExportImageTasksOutput::export_image_tasks): <p>Information about the export image tasks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeExportImageTasksOutput::next_token): <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeExportImageTasksError>`](crate::error::DescribeExportImageTasksError)
    pub fn describe_export_image_tasks(
        &self,
    ) -> fluent_builders::DescribeExportImageTasks<C, M, R> {
        fluent_builders::DescribeExportImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeExportTasks::export_task_ids) / [`set_export_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeExportTasks::set_export_task_ids): <p>The export task IDs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeExportTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeExportTasks::set_filters): <p>the filters for the export tasks.</p>
    /// - On success, responds with [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput) with field(s):
    ///   - [`export_tasks(Option<Vec<ExportTask>>)`](crate::output::DescribeExportTasksOutput::export_tasks): <p>Information about the export tasks.</p>
    /// - On failure, responds with [`SdkError<DescribeExportTasksError>`](crate::error::DescribeExportTasksError)
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks<C, M, R> {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFastLaunchImages`](crate::client::fluent_builders::DescribeFastLaunchImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFastLaunchImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_ids(Vec<String>)`](crate::client::fluent_builders::DescribeFastLaunchImages::image_ids) / [`set_image_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFastLaunchImages::set_image_ids): <p>Details for one or more Windows AMI image IDs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeFastLaunchImages::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFastLaunchImages::set_filters): <p>Use the following filters to streamline results.</p>  <ul>   <li> <p> <code>resource-type</code> - The resource type for pre-provisioning.</p> </li>   <li> <p> <code>launch-template</code> - The launch template that is associated with the pre-provisioned Windows AMI.</p> </li>   <li> <p> <code>owner-id</code> - The owner ID for the pre-provisioning resource.</p> </li>   <li> <p> <code>state</code> - The current state of fast launching for the Windows AMI.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFastLaunchImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFastLaunchImages::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned NextToken value. If this parameter is not specified, then all results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFastLaunchImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFastLaunchImages::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFastLaunchImages::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFastLaunchImages::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeFastLaunchImagesOutput`](crate::output::DescribeFastLaunchImagesOutput) with field(s):
    ///   - [`fast_launch_images(Option<Vec<DescribeFastLaunchImagesSuccessItem>>)`](crate::output::DescribeFastLaunchImagesOutput::fast_launch_images): <p>A collection of details about the fast-launch enabled Windows images that meet the requested criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFastLaunchImagesOutput::next_token): <p>The token to use for the next set of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeFastLaunchImagesError>`](crate::error::DescribeFastLaunchImagesError)
    pub fn describe_fast_launch_images(
        &self,
    ) -> fluent_builders::DescribeFastLaunchImages<C, M, R> {
        fluent_builders::DescribeFastLaunchImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFastSnapshotRestores`](crate::client::fluent_builders::DescribeFastSnapshotRestores) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFastSnapshotRestores::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::set_filters): <p>The filters. The possible values are:</p>  <ul>   <li> <p> <code>availability-zone</code>: The Availability Zone of the snapshot.</p> </li>   <li> <p> <code>owner-id</code>: The ID of the Amazon Web Services account that enabled fast snapshot restore on the snapshot.</p> </li>   <li> <p> <code>snapshot-id</code>: The ID of the snapshot.</p> </li>   <li> <p> <code>state</code>: The state of fast snapshot restores for the snapshot (<code>enabling</code> | <code>optimizing</code> | <code>enabled</code> | <code>disabling</code> | <code>disabled</code>).</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFastSnapshotRestores::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeFastSnapshotRestoresOutput`](crate::output::DescribeFastSnapshotRestoresOutput) with field(s):
    ///   - [`fast_snapshot_restores(Option<Vec<DescribeFastSnapshotRestoreSuccessItem>>)`](crate::output::DescribeFastSnapshotRestoresOutput::fast_snapshot_restores): <p>Information about the state of fast snapshot restores.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFastSnapshotRestoresOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeFastSnapshotRestoresError>`](crate::error::DescribeFastSnapshotRestoresError)
    pub fn describe_fast_snapshot_restores(
        &self,
    ) -> fluent_builders::DescribeFastSnapshotRestores<C, M, R> {
        fluent_builders::DescribeFastSnapshotRestores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleetHistory`](crate::client::fluent_builders::DescribeFleetHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFleetHistory::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFleetHistory::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`event_type(FleetEventType)`](crate::client::fluent_builders::DescribeFleetHistory::event_type) / [`set_event_type(Option<FleetEventType>)`](crate::client::fluent_builders::DescribeFleetHistory::set_event_type): <p>The type of events to describe. By default, all events are described.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFleetHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFleetHistory::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFleetHistory::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`fleet_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetHistory::fleet_id) / [`set_fleet_id(Option<String>)`](crate::client::fluent_builders::DescribeFleetHistory::set_fleet_id): <p>The ID of the EC2 Fleet.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeFleetHistory::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeFleetHistory::set_start_time): <p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// - On success, responds with [`DescribeFleetHistoryOutput`](crate::output::DescribeFleetHistoryOutput) with field(s):
    ///   - [`history_records(Option<Vec<HistoryRecordEntry>>)`](crate::output::DescribeFleetHistoryOutput::history_records): <p>Information about the events in the history of the EC2 Fleet.</p>
    ///   - [`last_evaluated_time(Option<DateTime>)`](crate::output::DescribeFleetHistoryOutput::last_evaluated_time): <p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p>  <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFleetHistoryOutput::next_token): <p>The token for the next set of results.</p>
    ///   - [`fleet_id(Option<String>)`](crate::output::DescribeFleetHistoryOutput::fleet_id): <p>The ID of the EC Fleet.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeFleetHistoryOutput::start_time): <p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// - On failure, responds with [`SdkError<DescribeFleetHistoryError>`](crate::error::DescribeFleetHistoryError)
    pub fn describe_fleet_history(&self) -> fluent_builders::DescribeFleetHistory<C, M, R> {
        fluent_builders::DescribeFleetHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleetInstances`](crate::client::fluent_builders::DescribeFleetInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFleetInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFleetInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFleetInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFleetInstances::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFleetInstances::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`fleet_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFleetInstances::fleet_id) / [`set_fleet_id(Option<String>)`](crate::client::fluent_builders::DescribeFleetInstances::set_fleet_id): <p>The ID of the EC2 Fleet.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeFleetInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFleetInstances::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>instance-type</code> - The instance type.</p> </li>  </ul>
    /// - On success, responds with [`DescribeFleetInstancesOutput`](crate::output::DescribeFleetInstancesOutput) with field(s):
    ///   - [`active_instances(Option<Vec<ActiveInstance>>)`](crate::output::DescribeFleetInstancesOutput::active_instances): <p>The running instances. This list is refreshed periodically and might be out of date.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFleetInstancesOutput::next_token): <p>The token for the next set of results.</p>
    ///   - [`fleet_id(Option<String>)`](crate::output::DescribeFleetInstancesOutput::fleet_id): <p>The ID of the EC2 Fleet.</p>
    /// - On failure, responds with [`SdkError<DescribeFleetInstancesError>`](crate::error::DescribeFleetInstancesError)
    pub fn describe_fleet_instances(&self) -> fluent_builders::DescribeFleetInstances<C, M, R> {
        fluent_builders::DescribeFleetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleets`](crate::client::fluent_builders::DescribeFleets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFleets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFleets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFleets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFleets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFleets::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFleets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFleets::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`fleet_ids(Vec<String>)`](crate::client::fluent_builders::DescribeFleets::fleet_ids) / [`set_fleet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFleets::set_fleet_ids): <p>The ID of the EC2 Fleets.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeFleets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFleets::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> | <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).</p> </li>   <li> <p> <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> | <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> | <code>modifying</code>).</p> </li>   <li> <p> <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).</p> </li>  </ul>
    /// - On success, responds with [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFleetsOutput::next_token): <p>The token for the next set of results.</p>
    ///   - [`fleets(Option<Vec<FleetData>>)`](crate::output::DescribeFleetsOutput::fleets): <p>Information about the EC2 Fleets.</p>
    /// - On failure, responds with [`SdkError<DescribeFleetsError>`](crate::error::DescribeFleetsError)
    pub fn describe_fleets(&self) -> fluent_builders::DescribeFleets<C, M, R> {
        fluent_builders::DescribeFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFlowLogs`](crate::client::fluent_builders::DescribeFlowLogs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFlowLogs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFlowLogs::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFlowLogs::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filter(Vec<Filter>)`](crate::client::fluent_builders::DescribeFlowLogs::filter) / [`set_filter(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFlowLogs::set_filter): <p>One or more filters.</p>  <ul>   <li> <p> <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p> </li>   <li> <p> <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible destination types include <code>cloud-watch-logs</code> and <code>s3</code>.</p> </li>   <li> <p> <code>flow-log-id</code> - The ID of the flow log.</p> </li>   <li> <p> <code>log-group-name</code> - The name of the log group.</p> </li>   <li> <p> <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p> </li>   <li> <p> <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`flow_log_ids(Vec<String>)`](crate::client::fluent_builders::DescribeFlowLogs::flow_log_ids) / [`set_flow_log_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFlowLogs::set_flow_log_ids): <p>One or more flow log IDs.</p>  <p>Constraint: Maximum of 1000 flow log IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFlowLogs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFlowLogs::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFlowLogs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFlowLogs::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeFlowLogsOutput`](crate::output::DescribeFlowLogsOutput) with field(s):
    ///   - [`flow_logs(Option<Vec<FlowLog>>)`](crate::output::DescribeFlowLogsOutput::flow_logs): <p>Information about the flow logs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFlowLogsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeFlowLogsError>`](crate::error::DescribeFlowLogsError)
    pub fn describe_flow_logs(&self) -> fluent_builders::DescribeFlowLogs<C, M, R> {
        fluent_builders::DescribeFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFpgaImageAttribute`](crate::client::fluent_builders::DescribeFpgaImageAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`fpga_image_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::fpga_image_id) / [`set_fpga_image_id(Option<String>)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::set_fpga_image_id): <p>The ID of the AFI.</p>
    ///   - [`attribute(FpgaImageAttributeName)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::attribute) / [`set_attribute(Option<FpgaImageAttributeName>)`](crate::client::fluent_builders::DescribeFpgaImageAttribute::set_attribute): <p>The AFI attribute.</p>
    /// - On success, responds with [`DescribeFpgaImageAttributeOutput`](crate::output::DescribeFpgaImageAttributeOutput) with field(s):
    ///   - [`fpga_image_attribute(Option<FpgaImageAttribute>)`](crate::output::DescribeFpgaImageAttributeOutput::fpga_image_attribute): <p>Information about the attribute.</p>
    /// - On failure, responds with [`SdkError<DescribeFpgaImageAttributeError>`](crate::error::DescribeFpgaImageAttributeError)
    pub fn describe_fpga_image_attribute(
        &self,
    ) -> fluent_builders::DescribeFpgaImageAttribute<C, M, R> {
        fluent_builders::DescribeFpgaImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFpgaImages`](crate::client::fluent_builders::DescribeFpgaImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFpgaImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeFpgaImages::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeFpgaImages::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`fpga_image_ids(Vec<String>)`](crate::client::fluent_builders::DescribeFpgaImages::fpga_image_ids) / [`set_fpga_image_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFpgaImages::set_fpga_image_ids): <p>The AFI IDs.</p>
    ///   - [`owners(Vec<String>)`](crate::client::fluent_builders::DescribeFpgaImages::owners) / [`set_owners(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFpgaImages::set_owners): <p>Filters the AFI by owner. Specify an Amazon Web Services account ID, <code>self</code> (owner is the sender of the request), or an Amazon Web Services owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeFpgaImages::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeFpgaImages::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>create-time</code> - The creation time of the AFI.</p> </li>   <li> <p> <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).</p> </li>   <li> <p> <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).</p> </li>   <li> <p> <code>name</code> - The name of the AFI.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the AFI owner.</p> </li>   <li> <p> <code>product-code</code> - The product code.</p> </li>   <li> <p> <code>shell-version</code> - The version of the Amazon Web Services Shell that was used to create the bitstream.</p> </li>   <li> <p> <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>unavailable</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>update-time</code> - The time of the most recent update.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFpgaImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFpgaImages::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeFpgaImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeFpgaImages::set_max_results): <p>The maximum number of results to return in a single call.</p>
    /// - On success, responds with [`DescribeFpgaImagesOutput`](crate::output::DescribeFpgaImagesOutput) with field(s):
    ///   - [`fpga_images(Option<Vec<FpgaImage>>)`](crate::output::DescribeFpgaImagesOutput::fpga_images): <p>Information about the FPGA images.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFpgaImagesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeFpgaImagesError>`](crate::error::DescribeFpgaImagesError)
    pub fn describe_fpga_images(&self) -> fluent_builders::DescribeFpgaImages<C, M, R> {
        fluent_builders::DescribeFpgaImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHostReservationOfferings`](crate::client::fluent_builders::DescribeHostReservationOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeHostReservationOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(Vec<Filter>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::filter) / [`set_filter(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_filter): <p>The filters.</p>  <ul>   <li> <p> <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).</p> </li>   <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li>  </ul>
    ///   - [`max_duration(i32)`](crate::client::fluent_builders::DescribeHostReservationOfferings::max_duration) / [`set_max_duration(Option<i32>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_max_duration): <p>This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeHostReservationOfferings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    ///   - [`min_duration(i32)`](crate::client::fluent_builders::DescribeHostReservationOfferings::min_duration) / [`set_min_duration(Option<i32>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_min_duration): <p>This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    ///   - [`offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::offering_id) / [`set_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeHostReservationOfferings::set_offering_id): <p>The ID of the reservation offering.</p>
    /// - On success, responds with [`DescribeHostReservationOfferingsOutput`](crate::output::DescribeHostReservationOfferingsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeHostReservationOfferingsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`offering_set(Option<Vec<HostOffering>>)`](crate::output::DescribeHostReservationOfferingsOutput::offering_set): <p>Information about the offerings.</p>
    /// - On failure, responds with [`SdkError<DescribeHostReservationOfferingsError>`](crate::error::DescribeHostReservationOfferingsError)
    pub fn describe_host_reservation_offerings(
        &self,
    ) -> fluent_builders::DescribeHostReservationOfferings<C, M, R> {
        fluent_builders::DescribeHostReservationOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHostReservations`](crate::client::fluent_builders::DescribeHostReservations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeHostReservations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(Vec<Filter>)`](crate::client::fluent_builders::DescribeHostReservations::filter) / [`set_filter(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeHostReservations::set_filter): <p>The filters.</p>  <ul>   <li> <p> <code>instance-family</code> - The instance family (for example, <code>m4</code>).</p> </li>   <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li>   <li> <p> <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> | <code>active</code> | <code>retired</code>).</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`host_reservation_id_set(Vec<String>)`](crate::client::fluent_builders::DescribeHostReservations::host_reservation_id_set) / [`set_host_reservation_id_set(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHostReservations::set_host_reservation_id_set): <p>The host reservation IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeHostReservations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeHostReservations::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeHostReservations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeHostReservations::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeHostReservationsOutput`](crate::output::DescribeHostReservationsOutput) with field(s):
    ///   - [`host_reservation_set(Option<Vec<HostReservation>>)`](crate::output::DescribeHostReservationsOutput::host_reservation_set): <p>Details about the reservation's configuration.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeHostReservationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeHostReservationsError>`](crate::error::DescribeHostReservationsError)
    pub fn describe_host_reservations(&self) -> fluent_builders::DescribeHostReservations<C, M, R> {
        fluent_builders::DescribeHostReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHosts`](crate::client::fluent_builders::DescribeHosts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeHosts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(Vec<Filter>)`](crate::client::fluent_builders::DescribeHosts::filter) / [`set_filter(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeHosts::set_filter): <p>The filters.</p>  <ul>   <li> <p> <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone of the host.</p> </li>   <li> <p> <code>client-token</code> - The idempotency token that you provided when you allocated the host.</p> </li>   <li> <p> <code>host-reservation-id</code> - The ID of the reservation assigned to this host.</p> </li>   <li> <p> <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.</p> </li>   <li> <p> <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> | <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> | <code>released-permanent-failure</code>).</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`host_ids(Vec<String>)`](crate::client::fluent_builders::DescribeHosts::host_ids) / [`set_host_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHosts::set_host_ids): <p>The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeHosts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeHosts::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>  <p>You cannot specify this parameter and the host IDs parameter in the same request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeHosts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeHosts::set_next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeHostsOutput`](crate::output::DescribeHostsOutput) with field(s):
    ///   - [`hosts(Option<Vec<Host>>)`](crate::output::DescribeHostsOutput::hosts): <p>Information about the Dedicated Hosts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeHostsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeHostsError>`](crate::error::DescribeHostsError)
    pub fn describe_hosts(&self) -> fluent_builders::DescribeHosts<C, M, R> {
        fluent_builders::DescribeHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIamInstanceProfileAssociations`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::association_ids) / [`set_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::set_association_ids): <p>The IAM instance profile associations.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li>   <li> <p> <code>state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`DescribeIamInstanceProfileAssociationsOutput`](crate::output::DescribeIamInstanceProfileAssociationsOutput) with field(s):
    ///   - [`iam_instance_profile_associations(Option<Vec<IamInstanceProfileAssociation>>)`](crate::output::DescribeIamInstanceProfileAssociationsOutput::iam_instance_profile_associations): <p>Information about the IAM instance profile associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIamInstanceProfileAssociationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeIamInstanceProfileAssociationsError>`](crate::error::DescribeIamInstanceProfileAssociationsError)
    pub fn describe_iam_instance_profile_associations(
        &self,
    ) -> fluent_builders::DescribeIamInstanceProfileAssociations<C, M, R> {
        fluent_builders::DescribeIamInstanceProfileAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityIdFormat`](crate::client::fluent_builders::DescribeIdentityIdFormat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityIdFormat::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::DescribeIdentityIdFormat::set_principal_arn): <p>The ARN of the principal, which can be an IAM role, IAM user, or the root user.</p>
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityIdFormat::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::DescribeIdentityIdFormat::set_resource): <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>
    /// - On success, responds with [`DescribeIdentityIdFormatOutput`](crate::output::DescribeIdentityIdFormatOutput) with field(s):
    ///   - [`statuses(Option<Vec<IdFormat>>)`](crate::output::DescribeIdentityIdFormatOutput::statuses): <p>Information about the ID format for the resources.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityIdFormatError>`](crate::error::DescribeIdentityIdFormatError)
    pub fn describe_identity_id_format(
        &self,
    ) -> fluent_builders::DescribeIdentityIdFormat<C, M, R> {
        fluent_builders::DescribeIdentityIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdFormat`](crate::client::fluent_builders::DescribeIdFormat) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::DescribeIdFormat::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::DescribeIdFormat::set_resource): <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>
    /// - On success, responds with [`DescribeIdFormatOutput`](crate::output::DescribeIdFormatOutput) with field(s):
    ///   - [`statuses(Option<Vec<IdFormat>>)`](crate::output::DescribeIdFormatOutput::statuses): <p>Information about the ID format for the resource.</p>
    /// - On failure, responds with [`SdkError<DescribeIdFormatError>`](crate::error::DescribeIdFormatError)
    pub fn describe_id_format(&self) -> fluent_builders::DescribeIdFormat<C, M, R> {
        fluent_builders::DescribeIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImageAttribute`](crate::client::fluent_builders::DescribeImageAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(ImageAttributeName)`](crate::client::fluent_builders::DescribeImageAttribute::attribute) / [`set_attribute(Option<ImageAttributeName>)`](crate::client::fluent_builders::DescribeImageAttribute::set_attribute): <p>The AMI attribute.</p>  <p> <b>Note</b>: The <code>blockDeviceMapping</code> attribute is deprecated. Using this attribute returns the <code>Client.AuthFailure</code> error. To get information about the block device mappings for an AMI, use the <code>DescribeImages</code> action.</p>
    ///   - [`image_id(impl Into<String>)`](crate::client::fluent_builders::DescribeImageAttribute::image_id) / [`set_image_id(Option<String>)`](crate::client::fluent_builders::DescribeImageAttribute::set_image_id): <p>The ID of the AMI.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeImageAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeImageAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeImageAttributeOutput`](crate::output::DescribeImageAttributeOutput) with field(s):
    ///   - [`block_device_mappings(Option<Vec<BlockDeviceMapping>>)`](crate::output::DescribeImageAttributeOutput::block_device_mappings): <p>The block device mapping entries.</p>
    ///   - [`image_id(Option<String>)`](crate::output::DescribeImageAttributeOutput::image_id): <p>The ID of the AMI.</p>
    ///   - [`launch_permissions(Option<Vec<LaunchPermission>>)`](crate::output::DescribeImageAttributeOutput::launch_permissions): <p>The launch permissions.</p>
    ///   - [`product_codes(Option<Vec<ProductCode>>)`](crate::output::DescribeImageAttributeOutput::product_codes): <p>The product codes.</p>
    ///   - [`description(Option<AttributeValue>)`](crate::output::DescribeImageAttributeOutput::description): <p>A description for the AMI.</p>
    ///   - [`kernel_id(Option<AttributeValue>)`](crate::output::DescribeImageAttributeOutput::kernel_id): <p>The kernel ID.</p>
    ///   - [`ramdisk_id(Option<AttributeValue>)`](crate::output::DescribeImageAttributeOutput::ramdisk_id): <p>The RAM disk ID.</p>
    ///   - [`sriov_net_support(Option<AttributeValue>)`](crate::output::DescribeImageAttributeOutput::sriov_net_support): <p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
    ///   - [`boot_mode(Option<AttributeValue>)`](crate::output::DescribeImageAttributeOutput::boot_mode): <p>Describes a value for a resource attribute that is a String.</p>
    /// - On failure, responds with [`SdkError<DescribeImageAttributeError>`](crate::error::DescribeImageAttributeError)
    pub fn describe_image_attribute(&self) -> fluent_builders::DescribeImageAttribute<C, M, R> {
        fluent_builders::DescribeImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImages`](crate::client::fluent_builders::DescribeImages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`executable_users(Vec<String>)`](crate::client::fluent_builders::DescribeImages::executable_users) / [`set_executable_users(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImages::set_executable_users): <p>Scopes the images by users with explicit launch permissions. Specify an Amazon Web Services account ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>  <ul>   <li> <p>If you specify an Amazon Web Services account ID that is not your own, only AMIs shared with that specific Amazon Web Services account ID are returned. However, AMIs that are shared with the account’s organization or organizational unit (OU) are not returned.</p> </li>   <li> <p>If you specify <code>self</code> or your own Amazon Web Services account ID, AMIs shared with your account are returned. In addition, AMIs that are shared with the organization or OU of which you are member are also returned. </p> </li>   <li> <p>If you specify <code>all</code>, all public AMIs are returned.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeImages::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeImages::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li>   <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li>   <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li>   <li> <p> <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the Amazon EBS volume.</p> </li>   <li> <p> <code>block-device-mapping.volume-size</code> - The volume size of the Amazon EBS volume, in GiB.</p> </li>   <li> <p> <code>block-device-mapping.volume-type</code> - The volume type of the Amazon EBS volume (<code>io1</code> | <code>io2</code> | <code>gp2</code> | <code>gp3</code> | <code>sc1 </code>| <code>st1</code> | <code>standard</code>).</p> </li>   <li> <p> <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the Amazon EBS volume is encrypted.</p> </li>   <li> <p> <code>description</code> - The description of the image (provided during image creation).</p> </li>   <li> <p> <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.</p> </li>   <li> <p> <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).</p> </li>   <li> <p> <code>image-id</code> - The ID of the image.</p> </li>   <li> <p> <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).</p> </li>   <li> <p> <code>is-public</code> - A Boolean that indicates whether the image is public.</p> </li>   <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li>   <li> <p> <code>manifest-location</code> - The location of the image manifest.</p> </li>   <li> <p> <code>name</code> - The name of the AMI (provided during image creation).</p> </li>   <li> <p> <code>owner-alias</code> - The owner alias (<code>amazon</code> | <code>aws-marketplace</code>). The valid aliases are defined in an Amazon-maintained list. This is not the Amazon Web Services account alias that can be set using the IAM console. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the <b>Owner</b> request parameter instead of this filter.</p> </li>   <li> <p> <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.</p> </li>   <li> <p> <code>product-code</code> - The product code.</p> </li>   <li> <p> <code>product-code.type</code> - The type of the product code (<code>marketplace</code>).</p> </li>   <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li>   <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li>   <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li>   <li> <p> <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>).</p> </li>   <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li>   <li> <p> <code>state-reason-message</code> - The message for the state change.</p> </li>   <li> <p> <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the Intel 82599 VF interface is enabled.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).</p> </li>  </ul>
    ///   - [`image_ids(Vec<String>)`](crate::client::fluent_builders::DescribeImages::image_ids) / [`set_image_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImages::set_image_ids): <p>The image IDs.</p>  <p>Default: Describes all images available to you.</p>
    ///   - [`owners(Vec<String>)`](crate::client::fluent_builders::DescribeImages::owners) / [`set_owners(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImages::set_owners): <p>Scopes the results to images with the specified owners. You can specify a combination of Amazon Web Services account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this parameter, the results include all images for which you have launch permissions, regardless of ownership.</p>
    ///   - [`include_deprecated(bool)`](crate::client::fluent_builders::DescribeImages::include_deprecated) / [`set_include_deprecated(Option<bool>)`](crate::client::fluent_builders::DescribeImages::set_include_deprecated): <p>If <code>true</code>, all deprecated AMIs are included in the response. If <code>false</code>, no deprecated AMIs are included in the response. If no value is specified, the default value is <code>false</code>.</p> <note>   <p>If you are the AMI owner, all deprecated AMIs appear in the response regardless of the value (<code>true</code> or <code>false</code>) that you set for this parameter.</p>  </note>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeImages::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeImages::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeImagesOutput`](crate::output::DescribeImagesOutput) with field(s):
    ///   - [`images(Option<Vec<Image>>)`](crate::output::DescribeImagesOutput::images): <p>Information about the images.</p>
    /// - On failure, responds with [`SdkError<DescribeImagesError>`](crate::error::DescribeImagesError)
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImportImageTasks`](crate::client::fluent_builders::DescribeImportImageTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImportImageTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeImportImageTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeImportImageTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeImportImageTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeImportImageTasks::set_filters): <p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>
    ///   - [`import_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeImportImageTasks::import_task_ids) / [`set_import_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImportImageTasks::set_import_task_ids): <p>The IDs of the import image tasks.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImportImageTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImportImageTasks::set_max_results): <p>The maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImportImageTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImportImageTasks::set_next_token): <p>A token that indicates the next page of results.</p>
    /// - On success, responds with [`DescribeImportImageTasksOutput`](crate::output::DescribeImportImageTasksOutput) with field(s):
    ///   - [`import_image_tasks(Option<Vec<ImportImageTask>>)`](crate::output::DescribeImportImageTasksOutput::import_image_tasks): <p>A list of zero or more import image tasks that are currently active or were completed or canceled in the previous 7 days.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImportImageTasksOutput::next_token): <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeImportImageTasksError>`](crate::error::DescribeImportImageTasksError)
    pub fn describe_import_image_tasks(
        &self,
    ) -> fluent_builders::DescribeImportImageTasks<C, M, R> {
        fluent_builders::DescribeImportImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImportSnapshotTasks`](crate::client::fluent_builders::DescribeImportSnapshotTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImportSnapshotTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::set_filters): <p>The filters.</p>
    ///   - [`import_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::import_task_ids) / [`set_import_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::set_import_task_ids): <p>A list of import snapshot task IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImportSnapshotTasks::set_next_token): <p>A token that indicates the next page of results.</p>
    /// - On success, responds with [`DescribeImportSnapshotTasksOutput`](crate::output::DescribeImportSnapshotTasksOutput) with field(s):
    ///   - [`import_snapshot_tasks(Option<Vec<ImportSnapshotTask>>)`](crate::output::DescribeImportSnapshotTasksOutput::import_snapshot_tasks): <p>A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the previous 7 days.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImportSnapshotTasksOutput::next_token): <p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeImportSnapshotTasksError>`](crate::error::DescribeImportSnapshotTasksError)
    pub fn describe_import_snapshot_tasks(
        &self,
    ) -> fluent_builders::DescribeImportSnapshotTasks<C, M, R> {
        fluent_builders::DescribeImportSnapshotTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceAttribute`](crate::client::fluent_builders::DescribeInstanceAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(InstanceAttributeName)`](crate::client::fluent_builders::DescribeInstanceAttribute::attribute) / [`set_attribute(Option<InstanceAttributeName>)`](crate::client::fluent_builders::DescribeInstanceAttribute::set_attribute): <p>The instance attribute.</p>  <p>Note: The <code>enaSupport</code> attribute is not supported at this time.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceAttribute::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstanceAttribute::set_instance_id): <p>The ID of the instance.</p>
    /// - On success, responds with [`DescribeInstanceAttributeOutput`](crate::output::DescribeInstanceAttributeOutput) with field(s):
    ///   - [`groups(Option<Vec<GroupIdentifier>>)`](crate::output::DescribeInstanceAttributeOutput::groups): <p>The security groups associated with the instance.</p>
    ///   - [`block_device_mappings(Option<Vec<InstanceBlockDeviceMapping>>)`](crate::output::DescribeInstanceAttributeOutput::block_device_mappings): <p>The block device mapping of the instance.</p>
    ///   - [`disable_api_termination(Option<AttributeBooleanValue>)`](crate::output::DescribeInstanceAttributeOutput::disable_api_termination): <p>If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or API; otherwise, you can.</p>
    ///   - [`ena_support(Option<AttributeBooleanValue>)`](crate::output::DescribeInstanceAttributeOutput::ena_support): <p>Indicates whether enhanced networking with ENA is enabled.</p>
    ///   - [`enclave_options(Option<EnclaveOptions>)`](crate::output::DescribeInstanceAttributeOutput::enclave_options): <p>To enable the instance for Amazon Web Services Nitro Enclaves, set this parameter to <code>true</code>; otherwise, set it to <code>false</code>.</p>
    ///   - [`ebs_optimized(Option<AttributeBooleanValue>)`](crate::output::DescribeInstanceAttributeOutput::ebs_optimized): <p>Indicates whether the instance is optimized for Amazon EBS I/O.</p>
    ///   - [`instance_id(Option<String>)`](crate::output::DescribeInstanceAttributeOutput::instance_id): <p>The ID of the instance.</p>
    ///   - [`instance_initiated_shutdown_behavior(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::instance_initiated_shutdown_behavior): <p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>
    ///   - [`instance_type(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::instance_type): <p>The instance type.</p>
    ///   - [`kernel_id(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::kernel_id): <p>The kernel ID.</p>
    ///   - [`product_codes(Option<Vec<ProductCode>>)`](crate::output::DescribeInstanceAttributeOutput::product_codes): <p>A list of product codes.</p>
    ///   - [`ramdisk_id(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::ramdisk_id): <p>The RAM disk ID.</p>
    ///   - [`root_device_name(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::root_device_name): <p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>
    ///   - [`source_dest_check(Option<AttributeBooleanValue>)`](crate::output::DescribeInstanceAttributeOutput::source_dest_check): <p>Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is <code>true</code>, source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code>. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.</p>
    ///   - [`sriov_net_support(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::sriov_net_support): <p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>
    ///   - [`user_data(Option<AttributeValue>)`](crate::output::DescribeInstanceAttributeOutput::user_data): <p>The user data.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceAttributeError>`](crate::error::DescribeInstanceAttributeError)
    pub fn describe_instance_attribute(
        &self,
    ) -> fluent_builders::DescribeInstanceAttribute<C, M, R> {
        fluent_builders::DescribeInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceCreditSpecifications`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li>  </ul>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::set_instance_ids): <p>The instance IDs.</p>  <p>Default: Describes all your instances.</p>  <p>Constraints: Maximum 1000 explicitly specified instance IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::set_next_token): <p>The token to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeInstanceCreditSpecificationsOutput`](crate::output::DescribeInstanceCreditSpecificationsOutput) with field(s):
    ///   - [`instance_credit_specifications(Option<Vec<InstanceCreditSpecification>>)`](crate::output::DescribeInstanceCreditSpecificationsOutput::instance_credit_specifications): <p>Information about the credit option for CPU usage of an instance.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceCreditSpecificationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceCreditSpecificationsError>`](crate::error::DescribeInstanceCreditSpecificationsError)
    pub fn describe_instance_credit_specifications(
        &self,
    ) -> fluent_builders::DescribeInstanceCreditSpecifications<C, M, R> {
        fluent_builders::DescribeInstanceCreditSpecifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceEventNotificationAttributes`](crate::client::fluent_builders::DescribeInstanceEventNotificationAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceEventNotificationAttributes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceEventNotificationAttributes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeInstanceEventNotificationAttributesOutput`](crate::output::DescribeInstanceEventNotificationAttributesOutput) with field(s):
    ///   - [`instance_tag_attribute(Option<InstanceTagNotificationAttribute>)`](crate::output::DescribeInstanceEventNotificationAttributesOutput::instance_tag_attribute): <p>Information about the registered tag keys.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceEventNotificationAttributesError>`](crate::error::DescribeInstanceEventNotificationAttributesError)
    pub fn describe_instance_event_notification_attributes(
        &self,
    ) -> fluent_builders::DescribeInstanceEventNotificationAttributes<C, M, R> {
        fluent_builders::DescribeInstanceEventNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceEventWindows`](crate::client::fluent_builders::DescribeInstanceEventWindows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceEventWindows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceEventWindows::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_event_window_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::instance_event_window_ids) / [`set_instance_event_window_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::set_instance_event_window_ids): <p>The IDs of the event windows.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>dedicated-host-id</code> - The event windows associated with the specified Dedicated Host ID.</p> </li>   <li> <p> <code>event-window-name</code> - The event windows associated with the specified names. </p> </li>   <li> <p> <code>instance-id</code> - The event windows associated with the specified instance ID.</p> </li>   <li> <p> <code>instance-tag</code> - The event windows associated with the specified tag and value.</p> </li>   <li> <p> <code>instance-tag-key</code> - The event windows associated with the specified tag key, regardless of the value.</p> </li>   <li> <p> <code>instance-tag-value</code> - The event windows associated with the specified tag value, regardless of the key.</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the event window. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>CMX</code>, specify <code>tag:Owner</code> for the filter name and <code>CMX</code> for the filter value. </p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific key, regardless of the tag value. </p> </li>   <li> <p> <code>tag-value</code> - The value of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific value, regardless of the tag key. </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceEventWindows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 20 and 500. You cannot specify this parameter and the event window IDs parameter in the same call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceEventWindows::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`DescribeInstanceEventWindowsOutput`](crate::output::DescribeInstanceEventWindowsOutput) with field(s):
    ///   - [`instance_event_windows(Option<Vec<InstanceEventWindow>>)`](crate::output::DescribeInstanceEventWindowsOutput::instance_event_windows): <p>Information about the event windows.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceEventWindowsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeInstanceEventWindowsError>`](crate::error::DescribeInstanceEventWindowsError)
    pub fn describe_instance_event_windows(
        &self,
    ) -> fluent_builders::DescribeInstanceEventWindows<C, M, R> {
        fluent_builders::DescribeInstanceEventWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstances`](crate::client::fluent_builders::DescribeInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstances::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> | <code>host</code>).</p> </li>   <li> <p> <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li>   <li> <p> <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for example, <code>2010-09-15T17:15:20.000Z</code>.</p> </li>   <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is deleted on instance termination.</p> </li>   <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li>   <li> <p> <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li>   <li> <p> <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.</p> </li>   <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance.</p> </li>   <li> <p> <code>dns-name</code> - The public DNS name of the instance.</p> </li>   <li> <p> <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.</p> </li>   <li> <p> <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.</p> </li>   <li> <p> <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation. </p> </li>   <li> <p> <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.</p> </li>   <li> <p> <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p> </li>   <li> <p> <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.</p> </li>   <li> <p> <code>image-id</code> - The ID of the image used to launch the instance.</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li>   <li> <p> <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (<code>spot</code> | <code>scheduled</code>).</p> </li>   <li> <p> <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li>   <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li>   <li> <p> <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).</p> </li>   <li> <p> <code>instance.group-id</code> - The ID of the security group for the instance. </p> </li>   <li> <p> <code>instance.group-name</code> - The name of the security group for the instance. </p> </li>   <li> <p> <code>ip-address</code> - The public IPv4 address of the instance.</p> </li>   <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li>   <li> <p> <code>key-name</code> - The name of the key pair used when the instance was launched.</p> </li>   <li> <p> <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch group (for example, 0, 1, 2, and so on). </p> </li>   <li> <p> <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.</p> </li>   <li> <p> <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> | <code>required</code>)</p> </li>   <li> <p> <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit (integer, possible values <code>1</code> to <code>64</code>)</p> </li>   <li> <p> <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (<code>enabled</code> | <code>disabled</code>)</p> </li>   <li> <p> <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li>   <li> <p> <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the network interface.</p> </li>   <li> <p> <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is the primary private IPv4 address.</p> </li>   <li> <p> <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP address (IPv4) with a network interface.</p> </li>   <li> <p> <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address associated with the network interface.</p> </li>   <li> <p> <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li>   <li> <p> <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li>   <li> <p> <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li>   <li> <p> <code>network-interface.association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li>   <li> <p> <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.</p> </li>   <li> <p> <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li>   <li> <p> <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li>   <li> <p> <code>network-interface.attachment.device-index</code> - The device index to which the network interface is attached.</p> </li>   <li> <p> <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li>   <li> <p> <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li>   <li> <p> <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted when an instance is terminated.</p> </li>   <li> <p> <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.</p> </li>   <li> <p> <code>network-interface.description</code> - The description of the network interface.</p> </li>   <li> <p> <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.</p> </li>   <li> <p> <code>network-interface.group-name</code> - The name of a security group associated with the network interface.</p> </li>   <li> <p> <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network interface.</p> </li>   <li> <p> <code>network-interface.mac-address</code> - The MAC address of the network interface.</p> </li>   <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li>   <li> <p> <code>network-interface.owner-id</code> - The ID of the owner of the network interface.</p> </li>   <li> <p> <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.</p> </li>   <li> <p> <code>network-interface.requester-id</code> - The requester ID for the network interface.</p> </li>   <li> <p> <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by Amazon Web Services.</p> </li>   <li> <p> <code>network-interface.status</code> - The status of the network interface (<code>available</code>) | <code>in-use</code>).</p> </li>   <li> <p> <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC.</p> </li>   <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.</p> </li>   <li> <p> <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.</p> </li>   <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.</p> </li>   <li> <p> <code>placement-group-name</code> - The name of the placement group for the instance.</p> </li>   <li> <p> <code>placement-partition-number</code> - The partition in which the instance is located.</p> </li>   <li> <p> <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.</p> </li>   <li> <p> <code>private-dns-name</code> - The private IPv4 DNS name of the instance.</p> </li>   <li> <p> <code>private-ip-address</code> - The private IPv4 address of the instance.</p> </li>   <li> <p> <code>product-code</code> - The product code associated with the AMI used to launch the instance.</p> </li>   <li> <p> <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).</p> </li>   <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li>   <li> <p> <code>reason</code> - The reason for the current state of the instance (for example, shows "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.</p> </li>   <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, Amazon Web Services Management Console, Auto Scaling, and so on).</p> </li>   <li> <p> <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be associated with more than one instance if you launch multiple instances using the same launch request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same launch request, you also get one reservation ID.</p> </li>   <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li>   <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li>   <li> <p> <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC. </p> </li>   <li> <p> <code>spot-instance-request-id</code> - The ID of the Spot Instance request.</p> </li>   <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li>   <li> <p> <code>state-reason-message</code> - A message that describes the state change.</p> </li>   <li> <p> <code>subnet-id</code> - The ID of the subnet for the instance.</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> | <code>host</code>).</p> </li>   <li> <p> <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> | <code>hvm</code>).</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is running in.</p> </li>  </ul>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInstances::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInstances::set_instance_ids): <p>The instance IDs.</p>  <p>Default: Describes all your instances.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstances::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstances::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`DescribeInstancesOutput`](crate::output::DescribeInstancesOutput) with field(s):
    ///   - [`reservations(Option<Vec<Reservation>>)`](crate::output::DescribeInstancesOutput::reservations): <p>Information about the reservations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstancesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInstancesError>`](crate::error::DescribeInstancesError)
    pub fn describe_instances(&self) -> fluent_builders::DescribeInstances<C, M, R> {
        fluent_builders::DescribeInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceStatus`](crate::client::fluent_builders::DescribeInstanceStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstanceStatus::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li>   <li> <p> <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> | <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> | <code>instance-stop</code>).</p> </li>   <li> <p> <code>event.description</code> - A description of the event.</p> </li>   <li> <p> <code>event.instance-event-id</code> - The ID of the event whose date and time you are modifying.</p> </li>   <li> <p> <code>event.not-after</code> - The latest end time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li>   <li> <p> <code>event.not-before</code> - The earliest start time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li>   <li> <p> <code>event.not-before-deadline</code> - The deadline for starting the event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li>   <li> <p> <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li>   <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li>   <li> <p> <code>instance-status.reachability</code> - Filters on instance status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li>   <li> <p> <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li>   <li> <p> <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li>   <li> <p> <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li>  </ul>
    ///   - [`instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInstanceStatus::instance_ids) / [`set_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_instance_ids): <p>The instance IDs.</p>  <p>Default: Describes all your instances.</p>  <p>Constraints: Maximum 100 explicitly specified instance IDs.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceStatus::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`include_all_instances(bool)`](crate::client::fluent_builders::DescribeInstanceStatus::include_all_instances) / [`set_include_all_instances(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceStatus::set_include_all_instances): <p>When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the health status for running instances only.</p>  <p>Default: <code>false</code> </p>
    /// - On success, responds with [`DescribeInstanceStatusOutput`](crate::output::DescribeInstanceStatusOutput) with field(s):
    ///   - [`instance_statuses(Option<Vec<InstanceStatus>>)`](crate::output::DescribeInstanceStatusOutput::instance_statuses): <p>Information about the status of the instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceStatusOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceStatusError>`](crate::error::DescribeInstanceStatusError)
    pub fn describe_instance_status(&self) -> fluent_builders::DescribeInstanceStatus<C, M, R> {
        fluent_builders::DescribeInstanceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceTypeOfferings`](crate::client::fluent_builders::DescribeInstanceTypeOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`location_type(LocationType)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::location_type) / [`set_location_type(Option<LocationType>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::set_location_type): <p>The location type.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>location</code> - This depends on the location type. For example, if the location type is <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)</p> </li>   <li> <p> <code>instance-type</code> - The instance type. For example, <code>c5.2xlarge</code>.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::set_next_token): <p>The token to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeInstanceTypeOfferingsOutput`](crate::output::DescribeInstanceTypeOfferingsOutput) with field(s):
    ///   - [`instance_type_offerings(Option<Vec<InstanceTypeOffering>>)`](crate::output::DescribeInstanceTypeOfferingsOutput::instance_type_offerings): <p>The instance types offered.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceTypeOfferingsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceTypeOfferingsError>`](crate::error::DescribeInstanceTypeOfferingsError)
    pub fn describe_instance_type_offerings(
        &self,
    ) -> fluent_builders::DescribeInstanceTypeOfferings<C, M, R> {
        fluent_builders::DescribeInstanceTypeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceTypes`](crate::client::fluent_builders::DescribeInstanceTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInstanceTypes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInstanceTypes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_types(Vec<InstanceType>)`](crate::client::fluent_builders::DescribeInstanceTypes::instance_types) / [`set_instance_types(Option<Vec<InstanceType>>)`](crate::client::fluent_builders::DescribeInstanceTypes::set_instance_types): <p>The instance types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInstanceTypes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInstanceTypes::set_filters): <p>One or more filters. Filter names and values are case-sensitive.</p>  <ul>   <li> <p> <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>bare-metal</code> - Indicates whether it is a bare metal instance type (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type of an instance family (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps</code> - The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.baseline-iops</code> - The baseline input/output storage operations per second for an EBS-optimized instance type.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.baseline-throughput-in-mbps</code> - The baseline throughput performance for an EBS-optimized instance type, in MB/s.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps</code> - The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.maximum-iops</code> - The maximum input/output storage operations per second for an EBS-optimized instance type.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-info.maximum-throughput-in-mbps</code> - The maximum throughput performance for an EBS-optimized instance type, in MB/s.</p> </li>   <li> <p> <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized (<code>supported</code> | <code>unsupported</code> | <code>default</code>).</p> </li>   <li> <p> <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported (<code>supported</code> | <code>unsupported</code>).</p> </li>   <li> <p> <code>ebs-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for EBS volumes (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li>   <li> <p> <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>hypervisor</code> - The hypervisor (<code>nitro</code> | <code>xen</code>).</p> </li>   <li> <p> <code>instance-storage-info.disk.count</code> - The number of local disks.</p> </li>   <li> <p> <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.</p> </li>   <li> <p> <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks (<code>hdd</code> | <code>ssd</code>).</p> </li>   <li> <p> <code>instance-storage-info.encryption-supported</code> - Indicates whether data is encrypted at rest (<code>required</code> | <code>unsupported</code>).</p> </li>   <li> <p> <code>instance-storage-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported for instance store (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li>   <li> <p> <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local instance storage, in GB.</p> </li>   <li> <p> <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>instance-type</code> - The instance type (for example <code>c5.2xlarge</code> or c5*).</p> </li>   <li> <p> <code>memory-info.size-in-mib</code> - The memory size.</p> </li>   <li> <p> <code>network-info.efa-info.maximum-efa-interfaces</code> - The maximum number of Elastic Fabric Adapters (EFAs) per instance.</p> </li>   <li> <p> <code>network-info.efa-supported</code> - Indicates whether the instance type supports Elastic Fabric Adapter (EFA) (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or required (<code>required</code> | <code>supported</code> | <code>unsupported</code>).</p> </li>   <li> <p> <code>network-info.encryption-in-transit-supported</code> - Indicates whether the instance type automatically encrypts in-transit traffic between instances (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per network interface.</p> </li>   <li> <p> <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per network interface.</p> </li>   <li> <p> <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6 (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.</p> </li>   <li> <p> <code>network-info.network-performance</code> - The network performance (for example, "25 Gigabit").</p> </li>   <li> <p> <code>processor-info.supported-architecture</code> - The CPU architecture (<code>arm64</code> | <code>i386</code> | <code>x86_64</code>).</p> </li>   <li> <p> <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.</p> </li>   <li> <p> <code>supported-boot-mode</code> - The boot mode (<code>legacy-bios</code> | <code>uefi</code>).</p> </li>   <li> <p> <code>supported-root-device-type</code> - The root device type (<code>ebs</code> | <code>instance-store</code>).</p> </li>   <li> <p> <code>supported-usage-class</code> - The usage class (<code>on-demand</code> | <code>spot</code>).</p> </li>   <li> <p> <code>supported-virtualization-type</code> - The virtualization type (<code>hvm</code> | <code>paravirtual</code>).</p> </li>   <li> <p> <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.</p> </li>   <li> <p> <code>vcpu-info.default-threads-per-core</code> - The default number of threads per core for the instance type.</p> </li>   <li> <p> <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.</p> </li>   <li> <p> <code>vcpu-info.valid-cores</code> - The number of cores that can be configured for the instance type.</p> </li>   <li> <p> <code>vcpu-info.valid-threads-per-core</code> - The number of threads per core that can be configured for the instance type. For example, "1" or "1,2".</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInstanceTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInstanceTypes::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInstanceTypes::set_next_token): <p>The token to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeInstanceTypesOutput`](crate::output::DescribeInstanceTypesOutput) with field(s):
    ///   - [`instance_types(Option<Vec<InstanceTypeInfo>>)`](crate::output::DescribeInstanceTypesOutput::instance_types): <p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInstanceTypesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceTypesError>`](crate::error::DescribeInstanceTypesError)
    pub fn describe_instance_types(&self) -> fluent_builders::DescribeInstanceTypes<C, M, R> {
        fluent_builders::DescribeInstanceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInternetGateways`](crate::client::fluent_builders::DescribeInternetGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeInternetGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeInternetGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeInternetGateways::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>available</code>). Present only if a VPC is attached.</p> </li>   <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li>   <li> <p> <code>internet-gateway-id</code> - The ID of the Internet gateway.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the internet gateway.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeInternetGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeInternetGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`internet_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeInternetGateways::internet_gateway_ids) / [`set_internet_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeInternetGateways::set_internet_gateway_ids): <p>One or more internet gateway IDs.</p>  <p>Default: Describes all your internet gateways.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeInternetGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeInternetGateways::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeInternetGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeInternetGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeInternetGatewaysOutput`](crate::output::DescribeInternetGatewaysOutput) with field(s):
    ///   - [`internet_gateways(Option<Vec<InternetGateway>>)`](crate::output::DescribeInternetGatewaysOutput::internet_gateways): <p>Information about one or more internet gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeInternetGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeInternetGatewaysError>`](crate::error::DescribeInternetGatewaysError)
    pub fn describe_internet_gateways(&self) -> fluent_builders::DescribeInternetGateways<C, M, R> {
        fluent_builders::DescribeInternetGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpamPools`](crate::client::fluent_builders::DescribeIpamPools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeIpamPools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeIpamPools::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeIpamPools::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeIpamPools::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeIpamPools::set_filters): <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIpamPools::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIpamPools::set_max_results): <p>The maximum number of results to return in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIpamPools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIpamPools::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`ipam_pool_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIpamPools::ipam_pool_ids) / [`set_ipam_pool_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIpamPools::set_ipam_pool_ids): <p>The IDs of the IPAM pools you would like information on.</p>
    /// - On success, responds with [`DescribeIpamPoolsOutput`](crate::output::DescribeIpamPoolsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIpamPoolsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`ipam_pools(Option<Vec<IpamPool>>)`](crate::output::DescribeIpamPoolsOutput::ipam_pools): <p>Information about the IPAM pools.</p>
    /// - On failure, responds with [`SdkError<DescribeIpamPoolsError>`](crate::error::DescribeIpamPoolsError)
    pub fn describe_ipam_pools(&self) -> fluent_builders::DescribeIpamPools<C, M, R> {
        fluent_builders::DescribeIpamPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpams`](crate::client::fluent_builders::DescribeIpams) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeIpams::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeIpams::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeIpams::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeIpams::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeIpams::set_filters): <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIpams::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIpams::set_max_results): <p>The maximum number of results to return in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIpams::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIpams::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`ipam_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIpams::ipam_ids) / [`set_ipam_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIpams::set_ipam_ids): <p>The IDs of the IPAMs you want information on.</p>
    /// - On success, responds with [`DescribeIpamsOutput`](crate::output::DescribeIpamsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIpamsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`ipams(Option<Vec<Ipam>>)`](crate::output::DescribeIpamsOutput::ipams): <p>Information about the IPAMs.</p>
    /// - On failure, responds with [`SdkError<DescribeIpamsError>`](crate::error::DescribeIpamsError)
    pub fn describe_ipams(&self) -> fluent_builders::DescribeIpams<C, M, R> {
        fluent_builders::DescribeIpams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpamScopes`](crate::client::fluent_builders::DescribeIpamScopes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeIpamScopes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeIpamScopes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeIpamScopes::set_dry_run): <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeIpamScopes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeIpamScopes::set_filters): <p>One or more filters for the request. For more information about filtering, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html">Filtering CLI output</a>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIpamScopes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIpamScopes::set_max_results): <p>The maximum number of results to return in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIpamScopes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIpamScopes::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`ipam_scope_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIpamScopes::ipam_scope_ids) / [`set_ipam_scope_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIpamScopes::set_ipam_scope_ids): <p>The IDs of the scopes you want information on.</p>
    /// - On success, responds with [`DescribeIpamScopesOutput`](crate::output::DescribeIpamScopesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIpamScopesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`ipam_scopes(Option<Vec<IpamScope>>)`](crate::output::DescribeIpamScopesOutput::ipam_scopes): <p>The scopes you want information on.</p>
    /// - On failure, responds with [`SdkError<DescribeIpamScopesError>`](crate::error::DescribeIpamScopesError)
    pub fn describe_ipam_scopes(&self) -> fluent_builders::DescribeIpamScopes<C, M, R> {
        fluent_builders::DescribeIpamScopes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIpv6Pools`](crate::client::fluent_builders::DescribeIpv6Pools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeIpv6Pools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_ids(Vec<String>)`](crate::client::fluent_builders::DescribeIpv6Pools::pool_ids) / [`set_pool_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeIpv6Pools::set_pool_ids): <p>The IDs of the IPv6 address pools.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeIpv6Pools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeIpv6Pools::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeIpv6Pools::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeIpv6Pools::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeIpv6Pools::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeIpv6Pools::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeIpv6Pools::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeIpv6Pools::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    /// - On success, responds with [`DescribeIpv6PoolsOutput`](crate::output::DescribeIpv6PoolsOutput) with field(s):
    ///   - [`ipv6_pools(Option<Vec<Ipv6Pool>>)`](crate::output::DescribeIpv6PoolsOutput::ipv6_pools): <p>Information about the IPv6 address pools.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeIpv6PoolsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeIpv6PoolsError>`](crate::error::DescribeIpv6PoolsError)
    pub fn describe_ipv6_pools(&self) -> fluent_builders::DescribeIpv6Pools<C, M, R> {
        fluent_builders::DescribeIpv6Pools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeKeyPairs`](crate::client::fluent_builders::DescribeKeyPairs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeKeyPairs::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeKeyPairs::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>key-pair-id</code> - The ID of the key pair.</p> </li>   <li> <p> <code>fingerprint</code> - The fingerprint of the key pair.</p> </li>   <li> <p> <code>key-name</code> - The name of the key pair.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>  </ul>
    ///   - [`key_names(Vec<String>)`](crate::client::fluent_builders::DescribeKeyPairs::key_names) / [`set_key_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeKeyPairs::set_key_names): <p>The key pair names.</p>  <p>Default: Describes all of your key pairs.</p>
    ///   - [`key_pair_ids(Vec<String>)`](crate::client::fluent_builders::DescribeKeyPairs::key_pair_ids) / [`set_key_pair_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeKeyPairs::set_key_pair_ids): <p>The IDs of the key pairs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeKeyPairs::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeKeyPairs::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeKeyPairsOutput`](crate::output::DescribeKeyPairsOutput) with field(s):
    ///   - [`key_pairs(Option<Vec<KeyPairInfo>>)`](crate::output::DescribeKeyPairsOutput::key_pairs): <p>Information about the key pairs.</p>
    /// - On failure, responds with [`SdkError<DescribeKeyPairsError>`](crate::error::DescribeKeyPairsError)
    pub fn describe_key_pairs(&self) -> fluent_builders::DescribeKeyPairs<C, M, R> {
        fluent_builders::DescribeKeyPairs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLaunchTemplates`](crate::client::fluent_builders::DescribeLaunchTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLaunchTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLaunchTemplates::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`launch_template_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLaunchTemplates::launch_template_ids) / [`set_launch_template_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_launch_template_ids): <p>One or more launch template IDs.</p>
    ///   - [`launch_template_names(Vec<String>)`](crate::client::fluent_builders::DescribeLaunchTemplates::launch_template_names) / [`set_launch_template_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_launch_template_names): <p>One or more launch template names.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLaunchTemplates::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>create-time</code> - The time the launch template was created.</p> </li>   <li> <p> <code>launch-template-name</code> - The name of the launch template.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLaunchTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLaunchTemplates::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.</p>
    /// - On success, responds with [`DescribeLaunchTemplatesOutput`](crate::output::DescribeLaunchTemplatesOutput) with field(s):
    ///   - [`launch_templates(Option<Vec<LaunchTemplate>>)`](crate::output::DescribeLaunchTemplatesOutput::launch_templates): <p>Information about the launch templates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLaunchTemplatesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLaunchTemplatesError>`](crate::error::DescribeLaunchTemplatesError)
    pub fn describe_launch_templates(&self) -> fluent_builders::DescribeLaunchTemplates<C, M, R> {
        fluent_builders::DescribeLaunchTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLaunchTemplateVersions`](crate::client::fluent_builders::DescribeLaunchTemplateVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`launch_template_id(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::launch_template_id) / [`set_launch_template_id(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_launch_template_id): <p>The ID of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter.</p>
    ///   - [`launch_template_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::launch_template_name) / [`set_launch_template_name(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_launch_template_name): <p>The name of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter.</p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_versions): <p>One or more versions of the launch template. Valid values depend on whether you are describing a specified launch template (by ID or name) or all launch templates in your account.</p>  <p>To describe one or more versions of a specified launch template, valid values are <code>$Latest</code>, <code>$Default</code>, and numbers.</p>  <p>To describe all launch templates in your account that are defined as the latest version, the valid value is <code>$Latest</code>. To describe all launch templates in your account that are defined as the default version, the valid value is <code>$Default</code>. You can specify <code>$Latest</code> and <code>$Default</code> in the same call. You cannot specify numbers.</p>
    ///   - [`min_version(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::min_version) / [`set_min_version(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_min_version): <p>The version number after which to describe launch template versions.</p>
    ///   - [`max_version(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::max_version) / [`set_max_version(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_max_version): <p>The version number up to which to describe launch template versions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>create-time</code> - The time the launch template version was created.</p> </li>   <li> <p> <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.</p> </li>   <li> <p> <code>http-endpoint</code> - Indicates whether the HTTP metadata endpoint on your instances is enabled (<code>enabled</code> | <code>disabled</code>).</p> </li>   <li> <p> <code>http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint for the instance metadata service is enabled (<code>enabled</code> | <code>disabled</code>).</p> </li>   <li> <p> <code>host-resource-group-arn</code> - The ARN of the host resource group in which to launch the instances.</p> </li>   <li> <p> <code>http-tokens</code> - The state of token usage for your instance metadata requests (<code>optional</code> | <code>required</code>).</p> </li>   <li> <p> <code>iam-instance-profile</code> - The ARN of the IAM instance profile.</p> </li>   <li> <p> <code>image-id</code> - The ID of the AMI.</p> </li>   <li> <p> <code>instance-type</code> - The instance type.</p> </li>   <li> <p> <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default version.</p> </li>   <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li>   <li> <p> <code>license-configuration-arn</code> - The ARN of the license configuration.</p> </li>   <li> <p> <code>network-card-index</code> - The index of the network card.</p> </li>   <li> <p> <code>ram-disk-id</code> - The RAM disk ID.</p> </li>  </ul>
    /// - On success, responds with [`DescribeLaunchTemplateVersionsOutput`](crate::output::DescribeLaunchTemplateVersionsOutput) with field(s):
    ///   - [`launch_template_versions(Option<Vec<LaunchTemplateVersion>>)`](crate::output::DescribeLaunchTemplateVersionsOutput::launch_template_versions): <p>Information about the launch template versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLaunchTemplateVersionsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLaunchTemplateVersionsError>`](crate::error::DescribeLaunchTemplateVersionsError)
    pub fn describe_launch_template_versions(
        &self,
    ) -> fluent_builders::DescribeLaunchTemplateVersions<C, M, R> {
        fluent_builders::DescribeLaunchTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocalGatewayRouteTables`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_route_table_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::local_gateway_route_table_ids) / [`set_local_gateway_route_table_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::set_local_gateway_route_table_ids): <p>The IDs of the local gateway route tables.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li>   <li> <p> <code>local-gateway-route-table-id</code> - The ID of a local gateway route table.</p> </li>   <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li>   <li> <p> <code>state</code> - The state of the local gateway route table.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewayRouteTablesOutput`](crate::output::DescribeLocalGatewayRouteTablesOutput) with field(s):
    ///   - [`local_gateway_route_tables(Option<Vec<LocalGatewayRouteTable>>)`](crate::output::DescribeLocalGatewayRouteTablesOutput::local_gateway_route_tables): <p>Information about the local gateway route tables.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewayRouteTablesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewayRouteTablesError>`](crate::error::DescribeLocalGatewayRouteTablesError)
    pub fn describe_local_gateway_route_tables(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTables<C, M, R> {
        fluent_builders::DescribeLocalGatewayRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_route_table_virtual_interface_group_association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::local_gateway_route_table_virtual_interface_group_association_ids) / [`set_local_gateway_route_table_virtual_interface_group_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::set_local_gateway_route_table_virtual_interface_group_association_ids): <p>The IDs of the associations.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li>   <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li>   <li> <p> <code>local-gateway-route-table-virtual-interface-group-association-id</code> - The ID of the association.</p> </li>   <li> <p> <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li>   <li> <p> <code>state</code> - The state of the association.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput`](crate::output::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput) with field(s):
    ///   - [`local_gateway_route_table_virtual_interface_group_associations(Option<Vec<LocalGatewayRouteTableVirtualInterfaceGroupAssociation>>)`](crate::output::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput::local_gateway_route_table_virtual_interface_group_associations): <p>Information about the associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsError>`](crate::error::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsError)
    pub fn describe_local_gateway_route_table_virtual_interface_group_associations(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations<C, M, R>
    {
        fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`DescribeLocalGatewayRouteTableVpcAssociations`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_route_table_vpc_association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::local_gateway_route_table_vpc_association_ids) / [`set_local_gateway_route_table_vpc_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::set_local_gateway_route_table_vpc_association_ids): <p>The IDs of the associations.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li>   <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li>   <li> <p> <code>local-gateway-route-table-vpc-association-id</code> - The ID of the association.</p> </li>   <li> <p> <code>state</code> - The state of the association.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewayRouteTableVpcAssociationsOutput`](crate::output::DescribeLocalGatewayRouteTableVpcAssociationsOutput) with field(s):
    ///   - [`local_gateway_route_table_vpc_associations(Option<Vec<LocalGatewayRouteTableVpcAssociation>>)`](crate::output::DescribeLocalGatewayRouteTableVpcAssociationsOutput::local_gateway_route_table_vpc_associations): <p>Information about the associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewayRouteTableVpcAssociationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewayRouteTableVpcAssociationsError>`](crate::error::DescribeLocalGatewayRouteTableVpcAssociationsError)
    pub fn describe_local_gateway_route_table_vpc_associations(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations<C, M, R> {
        fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocalGateways`](crate::client::fluent_builders::DescribeLocalGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGateways::local_gateway_ids) / [`set_local_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGateways::set_local_gateway_ids): <p>One or more filters.</p>  <ul>   <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li>   <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li>   <li> <p> <code>local-gateway-route-table-virtual-interface-group-association-id</code> - The ID of the association.</p> </li>   <li> <p> <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li>   <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li>   <li> <p> <code>state</code> - The state of the association.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGateways::set_filters): <p>One or more filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGateways::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewaysOutput`](crate::output::DescribeLocalGatewaysOutput) with field(s):
    ///   - [`local_gateways(Option<Vec<LocalGateway>>)`](crate::output::DescribeLocalGatewaysOutput::local_gateways): <p>Information about the local gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewaysError>`](crate::error::DescribeLocalGatewaysError)
    pub fn describe_local_gateways(&self) -> fluent_builders::DescribeLocalGateways<C, M, R> {
        fluent_builders::DescribeLocalGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocalGatewayVirtualInterfaceGroups`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_virtual_interface_group_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::local_gateway_virtual_interface_group_ids) / [`set_local_gateway_virtual_interface_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::set_local_gateway_virtual_interface_group_ids): <p>The IDs of the virtual interface groups.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li>   <li> <p> <code>local-gateway-virtual-interface-id</code> - The ID of the virtual interface.</p> </li>   <li> <p> <code>local-gateway-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewayVirtualInterfaceGroupsOutput`](crate::output::DescribeLocalGatewayVirtualInterfaceGroupsOutput) with field(s):
    ///   - [`local_gateway_virtual_interface_groups(Option<Vec<LocalGatewayVirtualInterfaceGroup>>)`](crate::output::DescribeLocalGatewayVirtualInterfaceGroupsOutput::local_gateway_virtual_interface_groups): <p>The virtual interface groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewayVirtualInterfaceGroupsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewayVirtualInterfaceGroupsError>`](crate::error::DescribeLocalGatewayVirtualInterfaceGroupsError)
    pub fn describe_local_gateway_virtual_interface_groups(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups<C, M, R> {
        fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLocalGatewayVirtualInterfaces`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`local_gateway_virtual_interface_ids(Vec<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::local_gateway_virtual_interface_ids) / [`set_local_gateway_virtual_interface_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::set_local_gateway_virtual_interface_ids): <p>The IDs of the virtual interfaces.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::set_filters): <p>One or more filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeLocalGatewayVirtualInterfacesOutput`](crate::output::DescribeLocalGatewayVirtualInterfacesOutput) with field(s):
    ///   - [`local_gateway_virtual_interfaces(Option<Vec<LocalGatewayVirtualInterface>>)`](crate::output::DescribeLocalGatewayVirtualInterfacesOutput::local_gateway_virtual_interfaces): <p>Information about the virtual interfaces.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLocalGatewayVirtualInterfacesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeLocalGatewayVirtualInterfacesError>`](crate::error::DescribeLocalGatewayVirtualInterfacesError)
    pub fn describe_local_gateway_virtual_interfaces(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayVirtualInterfaces<C, M, R> {
        fluent_builders::DescribeLocalGatewayVirtualInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeManagedPrefixLists`](crate::client::fluent_builders::DescribeManagedPrefixLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeManagedPrefixLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeManagedPrefixLists::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>owner-id</code> - The ID of the prefix list owner.</p> </li>   <li> <p> <code>prefix-list-id</code> - The ID of the prefix list.</p> </li>   <li> <p> <code>prefix-list-name</code> - The name of the prefix list.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeManagedPrefixLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`prefix_list_ids(Vec<String>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::prefix_list_ids) / [`set_prefix_list_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeManagedPrefixLists::set_prefix_list_ids): <p>One or more prefix list IDs.</p>
    /// - On success, responds with [`DescribeManagedPrefixListsOutput`](crate::output::DescribeManagedPrefixListsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeManagedPrefixListsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`prefix_lists(Option<Vec<ManagedPrefixList>>)`](crate::output::DescribeManagedPrefixListsOutput::prefix_lists): <p>Information about the prefix lists.</p>
    /// - On failure, responds with [`SdkError<DescribeManagedPrefixListsError>`](crate::error::DescribeManagedPrefixListsError)
    pub fn describe_managed_prefix_lists(
        &self,
    ) -> fluent_builders::DescribeManagedPrefixLists<C, M, R> {
        fluent_builders::DescribeManagedPrefixLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMovingAddresses`](crate::client::fluent_builders::DescribeMovingAddresses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMovingAddresses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeMovingAddresses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeMovingAddresses::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> | <code>RestoringToClassic</code>).</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeMovingAddresses::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeMovingAddresses::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeMovingAddresses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeMovingAddresses::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error is returned.</p>  <p>Default: If no value is provided, the default is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMovingAddresses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMovingAddresses::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`public_ips(Vec<String>)`](crate::client::fluent_builders::DescribeMovingAddresses::public_ips) / [`set_public_ips(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeMovingAddresses::set_public_ips): <p>One or more Elastic IP addresses.</p>
    /// - On success, responds with [`DescribeMovingAddressesOutput`](crate::output::DescribeMovingAddressesOutput) with field(s):
    ///   - [`moving_address_statuses(Option<Vec<MovingAddressStatus>>)`](crate::output::DescribeMovingAddressesOutput::moving_address_statuses): <p>The status for each Elastic IP address.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMovingAddressesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeMovingAddressesError>`](crate::error::DescribeMovingAddressesError)
    pub fn describe_moving_addresses(&self) -> fluent_builders::DescribeMovingAddresses<C, M, R> {
        fluent_builders::DescribeMovingAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNatGateways`](crate::client::fluent_builders::DescribeNatGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNatGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNatGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNatGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filter(Vec<Filter>)`](crate::client::fluent_builders::DescribeNatGateways::filter) / [`set_filter(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNatGateways::set_filter): <p>One or more filters.</p>  <ul>   <li> <p> <code>nat-gateway-id</code> - The ID of the NAT gateway.</p> </li>   <li> <p> <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li>   <li> <p> <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNatGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNatGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`nat_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNatGateways::nat_gateway_ids) / [`set_nat_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNatGateways::set_nat_gateway_ids): <p>One or more NAT gateway IDs.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNatGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNatGateways::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeNatGatewaysOutput`](crate::output::DescribeNatGatewaysOutput) with field(s):
    ///   - [`nat_gateways(Option<Vec<NatGateway>>)`](crate::output::DescribeNatGatewaysOutput::nat_gateways): <p>Information about the NAT gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNatGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNatGatewaysError>`](crate::error::DescribeNatGatewaysError)
    pub fn describe_nat_gateways(&self) -> fluent_builders::DescribeNatGateways<C, M, R> {
        fluent_builders::DescribeNatGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkAcls`](crate::client::fluent_builders::DescribeNetworkAcls) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkAcls::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkAcls::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkAcls::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>association.association-id</code> - The ID of an association ID for the ACL.</p> </li>   <li> <p> <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.</p> </li>   <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li>   <li> <p> <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.</p> </li>   <li> <p> <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.</p> </li>   <li> <p> <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.</p> </li>   <li> <p> <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.</p> </li>   <li> <p> <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.</p> </li>   <li> <p> <code>entry.port-range.from</code> - The start of the port range specified in the entry. </p> </li>   <li> <p> <code>entry.port-range.to</code> - The end of the port range specified in the entry. </p> </li>   <li> <p> <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li>   <li> <p> <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> | <code>deny</code>).</p> </li>   <li> <p> <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the set of ACL entries.</p> </li>   <li> <p> <code>network-acl-id</code> - The ID of the network ACL.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the network ACL.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC for the network ACL.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkAcls::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkAcls::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_acl_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkAcls::network_acl_ids) / [`set_network_acl_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkAcls::set_network_acl_ids): <p>One or more network ACL IDs.</p>  <p>Default: Describes all your network ACLs.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkAcls::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkAcls::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkAcls::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkAcls::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeNetworkAclsOutput`](crate::output::DescribeNetworkAclsOutput) with field(s):
    ///   - [`network_acls(Option<Vec<NetworkAcl>>)`](crate::output::DescribeNetworkAclsOutput::network_acls): <p>Information about one or more network ACLs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkAclsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkAclsError>`](crate::error::DescribeNetworkAclsError)
    pub fn describe_network_acls(&self) -> fluent_builders::DescribeNetworkAcls<C, M, R> {
        fluent_builders::DescribeNetworkAcls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInsightsAccessScopeAnalyses`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_insights_access_scope_analysis_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::network_insights_access_scope_analysis_ids) / [`set_network_insights_access_scope_analysis_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_network_insights_access_scope_analysis_ids): <p>The IDs of the Network Access Scope analyses.</p>
    ///   - [`network_insights_access_scope_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::network_insights_access_scope_id) / [`set_network_insights_access_scope_id(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_network_insights_access_scope_id): <p>The ID of the Network Access Scope.</p>
    ///   - [`analysis_start_time_begin(DateTime)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::analysis_start_time_begin) / [`set_analysis_start_time_begin(Option<DateTime>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_analysis_start_time_begin): <p>Filters the results based on the start time. The analysis must have started on or after this time.</p>
    ///   - [`analysis_start_time_end(DateTime)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::analysis_start_time_end) / [`set_analysis_start_time_end(Option<DateTime>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_analysis_start_time_end): <p>Filters the results based on the start time. The analysis must have started on or before this time.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_filters): <p>There are no supported filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeNetworkInsightsAccessScopeAnalysesOutput`](crate::output::DescribeNetworkInsightsAccessScopeAnalysesOutput) with field(s):
    ///   - [`network_insights_access_scope_analyses(Option<Vec<NetworkInsightsAccessScopeAnalysis>>)`](crate::output::DescribeNetworkInsightsAccessScopeAnalysesOutput::network_insights_access_scope_analyses): <p>The Network Access Scope analyses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInsightsAccessScopeAnalysesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInsightsAccessScopeAnalysesError>`](crate::error::DescribeNetworkInsightsAccessScopeAnalysesError)
    pub fn describe_network_insights_access_scope_analyses(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInsightsAccessScopes`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_insights_access_scope_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::network_insights_access_scope_ids) / [`set_network_insights_access_scope_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::set_network_insights_access_scope_ids): <p>The IDs of the Network Access Scopes.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::set_filters): <p>There are no supported filters.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeNetworkInsightsAccessScopesOutput`](crate::output::DescribeNetworkInsightsAccessScopesOutput) with field(s):
    ///   - [`network_insights_access_scopes(Option<Vec<NetworkInsightsAccessScope>>)`](crate::output::DescribeNetworkInsightsAccessScopesOutput::network_insights_access_scopes): <p>The Network Access Scopes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInsightsAccessScopesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInsightsAccessScopesError>`](crate::error::DescribeNetworkInsightsAccessScopesError)
    pub fn describe_network_insights_access_scopes(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAccessScopes<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAccessScopes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInsightsAnalyses`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_insights_analysis_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::network_insights_analysis_ids) / [`set_network_insights_analysis_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_network_insights_analysis_ids): <p>The ID of the network insights analyses. You must specify either analysis IDs or a path ID.</p>
    ///   - [`network_insights_path_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::network_insights_path_id) / [`set_network_insights_path_id(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_network_insights_path_id): <p>The ID of the path. You must specify either a path ID or analysis IDs.</p>
    ///   - [`analysis_start_time(DateTime)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::analysis_start_time) / [`set_analysis_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_analysis_start_time): <p>The time when the network insights analyses started.</p>
    ///   - [`analysis_end_time(DateTime)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::analysis_end_time) / [`set_analysis_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_analysis_end_time): <p>The time when the network insights analyses ended.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_filters): <p>The filters. The following are possible values:</p>  <ul>   <li> <p>PathFound - A Boolean value that indicates whether a feasible path is found.</p> </li>   <li> <p>Status - The status of the analysis (running | succeeded | failed).</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeNetworkInsightsAnalysesOutput`](crate::output::DescribeNetworkInsightsAnalysesOutput) with field(s):
    ///   - [`network_insights_analyses(Option<Vec<NetworkInsightsAnalysis>>)`](crate::output::DescribeNetworkInsightsAnalysesOutput::network_insights_analyses): <p>Information about the network insights analyses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInsightsAnalysesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInsightsAnalysesError>`](crate::error::DescribeNetworkInsightsAnalysesError)
    pub fn describe_network_insights_analyses(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAnalyses<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInsightsPaths`](crate::client::fluent_builders::DescribeNetworkInsightsPaths) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_insights_path_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::network_insights_path_ids) / [`set_network_insights_path_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::set_network_insights_path_ids): <p>The IDs of the paths.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::set_filters): <p>The filters. The following are possible values:</p>  <ul>   <li> <p>Destination - The ID of the resource.</p> </li>   <li> <p>DestinationPort - The destination port.</p> </li>   <li> <p>Name - The path name.</p> </li>   <li> <p>Protocol - The protocol.</p> </li>   <li> <p>Source - The ID of the resource.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeNetworkInsightsPathsOutput`](crate::output::DescribeNetworkInsightsPathsOutput) with field(s):
    ///   - [`network_insights_paths(Option<Vec<NetworkInsightsPath>>)`](crate::output::DescribeNetworkInsightsPathsOutput::network_insights_paths): <p>Information about the paths.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInsightsPathsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInsightsPathsError>`](crate::error::DescribeNetworkInsightsPathsError)
    pub fn describe_network_insights_paths(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsPaths<C, M, R> {
        fluent_builders::DescribeNetworkInsightsPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInterfaceAttribute`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(NetworkInterfaceAttribute)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::attribute) / [`set_attribute(Option<NetworkInterfaceAttribute>)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::set_attribute): <p>The attribute of the network interface. This parameter is required.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_interface_id(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::network_interface_id) / [`set_network_interface_id(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute::set_network_interface_id): <p>The ID of the network interface.</p>
    /// - On success, responds with [`DescribeNetworkInterfaceAttributeOutput`](crate::output::DescribeNetworkInterfaceAttributeOutput) with field(s):
    ///   - [`attachment(Option<NetworkInterfaceAttachment>)`](crate::output::DescribeNetworkInterfaceAttributeOutput::attachment): <p>The attachment (if any) of the network interface.</p>
    ///   - [`description(Option<AttributeValue>)`](crate::output::DescribeNetworkInterfaceAttributeOutput::description): <p>The description of the network interface.</p>
    ///   - [`groups(Option<Vec<GroupIdentifier>>)`](crate::output::DescribeNetworkInterfaceAttributeOutput::groups): <p>The security groups associated with the network interface.</p>
    ///   - [`network_interface_id(Option<String>)`](crate::output::DescribeNetworkInterfaceAttributeOutput::network_interface_id): <p>The ID of the network interface.</p>
    ///   - [`source_dest_check(Option<AttributeBooleanValue>)`](crate::output::DescribeNetworkInterfaceAttributeOutput::source_dest_check): <p>Indicates whether source/destination checking is enabled.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInterfaceAttributeError>`](crate::error::DescribeNetworkInterfaceAttributeError)
    pub fn describe_network_interface_attribute(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfaceAttribute<C, M, R> {
        fluent_builders::DescribeNetworkInterfaceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInterfacePermissions`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_interface_permission_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::network_interface_permission_ids) / [`set_network_interface_permission_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::set_network_interface_permission_ids): <p>One or more network interface permission IDs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.</p> </li>   <li> <p> <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.</p> </li>   <li> <p> <code>network-interface-permission.aws-account-id</code> - The Amazon Web Services account ID.</p> </li>   <li> <p> <code>network-interface-permission.aws-service</code> - The Amazon Web Service.</p> </li>   <li> <p> <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. If this parameter is not specified, up to 50 results are returned by default.</p>
    /// - On success, responds with [`DescribeNetworkInterfacePermissionsOutput`](crate::output::DescribeNetworkInterfacePermissionsOutput) with field(s):
    ///   - [`network_interface_permissions(Option<Vec<NetworkInterfacePermission>>)`](crate::output::DescribeNetworkInterfacePermissionsOutput::network_interface_permissions): <p>The network interface permissions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInterfacePermissionsOutput::next_token): <p>The token to use to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInterfacePermissionsError>`](crate::error::DescribeNetworkInterfacePermissionsError)
    pub fn describe_network_interface_permissions(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfacePermissions<C, M, R> {
        fluent_builders::DescribeNetworkInterfacePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNetworkInterfaces`](crate::client::fluent_builders::DescribeNetworkInterfaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInterfaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.</p> </li>   <li> <p> <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the network interface. </p> </li>   <li> <p> <code>addresses.association.public-ip</code> - The association ID returned when the network interface was associated with the Elastic IP address (IPv4).</p> </li>   <li> <p> <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network interface.</p> </li>   <li> <p> <code>association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li>   <li> <p> <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li>   <li> <p> <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li>   <li> <p> <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li>   <li> <p> <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).</p> </li>   <li> <p> <code>attachment.attachment-id</code> - The ID of the interface attachment.</p> </li>   <li> <p> <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li>   <li> <p> <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is terminated.</p> </li>   <li> <p> <code>attachment.device-index</code> - The device index to which the network interface is attached.</p> </li>   <li> <p> <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li>   <li> <p> <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li>   <li> <p> <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone of the network interface.</p> </li>   <li> <p> <code>description</code> - The description of the network interface.</p> </li>   <li> <p> <code>group-id</code> - The ID of a security group associated with the network interface.</p> </li>   <li> <p> <code>group-name</code> - The name of a security group associated with the network interface.</p> </li>   <li> <p> <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.</p> </li>   <li> <p> <code>mac-address</code> - The MAC address of the network interface.</p> </li>   <li> <p> <code>network-interface-id</code> - The ID of the network interface.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the network interface owner.</p> </li>   <li> <p> <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.</p> </li>   <li> <p> <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).</p> </li>   <li> <p> <code>requester-id</code> - The alias or Amazon Web Services account ID of the principal or service that created the network interface.</p> </li>   <li> <p> <code>requester-managed</code> - Indicates whether the network interface is being managed by an Amazon Web Service (for example, Amazon Web Services Management Console, Auto Scaling, and so on).</p> </li>   <li> <p> <code>source-dest-check</code> - Indicates whether the network interface performs source/destination checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC. </p> </li>   <li> <p> <code>status</code> - The status of the network interface. If the network interface is not attached to an instance, the status is <code>available</code>; if a network interface is attached to an instance the status is <code>in-use</code>.</p> </li>   <li> <p> <code>subnet-id</code> - The ID of the subnet for the network interface.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC for the network interface.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeNetworkInterfaces::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`network_interface_ids(Vec<String>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::network_interface_ids) / [`set_network_interface_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::set_network_interface_ids): <p>One or more network interface IDs.</p>  <p>Default: Describes all your network interfaces.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeNetworkInterfaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeNetworkInterfaces::set_max_results): <p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results. You cannot specify this parameter and the network interface IDs parameter in the same request.</p>
    /// - On success, responds with [`DescribeNetworkInterfacesOutput`](crate::output::DescribeNetworkInterfacesOutput) with field(s):
    ///   - [`network_interfaces(Option<Vec<NetworkInterface>>)`](crate::output::DescribeNetworkInterfacesOutput::network_interfaces): <p>Information about one or more network interfaces.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeNetworkInterfacesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeNetworkInterfacesError>`](crate::error::DescribeNetworkInterfacesError)
    pub fn describe_network_interfaces(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfaces<C, M, R> {
        fluent_builders::DescribeNetworkInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePlacementGroups`](crate::client::fluent_builders::DescribePlacementGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePlacementGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePlacementGroups::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>group-name</code> - The name of the placement group.</p> </li>   <li> <p> <code>group-arn</code> - The Amazon Resource Name (ARN) of the placement group.</p> </li>   <li> <p> <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li>   <li> <p> <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code> | <code>partition</code>).</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribePlacementGroups::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribePlacementGroups::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`group_names(Vec<String>)`](crate::client::fluent_builders::DescribePlacementGroups::group_names) / [`set_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePlacementGroups::set_group_names): <p>The names of the placement groups.</p>  <p>Default: Describes all your placement groups, or only those otherwise specified.</p>
    ///   - [`group_ids(Vec<String>)`](crate::client::fluent_builders::DescribePlacementGroups::group_ids) / [`set_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePlacementGroups::set_group_ids): <p>The IDs of the placement groups.</p>
    /// - On success, responds with [`DescribePlacementGroupsOutput`](crate::output::DescribePlacementGroupsOutput) with field(s):
    ///   - [`placement_groups(Option<Vec<PlacementGroup>>)`](crate::output::DescribePlacementGroupsOutput::placement_groups): <p>Information about the placement groups.</p>
    /// - On failure, responds with [`SdkError<DescribePlacementGroupsError>`](crate::error::DescribePlacementGroupsError)
    pub fn describe_placement_groups(&self) -> fluent_builders::DescribePlacementGroups<C, M, R> {
        fluent_builders::DescribePlacementGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePrefixLists`](crate::client::fluent_builders::DescribePrefixLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePrefixLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribePrefixLists::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribePrefixLists::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePrefixLists::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePrefixLists::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>prefix-list-id</code>: The ID of a prefix list.</p> </li>   <li> <p> <code>prefix-list-name</code>: The name of a prefix list.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePrefixLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePrefixLists::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePrefixLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePrefixLists::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`prefix_list_ids(Vec<String>)`](crate::client::fluent_builders::DescribePrefixLists::prefix_list_ids) / [`set_prefix_list_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePrefixLists::set_prefix_list_ids): <p>One or more prefix list IDs.</p>
    /// - On success, responds with [`DescribePrefixListsOutput`](crate::output::DescribePrefixListsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribePrefixListsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`prefix_lists(Option<Vec<PrefixList>>)`](crate::output::DescribePrefixListsOutput::prefix_lists): <p>All available prefix lists.</p>
    /// - On failure, responds with [`SdkError<DescribePrefixListsError>`](crate::error::DescribePrefixListsError)
    pub fn describe_prefix_lists(&self) -> fluent_builders::DescribePrefixLists<C, M, R> {
        fluent_builders::DescribePrefixLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePrincipalIdFormat`](crate::client::fluent_builders::DescribePrincipalIdFormat) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePrincipalIdFormat::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribePrincipalIdFormat::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`resources(Vec<String>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::resources) / [`set_resources(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::set_resources): <p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePrincipalIdFormat::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePrincipalIdFormat::set_next_token): <p>The token to request the next page of results.</p>
    /// - On success, responds with [`DescribePrincipalIdFormatOutput`](crate::output::DescribePrincipalIdFormatOutput) with field(s):
    ///   - [`principals(Option<Vec<PrincipalIdFormat>>)`](crate::output::DescribePrincipalIdFormatOutput::principals): <p>Information about the ID format settings for the ARN.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePrincipalIdFormatOutput::next_token): <p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribePrincipalIdFormatError>`](crate::error::DescribePrincipalIdFormatError)
    pub fn describe_principal_id_format(
        &self,
    ) -> fluent_builders::DescribePrincipalIdFormat<C, M, R> {
        fluent_builders::DescribePrincipalIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePublicIpv4Pools`](crate::client::fluent_builders::DescribePublicIpv4Pools) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePublicIpv4Pools::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pool_ids(Vec<String>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::pool_ids) / [`set_pool_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::set_pool_ids): <p>The IDs of the address pools.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePublicIpv4Pools::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePublicIpv4Pools::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>  </ul>
    /// - On success, responds with [`DescribePublicIpv4PoolsOutput`](crate::output::DescribePublicIpv4PoolsOutput) with field(s):
    ///   - [`public_ipv4_pools(Option<Vec<PublicIpv4Pool>>)`](crate::output::DescribePublicIpv4PoolsOutput::public_ipv4_pools): <p>Information about the address pools.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePublicIpv4PoolsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribePublicIpv4PoolsError>`](crate::error::DescribePublicIpv4PoolsError)
    pub fn describe_public_ipv4_pools(&self) -> fluent_builders::DescribePublicIpv4Pools<C, M, R> {
        fluent_builders::DescribePublicIpv4Pools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRegions`](crate::client::fluent_builders::DescribeRegions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeRegions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeRegions::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>endpoint</code> - The endpoint of the Region (for example, <code>ec2.us-east-1.amazonaws.com</code>).</p> </li>   <li> <p> <code>opt-in-status</code> - The opt-in status of the Region (<code>opt-in-not-required</code> | <code>opted-in</code> | <code>not-opted-in</code>).</p> </li>   <li> <p> <code>region-name</code> - The name of the Region (for example, <code>us-east-1</code>).</p> </li>  </ul>
    ///   - [`region_names(Vec<String>)`](crate::client::fluent_builders::DescribeRegions::region_names) / [`set_region_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeRegions::set_region_names): <p>The names of the Regions. You can specify any Regions, whether they are enabled and disabled for your account.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeRegions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeRegions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`all_regions(bool)`](crate::client::fluent_builders::DescribeRegions::all_regions) / [`set_all_regions(Option<bool>)`](crate::client::fluent_builders::DescribeRegions::set_all_regions): <p>Indicates whether to display all Regions, including Regions that are disabled for your account.</p>
    /// - On success, responds with [`DescribeRegionsOutput`](crate::output::DescribeRegionsOutput) with field(s):
    ///   - [`regions(Option<Vec<Region>>)`](crate::output::DescribeRegionsOutput::regions): <p>Information about the Regions.</p>
    /// - On failure, responds with [`SdkError<DescribeRegionsError>`](crate::error::DescribeRegionsError)
    pub fn describe_regions(&self) -> fluent_builders::DescribeRegions<C, M, R> {
        fluent_builders::DescribeRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplaceRootVolumeTasks`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replace_root_volume_task_ids(Vec<String>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::replace_root_volume_task_ids) / [`set_replace_root_volume_task_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::set_replace_root_volume_task_ids): <p>The ID of the root volume replacement task to view.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::set_filters): <p>Filter to use:</p>  <ul>   <li> <p> <code>instance-id</code> - The ID of the instance for which the root volume replacement task was created.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeReplaceRootVolumeTasksOutput`](crate::output::DescribeReplaceRootVolumeTasksOutput) with field(s):
    ///   - [`replace_root_volume_tasks(Option<Vec<ReplaceRootVolumeTask>>)`](crate::output::DescribeReplaceRootVolumeTasksOutput::replace_root_volume_tasks): <p>Information about the root volume replacement task.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReplaceRootVolumeTasksOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeReplaceRootVolumeTasksError>`](crate::error::DescribeReplaceRootVolumeTasksError)
    pub fn describe_replace_root_volume_tasks(
        &self,
    ) -> fluent_builders::DescribeReplaceRootVolumeTasks<C, M, R> {
        fluent_builders::DescribeReplaceRootVolumeTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstances`](crate::client::fluent_builders::DescribeReservedInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedInstances::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li>   <li> <p> <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li>   <li> <p> <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).</p> </li>   <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li>   <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li>   <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or <code>Availability Zone</code>).</p> </li>   <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux with HA (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).</p> </li>   <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instance.</p> </li>   <li> <p> <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example, 2014-08-07T11:54:42.000Z).</p> </li>   <li> <p> <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> | <code>payment-failed</code> | <code>retired</code>).</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li>  </ul>
    ///   - [`offering_class(OfferingClassType)`](crate::client::fluent_builders::DescribeReservedInstances::offering_class) / [`set_offering_class(Option<OfferingClassType>)`](crate::client::fluent_builders::DescribeReservedInstances::set_offering_class): <p>Describes whether the Reserved Instance is Standard or Convertible.</p>
    ///   - [`reserved_instances_ids(Vec<String>)`](crate::client::fluent_builders::DescribeReservedInstances::reserved_instances_ids) / [`set_reserved_instances_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReservedInstances::set_reserved_instances_ids): <p>One or more Reserved Instance IDs.</p>  <p>Default: Describes all your Reserved Instances, or only those otherwise specified.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeReservedInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeReservedInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`offering_type(OfferingTypeValues)`](crate::client::fluent_builders::DescribeReservedInstances::offering_type) / [`set_offering_type(Option<OfferingTypeValues>)`](crate::client::fluent_builders::DescribeReservedInstances::set_offering_type): <p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.</p>
    /// - On success, responds with [`DescribeReservedInstancesOutput`](crate::output::DescribeReservedInstancesOutput) with field(s):
    ///   - [`reserved_instances(Option<Vec<ReservedInstances>>)`](crate::output::DescribeReservedInstancesOutput::reserved_instances): <p>A list of Reserved Instances.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstancesError>`](crate::error::DescribeReservedInstancesError)
    pub fn describe_reserved_instances(
        &self,
    ) -> fluent_builders::DescribeReservedInstances<C, M, R> {
        fluent_builders::DescribeReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstancesListings`](crate::client::fluent_builders::DescribeReservedInstancesListings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances.</p> </li>   <li> <p> <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.</p> </li>   <li> <p> <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> | <code>cancelled</code> | <code>closed</code>).</p> </li>   <li> <p> <code>status-message</code> - The reason for the status.</p> </li>  </ul>
    ///   - [`reserved_instances_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::reserved_instances_id) / [`set_reserved_instances_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::set_reserved_instances_id): <p>One or more Reserved Instance IDs.</p>
    ///   - [`reserved_instances_listing_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::reserved_instances_listing_id) / [`set_reserved_instances_listing_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstancesListings::set_reserved_instances_listing_id): <p>One or more Reserved Instance listing IDs.</p>
    /// - On success, responds with [`DescribeReservedInstancesListingsOutput`](crate::output::DescribeReservedInstancesListingsOutput) with field(s):
    ///   - [`reserved_instances_listings(Option<Vec<ReservedInstancesListing>>)`](crate::output::DescribeReservedInstancesListingsOutput::reserved_instances_listings): <p>Information about the Reserved Instance listing.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstancesListingsError>`](crate::error::DescribeReservedInstancesListingsError)
    pub fn describe_reserved_instances_listings(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesListings<C, M, R> {
        fluent_builders::DescribeReservedInstancesListings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstancesModifications`](crate::client::fluent_builders::DescribeReservedInstancesModifications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstancesModifications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>client-token</code> - The idempotency token for the modification request.</p> </li>   <li> <p> <code>create-date</code> - The time when the modification request was created.</p> </li>   <li> <p> <code>effective-date</code> - The time when the modification becomes effective.</p> </li>   <li> <p> <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.</p> </li>   <li> <p> <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new Reserved Instances.</p> </li>   <li> <p> <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.</p> </li>   <li> <p> <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved Instances.</p> </li>   <li> <p> <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).</p> </li>   <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.</p> </li>   <li> <p> <code>reserved-instances-modification-id</code> - The ID of the modification request.</p> </li>   <li> <p> <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> | <code>fulfilled</code> | <code>failed</code>).</p> </li>   <li> <p> <code>status-message</code> - The reason for the status.</p> </li>   <li> <p> <code>update-date</code> - The time when the modification request was last updated.</p> </li>  </ul>
    ///   - [`reserved_instances_modification_ids(Vec<String>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::reserved_instances_modification_ids) / [`set_reserved_instances_modification_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::set_reserved_instances_modification_ids): <p>IDs for the submitted modification request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstancesModifications::set_next_token): <p>The token to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeReservedInstancesModificationsOutput`](crate::output::DescribeReservedInstancesModificationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedInstancesModificationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`reserved_instances_modifications(Option<Vec<ReservedInstancesModification>>)`](crate::output::DescribeReservedInstancesModificationsOutput::reserved_instances_modifications): <p>The Reserved Instance modification information.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstancesModificationsError>`](crate::error::DescribeReservedInstancesModificationsError)
    pub fn describe_reserved_instances_modifications(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesModifications<C, M, R> {
        fluent_builders::DescribeReservedInstancesModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedInstancesOfferings`](crate::client::fluent_builders::DescribeReservedInstancesOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_availability_zone): <p>The Availability Zone in which the Reserved Instance can be used.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li>   <li> <p> <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li>   <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li>   <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li>   <li> <p> <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When this filter is not used, which is the default behavior, all offerings from both Amazon Web Services and the Reserved Instance Marketplace are listed.</p> </li>   <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux with HA (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>) </p> </li>   <li> <p> <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.</p> </li>   <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).</p> </li>   <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li>  </ul>
    ///   - [`include_marketplace(bool)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::include_marketplace) / [`set_include_marketplace(Option<bool>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_include_marketplace): <p>Include Reserved Instance Marketplace offerings in the response.</p>
    ///   - [`instance_type(InstanceType)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::instance_type) / [`set_instance_type(Option<InstanceType>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_instance_type): <p>The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
    ///   - [`max_duration(i64)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::max_duration) / [`set_max_duration(Option<i64>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_max_duration): <p>The maximum duration (in seconds) to filter when searching for offerings.</p>  <p>Default: 94608000 (3 years)</p>
    ///   - [`max_instance_count(i32)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::max_instance_count) / [`set_max_instance_count(Option<i32>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_max_instance_count): <p>The maximum number of instances to filter when searching for offerings.</p>  <p>Default: 20</p>
    ///   - [`min_duration(i64)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::min_duration) / [`set_min_duration(Option<i64>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_min_duration): <p>The minimum duration (in seconds) to filter when searching for offerings.</p>  <p>Default: 2592000 (1 month)</p>
    ///   - [`offering_class(OfferingClassType)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::offering_class) / [`set_offering_class(Option<OfferingClassType>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_offering_class): <p>The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.</p>
    ///   - [`product_description(RiProductDescription)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::product_description) / [`set_product_description(Option<RiProductDescription>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_product_description): <p>The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the description are for use with Amazon VPC.</p>
    ///   - [`reserved_instances_offering_ids(Vec<String>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::reserved_instances_offering_ids) / [`set_reserved_instances_offering_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_reserved_instances_offering_ids): <p>One or more Reserved Instances offering IDs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`instance_tenancy(Tenancy)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::instance_tenancy) / [`set_instance_tenancy(Option<Tenancy>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_instance_tenancy): <p>The tenancy of the instances covered by the reservation. A Reserved Instance with a tenancy of <code>dedicated</code> is applied to instances that run in a VPC on single-tenant hardware (i.e., Dedicated Instances).</p>  <p> <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p>  <p>Default: <code>default</code> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_max_results): <p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. The maximum is 100.</p>  <p>Default: 100</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_next_token): <p>The token to retrieve the next page of results.</p>
    ///   - [`offering_type(OfferingTypeValues)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::offering_type) / [`set_offering_type(Option<OfferingTypeValues>)`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::set_offering_type): <p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type. </p>
    /// - On success, responds with [`DescribeReservedInstancesOfferingsOutput`](crate::output::DescribeReservedInstancesOfferingsOutput) with field(s):
    ///   - [`reserved_instances_offerings(Option<Vec<ReservedInstancesOffering>>)`](crate::output::DescribeReservedInstancesOfferingsOutput::reserved_instances_offerings): <p>A list of Reserved Instances offerings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReservedInstancesOfferingsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedInstancesOfferingsError>`](crate::error::DescribeReservedInstancesOfferingsError)
    pub fn describe_reserved_instances_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesOfferings<C, M, R> {
        fluent_builders::DescribeReservedInstancesOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRouteTables`](crate::client::fluent_builders::DescribeRouteTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeRouteTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeRouteTables::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeRouteTables::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>association.route-table-association-id</code> - The ID of an association ID for the route table.</p> </li>   <li> <p> <code>association.route-table-id</code> - The ID of the route table involved in the association.</p> </li>   <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li>   <li> <p> <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in the response.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the route table.</p> </li>   <li> <p> <code>route-table-id</code> - The ID of the route table.</p> </li>   <li> <p> <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.</p> </li>   <li> <p> <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.</p> </li>   <li> <p> <code>route.destination-prefix-list-id</code> - The ID (prefix) of the Amazon Web Service specified in a route in the table.</p> </li>   <li> <p> <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a route in the route table.</p> </li>   <li> <p> <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.</p> </li>   <li> <p> <code>route.instance-id</code> - The ID of an instance specified in a route in the table.</p> </li>   <li> <p> <code>route.nat-gateway-id</code> - The ID of a NAT gateway.</p> </li>   <li> <p> <code>route.transit-gateway-id</code> - The ID of a transit gateway.</p> </li>   <li> <p> <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.</p> </li>   <li> <p> <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>). The blackhole state indicates that the route's target isn't available (for example, the specified gateway isn't attached to the VPC, the specified NAT instance has been terminated, and so on).</p> </li>   <li> <p> <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the table.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC for the route table.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeRouteTables::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeRouteTables::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`route_table_ids(Vec<String>)`](crate::client::fluent_builders::DescribeRouteTables::route_table_ids) / [`set_route_table_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeRouteTables::set_route_table_ids): <p>One or more route table IDs.</p>  <p>Default: Describes all your route tables.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRouteTables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeRouteTables::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeRouteTables::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeRouteTables::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeRouteTablesOutput`](crate::output::DescribeRouteTablesOutput) with field(s):
    ///   - [`route_tables(Option<Vec<RouteTable>>)`](crate::output::DescribeRouteTablesOutput::route_tables): <p>Information about one or more route tables.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeRouteTablesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeRouteTablesError>`](crate::error::DescribeRouteTablesError)
    pub fn describe_route_tables(&self) -> fluent_builders::DescribeRouteTables<C, M, R> {
        fluent_builders::DescribeRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScheduledInstanceAvailability`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li>   <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li>   <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li>   <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li>  </ul>
    ///   - [`first_slot_start_time_range(SlotDateTimeRangeRequest)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::first_slot_start_time_range) / [`set_first_slot_start_time_range(Option<SlotDateTimeRangeRequest>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_first_slot_start_time_range): <p>The time period for the first schedule to start.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_max_results): <p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`max_slot_duration_in_hours(i32)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::max_slot_duration_in_hours) / [`set_max_slot_duration_in_hours(Option<i32>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_max_slot_duration_in_hours): <p>The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and less than 1,720.</p>
    ///   - [`min_slot_duration_in_hours(i32)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::min_slot_duration_in_hours) / [`set_min_slot_duration_in_hours(Option<i32>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_min_slot_duration_in_hours): <p>The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`recurrence(ScheduledInstanceRecurrenceRequest)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::recurrence) / [`set_recurrence(Option<ScheduledInstanceRecurrenceRequest>)`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::set_recurrence): <p>The schedule recurrence.</p>
    /// - On success, responds with [`DescribeScheduledInstanceAvailabilityOutput`](crate::output::DescribeScheduledInstanceAvailabilityOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeScheduledInstanceAvailabilityOutput::next_token): <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`scheduled_instance_availability_set(Option<Vec<ScheduledInstanceAvailability>>)`](crate::output::DescribeScheduledInstanceAvailabilityOutput::scheduled_instance_availability_set): <p>Information about the available Scheduled Instances.</p>
    /// - On failure, responds with [`SdkError<DescribeScheduledInstanceAvailabilityError>`](crate::error::DescribeScheduledInstanceAvailabilityError)
    pub fn describe_scheduled_instance_availability(
        &self,
    ) -> fluent_builders::DescribeScheduledInstanceAvailability<C, M, R> {
        fluent_builders::DescribeScheduledInstanceAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScheduledInstances`](crate::client::fluent_builders::DescribeScheduledInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeScheduledInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeScheduledInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeScheduledInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li>   <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li>   <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li>   <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeScheduledInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_max_results): <p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeScheduledInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`scheduled_instance_ids(Vec<String>)`](crate::client::fluent_builders::DescribeScheduledInstances::scheduled_instance_ids) / [`set_scheduled_instance_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_scheduled_instance_ids): <p>The Scheduled Instance IDs.</p>
    ///   - [`slot_start_time_range(SlotStartTimeRangeRequest)`](crate::client::fluent_builders::DescribeScheduledInstances::slot_start_time_range) / [`set_slot_start_time_range(Option<SlotStartTimeRangeRequest>)`](crate::client::fluent_builders::DescribeScheduledInstances::set_slot_start_time_range): <p>The time period for the first schedule to start.</p>
    /// - On success, responds with [`DescribeScheduledInstancesOutput`](crate::output::DescribeScheduledInstancesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeScheduledInstancesOutput::next_token): <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`scheduled_instance_set(Option<Vec<ScheduledInstance>>)`](crate::output::DescribeScheduledInstancesOutput::scheduled_instance_set): <p>Information about the Scheduled Instances.</p>
    /// - On failure, responds with [`SdkError<DescribeScheduledInstancesError>`](crate::error::DescribeScheduledInstancesError)
    pub fn describe_scheduled_instances(
        &self,
    ) -> fluent_builders::DescribeScheduledInstances<C, M, R> {
        fluent_builders::DescribeScheduledInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityGroupReferences`](crate::client::fluent_builders::DescribeSecurityGroupReferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSecurityGroupReferences::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSecurityGroupReferences::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`group_id(Vec<String>)`](crate::client::fluent_builders::DescribeSecurityGroupReferences::group_id) / [`set_group_id(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSecurityGroupReferences::set_group_id): <p>The IDs of the security groups in your account.</p>
    /// - On success, responds with [`DescribeSecurityGroupReferencesOutput`](crate::output::DescribeSecurityGroupReferencesOutput) with field(s):
    ///   - [`security_group_reference_set(Option<Vec<SecurityGroupReference>>)`](crate::output::DescribeSecurityGroupReferencesOutput::security_group_reference_set): <p>Information about the VPCs with the referencing security groups.</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityGroupReferencesError>`](crate::error::DescribeSecurityGroupReferencesError)
    pub fn describe_security_group_references(
        &self,
    ) -> fluent_builders::DescribeSecurityGroupReferences<C, M, R> {
        fluent_builders::DescribeSecurityGroupReferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityGroupRules`](crate::client::fluent_builders::DescribeSecurityGroupRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSecurityGroupRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>group-id</code> - The ID of the security group.</p> </li>   <li> <p> <code>security-group-rule-id</code> - The ID of the security group rule.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>  </ul>
    ///   - [`security_group_rule_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::security_group_rule_ids) / [`set_security_group_rule_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::set_security_group_rule_ids): <p>The IDs of the security group rules.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSecurityGroupRules::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSecurityGroupRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSecurityGroupRules::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned.</p>
    /// - On success, responds with [`DescribeSecurityGroupRulesOutput`](crate::output::DescribeSecurityGroupRulesOutput) with field(s):
    ///   - [`security_group_rules(Option<Vec<SecurityGroupRule>>)`](crate::output::DescribeSecurityGroupRulesOutput::security_group_rules): <p>Information about security group rules.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSecurityGroupRulesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>
    /// - On failure, responds with [`SdkError<DescribeSecurityGroupRulesError>`](crate::error::DescribeSecurityGroupRulesError)
    pub fn describe_security_group_rules(
        &self,
    ) -> fluent_builders::DescribeSecurityGroupRules<C, M, R> {
        fluent_builders::DescribeSecurityGroupRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityGroups`](crate::client::fluent_builders::DescribeSecurityGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSecurityGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSecurityGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_filters): <p>The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.</p>  <ul>   <li> <p> <code>description</code> - The description of the security group.</p> </li>   <li> <p> <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.</p> </li>   <li> <p> <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li>   <li> <p> <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an outbound security group rule.</p> </li>   <li> <p> <code>egress.ip-permission.group-name</code> - The name of a security group that is referenced in an outbound security group rule.</p> </li>   <li> <p> <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.</p> </li>   <li> <p> <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule allows outbound access.</p> </li>   <li> <p> <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code>, a protocol number, or -1 for all protocols).</p> </li>   <li> <p> <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li>   <li> <p> <code>egress.ip-permission.user-id</code> - The ID of an Amazon Web Services account that has been referenced in an outbound security group rule.</p> </li>   <li> <p> <code>group-id</code> - The ID of the security group. </p> </li>   <li> <p> <code>group-name</code> - The name of the security group.</p> </li>   <li> <p> <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.</p> </li>   <li> <p> <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li>   <li> <p> <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound security group rule.</p> </li>   <li> <p> <code>ip-permission.group-name</code> - The name of a security group that is referenced in an inbound security group rule.</p> </li>   <li> <p> <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.</p> </li>   <li> <p> <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows inbound access.</p> </li>   <li> <p> <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code>, a protocol number, or -1 for all protocols).</p> </li>   <li> <p> <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li>   <li> <p> <code>ip-permission.user-id</code> - The ID of an Amazon Web Services account that has been referenced in an inbound security group rule.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner of the security group.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC specified when the security group was created.</p> </li>  </ul>
    ///   - [`group_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSecurityGroups::group_ids) / [`set_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_group_ids): <p>The IDs of the security groups. Required for security groups in a nondefault VPC.</p>  <p>Default: Describes all of your security groups.</p>
    ///   - [`group_names(Vec<String>)`](crate::client::fluent_builders::DescribeSecurityGroups::group_names) / [`set_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_group_names): <p>[EC2-Classic and default VPC only] The names of the security groups. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to describe security groups by name.</p>  <p>Default: Describes all of your security groups.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSecurityGroups::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_next_token): <p>The token to request the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSecurityGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSecurityGroups::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned.</p>
    /// - On success, responds with [`DescribeSecurityGroupsOutput`](crate::output::DescribeSecurityGroupsOutput) with field(s):
    ///   - [`security_groups(Option<Vec<SecurityGroup>>)`](crate::output::DescribeSecurityGroupsOutput::security_groups): <p>Information about the security groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSecurityGroupsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityGroupsError>`](crate::error::DescribeSecurityGroupsError)
    pub fn describe_security_groups(&self) -> fluent_builders::DescribeSecurityGroups<C, M, R> {
        fluent_builders::DescribeSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshotAttribute`](crate::client::fluent_builders::DescribeSnapshotAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(SnapshotAttributeName)`](crate::client::fluent_builders::DescribeSnapshotAttribute::attribute) / [`set_attribute(Option<SnapshotAttributeName>)`](crate::client::fluent_builders::DescribeSnapshotAttribute::set_attribute): <p>The snapshot attribute you would like to view.</p>
    ///   - [`snapshot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotAttribute::snapshot_id) / [`set_snapshot_id(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotAttribute::set_snapshot_id): <p>The ID of the EBS snapshot.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSnapshotAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSnapshotAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeSnapshotAttributeOutput`](crate::output::DescribeSnapshotAttributeOutput) with field(s):
    ///   - [`create_volume_permissions(Option<Vec<CreateVolumePermission>>)`](crate::output::DescribeSnapshotAttributeOutput::create_volume_permissions): <p>The users and groups that have the permissions for creating volumes from the snapshot.</p>
    ///   - [`product_codes(Option<Vec<ProductCode>>)`](crate::output::DescribeSnapshotAttributeOutput::product_codes): <p>The product codes.</p>
    ///   - [`snapshot_id(Option<String>)`](crate::output::DescribeSnapshotAttributeOutput::snapshot_id): <p>The ID of the EBS snapshot.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotAttributeError>`](crate::error::DescribeSnapshotAttributeError)
    pub fn describe_snapshot_attribute(
        &self,
    ) -> fluent_builders::DescribeSnapshotAttribute<C, M, R> {
        fluent_builders::DescribeSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSnapshots::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSnapshots::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>description</code> - A description of the snapshot.</p> </li>   <li> <p> <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)</p> </li>   <li> <p> <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use the related parameter instead of this filter.</p> </li>   <li> <p> <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the related parameter instead of this filter.</p> </li>   <li> <p> <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).</p> </li>   <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li>   <li> <p> <code>start-time</code> - The time stamp when the snapshot was initiated.</p> </li>   <li> <p> <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> | <code>error</code>).</p> </li>   <li> <p> <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li>   <li> <p> <code>volume-size</code> - The size of the volume, in GiB.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSnapshots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshots::set_max_results): <p>The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned. If this parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot IDs parameter in the same request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_next_token): <p>The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`owner_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshots::owner_ids) / [`set_owner_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshots::set_owner_ids): <p>Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web Services account IDs, <code>self</code>, and <code>amazon</code>.</p>
    ///   - [`restorable_by_user_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshots::restorable_by_user_ids) / [`set_restorable_by_user_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshots::set_restorable_by_user_ids): <p>The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.</p>
    ///   - [`snapshot_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_ids) / [`set_snapshot_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_ids): <p>The snapshot IDs.</p>  <p>Default: Describes the snapshots for which you have create volume permissions.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSnapshots::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSnapshots::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput) with field(s):
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeSnapshotsOutput::snapshots): <p>Information about the snapshots.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSnapshotsOutput::next_token): <p>The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotsError>`](crate::error::DescribeSnapshotsError)
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots<C, M, R> {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshotTierStatus`](crate::client::fluent_builders::DescribeSnapshotTierStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshotTierStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li>   <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li>   <li> <p> <code>last-tiering-operation</code> - The state of the last archive or restore action. (<code>archival-in-progress</code> | <code>archival-completed</code> | <code>archival-failed</code> | <code>permanent-restore-in-progress</code> | <code>permanent-restore-completed</code> | <code>permanent-restore-failed</code> | <code>temporary-restore-in-progress</code> | <code>temporary-restore-completed</code> | <code>temporary-restore-failed</code>)</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshotTierStatus::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeSnapshotTierStatusOutput`](crate::output::DescribeSnapshotTierStatusOutput) with field(s):
    ///   - [`snapshot_tier_statuses(Option<Vec<SnapshotTierStatus>>)`](crate::output::DescribeSnapshotTierStatusOutput::snapshot_tier_statuses): <p>Information about the snapshot's storage tier.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSnapshotTierStatusOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotTierStatusError>`](crate::error::DescribeSnapshotTierStatusError)
    pub fn describe_snapshot_tier_status(
        &self,
    ) -> fluent_builders::DescribeSnapshotTierStatus<C, M, R> {
        fluent_builders::DescribeSnapshotTierStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotDatafeedSubscription`](crate::client::fluent_builders::DescribeSpotDatafeedSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotDatafeedSubscription::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotDatafeedSubscription::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeSpotDatafeedSubscriptionOutput`](crate::output::DescribeSpotDatafeedSubscriptionOutput) with field(s):
    ///   - [`spot_datafeed_subscription(Option<SpotDatafeedSubscription>)`](crate::output::DescribeSpotDatafeedSubscriptionOutput::spot_datafeed_subscription): <p>The Spot Instance data feed subscription.</p>
    /// - On failure, responds with [`SdkError<DescribeSpotDatafeedSubscriptionError>`](crate::error::DescribeSpotDatafeedSubscriptionError)
    pub fn describe_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::DescribeSpotDatafeedSubscription<C, M, R> {
        fluent_builders::DescribeSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotFleetInstances`](crate::client::fluent_builders::DescribeSpotFleetInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotFleetInstances::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpotFleetInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`spot_fleet_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::spot_fleet_request_id) / [`set_spot_fleet_request_id(Option<String>)`](crate::client::fluent_builders::DescribeSpotFleetInstances::set_spot_fleet_request_id): <p>The ID of the Spot Fleet request.</p>
    /// - On success, responds with [`DescribeSpotFleetInstancesOutput`](crate::output::DescribeSpotFleetInstancesOutput) with field(s):
    ///   - [`active_instances(Option<Vec<ActiveInstance>>)`](crate::output::DescribeSpotFleetInstancesOutput::active_instances): <p>The running instances. This list is refreshed periodically and might be out of date.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpotFleetInstancesOutput::next_token): <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`spot_fleet_request_id(Option<String>)`](crate::output::DescribeSpotFleetInstancesOutput::spot_fleet_request_id): <p>The ID of the Spot Fleet request.</p>
    /// - On failure, responds with [`SdkError<DescribeSpotFleetInstancesError>`](crate::error::DescribeSpotFleetInstancesError)
    pub fn describe_spot_fleet_instances(
        &self,
    ) -> fluent_builders::DescribeSpotFleetInstances<C, M, R> {
        fluent_builders::DescribeSpotFleetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotFleetRequestHistory`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`event_type(EventType)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::event_type) / [`set_event_type(Option<EventType>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_event_type): <p>The type of events to describe. By default, all events are described.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`spot_fleet_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::spot_fleet_request_id) / [`set_spot_fleet_request_id(Option<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_spot_fleet_request_id): <p>The ID of the Spot Fleet request.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory::set_start_time): <p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// - On success, responds with [`DescribeSpotFleetRequestHistoryOutput`](crate::output::DescribeSpotFleetRequestHistoryOutput) with field(s):
    ///   - [`history_records(Option<Vec<HistoryRecord>>)`](crate::output::DescribeSpotFleetRequestHistoryOutput::history_records): <p>Information about the events in the history of the Spot Fleet request.</p>
    ///   - [`last_evaluated_time(Option<DateTime>)`](crate::output::DescribeSpotFleetRequestHistoryOutput::last_evaluated_time): <p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p>  <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpotFleetRequestHistoryOutput::next_token): <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`spot_fleet_request_id(Option<String>)`](crate::output::DescribeSpotFleetRequestHistoryOutput::spot_fleet_request_id): <p>The ID of the Spot Fleet request.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeSpotFleetRequestHistoryOutput::start_time): <p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// - On failure, responds with [`SdkError<DescribeSpotFleetRequestHistoryError>`](crate::error::DescribeSpotFleetRequestHistoryError)
    pub fn describe_spot_fleet_request_history(
        &self,
    ) -> fluent_builders::DescribeSpotFleetRequestHistory<C, M, R> {
        fluent_builders::DescribeSpotFleetRequestHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotFleetRequests`](crate::client::fluent_builders::DescribeSpotFleetRequests) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotFleetRequests::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotFleetRequests::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpotFleetRequests::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`spot_fleet_request_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::spot_fleet_request_ids) / [`set_spot_fleet_request_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSpotFleetRequests::set_spot_fleet_request_ids): <p>The IDs of the Spot Fleet requests.</p>
    /// - On success, responds with [`DescribeSpotFleetRequestsOutput`](crate::output::DescribeSpotFleetRequestsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpotFleetRequestsOutput::next_token): <p>The token required to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`spot_fleet_request_configs(Option<Vec<SpotFleetRequestConfig>>)`](crate::output::DescribeSpotFleetRequestsOutput::spot_fleet_request_configs): <p>Information about the configuration of your Spot Fleet.</p>
    /// - On failure, responds with [`SdkError<DescribeSpotFleetRequestsError>`](crate::error::DescribeSpotFleetRequestsError)
    pub fn describe_spot_fleet_requests(
        &self,
    ) -> fluent_builders::DescribeSpotFleetRequests<C, M, R> {
        fluent_builders::DescribeSpotFleetRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotInstanceRequests`](crate::client::fluent_builders::DescribeSpotInstanceRequests) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotInstanceRequests::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>availability-zone-group</code> - The Availability Zone group.</p> </li>   <li> <p> <code>create-time</code> - The time stamp when the Spot Instance request was created.</p> </li>   <li> <p> <code>fault-code</code> - The fault code related to the request.</p> </li>   <li> <p> <code>fault-message</code> - The fault message related to the request.</p> </li>   <li> <p> <code>instance-id</code> - The ID of the instance that fulfilled the request.</p> </li>   <li> <p> <code>launch-group</code> - The Spot Instance launch group.</p> </li>   <li> <p> <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted on instance termination.</p> </li>   <li> <p> <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li>   <li> <p> <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.</p> </li>   <li> <p> <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.</p> </li>   <li> <p> <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.</p> </li>   <li> <p> <code>launch.group-id</code> - The ID of the security group for the instance.</p> </li>   <li> <p> <code>launch.group-name</code> - The name of the security group for the instance.</p> </li>   <li> <p> <code>launch.image-id</code> - The ID of the AMI.</p> </li>   <li> <p> <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li>   <li> <p> <code>launch.kernel-id</code> - The kernel ID.</p> </li>   <li> <p> <code>launch.key-name</code> - The name of the key pair the instance launched with.</p> </li>   <li> <p> <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.</p> </li>   <li> <p> <code>launch.ramdisk-id</code> - The RAM disk ID.</p> </li>   <li> <p> <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.</p> </li>   <li> <p> <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP address.</p> </li>   <li> <p> <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when the instance is terminated.</p> </li>   <li> <p> <code>network-interface.description</code> - A description of the network interface.</p> </li>   <li> <p> <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the instance.</p> </li>   <li> <p> <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.</p> </li>   <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li>   <li> <p> <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.</p> </li>   <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.</p> </li>   <li> <p> <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code> | <code>Windows</code>).</p> </li>   <li> <p> <code>spot-instance-request-id</code> - The Spot Instance request ID.</p> </li>   <li> <p> <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.</p> </li>   <li> <p> <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> | <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help you track your Amazon EC2 Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> </li>   <li> <p> <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance request.</p> </li>   <li> <p> <code>status-message</code> - The message explaining the status of the Spot Instance request.</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).</p> </li>   <li> <p> <code>valid-from</code> - The start date of the request.</p> </li>   <li> <p> <code>valid-until</code> - The end date of the request.</p> </li>  </ul>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`spot_instance_request_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::spot_instance_request_ids) / [`set_spot_instance_request_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::set_spot_instance_request_ids): <p>One or more Spot Instance request IDs.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::set_next_token): <p>The token to request the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpotInstanceRequests::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 5 and 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    /// - On success, responds with [`DescribeSpotInstanceRequestsOutput`](crate::output::DescribeSpotInstanceRequestsOutput) with field(s):
    ///   - [`spot_instance_requests(Option<Vec<SpotInstanceRequest>>)`](crate::output::DescribeSpotInstanceRequestsOutput::spot_instance_requests): <p>One or more Spot Instance requests.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpotInstanceRequestsOutput::next_token): <p>The token to use to retrieve the next set of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSpotInstanceRequestsError>`](crate::error::DescribeSpotInstanceRequestsError)
    pub fn describe_spot_instance_requests(
        &self,
    ) -> fluent_builders::DescribeSpotInstanceRequests<C, M, R> {
        fluent_builders::DescribeSpotInstanceRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSpotPriceHistory`](crate::client::fluent_builders::DescribeSpotPriceHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotPriceHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone for which prices should be returned.</p> </li>   <li> <p> <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li>   <li> <p> <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> | <code>Red Hat Enterprise Linux</code> | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).</p> </li>   <li> <p> <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or less than comparison is not supported).</p> </li>   <li> <p> <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater than or less than comparison is not supported.</p> </li>  </ul>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_availability_zone): <p>Filters the results by the specified Availability Zone.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSpotPriceHistory::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeSpotPriceHistory::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_end_time): <p>The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    ///   - [`instance_types(Vec<InstanceType>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::instance_types) / [`set_instance_types(Option<Vec<InstanceType>>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_instance_types): <p>Filters the results by the specified instance types.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSpotPriceHistory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_max_results): <p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_next_token): <p>The token for the next set of results.</p>
    ///   - [`product_descriptions(Vec<String>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::product_descriptions) / [`set_product_descriptions(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_product_descriptions): <p>Filters the results by the specified basic product descriptions.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeSpotPriceHistory::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeSpotPriceHistory::set_start_time): <p>The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>
    /// - On success, responds with [`DescribeSpotPriceHistoryOutput`](crate::output::DescribeSpotPriceHistoryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSpotPriceHistoryOutput::next_token): <p>The token required to retrieve the next set of results. This value is null or an empty string when there are no more results to return.</p>
    ///   - [`spot_price_history(Option<Vec<SpotPrice>>)`](crate::output::DescribeSpotPriceHistoryOutput::spot_price_history): <p>The historical Spot prices.</p>
    /// - On failure, responds with [`SdkError<DescribeSpotPriceHistoryError>`](crate::error::DescribeSpotPriceHistoryError)
    pub fn describe_spot_price_history(
        &self,
    ) -> fluent_builders::DescribeSpotPriceHistory<C, M, R> {
        fluent_builders::DescribeSpotPriceHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStaleSecurityGroups`](crate::client::fluent_builders::DescribeStaleSecurityGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeStaleSecurityGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::set_max_results): <p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::set_next_token): <p>The token for the next set of items to return. (You received this token from a prior call.)</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::DescribeStaleSecurityGroups::set_vpc_id): <p>The ID of the VPC.</p>
    /// - On success, responds with [`DescribeStaleSecurityGroupsOutput`](crate::output::DescribeStaleSecurityGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStaleSecurityGroupsOutput::next_token): <p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>
    ///   - [`stale_security_group_set(Option<Vec<StaleSecurityGroup>>)`](crate::output::DescribeStaleSecurityGroupsOutput::stale_security_group_set): <p>Information about the stale security groups.</p>
    /// - On failure, responds with [`SdkError<DescribeStaleSecurityGroupsError>`](crate::error::DescribeStaleSecurityGroupsError)
    pub fn describe_stale_security_groups(
        &self,
    ) -> fluent_builders::DescribeStaleSecurityGroups<C, M, R> {
        fluent_builders::DescribeStaleSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStoreImageTasks`](crate::client::fluent_builders::DescribeStoreImageTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeStoreImageTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_ids(Vec<String>)`](crate::client::fluent_builders::DescribeStoreImageTasks::image_ids) / [`set_image_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeStoreImageTasks::set_image_ids): <p>The AMI IDs for which to show progress. Up to 20 AMI IDs can be included in a request.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeStoreImageTasks::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeStoreImageTasks::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeStoreImageTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeStoreImageTasks::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>task-state</code> - Returns tasks in a certain state (<code>InProgress</code> | <code>Completed</code> | <code>Failed</code>)</p> </li>   <li> <p> <code>bucket</code> - Returns task information for tasks that targeted a specific bucket. For the filter value, specify the bucket name.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStoreImageTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStoreImageTasks::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeStoreImageTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeStoreImageTasks::set_max_results): <p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200. You cannot specify this parameter and the <code>ImageIDs</code> parameter in the same call.</p>
    /// - On success, responds with [`DescribeStoreImageTasksOutput`](crate::output::DescribeStoreImageTasksOutput) with field(s):
    ///   - [`store_image_task_results(Option<Vec<StoreImageTaskResult>>)`](crate::output::DescribeStoreImageTasksOutput::store_image_task_results): <p>The information about the AMI store tasks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStoreImageTasksOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeStoreImageTasksError>`](crate::error::DescribeStoreImageTasksError)
    pub fn describe_store_image_tasks(&self) -> fluent_builders::DescribeStoreImageTasks<C, M, R> {
        fluent_builders::DescribeStoreImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSubnets`](crate::client::fluent_builders::DescribeSubnets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSubnets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSubnets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSubnets::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>availability-zone</code> - The Availability Zone for the subnet. You can also use <code>availabilityZone</code> as the filter name.</p> </li>   <li> <p> <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use <code>availabilityZoneId</code> as the filter name.</p> </li>   <li> <p> <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.</p> </li>   <li> <p> <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the subnet's CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or <code>cidrBlock</code> as the filter names.</p> </li>   <li> <p> <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone (<code>true</code> | <code>false</code>). You can also use <code>defaultForAz</code> as the filter name.</p> </li>   <li> <p> <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.</p> </li>   <li> <p> <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated with the subnet.</p> </li>   <li> <p> <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.</p> </li>   <li> <p> <code>ipv6-native</code> - Indicates whether this is an IPv6 only subnet (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the subnet.</p> </li>   <li> <p> <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).</p> </li>   <li> <p> <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.</p> </li>   <li> <p> <code>subnet-id</code> - The ID of the subnet.</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC for the subnet.</p> </li>  </ul>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::DescribeSubnets::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSubnets::set_subnet_ids): <p>One or more subnet IDs.</p>  <p>Default: Describes all your subnets.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeSubnets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeSubnets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSubnets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSubnets::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeSubnets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeSubnets::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeSubnetsOutput`](crate::output::DescribeSubnetsOutput) with field(s):
    ///   - [`subnets(Option<Vec<Subnet>>)`](crate::output::DescribeSubnetsOutput::subnets): <p>Information about one or more subnets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSubnetsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeSubnetsError>`](crate::error::DescribeSubnetsError)
    pub fn describe_subnets(&self) -> fluent_builders::DescribeSubnets<C, M, R> {
        fluent_builders::DescribeSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTags::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTags::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTags::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTags::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>key</code> - The tag key.</p> </li>   <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li>   <li> <p> <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> | <code>host-reservation</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>key-pair</code> | <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> | <code>placement-group</code> | <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-endpoint</code> | <code>vpc-endpoint-service</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of the tag. For example, specify "tag:Owner" for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".    </key></p> </li>   <li> <p> <code>value</code> - The tag value.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTags::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTags::set_max_results): <p>The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_next_token): <p>The token to retrieve the next page of results.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTagsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`tags(Option<Vec<TagDescription>>)`](crate::output::DescribeTagsOutput::tags): <p>The tags.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrafficMirrorFilters`](crate::client::fluent_builders::DescribeTrafficMirrorFilters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_filter_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::traffic_mirror_filter_ids) / [`set_traffic_mirror_filter_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::set_traffic_mirror_filter_ids): <p>The ID of the Traffic Mirror filter.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>description</code>: The Traffic Mirror filter description.</p> </li>   <li> <p> <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeTrafficMirrorFiltersOutput`](crate::output::DescribeTrafficMirrorFiltersOutput) with field(s):
    ///   - [`traffic_mirror_filters(Option<Vec<TrafficMirrorFilter>>)`](crate::output::DescribeTrafficMirrorFiltersOutput::traffic_mirror_filters): <p>Information about one or more Traffic Mirror filters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTrafficMirrorFiltersOutput::next_token): <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTrafficMirrorFiltersError>`](crate::error::DescribeTrafficMirrorFiltersError)
    pub fn describe_traffic_mirror_filters(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorFilters<C, M, R> {
        fluent_builders::DescribeTrafficMirrorFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrafficMirrorSessions`](crate::client::fluent_builders::DescribeTrafficMirrorSessions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_session_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::traffic_mirror_session_ids) / [`set_traffic_mirror_session_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::set_traffic_mirror_session_ids): <p>The ID of the Traffic Mirror session.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>description</code>: The Traffic Mirror session description.</p> </li>   <li> <p> <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p> </li>   <li> <p> <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p> </li>   <li> <p> <code>packet-length</code>: The assigned number of packets to mirror. </p> </li>   <li> <p> <code>session-number</code>: The assigned session number. </p> </li>   <li> <p> <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p> </li>   <li> <p> <code>traffic-mirror-session-id</code>: The ID of the Traffic Mirror session.</p> </li>   <li> <p> <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p> </li>   <li> <p> <code>virtual-network-id</code>: The virtual network ID of the Traffic Mirror session.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeTrafficMirrorSessionsOutput`](crate::output::DescribeTrafficMirrorSessionsOutput) with field(s):
    ///   - [`traffic_mirror_sessions(Option<Vec<TrafficMirrorSession>>)`](crate::output::DescribeTrafficMirrorSessionsOutput::traffic_mirror_sessions): <p>Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTrafficMirrorSessionsOutput::next_token): <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTrafficMirrorSessionsError>`](crate::error::DescribeTrafficMirrorSessionsError)
    pub fn describe_traffic_mirror_sessions(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorSessions<C, M, R> {
        fluent_builders::DescribeTrafficMirrorSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrafficMirrorTargets`](crate::client::fluent_builders::DescribeTrafficMirrorTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_mirror_target_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::traffic_mirror_target_ids) / [`set_traffic_mirror_target_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::set_traffic_mirror_target_ids): <p>The ID of the Traffic Mirror targets.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>description</code>: The Traffic Mirror target description.</p> </li>   <li> <p> <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p> </li>   <li> <p> <code>network-load-balancer-arn</code>: The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the session.</p> </li>   <li> <p> <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p> </li>   <li> <p> <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`DescribeTrafficMirrorTargetsOutput`](crate::output::DescribeTrafficMirrorTargetsOutput) with field(s):
    ///   - [`traffic_mirror_targets(Option<Vec<TrafficMirrorTarget>>)`](crate::output::DescribeTrafficMirrorTargetsOutput::traffic_mirror_targets): <p>Information about one or more Traffic Mirror targets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTrafficMirrorTargetsOutput::next_token): <p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTrafficMirrorTargetsError>`](crate::error::DescribeTrafficMirrorTargetsError)
    pub fn describe_traffic_mirror_targets(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorTargets<C, M, R> {
        fluent_builders::DescribeTrafficMirrorTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayAttachments`](crate::client::fluent_builders::DescribeTransitGatewayAttachments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::transit_gateway_attachment_ids) / [`set_transit_gateway_attachment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::set_transit_gateway_attachment_ids): <p>The IDs of the attachments.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>association.state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li>   <li> <p> <code>association.transit-gateway-route-table-id</code> - The ID of the route table for the transit gateway.</p> </li>   <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li>   <li> <p> <code>resource-owner-id</code> - The ID of the Amazon Web Services account that owns the resource.</p> </li>   <li> <p> <code>resource-type</code> - The resource type. Valid values are <code>vpc</code> | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>peering</code> | <code>connect</code>.</p> </li>   <li> <p> <code>state</code> - The state of the attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.</p> </li>   <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>   <li> <p> <code>transit-gateway-owner-id</code> - The ID of the Amazon Web Services account that owns the transit gateway.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayAttachmentsOutput`](crate::output::DescribeTransitGatewayAttachmentsOutput) with field(s):
    ///   - [`transit_gateway_attachments(Option<Vec<TransitGatewayAttachment>>)`](crate::output::DescribeTransitGatewayAttachmentsOutput::transit_gateway_attachments): <p>Information about the attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayAttachmentsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayAttachmentsError>`](crate::error::DescribeTransitGatewayAttachmentsError)
    pub fn describe_transit_gateway_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayConnectPeers`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_connect_peer_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::transit_gateway_connect_peer_ids) / [`set_transit_gateway_connect_peer_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::set_transit_gateway_connect_peer_ids): <p>The IDs of the Connect peers.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>state</code> - The state of the Connect peer (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li>   <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li>   <li> <p> <code>transit-gateway-connect-peer-id</code> - The ID of the Connect peer.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayConnectPeersOutput`](crate::output::DescribeTransitGatewayConnectPeersOutput) with field(s):
    ///   - [`transit_gateway_connect_peers(Option<Vec<TransitGatewayConnectPeer>>)`](crate::output::DescribeTransitGatewayConnectPeersOutput::transit_gateway_connect_peers): <p>Information about the Connect peers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayConnectPeersOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayConnectPeersError>`](crate::error::DescribeTransitGatewayConnectPeersError)
    pub fn describe_transit_gateway_connect_peers(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayConnectPeers<C, M, R> {
        fluent_builders::DescribeTransitGatewayConnectPeers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayConnects`](crate::client::fluent_builders::DescribeTransitGatewayConnects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayConnects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::transit_gateway_attachment_ids) / [`set_transit_gateway_attachment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::set_transit_gateway_attachment_ids): <p>The IDs of the attachments.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>options.protocol</code> - The tunnel protocol (<code>gre</code>).</p> </li>   <li> <p> <code>state</code> - The state of the attachment (<code>initiating</code> | <code>initiatingRequest</code> | <code>pendingAcceptance</code> | <code>rollingBack</code> | <code>pending</code> | <code>available</code> | <code>modifying</code> | <code>deleting</code> | <code>deleted</code> | <code>failed</code> | <code>rejected</code> | <code>rejecting</code> | <code>failing</code>).</p> </li>   <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the Connect attachment.</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>   <li> <p> <code>transport-transit-gateway-attachment-id</code> - The ID of the transit gateway attachment from which the Connect attachment was created.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayConnects::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayConnectsOutput`](crate::output::DescribeTransitGatewayConnectsOutput) with field(s):
    ///   - [`transit_gateway_connects(Option<Vec<TransitGatewayConnect>>)`](crate::output::DescribeTransitGatewayConnectsOutput::transit_gateway_connects): <p>Information about the Connect attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayConnectsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayConnectsError>`](crate::error::DescribeTransitGatewayConnectsError)
    pub fn describe_transit_gateway_connects(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayConnects<C, M, R> {
        fluent_builders::DescribeTransitGatewayConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayMulticastDomains`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_multicast_domain_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::transit_gateway_multicast_domain_ids) / [`set_transit_gateway_multicast_domain_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::set_transit_gateway_multicast_domain_ids): <p>The ID of the transit gateway multicast domain.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>state</code> - The state of the transit gateway multicast domain. Valid values are <code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>.</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>   <li> <p> <code>transit-gateway-multicast-domain-id</code> - The ID of the transit gateway multicast domain.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayMulticastDomainsOutput`](crate::output::DescribeTransitGatewayMulticastDomainsOutput) with field(s):
    ///   - [`transit_gateway_multicast_domains(Option<Vec<TransitGatewayMulticastDomain>>)`](crate::output::DescribeTransitGatewayMulticastDomainsOutput::transit_gateway_multicast_domains): <p>Information about the transit gateway multicast domains.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayMulticastDomainsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayMulticastDomainsError>`](crate::error::DescribeTransitGatewayMulticastDomainsError)
    pub fn describe_transit_gateway_multicast_domains(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayMulticastDomains<C, M, R> {
        fluent_builders::DescribeTransitGatewayMulticastDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayPeeringAttachments`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::transit_gateway_attachment_ids) / [`set_transit_gateway_attachment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::set_transit_gateway_attachment_ids): <p>One or more IDs of the transit gateway peering attachments.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the transit gateway attachment.</p> </li>   <li> <p> <code>local-owner-id</code> - The ID of your Amazon Web Services account.</p> </li>   <li> <p> <code>remote-owner-id</code> - The ID of the Amazon Web Services account in the remote Region that owns the transit gateway.</p> </li>   <li> <p> <code>state</code> - The state of the peering attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayPeeringAttachmentsOutput`](crate::output::DescribeTransitGatewayPeeringAttachmentsOutput) with field(s):
    ///   - [`transit_gateway_peering_attachments(Option<Vec<TransitGatewayPeeringAttachment>>)`](crate::output::DescribeTransitGatewayPeeringAttachmentsOutput::transit_gateway_peering_attachments): <p>The transit gateway peering attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayPeeringAttachmentsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayPeeringAttachmentsError>`](crate::error::DescribeTransitGatewayPeeringAttachmentsError)
    pub fn describe_transit_gateway_peering_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayPeeringAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayPeeringAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayRouteTables`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_route_table_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::transit_gateway_route_table_ids) / [`set_transit_gateway_route_table_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::set_transit_gateway_route_table_ids): <p>The IDs of the transit gateway route tables.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>default-association-route-table</code> - Indicates whether this is the default association route table for the transit gateway (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table for the transit gateway (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>state</code> - The state of the route table (<code>available</code> | <code>deleting</code> | <code>deleted</code> | <code>pending</code>).</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>   <li> <p> <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayRouteTablesOutput`](crate::output::DescribeTransitGatewayRouteTablesOutput) with field(s):
    ///   - [`transit_gateway_route_tables(Option<Vec<TransitGatewayRouteTable>>)`](crate::output::DescribeTransitGatewayRouteTablesOutput::transit_gateway_route_tables): <p>Information about the transit gateway route tables.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayRouteTablesOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayRouteTablesError>`](crate::error::DescribeTransitGatewayRouteTablesError)
    pub fn describe_transit_gateway_route_tables(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayRouteTables<C, M, R> {
        fluent_builders::DescribeTransitGatewayRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGateways`](crate::client::fluent_builders::DescribeTransitGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGateways::transit_gateway_ids) / [`set_transit_gateway_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGateways::set_transit_gateway_ids): <p>The IDs of the transit gateways.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGateways::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGateways::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>options.propagation-default-route-table-id</code> - The ID of the default propagation route table.</p> </li>   <li> <p> <code>options.amazon-side-asn</code> - The private ASN for the Amazon side of a BGP session.</p> </li>   <li> <p> <code>options.association-default-route-table-id</code> - The ID of the default association route table.</p> </li>   <li> <p> <code>options.auto-accept-shared-attachments</code> - Indicates whether there is automatic acceptance of attachment requests (<code>enable</code> | <code>disable</code>).</p> </li>   <li> <p> <code>options.default-route-table-association</code> - Indicates whether resource attachments are automatically associated with the default association route table (<code>enable</code> | <code>disable</code>).</p> </li>   <li> <p> <code>options.default-route-table-propagation</code> - Indicates whether resource attachments automatically propagate routes to the default propagation route table (<code>enable</code> | <code>disable</code>).</p> </li>   <li> <p> <code>options.dns-support</code> - Indicates whether DNS support is enabled (<code>enable</code> | <code>disable</code>).</p> </li>   <li> <p> <code>options.vpn-ecmp-support</code> - Indicates whether Equal Cost Multipath Protocol support is enabled (<code>enable</code> | <code>disable</code>).</p> </li>   <li> <p> <code>owner-id</code> - The ID of the Amazon Web Services account that owns the transit gateway.</p> </li>   <li> <p> <code>state</code> - The state of the transit gateway (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>modifying</code> | <code>pending</code>).</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGateways::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGateways::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGateways::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGateways::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGateways::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewaysOutput`](crate::output::DescribeTransitGatewaysOutput) with field(s):
    ///   - [`transit_gateways(Option<Vec<TransitGateway>>)`](crate::output::DescribeTransitGatewaysOutput::transit_gateways): <p>Information about the transit gateways.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewaysOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewaysError>`](crate::error::DescribeTransitGatewaysError)
    pub fn describe_transit_gateways(&self) -> fluent_builders::DescribeTransitGateways<C, M, R> {
        fluent_builders::DescribeTransitGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTransitGatewayVpcAttachments`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`transit_gateway_attachment_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::transit_gateway_attachment_ids) / [`set_transit_gateway_attachment_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::set_transit_gateway_attachment_ids): <p>The IDs of the attachments.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::set_filters): <p>One or more filters. The possible values are:</p>  <ul>   <li> <p> <code>state</code> - The state of the attachment. Valid values are <code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>failing</code> | <code>initiatingRequest</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>.</p> </li>   <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li>   <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li>   <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeTransitGatewayVpcAttachmentsOutput`](crate::output::DescribeTransitGatewayVpcAttachmentsOutput) with field(s):
    ///   - [`transit_gateway_vpc_attachments(Option<Vec<TransitGatewayVpcAttachment>>)`](crate::output::DescribeTransitGatewayVpcAttachmentsOutput::transit_gateway_vpc_attachments): <p>Information about the VPC attachments.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTransitGatewayVpcAttachmentsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTransitGatewayVpcAttachmentsError>`](crate::error::DescribeTransitGatewayVpcAttachmentsError)
    pub fn describe_transit_gateway_vpc_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayVpcAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayVpcAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTrunkInterfaceAssociations`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`association_ids(Vec<String>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::association_ids) / [`set_association_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::set_association_ids): <p>The IDs of the associations.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::set_filters): <p>One or more filters.</p>  <ul>   <li> <p> <code>gre-key</code> - The ID of a trunk interface association.</p> </li>   <li> <p> <code>interface-protocol</code> - The interface protocol. Valid values are <code>VLAN</code> and <code>GRE</code>.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::set_next_token): <p>The token for the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    /// - On success, responds with [`DescribeTrunkInterfaceAssociationsOutput`](crate::output::DescribeTrunkInterfaceAssociationsOutput) with field(s):
    ///   - [`interface_associations(Option<Vec<TrunkInterfaceAssociation>>)`](crate::output::DescribeTrunkInterfaceAssociationsOutput::interface_associations): <p>Information about the trunk associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTrunkInterfaceAssociationsOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeTrunkInterfaceAssociationsError>`](crate::error::DescribeTrunkInterfaceAssociationsError)
    pub fn describe_trunk_interface_associations(
        &self,
    ) -> fluent_builders::DescribeTrunkInterfaceAssociations<C, M, R> {
        fluent_builders::DescribeTrunkInterfaceAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVolumeAttribute`](crate::client::fluent_builders::DescribeVolumeAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(VolumeAttributeName)`](crate::client::fluent_builders::DescribeVolumeAttribute::attribute) / [`set_attribute(Option<VolumeAttributeName>)`](crate::client::fluent_builders::DescribeVolumeAttribute::set_attribute): <p>The attribute of the volume. This parameter is required.</p>
    ///   - [`volume_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVolumeAttribute::volume_id) / [`set_volume_id(Option<String>)`](crate::client::fluent_builders::DescribeVolumeAttribute::set_volume_id): <p>The ID of the volume.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeVolumeAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeVolumeAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeVolumeAttributeOutput`](crate::output::DescribeVolumeAttributeOutput) with field(s):
    ///   - [`auto_enable_io(Option<AttributeBooleanValue>)`](crate::output::DescribeVolumeAttributeOutput::auto_enable_io): <p>The state of <code>autoEnableIO</code> attribute.</p>
    ///   - [`product_codes(Option<Vec<ProductCode>>)`](crate::output::DescribeVolumeAttributeOutput::product_codes): <p>A list of product codes.</p>
    ///   - [`volume_id(Option<String>)`](crate::output::DescribeVolumeAttributeOutput::volume_id): <p>The ID of the volume.</p>
    /// - On failure, responds with [`SdkError<DescribeVolumeAttributeError>`](crate::error::DescribeVolumeAttributeError)
    pub fn describe_volume_attribute(&self) -> fluent_builders::DescribeVolumeAttribute<C, M, R> {
        fluent_builders::DescribeVolumeAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVolumes`](crate::client::fluent_builders::DescribeVolumes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeVolumes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeVolumes::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>attachment.attach-time</code> - The time stamp when the attachment initiated.</p> </li>   <li> <p> <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.</p> </li>   <li> <p> <code>attachment.device</code> - The device name specified in the block device mapping (for example, <code>/dev/sda1</code>).</p> </li>   <li> <p> <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.</p> </li>   <li> <p> <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> | <code>detaching</code>).</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone in which the volume was created.</p> </li>   <li> <p> <code>create-time</code> - The time stamp when the volume was created.</p> </li>   <li> <p> <code>encrypted</code> - Indicates whether the volume is encrypted (<code>true</code> | <code>false</code>)</p> </li>   <li> <p> <code>multi-attach-enabled</code> - Indicates whether the volume is enabled for Multi-Attach (<code>true</code> | <code>false</code>)</p> </li>   <li> <p> <code>fast-restored</code> - Indicates whether the volume was created from a snapshot that is enabled for fast snapshot restore (<code>true</code> | <code>false</code>).</p> </li>   <li> <p> <code>size</code> - The size of the volume, in GiB.</p> </li>   <li> <p> <code>snapshot-id</code> - The snapshot from which the volume was created.</p> </li>   <li> <p> <code>status</code> - The state of the volume (<code>creating</code> | <code>available</code> | <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).</p> </li>   <li> <p> <code>tag</code>:<key>      - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key      <code>Owner</code> and the value      <code>TeamA</code>, specify      <code>tag:Owner</code> for the filter name and      <code>TeamA</code> for the filter value.    </key></p> </li>   <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li>   <li> <p> <code>volume-id</code> - The volume ID.</p> </li>   <li> <p> <code>volume-type</code> - The Amazon EBS volume type (<code>gp2</code> | <code>gp3</code> | <code>io1</code> | <code>io2</code> | <code>st1</code> | <code>sc1</code>| <code>standard</code>)</p> </li>  </ul>
    ///   - [`volume_ids(Vec<String>)`](crate::client::fluent_builders::DescribeVolumes::volume_ids) / [`set_volume_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeVolumes::set_volume_ids): <p>The volume IDs.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeVolumes::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeVolumes::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeVolumes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeVolumes::set_max_results): <p>The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500 results are returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVolumes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVolumes::set_next_token): <p>The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code> when there are no more results to return.</p>
    /// - On success, responds with [`DescribeVolumesOutput`](crate::output::DescribeVolumesOutput) with field(s):
    ///   - [`volumes(Option<Vec<Volume>>)`](crate::output::DescribeVolumesOutput::volumes): <p>Information about the volumes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVolumesOutput::next_token): <p>The <code>NextToken</code> value to include in a future <code>DescribeVolumes</code> request. When the results of a <code>DescribeVolumes</code> request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeVolumesError>`](crate::error::DescribeVolumesError)
    pub fn describe_volumes(&self) -> fluent_builders::DescribeVolumes<C, M, R> {
        fluent_builders::DescribeVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVolumesModifications`](crate::client::fluent_builders::DescribeVolumesModifications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumesModifications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeVolumesModifications::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeVolumesModifications::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    ///   - [`volume_ids(Vec<String>)`](crate::client::fluent_builders::DescribeVolumesModifications::volume_ids) / [`set_volume_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeVolumesModifications::set_volume_ids): <p>The IDs of the volumes.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeVolumesModifications::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeVolumesModifications::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>modification-state</code> - The current modification state (modifying | optimizing | completed | failed).</p> </li>   <li> <p> <code>original-iops</code> - The original IOPS rate of the volume.</p> </li>   <li> <p> <code>original-size</code> - The original size of the volume, in GiB.</p> </li>   <li> <p> <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | io2 | gp2 | sc1 | st1).</p> </li>   <li> <p> <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).</p> </li>   <li> <p> <code>start-time</code> - The modification start time.</p> </li>   <li> <p> <code>target-iops</code> - The target IOPS rate of the volume.</p> </li>   <li> <p> <code>target-size</code> - The target size of the volume, in GiB.</p> </li>   <li> <p> <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1 | st1).</p> </li>   <li> <p> <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true | false).</p> </li>   <li> <p> <code>volume-id</code> - The ID of the volume.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVolumesModifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVolumesModifications::set_next_token): <p>The <code>nextToken</code> value returned by a previous paginated request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeVolumesModifications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeVolumesModifications::set_max_results): <p>The maximum number of results (up to a limit of 500) to be returned in a paginated request.</p>
    /// - On success, responds with [`DescribeVolumesModificationsOutput`](crate::output::DescribeVolumesModificationsOutput) with field(s):
    ///   - [`volumes_modifications(Option<Vec<VolumeModification>>)`](crate::output::DescribeVolumesModificationsOutput::volumes_modifications): <p>Information about the volume modifications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVolumesModificationsOutput::next_token): <p>Token for pagination, null if there are no more results </p>
    /// - On failure, responds with [`SdkError<DescribeVolumesModificationsError>`](crate::error::DescribeVolumesModificationsError)
    pub fn describe_volumes_modifications(
        &self,
    ) -> fluent_builders::DescribeVolumesModifications<C, M, R> {
        fluent_builders::DescribeVolumesModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVolumeStatus`](crate::client::fluent_builders::DescribeVolumeStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumeStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeVolumeStatus::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeVolumeStatus::set_filters): <p>The filters.</p>  <ul>   <li> <p> <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).</p> </li>   <li> <p> <code>action.description</code> - A description of the action.</p> </li>   <li> <p> <code>action.event-id</code> - The event ID associated with the action.</p> </li>   <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li>   <li> <p> <code>event.description</code> - A description of the event.</p> </li>   <li> <p> <code>event.event-id</code> - The event ID.</p> </li>   <li> <p> <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> | <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).</p> </li>   <li> <p> <code>event.not-after</code> - The latest end time for the event.</p> </li>   <li> <p> <code>event.not-before</code> - The earliest start time for the event.</p> </li>   <li> <p> <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (<code>io-enabled</code> | <code>io-performance</code>).</p> </li>   <li> <p> <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).</p> </li>   <li> <p> <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> | <code>warning</code> | <code>insufficient-data</code>).</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeVolumeStatus::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeVolumeStatus::set_max_results): <p>The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When this parameter is used, the request only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned. If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeVolumeStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeVolumeStatus::set_next_token): <p>The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`volume_ids(Vec<String>)`](crate::client::fluent_builders::DescribeVolumeStatus::volume_ids) / [`set_volume_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeVolumeStatus::set_volume_ids): <p>The IDs of the volumes.</p>  <p>Default: Describes all your volumes.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeVolumeStatus::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeVolumeStatus::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeVolumeStatusOutput`](crate::output::DescribeVolumeStatusOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeVolumeStatusOutput::next_token): <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`volume_statuses(Option<Vec<VolumeStatusItem>>)`](crate::output::DescribeVolumeStatusOutput::volume_statuses): <p>Information about the status of the volumes.</p>
    /// - On failure, responds with [`SdkError<DescribeVolumeStatusError>`](crate::error::DescribeVolumeStatusError)
    pub fn describe_volume_status(&self) -> fluent_builders::DescribeVolumeStatus<C, M, R> {
        fluent_builders::DescribeVolumeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVpcAttribute`](crate::client::fluent_builders::DescribeVpcAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(VpcAttributeName)`](crate::client::fluent_builders::DescribeVpcAttribute::attribute) / [`set_attribute(Option<VpcAttributeName>)`](crate::client::fluent_builders::DescribeVpcAttribute::set_attribute): <p>The VPC attribute.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVpcAttribute::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::DescribeVpcAttribute::set_vpc_id): <p>The ID of the VPC.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::DescribeVpcAttribute::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::DescribeVpcAttribute::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
    /// - On success, responds with [`DescribeVpcAttributeOutput`](crate::output::DescribeVpcAttributeOutput) with field(s):
    ///   - [`vpc_id(Option<String>)`](crate::output::DescribeVpcAttributeOutput::vpc_id): <p>The ID of the VPC.</p>
    ///   - [`enable_dns_hostnames(Op