// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elastic Compute Cloud
///
/// Client for invoking operations on Amazon Elastic Compute Cloud. Each operation on Amazon Elastic Compute Cloud is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ec2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ec2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ec2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptReservedInstancesExchangeQuote` operation.
    ///
    /// See [`AcceptReservedInstancesExchangeQuote`](crate::client::fluent_builders::AcceptReservedInstancesExchangeQuote) for more information about the
    /// operation and its arguments.
    pub fn accept_reserved_instances_exchange_quote(
        &self,
    ) -> fluent_builders::AcceptReservedInstancesExchangeQuote<C, M, R> {
        fluent_builders::AcceptReservedInstancesExchangeQuote::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcceptTransitGatewayMulticastDomainAssociations` operation.
    ///
    /// See [`AcceptTransitGatewayMulticastDomainAssociations`](crate::client::fluent_builders::AcceptTransitGatewayMulticastDomainAssociations) for more information about the
    /// operation and its arguments.
    pub fn accept_transit_gateway_multicast_domain_associations(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayMulticastDomainAssociations<C, M, R> {
        fluent_builders::AcceptTransitGatewayMulticastDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcceptTransitGatewayPeeringAttachment` operation.
    ///
    /// See [`AcceptTransitGatewayPeeringAttachment`](crate::client::fluent_builders::AcceptTransitGatewayPeeringAttachment) for more information about the
    /// operation and its arguments.
    pub fn accept_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::AcceptTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcceptTransitGatewayVpcAttachment` operation.
    ///
    /// See [`AcceptTransitGatewayVpcAttachment`](crate::client::fluent_builders::AcceptTransitGatewayVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn accept_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::AcceptTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::AcceptTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcceptVpcEndpointConnections` operation.
    ///
    /// See [`AcceptVpcEndpointConnections`](crate::client::fluent_builders::AcceptVpcEndpointConnections) for more information about the
    /// operation and its arguments.
    pub fn accept_vpc_endpoint_connections(
        &self,
    ) -> fluent_builders::AcceptVpcEndpointConnections<C, M, R> {
        fluent_builders::AcceptVpcEndpointConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AcceptVpcPeeringConnection` operation.
    ///
    /// See [`AcceptVpcPeeringConnection`](crate::client::fluent_builders::AcceptVpcPeeringConnection) for more information about the
    /// operation and its arguments.
    pub fn accept_vpc_peering_connection(
        &self,
    ) -> fluent_builders::AcceptVpcPeeringConnection<C, M, R> {
        fluent_builders::AcceptVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AdvertiseByoipCidr` operation.
    ///
    /// See [`AdvertiseByoipCidr`](crate::client::fluent_builders::AdvertiseByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn advertise_byoip_cidr(&self) -> fluent_builders::AdvertiseByoipCidr<C, M, R> {
        fluent_builders::AdvertiseByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateAddress` operation.
    ///
    /// See [`AllocateAddress`](crate::client::fluent_builders::AllocateAddress) for more information about the
    /// operation and its arguments.
    pub fn allocate_address(&self) -> fluent_builders::AllocateAddress<C, M, R> {
        fluent_builders::AllocateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateHosts` operation.
    ///
    /// See [`AllocateHosts`](crate::client::fluent_builders::AllocateHosts) for more information about the
    /// operation and its arguments.
    pub fn allocate_hosts(&self) -> fluent_builders::AllocateHosts<C, M, R> {
        fluent_builders::AllocateHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllocateIpamPoolCidr` operation.
    ///
    /// See [`AllocateIpamPoolCidr`](crate::client::fluent_builders::AllocateIpamPoolCidr) for more information about the
    /// operation and its arguments.
    pub fn allocate_ipam_pool_cidr(&self) -> fluent_builders::AllocateIpamPoolCidr<C, M, R> {
        fluent_builders::AllocateIpamPoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplySecurityGroupsToClientVpnTargetNetwork` operation.
    ///
    /// See [`ApplySecurityGroupsToClientVpnTargetNetwork`](crate::client::fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork) for more information about the
    /// operation and its arguments.
    pub fn apply_security_groups_to_client_vpn_target_network(
        &self,
    ) -> fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork<C, M, R> {
        fluent_builders::ApplySecurityGroupsToClientVpnTargetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssignIpv6Addresses` operation.
    ///
    /// See [`AssignIpv6Addresses`](crate::client::fluent_builders::AssignIpv6Addresses) for more information about the
    /// operation and its arguments.
    pub fn assign_ipv6_addresses(&self) -> fluent_builders::AssignIpv6Addresses<C, M, R> {
        fluent_builders::AssignIpv6Addresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssignPrivateIpAddresses` operation.
    ///
    /// See [`AssignPrivateIpAddresses`](crate::client::fluent_builders::AssignPrivateIpAddresses) for more information about the
    /// operation and its arguments.
    pub fn assign_private_ip_addresses(
        &self,
    ) -> fluent_builders::AssignPrivateIpAddresses<C, M, R> {
        fluent_builders::AssignPrivateIpAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateAddress` operation.
    ///
    /// See [`AssociateAddress`](crate::client::fluent_builders::AssociateAddress) for more information about the
    /// operation and its arguments.
    pub fn associate_address(&self) -> fluent_builders::AssociateAddress<C, M, R> {
        fluent_builders::AssociateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateClientVpnTargetNetwork` operation.
    ///
    /// See [`AssociateClientVpnTargetNetwork`](crate::client::fluent_builders::AssociateClientVpnTargetNetwork) for more information about the
    /// operation and its arguments.
    pub fn associate_client_vpn_target_network(
        &self,
    ) -> fluent_builders::AssociateClientVpnTargetNetwork<C, M, R> {
        fluent_builders::AssociateClientVpnTargetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDhcpOptions` operation.
    ///
    /// See [`AssociateDhcpOptions`](crate::client::fluent_builders::AssociateDhcpOptions) for more information about the
    /// operation and its arguments.
    pub fn associate_dhcp_options(&self) -> fluent_builders::AssociateDhcpOptions<C, M, R> {
        fluent_builders::AssociateDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateEnclaveCertificateIamRole` operation.
    ///
    /// See [`AssociateEnclaveCertificateIamRole`](crate::client::fluent_builders::AssociateEnclaveCertificateIamRole) for more information about the
    /// operation and its arguments.
    pub fn associate_enclave_certificate_iam_role(
        &self,
    ) -> fluent_builders::AssociateEnclaveCertificateIamRole<C, M, R> {
        fluent_builders::AssociateEnclaveCertificateIamRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateIamInstanceProfile` operation.
    ///
    /// See [`AssociateIamInstanceProfile`](crate::client::fluent_builders::AssociateIamInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn associate_iam_instance_profile(
        &self,
    ) -> fluent_builders::AssociateIamInstanceProfile<C, M, R> {
        fluent_builders::AssociateIamInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateInstanceEventWindow` operation.
    ///
    /// See [`AssociateInstanceEventWindow`](crate::client::fluent_builders::AssociateInstanceEventWindow) for more information about the
    /// operation and its arguments.
    pub fn associate_instance_event_window(
        &self,
    ) -> fluent_builders::AssociateInstanceEventWindow<C, M, R> {
        fluent_builders::AssociateInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateRouteTable` operation.
    ///
    /// See [`AssociateRouteTable`](crate::client::fluent_builders::AssociateRouteTable) for more information about the
    /// operation and its arguments.
    pub fn associate_route_table(&self) -> fluent_builders::AssociateRouteTable<C, M, R> {
        fluent_builders::AssociateRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSubnetCidrBlock` operation.
    ///
    /// See [`AssociateSubnetCidrBlock`](crate::client::fluent_builders::AssociateSubnetCidrBlock) for more information about the
    /// operation and its arguments.
    pub fn associate_subnet_cidr_block(
        &self,
    ) -> fluent_builders::AssociateSubnetCidrBlock<C, M, R> {
        fluent_builders::AssociateSubnetCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTransitGatewayMulticastDomain` operation.
    ///
    /// See [`AssociateTransitGatewayMulticastDomain`](crate::client::fluent_builders::AssociateTransitGatewayMulticastDomain) for more information about the
    /// operation and its arguments.
    pub fn associate_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::AssociateTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTransitGatewayRouteTable` operation.
    ///
    /// See [`AssociateTransitGatewayRouteTable`](crate::client::fluent_builders::AssociateTransitGatewayRouteTable) for more information about the
    /// operation and its arguments.
    pub fn associate_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::AssociateTransitGatewayRouteTable<C, M, R> {
        fluent_builders::AssociateTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTrunkInterface` operation.
    ///
    /// See [`AssociateTrunkInterface`](crate::client::fluent_builders::AssociateTrunkInterface) for more information about the
    /// operation and its arguments.
    pub fn associate_trunk_interface(&self) -> fluent_builders::AssociateTrunkInterface<C, M, R> {
        fluent_builders::AssociateTrunkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateVpcCidrBlock` operation.
    ///
    /// See [`AssociateVpcCidrBlock`](crate::client::fluent_builders::AssociateVpcCidrBlock) for more information about the
    /// operation and its arguments.
    pub fn associate_vpc_cidr_block(&self) -> fluent_builders::AssociateVpcCidrBlock<C, M, R> {
        fluent_builders::AssociateVpcCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachClassicLinkVpc` operation.
    ///
    /// See [`AttachClassicLinkVpc`](crate::client::fluent_builders::AttachClassicLinkVpc) for more information about the
    /// operation and its arguments.
    pub fn attach_classic_link_vpc(&self) -> fluent_builders::AttachClassicLinkVpc<C, M, R> {
        fluent_builders::AttachClassicLinkVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachInternetGateway` operation.
    ///
    /// See [`AttachInternetGateway`](crate::client::fluent_builders::AttachInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn attach_internet_gateway(&self) -> fluent_builders::AttachInternetGateway<C, M, R> {
        fluent_builders::AttachInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachNetworkInterface` operation.
    ///
    /// See [`AttachNetworkInterface`](crate::client::fluent_builders::AttachNetworkInterface) for more information about the
    /// operation and its arguments.
    pub fn attach_network_interface(&self) -> fluent_builders::AttachNetworkInterface<C, M, R> {
        fluent_builders::AttachNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachVolume` operation.
    ///
    /// See [`AttachVolume`](crate::client::fluent_builders::AttachVolume) for more information about the
    /// operation and its arguments.
    pub fn attach_volume(&self) -> fluent_builders::AttachVolume<C, M, R> {
        fluent_builders::AttachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachVpnGateway` operation.
    ///
    /// See [`AttachVpnGateway`](crate::client::fluent_builders::AttachVpnGateway) for more information about the
    /// operation and its arguments.
    pub fn attach_vpn_gateway(&self) -> fluent_builders::AttachVpnGateway<C, M, R> {
        fluent_builders::AttachVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeClientVpnIngress` operation.
    ///
    /// See [`AuthorizeClientVpnIngress`](crate::client::fluent_builders::AuthorizeClientVpnIngress) for more information about the
    /// operation and its arguments.
    pub fn authorize_client_vpn_ingress(
        &self,
    ) -> fluent_builders::AuthorizeClientVpnIngress<C, M, R> {
        fluent_builders::AuthorizeClientVpnIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeSecurityGroupEgress` operation.
    ///
    /// See [`AuthorizeSecurityGroupEgress`](crate::client::fluent_builders::AuthorizeSecurityGroupEgress) for more information about the
    /// operation and its arguments.
    pub fn authorize_security_group_egress(
        &self,
    ) -> fluent_builders::AuthorizeSecurityGroupEgress<C, M, R> {
        fluent_builders::AuthorizeSecurityGroupEgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeSecurityGroupIngress` operation.
    ///
    /// See [`AuthorizeSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn authorize_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeSecurityGroupIngress<C, M, R> {
        fluent_builders::AuthorizeSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BundleInstance` operation.
    ///
    /// See [`BundleInstance`](crate::client::fluent_builders::BundleInstance) for more information about the
    /// operation and its arguments.
    pub fn bundle_instance(&self) -> fluent_builders::BundleInstance<C, M, R> {
        fluent_builders::BundleInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelBundleTask` operation.
    ///
    /// See [`CancelBundleTask`](crate::client::fluent_builders::CancelBundleTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_bundle_task(&self) -> fluent_builders::CancelBundleTask<C, M, R> {
        fluent_builders::CancelBundleTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelCapacityReservation` operation.
    ///
    /// See [`CancelCapacityReservation`](crate::client::fluent_builders::CancelCapacityReservation) for more information about the
    /// operation and its arguments.
    pub fn cancel_capacity_reservation(
        &self,
    ) -> fluent_builders::CancelCapacityReservation<C, M, R> {
        fluent_builders::CancelCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelCapacityReservationFleets` operation.
    ///
    /// See [`CancelCapacityReservationFleets`](crate::client::fluent_builders::CancelCapacityReservationFleets) for more information about the
    /// operation and its arguments.
    pub fn cancel_capacity_reservation_fleets(
        &self,
    ) -> fluent_builders::CancelCapacityReservationFleets<C, M, R> {
        fluent_builders::CancelCapacityReservationFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelConversionTask` operation.
    ///
    /// See [`CancelConversionTask`](crate::client::fluent_builders::CancelConversionTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_conversion_task(&self) -> fluent_builders::CancelConversionTask<C, M, R> {
        fluent_builders::CancelConversionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelExportTask` operation.
    ///
    /// See [`CancelExportTask`](crate::client::fluent_builders::CancelExportTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_export_task(&self) -> fluent_builders::CancelExportTask<C, M, R> {
        fluent_builders::CancelExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelImportTask` operation.
    ///
    /// See [`CancelImportTask`](crate::client::fluent_builders::CancelImportTask) for more information about the
    /// operation and its arguments.
    pub fn cancel_import_task(&self) -> fluent_builders::CancelImportTask<C, M, R> {
        fluent_builders::CancelImportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelReservedInstancesListing` operation.
    ///
    /// See [`CancelReservedInstancesListing`](crate::client::fluent_builders::CancelReservedInstancesListing) for more information about the
    /// operation and its arguments.
    pub fn cancel_reserved_instances_listing(
        &self,
    ) -> fluent_builders::CancelReservedInstancesListing<C, M, R> {
        fluent_builders::CancelReservedInstancesListing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSpotFleetRequests` operation.
    ///
    /// See [`CancelSpotFleetRequests`](crate::client::fluent_builders::CancelSpotFleetRequests) for more information about the
    /// operation and its arguments.
    pub fn cancel_spot_fleet_requests(&self) -> fluent_builders::CancelSpotFleetRequests<C, M, R> {
        fluent_builders::CancelSpotFleetRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSpotInstanceRequests` operation.
    ///
    /// See [`CancelSpotInstanceRequests`](crate::client::fluent_builders::CancelSpotInstanceRequests) for more information about the
    /// operation and its arguments.
    pub fn cancel_spot_instance_requests(
        &self,
    ) -> fluent_builders::CancelSpotInstanceRequests<C, M, R> {
        fluent_builders::CancelSpotInstanceRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ConfirmProductInstance` operation.
    ///
    /// See [`ConfirmProductInstance`](crate::client::fluent_builders::ConfirmProductInstance) for more information about the
    /// operation and its arguments.
    pub fn confirm_product_instance(&self) -> fluent_builders::ConfirmProductInstance<C, M, R> {
        fluent_builders::ConfirmProductInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyFpgaImage` operation.
    ///
    /// See [`CopyFpgaImage`](crate::client::fluent_builders::CopyFpgaImage) for more information about the
    /// operation and its arguments.
    pub fn copy_fpga_image(&self) -> fluent_builders::CopyFpgaImage<C, M, R> {
        fluent_builders::CopyFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyImage` operation.
    ///
    /// See [`CopyImage`](crate::client::fluent_builders::CopyImage) for more information about the
    /// operation and its arguments.
    pub fn copy_image(&self) -> fluent_builders::CopyImage<C, M, R> {
        fluent_builders::CopyImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopySnapshot` operation.
    ///
    /// See [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot<C, M, R> {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCapacityReservation` operation.
    ///
    /// See [`CreateCapacityReservation`](crate::client::fluent_builders::CreateCapacityReservation) for more information about the
    /// operation and its arguments.
    pub fn create_capacity_reservation(
        &self,
    ) -> fluent_builders::CreateCapacityReservation<C, M, R> {
        fluent_builders::CreateCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCapacityReservationFleet` operation.
    ///
    /// See [`CreateCapacityReservationFleet`](crate::client::fluent_builders::CreateCapacityReservationFleet) for more information about the
    /// operation and its arguments.
    pub fn create_capacity_reservation_fleet(
        &self,
    ) -> fluent_builders::CreateCapacityReservationFleet<C, M, R> {
        fluent_builders::CreateCapacityReservationFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCarrierGateway` operation.
    ///
    /// See [`CreateCarrierGateway`](crate::client::fluent_builders::CreateCarrierGateway) for more information about the
    /// operation and its arguments.
    pub fn create_carrier_gateway(&self) -> fluent_builders::CreateCarrierGateway<C, M, R> {
        fluent_builders::CreateCarrierGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClientVpnEndpoint` operation.
    ///
    /// See [`CreateClientVpnEndpoint`](crate::client::fluent_builders::CreateClientVpnEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_client_vpn_endpoint(&self) -> fluent_builders::CreateClientVpnEndpoint<C, M, R> {
        fluent_builders::CreateClientVpnEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClientVpnRoute` operation.
    ///
    /// See [`CreateClientVpnRoute`](crate::client::fluent_builders::CreateClientVpnRoute) for more information about the
    /// operation and its arguments.
    pub fn create_client_vpn_route(&self) -> fluent_builders::CreateClientVpnRoute<C, M, R> {
        fluent_builders::CreateClientVpnRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomerGateway` operation.
    ///
    /// See [`CreateCustomerGateway`](crate::client::fluent_builders::CreateCustomerGateway) for more information about the
    /// operation and its arguments.
    pub fn create_customer_gateway(&self) -> fluent_builders::CreateCustomerGateway<C, M, R> {
        fluent_builders::CreateCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDefaultSubnet` operation.
    ///
    /// See [`CreateDefaultSubnet`](crate::client::fluent_builders::CreateDefaultSubnet) for more information about the
    /// operation and its arguments.
    pub fn create_default_subnet(&self) -> fluent_builders::CreateDefaultSubnet<C, M, R> {
        fluent_builders::CreateDefaultSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDefaultVpc` operation.
    ///
    /// See [`CreateDefaultVpc`](crate::client::fluent_builders::CreateDefaultVpc) for more information about the
    /// operation and its arguments.
    pub fn create_default_vpc(&self) -> fluent_builders::CreateDefaultVpc<C, M, R> {
        fluent_builders::CreateDefaultVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDhcpOptions` operation.
    ///
    /// See [`CreateDhcpOptions`](crate::client::fluent_builders::CreateDhcpOptions) for more information about the
    /// operation and its arguments.
    pub fn create_dhcp_options(&self) -> fluent_builders::CreateDhcpOptions<C, M, R> {
        fluent_builders::CreateDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEgressOnlyInternetGateway` operation.
    ///
    /// See [`CreateEgressOnlyInternetGateway`](crate::client::fluent_builders::CreateEgressOnlyInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn create_egress_only_internet_gateway(
        &self,
    ) -> fluent_builders::CreateEgressOnlyInternetGateway<C, M, R> {
        fluent_builders::CreateEgressOnlyInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFleet` operation.
    ///
    /// See [`CreateFleet`](crate::client::fluent_builders::CreateFleet) for more information about the
    /// operation and its arguments.
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFlowLogs` operation.
    ///
    /// See [`CreateFlowLogs`](crate::client::fluent_builders::CreateFlowLogs) for more information about the
    /// operation and its arguments.
    pub fn create_flow_logs(&self) -> fluent_builders::CreateFlowLogs<C, M, R> {
        fluent_builders::CreateFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFpgaImage` operation.
    ///
    /// See [`CreateFpgaImage`](crate::client::fluent_builders::CreateFpgaImage) for more information about the
    /// operation and its arguments.
    pub fn create_fpga_image(&self) -> fluent_builders::CreateFpgaImage<C, M, R> {
        fluent_builders::CreateFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImage` operation.
    ///
    /// See [`CreateImage`](crate::client::fluent_builders::CreateImage) for more information about the
    /// operation and its arguments.
    pub fn create_image(&self) -> fluent_builders::CreateImage<C, M, R> {
        fluent_builders::CreateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceEventWindow` operation.
    ///
    /// See [`CreateInstanceEventWindow`](crate::client::fluent_builders::CreateInstanceEventWindow) for more information about the
    /// operation and its arguments.
    pub fn create_instance_event_window(
        &self,
    ) -> fluent_builders::CreateInstanceEventWindow<C, M, R> {
        fluent_builders::CreateInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceExportTask` operation.
    ///
    /// See [`CreateInstanceExportTask`](crate::client::fluent_builders::CreateInstanceExportTask) for more information about the
    /// operation and its arguments.
    pub fn create_instance_export_task(
        &self,
    ) -> fluent_builders::CreateInstanceExportTask<C, M, R> {
        fluent_builders::CreateInstanceExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInternetGateway` operation.
    ///
    /// See [`CreateInternetGateway`](crate::client::fluent_builders::CreateInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn create_internet_gateway(&self) -> fluent_builders::CreateInternetGateway<C, M, R> {
        fluent_builders::CreateInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIpam` operation.
    ///
    /// See [`CreateIpam`](crate::client::fluent_builders::CreateIpam) for more information about the
    /// operation and its arguments.
    pub fn create_ipam(&self) -> fluent_builders::CreateIpam<C, M, R> {
        fluent_builders::CreateIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIpamPool` operation.
    ///
    /// See [`CreateIpamPool`](crate::client::fluent_builders::CreateIpamPool) for more information about the
    /// operation and its arguments.
    pub fn create_ipam_pool(&self) -> fluent_builders::CreateIpamPool<C, M, R> {
        fluent_builders::CreateIpamPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIpamScope` operation.
    ///
    /// See [`CreateIpamScope`](crate::client::fluent_builders::CreateIpamScope) for more information about the
    /// operation and its arguments.
    pub fn create_ipam_scope(&self) -> fluent_builders::CreateIpamScope<C, M, R> {
        fluent_builders::CreateIpamScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateKeyPair` operation.
    ///
    /// See [`CreateKeyPair`](crate::client::fluent_builders::CreateKeyPair) for more information about the
    /// operation and its arguments.
    pub fn create_key_pair(&self) -> fluent_builders::CreateKeyPair<C, M, R> {
        fluent_builders::CreateKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLaunchTemplate` operation.
    ///
    /// See [`CreateLaunchTemplate`](crate::client::fluent_builders::CreateLaunchTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_launch_template(&self) -> fluent_builders::CreateLaunchTemplate<C, M, R> {
        fluent_builders::CreateLaunchTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLaunchTemplateVersion` operation.
    ///
    /// See [`CreateLaunchTemplateVersion`](crate::client::fluent_builders::CreateLaunchTemplateVersion) for more information about the
    /// operation and its arguments.
    pub fn create_launch_template_version(
        &self,
    ) -> fluent_builders::CreateLaunchTemplateVersion<C, M, R> {
        fluent_builders::CreateLaunchTemplateVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocalGatewayRoute` operation.
    ///
    /// See [`CreateLocalGatewayRoute`](crate::client::fluent_builders::CreateLocalGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn create_local_gateway_route(&self) -> fluent_builders::CreateLocalGatewayRoute<C, M, R> {
        fluent_builders::CreateLocalGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLocalGatewayRouteTableVpcAssociation` operation.
    ///
    /// See [`CreateLocalGatewayRouteTableVpcAssociation`](crate::client::fluent_builders::CreateLocalGatewayRouteTableVpcAssociation) for more information about the
    /// operation and its arguments.
    pub fn create_local_gateway_route_table_vpc_association(
        &self,
    ) -> fluent_builders::CreateLocalGatewayRouteTableVpcAssociation<C, M, R> {
        fluent_builders::CreateLocalGatewayRouteTableVpcAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateManagedPrefixList` operation.
    ///
    /// See [`CreateManagedPrefixList`](crate::client::fluent_builders::CreateManagedPrefixList) for more information about the
    /// operation and its arguments.
    pub fn create_managed_prefix_list(&self) -> fluent_builders::CreateManagedPrefixList<C, M, R> {
        fluent_builders::CreateManagedPrefixList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNatGateway` operation.
    ///
    /// See [`CreateNatGateway`](crate::client::fluent_builders::CreateNatGateway) for more information about the
    /// operation and its arguments.
    pub fn create_nat_gateway(&self) -> fluent_builders::CreateNatGateway<C, M, R> {
        fluent_builders::CreateNatGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkAcl` operation.
    ///
    /// See [`CreateNetworkAcl`](crate::client::fluent_builders::CreateNetworkAcl) for more information about the
    /// operation and its arguments.
    pub fn create_network_acl(&self) -> fluent_builders::CreateNetworkAcl<C, M, R> {
        fluent_builders::CreateNetworkAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkAclEntry` operation.
    ///
    /// See [`CreateNetworkAclEntry`](crate::client::fluent_builders::CreateNetworkAclEntry) for more information about the
    /// operation and its arguments.
    pub fn create_network_acl_entry(&self) -> fluent_builders::CreateNetworkAclEntry<C, M, R> {
        fluent_builders::CreateNetworkAclEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkInsightsAccessScope` operation.
    ///
    /// See [`CreateNetworkInsightsAccessScope`](crate::client::fluent_builders::CreateNetworkInsightsAccessScope) for more information about the
    /// operation and its arguments.
    pub fn create_network_insights_access_scope(
        &self,
    ) -> fluent_builders::CreateNetworkInsightsAccessScope<C, M, R> {
        fluent_builders::CreateNetworkInsightsAccessScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkInsightsPath` operation.
    ///
    /// See [`CreateNetworkInsightsPath`](crate::client::fluent_builders::CreateNetworkInsightsPath) for more information about the
    /// operation and its arguments.
    pub fn create_network_insights_path(
        &self,
    ) -> fluent_builders::CreateNetworkInsightsPath<C, M, R> {
        fluent_builders::CreateNetworkInsightsPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkInterface` operation.
    ///
    /// See [`CreateNetworkInterface`](crate::client::fluent_builders::CreateNetworkInterface) for more information about the
    /// operation and its arguments.
    pub fn create_network_interface(&self) -> fluent_builders::CreateNetworkInterface<C, M, R> {
        fluent_builders::CreateNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetworkInterfacePermission` operation.
    ///
    /// See [`CreateNetworkInterfacePermission`](crate::client::fluent_builders::CreateNetworkInterfacePermission) for more information about the
    /// operation and its arguments.
    pub fn create_network_interface_permission(
        &self,
    ) -> fluent_builders::CreateNetworkInterfacePermission<C, M, R> {
        fluent_builders::CreateNetworkInterfacePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePlacementGroup` operation.
    ///
    /// See [`CreatePlacementGroup`](crate::client::fluent_builders::CreatePlacementGroup) for more information about the
    /// operation and its arguments.
    pub fn create_placement_group(&self) -> fluent_builders::CreatePlacementGroup<C, M, R> {
        fluent_builders::CreatePlacementGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePublicIpv4Pool` operation.
    ///
    /// See [`CreatePublicIpv4Pool`](crate::client::fluent_builders::CreatePublicIpv4Pool) for more information about the
    /// operation and its arguments.
    pub fn create_public_ipv4_pool(&self) -> fluent_builders::CreatePublicIpv4Pool<C, M, R> {
        fluent_builders::CreatePublicIpv4Pool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplaceRootVolumeTask` operation.
    ///
    /// See [`CreateReplaceRootVolumeTask`](crate::client::fluent_builders::CreateReplaceRootVolumeTask) for more information about the
    /// operation and its arguments.
    pub fn create_replace_root_volume_task(
        &self,
    ) -> fluent_builders::CreateReplaceRootVolumeTask<C, M, R> {
        fluent_builders::CreateReplaceRootVolumeTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReservedInstancesListing` operation.
    ///
    /// See [`CreateReservedInstancesListing`](crate::client::fluent_builders::CreateReservedInstancesListing) for more information about the
    /// operation and its arguments.
    pub fn create_reserved_instances_listing(
        &self,
    ) -> fluent_builders::CreateReservedInstancesListing<C, M, R> {
        fluent_builders::CreateReservedInstancesListing::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRestoreImageTask` operation.
    ///
    /// See [`CreateRestoreImageTask`](crate::client::fluent_builders::CreateRestoreImageTask) for more information about the
    /// operation and its arguments.
    pub fn create_restore_image_task(&self) -> fluent_builders::CreateRestoreImageTask<C, M, R> {
        fluent_builders::CreateRestoreImageTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoute` operation.
    ///
    /// See [`CreateRoute`](crate::client::fluent_builders::CreateRoute) for more information about the
    /// operation and its arguments.
    pub fn create_route(&self) -> fluent_builders::CreateRoute<C, M, R> {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRouteTable` operation.
    ///
    /// See [`CreateRouteTable`](crate::client::fluent_builders::CreateRouteTable) for more information about the
    /// operation and its arguments.
    pub fn create_route_table(&self) -> fluent_builders::CreateRouteTable<C, M, R> {
        fluent_builders::CreateRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSecurityGroup` operation.
    ///
    /// See [`CreateSecurityGroup`](crate::client::fluent_builders::CreateSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn create_security_group(&self) -> fluent_builders::CreateSecurityGroup<C, M, R> {
        fluent_builders::CreateSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshot` operation.
    ///
    /// See [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot<C, M, R> {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshots` operation.
    ///
    /// See [`CreateSnapshots`](crate::client::fluent_builders::CreateSnapshots) for more information about the
    /// operation and its arguments.
    pub fn create_snapshots(&self) -> fluent_builders::CreateSnapshots<C, M, R> {
        fluent_builders::CreateSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSpotDatafeedSubscription` operation.
    ///
    /// See [`CreateSpotDatafeedSubscription`](crate::client::fluent_builders::CreateSpotDatafeedSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::CreateSpotDatafeedSubscription<C, M, R> {
        fluent_builders::CreateSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStoreImageTask` operation.
    ///
    /// See [`CreateStoreImageTask`](crate::client::fluent_builders::CreateStoreImageTask) for more information about the
    /// operation and its arguments.
    pub fn create_store_image_task(&self) -> fluent_builders::CreateStoreImageTask<C, M, R> {
        fluent_builders::CreateStoreImageTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubnet` operation.
    ///
    /// See [`CreateSubnet`](crate::client::fluent_builders::CreateSubnet) for more information about the
    /// operation and its arguments.
    pub fn create_subnet(&self) -> fluent_builders::CreateSubnet<C, M, R> {
        fluent_builders::CreateSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubnetCidrReservation` operation.
    ///
    /// See [`CreateSubnetCidrReservation`](crate::client::fluent_builders::CreateSubnetCidrReservation) for more information about the
    /// operation and its arguments.
    pub fn create_subnet_cidr_reservation(
        &self,
    ) -> fluent_builders::CreateSubnetCidrReservation<C, M, R> {
        fluent_builders::CreateSubnetCidrReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficMirrorFilter` operation.
    ///
    /// See [`CreateTrafficMirrorFilter`](crate::client::fluent_builders::CreateTrafficMirrorFilter) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_mirror_filter(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorFilter<C, M, R> {
        fluent_builders::CreateTrafficMirrorFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficMirrorFilterRule` operation.
    ///
    /// See [`CreateTrafficMirrorFilterRule`](crate::client::fluent_builders::CreateTrafficMirrorFilterRule) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_mirror_filter_rule(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorFilterRule<C, M, R> {
        fluent_builders::CreateTrafficMirrorFilterRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficMirrorSession` operation.
    ///
    /// See [`CreateTrafficMirrorSession`](crate::client::fluent_builders::CreateTrafficMirrorSession) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_mirror_session(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorSession<C, M, R> {
        fluent_builders::CreateTrafficMirrorSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficMirrorTarget` operation.
    ///
    /// See [`CreateTrafficMirrorTarget`](crate::client::fluent_builders::CreateTrafficMirrorTarget) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_mirror_target(
        &self,
    ) -> fluent_builders::CreateTrafficMirrorTarget<C, M, R> {
        fluent_builders::CreateTrafficMirrorTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGateway` operation.
    ///
    /// See [`CreateTransitGateway`](crate::client::fluent_builders::CreateTransitGateway) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway(&self) -> fluent_builders::CreateTransitGateway<C, M, R> {
        fluent_builders::CreateTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayConnect` operation.
    ///
    /// See [`CreateTransitGatewayConnect`](crate::client::fluent_builders::CreateTransitGatewayConnect) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_connect(
        &self,
    ) -> fluent_builders::CreateTransitGatewayConnect<C, M, R> {
        fluent_builders::CreateTransitGatewayConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayConnectPeer` operation.
    ///
    /// See [`CreateTransitGatewayConnectPeer`](crate::client::fluent_builders::CreateTransitGatewayConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::CreateTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::CreateTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayMulticastDomain` operation.
    ///
    /// See [`CreateTransitGatewayMulticastDomain`](crate::client::fluent_builders::CreateTransitGatewayMulticastDomain) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::CreateTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::CreateTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayPeeringAttachment` operation.
    ///
    /// See [`CreateTransitGatewayPeeringAttachment`](crate::client::fluent_builders::CreateTransitGatewayPeeringAttachment) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::CreateTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::CreateTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayPrefixListReference` operation.
    ///
    /// See [`CreateTransitGatewayPrefixListReference`](crate::client::fluent_builders::CreateTransitGatewayPrefixListReference) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_prefix_list_reference(
        &self,
    ) -> fluent_builders::CreateTransitGatewayPrefixListReference<C, M, R> {
        fluent_builders::CreateTransitGatewayPrefixListReference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayRoute` operation.
    ///
    /// See [`CreateTransitGatewayRoute`](crate::client::fluent_builders::CreateTransitGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_route(
        &self,
    ) -> fluent_builders::CreateTransitGatewayRoute<C, M, R> {
        fluent_builders::CreateTransitGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayRouteTable` operation.
    ///
    /// See [`CreateTransitGatewayRouteTable`](crate::client::fluent_builders::CreateTransitGatewayRouteTable) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::CreateTransitGatewayRouteTable<C, M, R> {
        fluent_builders::CreateTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransitGatewayVpcAttachment` operation.
    ///
    /// See [`CreateTransitGatewayVpcAttachment`](crate::client::fluent_builders::CreateTransitGatewayVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn create_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::CreateTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::CreateTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVolume` operation.
    ///
    /// See [`CreateVolume`](crate::client::fluent_builders::CreateVolume) for more information about the
    /// operation and its arguments.
    pub fn create_volume(&self) -> fluent_builders::CreateVolume<C, M, R> {
        fluent_builders::CreateVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpc` operation.
    ///
    /// See [`CreateVpc`](crate::client::fluent_builders::CreateVpc) for more information about the
    /// operation and its arguments.
    pub fn create_vpc(&self) -> fluent_builders::CreateVpc<C, M, R> {
        fluent_builders::CreateVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcEndpoint` operation.
    ///
    /// See [`CreateVpcEndpoint`](crate::client::fluent_builders::CreateVpcEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_endpoint(&self) -> fluent_builders::CreateVpcEndpoint<C, M, R> {
        fluent_builders::CreateVpcEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcEndpointConnectionNotification` operation.
    ///
    /// See [`CreateVpcEndpointConnectionNotification`](crate::client::fluent_builders::CreateVpcEndpointConnectionNotification) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_endpoint_connection_notification(
        &self,
    ) -> fluent_builders::CreateVpcEndpointConnectionNotification<C, M, R> {
        fluent_builders::CreateVpcEndpointConnectionNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcEndpointServiceConfiguration` operation.
    ///
    /// See [`CreateVpcEndpointServiceConfiguration`](crate::client::fluent_builders::CreateVpcEndpointServiceConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_endpoint_service_configuration(
        &self,
    ) -> fluent_builders::CreateVpcEndpointServiceConfiguration<C, M, R> {
        fluent_builders::CreateVpcEndpointServiceConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpcPeeringConnection` operation.
    ///
    /// See [`CreateVpcPeeringConnection`](crate::client::fluent_builders::CreateVpcPeeringConnection) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_peering_connection(
        &self,
    ) -> fluent_builders::CreateVpcPeeringConnection<C, M, R> {
        fluent_builders::CreateVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpnConnection` operation.
    ///
    /// See [`CreateVpnConnection`](crate::client::fluent_builders::CreateVpnConnection) for more information about the
    /// operation and its arguments.
    pub fn create_vpn_connection(&self) -> fluent_builders::CreateVpnConnection<C, M, R> {
        fluent_builders::CreateVpnConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpnConnectionRoute` operation.
    ///
    /// See [`CreateVpnConnectionRoute`](crate::client::fluent_builders::CreateVpnConnectionRoute) for more information about the
    /// operation and its arguments.
    pub fn create_vpn_connection_route(
        &self,
    ) -> fluent_builders::CreateVpnConnectionRoute<C, M, R> {
        fluent_builders::CreateVpnConnectionRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVpnGateway` operation.
    ///
    /// See [`CreateVpnGateway`](crate::client::fluent_builders::CreateVpnGateway) for more information about the
    /// operation and its arguments.
    pub fn create_vpn_gateway(&self) -> fluent_builders::CreateVpnGateway<C, M, R> {
        fluent_builders::CreateVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCarrierGateway` operation.
    ///
    /// See [`DeleteCarrierGateway`](crate::client::fluent_builders::DeleteCarrierGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_carrier_gateway(&self) -> fluent_builders::DeleteCarrierGateway<C, M, R> {
        fluent_builders::DeleteCarrierGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClientVpnEndpoint` operation.
    ///
    /// See [`DeleteClientVpnEndpoint`](crate::client::fluent_builders::DeleteClientVpnEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_client_vpn_endpoint(&self) -> fluent_builders::DeleteClientVpnEndpoint<C, M, R> {
        fluent_builders::DeleteClientVpnEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClientVpnRoute` operation.
    ///
    /// See [`DeleteClientVpnRoute`](crate::client::fluent_builders::DeleteClientVpnRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_client_vpn_route(&self) -> fluent_builders::DeleteClientVpnRoute<C, M, R> {
        fluent_builders::DeleteClientVpnRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomerGateway` operation.
    ///
    /// See [`DeleteCustomerGateway`](crate::client::fluent_builders::DeleteCustomerGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_customer_gateway(&self) -> fluent_builders::DeleteCustomerGateway<C, M, R> {
        fluent_builders::DeleteCustomerGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDhcpOptions` operation.
    ///
    /// See [`DeleteDhcpOptions`](crate::client::fluent_builders::DeleteDhcpOptions) for more information about the
    /// operation and its arguments.
    pub fn delete_dhcp_options(&self) -> fluent_builders::DeleteDhcpOptions<C, M, R> {
        fluent_builders::DeleteDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEgressOnlyInternetGateway` operation.
    ///
    /// See [`DeleteEgressOnlyInternetGateway`](crate::client::fluent_builders::DeleteEgressOnlyInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_egress_only_internet_gateway(
        &self,
    ) -> fluent_builders::DeleteEgressOnlyInternetGateway<C, M, R> {
        fluent_builders::DeleteEgressOnlyInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFleets` operation.
    ///
    /// See [`DeleteFleets`](crate::client::fluent_builders::DeleteFleets) for more information about the
    /// operation and its arguments.
    pub fn delete_fleets(&self) -> fluent_builders::DeleteFleets<C, M, R> {
        fluent_builders::DeleteFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFlowLogs` operation.
    ///
    /// See [`DeleteFlowLogs`](crate::client::fluent_builders::DeleteFlowLogs) for more information about the
    /// operation and its arguments.
    pub fn delete_flow_logs(&self) -> fluent_builders::DeleteFlowLogs<C, M, R> {
        fluent_builders::DeleteFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFpgaImage` operation.
    ///
    /// See [`DeleteFpgaImage`](crate::client::fluent_builders::DeleteFpgaImage) for more information about the
    /// operation and its arguments.
    pub fn delete_fpga_image(&self) -> fluent_builders::DeleteFpgaImage<C, M, R> {
        fluent_builders::DeleteFpgaImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstanceEventWindow` operation.
    ///
    /// See [`DeleteInstanceEventWindow`](crate::client::fluent_builders::DeleteInstanceEventWindow) for more information about the
    /// operation and its arguments.
    pub fn delete_instance_event_window(
        &self,
    ) -> fluent_builders::DeleteInstanceEventWindow<C, M, R> {
        fluent_builders::DeleteInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInternetGateway` operation.
    ///
    /// See [`DeleteInternetGateway`](crate::client::fluent_builders::DeleteInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_internet_gateway(&self) -> fluent_builders::DeleteInternetGateway<C, M, R> {
        fluent_builders::DeleteInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIpam` operation.
    ///
    /// See [`DeleteIpam`](crate::client::fluent_builders::DeleteIpam) for more information about the
    /// operation and its arguments.
    pub fn delete_ipam(&self) -> fluent_builders::DeleteIpam<C, M, R> {
        fluent_builders::DeleteIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIpamPool` operation.
    ///
    /// See [`DeleteIpamPool`](crate::client::fluent_builders::DeleteIpamPool) for more information about the
    /// operation and its arguments.
    pub fn delete_ipam_pool(&self) -> fluent_builders::DeleteIpamPool<C, M, R> {
        fluent_builders::DeleteIpamPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIpamScope` operation.
    ///
    /// See [`DeleteIpamScope`](crate::client::fluent_builders::DeleteIpamScope) for more information about the
    /// operation and its arguments.
    pub fn delete_ipam_scope(&self) -> fluent_builders::DeleteIpamScope<C, M, R> {
        fluent_builders::DeleteIpamScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteKeyPair` operation.
    ///
    /// See [`DeleteKeyPair`](crate::client::fluent_builders::DeleteKeyPair) for more information about the
    /// operation and its arguments.
    pub fn delete_key_pair(&self) -> fluent_builders::DeleteKeyPair<C, M, R> {
        fluent_builders::DeleteKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLaunchTemplate` operation.
    ///
    /// See [`DeleteLaunchTemplate`](crate::client::fluent_builders::DeleteLaunchTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_launch_template(&self) -> fluent_builders::DeleteLaunchTemplate<C, M, R> {
        fluent_builders::DeleteLaunchTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLaunchTemplateVersions` operation.
    ///
    /// See [`DeleteLaunchTemplateVersions`](crate::client::fluent_builders::DeleteLaunchTemplateVersions) for more information about the
    /// operation and its arguments.
    pub fn delete_launch_template_versions(
        &self,
    ) -> fluent_builders::DeleteLaunchTemplateVersions<C, M, R> {
        fluent_builders::DeleteLaunchTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLocalGatewayRoute` operation.
    ///
    /// See [`DeleteLocalGatewayRoute`](crate::client::fluent_builders::DeleteLocalGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_local_gateway_route(&self) -> fluent_builders::DeleteLocalGatewayRoute<C, M, R> {
        fluent_builders::DeleteLocalGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLocalGatewayRouteTableVpcAssociation` operation.
    ///
    /// See [`DeleteLocalGatewayRouteTableVpcAssociation`](crate::client::fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_local_gateway_route_table_vpc_association(
        &self,
    ) -> fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation<C, M, R> {
        fluent_builders::DeleteLocalGatewayRouteTableVpcAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteManagedPrefixList` operation.
    ///
    /// See [`DeleteManagedPrefixList`](crate::client::fluent_builders::DeleteManagedPrefixList) for more information about the
    /// operation and its arguments.
    pub fn delete_managed_prefix_list(&self) -> fluent_builders::DeleteManagedPrefixList<C, M, R> {
        fluent_builders::DeleteManagedPrefixList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNatGateway` operation.
    ///
    /// See [`DeleteNatGateway`](crate::client::fluent_builders::DeleteNatGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_nat_gateway(&self) -> fluent_builders::DeleteNatGateway<C, M, R> {
        fluent_builders::DeleteNatGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkAcl` operation.
    ///
    /// See [`DeleteNetworkAcl`](crate::client::fluent_builders::DeleteNetworkAcl) for more information about the
    /// operation and its arguments.
    pub fn delete_network_acl(&self) -> fluent_builders::DeleteNetworkAcl<C, M, R> {
        fluent_builders::DeleteNetworkAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkAclEntry` operation.
    ///
    /// See [`DeleteNetworkAclEntry`](crate::client::fluent_builders::DeleteNetworkAclEntry) for more information about the
    /// operation and its arguments.
    pub fn delete_network_acl_entry(&self) -> fluent_builders::DeleteNetworkAclEntry<C, M, R> {
        fluent_builders::DeleteNetworkAclEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInsightsAccessScope` operation.
    ///
    /// See [`DeleteNetworkInsightsAccessScope`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScope) for more information about the
    /// operation and its arguments.
    pub fn delete_network_insights_access_scope(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAccessScope<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAccessScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInsightsAccessScopeAnalysis` operation.
    ///
    /// See [`DeleteNetworkInsightsAccessScopeAnalysis`](crate::client::fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis) for more information about the
    /// operation and its arguments.
    pub fn delete_network_insights_access_scope_analysis(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAccessScopeAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInsightsAnalysis` operation.
    ///
    /// See [`DeleteNetworkInsightsAnalysis`](crate::client::fluent_builders::DeleteNetworkInsightsAnalysis) for more information about the
    /// operation and its arguments.
    pub fn delete_network_insights_analysis(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsAnalysis<C, M, R> {
        fluent_builders::DeleteNetworkInsightsAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInsightsPath` operation.
    ///
    /// See [`DeleteNetworkInsightsPath`](crate::client::fluent_builders::DeleteNetworkInsightsPath) for more information about the
    /// operation and its arguments.
    pub fn delete_network_insights_path(
        &self,
    ) -> fluent_builders::DeleteNetworkInsightsPath<C, M, R> {
        fluent_builders::DeleteNetworkInsightsPath::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInterface` operation.
    ///
    /// See [`DeleteNetworkInterface`](crate::client::fluent_builders::DeleteNetworkInterface) for more information about the
    /// operation and its arguments.
    pub fn delete_network_interface(&self) -> fluent_builders::DeleteNetworkInterface<C, M, R> {
        fluent_builders::DeleteNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNetworkInterfacePermission` operation.
    ///
    /// See [`DeleteNetworkInterfacePermission`](crate::client::fluent_builders::DeleteNetworkInterfacePermission) for more information about the
    /// operation and its arguments.
    pub fn delete_network_interface_permission(
        &self,
    ) -> fluent_builders::DeleteNetworkInterfacePermission<C, M, R> {
        fluent_builders::DeleteNetworkInterfacePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePlacementGroup` operation.
    ///
    /// See [`DeletePlacementGroup`](crate::client::fluent_builders::DeletePlacementGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_placement_group(&self) -> fluent_builders::DeletePlacementGroup<C, M, R> {
        fluent_builders::DeletePlacementGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePublicIpv4Pool` operation.
    ///
    /// See [`DeletePublicIpv4Pool`](crate::client::fluent_builders::DeletePublicIpv4Pool) for more information about the
    /// operation and its arguments.
    pub fn delete_public_ipv4_pool(&self) -> fluent_builders::DeletePublicIpv4Pool<C, M, R> {
        fluent_builders::DeletePublicIpv4Pool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQueuedReservedInstances` operation.
    ///
    /// See [`DeleteQueuedReservedInstances`](crate::client::fluent_builders::DeleteQueuedReservedInstances) for more information about the
    /// operation and its arguments.
    pub fn delete_queued_reserved_instances(
        &self,
    ) -> fluent_builders::DeleteQueuedReservedInstances<C, M, R> {
        fluent_builders::DeleteQueuedReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoute` operation.
    ///
    /// See [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute<C, M, R> {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRouteTable` operation.
    ///
    /// See [`DeleteRouteTable`](crate::client::fluent_builders::DeleteRouteTable) for more information about the
    /// operation and its arguments.
    pub fn delete_route_table(&self) -> fluent_builders::DeleteRouteTable<C, M, R> {
        fluent_builders::DeleteRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSecurityGroup` operation.
    ///
    /// See [`DeleteSecurityGroup`](crate::client::fluent_builders::DeleteSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_security_group(&self) -> fluent_builders::DeleteSecurityGroup<C, M, R> {
        fluent_builders::DeleteSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshot` operation.
    ///
    /// See [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot<C, M, R> {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSpotDatafeedSubscription` operation.
    ///
    /// See [`DeleteSpotDatafeedSubscription`](crate::client::fluent_builders::DeleteSpotDatafeedSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::DeleteSpotDatafeedSubscription<C, M, R> {
        fluent_builders::DeleteSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubnet` operation.
    ///
    /// See [`DeleteSubnet`](crate::client::fluent_builders::DeleteSubnet) for more information about the
    /// operation and its arguments.
    pub fn delete_subnet(&self) -> fluent_builders::DeleteSubnet<C, M, R> {
        fluent_builders::DeleteSubnet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubnetCidrReservation` operation.
    ///
    /// See [`DeleteSubnetCidrReservation`](crate::client::fluent_builders::DeleteSubnetCidrReservation) for more information about the
    /// operation and its arguments.
    pub fn delete_subnet_cidr_reservation(
        &self,
    ) -> fluent_builders::DeleteSubnetCidrReservation<C, M, R> {
        fluent_builders::DeleteSubnetCidrReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficMirrorFilter` operation.
    ///
    /// See [`DeleteTrafficMirrorFilter`](crate::client::fluent_builders::DeleteTrafficMirrorFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_mirror_filter(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorFilter<C, M, R> {
        fluent_builders::DeleteTrafficMirrorFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficMirrorFilterRule` operation.
    ///
    /// See [`DeleteTrafficMirrorFilterRule`](crate::client::fluent_builders::DeleteTrafficMirrorFilterRule) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_mirror_filter_rule(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorFilterRule<C, M, R> {
        fluent_builders::DeleteTrafficMirrorFilterRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficMirrorSession` operation.
    ///
    /// See [`DeleteTrafficMirrorSession`](crate::client::fluent_builders::DeleteTrafficMirrorSession) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_mirror_session(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorSession<C, M, R> {
        fluent_builders::DeleteTrafficMirrorSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficMirrorTarget` operation.
    ///
    /// See [`DeleteTrafficMirrorTarget`](crate::client::fluent_builders::DeleteTrafficMirrorTarget) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_mirror_target(
        &self,
    ) -> fluent_builders::DeleteTrafficMirrorTarget<C, M, R> {
        fluent_builders::DeleteTrafficMirrorTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGateway` operation.
    ///
    /// See [`DeleteTransitGateway`](crate::client::fluent_builders::DeleteTransitGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway(&self) -> fluent_builders::DeleteTransitGateway<C, M, R> {
        fluent_builders::DeleteTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayConnect` operation.
    ///
    /// See [`DeleteTransitGatewayConnect`](crate::client::fluent_builders::DeleteTransitGatewayConnect) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_connect(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayConnect<C, M, R> {
        fluent_builders::DeleteTransitGatewayConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayConnectPeer` operation.
    ///
    /// See [`DeleteTransitGatewayConnectPeer`](crate::client::fluent_builders::DeleteTransitGatewayConnectPeer) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_connect_peer(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayConnectPeer<C, M, R> {
        fluent_builders::DeleteTransitGatewayConnectPeer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayMulticastDomain` operation.
    ///
    /// See [`DeleteTransitGatewayMulticastDomain`](crate::client::fluent_builders::DeleteTransitGatewayMulticastDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::DeleteTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayPeeringAttachment` operation.
    ///
    /// See [`DeleteTransitGatewayPeeringAttachment`](crate::client::fluent_builders::DeleteTransitGatewayPeeringAttachment) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::DeleteTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayPrefixListReference` operation.
    ///
    /// See [`DeleteTransitGatewayPrefixListReference`](crate::client::fluent_builders::DeleteTransitGatewayPrefixListReference) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_prefix_list_reference(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayPrefixListReference<C, M, R> {
        fluent_builders::DeleteTransitGatewayPrefixListReference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayRoute` operation.
    ///
    /// See [`DeleteTransitGatewayRoute`](crate::client::fluent_builders::DeleteTransitGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_route(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayRoute<C, M, R> {
        fluent_builders::DeleteTransitGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayRouteTable` operation.
    ///
    /// See [`DeleteTransitGatewayRouteTable`](crate::client::fluent_builders::DeleteTransitGatewayRouteTable) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayRouteTable<C, M, R> {
        fluent_builders::DeleteTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTransitGatewayVpcAttachment` operation.
    ///
    /// See [`DeleteTransitGatewayVpcAttachment`](crate::client::fluent_builders::DeleteTransitGatewayVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn delete_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::DeleteTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::DeleteTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVolume` operation.
    ///
    /// See [`DeleteVolume`](crate::client::fluent_builders::DeleteVolume) for more information about the
    /// operation and its arguments.
    pub fn delete_volume(&self) -> fluent_builders::DeleteVolume<C, M, R> {
        fluent_builders::DeleteVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpc` operation.
    ///
    /// See [`DeleteVpc`](crate::client::fluent_builders::DeleteVpc) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc(&self) -> fluent_builders::DeleteVpc<C, M, R> {
        fluent_builders::DeleteVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcEndpointConnectionNotifications` operation.
    ///
    /// See [`DeleteVpcEndpointConnectionNotifications`](crate::client::fluent_builders::DeleteVpcEndpointConnectionNotifications) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_endpoint_connection_notifications(
        &self,
    ) -> fluent_builders::DeleteVpcEndpointConnectionNotifications<C, M, R> {
        fluent_builders::DeleteVpcEndpointConnectionNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcEndpoints` operation.
    ///
    /// See [`DeleteVpcEndpoints`](crate::client::fluent_builders::DeleteVpcEndpoints) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_endpoints(&self) -> fluent_builders::DeleteVpcEndpoints<C, M, R> {
        fluent_builders::DeleteVpcEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcEndpointServiceConfigurations` operation.
    ///
    /// See [`DeleteVpcEndpointServiceConfigurations`](crate::client::fluent_builders::DeleteVpcEndpointServiceConfigurations) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_endpoint_service_configurations(
        &self,
    ) -> fluent_builders::DeleteVpcEndpointServiceConfigurations<C, M, R> {
        fluent_builders::DeleteVpcEndpointServiceConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpcPeeringConnection` operation.
    ///
    /// See [`DeleteVpcPeeringConnection`](crate::client::fluent_builders::DeleteVpcPeeringConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_peering_connection(
        &self,
    ) -> fluent_builders::DeleteVpcPeeringConnection<C, M, R> {
        fluent_builders::DeleteVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpnConnection` operation.
    ///
    /// See [`DeleteVpnConnection`](crate::client::fluent_builders::DeleteVpnConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_vpn_connection(&self) -> fluent_builders::DeleteVpnConnection<C, M, R> {
        fluent_builders::DeleteVpnConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpnConnectionRoute` operation.
    ///
    /// See [`DeleteVpnConnectionRoute`](crate::client::fluent_builders::DeleteVpnConnectionRoute) for more information about the
    /// operation and its arguments.
    pub fn delete_vpn_connection_route(
        &self,
    ) -> fluent_builders::DeleteVpnConnectionRoute<C, M, R> {
        fluent_builders::DeleteVpnConnectionRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVpnGateway` operation.
    ///
    /// See [`DeleteVpnGateway`](crate::client::fluent_builders::DeleteVpnGateway) for more information about the
    /// operation and its arguments.
    pub fn delete_vpn_gateway(&self) -> fluent_builders::DeleteVpnGateway<C, M, R> {
        fluent_builders::DeleteVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprovisionByoipCidr` operation.
    ///
    /// See [`DeprovisionByoipCidr`](crate::client::fluent_builders::DeprovisionByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn deprovision_byoip_cidr(&self) -> fluent_builders::DeprovisionByoipCidr<C, M, R> {
        fluent_builders::DeprovisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprovisionIpamPoolCidr` operation.
    ///
    /// See [`DeprovisionIpamPoolCidr`](crate::client::fluent_builders::DeprovisionIpamPoolCidr) for more information about the
    /// operation and its arguments.
    pub fn deprovision_ipam_pool_cidr(&self) -> fluent_builders::DeprovisionIpamPoolCidr<C, M, R> {
        fluent_builders::DeprovisionIpamPoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprovisionPublicIpv4PoolCidr` operation.
    ///
    /// See [`DeprovisionPublicIpv4PoolCidr`](crate::client::fluent_builders::DeprovisionPublicIpv4PoolCidr) for more information about the
    /// operation and its arguments.
    pub fn deprovision_public_ipv4_pool_cidr(
        &self,
    ) -> fluent_builders::DeprovisionPublicIpv4PoolCidr<C, M, R> {
        fluent_builders::DeprovisionPublicIpv4PoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterImage` operation.
    ///
    /// See [`DeregisterImage`](crate::client::fluent_builders::DeregisterImage) for more information about the
    /// operation and its arguments.
    pub fn deregister_image(&self) -> fluent_builders::DeregisterImage<C, M, R> {
        fluent_builders::DeregisterImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterInstanceEventNotificationAttributes` operation.
    ///
    /// See [`DeregisterInstanceEventNotificationAttributes`](crate::client::fluent_builders::DeregisterInstanceEventNotificationAttributes) for more information about the
    /// operation and its arguments.
    pub fn deregister_instance_event_notification_attributes(
        &self,
    ) -> fluent_builders::DeregisterInstanceEventNotificationAttributes<C, M, R> {
        fluent_builders::DeregisterInstanceEventNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTransitGatewayMulticastGroupMembers` operation.
    ///
    /// See [`DeregisterTransitGatewayMulticastGroupMembers`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupMembers) for more information about the
    /// operation and its arguments.
    pub fn deregister_transit_gateway_multicast_group_members(
        &self,
    ) -> fluent_builders::DeregisterTransitGatewayMulticastGroupMembers<C, M, R> {
        fluent_builders::DeregisterTransitGatewayMulticastGroupMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterTransitGatewayMulticastGroupSources` operation.
    ///
    /// See [`DeregisterTransitGatewayMulticastGroupSources`](crate::client::fluent_builders::DeregisterTransitGatewayMulticastGroupSources) for more information about the
    /// operation and its arguments.
    pub fn deregister_transit_gateway_multicast_group_sources(
        &self,
    ) -> fluent_builders::DeregisterTransitGatewayMulticastGroupSources<C, M, R> {
        fluent_builders::DeregisterTransitGatewayMulticastGroupSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAttributes` operation.
    ///
    /// See [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAddresses` operation.
    ///
    /// See [`DescribeAddresses`](crate::client::fluent_builders::DescribeAddresses) for more information about the
    /// operation and its arguments.
    pub fn describe_addresses(&self) -> fluent_builders::DescribeAddresses<C, M, R> {
        fluent_builders::DescribeAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAddressesAttribute` operation.
    ///
    /// See [`DescribeAddressesAttribute`](crate::client::fluent_builders::DescribeAddressesAttribute) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeAddressesAttribute::into_paginator).
    pub fn describe_addresses_attribute(
        &self,
    ) -> fluent_builders::DescribeAddressesAttribute<C, M, R> {
        fluent_builders::DescribeAddressesAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAggregateIdFormat` operation.
    ///
    /// See [`DescribeAggregateIdFormat`](crate::client::fluent_builders::DescribeAggregateIdFormat) for more information about the
    /// operation and its arguments.
    pub fn describe_aggregate_id_format(
        &self,
    ) -> fluent_builders::DescribeAggregateIdFormat<C, M, R> {
        fluent_builders::DescribeAggregateIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAvailabilityZones` operation.
    ///
    /// See [`DescribeAvailabilityZones`](crate::client::fluent_builders::DescribeAvailabilityZones) for more information about the
    /// operation and its arguments.
    pub fn describe_availability_zones(
        &self,
    ) -> fluent_builders::DescribeAvailabilityZones<C, M, R> {
        fluent_builders::DescribeAvailabilityZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBundleTasks` operation.
    ///
    /// See [`DescribeBundleTasks`](crate::client::fluent_builders::DescribeBundleTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_bundle_tasks(&self) -> fluent_builders::DescribeBundleTasks<C, M, R> {
        fluent_builders::DescribeBundleTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeByoipCidrs` operation.
    ///
    /// See [`DescribeByoipCidrs`](crate::client::fluent_builders::DescribeByoipCidrs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeByoipCidrs::into_paginator).
    pub fn describe_byoip_cidrs(&self) -> fluent_builders::DescribeByoipCidrs<C, M, R> {
        fluent_builders::DescribeByoipCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCapacityReservationFleets` operation.
    ///
    /// See [`DescribeCapacityReservationFleets`](crate::client::fluent_builders::DescribeCapacityReservationFleets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeCapacityReservationFleets::into_paginator).
    pub fn describe_capacity_reservation_fleets(
        &self,
    ) -> fluent_builders::DescribeCapacityReservationFleets<C, M, R> {
        fluent_builders::DescribeCapacityReservationFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCapacityReservations` operation.
    ///
    /// See [`DescribeCapacityReservations`](crate::client::fluent_builders::DescribeCapacityReservations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeCapacityReservations::into_paginator).
    pub fn describe_capacity_reservations(
        &self,
    ) -> fluent_builders::DescribeCapacityReservations<C, M, R> {
        fluent_builders::DescribeCapacityReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCarrierGateways` operation.
    ///
    /// See [`DescribeCarrierGateways`](crate::client::fluent_builders::DescribeCarrierGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeCarrierGateways::into_paginator).
    pub fn describe_carrier_gateways(&self) -> fluent_builders::DescribeCarrierGateways<C, M, R> {
        fluent_builders::DescribeCarrierGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClassicLinkInstances` operation.
    ///
    /// See [`DescribeClassicLinkInstances`](crate::client::fluent_builders::DescribeClassicLinkInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClassicLinkInstances::into_paginator).
    pub fn describe_classic_link_instances(
        &self,
    ) -> fluent_builders::DescribeClassicLinkInstances<C, M, R> {
        fluent_builders::DescribeClassicLinkInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientVpnAuthorizationRules` operation.
    ///
    /// See [`DescribeClientVpnAuthorizationRules`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnAuthorizationRules::into_paginator).
    pub fn describe_client_vpn_authorization_rules(
        &self,
    ) -> fluent_builders::DescribeClientVpnAuthorizationRules<C, M, R> {
        fluent_builders::DescribeClientVpnAuthorizationRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientVpnConnections` operation.
    ///
    /// See [`DescribeClientVpnConnections`](crate::client::fluent_builders::DescribeClientVpnConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnConnections::into_paginator).
    pub fn describe_client_vpn_connections(
        &self,
    ) -> fluent_builders::DescribeClientVpnConnections<C, M, R> {
        fluent_builders::DescribeClientVpnConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientVpnEndpoints` operation.
    ///
    /// See [`DescribeClientVpnEndpoints`](crate::client::fluent_builders::DescribeClientVpnEndpoints) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnEndpoints::into_paginator).
    pub fn describe_client_vpn_endpoints(
        &self,
    ) -> fluent_builders::DescribeClientVpnEndpoints<C, M, R> {
        fluent_builders::DescribeClientVpnEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientVpnRoutes` operation.
    ///
    /// See [`DescribeClientVpnRoutes`](crate::client::fluent_builders::DescribeClientVpnRoutes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnRoutes::into_paginator).
    pub fn describe_client_vpn_routes(&self) -> fluent_builders::DescribeClientVpnRoutes<C, M, R> {
        fluent_builders::DescribeClientVpnRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClientVpnTargetNetworks` operation.
    ///
    /// See [`DescribeClientVpnTargetNetworks`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeClientVpnTargetNetworks::into_paginator).
    pub fn describe_client_vpn_target_networks(
        &self,
    ) -> fluent_builders::DescribeClientVpnTargetNetworks<C, M, R> {
        fluent_builders::DescribeClientVpnTargetNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCoipPools` operation.
    ///
    /// See [`DescribeCoipPools`](crate::client::fluent_builders::DescribeCoipPools) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeCoipPools::into_paginator).
    pub fn describe_coip_pools(&self) -> fluent_builders::DescribeCoipPools<C, M, R> {
        fluent_builders::DescribeCoipPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConversionTasks` operation.
    ///
    /// See [`DescribeConversionTasks`](crate::client::fluent_builders::DescribeConversionTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_conversion_tasks(&self) -> fluent_builders::DescribeConversionTasks<C, M, R> {
        fluent_builders::DescribeConversionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomerGateways` operation.
    ///
    /// See [`DescribeCustomerGateways`](crate::client::fluent_builders::DescribeCustomerGateways) for more information about the
    /// operation and its arguments.
    pub fn describe_customer_gateways(&self) -> fluent_builders::DescribeCustomerGateways<C, M, R> {
        fluent_builders::DescribeCustomerGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDhcpOptions` operation.
    ///
    /// See [`DescribeDhcpOptions`](crate::client::fluent_builders::DescribeDhcpOptions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeDhcpOptions::into_paginator).
    pub fn describe_dhcp_options(&self) -> fluent_builders::DescribeDhcpOptions<C, M, R> {
        fluent_builders::DescribeDhcpOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEgressOnlyInternetGateways` operation.
    ///
    /// See [`DescribeEgressOnlyInternetGateways`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeEgressOnlyInternetGateways::into_paginator).
    pub fn describe_egress_only_internet_gateways(
        &self,
    ) -> fluent_builders::DescribeEgressOnlyInternetGateways<C, M, R> {
        fluent_builders::DescribeEgressOnlyInternetGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeElasticGpus` operation.
    ///
    /// See [`DescribeElasticGpus`](crate::client::fluent_builders::DescribeElasticGpus) for more information about the
    /// operation and its arguments.
    pub fn describe_elastic_gpus(&self) -> fluent_builders::DescribeElasticGpus<C, M, R> {
        fluent_builders::DescribeElasticGpus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExportImageTasks` operation.
    ///
    /// See [`DescribeExportImageTasks`](crate::client::fluent_builders::DescribeExportImageTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeExportImageTasks::into_paginator).
    pub fn describe_export_image_tasks(
        &self,
    ) -> fluent_builders::DescribeExportImageTasks<C, M, R> {
        fluent_builders::DescribeExportImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExportTasks` operation.
    ///
    /// See [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks<C, M, R> {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFastSnapshotRestores` operation.
    ///
    /// See [`DescribeFastSnapshotRestores`](crate::client::fluent_builders::DescribeFastSnapshotRestores) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeFastSnapshotRestores::into_paginator).
    pub fn describe_fast_snapshot_restores(
        &self,
    ) -> fluent_builders::DescribeFastSnapshotRestores<C, M, R> {
        fluent_builders::DescribeFastSnapshotRestores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleetHistory` operation.
    ///
    /// See [`DescribeFleetHistory`](crate::client::fluent_builders::DescribeFleetHistory) for more information about the
    /// operation and its arguments.
    pub fn describe_fleet_history(&self) -> fluent_builders::DescribeFleetHistory<C, M, R> {
        fluent_builders::DescribeFleetHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleetInstances` operation.
    ///
    /// See [`DescribeFleetInstances`](crate::client::fluent_builders::DescribeFleetInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_fleet_instances(&self) -> fluent_builders::DescribeFleetInstances<C, M, R> {
        fluent_builders::DescribeFleetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleets` operation.
    ///
    /// See [`DescribeFleets`](crate::client::fluent_builders::DescribeFleets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeFleets::into_paginator).
    pub fn describe_fleets(&self) -> fluent_builders::DescribeFleets<C, M, R> {
        fluent_builders::DescribeFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFlowLogs` operation.
    ///
    /// See [`DescribeFlowLogs`](crate::client::fluent_builders::DescribeFlowLogs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeFlowLogs::into_paginator).
    pub fn describe_flow_logs(&self) -> fluent_builders::DescribeFlowLogs<C, M, R> {
        fluent_builders::DescribeFlowLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFpgaImageAttribute` operation.
    ///
    /// See [`DescribeFpgaImageAttribute`](crate::client::fluent_builders::DescribeFpgaImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_fpga_image_attribute(
        &self,
    ) -> fluent_builders::DescribeFpgaImageAttribute<C, M, R> {
        fluent_builders::DescribeFpgaImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFpgaImages` operation.
    ///
    /// See [`DescribeFpgaImages`](crate::client::fluent_builders::DescribeFpgaImages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeFpgaImages::into_paginator).
    pub fn describe_fpga_images(&self) -> fluent_builders::DescribeFpgaImages<C, M, R> {
        fluent_builders::DescribeFpgaImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHostReservationOfferings` operation.
    ///
    /// See [`DescribeHostReservationOfferings`](crate::client::fluent_builders::DescribeHostReservationOfferings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeHostReservationOfferings::into_paginator).
    pub fn describe_host_reservation_offerings(
        &self,
    ) -> fluent_builders::DescribeHostReservationOfferings<C, M, R> {
        fluent_builders::DescribeHostReservationOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHostReservations` operation.
    ///
    /// See [`DescribeHostReservations`](crate::client::fluent_builders::DescribeHostReservations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeHostReservations::into_paginator).
    pub fn describe_host_reservations(&self) -> fluent_builders::DescribeHostReservations<C, M, R> {
        fluent_builders::DescribeHostReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHosts` operation.
    ///
    /// See [`DescribeHosts`](crate::client::fluent_builders::DescribeHosts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeHosts::into_paginator).
    pub fn describe_hosts(&self) -> fluent_builders::DescribeHosts<C, M, R> {
        fluent_builders::DescribeHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIamInstanceProfileAssociations` operation.
    ///
    /// See [`DescribeIamInstanceProfileAssociations`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeIamInstanceProfileAssociations::into_paginator).
    pub fn describe_iam_instance_profile_associations(
        &self,
    ) -> fluent_builders::DescribeIamInstanceProfileAssociations<C, M, R> {
        fluent_builders::DescribeIamInstanceProfileAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdentityIdFormat` operation.
    ///
    /// See [`DescribeIdentityIdFormat`](crate::client::fluent_builders::DescribeIdentityIdFormat) for more information about the
    /// operation and its arguments.
    pub fn describe_identity_id_format(
        &self,
    ) -> fluent_builders::DescribeIdentityIdFormat<C, M, R> {
        fluent_builders::DescribeIdentityIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIdFormat` operation.
    ///
    /// See [`DescribeIdFormat`](crate::client::fluent_builders::DescribeIdFormat) for more information about the
    /// operation and its arguments.
    pub fn describe_id_format(&self) -> fluent_builders::DescribeIdFormat<C, M, R> {
        fluent_builders::DescribeIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageAttribute` operation.
    ///
    /// See [`DescribeImageAttribute`](crate::client::fluent_builders::DescribeImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_image_attribute(&self) -> fluent_builders::DescribeImageAttribute<C, M, R> {
        fluent_builders::DescribeImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImages` operation.
    ///
    /// See [`DescribeImages`](crate::client::fluent_builders::DescribeImages) for more information about the
    /// operation and its arguments.
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImportImageTasks` operation.
    ///
    /// See [`DescribeImportImageTasks`](crate::client::fluent_builders::DescribeImportImageTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeImportImageTasks::into_paginator).
    pub fn describe_import_image_tasks(
        &self,
    ) -> fluent_builders::DescribeImportImageTasks<C, M, R> {
        fluent_builders::DescribeImportImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImportSnapshotTasks` operation.
    ///
    /// See [`DescribeImportSnapshotTasks`](crate::client::fluent_builders::DescribeImportSnapshotTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeImportSnapshotTasks::into_paginator).
    pub fn describe_import_snapshot_tasks(
        &self,
    ) -> fluent_builders::DescribeImportSnapshotTasks<C, M, R> {
        fluent_builders::DescribeImportSnapshotTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceAttribute` operation.
    ///
    /// See [`DescribeInstanceAttribute`](crate::client::fluent_builders::DescribeInstanceAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_attribute(
        &self,
    ) -> fluent_builders::DescribeInstanceAttribute<C, M, R> {
        fluent_builders::DescribeInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceCreditSpecifications` operation.
    ///
    /// See [`DescribeInstanceCreditSpecifications`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceCreditSpecifications::into_paginator).
    pub fn describe_instance_credit_specifications(
        &self,
    ) -> fluent_builders::DescribeInstanceCreditSpecifications<C, M, R> {
        fluent_builders::DescribeInstanceCreditSpecifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceEventNotificationAttributes` operation.
    ///
    /// See [`DescribeInstanceEventNotificationAttributes`](crate::client::fluent_builders::DescribeInstanceEventNotificationAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_event_notification_attributes(
        &self,
    ) -> fluent_builders::DescribeInstanceEventNotificationAttributes<C, M, R> {
        fluent_builders::DescribeInstanceEventNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceEventWindows` operation.
    ///
    /// See [`DescribeInstanceEventWindows`](crate::client::fluent_builders::DescribeInstanceEventWindows) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceEventWindows::into_paginator).
    pub fn describe_instance_event_windows(
        &self,
    ) -> fluent_builders::DescribeInstanceEventWindows<C, M, R> {
        fluent_builders::DescribeInstanceEventWindows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstances` operation.
    ///
    /// See [`DescribeInstances`](crate::client::fluent_builders::DescribeInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstances::into_paginator).
    pub fn describe_instances(&self) -> fluent_builders::DescribeInstances<C, M, R> {
        fluent_builders::DescribeInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceStatus` operation.
    ///
    /// See [`DescribeInstanceStatus`](crate::client::fluent_builders::DescribeInstanceStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceStatus::into_paginator).
    pub fn describe_instance_status(&self) -> fluent_builders::DescribeInstanceStatus<C, M, R> {
        fluent_builders::DescribeInstanceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceTypeOfferings` operation.
    ///
    /// See [`DescribeInstanceTypeOfferings`](crate::client::fluent_builders::DescribeInstanceTypeOfferings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceTypeOfferings::into_paginator).
    pub fn describe_instance_type_offerings(
        &self,
    ) -> fluent_builders::DescribeInstanceTypeOfferings<C, M, R> {
        fluent_builders::DescribeInstanceTypeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceTypes` operation.
    ///
    /// See [`DescribeInstanceTypes`](crate::client::fluent_builders::DescribeInstanceTypes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInstanceTypes::into_paginator).
    pub fn describe_instance_types(&self) -> fluent_builders::DescribeInstanceTypes<C, M, R> {
        fluent_builders::DescribeInstanceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInternetGateways` operation.
    ///
    /// See [`DescribeInternetGateways`](crate::client::fluent_builders::DescribeInternetGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeInternetGateways::into_paginator).
    pub fn describe_internet_gateways(&self) -> fluent_builders::DescribeInternetGateways<C, M, R> {
        fluent_builders::DescribeInternetGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpamPools` operation.
    ///
    /// See [`DescribeIpamPools`](crate::client::fluent_builders::DescribeIpamPools) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeIpamPools::into_paginator).
    pub fn describe_ipam_pools(&self) -> fluent_builders::DescribeIpamPools<C, M, R> {
        fluent_builders::DescribeIpamPools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpams` operation.
    ///
    /// See [`DescribeIpams`](crate::client::fluent_builders::DescribeIpams) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeIpams::into_paginator).
    pub fn describe_ipams(&self) -> fluent_builders::DescribeIpams<C, M, R> {
        fluent_builders::DescribeIpams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpamScopes` operation.
    ///
    /// See [`DescribeIpamScopes`](crate::client::fluent_builders::DescribeIpamScopes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeIpamScopes::into_paginator).
    pub fn describe_ipam_scopes(&self) -> fluent_builders::DescribeIpamScopes<C, M, R> {
        fluent_builders::DescribeIpamScopes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIpv6Pools` operation.
    ///
    /// See [`DescribeIpv6Pools`](crate::client::fluent_builders::DescribeIpv6Pools) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeIpv6Pools::into_paginator).
    pub fn describe_ipv6_pools(&self) -> fluent_builders::DescribeIpv6Pools<C, M, R> {
        fluent_builders::DescribeIpv6Pools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeKeyPairs` operation.
    ///
    /// See [`DescribeKeyPairs`](crate::client::fluent_builders::DescribeKeyPairs) for more information about the
    /// operation and its arguments.
    pub fn describe_key_pairs(&self) -> fluent_builders::DescribeKeyPairs<C, M, R> {
        fluent_builders::DescribeKeyPairs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLaunchTemplates` operation.
    ///
    /// See [`DescribeLaunchTemplates`](crate::client::fluent_builders::DescribeLaunchTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLaunchTemplates::into_paginator).
    pub fn describe_launch_templates(&self) -> fluent_builders::DescribeLaunchTemplates<C, M, R> {
        fluent_builders::DescribeLaunchTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLaunchTemplateVersions` operation.
    ///
    /// See [`DescribeLaunchTemplateVersions`](crate::client::fluent_builders::DescribeLaunchTemplateVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLaunchTemplateVersions::into_paginator).
    pub fn describe_launch_template_versions(
        &self,
    ) -> fluent_builders::DescribeLaunchTemplateVersions<C, M, R> {
        fluent_builders::DescribeLaunchTemplateVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocalGatewayRouteTables` operation.
    ///
    /// See [`DescribeLocalGatewayRouteTables`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTables::into_paginator).
    pub fn describe_local_gateway_route_tables(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTables<C, M, R> {
        fluent_builders::DescribeLocalGatewayRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations` operation.
    ///
    /// See [`DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::into_paginator).
    pub fn describe_local_gateway_route_table_virtual_interface_group_associations(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations<C, M, R>
    {
        fluent_builders::DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `DescribeLocalGatewayRouteTableVpcAssociations` operation.
    ///
    /// See [`DescribeLocalGatewayRouteTableVpcAssociations`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::into_paginator).
    pub fn describe_local_gateway_route_table_vpc_associations(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations<C, M, R> {
        fluent_builders::DescribeLocalGatewayRouteTableVpcAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocalGateways` operation.
    ///
    /// See [`DescribeLocalGateways`](crate::client::fluent_builders::DescribeLocalGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGateways::into_paginator).
    pub fn describe_local_gateways(&self) -> fluent_builders::DescribeLocalGateways<C, M, R> {
        fluent_builders::DescribeLocalGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocalGatewayVirtualInterfaceGroups` operation.
    ///
    /// See [`DescribeLocalGatewayVirtualInterfaceGroups`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::into_paginator).
    pub fn describe_local_gateway_virtual_interface_groups(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups<C, M, R> {
        fluent_builders::DescribeLocalGatewayVirtualInterfaceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLocalGatewayVirtualInterfaces` operation.
    ///
    /// See [`DescribeLocalGatewayVirtualInterfaces`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeLocalGatewayVirtualInterfaces::into_paginator).
    pub fn describe_local_gateway_virtual_interfaces(
        &self,
    ) -> fluent_builders::DescribeLocalGatewayVirtualInterfaces<C, M, R> {
        fluent_builders::DescribeLocalGatewayVirtualInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeManagedPrefixLists` operation.
    ///
    /// See [`DescribeManagedPrefixLists`](crate::client::fluent_builders::DescribeManagedPrefixLists) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeManagedPrefixLists::into_paginator).
    pub fn describe_managed_prefix_lists(
        &self,
    ) -> fluent_builders::DescribeManagedPrefixLists<C, M, R> {
        fluent_builders::DescribeManagedPrefixLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMovingAddresses` operation.
    ///
    /// See [`DescribeMovingAddresses`](crate::client::fluent_builders::DescribeMovingAddresses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeMovingAddresses::into_paginator).
    pub fn describe_moving_addresses(&self) -> fluent_builders::DescribeMovingAddresses<C, M, R> {
        fluent_builders::DescribeMovingAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNatGateways` operation.
    ///
    /// See [`DescribeNatGateways`](crate::client::fluent_builders::DescribeNatGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNatGateways::into_paginator).
    pub fn describe_nat_gateways(&self) -> fluent_builders::DescribeNatGateways<C, M, R> {
        fluent_builders::DescribeNatGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkAcls` operation.
    ///
    /// See [`DescribeNetworkAcls`](crate::client::fluent_builders::DescribeNetworkAcls) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkAcls::into_paginator).
    pub fn describe_network_acls(&self) -> fluent_builders::DescribeNetworkAcls<C, M, R> {
        fluent_builders::DescribeNetworkAcls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInsightsAccessScopeAnalyses` operation.
    ///
    /// See [`DescribeNetworkInsightsAccessScopeAnalyses`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::into_paginator).
    pub fn describe_network_insights_access_scope_analyses(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAccessScopeAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInsightsAccessScopes` operation.
    ///
    /// See [`DescribeNetworkInsightsAccessScopes`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAccessScopes::into_paginator).
    pub fn describe_network_insights_access_scopes(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAccessScopes<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAccessScopes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInsightsAnalyses` operation.
    ///
    /// See [`DescribeNetworkInsightsAnalyses`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsAnalyses::into_paginator).
    pub fn describe_network_insights_analyses(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsAnalyses<C, M, R> {
        fluent_builders::DescribeNetworkInsightsAnalyses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInsightsPaths` operation.
    ///
    /// See [`DescribeNetworkInsightsPaths`](crate::client::fluent_builders::DescribeNetworkInsightsPaths) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInsightsPaths::into_paginator).
    pub fn describe_network_insights_paths(
        &self,
    ) -> fluent_builders::DescribeNetworkInsightsPaths<C, M, R> {
        fluent_builders::DescribeNetworkInsightsPaths::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInterfaceAttribute` operation.
    ///
    /// See [`DescribeNetworkInterfaceAttribute`](crate::client::fluent_builders::DescribeNetworkInterfaceAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_network_interface_attribute(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfaceAttribute<C, M, R> {
        fluent_builders::DescribeNetworkInterfaceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInterfacePermissions` operation.
    ///
    /// See [`DescribeNetworkInterfacePermissions`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInterfacePermissions::into_paginator).
    pub fn describe_network_interface_permissions(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfacePermissions<C, M, R> {
        fluent_builders::DescribeNetworkInterfacePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNetworkInterfaces` operation.
    ///
    /// See [`DescribeNetworkInterfaces`](crate::client::fluent_builders::DescribeNetworkInterfaces) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeNetworkInterfaces::into_paginator).
    pub fn describe_network_interfaces(
        &self,
    ) -> fluent_builders::DescribeNetworkInterfaces<C, M, R> {
        fluent_builders::DescribeNetworkInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePlacementGroups` operation.
    ///
    /// See [`DescribePlacementGroups`](crate::client::fluent_builders::DescribePlacementGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_placement_groups(&self) -> fluent_builders::DescribePlacementGroups<C, M, R> {
        fluent_builders::DescribePlacementGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePrefixLists` operation.
    ///
    /// See [`DescribePrefixLists`](crate::client::fluent_builders::DescribePrefixLists) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribePrefixLists::into_paginator).
    pub fn describe_prefix_lists(&self) -> fluent_builders::DescribePrefixLists<C, M, R> {
        fluent_builders::DescribePrefixLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePrincipalIdFormat` operation.
    ///
    /// See [`DescribePrincipalIdFormat`](crate::client::fluent_builders::DescribePrincipalIdFormat) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribePrincipalIdFormat::into_paginator).
    pub fn describe_principal_id_format(
        &self,
    ) -> fluent_builders::DescribePrincipalIdFormat<C, M, R> {
        fluent_builders::DescribePrincipalIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePublicIpv4Pools` operation.
    ///
    /// See [`DescribePublicIpv4Pools`](crate::client::fluent_builders::DescribePublicIpv4Pools) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribePublicIpv4Pools::into_paginator).
    pub fn describe_public_ipv4_pools(&self) -> fluent_builders::DescribePublicIpv4Pools<C, M, R> {
        fluent_builders::DescribePublicIpv4Pools::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRegions` operation.
    ///
    /// See [`DescribeRegions`](crate::client::fluent_builders::DescribeRegions) for more information about the
    /// operation and its arguments.
    pub fn describe_regions(&self) -> fluent_builders::DescribeRegions<C, M, R> {
        fluent_builders::DescribeRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplaceRootVolumeTasks` operation.
    ///
    /// See [`DescribeReplaceRootVolumeTasks`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReplaceRootVolumeTasks::into_paginator).
    pub fn describe_replace_root_volume_tasks(
        &self,
    ) -> fluent_builders::DescribeReplaceRootVolumeTasks<C, M, R> {
        fluent_builders::DescribeReplaceRootVolumeTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstances` operation.
    ///
    /// See [`DescribeReservedInstances`](crate::client::fluent_builders::DescribeReservedInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_instances(
        &self,
    ) -> fluent_builders::DescribeReservedInstances<C, M, R> {
        fluent_builders::DescribeReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstancesListings` operation.
    ///
    /// See [`DescribeReservedInstancesListings`](crate::client::fluent_builders::DescribeReservedInstancesListings) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_instances_listings(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesListings<C, M, R> {
        fluent_builders::DescribeReservedInstancesListings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstancesModifications` operation.
    ///
    /// See [`DescribeReservedInstancesModifications`](crate::client::fluent_builders::DescribeReservedInstancesModifications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstancesModifications::into_paginator).
    pub fn describe_reserved_instances_modifications(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesModifications<C, M, R> {
        fluent_builders::DescribeReservedInstancesModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedInstancesOfferings` operation.
    ///
    /// See [`DescribeReservedInstancesOfferings`](crate::client::fluent_builders::DescribeReservedInstancesOfferings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedInstancesOfferings::into_paginator).
    pub fn describe_reserved_instances_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedInstancesOfferings<C, M, R> {
        fluent_builders::DescribeReservedInstancesOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRouteTables` operation.
    ///
    /// See [`DescribeRouteTables`](crate::client::fluent_builders::DescribeRouteTables) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeRouteTables::into_paginator).
    pub fn describe_route_tables(&self) -> fluent_builders::DescribeRouteTables<C, M, R> {
        fluent_builders::DescribeRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeScheduledInstanceAvailability` operation.
    ///
    /// See [`DescribeScheduledInstanceAvailability`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeScheduledInstanceAvailability::into_paginator).
    pub fn describe_scheduled_instance_availability(
        &self,
    ) -> fluent_builders::DescribeScheduledInstanceAvailability<C, M, R> {
        fluent_builders::DescribeScheduledInstanceAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeScheduledInstances` operation.
    ///
    /// See [`DescribeScheduledInstances`](crate::client::fluent_builders::DescribeScheduledInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeScheduledInstances::into_paginator).
    pub fn describe_scheduled_instances(
        &self,
    ) -> fluent_builders::DescribeScheduledInstances<C, M, R> {
        fluent_builders::DescribeScheduledInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecurityGroupReferences` operation.
    ///
    /// See [`DescribeSecurityGroupReferences`](crate::client::fluent_builders::DescribeSecurityGroupReferences) for more information about the
    /// operation and its arguments.
    pub fn describe_security_group_references(
        &self,
    ) -> fluent_builders::DescribeSecurityGroupReferences<C, M, R> {
        fluent_builders::DescribeSecurityGroupReferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecurityGroupRules` operation.
    ///
    /// See [`DescribeSecurityGroupRules`](crate::client::fluent_builders::DescribeSecurityGroupRules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSecurityGroupRules::into_paginator).
    pub fn describe_security_group_rules(
        &self,
    ) -> fluent_builders::DescribeSecurityGroupRules<C, M, R> {
        fluent_builders::DescribeSecurityGroupRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecurityGroups` operation.
    ///
    /// See [`DescribeSecurityGroups`](crate::client::fluent_builders::DescribeSecurityGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSecurityGroups::into_paginator).
    pub fn describe_security_groups(&self) -> fluent_builders::DescribeSecurityGroups<C, M, R> {
        fluent_builders::DescribeSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshotAttribute` operation.
    ///
    /// See [`DescribeSnapshotAttribute`](crate::client::fluent_builders::DescribeSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshot_attribute(
        &self,
    ) -> fluent_builders::DescribeSnapshotAttribute<C, M, R> {
        fluent_builders::DescribeSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshots` operation.
    ///
    /// See [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshots::into_paginator).
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots<C, M, R> {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshotTierStatus` operation.
    ///
    /// See [`DescribeSnapshotTierStatus`](crate::client::fluent_builders::DescribeSnapshotTierStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshotTierStatus::into_paginator).
    pub fn describe_snapshot_tier_status(
        &self,
    ) -> fluent_builders::DescribeSnapshotTierStatus<C, M, R> {
        fluent_builders::DescribeSnapshotTierStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotDatafeedSubscription` operation.
    ///
    /// See [`DescribeSpotDatafeedSubscription`](crate::client::fluent_builders::DescribeSpotDatafeedSubscription) for more information about the
    /// operation and its arguments.
    pub fn describe_spot_datafeed_subscription(
        &self,
    ) -> fluent_builders::DescribeSpotDatafeedSubscription<C, M, R> {
        fluent_builders::DescribeSpotDatafeedSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotFleetInstances` operation.
    ///
    /// See [`DescribeSpotFleetInstances`](crate::client::fluent_builders::DescribeSpotFleetInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_spot_fleet_instances(
        &self,
    ) -> fluent_builders::DescribeSpotFleetInstances<C, M, R> {
        fluent_builders::DescribeSpotFleetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotFleetRequestHistory` operation.
    ///
    /// See [`DescribeSpotFleetRequestHistory`](crate::client::fluent_builders::DescribeSpotFleetRequestHistory) for more information about the
    /// operation and its arguments.
    pub fn describe_spot_fleet_request_history(
        &self,
    ) -> fluent_builders::DescribeSpotFleetRequestHistory<C, M, R> {
        fluent_builders::DescribeSpotFleetRequestHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotFleetRequests` operation.
    ///
    /// See [`DescribeSpotFleetRequests`](crate::client::fluent_builders::DescribeSpotFleetRequests) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotFleetRequests::into_paginator).
    pub fn describe_spot_fleet_requests(
        &self,
    ) -> fluent_builders::DescribeSpotFleetRequests<C, M, R> {
        fluent_builders::DescribeSpotFleetRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotInstanceRequests` operation.
    ///
    /// See [`DescribeSpotInstanceRequests`](crate::client::fluent_builders::DescribeSpotInstanceRequests) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotInstanceRequests::into_paginator).
    pub fn describe_spot_instance_requests(
        &self,
    ) -> fluent_builders::DescribeSpotInstanceRequests<C, M, R> {
        fluent_builders::DescribeSpotInstanceRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSpotPriceHistory` operation.
    ///
    /// See [`DescribeSpotPriceHistory`](crate::client::fluent_builders::DescribeSpotPriceHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSpotPriceHistory::into_paginator).
    pub fn describe_spot_price_history(
        &self,
    ) -> fluent_builders::DescribeSpotPriceHistory<C, M, R> {
        fluent_builders::DescribeSpotPriceHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStaleSecurityGroups` operation.
    ///
    /// See [`DescribeStaleSecurityGroups`](crate::client::fluent_builders::DescribeStaleSecurityGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeStaleSecurityGroups::into_paginator).
    pub fn describe_stale_security_groups(
        &self,
    ) -> fluent_builders::DescribeStaleSecurityGroups<C, M, R> {
        fluent_builders::DescribeStaleSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStoreImageTasks` operation.
    ///
    /// See [`DescribeStoreImageTasks`](crate::client::fluent_builders::DescribeStoreImageTasks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeStoreImageTasks::into_paginator).
    pub fn describe_store_image_tasks(&self) -> fluent_builders::DescribeStoreImageTasks<C, M, R> {
        fluent_builders::DescribeStoreImageTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubnets` operation.
    ///
    /// See [`DescribeSubnets`](crate::client::fluent_builders::DescribeSubnets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeSubnets::into_paginator).
    pub fn describe_subnets(&self) -> fluent_builders::DescribeSubnets<C, M, R> {
        fluent_builders::DescribeSubnets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTags::into_paginator).
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrafficMirrorFilters` operation.
    ///
    /// See [`DescribeTrafficMirrorFilters`](crate::client::fluent_builders::DescribeTrafficMirrorFilters) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorFilters::into_paginator).
    pub fn describe_traffic_mirror_filters(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorFilters<C, M, R> {
        fluent_builders::DescribeTrafficMirrorFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrafficMirrorSessions` operation.
    ///
    /// See [`DescribeTrafficMirrorSessions`](crate::client::fluent_builders::DescribeTrafficMirrorSessions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorSessions::into_paginator).
    pub fn describe_traffic_mirror_sessions(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorSessions<C, M, R> {
        fluent_builders::DescribeTrafficMirrorSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrafficMirrorTargets` operation.
    ///
    /// See [`DescribeTrafficMirrorTargets`](crate::client::fluent_builders::DescribeTrafficMirrorTargets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTrafficMirrorTargets::into_paginator).
    pub fn describe_traffic_mirror_targets(
        &self,
    ) -> fluent_builders::DescribeTrafficMirrorTargets<C, M, R> {
        fluent_builders::DescribeTrafficMirrorTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayAttachments` operation.
    ///
    /// See [`DescribeTransitGatewayAttachments`](crate::client::fluent_builders::DescribeTransitGatewayAttachments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayAttachments::into_paginator).
    pub fn describe_transit_gateway_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayConnectPeers` operation.
    ///
    /// See [`DescribeTransitGatewayConnectPeers`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayConnectPeers::into_paginator).
    pub fn describe_transit_gateway_connect_peers(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayConnectPeers<C, M, R> {
        fluent_builders::DescribeTransitGatewayConnectPeers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayConnects` operation.
    ///
    /// See [`DescribeTransitGatewayConnects`](crate::client::fluent_builders::DescribeTransitGatewayConnects) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayConnects::into_paginator).
    pub fn describe_transit_gateway_connects(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayConnects<C, M, R> {
        fluent_builders::DescribeTransitGatewayConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayMulticastDomains` operation.
    ///
    /// See [`DescribeTransitGatewayMulticastDomains`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayMulticastDomains::into_paginator).
    pub fn describe_transit_gateway_multicast_domains(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayMulticastDomains<C, M, R> {
        fluent_builders::DescribeTransitGatewayMulticastDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayPeeringAttachments` operation.
    ///
    /// See [`DescribeTransitGatewayPeeringAttachments`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayPeeringAttachments::into_paginator).
    pub fn describe_transit_gateway_peering_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayPeeringAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayPeeringAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayRouteTables` operation.
    ///
    /// See [`DescribeTransitGatewayRouteTables`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayRouteTables::into_paginator).
    pub fn describe_transit_gateway_route_tables(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayRouteTables<C, M, R> {
        fluent_builders::DescribeTransitGatewayRouteTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGateways` operation.
    ///
    /// See [`DescribeTransitGateways`](crate::client::fluent_builders::DescribeTransitGateways) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGateways::into_paginator).
    pub fn describe_transit_gateways(&self) -> fluent_builders::DescribeTransitGateways<C, M, R> {
        fluent_builders::DescribeTransitGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransitGatewayVpcAttachments` operation.
    ///
    /// See [`DescribeTransitGatewayVpcAttachments`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTransitGatewayVpcAttachments::into_paginator).
    pub fn describe_transit_gateway_vpc_attachments(
        &self,
    ) -> fluent_builders::DescribeTransitGatewayVpcAttachments<C, M, R> {
        fluent_builders::DescribeTransitGatewayVpcAttachments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrunkInterfaceAssociations` operation.
    ///
    /// See [`DescribeTrunkInterfaceAssociations`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeTrunkInterfaceAssociations::into_paginator).
    pub fn describe_trunk_interface_associations(
        &self,
    ) -> fluent_builders::DescribeTrunkInterfaceAssociations<C, M, R> {
        fluent_builders::DescribeTrunkInterfaceAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVolumeAttribute` operation.
    ///
    /// See [`DescribeVolumeAttribute`](crate::client::fluent_builders::DescribeVolumeAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_volume_attribute(&self) -> fluent_builders::DescribeVolumeAttribute<C, M, R> {
        fluent_builders::DescribeVolumeAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVolumes` operation.
    ///
    /// See [`DescribeVolumes`](crate::client::fluent_builders::DescribeVolumes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumes::into_paginator).
    pub fn describe_volumes(&self) -> fluent_builders::DescribeVolumes<C, M, R> {
        fluent_builders::DescribeVolumes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVolumesModifications` operation.
    ///
    /// See [`DescribeVolumesModifications`](crate::client::fluent_builders::DescribeVolumesModifications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumesModifications::into_paginator).
    pub fn describe_volumes_modifications(
        &self,
    ) -> fluent_builders::DescribeVolumesModifications<C, M, R> {
        fluent_builders::DescribeVolumesModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVolumeStatus` operation.
    ///
    /// See [`DescribeVolumeStatus`](crate::client::fluent_builders::DescribeVolumeStatus) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVolumeStatus::into_paginator).
    pub fn describe_volume_status(&self) -> fluent_builders::DescribeVolumeStatus<C, M, R> {
        fluent_builders::DescribeVolumeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcAttribute` operation.
    ///
    /// See [`DescribeVpcAttribute`](crate::client::fluent_builders::DescribeVpcAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_vpc_attribute(&self) -> fluent_builders::DescribeVpcAttribute<C, M, R> {
        fluent_builders::DescribeVpcAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcClassicLink` operation.
    ///
    /// See [`DescribeVpcClassicLink`](crate::client::fluent_builders::DescribeVpcClassicLink) for more information about the
    /// operation and its arguments.
    pub fn describe_vpc_classic_link(&self) -> fluent_builders::DescribeVpcClassicLink<C, M, R> {
        fluent_builders::DescribeVpcClassicLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcClassicLinkDnsSupport` operation.
    ///
    /// See [`DescribeVpcClassicLinkDnsSupport`](crate::client::fluent_builders::DescribeVpcClassicLinkDnsSupport) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcClassicLinkDnsSupport::into_paginator).
    pub fn describe_vpc_classic_link_dns_support(
        &self,
    ) -> fluent_builders::DescribeVpcClassicLinkDnsSupport<C, M, R> {
        fluent_builders::DescribeVpcClassicLinkDnsSupport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpointConnectionNotifications` operation.
    ///
    /// See [`DescribeVpcEndpointConnectionNotifications`](crate::client::fluent_builders::DescribeVpcEndpointConnectionNotifications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcEndpointConnectionNotifications::into_paginator).
    pub fn describe_vpc_endpoint_connection_notifications(
        &self,
    ) -> fluent_builders::DescribeVpcEndpointConnectionNotifications<C, M, R> {
        fluent_builders::DescribeVpcEndpointConnectionNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpointConnections` operation.
    ///
    /// See [`DescribeVpcEndpointConnections`](crate::client::fluent_builders::DescribeVpcEndpointConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcEndpointConnections::into_paginator).
    pub fn describe_vpc_endpoint_connections(
        &self,
    ) -> fluent_builders::DescribeVpcEndpointConnections<C, M, R> {
        fluent_builders::DescribeVpcEndpointConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpoints` operation.
    ///
    /// See [`DescribeVpcEndpoints`](crate::client::fluent_builders::DescribeVpcEndpoints) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcEndpoints::into_paginator).
    pub fn describe_vpc_endpoints(&self) -> fluent_builders::DescribeVpcEndpoints<C, M, R> {
        fluent_builders::DescribeVpcEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpointServiceConfigurations` operation.
    ///
    /// See [`DescribeVpcEndpointServiceConfigurations`](crate::client::fluent_builders::DescribeVpcEndpointServiceConfigurations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcEndpointServiceConfigurations::into_paginator).
    pub fn describe_vpc_endpoint_service_configurations(
        &self,
    ) -> fluent_builders::DescribeVpcEndpointServiceConfigurations<C, M, R> {
        fluent_builders::DescribeVpcEndpointServiceConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpointServicePermissions` operation.
    ///
    /// See [`DescribeVpcEndpointServicePermissions`](crate::client::fluent_builders::DescribeVpcEndpointServicePermissions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcEndpointServicePermissions::into_paginator).
    pub fn describe_vpc_endpoint_service_permissions(
        &self,
    ) -> fluent_builders::DescribeVpcEndpointServicePermissions<C, M, R> {
        fluent_builders::DescribeVpcEndpointServicePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcEndpointServices` operation.
    ///
    /// See [`DescribeVpcEndpointServices`](crate::client::fluent_builders::DescribeVpcEndpointServices) for more information about the
    /// operation and its arguments.
    pub fn describe_vpc_endpoint_services(
        &self,
    ) -> fluent_builders::DescribeVpcEndpointServices<C, M, R> {
        fluent_builders::DescribeVpcEndpointServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcPeeringConnections` operation.
    ///
    /// See [`DescribeVpcPeeringConnections`](crate::client::fluent_builders::DescribeVpcPeeringConnections) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcPeeringConnections::into_paginator).
    pub fn describe_vpc_peering_connections(
        &self,
    ) -> fluent_builders::DescribeVpcPeeringConnections<C, M, R> {
        fluent_builders::DescribeVpcPeeringConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpcs` operation.
    ///
    /// See [`DescribeVpcs`](crate::client::fluent_builders::DescribeVpcs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::DescribeVpcs::into_paginator).
    pub fn describe_vpcs(&self) -> fluent_builders::DescribeVpcs<C, M, R> {
        fluent_builders::DescribeVpcs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpnConnections` operation.
    ///
    /// See [`DescribeVpnConnections`](crate::client::fluent_builders::DescribeVpnConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_vpn_connections(&self) -> fluent_builders::DescribeVpnConnections<C, M, R> {
        fluent_builders::DescribeVpnConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeVpnGateways` operation.
    ///
    /// See [`DescribeVpnGateways`](crate::client::fluent_builders::DescribeVpnGateways) for more information about the
    /// operation and its arguments.
    pub fn describe_vpn_gateways(&self) -> fluent_builders::DescribeVpnGateways<C, M, R> {
        fluent_builders::DescribeVpnGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachClassicLinkVpc` operation.
    ///
    /// See [`DetachClassicLinkVpc`](crate::client::fluent_builders::DetachClassicLinkVpc) for more information about the
    /// operation and its arguments.
    pub fn detach_classic_link_vpc(&self) -> fluent_builders::DetachClassicLinkVpc<C, M, R> {
        fluent_builders::DetachClassicLinkVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachInternetGateway` operation.
    ///
    /// See [`DetachInternetGateway`](crate::client::fluent_builders::DetachInternetGateway) for more information about the
    /// operation and its arguments.
    pub fn detach_internet_gateway(&self) -> fluent_builders::DetachInternetGateway<C, M, R> {
        fluent_builders::DetachInternetGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachNetworkInterface` operation.
    ///
    /// See [`DetachNetworkInterface`](crate::client::fluent_builders::DetachNetworkInterface) for more information about the
    /// operation and its arguments.
    pub fn detach_network_interface(&self) -> fluent_builders::DetachNetworkInterface<C, M, R> {
        fluent_builders::DetachNetworkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachVolume` operation.
    ///
    /// See [`DetachVolume`](crate::client::fluent_builders::DetachVolume) for more information about the
    /// operation and its arguments.
    pub fn detach_volume(&self) -> fluent_builders::DetachVolume<C, M, R> {
        fluent_builders::DetachVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachVpnGateway` operation.
    ///
    /// See [`DetachVpnGateway`](crate::client::fluent_builders::DetachVpnGateway) for more information about the
    /// operation and its arguments.
    pub fn detach_vpn_gateway(&self) -> fluent_builders::DetachVpnGateway<C, M, R> {
        fluent_builders::DetachVpnGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableEbsEncryptionByDefault` operation.
    ///
    /// See [`DisableEbsEncryptionByDefault`](crate::client::fluent_builders::DisableEbsEncryptionByDefault) for more information about the
    /// operation and its arguments.
    pub fn disable_ebs_encryption_by_default(
        &self,
    ) -> fluent_builders::DisableEbsEncryptionByDefault<C, M, R> {
        fluent_builders::DisableEbsEncryptionByDefault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableFastSnapshotRestores` operation.
    ///
    /// See [`DisableFastSnapshotRestores`](crate::client::fluent_builders::DisableFastSnapshotRestores) for more information about the
    /// operation and its arguments.
    pub fn disable_fast_snapshot_restores(
        &self,
    ) -> fluent_builders::DisableFastSnapshotRestores<C, M, R> {
        fluent_builders::DisableFastSnapshotRestores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableImageDeprecation` operation.
    ///
    /// See [`DisableImageDeprecation`](crate::client::fluent_builders::DisableImageDeprecation) for more information about the
    /// operation and its arguments.
    pub fn disable_image_deprecation(&self) -> fluent_builders::DisableImageDeprecation<C, M, R> {
        fluent_builders::DisableImageDeprecation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableIpamOrganizationAdminAccount` operation.
    ///
    /// See [`DisableIpamOrganizationAdminAccount`](crate::client::fluent_builders::DisableIpamOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn disable_ipam_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableIpamOrganizationAdminAccount<C, M, R> {
        fluent_builders::DisableIpamOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableSerialConsoleAccess` operation.
    ///
    /// See [`DisableSerialConsoleAccess`](crate::client::fluent_builders::DisableSerialConsoleAccess) for more information about the
    /// operation and its arguments.
    pub fn disable_serial_console_access(
        &self,
    ) -> fluent_builders::DisableSerialConsoleAccess<C, M, R> {
        fluent_builders::DisableSerialConsoleAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableTransitGatewayRouteTablePropagation` operation.
    ///
    /// See [`DisableTransitGatewayRouteTablePropagation`](crate::client::fluent_builders::DisableTransitGatewayRouteTablePropagation) for more information about the
    /// operation and its arguments.
    pub fn disable_transit_gateway_route_table_propagation(
        &self,
    ) -> fluent_builders::DisableTransitGatewayRouteTablePropagation<C, M, R> {
        fluent_builders::DisableTransitGatewayRouteTablePropagation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableVgwRoutePropagation` operation.
    ///
    /// See [`DisableVgwRoutePropagation`](crate::client::fluent_builders::DisableVgwRoutePropagation) for more information about the
    /// operation and its arguments.
    pub fn disable_vgw_route_propagation(
        &self,
    ) -> fluent_builders::DisableVgwRoutePropagation<C, M, R> {
        fluent_builders::DisableVgwRoutePropagation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableVpcClassicLink` operation.
    ///
    /// See [`DisableVpcClassicLink`](crate::client::fluent_builders::DisableVpcClassicLink) for more information about the
    /// operation and its arguments.
    pub fn disable_vpc_classic_link(&self) -> fluent_builders::DisableVpcClassicLink<C, M, R> {
        fluent_builders::DisableVpcClassicLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableVpcClassicLinkDnsSupport` operation.
    ///
    /// See [`DisableVpcClassicLinkDnsSupport`](crate::client::fluent_builders::DisableVpcClassicLinkDnsSupport) for more information about the
    /// operation and its arguments.
    pub fn disable_vpc_classic_link_dns_support(
        &self,
    ) -> fluent_builders::DisableVpcClassicLinkDnsSupport<C, M, R> {
        fluent_builders::DisableVpcClassicLinkDnsSupport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateAddress` operation.
    ///
    /// See [`DisassociateAddress`](crate::client::fluent_builders::DisassociateAddress) for more information about the
    /// operation and its arguments.
    pub fn disassociate_address(&self) -> fluent_builders::DisassociateAddress<C, M, R> {
        fluent_builders::DisassociateAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateClientVpnTargetNetwork` operation.
    ///
    /// See [`DisassociateClientVpnTargetNetwork`](crate::client::fluent_builders::DisassociateClientVpnTargetNetwork) for more information about the
    /// operation and its arguments.
    pub fn disassociate_client_vpn_target_network(
        &self,
    ) -> fluent_builders::DisassociateClientVpnTargetNetwork<C, M, R> {
        fluent_builders::DisassociateClientVpnTargetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateEnclaveCertificateIamRole` operation.
    ///
    /// See [`DisassociateEnclaveCertificateIamRole`](crate::client::fluent_builders::DisassociateEnclaveCertificateIamRole) for more information about the
    /// operation and its arguments.
    pub fn disassociate_enclave_certificate_iam_role(
        &self,
    ) -> fluent_builders::DisassociateEnclaveCertificateIamRole<C, M, R> {
        fluent_builders::DisassociateEnclaveCertificateIamRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateIamInstanceProfile` operation.
    ///
    /// See [`DisassociateIamInstanceProfile`](crate::client::fluent_builders::DisassociateIamInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn disassociate_iam_instance_profile(
        &self,
    ) -> fluent_builders::DisassociateIamInstanceProfile<C, M, R> {
        fluent_builders::DisassociateIamInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateInstanceEventWindow` operation.
    ///
    /// See [`DisassociateInstanceEventWindow`](crate::client::fluent_builders::DisassociateInstanceEventWindow) for more information about the
    /// operation and its arguments.
    pub fn disassociate_instance_event_window(
        &self,
    ) -> fluent_builders::DisassociateInstanceEventWindow<C, M, R> {
        fluent_builders::DisassociateInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateRouteTable` operation.
    ///
    /// See [`DisassociateRouteTable`](crate::client::fluent_builders::DisassociateRouteTable) for more information about the
    /// operation and its arguments.
    pub fn disassociate_route_table(&self) -> fluent_builders::DisassociateRouteTable<C, M, R> {
        fluent_builders::DisassociateRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSubnetCidrBlock` operation.
    ///
    /// See [`DisassociateSubnetCidrBlock`](crate::client::fluent_builders::DisassociateSubnetCidrBlock) for more information about the
    /// operation and its arguments.
    pub fn disassociate_subnet_cidr_block(
        &self,
    ) -> fluent_builders::DisassociateSubnetCidrBlock<C, M, R> {
        fluent_builders::DisassociateSubnetCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTransitGatewayMulticastDomain` operation.
    ///
    /// See [`DisassociateTransitGatewayMulticastDomain`](crate::client::fluent_builders::DisassociateTransitGatewayMulticastDomain) for more information about the
    /// operation and its arguments.
    pub fn disassociate_transit_gateway_multicast_domain(
        &self,
    ) -> fluent_builders::DisassociateTransitGatewayMulticastDomain<C, M, R> {
        fluent_builders::DisassociateTransitGatewayMulticastDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTransitGatewayRouteTable` operation.
    ///
    /// See [`DisassociateTransitGatewayRouteTable`](crate::client::fluent_builders::DisassociateTransitGatewayRouteTable) for more information about the
    /// operation and its arguments.
    pub fn disassociate_transit_gateway_route_table(
        &self,
    ) -> fluent_builders::DisassociateTransitGatewayRouteTable<C, M, R> {
        fluent_builders::DisassociateTransitGatewayRouteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTrunkInterface` operation.
    ///
    /// See [`DisassociateTrunkInterface`](crate::client::fluent_builders::DisassociateTrunkInterface) for more information about the
    /// operation and its arguments.
    pub fn disassociate_trunk_interface(
        &self,
    ) -> fluent_builders::DisassociateTrunkInterface<C, M, R> {
        fluent_builders::DisassociateTrunkInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateVpcCidrBlock` operation.
    ///
    /// See [`DisassociateVpcCidrBlock`](crate::client::fluent_builders::DisassociateVpcCidrBlock) for more information about the
    /// operation and its arguments.
    pub fn disassociate_vpc_cidr_block(
        &self,
    ) -> fluent_builders::DisassociateVpcCidrBlock<C, M, R> {
        fluent_builders::DisassociateVpcCidrBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableEbsEncryptionByDefault` operation.
    ///
    /// See [`EnableEbsEncryptionByDefault`](crate::client::fluent_builders::EnableEbsEncryptionByDefault) for more information about the
    /// operation and its arguments.
    pub fn enable_ebs_encryption_by_default(
        &self,
    ) -> fluent_builders::EnableEbsEncryptionByDefault<C, M, R> {
        fluent_builders::EnableEbsEncryptionByDefault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableFastSnapshotRestores` operation.
    ///
    /// See [`EnableFastSnapshotRestores`](crate::client::fluent_builders::EnableFastSnapshotRestores) for more information about the
    /// operation and its arguments.
    pub fn enable_fast_snapshot_restores(
        &self,
    ) -> fluent_builders::EnableFastSnapshotRestores<C, M, R> {
        fluent_builders::EnableFastSnapshotRestores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableImageDeprecation` operation.
    ///
    /// See [`EnableImageDeprecation`](crate::client::fluent_builders::EnableImageDeprecation) for more information about the
    /// operation and its arguments.
    pub fn enable_image_deprecation(&self) -> fluent_builders::EnableImageDeprecation<C, M, R> {
        fluent_builders::EnableImageDeprecation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableIpamOrganizationAdminAccount` operation.
    ///
    /// See [`EnableIpamOrganizationAdminAccount`](crate::client::fluent_builders::EnableIpamOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn enable_ipam_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableIpamOrganizationAdminAccount<C, M, R> {
        fluent_builders::EnableIpamOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableSerialConsoleAccess` operation.
    ///
    /// See [`EnableSerialConsoleAccess`](crate::client::fluent_builders::EnableSerialConsoleAccess) for more information about the
    /// operation and its arguments.
    pub fn enable_serial_console_access(
        &self,
    ) -> fluent_builders::EnableSerialConsoleAccess<C, M, R> {
        fluent_builders::EnableSerialConsoleAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableTransitGatewayRouteTablePropagation` operation.
    ///
    /// See [`EnableTransitGatewayRouteTablePropagation`](crate::client::fluent_builders::EnableTransitGatewayRouteTablePropagation) for more information about the
    /// operation and its arguments.
    pub fn enable_transit_gateway_route_table_propagation(
        &self,
    ) -> fluent_builders::EnableTransitGatewayRouteTablePropagation<C, M, R> {
        fluent_builders::EnableTransitGatewayRouteTablePropagation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableVgwRoutePropagation` operation.
    ///
    /// See [`EnableVgwRoutePropagation`](crate::client::fluent_builders::EnableVgwRoutePropagation) for more information about the
    /// operation and its arguments.
    pub fn enable_vgw_route_propagation(
        &self,
    ) -> fluent_builders::EnableVgwRoutePropagation<C, M, R> {
        fluent_builders::EnableVgwRoutePropagation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableVolumeIO` operation.
    ///
    /// See [`EnableVolumeIO`](crate::client::fluent_builders::EnableVolumeIO) for more information about the
    /// operation and its arguments.
    pub fn enable_volume_io(&self) -> fluent_builders::EnableVolumeIO<C, M, R> {
        fluent_builders::EnableVolumeIO::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableVpcClassicLink` operation.
    ///
    /// See [`EnableVpcClassicLink`](crate::client::fluent_builders::EnableVpcClassicLink) for more information about the
    /// operation and its arguments.
    pub fn enable_vpc_classic_link(&self) -> fluent_builders::EnableVpcClassicLink<C, M, R> {
        fluent_builders::EnableVpcClassicLink::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableVpcClassicLinkDnsSupport` operation.
    ///
    /// See [`EnableVpcClassicLinkDnsSupport`](crate::client::fluent_builders::EnableVpcClassicLinkDnsSupport) for more information about the
    /// operation and its arguments.
    pub fn enable_vpc_classic_link_dns_support(
        &self,
    ) -> fluent_builders::EnableVpcClassicLinkDnsSupport<C, M, R> {
        fluent_builders::EnableVpcClassicLinkDnsSupport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportClientVpnClientCertificateRevocationList` operation.
    ///
    /// See [`ExportClientVpnClientCertificateRevocationList`](crate::client::fluent_builders::ExportClientVpnClientCertificateRevocationList) for more information about the
    /// operation and its arguments.
    pub fn export_client_vpn_client_certificate_revocation_list(
        &self,
    ) -> fluent_builders::ExportClientVpnClientCertificateRevocationList<C, M, R> {
        fluent_builders::ExportClientVpnClientCertificateRevocationList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportClientVpnClientConfiguration` operation.
    ///
    /// See [`ExportClientVpnClientConfiguration`](crate::client::fluent_builders::ExportClientVpnClientConfiguration) for more information about the
    /// operation and its arguments.
    pub fn export_client_vpn_client_configuration(
        &self,
    ) -> fluent_builders::ExportClientVpnClientConfiguration<C, M, R> {
        fluent_builders::ExportClientVpnClientConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportImage` operation.
    ///
    /// See [`ExportImage`](crate::client::fluent_builders::ExportImage) for more information about the
    /// operation and its arguments.
    pub fn export_image(&self) -> fluent_builders::ExportImage<C, M, R> {
        fluent_builders::ExportImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportTransitGatewayRoutes` operation.
    ///
    /// See [`ExportTransitGatewayRoutes`](crate::client::fluent_builders::ExportTransitGatewayRoutes) for more information about the
    /// operation and its arguments.
    pub fn export_transit_gateway_routes(
        &self,
    ) -> fluent_builders::ExportTransitGatewayRoutes<C, M, R> {
        fluent_builders::ExportTransitGatewayRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssociatedEnclaveCertificateIamRoles` operation.
    ///
    /// See [`GetAssociatedEnclaveCertificateIamRoles`](crate::client::fluent_builders::GetAssociatedEnclaveCertificateIamRoles) for more information about the
    /// operation and its arguments.
    pub fn get_associated_enclave_certificate_iam_roles(
        &self,
    ) -> fluent_builders::GetAssociatedEnclaveCertificateIamRoles<C, M, R> {
        fluent_builders::GetAssociatedEnclaveCertificateIamRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssociatedIpv6PoolCidrs` operation.
    ///
    /// See [`GetAssociatedIpv6PoolCidrs`](crate::client::fluent_builders::GetAssociatedIpv6PoolCidrs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetAssociatedIpv6PoolCidrs::into_paginator).
    pub fn get_associated_ipv6_pool_cidrs(
        &self,
    ) -> fluent_builders::GetAssociatedIpv6PoolCidrs<C, M, R> {
        fluent_builders::GetAssociatedIpv6PoolCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCapacityReservationUsage` operation.
    ///
    /// See [`GetCapacityReservationUsage`](crate::client::fluent_builders::GetCapacityReservationUsage) for more information about the
    /// operation and its arguments.
    pub fn get_capacity_reservation_usage(
        &self,
    ) -> fluent_builders::GetCapacityReservationUsage<C, M, R> {
        fluent_builders::GetCapacityReservationUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoipPoolUsage` operation.
    ///
    /// See [`GetCoipPoolUsage`](crate::client::fluent_builders::GetCoipPoolUsage) for more information about the
    /// operation and its arguments.
    pub fn get_coip_pool_usage(&self) -> fluent_builders::GetCoipPoolUsage<C, M, R> {
        fluent_builders::GetCoipPoolUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConsoleOutput` operation.
    ///
    /// See [`GetConsoleOutput`](crate::client::fluent_builders::GetConsoleOutput) for more information about the
    /// operation and its arguments.
    pub fn get_console_output(&self) -> fluent_builders::GetConsoleOutput<C, M, R> {
        fluent_builders::GetConsoleOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConsoleScreenshot` operation.
    ///
    /// See [`GetConsoleScreenshot`](crate::client::fluent_builders::GetConsoleScreenshot) for more information about the
    /// operation and its arguments.
    pub fn get_console_screenshot(&self) -> fluent_builders::GetConsoleScreenshot<C, M, R> {
        fluent_builders::GetConsoleScreenshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDefaultCreditSpecification` operation.
    ///
    /// See [`GetDefaultCreditSpecification`](crate::client::fluent_builders::GetDefaultCreditSpecification) for more information about the
    /// operation and its arguments.
    pub fn get_default_credit_specification(
        &self,
    ) -> fluent_builders::GetDefaultCreditSpecification<C, M, R> {
        fluent_builders::GetDefaultCreditSpecification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEbsDefaultKmsKeyId` operation.
    ///
    /// See [`GetEbsDefaultKmsKeyId`](crate::client::fluent_builders::GetEbsDefaultKmsKeyId) for more information about the
    /// operation and its arguments.
    pub fn get_ebs_default_kms_key_id(&self) -> fluent_builders::GetEbsDefaultKmsKeyId<C, M, R> {
        fluent_builders::GetEbsDefaultKmsKeyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEbsEncryptionByDefault` operation.
    ///
    /// See [`GetEbsEncryptionByDefault`](crate::client::fluent_builders::GetEbsEncryptionByDefault) for more information about the
    /// operation and its arguments.
    pub fn get_ebs_encryption_by_default(
        &self,
    ) -> fluent_builders::GetEbsEncryptionByDefault<C, M, R> {
        fluent_builders::GetEbsEncryptionByDefault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFlowLogsIntegrationTemplate` operation.
    ///
    /// See [`GetFlowLogsIntegrationTemplate`](crate::client::fluent_builders::GetFlowLogsIntegrationTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_flow_logs_integration_template(
        &self,
    ) -> fluent_builders::GetFlowLogsIntegrationTemplate<C, M, R> {
        fluent_builders::GetFlowLogsIntegrationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupsForCapacityReservation` operation.
    ///
    /// See [`GetGroupsForCapacityReservation`](crate::client::fluent_builders::GetGroupsForCapacityReservation) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetGroupsForCapacityReservation::into_paginator).
    pub fn get_groups_for_capacity_reservation(
        &self,
    ) -> fluent_builders::GetGroupsForCapacityReservation<C, M, R> {
        fluent_builders::GetGroupsForCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHostReservationPurchasePreview` operation.
    ///
    /// See [`GetHostReservationPurchasePreview`](crate::client::fluent_builders::GetHostReservationPurchasePreview) for more information about the
    /// operation and its arguments.
    pub fn get_host_reservation_purchase_preview(
        &self,
    ) -> fluent_builders::GetHostReservationPurchasePreview<C, M, R> {
        fluent_builders::GetHostReservationPurchasePreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceTypesFromInstanceRequirements` operation.
    ///
    /// See [`GetInstanceTypesFromInstanceRequirements`](crate::client::fluent_builders::GetInstanceTypesFromInstanceRequirements) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetInstanceTypesFromInstanceRequirements::into_paginator).
    pub fn get_instance_types_from_instance_requirements(
        &self,
    ) -> fluent_builders::GetInstanceTypesFromInstanceRequirements<C, M, R> {
        fluent_builders::GetInstanceTypesFromInstanceRequirements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIpamAddressHistory` operation.
    ///
    /// See [`GetIpamAddressHistory`](crate::client::fluent_builders::GetIpamAddressHistory) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetIpamAddressHistory::into_paginator).
    pub fn get_ipam_address_history(&self) -> fluent_builders::GetIpamAddressHistory<C, M, R> {
        fluent_builders::GetIpamAddressHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIpamPoolAllocations` operation.
    ///
    /// See [`GetIpamPoolAllocations`](crate::client::fluent_builders::GetIpamPoolAllocations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetIpamPoolAllocations::into_paginator).
    pub fn get_ipam_pool_allocations(&self) -> fluent_builders::GetIpamPoolAllocations<C, M, R> {
        fluent_builders::GetIpamPoolAllocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIpamPoolCidrs` operation.
    ///
    /// See [`GetIpamPoolCidrs`](crate::client::fluent_builders::GetIpamPoolCidrs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetIpamPoolCidrs::into_paginator).
    pub fn get_ipam_pool_cidrs(&self) -> fluent_builders::GetIpamPoolCidrs<C, M, R> {
        fluent_builders::GetIpamPoolCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIpamResourceCidrs` operation.
    ///
    /// See [`GetIpamResourceCidrs`](crate::client::fluent_builders::GetIpamResourceCidrs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetIpamResourceCidrs::into_paginator).
    pub fn get_ipam_resource_cidrs(&self) -> fluent_builders::GetIpamResourceCidrs<C, M, R> {
        fluent_builders::GetIpamResourceCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLaunchTemplateData` operation.
    ///
    /// See [`GetLaunchTemplateData`](crate::client::fluent_builders::GetLaunchTemplateData) for more information about the
    /// operation and its arguments.
    pub fn get_launch_template_data(&self) -> fluent_builders::GetLaunchTemplateData<C, M, R> {
        fluent_builders::GetLaunchTemplateData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetManagedPrefixListAssociations` operation.
    ///
    /// See [`GetManagedPrefixListAssociations`](crate::client::fluent_builders::GetManagedPrefixListAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetManagedPrefixListAssociations::into_paginator).
    pub fn get_managed_prefix_list_associations(
        &self,
    ) -> fluent_builders::GetManagedPrefixListAssociations<C, M, R> {
        fluent_builders::GetManagedPrefixListAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetManagedPrefixListEntries` operation.
    ///
    /// See [`GetManagedPrefixListEntries`](crate::client::fluent_builders::GetManagedPrefixListEntries) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetManagedPrefixListEntries::into_paginator).
    pub fn get_managed_prefix_list_entries(
        &self,
    ) -> fluent_builders::GetManagedPrefixListEntries<C, M, R> {
        fluent_builders::GetManagedPrefixListEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkInsightsAccessScopeAnalysisFindings` operation.
    ///
    /// See [`GetNetworkInsightsAccessScopeAnalysisFindings`](crate::client::fluent_builders::GetNetworkInsightsAccessScopeAnalysisFindings) for more information about the
    /// operation and its arguments.
    pub fn get_network_insights_access_scope_analysis_findings(
        &self,
    ) -> fluent_builders::GetNetworkInsightsAccessScopeAnalysisFindings<C, M, R> {
        fluent_builders::GetNetworkInsightsAccessScopeAnalysisFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetworkInsightsAccessScopeContent` operation.
    ///
    /// See [`GetNetworkInsightsAccessScopeContent`](crate::client::fluent_builders::GetNetworkInsightsAccessScopeContent) for more information about the
    /// operation and its arguments.
    pub fn get_network_insights_access_scope_content(
        &self,
    ) -> fluent_builders::GetNetworkInsightsAccessScopeContent<C, M, R> {
        fluent_builders::GetNetworkInsightsAccessScopeContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPasswordData` operation.
    ///
    /// See [`GetPasswordData`](crate::client::fluent_builders::GetPasswordData) for more information about the
    /// operation and its arguments.
    pub fn get_password_data(&self) -> fluent_builders::GetPasswordData<C, M, R> {
        fluent_builders::GetPasswordData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReservedInstancesExchangeQuote` operation.
    ///
    /// See [`GetReservedInstancesExchangeQuote`](crate::client::fluent_builders::GetReservedInstancesExchangeQuote) for more information about the
    /// operation and its arguments.
    pub fn get_reserved_instances_exchange_quote(
        &self,
    ) -> fluent_builders::GetReservedInstancesExchangeQuote<C, M, R> {
        fluent_builders::GetReservedInstancesExchangeQuote::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSerialConsoleAccessStatus` operation.
    ///
    /// See [`GetSerialConsoleAccessStatus`](crate::client::fluent_builders::GetSerialConsoleAccessStatus) for more information about the
    /// operation and its arguments.
    pub fn get_serial_console_access_status(
        &self,
    ) -> fluent_builders::GetSerialConsoleAccessStatus<C, M, R> {
        fluent_builders::GetSerialConsoleAccessStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSpotPlacementScores` operation.
    ///
    /// See [`GetSpotPlacementScores`](crate::client::fluent_builders::GetSpotPlacementScores) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetSpotPlacementScores::into_paginator).
    pub fn get_spot_placement_scores(&self) -> fluent_builders::GetSpotPlacementScores<C, M, R> {
        fluent_builders::GetSpotPlacementScores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSubnetCidrReservations` operation.
    ///
    /// See [`GetSubnetCidrReservations`](crate::client::fluent_builders::GetSubnetCidrReservations) for more information about the
    /// operation and its arguments.
    pub fn get_subnet_cidr_reservations(
        &self,
    ) -> fluent_builders::GetSubnetCidrReservations<C, M, R> {
        fluent_builders::GetSubnetCidrReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayAttachmentPropagations` operation.
    ///
    /// See [`GetTransitGatewayAttachmentPropagations`](crate::client::fluent_builders::GetTransitGatewayAttachmentPropagations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayAttachmentPropagations::into_paginator).
    pub fn get_transit_gateway_attachment_propagations(
        &self,
    ) -> fluent_builders::GetTransitGatewayAttachmentPropagations<C, M, R> {
        fluent_builders::GetTransitGatewayAttachmentPropagations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayMulticastDomainAssociations` operation.
    ///
    /// See [`GetTransitGatewayMulticastDomainAssociations`](crate::client::fluent_builders::GetTransitGatewayMulticastDomainAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayMulticastDomainAssociations::into_paginator).
    pub fn get_transit_gateway_multicast_domain_associations(
        &self,
    ) -> fluent_builders::GetTransitGatewayMulticastDomainAssociations<C, M, R> {
        fluent_builders::GetTransitGatewayMulticastDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayPrefixListReferences` operation.
    ///
    /// See [`GetTransitGatewayPrefixListReferences`](crate::client::fluent_builders::GetTransitGatewayPrefixListReferences) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayPrefixListReferences::into_paginator).
    pub fn get_transit_gateway_prefix_list_references(
        &self,
    ) -> fluent_builders::GetTransitGatewayPrefixListReferences<C, M, R> {
        fluent_builders::GetTransitGatewayPrefixListReferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayRouteTableAssociations` operation.
    ///
    /// See [`GetTransitGatewayRouteTableAssociations`](crate::client::fluent_builders::GetTransitGatewayRouteTableAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayRouteTableAssociations::into_paginator).
    pub fn get_transit_gateway_route_table_associations(
        &self,
    ) -> fluent_builders::GetTransitGatewayRouteTableAssociations<C, M, R> {
        fluent_builders::GetTransitGatewayRouteTableAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTransitGatewayRouteTablePropagations` operation.
    ///
    /// See [`GetTransitGatewayRouteTablePropagations`](crate::client::fluent_builders::GetTransitGatewayRouteTablePropagations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetTransitGatewayRouteTablePropagations::into_paginator).
    pub fn get_transit_gateway_route_table_propagations(
        &self,
    ) -> fluent_builders::GetTransitGatewayRouteTablePropagations<C, M, R> {
        fluent_builders::GetTransitGatewayRouteTablePropagations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpnConnectionDeviceSampleConfiguration` operation.
    ///
    /// See [`GetVpnConnectionDeviceSampleConfiguration`](crate::client::fluent_builders::GetVpnConnectionDeviceSampleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_vpn_connection_device_sample_configuration(
        &self,
    ) -> fluent_builders::GetVpnConnectionDeviceSampleConfiguration<C, M, R> {
        fluent_builders::GetVpnConnectionDeviceSampleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetVpnConnectionDeviceTypes` operation.
    ///
    /// See [`GetVpnConnectionDeviceTypes`](crate::client::fluent_builders::GetVpnConnectionDeviceTypes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::GetVpnConnectionDeviceTypes::into_paginator).
    pub fn get_vpn_connection_device_types(
        &self,
    ) -> fluent_builders::GetVpnConnectionDeviceTypes<C, M, R> {
        fluent_builders::GetVpnConnectionDeviceTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportClientVpnClientCertificateRevocationList` operation.
    ///
    /// See [`ImportClientVpnClientCertificateRevocationList`](crate::client::fluent_builders::ImportClientVpnClientCertificateRevocationList) for more information about the
    /// operation and its arguments.
    pub fn import_client_vpn_client_certificate_revocation_list(
        &self,
    ) -> fluent_builders::ImportClientVpnClientCertificateRevocationList<C, M, R> {
        fluent_builders::ImportClientVpnClientCertificateRevocationList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportImage` operation.
    ///
    /// See [`ImportImage`](crate::client::fluent_builders::ImportImage) for more information about the
    /// operation and its arguments.
    pub fn import_image(&self) -> fluent_builders::ImportImage<C, M, R> {
        fluent_builders::ImportImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportInstance` operation.
    ///
    /// See [`ImportInstance`](crate::client::fluent_builders::ImportInstance) for more information about the
    /// operation and its arguments.
    pub fn import_instance(&self) -> fluent_builders::ImportInstance<C, M, R> {
        fluent_builders::ImportInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportKeyPair` operation.
    ///
    /// See [`ImportKeyPair`](crate::client::fluent_builders::ImportKeyPair) for more information about the
    /// operation and its arguments.
    pub fn import_key_pair(&self) -> fluent_builders::ImportKeyPair<C, M, R> {
        fluent_builders::ImportKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportSnapshot` operation.
    ///
    /// See [`ImportSnapshot`](crate::client::fluent_builders::ImportSnapshot) for more information about the
    /// operation and its arguments.
    pub fn import_snapshot(&self) -> fluent_builders::ImportSnapshot<C, M, R> {
        fluent_builders::ImportSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportVolume` operation.
    ///
    /// See [`ImportVolume`](crate::client::fluent_builders::ImportVolume) for more information about the
    /// operation and its arguments.
    pub fn import_volume(&self) -> fluent_builders::ImportVolume<C, M, R> {
        fluent_builders::ImportVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSnapshotsInRecycleBin` operation.
    ///
    /// See [`ListSnapshotsInRecycleBin`](crate::client::fluent_builders::ListSnapshotsInRecycleBin) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSnapshotsInRecycleBin::into_paginator).
    pub fn list_snapshots_in_recycle_bin(
        &self,
    ) -> fluent_builders::ListSnapshotsInRecycleBin<C, M, R> {
        fluent_builders::ListSnapshotsInRecycleBin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyAddressAttribute` operation.
    ///
    /// See [`ModifyAddressAttribute`](crate::client::fluent_builders::ModifyAddressAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_address_attribute(&self) -> fluent_builders::ModifyAddressAttribute<C, M, R> {
        fluent_builders::ModifyAddressAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyAvailabilityZoneGroup` operation.
    ///
    /// See [`ModifyAvailabilityZoneGroup`](crate::client::fluent_builders::ModifyAvailabilityZoneGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_availability_zone_group(
        &self,
    ) -> fluent_builders::ModifyAvailabilityZoneGroup<C, M, R> {
        fluent_builders::ModifyAvailabilityZoneGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCapacityReservation` operation.
    ///
    /// See [`ModifyCapacityReservation`](crate::client::fluent_builders::ModifyCapacityReservation) for more information about the
    /// operation and its arguments.
    pub fn modify_capacity_reservation(
        &self,
    ) -> fluent_builders::ModifyCapacityReservation<C, M, R> {
        fluent_builders::ModifyCapacityReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCapacityReservationFleet` operation.
    ///
    /// See [`ModifyCapacityReservationFleet`](crate::client::fluent_builders::ModifyCapacityReservationFleet) for more information about the
    /// operation and its arguments.
    pub fn modify_capacity_reservation_fleet(
        &self,
    ) -> fluent_builders::ModifyCapacityReservationFleet<C, M, R> {
        fluent_builders::ModifyCapacityReservationFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClientVpnEndpoint` operation.
    ///
    /// See [`ModifyClientVpnEndpoint`](crate::client::fluent_builders::ModifyClientVpnEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_client_vpn_endpoint(&self) -> fluent_builders::ModifyClientVpnEndpoint<C, M, R> {
        fluent_builders::ModifyClientVpnEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyDefaultCreditSpecification` operation.
    ///
    /// See [`ModifyDefaultCreditSpecification`](crate::client::fluent_builders::ModifyDefaultCreditSpecification) for more information about the
    /// operation and its arguments.
    pub fn modify_default_credit_specification(
        &self,
    ) -> fluent_builders::ModifyDefaultCreditSpecification<C, M, R> {
        fluent_builders::ModifyDefaultCreditSpecification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEbsDefaultKmsKeyId` operation.
    ///
    /// See [`ModifyEbsDefaultKmsKeyId`](crate::client::fluent_builders::ModifyEbsDefaultKmsKeyId) for more information about the
    /// operation and its arguments.
    pub fn modify_ebs_default_kms_key_id(
        &self,
    ) -> fluent_builders::ModifyEbsDefaultKmsKeyId<C, M, R> {
        fluent_builders::ModifyEbsDefaultKmsKeyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyFleet` operation.
    ///
    /// See [`ModifyFleet`](crate::client::fluent_builders::ModifyFleet) for more information about the
    /// operation and its arguments.
    pub fn modify_fleet(&self) -> fluent_builders::ModifyFleet<C, M, R> {
        fluent_builders::ModifyFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyFpgaImageAttribute` operation.
    ///
    /// See [`ModifyFpgaImageAttribute`](crate::client::fluent_builders::ModifyFpgaImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_fpga_image_attribute(
        &self,
    ) -> fluent_builders::ModifyFpgaImageAttribute<C, M, R> {
        fluent_builders::ModifyFpgaImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyHosts` operation.
    ///
    /// See [`ModifyHosts`](crate::client::fluent_builders::ModifyHosts) for more information about the
    /// operation and its arguments.
    pub fn modify_hosts(&self) -> fluent_builders::ModifyHosts<C, M, R> {
        fluent_builders::ModifyHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIdentityIdFormat` operation.
    ///
    /// See [`ModifyIdentityIdFormat`](crate::client::fluent_builders::ModifyIdentityIdFormat) for more information about the
    /// operation and its arguments.
    pub fn modify_identity_id_format(&self) -> fluent_builders::ModifyIdentityIdFormat<C, M, R> {
        fluent_builders::ModifyIdentityIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIdFormat` operation.
    ///
    /// See [`ModifyIdFormat`](crate::client::fluent_builders::ModifyIdFormat) for more information about the
    /// operation and its arguments.
    pub fn modify_id_format(&self) -> fluent_builders::ModifyIdFormat<C, M, R> {
        fluent_builders::ModifyIdFormat::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyImageAttribute` operation.
    ///
    /// See [`ModifyImageAttribute`](crate::client::fluent_builders::ModifyImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_image_attribute(&self) -> fluent_builders::ModifyImageAttribute<C, M, R> {
        fluent_builders::ModifyImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceAttribute` operation.
    ///
    /// See [`ModifyInstanceAttribute`](crate::client::fluent_builders::ModifyInstanceAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_attribute(&self) -> fluent_builders::ModifyInstanceAttribute<C, M, R> {
        fluent_builders::ModifyInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceCapacityReservationAttributes` operation.
    ///
    /// See [`ModifyInstanceCapacityReservationAttributes`](crate::client::fluent_builders::ModifyInstanceCapacityReservationAttributes) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_capacity_reservation_attributes(
        &self,
    ) -> fluent_builders::ModifyInstanceCapacityReservationAttributes<C, M, R> {
        fluent_builders::ModifyInstanceCapacityReservationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceCreditSpecification` operation.
    ///
    /// See [`ModifyInstanceCreditSpecification`](crate::client::fluent_builders::ModifyInstanceCreditSpecification) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_credit_specification(
        &self,
    ) -> fluent_builders::ModifyInstanceCreditSpecification<C, M, R> {
        fluent_builders::ModifyInstanceCreditSpecification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceEventStartTime` operation.
    ///
    /// See [`ModifyInstanceEventStartTime`](crate::client::fluent_builders::ModifyInstanceEventStartTime) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_event_start_time(
        &self,
    ) -> fluent_builders::ModifyInstanceEventStartTime<C, M, R> {
        fluent_builders::ModifyInstanceEventStartTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceEventWindow` operation.
    ///
    /// See [`ModifyInstanceEventWindow`](crate::client::fluent_builders::ModifyInstanceEventWindow) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_event_window(
        &self,
    ) -> fluent_builders::ModifyInstanceEventWindow<C, M, R> {
        fluent_builders::ModifyInstanceEventWindow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstanceMetadataOptions` operation.
    ///
    /// See [`ModifyInstanceMetadataOptions`](crate::client::fluent_builders::ModifyInstanceMetadataOptions) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_metadata_options(
        &self,
    ) -> fluent_builders::ModifyInstanceMetadataOptions<C, M, R> {
        fluent_builders::ModifyInstanceMetadataOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyInstancePlacement` operation.
    ///
    /// See [`ModifyInstancePlacement`](crate::client::fluent_builders::ModifyInstancePlacement) for more information about the
    /// operation and its arguments.
    pub fn modify_instance_placement(&self) -> fluent_builders::ModifyInstancePlacement<C, M, R> {
        fluent_builders::ModifyInstancePlacement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIpam` operation.
    ///
    /// See [`ModifyIpam`](crate::client::fluent_builders::ModifyIpam) for more information about the
    /// operation and its arguments.
    pub fn modify_ipam(&self) -> fluent_builders::ModifyIpam<C, M, R> {
        fluent_builders::ModifyIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIpamPool` operation.
    ///
    /// See [`ModifyIpamPool`](crate::client::fluent_builders::ModifyIpamPool) for more information about the
    /// operation and its arguments.
    pub fn modify_ipam_pool(&self) -> fluent_builders::ModifyIpamPool<C, M, R> {
        fluent_builders::ModifyIpamPool::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIpamResourceCidr` operation.
    ///
    /// See [`ModifyIpamResourceCidr`](crate::client::fluent_builders::ModifyIpamResourceCidr) for more information about the
    /// operation and its arguments.
    pub fn modify_ipam_resource_cidr(&self) -> fluent_builders::ModifyIpamResourceCidr<C, M, R> {
        fluent_builders::ModifyIpamResourceCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyIpamScope` operation.
    ///
    /// See [`ModifyIpamScope`](crate::client::fluent_builders::ModifyIpamScope) for more information about the
    /// operation and its arguments.
    pub fn modify_ipam_scope(&self) -> fluent_builders::ModifyIpamScope<C, M, R> {
        fluent_builders::ModifyIpamScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyLaunchTemplate` operation.
    ///
    /// See [`ModifyLaunchTemplate`](crate::client::fluent_builders::ModifyLaunchTemplate) for more information about the
    /// operation and its arguments.
    pub fn modify_launch_template(&self) -> fluent_builders::ModifyLaunchTemplate<C, M, R> {
        fluent_builders::ModifyLaunchTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyManagedPrefixList` operation.
    ///
    /// See [`ModifyManagedPrefixList`](crate::client::fluent_builders::ModifyManagedPrefixList) for more information about the
    /// operation and its arguments.
    pub fn modify_managed_prefix_list(&self) -> fluent_builders::ModifyManagedPrefixList<C, M, R> {
        fluent_builders::ModifyManagedPrefixList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyNetworkInterfaceAttribute` operation.
    ///
    /// See [`ModifyNetworkInterfaceAttribute`](crate::client::fluent_builders::ModifyNetworkInterfaceAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_network_interface_attribute(
        &self,
    ) -> fluent_builders::ModifyNetworkInterfaceAttribute<C, M, R> {
        fluent_builders::ModifyNetworkInterfaceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyPrivateDnsNameOptions` operation.
    ///
    /// See [`ModifyPrivateDnsNameOptions`](crate::client::fluent_builders::ModifyPrivateDnsNameOptions) for more information about the
    /// operation and its arguments.
    pub fn modify_private_dns_name_options(
        &self,
    ) -> fluent_builders::ModifyPrivateDnsNameOptions<C, M, R> {
        fluent_builders::ModifyPrivateDnsNameOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyReservedInstances` operation.
    ///
    /// See [`ModifyReservedInstances`](crate::client::fluent_builders::ModifyReservedInstances) for more information about the
    /// operation and its arguments.
    pub fn modify_reserved_instances(&self) -> fluent_builders::ModifyReservedInstances<C, M, R> {
        fluent_builders::ModifyReservedInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySecurityGroupRules` operation.
    ///
    /// See [`ModifySecurityGroupRules`](crate::client::fluent_builders::ModifySecurityGroupRules) for more information about the
    /// operation and its arguments.
    pub fn modify_security_group_rules(
        &self,
    ) -> fluent_builders::ModifySecurityGroupRules<C, M, R> {
        fluent_builders::ModifySecurityGroupRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySnapshotAttribute` operation.
    ///
    /// See [`ModifySnapshotAttribute`](crate::client::fluent_builders::ModifySnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_snapshot_attribute(&self) -> fluent_builders::ModifySnapshotAttribute<C, M, R> {
        fluent_builders::ModifySnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySnapshotTier` operation.
    ///
    /// See [`ModifySnapshotTier`](crate::client::fluent_builders::ModifySnapshotTier) for more information about the
    /// operation and its arguments.
    pub fn modify_snapshot_tier(&self) -> fluent_builders::ModifySnapshotTier<C, M, R> {
        fluent_builders::ModifySnapshotTier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySpotFleetRequest` operation.
    ///
    /// See [`ModifySpotFleetRequest`](crate::client::fluent_builders::ModifySpotFleetRequest) for more information about the
    /// operation and its arguments.
    pub fn modify_spot_fleet_request(&self) -> fluent_builders::ModifySpotFleetRequest<C, M, R> {
        fluent_builders::ModifySpotFleetRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySubnetAttribute` operation.
    ///
    /// See [`ModifySubnetAttribute`](crate::client::fluent_builders::ModifySubnetAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_subnet_attribute(&self) -> fluent_builders::ModifySubnetAttribute<C, M, R> {
        fluent_builders::ModifySubnetAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTrafficMirrorFilterNetworkServices` operation.
    ///
    /// See [`ModifyTrafficMirrorFilterNetworkServices`](crate::client::fluent_builders::ModifyTrafficMirrorFilterNetworkServices) for more information about the
    /// operation and its arguments.
    pub fn modify_traffic_mirror_filter_network_services(
        &self,
    ) -> fluent_builders::ModifyTrafficMirrorFilterNetworkServices<C, M, R> {
        fluent_builders::ModifyTrafficMirrorFilterNetworkServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTrafficMirrorFilterRule` operation.
    ///
    /// See [`ModifyTrafficMirrorFilterRule`](crate::client::fluent_builders::ModifyTrafficMirrorFilterRule) for more information about the
    /// operation and its arguments.
    pub fn modify_traffic_mirror_filter_rule(
        &self,
    ) -> fluent_builders::ModifyTrafficMirrorFilterRule<C, M, R> {
        fluent_builders::ModifyTrafficMirrorFilterRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTrafficMirrorSession` operation.
    ///
    /// See [`ModifyTrafficMirrorSession`](crate::client::fluent_builders::ModifyTrafficMirrorSession) for more information about the
    /// operation and its arguments.
    pub fn modify_traffic_mirror_session(
        &self,
    ) -> fluent_builders::ModifyTrafficMirrorSession<C, M, R> {
        fluent_builders::ModifyTrafficMirrorSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTransitGateway` operation.
    ///
    /// See [`ModifyTransitGateway`](crate::client::fluent_builders::ModifyTransitGateway) for more information about the
    /// operation and its arguments.
    pub fn modify_transit_gateway(&self) -> fluent_builders::ModifyTransitGateway<C, M, R> {
        fluent_builders::ModifyTransitGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTransitGatewayPrefixListReference` operation.
    ///
    /// See [`ModifyTransitGatewayPrefixListReference`](crate::client::fluent_builders::ModifyTransitGatewayPrefixListReference) for more information about the
    /// operation and its arguments.
    pub fn modify_transit_gateway_prefix_list_reference(
        &self,
    ) -> fluent_builders::ModifyTransitGatewayPrefixListReference<C, M, R> {
        fluent_builders::ModifyTransitGatewayPrefixListReference::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyTransitGatewayVpcAttachment` operation.
    ///
    /// See [`ModifyTransitGatewayVpcAttachment`](crate::client::fluent_builders::ModifyTransitGatewayVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn modify_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::ModifyTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::ModifyTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVolume` operation.
    ///
    /// See [`ModifyVolume`](crate::client::fluent_builders::ModifyVolume) for more information about the
    /// operation and its arguments.
    pub fn modify_volume(&self) -> fluent_builders::ModifyVolume<C, M, R> {
        fluent_builders::ModifyVolume::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVolumeAttribute` operation.
    ///
    /// See [`ModifyVolumeAttribute`](crate::client::fluent_builders::ModifyVolumeAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_volume_attribute(&self) -> fluent_builders::ModifyVolumeAttribute<C, M, R> {
        fluent_builders::ModifyVolumeAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcAttribute` operation.
    ///
    /// See [`ModifyVpcAttribute`](crate::client::fluent_builders::ModifyVpcAttribute) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_attribute(&self) -> fluent_builders::ModifyVpcAttribute<C, M, R> {
        fluent_builders::ModifyVpcAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcEndpoint` operation.
    ///
    /// See [`ModifyVpcEndpoint`](crate::client::fluent_builders::ModifyVpcEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_endpoint(&self) -> fluent_builders::ModifyVpcEndpoint<C, M, R> {
        fluent_builders::ModifyVpcEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcEndpointConnectionNotification` operation.
    ///
    /// See [`ModifyVpcEndpointConnectionNotification`](crate::client::fluent_builders::ModifyVpcEndpointConnectionNotification) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_endpoint_connection_notification(
        &self,
    ) -> fluent_builders::ModifyVpcEndpointConnectionNotification<C, M, R> {
        fluent_builders::ModifyVpcEndpointConnectionNotification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcEndpointServiceConfiguration` operation.
    ///
    /// See [`ModifyVpcEndpointServiceConfiguration`](crate::client::fluent_builders::ModifyVpcEndpointServiceConfiguration) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_endpoint_service_configuration(
        &self,
    ) -> fluent_builders::ModifyVpcEndpointServiceConfiguration<C, M, R> {
        fluent_builders::ModifyVpcEndpointServiceConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcEndpointServicePayerResponsibility` operation.
    ///
    /// See [`ModifyVpcEndpointServicePayerResponsibility`](crate::client::fluent_builders::ModifyVpcEndpointServicePayerResponsibility) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_endpoint_service_payer_responsibility(
        &self,
    ) -> fluent_builders::ModifyVpcEndpointServicePayerResponsibility<C, M, R> {
        fluent_builders::ModifyVpcEndpointServicePayerResponsibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcEndpointServicePermissions` operation.
    ///
    /// See [`ModifyVpcEndpointServicePermissions`](crate::client::fluent_builders::ModifyVpcEndpointServicePermissions) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_endpoint_service_permissions(
        &self,
    ) -> fluent_builders::ModifyVpcEndpointServicePermissions<C, M, R> {
        fluent_builders::ModifyVpcEndpointServicePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcPeeringConnectionOptions` operation.
    ///
    /// See [`ModifyVpcPeeringConnectionOptions`](crate::client::fluent_builders::ModifyVpcPeeringConnectionOptions) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_peering_connection_options(
        &self,
    ) -> fluent_builders::ModifyVpcPeeringConnectionOptions<C, M, R> {
        fluent_builders::ModifyVpcPeeringConnectionOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpcTenancy` operation.
    ///
    /// See [`ModifyVpcTenancy`](crate::client::fluent_builders::ModifyVpcTenancy) for more information about the
    /// operation and its arguments.
    pub fn modify_vpc_tenancy(&self) -> fluent_builders::ModifyVpcTenancy<C, M, R> {
        fluent_builders::ModifyVpcTenancy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpnConnection` operation.
    ///
    /// See [`ModifyVpnConnection`](crate::client::fluent_builders::ModifyVpnConnection) for more information about the
    /// operation and its arguments.
    pub fn modify_vpn_connection(&self) -> fluent_builders::ModifyVpnConnection<C, M, R> {
        fluent_builders::ModifyVpnConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpnConnectionOptions` operation.
    ///
    /// See [`ModifyVpnConnectionOptions`](crate::client::fluent_builders::ModifyVpnConnectionOptions) for more information about the
    /// operation and its arguments.
    pub fn modify_vpn_connection_options(
        &self,
    ) -> fluent_builders::ModifyVpnConnectionOptions<C, M, R> {
        fluent_builders::ModifyVpnConnectionOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpnTunnelCertificate` operation.
    ///
    /// See [`ModifyVpnTunnelCertificate`](crate::client::fluent_builders::ModifyVpnTunnelCertificate) for more information about the
    /// operation and its arguments.
    pub fn modify_vpn_tunnel_certificate(
        &self,
    ) -> fluent_builders::ModifyVpnTunnelCertificate<C, M, R> {
        fluent_builders::ModifyVpnTunnelCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyVpnTunnelOptions` operation.
    ///
    /// See [`ModifyVpnTunnelOptions`](crate::client::fluent_builders::ModifyVpnTunnelOptions) for more information about the
    /// operation and its arguments.
    pub fn modify_vpn_tunnel_options(&self) -> fluent_builders::ModifyVpnTunnelOptions<C, M, R> {
        fluent_builders::ModifyVpnTunnelOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MonitorInstances` operation.
    ///
    /// See [`MonitorInstances`](crate::client::fluent_builders::MonitorInstances) for more information about the
    /// operation and its arguments.
    pub fn monitor_instances(&self) -> fluent_builders::MonitorInstances<C, M, R> {
        fluent_builders::MonitorInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MoveAddressToVpc` operation.
    ///
    /// See [`MoveAddressToVpc`](crate::client::fluent_builders::MoveAddressToVpc) for more information about the
    /// operation and its arguments.
    pub fn move_address_to_vpc(&self) -> fluent_builders::MoveAddressToVpc<C, M, R> {
        fluent_builders::MoveAddressToVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MoveByoipCidrToIpam` operation.
    ///
    /// See [`MoveByoipCidrToIpam`](crate::client::fluent_builders::MoveByoipCidrToIpam) for more information about the
    /// operation and its arguments.
    pub fn move_byoip_cidr_to_ipam(&self) -> fluent_builders::MoveByoipCidrToIpam<C, M, R> {
        fluent_builders::MoveByoipCidrToIpam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionByoipCidr` operation.
    ///
    /// See [`ProvisionByoipCidr`](crate::client::fluent_builders::ProvisionByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn provision_byoip_cidr(&self) -> fluent_builders::ProvisionByoipCidr<C, M, R> {
        fluent_builders::ProvisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionIpamPoolCidr` operation.
    ///
    /// See [`ProvisionIpamPoolCidr`](crate::client::fluent_builders::ProvisionIpamPoolCidr) for more information about the
    /// operation and its arguments.
    pub fn provision_ipam_pool_cidr(&self) -> fluent_builders::ProvisionIpamPoolCidr<C, M, R> {
        fluent_builders::ProvisionIpamPoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionPublicIpv4PoolCidr` operation.
    ///
    /// See [`ProvisionPublicIpv4PoolCidr`](crate::client::fluent_builders::ProvisionPublicIpv4PoolCidr) for more information about the
    /// operation and its arguments.
    pub fn provision_public_ipv4_pool_cidr(
        &self,
    ) -> fluent_builders::ProvisionPublicIpv4PoolCidr<C, M, R> {
        fluent_builders::ProvisionPublicIpv4PoolCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseHostReservation` operation.
    ///
    /// See [`PurchaseHostReservation`](crate::client::fluent_builders::PurchaseHostReservation) for more information about the
    /// operation and its arguments.
    pub fn purchase_host_reservation(&self) -> fluent_builders::PurchaseHostReservation<C, M, R> {
        fluent_builders::PurchaseHostReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseReservedInstancesOffering` operation.
    ///
    /// See [`PurchaseReservedInstancesOffering`](crate::client::fluent_builders::PurchaseReservedInstancesOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_reserved_instances_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedInstancesOffering<C, M, R> {
        fluent_builders::PurchaseReservedInstancesOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseScheduledInstances` operation.
    ///
    /// See [`PurchaseScheduledInstances`](crate::client::fluent_builders::PurchaseScheduledInstances) for more information about the
    /// operation and its arguments.
    pub fn purchase_scheduled_instances(
        &self,
    ) -> fluent_builders::PurchaseScheduledInstances<C, M, R> {
        fluent_builders::PurchaseScheduledInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootInstances` operation.
    ///
    /// See [`RebootInstances`](crate::client::fluent_builders::RebootInstances) for more information about the
    /// operation and its arguments.
    pub fn reboot_instances(&self) -> fluent_builders::RebootInstances<C, M, R> {
        fluent_builders::RebootInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterImage` operation.
    ///
    /// See [`RegisterImage`](crate::client::fluent_builders::RegisterImage) for more information about the
    /// operation and its arguments.
    pub fn register_image(&self) -> fluent_builders::RegisterImage<C, M, R> {
        fluent_builders::RegisterImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterInstanceEventNotificationAttributes` operation.
    ///
    /// See [`RegisterInstanceEventNotificationAttributes`](crate::client::fluent_builders::RegisterInstanceEventNotificationAttributes) for more information about the
    /// operation and its arguments.
    pub fn register_instance_event_notification_attributes(
        &self,
    ) -> fluent_builders::RegisterInstanceEventNotificationAttributes<C, M, R> {
        fluent_builders::RegisterInstanceEventNotificationAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTransitGatewayMulticastGroupMembers` operation.
    ///
    /// See [`RegisterTransitGatewayMulticastGroupMembers`](crate::client::fluent_builders::RegisterTransitGatewayMulticastGroupMembers) for more information about the
    /// operation and its arguments.
    pub fn register_transit_gateway_multicast_group_members(
        &self,
    ) -> fluent_builders::RegisterTransitGatewayMulticastGroupMembers<C, M, R> {
        fluent_builders::RegisterTransitGatewayMulticastGroupMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterTransitGatewayMulticastGroupSources` operation.
    ///
    /// See [`RegisterTransitGatewayMulticastGroupSources`](crate::client::fluent_builders::RegisterTransitGatewayMulticastGroupSources) for more information about the
    /// operation and its arguments.
    pub fn register_transit_gateway_multicast_group_sources(
        &self,
    ) -> fluent_builders::RegisterTransitGatewayMulticastGroupSources<C, M, R> {
        fluent_builders::RegisterTransitGatewayMulticastGroupSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectTransitGatewayMulticastDomainAssociations` operation.
    ///
    /// See [`RejectTransitGatewayMulticastDomainAssociations`](crate::client::fluent_builders::RejectTransitGatewayMulticastDomainAssociations) for more information about the
    /// operation and its arguments.
    pub fn reject_transit_gateway_multicast_domain_associations(
        &self,
    ) -> fluent_builders::RejectTransitGatewayMulticastDomainAssociations<C, M, R> {
        fluent_builders::RejectTransitGatewayMulticastDomainAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectTransitGatewayPeeringAttachment` operation.
    ///
    /// See [`RejectTransitGatewayPeeringAttachment`](crate::client::fluent_builders::RejectTransitGatewayPeeringAttachment) for more information about the
    /// operation and its arguments.
    pub fn reject_transit_gateway_peering_attachment(
        &self,
    ) -> fluent_builders::RejectTransitGatewayPeeringAttachment<C, M, R> {
        fluent_builders::RejectTransitGatewayPeeringAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectTransitGatewayVpcAttachment` operation.
    ///
    /// See [`RejectTransitGatewayVpcAttachment`](crate::client::fluent_builders::RejectTransitGatewayVpcAttachment) for more information about the
    /// operation and its arguments.
    pub fn reject_transit_gateway_vpc_attachment(
        &self,
    ) -> fluent_builders::RejectTransitGatewayVpcAttachment<C, M, R> {
        fluent_builders::RejectTransitGatewayVpcAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectVpcEndpointConnections` operation.
    ///
    /// See [`RejectVpcEndpointConnections`](crate::client::fluent_builders::RejectVpcEndpointConnections) for more information about the
    /// operation and its arguments.
    pub fn reject_vpc_endpoint_connections(
        &self,
    ) -> fluent_builders::RejectVpcEndpointConnections<C, M, R> {
        fluent_builders::RejectVpcEndpointConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectVpcPeeringConnection` operation.
    ///
    /// See [`RejectVpcPeeringConnection`](crate::client::fluent_builders::RejectVpcPeeringConnection) for more information about the
    /// operation and its arguments.
    pub fn reject_vpc_peering_connection(
        &self,
    ) -> fluent_builders::RejectVpcPeeringConnection<C, M, R> {
        fluent_builders::RejectVpcPeeringConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReleaseAddress` operation.
    ///
    /// See [`ReleaseAddress`](crate::client::fluent_builders::ReleaseAddress) for more information about the
    /// operation and its arguments.
    pub fn release_address(&self) -> fluent_builders::ReleaseAddress<C, M, R> {
        fluent_builders::ReleaseAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReleaseHosts` operation.
    ///
    /// See [`ReleaseHosts`](crate::client::fluent_builders::ReleaseHosts) for more information about the
    /// operation and its arguments.
    pub fn release_hosts(&self) -> fluent_builders::ReleaseHosts<C, M, R> {
        fluent_builders::ReleaseHosts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReleaseIpamPoolAllocation` operation.
    ///
    /// See [`ReleaseIpamPoolAllocation`](crate::client::fluent_builders::ReleaseIpamPoolAllocation) for more information about the
    /// operation and its arguments.
    pub fn release_ipam_pool_allocation(
        &self,
    ) -> fluent_builders::ReleaseIpamPoolAllocation<C, M, R> {
        fluent_builders::ReleaseIpamPoolAllocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceIamInstanceProfileAssociation` operation.
    ///
    /// See [`ReplaceIamInstanceProfileAssociation`](crate::client::fluent_builders::ReplaceIamInstanceProfileAssociation) for more information about the
    /// operation and its arguments.
    pub fn replace_iam_instance_profile_association(
        &self,
    ) -> fluent_builders::ReplaceIamInstanceProfileAssociation<C, M, R> {
        fluent_builders::ReplaceIamInstanceProfileAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceNetworkAclAssociation` operation.
    ///
    /// See [`ReplaceNetworkAclAssociation`](crate::client::fluent_builders::ReplaceNetworkAclAssociation) for more information about the
    /// operation and its arguments.
    pub fn replace_network_acl_association(
        &self,
    ) -> fluent_builders::ReplaceNetworkAclAssociation<C, M, R> {
        fluent_builders::ReplaceNetworkAclAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceNetworkAclEntry` operation.
    ///
    /// See [`ReplaceNetworkAclEntry`](crate::client::fluent_builders::ReplaceNetworkAclEntry) for more information about the
    /// operation and its arguments.
    pub fn replace_network_acl_entry(&self) -> fluent_builders::ReplaceNetworkAclEntry<C, M, R> {
        fluent_builders::ReplaceNetworkAclEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceRoute` operation.
    ///
    /// See [`ReplaceRoute`](crate::client::fluent_builders::ReplaceRoute) for more information about the
    /// operation and its arguments.
    pub fn replace_route(&self) -> fluent_builders::ReplaceRoute<C, M, R> {
        fluent_builders::ReplaceRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceRouteTableAssociation` operation.
    ///
    /// See [`ReplaceRouteTableAssociation`](crate::client::fluent_builders::ReplaceRouteTableAssociation) for more information about the
    /// operation and its arguments.
    pub fn replace_route_table_association(
        &self,
    ) -> fluent_builders::ReplaceRouteTableAssociation<C, M, R> {
        fluent_builders::ReplaceRouteTableAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReplaceTransitGatewayRoute` operation.
    ///
    /// See [`ReplaceTransitGatewayRoute`](crate::client::fluent_builders::ReplaceTransitGatewayRoute) for more information about the
    /// operation and its arguments.
    pub fn replace_transit_gateway_route(
        &self,
    ) -> fluent_builders::ReplaceTransitGatewayRoute<C, M, R> {
        fluent_builders::ReplaceTransitGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReportInstanceStatus` operation.
    ///
    /// See [`ReportInstanceStatus`](crate::client::fluent_builders::ReportInstanceStatus) for more information about the
    /// operation and its arguments.
    pub fn report_instance_status(&self) -> fluent_builders::ReportInstanceStatus<C, M, R> {
        fluent_builders::ReportInstanceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RequestSpotFleet` operation.
    ///
    /// See [`RequestSpotFleet`](crate::client::fluent_builders::RequestSpotFleet) for more information about the
    /// operation and its arguments.
    pub fn request_spot_fleet(&self) -> fluent_builders::RequestSpotFleet<C, M, R> {
        fluent_builders::RequestSpotFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RequestSpotInstances` operation.
    ///
    /// See [`RequestSpotInstances`](crate::client::fluent_builders::RequestSpotInstances) for more information about the
    /// operation and its arguments.
    pub fn request_spot_instances(&self) -> fluent_builders::RequestSpotInstances<C, M, R> {
        fluent_builders::RequestSpotInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetAddressAttribute` operation.
    ///
    /// See [`ResetAddressAttribute`](crate::client::fluent_builders::ResetAddressAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_address_attribute(&self) -> fluent_builders::ResetAddressAttribute<C, M, R> {
        fluent_builders::ResetAddressAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetEbsDefaultKmsKeyId` operation.
    ///
    /// See [`ResetEbsDefaultKmsKeyId`](crate::client::fluent_builders::ResetEbsDefaultKmsKeyId) for more information about the
    /// operation and its arguments.
    pub fn reset_ebs_default_kms_key_id(
        &self,
    ) -> fluent_builders::ResetEbsDefaultKmsKeyId<C, M, R> {
        fluent_builders::ResetEbsDefaultKmsKeyId::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetFpgaImageAttribute` operation.
    ///
    /// See [`ResetFpgaImageAttribute`](crate::client::fluent_builders::ResetFpgaImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_fpga_image_attribute(&self) -> fluent_builders::ResetFpgaImageAttribute<C, M, R> {
        fluent_builders::ResetFpgaImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetImageAttribute` operation.
    ///
    /// See [`ResetImageAttribute`](crate::client::fluent_builders::ResetImageAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_image_attribute(&self) -> fluent_builders::ResetImageAttribute<C, M, R> {
        fluent_builders::ResetImageAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetInstanceAttribute` operation.
    ///
    /// See [`ResetInstanceAttribute`](crate::client::fluent_builders::ResetInstanceAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_instance_attribute(&self) -> fluent_builders::ResetInstanceAttribute<C, M, R> {
        fluent_builders::ResetInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetNetworkInterfaceAttribute` operation.
    ///
    /// See [`ResetNetworkInterfaceAttribute`](crate::client::fluent_builders::ResetNetworkInterfaceAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_network_interface_attribute(
        &self,
    ) -> fluent_builders::ResetNetworkInterfaceAttribute<C, M, R> {
        fluent_builders::ResetNetworkInterfaceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetSnapshotAttribute` operation.
    ///
    /// See [`ResetSnapshotAttribute`](crate::client::fluent_builders::ResetSnapshotAttribute) for more information about the
    /// operation and its arguments.
    pub fn reset_snapshot_attribute(&self) -> fluent_builders::ResetSnapshotAttribute<C, M, R> {
        fluent_builders::ResetSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreAddressToClassic` operation.
    ///
    /// See [`RestoreAddressToClassic`](crate::client::fluent_builders::RestoreAddressToClassic) for more information about the
    /// operation and its arguments.
    pub fn restore_address_to_classic(&self) -> fluent_builders::RestoreAddressToClassic<C, M, R> {
        fluent_builders::RestoreAddressToClassic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreManagedPrefixListVersion` operation.
    ///
    /// See [`RestoreManagedPrefixListVersion`](crate::client::fluent_builders::RestoreManagedPrefixListVersion) for more information about the
    /// operation and its arguments.
    pub fn restore_managed_prefix_list_version(
        &self,
    ) -> fluent_builders::RestoreManagedPrefixListVersion<C, M, R> {
        fluent_builders::RestoreManagedPrefixListVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreSnapshotFromRecycleBin` operation.
    ///
    /// See [`RestoreSnapshotFromRecycleBin`](crate::client::fluent_builders::RestoreSnapshotFromRecycleBin) for more information about the
    /// operation and its arguments.
    pub fn restore_snapshot_from_recycle_bin(
        &self,
    ) -> fluent_builders::RestoreSnapshotFromRecycleBin<C, M, R> {
        fluent_builders::RestoreSnapshotFromRecycleBin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreSnapshotTier` operation.
    ///
    /// See [`RestoreSnapshotTier`](crate::client::fluent_builders::RestoreSnapshotTier) for more information about the
    /// operation and its arguments.
    pub fn restore_snapshot_tier(&self) -> fluent_builders::RestoreSnapshotTier<C, M, R> {
        fluent_builders::RestoreSnapshotTier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeClientVpnIngress` operation.
    ///
    /// See [`RevokeClientVpnIngress`](crate::client::fluent_builders::RevokeClientVpnIngress) for more information about the
    /// operation and its arguments.
    pub fn revoke_client_vpn_ingress(&self) -> fluent_builders::RevokeClientVpnIngress<C, M, R> {
        fluent_builders::RevokeClientVpnIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeSecurityGroupEgress` operation.
    ///
    /// See [`RevokeSecurityGroupEgress`](crate::client::fluent_builders::RevokeSecurityGroupEgress) for more information about the
    /// operation and its arguments.
    pub fn revoke_security_group_egress(
        &self,
    ) -> fluent_builders::RevokeSecurityGroupEgress<C, M, R> {
        fluent_builders::RevokeSecurityGroupEgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeSecurityGroupIngress` operation.
    ///
    /// See [`RevokeSecurityGroupIngress`](crate::client::fluent_builders::RevokeSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn revoke_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeSecurityGroupIngress<C, M, R> {
        fluent_builders::RevokeSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RunInstances` operation.
    ///
    /// See [`RunInstances`](crate::client::fluent_builders::RunInstances) for more information about the
    /// operation and its arguments.
    pub fn run_instances(&self) -> fluent_builders::RunInstances<C, M, R> {
        fluent_builders::RunInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RunScheduledInstances` operation.
    ///
    /// See [`RunScheduledInstances`](crate::client::fluent_builders::RunScheduledInstances) for more information about the
    /// operation and its arguments.
    pub fn run_scheduled_instances(&self) -> fluent_builders::RunScheduledInstances<C, M, R> {
        fluent_builders::RunScheduledInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchLocalGatewayRoutes` operation.
    ///
    /// See [`SearchLocalGatewayRoutes`](crate::client::fluent_builders::SearchLocalGatewayRoutes) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchLocalGatewayRoutes::into_paginator).
    pub fn search_local_gateway_routes(
        &self,
    ) -> fluent_builders::SearchLocalGatewayRoutes<C, M, R> {
        fluent_builders::SearchLocalGatewayRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchTransitGatewayMulticastGroups` operation.
    ///
    /// See [`SearchTransitGatewayMulticastGroups`](crate::client::fluent_builders::SearchTransitGatewayMulticastGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::SearchTransitGatewayMulticastGroups::into_paginator).
    pub fn search_transit_gateway_multicast_groups(
        &self,
    ) -> fluent_builders::SearchTransitGatewayMulticastGroups<C, M, R> {
        fluent_builders::SearchTransitGatewayMulticastGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchTransitGatewayRoutes` operation.
    ///
    /// See [`SearchTransitGatewayRoutes`](crate::client::fluent_builders::SearchTransitGatewayRoutes) for more information about the
    /// operation and its arguments.
    pub fn search_transit_gateway_routes(
        &self,
    ) -> fluent_builders::SearchTransitGatewayRoutes<C, M, R> {
        fluent_builders::SearchTransitGatewayRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendDiagnosticInterrupt` operation.
    ///
    /// See [`SendDiagnosticInterrupt`](crate::client::fluent_builders::SendDiagnosticInterrupt) for more information about the
    /// operation and its arguments.
    pub fn send_diagnostic_interrupt(&self) -> fluent_builders::SendDiagnosticInterrupt<C, M, R> {
        fluent_builders::SendDiagnosticInterrupt::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartInstances` operation.
    ///
    /// See [`StartInstances`](crate::client::fluent_builders::StartInstances) for more information about the
    /// operation and its arguments.
    pub fn start_instances(&self) -> fluent_builders::StartInstances<C, M, R> {
        fluent_builders::StartInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartNetworkInsightsAccessScopeAnalysis` operation.
    ///
    /// See [`StartNetworkInsightsAccessScopeAnalysis`](crate::client::fluent_builders::StartNetworkInsightsAccessScopeAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_network_insights_access_scope_analysis(
        &self,
    ) -> fluent_builders::StartNetworkInsightsAccessScopeAnalysis<C, M, R> {
        fluent_builders::StartNetworkInsightsAccessScopeAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartNetworkInsightsAnalysis` operation.
    ///
    /// See [`StartNetworkInsightsAnalysis`](crate::client::fluent_builders::StartNetworkInsightsAnalysis) for more information about the
    /// operation and its arguments.
    pub fn start_network_insights_analysis(
        &self,
    ) -> fluent_builders::StartNetworkInsightsAnalysis<C, M, R> {
        fluent_builders::StartNetworkInsightsAnalysis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartVpcEndpointServicePrivateDnsVerification` operation.
    ///
    /// See [`StartVpcEndpointServicePrivateDnsVerification`](crate::client::fluent_builders::StartVpcEndpointServicePrivateDnsVerification) for more information about the
    /// operation and its arguments.
    pub fn start_vpc_endpoint_service_private_dns_verification(
        &self,
    ) -> fluent_builders::StartVpcEndpointServicePrivateDnsVerification<C, M, R> {
        fluent_builders::StartVpcEndpointServicePrivateDnsVerification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopInstances` operation.
    ///
    /// See [`StopInstances`](crate::client::fluent_builders::StopInstances) for more information about the
    /// operation and its arguments.
    pub fn stop_instances(&self) -> fluent_builders::StopInstances<C, M, R> {
        fluent_builders::StopInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateClientVpnConnections` operation.
    ///
    /// See [`TerminateClientVpnConnections`](crate::client::fluent_builders::TerminateClientVpnConnections) for more information about the
    /// operation and its arguments.
    pub fn terminate_client_vpn_connections(
        &self,
    ) -> fluent_builders::TerminateClientVpnConnections<C, M, R> {
        fluent_builders::TerminateClientVpnConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TerminateInstances` operation.
    ///
    /// See [`TerminateInstances`](crate::client::fluent_builders::TerminateInstances) for more information about the
    /// operation and its arguments.
    pub fn terminate_instances(&self) -> fluent_builders::TerminateInstances<C, M, R> {
        fluent_builders::TerminateInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnassignIpv6Addresses` operation.
    ///
    /// See [`UnassignIpv6Addresses`](crate::client::fluent_builders::UnassignIpv6Addresses) for more information about the
    /// operation and its arguments.
    pub fn unassign_ipv6_addresses(&self) -> fluent_builders::UnassignIpv6Addresses<C, M, R> {
        fluent_builders::UnassignIpv6Addresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnassignPrivateIpAddresses` operation.
    ///
    /// See [`UnassignPrivateIpAddresses`](crate::client::fluent_builders::UnassignPrivateIpAddresses) for more information about the
    /// operation and its arguments.
    pub fn unassign_private_ip_addresses(
        &self,
    ) -> fluent_builders::UnassignPrivateIpAddresses<C, M, R> {
        fluent_builders::UnassignPrivateIpAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnmonitorInstances` operation.
    ///
    /// See [`UnmonitorInstances`](crate::client::fluent_builders::UnmonitorInstances) for more information about the
    /// operation and its arguments.
    pub fn unmonitor_instances(&self) -> fluent_builders::UnmonitorInstances<C, M, R> {
        fluent_builders::UnmonitorInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecurityGroupRuleDescriptionsEgress` operation.
    ///
    /// See [`UpdateSecurityGroupRuleDescriptionsEgress`](crate::client::fluent_builders::UpdateSecurityGroupRuleDescriptionsEgress) for more information about the
    /// operation and its arguments.
    pub fn update_security_group_rule_descriptions_egress(
        &self,
    ) -> fluent_builders::UpdateSecurityGroupRuleDescriptionsEgress<C, M, R> {
        fluent_builders::UpdateSecurityGroupRuleDescriptionsEgress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecurityGroupRuleDescriptionsIngress` operation.
    ///
    /// See [`UpdateSecurityGroupRuleDescriptionsIngress`](crate::client::fluent_builders::UpdateSecurityGroupRuleDescriptionsIngress) for more information about the
    /// operation and its arguments.
    pub fn update_security_group_rule_descriptions_ingress(
        &self,
    ) -> fluent_builders::UpdateSecurityGroupRuleDescriptionsIngress<C, M, R> {
        fluent_builders::UpdateSecurityGroupRuleDescriptionsIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `WithdrawByoipCidr` operation.
    ///
    /// See [`WithdrawByoipCidr`](crate::client::fluent_builders::WithdrawByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn withdraw_byoip_cidr(&self) -> fluent_builders::WithdrawByoipCidr<C, M, R> {
        fluent_builders::WithdrawByoipCidr::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptReservedInstancesExchangeQuote`.
    ///
    /// <p>Accepts the Convertible Reserved Instance exchange quote described in the <code>GetReservedInstancesExchangeQuote</code> call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptReservedInstancesExchangeQuote<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_reserved_instances_exchange_quote_input::Builder,
    }
    impl<C, M, R> AcceptReservedInstancesExchangeQuote<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptReservedInstancesExchangeQuote`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptReservedInstancesExchangeQuoteOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptReservedInstancesExchangeQuoteError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptReservedInstancesExchangeQuoteInputOperationOutputAlias,
                crate::output::AcceptReservedInstancesExchangeQuoteOutput,
                crate::error::AcceptReservedInstancesExchangeQuoteError,
                crate::input::AcceptReservedInstancesExchangeQuoteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `ReservedInstanceIds`.
        ///
        /// To override the contents of this collection use [`set_reserved_instance_ids`](Self::set_reserved_instance_ids).
        ///
        /// <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
        pub fn reserved_instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_instance_ids(input.into());
            self
        }
        /// <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
        pub fn set_reserved_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instance_ids(input);
            self
        }
        /// Appends an item to `TargetConfigurations`.
        ///
        /// To override the contents of this collection use [`set_target_configurations`](Self::set_target_configurations).
        ///
        /// <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
        pub fn target_configurations(
            mut self,
            input: crate::model::TargetConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.target_configurations(input);
            self
        }
        /// <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
        pub fn set_target_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetConfigurationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_target_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptTransitGatewayMulticastDomainAssociations`.
    ///
    /// <p>Accepts a request to associate subnets with a transit gateway multicast domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptTransitGatewayMulticastDomainAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_transit_gateway_multicast_domain_associations_input::Builder,
    }
    impl<C, M, R> AcceptTransitGatewayMulticastDomainAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptTransitGatewayMulticastDomainAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::AcceptTransitGatewayMulticastDomainAssociationsOutput, aws_smithy_http::result::SdkError<crate::error::AcceptTransitGatewayMulticastDomainAssociationsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::AcceptTransitGatewayMulticastDomainAssociationsInputOperationOutputAlias,
                                    crate::output::AcceptTransitGatewayMulticastDomainAssociationsOutput,
                                    crate::error::AcceptTransitGatewayMulticastDomainAssociationsError,
                                    crate::input::AcceptTransitGatewayMulticastDomainAssociationsInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn transit_gateway_multicast_domain_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_multicast_domain_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_multicast_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_multicast_domain_id(input);
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_attachment_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_attachment_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptTransitGatewayPeeringAttachment`.
    ///
    /// <p>Accepts a transit gateway peering attachment request. The peering attachment must be in the <code>pendingAcceptance</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptTransitGatewayPeeringAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_transit_gateway_peering_attachment_input::Builder,
    }
    impl<C, M, R> AcceptTransitGatewayPeeringAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptTransitGatewayPeeringAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptTransitGatewayPeeringAttachmentOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptTransitGatewayPeeringAttachmentError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptTransitGatewayPeeringAttachmentInputOperationOutputAlias,
                crate::output::AcceptTransitGatewayPeeringAttachmentOutput,
                crate::error::AcceptTransitGatewayPeeringAttachmentError,
                crate::input::AcceptTransitGatewayPeeringAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_attachment_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_attachment_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptTransitGatewayVpcAttachment`.
    ///
    /// <p>Accepts a request to attach a VPC to a transit gateway.</p>
    /// <p>The VPC attachment must be in the <code>pendingAcceptance</code> state. Use <code>DescribeTransitGatewayVpcAttachments</code> to view your pending VPC attachment requests. Use <code>RejectTransitGatewayVpcAttachment</code> to reject a VPC attachment request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptTransitGatewayVpcAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_transit_gateway_vpc_attachment_input::Builder,
    }
    impl<C, M, R> AcceptTransitGatewayVpcAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptTransitGatewayVpcAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptTransitGatewayVpcAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptTransitGatewayVpcAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptTransitGatewayVpcAttachmentInputOperationOutputAlias,
                crate::output::AcceptTransitGatewayVpcAttachmentOutput,
                crate::error::AcceptTransitGatewayVpcAttachmentError,
                crate::input::AcceptTransitGatewayVpcAttachmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_attachment_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptVpcEndpointConnections`.
    ///
    /// <p>Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptVpcEndpointConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_vpc_endpoint_connections_input::Builder,
    }
    impl<C, M, R> AcceptVpcEndpointConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptVpcEndpointConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptVpcEndpointConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptVpcEndpointConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptVpcEndpointConnectionsInputOperationOutputAlias,
                crate::output::AcceptVpcEndpointConnectionsOutput,
                crate::error::AcceptVpcEndpointConnectionsError,
                crate::input::AcceptVpcEndpointConnectionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the VPC endpoint service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_id(input.into());
            self
        }
        /// <p>The ID of the VPC endpoint service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_id(input);
            self
        }
        /// Appends an item to `VpcEndpointIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_endpoint_ids`](Self::set_vpc_endpoint_ids).
        ///
        /// <p>The IDs of one or more interface VPC endpoints.</p>
        pub fn vpc_endpoint_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_ids(input.into());
            self
        }
        /// <p>The IDs of one or more interface VPC endpoints.</p>
        pub fn set_vpc_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AcceptVpcPeeringConnection`.
    ///
    /// <p>Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use <code>DescribeVpcPeeringConnections</code> to view your outstanding VPC peering connection requests.</p>
    /// <p>For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of the accepter VPC.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptVpcPeeringConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_vpc_peering_connection_input::Builder,
    }
    impl<C, M, R> AcceptVpcPeeringConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptVpcPeeringConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptVpcPeeringConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptVpcPeeringConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptVpcPeeringConnectionInputOperationOutputAlias,
                crate::output::AcceptVpcPeeringConnectionOutput,
                crate::error::AcceptVpcPeeringConnectionError,
                crate::input::AcceptVpcPeeringConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_peering_connection_id(input.into());
            self
        }
        /// <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_peering_connection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdvertiseByoipCidr`.
    ///
    /// <p>Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).</p>
    /// <p>You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p>
    /// <p>We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through Amazon Web Services.</p>
    /// <p>It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of BGP propagation delays.</p>
    /// <p>To stop advertising the BYOIP CIDR, use <code>WithdrawByoipCidr</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdvertiseByoipCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::advertise_byoip_cidr_input::Builder,
    }
    impl<C, M, R> AdvertiseByoipCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdvertiseByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdvertiseByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::AdvertiseByoipCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdvertiseByoipCidrInputOperationOutputAlias,
                crate::output::AdvertiseByoipCidrOutput,
                crate::error::AdvertiseByoipCidrError,
                crate::input::AdvertiseByoipCidrInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateAddress`.
    ///
    /// <p>Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account.</p>
    /// <p>You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>[EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another Amazon Web Services account. You cannot recover an Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.</p>
    /// <p>An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_address_input::Builder,
    }
    impl<C, M, R> AllocateAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateAddressInputOperationOutputAlias,
                crate::output::AllocateAddressOutput,
                crate::error::AllocateAddressError,
                crate::input::AllocateAddressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p>
        /// <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
        pub fn domain(mut self, input: crate::model::DomainType) -> Self {
            self.inner = self.inner.domain(input);
            self
        }
        /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p>
        /// <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::DomainType>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address(input.into());
            self
        }
        /// <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
        pub fn public_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_ipv4_pool(input.into());
            self
        }
        /// <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
        pub fn set_public_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_ipv4_pool(input);
            self
        }
        /// <p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p>
        /// <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p>
        /// <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an <code>InvalidParameterCombination</code> error.</p>
        pub fn network_border_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_border_group(input.into());
            self
        }
        /// <p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p>
        /// <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p>
        /// <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an <code>InvalidParameterCombination</code> error.</p>
        pub fn set_network_border_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_border_group(input);
            self
        }
        /// <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
        pub fn customer_owned_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.customer_owned_ipv4_pool(input.into());
            self
        }
        /// <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
        pub fn set_customer_owned_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_customer_owned_ipv4_pool(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the Elastic IP address.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the Elastic IP address.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateHosts`.
    ///
    /// <p>Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateHosts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_hosts_input::Builder,
    }
    impl<C, M, R> AllocateHosts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateHosts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateHostsOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateHostsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateHostsInputOperationOutputAlias,
                crate::output::AllocateHostsOutput,
                crate::error::AllocateHostsError,
                crate::input::AllocateHostsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>on</code> </p>
        pub fn auto_placement(mut self, input: crate::model::AutoPlacement) -> Self {
            self.inner = self.inner.auto_placement(input);
            self
        }
        /// <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>on</code> </p>
        pub fn set_auto_placement(
            mut self,
            input: std::option::Option<crate::model::AutoPlacement>,
        ) -> Self {
            self.inner = self.inner.set_auto_placement(input);
            self
        }
        /// <p>The Availability Zone in which to allocate the Dedicated Host.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone in which to allocate the Dedicated Host.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p>
        /// <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p>
        /// <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p>
        /// <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
        pub fn instance_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_family(input.into());
            self
        }
        /// <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p>
        /// <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
        pub fn set_instance_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_family(input);
            self
        }
        /// <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.inner = self.inner.quantity(input);
            self
        }
        /// <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_quantity(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Dedicated Host during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the Dedicated Host during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>off</code> </p>
        pub fn host_recovery(mut self, input: crate::model::HostRecovery) -> Self {
            self.inner = self.inner.host_recovery(input);
            self
        }
        /// <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>off</code> </p>
        pub fn set_host_recovery(
            mut self,
            input: std::option::Option<crate::model::HostRecovery>,
        ) -> Self {
            self.inner = self.inner.set_host_recovery(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllocateIpamPoolCidr`.
    ///
    /// <p>Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR assignment from an IPAM pool to another resource or IPAM pool. For more information, see <a href="/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllocateIpamPoolCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_ipam_pool_cidr_input::Builder,
    }
    impl<C, M, R> AllocateIpamPoolCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateIpamPoolCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateIpamPoolCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateIpamPoolCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateIpamPoolCidrInputOperationOutputAlias,
                crate::output::AllocateIpamPoolCidrOutput,
                crate::error::AllocateIpamPoolCidrError,
                crate::input::AllocateIpamPoolCidrInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the IPAM pool from which you would like to allocate a CIDR.</p>
        pub fn ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipam_pool_id(input.into());
            self
        }
        /// <p>The ID of the IPAM pool from which you would like to allocate a CIDR.</p>
        pub fn set_ipam_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ipam_pool_id(input);
            self
        }
        /// <p>The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible values: Any available IPv4 or IPv6 CIDR.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible values: Any available IPv4 or IPv6 CIDR.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
        /// <p>The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.netmask_length(input);
            self
        }
        /// <p>The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_netmask_length(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A description for the allocation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the allocation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A preview of the next available CIDR in a pool.</p>
        pub fn preview_next_cidr(mut self, input: bool) -> Self {
            self.inner = self.inner.preview_next_cidr(input);
            self
        }
        /// <p>A preview of the next available CIDR in a pool.</p>
        pub fn set_preview_next_cidr(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preview_next_cidr(input);
            self
        }
        /// Appends an item to `DisallowedCidrs`.
        ///
        /// To override the contents of this collection use [`set_disallowed_cidrs`](Self::set_disallowed_cidrs).
        ///
        /// <p>Exclude a particular CIDR range from being returned by the pool.</p>
        pub fn disallowed_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disallowed_cidrs(input.into());
            self
        }
        /// <p>Exclude a particular CIDR range from being returned by the pool.</p>
        pub fn set_disallowed_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_disallowed_cidrs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplySecurityGroupsToClientVpnTargetNetwork`.
    ///
    /// <p>Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplySecurityGroupsToClientVpnTargetNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_security_groups_to_client_vpn_target_network_input::Builder,
    }
    impl<C, M, R> ApplySecurityGroupsToClientVpnTargetNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplySecurityGroupsToClientVpnTargetNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplySecurityGroupsToClientVpnTargetNetworkOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ApplySecurityGroupsToClientVpnTargetNetworkError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInputOperationOutputAlias,
                crate::output::ApplySecurityGroupsToClientVpnTargetNetworkOutput,
                crate::error::ApplySecurityGroupsToClientVpnTargetNetworkError,
                crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_vpn_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_vpn_endpoint_id(input);
            self
        }
        /// <p>The ID of the VPC in which the associated target network is located.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC in which the associated target network is located.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssignIpv6Addresses`.
    ///
    /// <p>Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>You must specify either the IPv6 addresses or the IPv6 address count in the request. </p>
    /// <p>You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssignIpv6Addresses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::assign_ipv6_addresses_input::Builder,
    }
    impl<C, M, R> AssignIpv6Addresses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssignIpv6Addresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssignIpv6AddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssignIpv6AddressesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssignIpv6AddressesInputOperationOutputAlias,
                crate::output::AssignIpv6AddressesOutput,
                crate::error::AssignIpv6AddressesError,
                crate::input::AssignIpv6AddressesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv6_address_count(input);
            self
        }
        /// <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv6_address_count(input);
            self
        }
        /// Appends an item to `Ipv6Addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn ipv6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_addresses(input.into());
            self
        }
        /// <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_addresses(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn ipv6_prefix_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv6_prefix_count(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn set_ipv6_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv6_prefix_count(input);
            self
        }
        /// Appends an item to `Ipv6Prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn ipv6_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_prefixes(input.into());
            self
        }
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_prefixes(input);
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssignPrivateIpAddresses`.
    ///
    /// <p>Assigns one or more secondary private IP addresses to the specified network interface.</p>
    /// <p>You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved.</p>
    /// <p>Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the remapping is complete.</p>
    /// <p>You must specify either the IP addresses or the IP address count in the request.</p>
    /// <p>You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssignPrivateIpAddresses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::assign_private_ip_addresses_input::Builder,
    }
    impl<C, M, R> AssignPrivateIpAddresses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssignPrivateIpAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssignPrivateIpAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssignPrivateIpAddressesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssignPrivateIpAddressesInputOperationOutputAlias,
                crate::output::AssignPrivateIpAddressesOutput,
                crate::error::AssignPrivateIpAddressesError,
                crate::input::AssignPrivateIpAddressesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
        pub fn allow_reassignment(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_reassignment(input);
            self
        }
        /// <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
        pub fn set_allow_reassignment(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_reassignment(input);
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// Appends an item to `PrivateIpAddresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
        /// <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
        pub fn private_ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.private_ip_addresses(input.into());
            self
        }
        /// <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
        /// <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_private_ip_addresses(input);
            self
        }
        /// <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.inner = self.inner.secondary_private_ip_address_count(input);
            self
        }
        /// <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_secondary_private_ip_address_count(input);
            self
        }
        /// Appends an item to `Ipv4Prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn ipv4_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv4_prefixes(input.into());
            self
        }
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ipv4_prefixes(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn ipv4_prefix_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv4_prefix_count(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn set_ipv4_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv4_prefix_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateAddress`.
    ///
    /// <p>Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account.</p>
    /// <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>[EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account.</p>
    /// <p>[VPC in an EC2-Classic account] If you don't specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address with an instance or network interface that has an existing Elastic IP address.</p>
    /// <p>[Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface. </p>
    /// <p>You cannot associate an Elastic IP address with an interface in a different network border group.</p> <important>
    /// <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2 Pricing</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_address_input::Builder,
    }
    impl<C, M, R> AssociateAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAddressOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateAddressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAddressInputOperationOutputAlias,
                crate::output::AssociateAddressOutput,
                crate::error::AssociateAddressError,
                crate::input::AssociateAddressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
        pub fn allocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allocation_id(input.into());
            self
        }
        /// <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
        pub fn set_allocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_allocation_id(input);
            self
        }
        /// <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_ip(input.into());
            self
        }
        /// <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_public_ip(input);
            self
        }
        /// <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
        pub fn allow_reassociation(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_reassociation(input);
            self
        }
        /// <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
        pub fn set_allow_reassociation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_reassociation(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>
        /// <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>
        /// <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.private_ip_address(input.into());
            self
        }
        /// <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_private_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateClientVpnTargetNetwork`.
    ///
    /// <p>Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.</p>
    /// <p>If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify the Client VPN endpoint (<code>ModifyClientVpnEndpoint</code>) and change the VPC that's associated with it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateClientVpnTargetNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_client_vpn_target_network_input::Builder,
    }
    impl<C, M, R> AssociateClientVpnTargetNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateClientVpnTargetNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateClientVpnTargetNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateClientVpnTargetNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateClientVpnTargetNetworkInputOperationOutputAlias,
                crate::output::AssociateClientVpnTargetNetworkOutput,
                crate::error::AssociateClientVpnTargetNetworkError,
                crate::input::AssociateClientVpnTargetNetworkInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_vpn_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_vpn_endpoint_id(input);
            self
        }
        /// <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDhcpOptions`.
    ///
    /// <p>Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC.</p>
    /// <p>After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDhcpOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_dhcp_options_input::Builder,
    }
    impl<C, M, R> AssociateDhcpOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDhcpOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDhcpOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDhcpOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDhcpOptionsInputOperationOutputAlias,
                crate::output::AssociateDhcpOptionsOutput,
                crate::error::AssociateDhcpOptionsError,
                crate::input::AssociateDhcpOptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
        pub fn dhcp_options_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dhcp_options_id(input.into());
            self
        }
        /// <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
        pub fn set_dhcp_options_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dhcp_options_id(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateEnclaveCertificateIamRole`.
    ///
    /// <p>Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
    /// <p>When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted private key are placed in an Amazon S3 bucket that only the associated IAM role can access. The private key of the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.</p>
    /// <p>To enable the IAM role to access the Amazon S3 object, you must grant it permission to call <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command. For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateEnclaveCertificateIamRole<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_enclave_certificate_iam_role_input::Builder,
    }
    impl<C, M, R> AssociateEnclaveCertificateIamRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateEnclaveCertificateIamRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEnclaveCertificateIamRoleOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateEnclaveCertificateIamRoleError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateEnclaveCertificateIamRoleInputOperationOutputAlias,
                crate::output::AssociateEnclaveCertificateIamRoleOutput,
                crate::error::AssociateEnclaveCertificateIamRoleError,
                crate::input::AssociateEnclaveCertificateIamRoleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateIamInstanceProfile`.
    ///
    /// <p>Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateIamInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_iam_instance_profile_input::Builder,
    }
    impl<C, M, R> AssociateIamInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateIamInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateIamInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateIamInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateIamInstanceProfileInputOperationOutputAlias,
                crate::output::AssociateIamInstanceProfileOutput,
                crate::error::AssociateIamInstanceProfileError,
                crate::input::AssociateIamInstanceProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM instance profile.</p>
        pub fn iam_instance_profile(
            mut self,
            input: crate::model::IamInstanceProfileSpecification,
        ) -> Self {
            self.inner = self.inner.iam_instance_profile(input);
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::IamInstanceProfileSpecification>,
        ) -> Self {
            self.inner = self.inner.set_iam_instance_profile(input);
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateInstanceEventWindow`.
    ///
    /// <p>Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateInstanceEventWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_instance_event_window_input::Builder,
    }
    impl<C, M, R> AssociateInstanceEventWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateInstanceEventWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateInstanceEventWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateInstanceEventWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateInstanceEventWindowInputOperationOutputAlias,
                crate::output::AssociateInstanceEventWindowOutput,
                crate::error::AssociateInstanceEventWindowError,
                crate::input::AssociateInstanceEventWindowInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the event window.</p>
        pub fn instance_event_window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_event_window_id(input.into());
            self
        }
        /// <p>The ID of the event window.</p>
        pub fn set_instance_event_window_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_event_window_id(input);
            self
        }
        /// <p>One or more targets associated with the specified event window.</p>
        pub fn association_target(
            mut self,
            input: crate::model::InstanceEventWindowAssociationRequest,
        ) -> Self {
            self.inner = self.inner.association_target(input);
            self
        }
        /// <p>One or more targets associated with the specified event window.</p>
        pub fn set_association_target(
            mut self,
            input: std::option::Option<crate::model::InstanceEventWindowAssociationRequest>,
        ) -> Self {
            self.inner = self.inner.set_association_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateRouteTable`.
    ///
    /// <p>Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateRouteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_route_table_input::Builder,
    }
    impl<C, M, R> AssociateRouteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateRouteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateRouteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateRouteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateRouteTableInputOperationOutputAlias,
                crate::output::AssociateRouteTableOutput,
                crate::error::AssociateRouteTableError,
                crate::input::AssociateRouteTableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_table_id(input.into());
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_table_id(input);
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The ID of the internet gateway or virtual private gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of the internet gateway or virtual private gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSubnetCidrBlock`.
    ///
    /// <p>Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length of /64.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateSubnetCidrBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_subnet_cidr_block_input::Builder,
    }
    impl<C, M, R> AssociateSubnetCidrBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSubnetCidrBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSubnetCidrBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSubnetCidrBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSubnetCidrBlockInputOperationOutputAlias,
                crate::output::AssociateSubnetCidrBlockOutput,
                crate::error::AssociateSubnetCidrBlockError,
                crate::input::AssociateSubnetCidrBlockInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_cidr_block(input.into());
            self
        }
        /// <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_cidr_block(input);
            self
        }
        /// <p>The ID of your subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of your subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTransitGatewayMulticastDomain`.
    ///
    /// <p>Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.</p>
    /// <p>The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments</a> to see the state of the attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTransitGatewayMulticastDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_transit_gateway_multicast_domain_input::Builder,
    }
    impl<C, M, R> AssociateTransitGatewayMulticastDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTransitGatewayMulticastDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTransitGatewayMulticastDomainOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateTransitGatewayMulticastDomainError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTransitGatewayMulticastDomainInputOperationOutputAlias,
                crate::output::AssociateTransitGatewayMulticastDomainOutput,
                crate::error::AssociateTransitGatewayMulticastDomainError,
                crate::input::AssociateTransitGatewayMulticastDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn transit_gateway_multicast_domain_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_multicast_domain_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_multicast_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_multicast_domain_id(input);
            self
        }
        /// <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_attachment_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_attachment_id(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTransitGatewayRouteTable`.
    ///
    /// <p>Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTransitGatewayRouteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_transit_gateway_route_table_input::Builder,
    }
    impl<C, M, R> AssociateTransitGatewayRouteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTransitGatewayRouteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTransitGatewayRouteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTransitGatewayRouteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTransitGatewayRouteTableInputOperationOutputAlias,
                crate::output::AssociateTransitGatewayRouteTableOutput,
                crate::error::AssociateTransitGatewayRouteTableError,
                crate::input::AssociateTransitGatewayRouteTableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the transit gateway route table.</p>
        pub fn transit_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_route_table_id(input.into());
            self
        }
        /// <p>The ID of the transit gateway route table.</p>
        pub fn set_transit_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_route_table_id(input);
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.transit_gateway_attachment_id(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_attachment_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTrunkInterface`.
    ///
    /// <note>
    /// <p>This API action is currently in <b>limited preview only</b>. If you are interested in using this feature, contact your account manager.</p>
    /// </note>
    /// <p>Associates a branch network interface with a trunk network interface.</p>
    /// <p>Before you create the association, run the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTrunkInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_trunk_interface_input::Builder,
    }
    impl<C, M, R> AssociateTrunkInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTrunkInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrunkInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrunkInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTrunkInterfaceInputOperationOutputAlias,
                crate::output::AssociateTrunkInterfaceOutput,
                crate::error::AssociateTrunkInterfaceError,
                crate::input::AssociateTrunkInterfaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the branch network interface.</p>
        pub fn branch_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_interface_id(input.into());
            self
        }
        /// <p>The ID of the branch network interface.</p>
        pub fn set_branch_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_branch_interface_id(input);
            self
        }
        /// <p>The ID of the trunk network interface.</p>
        pub fn trunk_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trunk_interface_id(input.into());
            self
        }
        /// <p>The ID of the trunk network interface.</p>
        pub fn set_trunk_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trunk_interface_id(input);
            self
        }
        /// <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
        pub fn vlan_id(mut self, input: i32) -> Self {
            self.inner = self.inner.vlan_id(input);
            self
        }
        /// <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
        pub fn set_vlan_id(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vlan_id(input);
            self
        }
        /// <p>The application key. This applies to the GRE protocol.</p>
        pub fn gre_key(mut self, input: i32) -> Self {
            self.inner = self.inner.gre_key(input);
            self
        }
        /// <p>The application key. This applies to the GRE protocol.</p>
        pub fn set_gre_key(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_gre_key(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateVpcCidrBlock`.
    ///
    /// <p>Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>). The IPv6 CIDR block size is fixed at /56.</p>
    /// <p>You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.</p>
    /// <p>For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and subnet sizing</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateVpcCidrBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_vpc_cidr_block_input::Builder,
    }
    impl<C, M, R> AssociateVpcCidrBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateVpcCidrBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateVpcCidrBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateVpcCidrBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateVpcCidrBlockInputOperationOutputAlias,
                crate::output::AssociateVpcCidrBlockOutput,
                crate::error::AssociateVpcCidrBlockError,
                crate::input::AssociateVpcCidrBlockInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
        pub fn amazon_provided_ipv6_cidr_block(mut self, input: bool) -> Self {
            self.inner = self.inner.amazon_provided_ipv6_cidr_block(input);
            self
        }
        /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
        pub fn set_amazon_provided_ipv6_cidr_block(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_amazon_provided_ipv6_cidr_block(input);
            self
        }
        /// <p>An IPv4 CIDR block to associate with the VPC.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_block(input.into());
            self
        }
        /// <p>An IPv4 CIDR block to associate with the VPC.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr_block(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p>
        /// <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
        /// <p> You can have one IPv6 CIDR block association per network border group.</p>
        pub fn ipv6_cidr_block_network_border_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .ipv6_cidr_block_network_border_group(input.into());
            self
        }
        /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p>
        /// <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
        /// <p> You can have one IPv6 CIDR block association per network border group.</p>
        pub fn set_ipv6_cidr_block_network_border_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_cidr_block_network_border_group(input);
            self
        }
        /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
        pub fn ipv6_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_pool(input.into());
            self
        }
        /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
        pub fn set_ipv6_pool(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ipv6_pool(input);
            self
        }
        /// <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>
        /// <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_cidr_block(input.into());
            self
        }
        /// <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>
        /// <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_cidr_block(input);
            self
        }
        /// <p>Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn ipv4_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv4_ipam_pool_id(input.into());
            self
        }
        /// <p>Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn set_ipv4_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv4_ipam_pool_id(input);
            self
        }
        /// <p>The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn ipv4_netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv4_netmask_length(input);
            self
        }
        /// <p>The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_ipv4_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv4_netmask_length(input);
            self
        }
        /// <p>Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn ipv6_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_ipam_pool_id(input.into());
            self
        }
        /// <p>Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn set_ipv6_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_ipam_pool_id(input);
            self
        }
        /// <p>The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn ipv6_netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv6_netmask_length(input);
            self
        }
        /// <p>The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_ipv6_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv6_netmask_length(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachClassicLinkVpc`.
    ///
    /// <p>Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it to the VPC again when you restart it.</p>
    /// <p>After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.</p>
    /// <p>Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachClassicLinkVpc<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_classic_link_vpc_input::Builder,
    }
    impl<C, M, R> AttachClassicLinkVpc<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachClassicLinkVpc`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachClassicLinkVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachClassicLinkVpcError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachClassicLinkVpcInputOperationOutputAlias,
                crate::output::AttachClassicLinkVpcOutput,
                crate::error::AttachClassicLinkVpcError,
                crate::input::AttachClassicLinkVpcInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(input.into());
            self
        }
        /// <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachInternetGateway`.
    ///
    /// <p>Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachInternetGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_internet_gateway_input::Builder,
    }
    impl<C, M, R> AttachInternetGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachInternetGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachInternetGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachInternetGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachInternetGatewayInputOperationOutputAlias,
                crate::output::AttachInternetGatewayOutput,
                crate::error::AttachInternetGatewayError,
                crate::input::AttachInternetGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the internet gateway.</p>
        pub fn internet_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.internet_gateway_id(input.into());
            self
        }
        /// <p>The ID of the internet gateway.</p>
        pub fn set_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_internet_gateway_id(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachNetworkInterface`.
    ///
    /// <p>Attaches a network interface to an instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachNetworkInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_network_interface_input::Builder,
    }
    impl<C, M, R> AttachNetworkInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachNetworkInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachNetworkInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachNetworkInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachNetworkInterfaceInputOperationOutputAlias,
                crate::output::AttachNetworkInterfaceOutput,
                crate::error::AttachNetworkInterfaceError,
                crate::input::AttachNetworkInterfaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn device_index(mut self, input: i32) -> Self {
            self.inner = self.inner.device_index(input);
            self
        }
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn set_device_index(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_device_index(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        pub fn network_card_index(mut self, input: i32) -> Self {
            self.inner = self.inner.network_card_index(input);
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        pub fn set_network_card_index(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_network_card_index(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachVolume`.
    ///
    /// <p>Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.</p>
    /// <p>Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>After you attach an EBS volume, you must make it available. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Make an EBS volume available for use</a>.</p>
    /// <p>If a volume has an Amazon Web Services Marketplace product code:</p>
    /// <ul>
    /// <li> <p>The volume can be attached only to a stopped instance.</p> </li>
    /// <li> <p>Amazon Web Services Marketplace product codes are copied from the volume to the instance.</p> </li>
    /// <li> <p>You must be subscribed to the product.</p> </li>
    /// <li> <p>The instance type and operating system of the instance must support the product. For example, you can't detach a volume from a Windows instance and attach it to a Linux instance.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attach an Amazon EBS volume to an instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachVolume<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_volume_input::Builder,
    }
    impl<C, M, R> AttachVolume<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachVolume`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachVolumeOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachVolumeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachVolumeInputOperationOutputAlias,
                crate::output::AttachVolumeOutput,
                crate::error::AttachVolumeError,
                crate::input::AttachVolumeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device(input.into());
            self
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device(input);
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachVpnGateway`.
    ///
    /// <p>Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AttachVpnGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_vpn_gateway_input::Builder,
    }
    impl<C, M, R> AttachVpnGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachVpnGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachVpnGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachVpnGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachVpnGatewayInputOperationOutputAlias,
                crate::output::AttachVpnGatewayOutput,
                crate::error::AttachVpnGatewayError,
                crate::input::AttachVpnGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn vpn_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpn_gateway_id(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_vpn_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpn_gateway_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeClientVpnIngress`.
    ///
    /// <p>Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in Amazon Web Services or on-premises networks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeClientVpnIngress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_client_vpn_ingress_input::Builder,
    }
    impl<C, M, R> AuthorizeClientVpnIngress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeClientVpnIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeClientVpnIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeClientVpnIngressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeClientVpnIngressInputOperationOutputAlias,
                crate::output::AuthorizeClientVpnIngressOutput,
                crate::error::AuthorizeClientVpnIngressError,
                crate::input::AuthorizeClientVpnIngressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_vpn_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_vpn_endpoint_id(input);
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
        pub fn target_network_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_network_cidr(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
        pub fn set_target_network_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_network_cidr(input);
            self
        }
        /// <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
        pub fn access_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_group_id(input.into());
            self
        }
        /// <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
        pub fn set_access_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_group_id(input);
            self
        }
        /// <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
        pub fn authorize_all_groups(mut self, input: bool) -> Self {
            self.inner = self.inner.authorize_all_groups(input);
            self
        }
        /// <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
        pub fn set_authorize_all_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_authorize_all_groups(input);
            self
        }
        /// <p>A brief description of the authorization rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A brief description of the authorization rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeSecurityGroupEgress`.
    ///
    /// <p>[VPC only] Adds the specified outbound (egress) rules to a security group for use with a VPC.</p>
    /// <p>An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the instances that are associated with the specified source security groups.</p>
    /// <p>You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes.</p>
    /// <p>Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.</p>
    /// <p>For information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeSecurityGroupEgress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_security_group_egress_input::Builder,
    }
    impl<C, M, R> AuthorizeSecurityGroupEgress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeSecurityGroupEgress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeSecurityGroupEgressOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeSecurityGroupEgressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeSecurityGroupEgressInputOperationOutputAlias,
                crate::output::AuthorizeSecurityGroupEgressOutput,
                crate::error::AuthorizeSecurityGroupEgressError,
                crate::input::AuthorizeSecurityGroupEgressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// Appends an item to `IpPermissions`.
        ///
        /// To override the contents of this collection use [`set_ip_permissions`](Self::set_ip_permissions).
        ///
        /// <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
        pub fn ip_permissions(mut self, input: crate::model::IpPermission) -> Self {
            self.inner = self.inner.ip_permissions(input);
            self
        }
        /// <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
        pub fn set_ip_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.inner = self.inner.set_ip_permissions(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags applied to the security group rule.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags applied to the security group rule.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_ip(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr_ip(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.inner = self.inner.from_port(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_from_port(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
        pub fn ip_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_protocol(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
        pub fn set_ip_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_protocol(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.inner = self.inner.to_port(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_to_port(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn source_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_security_group_name(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn set_source_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_security_group_name(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn source_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_security_group_owner_id(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn set_source_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeSecurityGroupIngress`.
    ///
    /// <p>Adds the specified inbound (ingress) rules to a security group.</p>
    /// <p>An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from the instances that are associated with the specified destination security groups.</p>
    /// <p>You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean all types or all codes.</p>
    /// <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>
    /// <p>For more information about VPC security group quotas, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeSecurityGroupIngress<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_security_group_ingress_input::Builder,
    }
    impl<C, M, R> AuthorizeSecurityGroupIngress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeSecurityGroupIngressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeSecurityGroupIngressInputOperationOutputAlias,
                crate::output::AuthorizeSecurityGroupIngressOutput,
                crate::error::AuthorizeSecurityGroupIngressError,
                crate::input::AuthorizeSecurityGroupIngressInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_ip(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr_ip(input);
            self
        }
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.inner = self.inner.from_port(input);
            self
        }
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_from_port(input);
            self
        }
        /// <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// Appends an item to `IpPermissions`.
        ///
        /// To override the contents of this collection use [`set_ip_permissions`](Self::set_ip_permissions).
        ///
        /// <p>The sets of IP permissions.</p>
        pub fn ip_permissions(mut self, input: crate::model::IpPermission) -> Self {
            self.inner = self.inner.ip_permissions(input);
            self
        }
        /// <p>The sets of IP permissions.</p>
        pub fn set_ip_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.inner = self.inner.set_ip_permissions(input);
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn ip_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_protocol(input.into());
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_ip_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_protocol(input);
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
        pub fn source_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_security_group_name(input.into());
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
        pub fn set_source_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_security_group_name(input);
            self
        }
        /// <p>[nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
        pub fn source_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_security_group_owner_id(input.into());
            self
        }
        /// <p>[nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
        pub fn set_source_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_security_group_owner_id(input);
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.inner = self.inner.to_port(input);
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_to_port(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>[VPC Only] The tags applied to the security group rule.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>[VPC Only] The tags applied to the security group rule.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BundleInstance`.
    ///
    /// <p>Bundles an Amazon instance store-backed Windows instance.</p>
    /// <p>During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not preserved.</p> <note>
    /// <p>This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BundleInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::bundle_instance_input::Builder,
    }
    impl<C, M, R> BundleInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BundleInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BundleInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::BundleInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BundleInstanceInputOperationOutputAlias,
                crate::output::BundleInstanceOutput,
                crate::error::BundleInstanceError,
                crate::input::BundleInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the instance to bundle.</p>
        /// <p>Type: String</p>
        /// <p>Default: None</p>
        /// <p>Required: Yes</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance to bundle.</p>
        /// <p>Type: String</p>
        /// <p>Default: None</p>
        /// <p>Required: Yes</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
        pub fn storage(mut self, input: crate::model::Storage) -> Self {
            self.inner = self.inner.storage(input);
            self
        }
        /// <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
        pub fn set_storage(mut self, input: std::option::Option<crate::model::Storage>) -> Self {
            self.inner = self.inner.set_storage(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelBundleTask`.
    ///
    /// <p>Cancels a bundling operation for an instance store-backed Windows instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelBundleTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_bundle_task_input::Builder,
    }
    impl<C, M, R> CancelBundleTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelBundleTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelBundleTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelBundleTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelBundleTaskInputOperationOutputAlias,
                crate::output::CancelBundleTaskOutput,
                crate::error::CancelBundleTaskError,
                crate::input::CancelBundleTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the bundle task.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(input.into());
            self
        }
        /// <p>The ID of the bundle task.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCapacityReservation`.
    ///
    /// <p>Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to <code>cancelled</code>.</p>
    /// <p>Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCapacityReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_capacity_reservation_input::Builder,
    }
    impl<C, M, R> CancelCapacityReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCapacityReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCapacityReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCapacityReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelCapacityReservationInputOperationOutputAlias,
                crate::output::CancelCapacityReservationOutput,
                crate::error::CancelCapacityReservationError,
                crate::input::CancelCapacityReservationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Capacity Reservation to be cancelled.</p>
        pub fn capacity_reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capacity_reservation_id(input.into());
            self
        }
        /// <p>The ID of the Capacity Reservation to be cancelled.</p>
        pub fn set_capacity_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capacity_reservation_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelCapacityReservationFleets`.
    ///
    /// <p>Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following happens:</p>
    /// <ul>
    /// <li> <p>The Capacity Reservation Fleet's status changes to <code>cancelled</code>.</p> </li>
    /// <li> <p>The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations at the time of cancelling the Fleet continue to run in shared capacity.</p> </li>
    /// <li> <p>The Fleet stops creating new Capacity Reservations.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelCapacityReservationFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_capacity_reservation_fleets_input::Builder,
    }
    impl<C, M, R> CancelCapacityReservationFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelCapacityReservationFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelCapacityReservationFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelCapacityReservationFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelCapacityReservationFleetsInputOperationOutputAlias,
                crate::output::CancelCapacityReservationFleetsOutput,
                crate::error::CancelCapacityReservationFleetsError,
                crate::input::CancelCapacityReservationFleetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `CapacityReservationFleetIds`.
        ///
        /// To override the contents of this collection use [`set_capacity_reservation_fleet_ids`](Self::set_capacity_reservation_fleet_ids).
        ///
        /// <p>The IDs of the Capacity Reservation Fleets to cancel.</p>
        pub fn capacity_reservation_fleet_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.capacity_reservation_fleet_ids(input.into());
            self
        }
        /// <p>The IDs of the Capacity Reservation Fleets to cancel.</p>
        pub fn set_capacity_reservation_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_reservation_fleet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelConversionTask`.
    ///
    /// <p>Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelConversionTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_conversion_task_input::Builder,
    }
    impl<C, M, R> CancelConversionTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelConversionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelConversionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelConversionTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelConversionTaskInputOperationOutputAlias,
                crate::output::CancelConversionTaskOutput,
                crate::error::CancelConversionTaskError,
                crate::input::CancelConversionTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the conversion task.</p>
        pub fn conversion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.conversion_task_id(input.into());
            self
        }
        /// <p>The ID of the conversion task.</p>
        pub fn set_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_conversion_task_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The reason for canceling the conversion task.</p>
        pub fn reason_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason_message(input.into());
            self
        }
        /// <p>The reason for canceling the conversion task.</p>
        pub fn set_reason_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reason_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelExportTask`.
    ///
    /// <p>Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelExportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_export_task_input::Builder,
    }
    impl<C, M, R> CancelExportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelExportTaskInputOperationOutputAlias,
                crate::output::CancelExportTaskOutput,
                crate::error::CancelExportTaskError,
                crate::input::CancelExportTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
        pub fn export_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_task_id(input.into());
            self
        }
        /// <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
        pub fn set_export_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelImportTask`.
    ///
    /// <p>Cancels an in-process import virtual machine or import snapshot task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelImportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_import_task_input::Builder,
    }
    impl<C, M, R> CancelImportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelImportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelImportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelImportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelImportTaskInputOperationOutputAlias,
                crate::output::CancelImportTaskOutput,
                crate::error::CancelImportTaskError,
                crate::input::CancelImportTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The reason for canceling the task.</p>
        pub fn cancel_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cancel_reason(input.into());
            self
        }
        /// <p>The reason for canceling the task.</p>
        pub fn set_cancel_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cancel_reason(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the import image or import snapshot task to be canceled.</p>
        pub fn import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_task_id(input.into());
            self
        }
        /// <p>The ID of the import image or import snapshot task to be canceled.</p>
        pub fn set_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_import_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelReservedInstancesListing`.
    ///
    /// <p>Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelReservedInstancesListing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_reserved_instances_listing_input::Builder,
    }
    impl<C, M, R> CancelReservedInstancesListing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelReservedInstancesListing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelReservedInstancesListingOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelReservedInstancesListingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelReservedInstancesListingInputOperationOutputAlias,
                crate::output::CancelReservedInstancesListingOutput,
                crate::error::CancelReservedInstancesListingError,
                crate::input::CancelReservedInstancesListingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Reserved Instance listing.</p>
        pub fn reserved_instances_listing_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_instances_listing_id(input.into());
            self
        }
        /// <p>The ID of the Reserved Instance listing.</p>
        pub fn set_reserved_instances_listing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instances_listing_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSpotFleetRequests`.
    ///
    /// <p>Cancels the specified Spot Fleet requests.</p>
    /// <p>After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you terminate them manually.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSpotFleetRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_spot_fleet_requests_input::Builder,
    }
    impl<C, M, R> CancelSpotFleetRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSpotFleetRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSpotFleetRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSpotFleetRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSpotFleetRequestsInputOperationOutputAlias,
                crate::output::CancelSpotFleetRequestsOutput,
                crate::error::CancelSpotFleetRequestsError,
                crate::input::CancelSpotFleetRequestsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `SpotFleetRequestIds`.
        ///
        /// To override the contents of this collection use [`set_spot_fleet_request_ids`](Self::set_spot_fleet_request_ids).
        ///
        /// <p>The IDs of the Spot Fleet requests.</p>
        pub fn spot_fleet_request_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spot_fleet_request_ids(input.into());
            self
        }
        /// <p>The IDs of the Spot Fleet requests.</p>
        pub fn set_spot_fleet_request_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_spot_fleet_request_ids(input);
            self
        }
        /// <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
        pub fn terminate_instances(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_instances(input);
            self
        }
        /// <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
        pub fn set_terminate_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_terminate_instances(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSpotInstanceRequests`.
    ///
    /// <p>Cancels one or more Spot Instance requests.</p> <important>
    /// <p>Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSpotInstanceRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_spot_instance_requests_input::Builder,
    }
    impl<C, M, R> CancelSpotInstanceRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSpotInstanceRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSpotInstanceRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSpotInstanceRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSpotInstanceRequestsInputOperationOutputAlias,
                crate::output::CancelSpotInstanceRequestsOutput,
                crate::error::CancelSpotInstanceRequestsError,
                crate::input::CancelSpotInstanceRequestsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `SpotInstanceRequestIds`.
        ///
        /// To override the contents of this collection use [`set_spot_instance_request_ids`](Self::set_spot_instance_request_ids).
        ///
        /// <p>One or more Spot Instance request IDs.</p>
        pub fn spot_instance_request_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.spot_instance_request_ids(input.into());
            self
        }
        /// <p>One or more Spot Instance request IDs.</p>
        pub fn set_spot_instance_request_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_spot_instance_request_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ConfirmProductInstance`.
    ///
    /// <p>Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ConfirmProductInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::confirm_product_instance_input::Builder,
    }
    impl<C, M, R> ConfirmProductInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ConfirmProductInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ConfirmProductInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ConfirmProductInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ConfirmProductInstanceInputOperationOutputAlias,
                crate::output::ConfirmProductInstanceOutput,
                crate::error::ConfirmProductInstanceError,
                crate::input::ConfirmProductInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The product code. This must be a product code that you own.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_code(input.into());
            self
        }
        /// <p>The product code. This must be a product code that you own.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_code(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyFpgaImage`.
    ///
    /// <p>Copies the specified Amazon FPGA Image (AFI) to the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyFpgaImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_fpga_image_input::Builder,
    }
    impl<C, M, R> CopyFpgaImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyFpgaImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyFpgaImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyFpgaImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyFpgaImageInputOperationOutputAlias,
                crate::output::CopyFpgaImageOutput,
                crate::error::CopyFpgaImageError,
                crate::input::CopyFpgaImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the source AFI.</p>
        pub fn source_fpga_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_fpga_image_id(input.into());
            self
        }
        /// <p>The ID of the source AFI.</p>
        pub fn set_source_fpga_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_fpga_image_id(input);
            self
        }
        /// <p>The description for the new AFI.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the new AFI.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name for the new AFI. The default is the name of the source AFI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the new AFI. The default is the name of the source AFI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Region that contains the source AFI.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The Region that contains the source AFI.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyImage`.
    ///
    /// <p>Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask</a>.</p>
    /// <p>To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code> during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.</p>
    /// <p>To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter, and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>For more information about the prerequisites and limits when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_image_input::Builder,
    }
    impl<C, M, R> CopyImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyImageInputOperationOutputAlias,
                crate::output::CopyImageOutput,
                crate::error::CopyImageError,
                crate::input::CopyImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A description for the new AMI in the destination Region.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the new AMI in the destination Region.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.encrypted(input);
            self
        }
        /// <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to <code>true</code>.</p>
        /// <p>You can specify a KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p>
        /// <p>The specified KMS key must exist in the destination Region.</p>
        /// <p>Amazon EBS does not support asymmetric KMS keys.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to <code>true</code>.</p>
        /// <p>You can specify a KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p>
        /// <p>The specified KMS key must exist in the destination Region.</p>
        /// <p>Amazon EBS does not support asymmetric KMS keys.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The name of the new AMI in the destination Region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new AMI in the destination Region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the AMI to copy.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_id(input.into());
            self
        }
        /// <p>The ID of the AMI to copy.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_id(input);
            self
        }
        /// <p>The name of the Region that contains the AMI to copy.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The name of the Region that contains the AMI to copy.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn destination_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_destination_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_outpost_arn(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopySnapshot`.
    ///
    /// <p>Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
    /// <p>You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).</p>
    /// <p>When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the snapshot.</p>
    /// <p>Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more information, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami"> Amazon EBS local snapshots on Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any purpose.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copy an Amazon EBS snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopySnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_snapshot_input::Builder,
    }
    impl<C, M, R> CopySnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopySnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopySnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopySnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopySnapshotInputOperationOutputAlias,
                crate::output::CopySnapshotOutput,
                crate::error::CopySnapshotError,
                crate::input::CopySnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the EBS snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the EBS snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copy snapshots from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn destination_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copy snapshots from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_destination_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_outpost_arn(input);
            self
        }
        /// <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p>
        /// <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the CLI, this is specified using the <code>--region</code> parameter or the default Region in your Amazon Web Services configuration file.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(input.into());
            self
        }
        /// <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p>
        /// <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the CLI, this is specified using the <code>--region</code> parameter or the default Region in your Amazon Web Services configuration file.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.encrypted(input);
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>
        /// <p>You can specify the KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>
        /// <p>You can specify the KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p>
        /// <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
        pub fn presigned_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.presigned_url(input.into());
            self
        }
        /// <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p>
        /// <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
        pub fn set_presigned_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_presigned_url(input);
            self
        }
        /// <p>The ID of the Region that contains the snapshot to be copied.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_region(input.into());
            self
        }
        /// <p>The ID of the Region that contains the snapshot to be copied.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
        /// <p>The ID of the EBS snapshot to copy.</p>
        pub fn source_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_id(input.into());
            self
        }
        /// <p>The ID of the EBS snapshot to copy.</p>
        pub fn set_source_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new snapshot.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the new snapshot.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCapacityReservation`.
    ///
    /// <p>Creates a new Capacity Reservation with the specified attributes.</p>
    /// <p>Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p>Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes.</p>
    /// <p>Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCapacityReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_capacity_reservation_input::Builder,
    }
    impl<C, M, R> CreateCapacityReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCapacityReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCapacityReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCapacityReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCapacityReservationInputOperationOutputAlias,
                crate::output::CreateCapacityReservationOutput,
                crate::error::CreateCapacityReservationError,
                crate::input::CreateCapacityReservationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The type of operating system for which to reserve capacity.</p>
        pub fn instance_platform(
            mut self,
            input: crate::model::CapacityReservationInstancePlatform,
        ) -> Self {
            self.inner = self.inner.instance_platform(input);
            self
        }
        /// <p>The type of operating system for which to reserve capacity.</p>
        pub fn set_instance_platform(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationInstancePlatform>,
        ) -> Self {
            self.inner = self.inner.set_instance_platform(input);
            self
        }
        /// <p>The Availability Zone in which to create the Capacity Reservation.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone in which to create the Capacity Reservation.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_id(input.into());
            self
        }
        /// <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_id(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn tenancy(mut self, input: crate::model::CapacityReservationTenancy) -> Self {
            self.inner = self.inner.tenancy(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_tenancy(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationTenancy>,
        ) -> Self {
            self.inner = self.inner.set_tenancy(input);
            self
        }
        /// <p>The number of instances for which to reserve capacity.</p>
        /// <p>Valid range: 1 - 1000</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_count(input);
            self
        }
        /// <p>The number of instances for which to reserve capacity.</p>
        /// <p>Valid range: 1 - 1000</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.inner = self.inner.ebs_optimized(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ebs_optimized(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
        pub fn ephemeral_storage(mut self, input: bool) -> Self {
            self.inner = self.inner.ephemeral_storage(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
        pub fn set_ephemeral_storage(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ephemeral_storage(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
        /// <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>
        /// <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
        /// <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>
        /// <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
        /// <ul>
        /// <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li>
        /// <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li>
        /// </ul>
        pub fn end_date_type(mut self, input: crate::model::EndDateType) -> Self {
            self.inner = self.inner.end_date_type(input);
            self
        }
        /// <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
        /// <ul>
        /// <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li>
        /// <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li>
        /// </ul>
        pub fn set_end_date_type(
            mut self,
            input: std::option::Option<crate::model::EndDateType>,
        ) -> Self {
            self.inner = self.inner.set_end_date_type(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li>
        /// <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li>
        /// </ul>
        /// <p>Default: <code>open</code> </p>
        pub fn instance_match_criteria(
            mut self,
            input: crate::model::InstanceMatchCriteria,
        ) -> Self {
            self.inner = self.inner.instance_match_criteria(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li>
        /// <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li>
        /// </ul>
        /// <p>Default: <code>open</code> </p>
        pub fn set_instance_match_criteria(
            mut self,
            input: std::option::Option<crate::model::InstanceMatchCriteria>,
        ) -> Self {
            self.inner = self.inner.set_instance_match_criteria(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Capacity Reservation during launch.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the Capacity Reservation during launch.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCapacityReservationFleet`.
    ///
    /// <p>Creates a Capacity Reservation Fleet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCapacityReservationFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_capacity_reservation_fleet_input::Builder,
    }
    impl<C, M, R> CreateCapacityReservationFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCapacityReservationFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCapacityReservationFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCapacityReservationFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCapacityReservationFleetInputOperationOutputAlias,
                crate::output::CreateCapacityReservationFleetOutput,
                crate::error::CreateCapacityReservationFleetError,
                crate::input::CreateCapacityReservationFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy"> Allocation strategy</a> in the Amazon EC2 User Guide.</p>
        /// <p>Valid values: <code>prioritized</code> </p>
        pub fn allocation_strategy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allocation_strategy(input.into());
            self
        }
        /// <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy"> Allocation strategy</a> in the Amazon EC2 User Guide.</p>
        /// <p>Valid values: <code>prioritized</code> </p>
        pub fn set_allocation_strategy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_allocation_strategy(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `InstanceTypeSpecifications`.
        ///
        /// To override the contents of this collection use [`set_instance_type_specifications`](Self::set_instance_type_specifications).
        ///
        /// <p>Information about the instance types for which to reserve the capacity.</p>
        pub fn instance_type_specifications(
            mut self,
            input: crate::model::ReservationFleetInstanceSpecification,
        ) -> Self {
            self.inner = self.inner.instance_type_specifications(input);
            self
        }
        /// <p>Information about the instance types for which to reserve the capacity.</p>
        pub fn set_instance_type_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservationFleetInstanceSpecification>,
            >,
        ) -> Self {
            self.inner = self.inner.set_instance_type_specifications(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn tenancy(mut self, input: crate::model::FleetCapacityReservationTenancy) -> Self {
            self.inner = self.inner.tenancy(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_tenancy(
            mut self,
            input: std::option::Option<crate::model::FleetCapacityReservationTenancy>,
        ) -> Self {
            self.inner = self.inner.set_tenancy(input);
            self
        }
        /// <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity"> Total target capacity</a> in the Amazon EC2 User Guide.</p>
        pub fn total_target_capacity(mut self, input: i32) -> Self {
            self.inner = self.inner.total_target_capacity(input);
            self
        }
        /// <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity"> Total target capacity</a> in the Amazon EC2 User Guide.</p>
        pub fn set_total_target_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_total_target_capacity(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.</p>
        /// <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>. </p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_date(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.</p>
        /// <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>. </p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_date(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
        /// <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
        pub fn instance_match_criteria(
            mut self,
            input: crate::model::FleetInstanceMatchCriteria,
        ) -> Self {
            self.inner = self.inner.instance_match_criteria(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
        /// <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
        pub fn set_instance_match_criteria(
            mut self,
            input: std::option::Option<crate::model::FleetInstanceMatchCriteria>,
        ) -> Self {
            self.inner = self.inner.set_instance_match_criteria(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCarrierGateway`.
    ///
    /// <p>Creates a carrier gateway. For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCarrierGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_carrier_gateway_input::Builder,
    }
    impl<C, M, R> CreateCarrierGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCarrierGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCarrierGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCarrierGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCarrierGatewayInputOperationOutputAlias,
                crate::output::CreateCarrierGatewayOutput,
                crate::error::CreateCarrierGatewayError,
                crate::input::CreateCarrierGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC to associate with the carrier gateway.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC to associate with the carrier gateway.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to associate with the carrier gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to associate with the carrier gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClientVpnEndpoint`.
    ///
    /// <p>Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClientVpnEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_client_vpn_endpoint_input::Builder,
    }
    impl<C, M, R> CreateClientVpnEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClientVpnEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClientVpnEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClientVpnEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClientVpnEndpointInputOperationOutputAlias,
                crate::output::CreateClientVpnEndpointOutput,
                crate::error::CreateClientVpnEndpointError,
                crate::input::CreateClientVpnEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
        pub fn client_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_cidr_block(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
        pub fn set_client_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_cidr_block(input);
            self
        }
        /// <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>
        pub fn server_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_arn(input.into());
            self
        }
        /// <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>
        pub fn set_server_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_arn(input);
            self
        }
        /// Appends an item to `AuthenticationOptions`.
        ///
        /// To override the contents of this collection use [`set_authentication_options`](Self::set_authentication_options).
        ///
        /// <p>Information about the authentication method to be used to authenticate clients.</p>
        pub fn authentication_options(
            mut self,
            input: crate::model::ClientVpnAuthenticationRequest,
        ) -> Self {
            self.inner = self.inner.authentication_options(input);
            self
        }
        /// <p>Information about the authentication method to be used to authenticate clients.</p>
        pub fn set_authentication_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClientVpnAuthenticationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_authentication_options(input);
            self
        }
        /// <p>Information about the client connection logging options.</p>
        /// <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p>
        /// <ul>
        /// <li> <p>Client connection requests</p> </li>
        /// <li> <p>Client connection results (successful and unsuccessful)</p> </li>
        /// <li> <p>Reasons for unsuccessful client connection requests</p> </li>
        /// <li> <p>Client connection termination time</p> </li>
        /// </ul>
        pub fn connection_log_options(mut self, input: crate::model::ConnectionLogOptions) -> Self {
            self.inner = self.inner.connection_log_options(input);
            self
        }
        /// <p>Information about the client connection logging options.</p>
        /// <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p>
        /// <ul>
        /// <li> <p>Client connection requests</p> </li>
        /// <li> <p>Client connection results (successful and unsuccessful)</p> </li>
        /// <li> <p>Reasons for unsuccessful client connection requests</p> </li>
        /// <li> <p>Client connection termination time</p> </li>
        /// </ul>
        pub fn set_connection_log_options(
            mut self,
            input: std::option::Option<crate::model::ConnectionLogOptions>,
        ) -> Self {
            self.inner = self.inner.set_connection_log_options(input);
            self
        }
        /// Appends an item to `DnsServers`.
        ///
        /// To override the contents of this collection use [`set_dns_servers`](Self::set_dns_servers).
        ///
        /// <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
        pub fn dns_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_servers(input.into());
            self
        }
        /// <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
        pub fn set_dns_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dns_servers(input);
            self
        }
        /// <p>The transport protocol to be used by the VPN session.</p>
        /// <p>Default value: <code>udp</code> </p>
        pub fn transport_protocol(mut self, input: crate::model::TransportProtocol) -> Self {
            self.inner = self.inner.transport_protocol(input);
            self
        }
        /// <p>The transport protocol to be used by the VPN session.</p>
        /// <p>Default value: <code>udp</code> </p>
        pub fn set_transport_protocol(
            mut self,
            input: std::option::Option<crate::model::TransportProtocol>,
        ) -> Self {
            self.inner = self.inner.set_transport_protocol(input);
            self
        }
        /// <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
        /// <p>Valid Values: <code>443</code> | <code>1194</code> </p>
        /// <p>Default Value: <code>443</code> </p>
        pub fn vpn_port(mut self, input: i32) -> Self {
            self.inner = self.inner.vpn_port(input);
            self
        }
        /// <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
        /// <p>Valid Values: <code>443</code> | <code>1194</code> </p>
        /// <p>Default Value: <code>443</code> </p>
        pub fn set_vpn_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_vpn_port(input);
            self
        }
        /// <p>A brief description of the Client VPN endpoint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A brief description of the Client VPN endpoint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
        /// <p>By default, split-tunnel on a VPN endpoint is disabled.</p>
        /// <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>
        pub fn split_tunnel(mut self, input: bool) -> Self {
            self.inner = self.inner.split_tunnel(input);
            self
        }
        /// <p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
        /// <p>By default, split-tunnel on a VPN endpoint is disabled.</p>
        /// <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>
        pub fn set_split_tunnel(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_split_tunnel(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Client VPN endpoint during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the Client VPN endpoint during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
        /// <p>Default Value: <code>enabled</code> </p>
        pub fn self_service_portal(mut self, input: crate::model::SelfServicePortal) -> Self {
            self.inner = self.inner.self_service_portal(input);
            self
        }
        /// <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
        /// <p>Default Value: <code>enabled</code> </p>
        pub fn set_self_service_portal(
            mut self,
            input: std::option::Option<crate::model::SelfServicePortal>,
        ) -> Self {
            self.inner = self.inner.set_self_service_portal(input);
            self
        }
        /// <p>The options for managing connection authorization for new client connections.</p>
        pub fn client_connect_options(mut self, input: crate::model::ClientConnectOptions) -> Self {
            self.inner = self.inner.client_connect_options(input);
            self
        }
        /// <p>The options for managing connection authorization for new client connections.</p>
        pub fn set_client_connect_options(
            mut self,
            input: std::option::Option<crate::model::ClientConnectOptions>,
        ) -> Self {
            self.inner = self.inner.set_client_connect_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClientVpnRoute`.
    ///
    /// <p>Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClientVpnRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_client_vpn_route_input::Builder,
    }
    impl<C, M, R> CreateClientVpnRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClientVpnRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClientVpnRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClientVpnRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClientVpnRouteInputOperationOutputAlias,
                crate::output::CreateClientVpnRouteOutput,
                crate::error::CreateClientVpnRouteError,
                crate::input::CreateClientVpnRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Client VPN endpoint to which to add the route.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_vpn_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint to which to add the route.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_vpn_endpoint_id(input);
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
        /// <ul>
        /// <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li>
        /// <li> <p>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for the local network, enter the client CIDR range</p> </li>
        /// </ul>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_cidr_block(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
        /// <ul>
        /// <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li>
        /// <li> <p>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for the local network, enter the client CIDR range</p> </li>
        /// </ul>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_cidr_block(input);
            self
        }
        /// <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p>
        /// <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
        pub fn target_vpc_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_vpc_subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p>
        /// <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
        pub fn set_target_vpc_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_vpc_subnet_id(input);
            self
        }
        /// <p>A brief description of the route.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A brief description of the route.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomerGateway`.
    ///
    /// <p>Provides information to Amazon Web Services about your VPN customer gateway device. The customer gateway is the appliance at your end of the VPN connection. (The device on the Amazon Web Services side of the VPN connection is the virtual private gateway.) You must provide the internet-routable IP address of the customer gateway's external interface. The IP address must be static and can be behind a device performing network address translation (NAT).</p>
    /// <p>For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use a private ASN (in the 64512 - 65534 range).</p> <note>
    /// <p>Amazon EC2 supports all 4-byte ASN numbers in the range of 1 - 2147483647, with the exception of the following:</p>
    /// <ul>
    /// <li> <p>7224 - reserved in the <code>us-east-1</code> Region</p> </li>
    /// <li> <p>9059 - reserved in the <code>eu-west-1</code> Region</p> </li>
    /// <li> <p>17943 - reserved in the <code>ap-southeast-1</code> Region</p> </li>
    /// <li> <p>10124 - reserved in the <code>ap-northeast-1</code> Region</p> </li>
    /// </ul>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.</p> <important>
    /// <p>To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. Identical requests return information about the existing customer gateway and do not create new customer gateways.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomerGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_customer_gateway_input::Builder,
    }
    impl<C, M, R> CreateCustomerGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomerGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomerGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomerGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomerGatewayInputOperationOutputAlias,
                crate::output::CreateCustomerGatewayOutput,
                crate::error::CreateCustomerGatewayError,
                crate::input::CreateCustomerGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>For devices that support BGP, the customer gateway's BGP ASN.</p>
        /// <p>Default: 65000</p>
        pub fn bgp_asn(mut self, input: i32) -> Self {
            self.inner = self.inner.bgp_asn(input);
            self
        }
        /// <p>For devices that support BGP, the customer gateway's BGP ASN.</p>
        /// <p>Default: 65000</p>
        pub fn set_bgp_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_bgp_asn(input);
            self
        }
        /// <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_ip(input.into());
            self
        }
        /// <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_public_ip(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
        pub fn r#type(mut self, input: crate::model::GatewayType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::GatewayType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the customer gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the customer gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>A name for the customer gateway device.</p>
        /// <p>Length Constraints: Up to 255 characters.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(input.into());
            self
        }
        /// <p>A name for the customer gateway device.</p>
        /// <p>Length Constraints: Up to 255 characters.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDefaultSubnet`.
    ///
    /// <p>Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a default subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDefaultSubnet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_default_subnet_input::Builder,
    }
    impl<C, M, R> CreateDefaultSubnet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDefaultSubnet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDefaultSubnetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDefaultSubnetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDefaultSubnetInputOperationOutputAlias,
                crate::output::CreateDefaultSubnetOutput,
                crate::error::CreateDefaultSubnetError,
                crate::input::CreateDefaultSubnetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Availability Zone in which to create the default subnet.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone in which to create the default subnet.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>
        pub fn ipv6_native(mut self, input: bool) -> Self {
            self.inner = self.inner.ipv6_native(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>
        pub fn set_ipv6_native(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ipv6_native(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDefaultVpc`.
    ///
    /// <p>Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and default subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC yourself.</p>
    /// <p>If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC per Region.</p>
    /// <p>If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDefaultVpc<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_default_vpc_input::Builder,
    }
    impl<C, M, R> CreateDefaultVpc<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDefaultVpc`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDefaultVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDefaultVpcError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDefaultVpcInputOperationOutputAlias,
                crate::output::CreateDefaultVpcOutput,
                crate::error::CreateDefaultVpcError,
                crate::input::CreateDefaultVpcInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDhcpOptions`.
    ///
    /// <p>Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p>
    /// <ul>
    /// <li> <p> <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.</p> </li>
    /// <li> <p> <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify <code>ec2.internal</code>. If you're using AmazonProvidedDNS in another Region, specify <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise, specify a domain name (for example, <code>ExampleCompany.com</code>). This value is used to complete unqualified DNS hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.</p> </li>
    /// <li> <p> <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.</p> </li>
    /// <li> <p> <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.</p> </li>
    /// <li> <p> <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> </li>
    /// </ul>
    /// <p>Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server of your choice. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDhcpOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dhcp_options_input::Builder,
    }
    impl<C, M, R> CreateDhcpOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDhcpOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDhcpOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDhcpOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDhcpOptionsInputOperationOutputAlias,
                crate::output::CreateDhcpOptionsOutput,
                crate::error::CreateDhcpOptionsError,
                crate::input::CreateDhcpOptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DhcpConfigurations`.
        ///
        /// To override the contents of this collection use [`set_dhcp_configurations`](Self::set_dhcp_configurations).
        ///
        /// <p>A DHCP configuration option.</p>
        pub fn dhcp_configurations(mut self, input: crate::model::NewDhcpConfiguration) -> Self {
            self.inner = self.inner.dhcp_configurations(input);
            self
        }
        /// <p>A DHCP configuration option.</p>
        pub fn set_dhcp_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewDhcpConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_dhcp_configurations(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the DHCP option.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the DHCP option.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEgressOnlyInternetGateway`.
    ///
    /// <p>[IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEgressOnlyInternetGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_egress_only_internet_gateway_input::Builder,
    }
    impl<C, M, R> CreateEgressOnlyInternetGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEgressOnlyInternetGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEgressOnlyInternetGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEgressOnlyInternetGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEgressOnlyInternetGatewayInputOperationOutputAlias,
                crate::output::CreateEgressOnlyInternetGatewayOutput,
                crate::error::CreateEgressOnlyInternetGatewayError,
                crate::input::CreateEgressOnlyInternetGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the egress-only internet gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the egress-only internet gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Launches an EC2 Fleet.</p>
    /// <p>You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl<C, M, R> CreateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetInputOperationOutputAlias,
                crate::output::CreateFleetOutput,
                crate::error::CreateFleetError,
                crate::input::CreateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
        pub fn spot_options(mut self, input: crate::model::SpotOptionsRequest) -> Self {
            self.inner = self.inner.spot_options(input);
            self
        }
        /// <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
        pub fn set_spot_options(
            mut self,
            input: std::option::Option<crate::model::SpotOptionsRequest>,
        ) -> Self {
            self.inner = self.inner.set_spot_options(input);
            self
        }
        /// <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
        pub fn on_demand_options(mut self, input: crate::model::OnDemandOptionsRequest) -> Self {
            self.inner = self.inner.on_demand_options(input);
            self
        }
        /// <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
        pub fn set_on_demand_options(
            mut self,
            input: std::option::Option<crate::model::OnDemandOptionsRequest>,
        ) -> Self {
            self.inner = self.inner.set_on_demand_options(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
        pub fn excess_capacity_termination_policy(
            mut self,
            input: crate::model::FleetExcessCapacityTerminationPolicy,
        ) -> Self {
            self.inner = self.inner.excess_capacity_termination_policy(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
        pub fn set_excess_capacity_termination_policy(
            mut self,
            input: std::option::Option<crate::model::FleetExcessCapacityTerminationPolicy>,
        ) -> Self {
            self.inner = self.inner.set_excess_capacity_termination_policy(input);
            self
        }
        /// Appends an item to `LaunchTemplateConfigs`.
        ///
        /// To override the contents of this collection use [`set_launch_template_configs`](Self::set_launch_template_configs).
        ///
        /// <p>The configuration for the EC2 Fleet.</p>
        pub fn launch_template_configs(
            mut self,
            input: crate::model::FleetLaunchTemplateConfigRequest,
        ) -> Self {
            self.inner = self.inner.launch_template_configs(input);
            self
        }
        /// <p>The configuration for the EC2 Fleet.</p>
        pub fn set_launch_template_configs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FleetLaunchTemplateConfigRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_launch_template_configs(input);
            self
        }
        /// <p>The number of units to request.</p>
        pub fn target_capacity_specification(
            mut self,
            input: crate::model::TargetCapacitySpecificationRequest,
        ) -> Self {
            self.inner = self.inner.target_capacity_specification(input);
            self
        }
        /// <p>The number of units to request.</p>
        pub fn set_target_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::TargetCapacitySpecificationRequest>,
        ) -> Self {
            self.inner = self.inner.set_target_capacity_specification(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
        pub fn terminate_instances_with_expiration(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_instances_with_expiration(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
        pub fn set_terminate_instances_with_expiration(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_terminate_instances_with_expiration(input);
            self
        }
        /// <p>The fleet type. The default value is <code>maintain</code>.</p>
        /// <ul>
        /// <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li>
        /// <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li>
        /// <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::FleetType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The fleet type. The default value is <code>maintain</code>.</p>
        /// <ul>
        /// <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li>
        /// <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li>
        /// <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FleetType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
        pub fn valid_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.valid_from(input);
            self
        }
        /// <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
        pub fn set_valid_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_valid_from(input);
            self
        }
        /// <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
        pub fn valid_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.valid_until(input);
            self
        }
        /// <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_valid_until(input);
            self
        }
        /// <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn replace_unhealthy_instances(mut self, input: bool) -> Self {
            self.inner = self.inner.replace_unhealthy_instances(input);
            self
        }
        /// <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_replace_unhealthy_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace_unhealthy_instances(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>
        /// <p>If the fleet type is <code>instant</code>, specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.</p>
        /// <p>If the fleet type is <code>maintain</code> or <code>request</code>, specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code>. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>
        /// <p>If the fleet type is <code>instant</code>, specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.</p>
        /// <p>If the fleet type is <code>maintain</code> or <code>request</code>, specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code>. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlowLogs`.
    ///
    /// <p>Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC. </p>
    /// <p>Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    /// <p>When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlowLogs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_flow_logs_input::Builder,
    }
    impl<C, M, R> CreateFlowLogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFlowLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowLogsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFlowLogsInputOperationOutputAlias,
                crate::output::CreateFlowLogsOutput,
                crate::error::CreateFlowLogsError,
                crate::input::CreateFlowLogsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn deliver_logs_permission_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.deliver_logs_permission_arn(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn set_deliver_logs_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deliver_logs_permission_arn(input);
            self
        }
        /// <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p>
        /// <p>Constraints: Maximum of 1000 resources</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p>
        /// <p>Constraints: Maximum of 1000 resources</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
        /// <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
        pub fn resource_type(mut self, input: crate::model::FlowLogsResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::FlowLogsResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
        pub fn traffic_type(mut self, input: crate::model::TrafficType) -> Self {
            self.inner = self.inner.traffic_type(input);
            self
        }
        /// <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
        pub fn set_traffic_type(
            mut self,
            input: std::option::Option<crate::model::TrafficType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_type(input);
            self
        }
        /// <p>The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        /// <p>Default: <code>cloud-watch-logs</code> </p>
        pub fn log_destination_type(mut self, input: crate::model::LogDestinationType) -> Self {
            self.inner = self.inner.log_destination_type(input);
            self
        }
        /// <p>The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        /// <p>Default: <code>cloud-watch-logs</code> </p>
        pub fn set_log_destination_type(
            mut self,
            input: std::option::Option<crate::model::LogDestinationType>,
        ) -> Self {
            self.inner = self.inner.set_log_destination_type(input);
            self
        }
        /// <p>The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p>
        /// <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p>
        /// <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
        pub fn log_destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_destination(input.into());
            self
        }
        /// <p>The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p>
        /// <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p>
        /// <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
        pub fn set_log_destination(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_destination(input);
            self
        }
        /// <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p>
        /// <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.</p>
        pub fn log_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_format(input.into());
            self
        }
        /// <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p>
        /// <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.</p>
        pub fn set_log_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_format(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the flow logs.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the flow logs.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p>
        /// <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p>
        /// <p>Default: 600</p>
        pub fn max_aggregation_interval(mut self, input: i32) -> Self {
            self.inner = self.inner.max_aggregation_interval(input);
            self
        }
        /// <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p>
        /// <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p>
        /// <p>Default: 600</p>
        pub fn set_max_aggregation_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_aggregation_interval(input);
            self
        }
        /// <p>The destination options.</p>
        pub fn destination_options(
            mut self,
            input: crate::model::DestinationOptionsRequest,
        ) -> Self {
            self.inner = self.inner.destination_options(input);
            self
        }
        /// <p>The destination options.</p>
        pub fn set_destination_options(
            mut self,
            input: std::option::Option<crate::model::DestinationOptionsRequest>,
        ) -> Self {
            self.inner = self.inner.set_destination_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFpgaImage`.
    ///
    /// <p>Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).</p>
    /// <p>The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.</p>
    /// <p>An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the <a href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFpgaImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fpga_image_input::Builder,
    }
    impl<C, M, R> CreateFpgaImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFpgaImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFpgaImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFpgaImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFpgaImageInputOperationOutputAlias,
                crate::output::CreateFpgaImageOutput,
                crate::error::CreateFpgaImageError,
                crate::input::CreateFpgaImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
        pub fn input_storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.inner = self.inner.input_storage_location(input);
            self
        }
        /// <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
        pub fn set_input_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.inner = self.inner.set_input_storage_location(input);
            self
        }
        /// <p>The location in Amazon S3 for the output logs.</p>
        pub fn logs_storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.inner = self.inner.logs_storage_location(input);
            self
        }
        /// <p>The location in Amazon S3 for the output logs.</p>
        pub fn set_logs_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.inner = self.inner.set_logs_storage_location(input);
            self
        }
        /// <p>A description for the AFI.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the AFI.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A name for the AFI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the AFI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the FPGA image during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the FPGA image during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImage`.
    ///
    /// <p>Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.</p>
    /// <p>If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_input::Builder,
    }
    impl<C, M, R> CreateImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageInputOperationOutputAlias,
                crate::output::CreateImageOutput,
                crate::error::CreateImageError,
                crate::input::CreateImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `BlockDeviceMappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <code>CopyImage</code> action.</p>
        pub fn block_device_mappings(mut self, input: crate::model::BlockDeviceMapping) -> Self {
            self.inner = self.inner.block_device_mappings(input);
            self
        }
        /// <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <code>CopyImage</code> action.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.inner = self.inner.set_block_device_mappings(input);
            self
        }
        /// <p>A description for the new image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the new image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A name for the new image.</p>
        /// <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the new image.</p>
        /// <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the <code>No Reboot</code> option is set, Amazon EC2 doesn't shut down the instance before creating the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted at the same time), but not application consistent (all the operating system buffers are not flushed to disk before the snapshots are created).</p>
        pub fn no_reboot(mut self, input: bool) -> Self {
            self.inner = self.inner.no_reboot(input);
            self
        }
        /// <p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the <code>No Reboot</code> option is set, Amazon EC2 doesn't shut down the instance before creating the image. Without a reboot, the AMI will be crash consistent (all the volumes are snapshotted at the same time), but not application consistent (all the operating system buffers are not flushed to disk before the snapshots are created).</p>
        pub fn set_no_reboot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_no_reboot(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        /// <p>If you specify other values for <code>ResourceType</code>, the request fails.</p>
        /// <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        /// <p>If you specify other values for <code>ResourceType</code>, the request fails.</p>
        /// <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceEventWindow`.
    ///
    /// <p>Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.</p>
    /// <p>You can define either a set of time ranges or a cron expression when creating the event window, but not both. All event window times are in UTC.</p>
    /// <p>You can create up to 200 event windows per Amazon Web Services Region.</p>
    /// <p>When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that the event window can be used, you must associate one or more targets with it by using the <code>AssociateInstanceEventWindow</code> API.</p> <important>
    /// <p>Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.</p>
    /// <p>Event windows are <i>not</i> applicable for:</p>
    /// <ul>
    /// <li> <p>Expedited scheduled events and network maintenance events. </p> </li>
    /// <li> <p>Unscheduled maintenance such as AutoRecovery and unplanned reboots.</p> </li>
    /// </ul>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInstanceEventWindow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_event_window_input::Builder,
    }
    impl<C, M, R> CreateInstanceEventWindow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceEventWindow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceEventWindowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceEventWindowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceEventWindowInputOperationOutputAlias,
                crate::output::CreateInstanceEventWindowOutput,
                crate::error::CreateInstanceEventWindowError,
                crate::input::CreateInstanceEventWindowInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The name of the event window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `TimeRanges`.
        ///
        /// To override the contents of this collection use [`set_time_ranges`](Self::set_time_ranges).
        ///
        /// <p>The time range for the event window. If you specify a time range, you can't specify a cron expression.</p>
        pub fn time_ranges(
            mut self,
            input: crate::model::InstanceEventWindowTimeRangeRequest,
        ) -> Self {
            self.inner = self.inner.time_ranges(input);
            self
        }
        /// <p>The time range for the event window. If you specify a time range, you can't specify a cron expression.</p>
        pub fn set_time_ranges(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceEventWindowTimeRangeRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_time_ranges(input);
            self
        }
        /// <p>The cron expression for the event window, for example, <code>* 0-4,20-23 * * 1,5</code>. If you specify a cron expression, you can't specify a time range.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Only hour and day of the week values are supported.</p> </li>
        /// <li> <p>For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative single values <code>SUN</code> through <code>SAT</code>.</p> </li>
        /// <li> <p>The minute, month, and year must be specified by <code>*</code>.</p> </li>
        /// <li> <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.</p> </li>
        /// <li> <p>Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.</p> </li>
        /// <li> <p>The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.</p> </li>
        /// </ul>
        /// <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia website</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cron_expression(input.into());
            self
        }
        /// <p>The cron expression for the event window, for example, <code>* 0-4,20-23 * * 1,5</code>. If you specify a cron expression, you can't specify a time range.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Only hour and day of the week values are supported.</p> </li>
        /// <li> <p>For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative single values <code>SUN</code> through <code>SAT</code>.</p> </li>
        /// <li> <p>The minute, month, and year must be specified by <code>*</code>.</p> </li>
        /// <li> <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.</p> </li>
        /// <li> <p>Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.</p> </li>
        /// <li> <p>The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.</p> </li>
        /// </ul>
        /// <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia website</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cron_expression(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the event window.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the event window.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceExportTask`.
    ///
    /// <p>Exports a running or stopped instance to an Amazon S3 bucket.</p>
    /// <p>For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInstanceExportTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_export_task_input::Builder,
    }
    impl<C, M, R> CreateInstanceExportTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceExportTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceExportTaskInputOperationOutputAlias,
                crate::output::CreateInstanceExportTaskOutput,
                crate::error::CreateInstanceExportTaskError,
                crate::input::CreateInstanceExportTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The format and location for an export instance task.</p>
        pub fn export_to_s3_task(
            mut self,
            input: crate::model::ExportToS3TaskSpecification,
        ) -> Self {
            self.inner = self.inner.export_to_s3_task(input);
            self
        }
        /// <p>The format and location for an export instance task.</p>
        pub fn set_export_to_s3_task(
            mut self,
            input: std::option::Option<crate::model::ExportToS3TaskSpecification>,
        ) -> Self {
            self.inner = self.inner.set_export_to_s3_task(input);
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The target virtualization environment.</p>
        pub fn target_environment(mut self, input: crate::model::ExportEnvironment) -> Self {
            self.inner = self.inner.target_environment(input);
            self
        }
        /// <p>The target virtualization environment.</p>
        pub fn set_target_environment(
            mut self,
            input: std::option::Option<crate::model::ExportEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_target_environment(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the export instance task during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the export instance task during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInternetGateway`.
    ///
    /// <p>Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using <code>AttachInternetGateway</code>.</p>
    /// <p>For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInternetGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_internet_gateway_input::Builder,
    }
    impl<C, M, R> CreateInternetGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInternetGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInternetGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInternetGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInternetGatewayInputOperationOutputAlias,
                crate::output::CreateInternetGatewayOutput,
                crate::error::CreateInternetGatewayError,
                crate::input::CreateInternetGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the internet gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the internet gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIpam`.
    ///
    /// <p>Create an IPAM. Amazon VCP IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.</p>
    /// <p>For more information, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIpam<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ipam_input::Builder,
    }
    impl<C, M, R> CreateIpam<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIpam`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIpamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpamInputOperationOutputAlias,
                crate::output::CreateIpamOutput,
                crate::error::CreateIpamError,
                crate::input::CreateIpamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>A description for the IPAM.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the IPAM.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `OperatingRegions`.
        ///
        /// To override the contents of this collection use [`set_operating_regions`](Self::set_operating_regions).
        ///
        /// <p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
        /// <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn operating_regions(mut self, input: crate::model::AddIpamOperatingRegion) -> Self {
            self.inner = self.inner.operating_regions(input);
            self
        }
        /// <p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
        /// <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_operating_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddIpamOperatingRegion>>,
        ) -> Self {
            self.inner = self.inner.set_operating_regions(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIpamPool`.
    ///
    /// <p>Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.</p>
    /// <p>For more information, see <a href="/vpc/latest/ipam/create-top-ipam.html">Create a top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIpamPool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ipam_pool_input::Builder,
    }
    impl<C, M, R> CreateIpamPool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIpamPool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpamPoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIpamPoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpamPoolInputOperationOutputAlias,
                crate::output::CreateIpamPoolOutput,
                crate::error::CreateIpamPoolError,
                crate::input::CreateIpamPoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the scope in which you would like to create the IPAM pool.</p>
        pub fn ipam_scope_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipam_scope_id(input.into());
            self
        }
        /// <p>The ID of the scope in which you would like to create the IPAM pool.</p>
        pub fn set_ipam_scope_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipam_scope_id(input);
            self
        }
        /// <p>In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.</p>
        /// <p>Possible values: Any Amazon Web Services Region, such as us-east-1.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.</p>
        /// <p>Possible values: Any Amazon Web Services Region, such as us-east-1.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.</p>
        pub fn source_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ipam_pool_id(input.into());
            self
        }
        /// <p>The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.</p>
        pub fn set_source_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_ipam_pool_id(input);
            self
        }
        /// <p>A description for the IPAM pool.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the IPAM pool.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.inner = self.inner.address_family(input);
            self
        }
        /// <p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.inner = self.inner.set_address_family(input);
            self
        }
        /// <p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p>
        /// <p>A locale must be set on the pool for this feature to work.</p>
        pub fn auto_import(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_import(input);
            self
        }
        /// <p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p>
        /// <p>A locale must be set on the pool for this feature to work.</p>
        pub fn set_auto_import(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_import(input);
            self
        }
        /// <p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>
        pub fn publicly_advertisable(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_advertisable(input);
            self
        }
        /// <p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>
        pub fn set_publicly_advertisable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_advertisable(input);
            self
        }
        /// <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn allocation_min_netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.allocation_min_netmask_length(input);
            self
        }
        /// <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_allocation_min_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_allocation_min_netmask_length(input);
            self
        }
        /// <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn allocation_max_netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.allocation_max_netmask_length(input);
            self
        }
        /// <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_allocation_max_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_allocation_max_netmask_length(input);
            self
        }
        /// <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
        pub fn allocation_default_netmask_length(mut self, input: i32) -> Self {
            self.inner = self.inner.allocation_default_netmask_length(input);
            self
        }
        /// <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
        pub fn set_allocation_default_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_allocation_default_netmask_length(input);
            self
        }
        /// Appends an item to `AllocationResourceTags`.
        ///
        /// To override the contents of this collection use [`set_allocation_resource_tags`](Self::set_allocation_resource_tags).
        ///
        /// <p>Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.</p>
        pub fn allocation_resource_tags(
            mut self,
            input: crate::model::RequestIpamResourceTag,
        ) -> Self {
            self.inner = self.inner.allocation_resource_tags(input);
            self
        }
        /// <p>Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.</p>
        pub fn set_allocation_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RequestIpamResourceTag>>,
        ) -> Self {
            self.inner = self.inner.set_allocation_resource_tags(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.</p>
        pub fn aws_service(mut self, input: crate::model::IpamPoolAwsService) -> Self {
            self.inner = self.inner.aws_service(input);
            self
        }
        /// <p>Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.</p>
        pub fn set_aws_service(
            mut self,
            input: std::option::Option<crate::model::IpamPoolAwsService>,
        ) -> Self {
            self.inner = self.inner.set_aws_service(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIpamScope`.
    ///
    /// <p>Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.</p>
    /// <p>For more information, see <a href="/vpc/latest/ipam/add-scope-ipam.html">Add a scope</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIpamScope<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ipam_scope_input::Builder,
    }
    impl<C, M, R> CreateIpamScope<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIpamScope`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpamScopeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIpamScopeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpamScopeInputOperationOutputAlias,
                crate::output::CreateIpamScopeOutput,
                crate::error::CreateIpamScopeError,
                crate::input::CreateIpamScopeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the IPAM for which you're creating this scope.</p>
        pub fn ipam_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipam_id(input.into());
            self
        }
        /// <p>The ID of the IPAM for which you're creating this scope.</p>
        pub fn set_ipam_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ipam_id(input);
            self
        }
        /// <p>A description for the scope you're creating.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the scope you're creating.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeyPair`.
    ///
    /// <p>Creates an ED25519 or 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name already exists, Amazon EC2 returns an error.</p>
    /// <p>The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using <code>ImportKeyPair</code>.</p>
    /// <p>You can have up to 5,000 key pairs per Amazon Web Services Region.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_key_pair_input::Builder,
    }
    impl<C, M, R> CreateKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeyPairInputOperationOutputAlias,
                crate::output::CreateKeyPairOutput,
                crate::error::CreateKeyPairError,
                crate::input::CreateKeyPairInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the key pair.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(input.into());
            self
        }
        /// <p>A unique name for the key pair.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The type of key pair. Note that ED25519 keys are not supported for Windows instances, EC2 Instance Connect, and EC2 Serial Console.</p>
        /// <p>Default: <code>rsa</code> </p>
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.inner = self.inner.key_type(input);
            self
        }
        /// <p>The type of key pair. Note that ED25519 keys are not supported for Windows instances, EC2 Instance Connect, and EC2 Serial Console.</p>
        /// <p>Default: <code>rsa</code> </p>
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.inner = self.inner.set_key_type(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new key pair.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the new key pair.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunchTemplate`.
    ///
    /// <p>Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an instance using <code>RunInstances</code>, you can specify a launch template instead of providing the launch parameters in the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLaunchTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_launch_template_input::Builder,
    }
    impl<C, M, R> CreateLaunchTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLaunchTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLaunchTemplateInputOperationOutputAlias,
                crate::output::CreateLaunchTemplateOutput,
                crate::error::CreateLaunchTemplateError,
                crate::input::CreateLaunchTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A name for the launch template.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_template_name(input.into());
            self
        }
        /// <p>A name for the launch template.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_template_name(input);
            self
        }
        /// <p>A description for the first version of the launch template.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description for the first version of the launch template.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn launch_template_data(
            mut self,
            input: crate::model::RequestLaunchTemplateData,
        ) -> Self {
            self.inner = self.inner.launch_template_data(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn set_launch_template_data(
            mut self,
            input: std::option::Option<crate::model::RequestLaunchTemplateData>,
        ) -> Self {
            self.inner = self.inner.set_launch_template_data(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the launch template during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the launch template during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLaunchTemplateVersion`.
    ///
    /// <p>Creates a new version for a launch template. You can specify an existing version of launch template from which to base the new version.</p>
    /// <p>Launch template versions are numbered in the order in which they are created. You cannot specify, change, or replace the numbering of launch template versions.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Managing launch template versions</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLaunchTemplateVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_launch_template_version_input::Builder,
    }
    impl<C, M, R> CreateLaunchTemplateVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLaunchTemplateVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLaunchTemplateVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLaunchTemplateVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLaunchTemplateVersionInputOperationOutputAlias,
                crate::output::CreateLaunchTemplateVersionOutput,
                crate::error::CreateLaunchTemplateVersionError,
                crate::input::CreateLaunchTemplateVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_template_id(input.into());
            self
        }
        /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_template_id(input);
            self
        }
        /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_template_name(input.into());
            self
        }
        /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_template_name(input);
            self
        }
        /// <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// <p>A description for the version of the launch template.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_description(input.into());
            self
        }
        /// <p>A description for the version of the launch template.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_description(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn launch_template_data(
            mut self,
            input: crate::model::RequestLaunchTemplateData,
        ) -> Self {
            self.inner = self.inner.launch_template_data(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn set_launch_template_data(
            mut self,
            input: std::option::Option<crate::model::RequestLaunchTemplateData>,
        ) -> Self {
            self.inner = self.inner.set_launch_template_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocalGatewayRoute`.
    ///
    /// <p>Creates a static route for the specified local gateway route table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocalGatewayRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_local_gateway_route_input::Builder,
    }
    impl<C, M, R> CreateLocalGatewayRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocalGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocalGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLocalGatewayRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocalGatewayRouteInputOperationOutputAlias,
                crate::output::CreateLocalGatewayRouteOutput,
                crate::error::CreateLocalGatewayRouteError,
                crate::input::CreateLocalGatewayRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_cidr_block(input.into());
            self
        }
        /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_cidr_block(input);
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn local_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.local_gateway_route_table_id(input.into());
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_local_gateway_route_table_id(input);
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn local_gateway_virtual_interface_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .local_gateway_virtual_interface_group_id(input.into());
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn set_local_gateway_virtual_interface_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_local_gateway_virtual_interface_group_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLocalGatewayRouteTableVpcAssociation`.
    ///
    /// <p>Associates the specified VPC with the specified local gateway route table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLocalGatewayRouteTableVpcAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_local_gateway_route_table_vpc_association_input::Builder,
    }
    impl<C, M, R> CreateLocalGatewayRouteTableVpcAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLocalGatewayRouteTableVpcAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLocalGatewayRouteTableVpcAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateLocalGatewayRouteTableVpcAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLocalGatewayRouteTableVpcAssociationInputOperationOutputAlias,
                crate::output::CreateLocalGatewayRouteTableVpcAssociationOutput,
                crate::error::CreateLocalGatewayRouteTableVpcAssociationError,
                crate::input::CreateLocalGatewayRouteTableVpcAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn local_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.local_gateway_route_table_id(input.into());
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_local_gateway_route_table_id(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the local gateway route table VPC association.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the local gateway route table VPC association.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateManagedPrefixList`.
    ///
    /// <p>Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateManagedPrefixList<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_managed_prefix_list_input::Builder,
    }
    impl<C, M, R> CreateManagedPrefixList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateManagedPrefixList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateManagedPrefixListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateManagedPrefixListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateManagedPrefixListInputOperationOutputAlias,
                crate::output::CreateManagedPrefixListOutput,
                crate::error::CreateManagedPrefixListError,
                crate::input::CreateManagedPrefixListInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>A name for the prefix list.</p>
        /// <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
        pub fn prefix_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix_list_name(input.into());
            self
        }
        /// <p>A name for the prefix list.</p>
        /// <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
        pub fn set_prefix_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_prefix_list_name(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>One or more entries for the prefix list.</p>
        pub fn entries(mut self, input: crate::model::AddPrefixListEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>One or more entries for the prefix list.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddPrefixListEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn max_entries(mut self, input: i32) -> Self {
            self.inner = self.inner.max_entries(input);
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn set_max_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_entries(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the prefix list during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the prefix list during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>The IP address type.</p>
        /// <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
        pub fn address_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.address_family(input.into());
            self
        }
        /// <p>The IP address type.</p>
        /// <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_address_family(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraints: Up to 255 UTF-8 characters in length.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraints: Up to 255 UTF-8 characters in length.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNatGateway`.
    ///
    /// <p>Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway.</p>
    /// <p>With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that instances in a private subnet can connect to the internet.</p>
    /// <p>With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT gateways</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNatGateway<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_nat_gateway_input::Builder,
    }
    impl<C, M, R> CreateNatGateway<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNatGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNatGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNatGatewayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNatGatewayInputOperationOutputAlias,
                crate::output::CreateNatGatewayOutput,
                crate::error::CreateNatGatewayError,
                crate::input::CreateNatGatewayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
        pub fn allocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.allocation_id(input.into());
            self
        }
        /// <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
        pub fn set_allocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_allocation_id(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        /// <p>Constraint: Maximum 64 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        /// <p>Constraint: Maximum 64 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The subnet in which to create the NAT gateway.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The subnet in which to create the NAT gateway.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the NAT gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the NAT gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
        pub fn connectivity_type(mut self, input: crate::model::ConnectivityType) -> Self {
            self.inner = self.inner.connectivity_type(input);
            self
        }
        /// <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
        pub fn set_connectivity_type(
            mut self,
            input: std::option::Option<crate::model::ConnectivityType>,
        ) -> Self {
            self.inner = self.inner.set_connectivity_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkAcl`.
    ///
    /// <p>Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkAcl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_acl_input::Builder,
    }
    impl<C, M, R> CreateNetworkAcl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkAcl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkAclOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkAclError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkAclInputOperationOutputAlias,
                crate::output::CreateNetworkAclOutput,
                crate::error::CreateNetworkAclError,
                crate::input::CreateNetworkAclInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the network ACL.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the network ACL.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkAclEntry`.
    ///
    /// <p>Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.</p>
    /// <p>We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.</p>
    /// <p>After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old one.</p>
    /// <p>For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkAclEntry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_acl_entry_input::Builder,
    }
    impl<C, M, R> CreateNetworkAclEntry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkAclEntry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkAclEntryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkAclEntryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkAclEntryInputOperationOutputAlias,
                crate::output::CreateNetworkAclEntryOutput,
                crate::error::CreateNetworkAclEntryError,
                crate::input::CreateNetworkAclEntryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_block(input.into());
            self
        }
        /// <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr_block(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
        pub fn egress(mut self, input: bool) -> Self {
            self.inner = self.inner.egress(input);
            self
        }
        /// <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
        pub fn set_egress(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_egress(input);
            self
        }
        /// <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
        pub fn icmp_type_code(mut self, input: crate::model::IcmpTypeCode) -> Self {
            self.inner = self.inner.icmp_type_code(input);
            self
        }
        /// <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
        pub fn set_icmp_type_code(
            mut self,
            input: std::option::Option<crate::model::IcmpTypeCode>,
        ) -> Self {
            self.inner = self.inner.set_icmp_type_code(input);
            self
        }
        /// <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_cidr_block(input.into());
            self
        }
        /// <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_cidr_block(input);
            self
        }
        /// <p>The ID of the network ACL.</p>
        pub fn network_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_acl_id(input.into());
            self
        }
        /// <p>The ID of the network ACL.</p>
        pub fn set_network_acl_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_acl_id(input);
            self
        }
        /// <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
        pub fn port_range(mut self, input: crate::model::PortRange) -> Self {
            self.inner = self.inner.port_range(input);
            self
        }
        /// <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
        pub fn set_port_range(
            mut self,
            input: std::option::Option<crate::model::PortRange>,
        ) -> Self {
            self.inner = self.inner.set_port_range(input);
            self
        }
        /// <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.protocol(input.into());
            self
        }
        /// <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
        pub fn rule_action(mut self, input: crate::model::RuleAction) -> Self {
            self.inner = self.inner.rule_action(input);
            self
        }
        /// <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
        pub fn set_rule_action(
            mut self,
            input: std::option::Option<crate::model::RuleAction>,
        ) -> Self {
            self.inner = self.inner.set_rule_action(input);
            self
        }
        /// <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p>
        /// <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
        pub fn rule_number(mut self, input: i32) -> Self {
            self.inner = self.inner.rule_number(input);
            self
        }
        /// <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p>
        /// <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
        pub fn set_rule_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rule_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkInsightsAccessScope`.
    ///
    /// <p>Creates a Network Access Scope.</p>
    /// <p>Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that their networks on Amazon Web Services conform to their network security and governance objectives. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web Services Network Access Analyzer Guide</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkInsightsAccessScope<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_insights_access_scope_input::Builder,
    }
    impl<C, M, R> CreateNetworkInsightsAccessScope<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkInsightsAccessScope`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkInsightsAccessScopeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkInsightsAccessScopeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkInsightsAccessScopeInputOperationOutputAlias,
                crate::output::CreateNetworkInsightsAccessScopeOutput,
                crate::error::CreateNetworkInsightsAccessScopeError,
                crate::input::CreateNetworkInsightsAccessScopeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `MatchPaths`.
        ///
        /// To override the contents of this collection use [`set_match_paths`](Self::set_match_paths).
        ///
        /// <p>The paths to match.</p>
        pub fn match_paths(mut self, input: crate::model::AccessScopePathRequest) -> Self {
            self.inner = self.inner.match_paths(input);
            self
        }
        /// <p>The paths to match.</p>
        pub fn set_match_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        ) -> Self {
            self.inner = self.inner.set_match_paths(input);
            self
        }
        /// Appends an item to `ExcludePaths`.
        ///
        /// To override the contents of this collection use [`set_exclude_paths`](Self::set_exclude_paths).
        ///
        /// <p>The paths to exclude.</p>
        pub fn exclude_paths(mut self, input: crate::model::AccessScopePathRequest) -> Self {
            self.inner = self.inner.exclude_paths(input);
            self
        }
        /// <p>The paths to exclude.</p>
        pub fn set_exclude_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        ) -> Self {
            self.inner = self.inner.set_exclude_paths(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkInsightsPath`.
    ///
    /// <p>Creates a path to analyze for reachability.</p>
    /// <p>Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/reachability/">What is Reachability Analyzer</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkInsightsPath<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_insights_path_input::Builder,
    }
    impl<C, M, R> CreateNetworkInsightsPath<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkInsightsPath`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkInsightsPathOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkInsightsPathError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkInsightsPathInputOperationOutputAlias,
                crate::output::CreateNetworkInsightsPathOutput,
                crate::error::CreateNetworkInsightsPathError,
                crate::input::CreateNetworkInsightsPathInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IP address of the Amazon Web Services resource that is the source of the path.</p>
        pub fn source_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ip(input.into());
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the source of the path.</p>
        pub fn set_source_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_ip(input);
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the destination of the path.</p>
        pub fn destination_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_ip(input.into());
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the destination of the path.</p>
        pub fn set_destination_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_ip(input);
            self
        }
        /// <p>The Amazon Web Services resource that is the source of the path.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The Amazon Web Services resource that is the source of the path.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The Amazon Web Services resource that is the destination of the path.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination(input.into());
            self
        }
        /// <p>The Amazon Web Services resource that is the destination of the path.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The protocol.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The destination port.</p>
        pub fn destination_port(mut self, input: i32) -> Self {
            self.inner = self.inner.destination_port(input);
            self
        }
        /// <p>The destination port.</p>
        pub fn set_destination_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_destination_port(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to add to the path.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to add to the path.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkInterface`.
    ///
    /// <p>Creates a network interface in the specified subnet.</p>
    /// <p>For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_interface_input::Builder,
    }
    impl<C, M, R> CreateNetworkInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkInterfaceInputOperationOutputAlias,
                crate::output::CreateNetworkInterfaceOutput,
                crate::error::CreateNetworkInterfaceError,
                crate::input::CreateNetworkInterfaceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the network interface.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the network interface.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `Groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The IDs of one or more security groups.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.groups(input.into());
            self
        }
        /// <p>The IDs of one or more security groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_groups(input);
            self
        }
        /// <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv6_address_count(input);
            self
        }
        /// <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv6_address_count(input);
            self
        }
        /// Appends an item to `Ipv6Addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn ipv6_addresses(mut self, input: crate::model::InstanceIpv6Address) -> Self {
            self.inner = self.inner.ipv6_addresses(input);
            self
        }
        /// <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_addresses(input);
            self
        }
        /// <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.private_ip_address(input.into());
            self
        }
        /// <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_private_ip_address(input);
            self
        }
        /// Appends an item to `PrivateIpAddresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more private IPv4 addresses.</p>
        pub fn private_ip_addresses(
            mut self,
            input: crate::model::PrivateIpAddressSpecification,
        ) -> Self {
            self.inner = self.inner.private_ip_addresses(input);
            self
        }
        /// <p>One or more private IPv4 addresses.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_private_ip_addresses(input);
            self
        }
        /// <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p>
        /// <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.inner = self.inner.secondary_private_ip_address_count(input);
            self
        }
        /// <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p>
        /// <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_secondary_private_ip_address_count(input);
            self
        }
        /// Appends an item to `Ipv4Prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn ipv4_prefixes(
            mut self,
            input: crate::model::Ipv4PrefixSpecificationRequest,
        ) -> Self {
            self.inner = self.inner.ipv4_prefixes(input);
            self
        }
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_ipv4_prefixes(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn ipv4_prefix_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv4_prefix_count(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn set_ipv4_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv4_prefix_count(input);
            self
        }
        /// Appends an item to `Ipv6Prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn ipv6_prefixes(
            mut self,
            input: crate::model::Ipv6PrefixSpecificationRequest,
        ) -> Self {
            self.inner = self.inner.ipv6_prefixes(input);
            self
        }
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_prefixes(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn ipv6_prefix_count(mut self, input: i32) -> Self {
            self.inner = self.inner.ipv6_prefix_count(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn set_ipv6_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ipv6_prefix_count(input);
            self
        }
        /// <p>Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html"> Elastic Fabric Adapter</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. To create a trunk network interface, specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html"> Network interface trunking</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn interface_type(mut self, input: crate::model::NetworkInterfaceCreationType) -> Self {
            self.inner = self.inner.interface_type(input);
            self
        }
        /// <p>Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html"> Elastic Fabric Adapter</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. To create a trunk network interface, specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/eni-trunking.html"> Network interface trunking</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_interface_type(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceCreationType>,
        ) -> Self {
            self.inner = self.inner.set_interface_type(input);
            self
        }
        /// <p>The ID of the subnet to associate with the network interface.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet to associate with the network interface.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new network interface.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the new network interface.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetworkInterfacePermission`.
    ///
    /// <p>Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account.</p>
    /// <p>You can grant permission to a single Amazon Web Services account only, and only one account at a time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetworkInterfacePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_interface_permission_input::Builder,
    }
    impl<C, M, R> CreateNetworkInterfacePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetworkInterfacePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkInterfacePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkInterfacePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkInterfacePermissionInputOperationOutputAlias,
                crate::output::CreateNetworkInterfacePermissionOutput,
                crate::error::CreateNetworkInterfacePermissionError,
                crate::input::CreateNetworkInterfacePermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_account_id(input);
            self
        }
        /// <p>The Amazon Web Service. Currently not supported.</p>
        pub fn aws_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_service(input.into());
            self
        }
        /// <p>The Amazon Web Service. Currently not supported.</p>
        pub fn set_aws_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_aws_service(input);
            self
        }
        /// <p>The type of permission to grant.</p>
        pub fn permission(mut self, input: crate::model::InterfacePermissionType) -> Self {
            self.inner = self.inner.permission(input);
            self
        }
        /// <p>The type of permission to grant.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::InterfacePermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePlacementGroup`.
    ///
    /// <p>Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group. </p>
    /// <p>A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances on distinct hardware. A <code>partition</code> placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePlacementGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_placement_group_input::Builder,
    }
    impl<C, M, R> CreatePlacementGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePlacementGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePlacementGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePlacementGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePlacementGroupInputOperationOutputAlias,
                crate::output::CreatePlacementGroupOutput,
                crate::error::CreatePlacementGroupError,
                crate::input::CreatePlacementGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The placement strategy.</p>
        pub fn strategy(mut self, input: crate::model::PlacementStrategy) -> Self {
            self.inner = self.inner.strategy(input);
            self
        }
        /// <p>The placement strategy.</p>
        pub fn set_strategy(
            mut self,
            input: std::option::Option<crate::model::PlacementStrategy>,
        ) -> Self {
            self.inner = self.inner.set_strategy(input);
            self
        }
        /// <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
        pub fn partition_count(mut self, input: i32) -> Self {
            self.inner = self.inner.partition_count(input);
            self
        }
        /// <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
        pub fn set_partition_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_partition_count(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new placement group.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the new placement group.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublicIpv4Pool`.
    ///
    /// <p>Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html">DescribePublicIpv4Pools</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePublicIpv4Pool<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_public_ipv4_pool_input::Builder,
    }
    impl<C, M, R> CreatePublicIpv4Pool<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePublicIpv4Pool`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublicIpv4PoolOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublicIpv4PoolError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePublicIpv4PoolInputOperationOutputAlias,
                crate::output::CreatePublicIpv4PoolOutput,
                crate::error::CreatePublicIpv4PoolError,
                crate::input::CreatePublicIpv4PoolInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplaceRootVolumeTask`.
    ///
    /// <p>Creates a root volume replacement task for an Amazon EC2 instance. The root volume can either be restored to its initial launch state, or it can be restored using a specific snapshot.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root">Replace a root volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplaceRootVolumeTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replace_root_volume_task_input::Builder,
    }
    impl<C, M, R> CreateReplaceRootVolumeTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplaceRootVolumeTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplaceRootVolumeTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplaceRootVolumeTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplaceRootVolumeTaskInputOperationOutputAlias,
                crate::output::CreateReplaceRootVolumeTaskOutput,
                crate::error::CreateReplaceRootVolumeTaskError,
                crate::input::CreateReplaceRootVolumeTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the instance for which to replace the root volume.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of the instance for which to replace the root volume.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_id(input.into());
            self
        }
        /// <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_snapshot_id(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the root volume replacement task.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the root volume replacement task.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReservedInstancesListing`.
    ///
    /// <p>Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the <code>DescribeReservedInstances</code> operation.</p> <note>
    /// <p>Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.</p>
    /// </note>
    /// <p>The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p>
    /// <p>To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the <code>DescribeReservedInstancesListings</code> operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReservedInstancesListing<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_reserved_instances_listing_input::Builder,
    }
    impl<C, M, R> CreateReservedInstancesListing<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReservedInstancesListing`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReservedInstancesListingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReservedInstancesListingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReservedInstancesListingInputOperationOutputAlias,
                crate::output::CreateReservedInstancesListingOutput,
                crate::error::CreateReservedInstancesListingError,
                crate::input::CreateReservedInstancesListingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.inner = self.inner.instance_count(input);
            self
        }
        /// <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_count(input);
            self
        }
        /// Appends an item to `PriceSchedules`.
        ///
        /// To override the contents of this collection use [`set_price_schedules`](Self::set_price_schedules).
        ///
        /// <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
        pub fn price_schedules(mut self, input: crate::model::PriceScheduleSpecification) -> Self {
            self.inner = self.inner.price_schedules(input);
            self
        }
        /// <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
        pub fn set_price_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PriceScheduleSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_price_schedules(input);
            self
        }
        /// <p>The ID of the active Standard Reserved Instance.</p>
        pub fn reserved_instances_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_instances_id(input.into());
            self
        }
        /// <p>The ID of the active Standard Reserved Instance.</p>
        pub fn set_reserved_instances_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_instances_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRestoreImageTask`.
    ///
    /// <p>Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html">CreateStoreImageTask</a>.</p>
    /// <p>To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRestoreImageTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_restore_image_task_input::Builder,
    }
    impl<C, M, R> CreateRestoreImageTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRestoreImageTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRestoreImageTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRestoreImageTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRestoreImageTaskInputOperationOutputAlias,
                crate::output::CreateRestoreImageTaskOutput,
                crate::error::CreateRestoreImageTaskError,
                crate::input::CreateRestoreImageTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The name of the stored AMI object in the bucket.</p>
        pub fn object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_key(input.into());
            self
        }
        /// <p>The name of the stored AMI object in the bucket.</p>
        pub fn set_object_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_object_key(input);
            self
        }
        /// <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates a route in a route table within a VPC.</p>
    /// <p>You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.</p>
    /// <p>When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:</p>
    /// <ul>
    /// <li> <p> <code>192.0.2.0/24</code> (goes to some target A)</p> </li>
    /// <li> <p> <code>192.0.2.0/28</code> (goes to some target B)</p> </li>
    /// </ul>
    /// <p>Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic.</p>
    /// <p>For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_input::Builder,
    }
    impl<C, M, R> CreateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteInputOperationOutputAlias,
                crate::output::CreateRouteOutput,
                crate::error::CreateRouteError,
                crate::input::CreateRouteInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_cidr_block(input.into());
            self
        }
        /// <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_cidr_block(input);
            self
        }
        /// <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
        pub fn destination_ipv6_cidr_block(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_ipv6_cidr_block(input.into());
            self
        }
        /// <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
        pub fn set_destination_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_ipv6_cidr_block(input);
            self
        }
        /// <p>The ID of a prefix list used for the destination match.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_prefix_list_id(input.into());
            self
        }
        /// <p>The ID of a prefix list used for the destination match.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_prefix_list_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_endpoint_id(input.into());
            self
        }
        /// <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_endpoint_id(input);
            self
        }
        /// <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
        pub fn egress_only_internet_gateway_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.egress_only_internet_gateway_id(input.into());
            self
        }
        /// <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
        pub fn set_egress_only_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_egress_only_internet_gateway_id(input);
            self
        }
        /// <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_id(input.into());
            self
        }
        /// <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gateway_id(input);
            self
        }
        /// <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
        pub fn nat_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nat_gateway_id(input.into());
            self
        }
        /// <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
        pub fn set_nat_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nat_gateway_id(input);
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transit_gateway_id(input.into());
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transit_gateway_id(input);
            self
        }
        /// <p>The ID of the local gateway.</p>
        pub fn local_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.local_gateway_id(input.into());
            self
        }
        /// <p>The ID of the local gateway.</p>
        pub fn set_local_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_local_gateway_id(input);
            self
        }
        /// <p>The ID of the carrier gateway.</p>
        /// <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
        pub fn carrier_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.carrier_gateway_id(input.into());
            self
        }
        /// <p>The ID of the carrier gateway.</p>
        /// <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
        pub fn set_carrier_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_carrier_gateway_id(input);
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_interface_id(input.into());
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_network_interface_id(input);
            self
        }
        /// <p>The ID of the route table for the route.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_table_id(input.into());
            self
        }
        /// <p>The ID of the route table for the route.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_route_table_id(input);
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_peering_connection_id(input.into());
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_peering_connection_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the core network.</p>
        pub fn core_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_network_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the core network.</p>
        pub fn set_core_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_network_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRouteTable`.
    ///
    /// <p>Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRouteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_table_input::Builder,
    }
    impl<C, M, R> CreateRouteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRouteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteTableInputOperationOutputAlias,
                crate::output::CreateRouteTableOutput,
                crate::error::CreateRouteTableError,
                crate::input::CreateRouteTableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the route table.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the route table.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityGroup`.
    ///
    /// <p>Creates a security group.</p>
    /// <p>A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    /// <p>When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can't have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.</p>
    /// <p>You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don't specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.</p>
    /// <p>You can add or remove rules from your security groups using <code>AuthorizeSecurityGroupIngress</code>, <code>AuthorizeSecurityGroupEgress</code>, <code>RevokeSecurityGroupIngress</code>, and <code>RevokeSecurityGroupEgress</code>.</p>
    /// <p>For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_group_input::Builder,
    }
    impl<C, M, R> CreateSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityGroupInputOperationOutputAlias,
                crate::output::CreateSecurityGroupOutput,
                crate::error::CreateSecurityGroupError,
                crate::input::CreateSecurityGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the security group. This is informational only.</p>
        /// <p>Constraints: Up to 255 characters in length</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the security group. This is informational only.</p>
        /// <p>Constraints: Up to 255 characters in length</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the security group.</p>
        /// <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>The name of the security group.</p>
        /// <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the security group.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the security group.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.</p>
    /// <p>You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.</p>
    /// <p>When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source volume are propagated to the snapshot.</p>
    /// <p>You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is <code>pending</code>.</p>
    /// <p>To create a snapshot for Amazon EBS volumes that serve as root devices, you should stop the instance before taking the snapshot.</p>
    /// <p>Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected.</p>
    /// <p>You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl<C, M, R> CreateSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotInputOperationOutputAlias,
                crate::output::CreateSnapshotOutput,
                crate::error::CreateSnapshotError,
                crate::input::CreateSnapshotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A description for the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
        /// <ul>
        /// <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
        /// <ul>
        /// <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_arn(input);
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.volume_id(input.into());
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_volume_id(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the snapshot during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to apply to the snapshot during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshots`.
    ///
    /// <p>Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance. Boot volumes can be excluded by changing the parameters. </p>
    /// <p>You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance, or in the Region for that Outpost.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshots_input::Builder,
    }
    impl<C, M, R> CreateSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotsInputOperationOutputAlias,
                crate::output::CreateSnapshotsOutput,
                crate::error::CreateSnapshotsError,
                crate::input::CreateSnapshotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A description propagated to every snapshot specified by the instance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A description propagated to every snapshot specified by the instance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The instance to specify which volumes should be included in the snapshots.</p>
        pub fn instance_specification(
            mut self,
            input: crate::model::InstanceSpecification,
        ) -> Self {
            self.inner = self.inner.instance_specification(input);
            self
        }
        /// <p>The instance to specify which volumes should be included in the snapshots.</p>
        pub fn set_instance_specification(
            mut self,
            input: std::option::Option<crate::model::InstanceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_instance_specification(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.</p>
        /// <ul>
        /// <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Create multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.</p>
        /// <ul>
        /// <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Create multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_arn(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>Tags to apply to every snapshot specified by the instance.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>Tags to apply to every snapshot specified by the instance.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Copies the tags from the specified volume to corresponding snapshot.</p>
        pub fn copy_tags_from_source(mut self, input: crate::model::CopyTagsFromSource) -> Self {
            self.inner = self.inner.copy_tags_from_source(input);
            self
        }
        /// <p>Copies the tags from the specified volume to corresponding snapshot.</p>
        pub fn set_copy_tags_from_source(
            mut self,
            input: std::option::Option<crate::model::CopyTagsFromSource>,
        ) -> Self {
            self.inner = self.inner.set_copy_tags_from_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSpotDatafeedSubscription`.
    ///
    /// <p>Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSpotDatafeedSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_spot_datafeed_subscription_input::Builder,
    }
    impl<C, M, R> CreateSpotDatafeedSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSpotDatafeedSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSpotDatafeedSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSpotDatafeedSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSpotDatafeedSubscriptionInputOperationOutputAlias,
                crate::output::CreateSpotDatafeedSubscriptionOutput,
                crate::error::CreateSpotDatafeedSubscriptionError,
                crate::input::CreateSpotDatafeedSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>The prefix for the data feed file names.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>The prefix for the data feed file names.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStoreImageTask`.
    ///
    /// <p>Stores an AMI as a single object in an Amazon S3 bucket.</p>
    /// <p>To use this API, you must have the required permissions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using Amazon S3</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStoreImageTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_store_image_task_input::Builder,
    }
    impl<C, M, R> CreateStoreImageTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStoreImageTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStoreImageTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStoreImageTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStoreImageTaskInputOperationOutputAlias,
                crate::output::CreateStoreImageTaskOutput,
                crate::error::CreateStoreImageTaskError,
                crate::input::CreateStoreImageTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the AMI.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_id(input.into());
            self
        }
        /// <p>The ID of the AMI.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// Appends an item to `S3ObjectTags`.
        ///
        /// To override the contents of this collection use [`set_s3_object_tags`](Self::set_s3_object_tags).
        ///
        /// <p>The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. </p>
        pub fn s3_object_tags(mut self, input: crate::model::S3ObjectTag) -> Self {
            self.inner = self.inner.s3_object_tags(input);
            self
        }
        /// <p>The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. </p>
        pub fn set_s3_object_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3ObjectTag>>,
        ) -> Self {
            self.inner = self.inner.set_s3_object_tags(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubnet`.
    ///
    /// <p>Creates a subnet in a specified VPC.</p>
    /// <p>You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can't change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the CIDR block of an existing subnet in the VPC.</p>
    /// <p>If you've associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses a /64 prefix length. </p> <important>
    /// <p>Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR block. They're not available for use.</p>
    /// </important>
    /// <p>If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.</p>
    /// <p>When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a subnet with no running instances (they're all stopped), but no remaining IP addresses available.</p>
    /// <p>For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubnet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subnet_input::Builder,
    }
    impl<C, M, R> CreateSubnet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubnet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubnetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubnetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubnetInputOperationOutputAlias,
                crate::output::CreateSubnetOutput,
                crate::error::CreateSubnetError,
                crate::input::CreateSubnetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the subnet.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the subnet.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>The Availability Zone or Local Zone for the subnet.</p>
        /// <p>Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p>
        /// <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        /// <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone or Local Zone for the subnet.</p>
        /// <p>Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p>
        /// <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        /// <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The AZ ID or the Local Zone ID of the subnet.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_id(input.into());
            self
        }
        /// <p>The AZ ID or the Local Zone ID of the subnet.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_id(input);
            self
        }
        /// <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        /// <p>This parameter is not supported for an IPv6 only subnet.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_block(input.into());
            self
        }
        /// <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        /// <p>This parameter is not supported for an IPv6 only subnet.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr_block(input);
            self
        }
        /// <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>
        /// <p>This parameter is required for an IPv6 only subnet.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ipv6_cidr_block(input.into());
            self
        }
        /// <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>
        /// <p>This parameter is required for an IPv6 only subnet.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ipv6_cidr_block(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_arn(input);
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet.</p>
        pub fn ipv6_native(mut self, input: bool) -> Self {
            self.inner = self.inner.ipv6_native(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet.</p>
        pub fn set_ipv6_native(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_ipv6_native(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubnetCidrReservation`.
    ///
    /// <p>Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSubnetCidrReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subnet_cidr_reservation_input::Builder,
    }
    impl<C, M, R> CreateSubnetCidrReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubnetCidrReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubnetCidrReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubnetCidrReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubnetCidrReservationInputOperationOutputAlias,
                crate::output::CreateSubnetCidrReservationOutput,
                crate::error::CreateSubnetCidrReservationError,
                crate::input::CreateSubnetCidrReservationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the subnet CIDR reservation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to the subnet CIDR reservation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The IPv4 or IPV6 CIDR range to reserve.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The IPv4 or IPV6 CIDR range to reserve.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
        /// <p>The type of reservation.</p>
        /// <p>The following are valid values:</p>
        /// <ul>
        /// <li> <p> <code>prefix</code>: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation for Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li>
        /// <li> <p> <code>explicit</code>: You manually assign the IP addresses to resources that reside in your subnet. </p> </li>
        /// </ul>
        pub fn reservation_type(mut self, input: crate::model::SubnetCidrReservationType) -> Self {
            self.inner = self.inner.reservation_type(input);
            self
        }
        /// <p>The type of reservation.</p>
        /// <p>The following are valid values:</p>
        /// <ul>
        /// <li> <p> <code>prefix</code>: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation for Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li>
        /// <li> <p> <code>explicit</code>: You manually assign the IP addresses to resources that reside in your subnet. </p> </li>
        /// </ul>
        pub fn set_reservation_type(
            mut self,
            input: std::option::Option<crate::model::SubnetCidrReservationType>,
        ) -> Self {
            self.inner = self.inner.set_reservation_type(input);
            self
        }
        /// <p>The description to assign to the subnet CIDR reservation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to assign to the subnet CIDR reservation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control users' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>The IDs of the resources, separated by spaces.</p>
        /// <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resources(input.into());
            self
        }
        /// <p>The IDs of the resources, separated by spaces.</p>
        /// <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags. The <code>value</code> parameter is required, but if you don't want the tag to have a value, specify the parameter with no value, and we set the value to an empty string.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags. The <code>value</code> parameter is required, but if you don't want the tag to have a value, specify the parameter with no value, and we set the value to an empty string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficMirrorFilter`.
    ///
    /// <p>Creates a Traffic Mirror filter.</p>
    /// <p>A Traffic Mirror filter is a set of rules that defines the traffic to mirror.</p>
    /// <p>By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficMirrorFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_traffic_mirror_filter_input::Builder,
    }
    impl<C, M, R> CreateTrafficMirrorFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrafficMirrorFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficMirrorFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficMirrorFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrafficMirrorFilterInputOperationOutputAlias,
                crate::output::CreateTrafficMirrorFilterOutput,
                crate::error::CreateTrafficMirrorFilterError,
                crate::input::CreateTrafficMirrorFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the Traffic Mirror filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the Traffic Mirror filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `TagSpecifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to a Traffic Mirror filter.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            self.inner = self.inner.tag_specifications(input);
            self
        }
        /// <p>The tags to assign to a Traffic Mirror filter.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_tag_specifications(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficMirrorFilterRule`.
    ///
    /// <p>Creates a Traffic Mirror filter rule.</p>
    /// <p>A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.</p>
    /// <p>You need the Traffic Mirror filter ID when you create the rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficMirrorFilterRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_traffic_mirror_filter_rule_input::Builder,
    }
    impl<C, M, R> CreateTrafficMirrorFilterRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrafficMirrorFilterRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficMirrorFilterRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficMirrorFilterRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrafficMirrorFilterRuleInputOperationOutputAlias,
                crate::output::CreateTrafficMirrorFilterRuleOutput,
                crate::error::CreateTrafficMirrorFilterRuleError,
                crate::input::CreateTrafficMirrorFilterRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the filter that this rule is associated with.</p>
        pub fn traffic_mirror_filter_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_mirror_filter_id(input.into());
            self
        }
        /// <p>The ID of the filter that this rule is associated with.</p>
        pub fn set_traffic_mirror_filter_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_mirror_filter_id(input);
            self
        }
        /// <p>The type of traffic.</p>
        pub fn traffic_direction(mut self, input: crate::model::TrafficDirection) -> Self {
            self.inner = self.inner.traffic_direction(input);
            self
        }
        /// <p>The type of traffic.</p>
        pub fn set_traffic_direction(
            mut self,
            input: std::option::Option<crate::model::TrafficDirection>,
        ) -> Self {
            self.inner = self.inner.set_traffic_direction(input);
            self
        }
        /// <p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>
        pub fn rule_number(mut self, input: i32) -> Self {
            self.inner = self.inner.rule_number(input);
            self
        }
        /// <p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>
        pub fn set_rule_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rule_number(input);
            self
        }
        /// <p>The action to take on the filtered traffic.</p>
        pub fn rule_action(mut self, input: crate::model::TrafficMirrorRuleAction) -> Self {
            self.inner = self.inner.rule_action(input);
            self
        }
        /// <p>The action to take on the filtered traffic.</p>
        pub fn set_rule_action(
            mut self,
            input: std::option::Option<crate::model::TrafficMirrorRuleAction>,
        ) -> Self {
            self.inner = self.inner.set_rule_action(input);
            self
        }
        /// <p>The destination port range.</p>
        pub fn destination_port_range(
            mut self,
            input: crate::model::TrafficMirrorPortRangeRequest,
        ) -> Self {
            self.inner = self.inner.destination_port_range(input);
            self
        }
        /// <p>The destination port range.</p>
        pub fn set_destination_port_range(
            mut self,
            input: std::option::Option<crate::model::TrafficMirrorPortRangeRequest>,
        ) -> Self {
            self.inner = self.inner.set_destination_port_range(input);
            self
        }
        /// <p>The source port range.</p>
        pub fn source_port_range(
            mut self,
            input: crate::model::TrafficMirrorPortRangeRequest,
        ) -> Self {
            self.inner = self.inner.source_port_range(input);
            self
        }
        /// <p>The source port range.</p>
        pub fn set_source_port_range(
            mut self,
            input: std::option::Option<crate::model::TrafficMirrorPortRangeRequest>,
        ) -> Self {
            self.inner = self.inner.set_source_port_range(input);
            self
        }
        /// <p>The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
        /// <p>For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the Internet Assigned Numbers Authority (IANA) website.</p>
        pub fn protocol(mut self, input: i32) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
        /// <p>For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the Internet Assigned Numbers Authority (IANA) website.</p>
        pub fn set_protocol(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The destination CIDR block to assign to the Traffic Mirror rule.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_cidr_block(input.into());
            self
        }
        /// <p>The destination CIDR block to assign to the Traffic Mirror rule.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_cidr_block(input);
            self
        }
        /// <p>The source CIDR block to assign to the Traffic Mirror rule.</p>
        pub fn source_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_cidr_block(input.into());
            self
        }
        /// <p>The source CIDR block to assign to the Traffic Mirror rule.</p>
        pub fn set_source_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_cidr_block(input);
            self
        }
        /// <p>The description of the Traffic Mirror rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the Traffic Mirror rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and