// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::ec2_query_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_reserved_instances_exchange_quote(
    inp: &[u8],
    mut builder: crate::output::accept_reserved_instances_exchange_quote_output::Builder,
) -> Result<
    crate::output::accept_reserved_instances_exchange_quote_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptReservedInstancesExchangeQuoteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptReservedInstancesExchangeQuoteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("exchangeId") /* ExchangeId com.amazonaws.ec2.synthetic#AcceptReservedInstancesExchangeQuoteOutput$ExchangeId */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_exchange_id(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_transit_gateway_multicast_domain_associations(
    inp: &[u8],
    mut builder: crate::output::accept_transit_gateway_multicast_domain_associations_output::Builder,
) -> Result<
    crate::output::accept_transit_gateway_multicast_domain_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptTransitGatewayMulticastDomainAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!("invalid root, expected AcceptTransitGatewayMulticastDomainAssociationsResponse got {:?}", start_el)));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associations") /* Associations com.amazonaws.ec2.synthetic#AcceptTransitGatewayMulticastDomainAssociationsOutput$Associations */ =>  {
                let var_2 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain_associations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associations(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_transit_gateway_peering_attachment(
    inp: &[u8],
    mut builder: crate::output::accept_transit_gateway_peering_attachment_output::Builder,
) -> Result<
    crate::output::accept_transit_gateway_peering_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptTransitGatewayPeeringAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptTransitGatewayPeeringAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPeeringAttachment") /* TransitGatewayPeeringAttachment com.amazonaws.ec2.synthetic#AcceptTransitGatewayPeeringAttachmentOutput$TransitGatewayPeeringAttachment */ =>  {
                let var_3 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_peering_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_peering_attachment(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_transit_gateway_vpc_attachment(
    inp: &[u8],
    mut builder: crate::output::accept_transit_gateway_vpc_attachment_output::Builder,
) -> Result<
    crate::output::accept_transit_gateway_vpc_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptTransitGatewayVpcAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptTransitGatewayVpcAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachment") /* TransitGatewayVpcAttachment com.amazonaws.ec2.synthetic#AcceptTransitGatewayVpcAttachmentOutput$TransitGatewayVpcAttachment */ =>  {
                let var_4 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachment(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_vpc_endpoint_connections(
    inp: &[u8],
    mut builder: crate::output::accept_vpc_endpoint_connections_output::Builder,
) -> Result<
    crate::output::accept_vpc_endpoint_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptVpcEndpointConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptVpcEndpointConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#AcceptVpcEndpointConnectionsOutput$Unsuccessful */ =>  {
                let var_5 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_vpc_peering_connection(
    inp: &[u8],
    mut builder: crate::output::accept_vpc_peering_connection_output::Builder,
) -> Result<
    crate::output::accept_vpc_peering_connection_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptVpcPeeringConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptVpcPeeringConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcPeeringConnection") /* VpcPeeringConnection com.amazonaws.ec2.synthetic#AcceptVpcPeeringConnectionOutput$VpcPeeringConnection */ =>  {
                let var_6 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_peering_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_peering_connection(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_advertise_byoip_cidr(
    inp: &[u8],
    mut builder: crate::output::advertise_byoip_cidr_output::Builder,
) -> Result<crate::output::advertise_byoip_cidr_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AdvertiseByoipCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AdvertiseByoipCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidr") /* ByoipCidr com.amazonaws.ec2.synthetic#AdvertiseByoipCidrOutput$ByoipCidr */ =>  {
                let var_7 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_byoip_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidr(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_allocate_address(
    inp: &[u8],
    mut builder: crate::output::allocate_address_output::Builder,
) -> Result<crate::output::allocate_address_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AllocateAddressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AllocateAddressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("publicIp") /* PublicIp com.amazonaws.ec2.synthetic#AllocateAddressOutput$PublicIp */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_public_ip(var_8);
            }
            ,
            s if s.matches("allocationId") /* AllocationId com.amazonaws.ec2.synthetic#AllocateAddressOutput$AllocationId */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_allocation_id(var_9);
            }
            ,
            s if s.matches("publicIpv4Pool") /* PublicIpv4Pool com.amazonaws.ec2.synthetic#AllocateAddressOutput$PublicIpv4Pool */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_public_ipv4_pool(var_10);
            }
            ,
            s if s.matches("networkBorderGroup") /* NetworkBorderGroup com.amazonaws.ec2.synthetic#AllocateAddressOutput$NetworkBorderGroup */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_border_group(var_11);
            }
            ,
            s if s.matches("domain") /* Domain com.amazonaws.ec2.synthetic#AllocateAddressOutput$Domain */ =>  {
                let var_12 =
                    Some(
                        Result::<crate::model::DomainType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DomainType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_domain(var_12);
            }
            ,
            s if s.matches("customerOwnedIp") /* CustomerOwnedIp com.amazonaws.ec2.synthetic#AllocateAddressOutput$CustomerOwnedIp */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_customer_owned_ip(var_13);
            }
            ,
            s if s.matches("customerOwnedIpv4Pool") /* CustomerOwnedIpv4Pool com.amazonaws.ec2.synthetic#AllocateAddressOutput$CustomerOwnedIpv4Pool */ =>  {
                let var_14 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_customer_owned_ipv4_pool(var_14);
            }
            ,
            s if s.matches("carrierIp") /* CarrierIp com.amazonaws.ec2.synthetic#AllocateAddressOutput$CarrierIp */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_carrier_ip(var_15);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_allocate_hosts(
    inp: &[u8],
    mut builder: crate::output::allocate_hosts_output::Builder,
) -> Result<crate::output::allocate_hosts_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AllocateHostsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AllocateHostsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("hostIdSet") /* HostIds com.amazonaws.ec2.synthetic#AllocateHostsOutput$HostIds */ =>  {
                let var_16 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_response_host_id_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_host_ids(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_allocate_ipam_pool_cidr(
    inp: &[u8],
    mut builder: crate::output::allocate_ipam_pool_cidr_output::Builder,
) -> Result<crate::output::allocate_ipam_pool_cidr_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AllocateIpamPoolCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AllocateIpamPoolCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPoolAllocation") /* IpamPoolAllocation com.amazonaws.ec2.synthetic#AllocateIpamPoolCidrOutput$IpamPoolAllocation */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool_allocation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_allocation(var_17);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_apply_security_groups_to_client_vpn_target_network(
    inp: &[u8],
    mut builder: crate::output::apply_security_groups_to_client_vpn_target_network_output::Builder,
) -> Result<
    crate::output::apply_security_groups_to_client_vpn_target_network_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ApplySecurityGroupsToClientVpnTargetNetworkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ApplySecurityGroupsToClientVpnTargetNetworkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("securityGroupIds") /* SecurityGroupIds com.amazonaws.ec2.synthetic#ApplySecurityGroupsToClientVpnTargetNetworkOutput$SecurityGroupIds */ =>  {
                let var_18 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_client_vpn_security_group_id_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_group_ids(var_18);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_assign_ipv6_addresses(
    inp: &[u8],
    mut builder: crate::output::assign_ipv6_addresses_output::Builder,
) -> Result<crate::output::assign_ipv6_addresses_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssignIpv6AddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssignIpv6AddressesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("assignedIpv6Addresses") /* AssignedIpv6Addresses com.amazonaws.ec2.synthetic#AssignIpv6AddressesOutput$AssignedIpv6Addresses */ =>  {
                let var_19 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipv6_address_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_assigned_ipv6_addresses(var_19);
            }
            ,
            s if s.matches("assignedIpv6PrefixSet") /* AssignedIpv6Prefixes com.amazonaws.ec2.synthetic#AssignIpv6AddressesOutput$AssignedIpv6Prefixes */ =>  {
                let var_20 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ip_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_assigned_ipv6_prefixes(var_20);
            }
            ,
            s if s.matches("networkInterfaceId") /* NetworkInterfaceId com.amazonaws.ec2.synthetic#AssignIpv6AddressesOutput$NetworkInterfaceId */ =>  {
                let var_21 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_interface_id(var_21);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_assign_private_ip_addresses(
    inp: &[u8],
    mut builder: crate::output::assign_private_ip_addresses_output::Builder,
) -> Result<
    crate::output::assign_private_ip_addresses_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssignPrivateIpAddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssignPrivateIpAddressesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInterfaceId") /* NetworkInterfaceId com.amazonaws.ec2.synthetic#AssignPrivateIpAddressesOutput$NetworkInterfaceId */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_interface_id(var_22);
            }
            ,
            s if s.matches("assignedPrivateIpAddressesSet") /* AssignedPrivateIpAddresses com.amazonaws.ec2.synthetic#AssignPrivateIpAddressesOutput$AssignedPrivateIpAddresses */ =>  {
                let var_23 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_assigned_private_ip_address_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_assigned_private_ip_addresses(var_23);
            }
            ,
            s if s.matches("assignedIpv4PrefixSet") /* AssignedIpv4Prefixes com.amazonaws.ec2.synthetic#AssignPrivateIpAddressesOutput$AssignedIpv4Prefixes */ =>  {
                let var_24 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipv4_prefixes_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_assigned_ipv4_prefixes(var_24);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_address(
    inp: &[u8],
    mut builder: crate::output::associate_address_output::Builder,
) -> Result<crate::output::associate_address_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateAddressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateAddressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2.synthetic#AssociateAddressOutput$AssociationId */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_25);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_client_vpn_target_network(
    inp: &[u8],
    mut builder: crate::output::associate_client_vpn_target_network_output::Builder,
) -> Result<
    crate::output::associate_client_vpn_target_network_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateClientVpnTargetNetworkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateClientVpnTargetNetworkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2.synthetic#AssociateClientVpnTargetNetworkOutput$AssociationId */ =>  {
                let var_26 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_26);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#AssociateClientVpnTargetNetworkOutput$Status */ =>  {
                let var_27 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_association_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_27);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_enclave_certificate_iam_role(
    inp: &[u8],
    mut builder: crate::output::associate_enclave_certificate_iam_role_output::Builder,
) -> Result<
    crate::output::associate_enclave_certificate_iam_role_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateEnclaveCertificateIamRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateEnclaveCertificateIamRoleResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("certificateS3BucketName") /* CertificateS3BucketName com.amazonaws.ec2.synthetic#AssociateEnclaveCertificateIamRoleOutput$CertificateS3BucketName */ =>  {
                let var_28 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_s3_bucket_name(var_28);
            }
            ,
            s if s.matches("certificateS3ObjectKey") /* CertificateS3ObjectKey com.amazonaws.ec2.synthetic#AssociateEnclaveCertificateIamRoleOutput$CertificateS3ObjectKey */ =>  {
                let var_29 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_s3_object_key(var_29);
            }
            ,
            s if s.matches("encryptionKmsKeyId") /* EncryptionKmsKeyId com.amazonaws.ec2.synthetic#AssociateEnclaveCertificateIamRoleOutput$EncryptionKmsKeyId */ =>  {
                let var_30 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_encryption_kms_key_id(var_30);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_iam_instance_profile(
    inp: &[u8],
    mut builder: crate::output::associate_iam_instance_profile_output::Builder,
) -> Result<
    crate::output::associate_iam_instance_profile_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateIamInstanceProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateIamInstanceProfileResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("iamInstanceProfileAssociation") /* IamInstanceProfileAssociation com.amazonaws.ec2.synthetic#AssociateIamInstanceProfileOutput$IamInstanceProfileAssociation */ =>  {
                let var_31 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_iam_instance_profile_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_instance_profile_association(var_31);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_instance_event_window(
    inp: &[u8],
    mut builder: crate::output::associate_instance_event_window_output::Builder,
) -> Result<
    crate::output::associate_instance_event_window_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateInstanceEventWindowResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateInstanceEventWindowResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindow") /* InstanceEventWindow com.amazonaws.ec2.synthetic#AssociateInstanceEventWindowOutput$InstanceEventWindow */ =>  {
                let var_32 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_window(var_32);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_route_table(
    inp: &[u8],
    mut builder: crate::output::associate_route_table_output::Builder,
) -> Result<crate::output::associate_route_table_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2.synthetic#AssociateRouteTableOutput$AssociationId */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_33);
            }
            ,
            s if s.matches("associationState") /* AssociationState com.amazonaws.ec2.synthetic#AssociateRouteTableOutput$AssociationState */ =>  {
                let var_34 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_route_table_association_state(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_association_state(var_34);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_subnet_cidr_block(
    inp: &[u8],
    mut builder: crate::output::associate_subnet_cidr_block_output::Builder,
) -> Result<
    crate::output::associate_subnet_cidr_block_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateSubnetCidrBlockResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateSubnetCidrBlockResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6CidrBlockAssociation") /* Ipv6CidrBlockAssociation com.amazonaws.ec2.synthetic#AssociateSubnetCidrBlockOutput$Ipv6CidrBlockAssociation */ =>  {
                let var_35 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet_ipv6_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association(var_35);
            }
            ,
            s if s.matches("subnetId") /* SubnetId com.amazonaws.ec2.synthetic#AssociateSubnetCidrBlockOutput$SubnetId */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_id(var_36);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_transit_gateway_multicast_domain(
    inp: &[u8],
    mut builder: crate::output::associate_transit_gateway_multicast_domain_output::Builder,
) -> Result<
    crate::output::associate_transit_gateway_multicast_domain_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateTransitGatewayMulticastDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateTransitGatewayMulticastDomainResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associations") /* Associations com.amazonaws.ec2.synthetic#AssociateTransitGatewayMulticastDomainOutput$Associations */ =>  {
                let var_37 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain_associations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associations(var_37);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_transit_gateway_route_table(
    inp: &[u8],
    mut builder: crate::output::associate_transit_gateway_route_table_output::Builder,
) -> Result<
    crate::output::associate_transit_gateway_route_table_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateTransitGatewayRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateTransitGatewayRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("association") /* Association com.amazonaws.ec2.synthetic#AssociateTransitGatewayRouteTableOutput$Association */ =>  {
                let var_38 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_association(var_38);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_trunk_interface(
    inp: &[u8],
    mut builder: crate::output::associate_trunk_interface_output::Builder,
) -> Result<
    crate::output::associate_trunk_interface_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateTrunkInterfaceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateTrunkInterfaceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("interfaceAssociation") /* InterfaceAssociation com.amazonaws.ec2.synthetic#AssociateTrunkInterfaceOutput$InterfaceAssociation */ =>  {
                let var_39 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_trunk_interface_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_interface_association(var_39);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#AssociateTrunkInterfaceOutput$ClientToken */ =>  {
                let var_40 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_40);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_vpc_cidr_block(
    inp: &[u8],
    mut builder: crate::output::associate_vpc_cidr_block_output::Builder,
) -> Result<crate::output::associate_vpc_cidr_block_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateVpcCidrBlockResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateVpcCidrBlockResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6CidrBlockAssociation") /* Ipv6CidrBlockAssociation com.amazonaws.ec2.synthetic#AssociateVpcCidrBlockOutput$Ipv6CidrBlockAssociation */ =>  {
                let var_41 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_ipv6_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association(var_41);
            }
            ,
            s if s.matches("cidrBlockAssociation") /* CidrBlockAssociation com.amazonaws.ec2.synthetic#AssociateVpcCidrBlockOutput$CidrBlockAssociation */ =>  {
                let var_42 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cidr_block_association(var_42);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2.synthetic#AssociateVpcCidrBlockOutput$VpcId */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_attach_classic_link_vpc(
    inp: &[u8],
    mut builder: crate::output::attach_classic_link_vpc_output::Builder,
) -> Result<crate::output::attach_classic_link_vpc_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AttachClassicLinkVpcResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AttachClassicLinkVpcResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#AttachClassicLinkVpcOutput$Return */ =>  {
                let var_44 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_44);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_attach_network_interface(
    inp: &[u8],
    mut builder: crate::output::attach_network_interface_output::Builder,
) -> Result<crate::output::attach_network_interface_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AttachNetworkInterfaceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AttachNetworkInterfaceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachmentId") /* AttachmentId com.amazonaws.ec2.synthetic#AttachNetworkInterfaceOutput$AttachmentId */ =>  {
                let var_45 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_attachment_id(var_45);
            }
            ,
            s if s.matches("networkCardIndex") /* NetworkCardIndex com.amazonaws.ec2.synthetic#AttachNetworkInterfaceOutput$NetworkCardIndex */ =>  {
                let var_46 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_network_card_index(var_46);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_attach_volume(
    inp: &[u8],
    mut builder: crate::output::attach_volume_output::Builder,
) -> Result<crate::output::attach_volume_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AttachVolumeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AttachVolumeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachTime") /* AttachTime com.amazonaws.ec2.synthetic#AttachVolumeOutput$AttachTime */ =>  {
                let var_47 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_attach_time(var_47);
            }
            ,
            s if s.matches("device") /* Device com.amazonaws.ec2.synthetic#AttachVolumeOutput$Device */ =>  {
                let var_48 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_device(var_48);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#AttachVolumeOutput$InstanceId */ =>  {
                let var_49 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_49);
            }
            ,
            s if s.matches("status") /* State com.amazonaws.ec2.synthetic#AttachVolumeOutput$State */ =>  {
                let var_50 =
                    Some(
                        Result::<crate::model::VolumeAttachmentState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VolumeAttachmentState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_50);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#AttachVolumeOutput$VolumeId */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_51);
            }
            ,
            s if s.matches("deleteOnTermination") /* DeleteOnTermination com.amazonaws.ec2.synthetic#AttachVolumeOutput$DeleteOnTermination */ =>  {
                let var_52 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delete_on_termination(var_52);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_attach_vpn_gateway(
    inp: &[u8],
    mut builder: crate::output::attach_vpn_gateway_output::Builder,
) -> Result<crate::output::attach_vpn_gateway_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AttachVpnGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AttachVpnGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachment") /* VpcAttachment com.amazonaws.ec2.synthetic#AttachVpnGatewayOutput$VpcAttachment */ =>  {
                let var_53 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_attachment(var_53);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_client_vpn_ingress(
    inp: &[u8],
    mut builder: crate::output::authorize_client_vpn_ingress_output::Builder,
) -> Result<
    crate::output::authorize_client_vpn_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeClientVpnIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeClientVpnIngressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#AuthorizeClientVpnIngressOutput$Status */ =>  {
                let var_54 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_authorization_rule_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_54);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_security_group_egress(
    inp: &[u8],
    mut builder: crate::output::authorize_security_group_egress_output::Builder,
) -> Result<
    crate::output::authorize_security_group_egress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeSecurityGroupEgressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeSecurityGroupEgressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#AuthorizeSecurityGroupEgressOutput$Return */ =>  {
                let var_55 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_55);
            }
            ,
            s if s.matches("securityGroupRuleSet") /* SecurityGroupRules com.amazonaws.ec2.synthetic#AuthorizeSecurityGroupEgressOutput$SecurityGroupRules */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_security_group_rule_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_group_rules(var_56);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_security_group_ingress(
    inp: &[u8],
    mut builder: crate::output::authorize_security_group_ingress_output::Builder,
) -> Result<
    crate::output::authorize_security_group_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeSecurityGroupIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeSecurityGroupIngressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#AuthorizeSecurityGroupIngressOutput$Return */ =>  {
                let var_57 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_57);
            }
            ,
            s if s.matches("securityGroupRuleSet") /* SecurityGroupRules com.amazonaws.ec2.synthetic#AuthorizeSecurityGroupIngressOutput$SecurityGroupRules */ =>  {
                let var_58 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_security_group_rule_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_group_rules(var_58);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_bundle_instance(
    inp: &[u8],
    mut builder: crate::output::bundle_instance_output::Builder,
) -> Result<crate::output::bundle_instance_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("BundleInstanceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected BundleInstanceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("bundleInstanceTask") /* BundleTask com.amazonaws.ec2.synthetic#BundleInstanceOutput$BundleTask */ =>  {
                let var_59 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_bundle_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bundle_task(var_59);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_bundle_task(
    inp: &[u8],
    mut builder: crate::output::cancel_bundle_task_output::Builder,
) -> Result<crate::output::cancel_bundle_task_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelBundleTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelBundleTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("bundleInstanceTask") /* BundleTask com.amazonaws.ec2.synthetic#CancelBundleTaskOutput$BundleTask */ =>  {
                let var_60 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_bundle_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bundle_task(var_60);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_capacity_reservation(
    inp: &[u8],
    mut builder: crate::output::cancel_capacity_reservation_output::Builder,
) -> Result<
    crate::output::cancel_capacity_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelCapacityReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelCapacityReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#CancelCapacityReservationOutput$Return */ =>  {
                let var_61 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_capacity_reservation_fleets(
    inp: &[u8],
    mut builder: crate::output::cancel_capacity_reservation_fleets_output::Builder,
) -> Result<
    crate::output::cancel_capacity_reservation_fleets_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelCapacityReservationFleetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelCapacityReservationFleetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfulFleetCancellationSet") /* SuccessfulFleetCancellations com.amazonaws.ec2.synthetic#CancelCapacityReservationFleetsOutput$SuccessfulFleetCancellations */ =>  {
                let var_62 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_capacity_reservation_fleet_cancellation_state_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful_fleet_cancellations(var_62);
            }
            ,
            s if s.matches("failedFleetCancellationSet") /* FailedFleetCancellations com.amazonaws.ec2.synthetic#CancelCapacityReservationFleetsOutput$FailedFleetCancellations */ =>  {
                let var_63 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_failed_capacity_reservation_fleet_cancellation_result_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failed_fleet_cancellations(var_63);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_import_task(
    inp: &[u8],
    mut builder: crate::output::cancel_import_task_output::Builder,
) -> Result<crate::output::cancel_import_task_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelImportTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelImportTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("importTaskId") /* ImportTaskId com.amazonaws.ec2.synthetic#CancelImportTaskOutput$ImportTaskId */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_import_task_id(var_64);
            }
            ,
            s if s.matches("previousState") /* PreviousState com.amazonaws.ec2.synthetic#CancelImportTaskOutput$PreviousState */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_previous_state(var_65);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2.synthetic#CancelImportTaskOutput$State */ =>  {
                let var_66 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_66);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_reserved_instances_listing(
    inp: &[u8],
    mut builder: crate::output::cancel_reserved_instances_listing_output::Builder,
) -> Result<
    crate::output::cancel_reserved_instances_listing_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelReservedInstancesListingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelReservedInstancesListingResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesListingsSet") /* ReservedInstancesListings com.amazonaws.ec2.synthetic#CancelReservedInstancesListingOutput$ReservedInstancesListings */ =>  {
                let var_67 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_listing_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_listings(var_67);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_spot_fleet_requests(
    inp: &[u8],
    mut builder: crate::output::cancel_spot_fleet_requests_output::Builder,
) -> Result<
    crate::output::cancel_spot_fleet_requests_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelSpotFleetRequestsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelSpotFleetRequestsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfulFleetRequestSet") /* SuccessfulFleetRequests com.amazonaws.ec2.synthetic#CancelSpotFleetRequestsOutput$SuccessfulFleetRequests */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_cancel_spot_fleet_requests_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful_fleet_requests(var_68);
            }
            ,
            s if s.matches("unsuccessfulFleetRequestSet") /* UnsuccessfulFleetRequests com.amazonaws.ec2.synthetic#CancelSpotFleetRequestsOutput$UnsuccessfulFleetRequests */ =>  {
                let var_69 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_cancel_spot_fleet_requests_error_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful_fleet_requests(var_69);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_spot_instance_requests(
    inp: &[u8],
    mut builder: crate::output::cancel_spot_instance_requests_output::Builder,
) -> Result<
    crate::output::cancel_spot_instance_requests_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelSpotInstanceRequestsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelSpotInstanceRequestsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotInstanceRequestSet") /* CancelledSpotInstanceRequests com.amazonaws.ec2.synthetic#CancelSpotInstanceRequestsOutput$CancelledSpotInstanceRequests */ =>  {
                let var_70 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_cancelled_spot_instance_request_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cancelled_spot_instance_requests(var_70);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_confirm_product_instance(
    inp: &[u8],
    mut builder: crate::output::confirm_product_instance_output::Builder,
) -> Result<crate::output::confirm_product_instance_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ConfirmProductInstanceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ConfirmProductInstanceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2.synthetic#ConfirmProductInstanceOutput$OwnerId */ =>  {
                let var_71 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_71);
            }
            ,
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ConfirmProductInstanceOutput$Return */ =>  {
                let var_72 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_72);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_copy_fpga_image(
    inp: &[u8],
    mut builder: crate::output::copy_fpga_image_output::Builder,
) -> Result<crate::output::copy_fpga_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopyFpgaImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopyFpgaImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fpgaImageId") /* FpgaImageId com.amazonaws.ec2.synthetic#CopyFpgaImageOutput$FpgaImageId */ =>  {
                let var_73 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fpga_image_id(var_73);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_copy_image(
    inp: &[u8],
    mut builder: crate::output::copy_image_output::Builder,
) -> Result<crate::output::copy_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopyImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopyImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#CopyImageOutput$ImageId */ =>  {
                let var_74 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_74);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_copy_snapshot(
    inp: &[u8],
    mut builder: crate::output::copy_snapshot_output::Builder,
) -> Result<crate::output::copy_snapshot_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopySnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopySnapshotResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#CopySnapshotOutput$SnapshotId */ =>  {
                let var_75 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_75);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CopySnapshotOutput$Tags */ =>  {
                let var_76 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_76);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_capacity_reservation(
    inp: &[u8],
    mut builder: crate::output::create_capacity_reservation_output::Builder,
) -> Result<
    crate::output::create_capacity_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateCapacityReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateCapacityReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("capacityReservation") /* CapacityReservation com.amazonaws.ec2.synthetic#CreateCapacityReservationOutput$CapacityReservation */ =>  {
                let var_77 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_capacity_reservation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation(var_77);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_capacity_reservation_fleet(
    inp: &[u8],
    mut builder: crate::output::create_capacity_reservation_fleet_output::Builder,
) -> Result<
    crate::output::create_capacity_reservation_fleet_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateCapacityReservationFleetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateCapacityReservationFleetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("capacityReservationFleetId") /* CapacityReservationFleetId com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$CapacityReservationFleetId */ =>  {
                let var_78 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_fleet_id(var_78);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$State */ =>  {
                let var_79 =
                    Some(
                        Result::<crate::model::CapacityReservationFleetState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CapacityReservationFleetState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_79);
            }
            ,
            s if s.matches("totalTargetCapacity") /* TotalTargetCapacity com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$TotalTargetCapacity */ =>  {
                let var_80 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_target_capacity(var_80);
            }
            ,
            s if s.matches("totalFulfilledCapacity") /* TotalFulfilledCapacity com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$TotalFulfilledCapacity */ =>  {
                let var_81 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.ec2#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_fulfilled_capacity(var_81);
            }
            ,
            s if s.matches("instanceMatchCriteria") /* InstanceMatchCriteria com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$InstanceMatchCriteria */ =>  {
                let var_82 =
                    Some(
                        Result::<crate::model::FleetInstanceMatchCriteria, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::FleetInstanceMatchCriteria::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_match_criteria(var_82);
            }
            ,
            s if s.matches("allocationStrategy") /* AllocationStrategy com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$AllocationStrategy */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_allocation_strategy(var_83);
            }
            ,
            s if s.matches("createTime") /* CreateTime com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$CreateTime */ =>  {
                let var_84 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_create_time(var_84);
            }
            ,
            s if s.matches("endDate") /* EndDate com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$EndDate */ =>  {
                let var_85 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_end_date(var_85);
            }
            ,
            s if s.matches("tenancy") /* Tenancy com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$Tenancy */ =>  {
                let var_86 =
                    Some(
                        Result::<crate::model::FleetCapacityReservationTenancy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::FleetCapacityReservationTenancy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_tenancy(var_86);
            }
            ,
            s if s.matches("fleetCapacityReservationSet") /* FleetCapacityReservations com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$FleetCapacityReservations */ =>  {
                let var_87 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_fleet_capacity_reservation_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fleet_capacity_reservations(var_87);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CreateCapacityReservationFleetOutput$Tags */ =>  {
                let var_88 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_88);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_carrier_gateway(
    inp: &[u8],
    mut builder: crate::output::create_carrier_gateway_output::Builder,
) -> Result<crate::output::create_carrier_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateCarrierGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateCarrierGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("carrierGateway") /* CarrierGateway com.amazonaws.ec2.synthetic#CreateCarrierGatewayOutput$CarrierGateway */ =>  {
                let var_89 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_carrier_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_carrier_gateway(var_89);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_client_vpn_endpoint(
    inp: &[u8],
    mut builder: crate::output::create_client_vpn_endpoint_output::Builder,
) -> Result<
    crate::output::create_client_vpn_endpoint_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClientVpnEndpointResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClientVpnEndpointResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientVpnEndpointId") /* ClientVpnEndpointId com.amazonaws.ec2.synthetic#CreateClientVpnEndpointOutput$ClientVpnEndpointId */ =>  {
                let var_90 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_vpn_endpoint_id(var_90);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#CreateClientVpnEndpointOutput$Status */ =>  {
                let var_91 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_endpoint_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_91);
            }
            ,
            s if s.matches("dnsName") /* DnsName com.amazonaws.ec2.synthetic#CreateClientVpnEndpointOutput$DnsName */ =>  {
                let var_92 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dns_name(var_92);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_client_vpn_route(
    inp: &[u8],
    mut builder: crate::output::create_client_vpn_route_output::Builder,
) -> Result<crate::output::create_client_vpn_route_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClientVpnRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClientVpnRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#CreateClientVpnRouteOutput$Status */ =>  {
                let var_93 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_route_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_93);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_customer_gateway(
    inp: &[u8],
    mut builder: crate::output::create_customer_gateway_output::Builder,
) -> Result<crate::output::create_customer_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateCustomerGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateCustomerGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("customerGateway") /* CustomerGateway com.amazonaws.ec2.synthetic#CreateCustomerGatewayOutput$CustomerGateway */ =>  {
                let var_94 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_customer_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_customer_gateway(var_94);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_default_subnet(
    inp: &[u8],
    mut builder: crate::output::create_default_subnet_output::Builder,
) -> Result<crate::output::create_default_subnet_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateDefaultSubnetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateDefaultSubnetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("subnet") /* Subnet com.amazonaws.ec2.synthetic#CreateDefaultSubnetOutput$Subnet */ =>  {
                let var_95 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet(var_95);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_default_vpc(
    inp: &[u8],
    mut builder: crate::output::create_default_vpc_output::Builder,
) -> Result<crate::output::create_default_vpc_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateDefaultVpcResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateDefaultVpcResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpc") /* Vpc com.amazonaws.ec2.synthetic#CreateDefaultVpcOutput$Vpc */ =>  {
                let var_96 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_dhcp_options(
    inp: &[u8],
    mut builder: crate::output::create_dhcp_options_output::Builder,
) -> Result<crate::output::create_dhcp_options_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateDhcpOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateDhcpOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("dhcpOptions") /* DhcpOptions com.amazonaws.ec2.synthetic#CreateDhcpOptionsOutput$DhcpOptions */ =>  {
                let var_97 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_dhcp_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dhcp_options(var_97);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_egress_only_internet_gateway(
    inp: &[u8],
    mut builder: crate::output::create_egress_only_internet_gateway_output::Builder,
) -> Result<
    crate::output::create_egress_only_internet_gateway_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateEgressOnlyInternetGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateEgressOnlyInternetGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateEgressOnlyInternetGatewayOutput$ClientToken */ =>  {
                let var_98 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_98);
            }
            ,
            s if s.matches("egressOnlyInternetGateway") /* EgressOnlyInternetGateway com.amazonaws.ec2.synthetic#CreateEgressOnlyInternetGatewayOutput$EgressOnlyInternetGateway */ =>  {
                let var_99 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_egress_only_internet_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_egress_only_internet_gateway(var_99);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_fleet(
    inp: &[u8],
    mut builder: crate::output::create_fleet_output::Builder,
) -> Result<crate::output::create_fleet_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateFleetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateFleetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fleetId") /* FleetId com.amazonaws.ec2.synthetic#CreateFleetOutput$FleetId */ =>  {
                let var_100 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fleet_id(var_100);
            }
            ,
            s if s.matches("errorSet") /* Errors com.amazonaws.ec2.synthetic#CreateFleetOutput$Errors */ =>  {
                let var_101 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_create_fleet_errors_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_errors(var_101);
            }
            ,
            s if s.matches("fleetInstanceSet") /* Instances com.amazonaws.ec2.synthetic#CreateFleetOutput$Instances */ =>  {
                let var_102 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_create_fleet_instances_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instances(var_102);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_flow_logs(
    inp: &[u8],
    mut builder: crate::output::create_flow_logs_output::Builder,
) -> Result<crate::output::create_flow_logs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateFlowLogsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateFlowLogsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateFlowLogsOutput$ClientToken */ =>  {
                let var_103 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_103);
            }
            ,
            s if s.matches("flowLogIdSet") /* FlowLogIds com.amazonaws.ec2.synthetic#CreateFlowLogsOutput$FlowLogIds */ =>  {
                let var_104 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_value_string_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_flow_log_ids(var_104);
            }
            ,
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#CreateFlowLogsOutput$Unsuccessful */ =>  {
                let var_105 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_105);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_fpga_image(
    inp: &[u8],
    mut builder: crate::output::create_fpga_image_output::Builder,
) -> Result<crate::output::create_fpga_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateFpgaImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateFpgaImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fpgaImageId") /* FpgaImageId com.amazonaws.ec2.synthetic#CreateFpgaImageOutput$FpgaImageId */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fpga_image_id(var_106);
            }
            ,
            s if s.matches("fpgaImageGlobalId") /* FpgaImageGlobalId com.amazonaws.ec2.synthetic#CreateFpgaImageOutput$FpgaImageGlobalId */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fpga_image_global_id(var_107);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_image(
    inp: &[u8],
    mut builder: crate::output::create_image_output::Builder,
) -> Result<crate::output::create_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#CreateImageOutput$ImageId */ =>  {
                let var_108 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_108);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_instance_event_window(
    inp: &[u8],
    mut builder: crate::output::create_instance_event_window_output::Builder,
) -> Result<
    crate::output::create_instance_event_window_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateInstanceEventWindowResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateInstanceEventWindowResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindow") /* InstanceEventWindow com.amazonaws.ec2.synthetic#CreateInstanceEventWindowOutput$InstanceEventWindow */ =>  {
                let var_109 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_window(var_109);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_instance_export_task(
    inp: &[u8],
    mut builder: crate::output::create_instance_export_task_output::Builder,
) -> Result<
    crate::output::create_instance_export_task_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateInstanceExportTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateInstanceExportTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("exportTask") /* ExportTask com.amazonaws.ec2.synthetic#CreateInstanceExportTaskOutput$ExportTask */ =>  {
                let var_110 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_export_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_export_task(var_110);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_internet_gateway(
    inp: &[u8],
    mut builder: crate::output::create_internet_gateway_output::Builder,
) -> Result<crate::output::create_internet_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateInternetGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateInternetGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("internetGateway") /* InternetGateway com.amazonaws.ec2.synthetic#CreateInternetGatewayOutput$InternetGateway */ =>  {
                let var_111 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_internet_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_internet_gateway(var_111);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_ipam(
    inp: &[u8],
    mut builder: crate::output::create_ipam_output::Builder,
) -> Result<crate::output::create_ipam_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateIpamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateIpamResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipam") /* Ipam com.amazonaws.ec2.synthetic#CreateIpamOutput$Ipam */ =>  {
                let var_112 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam(var_112);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_ipam_pool(
    inp: &[u8],
    mut builder: crate::output::create_ipam_pool_output::Builder,
) -> Result<crate::output::create_ipam_pool_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateIpamPoolResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateIpamPoolResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPool") /* IpamPool com.amazonaws.ec2.synthetic#CreateIpamPoolOutput$IpamPool */ =>  {
                let var_113 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool(var_113);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_ipam_scope(
    inp: &[u8],
    mut builder: crate::output::create_ipam_scope_output::Builder,
) -> Result<crate::output::create_ipam_scope_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateIpamScopeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateIpamScopeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamScope") /* IpamScope com.amazonaws.ec2.synthetic#CreateIpamScopeOutput$IpamScope */ =>  {
                let var_114 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_scope(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_scope(var_114);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_key_pair(
    inp: &[u8],
    mut builder: crate::output::create_key_pair_output::Builder,
) -> Result<crate::output::create_key_pair_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateKeyPairResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateKeyPairResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("keyFingerprint") /* KeyFingerprint com.amazonaws.ec2.synthetic#CreateKeyPairOutput$KeyFingerprint */ =>  {
                let var_115 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_fingerprint(var_115);
            }
            ,
            s if s.matches("keyMaterial") /* KeyMaterial com.amazonaws.ec2.synthetic#CreateKeyPairOutput$KeyMaterial */ =>  {
                let var_116 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_material(var_116);
            }
            ,
            s if s.matches("keyName") /* KeyName com.amazonaws.ec2.synthetic#CreateKeyPairOutput$KeyName */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_name(var_117);
            }
            ,
            s if s.matches("keyPairId") /* KeyPairId com.amazonaws.ec2.synthetic#CreateKeyPairOutput$KeyPairId */ =>  {
                let var_118 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_pair_id(var_118);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CreateKeyPairOutput$Tags */ =>  {
                let var_119 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_119);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_launch_template(
    inp: &[u8],
    mut builder: crate::output::create_launch_template_output::Builder,
) -> Result<crate::output::create_launch_template_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateLaunchTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateLaunchTemplateResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplate") /* LaunchTemplate com.amazonaws.ec2.synthetic#CreateLaunchTemplateOutput$LaunchTemplate */ =>  {
                let var_120 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_launch_template(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template(var_120);
            }
            ,
            s if s.matches("warning") /* Warning com.amazonaws.ec2.synthetic#CreateLaunchTemplateOutput$Warning */ =>  {
                let var_121 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_validation_warning(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_warning(var_121);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_launch_template_version(
    inp: &[u8],
    mut builder: crate::output::create_launch_template_version_output::Builder,
) -> Result<
    crate::output::create_launch_template_version_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateLaunchTemplateVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateLaunchTemplateVersionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplateVersion") /* LaunchTemplateVersion com.amazonaws.ec2.synthetic#CreateLaunchTemplateVersionOutput$LaunchTemplateVersion */ =>  {
                let var_122 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_launch_template_version(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template_version(var_122);
            }
            ,
            s if s.matches("warning") /* Warning com.amazonaws.ec2.synthetic#CreateLaunchTemplateVersionOutput$Warning */ =>  {
                let var_123 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_validation_warning(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_warning(var_123);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_local_gateway_route(
    inp: &[u8],
    mut builder: crate::output::create_local_gateway_route_output::Builder,
) -> Result<
    crate::output::create_local_gateway_route_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateLocalGatewayRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateLocalGatewayRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("route") /* Route com.amazonaws.ec2.synthetic#CreateLocalGatewayRouteOutput$Route */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_local_gateway_route(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route(var_124);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_local_gateway_route_table_vpc_association(
    inp: &[u8],
    mut builder: crate::output::create_local_gateway_route_table_vpc_association_output::Builder,
) -> Result<
    crate::output::create_local_gateway_route_table_vpc_association_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateLocalGatewayRouteTableVpcAssociationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateLocalGatewayRouteTableVpcAssociationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayRouteTableVpcAssociation") /* LocalGatewayRouteTableVpcAssociation com.amazonaws.ec2.synthetic#CreateLocalGatewayRouteTableVpcAssociationOutput$LocalGatewayRouteTableVpcAssociation */ =>  {
                let var_125 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_local_gateway_route_table_vpc_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_table_vpc_association(var_125);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_managed_prefix_list(
    inp: &[u8],
    mut builder: crate::output::create_managed_prefix_list_output::Builder,
) -> Result<
    crate::output::create_managed_prefix_list_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateManagedPrefixListResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateManagedPrefixListResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("prefixList") /* PrefixList com.amazonaws.ec2.synthetic#CreateManagedPrefixListOutput$PrefixList */ =>  {
                let var_126 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_managed_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_list(var_126);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_nat_gateway(
    inp: &[u8],
    mut builder: crate::output::create_nat_gateway_output::Builder,
) -> Result<crate::output::create_nat_gateway_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNatGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNatGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateNatGatewayOutput$ClientToken */ =>  {
                let var_127 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_127);
            }
            ,
            s if s.matches("natGateway") /* NatGateway com.amazonaws.ec2.synthetic#CreateNatGatewayOutput$NatGateway */ =>  {
                let var_128 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_nat_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_nat_gateway(var_128);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_network_acl(
    inp: &[u8],
    mut builder: crate::output::create_network_acl_output::Builder,
) -> Result<crate::output::create_network_acl_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNetworkAclResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNetworkAclResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkAcl") /* NetworkAcl com.amazonaws.ec2.synthetic#CreateNetworkAclOutput$NetworkAcl */ =>  {
                let var_129 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_acl(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_acl(var_129);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_network_insights_access_scope(
    inp: &[u8],
    mut builder: crate::output::create_network_insights_access_scope_output::Builder,
) -> Result<
    crate::output::create_network_insights_access_scope_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNetworkInsightsAccessScopeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNetworkInsightsAccessScopeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScope") /* NetworkInsightsAccessScope com.amazonaws.ec2.synthetic#CreateNetworkInsightsAccessScopeOutput$NetworkInsightsAccessScope */ =>  {
                let var_130 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_access_scope(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope(var_130);
            }
            ,
            s if s.matches("networkInsightsAccessScopeContent") /* NetworkInsightsAccessScopeContent com.amazonaws.ec2.synthetic#CreateNetworkInsightsAccessScopeOutput$NetworkInsightsAccessScopeContent */ =>  {
                let var_131 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_access_scope_content(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_content(var_131);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_network_insights_path(
    inp: &[u8],
    mut builder: crate::output::create_network_insights_path_output::Builder,
) -> Result<
    crate::output::create_network_insights_path_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNetworkInsightsPathResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNetworkInsightsPathResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsPath") /* NetworkInsightsPath com.amazonaws.ec2.synthetic#CreateNetworkInsightsPathOutput$NetworkInsightsPath */ =>  {
                let var_132 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_path(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_path(var_132);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_network_interface(
    inp: &[u8],
    mut builder: crate::output::create_network_interface_output::Builder,
) -> Result<crate::output::create_network_interface_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNetworkInterfaceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNetworkInterfaceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInterface") /* NetworkInterface com.amazonaws.ec2.synthetic#CreateNetworkInterfaceOutput$NetworkInterface */ =>  {
                let var_133 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_interface(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_interface(var_133);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateNetworkInterfaceOutput$ClientToken */ =>  {
                let var_134 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_134);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_network_interface_permission(
    inp: &[u8],
    mut builder: crate::output::create_network_interface_permission_output::Builder,
) -> Result<
    crate::output::create_network_interface_permission_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateNetworkInterfacePermissionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateNetworkInterfacePermissionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("interfacePermission") /* InterfacePermission com.amazonaws.ec2.synthetic#CreateNetworkInterfacePermissionOutput$InterfacePermission */ =>  {
                let var_135 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_interface_permission(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_interface_permission(var_135);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_placement_group(
    inp: &[u8],
    mut builder: crate::output::create_placement_group_output::Builder,
) -> Result<crate::output::create_placement_group_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreatePlacementGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreatePlacementGroupResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("placementGroup") /* PlacementGroup com.amazonaws.ec2.synthetic#CreatePlacementGroupOutput$PlacementGroup */ =>  {
                let var_136 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_placement_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_placement_group(var_136);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_public_ipv4_pool(
    inp: &[u8],
    mut builder: crate::output::create_public_ipv4_pool_output::Builder,
) -> Result<crate::output::create_public_ipv4_pool_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreatePublicIpv4PoolResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreatePublicIpv4PoolResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("poolId") /* PoolId com.amazonaws.ec2.synthetic#CreatePublicIpv4PoolOutput$PoolId */ =>  {
                let var_137 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_pool_id(var_137);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_replace_root_volume_task(
    inp: &[u8],
    mut builder: crate::output::create_replace_root_volume_task_output::Builder,
) -> Result<
    crate::output::create_replace_root_volume_task_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateReplaceRootVolumeTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateReplaceRootVolumeTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("replaceRootVolumeTask") /* ReplaceRootVolumeTask com.amazonaws.ec2.synthetic#CreateReplaceRootVolumeTaskOutput$ReplaceRootVolumeTask */ =>  {
                let var_138 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_replace_root_volume_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_replace_root_volume_task(var_138);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_reserved_instances_listing(
    inp: &[u8],
    mut builder: crate::output::create_reserved_instances_listing_output::Builder,
) -> Result<
    crate::output::create_reserved_instances_listing_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateReservedInstancesListingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateReservedInstancesListingResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesListingsSet") /* ReservedInstancesListings com.amazonaws.ec2.synthetic#CreateReservedInstancesListingOutput$ReservedInstancesListings */ =>  {
                let var_139 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_listing_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_listings(var_139);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_restore_image_task(
    inp: &[u8],
    mut builder: crate::output::create_restore_image_task_output::Builder,
) -> Result<
    crate::output::create_restore_image_task_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateRestoreImageTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateRestoreImageTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#CreateRestoreImageTaskOutput$ImageId */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_140);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_route(
    inp: &[u8],
    mut builder: crate::output::create_route_output::Builder,
) -> Result<crate::output::create_route_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#CreateRouteOutput$Return */ =>  {
                let var_141 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_141);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_route_table(
    inp: &[u8],
    mut builder: crate::output::create_route_table_output::Builder,
) -> Result<crate::output::create_route_table_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("routeTable") /* RouteTable com.amazonaws.ec2.synthetic#CreateRouteTableOutput$RouteTable */ =>  {
                let var_142 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_route_table(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route_table(var_142);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_security_group(
    inp: &[u8],
    mut builder: crate::output::create_security_group_output::Builder,
) -> Result<crate::output::create_security_group_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSecurityGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSecurityGroupResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("groupId") /* GroupId com.amazonaws.ec2.synthetic#CreateSecurityGroupOutput$GroupId */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_id(var_143);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CreateSecurityGroupOutput$Tags */ =>  {
                let var_144 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_144);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_snapshot(
    inp: &[u8],
    mut builder: crate::output::create_snapshot_output::Builder,
) -> Result<crate::output::create_snapshot_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSnapshotResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("dataEncryptionKeyId") /* DataEncryptionKeyId com.amazonaws.ec2.synthetic#CreateSnapshotOutput$DataEncryptionKeyId */ =>  {
                let var_145 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_encryption_key_id(var_145);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#CreateSnapshotOutput$Description */ =>  {
                let var_146 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_146);
            }
            ,
            s if s.matches("encrypted") /* Encrypted com.amazonaws.ec2.synthetic#CreateSnapshotOutput$Encrypted */ =>  {
                let var_147 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_147);
            }
            ,
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#CreateSnapshotOutput$KmsKeyId */ =>  {
                let var_148 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_148);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2.synthetic#CreateSnapshotOutput$OwnerId */ =>  {
                let var_149 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_149);
            }
            ,
            s if s.matches("progress") /* Progress com.amazonaws.ec2.synthetic#CreateSnapshotOutput$Progress */ =>  {
                let var_150 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_progress(var_150);
            }
            ,
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#CreateSnapshotOutput$SnapshotId */ =>  {
                let var_151 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_151);
            }
            ,
            s if s.matches("startTime") /* StartTime com.amazonaws.ec2.synthetic#CreateSnapshotOutput$StartTime */ =>  {
                let var_152 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_152);
            }
            ,
            s if s.matches("status") /* State com.amazonaws.ec2.synthetic#CreateSnapshotOutput$State */ =>  {
                let var_153 =
                    Some(
                        Result::<crate::model::SnapshotState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SnapshotState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_153);
            }
            ,
            s if s.matches("statusMessage") /* StateMessage com.amazonaws.ec2.synthetic#CreateSnapshotOutput$StateMessage */ =>  {
                let var_154 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state_message(var_154);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#CreateSnapshotOutput$VolumeId */ =>  {
                let var_155 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_155);
            }
            ,
            s if s.matches("volumeSize") /* VolumeSize com.amazonaws.ec2.synthetic#CreateSnapshotOutput$VolumeSize */ =>  {
                let var_156 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_volume_size(var_156);
            }
            ,
            s if s.matches("ownerAlias") /* OwnerAlias com.amazonaws.ec2.synthetic#CreateSnapshotOutput$OwnerAlias */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_alias(var_157);
            }
            ,
            s if s.matches("outpostArn") /* OutpostArn com.amazonaws.ec2.synthetic#CreateSnapshotOutput$OutpostArn */ =>  {
                let var_158 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_arn(var_158);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CreateSnapshotOutput$Tags */ =>  {
                let var_159 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_159);
            }
            ,
            s if s.matches("storageTier") /* StorageTier com.amazonaws.ec2.synthetic#CreateSnapshotOutput$StorageTier */ =>  {
                let var_160 =
                    Some(
                        Result::<crate::model::StorageTier, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageTier::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_tier(var_160);
            }
            ,
            s if s.matches("restoreExpiryTime") /* RestoreExpiryTime com.amazonaws.ec2.synthetic#CreateSnapshotOutput$RestoreExpiryTime */ =>  {
                let var_161 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_restore_expiry_time(var_161);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_snapshots(
    inp: &[u8],
    mut builder: crate::output::create_snapshots_output::Builder,
) -> Result<crate::output::create_snapshots_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSnapshotsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSnapshotsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotSet") /* Snapshots com.amazonaws.ec2.synthetic#CreateSnapshotsOutput$Snapshots */ =>  {
                let var_162 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_snapshot_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshots(var_162);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_spot_datafeed_subscription(
    inp: &[u8],
    mut builder: crate::output::create_spot_datafeed_subscription_output::Builder,
) -> Result<
    crate::output::create_spot_datafeed_subscription_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSpotDatafeedSubscriptionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSpotDatafeedSubscriptionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotDatafeedSubscription") /* SpotDatafeedSubscription com.amazonaws.ec2.synthetic#CreateSpotDatafeedSubscriptionOutput$SpotDatafeedSubscription */ =>  {
                let var_163 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_spot_datafeed_subscription(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_datafeed_subscription(var_163);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_store_image_task(
    inp: &[u8],
    mut builder: crate::output::create_store_image_task_output::Builder,
) -> Result<crate::output::create_store_image_task_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateStoreImageTaskResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateStoreImageTaskResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("objectKey") /* ObjectKey com.amazonaws.ec2.synthetic#CreateStoreImageTaskOutput$ObjectKey */ =>  {
                let var_164 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_key(var_164);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_subnet(
    inp: &[u8],
    mut builder: crate::output::create_subnet_output::Builder,
) -> Result<crate::output::create_subnet_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSubnetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSubnetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("subnet") /* Subnet com.amazonaws.ec2.synthetic#CreateSubnetOutput$Subnet */ =>  {
                let var_165 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet(var_165);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_subnet_cidr_reservation(
    inp: &[u8],
    mut builder: crate::output::create_subnet_cidr_reservation_output::Builder,
) -> Result<
    crate::output::create_subnet_cidr_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSubnetCidrReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSubnetCidrReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("subnetCidrReservation") /* SubnetCidrReservation com.amazonaws.ec2.synthetic#CreateSubnetCidrReservationOutput$SubnetCidrReservation */ =>  {
                let var_166 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet_cidr_reservation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet_cidr_reservation(var_166);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_traffic_mirror_filter(
    inp: &[u8],
    mut builder: crate::output::create_traffic_mirror_filter_output::Builder,
) -> Result<
    crate::output::create_traffic_mirror_filter_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTrafficMirrorFilterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTrafficMirrorFilterResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilter") /* TrafficMirrorFilter com.amazonaws.ec2.synthetic#CreateTrafficMirrorFilterOutput$TrafficMirrorFilter */ =>  {
                let var_167 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter(var_167);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateTrafficMirrorFilterOutput$ClientToken */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_168);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_traffic_mirror_filter_rule(
    inp: &[u8],
    mut builder: crate::output::create_traffic_mirror_filter_rule_output::Builder,
) -> Result<
    crate::output::create_traffic_mirror_filter_rule_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTrafficMirrorFilterRuleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTrafficMirrorFilterRuleResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilterRule") /* TrafficMirrorFilterRule com.amazonaws.ec2.synthetic#CreateTrafficMirrorFilterRuleOutput$TrafficMirrorFilterRule */ =>  {
                let var_169 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_filter_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter_rule(var_169);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateTrafficMirrorFilterRuleOutput$ClientToken */ =>  {
                let var_170 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_170);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_traffic_mirror_session(
    inp: &[u8],
    mut builder: crate::output::create_traffic_mirror_session_output::Builder,
) -> Result<
    crate::output::create_traffic_mirror_session_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTrafficMirrorSessionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTrafficMirrorSessionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorSession") /* TrafficMirrorSession com.amazonaws.ec2.synthetic#CreateTrafficMirrorSessionOutput$TrafficMirrorSession */ =>  {
                let var_171 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_session(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_session(var_171);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateTrafficMirrorSessionOutput$ClientToken */ =>  {
                let var_172 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_172);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_traffic_mirror_target(
    inp: &[u8],
    mut builder: crate::output::create_traffic_mirror_target_output::Builder,
) -> Result<
    crate::output::create_traffic_mirror_target_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTrafficMirrorTargetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTrafficMirrorTargetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorTarget") /* TrafficMirrorTarget com.amazonaws.ec2.synthetic#CreateTrafficMirrorTargetOutput$TrafficMirrorTarget */ =>  {
                let var_173 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_target(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_target(var_173);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateTrafficMirrorTargetOutput$ClientToken */ =>  {
                let var_174 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_174);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_output::Builder,
) -> Result<crate::output::create_transit_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGateway") /* TransitGateway com.amazonaws.ec2.synthetic#CreateTransitGatewayOutput$TransitGateway */ =>  {
                let var_175 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway(var_175);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_connect(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_connect_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_connect_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayConnectResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayConnectResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnect") /* TransitGatewayConnect com.amazonaws.ec2.synthetic#CreateTransitGatewayConnectOutput$TransitGatewayConnect */ =>  {
                let var_176 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_connect(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connect(var_176);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_connect_peer(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_connect_peer_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_connect_peer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayConnectPeerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayConnectPeerResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnectPeer") /* TransitGatewayConnectPeer com.amazonaws.ec2.synthetic#CreateTransitGatewayConnectPeerOutput$TransitGatewayConnectPeer */ =>  {
                let var_177 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_connect_peer(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connect_peer(var_177);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_multicast_domain(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_multicast_domain_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_multicast_domain_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayMulticastDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayMulticastDomainResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayMulticastDomain") /* TransitGatewayMulticastDomain com.amazonaws.ec2.synthetic#CreateTransitGatewayMulticastDomainOutput$TransitGatewayMulticastDomain */ =>  {
                let var_178 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_multicast_domain(var_178);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_peering_attachment(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_peering_attachment_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_peering_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayPeeringAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayPeeringAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPeeringAttachment") /* TransitGatewayPeeringAttachment com.amazonaws.ec2.synthetic#CreateTransitGatewayPeeringAttachmentOutput$TransitGatewayPeeringAttachment */ =>  {
                let var_179 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_peering_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_peering_attachment(var_179);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_prefix_list_reference(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_prefix_list_reference_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_prefix_list_reference_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayPrefixListReferenceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayPrefixListReferenceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPrefixListReference") /* TransitGatewayPrefixListReference com.amazonaws.ec2.synthetic#CreateTransitGatewayPrefixListReferenceOutput$TransitGatewayPrefixListReference */ =>  {
                let var_180 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_prefix_list_reference(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_prefix_list_reference(var_180);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_route(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_route_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_route_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("route") /* Route com.amazonaws.ec2.synthetic#CreateTransitGatewayRouteOutput$Route */ =>  {
                let var_181 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_route(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route(var_181);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_route_table(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_route_table_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_route_table_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayRouteTable") /* TransitGatewayRouteTable com.amazonaws.ec2.synthetic#CreateTransitGatewayRouteTableOutput$TransitGatewayRouteTable */ =>  {
                let var_182 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_route_table(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_route_table(var_182);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_transit_gateway_vpc_attachment(
    inp: &[u8],
    mut builder: crate::output::create_transit_gateway_vpc_attachment_output::Builder,
) -> Result<
    crate::output::create_transit_gateway_vpc_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateTransitGatewayVpcAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateTransitGatewayVpcAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachment") /* TransitGatewayVpcAttachment com.amazonaws.ec2.synthetic#CreateTransitGatewayVpcAttachmentOutput$TransitGatewayVpcAttachment */ =>  {
                let var_183 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachment(var_183);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_volume(
    inp: &[u8],
    mut builder: crate::output::create_volume_output::Builder,
) -> Result<crate::output::create_volume_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVolumeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVolumeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachmentSet") /* Attachments com.amazonaws.ec2.synthetic#CreateVolumeOutput$Attachments */ =>  {
                let var_184 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_volume_attachment_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attachments(var_184);
            }
            ,
            s if s.matches("availabilityZone") /* AvailabilityZone com.amazonaws.ec2.synthetic#CreateVolumeOutput$AvailabilityZone */ =>  {
                let var_185 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_185);
            }
            ,
            s if s.matches("createTime") /* CreateTime com.amazonaws.ec2.synthetic#CreateVolumeOutput$CreateTime */ =>  {
                let var_186 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_create_time(var_186);
            }
            ,
            s if s.matches("encrypted") /* Encrypted com.amazonaws.ec2.synthetic#CreateVolumeOutput$Encrypted */ =>  {
                let var_187 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_187);
            }
            ,
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#CreateVolumeOutput$KmsKeyId */ =>  {
                let var_188 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_188);
            }
            ,
            s if s.matches("outpostArn") /* OutpostArn com.amazonaws.ec2.synthetic#CreateVolumeOutput$OutpostArn */ =>  {
                let var_189 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_arn(var_189);
            }
            ,
            s if s.matches("size") /* Size com.amazonaws.ec2.synthetic#CreateVolumeOutput$Size */ =>  {
                let var_190 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_size(var_190);
            }
            ,
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#CreateVolumeOutput$SnapshotId */ =>  {
                let var_191 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_191);
            }
            ,
            s if s.matches("status") /* State com.amazonaws.ec2.synthetic#CreateVolumeOutput$State */ =>  {
                let var_192 =
                    Some(
                        Result::<crate::model::VolumeState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VolumeState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_192);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#CreateVolumeOutput$VolumeId */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_193);
            }
            ,
            s if s.matches("iops") /* Iops com.amazonaws.ec2.synthetic#CreateVolumeOutput$Iops */ =>  {
                let var_194 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_iops(var_194);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#CreateVolumeOutput$Tags */ =>  {
                let var_195 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_195);
            }
            ,
            s if s.matches("volumeType") /* VolumeType com.amazonaws.ec2.synthetic#CreateVolumeOutput$VolumeType */ =>  {
                let var_196 =
                    Some(
                        Result::<crate::model::VolumeType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VolumeType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_type(var_196);
            }
            ,
            s if s.matches("fastRestored") /* FastRestored com.amazonaws.ec2.synthetic#CreateVolumeOutput$FastRestored */ =>  {
                let var_197 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_fast_restored(var_197);
            }
            ,
            s if s.matches("multiAttachEnabled") /* MultiAttachEnabled com.amazonaws.ec2.synthetic#CreateVolumeOutput$MultiAttachEnabled */ =>  {
                let var_198 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_multi_attach_enabled(var_198);
            }
            ,
            s if s.matches("throughput") /* Throughput com.amazonaws.ec2.synthetic#CreateVolumeOutput$Throughput */ =>  {
                let var_199 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_throughput(var_199);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpc(
    inp: &[u8],
    mut builder: crate::output::create_vpc_output::Builder,
) -> Result<crate::output::create_vpc_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpcResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpcResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpc") /* Vpc com.amazonaws.ec2.synthetic#CreateVpcOutput$Vpc */ =>  {
                let var_200 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc(var_200);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpc_endpoint(
    inp: &[u8],
    mut builder: crate::output::create_vpc_endpoint_output::Builder,
) -> Result<crate::output::create_vpc_endpoint_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpcEndpointResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpcEndpointResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcEndpoint") /* VpcEndpoint com.amazonaws.ec2.synthetic#CreateVpcEndpointOutput$VpcEndpoint */ =>  {
                let var_201 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint(var_201);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateVpcEndpointOutput$ClientToken */ =>  {
                let var_202 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_202);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpc_endpoint_connection_notification(
    inp: &[u8],
    mut builder: crate::output::create_vpc_endpoint_connection_notification_output::Builder,
) -> Result<
    crate::output::create_vpc_endpoint_connection_notification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpcEndpointConnectionNotificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpcEndpointConnectionNotificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("connectionNotification") /* ConnectionNotification com.amazonaws.ec2.synthetic#CreateVpcEndpointConnectionNotificationOutput$ConnectionNotification */ =>  {
                let var_203 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_connection_notification(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_connection_notification(var_203);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateVpcEndpointConnectionNotificationOutput$ClientToken */ =>  {
                let var_204 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_204);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpc_endpoint_service_configuration(
    inp: &[u8],
    mut builder: crate::output::create_vpc_endpoint_service_configuration_output::Builder,
) -> Result<
    crate::output::create_vpc_endpoint_service_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpcEndpointServiceConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpcEndpointServiceConfigurationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serviceConfiguration") /* ServiceConfiguration com.amazonaws.ec2.synthetic#CreateVpcEndpointServiceConfigurationOutput$ServiceConfiguration */ =>  {
                let var_205 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_service_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_configuration(var_205);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#CreateVpcEndpointServiceConfigurationOutput$ClientToken */ =>  {
                let var_206 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_206);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpc_peering_connection(
    inp: &[u8],
    mut builder: crate::output::create_vpc_peering_connection_output::Builder,
) -> Result<
    crate::output::create_vpc_peering_connection_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpcPeeringConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpcPeeringConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcPeeringConnection") /* VpcPeeringConnection com.amazonaws.ec2.synthetic#CreateVpcPeeringConnectionOutput$VpcPeeringConnection */ =>  {
                let var_207 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_peering_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_peering_connection(var_207);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpn_connection(
    inp: &[u8],
    mut builder: crate::output::create_vpn_connection_output::Builder,
) -> Result<crate::output::create_vpn_connection_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpnConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpnConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnection") /* VpnConnection com.amazonaws.ec2.synthetic#CreateVpnConnectionOutput$VpnConnection */ =>  {
                let var_208 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection(var_208);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_vpn_gateway(
    inp: &[u8],
    mut builder: crate::output::create_vpn_gateway_output::Builder,
) -> Result<crate::output::create_vpn_gateway_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVpnGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVpnGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnGateway") /* VpnGateway com.amazonaws.ec2.synthetic#CreateVpnGatewayOutput$VpnGateway */ =>  {
                let var_209 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_gateway(var_209);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_carrier_gateway(
    inp: &[u8],
    mut builder: crate::output::delete_carrier_gateway_output::Builder,
) -> Result<crate::output::delete_carrier_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteCarrierGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteCarrierGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("carrierGateway") /* CarrierGateway com.amazonaws.ec2.synthetic#DeleteCarrierGatewayOutput$CarrierGateway */ =>  {
                let var_210 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_carrier_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_carrier_gateway(var_210);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_client_vpn_endpoint(
    inp: &[u8],
    mut builder: crate::output::delete_client_vpn_endpoint_output::Builder,
) -> Result<
    crate::output::delete_client_vpn_endpoint_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteClientVpnEndpointResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteClientVpnEndpointResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#DeleteClientVpnEndpointOutput$Status */ =>  {
                let var_211 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_endpoint_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_211);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_client_vpn_route(
    inp: &[u8],
    mut builder: crate::output::delete_client_vpn_route_output::Builder,
) -> Result<crate::output::delete_client_vpn_route_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteClientVpnRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteClientVpnRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#DeleteClientVpnRouteOutput$Status */ =>  {
                let var_212 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_route_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_212);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_egress_only_internet_gateway(
    inp: &[u8],
    mut builder: crate::output::delete_egress_only_internet_gateway_output::Builder,
) -> Result<
    crate::output::delete_egress_only_internet_gateway_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteEgressOnlyInternetGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteEgressOnlyInternetGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("returnCode") /* ReturnCode com.amazonaws.ec2.synthetic#DeleteEgressOnlyInternetGatewayOutput$ReturnCode */ =>  {
                let var_213 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_code(var_213);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_fleets(
    inp: &[u8],
    mut builder: crate::output::delete_fleets_output::Builder,
) -> Result<crate::output::delete_fleets_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteFleetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteFleetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfulFleetDeletionSet") /* SuccessfulFleetDeletions com.amazonaws.ec2.synthetic#DeleteFleetsOutput$SuccessfulFleetDeletions */ =>  {
                let var_214 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_delete_fleet_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful_fleet_deletions(var_214);
            }
            ,
            s if s.matches("unsuccessfulFleetDeletionSet") /* UnsuccessfulFleetDeletions com.amazonaws.ec2.synthetic#DeleteFleetsOutput$UnsuccessfulFleetDeletions */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_delete_fleet_error_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful_fleet_deletions(var_215);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_flow_logs(
    inp: &[u8],
    mut builder: crate::output::delete_flow_logs_output::Builder,
) -> Result<crate::output::delete_flow_logs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteFlowLogsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteFlowLogsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#DeleteFlowLogsOutput$Unsuccessful */ =>  {
                let var_216 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_216);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_fpga_image(
    inp: &[u8],
    mut builder: crate::output::delete_fpga_image_output::Builder,
) -> Result<crate::output::delete_fpga_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteFpgaImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteFpgaImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DeleteFpgaImageOutput$Return */ =>  {
                let var_217 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_217);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_instance_event_window(
    inp: &[u8],
    mut builder: crate::output::delete_instance_event_window_output::Builder,
) -> Result<
    crate::output::delete_instance_event_window_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteInstanceEventWindowResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteInstanceEventWindowResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindowState") /* InstanceEventWindowState com.amazonaws.ec2.synthetic#DeleteInstanceEventWindowOutput$InstanceEventWindowState */ =>  {
                let var_218 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window_state_change(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_window_state(var_218);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_ipam(
    inp: &[u8],
    mut builder: crate::output::delete_ipam_output::Builder,
) -> Result<crate::output::delete_ipam_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteIpamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteIpamResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipam") /* Ipam com.amazonaws.ec2.synthetic#DeleteIpamOutput$Ipam */ =>  {
                let var_219 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam(var_219);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_ipam_pool(
    inp: &[u8],
    mut builder: crate::output::delete_ipam_pool_output::Builder,
) -> Result<crate::output::delete_ipam_pool_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteIpamPoolResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteIpamPoolResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPool") /* IpamPool com.amazonaws.ec2.synthetic#DeleteIpamPoolOutput$IpamPool */ =>  {
                let var_220 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool(var_220);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_ipam_scope(
    inp: &[u8],
    mut builder: crate::output::delete_ipam_scope_output::Builder,
) -> Result<crate::output::delete_ipam_scope_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteIpamScopeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteIpamScopeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamScope") /* IpamScope com.amazonaws.ec2.synthetic#DeleteIpamScopeOutput$IpamScope */ =>  {
                let var_221 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_scope(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_scope(var_221);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_launch_template(
    inp: &[u8],
    mut builder: crate::output::delete_launch_template_output::Builder,
) -> Result<crate::output::delete_launch_template_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteLaunchTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteLaunchTemplateResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplate") /* LaunchTemplate com.amazonaws.ec2.synthetic#DeleteLaunchTemplateOutput$LaunchTemplate */ =>  {
                let var_222 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_launch_template(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template(var_222);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_launch_template_versions(
    inp: &[u8],
    mut builder: crate::output::delete_launch_template_versions_output::Builder,
) -> Result<
    crate::output::delete_launch_template_versions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteLaunchTemplateVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteLaunchTemplateVersionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfullyDeletedLaunchTemplateVersionSet") /* SuccessfullyDeletedLaunchTemplateVersions com.amazonaws.ec2.synthetic#DeleteLaunchTemplateVersionsOutput$SuccessfullyDeletedLaunchTemplateVersions */ =>  {
                let var_223 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_delete_launch_template_versions_response_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successfully_deleted_launch_template_versions(var_223);
            }
            ,
            s if s.matches("unsuccessfullyDeletedLaunchTemplateVersionSet") /* UnsuccessfullyDeletedLaunchTemplateVersions com.amazonaws.ec2.synthetic#DeleteLaunchTemplateVersionsOutput$UnsuccessfullyDeletedLaunchTemplateVersions */ =>  {
                let var_224 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_delete_launch_template_versions_response_error_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessfully_deleted_launch_template_versions(var_224);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_local_gateway_route(
    inp: &[u8],
    mut builder: crate::output::delete_local_gateway_route_output::Builder,
) -> Result<
    crate::output::delete_local_gateway_route_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteLocalGatewayRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteLocalGatewayRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("route") /* Route com.amazonaws.ec2.synthetic#DeleteLocalGatewayRouteOutput$Route */ =>  {
                let var_225 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_local_gateway_route(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route(var_225);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_local_gateway_route_table_vpc_association(
    inp: &[u8],
    mut builder: crate::output::delete_local_gateway_route_table_vpc_association_output::Builder,
) -> Result<
    crate::output::delete_local_gateway_route_table_vpc_association_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteLocalGatewayRouteTableVpcAssociationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteLocalGatewayRouteTableVpcAssociationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayRouteTableVpcAssociation") /* LocalGatewayRouteTableVpcAssociation com.amazonaws.ec2.synthetic#DeleteLocalGatewayRouteTableVpcAssociationOutput$LocalGatewayRouteTableVpcAssociation */ =>  {
                let var_226 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_local_gateway_route_table_vpc_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_table_vpc_association(var_226);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_managed_prefix_list(
    inp: &[u8],
    mut builder: crate::output::delete_managed_prefix_list_output::Builder,
) -> Result<
    crate::output::delete_managed_prefix_list_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteManagedPrefixListResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteManagedPrefixListResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("prefixList") /* PrefixList com.amazonaws.ec2.synthetic#DeleteManagedPrefixListOutput$PrefixList */ =>  {
                let var_227 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_managed_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_list(var_227);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_nat_gateway(
    inp: &[u8],
    mut builder: crate::output::delete_nat_gateway_output::Builder,
) -> Result<crate::output::delete_nat_gateway_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNatGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNatGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("natGatewayId") /* NatGatewayId com.amazonaws.ec2.synthetic#DeleteNatGatewayOutput$NatGatewayId */ =>  {
                let var_228 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_nat_gateway_id(var_228);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_network_insights_access_scope(
    inp: &[u8],
    mut builder: crate::output::delete_network_insights_access_scope_output::Builder,
) -> Result<
    crate::output::delete_network_insights_access_scope_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNetworkInsightsAccessScopeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNetworkInsightsAccessScopeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeId") /* NetworkInsightsAccessScopeId com.amazonaws.ec2.synthetic#DeleteNetworkInsightsAccessScopeOutput$NetworkInsightsAccessScopeId */ =>  {
                let var_229 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_id(var_229);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_network_insights_access_scope_analysis(
    inp: &[u8],
    mut builder: crate::output::delete_network_insights_access_scope_analysis_output::Builder,
) -> Result<
    crate::output::delete_network_insights_access_scope_analysis_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNetworkInsightsAccessScopeAnalysisResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNetworkInsightsAccessScopeAnalysisResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeAnalysisId") /* NetworkInsightsAccessScopeAnalysisId com.amazonaws.ec2.synthetic#DeleteNetworkInsightsAccessScopeAnalysisOutput$NetworkInsightsAccessScopeAnalysisId */ =>  {
                let var_230 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_analysis_id(var_230);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_network_insights_analysis(
    inp: &[u8],
    mut builder: crate::output::delete_network_insights_analysis_output::Builder,
) -> Result<
    crate::output::delete_network_insights_analysis_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNetworkInsightsAnalysisResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNetworkInsightsAnalysisResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAnalysisId") /* NetworkInsightsAnalysisId com.amazonaws.ec2.synthetic#DeleteNetworkInsightsAnalysisOutput$NetworkInsightsAnalysisId */ =>  {
                let var_231 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_insights_analysis_id(var_231);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_network_insights_path(
    inp: &[u8],
    mut builder: crate::output::delete_network_insights_path_output::Builder,
) -> Result<
    crate::output::delete_network_insights_path_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNetworkInsightsPathResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNetworkInsightsPathResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsPathId") /* NetworkInsightsPathId com.amazonaws.ec2.synthetic#DeleteNetworkInsightsPathOutput$NetworkInsightsPathId */ =>  {
                let var_232 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_insights_path_id(var_232);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_network_interface_permission(
    inp: &[u8],
    mut builder: crate::output::delete_network_interface_permission_output::Builder,
) -> Result<
    crate::output::delete_network_interface_permission_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteNetworkInterfacePermissionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteNetworkInterfacePermissionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DeleteNetworkInterfacePermissionOutput$Return */ =>  {
                let var_233 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_233);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_public_ipv4_pool(
    inp: &[u8],
    mut builder: crate::output::delete_public_ipv4_pool_output::Builder,
) -> Result<crate::output::delete_public_ipv4_pool_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeletePublicIpv4PoolResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeletePublicIpv4PoolResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("returnValue") /* ReturnValue com.amazonaws.ec2.synthetic#DeletePublicIpv4PoolOutput$ReturnValue */ =>  {
                let var_234 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_234);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_queued_reserved_instances(
    inp: &[u8],
    mut builder: crate::output::delete_queued_reserved_instances_output::Builder,
) -> Result<
    crate::output::delete_queued_reserved_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteQueuedReservedInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteQueuedReservedInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfulQueuedPurchaseDeletionSet") /* SuccessfulQueuedPurchaseDeletions com.amazonaws.ec2.synthetic#DeleteQueuedReservedInstancesOutput$SuccessfulQueuedPurchaseDeletions */ =>  {
                let var_235 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_successful_queued_purchase_deletion_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful_queued_purchase_deletions(var_235);
            }
            ,
            s if s.matches("failedQueuedPurchaseDeletionSet") /* FailedQueuedPurchaseDeletions com.amazonaws.ec2.synthetic#DeleteQueuedReservedInstancesOutput$FailedQueuedPurchaseDeletions */ =>  {
                let var_236 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_failed_queued_purchase_deletion_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failed_queued_purchase_deletions(var_236);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_subnet_cidr_reservation(
    inp: &[u8],
    mut builder: crate::output::delete_subnet_cidr_reservation_output::Builder,
) -> Result<
    crate::output::delete_subnet_cidr_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteSubnetCidrReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteSubnetCidrReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("deletedSubnetCidrReservation") /* DeletedSubnetCidrReservation com.amazonaws.ec2.synthetic#DeleteSubnetCidrReservationOutput$DeletedSubnetCidrReservation */ =>  {
                let var_237 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet_cidr_reservation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deleted_subnet_cidr_reservation(var_237);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_traffic_mirror_filter(
    inp: &[u8],
    mut builder: crate::output::delete_traffic_mirror_filter_output::Builder,
) -> Result<
    crate::output::delete_traffic_mirror_filter_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTrafficMirrorFilterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTrafficMirrorFilterResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilterId") /* TrafficMirrorFilterId com.amazonaws.ec2.synthetic#DeleteTrafficMirrorFilterOutput$TrafficMirrorFilterId */ =>  {
                let var_238 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter_id(var_238);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_traffic_mirror_filter_rule(
    inp: &[u8],
    mut builder: crate::output::delete_traffic_mirror_filter_rule_output::Builder,
) -> Result<
    crate::output::delete_traffic_mirror_filter_rule_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTrafficMirrorFilterRuleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTrafficMirrorFilterRuleResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilterRuleId") /* TrafficMirrorFilterRuleId com.amazonaws.ec2.synthetic#DeleteTrafficMirrorFilterRuleOutput$TrafficMirrorFilterRuleId */ =>  {
                let var_239 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter_rule_id(var_239);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_traffic_mirror_session(
    inp: &[u8],
    mut builder: crate::output::delete_traffic_mirror_session_output::Builder,
) -> Result<
    crate::output::delete_traffic_mirror_session_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTrafficMirrorSessionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTrafficMirrorSessionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorSessionId") /* TrafficMirrorSessionId com.amazonaws.ec2.synthetic#DeleteTrafficMirrorSessionOutput$TrafficMirrorSessionId */ =>  {
                let var_240 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_session_id(var_240);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_traffic_mirror_target(
    inp: &[u8],
    mut builder: crate::output::delete_traffic_mirror_target_output::Builder,
) -> Result<
    crate::output::delete_traffic_mirror_target_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTrafficMirrorTargetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTrafficMirrorTargetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorTargetId") /* TrafficMirrorTargetId com.amazonaws.ec2.synthetic#DeleteTrafficMirrorTargetOutput$TrafficMirrorTargetId */ =>  {
                let var_241 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_target_id(var_241);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_output::Builder,
) -> Result<crate::output::delete_transit_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGateway") /* TransitGateway com.amazonaws.ec2.synthetic#DeleteTransitGatewayOutput$TransitGateway */ =>  {
                let var_242 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway(var_242);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_connect(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_connect_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_connect_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayConnectResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayConnectResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnect") /* TransitGatewayConnect com.amazonaws.ec2.synthetic#DeleteTransitGatewayConnectOutput$TransitGatewayConnect */ =>  {
                let var_243 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_connect(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connect(var_243);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_connect_peer(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_connect_peer_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_connect_peer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayConnectPeerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayConnectPeerResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnectPeer") /* TransitGatewayConnectPeer com.amazonaws.ec2.synthetic#DeleteTransitGatewayConnectPeerOutput$TransitGatewayConnectPeer */ =>  {
                let var_244 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_connect_peer(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connect_peer(var_244);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_multicast_domain(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_multicast_domain_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_multicast_domain_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayMulticastDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayMulticastDomainResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayMulticastDomain") /* TransitGatewayMulticastDomain com.amazonaws.ec2.synthetic#DeleteTransitGatewayMulticastDomainOutput$TransitGatewayMulticastDomain */ =>  {
                let var_245 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_multicast_domain(var_245);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_peering_attachment(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_peering_attachment_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_peering_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayPeeringAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayPeeringAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPeeringAttachment") /* TransitGatewayPeeringAttachment com.amazonaws.ec2.synthetic#DeleteTransitGatewayPeeringAttachmentOutput$TransitGatewayPeeringAttachment */ =>  {
                let var_246 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_peering_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_peering_attachment(var_246);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_prefix_list_reference(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_prefix_list_reference_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_prefix_list_reference_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayPrefixListReferenceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayPrefixListReferenceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPrefixListReference") /* TransitGatewayPrefixListReference com.amazonaws.ec2.synthetic#DeleteTransitGatewayPrefixListReferenceOutput$TransitGatewayPrefixListReference */ =>  {
                let var_247 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_prefix_list_reference(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_prefix_list_reference(var_247);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_route(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_route_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_route_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("route") /* Route com.amazonaws.ec2.synthetic#DeleteTransitGatewayRouteOutput$Route */ =>  {
                let var_248 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_route(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route(var_248);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_route_table(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_route_table_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_route_table_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayRouteTable") /* TransitGatewayRouteTable com.amazonaws.ec2.synthetic#DeleteTransitGatewayRouteTableOutput$TransitGatewayRouteTable */ =>  {
                let var_249 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_route_table(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_route_table(var_249);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_transit_gateway_vpc_attachment(
    inp: &[u8],
    mut builder: crate::output::delete_transit_gateway_vpc_attachment_output::Builder,
) -> Result<
    crate::output::delete_transit_gateway_vpc_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteTransitGatewayVpcAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteTransitGatewayVpcAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachment") /* TransitGatewayVpcAttachment com.amazonaws.ec2.synthetic#DeleteTransitGatewayVpcAttachmentOutput$TransitGatewayVpcAttachment */ =>  {
                let var_250 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachment(var_250);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_vpc_endpoint_connection_notifications(
    inp: &[u8],
    mut builder: crate::output::delete_vpc_endpoint_connection_notifications_output::Builder,
) -> Result<
    crate::output::delete_vpc_endpoint_connection_notifications_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteVpcEndpointConnectionNotificationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteVpcEndpointConnectionNotificationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#DeleteVpcEndpointConnectionNotificationsOutput$Unsuccessful */ =>  {
                let var_251 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_251);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_vpc_endpoints(
    inp: &[u8],
    mut builder: crate::output::delete_vpc_endpoints_output::Builder,
) -> Result<crate::output::delete_vpc_endpoints_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteVpcEndpointsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteVpcEndpointsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#DeleteVpcEndpointsOutput$Unsuccessful */ =>  {
                let var_252 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_252);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_vpc_endpoint_service_configurations(
    inp: &[u8],
    mut builder: crate::output::delete_vpc_endpoint_service_configurations_output::Builder,
) -> Result<
    crate::output::delete_vpc_endpoint_service_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteVpcEndpointServiceConfigurationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteVpcEndpointServiceConfigurationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#DeleteVpcEndpointServiceConfigurationsOutput$Unsuccessful */ =>  {
                let var_253 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_253);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_vpc_peering_connection(
    inp: &[u8],
    mut builder: crate::output::delete_vpc_peering_connection_output::Builder,
) -> Result<
    crate::output::delete_vpc_peering_connection_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteVpcPeeringConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteVpcPeeringConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DeleteVpcPeeringConnectionOutput$Return */ =>  {
                let var_254 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_254);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deprovision_byoip_cidr(
    inp: &[u8],
    mut builder: crate::output::deprovision_byoip_cidr_output::Builder,
) -> Result<crate::output::deprovision_byoip_cidr_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeprovisionByoipCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeprovisionByoipCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidr") /* ByoipCidr com.amazonaws.ec2.synthetic#DeprovisionByoipCidrOutput$ByoipCidr */ =>  {
                let var_255 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_byoip_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidr(var_255);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deprovision_ipam_pool_cidr(
    inp: &[u8],
    mut builder: crate::output::deprovision_ipam_pool_cidr_output::Builder,
) -> Result<
    crate::output::deprovision_ipam_pool_cidr_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeprovisionIpamPoolCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeprovisionIpamPoolCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPoolCidr") /* IpamPoolCidr com.amazonaws.ec2.synthetic#DeprovisionIpamPoolCidrOutput$IpamPoolCidr */ =>  {
                let var_256 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_cidr(var_256);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deprovision_public_ipv4_pool_cidr(
    inp: &[u8],
    mut builder: crate::output::deprovision_public_ipv4_pool_cidr_output::Builder,
) -> Result<
    crate::output::deprovision_public_ipv4_pool_cidr_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeprovisionPublicIpv4PoolCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeprovisionPublicIpv4PoolCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("poolId") /* PoolId com.amazonaws.ec2.synthetic#DeprovisionPublicIpv4PoolCidrOutput$PoolId */ =>  {
                let var_257 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_pool_id(var_257);
            }
            ,
            s if s.matches("deprovisionedAddressSet") /* DeprovisionedAddresses com.amazonaws.ec2.synthetic#DeprovisionPublicIpv4PoolCidrOutput$DeprovisionedAddresses */ =>  {
                let var_258 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_deprovisioned_address_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deprovisioned_addresses(var_258);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deregister_instance_event_notification_attributes(
    inp: &[u8],
    mut builder: crate::output::deregister_instance_event_notification_attributes_output::Builder,
) -> Result<
    crate::output::deregister_instance_event_notification_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeregisterInstanceEventNotificationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeregisterInstanceEventNotificationAttributesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTagAttribute") /* InstanceTagAttribute com.amazonaws.ec2.synthetic#DeregisterInstanceEventNotificationAttributesOutput$InstanceTagAttribute */ =>  {
                let var_259 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_tag_notification_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_tag_attribute(var_259);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deregister_transit_gateway_multicast_group_members(
    inp: &[u8],
    mut builder: crate::output::deregister_transit_gateway_multicast_group_members_output::Builder,
) -> Result<
    crate::output::deregister_transit_gateway_multicast_group_members_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeregisterTransitGatewayMulticastGroupMembersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeregisterTransitGatewayMulticastGroupMembersResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("deregisteredMulticastGroupMembers") /* DeregisteredMulticastGroupMembers com.amazonaws.ec2.synthetic#DeregisterTransitGatewayMulticastGroupMembersOutput$DeregisteredMulticastGroupMembers */ =>  {
                let var_260 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_deregistered_group_members(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deregistered_multicast_group_members(var_260);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deregister_transit_gateway_multicast_group_sources(
    inp: &[u8],
    mut builder: crate::output::deregister_transit_gateway_multicast_group_sources_output::Builder,
) -> Result<
    crate::output::deregister_transit_gateway_multicast_group_sources_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeregisterTransitGatewayMulticastGroupSourcesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeregisterTransitGatewayMulticastGroupSourcesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("deregisteredMulticastGroupSources") /* DeregisteredMulticastGroupSources com.amazonaws.ec2.synthetic#DeregisterTransitGatewayMulticastGroupSourcesOutput$DeregisteredMulticastGroupSources */ =>  {
                let var_261 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_deregistered_group_sources(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deregistered_multicast_group_sources(var_261);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_account_attributes(
    inp: &[u8],
    mut builder: crate::output::describe_account_attributes_output::Builder,
) -> Result<
    crate::output::describe_account_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAccountAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAccountAttributesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("accountAttributeSet") /* AccountAttributes com.amazonaws.ec2.synthetic#DescribeAccountAttributesOutput$AccountAttributes */ =>  {
                let var_262 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_account_attribute_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_account_attributes(var_262);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_addresses(
    inp: &[u8],
    mut builder: crate::output::describe_addresses_output::Builder,
) -> Result<crate::output::describe_addresses_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAddressesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("addressesSet") /* Addresses com.amazonaws.ec2.synthetic#DescribeAddressesOutput$Addresses */ =>  {
                let var_263 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_address_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_addresses(var_263);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_addresses_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_addresses_attribute_output::Builder,
) -> Result<
    crate::output::describe_addresses_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAddressesAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAddressesAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("addressSet") /* Addresses com.amazonaws.ec2.synthetic#DescribeAddressesAttributeOutput$Addresses */ =>  {
                let var_264 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_address_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_addresses(var_264);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeAddressesAttributeOutput$NextToken */ =>  {
                let var_265 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_265);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_aggregate_id_format(
    inp: &[u8],
    mut builder: crate::output::describe_aggregate_id_format_output::Builder,
) -> Result<
    crate::output::describe_aggregate_id_format_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAggregateIdFormatResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAggregateIdFormatResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("useLongIdsAggregated") /* UseLongIdsAggregated com.amazonaws.ec2.synthetic#DescribeAggregateIdFormatOutput$UseLongIdsAggregated */ =>  {
                let var_266 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_use_long_ids_aggregated(var_266);
            }
            ,
            s if s.matches("statusSet") /* Statuses com.amazonaws.ec2.synthetic#DescribeAggregateIdFormatOutput$Statuses */ =>  {
                let var_267 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_id_format_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_statuses(var_267);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_availability_zones(
    inp: &[u8],
    mut builder: crate::output::describe_availability_zones_output::Builder,
) -> Result<
    crate::output::describe_availability_zones_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAvailabilityZonesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAvailabilityZonesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("availabilityZoneInfo") /* AvailabilityZones com.amazonaws.ec2.synthetic#DescribeAvailabilityZonesOutput$AvailabilityZones */ =>  {
                let var_268 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_availability_zone_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_availability_zones(var_268);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_bundle_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_bundle_tasks_output::Builder,
) -> Result<crate::output::describe_bundle_tasks_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeBundleTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeBundleTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("bundleInstanceTasksSet") /* BundleTasks com.amazonaws.ec2.synthetic#DescribeBundleTasksOutput$BundleTasks */ =>  {
                let var_269 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_bundle_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bundle_tasks(var_269);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_byoip_cidrs(
    inp: &[u8],
    mut builder: crate::output::describe_byoip_cidrs_output::Builder,
) -> Result<crate::output::describe_byoip_cidrs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeByoipCidrsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeByoipCidrsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidrSet") /* ByoipCidrs com.amazonaws.ec2.synthetic#DescribeByoipCidrsOutput$ByoipCidrs */ =>  {
                let var_270 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_byoip_cidr_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidrs(var_270);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeByoipCidrsOutput$NextToken */ =>  {
                let var_271 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_271);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_capacity_reservation_fleets(
    inp: &[u8],
    mut builder: crate::output::describe_capacity_reservation_fleets_output::Builder,
) -> Result<
    crate::output::describe_capacity_reservation_fleets_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeCapacityReservationFleetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeCapacityReservationFleetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("capacityReservationFleetSet") /* CapacityReservationFleets com.amazonaws.ec2.synthetic#DescribeCapacityReservationFleetsOutput$CapacityReservationFleets */ =>  {
                let var_272 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_capacity_reservation_fleet_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_fleets(var_272);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeCapacityReservationFleetsOutput$NextToken */ =>  {
                let var_273 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_273);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_capacity_reservations(
    inp: &[u8],
    mut builder: crate::output::describe_capacity_reservations_output::Builder,
) -> Result<
    crate::output::describe_capacity_reservations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeCapacityReservationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeCapacityReservationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeCapacityReservationsOutput$NextToken */ =>  {
                let var_274 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_274);
            }
            ,
            s if s.matches("capacityReservationSet") /* CapacityReservations com.amazonaws.ec2.synthetic#DescribeCapacityReservationsOutput$CapacityReservations */ =>  {
                let var_275 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_capacity_reservation_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_capacity_reservations(var_275);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_carrier_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_carrier_gateways_output::Builder,
) -> Result<
    crate::output::describe_carrier_gateways_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeCarrierGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeCarrierGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("carrierGatewaySet") /* CarrierGateways com.amazonaws.ec2.synthetic#DescribeCarrierGatewaysOutput$CarrierGateways */ =>  {
                let var_276 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_carrier_gateway_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_carrier_gateways(var_276);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeCarrierGatewaysOutput$NextToken */ =>  {
                let var_277 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_277);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_classic_link_instances(
    inp: &[u8],
    mut builder: crate::output::describe_classic_link_instances_output::Builder,
) -> Result<
    crate::output::describe_classic_link_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClassicLinkInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClassicLinkInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* Instances com.amazonaws.ec2.synthetic#DescribeClassicLinkInstancesOutput$Instances */ =>  {
                let var_278 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_classic_link_instance_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instances(var_278);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClassicLinkInstancesOutput$NextToken */ =>  {
                let var_279 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_279);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_client_vpn_authorization_rules(
    inp: &[u8],
    mut builder: crate::output::describe_client_vpn_authorization_rules_output::Builder,
) -> Result<
    crate::output::describe_client_vpn_authorization_rules_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClientVpnAuthorizationRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClientVpnAuthorizationRulesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("authorizationRule") /* AuthorizationRules com.amazonaws.ec2.synthetic#DescribeClientVpnAuthorizationRulesOutput$AuthorizationRules */ =>  {
                let var_280 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_authorization_rule_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_authorization_rules(var_280);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClientVpnAuthorizationRulesOutput$NextToken */ =>  {
                let var_281 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_281);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_client_vpn_connections(
    inp: &[u8],
    mut builder: crate::output::describe_client_vpn_connections_output::Builder,
) -> Result<
    crate::output::describe_client_vpn_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClientVpnConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClientVpnConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("connections") /* Connections com.amazonaws.ec2.synthetic#DescribeClientVpnConnectionsOutput$Connections */ =>  {
                let var_282 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_client_vpn_connection_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_connections(var_282);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClientVpnConnectionsOutput$NextToken */ =>  {
                let var_283 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_283);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_client_vpn_endpoints(
    inp: &[u8],
    mut builder: crate::output::describe_client_vpn_endpoints_output::Builder,
) -> Result<
    crate::output::describe_client_vpn_endpoints_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClientVpnEndpointsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClientVpnEndpointsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientVpnEndpoint") /* ClientVpnEndpoints com.amazonaws.ec2.synthetic#DescribeClientVpnEndpointsOutput$ClientVpnEndpoints */ =>  {
                let var_284 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_endpoint_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_client_vpn_endpoints(var_284);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClientVpnEndpointsOutput$NextToken */ =>  {
                let var_285 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_285);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_client_vpn_routes(
    inp: &[u8],
    mut builder: crate::output::describe_client_vpn_routes_output::Builder,
) -> Result<
    crate::output::describe_client_vpn_routes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClientVpnRoutesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClientVpnRoutesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("routes") /* Routes com.amazonaws.ec2.synthetic#DescribeClientVpnRoutesOutput$Routes */ =>  {
                let var_286 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_client_vpn_route_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_routes(var_286);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClientVpnRoutesOutput$NextToken */ =>  {
                let var_287 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_287);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_client_vpn_target_networks(
    inp: &[u8],
    mut builder: crate::output::describe_client_vpn_target_networks_output::Builder,
) -> Result<
    crate::output::describe_client_vpn_target_networks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClientVpnTargetNetworksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClientVpnTargetNetworksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientVpnTargetNetworks") /* ClientVpnTargetNetworks com.amazonaws.ec2.synthetic#DescribeClientVpnTargetNetworksOutput$ClientVpnTargetNetworks */ =>  {
                let var_288 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_target_network_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_client_vpn_target_networks(var_288);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeClientVpnTargetNetworksOutput$NextToken */ =>  {
                let var_289 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_289);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_coip_pools(
    inp: &[u8],
    mut builder: crate::output::describe_coip_pools_output::Builder,
) -> Result<crate::output::describe_coip_pools_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeCoipPoolsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeCoipPoolsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("coipPoolSet") /* CoipPools com.amazonaws.ec2.synthetic#DescribeCoipPoolsOutput$CoipPools */ =>  {
                let var_290 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_coip_pool_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_coip_pools(var_290);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeCoipPoolsOutput$NextToken */ =>  {
                let var_291 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_291);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_conversion_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_conversion_tasks_output::Builder,
) -> Result<
    crate::output::describe_conversion_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeConversionTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeConversionTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("conversionTasks") /* ConversionTasks com.amazonaws.ec2.synthetic#DescribeConversionTasksOutput$ConversionTasks */ =>  {
                let var_292 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_describe_conversion_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_conversion_tasks(var_292);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_customer_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_customer_gateways_output::Builder,
) -> Result<
    crate::output::describe_customer_gateways_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeCustomerGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeCustomerGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("customerGatewaySet") /* CustomerGateways com.amazonaws.ec2.synthetic#DescribeCustomerGatewaysOutput$CustomerGateways */ =>  {
                let var_293 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_customer_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_customer_gateways(var_293);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_dhcp_options(
    inp: &[u8],
    mut builder: crate::output::describe_dhcp_options_output::Builder,
) -> Result<crate::output::describe_dhcp_options_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDhcpOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDhcpOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("dhcpOptionsSet") /* DhcpOptions com.amazonaws.ec2.synthetic#DescribeDhcpOptionsOutput$DhcpOptions */ =>  {
                let var_294 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_dhcp_options_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dhcp_options(var_294);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeDhcpOptionsOutput$NextToken */ =>  {
                let var_295 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_295);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_egress_only_internet_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_egress_only_internet_gateways_output::Builder,
) -> Result<
    crate::output::describe_egress_only_internet_gateways_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEgressOnlyInternetGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEgressOnlyInternetGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("egressOnlyInternetGatewaySet") /* EgressOnlyInternetGateways com.amazonaws.ec2.synthetic#DescribeEgressOnlyInternetGatewaysOutput$EgressOnlyInternetGateways */ =>  {
                let var_296 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_egress_only_internet_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_egress_only_internet_gateways(var_296);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeEgressOnlyInternetGatewaysOutput$NextToken */ =>  {
                let var_297 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_297);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_elastic_gpus(
    inp: &[u8],
    mut builder: crate::output::describe_elastic_gpus_output::Builder,
) -> Result<crate::output::describe_elastic_gpus_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeElasticGpusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeElasticGpusResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("elasticGpuSet") /* ElasticGpuSet com.amazonaws.ec2.synthetic#DescribeElasticGpusOutput$ElasticGpuSet */ =>  {
                let var_298 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_elastic_gpu_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_elastic_gpu_set(var_298);
            }
            ,
            s if s.matches("maxResults") /* MaxResults com.amazonaws.ec2.synthetic#DescribeElasticGpusOutput$MaxResults */ =>  {
                let var_299 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_results(var_299);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeElasticGpusOutput$NextToken */ =>  {
                let var_300 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_300);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_export_image_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_export_image_tasks_output::Builder,
) -> Result<
    crate::output::describe_export_image_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeExportImageTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeExportImageTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("exportImageTaskSet") /* ExportImageTasks com.amazonaws.ec2.synthetic#DescribeExportImageTasksOutput$ExportImageTasks */ =>  {
                let var_301 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_export_image_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_export_image_tasks(var_301);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeExportImageTasksOutput$NextToken */ =>  {
                let var_302 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_302);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_export_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_export_tasks_output::Builder,
) -> Result<crate::output::describe_export_tasks_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeExportTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeExportTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("exportTaskSet") /* ExportTasks com.amazonaws.ec2.synthetic#DescribeExportTasksOutput$ExportTasks */ =>  {
                let var_303 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_export_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_export_tasks(var_303);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fast_snapshot_restores(
    inp: &[u8],
    mut builder: crate::output::describe_fast_snapshot_restores_output::Builder,
) -> Result<
    crate::output::describe_fast_snapshot_restores_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFastSnapshotRestoresResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFastSnapshotRestoresResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fastSnapshotRestoreSet") /* FastSnapshotRestores com.amazonaws.ec2.synthetic#DescribeFastSnapshotRestoresOutput$FastSnapshotRestores */ =>  {
                let var_304 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_describe_fast_snapshot_restore_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fast_snapshot_restores(var_304);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFastSnapshotRestoresOutput$NextToken */ =>  {
                let var_305 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_305);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fleet_history(
    inp: &[u8],
    mut builder: crate::output::describe_fleet_history_output::Builder,
) -> Result<crate::output::describe_fleet_history_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFleetHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFleetHistoryResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("historyRecordSet") /* HistoryRecords com.amazonaws.ec2.synthetic#DescribeFleetHistoryOutput$HistoryRecords */ =>  {
                let var_306 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_history_record_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_history_records(var_306);
            }
            ,
            s if s.matches("lastEvaluatedTime") /* LastEvaluatedTime com.amazonaws.ec2.synthetic#DescribeFleetHistoryOutput$LastEvaluatedTime */ =>  {
                let var_307 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_last_evaluated_time(var_307);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFleetHistoryOutput$NextToken */ =>  {
                let var_308 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_308);
            }
            ,
            s if s.matches("fleetId") /* FleetId com.amazonaws.ec2.synthetic#DescribeFleetHistoryOutput$FleetId */ =>  {
                let var_309 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fleet_id(var_309);
            }
            ,
            s if s.matches("startTime") /* StartTime com.amazonaws.ec2.synthetic#DescribeFleetHistoryOutput$StartTime */ =>  {
                let var_310 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_310);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fleet_instances(
    inp: &[u8],
    mut builder: crate::output::describe_fleet_instances_output::Builder,
) -> Result<crate::output::describe_fleet_instances_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFleetInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFleetInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("activeInstanceSet") /* ActiveInstances com.amazonaws.ec2.synthetic#DescribeFleetInstancesOutput$ActiveInstances */ =>  {
                let var_311 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_active_instance_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_active_instances(var_311);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFleetInstancesOutput$NextToken */ =>  {
                let var_312 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_312);
            }
            ,
            s if s.matches("fleetId") /* FleetId com.amazonaws.ec2.synthetic#DescribeFleetInstancesOutput$FleetId */ =>  {
                let var_313 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fleet_id(var_313);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fleets(
    inp: &[u8],
    mut builder: crate::output::describe_fleets_output::Builder,
) -> Result<crate::output::describe_fleets_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFleetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFleetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFleetsOutput$NextToken */ =>  {
                let var_314 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_314);
            }
            ,
            s if s.matches("fleetSet") /* Fleets com.amazonaws.ec2.synthetic#DescribeFleetsOutput$Fleets */ =>  {
                let var_315 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_fleet_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fleets(var_315);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_flow_logs(
    inp: &[u8],
    mut builder: crate::output::describe_flow_logs_output::Builder,
) -> Result<crate::output::describe_flow_logs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFlowLogsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFlowLogsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("flowLogSet") /* FlowLogs com.amazonaws.ec2.synthetic#DescribeFlowLogsOutput$FlowLogs */ =>  {
                let var_316 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_flow_log_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_flow_logs(var_316);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFlowLogsOutput$NextToken */ =>  {
                let var_317 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_317);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fpga_image_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_fpga_image_attribute_output::Builder,
) -> Result<
    crate::output::describe_fpga_image_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFpgaImageAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFpgaImageAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fpgaImageAttribute") /* FpgaImageAttribute com.amazonaws.ec2.synthetic#DescribeFpgaImageAttributeOutput$FpgaImageAttribute */ =>  {
                let var_318 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_fpga_image_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fpga_image_attribute(var_318);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_fpga_images(
    inp: &[u8],
    mut builder: crate::output::describe_fpga_images_output::Builder,
) -> Result<crate::output::describe_fpga_images_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeFpgaImagesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeFpgaImagesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fpgaImageSet") /* FpgaImages com.amazonaws.ec2.synthetic#DescribeFpgaImagesOutput$FpgaImages */ =>  {
                let var_319 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_fpga_image_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fpga_images(var_319);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeFpgaImagesOutput$NextToken */ =>  {
                let var_320 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_320);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_host_reservation_offerings(
    inp: &[u8],
    mut builder: crate::output::describe_host_reservation_offerings_output::Builder,
) -> Result<
    crate::output::describe_host_reservation_offerings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeHostReservationOfferingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeHostReservationOfferingsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeHostReservationOfferingsOutput$NextToken */ =>  {
                let var_321 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_321);
            }
            ,
            s if s.matches("offeringSet") /* OfferingSet com.amazonaws.ec2.synthetic#DescribeHostReservationOfferingsOutput$OfferingSet */ =>  {
                let var_322 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_host_offering_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_offering_set(var_322);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_host_reservations(
    inp: &[u8],
    mut builder: crate::output::describe_host_reservations_output::Builder,
) -> Result<
    crate::output::describe_host_reservations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeHostReservationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeHostReservationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("hostReservationSet") /* HostReservationSet com.amazonaws.ec2.synthetic#DescribeHostReservationsOutput$HostReservationSet */ =>  {
                let var_323 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_host_reservation_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_host_reservation_set(var_323);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeHostReservationsOutput$NextToken */ =>  {
                let var_324 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_324);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_hosts(
    inp: &[u8],
    mut builder: crate::output::describe_hosts_output::Builder,
) -> Result<crate::output::describe_hosts_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeHostsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeHostsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("hostSet") /* Hosts com.amazonaws.ec2.synthetic#DescribeHostsOutput$Hosts */ =>  {
                let var_325 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_host_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hosts(var_325);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeHostsOutput$NextToken */ =>  {
                let var_326 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_326);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_iam_instance_profile_associations(
    inp: &[u8],
    mut builder: crate::output::describe_iam_instance_profile_associations_output::Builder,
) -> Result<
    crate::output::describe_iam_instance_profile_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIamInstanceProfileAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIamInstanceProfileAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("iamInstanceProfileAssociationSet") /* IamInstanceProfileAssociations com.amazonaws.ec2.synthetic#DescribeIamInstanceProfileAssociationsOutput$IamInstanceProfileAssociations */ =>  {
                let var_327 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_iam_instance_profile_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_instance_profile_associations(var_327);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeIamInstanceProfileAssociationsOutput$NextToken */ =>  {
                let var_328 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_328);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_identity_id_format(
    inp: &[u8],
    mut builder: crate::output::describe_identity_id_format_output::Builder,
) -> Result<
    crate::output::describe_identity_id_format_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIdentityIdFormatResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIdentityIdFormatResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("statusSet") /* Statuses com.amazonaws.ec2.synthetic#DescribeIdentityIdFormatOutput$Statuses */ =>  {
                let var_329 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_id_format_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_statuses(var_329);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_id_format(
    inp: &[u8],
    mut builder: crate::output::describe_id_format_output::Builder,
) -> Result<crate::output::describe_id_format_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIdFormatResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIdFormatResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("statusSet") /* Statuses com.amazonaws.ec2.synthetic#DescribeIdFormatOutput$Statuses */ =>  {
                let var_330 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_id_format_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_statuses(var_330);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_image_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_image_attribute_output::Builder,
) -> Result<crate::output::describe_image_attribute_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeImageAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeImageAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("blockDeviceMapping") /* BlockDeviceMappings com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$BlockDeviceMappings */ =>  {
                let var_331 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_block_device_mapping_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_block_device_mappings(var_331);
            }
            ,
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$ImageId */ =>  {
                let var_332 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_332);
            }
            ,
            s if s.matches("launchPermission") /* LaunchPermissions com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$LaunchPermissions */ =>  {
                let var_333 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_launch_permission_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_permissions(var_333);
            }
            ,
            s if s.matches("productCodes") /* ProductCodes com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$ProductCodes */ =>  {
                let var_334 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_product_code_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_product_codes(var_334);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$Description */ =>  {
                let var_335 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_description(var_335);
            }
            ,
            s if s.matches("kernel") /* KernelId com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$KernelId */ =>  {
                let var_336 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_kernel_id(var_336);
            }
            ,
            s if s.matches("ramdisk") /* RamdiskId com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$RamdiskId */ =>  {
                let var_337 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ramdisk_id(var_337);
            }
            ,
            s if s.matches("sriovNetSupport") /* SriovNetSupport com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$SriovNetSupport */ =>  {
                let var_338 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sriov_net_support(var_338);
            }
            ,
            s if s.matches("bootMode") /* BootMode com.amazonaws.ec2.synthetic#DescribeImageAttributeOutput$BootMode */ =>  {
                let var_339 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_boot_mode(var_339);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_images(
    inp: &[u8],
    mut builder: crate::output::describe_images_output::Builder,
) -> Result<crate::output::describe_images_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeImagesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeImagesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imagesSet") /* Images com.amazonaws.ec2.synthetic#DescribeImagesOutput$Images */ =>  {
                let var_340 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_image_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_images(var_340);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_import_image_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_import_image_tasks_output::Builder,
) -> Result<
    crate::output::describe_import_image_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeImportImageTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeImportImageTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("importImageTaskSet") /* ImportImageTasks com.amazonaws.ec2.synthetic#DescribeImportImageTasksOutput$ImportImageTasks */ =>  {
                let var_341 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_import_image_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_image_tasks(var_341);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeImportImageTasksOutput$NextToken */ =>  {
                let var_342 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_342);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_import_snapshot_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_import_snapshot_tasks_output::Builder,
) -> Result<
    crate::output::describe_import_snapshot_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeImportSnapshotTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeImportSnapshotTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("importSnapshotTaskSet") /* ImportSnapshotTasks com.amazonaws.ec2.synthetic#DescribeImportSnapshotTasksOutput$ImportSnapshotTasks */ =>  {
                let var_343 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_import_snapshot_task_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_snapshot_tasks(var_343);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeImportSnapshotTasksOutput$NextToken */ =>  {
                let var_344 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_344);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_instance_attribute_output::Builder,
) -> Result<
    crate::output::describe_instance_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("groupSet") /* Groups com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$Groups */ =>  {
                let var_345 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_group_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_groups(var_345);
            }
            ,
            s if s.matches("blockDeviceMapping") /* BlockDeviceMappings com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$BlockDeviceMappings */ =>  {
                let var_346 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_block_device_mapping_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_block_device_mappings(var_346);
            }
            ,
            s if s.matches("disableApiTermination") /* DisableApiTermination com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$DisableApiTermination */ =>  {
                let var_347 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_disable_api_termination(var_347);
            }
            ,
            s if s.matches("enaSupport") /* EnaSupport com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$EnaSupport */ =>  {
                let var_348 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ena_support(var_348);
            }
            ,
            s if s.matches("enclaveOptions") /* EnclaveOptions com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$EnclaveOptions */ =>  {
                let var_349 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_enclave_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_enclave_options(var_349);
            }
            ,
            s if s.matches("ebsOptimized") /* EbsOptimized com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$EbsOptimized */ =>  {
                let var_350 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ebs_optimized(var_350);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$InstanceId */ =>  {
                let var_351 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_351);
            }
            ,
            s if s.matches("instanceInitiatedShutdownBehavior") /* InstanceInitiatedShutdownBehavior com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$InstanceInitiatedShutdownBehavior */ =>  {
                let var_352 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_initiated_shutdown_behavior(var_352);
            }
            ,
            s if s.matches("instanceType") /* InstanceType com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$InstanceType */ =>  {
                let var_353 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_type(var_353);
            }
            ,
            s if s.matches("kernel") /* KernelId com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$KernelId */ =>  {
                let var_354 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_kernel_id(var_354);
            }
            ,
            s if s.matches("productCodes") /* ProductCodes com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$ProductCodes */ =>  {
                let var_355 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_product_code_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_product_codes(var_355);
            }
            ,
            s if s.matches("ramdisk") /* RamdiskId com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$RamdiskId */ =>  {
                let var_356 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ramdisk_id(var_356);
            }
            ,
            s if s.matches("rootDeviceName") /* RootDeviceName com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$RootDeviceName */ =>  {
                let var_357 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_root_device_name(var_357);
            }
            ,
            s if s.matches("sourceDestCheck") /* SourceDestCheck com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$SourceDestCheck */ =>  {
                let var_358 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_dest_check(var_358);
            }
            ,
            s if s.matches("sriovNetSupport") /* SriovNetSupport com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$SriovNetSupport */ =>  {
                let var_359 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sriov_net_support(var_359);
            }
            ,
            s if s.matches("userData") /* UserData com.amazonaws.ec2.synthetic#DescribeInstanceAttributeOutput$UserData */ =>  {
                let var_360 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user_data(var_360);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_credit_specifications(
    inp: &[u8],
    mut builder: crate::output::describe_instance_credit_specifications_output::Builder,
) -> Result<
    crate::output::describe_instance_credit_specifications_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceCreditSpecificationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceCreditSpecificationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceCreditSpecificationSet") /* InstanceCreditSpecifications com.amazonaws.ec2.synthetic#DescribeInstanceCreditSpecificationsOutput$InstanceCreditSpecifications */ =>  {
                let var_361 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_credit_specification_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_credit_specifications(var_361);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstanceCreditSpecificationsOutput$NextToken */ =>  {
                let var_362 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_362);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_event_notification_attributes(
    inp: &[u8],
    mut builder: crate::output::describe_instance_event_notification_attributes_output::Builder,
) -> Result<
    crate::output::describe_instance_event_notification_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceEventNotificationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceEventNotificationAttributesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTagAttribute") /* InstanceTagAttribute com.amazonaws.ec2.synthetic#DescribeInstanceEventNotificationAttributesOutput$InstanceTagAttribute */ =>  {
                let var_363 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_tag_notification_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_tag_attribute(var_363);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_event_windows(
    inp: &[u8],
    mut builder: crate::output::describe_instance_event_windows_output::Builder,
) -> Result<
    crate::output::describe_instance_event_windows_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceEventWindowsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceEventWindowsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindowSet") /* InstanceEventWindows com.amazonaws.ec2.synthetic#DescribeInstanceEventWindowsOutput$InstanceEventWindows */ =>  {
                let var_364 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_event_window_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_windows(var_364);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstanceEventWindowsOutput$NextToken */ =>  {
                let var_365 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_365);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instances(
    inp: &[u8],
    mut builder: crate::output::describe_instances_output::Builder,
) -> Result<crate::output::describe_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservationSet") /* Reservations com.amazonaws.ec2.synthetic#DescribeInstancesOutput$Reservations */ =>  {
                let var_366 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reservation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reservations(var_366);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstancesOutput$NextToken */ =>  {
                let var_367 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_367);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_status(
    inp: &[u8],
    mut builder: crate::output::describe_instance_status_output::Builder,
) -> Result<crate::output::describe_instance_status_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceStatusResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceStatusSet") /* InstanceStatuses com.amazonaws.ec2.synthetic#DescribeInstanceStatusOutput$InstanceStatuses */ =>  {
                let var_368 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_statuses(var_368);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstanceStatusOutput$NextToken */ =>  {
                let var_369 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_369);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_type_offerings(
    inp: &[u8],
    mut builder: crate::output::describe_instance_type_offerings_output::Builder,
) -> Result<
    crate::output::describe_instance_type_offerings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceTypeOfferingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceTypeOfferingsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTypeOfferingSet") /* InstanceTypeOfferings com.amazonaws.ec2.synthetic#DescribeInstanceTypeOfferingsOutput$InstanceTypeOfferings */ =>  {
                let var_370 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_type_offerings_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_type_offerings(var_370);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstanceTypeOfferingsOutput$NextToken */ =>  {
                let var_371 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_371);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_instance_types(
    inp: &[u8],
    mut builder: crate::output::describe_instance_types_output::Builder,
) -> Result<crate::output::describe_instance_types_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInstanceTypesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInstanceTypesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTypeSet") /* InstanceTypes com.amazonaws.ec2.synthetic#DescribeInstanceTypesOutput$InstanceTypes */ =>  {
                let var_372 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_type_info_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_types(var_372);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInstanceTypesOutput$NextToken */ =>  {
                let var_373 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_373);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_internet_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_internet_gateways_output::Builder,
) -> Result<
    crate::output::describe_internet_gateways_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInternetGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInternetGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("internetGatewaySet") /* InternetGateways com.amazonaws.ec2.synthetic#DescribeInternetGatewaysOutput$InternetGateways */ =>  {
                let var_374 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_internet_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_internet_gateways(var_374);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeInternetGatewaysOutput$NextToken */ =>  {
                let var_375 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_375);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_ipam_pools(
    inp: &[u8],
    mut builder: crate::output::describe_ipam_pools_output::Builder,
) -> Result<crate::output::describe_ipam_pools_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIpamPoolsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIpamPoolsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeIpamPoolsOutput$NextToken */ =>  {
                let var_376 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_376);
            }
            ,
            s if s.matches("ipamPoolSet") /* IpamPools com.amazonaws.ec2.synthetic#DescribeIpamPoolsOutput$IpamPools */ =>  {
                let var_377 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_pool_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pools(var_377);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_ipams(
    inp: &[u8],
    mut builder: crate::output::describe_ipams_output::Builder,
) -> Result<crate::output::describe_ipams_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIpamsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIpamsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeIpamsOutput$NextToken */ =>  {
                let var_378 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_378);
            }
            ,
            s if s.matches("ipamSet") /* Ipams com.amazonaws.ec2.synthetic#DescribeIpamsOutput$Ipams */ =>  {
                let var_379 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipams(var_379);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_ipam_scopes(
    inp: &[u8],
    mut builder: crate::output::describe_ipam_scopes_output::Builder,
) -> Result<crate::output::describe_ipam_scopes_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIpamScopesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIpamScopesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeIpamScopesOutput$NextToken */ =>  {
                let var_380 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_380);
            }
            ,
            s if s.matches("ipamScopeSet") /* IpamScopes com.amazonaws.ec2.synthetic#DescribeIpamScopesOutput$IpamScopes */ =>  {
                let var_381 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_scope_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_scopes(var_381);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_ipv6_pools(
    inp: &[u8],
    mut builder: crate::output::describe_ipv6_pools_output::Builder,
) -> Result<crate::output::describe_ipv6_pools_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeIpv6PoolsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeIpv6PoolsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6PoolSet") /* Ipv6Pools com.amazonaws.ec2.synthetic#DescribeIpv6PoolsOutput$Ipv6Pools */ =>  {
                let var_382 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipv6_pool_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_pools(var_382);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeIpv6PoolsOutput$NextToken */ =>  {
                let var_383 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_383);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_key_pairs(
    inp: &[u8],
    mut builder: crate::output::describe_key_pairs_output::Builder,
) -> Result<crate::output::describe_key_pairs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeKeyPairsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeKeyPairsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("keySet") /* KeyPairs com.amazonaws.ec2.synthetic#DescribeKeyPairsOutput$KeyPairs */ =>  {
                let var_384 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_key_pair_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_key_pairs(var_384);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_launch_templates(
    inp: &[u8],
    mut builder: crate::output::describe_launch_templates_output::Builder,
) -> Result<
    crate::output::describe_launch_templates_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLaunchTemplatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLaunchTemplatesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplates") /* LaunchTemplates com.amazonaws.ec2.synthetic#DescribeLaunchTemplatesOutput$LaunchTemplates */ =>  {
                let var_385 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_launch_template_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_templates(var_385);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLaunchTemplatesOutput$NextToken */ =>  {
                let var_386 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_386);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_launch_template_versions(
    inp: &[u8],
    mut builder: crate::output::describe_launch_template_versions_output::Builder,
) -> Result<
    crate::output::describe_launch_template_versions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLaunchTemplateVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLaunchTemplateVersionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplateVersionSet") /* LaunchTemplateVersions com.amazonaws.ec2.synthetic#DescribeLaunchTemplateVersionsOutput$LaunchTemplateVersions */ =>  {
                let var_387 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_launch_template_version_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template_versions(var_387);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLaunchTemplateVersionsOutput$NextToken */ =>  {
                let var_388 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_388);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_local_gateway_route_tables(
    inp: &[u8],
    mut builder: crate::output::describe_local_gateway_route_tables_output::Builder,
) -> Result<
    crate::output::describe_local_gateway_route_tables_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLocalGatewayRouteTablesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLocalGatewayRouteTablesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayRouteTableSet") /* LocalGatewayRouteTables com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTablesOutput$LocalGatewayRouteTables */ =>  {
                let var_389 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_route_table_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_tables(var_389);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTablesOutput$NextToken */ =>  {
                let var_390 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_390);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]pub fn deser_operation_crate_operation_describe_local_gateway_route_table_virtual_interface_group_associations(inp: &[u8], mut builder: crate::output::describe_local_gateway_route_table_virtual_interface_group_associations_output::Builder) -> Result<crate::output::describe_local_gateway_route_table_virtual_interface_group_associations_output::Builder, aws_smithy_xml::decode::XmlError>{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el
        .matches("DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse"))
    {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!("invalid root, expected DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse got {:?}", start_el)));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayRouteTableVirtualInterfaceGroupAssociationSet") /* LocalGatewayRouteTableVirtualInterfaceGroupAssociations com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput$LocalGatewayRouteTableVirtualInterfaceGroupAssociations */ =>  {
                let var_391 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_route_table_virtual_interface_group_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_table_virtual_interface_group_associations(var_391);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsOutput$NextToken */ =>  {
                let var_392 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_392);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_local_gateway_route_table_vpc_associations(
    inp: &[u8],
    mut builder: crate::output::describe_local_gateway_route_table_vpc_associations_output::Builder,
) -> Result<
    crate::output::describe_local_gateway_route_table_vpc_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLocalGatewayRouteTableVpcAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLocalGatewayRouteTableVpcAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayRouteTableVpcAssociationSet") /* LocalGatewayRouteTableVpcAssociations com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTableVpcAssociationsOutput$LocalGatewayRouteTableVpcAssociations */ =>  {
                let var_393 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_route_table_vpc_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_table_vpc_associations(var_393);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewayRouteTableVpcAssociationsOutput$NextToken */ =>  {
                let var_394 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_394);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_local_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_local_gateways_output::Builder,
) -> Result<crate::output::describe_local_gateways_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLocalGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLocalGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewaySet") /* LocalGateways com.amazonaws.ec2.synthetic#DescribeLocalGatewaysOutput$LocalGateways */ =>  {
                let var_395 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateways(var_395);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewaysOutput$NextToken */ =>  {
                let var_396 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_396);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_local_gateway_virtual_interface_groups(
    inp: &[u8],
    mut builder: crate::output::describe_local_gateway_virtual_interface_groups_output::Builder,
) -> Result<
    crate::output::describe_local_gateway_virtual_interface_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLocalGatewayVirtualInterfaceGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLocalGatewayVirtualInterfaceGroupsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayVirtualInterfaceGroupSet") /* LocalGatewayVirtualInterfaceGroups com.amazonaws.ec2.synthetic#DescribeLocalGatewayVirtualInterfaceGroupsOutput$LocalGatewayVirtualInterfaceGroups */ =>  {
                let var_397 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_virtual_interface_group_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_virtual_interface_groups(var_397);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewayVirtualInterfaceGroupsOutput$NextToken */ =>  {
                let var_398 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_398);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_local_gateway_virtual_interfaces(
    inp: &[u8],
    mut builder: crate::output::describe_local_gateway_virtual_interfaces_output::Builder,
) -> Result<
    crate::output::describe_local_gateway_virtual_interfaces_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLocalGatewayVirtualInterfacesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLocalGatewayVirtualInterfacesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("localGatewayVirtualInterfaceSet") /* LocalGatewayVirtualInterfaces com.amazonaws.ec2.synthetic#DescribeLocalGatewayVirtualInterfacesOutput$LocalGatewayVirtualInterfaces */ =>  {
                let var_399 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_virtual_interface_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_local_gateway_virtual_interfaces(var_399);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeLocalGatewayVirtualInterfacesOutput$NextToken */ =>  {
                let var_400 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_400);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_managed_prefix_lists(
    inp: &[u8],
    mut builder: crate::output::describe_managed_prefix_lists_output::Builder,
) -> Result<
    crate::output::describe_managed_prefix_lists_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeManagedPrefixListsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeManagedPrefixListsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeManagedPrefixListsOutput$NextToken */ =>  {
                let var_401 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_401);
            }
            ,
            s if s.matches("prefixListSet") /* PrefixLists com.amazonaws.ec2.synthetic#DescribeManagedPrefixListsOutput$PrefixLists */ =>  {
                let var_402 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_managed_prefix_list_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_lists(var_402);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_moving_addresses(
    inp: &[u8],
    mut builder: crate::output::describe_moving_addresses_output::Builder,
) -> Result<
    crate::output::describe_moving_addresses_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeMovingAddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeMovingAddressesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("movingAddressStatusSet") /* MovingAddressStatuses com.amazonaws.ec2.synthetic#DescribeMovingAddressesOutput$MovingAddressStatuses */ =>  {
                let var_403 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_moving_address_status_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_moving_address_statuses(var_403);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeMovingAddressesOutput$NextToken */ =>  {
                let var_404 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_404);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_nat_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_nat_gateways_output::Builder,
) -> Result<crate::output::describe_nat_gateways_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNatGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNatGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("natGatewaySet") /* NatGateways com.amazonaws.ec2.synthetic#DescribeNatGatewaysOutput$NatGateways */ =>  {
                let var_405 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_nat_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_nat_gateways(var_405);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNatGatewaysOutput$NextToken */ =>  {
                let var_406 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_406);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_acls(
    inp: &[u8],
    mut builder: crate::output::describe_network_acls_output::Builder,
) -> Result<crate::output::describe_network_acls_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkAclsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkAclsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkAclSet") /* NetworkAcls com.amazonaws.ec2.synthetic#DescribeNetworkAclsOutput$NetworkAcls */ =>  {
                let var_407 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_acl_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_acls(var_407);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkAclsOutput$NextToken */ =>  {
                let var_408 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_408);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_insights_access_scope_analyses(
    inp: &[u8],
    mut builder: crate::output::describe_network_insights_access_scope_analyses_output::Builder,
) -> Result<
    crate::output::describe_network_insights_access_scope_analyses_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInsightsAccessScopeAnalysesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInsightsAccessScopeAnalysesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeAnalysisSet") /* NetworkInsightsAccessScopeAnalyses com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAccessScopeAnalysesOutput$NetworkInsightsAccessScopeAnalyses */ =>  {
                let var_409 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_insights_access_scope_analysis_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_analyses(var_409);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAccessScopeAnalysesOutput$NextToken */ =>  {
                let var_410 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_410);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_insights_access_scopes(
    inp: &[u8],
    mut builder: crate::output::describe_network_insights_access_scopes_output::Builder,
) -> Result<
    crate::output::describe_network_insights_access_scopes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInsightsAccessScopesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInsightsAccessScopesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeSet") /* NetworkInsightsAccessScopes com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAccessScopesOutput$NetworkInsightsAccessScopes */ =>  {
                let var_411 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_insights_access_scope_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scopes(var_411);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAccessScopesOutput$NextToken */ =>  {
                let var_412 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_412);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_insights_analyses(
    inp: &[u8],
    mut builder: crate::output::describe_network_insights_analyses_output::Builder,
) -> Result<
    crate::output::describe_network_insights_analyses_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInsightsAnalysesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInsightsAnalysesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAnalysisSet") /* NetworkInsightsAnalyses com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAnalysesOutput$NetworkInsightsAnalyses */ =>  {
                let var_413 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_insights_analysis_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_analyses(var_413);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInsightsAnalysesOutput$NextToken */ =>  {
                let var_414 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_414);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_insights_paths(
    inp: &[u8],
    mut builder: crate::output::describe_network_insights_paths_output::Builder,
) -> Result<
    crate::output::describe_network_insights_paths_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInsightsPathsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInsightsPathsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsPathSet") /* NetworkInsightsPaths com.amazonaws.ec2.synthetic#DescribeNetworkInsightsPathsOutput$NetworkInsightsPaths */ =>  {
                let var_415 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_insights_path_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_paths(var_415);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInsightsPathsOutput$NextToken */ =>  {
                let var_416 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_416);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_interface_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_network_interface_attribute_output::Builder,
) -> Result<
    crate::output::describe_network_interface_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInterfaceAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInterfaceAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachment") /* Attachment com.amazonaws.ec2.synthetic#DescribeNetworkInterfaceAttributeOutput$Attachment */ =>  {
                let var_417 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_interface_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attachment(var_417);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#DescribeNetworkInterfaceAttributeOutput$Description */ =>  {
                let var_418 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_description(var_418);
            }
            ,
            s if s.matches("groupSet") /* Groups com.amazonaws.ec2.synthetic#DescribeNetworkInterfaceAttributeOutput$Groups */ =>  {
                let var_419 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_group_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_groups(var_419);
            }
            ,
            s if s.matches("networkInterfaceId") /* NetworkInterfaceId com.amazonaws.ec2.synthetic#DescribeNetworkInterfaceAttributeOutput$NetworkInterfaceId */ =>  {
                let var_420 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_interface_id(var_420);
            }
            ,
            s if s.matches("sourceDestCheck") /* SourceDestCheck com.amazonaws.ec2.synthetic#DescribeNetworkInterfaceAttributeOutput$SourceDestCheck */ =>  {
                let var_421 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_dest_check(var_421);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_interface_permissions(
    inp: &[u8],
    mut builder: crate::output::describe_network_interface_permissions_output::Builder,
) -> Result<
    crate::output::describe_network_interface_permissions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInterfacePermissionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInterfacePermissionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInterfacePermissions") /* NetworkInterfacePermissions com.amazonaws.ec2.synthetic#DescribeNetworkInterfacePermissionsOutput$NetworkInterfacePermissions */ =>  {
                let var_422 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_interface_permission_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_interface_permissions(var_422);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInterfacePermissionsOutput$NextToken */ =>  {
                let var_423 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_423);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_network_interfaces(
    inp: &[u8],
    mut builder: crate::output::describe_network_interfaces_output::Builder,
) -> Result<
    crate::output::describe_network_interfaces_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNetworkInterfacesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNetworkInterfacesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInterfaceSet") /* NetworkInterfaces com.amazonaws.ec2.synthetic#DescribeNetworkInterfacesOutput$NetworkInterfaces */ =>  {
                let var_424 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_network_interface_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_interfaces(var_424);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeNetworkInterfacesOutput$NextToken */ =>  {
                let var_425 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_425);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_placement_groups(
    inp: &[u8],
    mut builder: crate::output::describe_placement_groups_output::Builder,
) -> Result<
    crate::output::describe_placement_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePlacementGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePlacementGroupsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("placementGroupSet") /* PlacementGroups com.amazonaws.ec2.synthetic#DescribePlacementGroupsOutput$PlacementGroups */ =>  {
                let var_426 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_placement_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_placement_groups(var_426);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_prefix_lists(
    inp: &[u8],
    mut builder: crate::output::describe_prefix_lists_output::Builder,
) -> Result<crate::output::describe_prefix_lists_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePrefixListsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePrefixListsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribePrefixListsOutput$NextToken */ =>  {
                let var_427 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_427);
            }
            ,
            s if s.matches("prefixListSet") /* PrefixLists com.amazonaws.ec2.synthetic#DescribePrefixListsOutput$PrefixLists */ =>  {
                let var_428 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_prefix_list_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_lists(var_428);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_principal_id_format(
    inp: &[u8],
    mut builder: crate::output::describe_principal_id_format_output::Builder,
) -> Result<
    crate::output::describe_principal_id_format_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePrincipalIdFormatResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePrincipalIdFormatResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("principalSet") /* Principals com.amazonaws.ec2.synthetic#DescribePrincipalIdFormatOutput$Principals */ =>  {
                let var_429 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_principal_id_format_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_principals(var_429);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribePrincipalIdFormatOutput$NextToken */ =>  {
                let var_430 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_430);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_public_ipv4_pools(
    inp: &[u8],
    mut builder: crate::output::describe_public_ipv4_pools_output::Builder,
) -> Result<
    crate::output::describe_public_ipv4_pools_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePublicIpv4PoolsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePublicIpv4PoolsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("publicIpv4PoolSet") /* PublicIpv4Pools com.amazonaws.ec2.synthetic#DescribePublicIpv4PoolsOutput$PublicIpv4Pools */ =>  {
                let var_431 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_public_ipv4_pool_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_public_ipv4_pools(var_431);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribePublicIpv4PoolsOutput$NextToken */ =>  {
                let var_432 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_432);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_regions(
    inp: &[u8],
    mut builder: crate::output::describe_regions_output::Builder,
) -> Result<crate::output::describe_regions_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeRegionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeRegionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("regionInfo") /* Regions com.amazonaws.ec2.synthetic#DescribeRegionsOutput$Regions */ =>  {
                let var_433 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_region_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_433);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_replace_root_volume_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_replace_root_volume_tasks_output::Builder,
) -> Result<
    crate::output::describe_replace_root_volume_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReplaceRootVolumeTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReplaceRootVolumeTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("replaceRootVolumeTaskSet") /* ReplaceRootVolumeTasks com.amazonaws.ec2.synthetic#DescribeReplaceRootVolumeTasksOutput$ReplaceRootVolumeTasks */ =>  {
                let var_434 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_replace_root_volume_tasks(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_replace_root_volume_tasks(var_434);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeReplaceRootVolumeTasksOutput$NextToken */ =>  {
                let var_435 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_435);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_instances(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_instances_output::Builder,
) -> Result<
    crate::output::describe_reserved_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesSet") /* ReservedInstances com.amazonaws.ec2.synthetic#DescribeReservedInstancesOutput$ReservedInstances */ =>  {
                let var_436 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances(var_436);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_instances_listings(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_instances_listings_output::Builder,
) -> Result<
    crate::output::describe_reserved_instances_listings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedInstancesListingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedInstancesListingsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesListingsSet") /* ReservedInstancesListings com.amazonaws.ec2.synthetic#DescribeReservedInstancesListingsOutput$ReservedInstancesListings */ =>  {
                let var_437 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_listing_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_listings(var_437);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_instances_modifications(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_instances_modifications_output::Builder,
) -> Result<
    crate::output::describe_reserved_instances_modifications_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedInstancesModificationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedInstancesModificationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeReservedInstancesModificationsOutput$NextToken */ =>  {
                let var_438 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_438);
            }
            ,
            s if s.matches("reservedInstancesModificationsSet") /* ReservedInstancesModifications com.amazonaws.ec2.synthetic#DescribeReservedInstancesModificationsOutput$ReservedInstancesModifications */ =>  {
                let var_439 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_modification_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_modifications(var_439);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_instances_offerings(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_instances_offerings_output::Builder,
) -> Result<
    crate::output::describe_reserved_instances_offerings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedInstancesOfferingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedInstancesOfferingsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesOfferingsSet") /* ReservedInstancesOfferings com.amazonaws.ec2.synthetic#DescribeReservedInstancesOfferingsOutput$ReservedInstancesOfferings */ =>  {
                let var_440 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instances_offering_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_offerings(var_440);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeReservedInstancesOfferingsOutput$NextToken */ =>  {
                let var_441 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_441);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_route_tables(
    inp: &[u8],
    mut builder: crate::output::describe_route_tables_output::Builder,
) -> Result<crate::output::describe_route_tables_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeRouteTablesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeRouteTablesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("routeTableSet") /* RouteTables com.amazonaws.ec2.synthetic#DescribeRouteTablesOutput$RouteTables */ =>  {
                let var_442 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_route_table_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route_tables(var_442);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeRouteTablesOutput$NextToken */ =>  {
                let var_443 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_443);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_scheduled_instance_availability(
    inp: &[u8],
    mut builder: crate::output::describe_scheduled_instance_availability_output::Builder,
) -> Result<
    crate::output::describe_scheduled_instance_availability_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeScheduledInstanceAvailabilityResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeScheduledInstanceAvailabilityResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeScheduledInstanceAvailabilityOutput$NextToken */ =>  {
                let var_444 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_444);
            }
            ,
            s if s.matches("scheduledInstanceAvailabilitySet") /* ScheduledInstanceAvailabilitySet com.amazonaws.ec2.synthetic#DescribeScheduledInstanceAvailabilityOutput$ScheduledInstanceAvailabilitySet */ =>  {
                let var_445 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_scheduled_instance_availability_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scheduled_instance_availability_set(var_445);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_scheduled_instances(
    inp: &[u8],
    mut builder: crate::output::describe_scheduled_instances_output::Builder,
) -> Result<
    crate::output::describe_scheduled_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeScheduledInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeScheduledInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeScheduledInstancesOutput$NextToken */ =>  {
                let var_446 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_446);
            }
            ,
            s if s.matches("scheduledInstanceSet") /* ScheduledInstanceSet com.amazonaws.ec2.synthetic#DescribeScheduledInstancesOutput$ScheduledInstanceSet */ =>  {
                let var_447 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_scheduled_instance_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scheduled_instance_set(var_447);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_security_group_references(
    inp: &[u8],
    mut builder: crate::output::describe_security_group_references_output::Builder,
) -> Result<
    crate::output::describe_security_group_references_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSecurityGroupReferencesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSecurityGroupReferencesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("securityGroupReferenceSet") /* SecurityGroupReferenceSet com.amazonaws.ec2.synthetic#DescribeSecurityGroupReferencesOutput$SecurityGroupReferenceSet */ =>  {
                let var_448 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_security_group_references(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_group_reference_set(var_448);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_security_group_rules(
    inp: &[u8],
    mut builder: crate::output::describe_security_group_rules_output::Builder,
) -> Result<
    crate::output::describe_security_group_rules_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSecurityGroupRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSecurityGroupRulesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("securityGroupRuleSet") /* SecurityGroupRules com.amazonaws.ec2.synthetic#DescribeSecurityGroupRulesOutput$SecurityGroupRules */ =>  {
                let var_449 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_security_group_rule_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_group_rules(var_449);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSecurityGroupRulesOutput$NextToken */ =>  {
                let var_450 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_450);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_security_groups(
    inp: &[u8],
    mut builder: crate::output::describe_security_groups_output::Builder,
) -> Result<crate::output::describe_security_groups_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSecurityGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSecurityGroupsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("securityGroupInfo") /* SecurityGroups com.amazonaws.ec2.synthetic#DescribeSecurityGroupsOutput$SecurityGroups */ =>  {
                let var_451 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_security_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_security_groups(var_451);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSecurityGroupsOutput$NextToken */ =>  {
                let var_452 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_452);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_snapshot_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_snapshot_attribute_output::Builder,
) -> Result<
    crate::output::describe_snapshot_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSnapshotAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSnapshotAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("createVolumePermission") /* CreateVolumePermissions com.amazonaws.ec2.synthetic#DescribeSnapshotAttributeOutput$CreateVolumePermissions */ =>  {
                let var_453 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_create_volume_permission_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_create_volume_permissions(var_453);
            }
            ,
            s if s.matches("productCodes") /* ProductCodes com.amazonaws.ec2.synthetic#DescribeSnapshotAttributeOutput$ProductCodes */ =>  {
                let var_454 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_product_code_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_product_codes(var_454);
            }
            ,
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#DescribeSnapshotAttributeOutput$SnapshotId */ =>  {
                let var_455 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_455);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_snapshots(
    inp: &[u8],
    mut builder: crate::output::describe_snapshots_output::Builder,
) -> Result<crate::output::describe_snapshots_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSnapshotsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSnapshotsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotSet") /* Snapshots com.amazonaws.ec2.synthetic#DescribeSnapshotsOutput$Snapshots */ =>  {
                let var_456 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_snapshot_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshots(var_456);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSnapshotsOutput$NextToken */ =>  {
                let var_457 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_457);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_snapshot_tier_status(
    inp: &[u8],
    mut builder: crate::output::describe_snapshot_tier_status_output::Builder,
) -> Result<
    crate::output::describe_snapshot_tier_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSnapshotTierStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSnapshotTierStatusResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotTierStatusSet") /* SnapshotTierStatuses com.amazonaws.ec2.synthetic#DescribeSnapshotTierStatusOutput$SnapshotTierStatuses */ =>  {
                let var_458 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_snapshot_tier_status_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_tier_statuses(var_458);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSnapshotTierStatusOutput$NextToken */ =>  {
                let var_459 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_459);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_datafeed_subscription(
    inp: &[u8],
    mut builder: crate::output::describe_spot_datafeed_subscription_output::Builder,
) -> Result<
    crate::output::describe_spot_datafeed_subscription_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotDatafeedSubscriptionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotDatafeedSubscriptionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotDatafeedSubscription") /* SpotDatafeedSubscription com.amazonaws.ec2.synthetic#DescribeSpotDatafeedSubscriptionOutput$SpotDatafeedSubscription */ =>  {
                let var_460 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_spot_datafeed_subscription(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_datafeed_subscription(var_460);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_fleet_instances(
    inp: &[u8],
    mut builder: crate::output::describe_spot_fleet_instances_output::Builder,
) -> Result<
    crate::output::describe_spot_fleet_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotFleetInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotFleetInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("activeInstanceSet") /* ActiveInstances com.amazonaws.ec2.synthetic#DescribeSpotFleetInstancesOutput$ActiveInstances */ =>  {
                let var_461 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_active_instance_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_active_instances(var_461);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSpotFleetInstancesOutput$NextToken */ =>  {
                let var_462 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_462);
            }
            ,
            s if s.matches("spotFleetRequestId") /* SpotFleetRequestId com.amazonaws.ec2.synthetic#DescribeSpotFleetInstancesOutput$SpotFleetRequestId */ =>  {
                let var_463 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_spot_fleet_request_id(var_463);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_fleet_request_history(
    inp: &[u8],
    mut builder: crate::output::describe_spot_fleet_request_history_output::Builder,
) -> Result<
    crate::output::describe_spot_fleet_request_history_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotFleetRequestHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotFleetRequestHistoryResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("historyRecordSet") /* HistoryRecords com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestHistoryOutput$HistoryRecords */ =>  {
                let var_464 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_history_records(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_history_records(var_464);
            }
            ,
            s if s.matches("lastEvaluatedTime") /* LastEvaluatedTime com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestHistoryOutput$LastEvaluatedTime */ =>  {
                let var_465 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_last_evaluated_time(var_465);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestHistoryOutput$NextToken */ =>  {
                let var_466 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_466);
            }
            ,
            s if s.matches("spotFleetRequestId") /* SpotFleetRequestId com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestHistoryOutput$SpotFleetRequestId */ =>  {
                let var_467 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_spot_fleet_request_id(var_467);
            }
            ,
            s if s.matches("startTime") /* StartTime com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestHistoryOutput$StartTime */ =>  {
                let var_468 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_468);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_fleet_requests(
    inp: &[u8],
    mut builder: crate::output::describe_spot_fleet_requests_output::Builder,
) -> Result<
    crate::output::describe_spot_fleet_requests_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotFleetRequestsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotFleetRequestsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestsOutput$NextToken */ =>  {
                let var_469 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_469);
            }
            ,
            s if s.matches("spotFleetRequestConfigSet") /* SpotFleetRequestConfigs com.amazonaws.ec2.synthetic#DescribeSpotFleetRequestsOutput$SpotFleetRequestConfigs */ =>  {
                let var_470 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_spot_fleet_request_config_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_fleet_request_configs(var_470);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_instance_requests(
    inp: &[u8],
    mut builder: crate::output::describe_spot_instance_requests_output::Builder,
) -> Result<
    crate::output::describe_spot_instance_requests_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotInstanceRequestsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotInstanceRequestsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotInstanceRequestSet") /* SpotInstanceRequests com.amazonaws.ec2.synthetic#DescribeSpotInstanceRequestsOutput$SpotInstanceRequests */ =>  {
                let var_471 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_spot_instance_request_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_instance_requests(var_471);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSpotInstanceRequestsOutput$NextToken */ =>  {
                let var_472 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_472);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_spot_price_history(
    inp: &[u8],
    mut builder: crate::output::describe_spot_price_history_output::Builder,
) -> Result<
    crate::output::describe_spot_price_history_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSpotPriceHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSpotPriceHistoryResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSpotPriceHistoryOutput$NextToken */ =>  {
                let var_473 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_473);
            }
            ,
            s if s.matches("spotPriceHistorySet") /* SpotPriceHistory com.amazonaws.ec2.synthetic#DescribeSpotPriceHistoryOutput$SpotPriceHistory */ =>  {
                let var_474 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_spot_price_history_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_price_history(var_474);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_stale_security_groups(
    inp: &[u8],
    mut builder: crate::output::describe_stale_security_groups_output::Builder,
) -> Result<
    crate::output::describe_stale_security_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeStaleSecurityGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeStaleSecurityGroupsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeStaleSecurityGroupsOutput$NextToken */ =>  {
                let var_475 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_475);
            }
            ,
            s if s.matches("staleSecurityGroupSet") /* StaleSecurityGroupSet com.amazonaws.ec2.synthetic#DescribeStaleSecurityGroupsOutput$StaleSecurityGroupSet */ =>  {
                let var_476 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_stale_security_group_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_stale_security_group_set(var_476);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_store_image_tasks(
    inp: &[u8],
    mut builder: crate::output::describe_store_image_tasks_output::Builder,
) -> Result<
    crate::output::describe_store_image_tasks_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeStoreImageTasksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeStoreImageTasksResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("storeImageTaskResultSet") /* StoreImageTaskResults com.amazonaws.ec2.synthetic#DescribeStoreImageTasksOutput$StoreImageTaskResults */ =>  {
                let var_477 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_store_image_task_result_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_store_image_task_results(var_477);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeStoreImageTasksOutput$NextToken */ =>  {
                let var_478 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_478);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_subnets(
    inp: &[u8],
    mut builder: crate::output::describe_subnets_output::Builder,
) -> Result<crate::output::describe_subnets_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSubnetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSubnetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("subnetSet") /* Subnets com.amazonaws.ec2.synthetic#DescribeSubnetsOutput$Subnets */ =>  {
                let var_479 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_subnet_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnets(var_479);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeSubnetsOutput$NextToken */ =>  {
                let var_480 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_480);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_tags(
    inp: &[u8],
    mut builder: crate::output::describe_tags_output::Builder,
) -> Result<crate::output::describe_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTagsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTagsOutput$NextToken */ =>  {
                let var_481 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_481);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#DescribeTagsOutput$Tags */ =>  {
                let var_482 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_description_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_482);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_traffic_mirror_filters(
    inp: &[u8],
    mut builder: crate::output::describe_traffic_mirror_filters_output::Builder,
) -> Result<
    crate::output::describe_traffic_mirror_filters_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTrafficMirrorFiltersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTrafficMirrorFiltersResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilterSet") /* TrafficMirrorFilters com.amazonaws.ec2.synthetic#DescribeTrafficMirrorFiltersOutput$TrafficMirrorFilters */ =>  {
                let var_483 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_traffic_mirror_filter_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filters(var_483);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTrafficMirrorFiltersOutput$NextToken */ =>  {
                let var_484 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_484);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_traffic_mirror_sessions(
    inp: &[u8],
    mut builder: crate::output::describe_traffic_mirror_sessions_output::Builder,
) -> Result<
    crate::output::describe_traffic_mirror_sessions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTrafficMirrorSessionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTrafficMirrorSessionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorSessionSet") /* TrafficMirrorSessions com.amazonaws.ec2.synthetic#DescribeTrafficMirrorSessionsOutput$TrafficMirrorSessions */ =>  {
                let var_485 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_traffic_mirror_session_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_sessions(var_485);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTrafficMirrorSessionsOutput$NextToken */ =>  {
                let var_486 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_486);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_traffic_mirror_targets(
    inp: &[u8],
    mut builder: crate::output::describe_traffic_mirror_targets_output::Builder,
) -> Result<
    crate::output::describe_traffic_mirror_targets_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTrafficMirrorTargetsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTrafficMirrorTargetsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorTargetSet") /* TrafficMirrorTargets com.amazonaws.ec2.synthetic#DescribeTrafficMirrorTargetsOutput$TrafficMirrorTargets */ =>  {
                let var_487 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_traffic_mirror_target_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_targets(var_487);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTrafficMirrorTargetsOutput$NextToken */ =>  {
                let var_488 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_488);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_attachments(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_attachments_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_attachments_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayAttachmentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayAttachmentsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayAttachments") /* TransitGatewayAttachments com.amazonaws.ec2.synthetic#DescribeTransitGatewayAttachmentsOutput$TransitGatewayAttachments */ =>  {
                let var_489 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_attachment_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachments(var_489);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayAttachmentsOutput$NextToken */ =>  {
                let var_490 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_490);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_connect_peers(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_connect_peers_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_connect_peers_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayConnectPeersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayConnectPeersResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnectPeerSet") /* TransitGatewayConnectPeers com.amazonaws.ec2.synthetic#DescribeTransitGatewayConnectPeersOutput$TransitGatewayConnectPeers */ =>  {
                let var_491 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_connect_peer_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connect_peers(var_491);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayConnectPeersOutput$NextToken */ =>  {
                let var_492 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_492);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_connects(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_connects_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_connects_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayConnectsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayConnectsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayConnectSet") /* TransitGatewayConnects com.amazonaws.ec2.synthetic#DescribeTransitGatewayConnectsOutput$TransitGatewayConnects */ =>  {
                let var_493 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_connect_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_connects(var_493);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayConnectsOutput$NextToken */ =>  {
                let var_494 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_494);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_multicast_domains(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_multicast_domains_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_multicast_domains_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayMulticastDomainsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayMulticastDomainsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayMulticastDomains") /* TransitGatewayMulticastDomains com.amazonaws.ec2.synthetic#DescribeTransitGatewayMulticastDomainsOutput$TransitGatewayMulticastDomains */ =>  {
                let var_495 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_multicast_domain_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_multicast_domains(var_495);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayMulticastDomainsOutput$NextToken */ =>  {
                let var_496 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_496);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_peering_attachments(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_peering_attachments_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_peering_attachments_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayPeeringAttachmentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayPeeringAttachmentsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPeeringAttachments") /* TransitGatewayPeeringAttachments com.amazonaws.ec2.synthetic#DescribeTransitGatewayPeeringAttachmentsOutput$TransitGatewayPeeringAttachments */ =>  {
                let var_497 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_peering_attachment_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_peering_attachments(var_497);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayPeeringAttachmentsOutput$NextToken */ =>  {
                let var_498 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_498);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_route_tables(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_route_tables_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_route_tables_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayRouteTablesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayRouteTablesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayRouteTables") /* TransitGatewayRouteTables com.amazonaws.ec2.synthetic#DescribeTransitGatewayRouteTablesOutput$TransitGatewayRouteTables */ =>  {
                let var_499 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_route_table_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_route_tables(var_499);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayRouteTablesOutput$NextToken */ =>  {
                let var_500 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_500);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateways_output::Builder,
) -> Result<
    crate::output::describe_transit_gateways_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewaySet") /* TransitGateways com.amazonaws.ec2.synthetic#DescribeTransitGatewaysOutput$TransitGateways */ =>  {
                let var_501 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateways(var_501);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewaysOutput$NextToken */ =>  {
                let var_502 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_502);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_transit_gateway_vpc_attachments(
    inp: &[u8],
    mut builder: crate::output::describe_transit_gateway_vpc_attachments_output::Builder,
) -> Result<
    crate::output::describe_transit_gateway_vpc_attachments_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTransitGatewayVpcAttachmentsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTransitGatewayVpcAttachmentsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachments") /* TransitGatewayVpcAttachments com.amazonaws.ec2.synthetic#DescribeTransitGatewayVpcAttachmentsOutput$TransitGatewayVpcAttachments */ =>  {
                let var_503 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_vpc_attachment_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachments(var_503);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTransitGatewayVpcAttachmentsOutput$NextToken */ =>  {
                let var_504 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_504);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_trunk_interface_associations(
    inp: &[u8],
    mut builder: crate::output::describe_trunk_interface_associations_output::Builder,
) -> Result<
    crate::output::describe_trunk_interface_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTrunkInterfaceAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTrunkInterfaceAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("interfaceAssociationSet") /* InterfaceAssociations com.amazonaws.ec2.synthetic#DescribeTrunkInterfaceAssociationsOutput$InterfaceAssociations */ =>  {
                let var_505 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_trunk_interface_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_interface_associations(var_505);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeTrunkInterfaceAssociationsOutput$NextToken */ =>  {
                let var_506 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_506);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_volume_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_volume_attribute_output::Builder,
) -> Result<
    crate::output::describe_volume_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVolumeAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVolumeAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("autoEnableIO") /* AutoEnableIO com.amazonaws.ec2.synthetic#DescribeVolumeAttributeOutput$AutoEnableIO */ =>  {
                let var_507 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_auto_enable_io(var_507);
            }
            ,
            s if s.matches("productCodes") /* ProductCodes com.amazonaws.ec2.synthetic#DescribeVolumeAttributeOutput$ProductCodes */ =>  {
                let var_508 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_product_code_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_product_codes(var_508);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#DescribeVolumeAttributeOutput$VolumeId */ =>  {
                let var_509 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_509);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_volumes(
    inp: &[u8],
    mut builder: crate::output::describe_volumes_output::Builder,
) -> Result<crate::output::describe_volumes_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVolumesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVolumesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("volumeSet") /* Volumes com.amazonaws.ec2.synthetic#DescribeVolumesOutput$Volumes */ =>  {
                let var_510 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_volume_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_volumes(var_510);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVolumesOutput$NextToken */ =>  {
                let var_511 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_511);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_volumes_modifications(
    inp: &[u8],
    mut builder: crate::output::describe_volumes_modifications_output::Builder,
) -> Result<
    crate::output::describe_volumes_modifications_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVolumesModificationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVolumesModificationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("volumeModificationSet") /* VolumesModifications com.amazonaws.ec2.synthetic#DescribeVolumesModificationsOutput$VolumesModifications */ =>  {
                let var_512 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_volume_modification_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_volumes_modifications(var_512);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVolumesModificationsOutput$NextToken */ =>  {
                let var_513 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_513);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_volume_status(
    inp: &[u8],
    mut builder: crate::output::describe_volume_status_output::Builder,
) -> Result<crate::output::describe_volume_status_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVolumeStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVolumeStatusResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVolumeStatusOutput$NextToken */ =>  {
                let var_514 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_514);
            }
            ,
            s if s.matches("volumeStatusSet") /* VolumeStatuses com.amazonaws.ec2.synthetic#DescribeVolumeStatusOutput$VolumeStatuses */ =>  {
                let var_515 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_volume_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_volume_statuses(var_515);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_attribute(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_attribute_output::Builder,
) -> Result<crate::output::describe_vpc_attribute_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2.synthetic#DescribeVpcAttributeOutput$VpcId */ =>  {
                let var_516 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_516);
            }
            ,
            s if s.matches("enableDnsHostnames") /* EnableDnsHostnames com.amazonaws.ec2.synthetic#DescribeVpcAttributeOutput$EnableDnsHostnames */ =>  {
                let var_517 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_enable_dns_hostnames(var_517);
            }
            ,
            s if s.matches("enableDnsSupport") /* EnableDnsSupport com.amazonaws.ec2.synthetic#DescribeVpcAttributeOutput$EnableDnsSupport */ =>  {
                let var_518 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attribute_boolean_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_enable_dns_support(var_518);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_classic_link(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_classic_link_output::Builder,
) -> Result<
    crate::output::describe_vpc_classic_link_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcClassicLinkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcClassicLinkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcSet") /* Vpcs com.amazonaws.ec2.synthetic#DescribeVpcClassicLinkOutput$Vpcs */ =>  {
                let var_519 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_classic_link_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpcs(var_519);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_classic_link_dns_support(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_classic_link_dns_support_output::Builder,
) -> Result<
    crate::output::describe_vpc_classic_link_dns_support_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcClassicLinkDnsSupportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcClassicLinkDnsSupportResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcClassicLinkDnsSupportOutput$NextToken */ =>  {
                let var_520 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_520);
            }
            ,
            s if s.matches("vpcs") /* Vpcs com.amazonaws.ec2.synthetic#DescribeVpcClassicLinkDnsSupportOutput$Vpcs */ =>  {
                let var_521 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_classic_link_dns_support_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpcs(var_521);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoint_connection_notifications(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoint_connection_notifications_output::Builder,
) -> Result<
    crate::output::describe_vpc_endpoint_connection_notifications_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointConnectionNotificationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointConnectionNotificationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("connectionNotificationSet") /* ConnectionNotificationSet com.amazonaws.ec2.synthetic#DescribeVpcEndpointConnectionNotificationsOutput$ConnectionNotificationSet */ =>  {
                let var_522 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_connection_notification_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_connection_notification_set(var_522);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointConnectionNotificationsOutput$NextToken */ =>  {
                let var_523 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_523);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoint_connections(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoint_connections_output::Builder,
) -> Result<
    crate::output::describe_vpc_endpoint_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcEndpointConnectionSet") /* VpcEndpointConnections com.amazonaws.ec2.synthetic#DescribeVpcEndpointConnectionsOutput$VpcEndpointConnections */ =>  {
                let var_524 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_endpoint_connection_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint_connections(var_524);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointConnectionsOutput$NextToken */ =>  {
                let var_525 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_525);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoints(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoints_output::Builder,
) -> Result<crate::output::describe_vpc_endpoints_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcEndpointSet") /* VpcEndpoints com.amazonaws.ec2.synthetic#DescribeVpcEndpointsOutput$VpcEndpoints */ =>  {
                let var_526 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_endpoint_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoints(var_526);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointsOutput$NextToken */ =>  {
                let var_527 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_527);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoint_service_configurations(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoint_service_configurations_output::Builder,
) -> Result<
    crate::output::describe_vpc_endpoint_service_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointServiceConfigurationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointServiceConfigurationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serviceConfigurationSet") /* ServiceConfigurations com.amazonaws.ec2.synthetic#DescribeVpcEndpointServiceConfigurationsOutput$ServiceConfigurations */ =>  {
                let var_528 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_service_configuration_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_configurations(var_528);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointServiceConfigurationsOutput$NextToken */ =>  {
                let var_529 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_529);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoint_service_permissions(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoint_service_permissions_output::Builder,
) -> Result<
    crate::output::describe_vpc_endpoint_service_permissions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointServicePermissionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointServicePermissionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("allowedPrincipals") /* AllowedPrincipals com.amazonaws.ec2.synthetic#DescribeVpcEndpointServicePermissionsOutput$AllowedPrincipals */ =>  {
                let var_530 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_allowed_principal_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_allowed_principals(var_530);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointServicePermissionsOutput$NextToken */ =>  {
                let var_531 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_531);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_endpoint_services(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_endpoint_services_output::Builder,
) -> Result<
    crate::output::describe_vpc_endpoint_services_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcEndpointServicesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcEndpointServicesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serviceNameSet") /* ServiceNames com.amazonaws.ec2.synthetic#DescribeVpcEndpointServicesOutput$ServiceNames */ =>  {
                let var_532 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_value_string_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_names(var_532);
            }
            ,
            s if s.matches("serviceDetailSet") /* ServiceDetails com.amazonaws.ec2.synthetic#DescribeVpcEndpointServicesOutput$ServiceDetails */ =>  {
                let var_533 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_service_detail_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_details(var_533);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcEndpointServicesOutput$NextToken */ =>  {
                let var_534 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_534);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpc_peering_connections(
    inp: &[u8],
    mut builder: crate::output::describe_vpc_peering_connections_output::Builder,
) -> Result<
    crate::output::describe_vpc_peering_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcPeeringConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcPeeringConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcPeeringConnectionSet") /* VpcPeeringConnections com.amazonaws.ec2.synthetic#DescribeVpcPeeringConnectionsOutput$VpcPeeringConnections */ =>  {
                let var_535 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_peering_connection_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_peering_connections(var_535);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcPeeringConnectionsOutput$NextToken */ =>  {
                let var_536 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_536);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpcs(
    inp: &[u8],
    mut builder: crate::output::describe_vpcs_output::Builder,
) -> Result<crate::output::describe_vpcs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpcsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpcsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpcSet") /* Vpcs com.amazonaws.ec2.synthetic#DescribeVpcsOutput$Vpcs */ =>  {
                let var_537 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpcs(var_537);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#DescribeVpcsOutput$NextToken */ =>  {
                let var_538 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_538);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpn_connections(
    inp: &[u8],
    mut builder: crate::output::describe_vpn_connections_output::Builder,
) -> Result<crate::output::describe_vpn_connections_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpnConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpnConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnectionSet") /* VpnConnections com.amazonaws.ec2.synthetic#DescribeVpnConnectionsOutput$VpnConnections */ =>  {
                let var_539 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpn_connection_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connections(var_539);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_vpn_gateways(
    inp: &[u8],
    mut builder: crate::output::describe_vpn_gateways_output::Builder,
) -> Result<crate::output::describe_vpn_gateways_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeVpnGatewaysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeVpnGatewaysResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnGatewaySet") /* VpnGateways com.amazonaws.ec2.synthetic#DescribeVpnGatewaysOutput$VpnGateways */ =>  {
                let var_540 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpn_gateway_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_gateways(var_540);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_detach_classic_link_vpc(
    inp: &[u8],
    mut builder: crate::output::detach_classic_link_vpc_output::Builder,
) -> Result<crate::output::detach_classic_link_vpc_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DetachClassicLinkVpcResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DetachClassicLinkVpcResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DetachClassicLinkVpcOutput$Return */ =>  {
                let var_541 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_541);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_detach_volume(
    inp: &[u8],
    mut builder: crate::output::detach_volume_output::Builder,
) -> Result<crate::output::detach_volume_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DetachVolumeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DetachVolumeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachTime") /* AttachTime com.amazonaws.ec2.synthetic#DetachVolumeOutput$AttachTime */ =>  {
                let var_542 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_attach_time(var_542);
            }
            ,
            s if s.matches("device") /* Device com.amazonaws.ec2.synthetic#DetachVolumeOutput$Device */ =>  {
                let var_543 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_device(var_543);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#DetachVolumeOutput$InstanceId */ =>  {
                let var_544 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_544);
            }
            ,
            s if s.matches("status") /* State com.amazonaws.ec2.synthetic#DetachVolumeOutput$State */ =>  {
                let var_545 =
                    Some(
                        Result::<crate::model::VolumeAttachmentState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VolumeAttachmentState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_545);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#DetachVolumeOutput$VolumeId */ =>  {
                let var_546 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_546);
            }
            ,
            s if s.matches("deleteOnTermination") /* DeleteOnTermination com.amazonaws.ec2.synthetic#DetachVolumeOutput$DeleteOnTermination */ =>  {
                let var_547 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delete_on_termination(var_547);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_ebs_encryption_by_default(
    inp: &[u8],
    mut builder: crate::output::disable_ebs_encryption_by_default_output::Builder,
) -> Result<
    crate::output::disable_ebs_encryption_by_default_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableEbsEncryptionByDefaultResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableEbsEncryptionByDefaultResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ebsEncryptionByDefault") /* EbsEncryptionByDefault com.amazonaws.ec2.synthetic#DisableEbsEncryptionByDefaultOutput$EbsEncryptionByDefault */ =>  {
                let var_548 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ebs_encryption_by_default(var_548);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_fast_snapshot_restores(
    inp: &[u8],
    mut builder: crate::output::disable_fast_snapshot_restores_output::Builder,
) -> Result<
    crate::output::disable_fast_snapshot_restores_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableFastSnapshotRestoresResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableFastSnapshotRestoresResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successful") /* Successful com.amazonaws.ec2.synthetic#DisableFastSnapshotRestoresOutput$Successful */ =>  {
                let var_549 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_disable_fast_snapshot_restore_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful(var_549);
            }
            ,
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#DisableFastSnapshotRestoresOutput$Unsuccessful */ =>  {
                let var_550 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_disable_fast_snapshot_restore_error_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_550);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_image_deprecation(
    inp: &[u8],
    mut builder: crate::output::disable_image_deprecation_output::Builder,
) -> Result<
    crate::output::disable_image_deprecation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableImageDeprecationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableImageDeprecationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DisableImageDeprecationOutput$Return */ =>  {
                let var_551 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_551);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_ipam_organization_admin_account(
    inp: &[u8],
    mut builder: crate::output::disable_ipam_organization_admin_account_output::Builder,
) -> Result<
    crate::output::disable_ipam_organization_admin_account_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableIpamOrganizationAdminAccountResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableIpamOrganizationAdminAccountResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("success") /* Success com.amazonaws.ec2.synthetic#DisableIpamOrganizationAdminAccountOutput$Success */ =>  {
                let var_552 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_success(var_552);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_serial_console_access(
    inp: &[u8],
    mut builder: crate::output::disable_serial_console_access_output::Builder,
) -> Result<
    crate::output::disable_serial_console_access_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableSerialConsoleAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableSerialConsoleAccessResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serialConsoleAccessEnabled") /* SerialConsoleAccessEnabled com.amazonaws.ec2.synthetic#DisableSerialConsoleAccessOutput$SerialConsoleAccessEnabled */ =>  {
                let var_553 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_serial_console_access_enabled(var_553);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_transit_gateway_route_table_propagation(
    inp: &[u8],
    mut builder: crate::output::disable_transit_gateway_route_table_propagation_output::Builder,
) -> Result<
    crate::output::disable_transit_gateway_route_table_propagation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableTransitGatewayRouteTablePropagationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableTransitGatewayRouteTablePropagationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("propagation") /* Propagation com.amazonaws.ec2.synthetic#DisableTransitGatewayRouteTablePropagationOutput$Propagation */ =>  {
                let var_554 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_propagation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_propagation(var_554);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_vpc_classic_link(
    inp: &[u8],
    mut builder: crate::output::disable_vpc_classic_link_output::Builder,
) -> Result<crate::output::disable_vpc_classic_link_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableVpcClassicLinkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableVpcClassicLinkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DisableVpcClassicLinkOutput$Return */ =>  {
                let var_555 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_555);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_vpc_classic_link_dns_support(
    inp: &[u8],
    mut builder: crate::output::disable_vpc_classic_link_dns_support_output::Builder,
) -> Result<
    crate::output::disable_vpc_classic_link_dns_support_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableVpcClassicLinkDnsSupportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableVpcClassicLinkDnsSupportResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DisableVpcClassicLinkDnsSupportOutput$Return */ =>  {
                let var_556 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_556);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_client_vpn_target_network(
    inp: &[u8],
    mut builder: crate::output::disassociate_client_vpn_target_network_output::Builder,
) -> Result<
    crate::output::disassociate_client_vpn_target_network_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateClientVpnTargetNetworkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateClientVpnTargetNetworkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2.synthetic#DisassociateClientVpnTargetNetworkOutput$AssociationId */ =>  {
                let var_557 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_557);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#DisassociateClientVpnTargetNetworkOutput$Status */ =>  {
                let var_558 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_association_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_558);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_enclave_certificate_iam_role(
    inp: &[u8],
    mut builder: crate::output::disassociate_enclave_certificate_iam_role_output::Builder,
) -> Result<
    crate::output::disassociate_enclave_certificate_iam_role_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateEnclaveCertificateIamRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateEnclaveCertificateIamRoleResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DisassociateEnclaveCertificateIamRoleOutput$Return */ =>  {
                let var_559 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_559);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_iam_instance_profile(
    inp: &[u8],
    mut builder: crate::output::disassociate_iam_instance_profile_output::Builder,
) -> Result<
    crate::output::disassociate_iam_instance_profile_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateIamInstanceProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateIamInstanceProfileResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("iamInstanceProfileAssociation") /* IamInstanceProfileAssociation com.amazonaws.ec2.synthetic#DisassociateIamInstanceProfileOutput$IamInstanceProfileAssociation */ =>  {
                let var_560 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_iam_instance_profile_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_instance_profile_association(var_560);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_instance_event_window(
    inp: &[u8],
    mut builder: crate::output::disassociate_instance_event_window_output::Builder,
) -> Result<
    crate::output::disassociate_instance_event_window_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateInstanceEventWindowResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateInstanceEventWindowResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindow") /* InstanceEventWindow com.amazonaws.ec2.synthetic#DisassociateInstanceEventWindowOutput$InstanceEventWindow */ =>  {
                let var_561 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_window(var_561);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_subnet_cidr_block(
    inp: &[u8],
    mut builder: crate::output::disassociate_subnet_cidr_block_output::Builder,
) -> Result<
    crate::output::disassociate_subnet_cidr_block_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateSubnetCidrBlockResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateSubnetCidrBlockResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6CidrBlockAssociation") /* Ipv6CidrBlockAssociation com.amazonaws.ec2.synthetic#DisassociateSubnetCidrBlockOutput$Ipv6CidrBlockAssociation */ =>  {
                let var_562 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet_ipv6_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association(var_562);
            }
            ,
            s if s.matches("subnetId") /* SubnetId com.amazonaws.ec2.synthetic#DisassociateSubnetCidrBlockOutput$SubnetId */ =>  {
                let var_563 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_id(var_563);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_transit_gateway_multicast_domain(
    inp: &[u8],
    mut builder: crate::output::disassociate_transit_gateway_multicast_domain_output::Builder,
) -> Result<
    crate::output::disassociate_transit_gateway_multicast_domain_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateTransitGatewayMulticastDomainResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateTransitGatewayMulticastDomainResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associations") /* Associations com.amazonaws.ec2.synthetic#DisassociateTransitGatewayMulticastDomainOutput$Associations */ =>  {
                let var_564 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain_associations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associations(var_564);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_transit_gateway_route_table(
    inp: &[u8],
    mut builder: crate::output::disassociate_transit_gateway_route_table_output::Builder,
) -> Result<
    crate::output::disassociate_transit_gateway_route_table_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateTransitGatewayRouteTableResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateTransitGatewayRouteTableResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("association") /* Association com.amazonaws.ec2.synthetic#DisassociateTransitGatewayRouteTableOutput$Association */ =>  {
                let var_565 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_association(var_565);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_trunk_interface(
    inp: &[u8],
    mut builder: crate::output::disassociate_trunk_interface_output::Builder,
) -> Result<
    crate::output::disassociate_trunk_interface_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateTrunkInterfaceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateTrunkInterfaceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#DisassociateTrunkInterfaceOutput$Return */ =>  {
                let var_566 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_566);
            }
            ,
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#DisassociateTrunkInterfaceOutput$ClientToken */ =>  {
                let var_567 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_567);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_vpc_cidr_block(
    inp: &[u8],
    mut builder: crate::output::disassociate_vpc_cidr_block_output::Builder,
) -> Result<
    crate::output::disassociate_vpc_cidr_block_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateVpcCidrBlockResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateVpcCidrBlockResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6CidrBlockAssociation") /* Ipv6CidrBlockAssociation com.amazonaws.ec2.synthetic#DisassociateVpcCidrBlockOutput$Ipv6CidrBlockAssociation */ =>  {
                let var_568 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_ipv6_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association(var_568);
            }
            ,
            s if s.matches("cidrBlockAssociation") /* CidrBlockAssociation com.amazonaws.ec2.synthetic#DisassociateVpcCidrBlockOutput$CidrBlockAssociation */ =>  {
                let var_569 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_cidr_block_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cidr_block_association(var_569);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2.synthetic#DisassociateVpcCidrBlockOutput$VpcId */ =>  {
                let var_570 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_570);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_ebs_encryption_by_default(
    inp: &[u8],
    mut builder: crate::output::enable_ebs_encryption_by_default_output::Builder,
) -> Result<
    crate::output::enable_ebs_encryption_by_default_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableEbsEncryptionByDefaultResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableEbsEncryptionByDefaultResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ebsEncryptionByDefault") /* EbsEncryptionByDefault com.amazonaws.ec2.synthetic#EnableEbsEncryptionByDefaultOutput$EbsEncryptionByDefault */ =>  {
                let var_571 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ebs_encryption_by_default(var_571);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_fast_snapshot_restores(
    inp: &[u8],
    mut builder: crate::output::enable_fast_snapshot_restores_output::Builder,
) -> Result<
    crate::output::enable_fast_snapshot_restores_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableFastSnapshotRestoresResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableFastSnapshotRestoresResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successful") /* Successful com.amazonaws.ec2.synthetic#EnableFastSnapshotRestoresOutput$Successful */ =>  {
                let var_572 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_enable_fast_snapshot_restore_success_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful(var_572);
            }
            ,
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#EnableFastSnapshotRestoresOutput$Unsuccessful */ =>  {
                let var_573 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_enable_fast_snapshot_restore_error_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_573);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_image_deprecation(
    inp: &[u8],
    mut builder: crate::output::enable_image_deprecation_output::Builder,
) -> Result<crate::output::enable_image_deprecation_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableImageDeprecationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableImageDeprecationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#EnableImageDeprecationOutput$Return */ =>  {
                let var_574 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_574);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_ipam_organization_admin_account(
    inp: &[u8],
    mut builder: crate::output::enable_ipam_organization_admin_account_output::Builder,
) -> Result<
    crate::output::enable_ipam_organization_admin_account_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableIpamOrganizationAdminAccountResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableIpamOrganizationAdminAccountResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("success") /* Success com.amazonaws.ec2.synthetic#EnableIpamOrganizationAdminAccountOutput$Success */ =>  {
                let var_575 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_success(var_575);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_serial_console_access(
    inp: &[u8],
    mut builder: crate::output::enable_serial_console_access_output::Builder,
) -> Result<
    crate::output::enable_serial_console_access_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableSerialConsoleAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableSerialConsoleAccessResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serialConsoleAccessEnabled") /* SerialConsoleAccessEnabled com.amazonaws.ec2.synthetic#EnableSerialConsoleAccessOutput$SerialConsoleAccessEnabled */ =>  {
                let var_576 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_serial_console_access_enabled(var_576);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_transit_gateway_route_table_propagation(
    inp: &[u8],
    mut builder: crate::output::enable_transit_gateway_route_table_propagation_output::Builder,
) -> Result<
    crate::output::enable_transit_gateway_route_table_propagation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableTransitGatewayRouteTablePropagationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableTransitGatewayRouteTablePropagationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("propagation") /* Propagation com.amazonaws.ec2.synthetic#EnableTransitGatewayRouteTablePropagationOutput$Propagation */ =>  {
                let var_577 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_propagation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_propagation(var_577);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_vpc_classic_link(
    inp: &[u8],
    mut builder: crate::output::enable_vpc_classic_link_output::Builder,
) -> Result<crate::output::enable_vpc_classic_link_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableVpcClassicLinkResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableVpcClassicLinkResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#EnableVpcClassicLinkOutput$Return */ =>  {
                let var_578 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_578);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_vpc_classic_link_dns_support(
    inp: &[u8],
    mut builder: crate::output::enable_vpc_classic_link_dns_support_output::Builder,
) -> Result<
    crate::output::enable_vpc_classic_link_dns_support_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableVpcClassicLinkDnsSupportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableVpcClassicLinkDnsSupportResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#EnableVpcClassicLinkDnsSupportOutput$Return */ =>  {
                let var_579 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_579);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_export_client_vpn_client_certificate_revocation_list(
    inp: &[u8],
    mut builder: crate::output::export_client_vpn_client_certificate_revocation_list_output::Builder,
) -> Result<
    crate::output::export_client_vpn_client_certificate_revocation_list_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ExportClientVpnClientCertificateRevocationListResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!("invalid root, expected ExportClientVpnClientCertificateRevocationListResponse got {:?}", start_el)));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("certificateRevocationList") /* CertificateRevocationList com.amazonaws.ec2.synthetic#ExportClientVpnClientCertificateRevocationListOutput$CertificateRevocationList */ =>  {
                let var_580 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_revocation_list(var_580);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#ExportClientVpnClientCertificateRevocationListOutput$Status */ =>  {
                let var_581 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_certificate_revocation_list_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_581);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_export_client_vpn_client_configuration(
    inp: &[u8],
    mut builder: crate::output::export_client_vpn_client_configuration_output::Builder,
) -> Result<
    crate::output::export_client_vpn_client_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ExportClientVpnClientConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ExportClientVpnClientConfigurationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientConfiguration") /* ClientConfiguration com.amazonaws.ec2.synthetic#ExportClientVpnClientConfigurationOutput$ClientConfiguration */ =>  {
                let var_582 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_configuration(var_582);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_export_image(
    inp: &[u8],
    mut builder: crate::output::export_image_output::Builder,
) -> Result<crate::output::export_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ExportImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ExportImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#ExportImageOutput$Description */ =>  {
                let var_583 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_583);
            }
            ,
            s if s.matches("diskImageFormat") /* DiskImageFormat com.amazonaws.ec2.synthetic#ExportImageOutput$DiskImageFormat */ =>  {
                let var_584 =
                    Some(
                        Result::<crate::model::DiskImageFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DiskImageFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_disk_image_format(var_584);
            }
            ,
            s if s.matches("exportImageTaskId") /* ExportImageTaskId com.amazonaws.ec2.synthetic#ExportImageOutput$ExportImageTaskId */ =>  {
                let var_585 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_export_image_task_id(var_585);
            }
            ,
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#ExportImageOutput$ImageId */ =>  {
                let var_586 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_586);
            }
            ,
            s if s.matches("roleName") /* RoleName com.amazonaws.ec2.synthetic#ExportImageOutput$RoleName */ =>  {
                let var_587 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_name(var_587);
            }
            ,
            s if s.matches("progress") /* Progress com.amazonaws.ec2.synthetic#ExportImageOutput$Progress */ =>  {
                let var_588 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_progress(var_588);
            }
            ,
            s if s.matches("s3ExportLocation") /* S3ExportLocation com.amazonaws.ec2.synthetic#ExportImageOutput$S3ExportLocation */ =>  {
                let var_589 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_export_task_s3_location(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_export_location(var_589);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#ExportImageOutput$Status */ =>  {
                let var_590 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_590);
            }
            ,
            s if s.matches("statusMessage") /* StatusMessage com.amazonaws.ec2.synthetic#ExportImageOutput$StatusMessage */ =>  {
                let var_591 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_message(var_591);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#ExportImageOutput$Tags */ =>  {
                let var_592 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_592);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_export_transit_gateway_routes(
    inp: &[u8],
    mut builder: crate::output::export_transit_gateway_routes_output::Builder,
) -> Result<
    crate::output::export_transit_gateway_routes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ExportTransitGatewayRoutesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ExportTransitGatewayRoutesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("s3Location") /* S3Location com.amazonaws.ec2.synthetic#ExportTransitGatewayRoutesOutput$S3Location */ =>  {
                let var_593 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_location(var_593);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_associated_enclave_certificate_iam_roles(
    inp: &[u8],
    mut builder: crate::output::get_associated_enclave_certificate_iam_roles_output::Builder,
) -> Result<
    crate::output::get_associated_enclave_certificate_iam_roles_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAssociatedEnclaveCertificateIamRolesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAssociatedEnclaveCertificateIamRolesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associatedRoleSet") /* AssociatedRoles com.amazonaws.ec2.synthetic#GetAssociatedEnclaveCertificateIamRolesOutput$AssociatedRoles */ =>  {
                let var_594 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_associated_roles_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associated_roles(var_594);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_associated_ipv6_pool_cidrs(
    inp: &[u8],
    mut builder: crate::output::get_associated_ipv6_pool_cidrs_output::Builder,
) -> Result<
    crate::output::get_associated_ipv6_pool_cidrs_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAssociatedIpv6PoolCidrsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAssociatedIpv6PoolCidrsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipv6CidrAssociationSet") /* Ipv6CidrAssociations com.amazonaws.ec2.synthetic#GetAssociatedIpv6PoolCidrsOutput$Ipv6CidrAssociations */ =>  {
                let var_595 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipv6_cidr_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_associations(var_595);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetAssociatedIpv6PoolCidrsOutput$NextToken */ =>  {
                let var_596 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_596);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_capacity_reservation_usage(
    inp: &[u8],
    mut builder: crate::output::get_capacity_reservation_usage_output::Builder,
) -> Result<
    crate::output::get_capacity_reservation_usage_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetCapacityReservationUsageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetCapacityReservationUsageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$NextToken */ =>  {
                let var_597 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_597);
            }
            ,
            s if s.matches("capacityReservationId") /* CapacityReservationId com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$CapacityReservationId */ =>  {
                let var_598 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_id(var_598);
            }
            ,
            s if s.matches("instanceType") /* InstanceType com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$InstanceType */ =>  {
                let var_599 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_type(var_599);
            }
            ,
            s if s.matches("totalInstanceCount") /* TotalInstanceCount com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$TotalInstanceCount */ =>  {
                let var_600 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_instance_count(var_600);
            }
            ,
            s if s.matches("availableInstanceCount") /* AvailableInstanceCount com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$AvailableInstanceCount */ =>  {
                let var_601 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_available_instance_count(var_601);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$State */ =>  {
                let var_602 =
                    Some(
                        Result::<crate::model::CapacityReservationState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CapacityReservationState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_602);
            }
            ,
            s if s.matches("instanceUsageSet") /* InstanceUsages com.amazonaws.ec2.synthetic#GetCapacityReservationUsageOutput$InstanceUsages */ =>  {
                let var_603 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_usage_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_usages(var_603);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_coip_pool_usage(
    inp: &[u8],
    mut builder: crate::output::get_coip_pool_usage_output::Builder,
) -> Result<crate::output::get_coip_pool_usage_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetCoipPoolUsageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetCoipPoolUsageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("coipPoolId") /* CoipPoolId com.amazonaws.ec2.synthetic#GetCoipPoolUsageOutput$CoipPoolId */ =>  {
                let var_604 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_coip_pool_id(var_604);
            }
            ,
            s if s.matches("coipAddressUsageSet") /* CoipAddressUsages com.amazonaws.ec2.synthetic#GetCoipPoolUsageOutput$CoipAddressUsages */ =>  {
                let var_605 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_coip_address_usage_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_coip_address_usages(var_605);
            }
            ,
            s if s.matches("localGatewayRouteTableId") /* LocalGatewayRouteTableId com.amazonaws.ec2.synthetic#GetCoipPoolUsageOutput$LocalGatewayRouteTableId */ =>  {
                let var_606 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_local_gateway_route_table_id(var_606);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_console_output(
    inp: &[u8],
    mut builder: crate::output::get_console_output_output::Builder,
) -> Result<crate::output::get_console_output_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetConsoleOutputResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetConsoleOutputResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#GetConsoleOutputOutput$InstanceId */ =>  {
                let var_607 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_607);
            }
            ,
            s if s.matches("output") /* Output com.amazonaws.ec2.synthetic#GetConsoleOutputOutput$Output */ =>  {
                let var_608 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_output(var_608);
            }
            ,
            s if s.matches("timestamp") /* Timestamp com.amazonaws.ec2.synthetic#GetConsoleOutputOutput$Timestamp */ =>  {
                let var_609 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_609);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_console_screenshot(
    inp: &[u8],
    mut builder: crate::output::get_console_screenshot_output::Builder,
) -> Result<crate::output::get_console_screenshot_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetConsoleScreenshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetConsoleScreenshotResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imageData") /* ImageData com.amazonaws.ec2.synthetic#GetConsoleScreenshotOutput$ImageData */ =>  {
                let var_610 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_data(var_610);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#GetConsoleScreenshotOutput$InstanceId */ =>  {
                let var_611 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_611);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_default_credit_specification(
    inp: &[u8],
    mut builder: crate::output::get_default_credit_specification_output::Builder,
) -> Result<
    crate::output::get_default_credit_specification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetDefaultCreditSpecificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetDefaultCreditSpecificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceFamilyCreditSpecification") /* InstanceFamilyCreditSpecification com.amazonaws.ec2.synthetic#GetDefaultCreditSpecificationOutput$InstanceFamilyCreditSpecification */ =>  {
                let var_612 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_family_credit_specification(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_family_credit_specification(var_612);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ebs_default_kms_key_id(
    inp: &[u8],
    mut builder: crate::output::get_ebs_default_kms_key_id_output::Builder,
) -> Result<
    crate::output::get_ebs_default_kms_key_id_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetEbsDefaultKmsKeyIdResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetEbsDefaultKmsKeyIdResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#GetEbsDefaultKmsKeyIdOutput$KmsKeyId */ =>  {
                let var_613 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_613);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ebs_encryption_by_default(
    inp: &[u8],
    mut builder: crate::output::get_ebs_encryption_by_default_output::Builder,
) -> Result<
    crate::output::get_ebs_encryption_by_default_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetEbsEncryptionByDefaultResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetEbsEncryptionByDefaultResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ebsEncryptionByDefault") /* EbsEncryptionByDefault com.amazonaws.ec2.synthetic#GetEbsEncryptionByDefaultOutput$EbsEncryptionByDefault */ =>  {
                let var_614 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ebs_encryption_by_default(var_614);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_flow_logs_integration_template(
    inp: &[u8],
    mut builder: crate::output::get_flow_logs_integration_template_output::Builder,
) -> Result<
    crate::output::get_flow_logs_integration_template_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetFlowLogsIntegrationTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetFlowLogsIntegrationTemplateResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("result") /* Result com.amazonaws.ec2.synthetic#GetFlowLogsIntegrationTemplateOutput$Result */ =>  {
                let var_615 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_result(var_615);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_groups_for_capacity_reservation(
    inp: &[u8],
    mut builder: crate::output::get_groups_for_capacity_reservation_output::Builder,
) -> Result<
    crate::output::get_groups_for_capacity_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetGroupsForCapacityReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetGroupsForCapacityReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetGroupsForCapacityReservationOutput$NextToken */ =>  {
                let var_616 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_616);
            }
            ,
            s if s.matches("capacityReservationGroupSet") /* CapacityReservationGroups com.amazonaws.ec2.synthetic#GetGroupsForCapacityReservationOutput$CapacityReservationGroups */ =>  {
                let var_617 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_capacity_reservation_group_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_groups(var_617);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_host_reservation_purchase_preview(
    inp: &[u8],
    mut builder: crate::output::get_host_reservation_purchase_preview_output::Builder,
) -> Result<
    crate::output::get_host_reservation_purchase_preview_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetHostReservationPurchasePreviewResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetHostReservationPurchasePreviewResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("currencyCode") /* CurrencyCode com.amazonaws.ec2.synthetic#GetHostReservationPurchasePreviewOutput$CurrencyCode */ =>  {
                let var_618 =
                    Some(
                        Result::<crate::model::CurrencyCodeValues, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CurrencyCodeValues::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_currency_code(var_618);
            }
            ,
            s if s.matches("purchase") /* Purchase com.amazonaws.ec2.synthetic#GetHostReservationPurchasePreviewOutput$Purchase */ =>  {
                let var_619 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_purchase_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_purchase(var_619);
            }
            ,
            s if s.matches("totalHourlyPrice") /* TotalHourlyPrice com.amazonaws.ec2.synthetic#GetHostReservationPurchasePreviewOutput$TotalHourlyPrice */ =>  {
                let var_620 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_total_hourly_price(var_620);
            }
            ,
            s if s.matches("totalUpfrontPrice") /* TotalUpfrontPrice com.amazonaws.ec2.synthetic#GetHostReservationPurchasePreviewOutput$TotalUpfrontPrice */ =>  {
                let var_621 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_total_upfront_price(var_621);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_instance_types_from_instance_requirements(
    inp: &[u8],
    mut builder: crate::output::get_instance_types_from_instance_requirements_output::Builder,
) -> Result<
    crate::output::get_instance_types_from_instance_requirements_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetInstanceTypesFromInstanceRequirementsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetInstanceTypesFromInstanceRequirementsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTypeSet") /* InstanceTypes com.amazonaws.ec2.synthetic#GetInstanceTypesFromInstanceRequirementsOutput$InstanceTypes */ =>  {
                let var_622 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_type_info_from_instance_requirements_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_types(var_622);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetInstanceTypesFromInstanceRequirementsOutput$NextToken */ =>  {
                let var_623 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_623);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ipam_address_history(
    inp: &[u8],
    mut builder: crate::output::get_ipam_address_history_output::Builder,
) -> Result<crate::output::get_ipam_address_history_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIpamAddressHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIpamAddressHistoryResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("historyRecordSet") /* HistoryRecords com.amazonaws.ec2.synthetic#GetIpamAddressHistoryOutput$HistoryRecords */ =>  {
                let var_624 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_address_history_record_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_history_records(var_624);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetIpamAddressHistoryOutput$NextToken */ =>  {
                let var_625 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_625);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ipam_pool_allocations(
    inp: &[u8],
    mut builder: crate::output::get_ipam_pool_allocations_output::Builder,
) -> Result<
    crate::output::get_ipam_pool_allocations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIpamPoolAllocationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIpamPoolAllocationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPoolAllocationSet") /* IpamPoolAllocations com.amazonaws.ec2.synthetic#GetIpamPoolAllocationsOutput$IpamPoolAllocations */ =>  {
                let var_626 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_pool_allocation_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_allocations(var_626);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetIpamPoolAllocationsOutput$NextToken */ =>  {
                let var_627 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_627);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ipam_pool_cidrs(
    inp: &[u8],
    mut builder: crate::output::get_ipam_pool_cidrs_output::Builder,
) -> Result<crate::output::get_ipam_pool_cidrs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIpamPoolCidrsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIpamPoolCidrsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPoolCidrSet") /* IpamPoolCidrs com.amazonaws.ec2.synthetic#GetIpamPoolCidrsOutput$IpamPoolCidrs */ =>  {
                let var_628 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_pool_cidr_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_cidrs(var_628);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetIpamPoolCidrsOutput$NextToken */ =>  {
                let var_629 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_629);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ipam_resource_cidrs(
    inp: &[u8],
    mut builder: crate::output::get_ipam_resource_cidrs_output::Builder,
) -> Result<crate::output::get_ipam_resource_cidrs_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetIpamResourceCidrsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetIpamResourceCidrsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetIpamResourceCidrsOutput$NextToken */ =>  {
                let var_630 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_630);
            }
            ,
            s if s.matches("ipamResourceCidrSet") /* IpamResourceCidrs com.amazonaws.ec2.synthetic#GetIpamResourceCidrsOutput$IpamResourceCidrs */ =>  {
                let var_631 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipam_resource_cidr_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_resource_cidrs(var_631);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_launch_template_data(
    inp: &[u8],
    mut builder: crate::output::get_launch_template_data_output::Builder,
) -> Result<crate::output::get_launch_template_data_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetLaunchTemplateDataResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetLaunchTemplateDataResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplateData") /* LaunchTemplateData com.amazonaws.ec2.synthetic#GetLaunchTemplateDataOutput$LaunchTemplateData */ =>  {
                let var_632 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_response_launch_template_data(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template_data(var_632);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_managed_prefix_list_associations(
    inp: &[u8],
    mut builder: crate::output::get_managed_prefix_list_associations_output::Builder,
) -> Result<
    crate::output::get_managed_prefix_list_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetManagedPrefixListAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetManagedPrefixListAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("prefixListAssociationSet") /* PrefixListAssociations com.amazonaws.ec2.synthetic#GetManagedPrefixListAssociationsOutput$PrefixListAssociations */ =>  {
                let var_633 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_prefix_list_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_list_associations(var_633);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetManagedPrefixListAssociationsOutput$NextToken */ =>  {
                let var_634 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_634);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_managed_prefix_list_entries(
    inp: &[u8],
    mut builder: crate::output::get_managed_prefix_list_entries_output::Builder,
) -> Result<
    crate::output::get_managed_prefix_list_entries_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetManagedPrefixListEntriesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetManagedPrefixListEntriesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entrySet") /* Entries com.amazonaws.ec2.synthetic#GetManagedPrefixListEntriesOutput$Entries */ =>  {
                let var_635 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_prefix_list_entry_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_entries(var_635);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetManagedPrefixListEntriesOutput$NextToken */ =>  {
                let var_636 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_636);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_network_insights_access_scope_analysis_findings(
    inp: &[u8],
    mut builder: crate::output::get_network_insights_access_scope_analysis_findings_output::Builder,
) -> Result<
    crate::output::get_network_insights_access_scope_analysis_findings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetNetworkInsightsAccessScopeAnalysisFindingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetNetworkInsightsAccessScopeAnalysisFindingsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeAnalysisId") /* NetworkInsightsAccessScopeAnalysisId com.amazonaws.ec2.synthetic#GetNetworkInsightsAccessScopeAnalysisFindingsOutput$NetworkInsightsAccessScopeAnalysisId */ =>  {
                let var_637 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_analysis_id(var_637);
            }
            ,
            s if s.matches("analysisStatus") /* AnalysisStatus com.amazonaws.ec2.synthetic#GetNetworkInsightsAccessScopeAnalysisFindingsOutput$AnalysisStatus */ =>  {
                let var_638 =
                    Some(
                        Result::<crate::model::AnalysisStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AnalysisStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_analysis_status(var_638);
            }
            ,
            s if s.matches("analysisFindingSet") /* AnalysisFindings com.amazonaws.ec2.synthetic#GetNetworkInsightsAccessScopeAnalysisFindingsOutput$AnalysisFindings */ =>  {
                let var_639 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_access_scope_analysis_finding_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_analysis_findings(var_639);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetNetworkInsightsAccessScopeAnalysisFindingsOutput$NextToken */ =>  {
                let var_640 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_640);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_network_insights_access_scope_content(
    inp: &[u8],
    mut builder: crate::output::get_network_insights_access_scope_content_output::Builder,
) -> Result<
    crate::output::get_network_insights_access_scope_content_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetNetworkInsightsAccessScopeContentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetNetworkInsightsAccessScopeContentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeContent") /* NetworkInsightsAccessScopeContent com.amazonaws.ec2.synthetic#GetNetworkInsightsAccessScopeContentOutput$NetworkInsightsAccessScopeContent */ =>  {
                let var_641 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_access_scope_content(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_content(var_641);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_password_data(
    inp: &[u8],
    mut builder: crate::output::get_password_data_output::Builder,
) -> Result<crate::output::get_password_data_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetPasswordDataResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetPasswordDataResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#GetPasswordDataOutput$InstanceId */ =>  {
                let var_642 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_642);
            }
            ,
            s if s.matches("passwordData") /* PasswordData com.amazonaws.ec2.synthetic#GetPasswordDataOutput$PasswordData */ =>  {
                let var_643 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_password_data(var_643);
            }
            ,
            s if s.matches("timestamp") /* Timestamp com.amazonaws.ec2.synthetic#GetPasswordDataOutput$Timestamp */ =>  {
                let var_644 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_644);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_reserved_instances_exchange_quote(
    inp: &[u8],
    mut builder: crate::output::get_reserved_instances_exchange_quote_output::Builder,
) -> Result<
    crate::output::get_reserved_instances_exchange_quote_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetReservedInstancesExchangeQuoteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetReservedInstancesExchangeQuoteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("currencyCode") /* CurrencyCode com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$CurrencyCode */ =>  {
                let var_645 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_currency_code(var_645);
            }
            ,
            s if s.matches("isValidExchange") /* IsValidExchange com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$IsValidExchange */ =>  {
                let var_646 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_valid_exchange(var_646);
            }
            ,
            s if s.matches("outputReservedInstancesWillExpireAt") /* OutputReservedInstancesWillExpireAt com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$OutputReservedInstancesWillExpireAt */ =>  {
                let var_647 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_output_reserved_instances_will_expire_at(var_647);
            }
            ,
            s if s.matches("paymentDue") /* PaymentDue com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$PaymentDue */ =>  {
                let var_648 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_payment_due(var_648);
            }
            ,
            s if s.matches("reservedInstanceValueRollup") /* ReservedInstanceValueRollup com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$ReservedInstanceValueRollup */ =>  {
                let var_649 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_reservation_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instance_value_rollup(var_649);
            }
            ,
            s if s.matches("reservedInstanceValueSet") /* ReservedInstanceValueSet com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$ReservedInstanceValueSet */ =>  {
                let var_650 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_reserved_instance_reservation_value_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_instance_value_set(var_650);
            }
            ,
            s if s.matches("targetConfigurationValueRollup") /* TargetConfigurationValueRollup com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$TargetConfigurationValueRollup */ =>  {
                let var_651 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_reservation_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_configuration_value_rollup(var_651);
            }
            ,
            s if s.matches("targetConfigurationValueSet") /* TargetConfigurationValueSet com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$TargetConfigurationValueSet */ =>  {
                let var_652 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_target_reservation_value_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_configuration_value_set(var_652);
            }
            ,
            s if s.matches("validationFailureReason") /* ValidationFailureReason com.amazonaws.ec2.synthetic#GetReservedInstancesExchangeQuoteOutput$ValidationFailureReason */ =>  {
                let var_653 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_validation_failure_reason(var_653);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_serial_console_access_status(
    inp: &[u8],
    mut builder: crate::output::get_serial_console_access_status_output::Builder,
) -> Result<
    crate::output::get_serial_console_access_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSerialConsoleAccessStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSerialConsoleAccessStatusResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("serialConsoleAccessEnabled") /* SerialConsoleAccessEnabled com.amazonaws.ec2.synthetic#GetSerialConsoleAccessStatusOutput$SerialConsoleAccessEnabled */ =>  {
                let var_654 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_serial_console_access_enabled(var_654);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_spot_placement_scores(
    inp: &[u8],
    mut builder: crate::output::get_spot_placement_scores_output::Builder,
) -> Result<
    crate::output::get_spot_placement_scores_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSpotPlacementScoresResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSpotPlacementScoresResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotPlacementScoreSet") /* SpotPlacementScores com.amazonaws.ec2.synthetic#GetSpotPlacementScoresOutput$SpotPlacementScores */ =>  {
                let var_655 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_spot_placement_scores(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_placement_scores(var_655);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetSpotPlacementScoresOutput$NextToken */ =>  {
                let var_656 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_656);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_subnet_cidr_reservations(
    inp: &[u8],
    mut builder: crate::output::get_subnet_cidr_reservations_output::Builder,
) -> Result<
    crate::output::get_subnet_cidr_reservations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSubnetCidrReservationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSubnetCidrReservationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("subnetIpv4CidrReservationSet") /* SubnetIpv4CidrReservations com.amazonaws.ec2.synthetic#GetSubnetCidrReservationsOutput$SubnetIpv4CidrReservations */ =>  {
                let var_657 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_subnet_cidr_reservation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet_ipv4_cidr_reservations(var_657);
            }
            ,
            s if s.matches("subnetIpv6CidrReservationSet") /* SubnetIpv6CidrReservations com.amazonaws.ec2.synthetic#GetSubnetCidrReservationsOutput$SubnetIpv6CidrReservations */ =>  {
                let var_658 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_subnet_cidr_reservation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet_ipv6_cidr_reservations(var_658);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetSubnetCidrReservationsOutput$NextToken */ =>  {
                let var_659 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_659);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_transit_gateway_attachment_propagations(
    inp: &[u8],
    mut builder: crate::output::get_transit_gateway_attachment_propagations_output::Builder,
) -> Result<
    crate::output::get_transit_gateway_attachment_propagations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTransitGatewayAttachmentPropagationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTransitGatewayAttachmentPropagationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayAttachmentPropagations") /* TransitGatewayAttachmentPropagations com.amazonaws.ec2.synthetic#GetTransitGatewayAttachmentPropagationsOutput$TransitGatewayAttachmentPropagations */ =>  {
                let var_660 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_attachment_propagation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachment_propagations(var_660);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetTransitGatewayAttachmentPropagationsOutput$NextToken */ =>  {
                let var_661 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_661);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_transit_gateway_multicast_domain_associations(
    inp: &[u8],
    mut builder: crate::output::get_transit_gateway_multicast_domain_associations_output::Builder,
) -> Result<
    crate::output::get_transit_gateway_multicast_domain_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTransitGatewayMulticastDomainAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTransitGatewayMulticastDomainAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("multicastDomainAssociations") /* MulticastDomainAssociations com.amazonaws.ec2.synthetic#GetTransitGatewayMulticastDomainAssociationsOutput$MulticastDomainAssociations */ =>  {
                let var_662 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_multicast_domain_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_multicast_domain_associations(var_662);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetTransitGatewayMulticastDomainAssociationsOutput$NextToken */ =>  {
                let var_663 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_663);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_transit_gateway_prefix_list_references(
    inp: &[u8],
    mut builder: crate::output::get_transit_gateway_prefix_list_references_output::Builder,
) -> Result<
    crate::output::get_transit_gateway_prefix_list_references_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTransitGatewayPrefixListReferencesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTransitGatewayPrefixListReferencesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPrefixListReferenceSet") /* TransitGatewayPrefixListReferences com.amazonaws.ec2.synthetic#GetTransitGatewayPrefixListReferencesOutput$TransitGatewayPrefixListReferences */ =>  {
                let var_664 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_prefix_list_reference_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_prefix_list_references(var_664);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetTransitGatewayPrefixListReferencesOutput$NextToken */ =>  {
                let var_665 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_665);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_transit_gateway_route_table_associations(
    inp: &[u8],
    mut builder: crate::output::get_transit_gateway_route_table_associations_output::Builder,
) -> Result<
    crate::output::get_transit_gateway_route_table_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTransitGatewayRouteTableAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTransitGatewayRouteTableAssociationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associations") /* Associations com.amazonaws.ec2.synthetic#GetTransitGatewayRouteTableAssociationsOutput$Associations */ =>  {
                let var_666 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_route_table_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associations(var_666);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetTransitGatewayRouteTableAssociationsOutput$NextToken */ =>  {
                let var_667 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_667);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_transit_gateway_route_table_propagations(
    inp: &[u8],
    mut builder: crate::output::get_transit_gateway_route_table_propagations_output::Builder,
) -> Result<
    crate::output::get_transit_gateway_route_table_propagations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetTransitGatewayRouteTablePropagationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetTransitGatewayRouteTablePropagationsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayRouteTablePropagations") /* TransitGatewayRouteTablePropagations com.amazonaws.ec2.synthetic#GetTransitGatewayRouteTablePropagationsOutput$TransitGatewayRouteTablePropagations */ =>  {
                let var_668 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_route_table_propagation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_route_table_propagations(var_668);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetTransitGatewayRouteTablePropagationsOutput$NextToken */ =>  {
                let var_669 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_669);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_vpn_connection_device_sample_configuration(
    inp: &[u8],
    mut builder: crate::output::get_vpn_connection_device_sample_configuration_output::Builder,
) -> Result<
    crate::output::get_vpn_connection_device_sample_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetVpnConnectionDeviceSampleConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetVpnConnectionDeviceSampleConfigurationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnectionDeviceSampleConfiguration") /* VpnConnectionDeviceSampleConfiguration com.amazonaws.ec2.synthetic#GetVpnConnectionDeviceSampleConfigurationOutput$VpnConnectionDeviceSampleConfiguration */ =>  {
                let var_670 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpn_connection_device_sample_configuration(var_670);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_vpn_connection_device_types(
    inp: &[u8],
    mut builder: crate::output::get_vpn_connection_device_types_output::Builder,
) -> Result<
    crate::output::get_vpn_connection_device_types_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetVpnConnectionDeviceTypesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetVpnConnectionDeviceTypesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnectionDeviceTypeSet") /* VpnConnectionDeviceTypes com.amazonaws.ec2.synthetic#GetVpnConnectionDeviceTypesOutput$VpnConnectionDeviceTypes */ =>  {
                let var_671 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpn_connection_device_type_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection_device_types(var_671);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#GetVpnConnectionDeviceTypesOutput$NextToken */ =>  {
                let var_672 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_672);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_client_vpn_client_certificate_revocation_list(
    inp: &[u8],
    mut builder: crate::output::import_client_vpn_client_certificate_revocation_list_output::Builder,
) -> Result<
    crate::output::import_client_vpn_client_certificate_revocation_list_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportClientVpnClientCertificateRevocationListResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!("invalid root, expected ImportClientVpnClientCertificateRevocationListResponse got {:?}", start_el)));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ImportClientVpnClientCertificateRevocationListOutput$Return */ =>  {
                let var_673 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_673);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_image(
    inp: &[u8],
    mut builder: crate::output::import_image_output::Builder,
) -> Result<crate::output::import_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ImportImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("architecture") /* Architecture com.amazonaws.ec2.synthetic#ImportImageOutput$Architecture */ =>  {
                let var_674 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_architecture(var_674);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#ImportImageOutput$Description */ =>  {
                let var_675 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_675);
            }
            ,
            s if s.matches("encrypted") /* Encrypted com.amazonaws.ec2.synthetic#ImportImageOutput$Encrypted */ =>  {
                let var_676 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_676);
            }
            ,
            s if s.matches("hypervisor") /* Hypervisor com.amazonaws.ec2.synthetic#ImportImageOutput$Hypervisor */ =>  {
                let var_677 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hypervisor(var_677);
            }
            ,
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#ImportImageOutput$ImageId */ =>  {
                let var_678 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_678);
            }
            ,
            s if s.matches("importTaskId") /* ImportTaskId com.amazonaws.ec2.synthetic#ImportImageOutput$ImportTaskId */ =>  {
                let var_679 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_import_task_id(var_679);
            }
            ,
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#ImportImageOutput$KmsKeyId */ =>  {
                let var_680 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_680);
            }
            ,
            s if s.matches("licenseType") /* LicenseType com.amazonaws.ec2.synthetic#ImportImageOutput$LicenseType */ =>  {
                let var_681 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_license_type(var_681);
            }
            ,
            s if s.matches("platform") /* Platform com.amazonaws.ec2.synthetic#ImportImageOutput$Platform */ =>  {
                let var_682 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_platform(var_682);
            }
            ,
            s if s.matches("progress") /* Progress com.amazonaws.ec2.synthetic#ImportImageOutput$Progress */ =>  {
                let var_683 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_progress(var_683);
            }
            ,
            s if s.matches("snapshotDetailSet") /* SnapshotDetails com.amazonaws.ec2.synthetic#ImportImageOutput$SnapshotDetails */ =>  {
                let var_684 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_snapshot_detail_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_details(var_684);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#ImportImageOutput$Status */ =>  {
                let var_685 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_685);
            }
            ,
            s if s.matches("statusMessage") /* StatusMessage com.amazonaws.ec2.synthetic#ImportImageOutput$StatusMessage */ =>  {
                let var_686 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_message(var_686);
            }
            ,
            s if s.matches("licenseSpecifications") /* LicenseSpecifications com.amazonaws.ec2.synthetic#ImportImageOutput$LicenseSpecifications */ =>  {
                let var_687 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_import_image_license_specification_list_response(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_license_specifications(var_687);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#ImportImageOutput$Tags */ =>  {
                let var_688 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_688);
            }
            ,
            s if s.matches("usageOperation") /* UsageOperation com.amazonaws.ec2.synthetic#ImportImageOutput$UsageOperation */ =>  {
                let var_689 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_usage_operation(var_689);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_instance(
    inp: &[u8],
    mut builder: crate::output::import_instance_output::Builder,
) -> Result<crate::output::import_instance_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportInstanceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ImportInstanceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("conversionTask") /* ConversionTask com.amazonaws.ec2.synthetic#ImportInstanceOutput$ConversionTask */ =>  {
                let var_690 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_conversion_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_conversion_task(var_690);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_key_pair(
    inp: &[u8],
    mut builder: crate::output::import_key_pair_output::Builder,
) -> Result<crate::output::import_key_pair_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportKeyPairResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ImportKeyPairResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("keyFingerprint") /* KeyFingerprint com.amazonaws.ec2.synthetic#ImportKeyPairOutput$KeyFingerprint */ =>  {
                let var_691 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_fingerprint(var_691);
            }
            ,
            s if s.matches("keyName") /* KeyName com.amazonaws.ec2.synthetic#ImportKeyPairOutput$KeyName */ =>  {
                let var_692 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_name(var_692);
            }
            ,
            s if s.matches("keyPairId") /* KeyPairId com.amazonaws.ec2.synthetic#ImportKeyPairOutput$KeyPairId */ =>  {
                let var_693 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_pair_id(var_693);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#ImportKeyPairOutput$Tags */ =>  {
                let var_694 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_694);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_snapshot(
    inp: &[u8],
    mut builder: crate::output::import_snapshot_output::Builder,
) -> Result<crate::output::import_snapshot_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ImportSnapshotResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#ImportSnapshotOutput$Description */ =>  {
                let var_695 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_695);
            }
            ,
            s if s.matches("importTaskId") /* ImportTaskId com.amazonaws.ec2.synthetic#ImportSnapshotOutput$ImportTaskId */ =>  {
                let var_696 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_import_task_id(var_696);
            }
            ,
            s if s.matches("snapshotTaskDetail") /* SnapshotTaskDetail com.amazonaws.ec2.synthetic#ImportSnapshotOutput$SnapshotTaskDetail */ =>  {
                let var_697 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot_task_detail(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_task_detail(var_697);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2.synthetic#ImportSnapshotOutput$Tags */ =>  {
                let var_698 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_698);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_import_volume(
    inp: &[u8],
    mut builder: crate::output::import_volume_output::Builder,
) -> Result<crate::output::import_volume_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ImportVolumeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ImportVolumeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("conversionTask") /* ConversionTask com.amazonaws.ec2.synthetic#ImportVolumeOutput$ConversionTask */ =>  {
                let var_699 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_conversion_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_conversion_task(var_699);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_snapshots_in_recycle_bin(
    inp: &[u8],
    mut builder: crate::output::list_snapshots_in_recycle_bin_output::Builder,
) -> Result<
    crate::output::list_snapshots_in_recycle_bin_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListSnapshotsInRecycleBinResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListSnapshotsInRecycleBinResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotSet") /* Snapshots com.amazonaws.ec2.synthetic#ListSnapshotsInRecycleBinOutput$Snapshots */ =>  {
                let var_700 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_snapshot_recycle_bin_info_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshots(var_700);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#ListSnapshotsInRecycleBinOutput$NextToken */ =>  {
                let var_701 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_701);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_address_attribute(
    inp: &[u8],
    mut builder: crate::output::modify_address_attribute_output::Builder,
) -> Result<crate::output::modify_address_attribute_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyAddressAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyAddressAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("address") /* Address com.amazonaws.ec2.synthetic#ModifyAddressAttributeOutput$Address */ =>  {
                let var_702 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_address_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_address(var_702);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_availability_zone_group(
    inp: &[u8],
    mut builder: crate::output::modify_availability_zone_group_output::Builder,
) -> Result<
    crate::output::modify_availability_zone_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyAvailabilityZoneGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyAvailabilityZoneGroupResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyAvailabilityZoneGroupOutput$Return */ =>  {
                let var_703 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_703);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_capacity_reservation(
    inp: &[u8],
    mut builder: crate::output::modify_capacity_reservation_output::Builder,
) -> Result<
    crate::output::modify_capacity_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyCapacityReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyCapacityReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyCapacityReservationOutput$Return */ =>  {
                let var_704 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_704);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_capacity_reservation_fleet(
    inp: &[u8],
    mut builder: crate::output::modify_capacity_reservation_fleet_output::Builder,
) -> Result<
    crate::output::modify_capacity_reservation_fleet_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyCapacityReservationFleetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyCapacityReservationFleetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyCapacityReservationFleetOutput$Return */ =>  {
                let var_705 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_705);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_client_vpn_endpoint(
    inp: &[u8],
    mut builder: crate::output::modify_client_vpn_endpoint_output::Builder,
) -> Result<
    crate::output::modify_client_vpn_endpoint_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClientVpnEndpointResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClientVpnEndpointResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyClientVpnEndpointOutput$Return */ =>  {
                let var_706 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_706);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_default_credit_specification(
    inp: &[u8],
    mut builder: crate::output::modify_default_credit_specification_output::Builder,
) -> Result<
    crate::output::modify_default_credit_specification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyDefaultCreditSpecificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyDefaultCreditSpecificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceFamilyCreditSpecification") /* InstanceFamilyCreditSpecification com.amazonaws.ec2.synthetic#ModifyDefaultCreditSpecificationOutput$InstanceFamilyCreditSpecification */ =>  {
                let var_707 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_family_credit_specification(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_family_credit_specification(var_707);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_ebs_default_kms_key_id(
    inp: &[u8],
    mut builder: crate::output::modify_ebs_default_kms_key_id_output::Builder,
) -> Result<
    crate::output::modify_ebs_default_kms_key_id_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyEbsDefaultKmsKeyIdResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyEbsDefaultKmsKeyIdResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#ModifyEbsDefaultKmsKeyIdOutput$KmsKeyId */ =>  {
                let var_708 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_708);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_fleet(
    inp: &[u8],
    mut builder: crate::output::modify_fleet_output::Builder,
) -> Result<crate::output::modify_fleet_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyFleetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyFleetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyFleetOutput$Return */ =>  {
                let var_709 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_709);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_fpga_image_attribute(
    inp: &[u8],
    mut builder: crate::output::modify_fpga_image_attribute_output::Builder,
) -> Result<
    crate::output::modify_fpga_image_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyFpgaImageAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyFpgaImageAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("fpgaImageAttribute") /* FpgaImageAttribute com.amazonaws.ec2.synthetic#ModifyFpgaImageAttributeOutput$FpgaImageAttribute */ =>  {
                let var_710 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_fpga_image_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fpga_image_attribute(var_710);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_hosts(
    inp: &[u8],
    mut builder: crate::output::modify_hosts_output::Builder,
) -> Result<crate::output::modify_hosts_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyHostsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyHostsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successful") /* Successful com.amazonaws.ec2.synthetic#ModifyHostsOutput$Successful */ =>  {
                let var_711 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_response_host_id_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful(var_711);
            }
            ,
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#ModifyHostsOutput$Unsuccessful */ =>  {
                let var_712 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_712);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_capacity_reservation_attributes(
    inp: &[u8],
    mut builder: crate::output::modify_instance_capacity_reservation_attributes_output::Builder,
) -> Result<
    crate::output::modify_instance_capacity_reservation_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstanceCapacityReservationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstanceCapacityReservationAttributesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyInstanceCapacityReservationAttributesOutput$Return */ =>  {
                let var_713 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_713);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_credit_specification(
    inp: &[u8],
    mut builder: crate::output::modify_instance_credit_specification_output::Builder,
) -> Result<
    crate::output::modify_instance_credit_specification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstanceCreditSpecificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstanceCreditSpecificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successfulInstanceCreditSpecificationSet") /* SuccessfulInstanceCreditSpecifications com.amazonaws.ec2.synthetic#ModifyInstanceCreditSpecificationOutput$SuccessfulInstanceCreditSpecifications */ =>  {
                let var_714 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_successful_instance_credit_specification_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful_instance_credit_specifications(var_714);
            }
            ,
            s if s.matches("unsuccessfulInstanceCreditSpecificationSet") /* UnsuccessfulInstanceCreditSpecifications com.amazonaws.ec2.synthetic#ModifyInstanceCreditSpecificationOutput$UnsuccessfulInstanceCreditSpecifications */ =>  {
                let var_715 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_instance_credit_specification_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful_instance_credit_specifications(var_715);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_event_start_time(
    inp: &[u8],
    mut builder: crate::output::modify_instance_event_start_time_output::Builder,
) -> Result<
    crate::output::modify_instance_event_start_time_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstanceEventStartTimeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstanceEventStartTimeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("event") /* Event com.amazonaws.ec2.synthetic#ModifyInstanceEventStartTimeOutput$Event */ =>  {
                let var_716 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_status_event(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event(var_716);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_event_window(
    inp: &[u8],
    mut builder: crate::output::modify_instance_event_window_output::Builder,
) -> Result<
    crate::output::modify_instance_event_window_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstanceEventWindowResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstanceEventWindowResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindow") /* InstanceEventWindow com.amazonaws.ec2.synthetic#ModifyInstanceEventWindowOutput$InstanceEventWindow */ =>  {
                let var_717 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_event_window(var_717);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_metadata_options(
    inp: &[u8],
    mut builder: crate::output::modify_instance_metadata_options_output::Builder,
) -> Result<
    crate::output::modify_instance_metadata_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstanceMetadataOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstanceMetadataOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2.synthetic#ModifyInstanceMetadataOptionsOutput$InstanceId */ =>  {
                let var_718 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_718);
            }
            ,
            s if s.matches("instanceMetadataOptions") /* InstanceMetadataOptions com.amazonaws.ec2.synthetic#ModifyInstanceMetadataOptionsOutput$InstanceMetadataOptions */ =>  {
                let var_719 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_metadata_options_response(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_metadata_options(var_719);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_instance_placement(
    inp: &[u8],
    mut builder: crate::output::modify_instance_placement_output::Builder,
) -> Result<
    crate::output::modify_instance_placement_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyInstancePlacementResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyInstancePlacementResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyInstancePlacementOutput$Return */ =>  {
                let var_720 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_720);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_ipam(
    inp: &[u8],
    mut builder: crate::output::modify_ipam_output::Builder,
) -> Result<crate::output::modify_ipam_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyIpamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyIpamResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipam") /* Ipam com.amazonaws.ec2.synthetic#ModifyIpamOutput$Ipam */ =>  {
                let var_721 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam(var_721);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_ipam_pool(
    inp: &[u8],
    mut builder: crate::output::modify_ipam_pool_output::Builder,
) -> Result<crate::output::modify_ipam_pool_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyIpamPoolResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyIpamPoolResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPool") /* IpamPool com.amazonaws.ec2.synthetic#ModifyIpamPoolOutput$IpamPool */ =>  {
                let var_722 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool(var_722);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_ipam_resource_cidr(
    inp: &[u8],
    mut builder: crate::output::modify_ipam_resource_cidr_output::Builder,
) -> Result<
    crate::output::modify_ipam_resource_cidr_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyIpamResourceCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyIpamResourceCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamResourceCidr") /* IpamResourceCidr com.amazonaws.ec2.synthetic#ModifyIpamResourceCidrOutput$IpamResourceCidr */ =>  {
                let var_723 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_resource_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_resource_cidr(var_723);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_ipam_scope(
    inp: &[u8],
    mut builder: crate::output::modify_ipam_scope_output::Builder,
) -> Result<crate::output::modify_ipam_scope_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyIpamScopeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyIpamScopeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamScope") /* IpamScope com.amazonaws.ec2.synthetic#ModifyIpamScopeOutput$IpamScope */ =>  {
                let var_724 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_scope(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_scope(var_724);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_launch_template(
    inp: &[u8],
    mut builder: crate::output::modify_launch_template_output::Builder,
) -> Result<crate::output::modify_launch_template_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyLaunchTemplateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyLaunchTemplateResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("launchTemplate") /* LaunchTemplate com.amazonaws.ec2.synthetic#ModifyLaunchTemplateOutput$LaunchTemplate */ =>  {
                let var_725 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_launch_template(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_launch_template(var_725);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_managed_prefix_list(
    inp: &[u8],
    mut builder: crate::output::modify_managed_prefix_list_output::Builder,
) -> Result<
    crate::output::modify_managed_prefix_list_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyManagedPrefixListResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyManagedPrefixListResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("prefixList") /* PrefixList com.amazonaws.ec2.synthetic#ModifyManagedPrefixListOutput$PrefixList */ =>  {
                let var_726 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_managed_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_list(var_726);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_private_dns_name_options(
    inp: &[u8],
    mut builder: crate::output::modify_private_dns_name_options_output::Builder,
) -> Result<
    crate::output::modify_private_dns_name_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyPrivateDnsNameOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyPrivateDnsNameOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyPrivateDnsNameOptionsOutput$Return */ =>  {
                let var_727 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_727);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_reserved_instances(
    inp: &[u8],
    mut builder: crate::output::modify_reserved_instances_output::Builder,
) -> Result<
    crate::output::modify_reserved_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyReservedInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyReservedInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesModificationId") /* ReservedInstancesModificationId com.amazonaws.ec2.synthetic#ModifyReservedInstancesOutput$ReservedInstancesModificationId */ =>  {
                let var_728 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_modification_id(var_728);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_security_group_rules(
    inp: &[u8],
    mut builder: crate::output::modify_security_group_rules_output::Builder,
) -> Result<
    crate::output::modify_security_group_rules_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifySecurityGroupRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifySecurityGroupRulesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifySecurityGroupRulesOutput$Return */ =>  {
                let var_729 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_729);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_snapshot_tier(
    inp: &[u8],
    mut builder: crate::output::modify_snapshot_tier_output::Builder,
) -> Result<crate::output::modify_snapshot_tier_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifySnapshotTierResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifySnapshotTierResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#ModifySnapshotTierOutput$SnapshotId */ =>  {
                let var_730 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_730);
            }
            ,
            s if s.matches("tieringStartTime") /* TieringStartTime com.amazonaws.ec2.synthetic#ModifySnapshotTierOutput$TieringStartTime */ =>  {
                let var_731 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_tiering_start_time(var_731);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_spot_fleet_request(
    inp: &[u8],
    mut builder: crate::output::modify_spot_fleet_request_output::Builder,
) -> Result<
    crate::output::modify_spot_fleet_request_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifySpotFleetRequestResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifySpotFleetRequestResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifySpotFleetRequestOutput$Return */ =>  {
                let var_732 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_732);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_traffic_mirror_filter_network_services(
    inp: &[u8],
    mut builder: crate::output::modify_traffic_mirror_filter_network_services_output::Builder,
) -> Result<
    crate::output::modify_traffic_mirror_filter_network_services_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTrafficMirrorFilterNetworkServicesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTrafficMirrorFilterNetworkServicesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilter") /* TrafficMirrorFilter com.amazonaws.ec2.synthetic#ModifyTrafficMirrorFilterNetworkServicesOutput$TrafficMirrorFilter */ =>  {
                let var_733 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter(var_733);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_traffic_mirror_filter_rule(
    inp: &[u8],
    mut builder: crate::output::modify_traffic_mirror_filter_rule_output::Builder,
) -> Result<
    crate::output::modify_traffic_mirror_filter_rule_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTrafficMirrorFilterRuleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTrafficMirrorFilterRuleResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorFilterRule") /* TrafficMirrorFilterRule com.amazonaws.ec2.synthetic#ModifyTrafficMirrorFilterRuleOutput$TrafficMirrorFilterRule */ =>  {
                let var_734 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_filter_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_filter_rule(var_734);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_traffic_mirror_session(
    inp: &[u8],
    mut builder: crate::output::modify_traffic_mirror_session_output::Builder,
) -> Result<
    crate::output::modify_traffic_mirror_session_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTrafficMirrorSessionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTrafficMirrorSessionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("trafficMirrorSession") /* TrafficMirrorSession com.amazonaws.ec2.synthetic#ModifyTrafficMirrorSessionOutput$TrafficMirrorSession */ =>  {
                let var_735 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_traffic_mirror_session(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_traffic_mirror_session(var_735);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_transit_gateway(
    inp: &[u8],
    mut builder: crate::output::modify_transit_gateway_output::Builder,
) -> Result<crate::output::modify_transit_gateway_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTransitGatewayResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTransitGatewayResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGateway") /* TransitGateway com.amazonaws.ec2.synthetic#ModifyTransitGatewayOutput$TransitGateway */ =>  {
                let var_736 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway(var_736);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_transit_gateway_prefix_list_reference(
    inp: &[u8],
    mut builder: crate::output::modify_transit_gateway_prefix_list_reference_output::Builder,
) -> Result<
    crate::output::modify_transit_gateway_prefix_list_reference_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTransitGatewayPrefixListReferenceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTransitGatewayPrefixListReferenceResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPrefixListReference") /* TransitGatewayPrefixListReference com.amazonaws.ec2.synthetic#ModifyTransitGatewayPrefixListReferenceOutput$TransitGatewayPrefixListReference */ =>  {
                let var_737 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_prefix_list_reference(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_prefix_list_reference(var_737);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_transit_gateway_vpc_attachment(
    inp: &[u8],
    mut builder: crate::output::modify_transit_gateway_vpc_attachment_output::Builder,
) -> Result<
    crate::output::modify_transit_gateway_vpc_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyTransitGatewayVpcAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyTransitGatewayVpcAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachment") /* TransitGatewayVpcAttachment com.amazonaws.ec2.synthetic#ModifyTransitGatewayVpcAttachmentOutput$TransitGatewayVpcAttachment */ =>  {
                let var_738 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachment(var_738);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_volume(
    inp: &[u8],
    mut builder: crate::output::modify_volume_output::Builder,
) -> Result<crate::output::modify_volume_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVolumeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVolumeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("volumeModification") /* VolumeModification com.amazonaws.ec2.synthetic#ModifyVolumeOutput$VolumeModification */ =>  {
                let var_739 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_volume_modification(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_volume_modification(var_739);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_endpoint(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_endpoint_output::Builder,
) -> Result<crate::output::modify_vpc_endpoint_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcEndpointResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcEndpointResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyVpcEndpointOutput$Return */ =>  {
                let var_740 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_740);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_endpoint_connection_notification(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_endpoint_connection_notification_output::Builder,
) -> Result<
    crate::output::modify_vpc_endpoint_connection_notification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcEndpointConnectionNotificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcEndpointConnectionNotificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* ReturnValue com.amazonaws.ec2.synthetic#ModifyVpcEndpointConnectionNotificationOutput$ReturnValue */ =>  {
                let var_741 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_741);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_endpoint_service_configuration(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_endpoint_service_configuration_output::Builder,
) -> Result<
    crate::output::modify_vpc_endpoint_service_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcEndpointServiceConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcEndpointServiceConfigurationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ModifyVpcEndpointServiceConfigurationOutput$Return */ =>  {
                let var_742 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_742);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_endpoint_service_payer_responsibility(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_endpoint_service_payer_responsibility_output::Builder,
) -> Result<
    crate::output::modify_vpc_endpoint_service_payer_responsibility_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcEndpointServicePayerResponsibilityResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcEndpointServicePayerResponsibilityResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* ReturnValue com.amazonaws.ec2.synthetic#ModifyVpcEndpointServicePayerResponsibilityOutput$ReturnValue */ =>  {
                let var_743 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_743);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_endpoint_service_permissions(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_endpoint_service_permissions_output::Builder,
) -> Result<
    crate::output::modify_vpc_endpoint_service_permissions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcEndpointServicePermissionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcEndpointServicePermissionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* ReturnValue com.amazonaws.ec2.synthetic#ModifyVpcEndpointServicePermissionsOutput$ReturnValue */ =>  {
                let var_744 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_744);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_peering_connection_options(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_peering_connection_options_output::Builder,
) -> Result<
    crate::output::modify_vpc_peering_connection_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcPeeringConnectionOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcPeeringConnectionOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("accepterPeeringConnectionOptions") /* AccepterPeeringConnectionOptions com.amazonaws.ec2.synthetic#ModifyVpcPeeringConnectionOptionsOutput$AccepterPeeringConnectionOptions */ =>  {
                let var_745 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_peering_connection_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_accepter_peering_connection_options(var_745);
            }
            ,
            s if s.matches("requesterPeeringConnectionOptions") /* RequesterPeeringConnectionOptions com.amazonaws.ec2.synthetic#ModifyVpcPeeringConnectionOptionsOutput$RequesterPeeringConnectionOptions */ =>  {
                let var_746 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_peering_connection_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_requester_peering_connection_options(var_746);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpc_tenancy(
    inp: &[u8],
    mut builder: crate::output::modify_vpc_tenancy_output::Builder,
) -> Result<crate::output::modify_vpc_tenancy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpcTenancyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpcTenancyResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* ReturnValue com.amazonaws.ec2.synthetic#ModifyVpcTenancyOutput$ReturnValue */ =>  {
                let var_747 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_747);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpn_connection(
    inp: &[u8],
    mut builder: crate::output::modify_vpn_connection_output::Builder,
) -> Result<crate::output::modify_vpn_connection_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpnConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpnConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnection") /* VpnConnection com.amazonaws.ec2.synthetic#ModifyVpnConnectionOutput$VpnConnection */ =>  {
                let var_748 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection(var_748);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpn_connection_options(
    inp: &[u8],
    mut builder: crate::output::modify_vpn_connection_options_output::Builder,
) -> Result<
    crate::output::modify_vpn_connection_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpnConnectionOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpnConnectionOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnection") /* VpnConnection com.amazonaws.ec2.synthetic#ModifyVpnConnectionOptionsOutput$VpnConnection */ =>  {
                let var_749 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection(var_749);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpn_tunnel_certificate(
    inp: &[u8],
    mut builder: crate::output::modify_vpn_tunnel_certificate_output::Builder,
) -> Result<
    crate::output::modify_vpn_tunnel_certificate_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpnTunnelCertificateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpnTunnelCertificateResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnection") /* VpnConnection com.amazonaws.ec2.synthetic#ModifyVpnTunnelCertificateOutput$VpnConnection */ =>  {
                let var_750 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection(var_750);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_vpn_tunnel_options(
    inp: &[u8],
    mut builder: crate::output::modify_vpn_tunnel_options_output::Builder,
) -> Result<
    crate::output::modify_vpn_tunnel_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyVpnTunnelOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyVpnTunnelOptionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("vpnConnection") /* VpnConnection com.amazonaws.ec2.synthetic#ModifyVpnTunnelOptionsOutput$VpnConnection */ =>  {
                let var_751 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpn_connection(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpn_connection(var_751);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_monitor_instances(
    inp: &[u8],
    mut builder: crate::output::monitor_instances_output::Builder,
) -> Result<crate::output::monitor_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("MonitorInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected MonitorInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* InstanceMonitorings com.amazonaws.ec2.synthetic#MonitorInstancesOutput$InstanceMonitorings */ =>  {
                let var_752 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_monitoring_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_monitorings(var_752);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_move_address_to_vpc(
    inp: &[u8],
    mut builder: crate::output::move_address_to_vpc_output::Builder,
) -> Result<crate::output::move_address_to_vpc_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("MoveAddressToVpcResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected MoveAddressToVpcResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("allocationId") /* AllocationId com.amazonaws.ec2.synthetic#MoveAddressToVpcOutput$AllocationId */ =>  {
                let var_753 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_allocation_id(var_753);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#MoveAddressToVpcOutput$Status */ =>  {
                let var_754 =
                    Some(
                        Result::<crate::model::Status, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Status::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_754);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_move_byoip_cidr_to_ipam(
    inp: &[u8],
    mut builder: crate::output::move_byoip_cidr_to_ipam_output::Builder,
) -> Result<crate::output::move_byoip_cidr_to_ipam_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("MoveByoipCidrToIpamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected MoveByoipCidrToIpamResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidr") /* ByoipCidr com.amazonaws.ec2.synthetic#MoveByoipCidrToIpamOutput$ByoipCidr */ =>  {
                let var_755 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_byoip_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidr(var_755);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_provision_byoip_cidr(
    inp: &[u8],
    mut builder: crate::output::provision_byoip_cidr_output::Builder,
) -> Result<crate::output::provision_byoip_cidr_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ProvisionByoipCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ProvisionByoipCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidr") /* ByoipCidr com.amazonaws.ec2.synthetic#ProvisionByoipCidrOutput$ByoipCidr */ =>  {
                let var_756 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_byoip_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidr(var_756);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_provision_ipam_pool_cidr(
    inp: &[u8],
    mut builder: crate::output::provision_ipam_pool_cidr_output::Builder,
) -> Result<crate::output::provision_ipam_pool_cidr_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ProvisionIpamPoolCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ProvisionIpamPoolCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ipamPoolCidr") /* IpamPoolCidr com.amazonaws.ec2.synthetic#ProvisionIpamPoolCidrOutput$IpamPoolCidr */ =>  {
                let var_757 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ipam_pool_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_cidr(var_757);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_provision_public_ipv4_pool_cidr(
    inp: &[u8],
    mut builder: crate::output::provision_public_ipv4_pool_cidr_output::Builder,
) -> Result<
    crate::output::provision_public_ipv4_pool_cidr_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ProvisionPublicIpv4PoolCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ProvisionPublicIpv4PoolCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("poolId") /* PoolId com.amazonaws.ec2.synthetic#ProvisionPublicIpv4PoolCidrOutput$PoolId */ =>  {
                let var_758 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_pool_id(var_758);
            }
            ,
            s if s.matches("poolAddressRange") /* PoolAddressRange com.amazonaws.ec2.synthetic#ProvisionPublicIpv4PoolCidrOutput$PoolAddressRange */ =>  {
                let var_759 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_public_ipv4_pool_range(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_pool_address_range(var_759);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_purchase_host_reservation(
    inp: &[u8],
    mut builder: crate::output::purchase_host_reservation_output::Builder,
) -> Result<
    crate::output::purchase_host_reservation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PurchaseHostReservationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PurchaseHostReservationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientToken") /* ClientToken com.amazonaws.ec2.synthetic#PurchaseHostReservationOutput$ClientToken */ =>  {
                let var_760 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_token(var_760);
            }
            ,
            s if s.matches("currencyCode") /* CurrencyCode com.amazonaws.ec2.synthetic#PurchaseHostReservationOutput$CurrencyCode */ =>  {
                let var_761 =
                    Some(
                        Result::<crate::model::CurrencyCodeValues, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CurrencyCodeValues::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_currency_code(var_761);
            }
            ,
            s if s.matches("purchase") /* Purchase com.amazonaws.ec2.synthetic#PurchaseHostReservationOutput$Purchase */ =>  {
                let var_762 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_purchase_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_purchase(var_762);
            }
            ,
            s if s.matches("totalHourlyPrice") /* TotalHourlyPrice com.amazonaws.ec2.synthetic#PurchaseHostReservationOutput$TotalHourlyPrice */ =>  {
                let var_763 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_total_hourly_price(var_763);
            }
            ,
            s if s.matches("totalUpfrontPrice") /* TotalUpfrontPrice com.amazonaws.ec2.synthetic#PurchaseHostReservationOutput$TotalUpfrontPrice */ =>  {
                let var_764 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_total_upfront_price(var_764);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_purchase_reserved_instances_offering(
    inp: &[u8],
    mut builder: crate::output::purchase_reserved_instances_offering_output::Builder,
) -> Result<
    crate::output::purchase_reserved_instances_offering_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PurchaseReservedInstancesOfferingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PurchaseReservedInstancesOfferingResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("reservedInstancesId") /* ReservedInstancesId com.amazonaws.ec2.synthetic#PurchaseReservedInstancesOfferingOutput$ReservedInstancesId */ =>  {
                let var_765 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_instances_id(var_765);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_purchase_scheduled_instances(
    inp: &[u8],
    mut builder: crate::output::purchase_scheduled_instances_output::Builder,
) -> Result<
    crate::output::purchase_scheduled_instances_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PurchaseScheduledInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PurchaseScheduledInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("scheduledInstanceSet") /* ScheduledInstanceSet com.amazonaws.ec2.synthetic#PurchaseScheduledInstancesOutput$ScheduledInstanceSet */ =>  {
                let var_766 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_purchased_scheduled_instance_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scheduled_instance_set(var_766);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_register_image(
    inp: &[u8],
    mut builder: crate::output::register_image_output::Builder,
) -> Result<crate::output::register_image_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RegisterImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RegisterImageResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("imageId") /* ImageId com.amazonaws.ec2.synthetic#RegisterImageOutput$ImageId */ =>  {
                let var_767 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_image_id(var_767);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_register_instance_event_notification_attributes(
    inp: &[u8],
    mut builder: crate::output::register_instance_event_notification_attributes_output::Builder,
) -> Result<
    crate::output::register_instance_event_notification_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RegisterInstanceEventNotificationAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RegisterInstanceEventNotificationAttributesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceTagAttribute") /* InstanceTagAttribute com.amazonaws.ec2.synthetic#RegisterInstanceEventNotificationAttributesOutput$InstanceTagAttribute */ =>  {
                let var_768 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_tag_notification_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_tag_attribute(var_768);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_register_transit_gateway_multicast_group_members(
    inp: &[u8],
    mut builder: crate::output::register_transit_gateway_multicast_group_members_output::Builder,
) -> Result<
    crate::output::register_transit_gateway_multicast_group_members_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RegisterTransitGatewayMulticastGroupMembersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RegisterTransitGatewayMulticastGroupMembersResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("registeredMulticastGroupMembers") /* RegisteredMulticastGroupMembers com.amazonaws.ec2.synthetic#RegisterTransitGatewayMulticastGroupMembersOutput$RegisteredMulticastGroupMembers */ =>  {
                let var_769 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_registered_group_members(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_registered_multicast_group_members(var_769);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_register_transit_gateway_multicast_group_sources(
    inp: &[u8],
    mut builder: crate::output::register_transit_gateway_multicast_group_sources_output::Builder,
) -> Result<
    crate::output::register_transit_gateway_multicast_group_sources_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RegisterTransitGatewayMulticastGroupSourcesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RegisterTransitGatewayMulticastGroupSourcesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("registeredMulticastGroupSources") /* RegisteredMulticastGroupSources com.amazonaws.ec2.synthetic#RegisterTransitGatewayMulticastGroupSourcesOutput$RegisteredMulticastGroupSources */ =>  {
                let var_770 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_registered_group_sources(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_registered_multicast_group_sources(var_770);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_transit_gateway_multicast_domain_associations(
    inp: &[u8],
    mut builder: crate::output::reject_transit_gateway_multicast_domain_associations_output::Builder,
) -> Result<
    crate::output::reject_transit_gateway_multicast_domain_associations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectTransitGatewayMulticastDomainAssociationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!("invalid root, expected RejectTransitGatewayMulticastDomainAssociationsResponse got {:?}", start_el)));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associations") /* Associations com.amazonaws.ec2.synthetic#RejectTransitGatewayMulticastDomainAssociationsOutput$Associations */ =>  {
                let var_771 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_multicast_domain_associations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associations(var_771);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_transit_gateway_peering_attachment(
    inp: &[u8],
    mut builder: crate::output::reject_transit_gateway_peering_attachment_output::Builder,
) -> Result<
    crate::output::reject_transit_gateway_peering_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectTransitGatewayPeeringAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RejectTransitGatewayPeeringAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayPeeringAttachment") /* TransitGatewayPeeringAttachment com.amazonaws.ec2.synthetic#RejectTransitGatewayPeeringAttachmentOutput$TransitGatewayPeeringAttachment */ =>  {
                let var_772 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_peering_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_peering_attachment(var_772);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_transit_gateway_vpc_attachment(
    inp: &[u8],
    mut builder: crate::output::reject_transit_gateway_vpc_attachment_output::Builder,
) -> Result<
    crate::output::reject_transit_gateway_vpc_attachment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectTransitGatewayVpcAttachmentResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RejectTransitGatewayVpcAttachmentResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayVpcAttachment") /* TransitGatewayVpcAttachment com.amazonaws.ec2.synthetic#RejectTransitGatewayVpcAttachmentOutput$TransitGatewayVpcAttachment */ =>  {
                let var_773 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_vpc_attachment(var_773);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_vpc_endpoint_connections(
    inp: &[u8],
    mut builder: crate::output::reject_vpc_endpoint_connections_output::Builder,
) -> Result<
    crate::output::reject_vpc_endpoint_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectVpcEndpointConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RejectVpcEndpointConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#RejectVpcEndpointConnectionsOutput$Unsuccessful */ =>  {
                let var_774 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_774);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_vpc_peering_connection(
    inp: &[u8],
    mut builder: crate::output::reject_vpc_peering_connection_output::Builder,
) -> Result<
    crate::output::reject_vpc_peering_connection_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectVpcPeeringConnectionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RejectVpcPeeringConnectionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#RejectVpcPeeringConnectionOutput$Return */ =>  {
                let var_775 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_775);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_release_hosts(
    inp: &[u8],
    mut builder: crate::output::release_hosts_output::Builder,
) -> Result<crate::output::release_hosts_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReleaseHostsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReleaseHostsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("successful") /* Successful com.amazonaws.ec2.synthetic#ReleaseHostsOutput$Successful */ =>  {
                let var_776 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_response_host_id_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_successful(var_776);
            }
            ,
            s if s.matches("unsuccessful") /* Unsuccessful com.amazonaws.ec2.synthetic#ReleaseHostsOutput$Unsuccessful */ =>  {
                let var_777 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_unsuccessful_item_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unsuccessful(var_777);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_release_ipam_pool_allocation(
    inp: &[u8],
    mut builder: crate::output::release_ipam_pool_allocation_output::Builder,
) -> Result<
    crate::output::release_ipam_pool_allocation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReleaseIpamPoolAllocationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReleaseIpamPoolAllocationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("success") /* Success com.amazonaws.ec2.synthetic#ReleaseIpamPoolAllocationOutput$Success */ =>  {
                let var_778 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_success(var_778);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_replace_iam_instance_profile_association(
    inp: &[u8],
    mut builder: crate::output::replace_iam_instance_profile_association_output::Builder,
) -> Result<
    crate::output::replace_iam_instance_profile_association_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReplaceIamInstanceProfileAssociationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReplaceIamInstanceProfileAssociationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("iamInstanceProfileAssociation") /* IamInstanceProfileAssociation com.amazonaws.ec2.synthetic#ReplaceIamInstanceProfileAssociationOutput$IamInstanceProfileAssociation */ =>  {
                let var_779 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_iam_instance_profile_association(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_instance_profile_association(var_779);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_replace_network_acl_association(
    inp: &[u8],
    mut builder: crate::output::replace_network_acl_association_output::Builder,
) -> Result<
    crate::output::replace_network_acl_association_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReplaceNetworkAclAssociationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReplaceNetworkAclAssociationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("newAssociationId") /* NewAssociationId com.amazonaws.ec2.synthetic#ReplaceNetworkAclAssociationOutput$NewAssociationId */ =>  {
                let var_780 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_new_association_id(var_780);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_replace_route_table_association(
    inp: &[u8],
    mut builder: crate::output::replace_route_table_association_output::Builder,
) -> Result<
    crate::output::replace_route_table_association_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReplaceRouteTableAssociationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReplaceRouteTableAssociationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("newAssociationId") /* NewAssociationId com.amazonaws.ec2.synthetic#ReplaceRouteTableAssociationOutput$NewAssociationId */ =>  {
                let var_781 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_new_association_id(var_781);
            }
            ,
            s if s.matches("associationState") /* AssociationState com.amazonaws.ec2.synthetic#ReplaceRouteTableAssociationOutput$AssociationState */ =>  {
                let var_782 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_route_table_association_state(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_association_state(var_782);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_replace_transit_gateway_route(
    inp: &[u8],
    mut builder: crate::output::replace_transit_gateway_route_output::Builder,
) -> Result<
    crate::output::replace_transit_gateway_route_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReplaceTransitGatewayRouteResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReplaceTransitGatewayRouteResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("route") /* Route com.amazonaws.ec2.synthetic#ReplaceTransitGatewayRouteOutput$Route */ =>  {
                let var_783 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_route(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_route(var_783);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_request_spot_fleet(
    inp: &[u8],
    mut builder: crate::output::request_spot_fleet_output::Builder,
) -> Result<crate::output::request_spot_fleet_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RequestSpotFleetResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RequestSpotFleetResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotFleetRequestId") /* SpotFleetRequestId com.amazonaws.ec2.synthetic#RequestSpotFleetOutput$SpotFleetRequestId */ =>  {
                let var_784 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_spot_fleet_request_id(var_784);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_request_spot_instances(
    inp: &[u8],
    mut builder: crate::output::request_spot_instances_output::Builder,
) -> Result<crate::output::request_spot_instances_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RequestSpotInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RequestSpotInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("spotInstanceRequestSet") /* SpotInstanceRequests com.amazonaws.ec2.synthetic#RequestSpotInstancesOutput$SpotInstanceRequests */ =>  {
                let var_785 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_spot_instance_request_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spot_instance_requests(var_785);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reset_address_attribute(
    inp: &[u8],
    mut builder: crate::output::reset_address_attribute_output::Builder,
) -> Result<crate::output::reset_address_attribute_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResetAddressAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResetAddressAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("address") /* Address com.amazonaws.ec2.synthetic#ResetAddressAttributeOutput$Address */ =>  {
                let var_786 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_address_attribute(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_address(var_786);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reset_ebs_default_kms_key_id(
    inp: &[u8],
    mut builder: crate::output::reset_ebs_default_kms_key_id_output::Builder,
) -> Result<
    crate::output::reset_ebs_default_kms_key_id_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResetEbsDefaultKmsKeyIdResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResetEbsDefaultKmsKeyIdResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("kmsKeyId") /* KmsKeyId com.amazonaws.ec2.synthetic#ResetEbsDefaultKmsKeyIdOutput$KmsKeyId */ =>  {
                let var_787 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_787);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reset_fpga_image_attribute(
    inp: &[u8],
    mut builder: crate::output::reset_fpga_image_attribute_output::Builder,
) -> Result<
    crate::output::reset_fpga_image_attribute_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResetFpgaImageAttributeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResetFpgaImageAttributeResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#ResetFpgaImageAttributeOutput$Return */ =>  {
                let var_788 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_788);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_address_to_classic(
    inp: &[u8],
    mut builder: crate::output::restore_address_to_classic_output::Builder,
) -> Result<
    crate::output::restore_address_to_classic_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreAddressToClassicResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreAddressToClassicResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("publicIp") /* PublicIp com.amazonaws.ec2.synthetic#RestoreAddressToClassicOutput$PublicIp */ =>  {
                let var_789 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_public_ip(var_789);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#RestoreAddressToClassicOutput$Status */ =>  {
                let var_790 =
                    Some(
                        Result::<crate::model::Status, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Status::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_790);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_managed_prefix_list_version(
    inp: &[u8],
    mut builder: crate::output::restore_managed_prefix_list_version_output::Builder,
) -> Result<
    crate::output::restore_managed_prefix_list_version_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreManagedPrefixListVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreManagedPrefixListVersionResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("prefixList") /* PrefixList com.amazonaws.ec2.synthetic#RestoreManagedPrefixListVersionOutput$PrefixList */ =>  {
                let var_791 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_managed_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_list(var_791);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_snapshot_from_recycle_bin(
    inp: &[u8],
    mut builder: crate::output::restore_snapshot_from_recycle_bin_output::Builder,
) -> Result<
    crate::output::restore_snapshot_from_recycle_bin_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreSnapshotFromRecycleBinResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreSnapshotFromRecycleBinResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$SnapshotId */ =>  {
                let var_792 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_792);
            }
            ,
            s if s.matches("outpostArn") /* OutpostArn com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$OutpostArn */ =>  {
                let var_793 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_arn(var_793);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$Description */ =>  {
                let var_794 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_794);
            }
            ,
            s if s.matches("encrypted") /* Encrypted com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$Encrypted */ =>  {
                let var_795 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_795);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$OwnerId */ =>  {
                let var_796 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_796);
            }
            ,
            s if s.matches("progress") /* Progress com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$Progress */ =>  {
                let var_797 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_progress(var_797);
            }
            ,
            s if s.matches("startTime") /* StartTime com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$StartTime */ =>  {
                let var_798 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_798);
            }
            ,
            s if s.matches("status") /* State com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$State */ =>  {
                let var_799 =
                    Some(
                        Result::<crate::model::SnapshotState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SnapshotState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_799);
            }
            ,
            s if s.matches("volumeId") /* VolumeId com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$VolumeId */ =>  {
                let var_800 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_volume_id(var_800);
            }
            ,
            s if s.matches("volumeSize") /* VolumeSize com.amazonaws.ec2.synthetic#RestoreSnapshotFromRecycleBinOutput$VolumeSize */ =>  {
                let var_801 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_volume_size(var_801);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_snapshot_tier(
    inp: &[u8],
    mut builder: crate::output::restore_snapshot_tier_output::Builder,
) -> Result<crate::output::restore_snapshot_tier_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreSnapshotTierResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreSnapshotTierResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("snapshotId") /* SnapshotId com.amazonaws.ec2.synthetic#RestoreSnapshotTierOutput$SnapshotId */ =>  {
                let var_802 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_id(var_802);
            }
            ,
            s if s.matches("restoreStartTime") /* RestoreStartTime com.amazonaws.ec2.synthetic#RestoreSnapshotTierOutput$RestoreStartTime */ =>  {
                let var_803 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_restore_start_time(var_803);
            }
            ,
            s if s.matches("restoreDuration") /* RestoreDuration com.amazonaws.ec2.synthetic#RestoreSnapshotTierOutput$RestoreDuration */ =>  {
                let var_804 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_restore_duration(var_804);
            }
            ,
            s if s.matches("isPermanentRestore") /* IsPermanentRestore com.amazonaws.ec2.synthetic#RestoreSnapshotTierOutput$IsPermanentRestore */ =>  {
                let var_805 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_permanent_restore(var_805);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_client_vpn_ingress(
    inp: &[u8],
    mut builder: crate::output::revoke_client_vpn_ingress_output::Builder,
) -> Result<
    crate::output::revoke_client_vpn_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeClientVpnIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeClientVpnIngressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("status") /* Status com.amazonaws.ec2.synthetic#RevokeClientVpnIngressOutput$Status */ =>  {
                let var_806 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_client_vpn_authorization_rule_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_806);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_security_group_egress(
    inp: &[u8],
    mut builder: crate::output::revoke_security_group_egress_output::Builder,
) -> Result<
    crate::output::revoke_security_group_egress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeSecurityGroupEgressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeSecurityGroupEgressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#RevokeSecurityGroupEgressOutput$Return */ =>  {
                let var_807 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_807);
            }
            ,
            s if s.matches("unknownIpPermissionSet") /* UnknownIpPermissions com.amazonaws.ec2.synthetic#RevokeSecurityGroupEgressOutput$UnknownIpPermissions */ =>  {
                let var_808 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ip_permission_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unknown_ip_permissions(var_808);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_security_group_ingress(
    inp: &[u8],
    mut builder: crate::output::revoke_security_group_ingress_output::Builder,
) -> Result<
    crate::output::revoke_security_group_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeSecurityGroupIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeSecurityGroupIngressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#RevokeSecurityGroupIngressOutput$Return */ =>  {
                let var_809 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_809);
            }
            ,
            s if s.matches("unknownIpPermissionSet") /* UnknownIpPermissions com.amazonaws.ec2.synthetic#RevokeSecurityGroupIngressOutput$UnknownIpPermissions */ =>  {
                let var_810 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ip_permission_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unknown_ip_permissions(var_810);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_run_instances(
    inp: &[u8],
    mut builder: crate::output::run_instances_output::Builder,
) -> Result<crate::output::run_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RunInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RunInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("groupSet") /* Groups com.amazonaws.ec2.synthetic#RunInstancesOutput$Groups */ =>  {
                let var_811 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_group_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_groups(var_811);
            }
            ,
            s if s.matches("instancesSet") /* Instances com.amazonaws.ec2.synthetic#RunInstancesOutput$Instances */ =>  {
                let var_812 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instances(var_812);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2.synthetic#RunInstancesOutput$OwnerId */ =>  {
                let var_813 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_813);
            }
            ,
            s if s.matches("requesterId") /* RequesterId com.amazonaws.ec2.synthetic#RunInstancesOutput$RequesterId */ =>  {
                let var_814 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_requester_id(var_814);
            }
            ,
            s if s.matches("reservationId") /* ReservationId com.amazonaws.ec2.synthetic#RunInstancesOutput$ReservationId */ =>  {
                let var_815 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reservation_id(var_815);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_run_scheduled_instances(
    inp: &[u8],
    mut builder: crate::output::run_scheduled_instances_output::Builder,
) -> Result<crate::output::run_scheduled_instances_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RunScheduledInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RunScheduledInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceIdSet") /* InstanceIdSet com.amazonaws.ec2.synthetic#RunScheduledInstancesOutput$InstanceIdSet */ =>  {
                let var_816 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_id_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_id_set(var_816);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_search_local_gateway_routes(
    inp: &[u8],
    mut builder: crate::output::search_local_gateway_routes_output::Builder,
) -> Result<
    crate::output::search_local_gateway_routes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SearchLocalGatewayRoutesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SearchLocalGatewayRoutesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("routeSet") /* Routes com.amazonaws.ec2.synthetic#SearchLocalGatewayRoutesOutput$Routes */ =>  {
                let var_817 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_local_gateway_route_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_routes(var_817);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#SearchLocalGatewayRoutesOutput$NextToken */ =>  {
                let var_818 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_818);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_search_transit_gateway_multicast_groups(
    inp: &[u8],
    mut builder: crate::output::search_transit_gateway_multicast_groups_output::Builder,
) -> Result<
    crate::output::search_transit_gateway_multicast_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SearchTransitGatewayMulticastGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SearchTransitGatewayMulticastGroupsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("multicastGroups") /* MulticastGroups com.amazonaws.ec2.synthetic#SearchTransitGatewayMulticastGroupsOutput$MulticastGroups */ =>  {
                let var_819 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_multicast_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_multicast_groups(var_819);
            }
            ,
            s if s.matches("nextToken") /* NextToken com.amazonaws.ec2.synthetic#SearchTransitGatewayMulticastGroupsOutput$NextToken */ =>  {
                let var_820 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_820);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_search_transit_gateway_routes(
    inp: &[u8],
    mut builder: crate::output::search_transit_gateway_routes_output::Builder,
) -> Result<
    crate::output::search_transit_gateway_routes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SearchTransitGatewayRoutesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SearchTransitGatewayRoutesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("routeSet") /* Routes com.amazonaws.ec2.synthetic#SearchTransitGatewayRoutesOutput$Routes */ =>  {
                let var_821 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_transit_gateway_route_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_routes(var_821);
            }
            ,
            s if s.matches("additionalRoutesAvailable") /* AdditionalRoutesAvailable com.amazonaws.ec2.synthetic#SearchTransitGatewayRoutesOutput$AdditionalRoutesAvailable */ =>  {
                let var_822 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_additional_routes_available(var_822);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_start_instances(
    inp: &[u8],
    mut builder: crate::output::start_instances_output::Builder,
) -> Result<crate::output::start_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StartInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StartInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* StartingInstances com.amazonaws.ec2.synthetic#StartInstancesOutput$StartingInstances */ =>  {
                let var_823 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_state_change_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_starting_instances(var_823);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_start_network_insights_access_scope_analysis(
    inp: &[u8],
    mut builder: crate::output::start_network_insights_access_scope_analysis_output::Builder,
) -> Result<
    crate::output::start_network_insights_access_scope_analysis_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StartNetworkInsightsAccessScopeAnalysisResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StartNetworkInsightsAccessScopeAnalysisResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAccessScopeAnalysis") /* NetworkInsightsAccessScopeAnalysis com.amazonaws.ec2.synthetic#StartNetworkInsightsAccessScopeAnalysisOutput$NetworkInsightsAccessScopeAnalysis */ =>  {
                let var_824 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_access_scope_analysis(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_access_scope_analysis(var_824);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_start_network_insights_analysis(
    inp: &[u8],
    mut builder: crate::output::start_network_insights_analysis_output::Builder,
) -> Result<
    crate::output::start_network_insights_analysis_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StartNetworkInsightsAnalysisResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StartNetworkInsightsAnalysisResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInsightsAnalysis") /* NetworkInsightsAnalysis com.amazonaws.ec2.synthetic#StartNetworkInsightsAnalysisOutput$NetworkInsightsAnalysis */ =>  {
                let var_825 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_network_insights_analysis(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_insights_analysis(var_825);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_start_vpc_endpoint_service_private_dns_verification(
    inp: &[u8],
    mut builder: crate::output::start_vpc_endpoint_service_private_dns_verification_output::Builder,
) -> Result<
    crate::output::start_vpc_endpoint_service_private_dns_verification_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StartVpcEndpointServicePrivateDnsVerificationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StartVpcEndpointServicePrivateDnsVerificationResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* ReturnValue com.amazonaws.ec2.synthetic#StartVpcEndpointServicePrivateDnsVerificationOutput$ReturnValue */ =>  {
                let var_826 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_value(var_826);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_stop_instances(
    inp: &[u8],
    mut builder: crate::output::stop_instances_output::Builder,
) -> Result<crate::output::stop_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StopInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StopInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* StoppingInstances com.amazonaws.ec2.synthetic#StopInstancesOutput$StoppingInstances */ =>  {
                let var_827 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_state_change_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_stopping_instances(var_827);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_terminate_client_vpn_connections(
    inp: &[u8],
    mut builder: crate::output::terminate_client_vpn_connections_output::Builder,
) -> Result<
    crate::output::terminate_client_vpn_connections_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("TerminateClientVpnConnectionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected TerminateClientVpnConnectionsResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("clientVpnEndpointId") /* ClientVpnEndpointId com.amazonaws.ec2.synthetic#TerminateClientVpnConnectionsOutput$ClientVpnEndpointId */ =>  {
                let var_828 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_client_vpn_endpoint_id(var_828);
            }
            ,
            s if s.matches("username") /* Username com.amazonaws.ec2.synthetic#TerminateClientVpnConnectionsOutput$Username */ =>  {
                let var_829 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_username(var_829);
            }
            ,
            s if s.matches("connectionStatuses") /* ConnectionStatuses com.amazonaws.ec2.synthetic#TerminateClientVpnConnectionsOutput$ConnectionStatuses */ =>  {
                let var_830 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_terminate_connection_status_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_connection_statuses(var_830);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_terminate_instances(
    inp: &[u8],
    mut builder: crate::output::terminate_instances_output::Builder,
) -> Result<crate::output::terminate_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("TerminateInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected TerminateInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* TerminatingInstances com.amazonaws.ec2.synthetic#TerminateInstancesOutput$TerminatingInstances */ =>  {
                let var_831 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_state_change_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_terminating_instances(var_831);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_unassign_ipv6_addresses(
    inp: &[u8],
    mut builder: crate::output::unassign_ipv6_addresses_output::Builder,
) -> Result<crate::output::unassign_ipv6_addresses_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UnassignIpv6AddressesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UnassignIpv6AddressesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("networkInterfaceId") /* NetworkInterfaceId com.amazonaws.ec2.synthetic#UnassignIpv6AddressesOutput$NetworkInterfaceId */ =>  {
                let var_832 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_interface_id(var_832);
            }
            ,
            s if s.matches("unassignedIpv6Addresses") /* UnassignedIpv6Addresses com.amazonaws.ec2.synthetic#UnassignIpv6AddressesOutput$UnassignedIpv6Addresses */ =>  {
                let var_833 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ipv6_address_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unassigned_ipv6_addresses(var_833);
            }
            ,
            s if s.matches("unassignedIpv6PrefixSet") /* UnassignedIpv6Prefixes com.amazonaws.ec2.synthetic#UnassignIpv6AddressesOutput$UnassignedIpv6Prefixes */ =>  {
                let var_834 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_ip_prefix_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_unassigned_ipv6_prefixes(var_834);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_unmonitor_instances(
    inp: &[u8],
    mut builder: crate::output::unmonitor_instances_output::Builder,
) -> Result<crate::output::unmonitor_instances_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UnmonitorInstancesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UnmonitorInstancesResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instancesSet") /* InstanceMonitorings com.amazonaws.ec2.synthetic#UnmonitorInstancesOutput$InstanceMonitorings */ =>  {
                let var_835 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_monitoring_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_monitorings(var_835);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_security_group_rule_descriptions_egress(
    inp: &[u8],
    mut builder: crate::output::update_security_group_rule_descriptions_egress_output::Builder,
) -> Result<
    crate::output::update_security_group_rule_descriptions_egress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateSecurityGroupRuleDescriptionsEgressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateSecurityGroupRuleDescriptionsEgressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#UpdateSecurityGroupRuleDescriptionsEgressOutput$Return */ =>  {
                let var_836 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_836);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_security_group_rule_descriptions_ingress(
    inp: &[u8],
    mut builder: crate::output::update_security_group_rule_descriptions_ingress_output::Builder,
) -> Result<
    crate::output::update_security_group_rule_descriptions_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateSecurityGroupRuleDescriptionsIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateSecurityGroupRuleDescriptionsIngressResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("return") /* Return com.amazonaws.ec2.synthetic#UpdateSecurityGroupRuleDescriptionsIngressOutput$Return */ =>  {
                let var_837 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return(var_837);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_withdraw_byoip_cidr(
    inp: &[u8],
    mut builder: crate::output::withdraw_byoip_cidr_output::Builder,
) -> Result<crate::output::withdraw_byoip_cidr_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("WithdrawByoipCidrResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected WithdrawByoipCidrResponse got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("byoipCidr") /* ByoipCidr com.amazonaws.ec2.synthetic#WithdrawByoipCidrOutput$ByoipCidr */ =>  {
                let var_838 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_byoip_cidr(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_byoip_cidr(var_838);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

pub fn deser_structure_crate_model_transit_gateway_multicast_domain_associations(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TransitGatewayMulticastDomainAssociations, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::TransitGatewayMulticastDomainAssociations::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayMulticastDomainId") /* TransitGatewayMulticastDomainId com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$TransitGatewayMulticastDomainId */ =>  {
                let var_839 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_multicast_domain_id(var_839);
            }
            ,
            s if s.matches("transitGatewayAttachmentId") /* TransitGatewayAttachmentId com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$TransitGatewayAttachmentId */ =>  {
                let var_840 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachment_id(var_840);
            }
            ,
            s if s.matches("resourceId") /* ResourceId com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$ResourceId */ =>  {
                let var_841 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_id(var_841);
            }
            ,
            s if s.matches("resourceType") /* ResourceType com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$ResourceType */ =>  {
                let var_842 =
                    Some(
                        Result::<crate::model::TransitGatewayAttachmentResourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitGatewayAttachmentResourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_type(var_842);
            }
            ,
            s if s.matches("resourceOwnerId") /* ResourceOwnerId com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$ResourceOwnerId */ =>  {
                let var_843 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner_id(var_843);
            }
            ,
            s if s.matches("subnets") /* Subnets com.amazonaws.ec2#TransitGatewayMulticastDomainAssociations$Subnets */ =>  {
                let var_844 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_subnet_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnets(var_844);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_transit_gateway_peering_attachment(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TransitGatewayPeeringAttachment, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TransitGatewayPeeringAttachment::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayAttachmentId") /* TransitGatewayAttachmentId com.amazonaws.ec2#TransitGatewayPeeringAttachment$TransitGatewayAttachmentId */ =>  {
                let var_845 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachment_id(var_845);
            }
            ,
            s if s.matches("requesterTgwInfo") /* RequesterTgwInfo com.amazonaws.ec2#TransitGatewayPeeringAttachment$RequesterTgwInfo */ =>  {
                let var_846 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_peering_tgw_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_requester_tgw_info(var_846);
            }
            ,
            s if s.matches("accepterTgwInfo") /* AccepterTgwInfo com.amazonaws.ec2#TransitGatewayPeeringAttachment$AccepterTgwInfo */ =>  {
                let var_847 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_peering_tgw_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_accepter_tgw_info(var_847);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2#TransitGatewayPeeringAttachment$Status */ =>  {
                let var_848 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_peering_attachment_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_848);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#TransitGatewayPeeringAttachment$State */ =>  {
                let var_849 =
                    Some(
                        Result::<crate::model::TransitGatewayAttachmentState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitGatewayAttachmentState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_849);
            }
            ,
            s if s.matches("creationTime") /* CreationTime com.amazonaws.ec2#TransitGatewayPeeringAttachment$CreationTime */ =>  {
                let var_850 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_time(var_850);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#TransitGatewayPeeringAttachment$Tags */ =>  {
                let var_851 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_851);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_transit_gateway_vpc_attachment(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TransitGatewayVpcAttachment, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TransitGatewayVpcAttachment::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayAttachmentId") /* TransitGatewayAttachmentId com.amazonaws.ec2#TransitGatewayVpcAttachment$TransitGatewayAttachmentId */ =>  {
                let var_852 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachment_id(var_852);
            }
            ,
            s if s.matches("transitGatewayId") /* TransitGatewayId com.amazonaws.ec2#TransitGatewayVpcAttachment$TransitGatewayId */ =>  {
                let var_853 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_id(var_853);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2#TransitGatewayVpcAttachment$VpcId */ =>  {
                let var_854 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_854);
            }
            ,
            s if s.matches("vpcOwnerId") /* VpcOwnerId com.amazonaws.ec2#TransitGatewayVpcAttachment$VpcOwnerId */ =>  {
                let var_855 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_owner_id(var_855);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#TransitGatewayVpcAttachment$State */ =>  {
                let var_856 =
                    Some(
                        Result::<crate::model::TransitGatewayAttachmentState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitGatewayAttachmentState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_856);
            }
            ,
            s if s.matches("subnetIds") /* SubnetIds com.amazonaws.ec2#TransitGatewayVpcAttachment$SubnetIds */ =>  {
                let var_857 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_value_string_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet_ids(var_857);
            }
            ,
            s if s.matches("creationTime") /* CreationTime com.amazonaws.ec2#TransitGatewayVpcAttachment$CreationTime */ =>  {
                let var_858 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_time(var_858);
            }
            ,
            s if s.matches("options") /* Options com.amazonaws.ec2#TransitGatewayVpcAttachment$Options */ =>  {
                let var_859 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_transit_gateway_vpc_attachment_options(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_options(var_859);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#TransitGatewayVpcAttachment$Tags */ =>  {
                let var_860 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_860);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_unsuccessful_item_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::UnsuccessfulItem>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#UnsuccessfulItemSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_unsuccessful_item(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_vpc_peering_connection(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcPeeringConnection, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcPeeringConnection::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("accepterVpcInfo") /* AccepterVpcInfo com.amazonaws.ec2#VpcPeeringConnection$AccepterVpcInfo */ =>  {
                let var_861 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_peering_connection_vpc_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_accepter_vpc_info(var_861);
            }
            ,
            s if s.matches("expirationTime") /* ExpirationTime com.amazonaws.ec2#VpcPeeringConnection$ExpirationTime */ =>  {
                let var_862 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_expiration_time(var_862);
            }
            ,
            s if s.matches("requesterVpcInfo") /* RequesterVpcInfo com.amazonaws.ec2#VpcPeeringConnection$RequesterVpcInfo */ =>  {
                let var_863 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_peering_connection_vpc_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_requester_vpc_info(var_863);
            }
            ,
            s if s.matches("status") /* Status com.amazonaws.ec2#VpcPeeringConnection$Status */ =>  {
                let var_864 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_peering_connection_state_reason(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_status(var_864);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#VpcPeeringConnection$Tags */ =>  {
                let var_865 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_865);
            }
            ,
            s if s.matches("vpcPeeringConnectionId") /* VpcPeeringConnectionId com.amazonaws.ec2#VpcPeeringConnection$VpcPeeringConnectionId */ =>  {
                let var_866 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_peering_connection_id(var_866);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_byoip_cidr(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ByoipCidr, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ByoipCidr::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("cidr") /* Cidr com.amazonaws.ec2#ByoipCidr$Cidr */ =>  {
                let var_867 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr(var_867);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2#ByoipCidr$Description */ =>  {
                let var_868 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_868);
            }
            ,
            s if s.matches("statusMessage") /* StatusMessage com.amazonaws.ec2#ByoipCidr$StatusMessage */ =>  {
                let var_869 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_message(var_869);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#ByoipCidr$State */ =>  {
                let var_870 =
                    Some(
                        Result::<crate::model::ByoipCidrState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ByoipCidrState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_870);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_response_host_id_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#ResponseHostIdList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_ipam_pool_allocation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IpamPoolAllocation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IpamPoolAllocation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("cidr") /* Cidr com.amazonaws.ec2#IpamPoolAllocation$Cidr */ =>  {
                let var_871 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr(var_871);
            }
            ,
            s if s.matches("ipamPoolAllocationId") /* IpamPoolAllocationId com.amazonaws.ec2#IpamPoolAllocation$IpamPoolAllocationId */ =>  {
                let var_872 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ipam_pool_allocation_id(var_872);
            }
            ,
            s if s.matches("description") /* Description com.amazonaws.ec2#IpamPoolAllocation$Description */ =>  {
                let var_873 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_873);
            }
            ,
            s if s.matches("resourceId") /* ResourceId com.amazonaws.ec2#IpamPoolAllocation$ResourceId */ =>  {
                let var_874 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_id(var_874);
            }
            ,
            s if s.matches("resourceType") /* ResourceType com.amazonaws.ec2#IpamPoolAllocation$ResourceType */ =>  {
                let var_875 =
                    Some(
                        Result::<crate::model::IpamPoolAllocationResourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IpamPoolAllocationResourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_type(var_875);
            }
            ,
            s if s.matches("resourceRegion") /* ResourceRegion com.amazonaws.ec2#IpamPoolAllocation$ResourceRegion */ =>  {
                let var_876 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_region(var_876);
            }
            ,
            s if s.matches("resourceOwner") /* ResourceOwner com.amazonaws.ec2#IpamPoolAllocation$ResourceOwner */ =>  {
                let var_877 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner(var_877);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_client_vpn_security_group_id_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#ClientVpnSecurityGroupIdSet$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_ipv6_address_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#Ipv6AddressList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_ip_prefix_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#IpPrefixList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_assigned_private_ip_address_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AssignedPrivateIpAddress>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#AssignedPrivateIpAddressList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_assigned_private_ip_address(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_ipv4_prefixes_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Ipv4PrefixSpecification>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#Ipv4PrefixesList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_ipv4_prefix_specification(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_association_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AssociationStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AssociationStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("code") /* Code com.amazonaws.ec2#AssociationStatus$Code */ =>  {
                let var_878 =
                    Some(
                        Result::<crate::model::AssociationStatusCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AssociationStatusCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_878);
            }
            ,
            s if s.matches("message") /* Message com.amazonaws.ec2#AssociationStatus$Message */ =>  {
                let var_879 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_879);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_iam_instance_profile_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IamInstanceProfileAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IamInstanceProfileAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2#IamInstanceProfileAssociation$AssociationId */ =>  {
                let var_880 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_880);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2#IamInstanceProfileAssociation$InstanceId */ =>  {
                let var_881 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_881);
            }
            ,
            s if s.matches("iamInstanceProfile") /* IamInstanceProfile com.amazonaws.ec2#IamInstanceProfileAssociation$IamInstanceProfile */ =>  {
                let var_882 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_iam_instance_profile(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_instance_profile(var_882);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#IamInstanceProfileAssociation$State */ =>  {
                let var_883 =
                    Some(
                        Result::<crate::model::IamInstanceProfileAssociationState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IamInstanceProfileAssociationState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_883);
            }
            ,
            s if s.matches("timestamp") /* Timestamp com.amazonaws.ec2#IamInstanceProfileAssociation$Timestamp */ =>  {
                let var_884 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_884);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_instance_event_window(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InstanceEventWindow, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InstanceEventWindow::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("instanceEventWindowId") /* InstanceEventWindowId com.amazonaws.ec2#InstanceEventWindow$InstanceEventWindowId */ =>  {
                let var_885 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_event_window_id(var_885);
            }
            ,
            s if s.matches("timeRangeSet") /* TimeRanges com.amazonaws.ec2#InstanceEventWindow$TimeRanges */ =>  {
                let var_886 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_instance_event_window_time_range_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_time_ranges(var_886);
            }
            ,
            s if s.matches("name") /* Name com.amazonaws.ec2#InstanceEventWindow$Name */ =>  {
                let var_887 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_887);
            }
            ,
            s if s.matches("cronExpression") /* CronExpression com.amazonaws.ec2#InstanceEventWindow$CronExpression */ =>  {
                let var_888 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cron_expression(var_888);
            }
            ,
            s if s.matches("associationTarget") /* AssociationTarget com.amazonaws.ec2#InstanceEventWindow$AssociationTarget */ =>  {
                let var_889 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_event_window_association_target(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_association_target(var_889);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#InstanceEventWindow$State */ =>  {
                let var_890 =
                    Some(
                        Result::<crate::model::InstanceEventWindowState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InstanceEventWindowState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_890);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#InstanceEventWindow$Tags */ =>  {
                let var_891 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_891);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_route_table_association_state(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RouteTableAssociationState, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RouteTableAssociationState::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("state") /* State com.amazonaws.ec2#RouteTableAssociationState$State */ =>  {
                let var_892 =
                    Some(
                        Result::<crate::model::RouteTableAssociationStateCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::RouteTableAssociationStateCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_892);
            }
            ,
            s if s.matches("statusMessage") /* StatusMessage com.amazonaws.ec2#RouteTableAssociationState$StatusMessage */ =>  {
                let var_893 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_message(var_893);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_subnet_ipv6_cidr_block_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SubnetIpv6CidrBlockAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SubnetIpv6CidrBlockAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2#SubnetIpv6CidrBlockAssociation$AssociationId */ =>  {
                let var_894 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_894);
            }
            ,
            s if s.matches("ipv6CidrBlock") /* Ipv6CidrBlock com.amazonaws.ec2#SubnetIpv6CidrBlockAssociation$Ipv6CidrBlock */ =>  {
                let var_895 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block(var_895);
            }
            ,
            s if s.matches("ipv6CidrBlockState") /* Ipv6CidrBlockState com.amazonaws.ec2#SubnetIpv6CidrBlockAssociation$Ipv6CidrBlockState */ =>  {
                let var_896 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_subnet_cidr_block_state(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_state(var_896);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_transit_gateway_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TransitGatewayAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TransitGatewayAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("transitGatewayRouteTableId") /* TransitGatewayRouteTableId com.amazonaws.ec2#TransitGatewayAssociation$TransitGatewayRouteTableId */ =>  {
                let var_897 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_route_table_id(var_897);
            }
            ,
            s if s.matches("transitGatewayAttachmentId") /* TransitGatewayAttachmentId com.amazonaws.ec2#TransitGatewayAssociation$TransitGatewayAttachmentId */ =>  {
                let var_898 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_transit_gateway_attachment_id(var_898);
            }
            ,
            s if s.matches("resourceId") /* ResourceId com.amazonaws.ec2#TransitGatewayAssociation$ResourceId */ =>  {
                let var_899 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_id(var_899);
            }
            ,
            s if s.matches("resourceType") /* ResourceType com.amazonaws.ec2#TransitGatewayAssociation$ResourceType */ =>  {
                let var_900 =
                    Some(
                        Result::<crate::model::TransitGatewayAttachmentResourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitGatewayAttachmentResourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_type(var_900);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#TransitGatewayAssociation$State */ =>  {
                let var_901 =
                    Some(
                        Result::<crate::model::TransitGatewayAssociationState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitGatewayAssociationState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_901);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_trunk_interface_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TrunkInterfaceAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TrunkInterfaceAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2#TrunkInterfaceAssociation$AssociationId */ =>  {
                let var_902 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_902);
            }
            ,
            s if s.matches("branchInterfaceId") /* BranchInterfaceId com.amazonaws.ec2#TrunkInterfaceAssociation$BranchInterfaceId */ =>  {
                let var_903 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_branch_interface_id(var_903);
            }
            ,
            s if s.matches("trunkInterfaceId") /* TrunkInterfaceId com.amazonaws.ec2#TrunkInterfaceAssociation$TrunkInterfaceId */ =>  {
                let var_904 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_trunk_interface_id(var_904);
            }
            ,
            s if s.matches("interfaceProtocol") /* InterfaceProtocol com.amazonaws.ec2#TrunkInterfaceAssociation$InterfaceProtocol */ =>  {
                let var_905 =
                    Some(
                        Result::<crate::model::InterfaceProtocolType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InterfaceProtocolType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_interface_protocol(var_905);
            }
            ,
            s if s.matches("vlanId") /* VlanId com.amazonaws.ec2#TrunkInterfaceAssociation$VlanId */ =>  {
                let var_906 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_vlan_id(var_906);
            }
            ,
            s if s.matches("greKey") /* GreKey com.amazonaws.ec2#TrunkInterfaceAssociation$GreKey */ =>  {
                let var_907 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_gre_key(var_907);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#TrunkInterfaceAssociation$Tags */ =>  {
                let var_908 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_908);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_vpc_ipv6_cidr_block_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcIpv6CidrBlockAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcIpv6CidrBlockAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2#VpcIpv6CidrBlockAssociation$AssociationId */ =>  {
                let var_909 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_909);
            }
            ,
            s if s.matches("ipv6CidrBlock") /* Ipv6CidrBlock com.amazonaws.ec2#VpcIpv6CidrBlockAssociation$Ipv6CidrBlock */ =>  {
                let var_910 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block(var_910);
            }
            ,
            s if s.matches("ipv6CidrBlockState") /* Ipv6CidrBlockState com.amazonaws.ec2#VpcIpv6CidrBlockAssociation$Ipv6CidrBlockState */ =>  {
                let var_911 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_cidr_block_state(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_state(var_911);
            }
            ,
            s if s.matches("networkBorderGroup") /* NetworkBorderGroup com.amazonaws.ec2#VpcIpv6CidrBlockAssociation$NetworkBorderGroup */ =>  {
                let var_912 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_border_group(var_912);
            }
            ,
            s if s.matches("ipv6Pool") /* Ipv6Pool com.amazonaws.ec2#VpcIpv6CidrBlockAssociation$Ipv6Pool */ =>  {
                let var_913 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ipv6_pool(var_913);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_vpc_cidr_block_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcCidrBlockAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcCidrBlockAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("associationId") /* AssociationId com.amazonaws.ec2#VpcCidrBlockAssociation$AssociationId */ =>  {
                let var_914 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_association_id(var_914);
            }
            ,
            s if s.matches("cidrBlock") /* CidrBlock com.amazonaws.ec2#VpcCidrBlockAssociation$CidrBlock */ =>  {
                let var_915 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr_block(var_915);
            }
            ,
            s if s.matches("cidrBlockState") /* CidrBlockState com.amazonaws.ec2#VpcCidrBlockAssociation$CidrBlockState */ =>  {
                let var_916 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_cidr_block_state(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cidr_block_state(var_916);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_vpc_attachment(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcAttachment, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcAttachment::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("state") /* State com.amazonaws.ec2#VpcAttachment$State */ =>  {
                let var_917 =
                    Some(
                        Result::<crate::model::AttachmentStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AttachmentStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_917);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2#VpcAttachment$VpcId */ =>  {
                let var_918 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_918);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_client_vpn_authorization_rule_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClientVpnAuthorizationRuleStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClientVpnAuthorizationRuleStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("code") /* Code com.amazonaws.ec2#ClientVpnAuthorizationRuleStatus$Code */ =>  {
                let var_919 =
                    Some(
                        Result::<crate::model::ClientVpnAuthorizationRuleStatusCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ClientVpnAuthorizationRuleStatusCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_919);
            }
            ,
            s if s.matches("message") /* Message com.amazonaws.ec2#ClientVpnAuthorizationRuleStatus$Message */ =>  {
                let var_920 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_920);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_security_group_rule_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SecurityGroupRule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#SecurityGroupRuleList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_security_group_rule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_bundle_task(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::BundleTask, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::BundleTask::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("bundleId") /* BundleId com.amazonaws.ec2#BundleTask$BundleId */ =>  {
                let var_921 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bundle_id(var_921);
            }
            ,
            s if s.matches("error") /* BundleTaskError com.amazonaws.ec2#BundleTask$BundleTaskError */ =>  {
                let var_922 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_bundle_task_error(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bundle_task_error(var_922);
            }
            ,
            s if s.matches("instanceId") /* InstanceId com.amazonaws.ec2#BundleTask$InstanceId */ =>  {
                let var_923 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_id(var_923);
            }
            ,
            s if s.matches("progress") /* Progress com.amazonaws.ec2#BundleTask$Progress */ =>  {
                let var_924 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_progress(var_924);
            }
            ,
            s if s.matches("startTime") /* StartTime com.amazonaws.ec2#BundleTask$StartTime */ =>  {
                let var_925 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_925);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#BundleTask$State */ =>  {
                let var_926 =
                    Some(
                        Result::<crate::model::BundleTaskState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BundleTaskState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_926);
            }
            ,
            s if s.matches("storage") /* Storage com.amazonaws.ec2#BundleTask$Storage */ =>  {
                let var_927 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_storage(var_927);
            }
            ,
            s if s.matches("updateTime") /* UpdateTime com.amazonaws.ec2#BundleTask$UpdateTime */ =>  {
                let var_928 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_update_time(var_928);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_capacity_reservation_fleet_cancellation_state_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CapacityReservationFleetCancellationState>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CapacityReservationFleetCancellationStateSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_capacity_reservation_fleet_cancellation_state(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_failed_capacity_reservation_fleet_cancellation_result_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::FailedCapacityReservationFleetCancellationResult>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#FailedCapacityReservationFleetCancellationResultSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_failed_capacity_reservation_fleet_cancellation_result(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_reserved_instances_listing_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReservedInstancesListing>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#ReservedInstancesListingList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_reserved_instances_listing(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_cancel_spot_fleet_requests_success_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CancelSpotFleetRequestsSuccessItem>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CancelSpotFleetRequestsSuccessSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cancel_spot_fleet_requests_success_item(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_cancel_spot_fleet_requests_error_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CancelSpotFleetRequestsErrorItem>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CancelSpotFleetRequestsErrorSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cancel_spot_fleet_requests_error_item(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_cancelled_spot_instance_request_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::CancelledSpotInstanceRequest>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CancelledSpotInstanceRequestList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cancelled_spot_instance_request(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_tag_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#TagList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_capacity_reservation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CapacityReservation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CapacityReservation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("capacityReservationId") /* CapacityReservationId com.amazonaws.ec2#CapacityReservation$CapacityReservationId */ =>  {
                let var_929 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_id(var_929);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2#CapacityReservation$OwnerId */ =>  {
                let var_930 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_930);
            }
            ,
            s if s.matches("capacityReservationArn") /* CapacityReservationArn com.amazonaws.ec2#CapacityReservation$CapacityReservationArn */ =>  {
                let var_931 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_arn(var_931);
            }
            ,
            s if s.matches("availabilityZoneId") /* AvailabilityZoneId com.amazonaws.ec2#CapacityReservation$AvailabilityZoneId */ =>  {
                let var_932 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone_id(var_932);
            }
            ,
            s if s.matches("instanceType") /* InstanceType com.amazonaws.ec2#CapacityReservation$InstanceType */ =>  {
                let var_933 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_type(var_933);
            }
            ,
            s if s.matches("instancePlatform") /* InstancePlatform com.amazonaws.ec2#CapacityReservation$InstancePlatform */ =>  {
                let var_934 =
                    Some(
                        Result::<crate::model::CapacityReservationInstancePlatform, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CapacityReservationInstancePlatform::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_platform(var_934);
            }
            ,
            s if s.matches("availabilityZone") /* AvailabilityZone com.amazonaws.ec2#CapacityReservation$AvailabilityZone */ =>  {
                let var_935 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_935);
            }
            ,
            s if s.matches("tenancy") /* Tenancy com.amazonaws.ec2#CapacityReservation$Tenancy */ =>  {
                let var_936 =
                    Some(
                        Result::<crate::model::CapacityReservationTenancy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CapacityReservationTenancy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_tenancy(var_936);
            }
            ,
            s if s.matches("totalInstanceCount") /* TotalInstanceCount com.amazonaws.ec2#CapacityReservation$TotalInstanceCount */ =>  {
                let var_937 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_instance_count(var_937);
            }
            ,
            s if s.matches("availableInstanceCount") /* AvailableInstanceCount com.amazonaws.ec2#CapacityReservation$AvailableInstanceCount */ =>  {
                let var_938 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_available_instance_count(var_938);
            }
            ,
            s if s.matches("ebsOptimized") /* EbsOptimized com.amazonaws.ec2#CapacityReservation$EbsOptimized */ =>  {
                let var_939 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ebs_optimized(var_939);
            }
            ,
            s if s.matches("ephemeralStorage") /* EphemeralStorage com.amazonaws.ec2#CapacityReservation$EphemeralStorage */ =>  {
                let var_940 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ephemeral_storage(var_940);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#CapacityReservation$State */ =>  {
                let var_941 =
                    Some(
                        Result::<crate::model::CapacityReservationState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CapacityReservationState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_941);
            }
            ,
            s if s.matches("startDate") /* StartDate com.amazonaws.ec2#CapacityReservation$StartDate */ =>  {
                let var_942 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#MillisecondDateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_start_date(var_942);
            }
            ,
            s if s.matches("endDate") /* EndDate com.amazonaws.ec2#CapacityReservation$EndDate */ =>  {
                let var_943 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_end_date(var_943);
            }
            ,
            s if s.matches("endDateType") /* EndDateType com.amazonaws.ec2#CapacityReservation$EndDateType */ =>  {
                let var_944 =
                    Some(
                        Result::<crate::model::EndDateType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EndDateType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_end_date_type(var_944);
            }
            ,
            s if s.matches("instanceMatchCriteria") /* InstanceMatchCriteria com.amazonaws.ec2#CapacityReservation$InstanceMatchCriteria */ =>  {
                let var_945 =
                    Some(
                        Result::<crate::model::InstanceMatchCriteria, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InstanceMatchCriteria::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_match_criteria(var_945);
            }
            ,
            s if s.matches("createDate") /* CreateDate com.amazonaws.ec2#CapacityReservation$CreateDate */ =>  {
                let var_946 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.ec2#DateTime`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_946);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#CapacityReservation$Tags */ =>  {
                let var_947 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_947);
            }
            ,
            s if s.matches("outpostArn") /* OutpostArn com.amazonaws.ec2#CapacityReservation$OutpostArn */ =>  {
                let var_948 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_arn(var_948);
            }
            ,
            s if s.matches("capacityReservationFleetId") /* CapacityReservationFleetId com.amazonaws.ec2#CapacityReservation$CapacityReservationFleetId */ =>  {
                let var_949 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_capacity_reservation_fleet_id(var_949);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_fleet_capacity_reservation_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::FleetCapacityReservation>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#FleetCapacityReservationSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_fleet_capacity_reservation(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_carrier_gateway(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CarrierGateway, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CarrierGateway::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("carrierGatewayId") /* CarrierGatewayId com.amazonaws.ec2#CarrierGateway$CarrierGatewayId */ =>  {
                let var_950 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_carrier_gateway_id(var_950);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2#CarrierGateway$VpcId */ =>  {
                let var_951 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_951);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#CarrierGateway$State */ =>  {
                let var_952 =
                    Some(
                        Result::<crate::model::CarrierGatewayState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::CarrierGatewayState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_952);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2#CarrierGateway$OwnerId */ =>  {
                let var_953 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_953);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#CarrierGateway$Tags */ =>  {
                let var_954 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_954);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_client_vpn_endpoint_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClientVpnEndpointStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClientVpnEndpointStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("code") /* Code com.amazonaws.ec2#ClientVpnEndpointStatus$Code */ =>  {
                let var_955 =
                    Some(
                        Result::<crate::model::ClientVpnEndpointStatusCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ClientVpnEndpointStatusCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_955);
            }
            ,
            s if s.matches("message") /* Message com.amazonaws.ec2#ClientVpnEndpointStatus$Message */ =>  {
                let var_956 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_956);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_client_vpn_route_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClientVpnRouteStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClientVpnRouteStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("code") /* Code com.amazonaws.ec2#ClientVpnRouteStatus$Code */ =>  {
                let var_957 =
                    Some(
                        Result::<crate::model::ClientVpnRouteStatusCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ClientVpnRouteStatusCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_957);
            }
            ,
            s if s.matches("message") /* Message com.amazonaws.ec2#ClientVpnRouteStatus$Message */ =>  {
                let var_958 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_958);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_customer_gateway(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CustomerGateway, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CustomerGateway::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("bgpAsn") /* BgpAsn com.amazonaws.ec2#CustomerGateway$BgpAsn */ =>  {
                let var_959 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bgp_asn(var_959);
            }
            ,
            s if s.matches("customerGatewayId") /* CustomerGatewayId com.amazonaws.ec2#CustomerGateway$CustomerGatewayId */ =>  {
                let var_960 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_customer_gateway_id(var_960);
            }
            ,
            s if s.matches("ipAddress") /* IpAddress com.amazonaws.ec2#CustomerGateway$IpAddress */ =>  {
                let var_961 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ip_address(var_961);
            }
            ,
            s if s.matches("certificateArn") /* CertificateArn com.amazonaws.ec2#CustomerGateway$CertificateArn */ =>  {
                let var_962 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_arn(var_962);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#CustomerGateway$State */ =>  {
                let var_963 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_963);
            }
            ,
            s if s.matches("type") /* Type com.amazonaws.ec2#CustomerGateway$Type */ =>  {
                let var_964 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_type(var_964);
            }
            ,
            s if s.matches("deviceName") /* DeviceName com.amazonaws.ec2#CustomerGateway$DeviceName */ =>  {
                let var_965 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_device_name(var_965);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#CustomerGateway$Tags */ =>  {
                let var_966 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_966);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_subnet(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Subnet, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Subnet::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("availabilityZone") /* AvailabilityZone com.amazonaws.ec2#Subnet$AvailabilityZone */ =>  {
                let var_967 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_967);
            }
            ,
            s if s.matches("availabilityZoneId") /* AvailabilityZoneId com.amazonaws.ec2#Subnet$AvailabilityZoneId */ =>  {
                let var_968 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone_id(var_968);
            }
            ,
            s if s.matches("availableIpAddressCount") /* AvailableIpAddressCount com.amazonaws.ec2#Subnet$AvailableIpAddressCount */ =>  {
                let var_969 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_available_ip_address_count(var_969);
            }
            ,
            s if s.matches("cidrBlock") /* CidrBlock com.amazonaws.ec2#Subnet$CidrBlock */ =>  {
                let var_970 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr_block(var_970);
            }
            ,
            s if s.matches("defaultForAz") /* DefaultForAz com.amazonaws.ec2#Subnet$DefaultForAz */ =>  {
                let var_971 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_default_for_az(var_971);
            }
            ,
            s if s.matches("enableLniAtDeviceIndex") /* EnableLniAtDeviceIndex com.amazonaws.ec2#Subnet$EnableLniAtDeviceIndex */ =>  {
                let var_972 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.ec2#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enable_lni_at_device_index(var_972);
            }
            ,
            s if s.matches("mapPublicIpOnLaunch") /* MapPublicIpOnLaunch com.amazonaws.ec2#Subnet$MapPublicIpOnLaunch */ =>  {
                let var_973 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_map_public_ip_on_launch(var_973);
            }
            ,
            s if s.matches("mapCustomerOwnedIpOnLaunch") /* MapCustomerOwnedIpOnLaunch com.amazonaws.ec2#Subnet$MapCustomerOwnedIpOnLaunch */ =>  {
                let var_974 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_map_customer_owned_ip_on_launch(var_974);
            }
            ,
            s if s.matches("customerOwnedIpv4Pool") /* CustomerOwnedIpv4Pool com.amazonaws.ec2#Subnet$CustomerOwnedIpv4Pool */ =>  {
                let var_975 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_customer_owned_ipv4_pool(var_975);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#Subnet$State */ =>  {
                let var_976 =
                    Some(
                        Result::<crate::model::SubnetState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SubnetState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_976);
            }
            ,
            s if s.matches("subnetId") /* SubnetId com.amazonaws.ec2#Subnet$SubnetId */ =>  {
                let var_977 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_id(var_977);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2#Subnet$VpcId */ =>  {
                let var_978 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_978);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2#Subnet$OwnerId */ =>  {
                let var_979 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_979);
            }
            ,
            s if s.matches("assignIpv6AddressOnCreation") /* AssignIpv6AddressOnCreation com.amazonaws.ec2#Subnet$AssignIpv6AddressOnCreation */ =>  {
                let var_980 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_assign_ipv6_address_on_creation(var_980);
            }
            ,
            s if s.matches("ipv6CidrBlockAssociationSet") /* Ipv6CidrBlockAssociationSet com.amazonaws.ec2#Subnet$Ipv6CidrBlockAssociationSet */ =>  {
                let var_981 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_subnet_ipv6_cidr_block_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association_set(var_981);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#Subnet$Tags */ =>  {
                let var_982 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_982);
            }
            ,
            s if s.matches("subnetArn") /* SubnetArn com.amazonaws.ec2#Subnet$SubnetArn */ =>  {
                let var_983 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_arn(var_983);
            }
            ,
            s if s.matches("outpostArn") /* OutpostArn com.amazonaws.ec2#Subnet$OutpostArn */ =>  {
                let var_984 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_arn(var_984);
            }
            ,
            s if s.matches("enableDns64") /* EnableDns64 com.amazonaws.ec2#Subnet$EnableDns64 */ =>  {
                let var_985 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enable_dns64(var_985);
            }
            ,
            s if s.matches("ipv6Native") /* Ipv6Native com.amazonaws.ec2#Subnet$Ipv6Native */ =>  {
                let var_986 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ipv6_native(var_986);
            }
            ,
            s if s.matches("privateDnsNameOptionsOnLaunch") /* PrivateDnsNameOptionsOnLaunch com.amazonaws.ec2#Subnet$PrivateDnsNameOptionsOnLaunch */ =>  {
                let var_987 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_private_dns_name_options_on_launch(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_private_dns_name_options_on_launch(var_987);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_vpc(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Vpc, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Vpc::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("cidrBlock") /* CidrBlock com.amazonaws.ec2#Vpc$CidrBlock */ =>  {
                let var_988 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidr_block(var_988);
            }
            ,
            s if s.matches("dhcpOptionsId") /* DhcpOptionsId com.amazonaws.ec2#Vpc$DhcpOptionsId */ =>  {
                let var_989 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dhcp_options_id(var_989);
            }
            ,
            s if s.matches("state") /* State com.amazonaws.ec2#Vpc$State */ =>  {
                let var_990 =
                    Some(
                        Result::<crate::model::VpcState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::VpcState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_990);
            }
            ,
            s if s.matches("vpcId") /* VpcId com.amazonaws.ec2#Vpc$VpcId */ =>  {
                let var_991 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_991);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2#Vpc$OwnerId */ =>  {
                let var_992 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_992);
            }
            ,
            s if s.matches("instanceTenancy") /* InstanceTenancy com.amazonaws.ec2#Vpc$InstanceTenancy */ =>  {
                let var_993 =
                    Some(
                        Result::<crate::model::Tenancy, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Tenancy::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_tenancy(var_993);
            }
            ,
            s if s.matches("ipv6CidrBlockAssociationSet") /* Ipv6CidrBlockAssociationSet com.amazonaws.ec2#Vpc$Ipv6CidrBlockAssociationSet */ =>  {
                let var_994 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_ipv6_cidr_block_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ipv6_cidr_block_association_set(var_994);
            }
            ,
            s if s.matches("cidrBlockAssociationSet") /* CidrBlockAssociationSet com.amazonaws.ec2#Vpc$CidrBlockAssociationSet */ =>  {
                let var_995 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_vpc_cidr_block_association_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cidr_block_association_set(var_995);
            }
            ,
            s if s.matches("isDefault") /* IsDefault com.amazonaws.ec2#Vpc$IsDefault */ =>  {
                let var_996 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.ec2#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_default(var_996);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#Vpc$Tags */ =>  {
                let var_997 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_997);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_dhcp_options(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DhcpOptions, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DhcpOptions::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("dhcpConfigurationSet") /* DhcpConfigurations com.amazonaws.ec2#DhcpOptions$DhcpConfigurations */ =>  {
                let var_998 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_dhcp_configuration_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dhcp_configurations(var_998);
            }
            ,
            s if s.matches("dhcpOptionsId") /* DhcpOptionsId com.amazonaws.ec2#DhcpOptions$DhcpOptionsId */ =>  {
                let var_999 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dhcp_options_id(var_999);
            }
            ,
            s if s.matches("ownerId") /* OwnerId com.amazonaws.ec2#DhcpOptions$OwnerId */ =>  {
                let var_1000 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_id(var_1000);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#DhcpOptions$Tags */ =>  {
                let var_1001 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_1001);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_egress_only_internet_gateway(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EgressOnlyInternetGateway, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EgressOnlyInternetGateway::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("attachmentSet") /* Attachments com.amazonaws.ec2#EgressOnlyInternetGateway$Attachments */ =>  {
                let var_1002 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_internet_gateway_attachment_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attachments(var_1002);
            }
            ,
            s if s.matches("egressOnlyInternetGatewayId") /* EgressOnlyInternetGatewayId com.amazonaws.ec2#EgressOnlyInternetGateway$EgressOnlyInternetGatewayId */ =>  {
                let var_1003 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_egress_only_internet_gateway_id(var_1003);
            }
            ,
            s if s.matches("tagSet") /* Tags com.amazonaws.ec2#EgressOnlyInternetGateway$Tags */ =>  {
                let var_1004 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_ec2_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_1004);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_ec2_create_fleet_errors_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::CreateFleetError>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CreateFleetErrorsSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_create_fleet_error(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_create_fleet_instances_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::CreateFleetInstance>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#CreateFleetInstancesSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_create_fleet_instance(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_ec2_value_string_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("item") /* member com.amazonaws.ec2#ValueStringList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_export_task(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ExportTask, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ExportTask::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("description") /* Description com.amazonaws.ec2#ExportTask$Description */ =>  {
                let var_1005 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_1005);
            }
            ,
            s if s.matches("exportTaskId") /* ExportTaskId com.amazonaws.ec2#ExportTask$ExportTaskId */ =>  {
                let var_1006 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_export_task_id(var_1006);
            }
            ,
            s if s.matches("exportToS3") /* ExportToS3Task com.amazonaws.ec2#ExportTask$ExportToS3Task */ =>  {
                let var_1007 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_export_to_s3_task(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_export_to_s3_task(var_1007);
            }
            ,
            s if s.matches("instanceExport") /* InstanceExportDetails com.amazonaws.ec2#ExportTask$InstanceExportDetails */ =>  {
                let var_1008 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_export_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_export_details(var_1008);
            }
            ,
            s if s.matches("state") /* State com.amazo