// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptReservedInstancesExchangeQuoteInput`](crate::input::AcceptReservedInstancesExchangeQuoteInput)
pub mod accept_reserved_instances_exchange_quote_input {
    /// A builder for [`AcceptReservedInstancesExchangeQuoteInput`](crate::input::AcceptReservedInstancesExchangeQuoteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) reserved_instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_configurations:
            std::option::Option<std::vec::Vec<crate::model::TargetConfigurationRequest>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `reserved_instance_ids`.
        ///
        /// To override the contents of this collection use [`set_reserved_instance_ids`](Self::set_reserved_instance_ids).
        ///
        /// <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
        pub fn reserved_instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reserved_instance_ids.unwrap_or_default();
            v.push(input.into());
            self.reserved_instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>
        pub fn set_reserved_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reserved_instance_ids = input;
            self
        }
        /// Appends an item to `target_configurations`.
        ///
        /// To override the contents of this collection use [`set_target_configurations`](Self::set_target_configurations).
        ///
        /// <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
        pub fn target_configurations(
            mut self,
            input: crate::model::TargetConfigurationRequest,
        ) -> Self {
            let mut v = self.target_configurations.unwrap_or_default();
            v.push(input);
            self.target_configurations = Some(v);
            self
        }
        /// <p>The configuration of the target Convertible Reserved Instance to exchange for your current Convertible Reserved Instances.</p>
        pub fn set_target_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetConfigurationRequest>>,
        ) -> Self {
            self.target_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptReservedInstancesExchangeQuoteInput`](crate::input::AcceptReservedInstancesExchangeQuoteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptReservedInstancesExchangeQuoteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptReservedInstancesExchangeQuoteInput {
                dry_run: self.dry_run,
                reserved_instance_ids: self.reserved_instance_ids,
                target_configurations: self.target_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptReservedInstancesExchangeQuoteInputOperationOutputAlias =
    crate::operation::AcceptReservedInstancesExchangeQuote;
#[doc(hidden)]
pub type AcceptReservedInstancesExchangeQuoteInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptReservedInstancesExchangeQuoteInput {
    /// Consumes the builder and constructs an Operation<[`AcceptReservedInstancesExchangeQuote`](crate::operation::AcceptReservedInstancesExchangeQuote)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptReservedInstancesExchangeQuote,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptReservedInstancesExchangeQuoteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptReservedInstancesExchangeQuoteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_reserved_instances_exchange_quote(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptReservedInstancesExchangeQuote::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptReservedInstancesExchangeQuote",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptReservedInstancesExchangeQuoteInput`](crate::input::AcceptReservedInstancesExchangeQuoteInput)
    pub fn builder() -> crate::input::accept_reserved_instances_exchange_quote_input::Builder {
        crate::input::accept_reserved_instances_exchange_quote_input::Builder::default()
    }
}

/// See [`AcceptTransitGatewayMulticastDomainAssociationsInput`](crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput)
pub mod accept_transit_gateway_multicast_domain_associations_input {
    /// A builder for [`AcceptTransitGatewayMulticastDomainAssociationsInput`](crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_multicast_domain_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn transit_gateway_multicast_domain_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_multicast_domain_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_multicast_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_multicast_domain_id = input;
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptTransitGatewayMulticastDomainAssociationsInput`](crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput {
                    transit_gateway_multicast_domain_id: self.transit_gateway_multicast_domain_id,
                    transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                    subnet_ids: self.subnet_ids,
                    dry_run: self.dry_run,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AcceptTransitGatewayMulticastDomainAssociationsInputOperationOutputAlias =
    crate::operation::AcceptTransitGatewayMulticastDomainAssociations;
#[doc(hidden)]
pub type AcceptTransitGatewayMulticastDomainAssociationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptTransitGatewayMulticastDomainAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`AcceptTransitGatewayMulticastDomainAssociations`](crate::operation::AcceptTransitGatewayMulticastDomainAssociations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptTransitGatewayMulticastDomainAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_transit_gateway_multicast_domain_associations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptTransitGatewayMulticastDomainAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptTransitGatewayMulticastDomainAssociations",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayMulticastDomainAssociationsInput`](crate::input::AcceptTransitGatewayMulticastDomainAssociationsInput)
    pub fn builder(
    ) -> crate::input::accept_transit_gateway_multicast_domain_associations_input::Builder {
        crate::input::accept_transit_gateway_multicast_domain_associations_input::Builder::default()
    }
}

/// See [`AcceptTransitGatewayPeeringAttachmentInput`](crate::input::AcceptTransitGatewayPeeringAttachmentInput)
pub mod accept_transit_gateway_peering_attachment_input {
    /// A builder for [`AcceptTransitGatewayPeeringAttachmentInput`](crate::input::AcceptTransitGatewayPeeringAttachmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptTransitGatewayPeeringAttachmentInput`](crate::input::AcceptTransitGatewayPeeringAttachmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptTransitGatewayPeeringAttachmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptTransitGatewayPeeringAttachmentInput {
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptTransitGatewayPeeringAttachmentInputOperationOutputAlias =
    crate::operation::AcceptTransitGatewayPeeringAttachment;
#[doc(hidden)]
pub type AcceptTransitGatewayPeeringAttachmentInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptTransitGatewayPeeringAttachmentInput {
    /// Consumes the builder and constructs an Operation<[`AcceptTransitGatewayPeeringAttachment`](crate::operation::AcceptTransitGatewayPeeringAttachment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptTransitGatewayPeeringAttachment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptTransitGatewayPeeringAttachmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptTransitGatewayPeeringAttachmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_transit_gateway_peering_attachment(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptTransitGatewayPeeringAttachment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptTransitGatewayPeeringAttachment",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayPeeringAttachmentInput`](crate::input::AcceptTransitGatewayPeeringAttachmentInput)
    pub fn builder() -> crate::input::accept_transit_gateway_peering_attachment_input::Builder {
        crate::input::accept_transit_gateway_peering_attachment_input::Builder::default()
    }
}

/// See [`AcceptTransitGatewayVpcAttachmentInput`](crate::input::AcceptTransitGatewayVpcAttachmentInput)
pub mod accept_transit_gateway_vpc_attachment_input {
    /// A builder for [`AcceptTransitGatewayVpcAttachmentInput`](crate::input::AcceptTransitGatewayVpcAttachmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptTransitGatewayVpcAttachmentInput`](crate::input::AcceptTransitGatewayVpcAttachmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptTransitGatewayVpcAttachmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptTransitGatewayVpcAttachmentInput {
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptTransitGatewayVpcAttachmentInputOperationOutputAlias =
    crate::operation::AcceptTransitGatewayVpcAttachment;
#[doc(hidden)]
pub type AcceptTransitGatewayVpcAttachmentInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptTransitGatewayVpcAttachmentInput {
    /// Consumes the builder and constructs an Operation<[`AcceptTransitGatewayVpcAttachment`](crate::operation::AcceptTransitGatewayVpcAttachment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptTransitGatewayVpcAttachment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptTransitGatewayVpcAttachmentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptTransitGatewayVpcAttachmentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_transit_gateway_vpc_attachment(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptTransitGatewayVpcAttachment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptTransitGatewayVpcAttachment",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptTransitGatewayVpcAttachmentInput`](crate::input::AcceptTransitGatewayVpcAttachmentInput)
    pub fn builder() -> crate::input::accept_transit_gateway_vpc_attachment_input::Builder {
        crate::input::accept_transit_gateway_vpc_attachment_input::Builder::default()
    }
}

/// See [`AcceptVpcEndpointConnectionsInput`](crate::input::AcceptVpcEndpointConnectionsInput)
pub mod accept_vpc_endpoint_connections_input {
    /// A builder for [`AcceptVpcEndpointConnectionsInput`](crate::input::AcceptVpcEndpointConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) vpc_endpoint_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the VPC endpoint service.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC endpoint service.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// Appends an item to `vpc_endpoint_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_endpoint_ids`](Self::set_vpc_endpoint_ids).
        ///
        /// <p>The IDs of one or more interface VPC endpoints.</p>
        pub fn vpc_endpoint_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_endpoint_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_endpoint_ids = Some(v);
            self
        }
        /// <p>The IDs of one or more interface VPC endpoints.</p>
        pub fn set_vpc_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_endpoint_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptVpcEndpointConnectionsInput`](crate::input::AcceptVpcEndpointConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptVpcEndpointConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptVpcEndpointConnectionsInput {
                dry_run: self.dry_run,
                service_id: self.service_id,
                vpc_endpoint_ids: self.vpc_endpoint_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptVpcEndpointConnectionsInputOperationOutputAlias =
    crate::operation::AcceptVpcEndpointConnections;
#[doc(hidden)]
pub type AcceptVpcEndpointConnectionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptVpcEndpointConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`AcceptVpcEndpointConnections`](crate::operation::AcceptVpcEndpointConnections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptVpcEndpointConnections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptVpcEndpointConnectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptVpcEndpointConnectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_vpc_endpoint_connections(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptVpcEndpointConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptVpcEndpointConnections",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptVpcEndpointConnectionsInput`](crate::input::AcceptVpcEndpointConnectionsInput)
    pub fn builder() -> crate::input::accept_vpc_endpoint_connections_input::Builder {
        crate::input::accept_vpc_endpoint_connections_input::Builder::default()
    }
}

/// See [`AcceptVpcPeeringConnectionInput`](crate::input::AcceptVpcPeeringConnectionInput)
pub mod accept_vpc_peering_connection_input {
    /// A builder for [`AcceptVpcPeeringConnectionInput`](crate::input::AcceptVpcPeeringConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC peering connection. You must specify this parameter in the request.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptVpcPeeringConnectionInput`](crate::input::AcceptVpcPeeringConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptVpcPeeringConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptVpcPeeringConnectionInput {
                dry_run: self.dry_run,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptVpcPeeringConnectionInputOperationOutputAlias =
    crate::operation::AcceptVpcPeeringConnection;
#[doc(hidden)]
pub type AcceptVpcPeeringConnectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptVpcPeeringConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AcceptVpcPeeringConnection`](crate::operation::AcceptVpcPeeringConnection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptVpcPeeringConnection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptVpcPeeringConnectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptVpcPeeringConnectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_vpc_peering_connection(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptVpcPeeringConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptVpcPeeringConnection",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptVpcPeeringConnectionInput`](crate::input::AcceptVpcPeeringConnectionInput)
    pub fn builder() -> crate::input::accept_vpc_peering_connection_input::Builder {
        crate::input::accept_vpc_peering_connection_input::Builder::default()
    }
}

/// See [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
pub mod advertise_byoip_cidr_input {
    /// A builder for [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdvertiseByoipCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdvertiseByoipCidrInput {
                cidr: self.cidr,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AdvertiseByoipCidrInputOperationOutputAlias = crate::operation::AdvertiseByoipCidr;
#[doc(hidden)]
pub type AdvertiseByoipCidrInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AdvertiseByoipCidrInput {
    /// Consumes the builder and constructs an Operation<[`AdvertiseByoipCidr`](crate::operation::AdvertiseByoipCidr)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdvertiseByoipCidr,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AdvertiseByoipCidrInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AdvertiseByoipCidrInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_advertise_byoip_cidr(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdvertiseByoipCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdvertiseByoipCidr",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    pub fn builder() -> crate::input::advertise_byoip_cidr_input::Builder {
        crate::input::advertise_byoip_cidr_input::Builder::default()
    }
}

/// See [`AllocateAddressInput`](crate::input::AllocateAddressInput)
pub mod allocate_address_input {
    /// A builder for [`AllocateAddressInput`](crate::input::AllocateAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::DomainType>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) public_ipv4_pool: std::option::Option<std::string::String>,
        pub(crate) network_border_group: std::option::Option<std::string::String>,
        pub(crate) customer_owned_ipv4_pool: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p>
        /// <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
        pub fn domain(mut self, input: crate::model::DomainType) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p>
        /// <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>
        pub fn set_domain(mut self, input: std::option::Option<crate::model::DomainType>) -> Self {
            self.domain = input;
            self
        }
        /// <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
        pub fn public_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ipv4_pool = Some(input.into());
            self
        }
        /// <p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>
        pub fn set_public_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ipv4_pool = input;
            self
        }
        /// <p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p>
        /// <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p>
        /// <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an <code>InvalidParameterCombination</code> error.</p>
        pub fn network_border_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_border_group = Some(input.into());
            self
        }
        /// <p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p>
        /// <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p>
        /// <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 Classic, you receive an <code>InvalidParameterCombination</code> error.</p>
        pub fn set_network_border_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_border_group = input;
            self
        }
        /// <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
        pub fn customer_owned_ipv4_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_owned_ipv4_pool = Some(input.into());
            self
        }
        /// <p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>
        pub fn set_customer_owned_ipv4_pool(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_owned_ipv4_pool = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the Elastic IP address.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the Elastic IP address.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateAddressInput`](crate::input::AllocateAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateAddressInput {
                domain: self.domain,
                address: self.address,
                public_ipv4_pool: self.public_ipv4_pool,
                network_border_group: self.network_border_group,
                customer_owned_ipv4_pool: self.customer_owned_ipv4_pool,
                dry_run: self.dry_run,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateAddressInputOperationOutputAlias = crate::operation::AllocateAddress;
#[doc(hidden)]
pub type AllocateAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AllocateAddressInput {
    /// Consumes the builder and constructs an Operation<[`AllocateAddress`](crate::operation::AllocateAddress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AllocateAddressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AllocateAddressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_allocate_address(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateAddress",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AllocateAddressInput`](crate::input::AllocateAddressInput)
    pub fn builder() -> crate::input::allocate_address_input::Builder {
        crate::input::allocate_address_input::Builder::default()
    }
}

/// See [`AllocateHostsInput`](crate::input::AllocateHostsInput)
pub mod allocate_hosts_input {
    /// A builder for [`AllocateHostsInput`](crate::input::AllocateHostsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_placement: std::option::Option<crate::model::AutoPlacement>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_family: std::option::Option<std::string::String>,
        pub(crate) quantity: std::option::Option<i32>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) host_recovery: std::option::Option<crate::model::HostRecovery>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>on</code> </p>
        pub fn auto_placement(mut self, input: crate::model::AutoPlacement) -> Self {
            self.auto_placement = Some(input);
            self
        }
        /// <p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding auto-placement and affinity</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>on</code> </p>
        pub fn set_auto_placement(
            mut self,
            input: std::option::Option<crate::model::AutoPlacement>,
        ) -> Self {
            self.auto_placement = input;
            self
        }
        /// <p>The Availability Zone in which to allocate the Dedicated Host.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to allocate the Dedicated Host.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p>
        /// <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p>
        /// <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p>
        /// <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
        pub fn instance_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_family = Some(input.into());
            self
        }
        /// <p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p>
        /// <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify <b>InstanceType</b> instead. You cannot specify <b>InstanceFamily</b> and <b>InstanceType</b> in the same request.</p>
        pub fn set_instance_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_family = input;
            self
        }
        /// <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
        pub fn quantity(mut self, input: i32) -> Self {
            self.quantity = Some(input);
            self
        }
        /// <p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>
        pub fn set_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.quantity = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Dedicated Host during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the Dedicated Host during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>off</code> </p>
        pub fn host_recovery(mut self, input: crate::model::HostRecovery) -> Self {
            self.host_recovery = Some(input);
            self
        }
        /// <p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host recovery</a> in the <i>Amazon EC2 User Guide</i>.</p>
        /// <p>Default: <code>off</code> </p>
        pub fn set_host_recovery(
            mut self,
            input: std::option::Option<crate::model::HostRecovery>,
        ) -> Self {
            self.host_recovery = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated Host.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on which to allocate the Dedicated Host.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateHostsInput`](crate::input::AllocateHostsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateHostsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateHostsInput {
                auto_placement: self.auto_placement,
                availability_zone: self.availability_zone,
                client_token: self.client_token,
                instance_type: self.instance_type,
                instance_family: self.instance_family,
                quantity: self.quantity,
                tag_specifications: self.tag_specifications,
                host_recovery: self.host_recovery,
                outpost_arn: self.outpost_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateHostsInputOperationOutputAlias = crate::operation::AllocateHosts;
#[doc(hidden)]
pub type AllocateHostsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AllocateHostsInput {
    /// Consumes the builder and constructs an Operation<[`AllocateHosts`](crate::operation::AllocateHosts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateHosts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AllocateHostsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AllocateHostsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_allocate_hosts(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateHosts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateHosts",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AllocateHostsInput`](crate::input::AllocateHostsInput)
    pub fn builder() -> crate::input::allocate_hosts_input::Builder {
        crate::input::allocate_hosts_input::Builder::default()
    }
}

/// See [`AllocateIpamPoolCidrInput`](crate::input::AllocateIpamPoolCidrInput)
pub mod allocate_ipam_pool_cidr_input {
    /// A builder for [`AllocateIpamPoolCidrInput`](crate::input::AllocateIpamPoolCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) ipam_pool_id: std::option::Option<std::string::String>,
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) netmask_length: std::option::Option<i32>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) preview_next_cidr: std::option::Option<bool>,
        pub(crate) disallowed_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the IPAM pool from which you would like to allocate a CIDR.</p>
        pub fn ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipam_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the IPAM pool from which you would like to allocate a CIDR.</p>
        pub fn set_ipam_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipam_pool_id = input;
            self
        }
        /// <p>The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible values: Any available IPv4 or IPv6 CIDR.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible values: Any available IPv4 or IPv6 CIDR.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn netmask_length(mut self, input: i32) -> Self {
            self.netmask_length = Some(input);
            self
        }
        /// <p>The netmask length of the CIDR you would like to allocate from the IPAM pool. Note the following:</p>
        /// <ul>
        /// <li> <p>If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify either the NetmaskLength or the CIDR.</p> </li>
        /// <li> <p>If the DefaultNetmaskLength allocation rule is set on the pool, you can specify either the NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.</p> </li>
        /// </ul>
        /// <p>Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.netmask_length = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A description for the allocation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the allocation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A preview of the next available CIDR in a pool.</p>
        pub fn preview_next_cidr(mut self, input: bool) -> Self {
            self.preview_next_cidr = Some(input);
            self
        }
        /// <p>A preview of the next available CIDR in a pool.</p>
        pub fn set_preview_next_cidr(mut self, input: std::option::Option<bool>) -> Self {
            self.preview_next_cidr = input;
            self
        }
        /// Appends an item to `disallowed_cidrs`.
        ///
        /// To override the contents of this collection use [`set_disallowed_cidrs`](Self::set_disallowed_cidrs).
        ///
        /// <p>Exclude a particular CIDR range from being returned by the pool.</p>
        pub fn disallowed_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disallowed_cidrs.unwrap_or_default();
            v.push(input.into());
            self.disallowed_cidrs = Some(v);
            self
        }
        /// <p>Exclude a particular CIDR range from being returned by the pool.</p>
        pub fn set_disallowed_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disallowed_cidrs = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateIpamPoolCidrInput`](crate::input::AllocateIpamPoolCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateIpamPoolCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateIpamPoolCidrInput {
                dry_run: self.dry_run,
                ipam_pool_id: self.ipam_pool_id,
                cidr: self.cidr,
                netmask_length: self.netmask_length,
                client_token: self.client_token,
                description: self.description,
                preview_next_cidr: self.preview_next_cidr,
                disallowed_cidrs: self.disallowed_cidrs,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateIpamPoolCidrInputOperationOutputAlias = crate::operation::AllocateIpamPoolCidr;
#[doc(hidden)]
pub type AllocateIpamPoolCidrInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AllocateIpamPoolCidrInput {
    /// Consumes the builder and constructs an Operation<[`AllocateIpamPoolCidr`](crate::operation::AllocateIpamPoolCidr)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateIpamPoolCidr,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AllocateIpamPoolCidrInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AllocateIpamPoolCidrInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_allocate_ipam_pool_cidr(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateIpamPoolCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateIpamPoolCidr",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AllocateIpamPoolCidrInput`](crate::input::AllocateIpamPoolCidrInput)
    pub fn builder() -> crate::input::allocate_ipam_pool_cidr_input::Builder {
        crate::input::allocate_ipam_pool_cidr_input::Builder::default()
    }
}

/// See [`ApplySecurityGroupsToClientVpnTargetNetworkInput`](crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput)
pub mod apply_security_groups_to_client_vpn_target_network_input {
    /// A builder for [`ApplySecurityGroupsToClientVpnTargetNetworkInput`](crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_vpn_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_vpn_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_vpn_endpoint_id = input;
            self
        }
        /// <p>The ID of the VPC in which the associated target network is located.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC in which the associated target network is located.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplySecurityGroupsToClientVpnTargetNetworkInput`](crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput {
                    client_vpn_endpoint_id: self.client_vpn_endpoint_id,
                    vpc_id: self.vpc_id,
                    security_group_ids: self.security_group_ids,
                    dry_run: self.dry_run,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ApplySecurityGroupsToClientVpnTargetNetworkInputOperationOutputAlias =
    crate::operation::ApplySecurityGroupsToClientVpnTargetNetwork;
#[doc(hidden)]
pub type ApplySecurityGroupsToClientVpnTargetNetworkInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ApplySecurityGroupsToClientVpnTargetNetworkInput {
    /// Consumes the builder and constructs an Operation<[`ApplySecurityGroupsToClientVpnTargetNetwork`](crate::operation::ApplySecurityGroupsToClientVpnTargetNetwork)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplySecurityGroupsToClientVpnTargetNetwork,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_apply_security_groups_to_client_vpn_target_network(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplySecurityGroupsToClientVpnTargetNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplySecurityGroupsToClientVpnTargetNetwork",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ApplySecurityGroupsToClientVpnTargetNetworkInput`](crate::input::ApplySecurityGroupsToClientVpnTargetNetworkInput)
    pub fn builder(
    ) -> crate::input::apply_security_groups_to_client_vpn_target_network_input::Builder {
        crate::input::apply_security_groups_to_client_vpn_target_network_input::Builder::default()
    }
}

/// See [`AssignIpv6AddressesInput`](crate::input::AssignIpv6AddressesInput)
pub mod assign_ipv6_addresses_input {
    /// A builder for [`AssignIpv6AddressesInput`](crate::input::AssignIpv6AddressesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_address_count: std::option::Option<i32>,
        pub(crate) ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_prefix_count: std::option::Option<i32>,
        pub(crate) ipv6_prefixes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.ipv6_address_count = Some(input);
            self
        }
        /// <p>The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_address_count = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn ipv6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input.into());
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>One or more specific IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn ipv6_prefix_count(mut self, input: i32) -> Self {
            self.ipv6_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn set_ipv6_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_prefix_count = input;
            self
        }
        /// Appends an item to `ipv6_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn ipv6_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_prefixes.unwrap_or_default();
            v.push(input.into());
            self.ipv6_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_prefixes = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignIpv6AddressesInput`](crate::input::AssignIpv6AddressesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssignIpv6AddressesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssignIpv6AddressesInput {
                ipv6_address_count: self.ipv6_address_count,
                ipv6_addresses: self.ipv6_addresses,
                ipv6_prefix_count: self.ipv6_prefix_count,
                ipv6_prefixes: self.ipv6_prefixes,
                network_interface_id: self.network_interface_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssignIpv6AddressesInputOperationOutputAlias = crate::operation::AssignIpv6Addresses;
#[doc(hidden)]
pub type AssignIpv6AddressesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssignIpv6AddressesInput {
    /// Consumes the builder and constructs an Operation<[`AssignIpv6Addresses`](crate::operation::AssignIpv6Addresses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssignIpv6Addresses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssignIpv6AddressesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssignIpv6AddressesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_assign_ipv6_addresses(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssignIpv6Addresses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssignIpv6Addresses",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssignIpv6AddressesInput`](crate::input::AssignIpv6AddressesInput)
    pub fn builder() -> crate::input::assign_ipv6_addresses_input::Builder {
        crate::input::assign_ipv6_addresses_input::Builder::default()
    }
}

/// See [`AssignPrivateIpAddressesInput`](crate::input::AssignPrivateIpAddressesInput)
pub mod assign_private_ip_addresses_input {
    /// A builder for [`AssignPrivateIpAddressesInput`](crate::input::AssignPrivateIpAddressesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_reassignment: std::option::Option<bool>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) secondary_private_ip_address_count: std::option::Option<i32>,
        pub(crate) ipv4_prefixes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv4_prefix_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
        pub fn allow_reassignment(mut self, input: bool) -> Self {
            self.allow_reassignment = Some(input);
            self
        }
        /// <p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>
        pub fn set_allow_reassignment(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_reassignment = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
        /// <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
        pub fn private_ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
        /// <p>If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.secondary_private_ip_address_count = Some(input);
            self
        }
        /// <p>The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when also specifying private IP addresses.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.secondary_private_ip_address_count = input;
            self
        }
        /// Appends an item to `ipv4_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn ipv4_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv4_prefixes.unwrap_or_default();
            v.push(input.into());
            self.ipv4_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv4_prefixes = input;
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn ipv4_prefix_count(mut self, input: i32) -> Self {
            self.ipv4_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn set_ipv4_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv4_prefix_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AssignPrivateIpAddressesInput`](crate::input::AssignPrivateIpAddressesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssignPrivateIpAddressesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssignPrivateIpAddressesInput {
                allow_reassignment: self.allow_reassignment,
                network_interface_id: self.network_interface_id,
                private_ip_addresses: self.private_ip_addresses,
                secondary_private_ip_address_count: self.secondary_private_ip_address_count,
                ipv4_prefixes: self.ipv4_prefixes,
                ipv4_prefix_count: self.ipv4_prefix_count,
            })
        }
    }
}
#[doc(hidden)]
pub type AssignPrivateIpAddressesInputOperationOutputAlias =
    crate::operation::AssignPrivateIpAddresses;
#[doc(hidden)]
pub type AssignPrivateIpAddressesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssignPrivateIpAddressesInput {
    /// Consumes the builder and constructs an Operation<[`AssignPrivateIpAddresses`](crate::operation::AssignPrivateIpAddresses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssignPrivateIpAddresses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssignPrivateIpAddressesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssignPrivateIpAddressesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_assign_private_ip_addresses(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssignPrivateIpAddresses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssignPrivateIpAddresses",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssignPrivateIpAddressesInput`](crate::input::AssignPrivateIpAddressesInput)
    pub fn builder() -> crate::input::assign_private_ip_addresses_input::Builder {
        crate::input::assign_private_ip_addresses_input::Builder::default()
    }
}

/// See [`AssociateAddressInput`](crate::input::AssociateAddressInput)
pub mod associate_address_input {
    /// A builder for [`AssociateAddressInput`](crate::input::AssociateAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocation_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) allow_reassociation: std::option::Option<bool>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
        pub fn allocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.allocation_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>
        pub fn set_allocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allocation_id = input;
            self
        }
        /// <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an instance ID and the instance must be in the running state.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>[EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
        pub fn allow_reassociation(mut self, input: bool) -> Self {
            self.allow_reassociation = Some(input);
            self
        }
        /// <p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>
        pub fn set_allow_reassociation(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_reassociation = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>
        /// <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p>
        /// <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAddressInput`](crate::input::AssociateAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAddressInput {
                allocation_id: self.allocation_id,
                instance_id: self.instance_id,
                public_ip: self.public_ip,
                allow_reassociation: self.allow_reassociation,
                dry_run: self.dry_run,
                network_interface_id: self.network_interface_id,
                private_ip_address: self.private_ip_address,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAddressInputOperationOutputAlias = crate::operation::AssociateAddress;
#[doc(hidden)]
pub type AssociateAddressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateAddressInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAddress`](crate::operation::AssociateAddress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAddress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateAddressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateAddressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_address(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAddress",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateAddressInput`](crate::input::AssociateAddressInput)
    pub fn builder() -> crate::input::associate_address_input::Builder {
        crate::input::associate_address_input::Builder::default()
    }
}

/// See [`AssociateClientVpnTargetNetworkInput`](crate::input::AssociateClientVpnTargetNetworkInput)
pub mod associate_client_vpn_target_network_input {
    /// A builder for [`AssociateClientVpnTargetNetworkInput`](crate::input::AssociateClientVpnTargetNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_vpn_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_vpn_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_vpn_endpoint_id = input;
            self
        }
        /// <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet to associate with the Client VPN endpoint.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateClientVpnTargetNetworkInput`](crate::input::AssociateClientVpnTargetNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateClientVpnTargetNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateClientVpnTargetNetworkInput {
                client_vpn_endpoint_id: self.client_vpn_endpoint_id,
                subnet_id: self.subnet_id,
                client_token: self.client_token,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateClientVpnTargetNetworkInputOperationOutputAlias =
    crate::operation::AssociateClientVpnTargetNetwork;
#[doc(hidden)]
pub type AssociateClientVpnTargetNetworkInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateClientVpnTargetNetworkInput {
    /// Consumes the builder and constructs an Operation<[`AssociateClientVpnTargetNetwork`](crate::operation::AssociateClientVpnTargetNetwork)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateClientVpnTargetNetwork,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateClientVpnTargetNetworkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateClientVpnTargetNetworkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_client_vpn_target_network(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateClientVpnTargetNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateClientVpnTargetNetwork",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateClientVpnTargetNetworkInput`](crate::input::AssociateClientVpnTargetNetworkInput)
    pub fn builder() -> crate::input::associate_client_vpn_target_network_input::Builder {
        crate::input::associate_client_vpn_target_network_input::Builder::default()
    }
}

/// See [`AssociateDhcpOptionsInput`](crate::input::AssociateDhcpOptionsInput)
pub mod associate_dhcp_options_input {
    /// A builder for [`AssociateDhcpOptionsInput`](crate::input::AssociateDhcpOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dhcp_options_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
        pub fn dhcp_options_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dhcp_options_id = Some(input.into());
            self
        }
        /// <p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>
        pub fn set_dhcp_options_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dhcp_options_id = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDhcpOptionsInput`](crate::input::AssociateDhcpOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDhcpOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDhcpOptionsInput {
                dhcp_options_id: self.dhcp_options_id,
                vpc_id: self.vpc_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDhcpOptionsInputOperationOutputAlias = crate::operation::AssociateDhcpOptions;
#[doc(hidden)]
pub type AssociateDhcpOptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateDhcpOptionsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDhcpOptions`](crate::operation::AssociateDhcpOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDhcpOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateDhcpOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateDhcpOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_dhcp_options(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDhcpOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDhcpOptions",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateDhcpOptionsInput`](crate::input::AssociateDhcpOptionsInput)
    pub fn builder() -> crate::input::associate_dhcp_options_input::Builder {
        crate::input::associate_dhcp_options_input::Builder::default()
    }
}

/// See [`AssociateEnclaveCertificateIamRoleInput`](crate::input::AssociateEnclaveCertificateIamRoleInput)
pub mod associate_enclave_certificate_iam_role_input {
    /// A builder for [`AssociateEnclaveCertificateIamRoleInput`](crate::input::AssociateEnclaveCertificateIamRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the ACM certificate with which to associate the IAM role.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role to associate with the ACM certificate. You can associate up to 16 IAM roles with an ACM certificate.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateEnclaveCertificateIamRoleInput`](crate::input::AssociateEnclaveCertificateIamRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateEnclaveCertificateIamRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateEnclaveCertificateIamRoleInput {
                certificate_arn: self.certificate_arn,
                role_arn: self.role_arn,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateEnclaveCertificateIamRoleInputOperationOutputAlias =
    crate::operation::AssociateEnclaveCertificateIamRole;
#[doc(hidden)]
pub type AssociateEnclaveCertificateIamRoleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateEnclaveCertificateIamRoleInput {
    /// Consumes the builder and constructs an Operation<[`AssociateEnclaveCertificateIamRole`](crate::operation::AssociateEnclaveCertificateIamRole)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateEnclaveCertificateIamRole,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateEnclaveCertificateIamRoleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateEnclaveCertificateIamRoleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_enclave_certificate_iam_role(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateEnclaveCertificateIamRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateEnclaveCertificateIamRole",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateEnclaveCertificateIamRoleInput`](crate::input::AssociateEnclaveCertificateIamRoleInput)
    pub fn builder() -> crate::input::associate_enclave_certificate_iam_role_input::Builder {
        crate::input::associate_enclave_certificate_iam_role_input::Builder::default()
    }
}

/// See [`AssociateIamInstanceProfileInput`](crate::input::AssociateIamInstanceProfileInput)
pub mod associate_iam_instance_profile_input {
    /// A builder for [`AssociateIamInstanceProfileInput`](crate::input::AssociateIamInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_instance_profile:
            std::option::Option<crate::model::IamInstanceProfileSpecification>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM instance profile.</p>
        pub fn iam_instance_profile(
            mut self,
            input: crate::model::IamInstanceProfileSpecification,
        ) -> Self {
            self.iam_instance_profile = Some(input);
            self
        }
        /// <p>The IAM instance profile.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::IamInstanceProfileSpecification>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateIamInstanceProfileInput`](crate::input::AssociateIamInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateIamInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateIamInstanceProfileInput {
                iam_instance_profile: self.iam_instance_profile,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateIamInstanceProfileInputOperationOutputAlias =
    crate::operation::AssociateIamInstanceProfile;
#[doc(hidden)]
pub type AssociateIamInstanceProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateIamInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`AssociateIamInstanceProfile`](crate::operation::AssociateIamInstanceProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateIamInstanceProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateIamInstanceProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateIamInstanceProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_iam_instance_profile(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateIamInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateIamInstanceProfile",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateIamInstanceProfileInput`](crate::input::AssociateIamInstanceProfileInput)
    pub fn builder() -> crate::input::associate_iam_instance_profile_input::Builder {
        crate::input::associate_iam_instance_profile_input::Builder::default()
    }
}

/// See [`AssociateInstanceEventWindowInput`](crate::input::AssociateInstanceEventWindowInput)
pub mod associate_instance_event_window_input {
    /// A builder for [`AssociateInstanceEventWindowInput`](crate::input::AssociateInstanceEventWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) instance_event_window_id: std::option::Option<std::string::String>,
        pub(crate) association_target:
            std::option::Option<crate::model::InstanceEventWindowAssociationRequest>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the event window.</p>
        pub fn instance_event_window_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_event_window_id = Some(input.into());
            self
        }
        /// <p>The ID of the event window.</p>
        pub fn set_instance_event_window_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_event_window_id = input;
            self
        }
        /// <p>One or more targets associated with the specified event window.</p>
        pub fn association_target(
            mut self,
            input: crate::model::InstanceEventWindowAssociationRequest,
        ) -> Self {
            self.association_target = Some(input);
            self
        }
        /// <p>One or more targets associated with the specified event window.</p>
        pub fn set_association_target(
            mut self,
            input: std::option::Option<crate::model::InstanceEventWindowAssociationRequest>,
        ) -> Self {
            self.association_target = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateInstanceEventWindowInput`](crate::input::AssociateInstanceEventWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateInstanceEventWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateInstanceEventWindowInput {
                dry_run: self.dry_run,
                instance_event_window_id: self.instance_event_window_id,
                association_target: self.association_target,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateInstanceEventWindowInputOperationOutputAlias =
    crate::operation::AssociateInstanceEventWindow;
#[doc(hidden)]
pub type AssociateInstanceEventWindowInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateInstanceEventWindowInput {
    /// Consumes the builder and constructs an Operation<[`AssociateInstanceEventWindow`](crate::operation::AssociateInstanceEventWindow)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateInstanceEventWindow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateInstanceEventWindowInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateInstanceEventWindowInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_instance_event_window(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateInstanceEventWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateInstanceEventWindow",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateInstanceEventWindowInput`](crate::input::AssociateInstanceEventWindowInput)
    pub fn builder() -> crate::input::associate_instance_event_window_input::Builder {
        crate::input::associate_instance_event_window_input::Builder::default()
    }
}

/// See [`AssociateRouteTableInput`](crate::input::AssociateRouteTableInput)
pub mod associate_route_table_input {
    /// A builder for [`AssociateRouteTableInput`](crate::input::AssociateRouteTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the route table.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of the internet gateway or virtual private gateway.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the internet gateway or virtual private gateway.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateRouteTableInput`](crate::input::AssociateRouteTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateRouteTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateRouteTableInput {
                dry_run: self.dry_run,
                route_table_id: self.route_table_id,
                subnet_id: self.subnet_id,
                gateway_id: self.gateway_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateRouteTableInputOperationOutputAlias = crate::operation::AssociateRouteTable;
#[doc(hidden)]
pub type AssociateRouteTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateRouteTableInput {
    /// Consumes the builder and constructs an Operation<[`AssociateRouteTable`](crate::operation::AssociateRouteTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateRouteTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateRouteTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateRouteTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_route_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateRouteTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateRouteTable",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateRouteTableInput`](crate::input::AssociateRouteTableInput)
    pub fn builder() -> crate::input::associate_route_table_input::Builder {
        crate::input::associate_route_table_input::Builder::default()
    }
}

/// See [`AssociateSubnetCidrBlockInput`](crate::input::AssociateSubnetCidrBlockInput)
pub mod associate_subnet_cidr_block_input {
    /// A builder for [`AssociateSubnetCidrBlockInput`](crate::input::AssociateSubnetCidrBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block = input;
            self
        }
        /// <p>The ID of your subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of your subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSubnetCidrBlockInput`](crate::input::AssociateSubnetCidrBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSubnetCidrBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSubnetCidrBlockInput {
                ipv6_cidr_block: self.ipv6_cidr_block,
                subnet_id: self.subnet_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSubnetCidrBlockInputOperationOutputAlias =
    crate::operation::AssociateSubnetCidrBlock;
#[doc(hidden)]
pub type AssociateSubnetCidrBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateSubnetCidrBlockInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSubnetCidrBlock`](crate::operation::AssociateSubnetCidrBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSubnetCidrBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateSubnetCidrBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateSubnetCidrBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_subnet_cidr_block(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSubnetCidrBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSubnetCidrBlock",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateSubnetCidrBlockInput`](crate::input::AssociateSubnetCidrBlockInput)
    pub fn builder() -> crate::input::associate_subnet_cidr_block_input::Builder {
        crate::input::associate_subnet_cidr_block_input::Builder::default()
    }
}

/// See [`AssociateTransitGatewayMulticastDomainInput`](crate::input::AssociateTransitGatewayMulticastDomainInput)
pub mod associate_transit_gateway_multicast_domain_input {
    /// A builder for [`AssociateTransitGatewayMulticastDomainInput`](crate::input::AssociateTransitGatewayMulticastDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_multicast_domain_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn transit_gateway_multicast_domain_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_multicast_domain_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_multicast_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_multicast_domain_id = input;
            self
        }
        /// <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway attachment to associate with the transit gateway multicast domain.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The IDs of the subnets to associate with the transit gateway multicast domain.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTransitGatewayMulticastDomainInput`](crate::input::AssociateTransitGatewayMulticastDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTransitGatewayMulticastDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTransitGatewayMulticastDomainInput {
                transit_gateway_multicast_domain_id: self.transit_gateway_multicast_domain_id,
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                subnet_ids: self.subnet_ids,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTransitGatewayMulticastDomainInputOperationOutputAlias =
    crate::operation::AssociateTransitGatewayMulticastDomain;
#[doc(hidden)]
pub type AssociateTransitGatewayMulticastDomainInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTransitGatewayMulticastDomainInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTransitGatewayMulticastDomain`](crate::operation::AssociateTransitGatewayMulticastDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTransitGatewayMulticastDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateTransitGatewayMulticastDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateTransitGatewayMulticastDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_transit_gateway_multicast_domain(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTransitGatewayMulticastDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTransitGatewayMulticastDomain",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayMulticastDomainInput`](crate::input::AssociateTransitGatewayMulticastDomainInput)
    pub fn builder() -> crate::input::associate_transit_gateway_multicast_domain_input::Builder {
        crate::input::associate_transit_gateway_multicast_domain_input::Builder::default()
    }
}

/// See [`AssociateTransitGatewayRouteTableInput`](crate::input::AssociateTransitGatewayRouteTableInput)
pub mod associate_transit_gateway_route_table_input {
    /// A builder for [`AssociateTransitGatewayRouteTableInput`](crate::input::AssociateTransitGatewayRouteTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transit_gateway_route_table_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_attachment_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the transit gateway route table.</p>
        pub fn transit_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the transit gateway route table.</p>
        pub fn set_transit_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_route_table_id = input;
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn transit_gateway_attachment_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = Some(input.into());
            self
        }
        /// <p>The ID of the attachment.</p>
        pub fn set_transit_gateway_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_attachment_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTransitGatewayRouteTableInput`](crate::input::AssociateTransitGatewayRouteTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTransitGatewayRouteTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTransitGatewayRouteTableInput {
                transit_gateway_route_table_id: self.transit_gateway_route_table_id,
                transit_gateway_attachment_id: self.transit_gateway_attachment_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTransitGatewayRouteTableInputOperationOutputAlias =
    crate::operation::AssociateTransitGatewayRouteTable;
#[doc(hidden)]
pub type AssociateTransitGatewayRouteTableInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTransitGatewayRouteTableInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTransitGatewayRouteTable`](crate::operation::AssociateTransitGatewayRouteTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTransitGatewayRouteTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateTransitGatewayRouteTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateTransitGatewayRouteTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_transit_gateway_route_table(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTransitGatewayRouteTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTransitGatewayRouteTable",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateTransitGatewayRouteTableInput`](crate::input::AssociateTransitGatewayRouteTableInput)
    pub fn builder() -> crate::input::associate_transit_gateway_route_table_input::Builder {
        crate::input::associate_transit_gateway_route_table_input::Builder::default()
    }
}

/// See [`AssociateTrunkInterfaceInput`](crate::input::AssociateTrunkInterfaceInput)
pub mod associate_trunk_interface_input {
    /// A builder for [`AssociateTrunkInterfaceInput`](crate::input::AssociateTrunkInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch_interface_id: std::option::Option<std::string::String>,
        pub(crate) trunk_interface_id: std::option::Option<std::string::String>,
        pub(crate) vlan_id: std::option::Option<i32>,
        pub(crate) gre_key: std::option::Option<i32>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the branch network interface.</p>
        pub fn branch_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the branch network interface.</p>
        pub fn set_branch_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.branch_interface_id = input;
            self
        }
        /// <p>The ID of the trunk network interface.</p>
        pub fn trunk_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.trunk_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the trunk network interface.</p>
        pub fn set_trunk_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trunk_interface_id = input;
            self
        }
        /// <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
        pub fn vlan_id(mut self, input: i32) -> Self {
            self.vlan_id = Some(input);
            self
        }
        /// <p>The ID of the VLAN. This applies to the VLAN protocol.</p>
        pub fn set_vlan_id(mut self, input: std::option::Option<i32>) -> Self {
            self.vlan_id = input;
            self
        }
        /// <p>The application key. This applies to the GRE protocol.</p>
        pub fn gre_key(mut self, input: i32) -> Self {
            self.gre_key = Some(input);
            self
        }
        /// <p>The application key. This applies to the GRE protocol.</p>
        pub fn set_gre_key(mut self, input: std::option::Option<i32>) -> Self {
            self.gre_key = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTrunkInterfaceInput`](crate::input::AssociateTrunkInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTrunkInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTrunkInterfaceInput {
                branch_interface_id: self.branch_interface_id,
                trunk_interface_id: self.trunk_interface_id,
                vlan_id: self.vlan_id,
                gre_key: self.gre_key,
                client_token: self.client_token,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTrunkInterfaceInputOperationOutputAlias =
    crate::operation::AssociateTrunkInterface;
#[doc(hidden)]
pub type AssociateTrunkInterfaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTrunkInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTrunkInterface`](crate::operation::AssociateTrunkInterface)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTrunkInterface,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateTrunkInterfaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateTrunkInterfaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_trunk_interface(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTrunkInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTrunkInterface",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateTrunkInterfaceInput`](crate::input::AssociateTrunkInterfaceInput)
    pub fn builder() -> crate::input::associate_trunk_interface_input::Builder {
        crate::input::associate_trunk_interface_input::Builder::default()
    }
}

/// See [`AssociateVpcCidrBlockInput`](crate::input::AssociateVpcCidrBlockInput)
pub mod associate_vpc_cidr_block_input {
    /// A builder for [`AssociateVpcCidrBlockInput`](crate::input::AssociateVpcCidrBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amazon_provided_ipv6_cidr_block: std::option::Option<bool>,
        pub(crate) cidr_block: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) ipv6_cidr_block_network_border_group: std::option::Option<std::string::String>,
        pub(crate) ipv6_pool: std::option::Option<std::string::String>,
        pub(crate) ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) ipv4_ipam_pool_id: std::option::Option<std::string::String>,
        pub(crate) ipv4_netmask_length: std::option::Option<i32>,
        pub(crate) ipv6_ipam_pool_id: std::option::Option<std::string::String>,
        pub(crate) ipv6_netmask_length: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
        pub fn amazon_provided_ipv6_cidr_block(mut self, input: bool) -> Self {
            self.amazon_provided_ipv6_cidr_block = Some(input);
            self
        }
        /// <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>
        pub fn set_amazon_provided_ipv6_cidr_block(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.amazon_provided_ipv6_cidr_block = input;
            self
        }
        /// <p>An IPv4 CIDR block to associate with the VPC.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_block = Some(input.into());
            self
        }
        /// <p>An IPv4 CIDR block to associate with the VPC.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_block = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p>
        /// <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
        /// <p> You can have one IPv6 CIDR block association per network border group.</p>
        pub fn ipv6_cidr_block_network_border_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block_network_border_group = Some(input.into());
            self
        }
        /// <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.</p>
        /// <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
        /// <p> You can have one IPv6 CIDR block association per network border group.</p>
        pub fn set_ipv6_cidr_block_network_border_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block_network_border_group = input;
            self
        }
        /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
        pub fn ipv6_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_pool = Some(input.into());
            self
        }
        /// <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
        pub fn set_ipv6_pool(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_pool = input;
            self
        }
        /// <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>
        /// <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>An IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>
        /// <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block = input;
            self
        }
        /// <p>Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn ipv4_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv4_ipam_pool_id = Some(input.into());
            self
        }
        /// <p>Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn set_ipv4_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv4_ipam_pool_id = input;
            self
        }
        /// <p>The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn ipv4_netmask_length(mut self, input: i32) -> Self {
            self.ipv4_netmask_length = Some(input);
            self
        }
        /// <p>The netmask length of the IPv4 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_ipv4_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv4_netmask_length = input;
            self
        }
        /// <p>Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn ipv6_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_ipam_pool_id = Some(input.into());
            self
        }
        /// <p>Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more information about Amazon VPC IP Address Manager (IPAM), see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
        pub fn set_ipv6_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_ipam_pool_id = input;
            self
        }
        /// <p>The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn ipv6_netmask_length(mut self, input: i32) -> Self {
            self.ipv6_netmask_length = Some(input);
            self
        }
        /// <p>The netmask length of the IPv6 CIDR you would like to associate from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_ipv6_netmask_length(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_netmask_length = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateVpcCidrBlockInput`](crate::input::AssociateVpcCidrBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateVpcCidrBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateVpcCidrBlockInput {
                amazon_provided_ipv6_cidr_block: self.amazon_provided_ipv6_cidr_block,
                cidr_block: self.cidr_block,
                vpc_id: self.vpc_id,
                ipv6_cidr_block_network_border_group: self.ipv6_cidr_block_network_border_group,
                ipv6_pool: self.ipv6_pool,
                ipv6_cidr_block: self.ipv6_cidr_block,
                ipv4_ipam_pool_id: self.ipv4_ipam_pool_id,
                ipv4_netmask_length: self.ipv4_netmask_length,
                ipv6_ipam_pool_id: self.ipv6_ipam_pool_id,
                ipv6_netmask_length: self.ipv6_netmask_length,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateVpcCidrBlockInputOperationOutputAlias = crate::operation::AssociateVpcCidrBlock;
#[doc(hidden)]
pub type AssociateVpcCidrBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateVpcCidrBlockInput {
    /// Consumes the builder and constructs an Operation<[`AssociateVpcCidrBlock`](crate::operation::AssociateVpcCidrBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateVpcCidrBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateVpcCidrBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateVpcCidrBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_vpc_cidr_block(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateVpcCidrBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateVpcCidrBlock",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateVpcCidrBlockInput`](crate::input::AssociateVpcCidrBlockInput)
    pub fn builder() -> crate::input::associate_vpc_cidr_block_input::Builder {
        crate::input::associate_vpc_cidr_block_input::Builder::default()
    }
}

/// See [`AttachClassicLinkVpcInput`](crate::input::AttachClassicLinkVpcInput)
pub mod attach_classic_link_vpc_input {
    /// A builder for [`AttachClassicLinkVpcInput`](crate::input::AttachClassicLinkVpcInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The ID of one or more of the VPC's security groups. You cannot specify security groups from a different VPC.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachClassicLinkVpcInput`](crate::input::AttachClassicLinkVpcInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachClassicLinkVpcInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachClassicLinkVpcInput {
                dry_run: self.dry_run,
                groups: self.groups,
                instance_id: self.instance_id,
                vpc_id: self.vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachClassicLinkVpcInputOperationOutputAlias = crate::operation::AttachClassicLinkVpc;
#[doc(hidden)]
pub type AttachClassicLinkVpcInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachClassicLinkVpcInput {
    /// Consumes the builder and constructs an Operation<[`AttachClassicLinkVpc`](crate::operation::AttachClassicLinkVpc)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachClassicLinkVpc,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachClassicLinkVpcInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachClassicLinkVpcInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_classic_link_vpc(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachClassicLinkVpc::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachClassicLinkVpc",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachClassicLinkVpcInput`](crate::input::AttachClassicLinkVpcInput)
    pub fn builder() -> crate::input::attach_classic_link_vpc_input::Builder {
        crate::input::attach_classic_link_vpc_input::Builder::default()
    }
}

/// See [`AttachInternetGatewayInput`](crate::input::AttachInternetGatewayInput)
pub mod attach_internet_gateway_input {
    /// A builder for [`AttachInternetGatewayInput`](crate::input::AttachInternetGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) internet_gateway_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the internet gateway.</p>
        pub fn internet_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.internet_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the internet gateway.</p>
        pub fn set_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.internet_gateway_id = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachInternetGatewayInput`](crate::input::AttachInternetGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachInternetGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachInternetGatewayInput {
                dry_run: self.dry_run,
                internet_gateway_id: self.internet_gateway_id,
                vpc_id: self.vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachInternetGatewayInputOperationOutputAlias = crate::operation::AttachInternetGateway;
#[doc(hidden)]
pub type AttachInternetGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachInternetGatewayInput {
    /// Consumes the builder and constructs an Operation<[`AttachInternetGateway`](crate::operation::AttachInternetGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachInternetGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachInternetGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachInternetGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_internet_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachInternetGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachInternetGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachInternetGatewayInput`](crate::input::AttachInternetGatewayInput)
    pub fn builder() -> crate::input::attach_internet_gateway_input::Builder {
        crate::input::attach_internet_gateway_input::Builder::default()
    }
}

/// See [`AttachNetworkInterfaceInput`](crate::input::AttachNetworkInterfaceInput)
pub mod attach_network_interface_input {
    /// A builder for [`AttachNetworkInterfaceInput`](crate::input::AttachNetworkInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_index: std::option::Option<i32>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) network_card_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn device_index(mut self, input: i32) -> Self {
            self.device_index = Some(input);
            self
        }
        /// <p>The index of the device for the network interface attachment.</p>
        pub fn set_device_index(mut self, input: std::option::Option<i32>) -> Self {
            self.device_index = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        pub fn network_card_index(mut self, input: i32) -> Self {
            self.network_card_index = Some(input);
            self
        }
        /// <p>The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index 0. The default is network card index 0.</p>
        pub fn set_network_card_index(mut self, input: std::option::Option<i32>) -> Self {
            self.network_card_index = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachNetworkInterfaceInput`](crate::input::AttachNetworkInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachNetworkInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachNetworkInterfaceInput {
                device_index: self.device_index,
                dry_run: self.dry_run,
                instance_id: self.instance_id,
                network_interface_id: self.network_interface_id,
                network_card_index: self.network_card_index,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachNetworkInterfaceInputOperationOutputAlias = crate::operation::AttachNetworkInterface;
#[doc(hidden)]
pub type AttachNetworkInterfaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachNetworkInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`AttachNetworkInterface`](crate::operation::AttachNetworkInterface)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachNetworkInterface,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachNetworkInterfaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachNetworkInterfaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_network_interface(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachNetworkInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachNetworkInterface",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachNetworkInterfaceInput`](crate::input::AttachNetworkInterfaceInput)
    pub fn builder() -> crate::input::attach_network_interface_input::Builder {
        crate::input::attach_network_interface_input::Builder::default()
    }
}

/// See [`AttachVolumeInput`](crate::input::AttachVolumeInput)
pub mod attach_volume_input {
    /// A builder for [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn device(mut self, input: impl Into<std::string::String>) -> Self {
            self.device = Some(input.into());
            self
        }
        /// <p>The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p>
        pub fn set_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the EBS volume. The volume and instance must be within the same Availability Zone.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachVolumeInput`](crate::input::AttachVolumeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachVolumeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachVolumeInput {
                device: self.device,
                instance_id: self.instance_id,
                volume_id: self.volume_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachVolumeInputOperationOutputAlias = crate::operation::AttachVolume;
#[doc(hidden)]
pub type AttachVolumeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachVolumeInput {
    /// Consumes the builder and constructs an Operation<[`AttachVolume`](crate::operation::AttachVolume)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachVolume,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachVolumeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachVolumeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_volume(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachVolume::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachVolume",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachVolumeInput`](crate::input::AttachVolumeInput)
    pub fn builder() -> crate::input::attach_volume_input::Builder {
        crate::input::attach_volume_input::Builder::default()
    }
}

/// See [`AttachVpnGatewayInput`](crate::input::AttachVpnGatewayInput)
pub mod attach_vpn_gateway_input {
    /// A builder for [`AttachVpnGatewayInput`](crate::input::AttachVpnGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) vpn_gateway_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn vpn_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpn_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private gateway.</p>
        pub fn set_vpn_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpn_gateway_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachVpnGatewayInput`](crate::input::AttachVpnGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachVpnGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachVpnGatewayInput {
                vpc_id: self.vpc_id,
                vpn_gateway_id: self.vpn_gateway_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachVpnGatewayInputOperationOutputAlias = crate::operation::AttachVpnGateway;
#[doc(hidden)]
pub type AttachVpnGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachVpnGatewayInput {
    /// Consumes the builder and constructs an Operation<[`AttachVpnGateway`](crate::operation::AttachVpnGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachVpnGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachVpnGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachVpnGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_vpn_gateway(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachVpnGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachVpnGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachVpnGatewayInput`](crate::input::AttachVpnGatewayInput)
    pub fn builder() -> crate::input::attach_vpn_gateway_input::Builder {
        crate::input::attach_vpn_gateway_input::Builder::default()
    }
}

/// See [`AuthorizeClientVpnIngressInput`](crate::input::AuthorizeClientVpnIngressInput)
pub mod authorize_client_vpn_ingress_input {
    /// A builder for [`AuthorizeClientVpnIngressInput`](crate::input::AuthorizeClientVpnIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_vpn_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) target_network_cidr: std::option::Option<std::string::String>,
        pub(crate) access_group_id: std::option::Option<std::string::String>,
        pub(crate) authorize_all_groups: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_vpn_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_vpn_endpoint_id = input;
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
        pub fn target_network_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_network_cidr = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the network for which access is being authorized.</p>
        pub fn set_target_network_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_network_cidr = input;
            self
        }
        /// <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
        pub fn access_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the group to grant access to, for example, the Active Directory group or identity provider (IdP) group. Required if <code>AuthorizeAllGroups</code> is <code>false</code> or not specified.</p>
        pub fn set_access_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_group_id = input;
            self
        }
        /// <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
        pub fn authorize_all_groups(mut self, input: bool) -> Self {
            self.authorize_all_groups = Some(input);
            self
        }
        /// <p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>
        pub fn set_authorize_all_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.authorize_all_groups = input;
            self
        }
        /// <p>A brief description of the authorization rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description of the authorization rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeClientVpnIngressInput`](crate::input::AuthorizeClientVpnIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeClientVpnIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeClientVpnIngressInput {
                client_vpn_endpoint_id: self.client_vpn_endpoint_id,
                target_network_cidr: self.target_network_cidr,
                access_group_id: self.access_group_id,
                authorize_all_groups: self.authorize_all_groups,
                description: self.description,
                client_token: self.client_token,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeClientVpnIngressInputOperationOutputAlias =
    crate::operation::AuthorizeClientVpnIngress;
#[doc(hidden)]
pub type AuthorizeClientVpnIngressInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AuthorizeClientVpnIngressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeClientVpnIngress`](crate::operation::AuthorizeClientVpnIngress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeClientVpnIngress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::AuthorizeClientVpnIngressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AuthorizeClientVpnIngressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_authorize_client_vpn_ingress(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeClientVpnIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeClientVpnIngress",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeClientVpnIngressInput`](crate::input::AuthorizeClientVpnIngressInput)
    pub fn builder() -> crate::input::authorize_client_vpn_ingress_input::Builder {
        crate::input::authorize_client_vpn_ingress_input::Builder::default()
    }
}

/// See [`AuthorizeSecurityGroupEgressInput`](crate::input::AuthorizeSecurityGroupEgressInput)
pub mod authorize_security_group_egress_input {
    /// A builder for [`AuthorizeSecurityGroupEgressInput`](crate::input::AuthorizeSecurityGroupEgressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) ip_permissions: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) cidr_ip: std::option::Option<std::string::String>,
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) ip_protocol: std::option::Option<std::string::String>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) source_security_group_name: std::option::Option<std::string::String>,
        pub(crate) source_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Appends an item to `ip_permissions`.
        ///
        /// To override the contents of this collection use [`set_ip_permissions`](Self::set_ip_permissions).
        ///
        /// <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
        pub fn ip_permissions(mut self, input: crate::model::IpPermission) -> Self {
            let mut v = self.ip_permissions.unwrap_or_default();
            v.push(input);
            self.ip_permissions = Some(v);
            self
        }
        /// <p>The sets of IP permissions. You can't specify a destination security group and a CIDR IP address range in the same set of permissions.</p>
        pub fn set_ip_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.ip_permissions = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags applied to the security group rule.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags applied to the security group rule.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ip = Some(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the CIDR.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ip = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
        pub fn ip_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_protocol = Some(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the protocol name or number.</p>
        pub fn set_ip_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_protocol = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify the port.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn source_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_security_group_name = Some(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn set_source_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_security_group_name = input;
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn source_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>Not supported. Use a set of IP permissions to specify a destination security group.</p>
        pub fn set_source_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeSecurityGroupEgressInput`](crate::input::AuthorizeSecurityGroupEgressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeSecurityGroupEgressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeSecurityGroupEgressInput {
                dry_run: self.dry_run,
                group_id: self.group_id,
                ip_permissions: self.ip_permissions,
                tag_specifications: self.tag_specifications,
                cidr_ip: self.cidr_ip,
                from_port: self.from_port,
                ip_protocol: self.ip_protocol,
                to_port: self.to_port,
                source_security_group_name: self.source_security_group_name,
                source_security_group_owner_id: self.source_security_group_owner_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeSecurityGroupEgressInputOperationOutputAlias =
    crate::operation::AuthorizeSecurityGroupEgress;
#[doc(hidden)]
pub type AuthorizeSecurityGroupEgressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AuthorizeSecurityGroupEgressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeSecurityGroupEgress`](crate::operation::AuthorizeSecurityGroupEgress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeSecurityGroupEgress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AuthorizeSecurityGroupEgressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AuthorizeSecurityGroupEgressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_authorize_security_group_egress(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeSecurityGroupEgress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeSecurityGroupEgress",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeSecurityGroupEgressInput`](crate::input::AuthorizeSecurityGroupEgressInput)
    pub fn builder() -> crate::input::authorize_security_group_egress_input::Builder {
        crate::input::authorize_security_group_egress_input::Builder::default()
    }
}

/// See [`AuthorizeSecurityGroupIngressInput`](crate::input::AuthorizeSecurityGroupIngressInput)
pub mod authorize_security_group_ingress_input {
    /// A builder for [`AuthorizeSecurityGroupIngressInput`](crate::input::AuthorizeSecurityGroupIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_ip: std::option::Option<std::string::String>,
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) ip_permissions: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        pub(crate) ip_protocol: std::option::Option<std::string::String>,
        pub(crate) source_security_group_name: std::option::Option<std::string::String>,
        pub(crate) source_security_group_owner_id: std::option::Option<std::string::String>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn cidr_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_ip = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_cidr_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_ip = input;
            self
        }
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Appends an item to `ip_permissions`.
        ///
        /// To override the contents of this collection use [`set_ip_permissions`](Self::set_ip_permissions).
        ///
        /// <p>The sets of IP permissions.</p>
        pub fn ip_permissions(mut self, input: crate::model::IpPermission) -> Self {
            let mut v = self.ip_permissions.unwrap_or_default();
            v.push(input);
            self.ip_permissions = Some(v);
            self
        }
        /// <p>The sets of IP permissions.</p>
        pub fn set_ip_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpPermission>>,
        ) -> Self {
            self.ip_permissions = input;
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn ip_protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_protocol = Some(input.into());
            self
        }
        /// <p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>) or number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>). To specify <code>icmpv6</code>, use a set of IP permissions.</p>
        /// <p>[VPC only] Use <code>-1</code> to specify all protocols. If you specify <code>-1</code> or a protocol other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports you specify.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_ip_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_protocol = input;
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
        pub fn source_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_security_group_name = Some(input.into());
            self
        }
        /// <p>[EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC.</p>
        pub fn set_source_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_security_group_name = input;
            self
        }
        /// <p>[nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
        pub fn source_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>[nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead.</p>
        pub fn set_source_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_security_group_owner_id = input;
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p>
        /// <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>[VPC Only] The tags applied to the security group rule.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>[VPC Only] The tags applied to the security group rule.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeSecurityGroupIngressInput`](crate::input::AuthorizeSecurityGroupIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeSecurityGroupIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeSecurityGroupIngressInput {
                cidr_ip: self.cidr_ip,
                from_port: self.from_port,
                group_id: self.group_id,
                group_name: self.group_name,
                ip_permissions: self.ip_permissions,
                ip_protocol: self.ip_protocol,
                source_security_group_name: self.source_security_group_name,
                source_security_group_owner_id: self.source_security_group_owner_id,
                to_port: self.to_port,
                dry_run: self.dry_run,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeSecurityGroupIngressInputOperationOutputAlias =
    crate::operation::AuthorizeSecurityGroupIngress;
#[doc(hidden)]
pub type AuthorizeSecurityGroupIngressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AuthorizeSecurityGroupIngressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeSecurityGroupIngress`](crate::operation::AuthorizeSecurityGroupIngress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeSecurityGroupIngress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AuthorizeSecurityGroupIngressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AuthorizeSecurityGroupIngressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_authorize_security_group_ingress(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeSecurityGroupIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeSecurityGroupIngress",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeSecurityGroupIngressInput`](crate::input::AuthorizeSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_security_group_ingress_input::Builder {
        crate::input::authorize_security_group_ingress_input::Builder::default()
    }
}

/// See [`BundleInstanceInput`](crate::input::BundleInstanceInput)
pub mod bundle_instance_input {
    /// A builder for [`BundleInstanceInput`](crate::input::BundleInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) storage: std::option::Option<crate::model::Storage>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the instance to bundle.</p>
        /// <p>Type: String</p>
        /// <p>Default: None</p>
        /// <p>Required: Yes</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance to bundle.</p>
        /// <p>Type: String</p>
        /// <p>Default: None</p>
        /// <p>Required: Yes</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
        pub fn storage(mut self, input: crate::model::Storage) -> Self {
            self.storage = Some(input);
            self
        }
        /// <p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>
        pub fn set_storage(mut self, input: std::option::Option<crate::model::Storage>) -> Self {
            self.storage = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`BundleInstanceInput`](crate::input::BundleInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BundleInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BundleInstanceInput {
                instance_id: self.instance_id,
                storage: self.storage,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type BundleInstanceInputOperationOutputAlias = crate::operation::BundleInstance;
#[doc(hidden)]
pub type BundleInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BundleInstanceInput {
    /// Consumes the builder and constructs an Operation<[`BundleInstance`](crate::operation::BundleInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BundleInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BundleInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BundleInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_bundle_instance(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BundleInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BundleInstance",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BundleInstanceInput`](crate::input::BundleInstanceInput)
    pub fn builder() -> crate::input::bundle_instance_input::Builder {
        crate::input::bundle_instance_input::Builder::default()
    }
}

/// See [`CancelBundleTaskInput`](crate::input::CancelBundleTaskInput)
pub mod cancel_bundle_task_input {
    /// A builder for [`CancelBundleTaskInput`](crate::input::CancelBundleTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the bundle task.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle task.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelBundleTaskInput`](crate::input::CancelBundleTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelBundleTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelBundleTaskInput {
                bundle_id: self.bundle_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelBundleTaskInputOperationOutputAlias = crate::operation::CancelBundleTask;
#[doc(hidden)]
pub type CancelBundleTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelBundleTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelBundleTask`](crate::operation::CancelBundleTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelBundleTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelBundleTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelBundleTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_bundle_task(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelBundleTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelBundleTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelBundleTaskInput`](crate::input::CancelBundleTaskInput)
    pub fn builder() -> crate::input::cancel_bundle_task_input::Builder {
        crate::input::cancel_bundle_task_input::Builder::default()
    }
}

/// See [`CancelCapacityReservationInput`](crate::input::CancelCapacityReservationInput)
pub mod cancel_capacity_reservation_input {
    /// A builder for [`CancelCapacityReservationInput`](crate::input::CancelCapacityReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_reservation_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Capacity Reservation to be cancelled.</p>
        pub fn capacity_reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_reservation_id = Some(input.into());
            self
        }
        /// <p>The ID of the Capacity Reservation to be cancelled.</p>
        pub fn set_capacity_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_reservation_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelCapacityReservationInput`](crate::input::CancelCapacityReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelCapacityReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelCapacityReservationInput {
                capacity_reservation_id: self.capacity_reservation_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelCapacityReservationInputOperationOutputAlias =
    crate::operation::CancelCapacityReservation;
#[doc(hidden)]
pub type CancelCapacityReservationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelCapacityReservationInput {
    /// Consumes the builder and constructs an Operation<[`CancelCapacityReservation`](crate::operation::CancelCapacityReservation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelCapacityReservation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelCapacityReservationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelCapacityReservationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_capacity_reservation(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelCapacityReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelCapacityReservation",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelCapacityReservationInput`](crate::input::CancelCapacityReservationInput)
    pub fn builder() -> crate::input::cancel_capacity_reservation_input::Builder {
        crate::input::cancel_capacity_reservation_input::Builder::default()
    }
}

/// See [`CancelCapacityReservationFleetsInput`](crate::input::CancelCapacityReservationFleetsInput)
pub mod cancel_capacity_reservation_fleets_input {
    /// A builder for [`CancelCapacityReservationFleetsInput`](crate::input::CancelCapacityReservationFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) capacity_reservation_fleet_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `capacity_reservation_fleet_ids`.
        ///
        /// To override the contents of this collection use [`set_capacity_reservation_fleet_ids`](Self::set_capacity_reservation_fleet_ids).
        ///
        /// <p>The IDs of the Capacity Reservation Fleets to cancel.</p>
        pub fn capacity_reservation_fleet_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.capacity_reservation_fleet_ids.unwrap_or_default();
            v.push(input.into());
            self.capacity_reservation_fleet_ids = Some(v);
            self
        }
        /// <p>The IDs of the Capacity Reservation Fleets to cancel.</p>
        pub fn set_capacity_reservation_fleet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capacity_reservation_fleet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelCapacityReservationFleetsInput`](crate::input::CancelCapacityReservationFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelCapacityReservationFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelCapacityReservationFleetsInput {
                dry_run: self.dry_run,
                capacity_reservation_fleet_ids: self.capacity_reservation_fleet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelCapacityReservationFleetsInputOperationOutputAlias =
    crate::operation::CancelCapacityReservationFleets;
#[doc(hidden)]
pub type CancelCapacityReservationFleetsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelCapacityReservationFleetsInput {
    /// Consumes the builder and constructs an Operation<[`CancelCapacityReservationFleets`](crate::operation::CancelCapacityReservationFleets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelCapacityReservationFleets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelCapacityReservationFleetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelCapacityReservationFleetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_capacity_reservation_fleets(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelCapacityReservationFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelCapacityReservationFleets",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelCapacityReservationFleetsInput`](crate::input::CancelCapacityReservationFleetsInput)
    pub fn builder() -> crate::input::cancel_capacity_reservation_fleets_input::Builder {
        crate::input::cancel_capacity_reservation_fleets_input::Builder::default()
    }
}

/// See [`CancelConversionTaskInput`](crate::input::CancelConversionTaskInput)
pub mod cancel_conversion_task_input {
    /// A builder for [`CancelConversionTaskInput`](crate::input::CancelConversionTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conversion_task_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) reason_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the conversion task.</p>
        pub fn conversion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.conversion_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the conversion task.</p>
        pub fn set_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.conversion_task_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The reason for canceling the conversion task.</p>
        pub fn reason_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason_message = Some(input.into());
            self
        }
        /// <p>The reason for canceling the conversion task.</p>
        pub fn set_reason_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reason_message = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelConversionTaskInput`](crate::input::CancelConversionTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelConversionTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelConversionTaskInput {
                conversion_task_id: self.conversion_task_id,
                dry_run: self.dry_run,
                reason_message: self.reason_message,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelConversionTaskInputOperationOutputAlias = crate::operation::CancelConversionTask;
#[doc(hidden)]
pub type CancelConversionTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelConversionTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelConversionTask`](crate::operation::CancelConversionTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelConversionTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelConversionTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelConversionTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_conversion_task(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelConversionTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelConversionTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelConversionTaskInput`](crate::input::CancelConversionTaskInput)
    pub fn builder() -> crate::input::cancel_conversion_task_input::Builder {
        crate::input::cancel_conversion_task_input::Builder::default()
    }
}

/// See [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
pub mod cancel_export_task_input {
    /// A builder for [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
        pub fn export_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>
        pub fn set_export_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelExportTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelExportTaskInput {
                export_task_id: self.export_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelExportTaskInputOperationOutputAlias = crate::operation::CancelExportTask;
#[doc(hidden)]
pub type CancelExportTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelExportTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelExportTask`](crate::operation::CancelExportTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelExportTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelExportTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelExportTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_export_task(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelExportTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelExportTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    pub fn builder() -> crate::input::cancel_export_task_input::Builder {
        crate::input::cancel_export_task_input::Builder::default()
    }
}

/// See [`CancelImportTaskInput`](crate::input::CancelImportTaskInput)
pub mod cancel_import_task_input {
    /// A builder for [`CancelImportTaskInput`](crate::input::CancelImportTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cancel_reason: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) import_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reason for canceling the task.</p>
        pub fn cancel_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.cancel_reason = Some(input.into());
            self
        }
        /// <p>The reason for canceling the task.</p>
        pub fn set_cancel_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cancel_reason = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the import image or import snapshot task to be canceled.</p>
        pub fn import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the import image or import snapshot task to be canceled.</p>
        pub fn set_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.import_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelImportTaskInput`](crate::input::CancelImportTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelImportTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelImportTaskInput {
                cancel_reason: self.cancel_reason,
                dry_run: self.dry_run,
                import_task_id: self.import_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelImportTaskInputOperationOutputAlias = crate::operation::CancelImportTask;
#[doc(hidden)]
pub type CancelImportTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelImportTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelImportTask`](crate::operation::CancelImportTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelImportTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelImportTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelImportTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_import_task(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelImportTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelImportTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelImportTaskInput`](crate::input::CancelImportTaskInput)
    pub fn builder() -> crate::input::cancel_import_task_input::Builder {
        crate::input::cancel_import_task_input::Builder::default()
    }
}

/// See [`CancelReservedInstancesListingInput`](crate::input::CancelReservedInstancesListingInput)
pub mod cancel_reserved_instances_listing_input {
    /// A builder for [`CancelReservedInstancesListingInput`](crate::input::CancelReservedInstancesListingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_instances_listing_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Reserved Instance listing.</p>
        pub fn reserved_instances_listing_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_instances_listing_id = Some(input.into());
            self
        }
        /// <p>The ID of the Reserved Instance listing.</p>
        pub fn set_reserved_instances_listing_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instances_listing_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelReservedInstancesListingInput`](crate::input::CancelReservedInstancesListingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelReservedInstancesListingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelReservedInstancesListingInput {
                reserved_instances_listing_id: self.reserved_instances_listing_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelReservedInstancesListingInputOperationOutputAlias =
    crate::operation::CancelReservedInstancesListing;
#[doc(hidden)]
pub type CancelReservedInstancesListingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelReservedInstancesListingInput {
    /// Consumes the builder and constructs an Operation<[`CancelReservedInstancesListing`](crate::operation::CancelReservedInstancesListing)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelReservedInstancesListing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelReservedInstancesListingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelReservedInstancesListingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_reserved_instances_listing(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelReservedInstancesListing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelReservedInstancesListing",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelReservedInstancesListingInput`](crate::input::CancelReservedInstancesListingInput)
    pub fn builder() -> crate::input::cancel_reserved_instances_listing_input::Builder {
        crate::input::cancel_reserved_instances_listing_input::Builder::default()
    }
}

/// See [`CancelSpotFleetRequestsInput`](crate::input::CancelSpotFleetRequestsInput)
pub mod cancel_spot_fleet_requests_input {
    /// A builder for [`CancelSpotFleetRequestsInput`](crate::input::CancelSpotFleetRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) spot_fleet_request_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) terminate_instances: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `spot_fleet_request_ids`.
        ///
        /// To override the contents of this collection use [`set_spot_fleet_request_ids`](Self::set_spot_fleet_request_ids).
        ///
        /// <p>The IDs of the Spot Fleet requests.</p>
        pub fn spot_fleet_request_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.spot_fleet_request_ids.unwrap_or_default();
            v.push(input.into());
            self.spot_fleet_request_ids = Some(v);
            self
        }
        /// <p>The IDs of the Spot Fleet requests.</p>
        pub fn set_spot_fleet_request_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.spot_fleet_request_ids = input;
            self
        }
        /// <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
        pub fn terminate_instances(mut self, input: bool) -> Self {
            self.terminate_instances = Some(input);
            self
        }
        /// <p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>
        pub fn set_terminate_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.terminate_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSpotFleetRequestsInput`](crate::input::CancelSpotFleetRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSpotFleetRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSpotFleetRequestsInput {
                dry_run: self.dry_run,
                spot_fleet_request_ids: self.spot_fleet_request_ids,
                terminate_instances: self.terminate_instances,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelSpotFleetRequestsInputOperationOutputAlias =
    crate::operation::CancelSpotFleetRequests;
#[doc(hidden)]
pub type CancelSpotFleetRequestsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelSpotFleetRequestsInput {
    /// Consumes the builder and constructs an Operation<[`CancelSpotFleetRequests`](crate::operation::CancelSpotFleetRequests)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSpotFleetRequests,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelSpotFleetRequestsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelSpotFleetRequestsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_spot_fleet_requests(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSpotFleetRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSpotFleetRequests",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelSpotFleetRequestsInput`](crate::input::CancelSpotFleetRequestsInput)
    pub fn builder() -> crate::input::cancel_spot_fleet_requests_input::Builder {
        crate::input::cancel_spot_fleet_requests_input::Builder::default()
    }
}

/// See [`CancelSpotInstanceRequestsInput`](crate::input::CancelSpotInstanceRequestsInput)
pub mod cancel_spot_instance_requests_input {
    /// A builder for [`CancelSpotInstanceRequestsInput`](crate::input::CancelSpotInstanceRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) spot_instance_request_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `spot_instance_request_ids`.
        ///
        /// To override the contents of this collection use [`set_spot_instance_request_ids`](Self::set_spot_instance_request_ids).
        ///
        /// <p>One or more Spot Instance request IDs.</p>
        pub fn spot_instance_request_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.spot_instance_request_ids.unwrap_or_default();
            v.push(input.into());
            self.spot_instance_request_ids = Some(v);
            self
        }
        /// <p>One or more Spot Instance request IDs.</p>
        pub fn set_spot_instance_request_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.spot_instance_request_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSpotInstanceRequestsInput`](crate::input::CancelSpotInstanceRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSpotInstanceRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSpotInstanceRequestsInput {
                dry_run: self.dry_run,
                spot_instance_request_ids: self.spot_instance_request_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelSpotInstanceRequestsInputOperationOutputAlias =
    crate::operation::CancelSpotInstanceRequests;
#[doc(hidden)]
pub type CancelSpotInstanceRequestsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelSpotInstanceRequestsInput {
    /// Consumes the builder and constructs an Operation<[`CancelSpotInstanceRequests`](crate::operation::CancelSpotInstanceRequests)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSpotInstanceRequests,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelSpotInstanceRequestsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelSpotInstanceRequestsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_spot_instance_requests(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSpotInstanceRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSpotInstanceRequests",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelSpotInstanceRequestsInput`](crate::input::CancelSpotInstanceRequestsInput)
    pub fn builder() -> crate::input::cancel_spot_instance_requests_input::Builder {
        crate::input::cancel_spot_instance_requests_input::Builder::default()
    }
}

/// See [`ConfirmProductInstanceInput`](crate::input::ConfirmProductInstanceInput)
pub mod confirm_product_instance_input {
    /// A builder for [`ConfirmProductInstanceInput`](crate::input::ConfirmProductInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The product code. This must be a product code that you own.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>The product code. This must be a product code that you own.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfirmProductInstanceInput`](crate::input::ConfirmProductInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ConfirmProductInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ConfirmProductInstanceInput {
                instance_id: self.instance_id,
                product_code: self.product_code,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type ConfirmProductInstanceInputOperationOutputAlias = crate::operation::ConfirmProductInstance;
#[doc(hidden)]
pub type ConfirmProductInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ConfirmProductInstanceInput {
    /// Consumes the builder and constructs an Operation<[`ConfirmProductInstance`](crate::operation::ConfirmProductInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ConfirmProductInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ConfirmProductInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ConfirmProductInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_confirm_product_instance(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ConfirmProductInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ConfirmProductInstance",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ConfirmProductInstanceInput`](crate::input::ConfirmProductInstanceInput)
    pub fn builder() -> crate::input::confirm_product_instance_input::Builder {
        crate::input::confirm_product_instance_input::Builder::default()
    }
}

/// See [`CopyFpgaImageInput`](crate::input::CopyFpgaImageInput)
pub mod copy_fpga_image_input {
    /// A builder for [`CopyFpgaImageInput`](crate::input::CopyFpgaImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) source_fpga_image_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the source AFI.</p>
        pub fn source_fpga_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_fpga_image_id = Some(input.into());
            self
        }
        /// <p>The ID of the source AFI.</p>
        pub fn set_source_fpga_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_fpga_image_id = input;
            self
        }
        /// <p>The description for the new AFI.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the new AFI.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name for the new AFI. The default is the name of the source AFI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new AFI. The default is the name of the source AFI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Region that contains the source AFI.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The Region that contains the source AFI.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyFpgaImageInput`](crate::input::CopyFpgaImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyFpgaImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyFpgaImageInput {
                dry_run: self.dry_run,
                source_fpga_image_id: self.source_fpga_image_id,
                description: self.description,
                name: self.name,
                source_region: self.source_region,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyFpgaImageInputOperationOutputAlias = crate::operation::CopyFpgaImage;
#[doc(hidden)]
pub type CopyFpgaImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyFpgaImageInput {
    /// Consumes the builder and constructs an Operation<[`CopyFpgaImage`](crate::operation::CopyFpgaImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyFpgaImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyFpgaImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyFpgaImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_fpga_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyFpgaImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyFpgaImage",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyFpgaImageInput`](crate::input::CopyFpgaImageInput)
    pub fn builder() -> crate::input::copy_fpga_image_input::Builder {
        crate::input::copy_fpga_image_input::Builder::default()
    }
}

/// See [`CopyImageInput`](crate::input::CopyImageInput)
pub mod copy_image_input {
    /// A builder for [`CopyImageInput`](crate::input::CopyImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_image_id: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) destination_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A description for the new AMI in the destination Region.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the new AMI in the destination Region.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used unless you specify a non-default Key Management Service (KMS) KMS key using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to <code>true</code>.</p>
        /// <p>You can specify a KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p>
        /// <p>The specified KMS key must exist in the destination Region.</p>
        /// <p>Amazon EBS does not support asymmetric KMS keys.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the symmetric Key Management Service (KMS) KMS key to use when creating encrypted volumes. If this parameter is not specified, your Amazon Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also set the encrypted state to <code>true</code>.</p>
        /// <p>You can specify a KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is not valid, the action can appear to complete, but eventually fails.</p>
        /// <p>The specified KMS key must exist in the destination Region.</p>
        /// <p>Amazon EBS does not support asymmetric KMS keys.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The name of the new AMI in the destination Region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the new AMI in the destination Region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the AMI to copy.</p>
        pub fn source_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_image_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI to copy.</p>
        pub fn set_source_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_image_id = input;
            self
        }
        /// <p>The name of the Region that contains the AMI to copy.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The name of the Region that contains the AMI to copy.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn destination_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis"> Copying AMIs from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_destination_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_outpost_arn = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyImageInput`](crate::input::CopyImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CopyImageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CopyImageInput {
                client_token: self.client_token,
                description: self.description,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                name: self.name,
                source_image_id: self.source_image_id,
                source_region: self.source_region,
                destination_outpost_arn: self.destination_outpost_arn,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyImageInputOperationOutputAlias = crate::operation::CopyImage;
#[doc(hidden)]
pub type CopyImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyImageInput {
    /// Consumes the builder and constructs an Operation<[`CopyImage`](crate::operation::CopyImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CopyImage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CopyImage",
                    "ec2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyImageInput`](crate::input::CopyImageInput)
    pub fn builder() -> crate::input::copy_image_input::Builder {
        crate::input::copy_image_input::Builder::default()
    }
}

/// See [`CopySnapshotInput`](crate::input::CopySnapshotInput)
pub mod copy_snapshot_input {
    /// A builder for [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination_outpost_arn: std::option::Option<std::string::String>,
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) presigned_url: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) source_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A description for the EBS snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the EBS snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copy snapshots from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn destination_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost to which to copy the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web Services Region to an Outpost. The snapshot must be in the Region for the destination Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots"> Copy snapshots from an Amazon Web Services Region to an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_destination_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_outpost_arn = input;
            self
        }
        /// <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p>
        /// <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the CLI, this is specified using the <code>--region</code> parameter or the default Region in your Amazon Web Services configuration file.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p>The destination Region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This parameter is only valid for specifying the destination Region in a <code>PresignedUrl</code> parameter, where it is required.</p>
        /// <p>The snapshot copy is sent to the regional endpoint that you sent the HTTP request to (for example, <code>ec2.us-east-1.amazonaws.com</code>). With the CLI, this is specified using the <code>--region</code> parameter or the default Region in your Amazon Web Services configuration file.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>
        /// <p>You can specify the KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption. If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p>
        /// <p>You can specify the KMS key using any of the following:</p>
        /// <ul>
        /// <li> <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li>
        /// <li> <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li>
        /// <li> <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p> </li>
        /// </ul>
        /// <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p>
        /// <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
        pub fn presigned_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.presigned_url = Some(input.into());
            self
        }
        /// <p>When you copy an encrypted source snapshot using the Amazon EC2 Query API, you must supply a pre-signed URL. This parameter is optional for unencrypted snapshots. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html">Query requests</a>.</p>
        /// <p>The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.</p>
        pub fn set_presigned_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.presigned_url = input;
            self
        }
        /// <p>The ID of the Region that contains the snapshot to be copied.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The ID of the Region that contains the snapshot to be copied.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The ID of the EBS snapshot to copy.</p>
        pub fn source_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the EBS snapshot to copy.</p>
        pub fn set_source_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new snapshot.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the new snapshot.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CopySnapshotInput`](crate::input::CopySnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopySnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopySnapshotInput {
                description: self.description,
                destination_outpost_arn: self.destination_outpost_arn,
                destination_region: self.destination_region,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                presigned_url: self.presigned_url,
                source_region: self.source_region,
                source_snapshot_id: self.source_snapshot_id,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CopySnapshotInputOperationOutputAlias = crate::operation::CopySnapshot;
#[doc(hidden)]
pub type CopySnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopySnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopySnapshot`](crate::operation::CopySnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopySnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopySnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopySnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopySnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopySnapshot",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
}

/// See [`CreateCapacityReservationInput`](crate::input::CreateCapacityReservationInput)
pub mod create_capacity_reservation_input {
    /// A builder for [`CreateCapacityReservationInput`](crate::input::CreateCapacityReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) instance_platform:
            std::option::Option<crate::model::CapacityReservationInstancePlatform>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<crate::model::CapacityReservationTenancy>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) ephemeral_storage: std::option::Option<bool>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_date_type: std::option::Option<crate::model::EndDateType>,
        pub(crate) instance_match_criteria:
            std::option::Option<crate::model::InstanceMatchCriteria>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) placement_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for which to reserve capacity. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The type of operating system for which to reserve capacity.</p>
        pub fn instance_platform(
            mut self,
            input: crate::model::CapacityReservationInstancePlatform,
        ) -> Self {
            self.instance_platform = Some(input);
            self
        }
        /// <p>The type of operating system for which to reserve capacity.</p>
        pub fn set_instance_platform(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationInstancePlatform>,
        ) -> Self {
            self.instance_platform = input;
            self
        }
        /// <p>The Availability Zone in which to create the Capacity Reservation.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to create the Capacity Reservation.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the Availability Zone in which to create the Capacity Reservation.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn tenancy(mut self, input: crate::model::CapacityReservationTenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_tenancy(
            mut self,
            input: std::option::Option<crate::model::CapacityReservationTenancy>,
        ) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>The number of instances for which to reserve capacity.</p>
        /// <p>Valid range: 1 - 1000</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances for which to reserve capacity.</p>
        /// <p>Valid range: 1 - 1000</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
        pub fn ephemeral_storage(mut self, input: bool) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>
        pub fn set_ephemeral_storage(mut self, input: std::option::Option<bool>) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
        /// <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>
        /// <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
        /// <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>
        /// <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
        /// <ul>
        /// <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li>
        /// <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li>
        /// </ul>
        pub fn end_date_type(mut self, input: crate::model::EndDateType) -> Self {
            self.end_date_type = Some(input);
            self
        }
        /// <p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
        /// <ul>
        /// <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li>
        /// <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li>
        /// </ul>
        pub fn set_end_date_type(
            mut self,
            input: std::option::Option<crate::model::EndDateType>,
        ) -> Self {
            self.end_date_type = input;
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li>
        /// <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li>
        /// </ul>
        /// <p>Default: <code>open</code> </p>
        pub fn instance_match_criteria(
            mut self,
            input: crate::model::InstanceMatchCriteria,
        ) -> Self {
            self.instance_match_criteria = Some(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
        /// <ul>
        /// <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li>
        /// <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li>
        /// </ul>
        /// <p>Default: <code>open</code> </p>
        pub fn set_instance_match_criteria(
            mut self,
            input: std::option::Option<crate::model::InstanceMatchCriteria>,
        ) -> Self {
            self.instance_match_criteria = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Capacity Reservation during launch.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the Capacity Reservation during launch.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn placement_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_placement_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCapacityReservationInput`](crate::input::CreateCapacityReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCapacityReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCapacityReservationInput {
                client_token: self.client_token,
                instance_type: self.instance_type,
                instance_platform: self.instance_platform,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                tenancy: self.tenancy,
                instance_count: self.instance_count,
                ebs_optimized: self.ebs_optimized,
                ephemeral_storage: self.ephemeral_storage,
                end_date: self.end_date,
                end_date_type: self.end_date_type,
                instance_match_criteria: self.instance_match_criteria,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
                outpost_arn: self.outpost_arn,
                placement_group_arn: self.placement_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCapacityReservationInputOperationOutputAlias =
    crate::operation::CreateCapacityReservation;
#[doc(hidden)]
pub type CreateCapacityReservationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCapacityReservationInput {
    /// Consumes the builder and constructs an Operation<[`CreateCapacityReservation`](crate::operation::CreateCapacityReservation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCapacityReservation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCapacityReservationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCapacityReservationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_capacity_reservation(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCapacityReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCapacityReservation",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCapacityReservationInput`](crate::input::CreateCapacityReservationInput)
    pub fn builder() -> crate::input::create_capacity_reservation_input::Builder {
        crate::input::create_capacity_reservation_input::Builder::default()
    }
}

/// See [`CreateCapacityReservationFleetInput`](crate::input::CreateCapacityReservationFleetInput)
pub mod create_capacity_reservation_fleet_input {
    /// A builder for [`CreateCapacityReservationFleetInput`](crate::input::CreateCapacityReservationFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocation_strategy: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) instance_type_specifications:
            std::option::Option<std::vec::Vec<crate::model::ReservationFleetInstanceSpecification>>,
        pub(crate) tenancy: std::option::Option<crate::model::FleetCapacityReservationTenancy>,
        pub(crate) total_target_capacity: std::option::Option<i32>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) instance_match_criteria:
            std::option::Option<crate::model::FleetInstanceMatchCriteria>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy"> Allocation strategy</a> in the Amazon EC2 User Guide.</p>
        /// <p>Valid values: <code>prioritized</code> </p>
        pub fn allocation_strategy(mut self, input: impl Into<std::string::String>) -> Self {
            self.allocation_strategy = Some(input.into());
            self
        }
        /// <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified instance types to use. Currently, only the <code>prioritized</code> allocation strategy is supported. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy"> Allocation strategy</a> in the Amazon EC2 User Guide.</p>
        /// <p>Valid values: <code>prioritized</code> </p>
        pub fn set_allocation_strategy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allocation_strategy = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `instance_type_specifications`.
        ///
        /// To override the contents of this collection use [`set_instance_type_specifications`](Self::set_instance_type_specifications).
        ///
        /// <p>Information about the instance types for which to reserve the capacity.</p>
        pub fn instance_type_specifications(
            mut self,
            input: crate::model::ReservationFleetInstanceSpecification,
        ) -> Self {
            let mut v = self.instance_type_specifications.unwrap_or_default();
            v.push(input);
            self.instance_type_specifications = Some(v);
            self
        }
        /// <p>Information about the instance types for which to reserve the capacity.</p>
        pub fn set_instance_type_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservationFleetInstanceSpecification>,
            >,
        ) -> Self {
            self.instance_type_specifications = input;
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn tenancy(mut self, input: crate::model::FleetCapacityReservationTenancy) -> Self {
            self.tenancy = Some(input);
            self
        }
        /// <p>Indicates the tenancy of the Capacity Reservation Fleet. All Capacity Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one of the following tenancy settings:</p>
        /// <ul>
        /// <li> <p> <code>default</code> - The Capacity Reservation Fleet is created on hardware that is shared with other Amazon Web Services accounts.</p> </li>
        /// <li> <p> <code>dedicated</code> - The Capacity Reservations are created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_tenancy(
            mut self,
            input: std::option::Option<crate::model::FleetCapacityReservationTenancy>,
        ) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity"> Total target capacity</a> in the Amazon EC2 User Guide.</p>
        pub fn total_target_capacity(mut self, input: i32) -> Self {
            self.total_target_capacity = Some(input);
            self
        }
        /// <p>The total number of capacity units to be reserved by the Capacity Reservation Fleet. This value, together with the instance type weights that you assign to each instance type used by the Fleet determine the number of instances for which the Fleet reserves capacity. Both values are based on units that make sense for your workload. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity"> Total target capacity</a> in the Amazon EC2 User Guide.</p>
        pub fn set_total_target_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.total_target_capacity = input;
            self
        }
        /// <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.</p>
        /// <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>. </p>
        pub fn end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The date and time at which the Capacity Reservation Fleet expires. When the Capacity Reservation Fleet expires, its state changes to <code>expired</code> and all of the Capacity Reservations in the Fleet expire.</p>
        /// <p>The Capacity Reservation Fleet expires within an hour after the specified time. For example, if you specify <code>5/31/2019</code>, <code>13:30:55</code>, the Capacity Reservation Fleet is guaranteed to expire between <code>13:30:55</code> and <code>14:30:55</code> on <code>5/31/2019</code>. </p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
        /// <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
        pub fn instance_match_criteria(
            mut self,
            input: crate::model::FleetInstanceMatchCriteria,
        ) -> Self {
            self.instance_match_criteria = Some(input);
            self
        }
        /// <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
        /// <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria only. This means that instances that have matching attributes (instance type, platform, and Availability Zone) run in the Capacity Reservations automatically. Instances do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
        pub fn set_instance_match_criteria(
            mut self,
            input: std::option::Option<crate::model::FleetInstanceMatchCriteria>,
        ) -> Self {
            self.instance_match_criteria = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the Capacity Reservation Fleet. The tags are automatically assigned to the Capacity Reservations in the Fleet.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCapacityReservationFleetInput`](crate::input::CreateCapacityReservationFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCapacityReservationFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCapacityReservationFleetInput {
                allocation_strategy: self.allocation_strategy,
                client_token: self.client_token,
                instance_type_specifications: self.instance_type_specifications,
                tenancy: self.tenancy,
                total_target_capacity: self.total_target_capacity,
                end_date: self.end_date,
                instance_match_criteria: self.instance_match_criteria,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCapacityReservationFleetInputOperationOutputAlias =
    crate::operation::CreateCapacityReservationFleet;
#[doc(hidden)]
pub type CreateCapacityReservationFleetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateCapacityReservationFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateCapacityReservationFleet`](crate::operation::CreateCapacityReservationFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCapacityReservationFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCapacityReservationFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCapacityReservationFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_capacity_reservation_fleet(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCapacityReservationFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCapacityReservationFleet",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCapacityReservationFleetInput`](crate::input::CreateCapacityReservationFleetInput)
    pub fn builder() -> crate::input::create_capacity_reservation_fleet_input::Builder {
        crate::input::create_capacity_reservation_fleet_input::Builder::default()
    }
}

/// See [`CreateCarrierGatewayInput`](crate::input::CreateCarrierGatewayInput)
pub mod create_carrier_gateway_input {
    /// A builder for [`CreateCarrierGatewayInput`](crate::input::CreateCarrierGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VPC to associate with the carrier gateway.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC to associate with the carrier gateway.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to associate with the carrier gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to associate with the carrier gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCarrierGatewayInput`](crate::input::CreateCarrierGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCarrierGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCarrierGatewayInput {
                vpc_id: self.vpc_id,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCarrierGatewayInputOperationOutputAlias = crate::operation::CreateCarrierGateway;
#[doc(hidden)]
pub type CreateCarrierGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCarrierGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateCarrierGateway`](crate::operation::CreateCarrierGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCarrierGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCarrierGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCarrierGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_carrier_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCarrierGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCarrierGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCarrierGatewayInput`](crate::input::CreateCarrierGatewayInput)
    pub fn builder() -> crate::input::create_carrier_gateway_input::Builder {
        crate::input::create_carrier_gateway_input::Builder::default()
    }
}

/// See [`CreateClientVpnEndpointInput`](crate::input::CreateClientVpnEndpointInput)
pub mod create_client_vpn_endpoint_input {
    /// A builder for [`CreateClientVpnEndpointInput`](crate::input::CreateClientVpnEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_cidr_block: std::option::Option<std::string::String>,
        pub(crate) server_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) authentication_options:
            std::option::Option<std::vec::Vec<crate::model::ClientVpnAuthenticationRequest>>,
        pub(crate) connection_log_options: std::option::Option<crate::model::ConnectionLogOptions>,
        pub(crate) dns_servers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) transport_protocol: std::option::Option<crate::model::TransportProtocol>,
        pub(crate) vpn_port: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) split_tunnel: std::option::Option<bool>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) self_service_portal: std::option::Option<crate::model::SelfServicePortal>,
        pub(crate) client_connect_options: std::option::Option<crate::model::ClientConnectOptions>,
        pub(crate) session_timeout_hours: std::option::Option<i32>,
        pub(crate) client_login_banner_options:
            std::option::Option<crate::model::ClientLoginBannerOptions>,
    }
    impl Builder {
        /// <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
        pub fn client_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.</p>
        pub fn set_client_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_cidr_block = input;
            self
        }
        /// <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>
        pub fn server_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the server certificate. For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">Certificate Manager User Guide</a>.</p>
        pub fn set_server_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_arn = input;
            self
        }
        /// Appends an item to `authentication_options`.
        ///
        /// To override the contents of this collection use [`set_authentication_options`](Self::set_authentication_options).
        ///
        /// <p>Information about the authentication method to be used to authenticate clients.</p>
        pub fn authentication_options(
            mut self,
            input: crate::model::ClientVpnAuthenticationRequest,
        ) -> Self {
            let mut v = self.authentication_options.unwrap_or_default();
            v.push(input);
            self.authentication_options = Some(v);
            self
        }
        /// <p>Information about the authentication method to be used to authenticate clients.</p>
        pub fn set_authentication_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClientVpnAuthenticationRequest>>,
        ) -> Self {
            self.authentication_options = input;
            self
        }
        /// <p>Information about the client connection logging options.</p>
        /// <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p>
        /// <ul>
        /// <li> <p>Client connection requests</p> </li>
        /// <li> <p>Client connection results (successful and unsuccessful)</p> </li>
        /// <li> <p>Reasons for unsuccessful client connection requests</p> </li>
        /// <li> <p>Client connection termination time</p> </li>
        /// </ul>
        pub fn connection_log_options(mut self, input: crate::model::ConnectionLogOptions) -> Self {
            self.connection_log_options = Some(input);
            self
        }
        /// <p>Information about the client connection logging options.</p>
        /// <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p>
        /// <ul>
        /// <li> <p>Client connection requests</p> </li>
        /// <li> <p>Client connection results (successful and unsuccessful)</p> </li>
        /// <li> <p>Reasons for unsuccessful client connection requests</p> </li>
        /// <li> <p>Client connection termination time</p> </li>
        /// </ul>
        pub fn set_connection_log_options(
            mut self,
            input: std::option::Option<crate::model::ConnectionLogOptions>,
        ) -> Self {
            self.connection_log_options = input;
            self
        }
        /// Appends an item to `dns_servers`.
        ///
        /// To override the contents of this collection use [`set_dns_servers`](Self::set_dns_servers).
        ///
        /// <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
        pub fn dns_servers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_servers.unwrap_or_default();
            v.push(input.into());
            self.dns_servers = Some(v);
            self
        }
        /// <p>Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.</p>
        pub fn set_dns_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_servers = input;
            self
        }
        /// <p>The transport protocol to be used by the VPN session.</p>
        /// <p>Default value: <code>udp</code> </p>
        pub fn transport_protocol(mut self, input: crate::model::TransportProtocol) -> Self {
            self.transport_protocol = Some(input);
            self
        }
        /// <p>The transport protocol to be used by the VPN session.</p>
        /// <p>Default value: <code>udp</code> </p>
        pub fn set_transport_protocol(
            mut self,
            input: std::option::Option<crate::model::TransportProtocol>,
        ) -> Self {
            self.transport_protocol = input;
            self
        }
        /// <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
        /// <p>Valid Values: <code>443</code> | <code>1194</code> </p>
        /// <p>Default Value: <code>443</code> </p>
        pub fn vpn_port(mut self, input: i32) -> Self {
            self.vpn_port = Some(input);
            self
        }
        /// <p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p>
        /// <p>Valid Values: <code>443</code> | <code>1194</code> </p>
        /// <p>Default Value: <code>443</code> </p>
        pub fn set_vpn_port(mut self, input: std::option::Option<i32>) -> Self {
            self.vpn_port = input;
            self
        }
        /// <p>A brief description of the Client VPN endpoint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description of the Client VPN endpoint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
        /// <p>By default, split-tunnel on a VPN endpoint is disabled.</p>
        /// <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>
        pub fn split_tunnel(mut self, input: bool) -> Self {
            self.split_tunnel = Some(input);
            self
        }
        /// <p>Indicates whether split-tunnel is enabled on the Client VPN endpoint.</p>
        /// <p>By default, split-tunnel on a VPN endpoint is disabled.</p>
        /// <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel Client VPN endpoint</a> in the <i>Client VPN Administrator Guide</i>.</p>
        pub fn set_split_tunnel(mut self, input: std::option::Option<bool>) -> Self {
            self.split_tunnel = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the Client VPN endpoint during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the Client VPN endpoint during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
        /// <p>Default Value: <code>enabled</code> </p>
        pub fn self_service_portal(mut self, input: crate::model::SelfServicePortal) -> Self {
            self.self_service_portal = Some(input);
            self
        }
        /// <p>Specify whether to enable the self-service portal for the Client VPN endpoint.</p>
        /// <p>Default Value: <code>enabled</code> </p>
        pub fn set_self_service_portal(
            mut self,
            input: std::option::Option<crate::model::SelfServicePortal>,
        ) -> Self {
            self.self_service_portal = input;
            self
        }
        /// <p>The options for managing connection authorization for new client connections.</p>
        pub fn client_connect_options(mut self, input: crate::model::ClientConnectOptions) -> Self {
            self.client_connect_options = Some(input);
            self
        }
        /// <p>The options for managing connection authorization for new client connections.</p>
        pub fn set_client_connect_options(
            mut self,
            input: std::option::Option<crate::model::ClientConnectOptions>,
        ) -> Self {
            self.client_connect_options = input;
            self
        }
        /// <p>The maximum VPN session duration time in hours.</p>
        /// <p>Valid values: <code>8 | 10 | 12 | 24</code> </p>
        /// <p>Default value: <code>24</code> </p>
        pub fn session_timeout_hours(mut self, input: i32) -> Self {
            self.session_timeout_hours = Some(input);
            self
        }
        /// <p>The maximum VPN session duration time in hours.</p>
        /// <p>Valid values: <code>8 | 10 | 12 | 24</code> </p>
        /// <p>Default value: <code>24</code> </p>
        pub fn set_session_timeout_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.session_timeout_hours = input;
            self
        }
        /// <p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>
        pub fn client_login_banner_options(
            mut self,
            input: crate::model::ClientLoginBannerOptions,
        ) -> Self {
            self.client_login_banner_options = Some(input);
            self
        }
        /// <p>Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients when a VPN session is established.</p>
        pub fn set_client_login_banner_options(
            mut self,
            input: std::option::Option<crate::model::ClientLoginBannerOptions>,
        ) -> Self {
            self.client_login_banner_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClientVpnEndpointInput`](crate::input::CreateClientVpnEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClientVpnEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClientVpnEndpointInput {
                client_cidr_block: self.client_cidr_block,
                server_certificate_arn: self.server_certificate_arn,
                authentication_options: self.authentication_options,
                connection_log_options: self.connection_log_options,
                dns_servers: self.dns_servers,
                transport_protocol: self.transport_protocol,
                vpn_port: self.vpn_port,
                description: self.description,
                split_tunnel: self.split_tunnel,
                dry_run: self.dry_run,
                client_token: self.client_token,
                tag_specifications: self.tag_specifications,
                security_group_ids: self.security_group_ids,
                vpc_id: self.vpc_id,
                self_service_portal: self.self_service_portal,
                client_connect_options: self.client_connect_options,
                session_timeout_hours: self.session_timeout_hours,
                client_login_banner_options: self.client_login_banner_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClientVpnEndpointInputOperationOutputAlias =
    crate::operation::CreateClientVpnEndpoint;
#[doc(hidden)]
pub type CreateClientVpnEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateClientVpnEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateClientVpnEndpoint`](crate::operation::CreateClientVpnEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClientVpnEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateClientVpnEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateClientVpnEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_client_vpn_endpoint(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClientVpnEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClientVpnEndpoint",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateClientVpnEndpointInput`](crate::input::CreateClientVpnEndpointInput)
    pub fn builder() -> crate::input::create_client_vpn_endpoint_input::Builder {
        crate::input::create_client_vpn_endpoint_input::Builder::default()
    }
}

/// See [`CreateClientVpnRouteInput`](crate::input::CreateClientVpnRouteInput)
pub mod create_client_vpn_route_input {
    /// A builder for [`CreateClientVpnRouteInput`](crate::input::CreateClientVpnRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_vpn_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) target_vpc_subnet_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Client VPN endpoint to which to add the route.</p>
        pub fn client_vpn_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_vpn_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Client VPN endpoint to which to add the route.</p>
        pub fn set_client_vpn_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_vpn_endpoint_id = input;
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
        /// <ul>
        /// <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li>
        /// <li> <p>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for the local network, enter the client CIDR range</p> </li>
        /// </ul>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv4 address range, in CIDR notation, of the route destination. For example:</p>
        /// <ul>
        /// <li> <p>To add a route for Internet access, enter <code>0.0.0.0/0</code> </p> </li>
        /// <li> <p>To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range</p> </li>
        /// <li> <p>To add a route for the local network, enter the client CIDR range</p> </li>
        /// </ul>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p>
        /// <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
        pub fn target_vpc_subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_vpc_subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.</p>
        /// <p>Alternatively, if you're adding a route for the local network, specify <code>local</code>.</p>
        pub fn set_target_vpc_subnet_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_vpc_subnet_id = input;
            self
        }
        /// <p>A brief description of the route.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A brief description of the route.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClientVpnRouteInput`](crate::input::CreateClientVpnRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClientVpnRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClientVpnRouteInput {
                client_vpn_endpoint_id: self.client_vpn_endpoint_id,
                destination_cidr_block: self.destination_cidr_block,
                target_vpc_subnet_id: self.target_vpc_subnet_id,
                description: self.description,
                client_token: self.client_token,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClientVpnRouteInputOperationOutputAlias = crate::operation::CreateClientVpnRoute;
#[doc(hidden)]
pub type CreateClientVpnRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateClientVpnRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateClientVpnRoute`](crate::operation::CreateClientVpnRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClientVpnRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateClientVpnRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateClientVpnRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_client_vpn_route(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClientVpnRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClientVpnRoute",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateClientVpnRouteInput`](crate::input::CreateClientVpnRouteInput)
    pub fn builder() -> crate::input::create_client_vpn_route_input::Builder {
        crate::input::create_client_vpn_route_input::Builder::default()
    }
}

/// See [`CreateCustomerGatewayInput`](crate::input::CreateCustomerGatewayInput)
pub mod create_customer_gateway_input {
    /// A builder for [`CreateCustomerGatewayInput`](crate::input::CreateCustomerGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bgp_asn: std::option::Option<i32>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::GatewayType>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>For devices that support BGP, the customer gateway's BGP ASN.</p>
        /// <p>Default: 65000</p>
        pub fn bgp_asn(mut self, input: i32) -> Self {
            self.bgp_asn = Some(input);
            self
        }
        /// <p>For devices that support BGP, the customer gateway's BGP ASN.</p>
        /// <p>Default: 65000</p>
        pub fn set_bgp_asn(mut self, input: std::option::Option<i32>) -> Self {
            self.bgp_asn = input;
            self
        }
        /// <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The Internet-routable IP address for the customer gateway's outside interface. The address must be static.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the customer gateway certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
        pub fn r#type(mut self, input: crate::model::GatewayType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::GatewayType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the customer gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the customer gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>A name for the customer gateway device.</p>
        /// <p>Length Constraints: Up to 255 characters.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>A name for the customer gateway device.</p>
        /// <p>Length Constraints: Up to 255 characters.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomerGatewayInput`](crate::input::CreateCustomerGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomerGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomerGatewayInput {
                bgp_asn: self.bgp_asn,
                public_ip: self.public_ip,
                certificate_arn: self.certificate_arn,
                r#type: self.r#type,
                tag_specifications: self.tag_specifications,
                device_name: self.device_name,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomerGatewayInputOperationOutputAlias = crate::operation::CreateCustomerGateway;
#[doc(hidden)]
pub type CreateCustomerGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomerGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomerGateway`](crate::operation::CreateCustomerGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomerGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomerGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomerGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_customer_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomerGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomerGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomerGatewayInput`](crate::input::CreateCustomerGatewayInput)
    pub fn builder() -> crate::input::create_customer_gateway_input::Builder {
        crate::input::create_customer_gateway_input::Builder::default()
    }
}

/// See [`CreateDefaultSubnetInput`](crate::input::CreateDefaultSubnetInput)
pub mod create_default_subnet_input {
    /// A builder for [`CreateDefaultSubnetInput`](crate::input::CreateDefaultSubnetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) ipv6_native: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Availability Zone in which to create the default subnet.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to create the default subnet.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>
        pub fn ipv6_native(mut self, input: bool) -> Self {
            self.ipv6_native = Some(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet. If you already have a default subnet for this Availability Zone, you must delete it before you can create an IPv6 only subnet.</p>
        pub fn set_ipv6_native(mut self, input: std::option::Option<bool>) -> Self {
            self.ipv6_native = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDefaultSubnetInput`](crate::input::CreateDefaultSubnetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDefaultSubnetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDefaultSubnetInput {
                availability_zone: self.availability_zone,
                dry_run: self.dry_run,
                ipv6_native: self.ipv6_native,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDefaultSubnetInputOperationOutputAlias = crate::operation::CreateDefaultSubnet;
#[doc(hidden)]
pub type CreateDefaultSubnetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDefaultSubnetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDefaultSubnet`](crate::operation::CreateDefaultSubnet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDefaultSubnet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDefaultSubnetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDefaultSubnetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_default_subnet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDefaultSubnet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDefaultSubnet",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDefaultSubnetInput`](crate::input::CreateDefaultSubnetInput)
    pub fn builder() -> crate::input::create_default_subnet_input::Builder {
        crate::input::create_default_subnet_input::Builder::default()
    }
}

/// See [`CreateDefaultVpcInput`](crate::input::CreateDefaultVpcInput)
pub mod create_default_vpc_input {
    /// A builder for [`CreateDefaultVpcInput`](crate::input::CreateDefaultVpcInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDefaultVpcInput`](crate::input::CreateDefaultVpcInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDefaultVpcInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDefaultVpcInput {
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDefaultVpcInputOperationOutputAlias = crate::operation::CreateDefaultVpc;
#[doc(hidden)]
pub type CreateDefaultVpcInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDefaultVpcInput {
    /// Consumes the builder and constructs an Operation<[`CreateDefaultVpc`](crate::operation::CreateDefaultVpc)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDefaultVpc,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDefaultVpcInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDefaultVpcInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_default_vpc(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDefaultVpc::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDefaultVpc",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDefaultVpcInput`](crate::input::CreateDefaultVpcInput)
    pub fn builder() -> crate::input::create_default_vpc_input::Builder {
        crate::input::create_default_vpc_input::Builder::default()
    }
}

/// See [`CreateDhcpOptionsInput`](crate::input::CreateDhcpOptionsInput)
pub mod create_dhcp_options_input {
    /// A builder for [`CreateDhcpOptionsInput`](crate::input::CreateDhcpOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dhcp_configurations:
            std::option::Option<std::vec::Vec<crate::model::NewDhcpConfiguration>>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `dhcp_configurations`.
        ///
        /// To override the contents of this collection use [`set_dhcp_configurations`](Self::set_dhcp_configurations).
        ///
        /// <p>A DHCP configuration option.</p>
        pub fn dhcp_configurations(mut self, input: crate::model::NewDhcpConfiguration) -> Self {
            let mut v = self.dhcp_configurations.unwrap_or_default();
            v.push(input);
            self.dhcp_configurations = Some(v);
            self
        }
        /// <p>A DHCP configuration option.</p>
        pub fn set_dhcp_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NewDhcpConfiguration>>,
        ) -> Self {
            self.dhcp_configurations = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the DHCP option.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the DHCP option.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDhcpOptionsInput`](crate::input::CreateDhcpOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDhcpOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDhcpOptionsInput {
                dhcp_configurations: self.dhcp_configurations,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDhcpOptionsInputOperationOutputAlias = crate::operation::CreateDhcpOptions;
#[doc(hidden)]
pub type CreateDhcpOptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDhcpOptionsInput {
    /// Consumes the builder and constructs an Operation<[`CreateDhcpOptions`](crate::operation::CreateDhcpOptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDhcpOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDhcpOptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDhcpOptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dhcp_options(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDhcpOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDhcpOptions",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDhcpOptionsInput`](crate::input::CreateDhcpOptionsInput)
    pub fn builder() -> crate::input::create_dhcp_options_input::Builder {
        crate::input::create_dhcp_options_input::Builder::default()
    }
}

/// See [`CreateEgressOnlyInternetGatewayInput`](crate::input::CreateEgressOnlyInternetGatewayInput)
pub mod create_egress_only_internet_gateway_input {
    /// A builder for [`CreateEgressOnlyInternetGatewayInput`](crate::input::CreateEgressOnlyInternetGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC for which to create the egress-only internet gateway.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the egress-only internet gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the egress-only internet gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEgressOnlyInternetGatewayInput`](crate::input::CreateEgressOnlyInternetGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEgressOnlyInternetGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEgressOnlyInternetGatewayInput {
                client_token: self.client_token,
                dry_run: self.dry_run,
                vpc_id: self.vpc_id,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEgressOnlyInternetGatewayInputOperationOutputAlias =
    crate::operation::CreateEgressOnlyInternetGateway;
#[doc(hidden)]
pub type CreateEgressOnlyInternetGatewayInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateEgressOnlyInternetGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateEgressOnlyInternetGateway`](crate::operation::CreateEgressOnlyInternetGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEgressOnlyInternetGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEgressOnlyInternetGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEgressOnlyInternetGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_egress_only_internet_gateway(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEgressOnlyInternetGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEgressOnlyInternetGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEgressOnlyInternetGatewayInput`](crate::input::CreateEgressOnlyInternetGatewayInput)
    pub fn builder() -> crate::input::create_egress_only_internet_gateway_input::Builder {
        crate::input::create_egress_only_internet_gateway_input::Builder::default()
    }
}

/// See [`CreateFleetInput`](crate::input::CreateFleetInput)
pub mod create_fleet_input {
    /// A builder for [`CreateFleetInput`](crate::input::CreateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) spot_options: std::option::Option<crate::model::SpotOptionsRequest>,
        pub(crate) on_demand_options: std::option::Option<crate::model::OnDemandOptionsRequest>,
        pub(crate) excess_capacity_termination_policy:
            std::option::Option<crate::model::FleetExcessCapacityTerminationPolicy>,
        pub(crate) launch_template_configs:
            std::option::Option<std::vec::Vec<crate::model::FleetLaunchTemplateConfigRequest>>,
        pub(crate) target_capacity_specification:
            std::option::Option<crate::model::TargetCapacitySpecificationRequest>,
        pub(crate) terminate_instances_with_expiration: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<crate::model::FleetType>,
        pub(crate) valid_from: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) replace_unhealthy_instances: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
        pub fn spot_options(mut self, input: crate::model::SpotOptionsRequest) -> Self {
            self.spot_options = Some(input);
            self
        }
        /// <p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>
        pub fn set_spot_options(
            mut self,
            input: std::option::Option<crate::model::SpotOptionsRequest>,
        ) -> Self {
            self.spot_options = input;
            self
        }
        /// <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
        pub fn on_demand_options(mut self, input: crate::model::OnDemandOptionsRequest) -> Self {
            self.on_demand_options = Some(input);
            self
        }
        /// <p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>
        pub fn set_on_demand_options(
            mut self,
            input: std::option::Option<crate::model::OnDemandOptionsRequest>,
        ) -> Self {
            self.on_demand_options = input;
            self
        }
        /// <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
        pub fn excess_capacity_termination_policy(
            mut self,
            input: crate::model::FleetExcessCapacityTerminationPolicy,
        ) -> Self {
            self.excess_capacity_termination_policy = Some(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>
        pub fn set_excess_capacity_termination_policy(
            mut self,
            input: std::option::Option<crate::model::FleetExcessCapacityTerminationPolicy>,
        ) -> Self {
            self.excess_capacity_termination_policy = input;
            self
        }
        /// Appends an item to `launch_template_configs`.
        ///
        /// To override the contents of this collection use [`set_launch_template_configs`](Self::set_launch_template_configs).
        ///
        /// <p>The configuration for the EC2 Fleet.</p>
        pub fn launch_template_configs(
            mut self,
            input: crate::model::FleetLaunchTemplateConfigRequest,
        ) -> Self {
            let mut v = self.launch_template_configs.unwrap_or_default();
            v.push(input);
            self.launch_template_configs = Some(v);
            self
        }
        /// <p>The configuration for the EC2 Fleet.</p>
        pub fn set_launch_template_configs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FleetLaunchTemplateConfigRequest>,
            >,
        ) -> Self {
            self.launch_template_configs = input;
            self
        }
        /// <p>The number of units to request.</p>
        pub fn target_capacity_specification(
            mut self,
            input: crate::model::TargetCapacitySpecificationRequest,
        ) -> Self {
            self.target_capacity_specification = Some(input);
            self
        }
        /// <p>The number of units to request.</p>
        pub fn set_target_capacity_specification(
            mut self,
            input: std::option::Option<crate::model::TargetCapacitySpecificationRequest>,
        ) -> Self {
            self.target_capacity_specification = input;
            self
        }
        /// <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
        pub fn terminate_instances_with_expiration(mut self, input: bool) -> Self {
            self.terminate_instances_with_expiration = Some(input);
            self
        }
        /// <p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>
        pub fn set_terminate_instances_with_expiration(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.terminate_instances_with_expiration = input;
            self
        }
        /// <p>The fleet type. The default value is <code>maintain</code>.</p>
        /// <ul>
        /// <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li>
        /// <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li>
        /// <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::FleetType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The fleet type. The default value is <code>maintain</code>.</p>
        /// <ul>
        /// <li> <p> <code>maintain</code> - The EC2 Fleet places an asynchronous request for your desired capacity, and continues to maintain your desired Spot capacity by replenishing interrupted Spot Instances.</p> </li>
        /// <li> <p> <code>request</code> - The EC2 Fleet places an asynchronous one-time request for your desired capacity, but does submit Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not maintain Spot capacity if Spot Instances are interrupted.</p> </li>
        /// <li> <p> <code>instant</code> - The EC2 Fleet places a synchronous one-time request for your desired capacity, and returns errors for any instances that could not be launched.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html">EC2 Fleet request types</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FleetType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
        pub fn valid_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_from = Some(input);
            self
        }
        /// <p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>
        pub fn set_valid_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_from = input;
            self
        }
        /// <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
        pub fn valid_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_until = Some(input);
            self
        }
        /// <p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_until = input;
            self
        }
        /// <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn replace_unhealthy_instances(mut self, input: bool) -> Self {
            self.replace_unhealthy_instances = Some(input);
            self
        }
        /// <p>Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type <code>maintain</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.</p>
        pub fn set_replace_unhealthy_instances(mut self, input: std::option::Option<bool>) -> Self {
            self.replace_unhealthy_instances = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>
        /// <p>If the fleet type is <code>instant</code>, specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.</p>
        /// <p>If the fleet type is <code>maintain</code> or <code>request</code>, specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code>. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The key-value pair for tagging the EC2 Fleet request on creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources">Tagging your resources</a>.</p>
        /// <p>If the fleet type is <code>instant</code>, specify a resource type of <code>fleet</code> to tag the fleet or <code>instance</code> to tag the instances at launch.</p>
        /// <p>If the fleet type is <code>maintain</code> or <code>request</code>, specify a resource type of <code>fleet</code> to tag the fleet. You cannot specify a resource type of <code>instance</code>. To tag instances at launch, specify the tags in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template">launch template</a>.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetInput`](crate::input::CreateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetInput {
                dry_run: self.dry_run,
                client_token: self.client_token,
                spot_options: self.spot_options,
                on_demand_options: self.on_demand_options,
                excess_capacity_termination_policy: self.excess_capacity_termination_policy,
                launch_template_configs: self.launch_template_configs,
                target_capacity_specification: self.target_capacity_specification,
                terminate_instances_with_expiration: self.terminate_instances_with_expiration,
                r#type: self.r#type,
                valid_from: self.valid_from,
                valid_until: self.valid_until,
                replace_unhealthy_instances: self.replace_unhealthy_instances,
                tag_specifications: self.tag_specifications,
                context: self.context,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetInputOperationOutputAlias = crate::operation::CreateFleet;
#[doc(hidden)]
pub type CreateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleet`](crate::operation::CreateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleet",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
}

/// See [`CreateFlowLogsInput`](crate::input::CreateFlowLogsInput)
pub mod create_flow_logs_input {
    /// A builder for [`CreateFlowLogsInput`](crate::input::CreateFlowLogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) deliver_logs_permission_arn: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_type: std::option::Option<crate::model::FlowLogsResourceType>,
        pub(crate) traffic_type: std::option::Option<crate::model::TrafficType>,
        pub(crate) log_destination_type: std::option::Option<crate::model::LogDestinationType>,
        pub(crate) log_destination: std::option::Option<std::string::String>,
        pub(crate) log_format: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) max_aggregation_interval: std::option::Option<i32>,
        pub(crate) destination_options:
            std::option::Option<crate::model::DestinationOptionsRequest>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn deliver_logs_permission_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.deliver_logs_permission_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn set_deliver_logs_permission_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deliver_logs_permission_arn = input;
            self
        }
        /// <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p>
        /// <p>Constraints: Maximum of 1000 resources</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p>
        /// <p>Constraints: Maximum of 1000 resources</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
        pub fn resource_type(mut self, input: crate::model::FlowLogsResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::FlowLogsResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
        pub fn traffic_type(mut self, input: crate::model::TrafficType) -> Self {
            self.traffic_type = Some(input);
            self
        }
        /// <p>The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.</p>
        pub fn set_traffic_type(
            mut self,
            input: std::option::Option<crate::model::TrafficType>,
        ) -> Self {
            self.traffic_type = input;
            self
        }
        /// <p>The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        /// <p>Default: <code>cloud-watch-logs</code> </p>
        pub fn log_destination_type(mut self, input: crate::model::LogDestinationType) -> Self {
            self.log_destination_type = Some(input);
            self
        }
        /// <p>The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p>
        /// <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p>
        /// <p>Default: <code>cloud-watch-logs</code> </p>
        pub fn set_log_destination_type(
            mut self,
            input: std::option::Option<crate::model::LogDestinationType>,
        ) -> Self {
            self.log_destination_type = input;
            self
        }
        /// <p>The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p>
        /// <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p>
        /// <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
        pub fn log_destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_destination = Some(input.into());
            self
        }
        /// <p>The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for <code>LogDestinationType</code>.</p>
        /// <p>If <code>LogDestinationType</code> is not specified or <code>cloud-watch-logs</code>, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called <code>my-logs</code>, specify <code>arn:aws:logs:us-east-1:123456789012:log-group:my-logs</code>. Alternatively, use <code>LogGroupName</code> instead.</p>
        /// <p>If LogDestinationType is <code>s3</code>, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: <code>bucket_ARN/subfolder_name/</code>. For example, to specify a subfolder named <code>my-logs</code> in a bucket named <code>my-bucket</code>, use the following ARN: <code>arn:aws:s3:::my-bucket/my-logs/</code>. You cannot use <code>AWSLogs</code> as a subfolder name. This is a reserved term.</p>
        pub fn set_log_destination(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_destination = input;
            self
        }
        /// <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p>
        /// <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.</p>
        pub fn log_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_format = Some(input.into());
            self
        }
        /// <p>The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a>. If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.</p>
        /// <p>Specify the fields using the <code>${field-id}</code> format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.</p>
        pub fn set_log_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_format = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the flow logs.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the flow logs.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p>
        /// <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p>
        /// <p>Default: 600</p>
        pub fn max_aggregation_interval(mut self, input: i32) -> Self {
            self.max_aggregation_interval = Some(input);
            self
        }
        /// <p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p>
        /// <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p>
        /// <p>Default: 600</p>
        pub fn set_max_aggregation_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.max_aggregation_interval = input;
            self
        }
        /// <p>The destination options.</p>
        pub fn destination_options(
            mut self,
            input: crate::model::DestinationOptionsRequest,
        ) -> Self {
            self.destination_options = Some(input);
            self
        }
        /// <p>The destination options.</p>
        pub fn set_destination_options(
            mut self,
            input: std::option::Option<crate::model::DestinationOptionsRequest>,
        ) -> Self {
            self.destination_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowLogsInput`](crate::input::CreateFlowLogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFlowLogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFlowLogsInput {
                dry_run: self.dry_run,
                client_token: self.client_token,
                deliver_logs_permission_arn: self.deliver_logs_permission_arn,
                log_group_name: self.log_group_name,
                resource_ids: self.resource_ids,
                resource_type: self.resource_type,
                traffic_type: self.traffic_type,
                log_destination_type: self.log_destination_type,
                log_destination: self.log_destination,
                log_format: self.log_format,
                tag_specifications: self.tag_specifications,
                max_aggregation_interval: self.max_aggregation_interval,
                destination_options: self.destination_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFlowLogsInputOperationOutputAlias = crate::operation::CreateFlowLogs;
#[doc(hidden)]
pub type CreateFlowLogsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFlowLogsInput {
    /// Consumes the builder and constructs an Operation<[`CreateFlowLogs`](crate::operation::CreateFlowLogs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFlowLogs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFlowLogsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFlowLogsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_flow_logs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFlowLogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFlowLogs",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFlowLogsInput`](crate::input::CreateFlowLogsInput)
    pub fn builder() -> crate::input::create_flow_logs_input::Builder {
        crate::input::create_flow_logs_input::Builder::default()
    }
}

/// See [`CreateFpgaImageInput`](crate::input::CreateFpgaImageInput)
pub mod create_fpga_image_input {
    /// A builder for [`CreateFpgaImageInput`](crate::input::CreateFpgaImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) input_storage_location: std::option::Option<crate::model::StorageLocation>,
        pub(crate) logs_storage_location: std::option::Option<crate::model::StorageLocation>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
        pub fn input_storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.input_storage_location = Some(input);
            self
        }
        /// <p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>
        pub fn set_input_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.input_storage_location = input;
            self
        }
        /// <p>The location in Amazon S3 for the output logs.</p>
        pub fn logs_storage_location(mut self, input: crate::model::StorageLocation) -> Self {
            self.logs_storage_location = Some(input);
            self
        }
        /// <p>The location in Amazon S3 for the output logs.</p>
        pub fn set_logs_storage_location(
            mut self,
            input: std::option::Option<crate::model::StorageLocation>,
        ) -> Self {
            self.logs_storage_location = input;
            self
        }
        /// <p>A description for the AFI.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the AFI.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A name for the AFI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the AFI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the FPGA image during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the FPGA image during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFpgaImageInput`](crate::input::CreateFpgaImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFpgaImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFpgaImageInput {
                dry_run: self.dry_run,
                input_storage_location: self.input_storage_location,
                logs_storage_location: self.logs_storage_location,
                description: self.description,
                name: self.name,
                client_token: self.client_token,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFpgaImageInputOperationOutputAlias = crate::operation::CreateFpgaImage;
#[doc(hidden)]
pub type CreateFpgaImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFpgaImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateFpgaImage`](crate::operation::CreateFpgaImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFpgaImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFpgaImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFpgaImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fpga_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFpgaImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFpgaImage",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFpgaImageInput`](crate::input::CreateFpgaImageInput)
    pub fn builder() -> crate::input::create_fpga_image_input::Builder {
        crate::input::create_fpga_image_input::Builder::default()
    }
}

/// See [`CreateImageInput`](crate::input::CreateImageInput)
pub mod create_image_input {
    /// A builder for [`CreateImageInput`](crate::input::CreateImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) no_reboot: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <code>CopyImage</code> action.</p>
        pub fn block_device_mappings(mut self, input: crate::model::BlockDeviceMapping) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <code>CopyImage</code> action.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>A description for the new image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the new image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A name for the new image.</p>
        /// <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the new image.</p>
        /// <p>Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the attached volumes while data is at rest, in order to ensure a consistent state. You can set the <code>NoReboot</code> parameter to <code>true</code> in the API request, or use the <code>--no-reboot</code> option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.</p> <important>
        /// <p>If you choose to bypass the shutdown and reboot process by setting the <code>NoReboot</code> parameter to <code>true</code> in the API request, or by using the <code>--no-reboot</code> option in the CLI, we can't guarantee the file system integrity of the created image.</p>
        /// </important>
        /// <p>Default: <code>false</code> (follow standard reboot process)</p>
        pub fn no_reboot(mut self, input: bool) -> Self {
            self.no_reboot = Some(input);
            self
        }
        /// <p>By default, when Amazon EC2 creates the new AMI, it reboots the instance so that it can take snapshots of the attached volumes while data is at rest, in order to ensure a consistent state. You can set the <code>NoReboot</code> parameter to <code>true</code> in the API request, or use the <code>--no-reboot</code> option in the CLI to prevent Amazon EC2 from shutting down and rebooting the instance.</p> <important>
        /// <p>If you choose to bypass the shutdown and reboot process by setting the <code>NoReboot</code> parameter to <code>true</code> in the API request, or by using the <code>--no-reboot</code> option in the CLI, we can't guarantee the file system integrity of the created image.</p>
        /// </important>
        /// <p>Default: <code>false</code> (follow standard reboot process)</p>
        pub fn set_no_reboot(mut self, input: std::option::Option<bool>) -> Self {
            self.no_reboot = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        /// <p>If you specify other values for <code>ResourceType</code>, the request fails.</p>
        /// <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        /// <p>If you specify other values for <code>ResourceType</code>, the request fails.</p>
        /// <p>To tag an AMI or snapshot after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>. </p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageInput`](crate::input::CreateImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageInput {
                block_device_mappings: self.block_device_mappings,
                description: self.description,
                dry_run: self.dry_run,
                instance_id: self.instance_id,
                name: self.name,
                no_reboot: self.no_reboot,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageInputOperationOutputAlias = crate::operation::CreateImage;
#[doc(hidden)]
pub type CreateImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateImage`](crate::operation::CreateImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImage",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
}

/// See [`CreateInstanceEventWindowInput`](crate::input::CreateInstanceEventWindowInput)
pub mod create_instance_event_window_input {
    /// A builder for [`CreateInstanceEventWindowInput`](crate::input::CreateInstanceEventWindowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) time_ranges:
            std::option::Option<std::vec::Vec<crate::model::InstanceEventWindowTimeRangeRequest>>,
        pub(crate) cron_expression: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The name of the event window.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event window.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `time_ranges`.
        ///
        /// To override the contents of this collection use [`set_time_ranges`](Self::set_time_ranges).
        ///
        /// <p>The time range for the event window. If you specify a time range, you can't specify a cron expression.</p>
        pub fn time_ranges(
            mut self,
            input: crate::model::InstanceEventWindowTimeRangeRequest,
        ) -> Self {
            let mut v = self.time_ranges.unwrap_or_default();
            v.push(input);
            self.time_ranges = Some(v);
            self
        }
        /// <p>The time range for the event window. If you specify a time range, you can't specify a cron expression.</p>
        pub fn set_time_ranges(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InstanceEventWindowTimeRangeRequest>,
            >,
        ) -> Self {
            self.time_ranges = input;
            self
        }
        /// <p>The cron expression for the event window, for example, <code>* 0-4,20-23 * * 1,5</code>. If you specify a cron expression, you can't specify a time range.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Only hour and day of the week values are supported.</p> </li>
        /// <li> <p>For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative single values <code>SUN</code> through <code>SAT</code>.</p> </li>
        /// <li> <p>The minute, month, and year must be specified by <code>*</code>.</p> </li>
        /// <li> <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.</p> </li>
        /// <li> <p>Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.</p> </li>
        /// <li> <p>The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.</p> </li>
        /// </ul>
        /// <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia website</i>.</p>
        pub fn cron_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.cron_expression = Some(input.into());
            self
        }
        /// <p>The cron expression for the event window, for example, <code>* 0-4,20-23 * * 1,5</code>. If you specify a cron expression, you can't specify a time range.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Only hour and day of the week values are supported.</p> </li>
        /// <li> <p>For day of the week values, you can specify either integers <code>0</code> through <code>6</code>, or alternative single values <code>SUN</code> through <code>SAT</code>.</p> </li>
        /// <li> <p>The minute, month, and year must be specified by <code>*</code>.</p> </li>
        /// <li> <p>The hour value must be one or a multiple range, for example, <code>0-4</code> or <code>0-4,20-23</code>.</p> </li>
        /// <li> <p>Each hour range must be &gt;= 2 hours, for example, <code>0-2</code> or <code>20-23</code>.</p> </li>
        /// <li> <p>The event window must be &gt;= 4 hours. The combined total time ranges in the event window must be &gt;= 4 hours.</p> </li>
        /// </ul>
        /// <p>For more information about cron expressions, see <a href="https://en.wikipedia.org/wiki/Cron">cron</a> on the <i>Wikipedia website</i>.</p>
        pub fn set_cron_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cron_expression = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the event window.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the event window.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceEventWindowInput`](crate::input::CreateInstanceEventWindowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceEventWindowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceEventWindowInput {
                dry_run: self.dry_run,
                name: self.name,
                time_ranges: self.time_ranges,
                cron_expression: self.cron_expression,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceEventWindowInputOperationOutputAlias =
    crate::operation::CreateInstanceEventWindow;
#[doc(hidden)]
pub type CreateInstanceEventWindowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceEventWindowInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceEventWindow`](crate::operation::CreateInstanceEventWindow)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceEventWindow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstanceEventWindowInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstanceEventWindowInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instance_event_window(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceEventWindow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceEventWindow",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceEventWindowInput`](crate::input::CreateInstanceEventWindowInput)
    pub fn builder() -> crate::input::create_instance_event_window_input::Builder {
        crate::input::create_instance_event_window_input::Builder::default()
    }
}

/// See [`CreateInstanceExportTaskInput`](crate::input::CreateInstanceExportTaskInput)
pub mod create_instance_export_task_input {
    /// A builder for [`CreateInstanceExportTaskInput`](crate::input::CreateInstanceExportTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) export_to_s3_task:
            std::option::Option<crate::model::ExportToS3TaskSpecification>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) target_environment: std::option::Option<crate::model::ExportEnvironment>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the conversion task or the resource being exported. The maximum length is 255 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The format and location for an export instance task.</p>
        pub fn export_to_s3_task(
            mut self,
            input: crate::model::ExportToS3TaskSpecification,
        ) -> Self {
            self.export_to_s3_task = Some(input);
            self
        }
        /// <p>The format and location for an export instance task.</p>
        pub fn set_export_to_s3_task(
            mut self,
            input: std::option::Option<crate::model::ExportToS3TaskSpecification>,
        ) -> Self {
            self.export_to_s3_task = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The target virtualization environment.</p>
        pub fn target_environment(mut self, input: crate::model::ExportEnvironment) -> Self {
            self.target_environment = Some(input);
            self
        }
        /// <p>The target virtualization environment.</p>
        pub fn set_target_environment(
            mut self,
            input: std::option::Option<crate::model::ExportEnvironment>,
        ) -> Self {
            self.target_environment = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the export instance task during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the export instance task during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceExportTaskInput`](crate::input::CreateInstanceExportTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceExportTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceExportTaskInput {
                description: self.description,
                export_to_s3_task: self.export_to_s3_task,
                instance_id: self.instance_id,
                target_environment: self.target_environment,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceExportTaskInputOperationOutputAlias =
    crate::operation::CreateInstanceExportTask;
#[doc(hidden)]
pub type CreateInstanceExportTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceExportTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceExportTask`](crate::operation::CreateInstanceExportTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceExportTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstanceExportTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstanceExportTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instance_export_task(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceExportTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceExportTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceExportTaskInput`](crate::input::CreateInstanceExportTaskInput)
    pub fn builder() -> crate::input::create_instance_export_task_input::Builder {
        crate::input::create_instance_export_task_input::Builder::default()
    }
}

/// See [`CreateInternetGatewayInput`](crate::input::CreateInternetGatewayInput)
pub mod create_internet_gateway_input {
    /// A builder for [`CreateInternetGatewayInput`](crate::input::CreateInternetGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the internet gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the internet gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInternetGatewayInput`](crate::input::CreateInternetGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInternetGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInternetGatewayInput {
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInternetGatewayInputOperationOutputAlias = crate::operation::CreateInternetGateway;
#[doc(hidden)]
pub type CreateInternetGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInternetGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateInternetGateway`](crate::operation::CreateInternetGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInternetGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInternetGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInternetGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_internet_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInternetGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInternetGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInternetGatewayInput`](crate::input::CreateInternetGatewayInput)
    pub fn builder() -> crate::input::create_internet_gateway_input::Builder {
        crate::input::create_internet_gateway_input::Builder::default()
    }
}

/// See [`CreateIpamInput`](crate::input::CreateIpamInput)
pub mod create_ipam_input {
    /// A builder for [`CreateIpamInput`](crate::input::CreateIpamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) operating_regions:
            std::option::Option<std::vec::Vec<crate::model::AddIpamOperatingRegion>>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>A description for the IPAM.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the IPAM.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `operating_regions`.
        ///
        /// To override the contents of this collection use [`set_operating_regions`](Self::set_operating_regions).
        ///
        /// <p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
        /// <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn operating_regions(mut self, input: crate::model::AddIpamOperatingRegion) -> Self {
            let mut v = self.operating_regions.unwrap_or_default();
            v.push(input);
            self.operating_regions = Some(v);
            self
        }
        /// <p>The operating Regions for the IPAM. Operating Regions are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers and monitors resources in the Amazon Web Services Regions you select as operating Regions.</p>
        /// <p>For more information about operating Regions, see <a href="/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>. </p>
        pub fn set_operating_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddIpamOperatingRegion>>,
        ) -> Self {
            self.operating_regions = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpamInput`](crate::input::CreateIpamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIpamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIpamInput {
                dry_run: self.dry_run,
                description: self.description,
                operating_regions: self.operating_regions,
                tag_specifications: self.tag_specifications,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIpamInputOperationOutputAlias = crate::operation::CreateIpam;
#[doc(hidden)]
pub type CreateIpamInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIpamInput {
    /// Consumes the builder and constructs an Operation<[`CreateIpam`](crate::operation::CreateIpam)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIpam,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIpamInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIpamInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_ipam(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIpam::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIpam",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIpamInput`](crate::input::CreateIpamInput)
    pub fn builder() -> crate::input::create_ipam_input::Builder {
        crate::input::create_ipam_input::Builder::default()
    }
}

/// See [`CreateIpamPoolInput`](crate::input::CreateIpamPoolInput)
pub mod create_ipam_pool_input {
    /// A builder for [`CreateIpamPoolInput`](crate::input::CreateIpamPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) ipam_scope_id: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) source_ipam_pool_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) address_family: std::option::Option<crate::model::AddressFamily>,
        pub(crate) auto_import: std::option::Option<bool>,
        pub(crate) publicly_advertisable: std::option::Option<bool>,
        pub(crate) allocation_min_netmask_length: std::option::Option<i32>,
        pub(crate) allocation_max_netmask_length: std::option::Option<i32>,
        pub(crate) allocation_default_netmask_length: std::option::Option<i32>,
        pub(crate) allocation_resource_tags:
            std::option::Option<std::vec::Vec<crate::model::RequestIpamResourceTag>>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) aws_service: std::option::Option<crate::model::IpamPoolAwsService>,
    }
    impl Builder {
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the scope in which you would like to create the IPAM pool.</p>
        pub fn ipam_scope_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipam_scope_id = Some(input.into());
            self
        }
        /// <p>The ID of the scope in which you would like to create the IPAM pool.</p>
        pub fn set_ipam_scope_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipam_scope_id = input;
            self
        }
        /// <p>In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.</p>
        /// <p>Possible values: Any Amazon Web Services Region, such as us-east-1.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.</p>
        /// <p>Possible values: Any Amazon Web Services Region, such as us-east-1.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.</p>
        pub fn source_ipam_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_ipam_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.</p>
        pub fn set_source_ipam_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_ipam_pool_id = input;
            self
        }
        /// <p>A description for the IPAM pool.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the IPAM pool.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>
        pub fn address_family(mut self, input: crate::model::AddressFamily) -> Self {
            self.address_family = Some(input);
            self
        }
        /// <p>The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.</p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<crate::model::AddressFamily>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p>
        /// <p>A locale must be set on the pool for this feature to work.</p>
        pub fn auto_import(mut self, input: bool) -> Self {
            self.auto_import = Some(input);
            self
        }
        /// <p>If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only. </p>
        /// <p>A locale must be set on the pool for this feature to work.</p>
        pub fn set_auto_import(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_import = input;
            self
        }
        /// <p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>
        pub fn publicly_advertisable(mut self, input: bool) -> Self {
            self.publicly_advertisable = Some(input);
            self
        }
        /// <p>Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to <code>ipv4</code>.</p>
        pub fn set_publicly_advertisable(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_advertisable = input;
            self
        }
        /// <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn allocation_min_netmask_length(mut self, input: i32) -> Self {
            self.allocation_min_netmask_length = Some(input);
            self
        }
        /// <p>The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_allocation_min_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocation_min_netmask_length = input;
            self
        }
        /// <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn allocation_max_netmask_length(mut self, input: i32) -> Self {
            self.allocation_max_netmask_length = Some(input);
            self
        }
        /// <p>The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.</p>
        pub fn set_allocation_max_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocation_max_netmask_length = input;
            self
        }
        /// <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
        pub fn allocation_default_netmask_length(mut self, input: i32) -> Self {
            self.allocation_default_netmask_length = Some(input);
            self
        }
        /// <p>The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.</p>
        pub fn set_allocation_default_netmask_length(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocation_default_netmask_length = input;
            self
        }
        /// Appends an item to `allocation_resource_tags`.
        ///
        /// To override the contents of this collection use [`set_allocation_resource_tags`](Self::set_allocation_resource_tags).
        ///
        /// <p>Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.</p>
        pub fn allocation_resource_tags(
            mut self,
            input: crate::model::RequestIpamResourceTag,
        ) -> Self {
            let mut v = self.allocation_resource_tags.unwrap_or_default();
            v.push(input);
            self.allocation_resource_tags = Some(v);
            self
        }
        /// <p>Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.</p>
        pub fn set_allocation_resource_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RequestIpamResourceTag>>,
        ) -> Self {
            self.allocation_resource_tags = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.</p>
        pub fn aws_service(mut self, input: crate::model::IpamPoolAwsService) -> Self {
            self.aws_service = Some(input);
            self
        }
        /// <p>Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.</p>
        pub fn set_aws_service(
            mut self,
            input: std::option::Option<crate::model::IpamPoolAwsService>,
        ) -> Self {
            self.aws_service = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpamPoolInput`](crate::input::CreateIpamPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIpamPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIpamPoolInput {
                dry_run: self.dry_run,
                ipam_scope_id: self.ipam_scope_id,
                locale: self.locale,
                source_ipam_pool_id: self.source_ipam_pool_id,
                description: self.description,
                address_family: self.address_family,
                auto_import: self.auto_import,
                publicly_advertisable: self.publicly_advertisable,
                allocation_min_netmask_length: self.allocation_min_netmask_length,
                allocation_max_netmask_length: self.allocation_max_netmask_length,
                allocation_default_netmask_length: self.allocation_default_netmask_length,
                allocation_resource_tags: self.allocation_resource_tags,
                tag_specifications: self.tag_specifications,
                client_token: self.client_token,
                aws_service: self.aws_service,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIpamPoolInputOperationOutputAlias = crate::operation::CreateIpamPool;
#[doc(hidden)]
pub type CreateIpamPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIpamPoolInput {
    /// Consumes the builder and constructs an Operation<[`CreateIpamPool`](crate::operation::CreateIpamPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIpamPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIpamPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIpamPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_ipam_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIpamPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIpamPool",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIpamPoolInput`](crate::input::CreateIpamPoolInput)
    pub fn builder() -> crate::input::create_ipam_pool_input::Builder {
        crate::input::create_ipam_pool_input::Builder::default()
    }
}

/// See [`CreateIpamScopeInput`](crate::input::CreateIpamScopeInput)
pub mod create_ipam_scope_input {
    /// A builder for [`CreateIpamScopeInput`](crate::input::CreateIpamScopeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) ipam_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the IPAM for which you're creating this scope.</p>
        pub fn ipam_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipam_id = Some(input.into());
            self
        }
        /// <p>The ID of the IPAM for which you're creating this scope.</p>
        pub fn set_ipam_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipam_id = input;
            self
        }
        /// <p>A description for the scope you're creating.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the scope you're creating.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpamScopeInput`](crate::input::CreateIpamScopeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIpamScopeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIpamScopeInput {
                dry_run: self.dry_run,
                ipam_id: self.ipam_id,
                description: self.description,
                tag_specifications: self.tag_specifications,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIpamScopeInputOperationOutputAlias = crate::operation::CreateIpamScope;
#[doc(hidden)]
pub type CreateIpamScopeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIpamScopeInput {
    /// Consumes the builder and constructs an Operation<[`CreateIpamScope`](crate::operation::CreateIpamScope)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIpamScope,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIpamScopeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIpamScopeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_ipam_scope(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIpamScope::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIpamScope",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIpamScopeInput`](crate::input::CreateIpamScopeInput)
    pub fn builder() -> crate::input::create_ipam_scope_input::Builder {
        crate::input::create_ipam_scope_input::Builder::default()
    }
}

/// See [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
pub mod create_key_pair_input {
    /// A builder for [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) key_format: std::option::Option<crate::model::KeyFormat>,
    }
    impl Builder {
        /// <p>A unique name for the key pair.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A unique name for the key pair.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
        /// <p>Default: <code>rsa</code> </p>
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
        /// <p>Default: <code>rsa</code> </p>
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new key pair.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the new key pair.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>The format of the key pair.</p>
        /// <p>Default: <code>pem</code> </p>
        pub fn key_format(mut self, input: crate::model::KeyFormat) -> Self {
            self.key_format = Some(input);
            self
        }
        /// <p>The format of the key pair.</p>
        /// <p>Default: <code>pem</code> </p>
        pub fn set_key_format(
            mut self,
            input: std::option::Option<crate::model::KeyFormat>,
        ) -> Self {
            self.key_format = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeyPairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeyPairInput {
                key_name: self.key_name,
                dry_run: self.dry_run,
                key_type: self.key_type,
                tag_specifications: self.tag_specifications,
                key_format: self.key_format,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeyPairInputOperationOutputAlias = crate::operation::CreateKeyPair;
#[doc(hidden)]
pub type CreateKeyPairInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKeyPairInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeyPair`](crate::operation::CreateKeyPair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeyPair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateKeyPairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateKeyPairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_key_pair(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeyPair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeyPair",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    pub fn builder() -> crate::input::create_key_pair_input::Builder {
        crate::input::create_key_pair_input::Builder::default()
    }
}

/// See [`CreateLaunchTemplateInput`](crate::input::CreateLaunchTemplateInput)
pub mod create_launch_template_input {
    /// A builder for [`CreateLaunchTemplateInput`](crate::input::CreateLaunchTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_template_name: std::option::Option<std::string::String>,
        pub(crate) version_description: std::option::Option<std::string::String>,
        pub(crate) launch_template_data:
            std::option::Option<crate::model::RequestLaunchTemplateData>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A name for the launch template.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_name = Some(input.into());
            self
        }
        /// <p>A name for the launch template.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_name = input;
            self
        }
        /// <p>A description for the first version of the launch template.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description for the first version of the launch template.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn launch_template_data(
            mut self,
            input: crate::model::RequestLaunchTemplateData,
        ) -> Self {
            self.launch_template_data = Some(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn set_launch_template_data(
            mut self,
            input: std::option::Option<crate::model::RequestLaunchTemplateData>,
        ) -> Self {
            self.launch_template_data = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the launch template during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the launch template during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchTemplateInput`](crate::input::CreateLaunchTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLaunchTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLaunchTemplateInput {
                dry_run: self.dry_run,
                client_token: self.client_token,
                launch_template_name: self.launch_template_name,
                version_description: self.version_description,
                launch_template_data: self.launch_template_data,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLaunchTemplateInputOperationOutputAlias = crate::operation::CreateLaunchTemplate;
#[doc(hidden)]
pub type CreateLaunchTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLaunchTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateLaunchTemplate`](crate::operation::CreateLaunchTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLaunchTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLaunchTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLaunchTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_launch_template(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLaunchTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLaunchTemplate",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLaunchTemplateInput`](crate::input::CreateLaunchTemplateInput)
    pub fn builder() -> crate::input::create_launch_template_input::Builder {
        crate::input::create_launch_template_input::Builder::default()
    }
}

/// See [`CreateLaunchTemplateVersionInput`](crate::input::CreateLaunchTemplateVersionInput)
pub mod create_launch_template_version_input {
    /// A builder for [`CreateLaunchTemplateVersionInput`](crate::input::CreateLaunchTemplateVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_template_name: std::option::Option<std::string::String>,
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) version_description: std::option::Option<std::string::String>,
        pub(crate) launch_template_data:
            std::option::Option<crate::model::RequestLaunchTemplateData>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraint: Maximum 128 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_id = input;
            self
        }
        /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_name = Some(input.into());
            self
        }
        /// <p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_name = input;
            self
        }
        /// <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>The version number of the launch template version on which to base the new version. The new version inherits the same launch parameters as the source version, except for parameters that you specify in <code>LaunchTemplateData</code>. Snapshots applied to the block device mapping are ignored when creating a new version unless they are explicitly included.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// <p>A description for the version of the launch template.</p>
        pub fn version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_description = Some(input.into());
            self
        }
        /// <p>A description for the version of the launch template.</p>
        pub fn set_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_description = input;
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn launch_template_data(
            mut self,
            input: crate::model::RequestLaunchTemplateData,
        ) -> Self {
            self.launch_template_data = Some(input);
            self
        }
        /// <p>The information for the launch template.</p>
        pub fn set_launch_template_data(
            mut self,
            input: std::option::Option<crate::model::RequestLaunchTemplateData>,
        ) -> Self {
            self.launch_template_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchTemplateVersionInput`](crate::input::CreateLaunchTemplateVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLaunchTemplateVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLaunchTemplateVersionInput {
                dry_run: self.dry_run,
                client_token: self.client_token,
                launch_template_id: self.launch_template_id,
                launch_template_name: self.launch_template_name,
                source_version: self.source_version,
                version_description: self.version_description,
                launch_template_data: self.launch_template_data,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLaunchTemplateVersionInputOperationOutputAlias =
    crate::operation::CreateLaunchTemplateVersion;
#[doc(hidden)]
pub type CreateLaunchTemplateVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLaunchTemplateVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateLaunchTemplateVersion`](crate::operation::CreateLaunchTemplateVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLaunchTemplateVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLaunchTemplateVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLaunchTemplateVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_launch_template_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLaunchTemplateVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLaunchTemplateVersion",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLaunchTemplateVersionInput`](crate::input::CreateLaunchTemplateVersionInput)
    pub fn builder() -> crate::input::create_launch_template_version_input::Builder {
        crate::input::create_launch_template_version_input::Builder::default()
    }
}

/// See [`CreateLocalGatewayRouteInput`](crate::input::CreateLocalGatewayRouteInput)
pub mod create_local_gateway_route_input {
    /// A builder for [`CreateLocalGatewayRouteInput`](crate::input::CreateLocalGatewayRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) local_gateway_route_table_id: std::option::Option<std::string::String>,
        pub(crate) local_gateway_virtual_interface_group_id:
            std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The CIDR range used for destination matches. Routing decisions are based on the most specific match.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn local_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = input;
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn local_gateway_virtual_interface_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_virtual_interface_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual interface group.</p>
        pub fn set_local_gateway_virtual_interface_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_virtual_interface_group_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocalGatewayRouteInput`](crate::input::CreateLocalGatewayRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLocalGatewayRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLocalGatewayRouteInput {
                destination_cidr_block: self.destination_cidr_block,
                local_gateway_route_table_id: self.local_gateway_route_table_id,
                local_gateway_virtual_interface_group_id: self
                    .local_gateway_virtual_interface_group_id,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLocalGatewayRouteInputOperationOutputAlias =
    crate::operation::CreateLocalGatewayRoute;
#[doc(hidden)]
pub type CreateLocalGatewayRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLocalGatewayRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateLocalGatewayRoute`](crate::operation::CreateLocalGatewayRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLocalGatewayRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLocalGatewayRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLocalGatewayRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_local_gateway_route(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLocalGatewayRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLocalGatewayRoute",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLocalGatewayRouteInput`](crate::input::CreateLocalGatewayRouteInput)
    pub fn builder() -> crate::input::create_local_gateway_route_input::Builder {
        crate::input::create_local_gateway_route_input::Builder::default()
    }
}

/// See [`CreateLocalGatewayRouteTableVpcAssociationInput`](crate::input::CreateLocalGatewayRouteTableVpcAssociationInput)
pub mod create_local_gateway_route_table_vpc_association_input {
    /// A builder for [`CreateLocalGatewayRouteTableVpcAssociationInput`](crate::input::CreateLocalGatewayRouteTableVpcAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_gateway_route_table_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the local gateway route table.</p>
        pub fn local_gateway_route_table_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the local gateway route table.</p>
        pub fn set_local_gateway_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_route_table_id = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the local gateway route table VPC association.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the local gateway route table VPC association.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLocalGatewayRouteTableVpcAssociationInput`](crate::input::CreateLocalGatewayRouteTableVpcAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLocalGatewayRouteTableVpcAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::CreateLocalGatewayRouteTableVpcAssociationInput {
                    local_gateway_route_table_id: self.local_gateway_route_table_id,
                    vpc_id: self.vpc_id,
                    tag_specifications: self.tag_specifications,
                    dry_run: self.dry_run,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type CreateLocalGatewayRouteTableVpcAssociationInputOperationOutputAlias =
    crate::operation::CreateLocalGatewayRouteTableVpcAssociation;
#[doc(hidden)]
pub type CreateLocalGatewayRouteTableVpcAssociationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateLocalGatewayRouteTableVpcAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateLocalGatewayRouteTableVpcAssociation`](crate::operation::CreateLocalGatewayRouteTableVpcAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLocalGatewayRouteTableVpcAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLocalGatewayRouteTableVpcAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLocalGatewayRouteTableVpcAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_local_gateway_route_table_vpc_association(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLocalGatewayRouteTableVpcAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLocalGatewayRouteTableVpcAssociation",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLocalGatewayRouteTableVpcAssociationInput`](crate::input::CreateLocalGatewayRouteTableVpcAssociationInput)
    pub fn builder() -> crate::input::create_local_gateway_route_table_vpc_association_input::Builder
    {
        crate::input::create_local_gateway_route_table_vpc_association_input::Builder::default()
    }
}

/// See [`CreateManagedPrefixListInput`](crate::input::CreateManagedPrefixListInput)
pub mod create_managed_prefix_list_input {
    /// A builder for [`CreateManagedPrefixListInput`](crate::input::CreateManagedPrefixListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) prefix_list_name: std::option::Option<std::string::String>,
        pub(crate) entries: std::option::Option<std::vec::Vec<crate::model::AddPrefixListEntry>>,
        pub(crate) max_entries: std::option::Option<i32>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) address_family: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>A name for the prefix list.</p>
        /// <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
        pub fn prefix_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix_list_name = Some(input.into());
            self
        }
        /// <p>A name for the prefix list.</p>
        /// <p>Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code>.</p>
        pub fn set_prefix_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prefix_list_name = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>One or more entries for the prefix list.</p>
        pub fn entries(mut self, input: crate::model::AddPrefixListEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>One or more entries for the prefix list.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddPrefixListEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn max_entries(mut self, input: i32) -> Self {
            self.max_entries = Some(input);
            self
        }
        /// <p>The maximum number of entries for the prefix list.</p>
        pub fn set_max_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_entries = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the prefix list during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the prefix list during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>The IP address type.</p>
        /// <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
        pub fn address_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_family = Some(input.into());
            self
        }
        /// <p>The IP address type.</p>
        /// <p>Valid Values: <code>IPv4</code> | <code>IPv6</code> </p>
        pub fn set_address_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_family = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraints: Up to 255 UTF-8 characters in length.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        /// <p>Constraints: Up to 255 UTF-8 characters in length.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateManagedPrefixListInput`](crate::input::CreateManagedPrefixListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateManagedPrefixListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateManagedPrefixListInput {
                dry_run: self.dry_run,
                prefix_list_name: self.prefix_list_name,
                entries: self.entries,
                max_entries: self.max_entries,
                tag_specifications: self.tag_specifications,
                address_family: self.address_family,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateManagedPrefixListInputOperationOutputAlias =
    crate::operation::CreateManagedPrefixList;
#[doc(hidden)]
pub type CreateManagedPrefixListInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateManagedPrefixListInput {
    /// Consumes the builder and constructs an Operation<[`CreateManagedPrefixList`](crate::operation::CreateManagedPrefixList)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateManagedPrefixList,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateManagedPrefixListInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateManagedPrefixListInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_managed_prefix_list(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateManagedPrefixList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateManagedPrefixList",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateManagedPrefixListInput`](crate::input::CreateManagedPrefixListInput)
    pub fn builder() -> crate::input::create_managed_prefix_list_input::Builder {
        crate::input::create_managed_prefix_list_input::Builder::default()
    }
}

/// See [`CreateNatGatewayInput`](crate::input::CreateNatGatewayInput)
pub mod create_nat_gateway_input {
    /// A builder for [`CreateNatGatewayInput`](crate::input::CreateNatGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocation_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) connectivity_type: std::option::Option<crate::model::ConnectivityType>,
    }
    impl Builder {
        /// <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
        pub fn allocation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.allocation_id = Some(input.into());
            self
        }
        /// <p>[Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>
        pub fn set_allocation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allocation_id = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        /// <p>Constraint: Maximum 64 ASCII characters.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        /// <p>Constraint: Maximum 64 ASCII characters.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The subnet in which to create the NAT gateway.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet in which to create the NAT gateway.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the NAT gateway.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the NAT gateway.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
        pub fn connectivity_type(mut self, input: crate::model::ConnectivityType) -> Self {
            self.connectivity_type = Some(input);
            self
        }
        /// <p>Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.</p>
        pub fn set_connectivity_type(
            mut self,
            input: std::option::Option<crate::model::ConnectivityType>,
        ) -> Self {
            self.connectivity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNatGatewayInput`](crate::input::CreateNatGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNatGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNatGatewayInput {
                allocation_id: self.allocation_id,
                client_token: self.client_token,
                dry_run: self.dry_run,
                subnet_id: self.subnet_id,
                tag_specifications: self.tag_specifications,
                connectivity_type: self.connectivity_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNatGatewayInputOperationOutputAlias = crate::operation::CreateNatGateway;
#[doc(hidden)]
pub type CreateNatGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNatGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateNatGateway`](crate::operation::CreateNatGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNatGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNatGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNatGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_nat_gateway(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNatGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNatGateway",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNatGatewayInput`](crate::input::CreateNatGatewayInput)
    pub fn builder() -> crate::input::create_nat_gateway_input::Builder {
        crate::input::create_nat_gateway_input::Builder::default()
    }
}

/// See [`CreateNetworkAclInput`](crate::input::CreateNetworkAclInput)
pub mod create_network_acl_input {
    /// A builder for [`CreateNetworkAclInput`](crate::input::CreateNetworkAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the network ACL.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the network ACL.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkAclInput`](crate::input::CreateNetworkAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkAclInput {
                dry_run: self.dry_run,
                vpc_id: self.vpc_id,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkAclInputOperationOutputAlias = crate::operation::CreateNetworkAcl;
#[doc(hidden)]
pub type CreateNetworkAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkAclInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkAcl`](crate::operation::CreateNetworkAcl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkAclInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkAclInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_acl(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkAcl",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkAclInput`](crate::input::CreateNetworkAclInput)
    pub fn builder() -> crate::input::create_network_acl_input::Builder {
        crate::input::create_network_acl_input::Builder::default()
    }
}

/// See [`CreateNetworkAclEntryInput`](crate::input::CreateNetworkAclEntryInput)
pub mod create_network_acl_entry_input {
    /// A builder for [`CreateNetworkAclEntryInput`](crate::input::CreateNetworkAclEntryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_block: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) egress: std::option::Option<bool>,
        pub(crate) icmp_type_code: std::option::Option<crate::model::IcmpTypeCode>,
        pub(crate) ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) network_acl_id: std::option::Option<std::string::String>,
        pub(crate) port_range: std::option::Option<crate::model::PortRange>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) rule_action: std::option::Option<crate::model::RuleAction>,
        pub(crate) rule_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>). We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_block = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
        pub fn egress(mut self, input: bool) -> Self {
            self.egress = Some(input);
            self
        }
        /// <p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>
        pub fn set_egress(mut self, input: std::option::Option<bool>) -> Self {
            self.egress = input;
            self
        }
        /// <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
        pub fn icmp_type_code(mut self, input: crate::model::IcmpTypeCode) -> Self {
            self.icmp_type_code = Some(input);
            self
        }
        /// <p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>
        pub fn set_icmp_type_code(
            mut self,
            input: std::option::Option<crate::model::IcmpTypeCode>,
        ) -> Self {
            self.icmp_type_code = input;
            self
        }
        /// <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block = input;
            self
        }
        /// <p>The ID of the network ACL.</p>
        pub fn network_acl_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_acl_id = Some(input.into());
            self
        }
        /// <p>The ID of the network ACL.</p>
        pub fn set_network_acl_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_acl_id = input;
            self
        }
        /// <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
        pub fn port_range(mut self, input: crate::model::PortRange) -> Self {
            self.port_range = Some(input);
            self
        }
        /// <p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>
        pub fn set_port_range(
            mut self,
            input: std::option::Option<crate::model::PortRange>,
        ) -> Self {
            self.port_range = input;
            self
        }
        /// <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol number. A value of "-1" means all protocols. If you specify "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP types or codes that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
        pub fn rule_action(mut self, input: crate::model::RuleAction) -> Self {
            self.rule_action = Some(input);
            self
        }
        /// <p>Indicates whether to allow or deny the traffic that matches the rule.</p>
        pub fn set_rule_action(
            mut self,
            input: std::option::Option<crate::model::RuleAction>,
        ) -> Self {
            self.rule_action = input;
            self
        }
        /// <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p>
        /// <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
        pub fn rule_number(mut self, input: i32) -> Self {
            self.rule_number = Some(input);
            self
        }
        /// <p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p>
        /// <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>
        pub fn set_rule_number(mut self, input: std::option::Option<i32>) -> Self {
            self.rule_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkAclEntryInput`](crate::input::CreateNetworkAclEntryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkAclEntryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkAclEntryInput {
                cidr_block: self.cidr_block,
                dry_run: self.dry_run,
                egress: self.egress,
                icmp_type_code: self.icmp_type_code,
                ipv6_cidr_block: self.ipv6_cidr_block,
                network_acl_id: self.network_acl_id,
                port_range: self.port_range,
                protocol: self.protocol,
                rule_action: self.rule_action,
                rule_number: self.rule_number,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkAclEntryInputOperationOutputAlias = crate::operation::CreateNetworkAclEntry;
#[doc(hidden)]
pub type CreateNetworkAclEntryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkAclEntryInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkAclEntry`](crate::operation::CreateNetworkAclEntry)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkAclEntry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkAclEntryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkAclEntryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_acl_entry(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkAclEntry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkAclEntry",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkAclEntryInput`](crate::input::CreateNetworkAclEntryInput)
    pub fn builder() -> crate::input::create_network_acl_entry_input::Builder {
        crate::input::create_network_acl_entry_input::Builder::default()
    }
}

/// See [`CreateNetworkInsightsAccessScopeInput`](crate::input::CreateNetworkInsightsAccessScopeInput)
pub mod create_network_insights_access_scope_input {
    /// A builder for [`CreateNetworkInsightsAccessScopeInput`](crate::input::CreateNetworkInsightsAccessScopeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) match_paths:
            std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        pub(crate) exclude_paths:
            std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `match_paths`.
        ///
        /// To override the contents of this collection use [`set_match_paths`](Self::set_match_paths).
        ///
        /// <p>The paths to match.</p>
        pub fn match_paths(mut self, input: crate::model::AccessScopePathRequest) -> Self {
            let mut v = self.match_paths.unwrap_or_default();
            v.push(input);
            self.match_paths = Some(v);
            self
        }
        /// <p>The paths to match.</p>
        pub fn set_match_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        ) -> Self {
            self.match_paths = input;
            self
        }
        /// Appends an item to `exclude_paths`.
        ///
        /// To override the contents of this collection use [`set_exclude_paths`](Self::set_exclude_paths).
        ///
        /// <p>The paths to exclude.</p>
        pub fn exclude_paths(mut self, input: crate::model::AccessScopePathRequest) -> Self {
            let mut v = self.exclude_paths.unwrap_or_default();
            v.push(input);
            self.exclude_paths = Some(v);
            self
        }
        /// <p>The paths to exclude.</p>
        pub fn set_exclude_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessScopePathRequest>>,
        ) -> Self {
            self.exclude_paths = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkInsightsAccessScopeInput`](crate::input::CreateNetworkInsightsAccessScopeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkInsightsAccessScopeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkInsightsAccessScopeInput {
                match_paths: self.match_paths,
                exclude_paths: self.exclude_paths,
                client_token: self.client_token,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkInsightsAccessScopeInputOperationOutputAlias =
    crate::operation::CreateNetworkInsightsAccessScope;
#[doc(hidden)]
pub type CreateNetworkInsightsAccessScopeInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkInsightsAccessScopeInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkInsightsAccessScope`](crate::operation::CreateNetworkInsightsAccessScope)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkInsightsAccessScope,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkInsightsAccessScopeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkInsightsAccessScopeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_insights_access_scope(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkInsightsAccessScope::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkInsightsAccessScope",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkInsightsAccessScopeInput`](crate::input::CreateNetworkInsightsAccessScopeInput)
    pub fn builder() -> crate::input::create_network_insights_access_scope_input::Builder {
        crate::input::create_network_insights_access_scope_input::Builder::default()
    }
}

/// See [`CreateNetworkInsightsPathInput`](crate::input::CreateNetworkInsightsPathInput)
pub mod create_network_insights_path_input {
    /// A builder for [`CreateNetworkInsightsPathInput`](crate::input::CreateNetworkInsightsPathInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_ip: std::option::Option<std::string::String>,
        pub(crate) destination_ip: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) destination_port: std::option::Option<i32>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IP address of the Amazon Web Services resource that is the source of the path.</p>
        pub fn source_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_ip = Some(input.into());
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the source of the path.</p>
        pub fn set_source_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_ip = input;
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the destination of the path.</p>
        pub fn destination_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_ip = Some(input.into());
            self
        }
        /// <p>The IP address of the Amazon Web Services resource that is the destination of the path.</p>
        pub fn set_destination_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ip = input;
            self
        }
        /// <p>The Amazon Web Services resource that is the source of the path.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services resource that is the source of the path.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The Amazon Web Services resource that is the destination of the path.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services resource that is the destination of the path.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The protocol.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The destination port.</p>
        pub fn destination_port(mut self, input: i32) -> Self {
            self.destination_port = Some(input);
            self
        }
        /// <p>The destination port.</p>
        pub fn set_destination_port(mut self, input: std::option::Option<i32>) -> Self {
            self.destination_port = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to add to the path.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to add to the path.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkInsightsPathInput`](crate::input::CreateNetworkInsightsPathInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkInsightsPathInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkInsightsPathInput {
                source_ip: self.source_ip,
                destination_ip: self.destination_ip,
                source: self.source,
                destination: self.destination,
                protocol: self.protocol,
                destination_port: self.destination_port,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkInsightsPathInputOperationOutputAlias =
    crate::operation::CreateNetworkInsightsPath;
#[doc(hidden)]
pub type CreateNetworkInsightsPathInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkInsightsPathInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkInsightsPath`](crate::operation::CreateNetworkInsightsPath)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkInsightsPath,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkInsightsPathInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkInsightsPathInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_insights_path(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkInsightsPath::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkInsightsPath",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkInsightsPathInput`](crate::input::CreateNetworkInsightsPathInput)
    pub fn builder() -> crate::input::create_network_insights_path_input::Builder {
        crate::input::create_network_insights_path_input::Builder::default()
    }
}

/// See [`CreateNetworkInterfaceInput`](crate::input::CreateNetworkInterfaceInput)
pub mod create_network_interface_input {
    /// A builder for [`CreateNetworkInterfaceInput`](crate::input::CreateNetworkInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_address_count: std::option::Option<i32>,
        pub(crate) ipv6_addresses:
            std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
        pub(crate) secondary_private_ip_address_count: std::option::Option<i32>,
        pub(crate) ipv4_prefixes:
            std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
        pub(crate) ipv4_prefix_count: std::option::Option<i32>,
        pub(crate) ipv6_prefixes:
            std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
        pub(crate) ipv6_prefix_count: std::option::Option<i32>,
        pub(crate) interface_type: std::option::Option<crate::model::NetworkInterfaceCreationType>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description for the network interface.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the network interface.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The IDs of one or more security groups.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>The IDs of one or more security groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
        pub fn ipv6_address_count(mut self, input: i32) -> Self {
            self.ipv6_address_count = Some(input);
            self
        }
        /// <p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>
        pub fn set_ipv6_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_address_count = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn ipv6_addresses(mut self, input: crate::model::InstanceIpv6Address) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input);
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you're specifying a number of IPv6 addresses.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceIpv6Address>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The primary private IPv4 address of the network interface. If you don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR range. If you specify an IP address, you cannot indicate any IP addresses specified in <code>privateIpAddresses</code> as primary (only one IP address can be designated as primary).</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>One or more private IPv4 addresses.</p>
        pub fn private_ip_addresses(
            mut self,
            input: crate::model::PrivateIpAddressSpecification,
        ) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input);
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>One or more private IPv4 addresses.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressSpecification>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p>
        /// <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn secondary_private_ip_address_count(mut self, input: i32) -> Self {
            self.secondary_private_ip_address_count = Some(input);
            self
        }
        /// <p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p>
        /// <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn set_secondary_private_ip_address_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.secondary_private_ip_address_count = input;
            self
        }
        /// Appends an item to `ipv4_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv4_prefixes`](Self::set_ipv4_prefixes).
        ///
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn ipv4_prefixes(
            mut self,
            input: crate::model::Ipv4PrefixSpecificationRequest,
        ) -> Self {
            let mut v = self.ipv4_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv4_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv4 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv4PrefixCount</code> option.</p>
        pub fn set_ipv4_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv4PrefixSpecificationRequest>>,
        ) -> Self {
            self.ipv4_prefixes = input;
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn ipv4_prefix_count(mut self, input: i32) -> Self {
            self.ipv4_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv4 Prefixes</code> option.</p>
        pub fn set_ipv4_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv4_prefix_count = input;
            self
        }
        /// Appends an item to `ipv6_prefixes`.
        ///
        /// To override the contents of this collection use [`set_ipv6_prefixes`](Self::set_ipv6_prefixes).
        ///
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn ipv6_prefixes(
            mut self,
            input: crate::model::Ipv6PrefixSpecificationRequest,
        ) -> Self {
            let mut v = self.ipv6_prefixes.unwrap_or_default();
            v.push(input);
            self.ipv6_prefixes = Some(v);
            self
        }
        /// <p>One or more IPv6 prefixes assigned to the network interface. You cannot use this option if you use the <code>Ipv6PrefixCount</code> option.</p>
        pub fn set_ipv6_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ipv6PrefixSpecificationRequest>>,
        ) -> Self {
            self.ipv6_prefixes = input;
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn ipv6_prefix_count(mut self, input: i32) -> Self {
            self.ipv6_prefix_count = Some(input);
            self
        }
        /// <p>The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot use this option if you use the <code>Ipv6Prefixes</code> option.</p>
        pub fn set_ipv6_prefix_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ipv6_prefix_count = input;
            self
        }
        /// <p>The type of network interface. The default is <code>interface</code>.</p>
        /// <p>The only supported values are <code>efa</code> and <code>trunk</code>.</p>
        pub fn interface_type(mut self, input: crate::model::NetworkInterfaceCreationType) -> Self {
            self.interface_type = Some(input);
            self
        }
        /// <p>The type of network interface. The default is <code>interface</code>.</p>
        /// <p>The only supported values are <code>efa</code> and <code>trunk</code>.</p>
        pub fn set_interface_type(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceCreationType>,
        ) -> Self {
            self.interface_type = input;
            self
        }
        /// <p>The ID of the subnet to associate with the network interface.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet to associate with the network interface.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new network interface.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the new network interface.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkInterfaceInput`](crate::input::CreateNetworkInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkInterfaceInput {
                description: self.description,
                dry_run: self.dry_run,
                groups: self.groups,
                ipv6_address_count: self.ipv6_address_count,
                ipv6_addresses: self.ipv6_addresses,
                private_ip_address: self.private_ip_address,
                private_ip_addresses: self.private_ip_addresses,
                secondary_private_ip_address_count: self.secondary_private_ip_address_count,
                ipv4_prefixes: self.ipv4_prefixes,
                ipv4_prefix_count: self.ipv4_prefix_count,
                ipv6_prefixes: self.ipv6_prefixes,
                ipv6_prefix_count: self.ipv6_prefix_count,
                interface_type: self.interface_type,
                subnet_id: self.subnet_id,
                tag_specifications: self.tag_specifications,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkInterfaceInputOperationOutputAlias = crate::operation::CreateNetworkInterface;
#[doc(hidden)]
pub type CreateNetworkInterfaceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkInterface`](crate::operation::CreateNetworkInterface)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkInterface,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkInterfaceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkInterfaceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_interface(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkInterface",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkInterfaceInput`](crate::input::CreateNetworkInterfaceInput)
    pub fn builder() -> crate::input::create_network_interface_input::Builder {
        crate::input::create_network_interface_input::Builder::default()
    }
}

/// See [`CreateNetworkInterfacePermissionInput`](crate::input::CreateNetworkInterfacePermissionInput)
pub mod create_network_interface_permission_input {
    /// A builder for [`CreateNetworkInterfacePermissionInput`](crate::input::CreateNetworkInterfacePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) aws_service: std::option::Option<std::string::String>,
        pub(crate) permission: std::option::Option<crate::model::InterfacePermissionType>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The Amazon Web Service. Currently not supported.</p>
        pub fn aws_service(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_service = Some(input.into());
            self
        }
        /// <p>The Amazon Web Service. Currently not supported.</p>
        pub fn set_aws_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_service = input;
            self
        }
        /// <p>The type of permission to grant.</p>
        pub fn permission(mut self, input: crate::model::InterfacePermissionType) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>The type of permission to grant.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::InterfacePermissionType>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkInterfacePermissionInput`](crate::input::CreateNetworkInterfacePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkInterfacePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkInterfacePermissionInput {
                network_interface_id: self.network_interface_id,
                aws_account_id: self.aws_account_id,
                aws_service: self.aws_service,
                permission: self.permission,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkInterfacePermissionInputOperationOutputAlias =
    crate::operation::CreateNetworkInterfacePermission;
#[doc(hidden)]
pub type CreateNetworkInterfacePermissionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkInterfacePermissionInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetworkInterfacePermission`](crate::operation::CreateNetworkInterfacePermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetworkInterfacePermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkInterfacePermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkInterfacePermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network_interface_permission(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetworkInterfacePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetworkInterfacePermission",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkInterfacePermissionInput`](crate::input::CreateNetworkInterfacePermissionInput)
    pub fn builder() -> crate::input::create_network_interface_permission_input::Builder {
        crate::input::create_network_interface_permission_input::Builder::default()
    }
}

/// See [`CreatePlacementGroupInput`](crate::input::CreatePlacementGroupInput)
pub mod create_placement_group_input {
    /// A builder for [`CreatePlacementGroupInput`](crate::input::CreatePlacementGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) strategy: std::option::Option<crate::model::PlacementStrategy>,
        pub(crate) partition_count: std::option::Option<i32>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>A name for the placement group. Must be unique within the scope of your account for the Region.</p>
        /// <p>Constraints: Up to 255 ASCII characters</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The placement strategy.</p>
        pub fn strategy(mut self, input: crate::model::PlacementStrategy) -> Self {
            self.strategy = Some(input);
            self
        }
        /// <p>The placement strategy.</p>
        pub fn set_strategy(
            mut self,
            input: std::option::Option<crate::model::PlacementStrategy>,
        ) -> Self {
            self.strategy = input;
            self
        }
        /// <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
        pub fn partition_count(mut self, input: i32) -> Self {
            self.partition_count = Some(input);
            self
        }
        /// <p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>
        pub fn set_partition_count(mut self, input: std::option::Option<i32>) -> Self {
            self.partition_count = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the new placement group.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the new placement group.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlacementGroupInput`](crate::input::CreatePlacementGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlacementGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlacementGroupInput {
                dry_run: self.dry_run,
                group_name: self.group_name,
                strategy: self.strategy,
                partition_count: self.partition_count,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlacementGroupInputOperationOutputAlias = crate::operation::CreatePlacementGroup;
#[doc(hidden)]
pub type CreatePlacementGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlacementGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlacementGroup`](crate::operation::CreatePlacementGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlacementGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePlacementGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePlacementGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_placement_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlacementGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlacementGroup",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePlacementGroupInput`](crate::input::CreatePlacementGroupInput)
    pub fn builder() -> crate::input::create_placement_group_input::Builder {
        crate::input::create_placement_group_input::Builder::default()
    }
}

/// See [`CreatePublicIpv4PoolInput`](crate::input::CreatePublicIpv4PoolInput)
pub mod create_public_ipv4_pool_input {
    /// A builder for [`CreatePublicIpv4PoolInput`](crate::input::CreatePublicIpv4PoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublicIpv4PoolInput`](crate::input::CreatePublicIpv4PoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePublicIpv4PoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePublicIpv4PoolInput {
                dry_run: self.dry_run,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePublicIpv4PoolInputOperationOutputAlias = crate::operation::CreatePublicIpv4Pool;
#[doc(hidden)]
pub type CreatePublicIpv4PoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePublicIpv4PoolInput {
    /// Consumes the builder and constructs an Operation<[`CreatePublicIpv4Pool`](crate::operation::CreatePublicIpv4Pool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePublicIpv4Pool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePublicIpv4PoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePublicIpv4PoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_public_ipv4_pool(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePublicIpv4Pool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePublicIpv4Pool",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePublicIpv4PoolInput`](crate::input::CreatePublicIpv4PoolInput)
    pub fn builder() -> crate::input::create_public_ipv4_pool_input::Builder {
        crate::input::create_public_ipv4_pool_input::Builder::default()
    }
}

/// See [`CreateReplaceRootVolumeTaskInput`](crate::input::CreateReplaceRootVolumeTaskInput)
pub mod create_replace_root_volume_task_input {
    /// A builder for [`CreateReplaceRootVolumeTaskInput`](crate::input::CreateReplaceRootVolumeTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>The ID of the instance for which to replace the root volume.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance for which to replace the root volume.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot from which to restore the replacement root volume. If you want to restore the volume to the initial launch state, omit this parameter.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a client token, a randomly generated token is used for the request to ensure idempotency. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the root volume replacement task.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the root volume replacement task.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplaceRootVolumeTaskInput`](crate::input::CreateReplaceRootVolumeTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplaceRootVolumeTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplaceRootVolumeTaskInput {
                instance_id: self.instance_id,
                snapshot_id: self.snapshot_id,
                client_token: self.client_token,
                dry_run: self.dry_run,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplaceRootVolumeTaskInputOperationOutputAlias =
    crate::operation::CreateReplaceRootVolumeTask;
#[doc(hidden)]
pub type CreateReplaceRootVolumeTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateReplaceRootVolumeTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplaceRootVolumeTask`](crate::operation::CreateReplaceRootVolumeTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplaceRootVolumeTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateReplaceRootVolumeTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateReplaceRootVolumeTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_replace_root_volume_task(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplaceRootVolumeTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplaceRootVolumeTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateReplaceRootVolumeTaskInput`](crate::input::CreateReplaceRootVolumeTaskInput)
    pub fn builder() -> crate::input::create_replace_root_volume_task_input::Builder {
        crate::input::create_replace_root_volume_task_input::Builder::default()
    }
}

/// See [`CreateReservedInstancesListingInput`](crate::input::CreateReservedInstancesListingInput)
pub mod create_reserved_instances_listing_input {
    /// A builder for [`CreateReservedInstancesListingInput`](crate::input::CreateReservedInstancesListingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) price_schedules:
            std::option::Option<std::vec::Vec<crate::model::PriceScheduleSpecification>>,
        pub(crate) reserved_instances_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of your listings. This helps avoid duplicate listings. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// Appends an item to `price_schedules`.
        ///
        /// To override the contents of this collection use [`set_price_schedules`](Self::set_price_schedules).
        ///
        /// <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
        pub fn price_schedules(mut self, input: crate::model::PriceScheduleSpecification) -> Self {
            let mut v = self.price_schedules.unwrap_or_default();
            v.push(input);
            self.price_schedules = Some(v);
            self
        }
        /// <p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>
        pub fn set_price_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PriceScheduleSpecification>>,
        ) -> Self {
            self.price_schedules = input;
            self
        }
        /// <p>The ID of the active Standard Reserved Instance.</p>
        pub fn reserved_instances_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_instances_id = Some(input.into());
            self
        }
        /// <p>The ID of the active Standard Reserved Instance.</p>
        pub fn set_reserved_instances_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_instances_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReservedInstancesListingInput`](crate::input::CreateReservedInstancesListingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReservedInstancesListingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReservedInstancesListingInput {
                client_token: self.client_token,
                instance_count: self.instance_count,
                price_schedules: self.price_schedules,
                reserved_instances_id: self.reserved_instances_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReservedInstancesListingInputOperationOutputAlias =
    crate::operation::CreateReservedInstancesListing;
#[doc(hidden)]
pub type CreateReservedInstancesListingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateReservedInstancesListingInput {
    /// Consumes the builder and constructs an Operation<[`CreateReservedInstancesListing`](crate::operation::CreateReservedInstancesListing)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReservedInstancesListing,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateReservedInstancesListingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateReservedInstancesListingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_reserved_instances_listing(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReservedInstancesListing::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReservedInstancesListing",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateReservedInstancesListingInput`](crate::input::CreateReservedInstancesListingInput)
    pub fn builder() -> crate::input::create_reserved_instances_listing_input::Builder {
        crate::input::create_reserved_instances_listing_input::Builder::default()
    }
}

/// See [`CreateRestoreImageTaskInput`](crate::input::CreateRestoreImageTaskInput)
pub mod create_restore_image_task_input {
    /// A builder for [`CreateRestoreImageTaskInput`](crate::input::CreateRestoreImageTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) object_key: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains the stored AMI object.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the stored AMI object in the bucket.</p>
        pub fn object_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_key = Some(input.into());
            self
        }
        /// <p>The name of the stored AMI object in the bucket.</p>
        pub fn set_object_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_key = input;
            self
        }
        /// <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.</p>
        /// <ul>
        /// <li> <p>To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.</p> </li>
        /// <li> <p>To tag the snapshots, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all of the snapshots that are created.</p> </li>
        /// </ul>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRestoreImageTaskInput`](crate::input::CreateRestoreImageTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRestoreImageTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRestoreImageTaskInput {
                bucket: self.bucket,
                object_key: self.object_key,
                name: self.name,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRestoreImageTaskInputOperationOutputAlias = crate::operation::CreateRestoreImageTask;
#[doc(hidden)]
pub type CreateRestoreImageTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRestoreImageTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateRestoreImageTask`](crate::operation::CreateRestoreImageTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRestoreImageTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRestoreImageTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRestoreImageTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_restore_image_task(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRestoreImageTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRestoreImageTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRestoreImageTaskInput`](crate::input::CreateRestoreImageTaskInput)
    pub fn builder() -> crate::input::create_restore_image_task_input::Builder {
        crate::input::create_restore_image_task_input::Builder::default()
    }
}

/// See [`CreateRouteInput`](crate::input::CreateRouteInput)
pub mod create_route_input {
    /// A builder for [`CreateRouteInput`](crate::input::CreateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destination_ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) destination_prefix_list_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) vpc_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) egress_only_internet_gateway_id: std::option::Option<std::string::String>,
        pub(crate) gateway_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) nat_gateway_id: std::option::Option<std::string::String>,
        pub(crate) transit_gateway_id: std::option::Option<std::string::String>,
        pub(crate) local_gateway_id: std::option::Option<std::string::String>,
        pub(crate) carrier_gateway_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) route_table_id: std::option::Option<std::string::String>,
        pub(crate) vpc_peering_connection_id: std::option::Option<std::string::String>,
        pub(crate) core_network_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn destination_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv4 CIDR address block used for the destination match. Routing decisions are based on the most specific match. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        pub fn set_destination_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_cidr_block = input;
            self
        }
        /// <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
        pub fn destination_ipv6_cidr_block(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv6 CIDR block used for the destination match. Routing decisions are based on the most specific match.</p>
        pub fn set_destination_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ipv6_cidr_block = input;
            self
        }
        /// <p>The ID of a prefix list used for the destination match.</p>
        pub fn destination_prefix_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix_list_id = Some(input.into());
            self
        }
        /// <p>The ID of a prefix list used for the destination match.</p>
        pub fn set_destination_prefix_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix_list_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_id = input;
            self
        }
        /// <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
        pub fn egress_only_internet_gateway_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.egress_only_internet_gateway_id = Some(input.into());
            self
        }
        /// <p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>
        pub fn set_egress_only_internet_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.egress_only_internet_gateway_id = input;
            self
        }
        /// <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>
        pub fn set_gateway_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway_id = input;
            self
        }
        /// <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
        pub fn nat_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.nat_gateway_id = Some(input.into());
            self
        }
        /// <p>[IPv4 traffic only] The ID of a NAT gateway.</p>
        pub fn set_nat_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nat_gateway_id = input;
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn transit_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transit_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of a transit gateway.</p>
        pub fn set_transit_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transit_gateway_id = input;
            self
        }
        /// <p>The ID of the local gateway.</p>
        pub fn local_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the local gateway.</p>
        pub fn set_local_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.local_gateway_id = input;
            self
        }
        /// <p>The ID of the carrier gateway.</p>
        /// <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
        pub fn carrier_gateway_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.carrier_gateway_id = Some(input.into());
            self
        }
        /// <p>The ID of the carrier gateway.</p>
        /// <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>
        pub fn set_carrier_gateway_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.carrier_gateway_id = input;
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of a network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The ID of the route table for the route.</p>
        pub fn route_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the route table for the route.</p>
        pub fn set_route_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.route_table_id = input;
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn vpc_peering_connection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_peering_connection_id = Some(input.into());
            self
        }
        /// <p>The ID of a VPC peering connection.</p>
        pub fn set_vpc_peering_connection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_peering_connection_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the core network.</p>
        pub fn core_network_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_network_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the core network.</p>
        pub fn set_core_network_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_network_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteInput`](crate::input::CreateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteInput {
                destination_cidr_block: self.destination_cidr_block,
                destination_ipv6_cidr_block: self.destination_ipv6_cidr_block,
                destination_prefix_list_id: self.destination_prefix_list_id,
                dry_run: self.dry_run,
                vpc_endpoint_id: self.vpc_endpoint_id,
                egress_only_internet_gateway_id: self.egress_only_internet_gateway_id,
                gateway_id: self.gateway_id,
                instance_id: self.instance_id,
                nat_gateway_id: self.nat_gateway_id,
                transit_gateway_id: self.transit_gateway_id,
                local_gateway_id: self.local_gateway_id,
                carrier_gateway_id: self.carrier_gateway_id,
                network_interface_id: self.network_interface_id,
                route_table_id: self.route_table_id,
                vpc_peering_connection_id: self.vpc_peering_connection_id,
                core_network_arn: self.core_network_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteInputOperationOutputAlias = crate::operation::CreateRoute;
#[doc(hidden)]
pub type CreateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoute`](crate::operation::CreateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoute",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
}

/// See [`CreateRouteTableInput`](crate::input::CreateRouteTableInput)
pub mod create_route_table_input {
    /// A builder for [`CreateRouteTableInput`](crate::input::CreateRouteTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the route table.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the route table.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteTableInput`](crate::input::CreateRouteTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteTableInput {
                dry_run: self.dry_run,
                vpc_id: self.vpc_id,
                tag_specifications: self.tag_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteTableInputOperationOutputAlias = crate::operation::CreateRouteTable;
#[doc(hidden)]
pub type CreateRouteTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteTableInput {
    /// Consumes the builder and constructs an Operation<[`CreateRouteTable`](crate::operation::CreateRouteTable)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRouteTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteTableInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteTableInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route_table(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRouteTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRouteTable",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteTableInput`](crate::input::CreateRouteTableInput)
    pub fn builder() -> crate::input::create_route_table_input::Builder {
        crate::input::create_route_table_input::Builder::default()
    }
}

/// See [`CreateSecurityGroupInput`](crate::input::CreateSecurityGroupInput)
pub mod create_security_group_input {
    /// A builder for [`CreateSecurityGroupInput`](crate::input::CreateSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A description for the security group. This is informational only.</p>
        /// <p>Constraints: Up to 255 characters in length</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group. This is informational only.</p>
        /// <p>Constraints: Up to 255 characters in length</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the security group.</p>
        /// <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group.</p>
        /// <p>Constraints: Up to 255 characters in length. Cannot start with <code>sg-</code>.</p>
        /// <p>Constraints for EC2-Classic: ASCII characters</p>
        /// <p>Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!$*</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>[EC2-VPC] The ID of the VPC. Required for EC2-VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the security group.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the security group.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityGroupInput`](crate::input::CreateSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSecurityGroupInput {
                description: self.description,
                group_name: self.group_name,
                vpc_id: self.vpc_id,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSecurityGroupInputOperationOutputAlias = crate::operation::CreateSecurityGroup;
#[doc(hidden)]
pub type CreateSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateSecurityGroup`](crate::operation::CreateSecurityGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSecurityGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSecurityGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_security_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSecurityGroup",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSecurityGroupInput`](crate::input::CreateSecurityGroupInput)
    pub fn builder() -> crate::input::create_security_group_input::Builder {
        crate::input::create_security_group_input::Builder::default()
    }
}

/// See [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
pub mod create_snapshot_input {
    /// A builder for [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) volume_id: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A description for the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
        /// <ul>
        /// <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.</p>
        /// <ul>
        /// <li> <p>To create a snapshot of a volume in a Region, omit this parameter. The snapshot is created in the same Region as the volume.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create a snapshot of a volume on an Outpost and store the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must be created on the same Outpost as the volume.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot">Create local snapshots from volumes on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn volume_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon EBS volume.</p>
        pub fn set_volume_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_id = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to apply to the snapshot during creation.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to apply to the snapshot during creation.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotInput {
                description: self.description,
                outpost_arn: self.outpost_arn,
                volume_id: self.volume_id,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotInputOperationOutputAlias = crate::operation::CreateSnapshot;
#[doc(hidden)]
pub type CreateSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshot`](crate::operation::CreateSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshot",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
}

/// See [`CreateSnapshotsInput`](crate::input::CreateSnapshotsInput)
pub mod create_snapshots_input {
    /// A builder for [`CreateSnapshotsInput`](crate::input::CreateSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_specification: std::option::Option<crate::model::InstanceSpecification>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) copy_tags_from_source: std::option::Option<crate::model::CopyTagsFromSource>,
    }
    impl Builder {
        /// <p> A description propagated to every snapshot specified by the instance.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> A description propagated to every snapshot specified by the instance.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The instance to specify which volumes should be included in the snapshots.</p>
        pub fn instance_specification(
            mut self,
            input: crate::model::InstanceSpecification,
        ) -> Self {
            self.instance_specification = Some(input);
            self
        }
        /// <p>The instance to specify which volumes should be included in the snapshots.</p>
        pub fn set_instance_specification(
            mut self,
            input: std::option::Option<crate::model::InstanceSpecification>,
        ) -> Self {
            self.instance_specification = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.</p>
        /// <ul>
        /// <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Create multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost on which to create the local snapshots.</p>
        /// <ul>
        /// <li> <p>To create snapshots from an instance in a Region, omit this parameter. The snapshots are created in the same Region as the instance.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots in the Region, omit this parameter. The snapshots are created in the Region for the Outpost.</p> </li>
        /// <li> <p>To create snapshots from an instance on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination Outpost. The snapshots must be created on the same Outpost as the instance.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot"> Create multi-volume local snapshots from instances on an Outpost</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>Tags to apply to every snapshot specified by the instance.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>Tags to apply to every snapshot specified by the instance.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Copies the tags from the specified volume to corresponding snapshot.</p>
        pub fn copy_tags_from_source(mut self, input: crate::model::CopyTagsFromSource) -> Self {
            self.copy_tags_from_source = Some(input);
            self
        }
        /// <p>Copies the tags from the specified volume to corresponding snapshot.</p>
        pub fn set_copy_tags_from_source(
            mut self,
            input: std::option::Option<crate::model::CopyTagsFromSource>,
        ) -> Self {
            self.copy_tags_from_source = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotsInput`](crate::input::CreateSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotsInput {
                description: self.description,
                instance_specification: self.instance_specification,
                outpost_arn: self.outpost_arn,
                tag_specifications: self.tag_specifications,
                dry_run: self.dry_run,
                copy_tags_from_source: self.copy_tags_from_source,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotsInputOperationOutputAlias = crate::operation::CreateSnapshots;
#[doc(hidden)]
pub type CreateSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshots`](crate::operation::CreateSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_snapshots(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshots",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotsInput`](crate::input::CreateSnapshotsInput)
    pub fn builder() -> crate::input::create_snapshots_input::Builder {
        crate::input::create_snapshots_input::Builder::default()
    }
}

/// See [`CreateSpotDatafeedSubscriptionInput`](crate::input::CreateSpotDatafeedSubscriptionInput)
pub mod create_spot_datafeed_subscription_input {
    /// A builder for [`CreateSpotDatafeedSubscriptionInput`](crate::input::CreateSpotDatafeedSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules">Rules for bucket naming</a> in the <i>Amazon S3 Developer Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>The prefix for the data feed file names.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the data feed file names.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSpotDatafeedSubscriptionInput`](crate::input::CreateSpotDatafeedSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSpotDatafeedSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSpotDatafeedSubscriptionInput {
                bucket: self.bucket,
                dry_run: self.dry_run,
                prefix: self.prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSpotDatafeedSubscriptionInputOperationOutputAlias =
    crate::operation::CreateSpotDatafeedSubscription;
#[doc(hidden)]
pub type CreateSpotDatafeedSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateSpotDatafeedSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSpotDatafeedSubscription`](crate::operation::CreateSpotDatafeedSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSpotDatafeedSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSpotDatafeedSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSpotDatafeedSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_spot_datafeed_subscription(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSpotDatafeedSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSpotDatafeedSubscription",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSpotDatafeedSubscriptionInput`](crate::input::CreateSpotDatafeedSubscriptionInput)
    pub fn builder() -> crate::input::create_spot_datafeed_subscription_input::Builder {
        crate::input::create_spot_datafeed_subscription_input::Builder::default()
    }
}

/// See [`CreateStoreImageTaskInput`](crate::input::CreateStoreImageTaskInput)
pub mod create_store_image_task_input {
    /// A builder for [`CreateStoreImageTaskInput`](crate::input::CreateStoreImageTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) s3_object_tags: std::option::Option<std::vec::Vec<crate::model::S3ObjectTag>>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the AMI.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the AMI.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket in which the AMI object will be stored. The bucket must be in the Region in which the request is being made. The AMI object appears in the bucket only after the upload task has completed. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Appends an item to `s3_object_tags`.
        ///
        /// To override the contents of this collection use [`set_s3_object_tags`](Self::set_s3_object_tags).
        ///
        /// <p>The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. </p>
        pub fn s3_object_tags(mut self, input: crate::model::S3ObjectTag) -> Self {
            let mut v = self.s3_object_tags.unwrap_or_default();
            v.push(input);
            self.s3_object_tags = Some(v);
            self
        }
        /// <p>The tags to apply to the AMI object that will be stored in the Amazon S3 bucket. </p>
        pub fn set_s3_object_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3ObjectTag>>,
        ) -> Self {
            self.s3_object_tags = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStoreImageTaskInput`](crate::input::CreateStoreImageTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStoreImageTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStoreImageTaskInput {
                image_id: self.image_id,
                bucket: self.bucket,
                s3_object_tags: self.s3_object_tags,
                dry_run: self.dry_run,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStoreImageTaskInputOperationOutputAlias = crate::operation::CreateStoreImageTask;
#[doc(hidden)]
pub type CreateStoreImageTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStoreImageTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateStoreImageTask`](crate::operation::CreateStoreImageTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStoreImageTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStoreImageTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStoreImageTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_store_image_task(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStoreImageTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStoreImageTask",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStoreImageTaskInput`](crate::input::CreateStoreImageTaskInput)
    pub fn builder() -> crate::input::create_store_image_task_input::Builder {
        crate::input::create_store_image_task_input::Builder::default()
    }
}

/// See [`CreateSubnetInput`](crate::input::CreateSubnetInput)
pub mod create_subnet_input {
    /// A builder for [`CreateSubnetInput`](crate::input::CreateSubnetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) cidr_block: std::option::Option<std::string::String>,
        pub(crate) ipv6_cidr_block: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) ipv6_native: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `tag_specifications`.
        ///
        /// To override the contents of this collection use [`set_tag_specifications`](Self::set_tag_specifications).
        ///
        /// <p>The tags to assign to the subnet.</p>
        pub fn tag_specifications(mut self, input: crate::model::TagSpecification) -> Self {
            let mut v = self.tag_specifications.unwrap_or_default();
            v.push(input);
            self.tag_specifications = Some(v);
            self
        }
        /// <p>The tags to assign to the subnet.</p>
        pub fn set_tag_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
        ) -> Self {
            self.tag_specifications = input;
            self
        }
        /// <p>The Availability Zone or Local Zone for the subnet.</p>
        /// <p>Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p>
        /// <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        /// <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone or Local Zone for the subnet.</p>
        /// <p>Default: Amazon Web Services selects one for you. If you create more than one subnet in your VPC, we do not necessarily select a different zone for each subnet.</p>
        /// <p>To create a subnet in a Local Zone, set this value to the Local Zone ID, for example <code>us-west-2-lax-1a</code>. For information about the Regions that support Local Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions">Available Regions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        /// <p>To create a subnet in an Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost ARN.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The AZ ID or the Local Zone ID of the subnet.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The AZ ID or the Local Zone ID of the subnet.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        /// <p>This parameter is not supported for an IPv6 only subnet.</p>
        pub fn cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
        /// <p>This parameter is not supported for an IPv6 only subnet.</p>
        pub fn set_cidr_block(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr_block = input;
            self
        }
        /// <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>
        /// <p>This parameter is required for an IPv6 only subnet.</p>
        pub fn ipv6_cidr_block(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_cidr_block = Some(input.into());
            self
        }
        /// <p>The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.</p>
        /// <p>This parameter is required for an IPv6 only subnet.</p>
        pub fn set_ipv6_cidr_block(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ipv6_cidr_block = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost ARN, you must also specify the Availability Zone of the Outpost subnet.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet.</p>
        pub fn ipv6_native(mut self, input: bool) -> Self {
            self.ipv6_native = Some(input);
            self
        }
        /// <p>Indicates whether to create an IPv6 only subnet.</p>
        pub fn set_ipv6_native(mut self, input: std::option::Option<bool>) -> Self {
            self.ipv6_native = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubnetInput`](crate::input::CreateSubnetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubnetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubnetInput {
                tag_specifications: self.tag_specifications,
                availability_zone: self.availability_zone,
                availability_zone_id: self.availability_zone_id,
                cidr_block: self.cidr_block,
                ipv6_cidr_block: self.ipv6_cidr_block,
                outpost_arn: self.outpost_arn,
                vpc_id: self.vpc_id,
                dry_run: self.dry_run,
                ipv6_native: self.ipv6_native,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubnetInputOperationOutputAlias = crate::operation::CreateSubnet;
#[doc(hidden)]
pub type CreateSubnetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSubnetInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubnet`](crate::operation::CreateSubnet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubnet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSubnetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSubnetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_subnet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubnet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubnet",
            "ec2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSubnetInput`](crate::input::CreateSubnetInput)
    pub fn builder() -> crate::input::create_subnet_input::Builder {
        crate::input::create_subnet_input::Builder::default()
    }
}

/// See [`CreateSubnetCidrReservationInput`](crate::input::CreateSubnetCidrReservationInput)
pub mod create_subnet_cidr_reservation_input {
    /// A builder for [`CreateSubnetCidrReservationInput`](crate::input::CreateSubnetCidrReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) reservation_type: std::option::Option<crate::model::SubnetCidrReservationType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) tag_specifications:
            std::option::Option<std::vec::Vec<crate::model::TagSpecification>>,
    }
    impl Builder {
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The IPv4 or IPV6 CIDR range to reserve.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The IPv4 or IPV6 CIDR range to reserve.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The type of reservation.</p>
        /// <p>The following are valid values:</p>
        /// <ul>
        /// <li> <p> <code>prefix</code>: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation for Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li>
        /// <li> <p> <code>explicit</code>: You manually assign the IP addresses to resources that reside in your subnet. </p> </li>
        /// </ul>
        pub fn reservation_type(mut self, input: crate::model::SubnetCidrReservationType) -> Self {
            self.reservation_type = Some(input);
            self
        }
        /// <p>The type of reservation.</p>
        /// <p>The following are valid values:</p>
        /// <ul>
        /// <li> <p> <code>prefix</code>: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-delegation.html">Prefix Delegation for Amazon EC2 network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li>
        /// <li> <p> <code>explicit</code>: You manually assign the IP addresses to resources that reside in your subnet. </p> </li>
        /// </ul>
        pub fn set_reservation_type(
            mut self,
            input: std::option::Option<crate::model::SubnetCidrReservationType>,
        ) -> Self {
            self.reservation_type = input;
            self
        }
        /// <p>The description to assign to the subnet CIDR reservation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to assign to the subnet CIDR reservation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</cod