// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CompleteSnapshotInput`](crate::input::CompleteSnapshotInput)
pub mod complete_snapshot_input {
    /// A builder for [`CompleteSnapshotInput`](crate::input::CompleteSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) changed_blocks_count: std::option::Option<i32>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) checksum_algorithm: std::option::Option<crate::model::ChecksumAlgorithm>,
        pub(crate) checksum_aggregation_method:
            std::option::Option<crate::model::ChecksumAggregationMethod>,
    }
    impl Builder {
        /// <p>The ID of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The number of blocks that were written to the snapshot.</p>
        pub fn changed_blocks_count(mut self, input: i32) -> Self {
            self.changed_blocks_count = Some(input);
            self
        }
        /// <p>The number of blocks that were written to the snapshot.</p>
        pub fn set_changed_blocks_count(mut self, input: std::option::Option<i32>) -> Self {
            self.changed_blocks_count = input;
            self
        }
        /// <p>An aggregated Base-64 SHA256 checksum based on the checksums of each written block.</p>
        /// <p>To generate the aggregated checksum using the linear aggregation method, arrange the checksums for each written block in ascending order of their block index, concatenate them to form a single string, and then generate the checksum on the entire string using the SHA256 algorithm.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>An aggregated Base-64 SHA256 checksum based on the checksums of each written block.</p>
        /// <p>To generate the aggregated checksum using the linear aggregation method, arrange the checksums for each written block in ascending order of their block index, concatenate them to form a single string, and then generate the checksum on the entire string using the SHA256 algorithm.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
        pub fn checksum_algorithm(mut self, input: crate::model::ChecksumAlgorithm) -> Self {
            self.checksum_algorithm = Some(input);
            self
        }
        /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
        pub fn set_checksum_algorithm(
            mut self,
            input: std::option::Option<crate::model::ChecksumAlgorithm>,
        ) -> Self {
            self.checksum_algorithm = input;
            self
        }
        /// <p>The aggregation method used to generate the checksum. Currently, the only supported aggregation method is <code>LINEAR</code>.</p>
        pub fn checksum_aggregation_method(
            mut self,
            input: crate::model::ChecksumAggregationMethod,
        ) -> Self {
            self.checksum_aggregation_method = Some(input);
            self
        }
        /// <p>The aggregation method used to generate the checksum. Currently, the only supported aggregation method is <code>LINEAR</code>.</p>
        pub fn set_checksum_aggregation_method(
            mut self,
            input: std::option::Option<crate::model::ChecksumAggregationMethod>,
        ) -> Self {
            self.checksum_aggregation_method = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteSnapshotInput`](crate::input::CompleteSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteSnapshotInput {
                snapshot_id: self.snapshot_id,
                changed_blocks_count: self.changed_blocks_count,
                checksum: self.checksum,
                checksum_algorithm: self.checksum_algorithm,
                checksum_aggregation_method: self.checksum_aggregation_method,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteSnapshotInputOperationOutputAlias = crate::operation::CompleteSnapshot;
#[doc(hidden)]
pub type CompleteSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CompleteSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CompleteSnapshot`](crate::operation::CompleteSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.snapshot_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    })?;
            let snapshot_id = aws_smithy_http::label::fmt_string(input_1, false);
            if snapshot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "snapshot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/snapshots/completion/{SnapshotId}",
                SnapshotId = snapshot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_complete_snapshot(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteSnapshot",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteSnapshotInput`](crate::input::CompleteSnapshotInput)
    pub fn builder() -> crate::input::complete_snapshot_input::Builder {
        crate::input::complete_snapshot_input::Builder::default()
    }
}

/// See [`GetSnapshotBlockInput`](crate::input::GetSnapshotBlockInput)
pub mod get_snapshot_block_input {
    /// A builder for [`GetSnapshotBlockInput`](crate::input::GetSnapshotBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) block_index: std::option::Option<i32>,
        pub(crate) block_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the snapshot containing the block from which to get data.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot containing the block from which to get data.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The block index of the block from which to get data.</p>
        /// <p>Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
        pub fn block_index(mut self, input: i32) -> Self {
            self.block_index = Some(input);
            self
        }
        /// <p>The block index of the block from which to get data.</p>
        /// <p>Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
        pub fn set_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.block_index = input;
            self
        }
        /// <p>The block token of the block from which to get data.</p>
        /// <p>Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
        pub fn block_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.block_token = Some(input.into());
            self
        }
        /// <p>The block token of the block from which to get data.</p>
        /// <p>Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
        pub fn set_block_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.block_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSnapshotBlockInput`](crate::input::GetSnapshotBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSnapshotBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSnapshotBlockInput {
                snapshot_id: self.snapshot_id,
                block_index: self.block_index,
                block_token: self.block_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSnapshotBlockInputOperationOutputAlias = crate::operation::GetSnapshotBlock;
#[doc(hidden)]
pub type GetSnapshotBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSnapshotBlockInput {
    /// Consumes the builder and constructs an Operation<[`GetSnapshotBlock`](crate::operation::GetSnapshotBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSnapshotBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSnapshotBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.snapshot_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    })?;
            let snapshot_id = aws_smithy_http::label::fmt_string(input_2, false);
            if snapshot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "snapshot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.block_index;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "block_index",
                        details: "cannot be empty or unset",
                    })?;
            let mut block_index_encoder = aws_smithy_types::primitive::Encoder::from(*input_3);
            let block_index = block_index_encoder.encode();
            if block_index.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "block_index",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/snapshots/{SnapshotId}/blocks/{BlockIndex}",
                SnapshotId = snapshot_id,
                BlockIndex = block_index
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetSnapshotBlockInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_4) = &_input.block_token {
                query.push_kv("blockToken", &aws_smithy_http::query::fmt_string(&inner_4));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSnapshotBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSnapshotBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSnapshotBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSnapshotBlock",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSnapshotBlockInput`](crate::input::GetSnapshotBlockInput)
    pub fn builder() -> crate::input::get_snapshot_block_input::Builder {
        crate::input::get_snapshot_block_input::Builder::default()
    }
}

/// See [`ListChangedBlocksInput`](crate::input::ListChangedBlocksInput)
pub mod list_changed_blocks_input {
    /// A builder for [`ListChangedBlocksInput`](crate::input::ListChangedBlocksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) first_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) second_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) starting_block_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the first snapshot to use for the comparison.</p> <important>
        /// <p>The <code>FirstSnapshotID</code> parameter must be specified with a <code>SecondSnapshotId</code> parameter; otherwise, an error occurs.</p>
        /// </important>
        pub fn first_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the first snapshot to use for the comparison.</p> <important>
        /// <p>The <code>FirstSnapshotID</code> parameter must be specified with a <code>SecondSnapshotId</code> parameter; otherwise, an error occurs.</p>
        /// </important>
        pub fn set_first_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_snapshot_id = input;
            self
        }
        /// <p>The ID of the second snapshot to use for the comparison.</p> <important>
        /// <p>The <code>SecondSnapshotId</code> parameter must be specified with a <code>FirstSnapshotID</code> parameter; otherwise, an error occurs.</p>
        /// </important>
        pub fn second_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.second_snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the second snapshot to use for the comparison.</p> <important>
        /// <p>The <code>SecondSnapshotId</code> parameter must be specified with a <code>FirstSnapshotID</code> parameter; otherwise, an error occurs.</p>
        /// </important>
        pub fn set_second_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.second_snapshot_id = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of blocks to be returned by the request.</p>
        /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
        /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of blocks to be returned by the request.</p>
        /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
        /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The block index from which the comparison should start.</p>
        /// <p>The list in the response will start from this block index or the next valid block index in the snapshots.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn starting_block_index(mut self, input: i32) -> Self {
            self.starting_block_index = Some(input);
            self
        }
        /// <p>The block index from which the comparison should start.</p>
        /// <p>The list in the response will start from this block index or the next valid block index in the snapshots.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn set_starting_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.starting_block_index = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChangedBlocksInput`](crate::input::ListChangedBlocksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChangedBlocksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChangedBlocksInput {
                first_snapshot_id: self.first_snapshot_id,
                second_snapshot_id: self.second_snapshot_id,
                next_token: self.next_token,
                max_results: self.max_results,
                starting_block_index: self.starting_block_index,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChangedBlocksInputOperationOutputAlias = crate::operation::ListChangedBlocks;
#[doc(hidden)]
pub type ListChangedBlocksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListChangedBlocksInput {
    /// Consumes the builder and constructs an Operation<[`ListChangedBlocks`](crate::operation::ListChangedBlocks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChangedBlocks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChangedBlocksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.second_snapshot_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "second_snapshot_id",
                        details: "cannot be empty or unset",
                    })?;
            let second_snapshot_id = aws_smithy_http::label::fmt_string(input_5, false);
            if second_snapshot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "second_snapshot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/snapshots/{SecondSnapshotId}/changedblocks",
                SecondSnapshotId = second_snapshot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListChangedBlocksInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_6) = &_input.first_snapshot_id {
                query.push_kv(
                    "firstSnapshotId",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("pageToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            if let Some(inner_8) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_8).encode(),
                );
            }
            if let Some(inner_9) = &_input.starting_block_index {
                query.push_kv(
                    "startingBlockIndex",
                    aws_smithy_types::primitive::Encoder::from(*inner_9).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChangedBlocksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChangedBlocksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChangedBlocks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChangedBlocks",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChangedBlocksInput`](crate::input::ListChangedBlocksInput)
    pub fn builder() -> crate::input::list_changed_blocks_input::Builder {
        crate::input::list_changed_blocks_input::Builder::default()
    }
}

/// See [`ListSnapshotBlocksInput`](crate::input::ListSnapshotBlocksInput)
pub mod list_snapshot_blocks_input {
    /// A builder for [`ListSnapshotBlocksInput`](crate::input::ListSnapshotBlocksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) starting_block_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the snapshot from which to get block indexes and block tokens.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot from which to get block indexes and block tokens.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The token to request the next page of results.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to request the next page of results.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of blocks to be returned by the request.</p>
        /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
        /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of blocks to be returned by the request.</p>
        /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
        /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The block index from which the list should start. The list in the response will start from this block index or the next valid block index in the snapshot.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn starting_block_index(mut self, input: i32) -> Self {
            self.starting_block_index = Some(input);
            self
        }
        /// <p>The block index from which the list should start. The list in the response will start from this block index or the next valid block index in the snapshot.</p>
        /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
        pub fn set_starting_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.starting_block_index = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSnapshotBlocksInput`](crate::input::ListSnapshotBlocksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSnapshotBlocksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSnapshotBlocksInput {
                snapshot_id: self.snapshot_id,
                next_token: self.next_token,
                max_results: self.max_results,
                starting_block_index: self.starting_block_index,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSnapshotBlocksInputOperationOutputAlias = crate::operation::ListSnapshotBlocks;
#[doc(hidden)]
pub type ListSnapshotBlocksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSnapshotBlocksInput {
    /// Consumes the builder and constructs an Operation<[`ListSnapshotBlocks`](crate::operation::ListSnapshotBlocks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSnapshotBlocks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSnapshotBlocksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.snapshot_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    })?;
            let snapshot_id = aws_smithy_http::label::fmt_string(input_10, false);
            if snapshot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "snapshot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/snapshots/{SnapshotId}/blocks",
                SnapshotId = snapshot_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSnapshotBlocksInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("pageToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if let Some(inner_12) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_12).encode(),
                );
            }
            if let Some(inner_13) = &_input.starting_block_index {
                query.push_kv(
                    "startingBlockIndex",
                    aws_smithy_types::primitive::Encoder::from(*inner_13).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSnapshotBlocksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSnapshotBlocksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSnapshotBlocks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSnapshotBlocks",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSnapshotBlocksInput`](crate::input::ListSnapshotBlocksInput)
    pub fn builder() -> crate::input::list_snapshot_blocks_input::Builder {
        crate::input::list_snapshot_blocks_input::Builder::default()
    }
}

/// See [`PutSnapshotBlockInput`](crate::input::PutSnapshotBlockInput)
pub mod put_snapshot_block_input {
    /// A builder for [`PutSnapshotBlockInput`](crate::input::PutSnapshotBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) block_index: std::option::Option<i32>,
        pub(crate) block_data: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) data_length: std::option::Option<i32>,
        pub(crate) progress: std::option::Option<i32>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) checksum_algorithm: std::option::Option<crate::model::ChecksumAlgorithm>,
    }
    impl Builder {
        /// <p>The ID of the snapshot.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the snapshot.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The block index of the block in which to write the data. A block index is a logical index in units of <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data must be <code>512</code> KiB aligned.</p>
        pub fn block_index(mut self, input: i32) -> Self {
            self.block_index = Some(input);
            self
        }
        /// <p>The block index of the block in which to write the data. A block index is a logical index in units of <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data must be <code>512</code> KiB aligned.</p>
        pub fn set_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.block_index = input;
            self
        }
        /// <p>The data to write to the block.</p>
        /// <p>The block data is not signed as part of the Signature Version 4 signing process. As a result, you must generate and provide a Base64-encoded SHA256 checksum for the block data using the <b>x-amz-Checksum</b> header. Also, you must specify the checksum algorithm using the <b>x-amz-Checksum-Algorithm</b> header. The checksum that you provide is part of the Signature Version 4 signing process. It is validated against a checksum generated by Amazon EBS to ensure the validity and authenticity of the data. If the checksums do not correspond, the request fails. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums"> Using checksums with the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn block_data(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.block_data = Some(input);
            self
        }
        /// <p>The data to write to the block.</p>
        /// <p>The block data is not signed as part of the Signature Version 4 signing process. As a result, you must generate and provide a Base64-encoded SHA256 checksum for the block data using the <b>x-amz-Checksum</b> header. Also, you must specify the checksum algorithm using the <b>x-amz-Checksum-Algorithm</b> header. The checksum that you provide is part of the Signature Version 4 signing process. It is validated against a checksum generated by Amazon EBS to ensure the validity and authenticity of the data. If the checksums do not correspond, the request fails. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums"> Using checksums with the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_block_data(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.block_data = input;
            self
        }
        /// <p>The size of the data to write to the block, in bytes. Currently, the only supported size is <code>524288</code> bytes.</p>
        /// <p>Valid values: <code>524288</code> </p>
        pub fn data_length(mut self, input: i32) -> Self {
            self.data_length = Some(input);
            self
        }
        /// <p>The size of the data to write to the block, in bytes. Currently, the only supported size is <code>524288</code> bytes.</p>
        /// <p>Valid values: <code>524288</code> </p>
        pub fn set_data_length(mut self, input: std::option::Option<i32>) -> Self {
            self.data_length = input;
            self
        }
        /// <p>The progress of the write process, as a percentage.</p>
        pub fn progress(mut self, input: i32) -> Self {
            self.progress = Some(input);
            self
        }
        /// <p>The progress of the write process, as a percentage.</p>
        pub fn set_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.progress = input;
            self
        }
        /// <p>A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
        pub fn checksum_algorithm(mut self, input: crate::model::ChecksumAlgorithm) -> Self {
            self.checksum_algorithm = Some(input);
            self
        }
        /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
        pub fn set_checksum_algorithm(
            mut self,
            input: std::option::Option<crate::model::ChecksumAlgorithm>,
        ) -> Self {
            self.checksum_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSnapshotBlockInput`](crate::input::PutSnapshotBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSnapshotBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSnapshotBlockInput {
                snapshot_id: self.snapshot_id,
                block_index: self.block_index,
                block_data: self.block_data.unwrap_or_default(),
                data_length: self.data_length,
                progress: self.progress,
                checksum: self.checksum,
                checksum_algorithm: self.checksum_algorithm,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSnapshotBlockInputOperationOutputAlias = crate::operation::PutSnapshotBlock;
#[doc(hidden)]
pub type PutSnapshotBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutSnapshotBlockInput {
    /// Consumes the builder and constructs an Operation<[`PutSnapshotBlock`](crate::operation::PutSnapshotBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSnapshotBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSnapshotBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.snapshot_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "snapshot_id",
                        details: "cannot be empty or unset",
                    })?;
            let snapshot_id = aws_smithy_http::label::fmt_string(input_14, false);
            if snapshot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "snapshot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.block_index;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "block_index",
                        details: "cannot be empty or unset",
                    })?;
            let mut block_index_encoder = aws_smithy_types::primitive::Encoder::from(*input_15);
            let block_index = block_index_encoder.encode();
            if block_index.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "block_index",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/snapshots/{SnapshotId}/blocks/{BlockIndex}",
                SnapshotId = snapshot_id,
                BlockIndex = block_index
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSnapshotBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_snapshot_block(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSnapshotBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_snapshot_block_input(self.block_data)?
                .into_inner(),
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::UnsignedPayload);
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSnapshotBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSnapshotBlock",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSnapshotBlockInput`](crate::input::PutSnapshotBlockInput)
    pub fn builder() -> crate::input::put_snapshot_block_input::Builder {
        crate::input::put_snapshot_block_input::Builder::default()
    }
}

/// See [`StartSnapshotInput`](crate::input::StartSnapshotInput)
pub mod start_snapshot_input {
    /// A builder for [`StartSnapshotInput`](crate::input::StartSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) volume_size: std::option::Option<i64>,
        pub(crate) parent_snapshot_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).</p>
        pub fn volume_size(mut self, input: i64) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i64>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an on-premises volume, omit this parameter.</p>
        /// <p>If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent snapshot. You must first create an encrypted copy of the parent snapshot using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.</p>
        pub fn parent_snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_snapshot_id = Some(input.into());
            self
        }
        /// <p>The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an on-premises volume, omit this parameter.</p>
        /// <p>If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent snapshot. You must first create an encrypted copy of the parent snapshot using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.</p>
        pub fn set_parent_snapshot_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_snapshot_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the snapshot.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to apply to the snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A description for the snapshot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the snapshot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully. The subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully. The subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
        /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create an unencrypted snapshot, omit this parameter.</p>
        /// <p>If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.</p>
        /// <p>If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is used. To set a default KMS key for your account, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html"> ModifyEbsDefaultKmsKeyId</a>.</p>
        /// <p>If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In this case, you can omit this parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"> Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create an unencrypted snapshot, omit this parameter.</p>
        /// <p>If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.</p>
        /// <p>If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is used. To set a default KMS key for your account, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html"> ModifyEbsDefaultKmsKeyId</a>.</p>
        /// <p>If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In this case, you can omit this parameter.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"> Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
        /// <p>If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS key that was used to encrypt the parent snapshot.</p>
        /// <p>If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN. </p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
        /// <p>If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS key that was used to encrypt the parent snapshot.</p>
        /// <p>If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN. </p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
        /// <ul>
        /// <li> <p>No blocks are written to the snapshot.</p> </li>
        /// <li> <p>The snapshot is not completed after writing the last block of data.</p> </li>
        /// </ul>
        /// <p>If no value is specified, the timeout defaults to <code>60</code> minutes.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
        /// <ul>
        /// <li> <p>No blocks are written to the snapshot.</p> </li>
        /// <li> <p>The snapshot is not completed after writing the last block of data.</p> </li>
        /// </ul>
        /// <p>If no value is specified, the timeout defaults to <code>60</code> minutes.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSnapshotInput`](crate::input::StartSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSnapshotInput {
                volume_size: self.volume_size,
                parent_snapshot_id: self.parent_snapshot_id,
                tags: self.tags,
                description: self.description,
                client_token: self.client_token,
                encrypted: self.encrypted,
                kms_key_arn: self.kms_key_arn,
                timeout: self.timeout,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSnapshotInputOperationOutputAlias = crate::operation::StartSnapshot;
#[doc(hidden)]
pub type StartSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`StartSnapshot`](crate::operation::StartSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/snapshots").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_snapshot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSnapshot",
            "ebs",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartSnapshotInput`](crate::input::StartSnapshotInput)
    pub fn builder() -> crate::input::start_snapshot_input::Builder {
        crate::input::start_snapshot_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSnapshotInput {
    /// <p>The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).</p>
    pub volume_size: std::option::Option<i64>,
    /// <p>The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an on-premises volume, omit this parameter.</p>
    /// <p>If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent snapshot. You must first create an encrypted copy of the parent snapshot using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.</p>
    pub parent_snapshot_id: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the snapshot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A description for the snapshot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully. The subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create an unencrypted snapshot, omit this parameter.</p>
    /// <p>If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.</p>
    /// <p>If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is used. To set a default KMS key for your account, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html"> ModifyEbsDefaultKmsKeyId</a>.</p>
    /// <p>If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In this case, you can omit this parameter.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"> Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
    /// <p>If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS key that was used to encrypt the parent snapshot.</p>
    /// <p>If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN. </p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
    /// <ul>
    /// <li> <p>No blocks are written to the snapshot.</p> </li>
    /// <li> <p>The snapshot is not completed after writing the last block of data.</p> </li>
    /// </ul>
    /// <p>If no value is specified, the timeout defaults to <code>60</code> minutes.</p>
    pub timeout: std::option::Option<i32>,
}
impl StartSnapshotInput {
    /// <p>The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).</p>
    pub fn volume_size(&self) -> std::option::Option<i64> {
        self.volume_size
    }
    /// <p>The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an on-premises volume, omit this parameter.</p>
    /// <p>If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent snapshot. You must first create an encrypted copy of the parent snapshot using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.</p>
    pub fn parent_snapshot_id(&self) -> std::option::Option<&str> {
        self.parent_snapshot_id.as_deref()
    }
    /// <p>The tags to apply to the snapshot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A description for the snapshot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully. The subsequent retries with the same client token return the result from the original successful request and they have no additional effect.</p>
    /// <p>If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create an unencrypted snapshot, omit this parameter.</p>
    /// <p>If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.</p>
    /// <p>If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is used. To set a default KMS key for your account, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html"> ModifyEbsDefaultKmsKeyId</a>.</p>
    /// <p>If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In this case, you can omit this parameter.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"> Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
    /// <p>If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS key that was used to encrypt the parent snapshot.</p>
    /// <p>If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN. </p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
    /// <ul>
    /// <li> <p>No blocks are written to the snapshot.</p> </li>
    /// <li> <p>The snapshot is not completed after writing the last block of data.</p> </li>
    /// </ul>
    /// <p>If no value is specified, the timeout defaults to <code>60</code> minutes.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
}
impl std::fmt::Debug for StartSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSnapshotInput");
        formatter.field("volume_size", &self.volume_size);
        formatter.field("parent_snapshot_id", &self.parent_snapshot_id);
        formatter.field("tags", &self.tags);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct PutSnapshotBlockInput {
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The block index of the block in which to write the data. A block index is a logical index in units of <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data must be <code>512</code> KiB aligned.</p>
    pub block_index: std::option::Option<i32>,
    /// <p>The data to write to the block.</p>
    /// <p>The block data is not signed as part of the Signature Version 4 signing process. As a result, you must generate and provide a Base64-encoded SHA256 checksum for the block data using the <b>x-amz-Checksum</b> header. Also, you must specify the checksum algorithm using the <b>x-amz-Checksum-Algorithm</b> header. The checksum that you provide is part of the Signature Version 4 signing process. It is validated against a checksum generated by Amazon EBS to ensure the validity and authenticity of the data. If the checksums do not correspond, the request fails. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums"> Using checksums with the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub block_data: aws_smithy_http::byte_stream::ByteStream,
    /// <p>The size of the data to write to the block, in bytes. Currently, the only supported size is <code>524288</code> bytes.</p>
    /// <p>Valid values: <code>524288</code> </p>
    pub data_length: std::option::Option<i32>,
    /// <p>The progress of the write process, as a percentage.</p>
    pub progress: std::option::Option<i32>,
    /// <p>A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
    pub checksum_algorithm: std::option::Option<crate::model::ChecksumAlgorithm>,
}
impl PutSnapshotBlockInput {
    /// <p>The ID of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The block index of the block in which to write the data. A block index is a logical index in units of <code>512</code> KiB blocks. To identify the block index, divide the logical offset of the data in the logical volume by the block size (logical offset of data/<code>524288</code>). The logical offset of the data must be <code>512</code> KiB aligned.</p>
    pub fn block_index(&self) -> std::option::Option<i32> {
        self.block_index
    }
    /// <p>The data to write to the block.</p>
    /// <p>The block data is not signed as part of the Signature Version 4 signing process. As a result, you must generate and provide a Base64-encoded SHA256 checksum for the block data using the <b>x-amz-Checksum</b> header. Also, you must specify the checksum algorithm using the <b>x-amz-Checksum-Algorithm</b> header. The checksum that you provide is part of the Signature Version 4 signing process. It is validated against a checksum generated by Amazon EBS to ensure the validity and authenticity of the data. If the checksums do not correspond, the request fails. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums"> Using checksums with the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
    pub fn block_data(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.block_data
    }
    /// <p>The size of the data to write to the block, in bytes. Currently, the only supported size is <code>524288</code> bytes.</p>
    /// <p>Valid values: <code>524288</code> </p>
    pub fn data_length(&self) -> std::option::Option<i32> {
        self.data_length
    }
    /// <p>The progress of the write process, as a percentage.</p>
    pub fn progress(&self) -> std::option::Option<i32> {
        self.progress
    }
    /// <p>A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
    pub fn checksum_algorithm(&self) -> std::option::Option<&crate::model::ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
}
impl std::fmt::Debug for PutSnapshotBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSnapshotBlockInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("block_index", &self.block_index);
        formatter.field("block_data", &"*** Sensitive Data Redacted ***");
        formatter.field("data_length", &self.data_length);
        formatter.field("progress", &self.progress);
        formatter.field("checksum", &self.checksum);
        formatter.field("checksum_algorithm", &self.checksum_algorithm);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSnapshotBlocksInput {
    /// <p>The ID of the snapshot from which to get block indexes and block tokens.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of blocks to be returned by the request.</p>
    /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
    /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The block index from which the list should start. The list in the response will start from this block index or the next valid block index in the snapshot.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub starting_block_index: std::option::Option<i32>,
}
impl ListSnapshotBlocksInput {
    /// <p>The ID of the snapshot from which to get block indexes and block tokens.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of blocks to be returned by the request.</p>
    /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
    /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The block index from which the list should start. The list in the response will start from this block index or the next valid block index in the snapshot.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub fn starting_block_index(&self) -> std::option::Option<i32> {
        self.starting_block_index
    }
}
impl std::fmt::Debug for ListSnapshotBlocksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSnapshotBlocksInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("starting_block_index", &self.starting_block_index);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChangedBlocksInput {
    /// <p>The ID of the first snapshot to use for the comparison.</p> <important>
    /// <p>The <code>FirstSnapshotID</code> parameter must be specified with a <code>SecondSnapshotId</code> parameter; otherwise, an error occurs.</p>
    /// </important>
    pub first_snapshot_id: std::option::Option<std::string::String>,
    /// <p>The ID of the second snapshot to use for the comparison.</p> <important>
    /// <p>The <code>SecondSnapshotId</code> parameter must be specified with a <code>FirstSnapshotID</code> parameter; otherwise, an error occurs.</p>
    /// </important>
    pub second_snapshot_id: std::option::Option<std::string::String>,
    /// <p>The token to request the next page of results.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of blocks to be returned by the request.</p>
    /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
    /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The block index from which the comparison should start.</p>
    /// <p>The list in the response will start from this block index or the next valid block index in the snapshots.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub starting_block_index: std::option::Option<i32>,
}
impl ListChangedBlocksInput {
    /// <p>The ID of the first snapshot to use for the comparison.</p> <important>
    /// <p>The <code>FirstSnapshotID</code> parameter must be specified with a <code>SecondSnapshotId</code> parameter; otherwise, an error occurs.</p>
    /// </important>
    pub fn first_snapshot_id(&self) -> std::option::Option<&str> {
        self.first_snapshot_id.as_deref()
    }
    /// <p>The ID of the second snapshot to use for the comparison.</p> <important>
    /// <p>The <code>SecondSnapshotId</code> parameter must be specified with a <code>FirstSnapshotID</code> parameter; otherwise, an error occurs.</p>
    /// </important>
    pub fn second_snapshot_id(&self) -> std::option::Option<&str> {
        self.second_snapshot_id.as_deref()
    }
    /// <p>The token to request the next page of results.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of blocks to be returned by the request.</p>
    /// <p>Even if additional blocks can be retrieved from the snapshot, the request can return less blocks than <b>MaxResults</b> or an empty array of blocks.</p>
    /// <p>To retrieve the next set of blocks from the snapshot, make another request with the returned <b>NextToken</b> value. The value of <b>NextToken</b> is <code>null</code> when there are no more blocks to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The block index from which the comparison should start.</p>
    /// <p>The list in the response will start from this block index or the next valid block index in the snapshots.</p>
    /// <p>If you specify <b>NextToken</b>, then <b>StartingBlockIndex</b> is ignored.</p>
    pub fn starting_block_index(&self) -> std::option::Option<i32> {
        self.starting_block_index
    }
}
impl std::fmt::Debug for ListChangedBlocksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChangedBlocksInput");
        formatter.field("first_snapshot_id", &self.first_snapshot_id);
        formatter.field("second_snapshot_id", &self.second_snapshot_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("starting_block_index", &self.starting_block_index);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSnapshotBlockInput {
    /// <p>The ID of the snapshot containing the block from which to get data.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The block index of the block from which to get data.</p>
    /// <p>Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
    pub block_index: std::option::Option<i32>,
    /// <p>The block token of the block from which to get data.</p>
    /// <p>Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
    pub block_token: std::option::Option<std::string::String>,
}
impl GetSnapshotBlockInput {
    /// <p>The ID of the snapshot containing the block from which to get data.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The block index of the block from which to get data.</p>
    /// <p>Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
    pub fn block_index(&self) -> std::option::Option<i32> {
        self.block_index
    }
    /// <p>The block token of the block from which to get data.</p>
    /// <p>Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or <code>ListSnapshotBlocks</code> operations.</p>
    pub fn block_token(&self) -> std::option::Option<&str> {
        self.block_token.as_deref()
    }
}
impl std::fmt::Debug for GetSnapshotBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSnapshotBlockInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("block_index", &self.block_index);
        formatter.field("block_token", &self.block_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteSnapshotInput {
    /// <p>The ID of the snapshot.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The number of blocks that were written to the snapshot.</p>
    pub changed_blocks_count: std::option::Option<i32>,
    /// <p>An aggregated Base-64 SHA256 checksum based on the checksums of each written block.</p>
    /// <p>To generate the aggregated checksum using the linear aggregation method, arrange the checksums for each written block in ascending order of their block index, concatenate them to form a single string, and then generate the checksum on the entire string using the SHA256 algorithm.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
    pub checksum_algorithm: std::option::Option<crate::model::ChecksumAlgorithm>,
    /// <p>The aggregation method used to generate the checksum. Currently, the only supported aggregation method is <code>LINEAR</code>.</p>
    pub checksum_aggregation_method: std::option::Option<crate::model::ChecksumAggregationMethod>,
}
impl CompleteSnapshotInput {
    /// <p>The ID of the snapshot.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The number of blocks that were written to the snapshot.</p>
    pub fn changed_blocks_count(&self) -> std::option::Option<i32> {
        self.changed_blocks_count
    }
    /// <p>An aggregated Base-64 SHA256 checksum based on the checksums of each written block.</p>
    /// <p>To generate the aggregated checksum using the linear aggregation method, arrange the checksums for each written block in ascending order of their block index, concatenate them to form a single string, and then generate the checksum on the entire string using the SHA256 algorithm.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The algorithm used to generate the checksum. Currently, the only supported algorithm is <code>SHA256</code>.</p>
    pub fn checksum_algorithm(&self) -> std::option::Option<&crate::model::ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
    /// <p>The aggregation method used to generate the checksum. Currently, the only supported aggregation method is <code>LINEAR</code>.</p>
    pub fn checksum_aggregation_method(
        &self,
    ) -> std::option::Option<&crate::model::ChecksumAggregationMethod> {
        self.checksum_aggregation_method.as_ref()
    }
}
impl std::fmt::Debug for CompleteSnapshotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteSnapshotInput");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("changed_blocks_count", &self.changed_blocks_count);
        formatter.field("checksum", &self.checksum);
        formatter.field("checksum_algorithm", &self.checksum_algorithm);
        formatter.field(
            "checksum_aggregation_method",
            &self.checksum_aggregation_method,
        );
        formatter.finish()
    }
}
