// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    ConflictingBlockUpdate,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBlock,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBlockToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidContentEncoding,
    #[allow(missing_docs)] // documentation missing in model
    InvalidCustomerKey,
    #[allow(missing_docs)] // documentation missing in model
    InvalidDependencyRequest,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPageToken,
    #[allow(missing_docs)] // documentation missing in model
    InvalidParameterValue,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSnapshotId,
    #[allow(missing_docs)] // documentation missing in model
    InvalidTag,
    #[allow(missing_docs)] // documentation missing in model
    InvalidVolumeSize,
    #[allow(missing_docs)] // documentation missing in model
    UnrelatedSnapshots,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CONFLICTING_BLOCK_UPDATE" => ValidationExceptionReason::ConflictingBlockUpdate,
            "INVALID_BLOCK" => ValidationExceptionReason::InvalidBlock,
            "INVALID_BLOCK_TOKEN" => ValidationExceptionReason::InvalidBlockToken,
            "INVALID_CONTENT_ENCODING" => ValidationExceptionReason::InvalidContentEncoding,
            "INVALID_CUSTOMER_KEY" => ValidationExceptionReason::InvalidCustomerKey,
            "INVALID_DEPENDENCY_REQUEST" => ValidationExceptionReason::InvalidDependencyRequest,
            "INVALID_PAGE_TOKEN" => ValidationExceptionReason::InvalidPageToken,
            "INVALID_PARAMETER_VALUE" => ValidationExceptionReason::InvalidParameterValue,
            "INVALID_SNAPSHOT_ID" => ValidationExceptionReason::InvalidSnapshotId,
            "INVALID_TAG" => ValidationExceptionReason::InvalidTag,
            "INVALID_VOLUME_SIZE" => ValidationExceptionReason::InvalidVolumeSize,
            "UNRELATED_SNAPSHOTS" => ValidationExceptionReason::UnrelatedSnapshots,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::ConflictingBlockUpdate => "CONFLICTING_BLOCK_UPDATE",
            ValidationExceptionReason::InvalidBlock => "INVALID_BLOCK",
            ValidationExceptionReason::InvalidBlockToken => "INVALID_BLOCK_TOKEN",
            ValidationExceptionReason::InvalidContentEncoding => "INVALID_CONTENT_ENCODING",
            ValidationExceptionReason::InvalidCustomerKey => "INVALID_CUSTOMER_KEY",
            ValidationExceptionReason::InvalidDependencyRequest => "INVALID_DEPENDENCY_REQUEST",
            ValidationExceptionReason::InvalidPageToken => "INVALID_PAGE_TOKEN",
            ValidationExceptionReason::InvalidParameterValue => "INVALID_PARAMETER_VALUE",
            ValidationExceptionReason::InvalidSnapshotId => "INVALID_SNAPSHOT_ID",
            ValidationExceptionReason::InvalidTag => "INVALID_TAG",
            ValidationExceptionReason::InvalidVolumeSize => "INVALID_VOLUME_SIZE",
            ValidationExceptionReason::UnrelatedSnapshots => "UNRELATED_SNAPSHOTS",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFLICTING_BLOCK_UPDATE",
            "INVALID_BLOCK",
            "INVALID_BLOCK_TOKEN",
            "INVALID_CONTENT_ENCODING",
            "INVALID_CUSTOMER_KEY",
            "INVALID_DEPENDENCY_REQUEST",
            "INVALID_PAGE_TOKEN",
            "INVALID_PARAMETER_VALUE",
            "INVALID_SNAPSHOT_ID",
            "INVALID_TAG",
            "INVALID_VOLUME_SIZE",
            "UNRELATED_SNAPSHOTS",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceQuotaExceededExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    DependencyServiceQuotaExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceQuotaExceededExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "DEPENDENCY_SERVICE_QUOTA_EXCEEDED" => {
                ServiceQuotaExceededExceptionReason::DependencyServiceQuotaExceeded
            }
            other => ServiceQuotaExceededExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceQuotaExceededExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceQuotaExceededExceptionReason::from(s))
    }
}
impl ServiceQuotaExceededExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceQuotaExceededExceptionReason::DependencyServiceQuotaExceeded => {
                "DEPENDENCY_SERVICE_QUOTA_EXCEEDED"
            }
            ServiceQuotaExceededExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPENDENCY_SERVICE_QUOTA_EXCEEDED"]
    }
}
impl AsRef<str> for ServiceQuotaExceededExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceNotFoundExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    DependencyResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SnapshotNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceNotFoundExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "DEPENDENCY_RESOURCE_NOT_FOUND" => {
                ResourceNotFoundExceptionReason::DependencyResourceNotFound
            }
            "SNAPSHOT_NOT_FOUND" => ResourceNotFoundExceptionReason::SnapshotNotFound,
            other => ResourceNotFoundExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceNotFoundExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceNotFoundExceptionReason::from(s))
    }
}
impl ResourceNotFoundExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceNotFoundExceptionReason::DependencyResourceNotFound => {
                "DEPENDENCY_RESOURCE_NOT_FOUND"
            }
            ResourceNotFoundExceptionReason::SnapshotNotFound => "SNAPSHOT_NOT_FOUND",
            ResourceNotFoundExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPENDENCY_RESOURCE_NOT_FOUND", "SNAPSHOT_NOT_FOUND"]
    }
}
impl AsRef<str> for ResourceNotFoundExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestThrottledExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    AccountThrottled,
    #[allow(missing_docs)] // documentation missing in model
    DependencyRequestThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ResourceLevelThrottle,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestThrottledExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_THROTTLED" => RequestThrottledExceptionReason::AccountThrottled,
            "DEPENDENCY_REQUEST_THROTTLED" => {
                RequestThrottledExceptionReason::DependencyRequestThrottled
            }
            "RESOURCE_LEVEL_THROTTLE" => RequestThrottledExceptionReason::ResourceLevelThrottle,
            other => RequestThrottledExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestThrottledExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestThrottledExceptionReason::from(s))
    }
}
impl RequestThrottledExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestThrottledExceptionReason::AccountThrottled => "ACCOUNT_THROTTLED",
            RequestThrottledExceptionReason::DependencyRequestThrottled => {
                "DEPENDENCY_REQUEST_THROTTLED"
            }
            RequestThrottledExceptionReason::ResourceLevelThrottle => "RESOURCE_LEVEL_THROTTLE",
            RequestThrottledExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_THROTTLED",
            "DEPENDENCY_REQUEST_THROTTLED",
            "RESOURCE_LEVEL_THROTTLE",
        ]
    }
}
impl AsRef<str> for RequestThrottledExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessDeniedExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    DependencyAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    UnauthorizedAccount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessDeniedExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "DEPENDENCY_ACCESS_DENIED" => AccessDeniedExceptionReason::DependencyAccessDenied,
            "UNAUTHORIZED_ACCOUNT" => AccessDeniedExceptionReason::UnauthorizedAccount,
            other => AccessDeniedExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessDeniedExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessDeniedExceptionReason::from(s))
    }
}
impl AccessDeniedExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessDeniedExceptionReason::DependencyAccessDenied => "DEPENDENCY_ACCESS_DENIED",
            AccessDeniedExceptionReason::UnauthorizedAccount => "UNAUTHORIZED_ACCOUNT",
            AccessDeniedExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPENDENCY_ACCESS_DENIED", "UNAUTHORIZED_ACCOUNT"]
    }
}
impl AsRef<str> for AccessDeniedExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "completed" => Status::Completed,
            "error" => Status::Error,
            "pending" => Status::Pending,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Completed => "completed",
            Status::Error => "error",
            Status::Pending => "pending",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["completed", "error", "pending"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChecksumAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    ChecksumAlgorithmSha256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChecksumAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "SHA256" => ChecksumAlgorithm::ChecksumAlgorithmSha256,
            other => ChecksumAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChecksumAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChecksumAlgorithm::from(s))
    }
}
impl ChecksumAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChecksumAlgorithm::ChecksumAlgorithmSha256 => "SHA256",
            ChecksumAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHA256"]
    }
}
impl AsRef<str> for ChecksumAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A block of data in an Amazon Elastic Block Store snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Block {
    /// <p>The block index.</p>
    pub block_index: std::option::Option<i32>,
    /// <p>The block token for the block index.</p>
    pub block_token: std::option::Option<std::string::String>,
}
impl Block {
    /// <p>The block index.</p>
    pub fn block_index(&self) -> std::option::Option<i32> {
        self.block_index
    }
    /// <p>The block token for the block index.</p>
    pub fn block_token(&self) -> std::option::Option<&str> {
        self.block_token.as_deref()
    }
}
impl std::fmt::Debug for Block {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Block");
        formatter.field("block_index", &self.block_index);
        formatter.field("block_token", &self.block_token);
        formatter.finish()
    }
}
/// See [`Block`](crate::model::Block)
pub mod block {
    /// A builder for [`Block`](crate::model::Block)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_index: std::option::Option<i32>,
        pub(crate) block_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The block index.</p>
        pub fn block_index(mut self, input: i32) -> Self {
            self.block_index = Some(input);
            self
        }
        /// <p>The block index.</p>
        pub fn set_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.block_index = input;
            self
        }
        /// <p>The block token for the block index.</p>
        pub fn block_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.block_token = Some(input.into());
            self
        }
        /// <p>The block token for the block index.</p>
        pub fn set_block_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.block_token = input;
            self
        }
        /// Consumes the builder and constructs a [`Block`](crate::model::Block)
        pub fn build(self) -> crate::model::Block {
            crate::model::Block {
                block_index: self.block_index,
                block_token: self.block_token,
            }
        }
    }
}
impl Block {
    /// Creates a new builder-style object to manufacture [`Block`](crate::model::Block)
    pub fn builder() -> crate::model::block::Builder {
        crate::model::block::Builder::default()
    }
}

/// <p>A block of data in an Amazon Elastic Block Store snapshot that is different from another snapshot of the same volume/snapshot lineage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangedBlock {
    /// <p>The block index.</p>
    pub block_index: std::option::Option<i32>,
    /// <p>The block token for the block index of the <code>FirstSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the changed block that is on the second snapshot.</p>
    pub first_block_token: std::option::Option<std::string::String>,
    /// <p>The block token for the block index of the <code>SecondSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation.</p>
    pub second_block_token: std::option::Option<std::string::String>,
}
impl ChangedBlock {
    /// <p>The block index.</p>
    pub fn block_index(&self) -> std::option::Option<i32> {
        self.block_index
    }
    /// <p>The block token for the block index of the <code>FirstSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the changed block that is on the second snapshot.</p>
    pub fn first_block_token(&self) -> std::option::Option<&str> {
        self.first_block_token.as_deref()
    }
    /// <p>The block token for the block index of the <code>SecondSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation.</p>
    pub fn second_block_token(&self) -> std::option::Option<&str> {
        self.second_block_token.as_deref()
    }
}
impl std::fmt::Debug for ChangedBlock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangedBlock");
        formatter.field("block_index", &self.block_index);
        formatter.field("first_block_token", &self.first_block_token);
        formatter.field("second_block_token", &self.second_block_token);
        formatter.finish()
    }
}
/// See [`ChangedBlock`](crate::model::ChangedBlock)
pub mod changed_block {
    /// A builder for [`ChangedBlock`](crate::model::ChangedBlock)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_index: std::option::Option<i32>,
        pub(crate) first_block_token: std::option::Option<std::string::String>,
        pub(crate) second_block_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The block index.</p>
        pub fn block_index(mut self, input: i32) -> Self {
            self.block_index = Some(input);
            self
        }
        /// <p>The block index.</p>
        pub fn set_block_index(mut self, input: std::option::Option<i32>) -> Self {
            self.block_index = input;
            self
        }
        /// <p>The block token for the block index of the <code>FirstSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the changed block that is on the second snapshot.</p>
        pub fn first_block_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_block_token = Some(input.into());
            self
        }
        /// <p>The block token for the block index of the <code>FirstSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the changed block that is on the second snapshot.</p>
        pub fn set_first_block_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.first_block_token = input;
            self
        }
        /// <p>The block token for the block index of the <code>SecondSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation.</p>
        pub fn second_block_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.second_block_token = Some(input.into());
            self
        }
        /// <p>The block token for the block index of the <code>SecondSnapshotId</code> specified in the <code>ListChangedBlocks</code> operation.</p>
        pub fn set_second_block_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.second_block_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangedBlock`](crate::model::ChangedBlock)
        pub fn build(self) -> crate::model::ChangedBlock {
            crate::model::ChangedBlock {
                block_index: self.block_index,
                first_block_token: self.first_block_token,
                second_block_token: self.second_block_token,
            }
        }
    }
}
impl ChangedBlock {
    /// Creates a new builder-style object to manufacture [`ChangedBlock`](crate::model::ChangedBlock)
    pub fn builder() -> crate::model::changed_block::Builder {
        crate::model::changed_block::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChecksumAggregationMethod {
    #[allow(missing_docs)] // documentation missing in model
    ChecksumAggregationLinear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChecksumAggregationMethod {
    fn from(s: &str) -> Self {
        match s {
            "LINEAR" => ChecksumAggregationMethod::ChecksumAggregationLinear,
            other => ChecksumAggregationMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChecksumAggregationMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChecksumAggregationMethod::from(s))
    }
}
impl ChecksumAggregationMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChecksumAggregationMethod::ChecksumAggregationLinear => "LINEAR",
            ChecksumAggregationMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINEAR"]
    }
}
impl AsRef<str> for ChecksumAggregationMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
