// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteSnapshotOutput, crate::error::CompleteSnapshotError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CompleteSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CompleteSnapshotError {
            meta: generic,
            kind: crate::error::CompleteSnapshotErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CompleteSnapshotOutput, crate::error::CompleteSnapshotError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_complete_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CompleteSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snapshot_block(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::GetSnapshotBlockOutput, crate::error::GetSnapshotBlockError>
{
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_snapshot_block_output::Builder::default();
        let _ = response;
        output = output.set_block_data(
            Some(crate::http_serde::deser_payload_get_snapshot_block_get_snapshot_block_output_block_data(response.body_mut())?)
        );
        output = output.set_checksum(
            crate::http_serde::deser_header_get_snapshot_block_get_snapshot_block_output_checksum(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetSnapshotBlockError::unhandled(
                    "Failed to parse Checksum from header `x-amz-Checksum",
                )
            })?,
        );
        output = output.set_checksum_algorithm(
            crate::http_serde::deser_header_get_snapshot_block_get_snapshot_block_output_checksum_algorithm(response.headers())
                                    .map_err(|_|crate::error::GetSnapshotBlockError::unhandled("Failed to parse ChecksumAlgorithm from header `x-amz-Checksum-Algorithm"))?
        );
        output = output.set_data_length(
            crate::http_serde::deser_header_get_snapshot_block_get_snapshot_block_output_data_length(response.headers())
                                    .map_err(|_|crate::error::GetSnapshotBlockError::unhandled("Failed to parse DataLength from header `x-amz-Data-Length"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_snapshot_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSnapshotBlockOutput, crate::error::GetSnapshotBlockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSnapshotBlockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSnapshotBlockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetSnapshotBlockError {
            meta: generic,
            kind: crate::error::GetSnapshotBlockErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSnapshotBlockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_changed_blocks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChangedBlocksOutput, crate::error::ListChangedBlocksError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListChangedBlocksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListChangedBlocksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListChangedBlocksError {
            meta: generic,
            kind: crate::error::ListChangedBlocksErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListChangedBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListChangedBlocksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_changed_blocks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListChangedBlocksOutput, crate::error::ListChangedBlocksError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_changed_blocks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_changed_blocks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListChangedBlocksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_snapshot_blocks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSnapshotBlocksOutput,
    crate::error::ListSnapshotBlocksError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSnapshotBlocksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::ListSnapshotBlocksError {
            meta: generic,
            kind: crate::error::ListSnapshotBlocksErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSnapshotBlocksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_snapshot_blocks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSnapshotBlocksOutput,
    crate::error::ListSnapshotBlocksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_snapshot_blocks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_snapshot_blocks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSnapshotBlocksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_snapshot_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSnapshotBlockOutput, crate::error::PutSnapshotBlockError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutSnapshotBlockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutSnapshotBlockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutSnapshotBlockError {
            meta: generic,
            kind: crate::error::PutSnapshotBlockErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSnapshotBlockError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutSnapshotBlockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_snapshot_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSnapshotBlockOutput, crate::error::PutSnapshotBlockError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_snapshot_block_output::Builder::default();
        let _ = response;
        output = output.set_checksum(
            crate::http_serde::deser_header_put_snapshot_block_put_snapshot_block_output_checksum(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSnapshotBlockError::unhandled(
                    "Failed to parse Checksum from header `x-amz-Checksum",
                )
            })?,
        );
        output = output.set_checksum_algorithm(
            crate::http_serde::deser_header_put_snapshot_block_put_snapshot_block_output_checksum_algorithm(response.headers())
                                    .map_err(|_|crate::error::PutSnapshotBlockError::unhandled("Failed to parse ChecksumAlgorithm from header `x-amz-Checksum-Algorithm"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartSnapshotOutput, crate::error::StartSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConcurrentLimitExceededException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::ConcurrentLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_concurrent_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::StartSnapshotError {
                meta: generic,
                kind: crate::error::StartSnapshotErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestThrottledException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::RequestThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StartSnapshotError {
            meta: generic,
            kind: crate::error::StartSnapshotErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartSnapshotOutput, crate::error::StartSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartSnapshotError::unhandled)?;
        output.build()
    })
}
