// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CompleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteSnapshotError {
    /// Kind of error that occurred.
    pub kind: CompleteSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CompleteSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteSnapshotError {
    fn code(&self) -> Option<&str> {
        CompleteSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteSnapshotError {
    /// Creates a new `CompleteSnapshotError`.
    pub fn new(kind: CompleteSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteSnapshotErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CompleteSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::RequestThrottledException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            CompleteSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSnapshotBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSnapshotBlockError {
    /// Kind of error that occurred.
    pub kind: GetSnapshotBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSnapshotBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSnapshotBlockErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSnapshotBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSnapshotBlockErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSnapshotBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSnapshotBlockError {
    fn code(&self) -> Option<&str> {
        GetSnapshotBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSnapshotBlockError {
    /// Creates a new `GetSnapshotBlockError`.
    pub fn new(kind: GetSnapshotBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSnapshotBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSnapshotBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSnapshotBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSnapshotBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSnapshotBlockErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSnapshotBlockErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetSnapshotBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSnapshotBlockErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::RequestThrottledException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::ValidationException(_inner) => Some(_inner),
            GetSnapshotBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListChangedBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListChangedBlocksError {
    /// Kind of error that occurred.
    pub kind: ListChangedBlocksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListChangedBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListChangedBlocksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListChangedBlocksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListChangedBlocksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListChangedBlocksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListChangedBlocksError {
    fn code(&self) -> Option<&str> {
        ListChangedBlocksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListChangedBlocksError {
    /// Creates a new `ListChangedBlocksError`.
    pub fn new(kind: ListChangedBlocksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListChangedBlocksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListChangedBlocksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListChangedBlocksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListChangedBlocksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListChangedBlocksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListChangedBlocksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListChangedBlocksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListChangedBlocksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::RequestThrottledException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::ValidationException(_inner) => Some(_inner),
            ListChangedBlocksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSnapshotBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSnapshotBlocksError {
    /// Kind of error that occurred.
    pub kind: ListSnapshotBlocksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSnapshotBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSnapshotBlocksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSnapshotBlocksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSnapshotBlocksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSnapshotBlocksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSnapshotBlocksError {
    fn code(&self) -> Option<&str> {
        ListSnapshotBlocksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSnapshotBlocksError {
    /// Creates a new `ListSnapshotBlocksError`.
    pub fn new(kind: ListSnapshotBlocksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSnapshotBlocksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSnapshotBlocksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSnapshotBlocksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSnapshotBlocksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSnapshotBlocksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSnapshotBlocksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListSnapshotBlocksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSnapshotBlocksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::RequestThrottledException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::ValidationException(_inner) => Some(_inner),
            ListSnapshotBlocksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSnapshotBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSnapshotBlockError {
    /// Kind of error that occurred.
    pub kind: PutSnapshotBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSnapshotBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSnapshotBlockErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSnapshotBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSnapshotBlockErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutSnapshotBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSnapshotBlockError {
    fn code(&self) -> Option<&str> {
        PutSnapshotBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSnapshotBlockError {
    /// Creates a new `PutSnapshotBlockError`.
    pub fn new(kind: PutSnapshotBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSnapshotBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSnapshotBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSnapshotBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSnapshotBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSnapshotBlockErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSnapshotBlockErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutSnapshotBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSnapshotBlockErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::InternalServerException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::RequestThrottledException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::ValidationException(_inner) => Some(_inner),
            PutSnapshotBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSnapshotError {
    /// Kind of error that occurred.
    pub kind: StartSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSnapshotErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You have reached the limit for concurrent API requests. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapi-performance">Optimizing performance of the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud
    /// User Guide</i>.</p>
    ConcurrentLimitExceededException(crate::error::ConcurrentLimitExceededException),
    /// <p>The request uses the same client token as a previous, but non-identical
    /// request.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal error has occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The number of API requests has exceed the maximum allowed API request throttling
    /// limit.</p>
    RequestThrottledException(crate::error::RequestThrottledException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your current service quotas do not allow you to perform this action.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::ConcurrentLimitExceededException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::RequestThrottledException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSnapshotError {
    fn code(&self) -> Option<&str> {
        StartSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSnapshotError {
    /// Creates a new `StartSnapshotError`.
    pub fn new(kind: StartSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StartSnapshotErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::ConcurrentLimitExceededException`.
    pub fn is_concurrent_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSnapshotErrorKind::ConcurrentLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartSnapshotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSnapshotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::RequestThrottledException`.
    pub fn is_request_throttled_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSnapshotErrorKind::RequestThrottledException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSnapshotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSnapshotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartSnapshotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartSnapshotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartSnapshotErrorKind::ConcurrentLimitExceededException(_inner) => Some(_inner),
            StartSnapshotErrorKind::ConflictException(_inner) => Some(_inner),
            StartSnapshotErrorKind::InternalServerException(_inner) => Some(_inner),
            StartSnapshotErrorKind::RequestThrottledException(_inner) => Some(_inner),
            StartSnapshotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartSnapshotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartSnapshotErrorKind::ValidationException(_inner) => Some(_inner),
            StartSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints of the EBS direct APIs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the validation exception.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the validation exception.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the validation exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Your current service quotas do not allow you to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::ServiceQuotaExceededExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ServiceQuotaExceededExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The specified resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::ResourceNotFoundExceptionReason>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ResourceNotFoundExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::ResourceNotFoundExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ResourceNotFoundExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The number of API requests has exceed the maximum allowed API request throttling
/// limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestThrottledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::RequestThrottledExceptionReason>,
}
impl std::fmt::Debug for RequestThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestThrottledException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl RequestThrottledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestThrottledException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestThrottledException {}
/// See [`RequestThrottledException`](crate::error::RequestThrottledException)
pub mod request_throttled_exception {
    /// A builder for [`RequestThrottledException`](crate::error::RequestThrottledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::RequestThrottledExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::RequestThrottledExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::RequestThrottledExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestThrottledException`](crate::error::RequestThrottledException)
        pub fn build(self) -> crate::error::RequestThrottledException {
            crate::error::RequestThrottledException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl RequestThrottledException {
    /// Creates a new builder-style object to manufacture [`RequestThrottledException`](crate::error::RequestThrottledException)
    pub fn builder() -> crate::error::request_throttled_exception::Builder {
        crate::error::request_throttled_exception::Builder::default()
    }
}

/// <p>An internal error has occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The request uses the same client token as a previous, but non-identical
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You have reached the limit for concurrent API requests. For more information, see
/// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapi-performance">Optimizing performance of the EBS direct APIs</a> in the <i>Amazon Elastic Compute Cloud
/// User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentLimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentLimitExceededException {}
/// See [`ConcurrentLimitExceededException`](crate::error::ConcurrentLimitExceededException)
pub mod concurrent_limit_exceeded_exception {
    /// A builder for [`ConcurrentLimitExceededException`](crate::error::ConcurrentLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentLimitExceededException`](crate::error::ConcurrentLimitExceededException)
        pub fn build(self) -> crate::error::ConcurrentLimitExceededException {
            crate::error::ConcurrentLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ConcurrentLimitExceededException`](crate::error::ConcurrentLimitExceededException)
    pub fn builder() -> crate::error::concurrent_limit_exceeded_exception::Builder {
        crate::error::concurrent_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the exception.</p>
    pub reason: std::option::Option<crate::model::AccessDeniedExceptionReason>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::AccessDeniedExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn reason(mut self, input: crate::model::AccessDeniedExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::AccessDeniedExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
