// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon DynamoDB Streams
///
/// Client for invoking operations on Amazon DynamoDB Streams. Each operation on Amazon DynamoDB Streams is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_dynamodbstreams::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_dynamodbstreams::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_dynamodbstreams::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`DescribeStream`](crate::client::fluent_builders::DescribeStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeStream::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::DescribeStream::set_stream_arn): <p>The Amazon Resource Name (ARN) for the stream.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeStream::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeStream::set_limit): <p>The maximum number of shard objects to return. The upper limit is 100.</p>
    ///   - [`exclusive_start_shard_id(impl Into<String>)`](crate::client::fluent_builders::DescribeStream::exclusive_start_shard_id) / [`set_exclusive_start_shard_id(Option<String>)`](crate::client::fluent_builders::DescribeStream::set_exclusive_start_shard_id): <p>The shard ID of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedShardId</code> in the previous operation. </p>
    /// - On success, responds with [`DescribeStreamOutput`](crate::output::DescribeStreamOutput) with field(s):
    ///   - [`stream_description(Option<StreamDescription>)`](crate::output::DescribeStreamOutput::stream_description): <p>A complete description of the stream, including its creation date and time, the DynamoDB table associated with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream records within the shards.</p>
    /// - On failure, responds with [`SdkError<DescribeStreamError>`](crate::error::DescribeStreamError)
    pub fn describe_stream(&self) -> fluent_builders::DescribeStream {
        fluent_builders::DescribeStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecords`](crate::client::fluent_builders::GetRecords) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`shard_iterator(impl Into<String>)`](crate::client::fluent_builders::GetRecords::shard_iterator) / [`set_shard_iterator(Option<String>)`](crate::client::fluent_builders::GetRecords::set_shard_iterator): <p>A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetRecords::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetRecords::set_limit): <p>The maximum number of records to return from the shard. The upper limit is 1000.</p>
    /// - On success, responds with [`GetRecordsOutput`](crate::output::GetRecordsOutput) with field(s):
    ///   - [`records(Option<Vec<Record>>)`](crate::output::GetRecordsOutput::records): <p>The stream records from the shard, which were retrieved using the shard iterator.</p>
    ///   - [`next_shard_iterator(Option<String>)`](crate::output::GetRecordsOutput::next_shard_iterator): <p>The next position in the shard from which to start sequentially reading stream records. If set to <code>null</code>, the shard has been closed and the requested iterator will not return any more data.</p>
    /// - On failure, responds with [`SdkError<GetRecordsError>`](crate::error::GetRecordsError)
    pub fn get_records(&self) -> fluent_builders::GetRecords {
        fluent_builders::GetRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetShardIterator`](crate::client::fluent_builders::GetShardIterator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::GetShardIterator::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::GetShardIterator::set_stream_arn): <p>The Amazon Resource Name (ARN) for the stream.</p>
    ///   - [`shard_id(impl Into<String>)`](crate::client::fluent_builders::GetShardIterator::shard_id) / [`set_shard_id(Option<String>)`](crate::client::fluent_builders::GetShardIterator::set_shard_id): <p>The identifier of the shard. The iterator will be returned for this shard ID.</p>
    ///   - [`shard_iterator_type(ShardIteratorType)`](crate::client::fluent_builders::GetShardIterator::shard_iterator_type) / [`set_shard_iterator_type(Option<ShardIteratorType>)`](crate::client::fluent_builders::GetShardIterator::set_shard_iterator_type): <p>Determines how the shard iterator is used to start reading stream records from the shard:</p>  <ul>   <li> <p> <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence number.</p> </li>   <li> <p> <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence number.</p> </li>   <li> <p> <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are subject to removal (trimming) from the stream.</p> </li>   <li> <p> <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always read the most recent data in the shard.</p> </li>  </ul>
    ///   - [`sequence_number(impl Into<String>)`](crate::client::fluent_builders::GetShardIterator::sequence_number) / [`set_sequence_number(Option<String>)`](crate::client::fluent_builders::GetShardIterator::set_sequence_number): <p>The sequence number of a stream record in the shard from which to start reading.</p>
    /// - On success, responds with [`GetShardIteratorOutput`](crate::output::GetShardIteratorOutput) with field(s):
    ///   - [`shard_iterator(Option<String>)`](crate::output::GetShardIteratorOutput::shard_iterator): <p>The position in the shard from which to start reading stream records sequentially. A shard iterator specifies this position using the sequence number of a stream record in a shard.</p>
    /// - On failure, responds with [`SdkError<GetShardIteratorError>`](crate::error::GetShardIteratorError)
    pub fn get_shard_iterator(&self) -> fluent_builders::GetShardIterator {
        fluent_builders::GetShardIterator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreams`](crate::client::fluent_builders::ListStreams) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::ListStreams::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::ListStreams::set_table_name): <p>If this parameter is provided, then only the streams associated with this table name are returned.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListStreams::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListStreams::set_limit): <p>The maximum number of streams to return. The upper limit is 100.</p>
    ///   - [`exclusive_start_stream_arn(impl Into<String>)`](crate::client::fluent_builders::ListStreams::exclusive_start_stream_arn) / [`set_exclusive_start_stream_arn(Option<String>)`](crate::client::fluent_builders::ListStreams::set_exclusive_start_stream_arn): <p>The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedStreamArn</code> in the previous operation. </p>
    /// - On success, responds with [`ListStreamsOutput`](crate::output::ListStreamsOutput) with field(s):
    ///   - [`streams(Option<Vec<Stream>>)`](crate::output::ListStreamsOutput::streams): <p>A list of stream descriptors associated with the current account and endpoint.</p>
    ///   - [`last_evaluated_stream_arn(Option<String>)`](crate::output::ListStreamsOutput::last_evaluated_stream_arn): <p>The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.</p>  <p>If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved.</p>  <p>If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedStreamArn</code> is empty.</p>
    /// - On failure, responds with [`SdkError<ListStreamsError>`](crate::error::ListStreamsError)
    pub fn list_streams(&self) -> fluent_builders::ListStreams {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DescribeStream`.
    ///
    /// <p>Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.</p> <note>
    /// <p>You can call <code>DescribeStream</code> at a maximum rate of 10 times per second.</p>
    /// </note>
    /// <p>Each shard in the stream has a <code>SequenceNumberRange</code> associated with it. If the <code>SequenceNumberRange</code> has a <code>StartingSequenceNumber</code> but no <code>EndingSequenceNumber</code>, then the shard is still open (able to receive more stream records). If both <code>StartingSequenceNumber</code> and <code>EndingSequenceNumber</code> are present, then that shard is closed and can no longer receive more data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_stream_input::Builder,
    }
    impl DescribeStream {
        /// Creates a new `DescribeStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The maximum number of shard objects to return. The upper limit is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of shard objects to return. The upper limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The shard ID of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedShardId</code> in the previous operation. </p>
        pub fn exclusive_start_shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_shard_id(input.into());
            self
        }
        /// <p>The shard ID of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedShardId</code> in the previous operation. </p>
        pub fn set_exclusive_start_shard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_shard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecords`.
    ///
    /// <p>Retrieves the stream records from a given shard.</p>
    /// <p>Specify a shard iterator using the <code>ShardIterator</code> parameter. The shard iterator specifies the position in the shard from which you want to start reading stream records sequentially. If there are no stream records available in the portion of the shard that the iterator points to, <code>GetRecords</code> returns an empty list. Note that it might take multiple calls to get to a portion of the shard that contains stream records.</p> <note>
    /// <p> <code>GetRecords</code> can retrieve a maximum of 1 MB of data or 1000 stream records, whichever comes first.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecords {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_records_input::Builder,
    }
    impl GetRecords {
        /// Creates a new `GetRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecordsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.</p>
        pub fn shard_iterator(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_iterator(input.into());
            self
        }
        /// <p>A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.</p>
        pub fn set_shard_iterator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shard_iterator(input);
            self
        }
        /// <p>The maximum number of records to return from the shard. The upper limit is 1000.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of records to return from the shard. The upper limit is 1000.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetShardIterator`.
    ///
    /// <p>Returns a shard iterator. A shard iterator provides information about how to retrieve the stream records from within a shard. Use the shard iterator in a subsequent <code>GetRecords</code> request to read the stream records from the shard.</p> <note>
    /// <p>A shard iterator expires 15 minutes after it is returned to the requester.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetShardIterator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_shard_iterator_input::Builder,
    }
    impl GetShardIterator {
        /// Creates a new `GetShardIterator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetShardIteratorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetShardIteratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The identifier of the shard. The iterator will be returned for this shard ID.</p>
        pub fn shard_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_id(input.into());
            self
        }
        /// <p>The identifier of the shard. The iterator will be returned for this shard ID.</p>
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shard_id(input);
            self
        }
        /// <p>Determines how the shard iterator is used to start reading stream records from the shard:</p>
        /// <ul>
        /// <li> <p> <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence number.</p> </li>
        /// <li> <p> <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence number.</p> </li>
        /// <li> <p> <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are subject to removal (trimming) from the stream.</p> </li>
        /// <li> <p> <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always read the most recent data in the shard.</p> </li>
        /// </ul>
        pub fn shard_iterator_type(mut self, input: crate::model::ShardIteratorType) -> Self {
            self.inner = self.inner.shard_iterator_type(input);
            self
        }
        /// <p>Determines how the shard iterator is used to start reading stream records from the shard:</p>
        /// <ul>
        /// <li> <p> <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a specific sequence number.</p> </li>
        /// <li> <p> <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a specific sequence number.</p> </li>
        /// <li> <p> <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are subject to removal (trimming) from the stream.</p> </li>
        /// <li> <p> <code>LATEST</code> - Start reading just after the most recent stream record in the shard, so that you always read the most recent data in the shard.</p> </li>
        /// </ul>
        pub fn set_shard_iterator_type(
            mut self,
            input: std::option::Option<crate::model::ShardIteratorType>,
        ) -> Self {
            self.inner = self.inner.set_shard_iterator_type(input);
            self
        }
        /// <p>The sequence number of a stream record in the shard from which to start reading.</p>
        pub fn sequence_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sequence_number(input.into());
            self
        }
        /// <p>The sequence number of a stream record in the shard from which to start reading.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sequence_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Returns an array of stream ARNs associated with the current account and endpoint. If the <code>TableName</code> parameter is present, then <code>ListStreams</code> will return only the streams ARNs for that table.</p> <note>
    /// <p>You can call <code>ListStreams</code> at a maximum rate of 5 times per second.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreams {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl ListStreams {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If this parameter is provided, then only the streams associated with this table name are returned.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>If this parameter is provided, then only the streams associated with this table name are returned.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The maximum number of streams to return. The upper limit is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of streams to return. The upper limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedStreamArn</code> in the previous operation. </p>
        pub fn exclusive_start_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_stream_arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedStreamArn</code> in the previous operation. </p>
        pub fn set_exclusive_start_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_stream_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
