// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStreamOutput, crate::error::DescribeStreamError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeStreamError {
            meta: generic,
            kind: crate::error::DescribeStreamErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeStreamError {
            meta: generic,
            kind: crate::error::DescribeStreamErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStreamOutput, crate::error::DescribeStreamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_stream_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_stream(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStreamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_records_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRecordsOutput, crate::error::GetRecordsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRecordsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRecordsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredIteratorException" => crate::error::GetRecordsError {
            meta: generic,
            kind: crate::error::GetRecordsErrorKind::ExpiredIteratorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::expired_iterator_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_expired_iterator_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::GetRecordsError {
            meta: generic,
            kind: crate::error::GetRecordsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetRecordsError {
            meta: generic,
            kind: crate::error::GetRecordsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetRecordsError {
            meta: generic,
            kind: crate::error::GetRecordsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrimmedDataAccessException" => crate::error::GetRecordsError {
            meta: generic,
            kind: crate::error::GetRecordsErrorKind::TrimmedDataAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::trimmed_data_access_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trimmed_data_access_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRecordsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_records_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRecordsOutput, crate::error::GetRecordsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_records_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_records(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRecordsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_shard_iterator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetShardIteratorOutput, crate::error::GetShardIteratorError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetShardIteratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetShardIteratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::GetShardIteratorError {
            meta: generic,
            kind: crate::error::GetShardIteratorErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetShardIteratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetShardIteratorError {
            meta: generic,
            kind: crate::error::GetShardIteratorErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetShardIteratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TrimmedDataAccessException" => crate::error::GetShardIteratorError {
            meta: generic,
            kind: crate::error::GetShardIteratorErrorKind::TrimmedDataAccessException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::trimmed_data_access_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_trimmed_data_access_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetShardIteratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetShardIteratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_shard_iterator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetShardIteratorOutput, crate::error::GetShardIteratorError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_shard_iterator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_shard_iterator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetShardIteratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_streams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStreamsOutput, crate::error::ListStreamsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStreamsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListStreamsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListStreamsError {
            meta: generic,
            kind: crate::error::ListStreamsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListStreamsError {
            meta: generic,
            kind: crate::error::ListStreamsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListStreamsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_streams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListStreamsOutput, crate::error::ListStreamsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_streams_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_streams(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListStreamsError::unhandled)?;
        output.build()
    })
}
