// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `DescribeStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stream`](crate::client::Client::describe_stream).
///
/// See [`crate::client::fluent_builders::DescribeStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStream {
    _private: (),
}
impl DescribeStream {
    /// Creates a new builder-style object to manufacture [`DescribeStreamInput`](crate::input::DescribeStreamInput)
    pub fn builder() -> crate::input::describe_stream_input::Builder {
        crate::input::describe_stream_input::Builder::default()
    }
    /// Creates a new `DescribeStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStream {
    type Output =
        std::result::Result<crate::output::DescribeStreamOutput, crate::error::DescribeStreamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stream_error(response)
        } else {
            crate::operation_deser::parse_describe_stream_response(response)
        }
    }
}

/// Operation shape for `GetRecords`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_records`](crate::client::Client::get_records).
///
/// See [`crate::client::fluent_builders::GetRecords`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecords {
    _private: (),
}
impl GetRecords {
    /// Creates a new builder-style object to manufacture [`GetRecordsInput`](crate::input::GetRecordsInput)
    pub fn builder() -> crate::input::get_records_input::Builder {
        crate::input::get_records_input::Builder::default()
    }
    /// Creates a new `GetRecords` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecords {
    type Output =
        std::result::Result<crate::output::GetRecordsOutput, crate::error::GetRecordsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_records_error(response)
        } else {
            crate::operation_deser::parse_get_records_response(response)
        }
    }
}

/// Operation shape for `GetShardIterator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_shard_iterator`](crate::client::Client::get_shard_iterator).
///
/// See [`crate::client::fluent_builders::GetShardIterator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetShardIterator {
    _private: (),
}
impl GetShardIterator {
    /// Creates a new builder-style object to manufacture [`GetShardIteratorInput`](crate::input::GetShardIteratorInput)
    pub fn builder() -> crate::input::get_shard_iterator_input::Builder {
        crate::input::get_shard_iterator_input::Builder::default()
    }
    /// Creates a new `GetShardIterator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetShardIterator {
    type Output = std::result::Result<
        crate::output::GetShardIteratorOutput,
        crate::error::GetShardIteratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_shard_iterator_error(response)
        } else {
            crate::operation_deser::parse_get_shard_iterator_response(response)
        }
    }
}

/// Operation shape for `ListStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_streams`](crate::client::Client::list_streams).
///
/// See [`crate::client::fluent_builders::ListStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreams {
    _private: (),
}
impl ListStreams {
    /// Creates a new builder-style object to manufacture [`ListStreamsInput`](crate::input::ListStreamsInput)
    pub fn builder() -> crate::input::list_streams_input::Builder {
        crate::input::list_streams_input::Builder::default()
    }
    /// Creates a new `ListStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreams {
    type Output =
        std::result::Result<crate::output::ListStreamsOutput, crate::error::ListStreamsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_streams_error(response)
        } else {
            crate::operation_deser::parse_list_streams_response(response)
        }
    }
}
