// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `DynamoDBStreams_20120810`.
///
/// This client allows ergonomic access to a `DynamoDBStreams_20120810`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DescribeStream` operation.
    ///
    /// See [`DescribeStream`](crate::client::fluent_builders::DescribeStream) for more information about the
    /// operation and its arguments.
    pub fn describe_stream(&self) -> fluent_builders::DescribeStream<C, M, R> {
        fluent_builders::DescribeStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecords` operation.
    ///
    /// See [`GetRecords`](crate::client::fluent_builders::GetRecords) for more information about the
    /// operation and its arguments.
    pub fn get_records(&self) -> fluent_builders::GetRecords<C, M, R> {
        fluent_builders::GetRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetShardIterator` operation.
    ///
    /// See [`GetShardIterator`](crate::client::fluent_builders::GetShardIterator) for more information about the
    /// operation and its arguments.
    pub fn get_shard_iterator(&self) -> fluent_builders::GetShardIterator<C, M, R> {
        fluent_builders::GetShardIterator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreams` operation.
    ///
    /// See [`ListStreams`](crate::client::fluent_builders::ListStreams) for more information about the
    /// operation and its arguments.
    pub fn list_streams(&self) -> fluent_builders::ListStreams<C, M, R> {
        fluent_builders::ListStreams::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DescribeStream`.
    ///
    /// <p>Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.</p>
    /// <note>
    /// <p>You can call <code>DescribeStream</code> at a maximum rate of 10 times per second.</p>
    /// </note>
    /// <p>Each shard in the stream has a <code>SequenceNumberRange</code> associated with it. If the
    /// <code>SequenceNumberRange</code> has a <code>StartingSequenceNumber</code> but no
    /// <code>EndingSequenceNumber</code>, then the shard is still open (able to receive more stream
    /// records). If both <code>StartingSequenceNumber</code> and <code>EndingSequenceNumber</code>
    /// are present, then that shard is closed and can no longer receive more data.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stream_input::Builder,
    }
    impl<C, M, R> DescribeStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStreamInputOperationOutputAlias,
                crate::output::DescribeStreamOutput,
                crate::error::DescribeStreamError,
                crate::input::DescribeStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn stream_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The maximum number of shard objects to return. The upper limit is 100.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of shard objects to return. The upper limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The shard ID of the first item that this operation will evaluate. Use the value that was
        /// returned for <code>LastEvaluatedShardId</code> in the previous operation. </p>
        pub fn exclusive_start_shard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_shard_id(inp);
            self
        }
        /// <p>The shard ID of the first item that this operation will evaluate. Use the value that was
        /// returned for <code>LastEvaluatedShardId</code> in the previous operation. </p>
        pub fn set_exclusive_start_shard_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_shard_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecords`.
    ///
    /// <p>Retrieves the stream records from a given shard.</p>
    /// <p>Specify a shard iterator using the <code>ShardIterator</code> parameter. The shard iterator
    /// specifies the position in the shard from which you want to start reading stream records
    /// sequentially. If there are no stream records available in the portion of the shard that the
    /// iterator points to, <code>GetRecords</code> returns an empty list. Note that it might take
    /// multiple calls to get to a portion of the shard that contains stream records.</p>
    /// <note>
    /// <p>
    /// <code>GetRecords</code> can retrieve a maximum of 1 MB of data or 1000 stream records,
    /// whichever comes first.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_records_input::Builder,
    }
    impl<C, M, R> GetRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecordsInputOperationOutputAlias,
                crate::output::GetRecordsOutput,
                crate::error::GetRecordsError,
                crate::input::GetRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.</p>
        pub fn shard_iterator(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_iterator(inp);
            self
        }
        /// <p>A shard iterator that was retrieved from a previous GetShardIterator operation. This iterator can be used to access the stream records in this shard.</p>
        pub fn set_shard_iterator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shard_iterator(input);
            self
        }
        /// <p>The maximum number of records to return from the shard. The upper limit is 1000.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of records to return from the shard. The upper limit is 1000.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetShardIterator`.
    ///
    /// <p>Returns a shard iterator. A shard iterator provides information
    /// about how to retrieve the stream records from within a shard.  Use
    /// the shard iterator in a subsequent
    /// <code>GetRecords</code> request to read the stream records
    /// from the shard.</p>
    /// <note>
    /// <p>A shard iterator expires 15 minutes after it is returned to the requester.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetShardIterator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_shard_iterator_input::Builder,
    }
    impl<C, M, R> GetShardIterator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetShardIterator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetShardIteratorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetShardIteratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetShardIteratorInputOperationOutputAlias,
                crate::output::GetShardIteratorOutput,
                crate::error::GetShardIteratorError,
                crate::input::GetShardIteratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn stream_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
        /// <p>The identifier of the shard. The iterator will be returned for this shard ID.</p>
        pub fn shard_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shard_id(inp);
            self
        }
        /// <p>The identifier of the shard. The iterator will be returned for this shard ID.</p>
        pub fn set_shard_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_shard_id(input);
            self
        }
        /// <p>Determines how the shard iterator is used to start reading stream records from the shard:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a
        /// specific sequence number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a
        /// specific sequence number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is
        /// the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention.
        /// Stream records whose age exceeds this limit are subject to removal (trimming) from the
        /// stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST</code> - Start reading just after the most recent stream record in the
        /// shard, so that you always read the most recent data in the shard.</p>
        /// </li>
        /// </ul>
        pub fn shard_iterator_type(mut self, inp: crate::model::ShardIteratorType) -> Self {
            self.inner = self.inner.shard_iterator_type(inp);
            self
        }
        /// <p>Determines how the shard iterator is used to start reading stream records from the shard:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AT_SEQUENCE_NUMBER</code> - Start reading exactly from the position denoted by a
        /// specific sequence number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AFTER_SEQUENCE_NUMBER</code> - Start reading right after the position denoted by a
        /// specific sequence number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRIM_HORIZON</code> - Start reading at the last (untrimmed) stream record, which is
        /// the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention.
        /// Stream records whose age exceeds this limit are subject to removal (trimming) from the
        /// stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST</code> - Start reading just after the most recent stream record in the
        /// shard, so that you always read the most recent data in the shard.</p>
        /// </li>
        /// </ul>
        pub fn set_shard_iterator_type(
            mut self,
            input: std::option::Option<crate::model::ShardIteratorType>,
        ) -> Self {
            self.inner = self.inner.set_shard_iterator_type(input);
            self
        }
        /// <p>The sequence number of a stream record in the shard from which to start reading.</p>
        pub fn sequence_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sequence_number(inp);
            self
        }
        /// <p>The sequence number of a stream record in the shard from which to start reading.</p>
        pub fn set_sequence_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sequence_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreams`.
    ///
    /// <p>Returns an array of stream ARNs associated with the current account and endpoint. If the
    /// <code>TableName</code> parameter is present, then <code>ListStreams</code> will return only the
    /// streams ARNs for that table.</p>
    /// <note>
    /// <p>You can call <code>ListStreams</code> at a maximum rate of 5 times per second.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_streams_input::Builder,
    }
    impl<C, M, R> ListStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamsInputOperationOutputAlias,
                crate::output::ListStreamsOutput,
                crate::error::ListStreamsError,
                crate::input::ListStreamsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>If this parameter is provided, then only the streams associated with this table name are returned.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>If this parameter is provided, then only the streams associated with this table name are returned.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The maximum number of streams to return. The upper limit is 100.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The maximum number of streams to return. The upper limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the
        /// value that was returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
        /// </p>
        pub fn exclusive_start_stream_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_stream_arn(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the first item that this operation will evaluate. Use the
        /// value that was returned for <code>LastEvaluatedStreamArn</code> in the previous operation.
        /// </p>
        pub fn set_exclusive_start_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_stream_arn(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
