// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_execute_statement_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchExecuteStatementOutput,
    crate::error::BatchExecuteStatementError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchExecuteStatementError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchExecuteStatementError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::BatchExecuteStatementError {
            meta: generic,
            kind: crate::error::BatchExecuteStatementErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::BatchExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestLimitExceeded" => crate::error::BatchExecuteStatementError {
            meta: generic,
            kind: crate::error::BatchExecuteStatementErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::BatchExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchExecuteStatementError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_execute_statement_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchExecuteStatementOutput,
    crate::error::BatchExecuteStatementError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_execute_statement_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_execute_statement(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchExecuteStatementError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchGetItemOutput, crate::error::BatchGetItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchGetItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchGetItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::BatchGetItemError {
            meta: generic,
            kind: crate::error::BatchGetItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::BatchGetItemError {
            meta: generic,
            kind: crate::error::BatchGetItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => crate::error::BatchGetItemError {
            meta: generic,
            kind: crate::error::BatchGetItemErrorKind::ProvisionedThroughputExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestLimitExceeded" => crate::error::BatchGetItemError {
            meta: generic,
            kind: crate::error::BatchGetItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::BatchGetItemError {
            meta: generic,
            kind: crate::error::BatchGetItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchGetItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchGetItemOutput, crate::error::BatchGetItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_get_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_get_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchGetItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_write_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchWriteItemOutput, crate::error::BatchWriteItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchWriteItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchWriteItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ItemCollectionSizeLimitExceededException" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::ItemCollectionSizeLimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::item_collection_size_limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_item_collection_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ProvisionedThroughputExceededException" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::ProvisionedThroughputExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestLimitExceeded" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::BatchWriteItemError {
            meta: generic,
            kind: crate::error::BatchWriteItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchWriteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BatchWriteItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_write_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchWriteItemOutput, crate::error::BatchWriteItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_write_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_write_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchWriteItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupInUseException" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::BackupInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ContinuousBackupsUnavailableException" => {
            crate::error::CreateBackupError {
                meta: generic,
                kind: crate::error::CreateBackupErrorKind::ContinuousBackupsUnavailableException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::continuous_backups_unavailable_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_continuous_backups_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerError" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableInUseException" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::TableInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableNotFoundException" => crate::error::CreateBackupError {
            meta: generic,
            kind: crate::error::CreateBackupErrorKind::TableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGlobalTableOutput, crate::error::CreateGlobalTableError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGlobalTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGlobalTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalTableAlreadyExistsException" => crate::error::CreateGlobalTableError {
            meta: generic,
            kind: crate::error::CreateGlobalTableErrorKind::GlobalTableAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_table_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_global_table_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateGlobalTableError {
            meta: generic,
            kind: crate::error::CreateGlobalTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::CreateGlobalTableError {
            meta: generic,
            kind: crate::error::CreateGlobalTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateGlobalTableError {
            meta: generic,
            kind: crate::error::CreateGlobalTableErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableNotFoundException" => crate::error::CreateGlobalTableError {
            meta: generic,
            kind: crate::error::CreateGlobalTableErrorKind::TableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGlobalTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGlobalTableOutput, crate::error::CreateGlobalTableError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_global_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_global_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGlobalTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTableOutput, crate::error::CreateTableError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::CreateTableError {
            meta: generic,
            kind: crate::error::CreateTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::CreateTableError {
            meta: generic,
            kind: crate::error::CreateTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateTableError {
            meta: generic,
            kind: crate::error::CreateTableErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::CreateTableError {
            meta: generic,
            kind: crate::error::CreateTableErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTableOutput, crate::error::CreateTableError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupInUseException" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::BackupInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupNotFoundException" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::BackupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DeleteBackupError {
            meta: generic,
            kind: crate::error::DeleteBackupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteItemOutput, crate::error::DeleteItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConditionalCheckFailedException" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::ConditionalCheckFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::conditional_check_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conditional_check_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ItemCollectionSizeLimitExceededException" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::ItemCollectionSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::item_collection_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_item_collection_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::DeleteItemError {
                meta: generic,
                kind: crate::error::DeleteItemErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionConflictException" => crate::error::DeleteItemError {
            meta: generic,
            kind: crate::error::DeleteItemErrorKind::TransactionConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteItemOutput, crate::error::DeleteItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTableOutput, crate::error::DeleteTableError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DeleteTableError {
            meta: generic,
            kind: crate::error::DeleteTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DeleteTableError {
            meta: generic,
            kind: crate::error::DeleteTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DeleteTableError {
            meta: generic,
            kind: crate::error::DeleteTableErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::DeleteTableError {
            meta: generic,
            kind: crate::error::DeleteTableErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteTableError {
            meta: generic,
            kind: crate::error::DeleteTableErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTableOutput, crate::error::DeleteTableError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBackupOutput, crate::error::DescribeBackupError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupNotFoundException" => crate::error::DescribeBackupError {
            meta: generic,
            kind: crate::error::DescribeBackupErrorKind::BackupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeBackupError {
            meta: generic,
            kind: crate::error::DescribeBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeBackupError {
            meta: generic,
            kind: crate::error::DescribeBackupErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeBackupOutput, crate::error::DescribeBackupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_continuous_backups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContinuousBackupsOutput,
    crate::error::DescribeContinuousBackupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeContinuousBackupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeContinuousBackupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeContinuousBackupsError {
            meta: generic,
            kind: crate::error::DescribeContinuousBackupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeContinuousBackupsError {
            meta: generic,
            kind: crate::error::DescribeContinuousBackupsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableNotFoundException" => crate::error::DescribeContinuousBackupsError {
            meta: generic,
            kind: crate::error::DescribeContinuousBackupsErrorKind::TableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContinuousBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeContinuousBackupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_continuous_backups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContinuousBackupsOutput,
    crate::error::DescribeContinuousBackupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_continuous_backups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_continuous_backups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeContinuousBackupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_contributor_insights_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContributorInsightsOutput,
    crate::error::DescribeContributorInsightsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeContributorInsightsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeContributorInsightsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeContributorInsightsError {
            meta: generic,
            kind: crate::error::DescribeContributorInsightsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeContributorInsightsError {
            meta: generic,
            kind: crate::error::DescribeContributorInsightsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeContributorInsightsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_contributor_insights_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContributorInsightsOutput,
    crate::error::DescribeContributorInsightsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_contributor_insights_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_contributor_insights(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeContributorInsightsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointsOutput, crate::error::DescribeEndpointsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointsError::unhandled)?;
    Err(crate::error::DescribeEndpointsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEndpointsOutput, crate::error::DescribeEndpointsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeExportOutput, crate::error::DescribeExportError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExportError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExportNotFoundException" => crate::error::DescribeExportError {
            meta: generic,
            kind: crate::error::DescribeExportErrorKind::ExportNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::export_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_export_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeExportError {
            meta: generic,
            kind: crate::error::DescribeExportErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DescribeExportError {
            meta: generic,
            kind: crate::error::DescribeExportErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeExportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeExportOutput, crate::error::DescribeExportError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_export_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_export(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalTableOutput,
    crate::error::DescribeGlobalTableError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeGlobalTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeGlobalTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalTableNotFoundException" => crate::error::DescribeGlobalTableError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableErrorKind::GlobalTableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_global_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeGlobalTableError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeGlobalTableError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeGlobalTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalTableOutput,
    crate::error::DescribeGlobalTableError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_global_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_global_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeGlobalTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_table_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalTableSettingsOutput,
    crate::error::DescribeGlobalTableSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeGlobalTableSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeGlobalTableSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalTableNotFoundException" => crate::error::DescribeGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableSettingsErrorKind::GlobalTableNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::global_table_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_global_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalServerError" => crate::error::DescribeGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableSettingsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::DescribeGlobalTableSettingsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeGlobalTableSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_table_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalTableSettingsOutput,
    crate::error::DescribeGlobalTableSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_global_table_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_global_table_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeGlobalTableSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_kinesis_streaming_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeKinesisStreamingDestinationOutput,
    crate::error::DescribeKinesisStreamingDestinationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeKinesisStreamingDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeKinesisStreamingDestinationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeKinesisStreamingDestinationError { meta: generic, kind: crate::error::DescribeKinesisStreamingDestinationErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKinesisStreamingDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEndpointException" => crate::error::DescribeKinesisStreamingDestinationError { meta: generic, kind: crate::error::DescribeKinesisStreamingDestinationErrorKind::InvalidEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKinesisStreamingDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DescribeKinesisStreamingDestinationError { meta: generic, kind: crate::error::DescribeKinesisStreamingDestinationErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeKinesisStreamingDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeKinesisStreamingDestinationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_kinesis_streaming_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeKinesisStreamingDestinationOutput,
    crate::error::DescribeKinesisStreamingDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_kinesis_streaming_destination_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_kinesis_streaming_destination(response.body().as_ref(), output).map_err(crate::error::DescribeKinesisStreamingDestinationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeLimitsOutput, crate::error::DescribeLimitsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLimitsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeLimitsError {
            meta: generic,
            kind: crate::error::DescribeLimitsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeLimitsError {
            meta: generic,
            kind: crate::error::DescribeLimitsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeLimitsOutput, crate::error::DescribeLimitsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_limits_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTableOutput, crate::error::DescribeTableError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTableError {
            meta: generic,
            kind: crate::error::DescribeTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeTableError {
            meta: generic,
            kind: crate::error::DescribeTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeTableError {
            meta: generic,
            kind: crate::error::DescribeTableErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTableOutput, crate::error::DescribeTableError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_replica_auto_scaling_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableReplicaAutoScalingOutput,
    crate::error::DescribeTableReplicaAutoScalingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTableReplicaAutoScalingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTableReplicaAutoScalingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::DescribeTableReplicaAutoScalingErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableReplicaAutoScalingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::DescribeTableReplicaAutoScalingErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableReplicaAutoScalingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeTableReplicaAutoScalingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_replica_auto_scaling_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableReplicaAutoScalingOutput,
    crate::error::DescribeTableReplicaAutoScalingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_table_replica_auto_scaling_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_table_replica_auto_scaling(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeTableReplicaAutoScalingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_time_to_live_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTimeToLiveOutput,
    crate::error::DescribeTimeToLiveError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTimeToLiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTimeToLiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeTimeToLiveError {
            meta: generic,
            kind: crate::error::DescribeTimeToLiveErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DescribeTimeToLiveError {
            meta: generic,
            kind: crate::error::DescribeTimeToLiveErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeTimeToLiveError {
            meta: generic,
            kind: crate::error::DescribeTimeToLiveErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTimeToLiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_time_to_live_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTimeToLiveOutput,
    crate::error::DescribeTimeToLiveError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_time_to_live_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_time_to_live(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTimeToLiveError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_kinesis_streaming_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableKinesisStreamingDestinationOutput,
    crate::error::DisableKinesisStreamingDestinationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisableKinesisStreamingDestinationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DisableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::DisableKinesisStreamingDestinationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::DisableKinesisStreamingDestinationError {
            meta: generic,
            kind:
                crate::error::DisableKinesisStreamingDestinationErrorKind::InvalidEndpointException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_endpoint_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::DisableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::DisableKinesisStreamingDestinationErrorKind::LimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceInUseException" => crate::error::DisableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::DisableKinesisStreamingDestinationErrorKind::ResourceInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_in_use_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DisableKinesisStreamingDestinationError {
            meta: generic,
            kind:
                crate::error::DisableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DisableKinesisStreamingDestinationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_kinesis_streaming_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableKinesisStreamingDestinationOutput,
    crate::error::DisableKinesisStreamingDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::disable_kinesis_streaming_destination_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disable_kinesis_streaming_destination(response.body().as_ref(), output).map_err(crate::error::DisableKinesisStreamingDestinationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_kinesis_streaming_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableKinesisStreamingDestinationOutput,
    crate::error::EnableKinesisStreamingDestinationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::EnableKinesisStreamingDestinationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::EnableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::EnableKinesisStreamingDestinationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::EnableKinesisStreamingDestinationError {
            meta: generic,
            kind:
                crate::error::EnableKinesisStreamingDestinationErrorKind::InvalidEndpointException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_endpoint_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::EnableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::EnableKinesisStreamingDestinationErrorKind::LimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceInUseException" => crate::error::EnableKinesisStreamingDestinationError {
            meta: generic,
            kind: crate::error::EnableKinesisStreamingDestinationErrorKind::ResourceInUseException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_in_use_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::EnableKinesisStreamingDestinationError {
            meta: generic,
            kind:
                crate::error::EnableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::resource_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::EnableKinesisStreamingDestinationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_kinesis_streaming_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableKinesisStreamingDestinationOutput,
    crate::error::EnableKinesisStreamingDestinationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::enable_kinesis_streaming_destination_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_enable_kinesis_streaming_destination(response.body().as_ref(), output).map_err(crate::error::EnableKinesisStreamingDestinationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_statement_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteStatementOutput, crate::error::ExecuteStatementError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteStatementError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecuteStatementError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConditionalCheckFailedException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::ConditionalCheckFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::conditional_check_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conditional_check_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DuplicateItemException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::DuplicateItemException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::duplicate_item_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_duplicate_item_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ItemCollectionSizeLimitExceededException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::ItemCollectionSizeLimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::item_collection_size_limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_item_collection_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ProvisionedThroughputExceededException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::ProvisionedThroughputExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RequestLimitExceeded" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionConflictException" => crate::error::ExecuteStatementError {
            meta: generic,
            kind: crate::error::ExecuteStatementErrorKind::TransactionConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteStatementError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecuteStatementError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_statement_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteStatementOutput, crate::error::ExecuteStatementError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_statement_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_execute_statement(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExecuteStatementError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_transaction_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteTransactionOutput,
    crate::error::ExecuteTransactionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteTransactionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecuteTransactionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => {
            crate::error::ExecuteTransactionError {
                meta: generic,
                kind:
                    crate::error::ExecuteTransactionErrorKind::IdempotentParameterMismatchException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InternalServerError" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::ProvisionedThroughputExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RequestLimitExceeded" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionCanceledException" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::TransactionCanceledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_canceled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_canceled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionInProgressException" => crate::error::ExecuteTransactionError {
            meta: generic,
            kind: crate::error::ExecuteTransactionErrorKind::TransactionInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteTransactionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecuteTransactionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_transaction_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExecuteTransactionOutput,
    crate::error::ExecuteTransactionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_transaction_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_execute_transaction(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExecuteTransactionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_table_to_point_in_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExportTableToPointInTimeOutput,
    crate::error::ExportTableToPointInTimeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ExportTableToPointInTimeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExportConflictException" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::ExportConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::export_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_export_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerError" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidExportTimeException" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::InvalidExportTimeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_export_time_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_export_time_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PointInTimeRecoveryUnavailableException" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::point_in_time_recovery_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_point_in_time_recovery_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TableNotFoundException" => crate::error::ExportTableToPointInTimeError { meta: generic, kind: crate::error::ExportTableToPointInTimeErrorKind::TableNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ExportTableToPointInTimeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_table_to_point_in_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ExportTableToPointInTimeOutput,
    crate::error::ExportTableToPointInTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::export_table_to_point_in_time_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_export_table_to_point_in_time(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExportTableToPointInTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetItemOutput, crate::error::GetItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::GetItemError {
            meta: generic,
            kind: crate::error::GetItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::GetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::GetItemError {
            meta: generic,
            kind: crate::error::GetItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::GetItemError {
                meta: generic,
                kind: crate::error::GetItemErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::GetItemError {
            meta: generic,
            kind: crate::error::GetItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::GetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetItemError {
            meta: generic,
            kind: crate::error::GetItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetItemOutput, crate::error::GetItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_backups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBackupsOutput, crate::error::ListBackupsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBackupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListBackupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListBackupsError {
            meta: generic,
            kind: crate::error::ListBackupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::ListBackupsError {
            meta: generic,
            kind: crate::error::ListBackupsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListBackupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListBackupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_backups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBackupsOutput, crate::error::ListBackupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_backups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_backups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBackupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_contributor_insights_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListContributorInsightsOutput,
    crate::error::ListContributorInsightsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListContributorInsightsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListContributorInsightsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListContributorInsightsError {
            meta: generic,
            kind: crate::error::ListContributorInsightsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListContributorInsightsError {
            meta: generic,
            kind: crate::error::ListContributorInsightsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListContributorInsightsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_contributor_insights_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListContributorInsightsOutput,
    crate::error::ListContributorInsightsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_contributor_insights_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_contributor_insights(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListContributorInsightsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_exports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListExportsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListExportsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListExportsError {
            meta: generic,
            kind: crate::error::ListExportsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ListExportsError {
            meta: generic,
            kind: crate::error::ListExportsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListExportsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListExportsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_exports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_exports_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_exports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListExportsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_global_tables_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGlobalTablesOutput, crate::error::ListGlobalTablesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGlobalTablesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGlobalTablesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListGlobalTablesError {
            meta: generic,
            kind: crate::error::ListGlobalTablesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListGlobalTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::ListGlobalTablesError {
            meta: generic,
            kind: crate::error::ListGlobalTablesErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListGlobalTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGlobalTablesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_global_tables_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGlobalTablesOutput, crate::error::ListGlobalTablesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_global_tables_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_global_tables(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGlobalTablesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tables_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTablesOutput, crate::error::ListTablesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTablesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTablesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListTablesError {
            meta: generic,
            kind: crate::error::ListTablesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::ListTablesError {
            meta: generic,
            kind: crate::error::ListTablesErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTablesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTablesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tables_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTablesOutput, crate::error::ListTablesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tables_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tables(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTablesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_of_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsOfResourceOutput,
    crate::error::ListTagsOfResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsOfResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsOfResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ListTagsOfResourceError {
            meta: generic,
            kind: crate::error::ListTagsOfResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsOfResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::ListTagsOfResourceError {
            meta: generic,
            kind: crate::error::ListTagsOfResourceErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsOfResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsOfResourceError {
            meta: generic,
            kind: crate::error::ListTagsOfResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsOfResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsOfResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_of_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsOfResourceOutput,
    crate::error::ListTagsOfResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_of_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_of_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsOfResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutItemOutput, crate::error::PutItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConditionalCheckFailedException" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::ConditionalCheckFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::conditional_check_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conditional_check_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ItemCollectionSizeLimitExceededException" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::ItemCollectionSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::item_collection_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_item_collection_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::PutItemError {
                meta: generic,
                kind: crate::error::PutItemErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionConflictException" => crate::error::PutItemError {
            meta: generic,
            kind: crate::error::PutItemErrorKind::TransactionConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutItemOutput, crate::error::PutItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryOutput, crate::error::QueryError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::QueryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::QueryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::QueryError {
            meta: generic,
            kind: crate::error::QueryErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::QueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::QueryError {
            meta: generic,
            kind: crate::error::QueryErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::QueryError {
                meta: generic,
                kind: crate::error::QueryErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::QueryError {
            meta: generic,
            kind: crate::error::QueryErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::QueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::QueryError {
            meta: generic,
            kind: crate::error::QueryErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::QueryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::QueryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_query_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::QueryOutput, crate::error::QueryError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::query_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_query(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::QueryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_from_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableFromBackupOutput,
    crate::error::RestoreTableFromBackupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreTableFromBackupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BackupInUseException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::BackupInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupNotFoundException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::BackupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::backup_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_backup_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableAlreadyExistsException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::TableAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::table_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableInUseException" => crate::error::RestoreTableFromBackupError {
            meta: generic,
            kind: crate::error::RestoreTableFromBackupErrorKind::TableInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestoreTableFromBackupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_from_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableFromBackupOutput,
    crate::error::RestoreTableFromBackupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_table_from_backup_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_restore_table_from_backup(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreTableFromBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_to_point_in_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableToPointInTimeOutput,
    crate::error::RestoreTableToPointInTimeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreTableToPointInTimeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEndpointException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::InvalidEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestoreTimeException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::InvalidRestoreTimeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_time_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_restore_time_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PointInTimeRecoveryUnavailableException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::point_in_time_recovery_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_point_in_time_recovery_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TableAlreadyExistsException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::TableAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::table_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TableInUseException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::TableInUseException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::table_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TableNotFoundException" => crate::error::RestoreTableToPointInTimeError { meta: generic, kind: crate::error::RestoreTableToPointInTimeErrorKind::TableNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreTableToPointInTimeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_to_point_in_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableToPointInTimeOutput,
    crate::error::RestoreTableToPointInTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_table_to_point_in_time_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_restore_table_to_point_in_time(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreTableToPointInTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_scan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ScanOutput, crate::error::ScanError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ScanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ScanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::ScanError {
            meta: generic,
            kind: crate::error::ScanErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::ScanError {
            meta: generic,
            kind: crate::error::ScanErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::ScanError {
                meta: generic,
                kind: crate::error::ScanErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::ScanError {
            meta: generic,
            kind: crate::error::ScanErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::ScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ScanError {
            meta: generic,
            kind: crate::error::ScanErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ScanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_scan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ScanOutput, crate::error::ScanError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::scan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_scan(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ScanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_transact_get_items_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TransactGetItemsOutput, crate::error::TransactGetItemsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TransactGetItemsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TransactGetItemsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::ProvisionedThroughputExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RequestLimitExceeded" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionCanceledException" => crate::error::TransactGetItemsError {
            meta: generic,
            kind: crate::error::TransactGetItemsErrorKind::TransactionCanceledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_canceled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_canceled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactGetItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TransactGetItemsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_transact_get_items_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TransactGetItemsOutput, crate::error::TransactGetItemsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::transact_get_items_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_transact_get_items(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TransactGetItemsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_transact_write_items_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TransactWriteItemsOutput,
    crate::error::TransactWriteItemsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TransactWriteItemsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TransactWriteItemsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => {
            crate::error::TransactWriteItemsError {
                meta: generic,
                kind:
                    crate::error::TransactWriteItemsErrorKind::IdempotentParameterMismatchException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InternalServerError" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::ProvisionedThroughputExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RequestLimitExceeded" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionCanceledException" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::TransactionCanceledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_canceled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_canceled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionInProgressException" => crate::error::TransactWriteItemsError {
            meta: generic,
            kind: crate::error::TransactWriteItemsErrorKind::TransactionInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TransactWriteItemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TransactWriteItemsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_transact_write_items_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TransactWriteItemsOutput,
    crate::error::TransactWriteItemsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::transact_write_items_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_transact_write_items(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TransactWriteItemsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_continuous_backups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContinuousBackupsOutput,
    crate::error::UpdateContinuousBackupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateContinuousBackupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ContinuousBackupsUnavailableException" => crate::error::UpdateContinuousBackupsError { meta: generic, kind: crate::error::UpdateContinuousBackupsErrorKind::ContinuousBackupsUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::continuous_backups_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_continuous_backups_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerError" => crate::error::UpdateContinuousBackupsError { meta: generic, kind: crate::error::UpdateContinuousBackupsErrorKind::InternalServerError({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidEndpointException" => crate::error::UpdateContinuousBackupsError { meta: generic, kind: crate::error::UpdateContinuousBackupsErrorKind::InvalidEndpointException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TableNotFoundException" => crate::error::UpdateContinuousBackupsError { meta: generic, kind: crate::error::UpdateContinuousBackupsErrorKind::TableNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateContinuousBackupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_continuous_backups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContinuousBackupsOutput,
    crate::error::UpdateContinuousBackupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_continuous_backups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_continuous_backups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateContinuousBackupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_contributor_insights_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContributorInsightsOutput,
    crate::error::UpdateContributorInsightsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContributorInsightsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateContributorInsightsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateContributorInsightsError {
            meta: generic,
            kind: crate::error::UpdateContributorInsightsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateContributorInsightsError {
            meta: generic,
            kind: crate::error::UpdateContributorInsightsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContributorInsightsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateContributorInsightsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_contributor_insights_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContributorInsightsOutput,
    crate::error::UpdateContributorInsightsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_contributor_insights_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_contributor_insights(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateContributorInsightsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_global_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGlobalTableOutput, crate::error::UpdateGlobalTableError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGlobalTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGlobalTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalTableNotFoundException" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::GlobalTableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_global_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicaAlreadyExistsException" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::ReplicaAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::replica_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replica_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicaNotFoundException" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::ReplicaNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::replica_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replica_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableNotFoundException" => crate::error::UpdateGlobalTableError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableErrorKind::TableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGlobalTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_global_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGlobalTableOutput, crate::error::UpdateGlobalTableError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_global_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_global_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGlobalTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_global_table_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGlobalTableSettingsOutput,
    crate::error::UpdateGlobalTableSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateGlobalTableSettingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalTableNotFoundException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::GlobalTableNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_table_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_global_table_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IndexNotFoundException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::IndexNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::index_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_index_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReplicaNotFoundException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::ReplicaNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::replica_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_replica_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateGlobalTableSettingsError {
            meta: generic,
            kind: crate::error::UpdateGlobalTableSettingsErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGlobalTableSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_global_table_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateGlobalTableSettingsOutput,
    crate::error::UpdateGlobalTableSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_global_table_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_global_table_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateGlobalTableSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_item_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateItemOutput, crate::error::UpdateItemError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateItemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateItemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConditionalCheckFailedException" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::ConditionalCheckFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::conditional_check_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_conditional_check_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ItemCollectionSizeLimitExceededException" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::ItemCollectionSizeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::item_collection_size_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_item_collection_size_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedThroughputExceededException" => {
            crate::error::UpdateItemError {
                meta: generic,
                kind: crate::error::UpdateItemErrorKind::ProvisionedThroughputExceededException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::provisioned_throughput_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_provisioned_throughput_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "RequestLimitExceeded" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::RequestLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TransactionConflictException" => crate::error::UpdateItemError {
            meta: generic,
            kind: crate::error::UpdateItemErrorKind::TransactionConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::transaction_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_transaction_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateItemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateItemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_item_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateItemOutput, crate::error::UpdateItemError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_item_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_item(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateItemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_table_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTableOutput, crate::error::UpdateTableError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTableError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTableError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateTableError {
            meta: generic,
            kind: crate::error::UpdateTableErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UpdateTableError {
            meta: generic,
            kind: crate::error::UpdateTableErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateTableError {
            meta: generic,
            kind: crate::error::UpdateTableErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateTableError {
            meta: generic,
            kind: crate::error::UpdateTableErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTableError {
            meta: generic,
            kind: crate::error::UpdateTableErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTableError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_table_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTableOutput, crate::error::UpdateTableError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_table_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_table(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTableError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_table_replica_auto_scaling_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTableReplicaAutoScalingOutput,
    crate::error::UpdateTableReplicaAutoScalingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateTableReplicaAutoScalingError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::UpdateTableReplicaAutoScalingErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::UpdateTableReplicaAutoScalingErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::UpdateTableReplicaAutoScalingErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTableReplicaAutoScalingError {
            meta: generic,
            kind: crate::error::UpdateTableReplicaAutoScalingErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateTableReplicaAutoScalingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_table_replica_auto_scaling_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateTableReplicaAutoScalingOutput,
    crate::error::UpdateTableReplicaAutoScalingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_table_replica_auto_scaling_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_table_replica_auto_scaling(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateTableReplicaAutoScalingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_time_to_live_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTimeToLiveOutput, crate::error::UpdateTimeToLiveError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTimeToLiveError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::UpdateTimeToLiveError {
            meta: generic,
            kind: crate::error::UpdateTimeToLiveErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointException" => crate::error::UpdateTimeToLiveError {
            meta: generic,
            kind: crate::error::UpdateTimeToLiveErrorKind::InvalidEndpointException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_endpoint_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateTimeToLiveError {
            meta: generic,
            kind: crate::error::UpdateTimeToLiveErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateTimeToLiveError {
            meta: generic,
            kind: crate::error::UpdateTimeToLiveErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateTimeToLiveError {
            meta: generic,
            kind: crate::error::UpdateTimeToLiveErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTimeToLiveError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_time_to_live_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTimeToLiveOutput, crate::error::UpdateTimeToLiveError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_time_to_live_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_time_to_live(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTimeToLiveError::unhandled)?;
        output.build()
    })
}
