// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: BatchExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchExecuteStatementErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchExecuteStatementErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchExecuteStatementError {
    fn code(&self) -> Option<&str> {
        BatchExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchExecuteStatementError {
    /// Creates a new `BatchExecuteStatementError`.
    pub fn new(kind: BatchExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::RequestLimitExceeded(_)
        )
    }
}
impl std::error::Error for BatchExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchExecuteStatementErrorKind::InternalServerError(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetItemError {
    /// Kind of error that occurred.
    pub kind: BatchGetItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            BatchGetItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            BatchGetItemErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            BatchGetItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            BatchGetItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchGetItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetItemError {
    fn code(&self) -> Option<&str> {
        BatchGetItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetItemError {
    /// Creates a new `BatchGetItemError`.
    pub fn new(kind: BatchGetItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, BatchGetItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `BatchGetItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetItemErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, BatchGetItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `BatchGetItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetItemErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for BatchGetItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetItemErrorKind::InternalServerError(_inner) => Some(_inner),
            BatchGetItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            BatchGetItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            BatchGetItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            BatchGetItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchGetItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchWriteItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchWriteItemError {
    /// Kind of error that occurred.
    pub kind: BatchWriteItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchWriteItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchWriteItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
    ItemCollectionSizeLimitExceededException(
        crate::error::ItemCollectionSizeLimitExceededException,
    ),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchWriteItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchWriteItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            BatchWriteItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            BatchWriteItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchWriteItemErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchWriteItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            BatchWriteItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BatchWriteItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchWriteItemError {
    fn code(&self) -> Option<&str> {
        BatchWriteItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchWriteItemError {
    /// Creates a new `BatchWriteItemError`.
    pub fn new(kind: BatchWriteItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchWriteItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchWriteItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchWriteItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchWriteItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, BatchWriteItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteItemErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::ItemCollectionSizeLimitExceededException`.
    pub fn is_item_collection_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteItemErrorKind::ItemCollectionSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, BatchWriteItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `BatchWriteItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchWriteItemErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for BatchWriteItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchWriteItemErrorKind::InternalServerError(_inner) => Some(_inner),
            BatchWriteItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            BatchWriteItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            BatchWriteItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            BatchWriteItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            BatchWriteItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BatchWriteItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBackupError {
    /// Kind of error that occurred.
    pub kind: CreateBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBackupErrorKind {
    /// <p>There is another ongoing conflicting backup control plane operation on the table. The backup is either being created, deleted or restored to a table.</p>
    BackupInUseException(crate::error::BackupInUseException),
    /// <p>Backups have not yet been enabled for this table.</p>
    ContinuousBackupsUnavailableException(crate::error::ContinuousBackupsUnavailableException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A target table with the specified name is either being created or deleted. </p>
    TableInUseException(crate::error::TableInUseException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBackupErrorKind::BackupInUseException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::ContinuousBackupsUnavailableException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::TableInUseException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            CreateBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBackupError {
    fn code(&self) -> Option<&str> {
        CreateBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBackupError {
    /// Creates a new `CreateBackupError`.
    pub fn new(kind: CreateBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::BackupInUseException`.
    pub fn is_backup_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::BackupInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::ContinuousBackupsUnavailableException`.
    pub fn is_continuous_backups_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupErrorKind::ContinuousBackupsUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBackupErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::TableInUseException`.
    pub fn is_table_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::TableInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateBackupErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBackupErrorKind::TableNotFoundException(_))
    }
}
impl std::error::Error for CreateBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBackupErrorKind::BackupInUseException(_inner) => Some(_inner),
            CreateBackupErrorKind::ContinuousBackupsUnavailableException(_inner) => Some(_inner),
            CreateBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateBackupErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            CreateBackupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBackupErrorKind::TableInUseException(_inner) => Some(_inner),
            CreateBackupErrorKind::TableNotFoundException(_inner) => Some(_inner),
            CreateBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGlobalTableError {
    /// Kind of error that occurred.
    pub kind: CreateGlobalTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGlobalTableErrorKind {
    /// <p>The specified global table already exists.</p>
    GlobalTableAlreadyExistsException(crate::error::GlobalTableAlreadyExistsException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGlobalTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGlobalTableErrorKind::GlobalTableAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateGlobalTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateGlobalTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            CreateGlobalTableErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGlobalTableErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            CreateGlobalTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGlobalTableError {
    fn code(&self) -> Option<&str> {
        CreateGlobalTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGlobalTableError {
    /// Creates a new `CreateGlobalTableError`.
    pub fn new(kind: CreateGlobalTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGlobalTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGlobalTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGlobalTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGlobalTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGlobalTableErrorKind::GlobalTableAlreadyExistsException`.
    pub fn is_global_table_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalTableErrorKind::GlobalTableAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalTableErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalTableErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalTableErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalTableErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalTableErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateGlobalTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGlobalTableErrorKind::GlobalTableAlreadyExistsException(_inner) => Some(_inner),
            CreateGlobalTableErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateGlobalTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            CreateGlobalTableErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGlobalTableErrorKind::TableNotFoundException(_inner) => Some(_inner),
            CreateGlobalTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTableError {
    /// Kind of error that occurred.
    pub kind: CreateTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTableErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTableError {
    fn code(&self) -> Option<&str> {
        CreateTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTableError {
    /// Creates a new `CreateTableError`.
    pub fn new(kind: CreateTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::ResourceInUseException(_))
    }
}
impl std::error::Error for CreateTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTableErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            CreateTableErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateTableErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBackupError {
    /// Kind of error that occurred.
    pub kind: DeleteBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBackupErrorKind {
    /// <p>There is another ongoing conflicting backup control plane operation on the table. The backup is either being created, deleted or restored to a table.</p>
    BackupInUseException(crate::error::BackupInUseException),
    /// <p>Backup not found for the given BackupARN. </p>
    BackupNotFoundException(crate::error::BackupNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBackupErrorKind::BackupInUseException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::BackupNotFoundException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBackupError {
    fn code(&self) -> Option<&str> {
        DeleteBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBackupError {
    /// Creates a new `DeleteBackupError`.
    pub fn new(kind: DeleteBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupInUseException`.
    pub fn is_backup_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::BackupInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::BackupNotFoundException`.
    pub fn is_backup_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupErrorKind::BackupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBackupErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBackupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteBackupErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for DeleteBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBackupErrorKind::BackupInUseException(_inner) => Some(_inner),
            DeleteBackupErrorKind::BackupNotFoundException(_inner) => Some(_inner),
            DeleteBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteBackupErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DeleteBackupErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteItemError {
    /// Kind of error that occurred.
    pub kind: DeleteItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteItemErrorKind {
    /// <p>A condition specified in the operation could not be evaluated.</p>
    ConditionalCheckFailedException(crate::error::ConditionalCheckFailedException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
    ItemCollectionSizeLimitExceededException(
        crate::error::ItemCollectionSizeLimitExceededException,
    ),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Operation was rejected because there is an ongoing transaction for the item.</p>
    TransactionConflictException(crate::error::TransactionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteItemErrorKind::ConditionalCheckFailedException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::TransactionConflictException(_inner) => _inner.fmt(f),
            DeleteItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteItemError {
    fn code(&self) -> Option<&str> {
        DeleteItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteItemError {
    /// Creates a new `DeleteItemError`.
    pub fn new(kind: DeleteItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::ConditionalCheckFailedException`.
    pub fn is_conditional_check_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteItemErrorKind::ConditionalCheckFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, DeleteItemErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::ItemCollectionSizeLimitExceededException`.
    pub fn is_item_collection_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteItemErrorKind::ItemCollectionSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, DeleteItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteItemErrorKind::TransactionConflictException`.
    pub fn is_transaction_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteItemErrorKind::TransactionConflictException(_)
        )
    }
}
impl std::error::Error for DeleteItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteItemErrorKind::ConditionalCheckFailedException(_inner) => Some(_inner),
            DeleteItemErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DeleteItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => Some(_inner),
            DeleteItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            DeleteItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            DeleteItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteItemErrorKind::TransactionConflictException(_inner) => Some(_inner),
            DeleteItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTableError {
    /// Kind of error that occurred.
    pub kind: DeleteTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTableErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTableError {
    fn code(&self) -> Option<&str> {
        DeleteTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTableError {
    /// Creates a new `DeleteTableError`.
    pub fn new(kind: DeleteTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteTableErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteTableErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteTableErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTableErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DeleteTableErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteTableErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteTableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupErrorKind {
    /// <p>Backup not found for the given BackupARN. </p>
    BackupNotFoundException(crate::error::BackupNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupErrorKind::BackupNotFoundException(_inner) => _inner.fmt(f),
            DescribeBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeBackupErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupError {
    fn code(&self) -> Option<&str> {
        DescribeBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupError {
    /// Creates a new `DescribeBackupError`.
    pub fn new(kind: DescribeBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupErrorKind::BackupNotFoundException`.
    pub fn is_backup_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupErrorKind::BackupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeBackupErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupErrorKind::BackupNotFoundException(_inner) => Some(_inner),
            DescribeBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeBackupErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContinuousBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContinuousBackupsError {
    /// Kind of error that occurred.
    pub kind: DescribeContinuousBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContinuousBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContinuousBackupsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContinuousBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContinuousBackupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeContinuousBackupsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeContinuousBackupsErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            DescribeContinuousBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContinuousBackupsError {
    fn code(&self) -> Option<&str> {
        DescribeContinuousBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContinuousBackupsError {
    /// Creates a new `DescribeContinuousBackupsError`.
    pub fn new(kind: DescribeContinuousBackupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContinuousBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContinuousBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContinuousBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContinuousBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContinuousBackupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContinuousBackupsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContinuousBackupsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContinuousBackupsErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContinuousBackupsErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContinuousBackupsErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeContinuousBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContinuousBackupsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeContinuousBackupsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeContinuousBackupsErrorKind::TableNotFoundException(_inner) => Some(_inner),
            DescribeContinuousBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContributorInsightsError {
    /// Kind of error that occurred.
    pub kind: DescribeContributorInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContributorInsightsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContributorInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContributorInsightsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeContributorInsightsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeContributorInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContributorInsightsError {
    fn code(&self) -> Option<&str> {
        DescribeContributorInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContributorInsightsError {
    /// Creates a new `DescribeContributorInsightsError`.
    pub fn new(kind: DescribeContributorInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContributorInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContributorInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContributorInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContributorInsightsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContributorInsightsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContributorInsightsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContributorInsightsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContributorInsightsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeContributorInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContributorInsightsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeContributorInsightsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeContributorInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointsError {
    /// Creates a new `DescribeEndpointsError`.
    pub fn new(kind: DescribeEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExportError {
    /// Kind of error that occurred.
    pub kind: DescribeExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExportErrorKind {
    /// <p>The specified export was not found.</p>
    ExportNotFoundException(crate::error::ExportNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExportErrorKind::ExportNotFoundException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExportError {
    fn code(&self) -> Option<&str> {
        DescribeExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExportError {
    /// Creates a new `DescribeExportError`.
    pub fn new(kind: DescribeExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::ExportNotFoundException`.
    pub fn is_export_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportErrorKind::ExportNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeExportErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for DescribeExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExportErrorKind::ExportNotFoundException(_inner) => Some(_inner),
            DescribeExportErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeExportErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGlobalTableError {
    /// Kind of error that occurred.
    pub kind: DescribeGlobalTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGlobalTableErrorKind {
    /// <p>The specified global table does not exist.</p>
    GlobalTableNotFoundException(crate::error::GlobalTableNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGlobalTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGlobalTableErrorKind::GlobalTableNotFoundException(_inner) => _inner.fmt(f),
            DescribeGlobalTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeGlobalTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeGlobalTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGlobalTableError {
    fn code(&self) -> Option<&str> {
        DescribeGlobalTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGlobalTableError {
    /// Creates a new `DescribeGlobalTableError`.
    pub fn new(kind: DescribeGlobalTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGlobalTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGlobalTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGlobalTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGlobalTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableErrorKind::GlobalTableNotFoundException`.
    pub fn is_global_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableErrorKind::GlobalTableNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeGlobalTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGlobalTableErrorKind::GlobalTableNotFoundException(_inner) => Some(_inner),
            DescribeGlobalTableErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeGlobalTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeGlobalTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGlobalTableSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGlobalTableSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeGlobalTableSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGlobalTableSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGlobalTableSettingsErrorKind {
    /// <p>The specified global table does not exist.</p>
    GlobalTableNotFoundException(crate::error::GlobalTableNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGlobalTableSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeGlobalTableSettingsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeGlobalTableSettingsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeGlobalTableSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGlobalTableSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeGlobalTableSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGlobalTableSettingsError {
    /// Creates a new `DescribeGlobalTableSettingsError`.
    pub fn new(kind: DescribeGlobalTableSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGlobalTableSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGlobalTableSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGlobalTableSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGlobalTableSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableSettingsErrorKind::GlobalTableNotFoundException`.
    pub fn is_global_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableSettingsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableSettingsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGlobalTableSettingsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalTableSettingsErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeGlobalTableSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeGlobalTableSettingsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeGlobalTableSettingsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeGlobalTableSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeKinesisStreamingDestinationError {
    /// Kind of error that occurred.
    pub kind: DescribeKinesisStreamingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeKinesisStreamingDestinationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeKinesisStreamingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DescribeKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeKinesisStreamingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeKinesisStreamingDestinationError {
    fn code(&self) -> Option<&str> {
        DescribeKinesisStreamingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeKinesisStreamingDestinationError {
    /// Creates a new `DescribeKinesisStreamingDestinationError`.
    pub fn new(
        kind: DescribeKinesisStreamingDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeKinesisStreamingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeKinesisStreamingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeKinesisStreamingDestinationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKinesisStreamingDestinationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKinesisStreamingDestinationErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKinesisStreamingDestinationErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeKinesisStreamingDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeKinesisStreamingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DescribeKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                Some(_inner)
            }
            DescribeKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeKinesisStreamingDestinationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLimitsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLimitsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeLimitsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLimitsError {
    /// Creates a new `DescribeLimitsError`.
    pub fn new(kind: DescribeLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLimitsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLimitsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeLimitsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeLimitsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLimitsErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for DescribeLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLimitsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeLimitsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTableError {
    /// Kind of error that occurred.
    pub kind: DescribeTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTableErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTableError {
    fn code(&self) -> Option<&str> {
        DescribeTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTableError {
    /// Creates a new `DescribeTableError`.
    pub fn new(kind: DescribeTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeTableErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTableErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeTableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTableReplicaAutoScaling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTableReplicaAutoScalingError {
    /// Kind of error that occurred.
    pub kind: DescribeTableReplicaAutoScalingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTableReplicaAutoScaling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTableReplicaAutoScalingErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTableReplicaAutoScalingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTableReplicaAutoScalingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeTableReplicaAutoScalingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTableReplicaAutoScalingError {
    fn code(&self) -> Option<&str> {
        DescribeTableReplicaAutoScalingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTableReplicaAutoScalingError {
    /// Creates a new `DescribeTableReplicaAutoScalingError`.
    pub fn new(
        kind: DescribeTableReplicaAutoScalingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTableReplicaAutoScalingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTableReplicaAutoScalingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTableReplicaAutoScalingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTableReplicaAutoScalingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTableReplicaAutoScalingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableReplicaAutoScalingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableReplicaAutoScalingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTableReplicaAutoScalingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTableReplicaAutoScalingErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeTableReplicaAutoScalingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTimeToLive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTimeToLiveError {
    /// Kind of error that occurred.
    pub kind: DescribeTimeToLiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTimeToLive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTimeToLiveErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTimeToLiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTimeToLiveErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTimeToLiveErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            DescribeTimeToLiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTimeToLiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTimeToLiveError {
    fn code(&self) -> Option<&str> {
        DescribeTimeToLiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTimeToLiveError {
    /// Creates a new `DescribeTimeToLiveError`.
    pub fn new(kind: DescribeTimeToLiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTimeToLiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTimeToLiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTimeToLiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTimeToLiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTimeToLiveErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTimeToLiveErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTimeToLiveErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTimeToLiveErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTimeToLiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTimeToLiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTimeToLiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTimeToLiveErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTimeToLiveErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            DescribeTimeToLiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTimeToLiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableKinesisStreamingDestinationError {
    /// Kind of error that occurred.
    pub kind: DisableKinesisStreamingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableKinesisStreamingDestinationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableKinesisStreamingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DisableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                _inner.fmt(f)
            }
            DisableKinesisStreamingDestinationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DisableKinesisStreamingDestinationErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            DisableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisableKinesisStreamingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableKinesisStreamingDestinationError {
    fn code(&self) -> Option<&str> {
        DisableKinesisStreamingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableKinesisStreamingDestinationError {
    /// Creates a new `DisableKinesisStreamingDestinationError`.
    pub fn new(
        kind: DisableKinesisStreamingDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableKinesisStreamingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableKinesisStreamingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableKinesisStreamingDestinationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DisableKinesisStreamingDestinationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKinesisStreamingDestinationErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKinesisStreamingDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKinesisStreamingDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKinesisStreamingDestinationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKinesisStreamingDestinationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableKinesisStreamingDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableKinesisStreamingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => {
                Some(_inner)
            }
            DisableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                Some(_inner)
            }
            DisableKinesisStreamingDestinationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            DisableKinesisStreamingDestinationErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            DisableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisableKinesisStreamingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableKinesisStreamingDestinationError {
    /// Kind of error that occurred.
    pub kind: EnableKinesisStreamingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableKinesisStreamingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableKinesisStreamingDestinationErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableKinesisStreamingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            EnableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                _inner.fmt(f)
            }
            EnableKinesisStreamingDestinationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            EnableKinesisStreamingDestinationErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            EnableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            EnableKinesisStreamingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableKinesisStreamingDestinationError {
    fn code(&self) -> Option<&str> {
        EnableKinesisStreamingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableKinesisStreamingDestinationError {
    /// Creates a new `EnableKinesisStreamingDestinationError`.
    pub fn new(
        kind: EnableKinesisStreamingDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableKinesisStreamingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableKinesisStreamingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableKinesisStreamingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableKinesisStreamingDestinationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            EnableKinesisStreamingDestinationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKinesisStreamingDestinationErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKinesisStreamingDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKinesisStreamingDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKinesisStreamingDestinationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKinesisStreamingDestinationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableKinesisStreamingDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableKinesisStreamingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableKinesisStreamingDestinationErrorKind::InternalServerError(_inner) => Some(_inner),
            EnableKinesisStreamingDestinationErrorKind::InvalidEndpointException(_inner) => {
                Some(_inner)
            }
            EnableKinesisStreamingDestinationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            EnableKinesisStreamingDestinationErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            EnableKinesisStreamingDestinationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            EnableKinesisStreamingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: ExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteStatementErrorKind {
    /// <p>A condition specified in the operation could not be evaluated.</p>
    ConditionalCheckFailedException(crate::error::ConditionalCheckFailedException),
    /// <p> There was an attempt to insert an item with the same primary key as an item that already exists in the DynamoDB table.</p>
    DuplicateItemException(crate::error::DuplicateItemException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
    ItemCollectionSizeLimitExceededException(
        crate::error::ItemCollectionSizeLimitExceededException,
    ),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Operation was rejected because there is an ongoing transaction for the item.</p>
    TransactionConflictException(crate::error::TransactionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteStatementErrorKind::ConditionalCheckFailedException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::DuplicateItemException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ItemCollectionSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteStatementErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteStatementErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::TransactionConflictException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteStatementError {
    fn code(&self) -> Option<&str> {
        ExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteStatementError {
    /// Creates a new `ExecuteStatementError`.
    pub fn new(kind: ExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ConditionalCheckFailedException`.
    pub fn is_conditional_check_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ConditionalCheckFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::DuplicateItemException`.
    pub fn is_duplicate_item_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::DuplicateItemException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ItemCollectionSizeLimitExceededException`.
    pub fn is_item_collection_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ItemCollectionSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::RequestLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::TransactionConflictException`.
    pub fn is_transaction_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::TransactionConflictException(_)
        )
    }
}
impl std::error::Error for ExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteStatementErrorKind::ConditionalCheckFailedException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::DuplicateItemException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::InternalServerError(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ItemCollectionSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            ExecuteStatementErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            ExecuteStatementErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::TransactionConflictException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteTransactionError {
    /// Kind of error that occurred.
    pub kind: ExecuteTransactionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteTransactionErrorKind {
    /// <p>DynamoDB rejected the request because you retried a request with a different payload but with an idempotent token that was already used.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The entire transaction request was canceled.</p>
    /// <p>DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>A condition in one of the condition expressions is not met.</p> </li>
    /// <li> <p>A table in the <code>TransactWriteItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>More than one action in the <code>TransactWriteItems</code> operation targets the same item.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul>
    /// <p>DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code> request. In this case the <code>TransactGetItems</code> operation fails with a <code>TransactionCanceledException</code>.</p> </li>
    /// <li> <p>A table in the <code>TransactGetItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul> <note>
    /// <p>If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. This property is not set for other languages. Transaction cancellation reasons are ordered in the order of requested items, if an item has no error it will have <code>NONE</code> code and <code>Null</code> message.</p>
    /// </note>
    /// <p>Cancellation reason codes and possible error messages:</p>
    /// <ul>
    /// <li> <p>No Errors:</p>
    /// <ul>
    /// <li> <p>Code: <code>NONE</code> </p> </li>
    /// <li> <p>Message: <code>null</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Conditional Check Failed:</p>
    /// <ul>
    /// <li> <p>Code: <code>ConditionalCheckFailed</code> </p> </li>
    /// <li> <p>Message: The conditional request failed. </p> </li>
    /// </ul> </li>
    /// <li> <p>Item Collection Size Limit Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ItemCollectionSizeLimitExceeded</code> </p> </li>
    /// <li> <p>Message: Collection size exceeded.</p> </li>
    /// </ul> </li>
    /// <li> <p>Transaction Conflict:</p>
    /// <ul>
    /// <li> <p>Code: <code>TransactionConflict</code> </p> </li>
    /// <li> <p>Message: Transaction is ongoing for the item.</p> </li>
    /// </ul> </li>
    /// <li> <p>Provisioned Throughput Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ProvisionedThroughputExceeded</code> </p> </li>
    /// <li> <p>Messages:</p>
    /// <ul>
    /// <li> <p>The level of configured provisioned throughput for the table was exceeded. Consider increasing your provisioning level with the UpdateTable API.</p> <note>
    /// <p>This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.</p>
    /// </note> </li>
    /// <li> <p>The level of configured provisioned throughput for one or more global secondary indexes of the table was exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes with the UpdateTable API.</p> <note>
    /// <p>This message is returned when provisioned throughput is exceeded is on a provisioned GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Throttling Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ThrottlingError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your table or index so please try again shortly. If exceptions persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.</p> <note>
    /// <p>This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically scaling the table.</p>
    /// </note> </li>
    /// <li> <p>Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is automatically scaling your index so please try again shortly.</p> <note>
    /// <p>This message is returned when when writes get throttled on an On-Demand GSI as DynamoDB is automatically scaling the GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Validation Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ValidationError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>One or more parameter values were invalid.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key beyond allowed size limits.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key to unsupported type.</p> </li>
    /// <li> <p>An operand in the update expression has an incorrect data type.</p> </li>
    /// <li> <p>Item size to update has exceeded the maximum allowed size.</p> </li>
    /// <li> <p>Number overflow. Attempting to store a number with magnitude larger than supported range.</p> </li>
    /// <li> <p>Type mismatch for attribute to update.</p> </li>
    /// <li> <p>Nesting Levels have exceeded supported limits.</p> </li>
    /// <li> <p>The document path provided in the update expression is invalid for update.</p> </li>
    /// <li> <p>The provided expression refers to an attribute that does not exist in the item.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// </ul>
    TransactionCanceledException(crate::error::TransactionCanceledException),
    /// <p>The transaction with the given request token is already in progress.</p>
    TransactionInProgressException(crate::error::TransactionInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteTransactionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteTransactionErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteTransactionErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ExecuteTransactionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            ExecuteTransactionErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            ExecuteTransactionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExecuteTransactionErrorKind::TransactionCanceledException(_inner) => _inner.fmt(f),
            ExecuteTransactionErrorKind::TransactionInProgressException(_inner) => _inner.fmt(f),
            ExecuteTransactionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteTransactionError {
    fn code(&self) -> Option<&str> {
        ExecuteTransactionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteTransactionError {
    /// Creates a new `ExecuteTransactionError`.
    pub fn new(kind: ExecuteTransactionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteTransactionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteTransactionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteTransactionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteTransactionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::RequestLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::TransactionCanceledException`.
    pub fn is_transaction_canceled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::TransactionCanceledException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteTransactionErrorKind::TransactionInProgressException`.
    pub fn is_transaction_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteTransactionErrorKind::TransactionInProgressException(_)
        )
    }
}
impl std::error::Error for ExecuteTransactionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteTransactionErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            ExecuteTransactionErrorKind::InternalServerError(_inner) => Some(_inner),
            ExecuteTransactionErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            ExecuteTransactionErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            ExecuteTransactionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExecuteTransactionErrorKind::TransactionCanceledException(_inner) => Some(_inner),
            ExecuteTransactionErrorKind::TransactionInProgressException(_inner) => Some(_inner),
            ExecuteTransactionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportTableToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportTableToPointInTimeError {
    /// Kind of error that occurred.
    pub kind: ExportTableToPointInTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportTableToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportTableToPointInTimeErrorKind {
    /// <p>There was a conflict when writing to the specified S3 bucket.</p>
    ExportConflictException(crate::error::ExportConflictException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The specified <code>ExportTime</code> is outside of the point in time recovery window.</p>
    InvalidExportTimeException(crate::error::InvalidExportTimeException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Point in time recovery has not yet been enabled for this source table.</p>
    PointInTimeRecoveryUnavailableException(crate::error::PointInTimeRecoveryUnavailableException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportTableToPointInTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportTableToPointInTimeErrorKind::ExportConflictException(_inner) => _inner.fmt(f),
            ExportTableToPointInTimeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ExportTableToPointInTimeErrorKind::InvalidExportTimeException(_inner) => _inner.fmt(f),
            ExportTableToPointInTimeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ExportTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ExportTableToPointInTimeErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            ExportTableToPointInTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportTableToPointInTimeError {
    fn code(&self) -> Option<&str> {
        ExportTableToPointInTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportTableToPointInTimeError {
    /// Creates a new `ExportTableToPointInTimeError`.
    pub fn new(kind: ExportTableToPointInTimeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportTableToPointInTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportTableToPointInTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportTableToPointInTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportTableToPointInTimeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::ExportConflictException`.
    pub fn is_export_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::ExportConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::InvalidExportTimeException`.
    pub fn is_invalid_export_time_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::InvalidExportTimeException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException`.
    pub fn is_point_in_time_recovery_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportTableToPointInTimeErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportTableToPointInTimeErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for ExportTableToPointInTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportTableToPointInTimeErrorKind::ExportConflictException(_inner) => Some(_inner),
            ExportTableToPointInTimeErrorKind::InternalServerError(_inner) => Some(_inner),
            ExportTableToPointInTimeErrorKind::InvalidExportTimeException(_inner) => Some(_inner),
            ExportTableToPointInTimeErrorKind::LimitExceededException(_inner) => Some(_inner),
            ExportTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_inner) => {
                Some(_inner)
            }
            ExportTableToPointInTimeErrorKind::TableNotFoundException(_inner) => Some(_inner),
            ExportTableToPointInTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetItemError {
    /// Kind of error that occurred.
    pub kind: GetItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetItemErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            GetItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            GetItemErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            GetItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            GetItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetItemError {
    fn code(&self) -> Option<&str> {
        GetItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetItemError {
    /// Creates a new `GetItemError`.
    pub fn new(kind: GetItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, GetItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `GetItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, GetItemErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `GetItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, GetItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `GetItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetItemErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for GetItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetItemErrorKind::InternalServerError(_inner) => Some(_inner),
            GetItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            GetItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            GetItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            GetItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBackupsError {
    /// Kind of error that occurred.
    pub kind: ListBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBackupsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBackupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListBackupsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            ListBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBackupsError {
    fn code(&self) -> Option<&str> {
        ListBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBackupsError {
    /// Creates a new `ListBackupsError`.
    pub fn new(kind: ListBackupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBackupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListBackupsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListBackupsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBackupsErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for ListBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBackupsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListBackupsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            ListBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContributorInsightsError {
    /// Kind of error that occurred.
    pub kind: ListContributorInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContributorInsightsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContributorInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContributorInsightsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListContributorInsightsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListContributorInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContributorInsightsError {
    fn code(&self) -> Option<&str> {
        ListContributorInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContributorInsightsError {
    /// Creates a new `ListContributorInsightsError`.
    pub fn new(kind: ListContributorInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContributorInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContributorInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContributorInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContributorInsightsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContributorInsightsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListContributorInsightsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListContributorInsightsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContributorInsightsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListContributorInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContributorInsightsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListContributorInsightsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListContributorInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExportsError {
    /// Kind of error that occurred.
    pub kind: ListExportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExportsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExportsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListExportsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListExportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExportsError {
    fn code(&self) -> Option<&str> {
        ListExportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExportsError {
    /// Creates a new `ListExportsError`.
    pub fn new(kind: ListExportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExportsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListExportsErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListExportsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, ListExportsErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for ListExportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExportsErrorKind::InternalServerError(_inner) => Some(_inner),
            ListExportsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListExportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGlobalTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGlobalTablesError {
    /// Kind of error that occurred.
    pub kind: ListGlobalTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGlobalTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGlobalTablesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGlobalTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGlobalTablesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListGlobalTablesErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            ListGlobalTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGlobalTablesError {
    fn code(&self) -> Option<&str> {
        ListGlobalTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGlobalTablesError {
    /// Creates a new `ListGlobalTablesError`.
    pub fn new(kind: ListGlobalTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGlobalTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGlobalTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGlobalTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGlobalTablesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGlobalTablesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListGlobalTablesErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListGlobalTablesErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGlobalTablesErrorKind::InvalidEndpointException(_)
        )
    }
}
impl std::error::Error for ListGlobalTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGlobalTablesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListGlobalTablesErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            ListGlobalTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTablesError {
    /// Kind of error that occurred.
    pub kind: ListTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTablesErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTablesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTablesErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            ListTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTablesError {
    fn code(&self) -> Option<&str> {
        ListTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTablesError {
    /// Creates a new `ListTablesError`.
    pub fn new(kind: ListTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTablesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTablesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ListTablesErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ListTablesErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, ListTablesErrorKind::InvalidEndpointException(_))
    }
}
impl std::error::Error for ListTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTablesErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTablesErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            ListTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsOfResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsOfResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsOfResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsOfResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsOfResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsOfResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsOfResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsOfResourceErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            ListTagsOfResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsOfResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsOfResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsOfResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsOfResourceError {
    /// Creates a new `ListTagsOfResourceError`.
    pub fn new(kind: ListTagsOfResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsOfResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsOfResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsOfResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsOfResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsOfResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsOfResourceErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsOfResourceErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsOfResourceErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsOfResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsOfResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsOfResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsOfResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsOfResourceErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            ListTagsOfResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsOfResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutItemError {
    /// Kind of error that occurred.
    pub kind: PutItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutItemErrorKind {
    /// <p>A condition specified in the operation could not be evaluated.</p>
    ConditionalCheckFailedException(crate::error::ConditionalCheckFailedException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
    ItemCollectionSizeLimitExceededException(
        crate::error::ItemCollectionSizeLimitExceededException,
    ),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Operation was rejected because there is an ongoing transaction for the item.</p>
    TransactionConflictException(crate::error::TransactionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutItemErrorKind::ConditionalCheckFailedException(_inner) => _inner.fmt(f),
            PutItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            PutItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutItemErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            PutItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            PutItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutItemErrorKind::TransactionConflictException(_inner) => _inner.fmt(f),
            PutItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutItemError {
    fn code(&self) -> Option<&str> {
        PutItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutItemError {
    /// Creates a new `PutItemError`.
    pub fn new(kind: PutItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::ConditionalCheckFailedException`.
    pub fn is_conditional_check_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutItemErrorKind::ConditionalCheckFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, PutItemErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::ItemCollectionSizeLimitExceededException`.
    pub fn is_item_collection_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutItemErrorKind::ItemCollectionSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, PutItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutItemErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutItemErrorKind::TransactionConflictException`.
    pub fn is_transaction_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutItemErrorKind::TransactionConflictException(_)
        )
    }
}
impl std::error::Error for PutItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutItemErrorKind::ConditionalCheckFailedException(_inner) => Some(_inner),
            PutItemErrorKind::InternalServerError(_inner) => Some(_inner),
            PutItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            PutItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => Some(_inner),
            PutItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            PutItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            PutItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutItemErrorKind::TransactionConflictException(_inner) => Some(_inner),
            PutItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Query` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct QueryError {
    /// Kind of error that occurred.
    pub kind: QueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Query` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum QueryErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for QueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            QueryErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            QueryErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            QueryErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            QueryErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            QueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            QueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for QueryError {
    fn code(&self) -> Option<&str> {
        QueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl QueryError {
    /// Creates a new `QueryError`.
    pub fn new(kind: QueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `QueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: QueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `QueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: QueryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `QueryErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            QueryErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `QueryErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `QueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, QueryErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for QueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            QueryErrorKind::InternalServerError(_inner) => Some(_inner),
            QueryErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            QueryErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            QueryErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            QueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            QueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreTableFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreTableFromBackupError {
    /// Kind of error that occurred.
    pub kind: RestoreTableFromBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreTableFromBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreTableFromBackupErrorKind {
    /// <p>There is another ongoing conflicting backup control plane operation on the table. The backup is either being created, deleted or restored to a table.</p>
    BackupInUseException(crate::error::BackupInUseException),
    /// <p>Backup not found for the given BackupARN. </p>
    BackupNotFoundException(crate::error::BackupNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A target table with the specified name already exists. </p>
    TableAlreadyExistsException(crate::error::TableAlreadyExistsException),
    /// <p>A target table with the specified name is either being created or deleted. </p>
    TableInUseException(crate::error::TableInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreTableFromBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreTableFromBackupErrorKind::BackupInUseException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::BackupNotFoundException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::TableAlreadyExistsException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::TableInUseException(_inner) => _inner.fmt(f),
            RestoreTableFromBackupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreTableFromBackupError {
    fn code(&self) -> Option<&str> {
        RestoreTableFromBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreTableFromBackupError {
    /// Creates a new `RestoreTableFromBackupError`.
    pub fn new(kind: RestoreTableFromBackupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreTableFromBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreTableFromBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreTableFromBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreTableFromBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::BackupInUseException`.
    pub fn is_backup_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::BackupInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::BackupNotFoundException`.
    pub fn is_backup_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::BackupNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::TableAlreadyExistsException`.
    pub fn is_table_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::TableAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromBackupErrorKind::TableInUseException`.
    pub fn is_table_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromBackupErrorKind::TableInUseException(_)
        )
    }
}
impl std::error::Error for RestoreTableFromBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreTableFromBackupErrorKind::BackupInUseException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::BackupNotFoundException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::InternalServerError(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::LimitExceededException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::TableAlreadyExistsException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::TableInUseException(_inner) => Some(_inner),
            RestoreTableFromBackupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreTableToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreTableToPointInTimeError {
    /// Kind of error that occurred.
    pub kind: RestoreTableToPointInTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreTableToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreTableToPointInTimeErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>An invalid restore time was specified. RestoreDateTime must be between EarliestRestorableDateTime and LatestRestorableDateTime.</p>
    InvalidRestoreTimeException(crate::error::InvalidRestoreTimeException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Point in time recovery has not yet been enabled for this source table.</p>
    PointInTimeRecoveryUnavailableException(crate::error::PointInTimeRecoveryUnavailableException),
    /// <p>A target table with the specified name already exists. </p>
    TableAlreadyExistsException(crate::error::TableAlreadyExistsException),
    /// <p>A target table with the specified name is either being created or deleted. </p>
    TableInUseException(crate::error::TableInUseException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreTableToPointInTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreTableToPointInTimeErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            RestoreTableToPointInTimeErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            RestoreTableToPointInTimeErrorKind::InvalidRestoreTimeException(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableToPointInTimeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RestoreTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableToPointInTimeErrorKind::TableAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableToPointInTimeErrorKind::TableInUseException(_inner) => _inner.fmt(f),
            RestoreTableToPointInTimeErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            RestoreTableToPointInTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreTableToPointInTimeError {
    fn code(&self) -> Option<&str> {
        RestoreTableToPointInTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreTableToPointInTimeError {
    /// Creates a new `RestoreTableToPointInTimeError`.
    pub fn new(kind: RestoreTableToPointInTimeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreTableToPointInTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreTableToPointInTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreTableToPointInTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreTableToPointInTimeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::InvalidRestoreTimeException`.
    pub fn is_invalid_restore_time_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::InvalidRestoreTimeException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException`.
    pub fn is_point_in_time_recovery_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::TableAlreadyExistsException`.
    pub fn is_table_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::TableAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::TableInUseException`.
    pub fn is_table_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::TableInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableToPointInTimeErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableToPointInTimeErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for RestoreTableToPointInTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreTableToPointInTimeErrorKind::InternalServerError(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::InvalidRestoreTimeException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::LimitExceededException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::PointInTimeRecoveryUnavailableException(_inner) => {
                Some(_inner)
            }
            RestoreTableToPointInTimeErrorKind::TableAlreadyExistsException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::TableInUseException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::TableNotFoundException(_inner) => Some(_inner),
            RestoreTableToPointInTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Scan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ScanError {
    /// Kind of error that occurred.
    pub kind: ScanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Scan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ScanErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ScanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ScanErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ScanErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            ScanErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            ScanErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            ScanErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ScanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ScanError {
    fn code(&self) -> Option<&str> {
        ScanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ScanError {
    /// Creates a new `ScanError`.
    pub fn new(kind: ScanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ScanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ScanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ScanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ScanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ScanErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, ScanErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `ScanErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, ScanErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `ScanErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ScanErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ScanErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, ScanErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `ScanErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ScanErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for ScanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ScanErrorKind::InternalServerError(_inner) => Some(_inner),
            ScanErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            ScanErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            ScanErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            ScanErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ScanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TransactGetItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TransactGetItemsError {
    /// Kind of error that occurred.
    pub kind: TransactGetItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TransactGetItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TransactGetItemsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The entire transaction request was canceled.</p>
    /// <p>DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>A condition in one of the condition expressions is not met.</p> </li>
    /// <li> <p>A table in the <code>TransactWriteItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>More than one action in the <code>TransactWriteItems</code> operation targets the same item.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul>
    /// <p>DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code> request. In this case the <code>TransactGetItems</code> operation fails with a <code>TransactionCanceledException</code>.</p> </li>
    /// <li> <p>A table in the <code>TransactGetItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul> <note>
    /// <p>If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. This property is not set for other languages. Transaction cancellation reasons are ordered in the order of requested items, if an item has no error it will have <code>NONE</code> code and <code>Null</code> message.</p>
    /// </note>
    /// <p>Cancellation reason codes and possible error messages:</p>
    /// <ul>
    /// <li> <p>No Errors:</p>
    /// <ul>
    /// <li> <p>Code: <code>NONE</code> </p> </li>
    /// <li> <p>Message: <code>null</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Conditional Check Failed:</p>
    /// <ul>
    /// <li> <p>Code: <code>ConditionalCheckFailed</code> </p> </li>
    /// <li> <p>Message: The conditional request failed. </p> </li>
    /// </ul> </li>
    /// <li> <p>Item Collection Size Limit Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ItemCollectionSizeLimitExceeded</code> </p> </li>
    /// <li> <p>Message: Collection size exceeded.</p> </li>
    /// </ul> </li>
    /// <li> <p>Transaction Conflict:</p>
    /// <ul>
    /// <li> <p>Code: <code>TransactionConflict</code> </p> </li>
    /// <li> <p>Message: Transaction is ongoing for the item.</p> </li>
    /// </ul> </li>
    /// <li> <p>Provisioned Throughput Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ProvisionedThroughputExceeded</code> </p> </li>
    /// <li> <p>Messages:</p>
    /// <ul>
    /// <li> <p>The level of configured provisioned throughput for the table was exceeded. Consider increasing your provisioning level with the UpdateTable API.</p> <note>
    /// <p>This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.</p>
    /// </note> </li>
    /// <li> <p>The level of configured provisioned throughput for one or more global secondary indexes of the table was exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes with the UpdateTable API.</p> <note>
    /// <p>This message is returned when provisioned throughput is exceeded is on a provisioned GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Throttling Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ThrottlingError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your table or index so please try again shortly. If exceptions persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.</p> <note>
    /// <p>This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically scaling the table.</p>
    /// </note> </li>
    /// <li> <p>Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is automatically scaling your index so please try again shortly.</p> <note>
    /// <p>This message is returned when when writes get throttled on an On-Demand GSI as DynamoDB is automatically scaling the GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Validation Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ValidationError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>One or more parameter values were invalid.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key beyond allowed size limits.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key to unsupported type.</p> </li>
    /// <li> <p>An operand in the update expression has an incorrect data type.</p> </li>
    /// <li> <p>Item size to update has exceeded the maximum allowed size.</p> </li>
    /// <li> <p>Number overflow. Attempting to store a number with magnitude larger than supported range.</p> </li>
    /// <li> <p>Type mismatch for attribute to update.</p> </li>
    /// <li> <p>Nesting Levels have exceeded supported limits.</p> </li>
    /// <li> <p>The document path provided in the update expression is invalid for update.</p> </li>
    /// <li> <p>The provided expression refers to an attribute that does not exist in the item.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// </ul>
    TransactionCanceledException(crate::error::TransactionCanceledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TransactGetItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TransactGetItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TransactGetItemsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            TransactGetItemsErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            TransactGetItemsErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            TransactGetItemsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TransactGetItemsErrorKind::TransactionCanceledException(_inner) => _inner.fmt(f),
            TransactGetItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TransactGetItemsError {
    fn code(&self) -> Option<&str> {
        TransactGetItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TransactGetItemsError {
    /// Creates a new `TransactGetItemsError`.
    pub fn new(kind: TransactGetItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TransactGetItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TransactGetItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TransactGetItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TransactGetItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::RequestLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactGetItemsErrorKind::TransactionCanceledException`.
    pub fn is_transaction_canceled_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactGetItemsErrorKind::TransactionCanceledException(_)
        )
    }
}
impl std::error::Error for TransactGetItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TransactGetItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            TransactGetItemsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            TransactGetItemsErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            TransactGetItemsErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            TransactGetItemsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TransactGetItemsErrorKind::TransactionCanceledException(_inner) => Some(_inner),
            TransactGetItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TransactWriteItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TransactWriteItemsError {
    /// Kind of error that occurred.
    pub kind: TransactWriteItemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TransactWriteItems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TransactWriteItemsErrorKind {
    /// <p>DynamoDB rejected the request because you retried a request with a different payload but with an idempotent token that was already used.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The entire transaction request was canceled.</p>
    /// <p>DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>A condition in one of the condition expressions is not met.</p> </li>
    /// <li> <p>A table in the <code>TransactWriteItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>More than one action in the <code>TransactWriteItems</code> operation targets the same item.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul>
    /// <p>DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:</p>
    /// <ul>
    /// <li> <p>There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code> request. In this case the <code>TransactGetItems</code> operation fails with a <code>TransactionCanceledException</code>.</p> </li>
    /// <li> <p>A table in the <code>TransactGetItems</code> request is in a different account or region.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul> <note>
    /// <p>If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. This property is not set for other languages. Transaction cancellation reasons are ordered in the order of requested items, if an item has no error it will have <code>NONE</code> code and <code>Null</code> message.</p>
    /// </note>
    /// <p>Cancellation reason codes and possible error messages:</p>
    /// <ul>
    /// <li> <p>No Errors:</p>
    /// <ul>
    /// <li> <p>Code: <code>NONE</code> </p> </li>
    /// <li> <p>Message: <code>null</code> </p> </li>
    /// </ul> </li>
    /// <li> <p>Conditional Check Failed:</p>
    /// <ul>
    /// <li> <p>Code: <code>ConditionalCheckFailed</code> </p> </li>
    /// <li> <p>Message: The conditional request failed. </p> </li>
    /// </ul> </li>
    /// <li> <p>Item Collection Size Limit Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ItemCollectionSizeLimitExceeded</code> </p> </li>
    /// <li> <p>Message: Collection size exceeded.</p> </li>
    /// </ul> </li>
    /// <li> <p>Transaction Conflict:</p>
    /// <ul>
    /// <li> <p>Code: <code>TransactionConflict</code> </p> </li>
    /// <li> <p>Message: Transaction is ongoing for the item.</p> </li>
    /// </ul> </li>
    /// <li> <p>Provisioned Throughput Exceeded:</p>
    /// <ul>
    /// <li> <p>Code: <code>ProvisionedThroughputExceeded</code> </p> </li>
    /// <li> <p>Messages:</p>
    /// <ul>
    /// <li> <p>The level of configured provisioned throughput for the table was exceeded. Consider increasing your provisioning level with the UpdateTable API.</p> <note>
    /// <p>This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.</p>
    /// </note> </li>
    /// <li> <p>The level of configured provisioned throughput for one or more global secondary indexes of the table was exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes with the UpdateTable API.</p> <note>
    /// <p>This message is returned when provisioned throughput is exceeded is on a provisioned GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Throttling Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ThrottlingError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your table or index so please try again shortly. If exceptions persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.</p> <note>
    /// <p>This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically scaling the table.</p>
    /// </note> </li>
    /// <li> <p>Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is automatically scaling your index so please try again shortly.</p> <note>
    /// <p>This message is returned when when writes get throttled on an On-Demand GSI as DynamoDB is automatically scaling the GSI.</p>
    /// </note> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// <li> <p>Validation Error:</p>
    /// <ul>
    /// <li> <p>Code: <code>ValidationError</code> </p> </li>
    /// <li> <p>Messages: </p>
    /// <ul>
    /// <li> <p>One or more parameter values were invalid.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key beyond allowed size limits.</p> </li>
    /// <li> <p>The update expression attempted to update the secondary index key to unsupported type.</p> </li>
    /// <li> <p>An operand in the update expression has an incorrect data type.</p> </li>
    /// <li> <p>Item size to update has exceeded the maximum allowed size.</p> </li>
    /// <li> <p>Number overflow. Attempting to store a number with magnitude larger than supported range.</p> </li>
    /// <li> <p>Type mismatch for attribute to update.</p> </li>
    /// <li> <p>Nesting Levels have exceeded supported limits.</p> </li>
    /// <li> <p>The document path provided in the update expression is invalid for update.</p> </li>
    /// <li> <p>The provided expression refers to an attribute that does not exist in the item.</p> </li>
    /// </ul> </li>
    /// </ul> </li>
    /// </ul>
    TransactionCanceledException(crate::error::TransactionCanceledException),
    /// <p>The transaction with the given request token is already in progress.</p>
    TransactionInProgressException(crate::error::TransactionInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TransactWriteItemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TransactWriteItemsErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            TransactWriteItemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::ProvisionedThroughputExceededException(_inner) => {
                _inner.fmt(f)
            }
            TransactWriteItemsErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::TransactionCanceledException(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::TransactionInProgressException(_inner) => _inner.fmt(f),
            TransactWriteItemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TransactWriteItemsError {
    fn code(&self) -> Option<&str> {
        TransactWriteItemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TransactWriteItemsError {
    /// Creates a new `TransactWriteItemsError`.
    pub fn new(kind: TransactWriteItemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TransactWriteItemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TransactWriteItemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TransactWriteItemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TransactWriteItemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::RequestLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::TransactionCanceledException`.
    pub fn is_transaction_canceled_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::TransactionCanceledException(_)
        )
    }
    /// Returns `true` if the error kind is `TransactWriteItemsErrorKind::TransactionInProgressException`.
    pub fn is_transaction_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            TransactWriteItemsErrorKind::TransactionInProgressException(_)
        )
    }
}
impl std::error::Error for TransactWriteItemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TransactWriteItemsErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            TransactWriteItemsErrorKind::InternalServerError(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::ProvisionedThroughputExceededException(_inner) => {
                Some(_inner)
            }
            TransactWriteItemsErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::TransactionCanceledException(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::TransactionInProgressException(_inner) => Some(_inner),
            TransactWriteItemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContinuousBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContinuousBackupsError {
    /// Kind of error that occurred.
    pub kind: UpdateContinuousBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContinuousBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContinuousBackupsErrorKind {
    /// <p>Backups have not yet been enabled for this table.</p>
    ContinuousBackupsUnavailableException(crate::error::ContinuousBackupsUnavailableException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContinuousBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContinuousBackupsErrorKind::ContinuousBackupsUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateContinuousBackupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateContinuousBackupsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateContinuousBackupsErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            UpdateContinuousBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContinuousBackupsError {
    fn code(&self) -> Option<&str> {
        UpdateContinuousBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContinuousBackupsError {
    /// Creates a new `UpdateContinuousBackupsError`.
    pub fn new(kind: UpdateContinuousBackupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContinuousBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContinuousBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContinuousBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContinuousBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContinuousBackupsErrorKind::ContinuousBackupsUnavailableException`.
    pub fn is_continuous_backups_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContinuousBackupsErrorKind::ContinuousBackupsUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContinuousBackupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContinuousBackupsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContinuousBackupsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContinuousBackupsErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContinuousBackupsErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContinuousBackupsErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateContinuousBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContinuousBackupsErrorKind::ContinuousBackupsUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateContinuousBackupsErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateContinuousBackupsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateContinuousBackupsErrorKind::TableNotFoundException(_inner) => Some(_inner),
            UpdateContinuousBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContributorInsightsError {
    /// Kind of error that occurred.
    pub kind: UpdateContributorInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContributorInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContributorInsightsErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContributorInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContributorInsightsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateContributorInsightsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContributorInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContributorInsightsError {
    fn code(&self) -> Option<&str> {
        UpdateContributorInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContributorInsightsError {
    /// Creates a new `UpdateContributorInsightsError`.
    pub fn new(kind: UpdateContributorInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContributorInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContributorInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContributorInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContributorInsightsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContributorInsightsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContributorInsightsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContributorInsightsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContributorInsightsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateContributorInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContributorInsightsErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateContributorInsightsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContributorInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGlobalTableError {
    /// Kind of error that occurred.
    pub kind: UpdateGlobalTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGlobalTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGlobalTableErrorKind {
    /// <p>The specified global table does not exist.</p>
    GlobalTableNotFoundException(crate::error::GlobalTableNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>The specified replica is already part of the global table.</p>
    ReplicaAlreadyExistsException(crate::error::ReplicaAlreadyExistsException),
    /// <p>The specified replica is no longer part of the global table.</p>
    ReplicaNotFoundException(crate::error::ReplicaNotFoundException),
    /// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
    TableNotFoundException(crate::error::TableNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGlobalTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGlobalTableErrorKind::GlobalTableNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::ReplicaAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::ReplicaNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::TableNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGlobalTableError {
    fn code(&self) -> Option<&str> {
        UpdateGlobalTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGlobalTableError {
    /// Creates a new `UpdateGlobalTableError`.
    pub fn new(kind: UpdateGlobalTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGlobalTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGlobalTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGlobalTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGlobalTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::GlobalTableNotFoundException`.
    pub fn is_global_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::GlobalTableNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::ReplicaAlreadyExistsException`.
    pub fn is_replica_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::ReplicaAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::ReplicaNotFoundException`.
    pub fn is_replica_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::ReplicaNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableErrorKind::TableNotFoundException`.
    pub fn is_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableErrorKind::TableNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateGlobalTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGlobalTableErrorKind::GlobalTableNotFoundException(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::ReplicaAlreadyExistsException(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::ReplicaNotFoundException(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::TableNotFoundException(_inner) => Some(_inner),
            UpdateGlobalTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGlobalTableSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGlobalTableSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateGlobalTableSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGlobalTableSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGlobalTableSettingsErrorKind {
    /// <p>The specified global table does not exist.</p>
    GlobalTableNotFoundException(crate::error::GlobalTableNotFoundException),
    /// <p>The operation tried to access a nonexistent index.</p>
    IndexNotFoundException(crate::error::IndexNotFoundException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified replica is no longer part of the global table.</p>
    ReplicaNotFoundException(crate::error::ReplicaNotFoundException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGlobalTableSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateGlobalTableSettingsErrorKind::IndexNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::ReplicaNotFoundException(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateGlobalTableSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGlobalTableSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateGlobalTableSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGlobalTableSettingsError {
    /// Creates a new `UpdateGlobalTableSettingsError`.
    pub fn new(kind: UpdateGlobalTableSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGlobalTableSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGlobalTableSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGlobalTableSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGlobalTableSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::GlobalTableNotFoundException`.
    pub fn is_global_table_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::IndexNotFoundException`.
    pub fn is_index_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::IndexNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::ReplicaNotFoundException`.
    pub fn is_replica_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::ReplicaNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGlobalTableSettingsErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGlobalTableSettingsErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for UpdateGlobalTableSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGlobalTableSettingsErrorKind::GlobalTableNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateGlobalTableSettingsErrorKind::IndexNotFoundException(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::ReplicaNotFoundException(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateGlobalTableSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateItemError {
    /// Kind of error that occurred.
    pub kind: UpdateItemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateItem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateItemErrorKind {
    /// <p>A condition specified in the operation could not be evaluated.</p>
    ConditionalCheckFailedException(crate::error::ConditionalCheckFailedException),
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
    ItemCollectionSizeLimitExceededException(
        crate::error::ItemCollectionSizeLimitExceededException,
    ),
    /// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
    RequestLimitExceeded(crate::error::RequestLimitExceeded),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Operation was rejected because there is an ongoing transaction for the item.</p>
    TransactionConflictException(crate::error::TransactionConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateItemErrorKind::ConditionalCheckFailedException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::ProvisionedThroughputExceededException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::RequestLimitExceeded(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::TransactionConflictException(_inner) => _inner.fmt(f),
            UpdateItemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateItemError {
    fn code(&self) -> Option<&str> {
        UpdateItemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateItemError {
    /// Creates a new `UpdateItemError`.
    pub fn new(kind: UpdateItemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateItemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateItemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateItemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateItemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::ConditionalCheckFailedException`.
    pub fn is_conditional_check_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateItemErrorKind::ConditionalCheckFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateItemErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(&self.kind, UpdateItemErrorKind::InvalidEndpointException(_))
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::ItemCollectionSizeLimitExceededException`.
    pub fn is_item_collection_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateItemErrorKind::ItemCollectionSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::ProvisionedThroughputExceededException`.
    pub fn is_provisioned_throughput_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateItemErrorKind::ProvisionedThroughputExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::RequestLimitExceeded`.
    pub fn is_request_limit_exceeded(&self) -> bool {
        matches!(&self.kind, UpdateItemErrorKind::RequestLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateItemErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateItemErrorKind::TransactionConflictException`.
    pub fn is_transaction_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateItemErrorKind::TransactionConflictException(_)
        )
    }
}
impl std::error::Error for UpdateItemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateItemErrorKind::ConditionalCheckFailedException(_inner) => Some(_inner),
            UpdateItemErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateItemErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateItemErrorKind::ItemCollectionSizeLimitExceededException(_inner) => Some(_inner),
            UpdateItemErrorKind::ProvisionedThroughputExceededException(_inner) => Some(_inner),
            UpdateItemErrorKind::RequestLimitExceeded(_inner) => Some(_inner),
            UpdateItemErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateItemErrorKind::TransactionConflictException(_inner) => Some(_inner),
            UpdateItemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTableError {
    /// Kind of error that occurred.
    pub kind: UpdateTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTableErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTableErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTableError {
    fn code(&self) -> Option<&str> {
        UpdateTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTableError {
    /// Creates a new `UpdateTableError`.
    pub fn new(kind: UpdateTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTableErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateTableErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateTableErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTableErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateTableErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTableReplicaAutoScaling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTableReplicaAutoScalingError {
    /// Kind of error that occurred.
    pub kind: UpdateTableReplicaAutoScalingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTableReplicaAutoScaling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTableReplicaAutoScalingErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTableReplicaAutoScalingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTableReplicaAutoScalingErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateTableReplicaAutoScalingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTableReplicaAutoScalingErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateTableReplicaAutoScalingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTableReplicaAutoScalingError {
    fn code(&self) -> Option<&str> {
        UpdateTableReplicaAutoScalingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTableReplicaAutoScalingError {
    /// Creates a new `UpdateTableReplicaAutoScalingError`.
    pub fn new(
        kind: UpdateTableReplicaAutoScalingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTableReplicaAutoScalingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTableReplicaAutoScalingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTableReplicaAutoScalingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTableReplicaAutoScalingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTableReplicaAutoScalingErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableReplicaAutoScalingErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableReplicaAutoScalingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableReplicaAutoScalingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableReplicaAutoScalingErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableReplicaAutoScalingErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableReplicaAutoScalingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateTableReplicaAutoScalingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTableReplicaAutoScalingErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateTableReplicaAutoScalingErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTableReplicaAutoScalingErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateTableReplicaAutoScalingErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateTableReplicaAutoScalingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTimeToLive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTimeToLiveError {
    /// Kind of error that occurred.
    pub kind: UpdateTimeToLiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTimeToLive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTimeToLiveErrorKind {
    /// <p>An error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    #[allow(missing_docs)] // documentation missing in model
    InvalidEndpointException(crate::error::InvalidEndpointException),
    /// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
    /// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
    /// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
    /// <p>There is a soft account quota of 256 tables.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTimeToLiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTimeToLiveErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateTimeToLiveErrorKind::InvalidEndpointException(_inner) => _inner.fmt(f),
            UpdateTimeToLiveErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateTimeToLiveErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateTimeToLiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTimeToLiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTimeToLiveError {
    fn code(&self) -> Option<&str> {
        UpdateTimeToLiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTimeToLiveError {
    /// Creates a new `UpdateTimeToLiveError`.
    pub fn new(kind: UpdateTimeToLiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTimeToLiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTimeToLiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTimeToLiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTimeToLiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTimeToLiveErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimeToLiveErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimeToLiveErrorKind::InvalidEndpointException`.
    pub fn is_invalid_endpoint_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimeToLiveErrorKind::InvalidEndpointException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimeToLiveErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimeToLiveErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimeToLiveErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimeToLiveErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTimeToLiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTimeToLiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateTimeToLiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTimeToLiveErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateTimeToLiveErrorKind::InvalidEndpointException(_inner) => Some(_inner),
            UpdateTimeToLiveErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateTimeToLiveErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateTimeToLiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateTimeToLiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The operation tried to access a nonexistent table or index. The resource might not be specified correctly, or its status might not be <code>ACTIVE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The resource which is being requested does not exist.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource which is being requested does not exist.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource which is being requested does not exist.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The operation conflicts with the resource's availability. For example, you attempted to recreate an existing table, or tried to delete a table currently in the <code>CREATING</code> state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>The resource which is being attempted to be changed is in use.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource which is being attempted to be changed is in use.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The resource which is being attempted to be changed is in use.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>There is no limit to the number of daily on-demand backups that can be taken. </p>
/// <p>Up to 50 simultaneous table operations are allowed per account. These operations include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,<code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and <code>RestoreTableToPointInTime</code>. </p>
/// <p>The only exception is when you are creating a table with one or more secondary indexes. You can have up to 25 such requests running at a time; however, if the table or index specifications are complex, DynamoDB might temporarily reduce the number of concurrent operations.</p>
/// <p>There is a soft account quota of 256 tables.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>Too many operations for a given subscriber.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Too many operations for a given subscriber.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Too many operations for a given subscriber.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEndpointException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEndpointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEndpointException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEndpointException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEndpointException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEndpointException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEndpointException {}
/// See [`InvalidEndpointException`](crate::error::InvalidEndpointException)
pub mod invalid_endpoint_exception {
    /// A builder for [`InvalidEndpointException`](crate::error::InvalidEndpointException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEndpointException`](crate::error::InvalidEndpointException)
        pub fn build(self) -> crate::error::InvalidEndpointException {
            crate::error::InvalidEndpointException {
                message: self.message,
            }
        }
    }
}
impl InvalidEndpointException {
    /// Creates a new builder-style object to manufacture [`InvalidEndpointException`](crate::error::InvalidEndpointException)
    pub fn builder() -> crate::error::invalid_endpoint_exception::Builder {
        crate::error::invalid_endpoint_exception::Builder::default()
    }
}

/// <p>An error occurred on the server side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    /// <p>The server encountered an internal error trying to fulfill the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The server encountered an internal error trying to fulfill the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The server encountered an internal error trying to fulfill the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>Operation was rejected because there is an ongoing transaction for the item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactionConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TransactionConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactionConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TransactionConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TransactionConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TransactionConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for TransactionConflictException {}
/// See [`TransactionConflictException`](crate::error::TransactionConflictException)
pub mod transaction_conflict_exception {
    /// A builder for [`TransactionConflictException`](crate::error::TransactionConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactionConflictException`](crate::error::TransactionConflictException)
        pub fn build(self) -> crate::error::TransactionConflictException {
            crate::error::TransactionConflictException {
                message: self.message,
            }
        }
    }
}
impl TransactionConflictException {
    /// Creates a new builder-style object to manufacture [`TransactionConflictException`](crate::error::TransactionConflictException)
    pub fn builder() -> crate::error::transaction_conflict_exception::Builder {
        crate::error::transaction_conflict_exception::Builder::default()
    }
}

/// <p>Throughput exceeds the current throughput quota for your account. Please contact <a href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestLimitExceeded {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestLimitExceeded")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestLimitExceeded {}
/// See [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
pub mod request_limit_exceeded {
    /// A builder for [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
        pub fn build(self) -> crate::error::RequestLimitExceeded {
            crate::error::RequestLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl RequestLimitExceeded {
    /// Creates a new builder-style object to manufacture [`RequestLimitExceeded`](crate::error::RequestLimitExceeded)
    pub fn builder() -> crate::error::request_limit_exceeded::Builder {
        crate::error::request_limit_exceeded::Builder::default()
    }
}

/// <p>Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff">Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughputExceededException {
    /// <p>You exceeded your maximum allowed provisioned throughput.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughputExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProvisionedThroughputExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedThroughputExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProvisionedThroughputExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedThroughputExceededException {}
/// See [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
pub mod provisioned_throughput_exceeded_exception {
    /// A builder for [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You exceeded your maximum allowed provisioned throughput.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>You exceeded your maximum allowed provisioned throughput.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
        pub fn build(self) -> crate::error::ProvisionedThroughputExceededException {
            crate::error::ProvisionedThroughputExceededException {
                message: self.message,
            }
        }
    }
}
impl ProvisionedThroughputExceededException {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughputExceededException`](crate::error::ProvisionedThroughputExceededException)
    pub fn builder() -> crate::error::provisioned_throughput_exceeded_exception::Builder {
        crate::error::provisioned_throughput_exceeded_exception::Builder::default()
    }
}

/// <p>An item collection is too large. This exception is only returned for tables that have one or more local secondary indexes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemCollectionSizeLimitExceededException {
    /// <p>The total size of an item collection has exceeded the maximum limit of 10 gigabytes.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ItemCollectionSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemCollectionSizeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ItemCollectionSizeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ItemCollectionSizeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ItemCollectionSizeLimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ItemCollectionSizeLimitExceededException {}
/// See [`ItemCollectionSizeLimitExceededException`](crate::error::ItemCollectionSizeLimitExceededException)
pub mod item_collection_size_limit_exceeded_exception {
    /// A builder for [`ItemCollectionSizeLimitExceededException`](crate::error::ItemCollectionSizeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total size of an item collection has exceeded the maximum limit of 10 gigabytes.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The total size of an item collection has exceeded the maximum limit of 10 gigabytes.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemCollectionSizeLimitExceededException`](crate::error::ItemCollectionSizeLimitExceededException)
        pub fn build(self) -> crate::error::ItemCollectionSizeLimitExceededException {
            crate::error::ItemCollectionSizeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ItemCollectionSizeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ItemCollectionSizeLimitExceededException`](crate::error::ItemCollectionSizeLimitExceededException)
    pub fn builder() -> crate::error::item_collection_size_limit_exceeded_exception::Builder {
        crate::error::item_collection_size_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A condition specified in the operation could not be evaluated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionalCheckFailedException {
    /// <p>The conditional request failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConditionalCheckFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionalCheckFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConditionalCheckFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConditionalCheckFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConditionalCheckFailedException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConditionalCheckFailedException {}
/// See [`ConditionalCheckFailedException`](crate::error::ConditionalCheckFailedException)
pub mod conditional_check_failed_exception {
    /// A builder for [`ConditionalCheckFailedException`](crate::error::ConditionalCheckFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The conditional request failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The conditional request failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionalCheckFailedException`](crate::error::ConditionalCheckFailedException)
        pub fn build(self) -> crate::error::ConditionalCheckFailedException {
            crate::error::ConditionalCheckFailedException {
                message: self.message,
            }
        }
    }
}
impl ConditionalCheckFailedException {
    /// Creates a new builder-style object to manufacture [`ConditionalCheckFailedException`](crate::error::ConditionalCheckFailedException)
    pub fn builder() -> crate::error::conditional_check_failed_exception::Builder {
        crate::error::conditional_check_failed_exception::Builder::default()
    }
}

/// <p>The specified replica is no longer part of the global table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicaNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicaNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicaNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicaNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicaNotFoundException {}
/// See [`ReplicaNotFoundException`](crate::error::ReplicaNotFoundException)
pub mod replica_not_found_exception {
    /// A builder for [`ReplicaNotFoundException`](crate::error::ReplicaNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaNotFoundException`](crate::error::ReplicaNotFoundException)
        pub fn build(self) -> crate::error::ReplicaNotFoundException {
            crate::error::ReplicaNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ReplicaNotFoundException {
    /// Creates a new builder-style object to manufacture [`ReplicaNotFoundException`](crate::error::ReplicaNotFoundException)
    pub fn builder() -> crate::error::replica_not_found_exception::Builder {
        crate::error::replica_not_found_exception::Builder::default()
    }
}

/// <p>The operation tried to access a nonexistent index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IndexNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IndexNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IndexNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IndexNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for IndexNotFoundException {}
/// See [`IndexNotFoundException`](crate::error::IndexNotFoundException)
pub mod index_not_found_exception {
    /// A builder for [`IndexNotFoundException`](crate::error::IndexNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexNotFoundException`](crate::error::IndexNotFoundException)
        pub fn build(self) -> crate::error::IndexNotFoundException {
            crate::error::IndexNotFoundException {
                message: self.message,
            }
        }
    }
}
impl IndexNotFoundException {
    /// Creates a new builder-style object to manufacture [`IndexNotFoundException`](crate::error::IndexNotFoundException)
    pub fn builder() -> crate::error::index_not_found_exception::Builder {
        crate::error::index_not_found_exception::Builder::default()
    }
}

/// <p>The specified global table does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalTableNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlobalTableNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalTableNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GlobalTableNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GlobalTableNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GlobalTableNotFoundException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for GlobalTableNotFoundException {}
/// See [`GlobalTableNotFoundException`](crate::error::GlobalTableNotFoundException)
pub mod global_table_not_found_exception {
    /// A builder for [`GlobalTableNotFoundException`](crate::error::GlobalTableNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalTableNotFoundException`](crate::error::GlobalTableNotFoundException)
        pub fn build(self) -> crate::error::GlobalTableNotFoundException {
            crate::error::GlobalTableNotFoundException {
                message: self.message,
            }
        }
    }
}
impl GlobalTableNotFoundException {
    /// Creates a new builder-style object to manufacture [`GlobalTableNotFoundException`](crate::error::GlobalTableNotFoundException)
    pub fn builder() -> crate::error::global_table_not_found_exception::Builder {
        crate::error::global_table_not_found_exception::Builder::default()
    }
}

/// <p>A source table with the name <code>TableName</code> does not currently exist within the subscriber's account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TableNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TableNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TableNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for TableNotFoundException {}
/// See [`TableNotFoundException`](crate::error::TableNotFoundException)
pub mod table_not_found_exception {
    /// A builder for [`TableNotFoundException`](crate::error::TableNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TableNotFoundException`](crate::error::TableNotFoundException)
        pub fn build(self) -> crate::error::TableNotFoundException {
            crate::error::TableNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TableNotFoundException {
    /// Creates a new builder-style object to manufacture [`TableNotFoundException`](crate::error::TableNotFoundException)
    pub fn builder() -> crate::error::table_not_found_exception::Builder {
        crate::error::table_not_found_exception::Builder::default()
    }
}

/// <p>The specified replica is already part of the global table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicaAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicaAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicaAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicaAlreadyExistsException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicaAlreadyExistsException {}
/// See [`ReplicaAlreadyExistsException`](crate::error::ReplicaAlreadyExistsException)
pub mod replica_already_exists_exception {
    /// A builder for [`ReplicaAlreadyExistsException`](crate::error::ReplicaAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaAlreadyExistsException`](crate::error::ReplicaAlreadyExistsException)
        pub fn build(self) -> crate::error::ReplicaAlreadyExistsException {
            crate::error::ReplicaAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ReplicaAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ReplicaAlreadyExistsException`](crate::error::ReplicaAlreadyExistsException)
    pub fn builder() -> crate::error::replica_already_exists_exception::Builder {
        crate::error::replica_already_exists_exception::Builder::default()
    }
}

/// <p>Backups have not yet been enabled for this table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuousBackupsUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContinuousBackupsUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuousBackupsUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ContinuousBackupsUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ContinuousBackupsUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ContinuousBackupsUnavailableException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ContinuousBackupsUnavailableException {}
/// See [`ContinuousBackupsUnavailableException`](crate::error::ContinuousBackupsUnavailableException)
pub mod continuous_backups_unavailable_exception {
    /// A builder for [`ContinuousBackupsUnavailableException`](crate::error::ContinuousBackupsUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinuousBackupsUnavailableException`](crate::error::ContinuousBackupsUnavailableException)
        pub fn build(self) -> crate::error::ContinuousBackupsUnavailableException {
            crate::error::ContinuousBackupsUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ContinuousBackupsUnavailableException {
    /// Creates a new builder-style object to manufacture [`ContinuousBackupsUnavailableException`](crate::error::ContinuousBackupsUnavailableException)
    pub fn builder() -> crate::error::continuous_backups_unavailable_exception::Builder {
        crate::error::continuous_backups_unavailable_exception::Builder::default()
    }
}

/// <p>The transaction with the given request token is already in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactionInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TransactionInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactionInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TransactionInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TransactionInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TransactionInProgressException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for TransactionInProgressException {}
/// See [`TransactionInProgressException`](crate::error::TransactionInProgressException)
pub mod transaction_in_progress_exception {
    /// A builder for [`TransactionInProgressException`](crate::error::TransactionInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactionInProgressException`](crate::error::TransactionInProgressException)
        pub fn build(self) -> crate::error::TransactionInProgressException {
            crate::error::TransactionInProgressException {
                message: self.message,
            }
        }
    }
}
impl TransactionInProgressException {
    /// Creates a new builder-style object to manufacture [`TransactionInProgressException`](crate::error::TransactionInProgressException)
    pub fn builder() -> crate::error::transaction_in_progress_exception::Builder {
        crate::error::transaction_in_progress_exception::Builder::default()
    }
}

/// <p>The entire transaction request was canceled.</p>
/// <p>DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:</p>
/// <ul>
/// <li> <p>A condition in one of the condition expressions is not met.</p> </li>
/// <li> <p>A table in the <code>TransactWriteItems</code> request is in a different account or region.</p> </li>
/// <li> <p>More than one action in the <code>TransactWriteItems</code> operation targets the same item.</p> </li>
/// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
/// <li> <p>An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li>
/// <li> <p>There is a user error, such as an invalid data format.</p> </li>
/// </ul>
/// <p>DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:</p>
/// <ul>
/// <li> <p>There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code> request. In this case the <code>TransactGetItems</code> operation fails with a <code>TransactionCanceledException</code>.</p> </li>
/// <li> <p>A table in the <code>TransactGetItems</code> request is in a different account or region.</p> </li>
/// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
/// <li> <p>There is a user error, such as an invalid data format.</p> </li>
/// </ul> <note>
/// <p>If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property. This property is not set for other languages. Transaction cancellation reasons are ordered in the order of requested items, if an item has no error it will have <code>NONE</code> code and <code>Null</code> message.</p>
/// </note>
/// <p>Cancellation reason codes and possible error messages:</p>
/// <ul>
/// <li> <p>No Errors:</p>
/// <ul>
/// <li> <p>Code: <code>NONE</code> </p> </li>
/// <li> <p>Message: <code>null</code> </p> </li>
/// </ul> </li>
/// <li> <p>Conditional Check Failed:</p>
/// <ul>
/// <li> <p>Code: <code>ConditionalCheckFailed</code> </p> </li>
/// <li> <p>Message: The conditional request failed. </p> </li>
/// </ul> </li>
/// <li> <p>Item Collection Size Limit Exceeded:</p>
/// <ul>
/// <li> <p>Code: <code>ItemCollectionSizeLimitExceeded</code> </p> </li>
/// <li> <p>Message: Collection size exceeded.</p> </li>
/// </ul> </li>
/// <li> <p>Transaction Conflict:</p>
/// <ul>
/// <li> <p>Code: <code>TransactionConflict</code> </p> </li>
/// <li> <p>Message: Transaction is ongoing for the item.</p> </li>
/// </ul> </li>
/// <li> <p>Provisioned Throughput Exceeded:</p>
/// <ul>
/// <li> <p>Code: <code>ProvisionedThroughputExceeded</code> </p> </li>
/// <li> <p>Messages:</p>
/// <ul>
/// <li> <p>The level of configured provisioned throughput for the table was exceeded. Consider increasing your provisioning level with the UpdateTable API.</p> <note>
/// <p>This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.</p>
/// </note> </li>
/// <li> <p>The level of configured provisioned throughput for one or more global secondary indexes of the table was exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes with the UpdateTable API.</p> <note>
/// <p>This message is returned when provisioned throughput is exceeded is on a provisioned GSI.</p>
/// </note> </li>
/// </ul> </li>
/// </ul> </li>
/// <li> <p>Throttling Error:</p>
/// <ul>
/// <li> <p>Code: <code>ThrottlingError</code> </p> </li>
/// <li> <p>Messages: </p>
/// <ul>
/// <li> <p>Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your table or index so please try again shortly. If exceptions persist, check if you have a hot key: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.</p> <note>
/// <p>This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically scaling the table.</p>
/// </note> </li>
/// <li> <p>Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is automatically scaling your index so please try again shortly.</p> <note>
/// <p>This message is returned when when writes get throttled on an On-Demand GSI as DynamoDB is automatically scaling the GSI.</p>
/// </note> </li>
/// </ul> </li>
/// </ul> </li>
/// <li> <p>Validation Error:</p>
/// <ul>
/// <li> <p>Code: <code>ValidationError</code> </p> </li>
/// <li> <p>Messages: </p>
/// <ul>
/// <li> <p>One or more parameter values were invalid.</p> </li>
/// <li> <p>The update expression attempted to update the secondary index key beyond allowed size limits.</p> </li>
/// <li> <p>The update expression attempted to update the secondary index key to unsupported type.</p> </li>
/// <li> <p>An operand in the update expression has an incorrect data type.</p> </li>
/// <li> <p>Item size to update has exceeded the maximum allowed size.</p> </li>
/// <li> <p>Number overflow. Attempting to store a number with magnitude larger than supported range.</p> </li>
/// <li> <p>Type mismatch for attribute to update.</p> </li>
/// <li> <p>Nesting Levels have exceeded supported limits.</p> </li>
/// <li> <p>The document path provided in the update expression is invalid for update.</p> </li>
/// <li> <p>The provided expression refers to an attribute that does not exist in the item.</p> </li>
/// </ul> </li>
/// </ul> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactionCanceledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>A list of cancellation reasons.</p>
    pub cancellation_reasons: std::option::Option<std::vec::Vec<crate::model::CancellationReason>>,
}
impl TransactionCanceledException {
    /// <p>A list of cancellation reasons.</p>
    pub fn cancellation_reasons(&self) -> std::option::Option<&[crate::model::CancellationReason]> {
        self.cancellation_reasons.as_deref()
    }
}
impl std::fmt::Debug for TransactionCanceledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactionCanceledException");
        formatter.field("message", &self.message);
        formatter.field("cancellation_reasons", &self.cancellation_reasons);
        formatter.finish()
    }
}
impl TransactionCanceledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TransactionCanceledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TransactionCanceledException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for TransactionCanceledException {}
/// See [`TransactionCanceledException`](crate::error::TransactionCanceledException)
pub mod transaction_canceled_exception {
    /// A builder for [`TransactionCanceledException`](crate::error::TransactionCanceledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) cancellation_reasons:
            std::option::Option<std::vec::Vec<crate::model::CancellationReason>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `cancellation_reasons`.
        ///
        /// To override the contents of this collection use [`set_cancellation_reasons`](Self::set_cancellation_reasons).
        ///
        /// <p>A list of cancellation reasons.</p>
        pub fn cancellation_reasons(mut self, input: crate::model::CancellationReason) -> Self {
            let mut v = self.cancellation_reasons.unwrap_or_default();
            v.push(input);
            self.cancellation_reasons = Some(v);
            self
        }
        /// <p>A list of cancellation reasons.</p>
        pub fn set_cancellation_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CancellationReason>>,
        ) -> Self {
            self.cancellation_reasons = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactionCanceledException`](crate::error::TransactionCanceledException)
        pub fn build(self) -> crate::error::TransactionCanceledException {
            crate::error::TransactionCanceledException {
                message: self.message,
                cancellation_reasons: self.cancellation_reasons,
            }
        }
    }
}
impl TransactionCanceledException {
    /// Creates a new builder-style object to manufacture [`TransactionCanceledException`](crate::error::TransactionCanceledException)
    pub fn builder() -> crate::error::transaction_canceled_exception::Builder {
        crate::error::transaction_canceled_exception::Builder::default()
    }
}

/// <p>DynamoDB rejected the request because you retried a request with a different payload but with an idempotent token that was already used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}

/// <p>A target table with the specified name is either being created or deleted. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TableInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TableInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TableInUseException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for TableInUseException {}
/// See [`TableInUseException`](crate::error::TableInUseException)
pub mod table_in_use_exception {
    /// A builder for [`TableInUseException`](crate::error::TableInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TableInUseException`](crate::error::TableInUseException)
        pub fn build(self) -> crate::error::TableInUseException {
            crate::error::TableInUseException {
                message: self.message,
            }
        }
    }
}
impl TableInUseException {
    /// Creates a new builder-style object to manufacture [`TableInUseException`](crate::error::TableInUseException)
    pub fn builder() -> crate::error::table_in_use_exception::Builder {
        crate::error::table_in_use_exception::Builder::default()
    }
}

/// <p>A target table with the specified name already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TableAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TableAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TableAlreadyExistsException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for TableAlreadyExistsException {}
/// See [`TableAlreadyExistsException`](crate::error::TableAlreadyExistsException)
pub mod table_already_exists_exception {
    /// A builder for [`TableAlreadyExistsException`](crate::error::TableAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TableAlreadyExistsException`](crate::error::TableAlreadyExistsException)
        pub fn build(self) -> crate::error::TableAlreadyExistsException {
            crate::error::TableAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl TableAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`TableAlreadyExistsException`](crate::error::TableAlreadyExistsException)
    pub fn builder() -> crate::error::table_already_exists_exception::Builder {
        crate::error::table_already_exists_exception::Builder::default()
    }
}

/// <p>Point in time recovery has not yet been enabled for this source table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRecoveryUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PointInTimeRecoveryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRecoveryUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PointInTimeRecoveryUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PointInTimeRecoveryUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PointInTimeRecoveryUnavailableException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for PointInTimeRecoveryUnavailableException {}
/// See [`PointInTimeRecoveryUnavailableException`](crate::error::PointInTimeRecoveryUnavailableException)
pub mod point_in_time_recovery_unavailable_exception {
    /// A builder for [`PointInTimeRecoveryUnavailableException`](crate::error::PointInTimeRecoveryUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRecoveryUnavailableException`](crate::error::PointInTimeRecoveryUnavailableException)
        pub fn build(self) -> crate::error::PointInTimeRecoveryUnavailableException {
            crate::error::PointInTimeRecoveryUnavailableException {
                message: self.message,
            }
        }
    }
}
impl PointInTimeRecoveryUnavailableException {
    /// Creates a new builder-style object to manufacture [`PointInTimeRecoveryUnavailableException`](crate::error::PointInTimeRecoveryUnavailableException)
    pub fn builder() -> crate::error::point_in_time_recovery_unavailable_exception::Builder {
        crate::error::point_in_time_recovery_unavailable_exception::Builder::default()
    }
}

/// <p>An invalid restore time was specified. RestoreDateTime must be between EarliestRestorableDateTime and LatestRestorableDateTime.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRestoreTimeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRestoreTimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRestoreTimeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRestoreTimeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRestoreTimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRestoreTimeException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRestoreTimeException {}
/// See [`InvalidRestoreTimeException`](crate::error::InvalidRestoreTimeException)
pub mod invalid_restore_time_exception {
    /// A builder for [`InvalidRestoreTimeException`](crate::error::InvalidRestoreTimeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRestoreTimeException`](crate::error::InvalidRestoreTimeException)
        pub fn build(self) -> crate::error::InvalidRestoreTimeException {
            crate::error::InvalidRestoreTimeException {
                message: self.message,
            }
        }
    }
}
impl InvalidRestoreTimeException {
    /// Creates a new builder-style object to manufacture [`InvalidRestoreTimeException`](crate::error::InvalidRestoreTimeException)
    pub fn builder() -> crate::error::invalid_restore_time_exception::Builder {
        crate::error::invalid_restore_time_exception::Builder::default()
    }
}

/// <p>Backup not found for the given BackupARN. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BackupNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupNotFoundException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupNotFoundException {}
/// See [`BackupNotFoundException`](crate::error::BackupNotFoundException)
pub mod backup_not_found_exception {
    /// A builder for [`BackupNotFoundException`](crate::error::BackupNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupNotFoundException`](crate::error::BackupNotFoundException)
        pub fn build(self) -> crate::error::BackupNotFoundException {
            crate::error::BackupNotFoundException {
                message: self.message,
            }
        }
    }
}
impl BackupNotFoundException {
    /// Creates a new builder-style object to manufacture [`BackupNotFoundException`](crate::error::BackupNotFoundException)
    pub fn builder() -> crate::error::backup_not_found_exception::Builder {
        crate::error::backup_not_found_exception::Builder::default()
    }
}

/// <p>There is another ongoing conflicting backup control plane operation on the table. The backup is either being created, deleted or restored to a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackupInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BackupInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupInUseException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupInUseException {}
/// See [`BackupInUseException`](crate::error::BackupInUseException)
pub mod backup_in_use_exception {
    /// A builder for [`BackupInUseException`](crate::error::BackupInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupInUseException`](crate::error::BackupInUseException)
        pub fn build(self) -> crate::error::BackupInUseException {
            crate::error::BackupInUseException {
                message: self.message,
            }
        }
    }
}
impl BackupInUseException {
    /// Creates a new builder-style object to manufacture [`BackupInUseException`](crate::error::BackupInUseException)
    pub fn builder() -> crate::error::backup_in_use_exception::Builder {
        crate::error::backup_in_use_exception::Builder::default()
    }
}

/// <p>The specified <code>ExportTime</code> is outside of the point in time recovery window.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExportTimeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExportTimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExportTimeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExportTimeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExportTimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExportTimeException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExportTimeException {}
/// See [`InvalidExportTimeException`](crate::error::InvalidExportTimeException)
pub mod invalid_export_time_exception {
    /// A builder for [`InvalidExportTimeException`](crate::error::InvalidExportTimeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExportTimeException`](crate::error::InvalidExportTimeException)
        pub fn build(self) -> crate::error::InvalidExportTimeException {
            crate::error::InvalidExportTimeException {
                message: self.message,
            }
        }
    }
}
impl InvalidExportTimeException {
    /// Creates a new builder-style object to manufacture [`InvalidExportTimeException`](crate::error::InvalidExportTimeException)
    pub fn builder() -> crate::error::invalid_export_time_exception::Builder {
        crate::error::invalid_export_time_exception::Builder::default()
    }
}

/// <p>There was a conflict when writing to the specified S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExportConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExportConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExportConflictException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExportConflictException {}
/// See [`ExportConflictException`](crate::error::ExportConflictException)
pub mod export_conflict_exception {
    /// A builder for [`ExportConflictException`](crate::error::ExportConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportConflictException`](crate::error::ExportConflictException)
        pub fn build(self) -> crate::error::ExportConflictException {
            crate::error::ExportConflictException {
                message: self.message,
            }
        }
    }
}
impl ExportConflictException {
    /// Creates a new builder-style object to manufacture [`ExportConflictException`](crate::error::ExportConflictException)
    pub fn builder() -> crate::error::export_conflict_exception::Builder {
        crate::error::export_conflict_exception::Builder::default()
    }
}

/// <p> There was an attempt to insert an item with the same primary key as an item that already exists in the DynamoDB table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateItemException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateItemException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateItemException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateItemException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateItemException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateItemException {}
/// See [`DuplicateItemException`](crate::error::DuplicateItemException)
pub mod duplicate_item_exception {
    /// A builder for [`DuplicateItemException`](crate::error::DuplicateItemException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateItemException`](crate::error::DuplicateItemException)
        pub fn build(self) -> crate::error::DuplicateItemException {
            crate::error::DuplicateItemException {
                message: self.message,
            }
        }
    }
}
impl DuplicateItemException {
    /// Creates a new builder-style object to manufacture [`DuplicateItemException`](crate::error::DuplicateItemException)
    pub fn builder() -> crate::error::duplicate_item_exception::Builder {
        crate::error::duplicate_item_exception::Builder::default()
    }
}

/// <p>The specified export was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExportNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExportNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExportNotFoundException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExportNotFoundException {}
/// See [`ExportNotFoundException`](crate::error::ExportNotFoundException)
pub mod export_not_found_exception {
    /// A builder for [`ExportNotFoundException`](crate::error::ExportNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportNotFoundException`](crate::error::ExportNotFoundException)
        pub fn build(self) -> crate::error::ExportNotFoundException {
            crate::error::ExportNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ExportNotFoundException {
    /// Creates a new builder-style object to manufacture [`ExportNotFoundException`](crate::error::ExportNotFoundException)
    pub fn builder() -> crate::error::export_not_found_exception::Builder {
        crate::error::export_not_found_exception::Builder::default()
    }
}

/// <p>The specified global table already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalTableAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlobalTableAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalTableAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GlobalTableAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GlobalTableAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GlobalTableAlreadyExistsException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for GlobalTableAlreadyExistsException {}
/// See [`GlobalTableAlreadyExistsException`](crate::error::GlobalTableAlreadyExistsException)
pub mod global_table_already_exists_exception {
    /// A builder for [`GlobalTableAlreadyExistsException`](crate::error::GlobalTableAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalTableAlreadyExistsException`](crate::error::GlobalTableAlreadyExistsException)
        pub fn build(self) -> crate::error::GlobalTableAlreadyExistsException {
            crate::error::GlobalTableAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl GlobalTableAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`GlobalTableAlreadyExistsException`](crate::error::GlobalTableAlreadyExistsException)
    pub fn builder() -> crate::error::global_table_already_exists_exception::Builder {
        crate::error::global_table_already_exists_exception::Builder::default()
    }
}
