// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon DynamoDB
///
/// Client for invoking operations on Amazon DynamoDB. Each operation on Amazon DynamoDB is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_dynamodb::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_dynamodb::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_dynamodb::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchExecuteStatement`](crate::client::fluent_builders::BatchExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`statements(Vec<BatchStatementRequest>)`](crate::client::fluent_builders::BatchExecuteStatement::statements) / [`set_statements(Option<Vec<BatchStatementRequest>>)`](crate::client::fluent_builders::BatchExecuteStatement::set_statements): <p>The list of PartiQL statements representing the batch to run.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::BatchExecuteStatement::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::BatchExecuteStatement::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    /// - On success, responds with [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput) with field(s):
    ///   - [`responses(Option<Vec<BatchStatementResponse>>)`](crate::output::BatchExecuteStatementOutput::responses): <p>The response to each PartiQL statement in the batch.</p>
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::BatchExecuteStatementOutput::consumed_capacity): <p>The capacity units consumed by the entire operation. The values of the list are ordered according to the ordering of the statements.</p>
    /// - On failure, responds with [`SdkError<BatchExecuteStatementError>`](crate::error::BatchExecuteStatementError)
    pub fn batch_execute_statement(&self) -> fluent_builders::BatchExecuteStatement {
        fluent_builders::BatchExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetItem`](crate::client::fluent_builders::BatchGetItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_items(HashMap<String, KeysAndAttributes>)`](crate::client::fluent_builders::BatchGetItem::request_items) / [`set_request_items(Option<HashMap<String, KeysAndAttributes>>)`](crate::client::fluent_builders::BatchGetItem::set_request_items): <p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>  <p>Each element in the map of items to retrieve consists of the following:</p>  <ul>   <li> <p> <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code> (the default), an eventually consistent read is used.</p> </li>   <li> <p> <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>    <ul>     <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>     <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>     <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>    </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>    <ul>     <li> <p> <code>Percentile</code> </p> </li>    </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>    <ul>     <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>    </ul> <p>You could then use this substitution in an expression, as in this example:</p>    <ul>     <li> <p> <code>#P = :val</code> </p> </li>    </ul> <note>     <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>    </note> <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>   <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide <i>both</i> the partition key value and the sort key value.</p> </li>   <li> <p> <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>   <li> <p> <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> </li>  </ul>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::BatchGetItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::BatchGetItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    /// - On success, responds with [`BatchGetItemOutput`](crate::output::BatchGetItemOutput) with field(s):
    ///   - [`responses(Option<HashMap<String, Vec<HashMap<String, AttributeValue>>>>)`](crate::output::BatchGetItemOutput::responses): <p>A map of table name to a list of items. Each object in <code>Responses</code> consists of a table name, along with a map of attribute data consisting of the data type and attribute value.</p>
    ///   - [`unprocessed_keys(Option<HashMap<String, KeysAndAttributes>>)`](crate::output::BatchGetItemOutput::unprocessed_keys): <p>A map of tables and their respective keys that were not processed with the current response. The <code>UnprocessedKeys</code> value is in the same form as <code>RequestItems</code>, so the value can be provided directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request Parameters section.</p>  <p>Each element consists of:</p>  <ul>   <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table.</p> </li>   <li> <p> <code>ProjectionExpression</code> - One or more attributes to be retrieved from the table or index. By default, all attributes are returned. If a requested attribute is not found, it does not appear in the result.</p> </li>   <li> <p> <code>ConsistentRead</code> - The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p> </li>  </ul>  <p>If there are no unprocessed keys remaining, the response contains an empty <code>UnprocessedKeys</code> map.</p>
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::BatchGetItemOutput::consumed_capacity): <p>The read capacity units consumed by the entire <code>BatchGetItem</code> operation.</p>  <p>Each element consists of:</p>  <ul>   <li> <p> <code>TableName</code> - The table that consumed the provisioned throughput.</p> </li>   <li> <p> <code>CapacityUnits</code> - The total number of capacity units consumed.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<BatchGetItemError>`](crate::error::BatchGetItemError)
    pub fn batch_get_item(&self) -> fluent_builders::BatchGetItem {
        fluent_builders::BatchGetItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchWriteItem`](crate::client::fluent_builders::BatchWriteItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_items(HashMap<String, Vec<WriteRequest>>)`](crate::client::fluent_builders::BatchWriteItem::request_items) / [`set_request_items(Option<HashMap<String, Vec<WriteRequest>>>)`](crate::client::fluent_builders::BatchWriteItem::set_request_items): <p>A map of one or more table names and, for each table, a list of operations to be performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:</p>  <ul>   <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p>    <ul>     <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p> </li>    </ul> </li>   <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p>    <ul>     <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values are rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p> </li>    </ul> </li>  </ul>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::BatchWriteItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::BatchWriteItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`return_item_collection_metrics(ReturnItemCollectionMetrics)`](crate::client::fluent_builders::BatchWriteItem::return_item_collection_metrics) / [`set_return_item_collection_metrics(Option<ReturnItemCollectionMetrics>)`](crate::client::fluent_builders::BatchWriteItem::set_return_item_collection_metrics): <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
    /// - On success, responds with [`BatchWriteItemOutput`](crate::output::BatchWriteItemOutput) with field(s):
    ///   - [`unprocessed_items(Option<HashMap<String, Vec<WriteRequest>>>)`](crate::output::BatchWriteItemOutput::unprocessed_items): <p>A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request Parameters section.</p>  <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).</p>  <ul>   <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p>    <ul>     <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value.</p> </li>    </ul> </li>   <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p>    <ul>     <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p> </li>    </ul> </li>  </ul>  <p>If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code> map.</p>
    ///   - [`item_collection_metrics(Option<HashMap<String, Vec<ItemCollectionMetrics>>>)`](crate::output::BatchWriteItemOutput::item_collection_metrics): <p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about any item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code> operations.</p>  <p>Each entry consists of the following subelements:</p>  <ul>   <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item.</p> </li>   <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, expressed in GB. This is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on the table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li>  </ul>
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::BatchWriteItemOutput::consumed_capacity): <p>The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>  <p>Each element consists of:</p>  <ul>   <li> <p> <code>TableName</code> - The table that consumed the provisioned throughput.</p> </li>   <li> <p> <code>CapacityUnits</code> - The total number of capacity units consumed.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<BatchWriteItemError>`](crate::error::BatchWriteItemError)
    pub fn batch_write_item(&self) -> fluent_builders::BatchWriteItem {
        fluent_builders::BatchWriteItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBackup`](crate::client::fluent_builders::CreateBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::CreateBackup::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::CreateBackup::set_table_name): <p>The name of the table.</p>
    ///   - [`backup_name(impl Into<String>)`](crate::client::fluent_builders::CreateBackup::backup_name) / [`set_backup_name(Option<String>)`](crate::client::fluent_builders::CreateBackup::set_backup_name): <p>Specified name for the backup.</p>
    /// - On success, responds with [`CreateBackupOutput`](crate::output::CreateBackupOutput) with field(s):
    ///   - [`backup_details(Option<BackupDetails>)`](crate::output::CreateBackupOutput::backup_details): <p>Contains the details of the backup created for the table.</p>
    /// - On failure, responds with [`SdkError<CreateBackupError>`](crate::error::CreateBackupError)
    pub fn create_backup(&self) -> fluent_builders::CreateBackup {
        fluent_builders::CreateBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGlobalTable`](crate::client::fluent_builders::CreateGlobalTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_table_name(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalTable::global_table_name) / [`set_global_table_name(Option<String>)`](crate::client::fluent_builders::CreateGlobalTable::set_global_table_name): <p>The global table name.</p>
    ///   - [`replication_group(Vec<Replica>)`](crate::client::fluent_builders::CreateGlobalTable::replication_group) / [`set_replication_group(Option<Vec<Replica>>)`](crate::client::fluent_builders::CreateGlobalTable::set_replication_group): <p>The Regions where the global table needs to be created.</p>
    /// - On success, responds with [`CreateGlobalTableOutput`](crate::output::CreateGlobalTableOutput) with field(s):
    ///   - [`global_table_description(Option<GlobalTableDescription>)`](crate::output::CreateGlobalTableOutput::global_table_description): <p>Contains the details of the global table.</p>
    /// - On failure, responds with [`SdkError<CreateGlobalTableError>`](crate::error::CreateGlobalTableError)
    pub fn create_global_table(&self) -> fluent_builders::CreateGlobalTable {
        fluent_builders::CreateGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTable`](crate::client::fluent_builders::CreateTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_definitions(Vec<AttributeDefinition>)`](crate::client::fluent_builders::CreateTable::attribute_definitions) / [`set_attribute_definitions(Option<Vec<AttributeDefinition>>)`](crate::client::fluent_builders::CreateTable::set_attribute_definitions): <p>An array of attributes that describe the key schema for the table and indexes.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::CreateTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::CreateTable::set_table_name): <p>The name of the table to create.</p>
    ///   - [`key_schema(Vec<KeySchemaElement>)`](crate::client::fluent_builders::CreateTable::key_schema) / [`set_key_schema(Option<Vec<KeySchemaElement>>)`](crate::client::fluent_builders::CreateTable::set_key_schema): <p>Specifies the attributes that make up the primary key for a table or an index. The attributes in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>  <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>  <ul>   <li> <p> <code>AttributeName</code> - The name of this key attribute.</p> </li>   <li> <p> <code>KeyType</code> - The role that the key attribute will assume:</p>    <ul>     <li> <p> <code>HASH</code> - partition key</p> </li>     <li> <p> <code>RANGE</code> - sort key</p> </li>    </ul> </li>  </ul> <note>   <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>   <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>  </note>  <p>For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p>  <p>For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`local_secondary_indexes(Vec<LocalSecondaryIndex>)`](crate::client::fluent_builders::CreateTable::local_secondary_indexes) / [`set_local_secondary_indexes(Option<Vec<LocalSecondaryIndex>>)`](crate::client::fluent_builders::CreateTable::set_local_secondary_indexes): <p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p>  <p>Each local secondary index in the array includes the following:</p>  <ul>   <li> <p> <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p> <p></p> </li>   <li> <p> <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.</p> </li>   <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>    <ul>     <li> <p> <code>ProjectionType</code> - One of the following:</p>      <ul>       <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>       <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>       <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>      </ul> </li>     <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>    </ul> </li>  </ul>
    ///   - [`global_secondary_indexes(Vec<GlobalSecondaryIndex>)`](crate::client::fluent_builders::CreateTable::global_secondary_indexes) / [`set_global_secondary_indexes(Option<Vec<GlobalSecondaryIndex>>)`](crate::client::fluent_builders::CreateTable::set_global_secondary_indexes): <p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p>  <ul>   <li> <p> <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p> <p></p> </li>   <li> <p> <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p> </li>   <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>    <ul>     <li> <p> <code>ProjectionType</code> - One of the following:</p>      <ul>       <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>       <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>       <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>      </ul> </li>     <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>    </ul> </li>   <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.</p> </li>  </ul>
    ///   - [`billing_mode(BillingMode)`](crate::client::fluent_builders::CreateTable::billing_mode) / [`set_billing_mode(Option<BillingMode>)`](crate::client::fluent_builders::CreateTable::set_billing_mode): <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>  <ul>   <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>   <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>  </ul>
    ///   - [`provisioned_throughput(ProvisionedThroughput)`](crate::client::fluent_builders::CreateTable::provisioned_throughput) / [`set_provisioned_throughput(Option<ProvisionedThroughput>)`](crate::client::fluent_builders::CreateTable::set_provisioned_throughput): <p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p>  <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.</p>  <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`stream_specification(StreamSpecification)`](crate::client::fluent_builders::CreateTable::stream_specification) / [`set_stream_specification(Option<StreamSpecification>)`](crate::client::fluent_builders::CreateTable::set_stream_specification): <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>  <ul>   <li> <p> <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).</p> </li>   <li> <p> <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:</p>    <ul>     <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>     <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>     <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>     <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>    </ul> </li>  </ul>
    ///   - [`sse_specification(SseSpecification)`](crate::client::fluent_builders::CreateTable::sse_specification) / [`set_sse_specification(Option<SseSpecification>)`](crate::client::fluent_builders::CreateTable::set_sse_specification): <p>Represents the settings used to enable server-side encryption.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTable::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTable::set_tags): <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>
    ///   - [`table_class(TableClass)`](crate::client::fluent_builders::CreateTable::table_class) / [`set_table_class(Option<TableClass>)`](crate::client::fluent_builders::CreateTable::set_table_class): <p>The table class of the new table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    /// - On success, responds with [`CreateTableOutput`](crate::output::CreateTableOutput) with field(s):
    ///   - [`table_description(Option<TableDescription>)`](crate::output::CreateTableOutput::table_description): <p>Represents the properties of the table.</p>
    /// - On failure, responds with [`SdkError<CreateTableError>`](crate::error::CreateTableError)
    pub fn create_table(&self) -> fluent_builders::CreateTable {
        fluent_builders::CreateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBackup`](crate::client::fluent_builders::DeleteBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteBackup::backup_arn) / [`set_backup_arn(Option<String>)`](crate::client::fluent_builders::DeleteBackup::set_backup_arn): <p>The ARN associated with the backup.</p>
    /// - On success, responds with [`DeleteBackupOutput`](crate::output::DeleteBackupOutput) with field(s):
    ///   - [`backup_description(Option<BackupDescription>)`](crate::output::DeleteBackupOutput::backup_description): <p>Contains the description of the backup created for the table.</p>
    /// - On failure, responds with [`SdkError<DeleteBackupError>`](crate::error::DeleteBackupError)
    pub fn delete_backup(&self) -> fluent_builders::DeleteBackup {
        fluent_builders::DeleteBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteItem`](crate::client::fluent_builders::DeleteItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DeleteItem::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DeleteItem::set_table_name): <p>The name of the table from which to delete the item.</p>
    ///   - [`key(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::DeleteItem::key) / [`set_key(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::DeleteItem::set_key): <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to delete.</p>  <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
    ///   - [`expected(HashMap<String, ExpectedAttributeValue>)`](crate::client::fluent_builders::DeleteItem::expected) / [`set_expected(Option<HashMap<String, ExpectedAttributeValue>>)`](crate::client::fluent_builders::DeleteItem::set_expected): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`conditional_operator(ConditionalOperator)`](crate::client::fluent_builders::DeleteItem::conditional_operator) / [`set_conditional_operator(Option<ConditionalOperator>)`](crate::client::fluent_builders::DeleteItem::set_conditional_operator): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`return_values(ReturnValue)`](crate::client::fluent_builders::DeleteItem::return_values) / [`set_return_values(Option<ReturnValue>)`](crate::client::fluent_builders::DeleteItem::set_return_values): <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>  <ul>   <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>   <li> <p> <code>ALL_OLD</code> - The content of the old item is returned.</p> </li>  </ul> <note>   <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>  </note>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::DeleteItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::DeleteItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`return_item_collection_metrics(ReturnItemCollectionMetrics)`](crate::client::fluent_builders::DeleteItem::return_item_collection_metrics) / [`set_return_item_collection_metrics(Option<ReturnItemCollectionMetrics>)`](crate::client::fluent_builders::DeleteItem::set_return_item_collection_metrics): <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
    ///   - [`condition_expression(impl Into<String>)`](crate::client::fluent_builders::DeleteItem::condition_expression) / [`set_condition_expression(Option<String>)`](crate::client::fluent_builders::DeleteItem::set_condition_expression): <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p>  <p>An expression can contain any of the following:</p>  <ul>   <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>   <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>   <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>  </ul>  <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::DeleteItem::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::DeleteItem::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_values(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::DeleteItem::expression_attribute_values) / [`set_expression_attribute_values(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::DeleteItem::set_expression_attribute_values): <p>One or more values that can be substituted in an expression.</p>  <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>  <p> <code>Available | Backordered | Discontinued</code> </p>  <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>  <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>  <p>You could then use these values in an expression, such as this:</p>  <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>  <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On success, responds with [`DeleteItemOutput`](crate::output::DeleteItemOutput) with field(s):
    ///   - [`attributes(Option<HashMap<String, AttributeValue>>)`](crate::output::DeleteItemOutput::attributes): <p>A map of attribute names to <code>AttributeValue</code> objects, representing the item as it appeared before the <code>DeleteItem</code> operation. This map appears in the response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the request.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::DeleteItemOutput::consumed_capacity): <p>The capacity units consumed by the <code>DeleteItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`item_collection_metrics(Option<ItemCollectionMetrics>)`](crate::output::DeleteItemOutput::item_collection_metrics): <p>Information about item collections, if any, that were affected by the <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p>  <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>  <ul>   <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li>   <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DeleteItemError>`](crate::error::DeleteItemError)
    pub fn delete_item(&self) -> fluent_builders::DeleteItem {
        fluent_builders::DeleteItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTable`](crate::client::fluent_builders::DeleteTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DeleteTable::set_table_name): <p>The name of the table to delete.</p>
    /// - On success, responds with [`DeleteTableOutput`](crate::output::DeleteTableOutput) with field(s):
    ///   - [`table_description(Option<TableDescription>)`](crate::output::DeleteTableOutput::table_description): <p>Represents the properties of a table.</p>
    /// - On failure, responds with [`SdkError<DeleteTableError>`](crate::error::DeleteTableError)
    pub fn delete_table(&self) -> fluent_builders::DeleteTable {
        fluent_builders::DeleteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBackup`](crate::client::fluent_builders::DescribeBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`backup_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeBackup::backup_arn) / [`set_backup_arn(Option<String>)`](crate::client::fluent_builders::DescribeBackup::set_backup_arn): <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    /// - On success, responds with [`DescribeBackupOutput`](crate::output::DescribeBackupOutput) with field(s):
    ///   - [`backup_description(Option<BackupDescription>)`](crate::output::DescribeBackupOutput::backup_description): <p>Contains the description of the backup created for the table.</p>
    /// - On failure, responds with [`SdkError<DescribeBackupError>`](crate::error::DescribeBackupError)
    pub fn describe_backup(&self) -> fluent_builders::DescribeBackup {
        fluent_builders::DescribeBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContinuousBackups`](crate::client::fluent_builders::DescribeContinuousBackups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeContinuousBackups::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeContinuousBackups::set_table_name): <p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>
    /// - On success, responds with [`DescribeContinuousBackupsOutput`](crate::output::DescribeContinuousBackupsOutput) with field(s):
    ///   - [`continuous_backups_description(Option<ContinuousBackupsDescription>)`](crate::output::DescribeContinuousBackupsOutput::continuous_backups_description): <p>Represents the continuous backups and point in time recovery settings on the table.</p>
    /// - On failure, responds with [`SdkError<DescribeContinuousBackupsError>`](crate::error::DescribeContinuousBackupsError)
    pub fn describe_continuous_backups(&self) -> fluent_builders::DescribeContinuousBackups {
        fluent_builders::DescribeContinuousBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContributorInsights`](crate::client::fluent_builders::DescribeContributorInsights) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeContributorInsights::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeContributorInsights::set_table_name): <p>The name of the table to describe.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::DescribeContributorInsights::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::DescribeContributorInsights::set_index_name): <p>The name of the global secondary index to describe, if applicable.</p>
    /// - On success, responds with [`DescribeContributorInsightsOutput`](crate::output::DescribeContributorInsightsOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::DescribeContributorInsightsOutput::table_name): <p>The name of the table being described.</p>
    ///   - [`index_name(Option<String>)`](crate::output::DescribeContributorInsightsOutput::index_name): <p>The name of the global secondary index being described.</p>
    ///   - [`contributor_insights_rule_list(Option<Vec<String>>)`](crate::output::DescribeContributorInsightsOutput::contributor_insights_rule_list): <p>List of names of the associated contributor insights rules.</p>
    ///   - [`contributor_insights_status(Option<ContributorInsightsStatus>)`](crate::output::DescribeContributorInsightsOutput::contributor_insights_status): <p>Current status of contributor insights.</p>
    ///   - [`last_update_date_time(Option<DateTime>)`](crate::output::DescribeContributorInsightsOutput::last_update_date_time): <p>Timestamp of the last time the status was changed.</p>
    ///   - [`failure_exception(Option<FailureException>)`](crate::output::DescribeContributorInsightsOutput::failure_exception): <p>Returns information about the last failure that was encountered.</p>  <p>The most common exceptions for a FAILED status are:</p>  <ul>   <li> <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before retrying.</p> </li>   <li> <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to insufficient permissions.</p> </li>   <li> <p>AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient permissions.</p> </li>   <li> <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry request.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeContributorInsightsError>`](crate::error::DescribeContributorInsightsError)
    pub fn describe_contributor_insights(&self) -> fluent_builders::DescribeContributorInsights {
        fluent_builders::DescribeContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpoints`](crate::client::fluent_builders::DescribeEndpoints) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeEndpoints::send) it.

    /// - On success, responds with [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput) with field(s):
    ///   - [`endpoints(Option<Vec<Endpoint>>)`](crate::output::DescribeEndpointsOutput::endpoints): <p>List of endpoints.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointsError>`](crate::error::DescribeEndpointsError)
    pub fn describe_endpoints(&self) -> fluent_builders::DescribeEndpoints {
        fluent_builders::DescribeEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExport`](crate::client::fluent_builders::DescribeExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeExport::export_arn) / [`set_export_arn(Option<String>)`](crate::client::fluent_builders::DescribeExport::set_export_arn): <p>The Amazon Resource Name (ARN) associated with the export.</p>
    /// - On success, responds with [`DescribeExportOutput`](crate::output::DescribeExportOutput) with field(s):
    ///   - [`export_description(Option<ExportDescription>)`](crate::output::DescribeExportOutput::export_description): <p>Represents the properties of the export.</p>
    /// - On failure, responds with [`SdkError<DescribeExportError>`](crate::error::DescribeExportError)
    pub fn describe_export(&self) -> fluent_builders::DescribeExport {
        fluent_builders::DescribeExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGlobalTable`](crate::client::fluent_builders::DescribeGlobalTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalTable::global_table_name) / [`set_global_table_name(Option<String>)`](crate::client::fluent_builders::DescribeGlobalTable::set_global_table_name): <p>The name of the global table.</p>
    /// - On success, responds with [`DescribeGlobalTableOutput`](crate::output::DescribeGlobalTableOutput) with field(s):
    ///   - [`global_table_description(Option<GlobalTableDescription>)`](crate::output::DescribeGlobalTableOutput::global_table_description): <p>Contains the details of the global table.</p>
    /// - On failure, responds with [`SdkError<DescribeGlobalTableError>`](crate::error::DescribeGlobalTableError)
    pub fn describe_global_table(&self) -> fluent_builders::DescribeGlobalTable {
        fluent_builders::DescribeGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGlobalTableSettings`](crate::client::fluent_builders::DescribeGlobalTableSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalTableSettings::global_table_name) / [`set_global_table_name(Option<String>)`](crate::client::fluent_builders::DescribeGlobalTableSettings::set_global_table_name): <p>The name of the global table to describe.</p>
    /// - On success, responds with [`DescribeGlobalTableSettingsOutput`](crate::output::DescribeGlobalTableSettingsOutput) with field(s):
    ///   - [`global_table_name(Option<String>)`](crate::output::DescribeGlobalTableSettingsOutput::global_table_name): <p>The name of the global table.</p>
    ///   - [`replica_settings(Option<Vec<ReplicaSettingsDescription>>)`](crate::output::DescribeGlobalTableSettingsOutput::replica_settings): <p>The Region-specific settings for the global table.</p>
    /// - On failure, responds with [`SdkError<DescribeGlobalTableSettingsError>`](crate::error::DescribeGlobalTableSettingsError)
    pub fn describe_global_table_settings(&self) -> fluent_builders::DescribeGlobalTableSettings {
        fluent_builders::DescribeGlobalTableSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeKinesisStreamingDestination`](crate::client::fluent_builders::DescribeKinesisStreamingDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeKinesisStreamingDestination::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeKinesisStreamingDestination::set_table_name): <p>The name of the table being described.</p>
    /// - On success, responds with [`DescribeKinesisStreamingDestinationOutput`](crate::output::DescribeKinesisStreamingDestinationOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::DescribeKinesisStreamingDestinationOutput::table_name): <p>The name of the table being described.</p>
    ///   - [`kinesis_data_stream_destinations(Option<Vec<KinesisDataStreamDestination>>)`](crate::output::DescribeKinesisStreamingDestinationOutput::kinesis_data_stream_destinations): <p>The list of replica structures for the table being described.</p>
    /// - On failure, responds with [`SdkError<DescribeKinesisStreamingDestinationError>`](crate::error::DescribeKinesisStreamingDestinationError)
    pub fn describe_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::DescribeKinesisStreamingDestination {
        fluent_builders::DescribeKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLimits`](crate::client::fluent_builders::DescribeLimits) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeLimits::send) it.

    /// - On success, responds with [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput) with field(s):
    ///   - [`account_max_read_capacity_units(Option<i64>)`](crate::output::DescribeLimitsOutput::account_max_read_capacity_units): <p>The maximum total read capacity units that your account allows you to provision across all of your tables in this Region.</p>
    ///   - [`account_max_write_capacity_units(Option<i64>)`](crate::output::DescribeLimitsOutput::account_max_write_capacity_units): <p>The maximum total write capacity units that your account allows you to provision across all of your tables in this Region.</p>
    ///   - [`table_max_read_capacity_units(Option<i64>)`](crate::output::DescribeLimitsOutput::table_max_read_capacity_units): <p>The maximum read capacity units that your account allows you to provision for a new table that you are creating in this Region, including the read capacity units provisioned for its global secondary indexes (GSIs).</p>
    ///   - [`table_max_write_capacity_units(Option<i64>)`](crate::output::DescribeLimitsOutput::table_max_write_capacity_units): <p>The maximum write capacity units that your account allows you to provision for a new table that you are creating in this Region, including the write capacity units provisioned for its global secondary indexes (GSIs).</p>
    /// - On failure, responds with [`SdkError<DescribeLimitsError>`](crate::error::DescribeLimitsError)
    pub fn describe_limits(&self) -> fluent_builders::DescribeLimits {
        fluent_builders::DescribeLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTable`](crate::client::fluent_builders::DescribeTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_table_name): <p>The name of the table to describe.</p>
    /// - On success, responds with [`DescribeTableOutput`](crate::output::DescribeTableOutput) with field(s):
    ///   - [`table(Option<TableDescription>)`](crate::output::DescribeTableOutput::table): <p>The properties of the table.</p>
    /// - On failure, responds with [`SdkError<DescribeTableError>`](crate::error::DescribeTableError)
    pub fn describe_table(&self) -> fluent_builders::DescribeTable {
        fluent_builders::DescribeTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTableReplicaAutoScaling`](crate::client::fluent_builders::DescribeTableReplicaAutoScaling) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTableReplicaAutoScaling::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeTableReplicaAutoScaling::set_table_name): <p>The name of the table.</p>
    /// - On success, responds with [`DescribeTableReplicaAutoScalingOutput`](crate::output::DescribeTableReplicaAutoScalingOutput) with field(s):
    ///   - [`table_auto_scaling_description(Option<TableAutoScalingDescription>)`](crate::output::DescribeTableReplicaAutoScalingOutput::table_auto_scaling_description): <p>Represents the auto scaling properties of the table.</p>
    /// - On failure, responds with [`SdkError<DescribeTableReplicaAutoScalingError>`](crate::error::DescribeTableReplicaAutoScalingError)
    pub fn describe_table_replica_auto_scaling(
        &self,
    ) -> fluent_builders::DescribeTableReplicaAutoScaling {
        fluent_builders::DescribeTableReplicaAutoScaling::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTimeToLive`](crate::client::fluent_builders::DescribeTimeToLive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTimeToLive::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DescribeTimeToLive::set_table_name): <p>The name of the table to be described.</p>
    /// - On success, responds with [`DescribeTimeToLiveOutput`](crate::output::DescribeTimeToLiveOutput) with field(s):
    ///   - [`time_to_live_description(Option<TimeToLiveDescription>)`](crate::output::DescribeTimeToLiveOutput::time_to_live_description): <p></p>
    /// - On failure, responds with [`SdkError<DescribeTimeToLiveError>`](crate::error::DescribeTimeToLiveError)
    pub fn describe_time_to_live(&self) -> fluent_builders::DescribeTimeToLive {
        fluent_builders::DescribeTimeToLive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableKinesisStreamingDestination`](crate::client::fluent_builders::DisableKinesisStreamingDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::DisableKinesisStreamingDestination::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::DisableKinesisStreamingDestination::set_table_name): <p>The name of the DynamoDB table.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::DisableKinesisStreamingDestination::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::DisableKinesisStreamingDestination::set_stream_arn): <p>The ARN for a Kinesis data stream.</p>
    /// - On success, responds with [`DisableKinesisStreamingDestinationOutput`](crate::output::DisableKinesisStreamingDestinationOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::DisableKinesisStreamingDestinationOutput::table_name): <p>The name of the table being modified.</p>
    ///   - [`stream_arn(Option<String>)`](crate::output::DisableKinesisStreamingDestinationOutput::stream_arn): <p>The ARN for the specific Kinesis data stream.</p>
    ///   - [`destination_status(Option<DestinationStatus>)`](crate::output::DisableKinesisStreamingDestinationOutput::destination_status): <p>The current status of the replication.</p>
    /// - On failure, responds with [`SdkError<DisableKinesisStreamingDestinationError>`](crate::error::DisableKinesisStreamingDestinationError)
    pub fn disable_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::DisableKinesisStreamingDestination {
        fluent_builders::DisableKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableKinesisStreamingDestination`](crate::client::fluent_builders::EnableKinesisStreamingDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::EnableKinesisStreamingDestination::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::EnableKinesisStreamingDestination::set_table_name): <p>The name of the DynamoDB table.</p>
    ///   - [`stream_arn(impl Into<String>)`](crate::client::fluent_builders::EnableKinesisStreamingDestination::stream_arn) / [`set_stream_arn(Option<String>)`](crate::client::fluent_builders::EnableKinesisStreamingDestination::set_stream_arn): <p>The ARN for a Kinesis data stream.</p>
    /// - On success, responds with [`EnableKinesisStreamingDestinationOutput`](crate::output::EnableKinesisStreamingDestinationOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::EnableKinesisStreamingDestinationOutput::table_name): <p>The name of the table being modified.</p>
    ///   - [`stream_arn(Option<String>)`](crate::output::EnableKinesisStreamingDestinationOutput::stream_arn): <p>The ARN for the specific Kinesis data stream.</p>
    ///   - [`destination_status(Option<DestinationStatus>)`](crate::output::EnableKinesisStreamingDestinationOutput::destination_status): <p>The current status of the replication.</p>
    /// - On failure, responds with [`SdkError<EnableKinesisStreamingDestinationError>`](crate::error::EnableKinesisStreamingDestinationError)
    pub fn enable_kinesis_streaming_destination(
        &self,
    ) -> fluent_builders::EnableKinesisStreamingDestination {
        fluent_builders::EnableKinesisStreamingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteStatement`](crate::client::fluent_builders::ExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`statement(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::statement) / [`set_statement(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_statement): <p>The PartiQL statement representing the operation to run.</p>
    ///   - [`parameters(Vec<AttributeValue>)`](crate::client::fluent_builders::ExecuteStatement::parameters) / [`set_parameters(Option<Vec<AttributeValue>>)`](crate::client::fluent_builders::ExecuteStatement::set_parameters): <p>The parameters for the PartiQL statement, if any.</p>
    ///   - [`consistent_read(bool)`](crate::client::fluent_builders::ExecuteStatement::consistent_read) / [`set_consistent_read(Option<bool>)`](crate::client::fluent_builders::ExecuteStatement::set_consistent_read): <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_next_token): <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::ExecuteStatement::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::ExecuteStatement::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    /// - On success, responds with [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput) with field(s):
    ///   - [`items(Option<Vec<HashMap<String, AttributeValue>>>)`](crate::output::ExecuteStatementOutput::items): <p>If a read operation was used, this property will contain the result of the read operation; a map of attribute names and their values. For the write operations this value will be empty.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ExecuteStatementOutput::next_token): <p>If the response of a read request exceeds the response payload limit DynamoDB will set this value in the response. If set, you can use that this value in the subsequent request to get the remaining results.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::ExecuteStatementOutput::consumed_capacity): <p>The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the request asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<ExecuteStatementError>`](crate::error::ExecuteStatementError)
    pub fn execute_statement(&self) -> fluent_builders::ExecuteStatement {
        fluent_builders::ExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteTransaction`](crate::client::fluent_builders::ExecuteTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transact_statements(Vec<ParameterizedStatement>)`](crate::client::fluent_builders::ExecuteTransaction::transact_statements) / [`set_transact_statements(Option<Vec<ParameterizedStatement>>)`](crate::client::fluent_builders::ExecuteTransaction::set_transact_statements): <p>The list of PartiQL statements representing the transaction to run.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::ExecuteTransaction::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::ExecuteTransaction::set_client_request_token): <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::ExecuteTransaction::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::ExecuteTransaction::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
    /// - On success, responds with [`ExecuteTransactionOutput`](crate::output::ExecuteTransactionOutput) with field(s):
    ///   - [`responses(Option<Vec<ItemResponse>>)`](crate::output::ExecuteTransactionOutput::responses): <p>The response to a PartiQL transaction.</p>
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::ExecuteTransactionOutput::consumed_capacity): <p>The capacity units consumed by the entire operation. The values of the list are ordered according to the ordering of the statements.</p>
    /// - On failure, responds with [`SdkError<ExecuteTransactionError>`](crate::error::ExecuteTransactionError)
    pub fn execute_transaction(&self) -> fluent_builders::ExecuteTransaction {
        fluent_builders::ExecuteTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExportTableToPointInTime`](crate::client::fluent_builders::ExportTableToPointInTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_arn(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::table_arn) / [`set_table_arn(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_table_arn): <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
    ///   - [`export_time(DateTime)`](crate::client::fluent_builders::ExportTableToPointInTime::export_time) / [`set_export_time(Option<DateTime>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_export_time): <p>Time in the past from which to export table data. The table export will be a snapshot of the table's state at this point in time.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_client_token): <p>Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>  <p>A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.</p>  <p>If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
    ///   - [`s3_bucket(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::s3_bucket) / [`set_s3_bucket(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_s3_bucket): <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
    ///   - [`s3_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::s3_bucket_owner) / [`set_s3_bucket_owner(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_s3_bucket_owner): <p>The ID of the Amazon Web Services account that owns the bucket the export will be stored in.</p>
    ///   - [`s3_prefix(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::s3_prefix) / [`set_s3_prefix(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_s3_prefix): <p>The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.</p>
    ///   - [`s3_sse_algorithm(S3SseAlgorithm)`](crate::client::fluent_builders::ExportTableToPointInTime::s3_sse_algorithm) / [`set_s3_sse_algorithm(Option<S3SseAlgorithm>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_s3_sse_algorithm): <p>Type of encryption used on the bucket where export data will be stored. Valid values for <code>S3SseAlgorithm</code> are:</p>  <ul>   <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>   <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>  </ul>
    ///   - [`s3_sse_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::s3_sse_kms_key_id) / [`set_s3_sse_kms_key_id(Option<String>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_s3_sse_kms_key_id): <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).</p>
    ///   - [`export_format(ExportFormat)`](crate::client::fluent_builders::ExportTableToPointInTime::export_format) / [`set_export_format(Option<ExportFormat>)`](crate::client::fluent_builders::ExportTableToPointInTime::set_export_format): <p>The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
    /// - On success, responds with [`ExportTableToPointInTimeOutput`](crate::output::ExportTableToPointInTimeOutput) with field(s):
    ///   - [`export_description(Option<ExportDescription>)`](crate::output::ExportTableToPointInTimeOutput::export_description): <p>Contains a description of the table export.</p>
    /// - On failure, responds with [`SdkError<ExportTableToPointInTimeError>`](crate::error::ExportTableToPointInTimeError)
    pub fn export_table_to_point_in_time(&self) -> fluent_builders::ExportTableToPointInTime {
        fluent_builders::ExportTableToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetItem`](crate::client::fluent_builders::GetItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::GetItem::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::GetItem::set_table_name): <p>The name of the table containing the requested item.</p>
    ///   - [`key(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::GetItem::key) / [`set_key(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::GetItem::set_key): <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to retrieve.</p>  <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
    ///   - [`attributes_to_get(Vec<String>)`](crate::client::fluent_builders::GetItem::attributes_to_get) / [`set_attributes_to_get(Option<Vec<String>>)`](crate::client::fluent_builders::GetItem::set_attributes_to_get): <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`consistent_read(bool)`](crate::client::fluent_builders::GetItem::consistent_read) / [`set_consistent_read(Option<bool>)`](crate::client::fluent_builders::GetItem::set_consistent_read): <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::GetItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::GetItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`projection_expression(impl Into<String>)`](crate::client::fluent_builders::GetItem::projection_expression) / [`set_projection_expression(Option<String>)`](crate::client::fluent_builders::GetItem::set_projection_expression): <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>  <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::GetItem::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::GetItem::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On success, responds with [`GetItemOutput`](crate::output::GetItemOutput) with field(s):
    ///   - [`item(Option<HashMap<String, AttributeValue>>)`](crate::output::GetItemOutput::item): <p>A map of attribute names to <code>AttributeValue</code> objects, as specified by <code>ProjectionExpression</code>.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::GetItemOutput::consumed_capacity): <p>The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetItemError>`](crate::error::GetItemError)
    pub fn get_item(&self) -> fluent_builders::GetItem {
        fluent_builders::GetItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBackups`](crate::client::fluent_builders::ListBackups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::ListBackups::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::ListBackups::set_table_name): <p>The backups from the table specified by <code>TableName</code> are listed. </p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListBackups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListBackups::set_limit): <p>Maximum number of backups to return at once.</p>
    ///   - [`time_range_lower_bound(DateTime)`](crate::client::fluent_builders::ListBackups::time_range_lower_bound) / [`set_time_range_lower_bound(Option<DateTime>)`](crate::client::fluent_builders::ListBackups::set_time_range_lower_bound): <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>
    ///   - [`time_range_upper_bound(DateTime)`](crate::client::fluent_builders::ListBackups::time_range_upper_bound) / [`set_time_range_upper_bound(Option<DateTime>)`](crate::client::fluent_builders::ListBackups::set_time_range_upper_bound): <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>
    ///   - [`exclusive_start_backup_arn(impl Into<String>)`](crate::client::fluent_builders::ListBackups::exclusive_start_backup_arn) / [`set_exclusive_start_backup_arn(Option<String>)`](crate::client::fluent_builders::ListBackups::set_exclusive_start_backup_arn): <p> <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
    ///   - [`backup_type(BackupTypeFilter)`](crate::client::fluent_builders::ListBackups::backup_type) / [`set_backup_type(Option<BackupTypeFilter>)`](crate::client::fluent_builders::ListBackups::set_backup_type): <p>The backups from the table specified by <code>BackupType</code> are listed.</p>  <p>Where <code>BackupType</code> can be:</p>  <ul>   <li> <p> <code>USER</code> - On-demand backup created by you.</p> </li>   <li> <p> <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p> </li>   <li> <p> <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p> </li>  </ul>
    /// - On success, responds with [`ListBackupsOutput`](crate::output::ListBackupsOutput) with field(s):
    ///   - [`backup_summaries(Option<Vec<BackupSummary>>)`](crate::output::ListBackupsOutput::backup_summaries): <p>List of <code>BackupSummary</code> objects.</p>
    ///   - [`last_evaluated_backup_arn(Option<String>)`](crate::output::ListBackupsOutput::last_evaluated_backup_arn): <p> The ARN of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p>  <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has been processed and there are no more results to be retrieved. </p>  <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate that there is more data to be returned. All results are guaranteed to have been returned if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>
    /// - On failure, responds with [`SdkError<ListBackupsError>`](crate::error::ListBackupsError)
    pub fn list_backups(&self) -> fluent_builders::ListBackups {
        fluent_builders::ListBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContributorInsights`](crate::client::fluent_builders::ListContributorInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContributorInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::ListContributorInsights::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::ListContributorInsights::set_table_name): <p>The name of the table.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContributorInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContributorInsights::set_next_token): <p>A token to for the desired page, if there is one.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContributorInsights::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListContributorInsights::set_max_results): <p>Maximum number of results to return per page.</p>
    /// - On success, responds with [`ListContributorInsightsOutput`](crate::output::ListContributorInsightsOutput) with field(s):
    ///   - [`contributor_insights_summaries(Option<Vec<ContributorInsightsSummary>>)`](crate::output::ListContributorInsightsOutput::contributor_insights_summaries): <p>A list of ContributorInsightsSummary.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContributorInsightsOutput::next_token): <p>A token to go to the next page if there is one.</p>
    /// - On failure, responds with [`SdkError<ListContributorInsightsError>`](crate::error::ListContributorInsightsError)
    pub fn list_contributor_insights(&self) -> fluent_builders::ListContributorInsights {
        fluent_builders::ListContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExports`](crate::client::fluent_builders::ListExports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_arn(impl Into<String>)`](crate::client::fluent_builders::ListExports::table_arn) / [`set_table_arn(Option<String>)`](crate::client::fluent_builders::ListExports::set_table_arn): <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExports::set_max_results): <p>Maximum number of results to return per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExports::set_next_token): <p>An optional string that, if supplied, must be copied from the output of a previous call to <code>ListExports</code>. When provided in this manner, the API fetches the next page of results.</p>
    /// - On success, responds with [`ListExportsOutput`](crate::output::ListExportsOutput) with field(s):
    ///   - [`export_summaries(Option<Vec<ExportSummary>>)`](crate::output::ListExportsOutput::export_summaries): <p>A list of <code>ExportSummary</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExportsOutput::next_token): <p>If this value is returned, there are additional results to be displayed. To retrieve them, call <code>ListExports</code> again, with <code>NextToken</code> set to this value.</p>
    /// - On failure, responds with [`SdkError<ListExportsError>`](crate::error::ListExportsError)
    pub fn list_exports(&self) -> fluent_builders::ListExports {
        fluent_builders::ListExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGlobalTables`](crate::client::fluent_builders::ListGlobalTables) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`exclusive_start_global_table_name(impl Into<String>)`](crate::client::fluent_builders::ListGlobalTables::exclusive_start_global_table_name) / [`set_exclusive_start_global_table_name(Option<String>)`](crate::client::fluent_builders::ListGlobalTables::set_exclusive_start_global_table_name): <p>The first global table name that this operation will evaluate.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGlobalTables::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListGlobalTables::set_limit): <p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p>  <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point, with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>
    ///   - [`region_name(impl Into<String>)`](crate::client::fluent_builders::ListGlobalTables::region_name) / [`set_region_name(Option<String>)`](crate::client::fluent_builders::ListGlobalTables::set_region_name): <p>Lists the global tables in a specific Region.</p>
    /// - On success, responds with [`ListGlobalTablesOutput`](crate::output::ListGlobalTablesOutput) with field(s):
    ///   - [`global_tables(Option<Vec<GlobalTable>>)`](crate::output::ListGlobalTablesOutput::global_tables): <p>List of global table names.</p>
    ///   - [`last_evaluated_global_table_name(Option<String>)`](crate::output::ListGlobalTablesOutput::last_evaluated_global_table_name): <p>Last evaluated global table name.</p>
    /// - On failure, responds with [`SdkError<ListGlobalTablesError>`](crate::error::ListGlobalTablesError)
    pub fn list_global_tables(&self) -> fluent_builders::ListGlobalTables {
        fluent_builders::ListGlobalTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTables`](crate::client::fluent_builders::ListTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`exclusive_start_table_name(impl Into<String>)`](crate::client::fluent_builders::ListTables::exclusive_start_table_name) / [`set_exclusive_start_table_name(Option<String>)`](crate::client::fluent_builders::ListTables::set_exclusive_start_table_name): <p>The first table name that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTables::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTables::set_limit): <p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>
    /// - On success, responds with [`ListTablesOutput`](crate::output::ListTablesOutput) with field(s):
    ///   - [`table_names(Option<Vec<String>>)`](crate::output::ListTablesOutput::table_names): <p>The names of the tables associated with the current account at the current endpoint. The maximum size of this array is 100.</p>  <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this value as the <code>ExclusiveStartTableName</code> parameter in a subsequent <code>ListTables</code> request and obtain the next page of results.</p>
    ///   - [`last_evaluated_table_name(Option<String>)`](crate::output::ListTablesOutput::last_evaluated_table_name): <p>The name of the last table in the current page of results. Use this value as the <code>ExclusiveStartTableName</code> in a new request to obtain the next page of results, until all the table names are returned.</p>  <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response, this means that there are no more table names to be retrieved.</p>
    /// - On failure, responds with [`SdkError<ListTablesError>`](crate::error::ListTablesError)
    pub fn list_tables(&self) -> fluent_builders::ListTables {
        fluent_builders::ListTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsOfResource`](crate::client::fluent_builders::ListTagsOfResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsOfResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsOfResource::set_resource_arn): <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsOfResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsOfResource::set_next_token): <p>An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>
    /// - On success, responds with [`ListTagsOfResourceOutput`](crate::output::ListTagsOfResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsOfResourceOutput::tags): <p>The tags currently associated with the Amazon DynamoDB resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsOfResourceOutput::next_token): <p>If this value is returned, there are additional results to be displayed. To retrieve them, call ListTagsOfResource again, with NextToken set to this value.</p>
    /// - On failure, responds with [`SdkError<ListTagsOfResourceError>`](crate::error::ListTagsOfResourceError)
    pub fn list_tags_of_resource(&self) -> fluent_builders::ListTagsOfResource {
        fluent_builders::ListTagsOfResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutItem`](crate::client::fluent_builders::PutItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::PutItem::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::PutItem::set_table_name): <p>The name of the table to contain the item.</p>
    ///   - [`item(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::PutItem::item) / [`set_item(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::PutItem::set_item): <p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p>  <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p>  <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>  <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p>  <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>  <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>
    ///   - [`expected(HashMap<String, ExpectedAttributeValue>)`](crate::client::fluent_builders::PutItem::expected) / [`set_expected(Option<HashMap<String, ExpectedAttributeValue>>)`](crate::client::fluent_builders::PutItem::set_expected): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`return_values(ReturnValue)`](crate::client::fluent_builders::PutItem::return_values) / [`set_return_values(Option<ReturnValue>)`](crate::client::fluent_builders::PutItem::set_return_values): <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>  <ul>   <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>   <li> <p> <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the old item is returned.</p> </li>  </ul>  <p>The values returned are strongly consistent.</p> <note>   <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>  </note>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::PutItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::PutItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`return_item_collection_metrics(ReturnItemCollectionMetrics)`](crate::client::fluent_builders::PutItem::return_item_collection_metrics) / [`set_return_item_collection_metrics(Option<ReturnItemCollectionMetrics>)`](crate::client::fluent_builders::PutItem::set_return_item_collection_metrics): <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
    ///   - [`conditional_operator(ConditionalOperator)`](crate::client::fluent_builders::PutItem::conditional_operator) / [`set_conditional_operator(Option<ConditionalOperator>)`](crate::client::fluent_builders::PutItem::set_conditional_operator): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`condition_expression(impl Into<String>)`](crate::client::fluent_builders::PutItem::condition_expression) / [`set_condition_expression(Option<String>)`](crate::client::fluent_builders::PutItem::set_condition_expression): <p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.</p>  <p>An expression can contain any of the following:</p>  <ul>   <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>   <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>   <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>  </ul>  <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::PutItem::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutItem::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_values(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::PutItem::expression_attribute_values) / [`set_expression_attribute_values(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::PutItem::set_expression_attribute_values): <p>One or more values that can be substituted in an expression.</p>  <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>  <p> <code>Available | Backordered | Discontinued</code> </p>  <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>  <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>  <p>You could then use these values in an expression, such as this:</p>  <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>  <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On success, responds with [`PutItemOutput`](crate::output::PutItemOutput) with field(s):
    ///   - [`attributes(Option<HashMap<String, AttributeValue>>)`](crate::output::PutItemOutput::attributes): <p>The attribute values as they appeared before the <code>PutItem</code> operation, but only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request. Each element consists of an attribute name and an attribute value.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::PutItemOutput::consumed_capacity): <p>The capacity units consumed by the <code>PutItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`item_collection_metrics(Option<ItemCollectionMetrics>)`](crate::output::PutItemOutput::item_collection_metrics): <p>Information about item collections, if any, that were affected by the <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p>  <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>  <ul>   <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li>   <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<PutItemError>`](crate::error::PutItemError)
    pub fn put_item(&self) -> fluent_builders::PutItem {
        fluent_builders::PutItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Query`](crate::client::fluent_builders::Query) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::Query::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::Query::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::Query::set_table_name): <p>The name of the table containing the requested items.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::Query::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::Query::set_index_name): <p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code> </p>
    ///   - [`select(Select)`](crate::client::fluent_builders::Query::select) / [`set_select(Option<Select>)`](crate::client::fluent_builders::Query::set_select): <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>  <ul>   <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>   <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>   <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>   <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>  </ul>  <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>   <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>  </note>
    ///   - [`attributes_to_get(Vec<String>)`](crate::client::fluent_builders::Query::attributes_to_get) / [`set_attributes_to_get(Option<Vec<String>>)`](crate::client::fluent_builders::Query::set_attributes_to_get): <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::Query::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::Query::set_limit): <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`consistent_read(bool)`](crate::client::fluent_builders::Query::consistent_read) / [`set_consistent_read(Option<bool>)`](crate::client::fluent_builders::Query::set_consistent_read): <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>  <p>Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.</p>
    ///   - [`key_conditions(HashMap<String, Condition>)`](crate::client::fluent_builders::Query::key_conditions) / [`set_key_conditions(Option<HashMap<String, Condition>>)`](crate::client::fluent_builders::Query::set_key_conditions): <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`query_filter(HashMap<String, Condition>)`](crate::client::fluent_builders::Query::query_filter) / [`set_query_filter(Option<HashMap<String, Condition>>)`](crate::client::fluent_builders::Query::set_query_filter): <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`conditional_operator(ConditionalOperator)`](crate::client::fluent_builders::Query::conditional_operator) / [`set_conditional_operator(Option<ConditionalOperator>)`](crate::client::fluent_builders::Query::set_conditional_operator): <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`scan_index_forward(bool)`](crate::client::fluent_builders::Query::scan_index_forward) / [`set_scan_index_forward(Option<bool>)`](crate::client::fluent_builders::Query::set_scan_index_forward): <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p>  <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p>  <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>
    ///   - [`exclusive_start_key(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::Query::exclusive_start_key) / [`set_exclusive_start_key(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::Query::set_exclusive_start_key): <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>  <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are allowed.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::Query::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::Query::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`projection_expression(impl Into<String>)`](crate::client::fluent_builders::Query::projection_expression) / [`set_projection_expression(Option<String>)`](crate::client::fluent_builders::Query::set_projection_expression): <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>  <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`filter_expression(impl Into<String>)`](crate::client::fluent_builders::Query::filter_expression) / [`set_filter_expression(Option<String>)`](crate::client::fluent_builders::Query::set_filter_expression): <p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p>  <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.</p> <note>   <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>  </note>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`key_condition_expression(impl Into<String>)`](crate::client::fluent_builders::Query::key_condition_expression) / [`set_key_condition_expression(Option<String>)`](crate::client::fluent_builders::Query::set_key_condition_expression): <p>The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.</p>  <p>The condition must perform an equality test on a single partition key value.</p>  <p>The condition can optionally perform one of several comparison tests on a single sort key value. This allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.</p>  <p>The partition key equality test is required, and must be specified in the following format:</p>  <p> <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code> </p>  <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p>  <p> <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> </p>  <p>Valid comparisons for the sort key condition are as follows:</p>  <ul>   <li> <p> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p> </li>   <li> <p> <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p> </li>   <li> <p> <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or equal to <code>:sortkeyval</code>.</p> </li>   <li> <p> <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p> </li>   <li> <p> <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater than or equal to <code>:sortkeyval</code>.</p> </li>   <li> <p> <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code> <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p> </li>   <li> <p> <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.</p> </li>  </ul>  <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p>  <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:</p>  <ul>   <li> <p> <code>Size = :myval</code> </p> </li>  </ul>  <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p>  <ul>   <li> <p> <code>#S = :myval</code> </p> </li>  </ul>  <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>  <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::Query::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Query::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_values(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::Query::expression_attribute_values) / [`set_expression_attribute_values(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::Query::set_expression_attribute_values): <p>One or more values that can be substituted in an expression.</p>  <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>  <p> <code>Available | Backordered | Discontinued</code> </p>  <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>  <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>  <p>You could then use these values in an expression, such as this:</p>  <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>  <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On success, responds with [`QueryOutput`](crate::output::QueryOutput) with field(s):
    ///   - [`items(Option<Vec<HashMap<String, AttributeValue>>>)`](crate::output::QueryOutput::items): <p>An array of item attributes that match the query criteria. Each element in this array consists of an attribute name and the value for that attribute.</p>
    ///   - [`count(i32)`](crate::output::QueryOutput::count): <p>The number of items in the response.</p>  <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the number of items returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was applied.</p>  <p>If you did not use a filter in the request, then <code>Count</code> and <code>ScannedCount</code> are the same.</p>
    ///   - [`scanned_count(i32)`](crate::output::QueryOutput::scanned_count): <p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>  <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.</p>
    ///   - [`last_evaluated_key(Option<HashMap<String, AttributeValue>>)`](crate::output::QueryOutput::last_evaluated_key): <p>The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.</p>  <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved.</p>  <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::QueryOutput::consumed_capacity): <p>The capacity units consumed by the <code>Query</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<QueryError>`](crate::error::QueryError)
    pub fn query(&self) -> fluent_builders::Query {
        fluent_builders::Query::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreTableFromBackup`](crate::client::fluent_builders::RestoreTableFromBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromBackup::target_table_name) / [`set_target_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_target_table_name): <p>The name of the new table to which the backup must be restored.</p>
    ///   - [`backup_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromBackup::backup_arn) / [`set_backup_arn(Option<String>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_backup_arn): <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    ///   - [`billing_mode_override(BillingMode)`](crate::client::fluent_builders::RestoreTableFromBackup::billing_mode_override) / [`set_billing_mode_override(Option<BillingMode>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_billing_mode_override): <p>The billing mode of the restored table.</p>
    ///   - [`global_secondary_index_override(Vec<GlobalSecondaryIndex>)`](crate::client::fluent_builders::RestoreTableFromBackup::global_secondary_index_override) / [`set_global_secondary_index_override(Option<Vec<GlobalSecondaryIndex>>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_global_secondary_index_override): <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
    ///   - [`local_secondary_index_override(Vec<LocalSecondaryIndex>)`](crate::client::fluent_builders::RestoreTableFromBackup::local_secondary_index_override) / [`set_local_secondary_index_override(Option<Vec<LocalSecondaryIndex>>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_local_secondary_index_override): <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
    ///   - [`provisioned_throughput_override(ProvisionedThroughput)`](crate::client::fluent_builders::RestoreTableFromBackup::provisioned_throughput_override) / [`set_provisioned_throughput_override(Option<ProvisionedThroughput>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_provisioned_throughput_override): <p>Provisioned throughput settings for the restored table.</p>
    ///   - [`sse_specification_override(SseSpecification)`](crate::client::fluent_builders::RestoreTableFromBackup::sse_specification_override) / [`set_sse_specification_override(Option<SseSpecification>)`](crate::client::fluent_builders::RestoreTableFromBackup::set_sse_specification_override): <p>The new server-side encryption settings for the restored table.</p>
    /// - On success, responds with [`RestoreTableFromBackupOutput`](crate::output::RestoreTableFromBackupOutput) with field(s):
    ///   - [`table_description(Option<TableDescription>)`](crate::output::RestoreTableFromBackupOutput::table_description): <p>The description of the table created from an existing backup.</p>
    /// - On failure, responds with [`SdkError<RestoreTableFromBackupError>`](crate::error::RestoreTableFromBackupError)
    pub fn restore_table_from_backup(&self) -> fluent_builders::RestoreTableFromBackup {
        fluent_builders::RestoreTableFromBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreTableToPointInTime`](crate::client::fluent_builders::RestoreTableToPointInTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_table_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::source_table_arn) / [`set_source_table_arn(Option<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_source_table_arn): <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).</p>
    ///   - [`source_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::source_table_name) / [`set_source_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_source_table_name): <p>Name of the source table that is being restored.</p>
    ///   - [`target_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::target_table_name) / [`set_target_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_target_table_name): <p>The name of the new table to which it must be restored to.</p>
    ///   - [`use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreTableToPointInTime::use_latest_restorable_time) / [`set_use_latest_restorable_time(Option<bool>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_use_latest_restorable_time): <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
    ///   - [`restore_date_time(DateTime)`](crate::client::fluent_builders::RestoreTableToPointInTime::restore_date_time) / [`set_restore_date_time(Option<DateTime>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_restore_date_time): <p>Time in the past to restore the table to.</p>
    ///   - [`billing_mode_override(BillingMode)`](crate::client::fluent_builders::RestoreTableToPointInTime::billing_mode_override) / [`set_billing_mode_override(Option<BillingMode>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_billing_mode_override): <p>The billing mode of the restored table.</p>
    ///   - [`global_secondary_index_override(Vec<GlobalSecondaryIndex>)`](crate::client::fluent_builders::RestoreTableToPointInTime::global_secondary_index_override) / [`set_global_secondary_index_override(Option<Vec<GlobalSecondaryIndex>>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_global_secondary_index_override): <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
    ///   - [`local_secondary_index_override(Vec<LocalSecondaryIndex>)`](crate::client::fluent_builders::RestoreTableToPointInTime::local_secondary_index_override) / [`set_local_secondary_index_override(Option<Vec<LocalSecondaryIndex>>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_local_secondary_index_override): <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
    ///   - [`provisioned_throughput_override(ProvisionedThroughput)`](crate::client::fluent_builders::RestoreTableToPointInTime::provisioned_throughput_override) / [`set_provisioned_throughput_override(Option<ProvisionedThroughput>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_provisioned_throughput_override): <p>Provisioned throughput settings for the restored table.</p>
    ///   - [`sse_specification_override(SseSpecification)`](crate::client::fluent_builders::RestoreTableToPointInTime::sse_specification_override) / [`set_sse_specification_override(Option<SseSpecification>)`](crate::client::fluent_builders::RestoreTableToPointInTime::set_sse_specification_override): <p>The new server-side encryption settings for the restored table.</p>
    /// - On success, responds with [`RestoreTableToPointInTimeOutput`](crate::output::RestoreTableToPointInTimeOutput) with field(s):
    ///   - [`table_description(Option<TableDescription>)`](crate::output::RestoreTableToPointInTimeOutput::table_description): <p>Represents the properties of a table.</p>
    /// - On failure, responds with [`SdkError<RestoreTableToPointInTimeError>`](crate::error::RestoreTableToPointInTimeError)
    pub fn restore_table_to_point_in_time(&self) -> fluent_builders::RestoreTableToPointInTime {
        fluent_builders::RestoreTableToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Scan`](crate::client::fluent_builders::Scan) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::Scan::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::Scan::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::Scan::set_table_name): <p>The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of the table to which that index belongs.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::Scan::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::Scan::set_index_name): <p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>
    ///   - [`attributes_to_get(Vec<String>)`](crate::client::fluent_builders::Scan::attributes_to_get) / [`set_attributes_to_get(Option<Vec<String>>)`](crate::client::fluent_builders::Scan::set_attributes_to_get): <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::Scan::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::Scan::set_limit): <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`select(Select)`](crate::client::fluent_builders::Scan::select) / [`set_select(Option<Select>)`](crate::client::fluent_builders::Scan::set_select): <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>  <ul>   <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>   <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>   <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>   <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation reads only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>  </ul>  <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>   <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>  </note>
    ///   - [`scan_filter(HashMap<String, Condition>)`](crate::client::fluent_builders::Scan::scan_filter) / [`set_scan_filter(Option<HashMap<String, Condition>>)`](crate::client::fluent_builders::Scan::set_scan_filter): <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`conditional_operator(ConditionalOperator)`](crate::client::fluent_builders::Scan::conditional_operator) / [`set_conditional_operator(Option<ConditionalOperator>)`](crate::client::fluent_builders::Scan::set_conditional_operator): <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`exclusive_start_key(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::Scan::exclusive_start_key) / [`set_exclusive_start_key(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::Scan::set_exclusive_start_key): <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>  <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p>  <p>In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::Scan::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::Scan::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`total_segments(i32)`](crate::client::fluent_builders::Scan::total_segments) / [`set_total_segments(Option<i32>)`](crate::client::fluent_builders::Scan::set_total_segments): <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments into which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code> corresponds to the number of application workers that will perform the parallel scan. For example, if you want to use four application threads to scan a table or an index, specify a <code>TotalSegments</code> value of 4.</p>  <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be sequential rather than parallel.</p>  <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>
    ///   - [`segment(i32)`](crate::client::fluent_builders::Scan::segment) / [`set_segment(Option<i32>)`](crate::client::fluent_builders::Scan::set_segment): <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned by an application worker.</p>  <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so on.</p>  <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.</p>  <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for <code>TotalSegments</code>.</p>  <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>
    ///   - [`projection_expression(impl Into<String>)`](crate::client::fluent_builders::Scan::projection_expression) / [`set_projection_expression(Option<String>)`](crate::client::fluent_builders::Scan::set_projection_expression): <p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>  <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`filter_expression(impl Into<String>)`](crate::client::fluent_builders::Scan::filter_expression) / [`set_filter_expression(Option<String>)`](crate::client::fluent_builders::Scan::set_filter_expression): <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p> <note>   <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>  </note>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::Scan::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Scan::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_values(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::Scan::expression_attribute_values) / [`set_expression_attribute_values(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::Scan::set_expression_attribute_values): <p>One or more values that can be substituted in an expression.</p>  <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>  <p> <code>Available | Backordered | Discontinued</code> </p>  <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>  <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>  <p>You could then use these values in an expression, such as this:</p>  <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>  <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`consistent_read(bool)`](crate::client::fluent_builders::Scan::consistent_read) / [`set_consistent_read(Option<bool>)`](crate::client::fluent_builders::Scan::set_consistent_read): <p>A Boolean value that determines the read consistency model during the scan:</p>  <ul>   <li> <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not contain the results from other recently completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or <code>DeleteItem</code>).</p> </li>   <li> <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p> </li>  </ul>  <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>  <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>
    /// - On success, responds with [`ScanOutput`](crate::output::ScanOutput) with field(s):
    ///   - [`items(Option<Vec<HashMap<String, AttributeValue>>>)`](crate::output::ScanOutput::items): <p>An array of item attributes that match the scan criteria. Each element in this array consists of an attribute name and the value for that attribute.</p>
    ///   - [`count(i32)`](crate::output::ScanOutput::count): <p>The number of items in the response.</p>  <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the number of items returned after the filter was applied, and <code>ScannedCount</code> is the number of matching items before the filter was applied.</p>  <p>If you did not use a filter in the request, then <code>Count</code> is the same as <code>ScannedCount</code>.</p>
    ///   - [`scanned_count(i32)`](crate::output::ScanOutput::scanned_count): <p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high <code>ScannedCount</code> value with few, or no, <code>Count</code> results indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and ScannedCount</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>  <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same as <code>Count</code>.</p>
    ///   - [`last_evaluated_key(Option<HashMap<String, AttributeValue>>)`](crate::output::ScanOutput::last_evaluated_key): <p>The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.</p>  <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there is no more data to be retrieved.</p>  <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::ScanOutput::consumed_capacity): <p>The capacity units consumed by the <code>Scan</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<ScanError>`](crate::error::ScanError)
    pub fn scan(&self) -> fluent_builders::Scan {
        fluent_builders::Scan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TransactGetItems`](crate::client::fluent_builders::TransactGetItems) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transact_items(Vec<TransactGetItem>)`](crate::client::fluent_builders::TransactGetItems::transact_items) / [`set_transact_items(Option<Vec<TransactGetItem>>)`](crate::client::fluent_builders::TransactGetItems::set_transact_items): <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::TransactGetItems::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::TransactGetItems::set_return_consumed_capacity): <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of <code>NONE</code> prevents that information from being returned. No other value is valid.</p>
    /// - On success, responds with [`TransactGetItemsOutput`](crate::output::TransactGetItemsOutput) with field(s):
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::TransactGetItemsOutput::consumed_capacity): <p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by <code>TransactGetItem</code> objects in the <i>TransactItems</i> parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units consumed by the <code>TransactGetItems</code> call in that table.</p>
    ///   - [`responses(Option<Vec<ItemResponse>>)`](crate::output::TransactGetItemsOutput::responses): <p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which corresponds to the <code>TransactGetItem</code> object in the same position in the <i>TransactItems</i> array. Each <code>ItemResponse</code> object contains a Map of the name-value pairs that are the projected attributes of the requested item.</p>  <p>If a requested item could not be retrieved, the corresponding <code>ItemResponse</code> object is Null, or if the requested item has no projected attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>
    /// - On failure, responds with [`SdkError<TransactGetItemsError>`](crate::error::TransactGetItemsError)
    pub fn transact_get_items(&self) -> fluent_builders::TransactGetItems {
        fluent_builders::TransactGetItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TransactWriteItems`](crate::client::fluent_builders::TransactWriteItems) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`transact_items(Vec<TransactWriteItem>)`](crate::client::fluent_builders::TransactWriteItems::transact_items) / [`set_transact_items(Option<Vec<TransactWriteItem>>)`](crate::client::fluent_builders::TransactWriteItems::set_transact_items): <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can operate on items in different tables, but the tables must reside in the same Amazon Web Services account and Region, and no two of them can operate on the same item. </p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::TransactWriteItems::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::TransactWriteItems::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`return_item_collection_metrics(ReturnItemCollectionMetrics)`](crate::client::fluent_builders::TransactWriteItems::return_item_collection_metrics) / [`set_return_item_collection_metrics(Option<ReturnItemCollectionMetrics>)`](crate::client::fluent_builders::TransactWriteItems::set_return_item_collection_metrics): <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections (if any), that were modified during the operation and are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::TransactWriteItems::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::TransactWriteItems::set_client_request_token): <p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>  <p>Although multiple identical calls using the same client request token produce the same result on the server (no side effects), the responses to the calls might not be the same. If the <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number of read capacity units consumed in reading the item.</p>  <p>A client request token is valid for 10 minutes after the first request that uses it is completed. After 10 minutes, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 10 minutes, or the result might not be idempotent.</p>  <p>If you submit a request with the same client token but a change in other parameters within the 10-minute idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
    /// - On success, responds with [`TransactWriteItemsOutput`](crate::output::TransactWriteItemsOutput) with field(s):
    ///   - [`consumed_capacity(Option<Vec<ConsumedCapacity>>)`](crate::output::TransactWriteItemsOutput::consumed_capacity): <p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation. The values of the list are ordered according to the ordering of the <code>TransactItems</code> request parameter. </p>
    ///   - [`item_collection_metrics(Option<HashMap<String, Vec<ItemCollectionMetrics>>>)`](crate::output::TransactWriteItemsOutput::item_collection_metrics): <p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each table, information about any item collections that were affected by individual <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code> operations. </p>
    /// - On failure, responds with [`SdkError<TransactWriteItemsError>`](crate::error::TransactWriteItemsError)
    pub fn transact_write_items(&self) -> fluent_builders::TransactWriteItems {
        fluent_builders::TransactWriteItems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys. Existing tags of the resource whose keys are members of this list will be removed from the DynamoDB resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContinuousBackups`](crate::client::fluent_builders::UpdateContinuousBackups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContinuousBackups::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateContinuousBackups::set_table_name): <p>The name of the table.</p>
    ///   - [`point_in_time_recovery_specification(PointInTimeRecoverySpecification)`](crate::client::fluent_builders::UpdateContinuousBackups::point_in_time_recovery_specification) / [`set_point_in_time_recovery_specification(Option<PointInTimeRecoverySpecification>)`](crate::client::fluent_builders::UpdateContinuousBackups::set_point_in_time_recovery_specification): <p>Represents the settings used to enable point in time recovery.</p>
    /// - On success, responds with [`UpdateContinuousBackupsOutput`](crate::output::UpdateContinuousBackupsOutput) with field(s):
    ///   - [`continuous_backups_description(Option<ContinuousBackupsDescription>)`](crate::output::UpdateContinuousBackupsOutput::continuous_backups_description): <p>Represents the continuous backups and point in time recovery settings on the table.</p>
    /// - On failure, responds with [`SdkError<UpdateContinuousBackupsError>`](crate::error::UpdateContinuousBackupsError)
    pub fn update_continuous_backups(&self) -> fluent_builders::UpdateContinuousBackups {
        fluent_builders::UpdateContinuousBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContributorInsights`](crate::client::fluent_builders::UpdateContributorInsights) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContributorInsights::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateContributorInsights::set_table_name): <p>The name of the table.</p>
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::UpdateContributorInsights::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::UpdateContributorInsights::set_index_name): <p>The global secondary index name, if applicable.</p>
    ///   - [`contributor_insights_action(ContributorInsightsAction)`](crate::client::fluent_builders::UpdateContributorInsights::contributor_insights_action) / [`set_contributor_insights_action(Option<ContributorInsightsAction>)`](crate::client::fluent_builders::UpdateContributorInsights::set_contributor_insights_action): <p>Represents the contributor insights action.</p>
    /// - On success, responds with [`UpdateContributorInsightsOutput`](crate::output::UpdateContributorInsightsOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::UpdateContributorInsightsOutput::table_name): <p>The name of the table.</p>
    ///   - [`index_name(Option<String>)`](crate::output::UpdateContributorInsightsOutput::index_name): <p>The name of the global secondary index, if applicable.</p>
    ///   - [`contributor_insights_status(Option<ContributorInsightsStatus>)`](crate::output::UpdateContributorInsightsOutput::contributor_insights_status): <p>The status of contributor insights</p>
    /// - On failure, responds with [`SdkError<UpdateContributorInsightsError>`](crate::error::UpdateContributorInsightsError)
    pub fn update_contributor_insights(&self) -> fluent_builders::UpdateContributorInsights {
        fluent_builders::UpdateContributorInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGlobalTable`](crate::client::fluent_builders::UpdateGlobalTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGlobalTable::global_table_name) / [`set_global_table_name(Option<String>)`](crate::client::fluent_builders::UpdateGlobalTable::set_global_table_name): <p>The global table name.</p>
    ///   - [`replica_updates(Vec<ReplicaUpdate>)`](crate::client::fluent_builders::UpdateGlobalTable::replica_updates) / [`set_replica_updates(Option<Vec<ReplicaUpdate>>)`](crate::client::fluent_builders::UpdateGlobalTable::set_replica_updates): <p>A list of Regions that should be added or removed from the global table.</p>
    /// - On success, responds with [`UpdateGlobalTableOutput`](crate::output::UpdateGlobalTableOutput) with field(s):
    ///   - [`global_table_description(Option<GlobalTableDescription>)`](crate::output::UpdateGlobalTableOutput::global_table_description): <p>Contains the details of the global table.</p>
    /// - On failure, responds with [`SdkError<UpdateGlobalTableError>`](crate::error::UpdateGlobalTableError)
    pub fn update_global_table(&self) -> fluent_builders::UpdateGlobalTable {
        fluent_builders::UpdateGlobalTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGlobalTableSettings`](crate::client::fluent_builders::UpdateGlobalTableSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::global_table_name) / [`set_global_table_name(Option<String>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_global_table_name): <p>The name of the global table</p>
    ///   - [`global_table_billing_mode(BillingMode)`](crate::client::fluent_builders::UpdateGlobalTableSettings::global_table_billing_mode) / [`set_global_table_billing_mode(Option<BillingMode>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_global_table_billing_mode): <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>  <ul>   <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>   <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>  </ul>
    ///   - [`global_table_provisioned_write_capacity_units(i64)`](crate::client::fluent_builders::UpdateGlobalTableSettings::global_table_provisioned_write_capacity_units) / [`set_global_table_provisioned_write_capacity_units(Option<i64>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_global_table_provisioned_write_capacity_units): <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
    ///   - [`global_table_provisioned_write_capacity_auto_scaling_settings_update(AutoScalingSettingsUpdate)`](crate::client::fluent_builders::UpdateGlobalTableSettings::global_table_provisioned_write_capacity_auto_scaling_settings_update) / [`set_global_table_provisioned_write_capacity_auto_scaling_settings_update(Option<AutoScalingSettingsUpdate>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_global_table_provisioned_write_capacity_auto_scaling_settings_update): <p>Auto scaling settings for managing provisioned write capacity for the global table.</p>
    ///   - [`global_table_global_secondary_index_settings_update(Vec<GlobalTableGlobalSecondaryIndexSettingsUpdate>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::global_table_global_secondary_index_settings_update) / [`set_global_table_global_secondary_index_settings_update(Option<Vec<GlobalTableGlobalSecondaryIndexSettingsUpdate>>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_global_table_global_secondary_index_settings_update): <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
    ///   - [`replica_settings_update(Vec<ReplicaSettingsUpdate>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::replica_settings_update) / [`set_replica_settings_update(Option<Vec<ReplicaSettingsUpdate>>)`](crate::client::fluent_builders::UpdateGlobalTableSettings::set_replica_settings_update): <p>Represents the settings for a global table in a Region that will be modified.</p>
    /// - On success, responds with [`UpdateGlobalTableSettingsOutput`](crate::output::UpdateGlobalTableSettingsOutput) with field(s):
    ///   - [`global_table_name(Option<String>)`](crate::output::UpdateGlobalTableSettingsOutput::global_table_name): <p>The name of the global table.</p>
    ///   - [`replica_settings(Option<Vec<ReplicaSettingsDescription>>)`](crate::output::UpdateGlobalTableSettingsOutput::replica_settings): <p>The Region-specific settings for the global table.</p>
    /// - On failure, responds with [`SdkError<UpdateGlobalTableSettingsError>`](crate::error::UpdateGlobalTableSettingsError)
    pub fn update_global_table_settings(&self) -> fluent_builders::UpdateGlobalTableSettings {
        fluent_builders::UpdateGlobalTableSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateItem`](crate::client::fluent_builders::UpdateItem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateItem::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateItem::set_table_name): <p>The name of the table containing the item to update.</p>
    ///   - [`key(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::UpdateItem::key) / [`set_key(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::UpdateItem::set_key): <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>  <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
    ///   - [`attribute_updates(HashMap<String, AttributeValueUpdate>)`](crate::client::fluent_builders::UpdateItem::attribute_updates) / [`set_attribute_updates(Option<HashMap<String, AttributeValueUpdate>>)`](crate::client::fluent_builders::UpdateItem::set_attribute_updates): <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expected(HashMap<String, ExpectedAttributeValue>)`](crate::client::fluent_builders::UpdateItem::expected) / [`set_expected(Option<HashMap<String, ExpectedAttributeValue>>)`](crate::client::fluent_builders::UpdateItem::set_expected): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`conditional_operator(ConditionalOperator)`](crate::client::fluent_builders::UpdateItem::conditional_operator) / [`set_conditional_operator(Option<ConditionalOperator>)`](crate::client::fluent_builders::UpdateItem::set_conditional_operator): <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`return_values(ReturnValue)`](crate::client::fluent_builders::UpdateItem::return_values) / [`set_return_values(Option<ReturnValue>)`](crate::client::fluent_builders::UpdateItem::set_return_values): <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are updated. For <code>UpdateItem</code>, the valid values are:</p>  <ul>   <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>   <li> <p> <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p> </li>   <li> <p> <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p> </li>   <li> <p> <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p> </li>   <li> <p> <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p> </li>  </ul>  <p>There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.</p>  <p>The values returned are strongly consistent.</p>
    ///   - [`return_consumed_capacity(ReturnConsumedCapacity)`](crate::client::fluent_builders::UpdateItem::return_consumed_capacity) / [`set_return_consumed_capacity(Option<ReturnConsumedCapacity>)`](crate::client::fluent_builders::UpdateItem::set_return_consumed_capacity): <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>  <ul>   <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>   <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>   <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>  </ul>
    ///   - [`return_item_collection_metrics(ReturnItemCollectionMetrics)`](crate::client::fluent_builders::UpdateItem::return_item_collection_metrics) / [`set_return_item_collection_metrics(Option<ReturnItemCollectionMetrics>)`](crate::client::fluent_builders::UpdateItem::set_return_item_collection_metrics): <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
    ///   - [`update_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateItem::update_expression) / [`set_update_expression(Option<String>)`](crate::client::fluent_builders::UpdateItem::set_update_expression): <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.</p>  <p>The following action values are available for <code>UpdateExpression</code>.</p>  <ul>   <li> <p> <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code> </p> <p> <code>SET</code> supports the following functions:</p>    <ul>     <li> <p> <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p> </li>     <li> <p> <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p> </li>    </ul> <p>These function names are case-sensitive.</p> </li>   <li> <p> <code>REMOVE</code> - Removes one or more attributes from an item.</p> </li>   <li> <p> <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>    <ul>     <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>       <p>If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value.</p>       <p>Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update doesn't have an attribute named <code>itemcount</code>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.</p>      </note> </li>     <li> <p>If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings.</p> </li>    </ul> <important>     <p>The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p>    </important> </li>   <li> <p> <code>DELETE</code> - Deletes an element from a set.</p> <p>If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an error.</p> <important>     <p>The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p>    </important> </li>  </ul>  <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code> </p>  <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`condition_expression(impl Into<String>)`](crate::client::fluent_builders::UpdateItem::condition_expression) / [`set_condition_expression(Option<String>)`](crate::client::fluent_builders::UpdateItem::set_condition_expression): <p>A condition that must be satisfied in order for a conditional update to succeed.</p>  <p>An expression can contain any of the following:</p>  <ul>   <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>   <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>   <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>  </ul>  <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_names(HashMap<String, String>)`](crate::client::fluent_builders::UpdateItem::expression_attribute_names) / [`set_expression_attribute_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateItem::set_expression_attribute_names): <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>   <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>   <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>  </ul>  <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>  <ul>   <li> <p> <code>Percentile</code> </p> </li>  </ul>  <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>  <ul>   <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>  </ul>  <p>You could then use this substitution in an expression, as in this example:</p>  <ul>   <li> <p> <code>#P = :val</code> </p> </li>  </ul> <note>   <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>  </note>  <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`expression_attribute_values(HashMap<String, AttributeValue>)`](crate::client::fluent_builders::UpdateItem::expression_attribute_values) / [`set_expression_attribute_values(Option<HashMap<String, AttributeValue>>)`](crate::client::fluent_builders::UpdateItem::set_expression_attribute_values): <p>One or more values that can be substituted in an expression.</p>  <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>  <p> <code>Available | Backordered | Discontinued</code> </p>  <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>  <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>  <p>You could then use these values in an expression, such as this:</p>  <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>  <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateItemOutput`](crate::output::UpdateItemOutput) with field(s):
    ///   - [`attributes(Option<HashMap<String, AttributeValue>>)`](crate::output::UpdateItemOutput::attributes): <p>A map of attribute values as they appear before or after the <code>UpdateItem</code> operation, as determined by the <code>ReturnValues</code> parameter.</p>  <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was specified as something other than <code>NONE</code> in the request. Each element represents one attribute.</p>
    ///   - [`consumed_capacity(Option<ConsumedCapacity>)`](crate::output::UpdateItemOutput::consumed_capacity): <p>The capacity units consumed by the <code>UpdateItem</code> operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///   - [`item_collection_metrics(Option<ItemCollectionMetrics>)`](crate::output::UpdateItemOutput::item_collection_metrics): <p>Information about item collections, if any, that were affected by the <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.</p>  <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>  <ul>   <li> <p> <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the partition key value of the item itself.</p> </li>   <li> <p> <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p> <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<UpdateItemError>`](crate::error::UpdateItemError)
    pub fn update_item(&self) -> fluent_builders::UpdateItem {
        fluent_builders::UpdateItem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTable`](crate::client::fluent_builders::UpdateTable) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_definitions(Vec<AttributeDefinition>)`](crate::client::fluent_builders::UpdateTable::attribute_definitions) / [`set_attribute_definitions(Option<Vec<AttributeDefinition>>)`](crate::client::fluent_builders::UpdateTable::set_attribute_definitions): <p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTable::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTable::set_table_name): <p>The name of the table to be updated.</p>
    ///   - [`billing_mode(BillingMode)`](crate::client::fluent_builders::UpdateTable::billing_mode) / [`set_billing_mode(Option<BillingMode>)`](crate::client::fluent_builders::UpdateTable::set_billing_mode): <p>Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.</p>  <ul>   <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>   <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>  </ul>
    ///   - [`provisioned_throughput(ProvisionedThroughput)`](crate::client::fluent_builders::UpdateTable::provisioned_throughput) / [`set_provisioned_throughput(Option<ProvisionedThroughput>)`](crate::client::fluent_builders::UpdateTable::set_provisioned_throughput): <p>The new provisioned throughput settings for the specified table or index.</p>
    ///   - [`global_secondary_index_updates(Vec<GlobalSecondaryIndexUpdate>)`](crate::client::fluent_builders::UpdateTable::global_secondary_index_updates) / [`set_global_secondary_index_updates(Option<Vec<GlobalSecondaryIndexUpdate>>)`](crate::client::fluent_builders::UpdateTable::set_global_secondary_index_updates): <p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p>  <ul>   <li> <p> <code>Create</code> - add a new global secondary index to the table.</p> </li>   <li> <p> <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p> </li>   <li> <p> <code>Delete</code> - remove a global secondary index from the table.</p> </li>  </ul>  <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    ///   - [`stream_specification(StreamSpecification)`](crate::client::fluent_builders::UpdateTable::stream_specification) / [`set_stream_specification(Option<StreamSpecification>)`](crate::client::fluent_builders::UpdateTable::set_stream_specification): <p>Represents the DynamoDB Streams configuration for the table.</p> <note>   <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream.</p>  </note>
    ///   - [`sse_specification(SseSpecification)`](crate::client::fluent_builders::UpdateTable::sse_specification) / [`set_sse_specification(Option<SseSpecification>)`](crate::client::fluent_builders::UpdateTable::set_sse_specification): <p>The new server-side encryption settings for the specified table.</p>
    ///   - [`replica_updates(Vec<ReplicationGroupUpdate>)`](crate::client::fluent_builders::UpdateTable::replica_updates) / [`set_replica_updates(Option<Vec<ReplicationGroupUpdate>>)`](crate::client::fluent_builders::UpdateTable::set_replica_updates): <p>A list of replica update actions (create, delete, or update) for the table.</p> <note>   <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>  </note>
    ///   - [`table_class(TableClass)`](crate::client::fluent_builders::UpdateTable::table_class) / [`set_table_class(Option<TableClass>)`](crate::client::fluent_builders::UpdateTable::set_table_class): <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    /// - On success, responds with [`UpdateTableOutput`](crate::output::UpdateTableOutput) with field(s):
    ///   - [`table_description(Option<TableDescription>)`](crate::output::UpdateTableOutput::table_description): <p>Represents the properties of the table.</p>
    /// - On failure, responds with [`SdkError<UpdateTableError>`](crate::error::UpdateTableError)
    pub fn update_table(&self) -> fluent_builders::UpdateTable {
        fluent_builders::UpdateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTableReplicaAutoScaling`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_secondary_index_updates(Vec<GlobalSecondaryIndexAutoScalingUpdate>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::global_secondary_index_updates) / [`set_global_secondary_index_updates(Option<Vec<GlobalSecondaryIndexAutoScalingUpdate>>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::set_global_secondary_index_updates): <p>Represents the auto scaling settings of the global secondary indexes of the replica to be updated.</p>
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::set_table_name): <p>The name of the global table to be updated.</p>
    ///   - [`provisioned_write_capacity_auto_scaling_update(AutoScalingSettingsUpdate)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::provisioned_write_capacity_auto_scaling_update) / [`set_provisioned_write_capacity_auto_scaling_update(Option<AutoScalingSettingsUpdate>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::set_provisioned_write_capacity_auto_scaling_update): <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    ///   - [`replica_updates(Vec<ReplicaAutoScalingUpdate>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::replica_updates) / [`set_replica_updates(Option<Vec<ReplicaAutoScalingUpdate>>)`](crate::client::fluent_builders::UpdateTableReplicaAutoScaling::set_replica_updates): <p>Represents the auto scaling settings of replicas of the table that will be modified.</p>
    /// - On success, responds with [`UpdateTableReplicaAutoScalingOutput`](crate::output::UpdateTableReplicaAutoScalingOutput) with field(s):
    ///   - [`table_auto_scaling_description(Option<TableAutoScalingDescription>)`](crate::output::UpdateTableReplicaAutoScalingOutput::table_auto_scaling_description): <p>Returns information about the auto scaling settings of a table with replicas.</p>
    /// - On failure, responds with [`SdkError<UpdateTableReplicaAutoScalingError>`](crate::error::UpdateTableReplicaAutoScalingError)
    pub fn update_table_replica_auto_scaling(
        &self,
    ) -> fluent_builders::UpdateTableReplicaAutoScaling {
        fluent_builders::UpdateTableReplicaAutoScaling::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTimeToLive`](crate::client::fluent_builders::UpdateTimeToLive) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`table_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTimeToLive::table_name) / [`set_table_name(Option<String>)`](crate::client::fluent_builders::UpdateTimeToLive::set_table_name): <p>The name of the table to be configured.</p>
    ///   - [`time_to_live_specification(TimeToLiveSpecification)`](crate::client::fluent_builders::UpdateTimeToLive::time_to_live_specification) / [`set_time_to_live_specification(Option<TimeToLiveSpecification>)`](crate::client::fluent_builders::UpdateTimeToLive::set_time_to_live_specification): <p>Represents the settings used to enable or disable Time to Live for the specified table.</p>
    /// - On success, responds with [`UpdateTimeToLiveOutput`](crate::output::UpdateTimeToLiveOutput) with field(s):
    ///   - [`time_to_live_specification(Option<TimeToLiveSpecification>)`](crate::output::UpdateTimeToLiveOutput::time_to_live_specification): <p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>
    /// - On failure, responds with [`SdkError<UpdateTimeToLiveError>`](crate::error::UpdateTimeToLiveError)
    pub fn update_time_to_live(&self) -> fluent_builders::UpdateTimeToLive {
        fluent_builders::UpdateTimeToLive::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchExecuteStatement`.
    ///
    /// <p>This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL.</p> <note>
    /// <p>The entire batch must consist of either read statements or write statements, you cannot mix both in one batch.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchExecuteStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_execute_statement_input::Builder,
    }
    impl BatchExecuteStatement {
        /// Creates a new `BatchExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchExecuteStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>The list of PartiQL statements representing the batch to run.</p>
        pub fn statements(mut self, input: crate::model::BatchStatementRequest) -> Self {
            self.inner = self.inner.statements(input);
            self
        }
        /// <p>The list of PartiQL statements representing the batch to run.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchStatementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_statements(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetItem`.
    ///
    /// <p>The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or more tables. You identify requested items by primary key.</p>
    /// <p>A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items. <code>BatchGetItem</code> returns a partial result if the response size limit is exceeded, the table's provisioned throughput is exceeded, or an internal processing failure occurs. If a partial result is returned, the operation returns a value for <code>UnprocessedKeys</code>. You can use this value to retry the operation starting with the next item to get.</p> <important>
    /// <p>If you request more than 100 items, <code>BatchGetItem</code> returns a <code>ValidationException</code> with the message "Too many items requested for the BatchGetItem call."</p>
    /// </important>
    /// <p>For example, if you ask to retrieve 100 items, but each individual item is 300 KB in size, the system returns 52 items (so as not to exceed the 16 MB limit). It also returns an appropriate <code>UnprocessedKeys</code> value so you can get the next page of results. If desired, your application can include its own logic to assemble the pages of results into one dataset.</p>
    /// <p>If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in the request, then <code>BatchGetItem</code> returns a <code>ProvisionedThroughputExceededException</code>. If <i>at least one</i> of the items is successfully processed, then <code>BatchGetItem</code> completes successfully, while returning the keys of the unread items in <code>UnprocessedKeys</code>.</p> <important>
    /// <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If you delay the batch operation using exponential backoff, the individual requests in the batch are much more likely to succeed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// </important>
    /// <p>By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the request. If you want strongly consistent reads instead, you can set <code>ConsistentRead</code> to <code>true</code> for any or all tables.</p>
    /// <p>In order to minimize response latency, <code>BatchGetItem</code> retrieves items in parallel.</p>
    /// <p>When designing your application, keep in mind that DynamoDB does not return items in any particular order. To help parse the response by item, include the primary key values for the items in your request in the <code>ProjectionExpression</code> parameter.</p>
    /// <p>If a requested item does not exist, it is not returned in the result. Requests for nonexistent items consume the minimum read capacity units according to the type of read. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_item_input::Builder,
    }
    impl BatchGetItem {
        /// Creates a new `BatchGetItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetItemOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `RequestItems`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li> <p> <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code> (the default), an eventually consistent read is used.</p> </li>
        /// <li> <p> <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul> <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note> <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>
        /// <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide <i>both</i> the partition key value and the sort key value.</p> </li>
        /// <li> <p> <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>
        /// <li> <p> <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::KeysAndAttributes,
        ) -> Self {
            self.inner = self.inner.request_items(k.into(), v);
            self
        }
        /// <p>A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li> <p> <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read is used; if <code>false</code> (the default), an eventually consistent read is used.</p> </li>
        /// <li> <p> <code>ExpressionAttributeNames</code> - One or more substitution tokens for attribute names in the <code>ProjectionExpression</code> parameter. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul> <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul> <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul> <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note> <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>
        /// <li> <p> <code>Keys</code> - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide <i>both</i> the partition key value and the sort key value.</p> </li>
        /// <li> <p> <code>ProjectionExpression</code> - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p> <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p> </li>
        /// <li> <p> <code>AttributesToGet</code> - This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p> </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_items(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchWriteItem`.
    ///
    /// <p>The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more tables. A single call to <code>BatchWriteItem</code> can transmit up to 16MB of data over the network, consisting of up to 25 item put or delete operations. While individual items can be up to 400 KB once stored, it's important to note that an item's representation might be greater than 400KB while being sent in DynamoDB's JSON format for the API call. For more details on this distinction, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html">Naming Rules and Data Types</a>.</p> <note>
    /// <p> <code>BatchWriteItem</code> cannot update items. To update items, use the <code>UpdateItem</code> action.</p>
    /// </note>
    /// <p>The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any requested operations fail because the table's provisioned throughput is exceeded or an internal processing failure occurs, the failed operations are returned in the <code>UnprocessedItems</code> response parameter. You can investigate and optionally resend the requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each iteration would check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those unprocessed items until all items have been processed.</p>
    /// <p>If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in the request, then <code>BatchWriteItem</code> returns a <code>ProvisionedThroughputExceededException</code>.</p> <important>
    /// <p>If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If you delay the batch operation using exponential backoff, the individual requests in the batch are much more likely to succeed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations">Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// </important>
    /// <p>With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of data, such as from Amazon EMR, or copy data from another database into DynamoDB. In order to improve performance with these large-scale operations, <code>BatchWriteItem</code> does not behave in the same way as individual <code>PutItem</code> and <code>DeleteItem</code> calls would. For example, you cannot specify conditions on individual put and delete requests, and <code>BatchWriteItem</code> does not return deleted items in the response.</p>
    /// <p>If you use a programming language that supports concurrency, you can use threads to write items in parallel. Your application must include the necessary logic to manage the threads. With languages that don't support threading, you must update or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code> performs the specified put and delete operations in parallel, giving you the power of the thread pool approach without having to introduce complexity into your application.</p>
    /// <p>Parallel processing reduces latency, but each specified put and delete request consumes the same number of write capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one write capacity unit.</p>
    /// <p>If one or more of the following is true, DynamoDB rejects the entire batch write operation:</p>
    /// <ul>
    /// <li> <p>One or more tables specified in the <code>BatchWriteItem</code> request does not exist.</p> </li>
    /// <li> <p>Primary key attributes specified on an item in the request do not match those in the corresponding table's primary key schema.</p> </li>
    /// <li> <p>You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code> request. For example, you cannot put and delete the same item in the same <code>BatchWriteItem</code> request. </p> </li>
    /// <li> <p> Your request contains at least two items with identical hash and range keys (which essentially is two put operations). </p> </li>
    /// <li> <p>There are more than 25 requests in the batch.</p> </li>
    /// <li> <p>Any individual item in a batch exceeds 400 KB.</p> </li>
    /// <li> <p>The total request size exceeds 16 MB.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchWriteItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_write_item_input::Builder,
    }
    impl BatchWriteItem {
        /// Creates a new `BatchWriteItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchWriteItemOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchWriteItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `RequestItems`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a list of operations to be performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:</p>
        /// <ul>
        /// <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p>
        /// <ul>
        /// <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p>
        /// <ul>
        /// <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values are rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<crate::model::WriteRequest>,
        ) -> Self {
            self.inner = self.inner.request_items(k.into(), v);
            self
        }
        /// <p>A map of one or more table names and, for each table, a list of operations to be performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the map consists of the following:</p>
        /// <ul>
        /// <li> <p> <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be deleted is identified by a <code>Key</code> subelement:</p>
        /// <ul>
        /// <li> <p> <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value. For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for <i>both</i> the partition key and the sort key.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is identified by an <code>Item</code> subelement:</p>
        /// <ul>
        /// <li> <p> <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values are rejected with a <code>ValidationException</code> exception.</p> <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::WriteRequest>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_items(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBackup`.
    ///
    /// <p>Creates a backup for an existing table.</p>
    /// <p> Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of on-demand backups that can be taken. </p>
    /// <p> When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup requests are processed instantaneously and become available for restore within minutes. </p>
    /// <p>You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.</p>
    /// <p>All backups in DynamoDB work without consuming any provisioned throughput on the table.</p>
    /// <p> If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency. </p>
    /// <p> Along with data, the following are also included on the backups: </p>
    /// <ul>
    /// <li> <p>Global secondary indexes (GSIs)</p> </li>
    /// <li> <p>Local secondary indexes (LSIs)</p> </li>
    /// <li> <p>Streams</p> </li>
    /// <li> <p>Provisioned read and write capacity</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_backup_input::Builder,
    }
    impl CreateBackup {
        /// Creates a new `CreateBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn backup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_name(input.into());
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn set_backup_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalTable`.
    ///
    /// <p>Creates a global table from an existing table. A global table creates a replication relationship between two or more DynamoDB tables with the same table name in the provided Regions. </p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    /// <p>If you want to add a new replica table to a global table, each of the following conditions must be true:</p>
    /// <ul>
    /// <li> <p>The table must have the same primary key as all of the other replicas.</p> </li>
    /// <li> <p>The table must have the same name as all of the other replicas.</p> </li>
    /// <li> <p>The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the item.</p> </li>
    /// <li> <p>None of the replica tables in the global table can contain any data.</p> </li>
    /// </ul>
    /// <p> If global secondary indexes are specified, then the following conditions must also be met: </p>
    /// <ul>
    /// <li> <p> The global secondary indexes must have the same name. </p> </li>
    /// <li> <p> The global secondary indexes must have the same hash key and sort key (if present). </p> </li>
    /// </ul>
    /// <p> If local secondary indexes are specified, then the following conditions must also be met: </p>
    /// <ul>
    /// <li> <p> The local secondary indexes must have the same name. </p> </li>
    /// <li> <p> The local secondary indexes must have the same hash key and sort key (if present). </p> </li>
    /// </ul> <important>
    /// <p> Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables replicas and indexes. </p>
    /// <p> If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity units to your replica tables. You should also provision equal replicated write capacity units to matching secondary indexes across your global table. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGlobalTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_global_table_input::Builder,
    }
    impl CreateGlobalTable {
        /// Creates a new `CreateGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// Appends an item to `ReplicationGroup`.
        ///
        /// To override the contents of this collection use [`set_replication_group`](Self::set_replication_group).
        ///
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn replication_group(mut self, input: crate::model::Replica) -> Self {
            self.inner = self.inner.replication_group(input);
            self
        }
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Replica>>,
        ) -> Self {
            self.inner = self.inner.set_replication_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTable`.
    ///
    /// <p>The <code>CreateTable</code> operation adds a new table to your account. In an Amazon Web Services account, table names must be unique within each Region. That is, you can have two tables with same name if you create the tables in different Regions.</p>
    /// <p> <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request, DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After the table is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can perform read and write operations only on an <code>ACTIVE</code> table. </p>
    /// <p>You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code> operation. If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially. Only one table with secondary indexes can be in the <code>CREATING</code> state at any given time.</p>
    /// <p>You can use the <code>DescribeTable</code> action to check the table status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_table_input::Builder,
    }
    impl CreateTable {
        /// Creates a new `CreateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeDefinitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn attribute_definitions(mut self, input: crate::model::AttributeDefinition) -> Self {
            self.inner = self.inner.attribute_definitions(input);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_definitions(input);
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `KeySchema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The attributes in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of this key attribute.</p> </li>
        /// <li> <p> <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        /// <p>For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            self.inner = self.inner.key_schema(input);
            self
        }
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The attributes in <code>KeySchema</code> must also be defined in the <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of this key attribute.</p> </li>
        /// <li> <p> <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        /// <p>For a simple primary key (partition key), you must provide exactly one element with a <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a <code>KeyType</code> of <code>HASH</code>, and the second element must have a <code>KeyType</code> of <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.inner = self.inner.set_key_schema(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p> <p></p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn local_secondary_indexes(mut self, input: crate::model::LocalSecondaryIndex) -> Self {
            self.inner = self.inner.local_secondary_indexes(input);
            self
        }
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the local secondary index. Must be unique only for this table.</p> <p></p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_indexes(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p> <p></p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.</p> </li>
        /// </ul>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::GlobalSecondaryIndex,
        ) -> Self {
            self.inner = self.inner.global_secondary_indexes(input);
            self
        }
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the global secondary index. Must be unique only for this table.</p> <p></p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the key schema for the global secondary index.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.</p> </li>
        /// </ul>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_indexes(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property. If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput(input);
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li> <p> <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).</p> </li>
        /// <li> <p> <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
        /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn stream_specification(mut self, input: crate::model::StreamSpecification) -> Self {
            self.inner = self.inner.stream_specification(input);
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li> <p> <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).</p> </li>
        /// <li> <p> <code>StreamViewType</code> - When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the table's stream. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
        /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.inner = self.inner.set_stream_specification(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn table_class(mut self, input: crate::model::TableClass) -> Self {
            self.inner = self.inner.table_class(input);
            self
        }
        /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn set_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.inner = self.inner.set_table_class(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBackup`.
    ///
    /// <p>Deletes an existing backup of a table.</p>
    /// <p>You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_backup_input::Builder,
    }
    impl DeleteBackup {
        /// Creates a new `DeleteBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(input.into());
            self
        }
        /// <p>The ARN associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteItem`.
    ///
    /// <p>Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the item if it exists, or if it has an expected attribute value.</p>
    /// <p>In addition to deleting an item, you can also return the item's attribute values in the same operation, using the <code>ReturnValues</code> parameter.</p>
    /// <p>Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it multiple times on the same item or attribute does <i>not</i> result in an error response.</p>
    /// <p>Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are met, DynamoDB performs the delete. Otherwise, the item is not deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_item_input::Builder,
    }
    impl DeleteItem {
        /// Creates a new `DeleteItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteItemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table from which to delete the item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table from which to delete the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.key(k.into(), v);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ExpectedAttributeValue,
        ) -> Self {
            self.inner = self.inner.expected(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - The content of the old item is returned.</p> </li>
        /// </ul> <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - The content of the old item is returned.</p> </li>
        /// </ul> <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k.into(), v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTable`.
    ///
    /// <p>The <code>DeleteTable</code> operation deletes a table and all of its items. After a <code>DeleteTable</code> request, the specified table is in the <code>DELETING</code> state until DynamoDB completes the deletion. If the table is in the <code>ACTIVE</code> state, you can delete it. If a table is in <code>CREATING</code> or <code>UPDATING</code> states, then DynamoDB returns a <code>ResourceInUseException</code>. If the specified table does not exist, DynamoDB returns a <code>ResourceNotFoundException</code>. If table is already in the <code>DELETING</code> state, no error is returned. </p> <note>
    /// <p>DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is complete.</p>
    /// </note>
    /// <p>When you delete a table, any indexes on that table are also deleted.</p>
    /// <p>If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.</p>
    /// <p>Use the <code>DescribeTable</code> action to check the status of the table. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_table_input::Builder,
    }
    impl DeleteTable {
        /// Creates a new `DeleteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to delete.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to delete.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackup`.
    ///
    /// <p>Describes an existing backup of a table.</p>
    /// <p>You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_backup_input::Builder,
    }
    impl DescribeBackup {
        /// Creates a new `DescribeBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContinuousBackups`.
    ///
    /// <p>Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p>
    /// <p> After continuous backups and point in time recovery are enabled, you can restore to any point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. </p>
    /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days. </p>
    /// <p>You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContinuousBackups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_continuous_backups_input::Builder,
    }
    impl DescribeContinuousBackups {
        /// Creates a new `DescribeContinuousBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContinuousBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContinuousBackupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>Name of the table for which the customer wants to check the continuous backups and point in time recovery settings.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContributorInsights`.
    ///
    /// <p>Returns information about contributor insights, for a given table or global secondary index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContributorInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_contributor_insights_input::Builder,
    }
    impl DescribeContributorInsights {
        /// Creates a new `DescribeContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContributorInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoints`.
    ///
    /// <p>Returns the regional endpoint information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoints_input::Builder,
    }
    impl DescribeEndpoints {
        /// Creates a new `DescribeEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeExport`.
    ///
    /// <p>Describes an existing table export.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_export_input::Builder,
    }
    impl DescribeExport {
        /// Creates a new `DescribeExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn export_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn set_export_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalTable`.
    ///
    /// <p>Returns information about the specified global table.</p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables. If you are using global tables <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> you can use <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html">DescribeTable</a> instead.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGlobalTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_global_table_input::Builder,
    }
    impl DescribeGlobalTable {
        /// Creates a new `DescribeGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(input.into());
            self
        }
        /// <p>The name of the global table.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalTableSettings`.
    ///
    /// <p>Describes Region-specific settings for a global table.</p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGlobalTableSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_global_table_settings_input::Builder,
    }
    impl DescribeGlobalTableSettings {
        /// Creates a new `DescribeGlobalTableSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalTableSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalTableSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table to describe.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(input.into());
            self
        }
        /// <p>The name of the global table to describe.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeKinesisStreamingDestination`.
    ///
    /// <p>Returns information about the status of Kinesis streaming.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeKinesisStreamingDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_kinesis_streaming_destination_input::Builder,
    }
    impl DescribeKinesisStreamingDestination {
        /// Creates a new `DescribeKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeKinesisStreamingDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table being described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table being described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLimits`.
    ///
    /// <p>Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the Region as a whole and for any one DynamoDB table that you create there.</p>
    /// <p>When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also, there are per-table quotas that apply when you create a table there. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>Although you can increase these quotas by filing a case at <a href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity you are currently using to those quotas imposed by your account so that you have enough time to apply for an increase before you hit a quota.</p>
    /// <p>For example, you could use one of the Amazon Web Services SDKs to do the following:</p>
    /// <ol>
    /// <li> <p>Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned capacity there.</p> </li>
    /// <li> <p>Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and one to hold the aggregate write capacity units. Zero them both.</p> </li>
    /// <li> <p>Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.</p> </li>
    /// <li> <p>For each table name listed by <code>ListTables</code>, do the following:</p>
    /// <ul>
    /// <li> <p>Call <code>DescribeTable</code> with the table name.</p> </li>
    /// <li> <p>Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units provisioned for the table itself to your variables.</p> </li>
    /// <li> <p>If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned capacity values to your variables as well.</p> </li>
    /// </ul> </li>
    /// <li> <p>Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current provisioned capacity levels you have calculated.</p> </li>
    /// </ol>
    /// <p>This will let you see whether you are getting close to your account-level quotas.</p>
    /// <p>The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned capacity of the new table itself and all its global secondary indexes.</p>
    /// <p>For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned capacity extremely rapidly, but the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot exceed either of the per-account quotas.</p> <note>
    /// <p> <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it more than once in a minute.</p>
    /// </note>
    /// <p>The <code>DescribeLimits</code> Request element has no content.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_limits_input::Builder,
    }
    impl DescribeLimits {
        /// Creates a new `DescribeLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeTable`.
    ///
    /// <p>Returns information about the table, including the current status of the table, when it was created, the primary key schema, and any indexes on the table.</p> <note>
    /// <p>If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB might return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a few seconds, and then try the <code>DescribeTable</code> request again.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_table_input::Builder,
    }
    impl DescribeTable {
        /// Creates a new `DescribeTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTableReplicaAutoScaling`.
    ///
    /// <p>Describes auto scaling settings across replicas of the global table at once.</p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTableReplicaAutoScaling {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_table_replica_auto_scaling_input::Builder,
    }
    impl DescribeTableReplicaAutoScaling {
        /// Creates a new `DescribeTableReplicaAutoScaling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableReplicaAutoScalingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableReplicaAutoScalingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTimeToLive`.
    ///
    /// <p>Gives a description of the Time to Live (TTL) status on the specified table. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTimeToLive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_time_to_live_input::Builder,
    }
    impl DescribeTimeToLive {
        /// Creates a new `DescribeTimeToLive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTimeToLiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTimeToLiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to be described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to be described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableKinesisStreamingDestination`.
    ///
    /// <p>Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the resources.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableKinesisStreamingDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_kinesis_streaming_destination_input::Builder,
    }
    impl DisableKinesisStreamingDestination {
        /// Creates a new `DisableKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableKinesisStreamingDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableKinesisStreamingDestination`.
    ///
    /// <p>Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check if streaming to the Kinesis data stream is ACTIVE.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableKinesisStreamingDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_kinesis_streaming_destination_input::Builder,
    }
    impl EnableKinesisStreamingDestination {
        /// Creates a new `EnableKinesisStreamingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableKinesisStreamingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableKinesisStreamingDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_arn(input.into());
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteStatement`.
    ///
    /// <p>This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_statement_input::Builder,
    }
    impl ExecuteStatement {
        /// Creates a new `ExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The PartiQL statement representing the operation to run.</p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement(input.into());
            self
        }
        /// <p>The PartiQL statement representing the operation to run.</p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the PartiQL statement, if any.</p>
        pub fn parameters(mut self, input: crate::model::AttributeValue) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameters for the PartiQL statement, if any.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.inner = self.inner.consistent_read(input);
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteTransaction`.
    ///
    /// <p>This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.</p> <note>
    /// <p>The entire transaction must consist of either read statements or write statements, you cannot mix both in one transaction. The EXISTS function is an exception and can be used to check the condition of specific attributes of the item in a similar manner to <code>ConditionCheck</code> in the <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/transaction-apis.html#transaction-apis-txwriteitems">TransactWriteItems</a> API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteTransaction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_transaction_input::Builder,
    }
    impl ExecuteTransaction {
        /// Creates a new `ExecuteTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteTransactionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactStatements`.
        ///
        /// To override the contents of this collection use [`set_transact_statements`](Self::set_transact_statements).
        ///
        /// <p>The list of PartiQL statements representing the transaction to run.</p>
        pub fn transact_statements(mut self, input: crate::model::ParameterizedStatement) -> Self {
            self.inner = self.inner.transact_statements(input);
            self
        }
        /// <p>The list of PartiQL statements representing the transaction to run.</p>
        pub fn set_transact_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterizedStatement>>,
        ) -> Self {
            self.inner = self.inner.set_transact_statements(input);
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the statement response.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportTableToPointInTime`.
    ///
    /// <p>Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data from any time within the point in time recovery window.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExportTableToPointInTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::export_table_to_point_in_time_input::Builder,
    }
    impl ExportTableToPointInTime {
        /// Creates a new `ExportTableToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportTableToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportTableToPointInTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot of the table's state at this point in time.</p>
        pub fn export_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.export_time(input);
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot of the table's state at this point in time.</p>
        pub fn set_export_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_export_time(input);
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be stored in.</p>
        pub fn s3_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_owner(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be stored in.</p>
        pub fn set_s3_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_owner(input);
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_prefix(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_prefix(input);
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
        /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
        /// </ul>
        pub fn s3_sse_algorithm(mut self, input: crate::model::S3SseAlgorithm) -> Self {
            self.inner = self.inner.s3_sse_algorithm(input);
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
        /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
        /// </ul>
        pub fn set_s3_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3SseAlgorithm>,
        ) -> Self {
            self.inner = self.inner.set_s3_sse_algorithm(input);
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).</p>
        pub fn s3_sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_sse_kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data will be stored (if applicable).</p>
        pub fn set_s3_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_sse_kms_key_id(input);
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn export_format(mut self, input: crate::model::ExportFormat) -> Self {
            self.inner = self.inner.export_format(input);
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn set_export_format(
            mut self,
            input: std::option::Option<crate::model::ExportFormat>,
        ) -> Self {
            self.inner = self.inner.set_export_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetItem`.
    ///
    /// <p>The <code>GetItem</code> operation returns a set of attributes for the item with the given primary key. If there is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element in the response.</p>
    /// <p> <code>GetItem</code> provides an eventually consistent read by default. If your application requires a strongly consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although a strongly consistent read might take more time than an eventually consistent read, it always returns the last updated value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_item_input::Builder,
    }
    impl GetItem {
        /// Creates a new `GetItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetItemOutput,
            aws_smithy_http::result::SdkError<crate::error::GetItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the requested item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table containing the requested item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.key(k.into(), v);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(input.into());
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.inner = self.inner.consistent_read(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBackups`.
    ///
    /// <p>List backups associated with an Amazon Web Services account. To list backups for a given table, specify <code>TableName</code>. <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can also specify a maximum number of entries to be returned in a page.</p>
    /// <p>In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time at which the original backup was requested.</p>
    /// <p>You can call <code>ListBackups</code> a maximum of five times per second.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBackups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_backups_input::Builder,
    }
    impl ListBackups {
        /// Creates a new `ListBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBackupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>
        pub fn time_range_lower_bound(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.time_range_lower_bound(input);
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.</p>
        pub fn set_time_range_lower_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_time_range_lower_bound(input);
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>
        pub fn time_range_upper_bound(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.time_range_upper_bound(input);
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive. </p>
        pub fn set_time_range_upper_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_time_range_upper_bound(input);
            self
        }
        /// <p> <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
        pub fn exclusive_start_backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_backup_arn(input.into());
            self
        }
        /// <p> <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next page of results. </p>
        pub fn set_exclusive_start_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_backup_arn(input);
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - On-demand backup created by you.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p> </li>
        /// <li> <p> <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p> </li>
        /// </ul>
        pub fn backup_type(mut self, input: crate::model::BackupTypeFilter) -> Self {
            self.inner = self.inner.backup_type(input);
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - On-demand backup created by you.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p> </li>
        /// <li> <p> <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p> </li>
        /// </ul>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_backup_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContributorInsights`.
    ///
    /// <p>Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContributorInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_contributor_insights_input::Builder,
    }
    impl ListContributorInsights {
        /// Creates a new `ListContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContributorInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContributorInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContributorInsightsPaginator {
            crate::paginator::ListContributorInsightsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExports`.
    ///
    /// <p>Lists completed exports within the past 90 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_exports_input::Builder,
    }
    impl ListExports {
        /// Creates a new `ListExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExportsPaginator {
            crate::paginator::ListExportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_arn(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous call to <code>ListExports</code>. When provided in this manner, the API fetches the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous call to <code>ListExports</code>. When provided in this manner, the API fetches the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGlobalTables`.
    ///
    /// <p>Lists all global tables that have a replica in the specified Region.</p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29</a> of global tables.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGlobalTables {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_global_tables_input::Builder,
    }
    impl ListGlobalTables {
        /// Creates a new `ListGlobalTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGlobalTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGlobalTablesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn exclusive_start_global_table_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.exclusive_start_global_table_name(input.into());
            self
        }
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn set_exclusive_start_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_global_table_name(input);
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point, with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the operation and returns the table names collected up to that point, with a table name in the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.region_name(input.into());
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_region_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTables`.
    ///
    /// <p>Returns an array of table names associated with the current account and endpoint. The output from <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTables {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tables_input::Builder,
    }
    impl ListTables {
        /// Creates a new `ListTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTablesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTablesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTablesPaginator {
            crate::paginator::ListTablesPaginator::new(self.handle, self.inner)
        }
        /// <p>The first table name that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.</p>
        pub fn exclusive_start_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusive_start_table_name(input.into());
            self
        }
        /// <p>The first table name that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.</p>
        pub fn set_exclusive_start_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_table_name(input);
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsOfResource`.
    ///
    /// <p>List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per account.</p>
    /// <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsOfResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_of_resource_input::Builder,
    }
    impl ListTagsOfResource {
        /// Creates a new `ListTagsOfResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOfResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsOfResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource. When provided in this manner, this API fetches the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutItem`.
    ///
    /// <p>Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new item already exists in the specified table, the new item completely replaces the existing item. You can perform a conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an existing item if it has certain attribute values. You can return the item's attribute values in the same operation, using the <code>ReturnValues</code> parameter.</p> <important>
    /// <p>This topic provides general information about the <code>PutItem</code> API.</p>
    /// <p>For information on how to call the <code>PutItem</code> API using the Amazon Web Services SDK in specific languages, see the following:</p>
    /// <ul>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem"> PutItem in the Command Line Interface</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for .NET</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for C++</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Go</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Java</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for JavaScript</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for PHP V3</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Python (Boto)</a> </p> </li>
    /// <li> <p> <a href="http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem"> PutItem in the SDK for Ruby V2</a> </p> </li>
    /// </ul>
    /// </important>
    /// <p>When you add an item, the primary key attributes are the only required attributes. Attribute values cannot be null.</p>
    /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index. Set type attributes cannot be empty. </p>
    /// <p>Invalid Requests with empty values will be rejected with a <code>ValidationException</code> exception.</p> <note>
    /// <p>To prevent a new item from replacing an existing item, use a conditional expression that contains the <code>attribute_not_exists</code> function with the name of the attribute being used as the partition key for the table. Since every record must contain that attribute, the <code>attribute_not_exists</code> function will only succeed if no matching item exists.</p>
    /// </note>
    /// <p>For more information about <code>PutItem</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_item_input::Builder,
    }
    impl PutItem {
        /// Creates a new `PutItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutItemOutput,
            aws_smithy_http::result::SdkError<crate::error::PutItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to contain the item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to contain the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p>
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.item(k.into(), v);
            self
        }
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you can optionally provide other attribute name-value pairs for the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide both values for both the partition key and the sort key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a length greater than zero if the attribute is used as a key attribute for a table or index.</p>
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_item(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ExpectedAttributeValue,
        ) -> Self {
            self.inner = self.inner.expected(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the old item is returned.</p> </li>
        /// </ul>
        /// <p>The values returned are strongly consistent.</p> <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the old item is returned.</p> </li>
        /// </ul>
        /// <p>The values returned are strongly consistent.</p> <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k.into(), v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Query`.
    ///
    /// <p>You must provide the name of the partition key attribute and a single value for that attribute. <code>Query</code> returns all items with that partition key value. Optionally, you can provide a sort key attribute and use a comparison operator to refine the search results.</p>
    /// <p>Use the <code>KeyConditionExpression</code> parameter to provide a specific value for the partition key. The <code>Query</code> operation will return all of the items from the table or index with that partition key value. You can optionally narrow the scope of the <code>Query</code> operation by specifying a sort key value and a comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results, you can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items within the results should be returned to you. All of the other results are discarded. </p>
    /// <p> A <code>Query</code> operation always returns a result set. If no matching items are found, the result set will be empty. Queries that do not return results consume the minimum number of read capacity units for that type of read operation. </p> <note>
    /// <p> DynamoDB calculates the number of read capacity units consumed based on item size, not on the amount of data that is returned to an application. The number of capacity units consumed will be the same whether you request all of the attributes (the default behavior) or just some of them (using a projection expression). The number will also be the same whether or not you use a <code>FilterExpression</code>. </p>
    /// </note>
    /// <p> <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number, the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes. By default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter to false. </p>
    /// <p> A single <code>Query</code> operation will read up to the maximum number of items set (if using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you will need to paginate the result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    /// <p> <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before the results are returned. A <code>FilterExpression</code> cannot contain partition key or sort key attributes. You need to specify those attributes in the <code>KeyConditionExpression</code>. </p> <note>
    /// <p> A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code> if all the items read for the page of results are filtered out. </p>
    /// </note>
    /// <p>You can query a table, a local secondary index, or a global secondary index. For a query on a table or on a local secondary index, you can set the <code>ConsistentRead</code> parameter to <code>true</code> and obtain a strongly consistent result. Global secondary indexes support eventually consistent reads only, so do not specify <code>ConsistentRead</code> when querying a global secondary index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Query {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::query_input::Builder,
    }
    impl Query {
        /// Creates a new `Query`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::QueryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::QueryPaginator {
            crate::paginator::QueryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the table containing the requested items.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table containing the requested items.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code> </p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code> </p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>
        /// <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>
        /// <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>
        /// <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, input: crate::model::Select) -> Self {
            self.inner = self.inner.select(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>
        /// <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>
        /// <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>
        /// <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.inner = self.inner.set_select(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(input.into());
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.inner = self.inner.consistent_read(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.</p>
        /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
        /// Adds a key-value pair to `KeyConditions`.
        ///
        /// To override the contents of this collection use [`set_key_conditions`](Self::set_key_conditions).
        ///
        /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_conditions(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Condition,
        ) -> Self {
            self.inner = self.inner.key_conditions(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_conditions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key_conditions(input);
            self
        }
        /// Adds a key-value pair to `QueryFilter`.
        ///
        /// To override the contents of this collection use [`set_query_filter`](Self::set_query_filter).
        ///
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn query_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Condition,
        ) -> Self {
            self.inner = self.inner.query_filter(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_query_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_query_filter(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>
        pub fn scan_index_forward(mut self, input: bool) -> Self {
            self.inner = self.inner.scan_index_forward(input);
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.</p>
        pub fn set_scan_index_forward(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_scan_index_forward(input);
            self
        }
        /// Adds a key-value pair to `ExclusiveStartKey`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are allowed.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.exclusive_start_key(k.into(), v);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are allowed.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_key(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.</p> <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(input.into());
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.</p> <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.</p>
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single sort key value. This allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.</p>
        /// <p>The partition key equality test is required, and must be specified in the following format:</p>
        /// <p> <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code> </p>
        /// <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p>
        /// <p> <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li> <p> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater than or equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code> <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p> </li>
        /// <li> <p> <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.</p> </li>
        /// </ul>
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p>
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:</p>
        /// <ul>
        /// <li> <p> <code>Size = :myval</code> </p> </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p>
        /// <ul>
        /// <li> <p> <code>#S = :myval</code> </p> </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_condition_expression(input.into());
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.</p>
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single sort key value. This allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.</p>
        /// <p>The partition key equality test is required, and must be specified in the following format:</p>
        /// <p> <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code> </p>
        /// <p>If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:</p>
        /// <p> <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li> <p> <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater than or equal to <code>:sortkeyval</code>.</p> </li>
        /// <li> <p> <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code> <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.</p> </li>
        /// <li> <p> <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.</p> </li>
        /// </ul>
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.</p>
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:</p>
        /// <ul>
        /// <li> <p> <code>Size = :myval</code> </p> </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:</p>
        /// <ul>
        /// <li> <p> <code>#S = :myval</code> </p> </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k.into(), v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTableFromBackup`.
    ///
    /// <p>Creates a new table from an existing backup. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account. </p>
    /// <p>You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.</p>
    /// <p>You must manually set up the following on the restored table:</p>
    /// <ul>
    /// <li> <p>Auto scaling policies</p> </li>
    /// <li> <p>IAM policies</p> </li>
    /// <li> <p>Amazon CloudWatch metrics and alarms</p> </li>
    /// <li> <p>Tags</p> </li>
    /// <li> <p>Stream settings</p> </li>
    /// <li> <p>Time to Live (TTL) settings</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreTableFromBackup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_table_from_backup_input::Builder,
    }
    impl RestoreTableFromBackup {
        /// Creates a new `RestoreTableFromBackup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableFromBackupOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableFromBackupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_table_name(input.into());
            self
        }
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_table_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.backup_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_backup_arn(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, input: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode_override(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode_override(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            input: crate::model::GlobalSecondaryIndex,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_override(input);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_override(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            input: crate::model::LocalSecondaryIndex,
        ) -> Self {
            self.inner = self.inner.local_secondary_index_override(input);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_index_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, input: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTableToPointInTime`.
    ///
    /// <p>Restores the specified table to the specified point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. You can restore your table to any point in time during the last 35 days. Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account. </p>
    /// <p> When you restore using point in time recovery, DynamoDB restores your table data to the state based on the selected date and time (day:hour:minute:second) to a new table. </p>
    /// <p> Along with data, the following are also included on the new restored table using point in time recovery: </p>
    /// <ul>
    /// <li> <p>Global secondary indexes (GSIs)</p> </li>
    /// <li> <p>Local secondary indexes (LSIs)</p> </li>
    /// <li> <p>Provisioned read and write capacity</p> </li>
    /// <li> <p>Encryption settings</p> <important>
    /// <p> All these settings come from the current settings of the source table at the time of restore. </p>
    /// </important> </li>
    /// </ul>
    /// <p>You must manually set up the following on the restored table:</p>
    /// <ul>
    /// <li> <p>Auto scaling policies</p> </li>
    /// <li> <p>IAM policies</p> </li>
    /// <li> <p>Amazon CloudWatch metrics and alarms</p> </li>
    /// <li> <p>Tags</p> </li>
    /// <li> <p>Stream settings</p> </li>
    /// <li> <p>Time to Live (TTL) settings</p> </li>
    /// <li> <p>Point in time recovery settings</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestoreTableToPointInTime {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::restore_table_to_point_in_time_input::Builder,
    }
    impl RestoreTableToPointInTime {
        /// Creates a new `RestoreTableToPointInTime`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableToPointInTimeOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableToPointInTimeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).</p>
        pub fn source_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_arn(input.into());
            self
        }
        /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_source_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_arn(input);
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn source_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_name(input.into());
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_name(input);
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_table_name(input.into());
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_table_name(input);
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(input);
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn restore_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.restore_date_time(input);
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn set_restore_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_restore_date_time(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, input: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode_override(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode_override(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            input: crate::model::GlobalSecondaryIndex,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_override(input);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_override(input);
            self
        }
        /// Appends an item to `LocalSecondaryIndexOverride`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            input: crate::model::LocalSecondaryIndex,
        ) -> Self {
            self.inner = self.inner.local_secondary_index_override(input);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes provided should match existing secondary indexes. You can choose to exclude some or all of the indexes at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.inner = self.inner.set_local_secondary_index_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput_override(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, input: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification_override(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification_override(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Scan`.
    ///
    /// <p>The <code>Scan</code> operation returns one or more items and item attributes by accessing every item in a table or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code> operation.</p>
    /// <p>If the total number of scanned items exceeds the maximum dataset size limit of 1 MB, the scan stops and results are returned to the user as a <code>LastEvaluatedKey</code> value to continue the scan in a subsequent operation. The results also include the number of items exceeding the limit. A scan can result in no table data meeting the filter criteria. </p>
    /// <p>A single <code>Scan</code> operation reads up to the maximum number of items set (if using the <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    /// <p> <code>Scan</code> operations proceed sequentially; however, for faster performance on a large table or secondary index, applications can request a parallel <code>Scan</code> operation by providing the <code>Segment</code> and <code>TotalSegments</code> parameters. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p> <code>Scan</code> uses eventually consistent reads when accessing the data in a table; therefore, the result set might not include the changes to data in the table immediately before the operation began. If you need a consistent copy of the data, as of the time that the <code>Scan</code> begins, you can set the <code>ConsistentRead</code> parameter to <code>true</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Scan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::scan_input::Builder,
    }
    impl Scan {
        /// Creates a new `Scan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ScanOutput,
            aws_smithy_http::result::SdkError<crate::error::ScanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ScanPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ScanPaginator {
            crate::paginator::ScanPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table containing the requested items; or, if you provide <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or global secondary index. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName</code>.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// Appends an item to `AttributesToGet`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attributes_to_get(input.into());
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_get(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>
        /// <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>
        /// <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>
        /// <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation reads only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, input: crate::model::Select) -> Self {
            self.inner = self.inner.select(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li> <p> <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.</p> </li>
        /// <li> <p> <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.</p> </li>
        /// <li> <p> <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.</p> </li>
        /// <li> <p> <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for <code>Select</code>.</p> <p>If you query or scan a local secondary index and request only attributes that are projected into that index, the operation reads only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.</p> <p>If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.</p> </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)</p> <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.inner = self.inner.set_select(input);
            self
        }
        /// Adds a key-value pair to `ScanFilter`.
        ///
        /// To override the contents of this collection use [`set_scan_filter`](Self::set_scan_filter).
        ///
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn scan_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Condition,
        ) -> Self {
            self.inner = self.inner.scan_filter(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_scan_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_scan_filter(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// Adds a key-value pair to `ExclusiveStartKey`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p>
        /// <p>In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.exclusive_start_key(k.into(), v);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No set data types are allowed.</p>
        /// <p>In a parallel scan, a <code>Scan</code> request that includes <code>ExclusiveStartKey</code> must specify the same segment whose previous <code>Scan</code> returned the corresponding value of <code>LastEvaluatedKey</code>.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_exclusive_start_key(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments into which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code> corresponds to the number of application workers that will perform the parallel scan. For example, if you want to use four application threads to scan a table or an index, specify a <code>TotalSegments</code> value of 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>
        pub fn total_segments(mut self, input: i32) -> Self {
            self.inner = self.inner.total_segments(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the total number of segments into which the <code>Scan</code> operation will be divided. The value of <code>TotalSegments</code> corresponds to the number of application workers that will perform the parallel scan. For example, if you want to use four application threads to scan a table or an index, specify a <code>TotalSegments</code> value of 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the <code>Scan</code> operation will be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify <code>Segment</code>.</p>
        pub fn set_total_segments(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_total_segments(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>
        pub fn segment(mut self, input: i32) -> Self {
            self.inner = self.inner.segment(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an individual segment to be scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want to use four application threads to scan a table or an index, then the first thread specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code> request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a subsequent <code>Scan</code> operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than the value provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide <code>TotalSegments</code>.</p>
        pub fn set_segment(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_segment(input);
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.projection_expression(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table or index. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_projection_expression(input);
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p> <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_expression(input.into());
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code> operation, but before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.</p> <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k.into(), v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li> <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not contain the results from other recently completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or <code>DeleteItem</code>).</p> </li>
        /// <li> <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p> </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.inner = self.inner.consistent_read(input);
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li> <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned from <code>Scan</code> might not contain the results from other recently completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or <code>DeleteItem</code>).</p> </li>
        /// <li> <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write operations that completed before the <code>Scan</code> began are guaranteed to be contained in the <code>Scan</code> response.</p> </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to true, you will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_consistent_read(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up to five times per second, per account. </p>
    /// <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransactGetItems`.
    ///
    /// <p> <code>TransactGetItems</code> is a synchronous operation that atomically retrieves multiple items from one or more tables (but not from indexes) in a single account and Region. A <code>TransactGetItems</code> call can contain up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure that specifies an item to retrieve from a table in the account and Region. A call to <code>TransactGetItems</code> cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of the items in the transaction cannot exceed 4 MB.</p>
    /// <p>DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:</p>
    /// <ul>
    /// <li> <p>A conflicting operation is in the process of updating an item to be read.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// <li> <p>The aggregate size of the items in the transaction cannot exceed 4 MB.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TransactGetItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::transact_get_items_input::Builder,
    }
    impl TransactGetItems {
        /// Creates a new `TransactGetItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransactGetItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::TransactGetItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactItems`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure.</p>
        pub fn transact_items(mut self, input: crate::model::TransactGetItem) -> Self {
            self.inner = self.inner.transact_items(input);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure.</p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactGetItem>>,
        ) -> Self {
            self.inner = self.inner.set_transact_items(input);
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of <code>NONE</code> prevents that information from being returned. No other value is valid.</p>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of <code>NONE</code> prevents that information from being returned. No other value is valid.</p>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransactWriteItems`.
    ///
    /// <p> <code>TransactWriteItems</code> is a synchronous write operation that groups up to 25 action requests. These actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and no two actions can target the same item. For example, you cannot both <code>ConditionCheck</code> and <code>Update</code> the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.</p>
    /// <p>The actions are completed atomically so that either all of them succeed, or all of them fail. They are defined by the following objects:</p>
    /// <ul>
    /// <li> <p> <code>Put</code> &nbsp;— &nbsp; Initiates a <code>PutItem</code> operation to write a new item. This structure specifies the primary key of the item to be written, the name of the table to write it in, an optional condition expression that must be satisfied for the write to succeed, a list of the item's attributes, and a field indicating whether to retrieve the item's attributes if the condition is not met.</p> </li>
    /// <li> <p> <code>Update</code> &nbsp;— &nbsp; Initiates an <code>UpdateItem</code> operation to update an existing item. This structure specifies the primary key of the item to be updated, the name of the table where it resides, an optional condition expression that must be satisfied for the update to succeed, an expression that defines one or more attributes to be updated, and a field indicating whether to retrieve the item's attributes if the condition is not met.</p> </li>
    /// <li> <p> <code>Delete</code> &nbsp;— &nbsp; Initiates a <code>DeleteItem</code> operation to delete an existing item. This structure specifies the primary key of the item to be deleted, the name of the table where it resides, an optional condition expression that must be satisfied for the deletion to succeed, and a field indicating whether to retrieve the item's attributes if the condition is not met.</p> </li>
    /// <li> <p> <code>ConditionCheck</code> &nbsp;— &nbsp; Applies a condition to an item that is not being modified by the transaction. This structure specifies the primary key of the item to be checked, the name of the table where it resides, a condition expression that must be satisfied for the transaction to succeed, and a field indicating whether to retrieve the item's attributes if the condition is not met.</p> </li>
    /// </ul>
    /// <p>DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:</p>
    /// <ul>
    /// <li> <p>A condition in one of the condition expressions is not met.</p> </li>
    /// <li> <p>An ongoing operation is in the process of updating the same item.</p> </li>
    /// <li> <p>There is insufficient provisioned capacity for the transaction to be completed.</p> </li>
    /// <li> <p>An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too large, or a similar validation error occurs because of changes made by the transaction.</p> </li>
    /// <li> <p>The aggregate size of the items in the transaction exceeds 4 MB.</p> </li>
    /// <li> <p>There is a user error, such as an invalid data format.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TransactWriteItems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::transact_write_items_input::Builder,
    }
    impl TransactWriteItems {
        /// Creates a new `TransactWriteItems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransactWriteItemsOutput,
            aws_smithy_http::result::SdkError<crate::error::TransactWriteItemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TransactItems`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can operate on items in different tables, but the tables must reside in the same Amazon Web Services account and Region, and no two of them can operate on the same item. </p>
        pub fn transact_items(mut self, input: crate::model::TransactWriteItem) -> Self {
            self.inner = self.inner.transact_items(input);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or <code>Delete</code> object. These can operate on items in different tables, but the tables must reside in the same Amazon Web Services account and Region, and no two of them can operate on the same item. </p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactWriteItem>>,
        ) -> Self {
            self.inner = self.inner.set_transact_items(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections (if any), that were modified during the operation and are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned. </p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections (if any), that were modified during the operation and are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned. </p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same result on the server (no side effects), the responses to the calls might not be the same. If the <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number of read capacity units consumed in reading the item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is completed. After 10 minutes, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 10 minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters within the 10-minute idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same result on the server (no side effects), the responses to the calls might not be the same. If the <code>ReturnConsumedCapacity&gt;</code> parameter is set, then the initial <code>TransactWriteItems</code> call returns the amount of write capacity units consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with the same client token return the number of read capacity units consumed in reading the item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is completed. After 10 minutes, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 10 minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters within the 10-minute idempotency window, DynamoDB returns an <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the association of tags from an Amazon DynamoDB resource. You can call <code>UntagResource</code> up to five times per second, per account. </p>
    /// <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list will be removed from the DynamoDB resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list will be removed from the DynamoDB resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContinuousBackups`.
    ///
    /// <p> <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table. A successful <code>UpdateContinuousBackups</code> call returns the current <code>ContinuousBackupsDescription</code>. Continuous backups are <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.</p>
    /// <p> Once continuous backups and point in time recovery are enabled, you can restore to any point in time within <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>. </p>
    /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table to any point in time during the last 35 days. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContinuousBackups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_continuous_backups_input::Builder,
    }
    impl UpdateContinuousBackups {
        /// Creates a new `UpdateContinuousBackups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContinuousBackupsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContinuousBackupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn point_in_time_recovery_specification(
            mut self,
            input: crate::model::PointInTimeRecoverySpecification,
        ) -> Self {
            self.inner = self.inner.point_in_time_recovery_specification(input);
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn set_point_in_time_recovery_specification(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoverySpecification>,
        ) -> Self {
            self.inner = self.inner.set_point_in_time_recovery_specification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContributorInsights`.
    ///
    /// <p>Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContributorInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_contributor_insights_input::Builder,
    }
    impl UpdateContributorInsights {
        /// Creates a new `UpdateContributorInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContributorInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContributorInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn contributor_insights_action(
            mut self,
            input: crate::model::ContributorInsightsAction,
        ) -> Self {
            self.inner = self.inner.contributor_insights_action(input);
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn set_contributor_insights_action(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsAction>,
        ) -> Self {
            self.inner = self.inner.set_contributor_insights_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalTable`.
    ///
    /// <p>Adds or removes replicas in the specified global table. The global table must already exist to be able to use this operation. Any replica to be added must be empty, have the same name as the global table, have the same key schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.</p> <note>
    /// <p>Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in a single request, for simplicity we recommend that you issue separate requests for adding or removing replicas.</p>
    /// </note>
    /// <p> If global secondary indexes are specified, then the following conditions must also be met: </p>
    /// <ul>
    /// <li> <p> The global secondary indexes must have the same name. </p> </li>
    /// <li> <p> The global secondary indexes must have the same hash key and sort key (if present). </p> </li>
    /// <li> <p> The global secondary indexes must have the same provisioned and maximum write capacity units. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGlobalTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_global_table_input::Builder,
    }
    impl UpdateGlobalTable {
        /// Creates a new `UpdateGlobalTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn replica_updates(mut self, input: crate::model::ReplicaUpdate) -> Self {
            self.inner = self.inner.replica_updates(input);
            self
        }
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGlobalTableSettings`.
    ///
    /// <p>Updates settings for a global table.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGlobalTableSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_global_table_settings_input::Builder,
    }
    impl UpdateGlobalTableSettings {
        /// Creates a new `UpdateGlobalTableSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGlobalTableSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGlobalTableSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the global table</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_table_name(input.into());
            self
        }
        /// <p>The name of the global table</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_table_name(input);
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn global_table_billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.inner = self.inner.global_table_billing_mode(input);
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn set_global_table_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_global_table_billing_mode(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
        pub fn global_table_provisioned_write_capacity_units(mut self, input: i64) -> Self {
            self.inner = self
                .inner
                .global_table_provisioned_write_capacity_units(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
        pub fn set_global_table_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_provisioned_write_capacity_units(input);
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global table.</p>
        pub fn global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.inner = self
                .inner
                .global_table_provisioned_write_capacity_auto_scaling_settings_update(input);
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global table.</p>
        pub fn set_global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_provisioned_write_capacity_auto_scaling_settings_update(input);
            self
        }
        /// Appends an item to `GlobalTableGlobalSecondaryIndexSettingsUpdate`.
        ///
        /// To override the contents of this collection use [`set_global_table_global_secondary_index_settings_update`](Self::set_global_table_global_secondary_index_settings_update).
        ///
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn global_table_global_secondary_index_settings_update(
            mut self,
            input: crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate,
        ) -> Self {
            self.inner = self
                .inner
                .global_table_global_secondary_index_settings_update(input);
            self
        }
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn set_global_table_global_secondary_index_settings_update(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
            >,
        ) -> Self {
            self.inner = self
                .inner
                .set_global_table_global_secondary_index_settings_update(input);
            self
        }
        /// Appends an item to `ReplicaSettingsUpdate`.
        ///
        /// To override the contents of this collection use [`set_replica_settings_update`](Self::set_replica_settings_update).
        ///
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn replica_settings_update(
            mut self,
            input: crate::model::ReplicaSettingsUpdate,
        ) -> Self {
            self.inner = self.inner.replica_settings_update(input);
            self
        }
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn set_replica_settings_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_settings_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateItem`.
    ///
    /// <p>Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put, delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected attribute values).</p>
    /// <p>You can also return the item's attribute values in the same <code>UpdateItem</code> operation using the <code>ReturnValues</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateItem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_item_input::Builder,
    }
    impl UpdateItem {
        /// Creates a new `UpdateItem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateItemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateItemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table containing the item to update.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table containing the item to update.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Adds a key-value pair to `Key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.key(k.into(), v);
            self
        }
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `AttributeUpdates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attribute_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValueUpdate,
        ) -> Self {
            self.inner = self.inner.attribute_updates(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attribute_updates(input);
            self
        }
        /// Adds a key-value pair to `Expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ExpectedAttributeValue,
        ) -> Self {
            self.inner = self.inner.expected(k.into(), v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_expected(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.inner = self.inner.conditional_operator(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.inner = self.inner.set_conditional_operator(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are updated. For <code>UpdateItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p> </li>
        /// <li> <p> <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p> </li>
        /// <li> <p> <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p> </li>
        /// <li> <p> <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p> </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.inner = self.inner.return_values(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear before or after they are updated. For <code>UpdateItem</code>, the valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)</p> </li>
        /// <li> <p> <code>ALL_OLD</code> - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.</p> </li>
        /// <li> <p> <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared before the UpdateItem operation.</p> </li>
        /// <li> <p> <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear after the UpdateItem operation.</p> </li>
        /// <li> <p> <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear after the UpdateItem operation.</p> </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.inner = self.inner.set_return_values(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.inner = self.inner.return_consumed_capacity(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:</p>
        /// <ul>
        /// <li> <p> <code>INDEXES</code> - The response includes the aggregate <code>ConsumedCapacity</code> for the operation, together with <code>ConsumedCapacity</code> for each table and secondary index that was accessed.</p> <p>Note that some operations, such as <code>GetItem</code> and <code>BatchGetItem</code>, do not access any indexes at all. In these cases, specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code> information for table(s).</p> </li>
        /// <li> <p> <code>TOTAL</code> - The response includes only the aggregate <code>ConsumedCapacity</code> for the operation.</p> </li>
        /// <li> <p> <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the response.</p> </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.inner = self.inner.set_return_consumed_capacity(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.inner = self.inner.return_item_collection_metrics(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.inner = self.inner.set_return_item_collection_metrics(input);
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li> <p> <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code> </p> <p> <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li> <p> <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p> </li>
        /// <li> <p> <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p> </li>
        /// </ul> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p> <code>REMOVE</code> - Removes one or more attributes from an item.</p> </li>
        /// <li> <p> <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update doesn't have an attribute named <code>itemcount</code>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.</p>
        /// </note> </li>
        /// <li> <p>If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings.</p> </li>
        /// </ul> <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important> </li>
        /// <li> <p> <code>DELETE</code> - Deletes an element from a set.</p> <p>If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an error.</p> <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important> </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code> </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn update_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_expression(input.into());
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li> <p> <code>SET</code> - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use <code>SET</code> to add or subtract from an attribute that is of type Number. For example: <code>SET myNum = myNum + :val</code> </p> <p> <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li> <p> <code>if_not_exists (path, operand)</code> - if the item does not contain an attribute at the specified path, then <code>if_not_exists</code> evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.</p> </li>
        /// <li> <p> <code>list_append (operand, operand)</code> - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.</p> </li>
        /// </ul> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p> <code>REMOVE</code> - Removes one or more attributes from an item.</p> </li>
        /// <li> <p> <code>ADD</code> - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to increment or decrement an attribute value that doesn't exist before the update, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update doesn't have an attribute named <code>itemcount</code>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway. DynamoDB will create the <code>itemcount</code> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <code>itemcount</code> attribute in the item, with a value of <code>3</code>.</p>
        /// </note> </li>
        /// <li> <p>If the existing data type is a set and if <code>Value</code> is also a set, then <code>Value</code> is added to the existing set. For example, if the attribute value is the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value is <code>[1,2,3]</code>. An error occurs if an <code>ADD</code> action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings.</p> </li>
        /// </ul> <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In addition, <code>ADD</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important> </li>
        /// <li> <p> <code>DELETE</code> - Deletes an element from a set.</p> <p>If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final attribute value is <code>[b]</code>. Specifying an empty set is an error.</p> <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition, <code>DELETE</code> can only be used on top-level attributes, not nested attributes.</p>
        /// </important> </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET a=:value1, b=:value2 DELETE :value3, :value4, :value5</code> </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying Items and Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_update_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_update_expression(input);
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.condition_expression(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li> <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code> </p> <p>These function names are case-sensitive.</p> </li>
        /// <li> <p>Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code> </p> </li>
        /// <li> <p> Logical operators: <code>AND | OR | NOT</code> </p> </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_condition_expression(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeNames`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expression_attribute_names(k.into(), v.into());
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.) To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_names(input);
            self
        }
        /// Adds a key-value pair to `ExpressionAttributeValues`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            self.inner = self.inner.expression_attribute_values(k.into(), v);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p> <code>Available | Backordered | Discontinued</code> </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as follows:</p>
        /// <p> <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code> </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p> <code>ProductStatus IN (:avail, :back, :disc)</code> </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_expression_attribute_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTable`.
    ///
    /// <p>Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.</p>
    /// <p>You can only perform one of the following operations at once:</p>
    /// <ul>
    /// <li> <p>Modify the provisioned throughput settings of the table.</p> </li>
    /// <li> <p>Enable or disable DynamoDB Streams on the table.</p> </li>
    /// <li> <p>Remove a global secondary index from the table.</p> </li>
    /// <li> <p>Create a new global secondary index on the table. After the index begins backfilling, you can use <code>UpdateTable</code> to perform other operations.</p> </li>
    /// </ul>
    /// <p> <code>UpdateTable</code> is an asynchronous operation; while it is executing, the table status changes from <code>ACTIVE</code> to <code>UPDATING</code>. While it is <code>UPDATING</code>, you cannot issue another <code>UpdateTable</code> request. When the table returns to the <code>ACTIVE</code> state, the <code>UpdateTable</code> operation is complete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTable {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_table_input::Builder,
    }
    impl UpdateTable {
        /// Creates a new `UpdateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeDefinitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>
        pub fn attribute_definitions(mut self, input: crate::model::AttributeDefinition) -> Self {
            self.inner = self.inner.attribute_definitions(input);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_definitions(input);
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.inner = self.inner.billing_mode(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p> </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.inner = self.inner.set_billing_mode(input);
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.inner = self.inner.provisioned_throughput(input);
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput(input);
            self
        }
        /// Appends an item to `GlobalSecondaryIndexUpdates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p>
        /// <ul>
        /// <li> <p> <code>Create</code> - add a new global secondary index to the table.</p> </li>
        /// <li> <p> <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p> </li>
        /// <li> <p> <code>Delete</code> - remove a global secondary index from the table.</p> </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn global_secondary_index_updates(
            mut self,
            input: crate::model::GlobalSecondaryIndexUpdate,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_updates(input);
            self
        }
        /// <p>An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:</p>
        /// <ul>
        /// <li> <p> <code>Create</code> - add a new global secondary index to the table.</p> </li>
        /// <li> <p> <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.</p> </li>
        /// <li> <p> <code>Delete</code> - remove a global secondary index from the table.</p> </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code> operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_updates(input);
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p> <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream.</p>
        /// </note>
        pub fn stream_specification(mut self, input: crate::model::StreamSpecification) -> Self {
            self.inner = self.inner.stream_specification(input);
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p> <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream.</p>
        /// </note>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.inner = self.inner.set_stream_specification(input);
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.inner = self.inner.sse_specification(input);
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.inner = self.inner.set_sse_specification(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p> <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn replica_updates(mut self, input: crate::model::ReplicationGroupUpdate) -> Self {
            self.inner = self.inner.replica_updates(input);
            self
        }
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p> <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationGroupUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
        /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn table_class(mut self, input: crate::model::TableClass) -> Self {
            self.inner = self.inner.table_class(input);
            self
        }
        /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn set_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.inner = self.inner.set_table_class(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTableReplicaAutoScaling`.
    ///
    /// <p>Updates auto scaling settings on your global tables at once.</p> <note>
    /// <p>This operation only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21</a> of global tables.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTableReplicaAutoScaling {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_table_replica_auto_scaling_input::Builder,
    }
    impl UpdateTableReplicaAutoScaling {
        /// Creates a new `UpdateTableReplicaAutoScaling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableReplicaAutoScalingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableReplicaAutoScalingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GlobalSecondaryIndexUpdates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to be updated.</p>
        pub fn global_secondary_index_updates(
            mut self,
            input: crate::model::GlobalSecondaryIndexAutoScalingUpdate,
        ) -> Self {
            self.inner = self.inner.global_secondary_index_updates(input);
            self
        }
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to be updated.</p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalSecondaryIndexAutoScalingUpdate>,
            >,
        ) -> Self {
            self.inner = self.inner.set_global_secondary_index_updates(input);
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.inner = self
                .inner
                .provisioned_write_capacity_auto_scaling_update(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.inner = self
                .inner
                .set_provisioned_write_capacity_auto_scaling_update(input);
            self
        }
        /// Appends an item to `ReplicaUpdates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>Represents the auto scaling settings of replicas of the table that will be modified.</p>
        pub fn replica_updates(mut self, input: crate::model::ReplicaAutoScalingUpdate) -> Self {
            self.inner = self.inner.replica_updates(input);
            self
        }
        /// <p>Represents the auto scaling settings of replicas of the table that will be modified.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_replica_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTimeToLive`.
    ///
    /// <p>The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the specified table. A successful <code>UpdateTimeToLive</code> call returns the current <code>TimeToLiveSpecification</code>. It can take up to one hour for the change to fully process. Any additional <code>UpdateTimeToLive</code> calls for the same table during this one hour duration result in a <code>ValidationException</code>. </p>
    /// <p>TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the epoch time value stored in the attribute is less than the current time, the item is marked as expired and subsequently deleted.</p> <note>
    /// <p> The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC. </p>
    /// </note>
    /// <p>DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data operations. </p> <important>
    /// <p>DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been deleted will still show up in reads, queries, and scans.</p>
    /// </important>
    /// <p>As items are deleted, they are removed from any local secondary index and global secondary index immediately in the same eventually consistent way as a standard delete operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon DynamoDB Developer Guide. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTimeToLive {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_time_to_live_input::Builder,
    }
    impl UpdateTimeToLive {
        /// Creates a new `UpdateTimeToLive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTimeToLiveOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTimeToLiveError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the table to be configured.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(input.into());
            self
        }
        /// <p>The name of the table to be configured.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified table.</p>
        pub fn time_to_live_specification(
            mut self,
            input: crate::model::TimeToLiveSpecification,
        ) -> Self {
            self.inner = self.inner.time_to_live_specification(input);
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified table.</p>
        pub fn set_time_to_live_specification(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveSpecification>,
        ) -> Self {
            self.inner = self.inner.set_time_to_live_specification(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
