// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchExecuteStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_execute_statement`](crate::client::Client::batch_execute_statement).
///
/// See [`crate::client::fluent_builders::BatchExecuteStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchExecuteStatement {
    _private: (),
}
impl BatchExecuteStatement {
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    pub fn builder() -> crate::input::batch_execute_statement_input::Builder {
        crate::input::batch_execute_statement_input::Builder::default()
    }
    /// Creates a new `BatchExecuteStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchExecuteStatement {
    type Output = std::result::Result<
        crate::output::BatchExecuteStatementOutput,
        crate::error::BatchExecuteStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_execute_statement_error(response)
        } else {
            crate::operation_deser::parse_batch_execute_statement_response(response)
        }
    }
}

/// Operation shape for `BatchGetItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_item`](crate::client::Client::batch_get_item).
///
/// See [`crate::client::fluent_builders::BatchGetItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetItem {
    _private: (),
}
impl BatchGetItem {
    /// Creates a new builder-style object to manufacture [`BatchGetItemInput`](crate::input::BatchGetItemInput)
    pub fn builder() -> crate::input::batch_get_item_input::Builder {
        crate::input::batch_get_item_input::Builder::default()
    }
    /// Creates a new `BatchGetItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetItem {
    type Output =
        std::result::Result<crate::output::BatchGetItemOutput, crate::error::BatchGetItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_item_error(response)
        } else {
            crate::operation_deser::parse_batch_get_item_response(response)
        }
    }
}

/// Operation shape for `BatchWriteItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_write_item`](crate::client::Client::batch_write_item).
///
/// See [`crate::client::fluent_builders::BatchWriteItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchWriteItem {
    _private: (),
}
impl BatchWriteItem {
    /// Creates a new builder-style object to manufacture [`BatchWriteItemInput`](crate::input::BatchWriteItemInput)
    pub fn builder() -> crate::input::batch_write_item_input::Builder {
        crate::input::batch_write_item_input::Builder::default()
    }
    /// Creates a new `BatchWriteItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchWriteItem {
    type Output =
        std::result::Result<crate::output::BatchWriteItemOutput, crate::error::BatchWriteItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_write_item_error(response)
        } else {
            crate::operation_deser::parse_batch_write_item_response(response)
        }
    }
}

/// Operation shape for `CreateBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_backup`](crate::client::Client::create_backup).
///
/// See [`crate::client::fluent_builders::CreateBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBackup {
    _private: (),
}
impl CreateBackup {
    /// Creates a new builder-style object to manufacture [`CreateBackupInput`](crate::input::CreateBackupInput)
    pub fn builder() -> crate::input::create_backup_input::Builder {
        crate::input::create_backup_input::Builder::default()
    }
    /// Creates a new `CreateBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBackup {
    type Output =
        std::result::Result<crate::output::CreateBackupOutput, crate::error::CreateBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_backup_error(response)
        } else {
            crate::operation_deser::parse_create_backup_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_table`](crate::client::Client::create_global_table).
///
/// See [`crate::client::fluent_builders::CreateGlobalTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalTable {
    _private: (),
}
impl CreateGlobalTable {
    /// Creates a new builder-style object to manufacture [`CreateGlobalTableInput`](crate::input::CreateGlobalTableInput)
    pub fn builder() -> crate::input::create_global_table_input::Builder {
        crate::input::create_global_table_input::Builder::default()
    }
    /// Creates a new `CreateGlobalTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalTable {
    type Output = std::result::Result<
        crate::output::CreateGlobalTableOutput,
        crate::error::CreateGlobalTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_table_error(response)
        } else {
            crate::operation_deser::parse_create_global_table_response(response)
        }
    }
}

/// Operation shape for `CreateTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_table`](crate::client::Client::create_table).
///
/// See [`crate::client::fluent_builders::CreateTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTable {
    _private: (),
}
impl CreateTable {
    /// Creates a new builder-style object to manufacture [`CreateTableInput`](crate::input::CreateTableInput)
    pub fn builder() -> crate::input::create_table_input::Builder {
        crate::input::create_table_input::Builder::default()
    }
    /// Creates a new `CreateTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTable {
    type Output =
        std::result::Result<crate::output::CreateTableOutput, crate::error::CreateTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_table_error(response)
        } else {
            crate::operation_deser::parse_create_table_response(response)
        }
    }
}

/// Operation shape for `DeleteBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_backup`](crate::client::Client::delete_backup).
///
/// See [`crate::client::fluent_builders::DeleteBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBackup {
    _private: (),
}
impl DeleteBackup {
    /// Creates a new builder-style object to manufacture [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    pub fn builder() -> crate::input::delete_backup_input::Builder {
        crate::input::delete_backup_input::Builder::default()
    }
    /// Creates a new `DeleteBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBackup {
    type Output =
        std::result::Result<crate::output::DeleteBackupOutput, crate::error::DeleteBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_backup_error(response)
        } else {
            crate::operation_deser::parse_delete_backup_response(response)
        }
    }
}

/// Operation shape for `DeleteItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_item`](crate::client::Client::delete_item).
///
/// See [`crate::client::fluent_builders::DeleteItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteItem {
    _private: (),
}
impl DeleteItem {
    /// Creates a new builder-style object to manufacture [`DeleteItemInput`](crate::input::DeleteItemInput)
    pub fn builder() -> crate::input::delete_item_input::Builder {
        crate::input::delete_item_input::Builder::default()
    }
    /// Creates a new `DeleteItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteItem {
    type Output =
        std::result::Result<crate::output::DeleteItemOutput, crate::error::DeleteItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_item_error(response)
        } else {
            crate::operation_deser::parse_delete_item_response(response)
        }
    }
}

/// Operation shape for `DeleteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_table`](crate::client::Client::delete_table).
///
/// See [`crate::client::fluent_builders::DeleteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTable {
    _private: (),
}
impl DeleteTable {
    /// Creates a new builder-style object to manufacture [`DeleteTableInput`](crate::input::DeleteTableInput)
    pub fn builder() -> crate::input::delete_table_input::Builder {
        crate::input::delete_table_input::Builder::default()
    }
    /// Creates a new `DeleteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTable {
    type Output =
        std::result::Result<crate::output::DeleteTableOutput, crate::error::DeleteTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_table_error(response)
        } else {
            crate::operation_deser::parse_delete_table_response(response)
        }
    }
}

/// Operation shape for `DescribeBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_backup`](crate::client::Client::describe_backup).
///
/// See [`crate::client::fluent_builders::DescribeBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBackup {
    _private: (),
}
impl DescribeBackup {
    /// Creates a new builder-style object to manufacture [`DescribeBackupInput`](crate::input::DescribeBackupInput)
    pub fn builder() -> crate::input::describe_backup_input::Builder {
        crate::input::describe_backup_input::Builder::default()
    }
    /// Creates a new `DescribeBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBackup {
    type Output =
        std::result::Result<crate::output::DescribeBackupOutput, crate::error::DescribeBackupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_backup_error(response)
        } else {
            crate::operation_deser::parse_describe_backup_response(response)
        }
    }
}

/// Operation shape for `DescribeContinuousBackups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_continuous_backups`](crate::client::Client::describe_continuous_backups).
///
/// See [`crate::client::fluent_builders::DescribeContinuousBackups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeContinuousBackups {
    _private: (),
}
impl DescribeContinuousBackups {
    /// Creates a new builder-style object to manufacture [`DescribeContinuousBackupsInput`](crate::input::DescribeContinuousBackupsInput)
    pub fn builder() -> crate::input::describe_continuous_backups_input::Builder {
        crate::input::describe_continuous_backups_input::Builder::default()
    }
    /// Creates a new `DescribeContinuousBackups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeContinuousBackups {
    type Output = std::result::Result<
        crate::output::DescribeContinuousBackupsOutput,
        crate::error::DescribeContinuousBackupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_continuous_backups_error(response)
        } else {
            crate::operation_deser::parse_describe_continuous_backups_response(response)
        }
    }
}

/// Operation shape for `DescribeContributorInsights`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_contributor_insights`](crate::client::Client::describe_contributor_insights).
///
/// See [`crate::client::fluent_builders::DescribeContributorInsights`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeContributorInsights {
    _private: (),
}
impl DescribeContributorInsights {
    /// Creates a new builder-style object to manufacture [`DescribeContributorInsightsInput`](crate::input::DescribeContributorInsightsInput)
    pub fn builder() -> crate::input::describe_contributor_insights_input::Builder {
        crate::input::describe_contributor_insights_input::Builder::default()
    }
    /// Creates a new `DescribeContributorInsights` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeContributorInsights {
    type Output = std::result::Result<
        crate::output::DescribeContributorInsightsOutput,
        crate::error::DescribeContributorInsightsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_contributor_insights_error(response)
        } else {
            crate::operation_deser::parse_describe_contributor_insights_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoints`](crate::client::Client::describe_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoints {
    _private: (),
}
impl DescribeEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    pub fn builder() -> crate::input::describe_endpoints_input::Builder {
        crate::input::describe_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeEndpointsOutput,
        crate::error::DescribeEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoints_response(response)
        }
    }
}

/// Operation shape for `DescribeExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export`](crate::client::Client::describe_export).
///
/// See [`crate::client::fluent_builders::DescribeExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExport {
    _private: (),
}
impl DescribeExport {
    /// Creates a new builder-style object to manufacture [`DescribeExportInput`](crate::input::DescribeExportInput)
    pub fn builder() -> crate::input::describe_export_input::Builder {
        crate::input::describe_export_input::Builder::default()
    }
    /// Creates a new `DescribeExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExport {
    type Output =
        std::result::Result<crate::output::DescribeExportOutput, crate::error::DescribeExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_error(response)
        } else {
            crate::operation_deser::parse_describe_export_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_table`](crate::client::Client::describe_global_table).
///
/// See [`crate::client::fluent_builders::DescribeGlobalTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalTable {
    _private: (),
}
impl DescribeGlobalTable {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableInput`](crate::input::DescribeGlobalTableInput)
    pub fn builder() -> crate::input::describe_global_table_input::Builder {
        crate::input::describe_global_table_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalTable {
    type Output = std::result::Result<
        crate::output::DescribeGlobalTableOutput,
        crate::error::DescribeGlobalTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_table_error(response)
        } else {
            crate::operation_deser::parse_describe_global_table_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalTableSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_table_settings`](crate::client::Client::describe_global_table_settings).
///
/// See [`crate::client::fluent_builders::DescribeGlobalTableSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalTableSettings {
    _private: (),
}
impl DescribeGlobalTableSettings {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableSettingsInput`](crate::input::DescribeGlobalTableSettingsInput)
    pub fn builder() -> crate::input::describe_global_table_settings_input::Builder {
        crate::input::describe_global_table_settings_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalTableSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalTableSettings {
    type Output = std::result::Result<
        crate::output::DescribeGlobalTableSettingsOutput,
        crate::error::DescribeGlobalTableSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_table_settings_error(response)
        } else {
            crate::operation_deser::parse_describe_global_table_settings_response(response)
        }
    }
}

/// Operation shape for `DescribeKinesisStreamingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_kinesis_streaming_destination`](crate::client::Client::describe_kinesis_streaming_destination).
///
/// See [`crate::client::fluent_builders::DescribeKinesisStreamingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeKinesisStreamingDestination {
    _private: (),
}
impl DescribeKinesisStreamingDestination {
    /// Creates a new builder-style object to manufacture [`DescribeKinesisStreamingDestinationInput`](crate::input::DescribeKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::describe_kinesis_streaming_destination_input::Builder {
        crate::input::describe_kinesis_streaming_destination_input::Builder::default()
    }
    /// Creates a new `DescribeKinesisStreamingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeKinesisStreamingDestination {
    type Output = std::result::Result<
        crate::output::DescribeKinesisStreamingDestinationOutput,
        crate::error::DescribeKinesisStreamingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_kinesis_streaming_destination_error(response)
        } else {
            crate::operation_deser::parse_describe_kinesis_streaming_destination_response(response)
        }
    }
}

/// Operation shape for `DescribeLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_limits`](crate::client::Client::describe_limits).
///
/// See [`crate::client::fluent_builders::DescribeLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLimits {
    _private: (),
}
impl DescribeLimits {
    /// Creates a new builder-style object to manufacture [`DescribeLimitsInput`](crate::input::DescribeLimitsInput)
    pub fn builder() -> crate::input::describe_limits_input::Builder {
        crate::input::describe_limits_input::Builder::default()
    }
    /// Creates a new `DescribeLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLimits {
    type Output =
        std::result::Result<crate::output::DescribeLimitsOutput, crate::error::DescribeLimitsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_limits_response(response)
        }
    }
}

/// Operation shape for `DescribeTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_table`](crate::client::Client::describe_table).
///
/// See [`crate::client::fluent_builders::DescribeTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTable {
    _private: (),
}
impl DescribeTable {
    /// Creates a new builder-style object to manufacture [`DescribeTableInput`](crate::input::DescribeTableInput)
    pub fn builder() -> crate::input::describe_table_input::Builder {
        crate::input::describe_table_input::Builder::default()
    }
    /// Creates a new `DescribeTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTable {
    type Output =
        std::result::Result<crate::output::DescribeTableOutput, crate::error::DescribeTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_table_error(response)
        } else {
            crate::operation_deser::parse_describe_table_response(response)
        }
    }
}

/// Operation shape for `DescribeTableReplicaAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_table_replica_auto_scaling`](crate::client::Client::describe_table_replica_auto_scaling).
///
/// See [`crate::client::fluent_builders::DescribeTableReplicaAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTableReplicaAutoScaling {
    _private: (),
}
impl DescribeTableReplicaAutoScaling {
    /// Creates a new builder-style object to manufacture [`DescribeTableReplicaAutoScalingInput`](crate::input::DescribeTableReplicaAutoScalingInput)
    pub fn builder() -> crate::input::describe_table_replica_auto_scaling_input::Builder {
        crate::input::describe_table_replica_auto_scaling_input::Builder::default()
    }
    /// Creates a new `DescribeTableReplicaAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTableReplicaAutoScaling {
    type Output = std::result::Result<
        crate::output::DescribeTableReplicaAutoScalingOutput,
        crate::error::DescribeTableReplicaAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_table_replica_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_describe_table_replica_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `DescribeTimeToLive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_time_to_live`](crate::client::Client::describe_time_to_live).
///
/// See [`crate::client::fluent_builders::DescribeTimeToLive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTimeToLive {
    _private: (),
}
impl DescribeTimeToLive {
    /// Creates a new builder-style object to manufacture [`DescribeTimeToLiveInput`](crate::input::DescribeTimeToLiveInput)
    pub fn builder() -> crate::input::describe_time_to_live_input::Builder {
        crate::input::describe_time_to_live_input::Builder::default()
    }
    /// Creates a new `DescribeTimeToLive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTimeToLive {
    type Output = std::result::Result<
        crate::output::DescribeTimeToLiveOutput,
        crate::error::DescribeTimeToLiveError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_time_to_live_error(response)
        } else {
            crate::operation_deser::parse_describe_time_to_live_response(response)
        }
    }
}

/// Operation shape for `DisableKinesisStreamingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_kinesis_streaming_destination`](crate::client::Client::disable_kinesis_streaming_destination).
///
/// See [`crate::client::fluent_builders::DisableKinesisStreamingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableKinesisStreamingDestination {
    _private: (),
}
impl DisableKinesisStreamingDestination {
    /// Creates a new builder-style object to manufacture [`DisableKinesisStreamingDestinationInput`](crate::input::DisableKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::disable_kinesis_streaming_destination_input::Builder {
        crate::input::disable_kinesis_streaming_destination_input::Builder::default()
    }
    /// Creates a new `DisableKinesisStreamingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableKinesisStreamingDestination {
    type Output = std::result::Result<
        crate::output::DisableKinesisStreamingDestinationOutput,
        crate::error::DisableKinesisStreamingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_kinesis_streaming_destination_error(response)
        } else {
            crate::operation_deser::parse_disable_kinesis_streaming_destination_response(response)
        }
    }
}

/// Operation shape for `EnableKinesisStreamingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_kinesis_streaming_destination`](crate::client::Client::enable_kinesis_streaming_destination).
///
/// See [`crate::client::fluent_builders::EnableKinesisStreamingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableKinesisStreamingDestination {
    _private: (),
}
impl EnableKinesisStreamingDestination {
    /// Creates a new builder-style object to manufacture [`EnableKinesisStreamingDestinationInput`](crate::input::EnableKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::enable_kinesis_streaming_destination_input::Builder {
        crate::input::enable_kinesis_streaming_destination_input::Builder::default()
    }
    /// Creates a new `EnableKinesisStreamingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableKinesisStreamingDestination {
    type Output = std::result::Result<
        crate::output::EnableKinesisStreamingDestinationOutput,
        crate::error::EnableKinesisStreamingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_kinesis_streaming_destination_error(response)
        } else {
            crate::operation_deser::parse_enable_kinesis_streaming_destination_response(response)
        }
    }
}

/// Operation shape for `ExecuteStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_statement`](crate::client::Client::execute_statement).
///
/// See [`crate::client::fluent_builders::ExecuteStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteStatement {
    _private: (),
}
impl ExecuteStatement {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    pub fn builder() -> crate::input::execute_statement_input::Builder {
        crate::input::execute_statement_input::Builder::default()
    }
    /// Creates a new `ExecuteStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteStatement {
    type Output = std::result::Result<
        crate::output::ExecuteStatementOutput,
        crate::error::ExecuteStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_statement_error(response)
        } else {
            crate::operation_deser::parse_execute_statement_response(response)
        }
    }
}

/// Operation shape for `ExecuteTransaction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_transaction`](crate::client::Client::execute_transaction).
///
/// See [`crate::client::fluent_builders::ExecuteTransaction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteTransaction {
    _private: (),
}
impl ExecuteTransaction {
    /// Creates a new builder-style object to manufacture [`ExecuteTransactionInput`](crate::input::ExecuteTransactionInput)
    pub fn builder() -> crate::input::execute_transaction_input::Builder {
        crate::input::execute_transaction_input::Builder::default()
    }
    /// Creates a new `ExecuteTransaction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteTransaction {
    type Output = std::result::Result<
        crate::output::ExecuteTransactionOutput,
        crate::error::ExecuteTransactionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_transaction_error(response)
        } else {
            crate::operation_deser::parse_execute_transaction_response(response)
        }
    }
}

/// Operation shape for `ExportTableToPointInTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_table_to_point_in_time`](crate::client::Client::export_table_to_point_in_time).
///
/// See [`crate::client::fluent_builders::ExportTableToPointInTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportTableToPointInTime {
    _private: (),
}
impl ExportTableToPointInTime {
    /// Creates a new builder-style object to manufacture [`ExportTableToPointInTimeInput`](crate::input::ExportTableToPointInTimeInput)
    pub fn builder() -> crate::input::export_table_to_point_in_time_input::Builder {
        crate::input::export_table_to_point_in_time_input::Builder::default()
    }
    /// Creates a new `ExportTableToPointInTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportTableToPointInTime {
    type Output = std::result::Result<
        crate::output::ExportTableToPointInTimeOutput,
        crate::error::ExportTableToPointInTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_table_to_point_in_time_error(response)
        } else {
            crate::operation_deser::parse_export_table_to_point_in_time_response(response)
        }
    }
}

/// Operation shape for `GetItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_item`](crate::client::Client::get_item).
///
/// See [`crate::client::fluent_builders::GetItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetItem {
    _private: (),
}
impl GetItem {
    /// Creates a new builder-style object to manufacture [`GetItemInput`](crate::input::GetItemInput)
    pub fn builder() -> crate::input::get_item_input::Builder {
        crate::input::get_item_input::Builder::default()
    }
    /// Creates a new `GetItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetItem {
    type Output = std::result::Result<crate::output::GetItemOutput, crate::error::GetItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_item_error(response)
        } else {
            crate::operation_deser::parse_get_item_response(response)
        }
    }
}

/// Operation shape for `ListBackups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_backups`](crate::client::Client::list_backups).
///
/// See [`crate::client::fluent_builders::ListBackups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBackups {
    _private: (),
}
impl ListBackups {
    /// Creates a new builder-style object to manufacture [`ListBackupsInput`](crate::input::ListBackupsInput)
    pub fn builder() -> crate::input::list_backups_input::Builder {
        crate::input::list_backups_input::Builder::default()
    }
    /// Creates a new `ListBackups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBackups {
    type Output =
        std::result::Result<crate::output::ListBackupsOutput, crate::error::ListBackupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_backups_error(response)
        } else {
            crate::operation_deser::parse_list_backups_response(response)
        }
    }
}

/// Operation shape for `ListContributorInsights`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_contributor_insights`](crate::client::Client::list_contributor_insights).
///
/// See [`crate::client::fluent_builders::ListContributorInsights`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContributorInsights {
    _private: (),
}
impl ListContributorInsights {
    /// Creates a new builder-style object to manufacture [`ListContributorInsightsInput`](crate::input::ListContributorInsightsInput)
    pub fn builder() -> crate::input::list_contributor_insights_input::Builder {
        crate::input::list_contributor_insights_input::Builder::default()
    }
    /// Creates a new `ListContributorInsights` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContributorInsights {
    type Output = std::result::Result<
        crate::output::ListContributorInsightsOutput,
        crate::error::ListContributorInsightsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_contributor_insights_error(response)
        } else {
            crate::operation_deser::parse_list_contributor_insights_response(response)
        }
    }
}

/// Operation shape for `ListExports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_exports`](crate::client::Client::list_exports).
///
/// See [`crate::client::fluent_builders::ListExports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExports {
    _private: (),
}
impl ListExports {
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
    /// Creates a new `ListExports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExports {
    type Output =
        std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_exports_error(response)
        } else {
            crate::operation_deser::parse_list_exports_response(response)
        }
    }
}

/// Operation shape for `ListGlobalTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_global_tables`](crate::client::Client::list_global_tables).
///
/// See [`crate::client::fluent_builders::ListGlobalTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGlobalTables {
    _private: (),
}
impl ListGlobalTables {
    /// Creates a new builder-style object to manufacture [`ListGlobalTablesInput`](crate::input::ListGlobalTablesInput)
    pub fn builder() -> crate::input::list_global_tables_input::Builder {
        crate::input::list_global_tables_input::Builder::default()
    }
    /// Creates a new `ListGlobalTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGlobalTables {
    type Output = std::result::Result<
        crate::output::ListGlobalTablesOutput,
        crate::error::ListGlobalTablesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_global_tables_error(response)
        } else {
            crate::operation_deser::parse_list_global_tables_response(response)
        }
    }
}

/// Operation shape for `ListTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tables`](crate::client::Client::list_tables).
///
/// See [`crate::client::fluent_builders::ListTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTables {
    _private: (),
}
impl ListTables {
    /// Creates a new builder-style object to manufacture [`ListTablesInput`](crate::input::ListTablesInput)
    pub fn builder() -> crate::input::list_tables_input::Builder {
        crate::input::list_tables_input::Builder::default()
    }
    /// Creates a new `ListTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTables {
    type Output =
        std::result::Result<crate::output::ListTablesOutput, crate::error::ListTablesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tables_error(response)
        } else {
            crate::operation_deser::parse_list_tables_response(response)
        }
    }
}

/// Operation shape for `ListTagsOfResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_of_resource`](crate::client::Client::list_tags_of_resource).
///
/// See [`crate::client::fluent_builders::ListTagsOfResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsOfResource {
    _private: (),
}
impl ListTagsOfResource {
    /// Creates a new builder-style object to manufacture [`ListTagsOfResourceInput`](crate::input::ListTagsOfResourceInput)
    pub fn builder() -> crate::input::list_tags_of_resource_input::Builder {
        crate::input::list_tags_of_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsOfResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsOfResource {
    type Output = std::result::Result<
        crate::output::ListTagsOfResourceOutput,
        crate::error::ListTagsOfResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_of_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_of_resource_response(response)
        }
    }
}

/// Operation shape for `PutItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_item`](crate::client::Client::put_item).
///
/// See [`crate::client::fluent_builders::PutItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutItem {
    _private: (),
}
impl PutItem {
    /// Creates a new builder-style object to manufacture [`PutItemInput`](crate::input::PutItemInput)
    pub fn builder() -> crate::input::put_item_input::Builder {
        crate::input::put_item_input::Builder::default()
    }
    /// Creates a new `PutItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutItem {
    type Output = std::result::Result<crate::output::PutItemOutput, crate::error::PutItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_item_error(response)
        } else {
            crate::operation_deser::parse_put_item_response(response)
        }
    }
}

/// Operation shape for `Query`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`query`](crate::client::Client::query).
///
/// See [`crate::client::fluent_builders::Query`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Query {
    _private: (),
}
impl Query {
    /// Creates a new builder-style object to manufacture [`QueryInput`](crate::input::QueryInput)
    pub fn builder() -> crate::input::query_input::Builder {
        crate::input::query_input::Builder::default()
    }
    /// Creates a new `Query` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Query {
    type Output = std::result::Result<crate::output::QueryOutput, crate::error::QueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_query_error(response)
        } else {
            crate::operation_deser::parse_query_response(response)
        }
    }
}

/// Operation shape for `RestoreTableFromBackup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_table_from_backup`](crate::client::Client::restore_table_from_backup).
///
/// See [`crate::client::fluent_builders::RestoreTableFromBackup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreTableFromBackup {
    _private: (),
}
impl RestoreTableFromBackup {
    /// Creates a new builder-style object to manufacture [`RestoreTableFromBackupInput`](crate::input::RestoreTableFromBackupInput)
    pub fn builder() -> crate::input::restore_table_from_backup_input::Builder {
        crate::input::restore_table_from_backup_input::Builder::default()
    }
    /// Creates a new `RestoreTableFromBackup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreTableFromBackup {
    type Output = std::result::Result<
        crate::output::RestoreTableFromBackupOutput,
        crate::error::RestoreTableFromBackupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_table_from_backup_error(response)
        } else {
            crate::operation_deser::parse_restore_table_from_backup_response(response)
        }
    }
}

/// Operation shape for `RestoreTableToPointInTime`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_table_to_point_in_time`](crate::client::Client::restore_table_to_point_in_time).
///
/// See [`crate::client::fluent_builders::RestoreTableToPointInTime`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreTableToPointInTime {
    _private: (),
}
impl RestoreTableToPointInTime {
    /// Creates a new builder-style object to manufacture [`RestoreTableToPointInTimeInput`](crate::input::RestoreTableToPointInTimeInput)
    pub fn builder() -> crate::input::restore_table_to_point_in_time_input::Builder {
        crate::input::restore_table_to_point_in_time_input::Builder::default()
    }
    /// Creates a new `RestoreTableToPointInTime` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreTableToPointInTime {
    type Output = std::result::Result<
        crate::output::RestoreTableToPointInTimeOutput,
        crate::error::RestoreTableToPointInTimeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_table_to_point_in_time_error(response)
        } else {
            crate::operation_deser::parse_restore_table_to_point_in_time_response(response)
        }
    }
}

/// Operation shape for `Scan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`scan`](crate::client::Client::scan).
///
/// See [`crate::client::fluent_builders::Scan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Scan {
    _private: (),
}
impl Scan {
    /// Creates a new builder-style object to manufacture [`ScanInput`](crate::input::ScanInput)
    pub fn builder() -> crate::input::scan_input::Builder {
        crate::input::scan_input::Builder::default()
    }
    /// Creates a new `Scan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Scan {
    type Output = std::result::Result<crate::output::ScanOutput, crate::error::ScanError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_scan_error(response)
        } else {
            crate::operation_deser::parse_scan_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TransactGetItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`transact_get_items`](crate::client::Client::transact_get_items).
///
/// See [`crate::client::fluent_builders::TransactGetItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TransactGetItems {
    _private: (),
}
impl TransactGetItems {
    /// Creates a new builder-style object to manufacture [`TransactGetItemsInput`](crate::input::TransactGetItemsInput)
    pub fn builder() -> crate::input::transact_get_items_input::Builder {
        crate::input::transact_get_items_input::Builder::default()
    }
    /// Creates a new `TransactGetItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TransactGetItems {
    type Output = std::result::Result<
        crate::output::TransactGetItemsOutput,
        crate::error::TransactGetItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_transact_get_items_error(response)
        } else {
            crate::operation_deser::parse_transact_get_items_response(response)
        }
    }
}

/// Operation shape for `TransactWriteItems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`transact_write_items`](crate::client::Client::transact_write_items).
///
/// See [`crate::client::fluent_builders::TransactWriteItems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TransactWriteItems {
    _private: (),
}
impl TransactWriteItems {
    /// Creates a new builder-style object to manufacture [`TransactWriteItemsInput`](crate::input::TransactWriteItemsInput)
    pub fn builder() -> crate::input::transact_write_items_input::Builder {
        crate::input::transact_write_items_input::Builder::default()
    }
    /// Creates a new `TransactWriteItems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TransactWriteItems {
    type Output = std::result::Result<
        crate::output::TransactWriteItemsOutput,
        crate::error::TransactWriteItemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_transact_write_items_error(response)
        } else {
            crate::operation_deser::parse_transact_write_items_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateContinuousBackups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_continuous_backups`](crate::client::Client::update_continuous_backups).
///
/// See [`crate::client::fluent_builders::UpdateContinuousBackups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContinuousBackups {
    _private: (),
}
impl UpdateContinuousBackups {
    /// Creates a new builder-style object to manufacture [`UpdateContinuousBackupsInput`](crate::input::UpdateContinuousBackupsInput)
    pub fn builder() -> crate::input::update_continuous_backups_input::Builder {
        crate::input::update_continuous_backups_input::Builder::default()
    }
    /// Creates a new `UpdateContinuousBackups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContinuousBackups {
    type Output = std::result::Result<
        crate::output::UpdateContinuousBackupsOutput,
        crate::error::UpdateContinuousBackupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_continuous_backups_error(response)
        } else {
            crate::operation_deser::parse_update_continuous_backups_response(response)
        }
    }
}

/// Operation shape for `UpdateContributorInsights`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_contributor_insights`](crate::client::Client::update_contributor_insights).
///
/// See [`crate::client::fluent_builders::UpdateContributorInsights`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContributorInsights {
    _private: (),
}
impl UpdateContributorInsights {
    /// Creates a new builder-style object to manufacture [`UpdateContributorInsightsInput`](crate::input::UpdateContributorInsightsInput)
    pub fn builder() -> crate::input::update_contributor_insights_input::Builder {
        crate::input::update_contributor_insights_input::Builder::default()
    }
    /// Creates a new `UpdateContributorInsights` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContributorInsights {
    type Output = std::result::Result<
        crate::output::UpdateContributorInsightsOutput,
        crate::error::UpdateContributorInsightsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_contributor_insights_error(response)
        } else {
            crate::operation_deser::parse_update_contributor_insights_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_table`](crate::client::Client::update_global_table).
///
/// See [`crate::client::fluent_builders::UpdateGlobalTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalTable {
    _private: (),
}
impl UpdateGlobalTable {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableInput`](crate::input::UpdateGlobalTableInput)
    pub fn builder() -> crate::input::update_global_table_input::Builder {
        crate::input::update_global_table_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalTable {
    type Output = std::result::Result<
        crate::output::UpdateGlobalTableOutput,
        crate::error::UpdateGlobalTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_global_table_error(response)
        } else {
            crate::operation_deser::parse_update_global_table_response(response)
        }
    }
}

/// Operation shape for `UpdateGlobalTableSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_global_table_settings`](crate::client::Client::update_global_table_settings).
///
/// See [`crate::client::fluent_builders::UpdateGlobalTableSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGlobalTableSettings {
    _private: (),
}
impl UpdateGlobalTableSettings {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableSettingsInput`](crate::input::UpdateGlobalTableSettingsInput)
    pub fn builder() -> crate::input::update_global_table_settings_input::Builder {
        crate::input::update_global_table_settings_input::Builder::default()
    }
    /// Creates a new `UpdateGlobalTableSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGlobalTableSettings {
    type Output = std::result::Result<
        crate::output::UpdateGlobalTableSettingsOutput,
        crate::error::UpdateGlobalTableSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_global_table_settings_error(response)
        } else {
            crate::operation_deser::parse_update_global_table_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateItem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_item`](crate::client::Client::update_item).
///
/// See [`crate::client::fluent_builders::UpdateItem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateItem {
    _private: (),
}
impl UpdateItem {
    /// Creates a new builder-style object to manufacture [`UpdateItemInput`](crate::input::UpdateItemInput)
    pub fn builder() -> crate::input::update_item_input::Builder {
        crate::input::update_item_input::Builder::default()
    }
    /// Creates a new `UpdateItem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateItem {
    type Output =
        std::result::Result<crate::output::UpdateItemOutput, crate::error::UpdateItemError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_item_error(response)
        } else {
            crate::operation_deser::parse_update_item_response(response)
        }
    }
}

/// Operation shape for `UpdateTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_table`](crate::client::Client::update_table).
///
/// See [`crate::client::fluent_builders::UpdateTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTable {
    _private: (),
}
impl UpdateTable {
    /// Creates a new builder-style object to manufacture [`UpdateTableInput`](crate::input::UpdateTableInput)
    pub fn builder() -> crate::input::update_table_input::Builder {
        crate::input::update_table_input::Builder::default()
    }
    /// Creates a new `UpdateTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTable {
    type Output =
        std::result::Result<crate::output::UpdateTableOutput, crate::error::UpdateTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_table_error(response)
        } else {
            crate::operation_deser::parse_update_table_response(response)
        }
    }
}

/// Operation shape for `UpdateTableReplicaAutoScaling`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_table_replica_auto_scaling`](crate::client::Client::update_table_replica_auto_scaling).
///
/// See [`crate::client::fluent_builders::UpdateTableReplicaAutoScaling`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTableReplicaAutoScaling {
    _private: (),
}
impl UpdateTableReplicaAutoScaling {
    /// Creates a new builder-style object to manufacture [`UpdateTableReplicaAutoScalingInput`](crate::input::UpdateTableReplicaAutoScalingInput)
    pub fn builder() -> crate::input::update_table_replica_auto_scaling_input::Builder {
        crate::input::update_table_replica_auto_scaling_input::Builder::default()
    }
    /// Creates a new `UpdateTableReplicaAutoScaling` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTableReplicaAutoScaling {
    type Output = std::result::Result<
        crate::output::UpdateTableReplicaAutoScalingOutput,
        crate::error::UpdateTableReplicaAutoScalingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_table_replica_auto_scaling_error(response)
        } else {
            crate::operation_deser::parse_update_table_replica_auto_scaling_response(response)
        }
    }
}

/// Operation shape for `UpdateTimeToLive`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_time_to_live`](crate::client::Client::update_time_to_live).
///
/// See [`crate::client::fluent_builders::UpdateTimeToLive`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTimeToLive {
    _private: (),
}
impl UpdateTimeToLive {
    /// Creates a new builder-style object to manufacture [`UpdateTimeToLiveInput`](crate::input::UpdateTimeToLiveInput)
    pub fn builder() -> crate::input::update_time_to_live_input::Builder {
        crate::input::update_time_to_live_input::Builder::default()
    }
    /// Creates a new `UpdateTimeToLive` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTimeToLive {
    type Output = std::result::Result<
        crate::output::UpdateTimeToLiveOutput,
        crate::error::UpdateTimeToLiveError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_time_to_live_error(response)
        } else {
            crate::operation_deser::parse_update_time_to_live_response(response)
        }
    }
}
