// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the settings used to enable or disable Time to Live (TTL) for the specified table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeToLiveSpecification {
    /// <p>Indicates whether TTL is to be enabled (true) or disabled (false) on the table.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The name of the TTL attribute used to store the expiration time for items in the table.</p>
    pub attribute_name: std::option::Option<std::string::String>,
}
impl TimeToLiveSpecification {
    /// <p>Indicates whether TTL is to be enabled (true) or disabled (false) on the table.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The name of the TTL attribute used to store the expiration time for items in the table.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
}
impl std::fmt::Debug for TimeToLiveSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeToLiveSpecification");
        formatter.field("enabled", &self.enabled);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.finish()
    }
}
/// See [`TimeToLiveSpecification`](crate::model::TimeToLiveSpecification)
pub mod time_to_live_specification {
    /// A builder for [`TimeToLiveSpecification`](crate::model::TimeToLiveSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether TTL is to be enabled (true) or disabled (false) on the table.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether TTL is to be enabled (true) or disabled (false) on the table.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The name of the TTL attribute used to store the expiration time for items in the table.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the TTL attribute used to store the expiration time for items in the table.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeToLiveSpecification`](crate::model::TimeToLiveSpecification)
        pub fn build(self) -> crate::model::TimeToLiveSpecification {
            crate::model::TimeToLiveSpecification {
                enabled: self.enabled,
                attribute_name: self.attribute_name,
            }
        }
    }
}
impl TimeToLiveSpecification {
    /// Creates a new builder-style object to manufacture [`TimeToLiveSpecification`](crate::model::TimeToLiveSpecification)
    pub fn builder() -> crate::model::time_to_live_specification::Builder {
        crate::model::time_to_live_specification::Builder::default()
    }
}

/// <p>Represents the auto scaling configuration for a global table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableAutoScalingDescription {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The current state of the table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
    /// </ul>
    pub table_status: std::option::Option<crate::model::TableStatus>,
    /// <p>Represents replicas of the global table.</p>
    pub replicas: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingDescription>>,
}
impl TableAutoScalingDescription {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The current state of the table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
    /// </ul>
    pub fn table_status(&self) -> std::option::Option<&crate::model::TableStatus> {
        self.table_status.as_ref()
    }
    /// <p>Represents replicas of the global table.</p>
    pub fn replicas(&self) -> std::option::Option<&[crate::model::ReplicaAutoScalingDescription]> {
        self.replicas.as_deref()
    }
}
impl std::fmt::Debug for TableAutoScalingDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableAutoScalingDescription");
        formatter.field("table_name", &self.table_name);
        formatter.field("table_status", &self.table_status);
        formatter.field("replicas", &self.replicas);
        formatter.finish()
    }
}
/// See [`TableAutoScalingDescription`](crate::model::TableAutoScalingDescription)
pub mod table_auto_scaling_description {
    /// A builder for [`TableAutoScalingDescription`](crate::model::TableAutoScalingDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) table_status: std::option::Option<crate::model::TableStatus>,
        pub(crate) replicas:
            std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingDescription>>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The current state of the table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
        /// </ul>
        pub fn table_status(mut self, input: crate::model::TableStatus) -> Self {
            self.table_status = Some(input);
            self
        }
        /// <p>The current state of the table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
        /// </ul>
        pub fn set_table_status(
            mut self,
            input: std::option::Option<crate::model::TableStatus>,
        ) -> Self {
            self.table_status = input;
            self
        }
        /// Appends an item to `replicas`.
        ///
        /// To override the contents of this collection use [`set_replicas`](Self::set_replicas).
        ///
        /// <p>Represents replicas of the global table.</p>
        pub fn replicas(mut self, input: crate::model::ReplicaAutoScalingDescription) -> Self {
            let mut v = self.replicas.unwrap_or_default();
            v.push(input);
            self.replicas = Some(v);
            self
        }
        /// <p>Represents replicas of the global table.</p>
        pub fn set_replicas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingDescription>>,
        ) -> Self {
            self.replicas = input;
            self
        }
        /// Consumes the builder and constructs a [`TableAutoScalingDescription`](crate::model::TableAutoScalingDescription)
        pub fn build(self) -> crate::model::TableAutoScalingDescription {
            crate::model::TableAutoScalingDescription {
                table_name: self.table_name,
                table_status: self.table_status,
                replicas: self.replicas,
            }
        }
    }
}
impl TableAutoScalingDescription {
    /// Creates a new builder-style object to manufacture [`TableAutoScalingDescription`](crate::model::TableAutoScalingDescription)
    pub fn builder() -> crate::model::table_auto_scaling_description::Builder {
        crate::model::table_auto_scaling_description::Builder::default()
    }
}

/// <p>Represents the auto scaling settings of the replica.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaAutoScalingDescription {
    /// <p>The Region where the replica exists.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>Replica-specific global secondary index auto scaling settings.</p>
    pub global_secondary_indexes: std::option::Option<
        std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription>,
    >,
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub replica_provisioned_read_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub replica_provisioned_write_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>The current state of the replica:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
    /// </ul>
    pub replica_status: std::option::Option<crate::model::ReplicaStatus>,
}
impl ReplicaAutoScalingDescription {
    /// <p>The Region where the replica exists.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>Replica-specific global secondary index auto scaling settings.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription]>
    {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub fn replica_provisioned_read_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.replica_provisioned_read_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub fn replica_provisioned_write_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.replica_provisioned_write_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>The current state of the replica:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
    /// </ul>
    pub fn replica_status(&self) -> std::option::Option<&crate::model::ReplicaStatus> {
        self.replica_status.as_ref()
    }
}
impl std::fmt::Debug for ReplicaAutoScalingDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaAutoScalingDescription");
        formatter.field("region_name", &self.region_name);
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field(
            "replica_provisioned_read_capacity_auto_scaling_settings",
            &self.replica_provisioned_read_capacity_auto_scaling_settings,
        );
        formatter.field(
            "replica_provisioned_write_capacity_auto_scaling_settings",
            &self.replica_provisioned_write_capacity_auto_scaling_settings,
        );
        formatter.field("replica_status", &self.replica_status);
        formatter.finish()
    }
}
/// See [`ReplicaAutoScalingDescription`](crate::model::ReplicaAutoScalingDescription)
pub mod replica_auto_scaling_description {
    /// A builder for [`ReplicaAutoScalingDescription`](crate::model::ReplicaAutoScalingDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) global_secondary_indexes: std::option::Option<
            std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription>,
        >,
        pub(crate) replica_provisioned_read_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) replica_provisioned_write_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) replica_status: std::option::Option<crate::model::ReplicaStatus>,
    }
    impl Builder {
        /// <p>The Region where the replica exists.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the replica exists.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>Replica-specific global secondary index auto scaling settings.</p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>Replica-specific global secondary index auto scaling settings.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription>,
            >,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn replica_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn set_replica_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings = input;
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn replica_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.replica_provisioned_write_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn set_replica_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.replica_provisioned_write_capacity_auto_scaling_settings = input;
            self
        }
        /// <p>The current state of the replica:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
        /// </ul>
        pub fn replica_status(mut self, input: crate::model::ReplicaStatus) -> Self {
            self.replica_status = Some(input);
            self
        }
        /// <p>The current state of the replica:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
        /// </ul>
        pub fn set_replica_status(
            mut self,
            input: std::option::Option<crate::model::ReplicaStatus>,
        ) -> Self {
            self.replica_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaAutoScalingDescription`](crate::model::ReplicaAutoScalingDescription)
        pub fn build(self) -> crate::model::ReplicaAutoScalingDescription {
            crate::model::ReplicaAutoScalingDescription {
                region_name: self.region_name,
                global_secondary_indexes: self.global_secondary_indexes,
                replica_provisioned_read_capacity_auto_scaling_settings: self
                    .replica_provisioned_read_capacity_auto_scaling_settings,
                replica_provisioned_write_capacity_auto_scaling_settings: self
                    .replica_provisioned_write_capacity_auto_scaling_settings,
                replica_status: self.replica_status,
            }
        }
    }
}
impl ReplicaAutoScalingDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaAutoScalingDescription`](crate::model::ReplicaAutoScalingDescription)
    pub fn builder() -> crate::model::replica_auto_scaling_description::Builder {
        crate::model::replica_auto_scaling_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicaStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    CreationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InaccessibleEncryptionCredentials,
    #[allow(missing_docs)] // documentation missing in model
    RegionDisabled,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicaStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReplicaStatus::Active,
            "CREATING" => ReplicaStatus::Creating,
            "CREATION_FAILED" => ReplicaStatus::CreationFailed,
            "DELETING" => ReplicaStatus::Deleting,
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS" => {
                ReplicaStatus::InaccessibleEncryptionCredentials
            }
            "REGION_DISABLED" => ReplicaStatus::RegionDisabled,
            "UPDATING" => ReplicaStatus::Updating,
            other => ReplicaStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicaStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicaStatus::from(s))
    }
}
impl ReplicaStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicaStatus::Active => "ACTIVE",
            ReplicaStatus::Creating => "CREATING",
            ReplicaStatus::CreationFailed => "CREATION_FAILED",
            ReplicaStatus::Deleting => "DELETING",
            ReplicaStatus::InaccessibleEncryptionCredentials => {
                "INACCESSIBLE_ENCRYPTION_CREDENTIALS"
            }
            ReplicaStatus::RegionDisabled => "REGION_DISABLED",
            ReplicaStatus::Updating => "UPDATING",
            ReplicaStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATION_FAILED",
            "DELETING",
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
            "REGION_DISABLED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ReplicaStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingSettingsDescription {
    /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
    pub minimum_units: std::option::Option<i64>,
    /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
    pub maximum_units: std::option::Option<i64>,
    /// <p>Disabled auto scaling for this global table or global secondary index.</p>
    pub auto_scaling_disabled: std::option::Option<bool>,
    /// <p>Role ARN used for configuring the auto scaling policy.</p>
    pub auto_scaling_role_arn: std::option::Option<std::string::String>,
    /// <p>Information about the scaling policies.</p>
    pub scaling_policies:
        std::option::Option<std::vec::Vec<crate::model::AutoScalingPolicyDescription>>,
}
impl AutoScalingSettingsDescription {
    /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
    pub fn minimum_units(&self) -> std::option::Option<i64> {
        self.minimum_units
    }
    /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
    pub fn maximum_units(&self) -> std::option::Option<i64> {
        self.maximum_units
    }
    /// <p>Disabled auto scaling for this global table or global secondary index.</p>
    pub fn auto_scaling_disabled(&self) -> std::option::Option<bool> {
        self.auto_scaling_disabled
    }
    /// <p>Role ARN used for configuring the auto scaling policy.</p>
    pub fn auto_scaling_role_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_role_arn.as_deref()
    }
    /// <p>Information about the scaling policies.</p>
    pub fn scaling_policies(
        &self,
    ) -> std::option::Option<&[crate::model::AutoScalingPolicyDescription]> {
        self.scaling_policies.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingSettingsDescription");
        formatter.field("minimum_units", &self.minimum_units);
        formatter.field("maximum_units", &self.maximum_units);
        formatter.field("auto_scaling_disabled", &self.auto_scaling_disabled);
        formatter.field("auto_scaling_role_arn", &self.auto_scaling_role_arn);
        formatter.field("scaling_policies", &self.scaling_policies);
        formatter.finish()
    }
}
/// See [`AutoScalingSettingsDescription`](crate::model::AutoScalingSettingsDescription)
pub mod auto_scaling_settings_description {
    /// A builder for [`AutoScalingSettingsDescription`](crate::model::AutoScalingSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_units: std::option::Option<i64>,
        pub(crate) maximum_units: std::option::Option<i64>,
        pub(crate) auto_scaling_disabled: std::option::Option<bool>,
        pub(crate) auto_scaling_role_arn: std::option::Option<std::string::String>,
        pub(crate) scaling_policies:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingPolicyDescription>>,
    }
    impl Builder {
        /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
        pub fn minimum_units(mut self, input: i64) -> Self {
            self.minimum_units = Some(input);
            self
        }
        /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
        pub fn set_minimum_units(mut self, input: std::option::Option<i64>) -> Self {
            self.minimum_units = input;
            self
        }
        /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
        pub fn maximum_units(mut self, input: i64) -> Self {
            self.maximum_units = Some(input);
            self
        }
        /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
        pub fn set_maximum_units(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_units = input;
            self
        }
        /// <p>Disabled auto scaling for this global table or global secondary index.</p>
        pub fn auto_scaling_disabled(mut self, input: bool) -> Self {
            self.auto_scaling_disabled = Some(input);
            self
        }
        /// <p>Disabled auto scaling for this global table or global secondary index.</p>
        pub fn set_auto_scaling_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_scaling_disabled = input;
            self
        }
        /// <p>Role ARN used for configuring the auto scaling policy.</p>
        pub fn auto_scaling_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_role_arn = Some(input.into());
            self
        }
        /// <p>Role ARN used for configuring the auto scaling policy.</p>
        pub fn set_auto_scaling_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_role_arn = input;
            self
        }
        /// Appends an item to `scaling_policies`.
        ///
        /// To override the contents of this collection use [`set_scaling_policies`](Self::set_scaling_policies).
        ///
        /// <p>Information about the scaling policies.</p>
        pub fn scaling_policies(
            mut self,
            input: crate::model::AutoScalingPolicyDescription,
        ) -> Self {
            let mut v = self.scaling_policies.unwrap_or_default();
            v.push(input);
            self.scaling_policies = Some(v);
            self
        }
        /// <p>Information about the scaling policies.</p>
        pub fn set_scaling_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingPolicyDescription>>,
        ) -> Self {
            self.scaling_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingSettingsDescription`](crate::model::AutoScalingSettingsDescription)
        pub fn build(self) -> crate::model::AutoScalingSettingsDescription {
            crate::model::AutoScalingSettingsDescription {
                minimum_units: self.minimum_units,
                maximum_units: self.maximum_units,
                auto_scaling_disabled: self.auto_scaling_disabled,
                auto_scaling_role_arn: self.auto_scaling_role_arn,
                scaling_policies: self.scaling_policies,
            }
        }
    }
}
impl AutoScalingSettingsDescription {
    /// Creates a new builder-style object to manufacture [`AutoScalingSettingsDescription`](crate::model::AutoScalingSettingsDescription)
    pub fn builder() -> crate::model::auto_scaling_settings_description::Builder {
        crate::model::auto_scaling_settings_description::Builder::default()
    }
}

/// <p>Represents the properties of the scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicyDescription {
    /// <p>The name of the scaling policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>Represents a target tracking scaling policy configuration.</p>
    pub target_tracking_scaling_policy_configuration: std::option::Option<
        crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription,
    >,
}
impl AutoScalingPolicyDescription {
    /// <p>The name of the scaling policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>Represents a target tracking scaling policy configuration.</p>
    pub fn target_tracking_scaling_policy_configuration(
        &self,
    ) -> std::option::Option<
        &crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription,
    > {
        self.target_tracking_scaling_policy_configuration.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingPolicyDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicyDescription");
        formatter.field("policy_name", &self.policy_name);
        formatter.field(
            "target_tracking_scaling_policy_configuration",
            &self.target_tracking_scaling_policy_configuration,
        );
        formatter.finish()
    }
}
/// See [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
pub mod auto_scaling_policy_description {
    /// A builder for [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) target_tracking_scaling_policy_configuration: std::option::Option<
            crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription,
        >,
    }
    impl Builder {
        /// <p>The name of the scaling policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>Represents a target tracking scaling policy configuration.</p>
        pub fn target_tracking_scaling_policy_configuration(
            mut self,
            input: crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = Some(input);
            self
        }
        /// <p>Represents a target tracking scaling policy configuration.</p>
        pub fn set_target_tracking_scaling_policy_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription,
            >,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
        pub fn build(self) -> crate::model::AutoScalingPolicyDescription {
            crate::model::AutoScalingPolicyDescription {
                policy_name: self.policy_name,
                target_tracking_scaling_policy_configuration: self
                    .target_tracking_scaling_policy_configuration,
            }
        }
    }
}
impl AutoScalingPolicyDescription {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicyDescription`](crate::model::AutoScalingPolicyDescription)
    pub fn builder() -> crate::model::auto_scaling_policy_description::Builder {
        crate::model::auto_scaling_policy_description::Builder::default()
    }
}

/// <p>Represents the properties of a target tracking scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
    /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
    pub disable_scale_in: std::option::Option<bool>,
    /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
    pub scale_in_cooldown: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
    pub scale_out_cooldown: std::option::Option<i32>,
    /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
    pub target_value: std::option::Option<f64>,
}
impl AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
    /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
    pub fn disable_scale_in(&self) -> std::option::Option<bool> {
        self.disable_scale_in
    }
    /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
    pub fn scale_in_cooldown(&self) -> std::option::Option<i32> {
        self.scale_in_cooldown
    }
    /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
    pub fn scale_out_cooldown(&self) -> std::option::Option<i32> {
        self.scale_out_cooldown
    }
    /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
}
impl std::fmt::Debug for AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AutoScalingTargetTrackingScalingPolicyConfigurationDescription");
        formatter.field("disable_scale_in", &self.disable_scale_in);
        formatter.field("scale_in_cooldown", &self.scale_in_cooldown);
        formatter.field("scale_out_cooldown", &self.scale_out_cooldown);
        formatter.field("target_value", &self.target_value);
        formatter.finish()
    }
}
/// See [`AutoScalingTargetTrackingScalingPolicyConfigurationDescription`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription)
pub mod auto_scaling_target_tracking_scaling_policy_configuration_description {
    /// A builder for [`AutoScalingTargetTrackingScalingPolicyConfigurationDescription`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_scale_in: std::option::Option<bool>,
        pub(crate) scale_in_cooldown: std::option::Option<i32>,
        pub(crate) scale_out_cooldown: std::option::Option<i32>,
        pub(crate) target_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
        pub fn disable_scale_in(mut self, input: bool) -> Self {
            self.disable_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
        pub fn set_disable_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_scale_in = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
        pub fn scale_in_cooldown(mut self, input: i32) -> Self {
            self.scale_in_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
        pub fn set_scale_in_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_in_cooldown = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
        pub fn scale_out_cooldown(mut self, input: i32) -> Self {
            self.scale_out_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
        pub fn set_scale_out_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_out_cooldown = input;
            self
        }
        /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingTargetTrackingScalingPolicyConfigurationDescription`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription)
        pub fn build(
            self,
        ) -> crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
            crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
                disable_scale_in: self.disable_scale_in,
                scale_in_cooldown: self.scale_in_cooldown,
                scale_out_cooldown: self.scale_out_cooldown,
                target_value: self.target_value,
            }
        }
    }
}
impl AutoScalingTargetTrackingScalingPolicyConfigurationDescription {
    /// Creates a new builder-style object to manufacture [`AutoScalingTargetTrackingScalingPolicyConfigurationDescription`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationDescription)
    pub fn builder(
    ) -> crate::model::auto_scaling_target_tracking_scaling_policy_configuration_description::Builder
    {
        crate::model::auto_scaling_target_tracking_scaling_policy_configuration_description::Builder::default()
    }
}

/// <p>Represents the auto scaling configuration for a replica global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndexAutoScalingDescription {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The current state of the replica global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul>
    pub index_status: std::option::Option<crate::model::IndexStatus>,
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub provisioned_read_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub provisioned_write_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
}
impl ReplicaGlobalSecondaryIndexAutoScalingDescription {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The current state of the replica global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul>
    pub fn index_status(&self) -> std::option::Option<&crate::model::IndexStatus> {
        self.index_status.as_ref()
    }
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub fn provisioned_read_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.provisioned_read_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
    pub fn provisioned_write_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.provisioned_write_capacity_auto_scaling_settings
            .as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndexAutoScalingDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndexAutoScalingDescription");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_status", &self.index_status);
        formatter.field(
            "provisioned_read_capacity_auto_scaling_settings",
            &self.provisioned_read_capacity_auto_scaling_settings,
        );
        formatter.field(
            "provisioned_write_capacity_auto_scaling_settings",
            &self.provisioned_write_capacity_auto_scaling_settings,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndexAutoScalingDescription`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription)
pub mod replica_global_secondary_index_auto_scaling_description {
    /// A builder for [`ReplicaGlobalSecondaryIndexAutoScalingDescription`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_status: std::option::Option<crate::model::IndexStatus>,
        pub(crate) provisioned_read_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) provisioned_write_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The current state of the replica global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul>
        pub fn index_status(mut self, input: crate::model::IndexStatus) -> Self {
            self.index_status = Some(input);
            self
        }
        /// <p>The current state of the replica global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul>
        pub fn set_index_status(
            mut self,
            input: std::option::Option<crate::model::IndexStatus>,
        ) -> Self {
            self.index_status = input;
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn set_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings = input;
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings for a global table or global secondary index.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndexAutoScalingDescription`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription {
            crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription {
                index_name: self.index_name,
                index_status: self.index_status,
                provisioned_read_capacity_auto_scaling_settings: self
                    .provisioned_read_capacity_auto_scaling_settings,
                provisioned_write_capacity_auto_scaling_settings: self
                    .provisioned_write_capacity_auto_scaling_settings,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndexAutoScalingDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndexAutoScalingDescription`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingDescription)
    pub fn builder(
    ) -> crate::model::replica_global_secondary_index_auto_scaling_description::Builder {
        crate::model::replica_global_secondary_index_auto_scaling_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IndexStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IndexStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => IndexStatus::Active,
            "CREATING" => IndexStatus::Creating,
            "DELETING" => IndexStatus::Deleting,
            "UPDATING" => IndexStatus::Updating,
            other => IndexStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IndexStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IndexStatus::from(s))
    }
}
impl IndexStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IndexStatus::Active => "ACTIVE",
            IndexStatus::Creating => "CREATING",
            IndexStatus::Deleting => "DELETING",
            IndexStatus::Updating => "UPDATING",
            IndexStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for IndexStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TableStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    #[allow(missing_docs)] // documentation missing in model
    Archiving,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InaccessibleEncryptionCredentials,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TableStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => TableStatus::Active,
            "ARCHIVED" => TableStatus::Archived,
            "ARCHIVING" => TableStatus::Archiving,
            "CREATING" => TableStatus::Creating,
            "DELETING" => TableStatus::Deleting,
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS" => TableStatus::InaccessibleEncryptionCredentials,
            "UPDATING" => TableStatus::Updating,
            other => TableStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TableStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TableStatus::from(s))
    }
}
impl TableStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TableStatus::Active => "ACTIVE",
            TableStatus::Archived => "ARCHIVED",
            TableStatus::Archiving => "ARCHIVING",
            TableStatus::Creating => "CREATING",
            TableStatus::Deleting => "DELETING",
            TableStatus::InaccessibleEncryptionCredentials => "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
            TableStatus::Updating => "UPDATING",
            TableStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "ARCHIVED",
            "ARCHIVING",
            "CREATING",
            "DELETING",
            "INACCESSIBLE_ENCRYPTION_CREDENTIALS",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for TableStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the auto scaling settings of a replica that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaAutoScalingUpdate {
    /// <p>The Region where the replica exists.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>Represents the auto scaling settings of global secondary indexes that will be modified.</p>
    pub replica_global_secondary_index_updates: std::option::Option<
        std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate>,
    >,
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub replica_provisioned_read_capacity_auto_scaling_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
}
impl ReplicaAutoScalingUpdate {
    /// <p>The Region where the replica exists.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>Represents the auto scaling settings of global secondary indexes that will be modified.</p>
    pub fn replica_global_secondary_index_updates(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate]> {
        self.replica_global_secondary_index_updates.as_deref()
    }
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub fn replica_provisioned_read_capacity_auto_scaling_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.replica_provisioned_read_capacity_auto_scaling_update
            .as_ref()
    }
}
impl std::fmt::Debug for ReplicaAutoScalingUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaAutoScalingUpdate");
        formatter.field("region_name", &self.region_name);
        formatter.field(
            "replica_global_secondary_index_updates",
            &self.replica_global_secondary_index_updates,
        );
        formatter.field(
            "replica_provisioned_read_capacity_auto_scaling_update",
            &self.replica_provisioned_read_capacity_auto_scaling_update,
        );
        formatter.finish()
    }
}
/// See [`ReplicaAutoScalingUpdate`](crate::model::ReplicaAutoScalingUpdate)
pub mod replica_auto_scaling_update {
    /// A builder for [`ReplicaAutoScalingUpdate`](crate::model::ReplicaAutoScalingUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) replica_global_secondary_index_updates: std::option::Option<
            std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate>,
        >,
        pub(crate) replica_provisioned_read_capacity_auto_scaling_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    }
    impl Builder {
        /// <p>The Region where the replica exists.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the replica exists.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Appends an item to `replica_global_secondary_index_updates`.
        ///
        /// To override the contents of this collection use [`set_replica_global_secondary_index_updates`](Self::set_replica_global_secondary_index_updates).
        ///
        /// <p>Represents the auto scaling settings of global secondary indexes that will be modified.</p>
        pub fn replica_global_secondary_index_updates(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate,
        ) -> Self {
            let mut v = self
                .replica_global_secondary_index_updates
                .unwrap_or_default();
            v.push(input);
            self.replica_global_secondary_index_updates = Some(v);
            self
        }
        /// <p>Represents the auto scaling settings of global secondary indexes that will be modified.</p>
        pub fn set_replica_global_secondary_index_updates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate>,
            >,
        ) -> Self {
            self.replica_global_secondary_index_updates = input;
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn replica_provisioned_read_capacity_auto_scaling_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_update = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn set_replica_provisioned_read_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_update = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaAutoScalingUpdate`](crate::model::ReplicaAutoScalingUpdate)
        pub fn build(self) -> crate::model::ReplicaAutoScalingUpdate {
            crate::model::ReplicaAutoScalingUpdate {
                region_name: self.region_name,
                replica_global_secondary_index_updates: self.replica_global_secondary_index_updates,
                replica_provisioned_read_capacity_auto_scaling_update: self
                    .replica_provisioned_read_capacity_auto_scaling_update,
            }
        }
    }
}
impl ReplicaAutoScalingUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicaAutoScalingUpdate`](crate::model::ReplicaAutoScalingUpdate)
    pub fn builder() -> crate::model::replica_auto_scaling_update::Builder {
        crate::model::replica_auto_scaling_update::Builder::default()
    }
}

/// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingSettingsUpdate {
    /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
    pub minimum_units: std::option::Option<i64>,
    /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
    pub maximum_units: std::option::Option<i64>,
    /// <p>Disabled auto scaling for this global table or global secondary index.</p>
    pub auto_scaling_disabled: std::option::Option<bool>,
    /// <p>Role ARN used for configuring auto scaling policy.</p>
    pub auto_scaling_role_arn: std::option::Option<std::string::String>,
    /// <p>The scaling policy to apply for scaling target global table or global secondary index capacity units.</p>
    pub scaling_policy_update: std::option::Option<crate::model::AutoScalingPolicyUpdate>,
}
impl AutoScalingSettingsUpdate {
    /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
    pub fn minimum_units(&self) -> std::option::Option<i64> {
        self.minimum_units
    }
    /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
    pub fn maximum_units(&self) -> std::option::Option<i64> {
        self.maximum_units
    }
    /// <p>Disabled auto scaling for this global table or global secondary index.</p>
    pub fn auto_scaling_disabled(&self) -> std::option::Option<bool> {
        self.auto_scaling_disabled
    }
    /// <p>Role ARN used for configuring auto scaling policy.</p>
    pub fn auto_scaling_role_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_role_arn.as_deref()
    }
    /// <p>The scaling policy to apply for scaling target global table or global secondary index capacity units.</p>
    pub fn scaling_policy_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingPolicyUpdate> {
        self.scaling_policy_update.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingSettingsUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingSettingsUpdate");
        formatter.field("minimum_units", &self.minimum_units);
        formatter.field("maximum_units", &self.maximum_units);
        formatter.field("auto_scaling_disabled", &self.auto_scaling_disabled);
        formatter.field("auto_scaling_role_arn", &self.auto_scaling_role_arn);
        formatter.field("scaling_policy_update", &self.scaling_policy_update);
        formatter.finish()
    }
}
/// See [`AutoScalingSettingsUpdate`](crate::model::AutoScalingSettingsUpdate)
pub mod auto_scaling_settings_update {
    /// A builder for [`AutoScalingSettingsUpdate`](crate::model::AutoScalingSettingsUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_units: std::option::Option<i64>,
        pub(crate) maximum_units: std::option::Option<i64>,
        pub(crate) auto_scaling_disabled: std::option::Option<bool>,
        pub(crate) auto_scaling_role_arn: std::option::Option<std::string::String>,
        pub(crate) scaling_policy_update:
            std::option::Option<crate::model::AutoScalingPolicyUpdate>,
    }
    impl Builder {
        /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
        pub fn minimum_units(mut self, input: i64) -> Self {
            self.minimum_units = Some(input);
            self
        }
        /// <p>The minimum capacity units that a global table or global secondary index should be scaled down to.</p>
        pub fn set_minimum_units(mut self, input: std::option::Option<i64>) -> Self {
            self.minimum_units = input;
            self
        }
        /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
        pub fn maximum_units(mut self, input: i64) -> Self {
            self.maximum_units = Some(input);
            self
        }
        /// <p>The maximum capacity units that a global table or global secondary index should be scaled up to.</p>
        pub fn set_maximum_units(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_units = input;
            self
        }
        /// <p>Disabled auto scaling for this global table or global secondary index.</p>
        pub fn auto_scaling_disabled(mut self, input: bool) -> Self {
            self.auto_scaling_disabled = Some(input);
            self
        }
        /// <p>Disabled auto scaling for this global table or global secondary index.</p>
        pub fn set_auto_scaling_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_scaling_disabled = input;
            self
        }
        /// <p>Role ARN used for configuring auto scaling policy.</p>
        pub fn auto_scaling_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_role_arn = Some(input.into());
            self
        }
        /// <p>Role ARN used for configuring auto scaling policy.</p>
        pub fn set_auto_scaling_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_role_arn = input;
            self
        }
        /// <p>The scaling policy to apply for scaling target global table or global secondary index capacity units.</p>
        pub fn scaling_policy_update(
            mut self,
            input: crate::model::AutoScalingPolicyUpdate,
        ) -> Self {
            self.scaling_policy_update = Some(input);
            self
        }
        /// <p>The scaling policy to apply for scaling target global table or global secondary index capacity units.</p>
        pub fn set_scaling_policy_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingPolicyUpdate>,
        ) -> Self {
            self.scaling_policy_update = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingSettingsUpdate`](crate::model::AutoScalingSettingsUpdate)
        pub fn build(self) -> crate::model::AutoScalingSettingsUpdate {
            crate::model::AutoScalingSettingsUpdate {
                minimum_units: self.minimum_units,
                maximum_units: self.maximum_units,
                auto_scaling_disabled: self.auto_scaling_disabled,
                auto_scaling_role_arn: self.auto_scaling_role_arn,
                scaling_policy_update: self.scaling_policy_update,
            }
        }
    }
}
impl AutoScalingSettingsUpdate {
    /// Creates a new builder-style object to manufacture [`AutoScalingSettingsUpdate`](crate::model::AutoScalingSettingsUpdate)
    pub fn builder() -> crate::model::auto_scaling_settings_update::Builder {
        crate::model::auto_scaling_settings_update::Builder::default()
    }
}

/// <p>Represents the auto scaling policy to be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingPolicyUpdate {
    /// <p>The name of the scaling policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>Represents a target tracking scaling policy configuration.</p>
    pub target_tracking_scaling_policy_configuration: std::option::Option<
        crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate,
    >,
}
impl AutoScalingPolicyUpdate {
    /// <p>The name of the scaling policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>Represents a target tracking scaling policy configuration.</p>
    pub fn target_tracking_scaling_policy_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate>
    {
        self.target_tracking_scaling_policy_configuration.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingPolicyUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingPolicyUpdate");
        formatter.field("policy_name", &self.policy_name);
        formatter.field(
            "target_tracking_scaling_policy_configuration",
            &self.target_tracking_scaling_policy_configuration,
        );
        formatter.finish()
    }
}
/// See [`AutoScalingPolicyUpdate`](crate::model::AutoScalingPolicyUpdate)
pub mod auto_scaling_policy_update {
    /// A builder for [`AutoScalingPolicyUpdate`](crate::model::AutoScalingPolicyUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) target_tracking_scaling_policy_configuration: std::option::Option<
            crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate,
        >,
    }
    impl Builder {
        /// <p>The name of the scaling policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>Represents a target tracking scaling policy configuration.</p>
        pub fn target_tracking_scaling_policy_configuration(
            mut self,
            input: crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = Some(input);
            self
        }
        /// <p>Represents a target tracking scaling policy configuration.</p>
        pub fn set_target_tracking_scaling_policy_configuration(
            mut self,
            input: std::option::Option<
                crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate,
            >,
        ) -> Self {
            self.target_tracking_scaling_policy_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingPolicyUpdate`](crate::model::AutoScalingPolicyUpdate)
        pub fn build(self) -> crate::model::AutoScalingPolicyUpdate {
            crate::model::AutoScalingPolicyUpdate {
                policy_name: self.policy_name,
                target_tracking_scaling_policy_configuration: self
                    .target_tracking_scaling_policy_configuration,
            }
        }
    }
}
impl AutoScalingPolicyUpdate {
    /// Creates a new builder-style object to manufacture [`AutoScalingPolicyUpdate`](crate::model::AutoScalingPolicyUpdate)
    pub fn builder() -> crate::model::auto_scaling_policy_update::Builder {
        crate::model::auto_scaling_policy_update::Builder::default()
    }
}

/// <p>Represents the settings of a target tracking scaling policy that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
    /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
    pub disable_scale_in: std::option::Option<bool>,
    /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
    pub scale_in_cooldown: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
    pub scale_out_cooldown: std::option::Option<i32>,
    /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
    pub target_value: std::option::Option<f64>,
}
impl AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
    /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
    pub fn disable_scale_in(&self) -> std::option::Option<bool> {
        self.disable_scale_in
    }
    /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
    pub fn scale_in_cooldown(&self) -> std::option::Option<i32> {
        self.scale_in_cooldown
    }
    /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
    pub fn scale_out_cooldown(&self) -> std::option::Option<i32> {
        self.scale_out_cooldown
    }
    /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
}
impl std::fmt::Debug for AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("AutoScalingTargetTrackingScalingPolicyConfigurationUpdate");
        formatter.field("disable_scale_in", &self.disable_scale_in);
        formatter.field("scale_in_cooldown", &self.scale_in_cooldown);
        formatter.field("scale_out_cooldown", &self.scale_out_cooldown);
        formatter.field("target_value", &self.target_value);
        formatter.finish()
    }
}
/// See [`AutoScalingTargetTrackingScalingPolicyConfigurationUpdate`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)
pub mod auto_scaling_target_tracking_scaling_policy_configuration_update {
    /// A builder for [`AutoScalingTargetTrackingScalingPolicyConfigurationUpdate`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disable_scale_in: std::option::Option<bool>,
        pub(crate) scale_in_cooldown: std::option::Option<i32>,
        pub(crate) scale_out_cooldown: std::option::Option<i32>,
        pub(crate) target_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
        pub fn disable_scale_in(mut self, input: bool) -> Self {
            self.disable_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The default value is false.</p>
        pub fn set_disable_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_scale_in = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
        pub fn scale_in_cooldown(mut self, input: i32) -> Self {
            self.scale_in_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale in activity completes before another scale in activity can start. The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in conservatively to protect your application's availability. However, if another alarm triggers a scale out policy during the cooldown period after a scale-in, application auto scaling scales out your scalable target immediately. </p>
        pub fn set_scale_in_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_in_cooldown = input;
            self
        }
        /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
        pub fn scale_out_cooldown(mut self, input: i32) -> Self {
            self.scale_out_cooldown = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, after a scale out activity completes before another scale out activity can start. While the cooldown period is in effect, the capacity that has been added by the previous scale out event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should continuously (but not excessively) scale out.</p>
        pub fn set_scale_out_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.scale_out_cooldown = input;
            self
        }
        /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingTargetTrackingScalingPolicyConfigurationUpdate`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)
        pub fn build(
            self,
        ) -> crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
            crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
                disable_scale_in: self.disable_scale_in,
                scale_in_cooldown: self.scale_in_cooldown,
                scale_out_cooldown: self.scale_out_cooldown,
                target_value: self.target_value,
            }
        }
    }
}
impl AutoScalingTargetTrackingScalingPolicyConfigurationUpdate {
    /// Creates a new builder-style object to manufacture [`AutoScalingTargetTrackingScalingPolicyConfigurationUpdate`](crate::model::AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)
    pub fn builder(
    ) -> crate::model::auto_scaling_target_tracking_scaling_policy_configuration_update::Builder
    {
        crate::model::auto_scaling_target_tracking_scaling_policy_configuration_update::Builder::default()
    }
}

/// <p>Represents the auto scaling settings of a global secondary index for a replica that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndexAutoScalingUpdate {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub provisioned_read_capacity_auto_scaling_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
}
impl ReplicaGlobalSecondaryIndexAutoScalingUpdate {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub fn provisioned_read_capacity_auto_scaling_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.provisioned_read_capacity_auto_scaling_update.as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndexAutoScalingUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndexAutoScalingUpdate");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_read_capacity_auto_scaling_update",
            &self.provisioned_read_capacity_auto_scaling_update,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndexAutoScalingUpdate`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate)
pub mod replica_global_secondary_index_auto_scaling_update {
    /// A builder for [`ReplicaGlobalSecondaryIndexAutoScalingUpdate`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_read_capacity_auto_scaling_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn provisioned_read_capacity_auto_scaling_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_update = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn set_provisioned_read_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_update = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndexAutoScalingUpdate`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate {
            crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate {
                index_name: self.index_name,
                provisioned_read_capacity_auto_scaling_update: self
                    .provisioned_read_capacity_auto_scaling_update,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndexAutoScalingUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndexAutoScalingUpdate`](crate::model::ReplicaGlobalSecondaryIndexAutoScalingUpdate)
    pub fn builder() -> crate::model::replica_global_secondary_index_auto_scaling_update::Builder {
        crate::model::replica_global_secondary_index_auto_scaling_update::Builder::default()
    }
}

/// <p>Represents the auto scaling settings of a global secondary index for a global table that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSecondaryIndexAutoScalingUpdate {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub provisioned_write_capacity_auto_scaling_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
}
impl GlobalSecondaryIndexAutoScalingUpdate {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
    pub fn provisioned_write_capacity_auto_scaling_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.provisioned_write_capacity_auto_scaling_update.as_ref()
    }
}
impl std::fmt::Debug for GlobalSecondaryIndexAutoScalingUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSecondaryIndexAutoScalingUpdate");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_write_capacity_auto_scaling_update",
            &self.provisioned_write_capacity_auto_scaling_update,
        );
        formatter.finish()
    }
}
/// See [`GlobalSecondaryIndexAutoScalingUpdate`](crate::model::GlobalSecondaryIndexAutoScalingUpdate)
pub mod global_secondary_index_auto_scaling_update {
    /// A builder for [`GlobalSecondaryIndexAutoScalingUpdate`](crate::model::GlobalSecondaryIndexAutoScalingUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_write_capacity_auto_scaling_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_update = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global secondary index.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_update = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSecondaryIndexAutoScalingUpdate`](crate::model::GlobalSecondaryIndexAutoScalingUpdate)
        pub fn build(self) -> crate::model::GlobalSecondaryIndexAutoScalingUpdate {
            crate::model::GlobalSecondaryIndexAutoScalingUpdate {
                index_name: self.index_name,
                provisioned_write_capacity_auto_scaling_update: self
                    .provisioned_write_capacity_auto_scaling_update,
            }
        }
    }
}
impl GlobalSecondaryIndexAutoScalingUpdate {
    /// Creates a new builder-style object to manufacture [`GlobalSecondaryIndexAutoScalingUpdate`](crate::model::GlobalSecondaryIndexAutoScalingUpdate)
    pub fn builder() -> crate::model::global_secondary_index_auto_scaling_update::Builder {
        crate::model::global_secondary_index_auto_scaling_update::Builder::default()
    }
}

/// <p>Represents the properties of a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableDescription {
    /// <p>An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table and index key schema.</p>
    /// <p>Each <code>AttributeDefinition</code> object in this array is composed of:</p>
    /// <ul>
    /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
    /// <li> <p> <code>AttributeType</code> - The data type for the attribute.</p> </li>
    /// </ul>
    pub attribute_definitions:
        std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
    /// <ul>
    /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
    /// <li> <p> <code>KeyType</code> - The role of the attribute:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note> </li>
    /// </ul>
    /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>The current state of the table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days. </p> </li>
    /// <li> <p> <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete. </p> </li>
    /// <li> <p> <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information. </p> </li>
    /// </ul>
    pub table_status: std::option::Option<crate::model::TableStatus>,
    /// <p>The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughputDescription>,
    /// <p>The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub table_size_bytes: i64,
    /// <p>The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub item_count: i64,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the table.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the table for which the backup was created. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>Contains the details for the read/write capacity mode.</p>
    pub billing_mode_summary: std::option::Option<crate::model::BillingModeSummary>,
    /// <p>Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:</p>
    /// <ul>
    /// <li> <p> <code>IndexName</code> - The name of the local secondary index.</p> </li>
    /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
    /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
    /// <ul>
    /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
    /// <li> <p> <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
    /// </ul>
    /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
    pub local_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexDescription>>,
    /// <p>The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:</p>
    /// <ul>
    /// <li> <p> <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.) </p> <p> You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)</p> </li>
    /// <li> <p> <code>IndexName</code> - The name of the global secondary index.</p> </li>
    /// <li> <p> <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
    /// <li> <p> <code>IndexStatus</code> - The current status of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
    /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
    /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
    /// <ul>
    /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases. </p> </li>
    /// </ul>
    /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexDescription>>,
    /// <p>The current DynamoDB Streams configuration for the table.</p>
    pub stream_specification: std::option::Option<crate::model::StreamSpecification>,
    /// <p>A timestamp, in ISO 8601 format, for this stream.</p>
    /// <p>Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:</p>
    /// <ul>
    /// <li> <p>Amazon Web Services customer ID</p> </li>
    /// <li> <p>Table name</p> </li>
    /// <li> <p> <code>StreamLabel</code> </p> </li>
    /// </ul>
    pub latest_stream_label: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.</p>
    pub latest_stream_arn: std::option::Option<std::string::String>,
    /// <p>Represents the version of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in use, if the table is replicated across Amazon Web Services Regions.</p>
    pub global_table_version: std::option::Option<std::string::String>,
    /// <p>Represents replicas of the table.</p>
    pub replicas: std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
    /// <p>Contains details for the restore.</p>
    pub restore_summary: std::option::Option<crate::model::RestoreSummary>,
    /// <p>The description of the server-side encryption status on the specified table.</p>
    pub sse_description: std::option::Option<crate::model::SseDescription>,
    /// <p>Contains information about the table archive.</p>
    pub archival_summary: std::option::Option<crate::model::ArchivalSummary>,
    /// <p>Contains details of the table class.</p>
    pub table_class_summary: std::option::Option<crate::model::TableClassSummary>,
}
impl TableDescription {
    /// <p>An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table and index key schema.</p>
    /// <p>Each <code>AttributeDefinition</code> object in this array is composed of:</p>
    /// <ul>
    /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
    /// <li> <p> <code>AttributeType</code> - The data type for the attribute.</p> </li>
    /// </ul>
    pub fn attribute_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeDefinition]> {
        self.attribute_definitions.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
    /// <ul>
    /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
    /// <li> <p> <code>KeyType</code> - The role of the attribute:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note> </li>
    /// </ul>
    /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>The current state of the table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days. </p> </li>
    /// <li> <p> <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete. </p> </li>
    /// <li> <p> <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information. </p> </li>
    /// </ul>
    pub fn table_status(&self) -> std::option::Option<&crate::model::TableStatus> {
        self.table_status.as_ref()
    }
    /// <p>The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a> format.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputDescription> {
        self.provisioned_throughput.as_ref()
    }
    /// <p>The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn table_size_bytes(&self) -> i64 {
        self.table_size_bytes
    }
    /// <p>The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn item_count(&self) -> i64 {
        self.item_count
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the table.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Unique identifier for the table for which the backup was created. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>Contains the details for the read/write capacity mode.</p>
    pub fn billing_mode_summary(&self) -> std::option::Option<&crate::model::BillingModeSummary> {
        self.billing_mode_summary.as_ref()
    }
    /// <p>Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:</p>
    /// <ul>
    /// <li> <p> <code>IndexName</code> - The name of the local secondary index.</p> </li>
    /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
    /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
    /// <ul>
    /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
    /// <li> <p> <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
    /// </ul>
    /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
    pub fn local_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::LocalSecondaryIndexDescription]> {
        self.local_secondary_indexes.as_deref()
    }
    /// <p>The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:</p>
    /// <ul>
    /// <li> <p> <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.) </p> <p> You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)</p> </li>
    /// <li> <p> <code>IndexName</code> - The name of the global secondary index.</p> </li>
    /// <li> <p> <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
    /// <li> <p> <code>IndexStatus</code> - The current status of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
    /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
    /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
    /// <ul>
    /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
    /// </ul> </li>
    /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases. </p> </li>
    /// </ul>
    /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndexDescription]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>The current DynamoDB Streams configuration for the table.</p>
    pub fn stream_specification(&self) -> std::option::Option<&crate::model::StreamSpecification> {
        self.stream_specification.as_ref()
    }
    /// <p>A timestamp, in ISO 8601 format, for this stream.</p>
    /// <p>Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:</p>
    /// <ul>
    /// <li> <p>Amazon Web Services customer ID</p> </li>
    /// <li> <p>Table name</p> </li>
    /// <li> <p> <code>StreamLabel</code> </p> </li>
    /// </ul>
    pub fn latest_stream_label(&self) -> std::option::Option<&str> {
        self.latest_stream_label.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.</p>
    pub fn latest_stream_arn(&self) -> std::option::Option<&str> {
        self.latest_stream_arn.as_deref()
    }
    /// <p>Represents the version of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in use, if the table is replicated across Amazon Web Services Regions.</p>
    pub fn global_table_version(&self) -> std::option::Option<&str> {
        self.global_table_version.as_deref()
    }
    /// <p>Represents replicas of the table.</p>
    pub fn replicas(&self) -> std::option::Option<&[crate::model::ReplicaDescription]> {
        self.replicas.as_deref()
    }
    /// <p>Contains details for the restore.</p>
    pub fn restore_summary(&self) -> std::option::Option<&crate::model::RestoreSummary> {
        self.restore_summary.as_ref()
    }
    /// <p>The description of the server-side encryption status on the specified table.</p>
    pub fn sse_description(&self) -> std::option::Option<&crate::model::SseDescription> {
        self.sse_description.as_ref()
    }
    /// <p>Contains information about the table archive.</p>
    pub fn archival_summary(&self) -> std::option::Option<&crate::model::ArchivalSummary> {
        self.archival_summary.as_ref()
    }
    /// <p>Contains details of the table class.</p>
    pub fn table_class_summary(&self) -> std::option::Option<&crate::model::TableClassSummary> {
        self.table_class_summary.as_ref()
    }
}
impl std::fmt::Debug for TableDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableDescription");
        formatter.field("attribute_definitions", &self.attribute_definitions);
        formatter.field("table_name", &self.table_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("table_status", &self.table_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.field("table_size_bytes", &self.table_size_bytes);
        formatter.field("item_count", &self.item_count);
        formatter.field("table_arn", &self.table_arn);
        formatter.field("table_id", &self.table_id);
        formatter.field("billing_mode_summary", &self.billing_mode_summary);
        formatter.field("local_secondary_indexes", &self.local_secondary_indexes);
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field("stream_specification", &self.stream_specification);
        formatter.field("latest_stream_label", &self.latest_stream_label);
        formatter.field("latest_stream_arn", &self.latest_stream_arn);
        formatter.field("global_table_version", &self.global_table_version);
        formatter.field("replicas", &self.replicas);
        formatter.field("restore_summary", &self.restore_summary);
        formatter.field("sse_description", &self.sse_description);
        formatter.field("archival_summary", &self.archival_summary);
        formatter.field("table_class_summary", &self.table_class_summary);
        formatter.finish()
    }
}
/// See [`TableDescription`](crate::model::TableDescription)
pub mod table_description {
    /// A builder for [`TableDescription`](crate::model::TableDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_definitions:
            std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) table_status: std::option::Option<crate::model::TableStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) provisioned_throughput:
            std::option::Option<crate::model::ProvisionedThroughputDescription>,
        pub(crate) table_size_bytes: std::option::Option<i64>,
        pub(crate) item_count: std::option::Option<i64>,
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) billing_mode_summary: std::option::Option<crate::model::BillingModeSummary>,
        pub(crate) local_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexDescription>>,
        pub(crate) global_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexDescription>>,
        pub(crate) stream_specification: std::option::Option<crate::model::StreamSpecification>,
        pub(crate) latest_stream_label: std::option::Option<std::string::String>,
        pub(crate) latest_stream_arn: std::option::Option<std::string::String>,
        pub(crate) global_table_version: std::option::Option<std::string::String>,
        pub(crate) replicas: std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
        pub(crate) restore_summary: std::option::Option<crate::model::RestoreSummary>,
        pub(crate) sse_description: std::option::Option<crate::model::SseDescription>,
        pub(crate) archival_summary: std::option::Option<crate::model::ArchivalSummary>,
        pub(crate) table_class_summary: std::option::Option<crate::model::TableClassSummary>,
    }
    impl Builder {
        /// Appends an item to `attribute_definitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table and index key schema.</p>
        /// <p>Each <code>AttributeDefinition</code> object in this array is composed of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
        /// <li> <p> <code>AttributeType</code> - The data type for the attribute.</p> </li>
        /// </ul>
        pub fn attribute_definitions(mut self, input: crate::model::AttributeDefinition) -> Self {
            let mut v = self.attribute_definitions.unwrap_or_default();
            v.push(input);
            self.attribute_definitions = Some(v);
            self
        }
        /// <p>An array of <code>AttributeDefinition</code> objects. Each of these objects describes one attribute in the table and index key schema.</p>
        /// <p>Each <code>AttributeDefinition</code> object in this array is composed of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
        /// <li> <p> <code>AttributeType</code> - The data type for the attribute.</p> </li>
        /// </ul>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.attribute_definitions = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
        /// <li> <p> <code>KeyType</code> - The role of the attribute:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note> </li>
        /// </ul>
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The primary key structure for the table. Each <code>KeySchemaElement</code> consists of:</p>
        /// <ul>
        /// <li> <p> <code>AttributeName</code> - The name of the attribute.</p> </li>
        /// <li> <p> <code>KeyType</code> - The role of the attribute:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note> </li>
        /// </ul>
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>The current state of the table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days. </p> </li>
        /// <li> <p> <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete. </p> </li>
        /// <li> <p> <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information. </p> </li>
        /// </ul>
        pub fn table_status(mut self, input: crate::model::TableStatus) -> Self {
            self.table_status = Some(input);
            self
        }
        /// <p>The current state of the table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The table is ready for use.</p> </li>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days. </p> </li>
        /// <li> <p> <code>ARCHIVING</code> - The table is being archived. Operations are not allowed until archival is complete. </p> </li>
        /// <li> <p> <code>ARCHIVED</code> - The table has been archived. See the ArchivalReason for more information. </p> </li>
        /// </ul>
        pub fn set_table_status(
            mut self,
            input: std::option::Option<crate::model::TableStatus>,
        ) -> Self {
            self.table_status = input;
            self
        }
        /// <p>The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time when the table was created, in <a href="http://www.epochconverter.com/">UNIX epoch time</a> format.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughputDescription,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputDescription>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// <p>The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn table_size_bytes(mut self, input: i64) -> Self {
            self.table_size_bytes = Some(input);
            self
        }
        /// <p>The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_table_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.table_size_bytes = input;
            self
        }
        /// <p>The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn item_count(mut self, input: i64) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i64>) -> Self {
            self.item_count = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>Unique identifier for the table for which the backup was created. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the table for which the backup was created. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>Contains the details for the read/write capacity mode.</p>
        pub fn billing_mode_summary(mut self, input: crate::model::BillingModeSummary) -> Self {
            self.billing_mode_summary = Some(input);
            self
        }
        /// <p>Contains the details for the read/write capacity mode.</p>
        pub fn set_billing_mode_summary(
            mut self,
            input: std::option::Option<crate::model::BillingModeSummary>,
        ) -> Self {
            self.billing_mode_summary = input;
            self
        }
        /// Appends an item to `local_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the local secondary index.</p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
        /// <li> <p> <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
        /// </ul>
        /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
        pub fn local_secondary_indexes(
            mut self,
            input: crate::model::LocalSecondaryIndexDescription,
        ) -> Self {
            let mut v = self.local_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.local_secondary_indexes = Some(v);
            self
        }
        /// <p>Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:</p>
        /// <ul>
        /// <li> <p> <code>IndexName</code> - The name of the local secondary index.</p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - Only the specified table attributes are projected into the index. The list of projected attributes is in <code>NonKeyAttributes</code>.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>IndexSizeBytes</code> - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
        /// <li> <p> <code>ItemCount</code> - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p> </li>
        /// </ul>
        /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexDescription>>,
        ) -> Self {
            self.local_secondary_indexes = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:</p>
        /// <ul>
        /// <li> <p> <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.) </p> <p> You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)</p> </li>
        /// <li> <p> <code>IndexName</code> - The name of the global secondary index.</p> </li>
        /// <li> <p> <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
        /// <li> <p> <code>IndexStatus</code> - The current status of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases. </p> </li>
        /// </ul>
        /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::GlobalSecondaryIndexDescription,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:</p>
        /// <ul>
        /// <li> <p> <code>Backfilling</code> - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.) </p> <p> You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. (This attribute does not appear for indexes that were created during a <code>CreateTable</code> operation.)</p> </li>
        /// <li> <p> <code>IndexName</code> - The name of the global secondary index.</p> </li>
        /// <li> <p> <code>IndexSizeBytes</code> - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
        /// <li> <p> <code>IndexStatus</code> - The current status of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ItemCount</code> - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value. </p> </li>
        /// <li> <p> <code>KeySchema</code> - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.</p> </li>
        /// <li> <p> <code>Projection</code> - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:</p>
        /// <ul>
        /// <li> <p> <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>NonKeyAttributes</code> - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in <code>NonKeyAttributes</code>, summed across all of the secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>ProvisionedThroughput</code> - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases. </p> </li>
        /// </ul>
        /// <p>If the table is in the <code>DELETING</code> state, no information about indexes will be returned.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalSecondaryIndexDescription>,
            >,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>The current DynamoDB Streams configuration for the table.</p>
        pub fn stream_specification(mut self, input: crate::model::StreamSpecification) -> Self {
            self.stream_specification = Some(input);
            self
        }
        /// <p>The current DynamoDB Streams configuration for the table.</p>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.stream_specification = input;
            self
        }
        /// <p>A timestamp, in ISO 8601 format, for this stream.</p>
        /// <p>Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:</p>
        /// <ul>
        /// <li> <p>Amazon Web Services customer ID</p> </li>
        /// <li> <p>Table name</p> </li>
        /// <li> <p> <code>StreamLabel</code> </p> </li>
        /// </ul>
        pub fn latest_stream_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_stream_label = Some(input.into());
            self
        }
        /// <p>A timestamp, in ISO 8601 format, for this stream.</p>
        /// <p>Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:</p>
        /// <ul>
        /// <li> <p>Amazon Web Services customer ID</p> </li>
        /// <li> <p>Table name</p> </li>
        /// <li> <p> <code>StreamLabel</code> </p> </li>
        /// </ul>
        pub fn set_latest_stream_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_stream_label = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.</p>
        pub fn latest_stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.</p>
        pub fn set_latest_stream_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_stream_arn = input;
            self
        }
        /// <p>Represents the version of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in use, if the table is replicated across Amazon Web Services Regions.</p>
        pub fn global_table_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_version = Some(input.into());
            self
        }
        /// <p>Represents the version of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html">global tables</a> in use, if the table is replicated across Amazon Web Services Regions.</p>
        pub fn set_global_table_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_version = input;
            self
        }
        /// Appends an item to `replicas`.
        ///
        /// To override the contents of this collection use [`set_replicas`](Self::set_replicas).
        ///
        /// <p>Represents replicas of the table.</p>
        pub fn replicas(mut self, input: crate::model::ReplicaDescription) -> Self {
            let mut v = self.replicas.unwrap_or_default();
            v.push(input);
            self.replicas = Some(v);
            self
        }
        /// <p>Represents replicas of the table.</p>
        pub fn set_replicas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
        ) -> Self {
            self.replicas = input;
            self
        }
        /// <p>Contains details for the restore.</p>
        pub fn restore_summary(mut self, input: crate::model::RestoreSummary) -> Self {
            self.restore_summary = Some(input);
            self
        }
        /// <p>Contains details for the restore.</p>
        pub fn set_restore_summary(
            mut self,
            input: std::option::Option<crate::model::RestoreSummary>,
        ) -> Self {
            self.restore_summary = input;
            self
        }
        /// <p>The description of the server-side encryption status on the specified table.</p>
        pub fn sse_description(mut self, input: crate::model::SseDescription) -> Self {
            self.sse_description = Some(input);
            self
        }
        /// <p>The description of the server-side encryption status on the specified table.</p>
        pub fn set_sse_description(
            mut self,
            input: std::option::Option<crate::model::SseDescription>,
        ) -> Self {
            self.sse_description = input;
            self
        }
        /// <p>Contains information about the table archive.</p>
        pub fn archival_summary(mut self, input: crate::model::ArchivalSummary) -> Self {
            self.archival_summary = Some(input);
            self
        }
        /// <p>Contains information about the table archive.</p>
        pub fn set_archival_summary(
            mut self,
            input: std::option::Option<crate::model::ArchivalSummary>,
        ) -> Self {
            self.archival_summary = input;
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn table_class_summary(mut self, input: crate::model::TableClassSummary) -> Self {
            self.table_class_summary = Some(input);
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn set_table_class_summary(
            mut self,
            input: std::option::Option<crate::model::TableClassSummary>,
        ) -> Self {
            self.table_class_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`TableDescription`](crate::model::TableDescription)
        pub fn build(self) -> crate::model::TableDescription {
            crate::model::TableDescription {
                attribute_definitions: self.attribute_definitions,
                table_name: self.table_name,
                key_schema: self.key_schema,
                table_status: self.table_status,
                creation_date_time: self.creation_date_time,
                provisioned_throughput: self.provisioned_throughput,
                table_size_bytes: self.table_size_bytes.unwrap_or_default(),
                item_count: self.item_count.unwrap_or_default(),
                table_arn: self.table_arn,
                table_id: self.table_id,
                billing_mode_summary: self.billing_mode_summary,
                local_secondary_indexes: self.local_secondary_indexes,
                global_secondary_indexes: self.global_secondary_indexes,
                stream_specification: self.stream_specification,
                latest_stream_label: self.latest_stream_label,
                latest_stream_arn: self.latest_stream_arn,
                global_table_version: self.global_table_version,
                replicas: self.replicas,
                restore_summary: self.restore_summary,
                sse_description: self.sse_description,
                archival_summary: self.archival_summary,
                table_class_summary: self.table_class_summary,
            }
        }
    }
}
impl TableDescription {
    /// Creates a new builder-style object to manufacture [`TableDescription`](crate::model::TableDescription)
    pub fn builder() -> crate::model::table_description::Builder {
        crate::model::table_description::Builder::default()
    }
}

/// <p>Contains details of the table class.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableClassSummary {
    /// <p>The table class of the specified table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub table_class: std::option::Option<crate::model::TableClass>,
    /// <p>The date and time at which the table class was last updated.</p>
    pub last_update_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl TableClassSummary {
    /// <p>The table class of the specified table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub fn table_class(&self) -> std::option::Option<&crate::model::TableClass> {
        self.table_class.as_ref()
    }
    /// <p>The date and time at which the table class was last updated.</p>
    pub fn last_update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date_time.as_ref()
    }
}
impl std::fmt::Debug for TableClassSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableClassSummary");
        formatter.field("table_class", &self.table_class);
        formatter.field("last_update_date_time", &self.last_update_date_time);
        formatter.finish()
    }
}
/// See [`TableClassSummary`](crate::model::TableClassSummary)
pub mod table_class_summary {
    /// A builder for [`TableClassSummary`](crate::model::TableClassSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_class: std::option::Option<crate::model::TableClass>,
        pub(crate) last_update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The table class of the specified table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn table_class(mut self, input: crate::model::TableClass) -> Self {
            self.table_class = Some(input);
            self
        }
        /// <p>The table class of the specified table. Valid values are <code>STANDARD</code> and <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn set_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.table_class = input;
            self
        }
        /// <p>The date and time at which the table class was last updated.</p>
        pub fn last_update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date_time = Some(input);
            self
        }
        /// <p>The date and time at which the table class was last updated.</p>
        pub fn set_last_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TableClassSummary`](crate::model::TableClassSummary)
        pub fn build(self) -> crate::model::TableClassSummary {
            crate::model::TableClassSummary {
                table_class: self.table_class,
                last_update_date_time: self.last_update_date_time,
            }
        }
    }
}
impl TableClassSummary {
    /// Creates a new builder-style object to manufacture [`TableClassSummary`](crate::model::TableClassSummary)
    pub fn builder() -> crate::model::table_class_summary::Builder {
        crate::model::table_class_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TableClass {
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardInfrequentAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TableClass {
    fn from(s: &str) -> Self {
        match s {
            "STANDARD" => TableClass::Standard,
            "STANDARD_INFREQUENT_ACCESS" => TableClass::StandardInfrequentAccess,
            other => TableClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TableClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TableClass::from(s))
    }
}
impl TableClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TableClass::Standard => "STANDARD",
            TableClass::StandardInfrequentAccess => "STANDARD_INFREQUENT_ACCESS",
            TableClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STANDARD", "STANDARD_INFREQUENT_ACCESS"]
    }
}
impl AsRef<str> for TableClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details of a table archival operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArchivalSummary {
    /// <p>The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.</p>
    pub archival_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The reason DynamoDB archived the table. Currently, the only possible value is:</p>
    /// <ul>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being inaccessible for more than seven days. An On-Demand backup was created at the archival time.</p> </li>
    /// </ul>
    pub archival_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason. If you wish to restore this backup to the same table name, you will need to delete the original table.</p>
    pub archival_backup_arn: std::option::Option<std::string::String>,
}
impl ArchivalSummary {
    /// <p>The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.</p>
    pub fn archival_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.archival_date_time.as_ref()
    }
    /// <p>The reason DynamoDB archived the table. Currently, the only possible value is:</p>
    /// <ul>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being inaccessible for more than seven days. An On-Demand backup was created at the archival time.</p> </li>
    /// </ul>
    pub fn archival_reason(&self) -> std::option::Option<&str> {
        self.archival_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason. If you wish to restore this backup to the same table name, you will need to delete the original table.</p>
    pub fn archival_backup_arn(&self) -> std::option::Option<&str> {
        self.archival_backup_arn.as_deref()
    }
}
impl std::fmt::Debug for ArchivalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArchivalSummary");
        formatter.field("archival_date_time", &self.archival_date_time);
        formatter.field("archival_reason", &self.archival_reason);
        formatter.field("archival_backup_arn", &self.archival_backup_arn);
        formatter.finish()
    }
}
/// See [`ArchivalSummary`](crate::model::ArchivalSummary)
pub mod archival_summary {
    /// A builder for [`ArchivalSummary`](crate::model::ArchivalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archival_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) archival_reason: std::option::Option<std::string::String>,
        pub(crate) archival_backup_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.</p>
        pub fn archival_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.archival_date_time = Some(input);
            self
        }
        /// <p>The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.</p>
        pub fn set_archival_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.archival_date_time = input;
            self
        }
        /// <p>The reason DynamoDB archived the table. Currently, the only possible value is:</p>
        /// <ul>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being inaccessible for more than seven days. An On-Demand backup was created at the archival time.</p> </li>
        /// </ul>
        pub fn archival_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.archival_reason = Some(input.into());
            self
        }
        /// <p>The reason DynamoDB archived the table. Currently, the only possible value is:</p>
        /// <ul>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being inaccessible for more than seven days. An On-Demand backup was created at the archival time.</p> </li>
        /// </ul>
        pub fn set_archival_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archival_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason. If you wish to restore this backup to the same table name, you will need to delete the original table.</p>
        pub fn archival_backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.archival_backup_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason. If you wish to restore this backup to the same table name, you will need to delete the original table.</p>
        pub fn set_archival_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.archival_backup_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ArchivalSummary`](crate::model::ArchivalSummary)
        pub fn build(self) -> crate::model::ArchivalSummary {
            crate::model::ArchivalSummary {
                archival_date_time: self.archival_date_time,
                archival_reason: self.archival_reason,
                archival_backup_arn: self.archival_backup_arn,
            }
        }
    }
}
impl ArchivalSummary {
    /// Creates a new builder-style object to manufacture [`ArchivalSummary`](crate::model::ArchivalSummary)
    pub fn builder() -> crate::model::archival_summary::Builder {
        crate::model::archival_summary::Builder::default()
    }
}

/// <p>The description of the server-side encryption status on the specified table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseDescription {
    /// <p>Represents the current state of server-side encryption. The only supported values are:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
    /// <li> <p> <code>UPDATING</code> - Server-side encryption is being updated.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::SseStatus>,
    /// <p>Server-side encryption type. The only supported value is:</p>
    /// <ul>
    /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
    /// </ul>
    pub sse_type: std::option::Option<crate::model::SseType>,
    /// <p>The KMS key ARN used for the KMS encryption.</p>
    pub kms_master_key_arn: std::option::Option<std::string::String>,
    /// <p>Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.</p>
    pub inaccessible_encryption_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl SseDescription {
    /// <p>Represents the current state of server-side encryption. The only supported values are:</p>
    /// <ul>
    /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
    /// <li> <p> <code>UPDATING</code> - Server-side encryption is being updated.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::SseStatus> {
        self.status.as_ref()
    }
    /// <p>Server-side encryption type. The only supported value is:</p>
    /// <ul>
    /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
    /// </ul>
    pub fn sse_type(&self) -> std::option::Option<&crate::model::SseType> {
        self.sse_type.as_ref()
    }
    /// <p>The KMS key ARN used for the KMS encryption.</p>
    pub fn kms_master_key_arn(&self) -> std::option::Option<&str> {
        self.kms_master_key_arn.as_deref()
    }
    /// <p>Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.</p>
    pub fn inaccessible_encryption_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.inaccessible_encryption_date_time.as_ref()
    }
}
impl std::fmt::Debug for SseDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseDescription");
        formatter.field("status", &self.status);
        formatter.field("sse_type", &self.sse_type);
        formatter.field("kms_master_key_arn", &self.kms_master_key_arn);
        formatter.field(
            "inaccessible_encryption_date_time",
            &self.inaccessible_encryption_date_time,
        );
        formatter.finish()
    }
}
/// See [`SseDescription`](crate::model::SseDescription)
pub mod sse_description {
    /// A builder for [`SseDescription`](crate::model::SseDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SseStatus>,
        pub(crate) sse_type: std::option::Option<crate::model::SseType>,
        pub(crate) kms_master_key_arn: std::option::Option<std::string::String>,
        pub(crate) inaccessible_encryption_date_time:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Represents the current state of server-side encryption. The only supported values are:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
        /// <li> <p> <code>UPDATING</code> - Server-side encryption is being updated.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::SseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Represents the current state of server-side encryption. The only supported values are:</p>
        /// <ul>
        /// <li> <p> <code>ENABLED</code> - Server-side encryption is enabled.</p> </li>
        /// <li> <p> <code>UPDATING</code> - Server-side encryption is being updated.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::SseStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Server-side encryption type. The only supported value is:</p>
        /// <ul>
        /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
        /// </ul>
        pub fn sse_type(mut self, input: crate::model::SseType) -> Self {
            self.sse_type = Some(input);
            self
        }
        /// <p>Server-side encryption type. The only supported value is:</p>
        /// <ul>
        /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
        /// </ul>
        pub fn set_sse_type(mut self, input: std::option::Option<crate::model::SseType>) -> Self {
            self.sse_type = input;
            self
        }
        /// <p>The KMS key ARN used for the KMS encryption.</p>
        pub fn kms_master_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key ARN used for the KMS encryption.</p>
        pub fn set_kms_master_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_arn = input;
            self
        }
        /// <p>Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.</p>
        pub fn inaccessible_encryption_date_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.inaccessible_encryption_date_time = Some(input);
            self
        }
        /// <p>Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.</p>
        pub fn set_inaccessible_encryption_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inaccessible_encryption_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SseDescription`](crate::model::SseDescription)
        pub fn build(self) -> crate::model::SseDescription {
            crate::model::SseDescription {
                status: self.status,
                sse_type: self.sse_type,
                kms_master_key_arn: self.kms_master_key_arn,
                inaccessible_encryption_date_time: self.inaccessible_encryption_date_time,
            }
        }
    }
}
impl SseDescription {
    /// Creates a new builder-style object to manufacture [`SseDescription`](crate::model::SseDescription)
    pub fn builder() -> crate::model::sse_description::Builder {
        crate::model::sse_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SseType {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SseType {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => SseType::Aes256,
            "KMS" => SseType::Kms,
            other => SseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SseType::from(s))
    }
}
impl SseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SseType::Aes256 => "AES256",
            SseType::Kms => "KMS",
            SseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "KMS"]
    }
}
impl AsRef<str> for SseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SseStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => SseStatus::Disabled,
            "DISABLING" => SseStatus::Disabling,
            "ENABLED" => SseStatus::Enabled,
            "ENABLING" => SseStatus::Enabling,
            "UPDATING" => SseStatus::Updating,
            other => SseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SseStatus::from(s))
    }
}
impl SseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SseStatus::Disabled => "DISABLED",
            SseStatus::Disabling => "DISABLING",
            SseStatus::Enabled => "ENABLED",
            SseStatus::Enabling => "ENABLING",
            SseStatus::Updating => "UPDATING",
            SseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING", "UPDATING"]
    }
}
impl AsRef<str> for SseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details for the restore.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreSummary {
    /// <p>The Amazon Resource Name (ARN) of the backup from which the table was restored.</p>
    pub source_backup_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the source table of the backup that is being restored.</p>
    pub source_table_arn: std::option::Option<std::string::String>,
    /// <p>Point in time or source backup time.</p>
    pub restore_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates if a restore is in progress or not.</p>
    pub restore_in_progress: std::option::Option<bool>,
}
impl RestoreSummary {
    /// <p>The Amazon Resource Name (ARN) of the backup from which the table was restored.</p>
    pub fn source_backup_arn(&self) -> std::option::Option<&str> {
        self.source_backup_arn.as_deref()
    }
    /// <p>The ARN of the source table of the backup that is being restored.</p>
    pub fn source_table_arn(&self) -> std::option::Option<&str> {
        self.source_table_arn.as_deref()
    }
    /// <p>Point in time or source backup time.</p>
    pub fn restore_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.restore_date_time.as_ref()
    }
    /// <p>Indicates if a restore is in progress or not.</p>
    pub fn restore_in_progress(&self) -> std::option::Option<bool> {
        self.restore_in_progress
    }
}
impl std::fmt::Debug for RestoreSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreSummary");
        formatter.field("source_backup_arn", &self.source_backup_arn);
        formatter.field("source_table_arn", &self.source_table_arn);
        formatter.field("restore_date_time", &self.restore_date_time);
        formatter.field("restore_in_progress", &self.restore_in_progress);
        formatter.finish()
    }
}
/// See [`RestoreSummary`](crate::model::RestoreSummary)
pub mod restore_summary {
    /// A builder for [`RestoreSummary`](crate::model::RestoreSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_backup_arn: std::option::Option<std::string::String>,
        pub(crate) source_table_arn: std::option::Option<std::string::String>,
        pub(crate) restore_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) restore_in_progress: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the backup from which the table was restored.</p>
        pub fn source_backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_backup_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the backup from which the table was restored.</p>
        pub fn set_source_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_backup_arn = input;
            self
        }
        /// <p>The ARN of the source table of the backup that is being restored.</p>
        pub fn source_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the source table of the backup that is being restored.</p>
        pub fn set_source_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_table_arn = input;
            self
        }
        /// <p>Point in time or source backup time.</p>
        pub fn restore_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.restore_date_time = Some(input);
            self
        }
        /// <p>Point in time or source backup time.</p>
        pub fn set_restore_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.restore_date_time = input;
            self
        }
        /// <p>Indicates if a restore is in progress or not.</p>
        pub fn restore_in_progress(mut self, input: bool) -> Self {
            self.restore_in_progress = Some(input);
            self
        }
        /// <p>Indicates if a restore is in progress or not.</p>
        pub fn set_restore_in_progress(mut self, input: std::option::Option<bool>) -> Self {
            self.restore_in_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreSummary`](crate::model::RestoreSummary)
        pub fn build(self) -> crate::model::RestoreSummary {
            crate::model::RestoreSummary {
                source_backup_arn: self.source_backup_arn,
                source_table_arn: self.source_table_arn,
                restore_date_time: self.restore_date_time,
                restore_in_progress: self.restore_in_progress,
            }
        }
    }
}
impl RestoreSummary {
    /// Creates a new builder-style object to manufacture [`RestoreSummary`](crate::model::RestoreSummary)
    pub fn builder() -> crate::model::restore_summary::Builder {
        crate::model::restore_summary::Builder::default()
    }
}

/// <p>Contains the details of the replica.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaDescription {
    /// <p>The name of the Region.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The current state of the replica:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
    /// <li> <p> <code>REGION_DISABLED</code> - The replica is inaccessible because the Amazon Web Services Region has been disabled.</p> <note>
    /// <p>If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
    /// </note> </li>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS </code> - The KMS key used to encrypt the table is inaccessible.</p> <note>
    /// <p>If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
    /// </note> </li>
    /// </ul>
    pub replica_status: std::option::Option<crate::model::ReplicaStatus>,
    /// <p>Detailed information about the replica status.</p>
    pub replica_status_description: std::option::Option<std::string::String>,
    /// <p>Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.</p>
    pub replica_status_percent_progress: std::option::Option<std::string::String>,
    /// <p>The KMS key of the replica that will be used for KMS encryption.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
    /// <p>Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.</p>
    pub provisioned_throughput_override:
        std::option::Option<crate::model::ProvisionedThroughputOverride>,
    /// <p>Replica-specific global secondary index settings.</p>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexDescription>>,
    /// <p>The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the <code>ReplicaStatus</code> property.</p>
    pub replica_inaccessible_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains details of the table class.</p>
    pub replica_table_class_summary: std::option::Option<crate::model::TableClassSummary>,
}
impl ReplicaDescription {
    /// <p>The name of the Region.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The current state of the replica:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
    /// <li> <p> <code>REGION_DISABLED</code> - The replica is inaccessible because the Amazon Web Services Region has been disabled.</p> <note>
    /// <p>If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
    /// </note> </li>
    /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS </code> - The KMS key used to encrypt the table is inaccessible.</p> <note>
    /// <p>If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
    /// </note> </li>
    /// </ul>
    pub fn replica_status(&self) -> std::option::Option<&crate::model::ReplicaStatus> {
        self.replica_status.as_ref()
    }
    /// <p>Detailed information about the replica status.</p>
    pub fn replica_status_description(&self) -> std::option::Option<&str> {
        self.replica_status_description.as_deref()
    }
    /// <p>Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.</p>
    pub fn replica_status_percent_progress(&self) -> std::option::Option<&str> {
        self.replica_status_percent_progress.as_deref()
    }
    /// <p>The KMS key of the replica that will be used for KMS encryption.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
    /// <p>Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputOverride> {
        self.provisioned_throughput_override.as_ref()
    }
    /// <p>Replica-specific global secondary index settings.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndexDescription]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the <code>ReplicaStatus</code> property.</p>
    pub fn replica_inaccessible_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replica_inaccessible_date_time.as_ref()
    }
    /// <p>Contains details of the table class.</p>
    pub fn replica_table_class_summary(
        &self,
    ) -> std::option::Option<&crate::model::TableClassSummary> {
        self.replica_table_class_summary.as_ref()
    }
}
impl std::fmt::Debug for ReplicaDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaDescription");
        formatter.field("region_name", &self.region_name);
        formatter.field("replica_status", &self.replica_status);
        formatter.field(
            "replica_status_description",
            &self.replica_status_description,
        );
        formatter.field(
            "replica_status_percent_progress",
            &self.replica_status_percent_progress,
        );
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field(
            "replica_inaccessible_date_time",
            &self.replica_inaccessible_date_time,
        );
        formatter.field(
            "replica_table_class_summary",
            &self.replica_table_class_summary,
        );
        formatter.finish()
    }
}
/// See [`ReplicaDescription`](crate::model::ReplicaDescription)
pub mod replica_description {
    /// A builder for [`ReplicaDescription`](crate::model::ReplicaDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) replica_status: std::option::Option<crate::model::ReplicaStatus>,
        pub(crate) replica_status_description: std::option::Option<std::string::String>,
        pub(crate) replica_status_percent_progress: std::option::Option<std::string::String>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughputOverride>,
        pub(crate) global_secondary_indexes: std::option::Option<
            std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexDescription>,
        >,
        pub(crate) replica_inaccessible_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) replica_table_class_summary:
            std::option::Option<crate::model::TableClassSummary>,
    }
    impl Builder {
        /// <p>The name of the Region.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the Region.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The current state of the replica:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
        /// <li> <p> <code>REGION_DISABLED</code> - The replica is inaccessible because the Amazon Web Services Region has been disabled.</p> <note>
        /// <p>If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
        /// </note> </li>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS </code> - The KMS key used to encrypt the table is inaccessible.</p> <note>
        /// <p>If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
        /// </note> </li>
        /// </ul>
        pub fn replica_status(mut self, input: crate::model::ReplicaStatus) -> Self {
            self.replica_status = Some(input);
            self
        }
        /// <p>The current state of the replica:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The replica is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The replica is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The replica is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The replica is ready for use.</p> </li>
        /// <li> <p> <code>REGION_DISABLED</code> - The replica is inaccessible because the Amazon Web Services Region has been disabled.</p> <note>
        /// <p>If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
        /// </note> </li>
        /// <li> <p> <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS </code> - The KMS key used to encrypt the table is inaccessible.</p> <note>
        /// <p>If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.</p>
        /// </note> </li>
        /// </ul>
        pub fn set_replica_status(
            mut self,
            input: std::option::Option<crate::model::ReplicaStatus>,
        ) -> Self {
            self.replica_status = input;
            self
        }
        /// <p>Detailed information about the replica status.</p>
        pub fn replica_status_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.replica_status_description = Some(input.into());
            self
        }
        /// <p>Detailed information about the replica status.</p>
        pub fn set_replica_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replica_status_description = input;
            self
        }
        /// <p>Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.</p>
        pub fn replica_status_percent_progress(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replica_status_percent_progress = Some(input.into());
            self
        }
        /// <p>Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.</p>
        pub fn set_replica_status_percent_progress(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replica_status_percent_progress = input;
            self
        }
        /// <p>The KMS key of the replica that will be used for KMS encryption.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key of the replica that will be used for KMS encryption.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// <p>Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughputOverride,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputOverride>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndexDescription,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexDescription>,
            >,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the <code>ReplicaStatus</code> property.</p>
        pub fn replica_inaccessible_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.replica_inaccessible_date_time = Some(input);
            self
        }
        /// <p>The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the <code>ReplicaStatus</code> property.</p>
        pub fn set_replica_inaccessible_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replica_inaccessible_date_time = input;
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn replica_table_class_summary(
            mut self,
            input: crate::model::TableClassSummary,
        ) -> Self {
            self.replica_table_class_summary = Some(input);
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn set_replica_table_class_summary(
            mut self,
            input: std::option::Option<crate::model::TableClassSummary>,
        ) -> Self {
            self.replica_table_class_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaDescription`](crate::model::ReplicaDescription)
        pub fn build(self) -> crate::model::ReplicaDescription {
            crate::model::ReplicaDescription {
                region_name: self.region_name,
                replica_status: self.replica_status,
                replica_status_description: self.replica_status_description,
                replica_status_percent_progress: self.replica_status_percent_progress,
                kms_master_key_id: self.kms_master_key_id,
                provisioned_throughput_override: self.provisioned_throughput_override,
                global_secondary_indexes: self.global_secondary_indexes,
                replica_inaccessible_date_time: self.replica_inaccessible_date_time,
                replica_table_class_summary: self.replica_table_class_summary,
            }
        }
    }
}
impl ReplicaDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaDescription`](crate::model::ReplicaDescription)
    pub fn builder() -> crate::model::replica_description::Builder {
        crate::model::replica_description::Builder::default()
    }
}

/// <p>Represents the properties of a replica global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndexDescription {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>If not described, uses the source table GSI's read capacity settings.</p>
    pub provisioned_throughput_override:
        std::option::Option<crate::model::ProvisionedThroughputOverride>,
}
impl ReplicaGlobalSecondaryIndexDescription {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>If not described, uses the source table GSI's read capacity settings.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputOverride> {
        self.provisioned_throughput_override.as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndexDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndexDescription");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndexDescription`](crate::model::ReplicaGlobalSecondaryIndexDescription)
pub mod replica_global_secondary_index_description {
    /// A builder for [`ReplicaGlobalSecondaryIndexDescription`](crate::model::ReplicaGlobalSecondaryIndexDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughputOverride>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>If not described, uses the source table GSI's read capacity settings.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughputOverride,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>If not described, uses the source table GSI's read capacity settings.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputOverride>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndexDescription`](crate::model::ReplicaGlobalSecondaryIndexDescription)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndexDescription {
            crate::model::ReplicaGlobalSecondaryIndexDescription {
                index_name: self.index_name,
                provisioned_throughput_override: self.provisioned_throughput_override,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndexDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndexDescription`](crate::model::ReplicaGlobalSecondaryIndexDescription)
    pub fn builder() -> crate::model::replica_global_secondary_index_description::Builder {
        crate::model::replica_global_secondary_index_description::Builder::default()
    }
}

/// <p>Replica-specific provisioned throughput settings. If not specified, uses the source table's provisioned throughput settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughputOverride {
    /// <p>Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.</p>
    pub read_capacity_units: std::option::Option<i64>,
}
impl ProvisionedThroughputOverride {
    /// <p>Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<i64> {
        self.read_capacity_units
    }
}
impl std::fmt::Debug for ProvisionedThroughputOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughputOverride");
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.finish()
    }
}
/// See [`ProvisionedThroughputOverride`](crate::model::ProvisionedThroughputOverride)
pub mod provisioned_throughput_override {
    /// A builder for [`ProvisionedThroughputOverride`](crate::model::ProvisionedThroughputOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_capacity_units: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.</p>
        pub fn read_capacity_units(mut self, input: i64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>Replica-specific read capacity units. If not specified, uses the source table's read capacity settings.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughputOverride`](crate::model::ProvisionedThroughputOverride)
        pub fn build(self) -> crate::model::ProvisionedThroughputOverride {
            crate::model::ProvisionedThroughputOverride {
                read_capacity_units: self.read_capacity_units,
            }
        }
    }
}
impl ProvisionedThroughputOverride {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughputOverride`](crate::model::ProvisionedThroughputOverride)
    pub fn builder() -> crate::model::provisioned_throughput_override::Builder {
        crate::model::provisioned_throughput_override::Builder::default()
    }
}

/// <p>Represents the DynamoDB Streams configuration for a table in DynamoDB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamSpecification {
    /// <p>Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.</p>
    pub stream_enabled: std::option::Option<bool>,
    /// <p> When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
    /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
    /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
    /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
    /// </ul>
    pub stream_view_type: std::option::Option<crate::model::StreamViewType>,
}
impl StreamSpecification {
    /// <p>Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.</p>
    pub fn stream_enabled(&self) -> std::option::Option<bool> {
        self.stream_enabled
    }
    /// <p> When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
    /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
    /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
    /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
    /// </ul>
    pub fn stream_view_type(&self) -> std::option::Option<&crate::model::StreamViewType> {
        self.stream_view_type.as_ref()
    }
}
impl std::fmt::Debug for StreamSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamSpecification");
        formatter.field("stream_enabled", &self.stream_enabled);
        formatter.field("stream_view_type", &self.stream_view_type);
        formatter.finish()
    }
}
/// See [`StreamSpecification`](crate::model::StreamSpecification)
pub mod stream_specification {
    /// A builder for [`StreamSpecification`](crate::model::StreamSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_enabled: std::option::Option<bool>,
        pub(crate) stream_view_type: std::option::Option<crate::model::StreamViewType>,
    }
    impl Builder {
        /// <p>Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.</p>
        pub fn stream_enabled(mut self, input: bool) -> Self {
            self.stream_enabled = Some(input);
            self
        }
        /// <p>Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.</p>
        pub fn set_stream_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.stream_enabled = input;
            self
        }
        /// <p> When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
        /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
        /// </ul>
        pub fn stream_view_type(mut self, input: crate::model::StreamViewType) -> Self {
            self.stream_view_type = Some(input);
            self
        }
        /// <p> When an item in the table is modified, <code>StreamViewType</code> determines what information is written to the stream for this table. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the key attributes of the modified item are written to the stream.</p> </li>
        /// <li> <p> <code>NEW_IMAGE</code> - The entire item, as it appears after it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>OLD_IMAGE</code> - The entire item, as it appeared before it was modified, is written to the stream.</p> </li>
        /// <li> <p> <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images of the item are written to the stream.</p> </li>
        /// </ul>
        pub fn set_stream_view_type(
            mut self,
            input: std::option::Option<crate::model::StreamViewType>,
        ) -> Self {
            self.stream_view_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamSpecification`](crate::model::StreamSpecification)
        pub fn build(self) -> crate::model::StreamSpecification {
            crate::model::StreamSpecification {
                stream_enabled: self.stream_enabled,
                stream_view_type: self.stream_view_type,
            }
        }
    }
}
impl StreamSpecification {
    /// Creates a new builder-style object to manufacture [`StreamSpecification`](crate::model::StreamSpecification)
    pub fn builder() -> crate::model::stream_specification::Builder {
        crate::model::stream_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamViewType {
    #[allow(missing_docs)] // documentation missing in model
    KeysOnly,
    #[allow(missing_docs)] // documentation missing in model
    NewAndOldImages,
    #[allow(missing_docs)] // documentation missing in model
    NewImage,
    #[allow(missing_docs)] // documentation missing in model
    OldImage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamViewType {
    fn from(s: &str) -> Self {
        match s {
            "KEYS_ONLY" => StreamViewType::KeysOnly,
            "NEW_AND_OLD_IMAGES" => StreamViewType::NewAndOldImages,
            "NEW_IMAGE" => StreamViewType::NewImage,
            "OLD_IMAGE" => StreamViewType::OldImage,
            other => StreamViewType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamViewType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamViewType::from(s))
    }
}
impl StreamViewType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamViewType::KeysOnly => "KEYS_ONLY",
            StreamViewType::NewAndOldImages => "NEW_AND_OLD_IMAGES",
            StreamViewType::NewImage => "NEW_IMAGE",
            StreamViewType::OldImage => "OLD_IMAGE",
            StreamViewType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["KEYS_ONLY", "NEW_AND_OLD_IMAGES", "NEW_IMAGE", "OLD_IMAGE"]
    }
}
impl AsRef<str> for StreamViewType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the properties of a global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSecondaryIndexDescription {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
    /// <p>The current state of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul>
    pub index_status: std::option::Option<crate::model::IndexStatus>,
    /// <p>Indicates whether the index is currently backfilling. <i>Backfilling</i> is the process of reading items from the table and determining whether they can be added to the index. (Not all items will qualify: For example, a partition key cannot have any duplicate values.) If an item can be added to the index, DynamoDB will do so. After all items have been processed, the backfilling operation is complete and <code>Backfilling</code> is false.</p>
    /// <p>You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. </p> <note>
    /// <p>For indexes that were created during a <code>CreateTable</code> operation, the <code>Backfilling</code> attribute does not appear in the <code>DescribeTable</code> output.</p>
    /// </note>
    pub backfilling: std::option::Option<bool>,
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughputDescription>,
    /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub index_size_bytes: i64,
    /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub item_count: i64,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
    pub index_arn: std::option::Option<std::string::String>,
}
impl GlobalSecondaryIndexDescription {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
    /// <p>The current state of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
    /// </ul>
    pub fn index_status(&self) -> std::option::Option<&crate::model::IndexStatus> {
        self.index_status.as_ref()
    }
    /// <p>Indicates whether the index is currently backfilling. <i>Backfilling</i> is the process of reading items from the table and determining whether they can be added to the index. (Not all items will qualify: For example, a partition key cannot have any duplicate values.) If an item can be added to the index, DynamoDB will do so. After all items have been processed, the backfilling operation is complete and <code>Backfilling</code> is false.</p>
    /// <p>You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. </p> <note>
    /// <p>For indexes that were created during a <code>CreateTable</code> operation, the <code>Backfilling</code> attribute does not appear in the <code>DescribeTable</code> output.</p>
    /// </note>
    pub fn backfilling(&self) -> std::option::Option<bool> {
        self.backfilling
    }
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputDescription> {
        self.provisioned_throughput.as_ref()
    }
    /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn index_size_bytes(&self) -> i64 {
        self.index_size_bytes
    }
    /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn item_count(&self) -> i64 {
        self.item_count
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
    pub fn index_arn(&self) -> std::option::Option<&str> {
        self.index_arn.as_deref()
    }
}
impl std::fmt::Debug for GlobalSecondaryIndexDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSecondaryIndexDescription");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.field("index_status", &self.index_status);
        formatter.field("backfilling", &self.backfilling);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.field("index_size_bytes", &self.index_size_bytes);
        formatter.field("item_count", &self.item_count);
        formatter.field("index_arn", &self.index_arn);
        formatter.finish()
    }
}
/// See [`GlobalSecondaryIndexDescription`](crate::model::GlobalSecondaryIndexDescription)
pub mod global_secondary_index_description {
    /// A builder for [`GlobalSecondaryIndexDescription`](crate::model::GlobalSecondaryIndexDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
        pub(crate) index_status: std::option::Option<crate::model::IndexStatus>,
        pub(crate) backfilling: std::option::Option<bool>,
        pub(crate) provisioned_throughput:
            std::option::Option<crate::model::ProvisionedThroughputDescription>,
        pub(crate) index_size_bytes: std::option::Option<i64>,
        pub(crate) item_count: std::option::Option<i64>,
        pub(crate) index_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// <p>The current state of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul>
        pub fn index_status(mut self, input: crate::model::IndexStatus) -> Self {
            self.index_status = Some(input);
            self
        }
        /// <p>The current state of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The index is ready for use.</p> </li>
        /// </ul>
        pub fn set_index_status(
            mut self,
            input: std::option::Option<crate::model::IndexStatus>,
        ) -> Self {
            self.index_status = input;
            self
        }
        /// <p>Indicates whether the index is currently backfilling. <i>Backfilling</i> is the process of reading items from the table and determining whether they can be added to the index. (Not all items will qualify: For example, a partition key cannot have any duplicate values.) If an item can be added to the index, DynamoDB will do so. After all items have been processed, the backfilling operation is complete and <code>Backfilling</code> is false.</p>
        /// <p>You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. </p> <note>
        /// <p>For indexes that were created during a <code>CreateTable</code> operation, the <code>Backfilling</code> attribute does not appear in the <code>DescribeTable</code> output.</p>
        /// </note>
        pub fn backfilling(mut self, input: bool) -> Self {
            self.backfilling = Some(input);
            self
        }
        /// <p>Indicates whether the index is currently backfilling. <i>Backfilling</i> is the process of reading items from the table and determining whether they can be added to the index. (Not all items will qualify: For example, a partition key cannot have any duplicate values.) If an item can be added to the index, DynamoDB will do so. After all items have been processed, the backfilling operation is complete and <code>Backfilling</code> is false.</p>
        /// <p>You can delete an index that is being created during the <code>Backfilling</code> phase when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is true. You can't delete the index that is being created when <code>IndexStatus</code> is set to CREATING and <code>Backfilling</code> is false. </p> <note>
        /// <p>For indexes that were created during a <code>CreateTable</code> operation, the <code>Backfilling</code> attribute does not appear in the <code>DescribeTable</code> output.</p>
        /// </note>
        pub fn set_backfilling(mut self, input: std::option::Option<bool>) -> Self {
            self.backfilling = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughputDescription,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputDescription>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn index_size_bytes(mut self, input: i64) -> Self {
            self.index_size_bytes = Some(input);
            self
        }
        /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_index_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.index_size_bytes = input;
            self
        }
        /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn item_count(mut self, input: i64) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i64>) -> Self {
            self.item_count = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
        pub fn index_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
        pub fn set_index_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSecondaryIndexDescription`](crate::model::GlobalSecondaryIndexDescription)
        pub fn build(self) -> crate::model::GlobalSecondaryIndexDescription {
            crate::model::GlobalSecondaryIndexDescription {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
                index_status: self.index_status,
                backfilling: self.backfilling,
                provisioned_throughput: self.provisioned_throughput,
                index_size_bytes: self.index_size_bytes.unwrap_or_default(),
                item_count: self.item_count.unwrap_or_default(),
                index_arn: self.index_arn,
            }
        }
    }
}
impl GlobalSecondaryIndexDescription {
    /// Creates a new builder-style object to manufacture [`GlobalSecondaryIndexDescription`](crate::model::GlobalSecondaryIndexDescription)
    pub fn builder() -> crate::model::global_secondary_index_description::Builder {
        crate::model::global_secondary_index_description::Builder::default()
    }
}

/// <p>Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughputDescription {
    /// <p>The date and time of the last provisioned throughput increase for this table.</p>
    pub last_increase_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time of the last provisioned throughput decrease for this table.</p>
    pub last_decrease_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub number_of_decreases_today: std::option::Option<i64>,
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent <code>ReadCapacityUnits</code> per second.</p>
    pub read_capacity_units: std::option::Option<i64>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub write_capacity_units: std::option::Option<i64>,
}
impl ProvisionedThroughputDescription {
    /// <p>The date and time of the last provisioned throughput increase for this table.</p>
    pub fn last_increase_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_increase_date_time.as_ref()
    }
    /// <p>The date and time of the last provisioned throughput decrease for this table.</p>
    pub fn last_decrease_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_decrease_date_time.as_ref()
    }
    /// <p>The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn number_of_decreases_today(&self) -> std::option::Option<i64> {
        self.number_of_decreases_today
    }
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent <code>ReadCapacityUnits</code> per second.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<i64> {
        self.read_capacity_units
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<i64> {
        self.write_capacity_units
    }
}
impl std::fmt::Debug for ProvisionedThroughputDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughputDescription");
        formatter.field("last_increase_date_time", &self.last_increase_date_time);
        formatter.field("last_decrease_date_time", &self.last_decrease_date_time);
        formatter.field("number_of_decreases_today", &self.number_of_decreases_today);
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.finish()
    }
}
/// See [`ProvisionedThroughputDescription`](crate::model::ProvisionedThroughputDescription)
pub mod provisioned_throughput_description {
    /// A builder for [`ProvisionedThroughputDescription`](crate::model::ProvisionedThroughputDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_increase_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_decrease_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) number_of_decreases_today: std::option::Option<i64>,
        pub(crate) read_capacity_units: std::option::Option<i64>,
        pub(crate) write_capacity_units: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The date and time of the last provisioned throughput increase for this table.</p>
        pub fn last_increase_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_increase_date_time = Some(input);
            self
        }
        /// <p>The date and time of the last provisioned throughput increase for this table.</p>
        pub fn set_last_increase_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_increase_date_time = input;
            self
        }
        /// <p>The date and time of the last provisioned throughput decrease for this table.</p>
        pub fn last_decrease_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_decrease_date_time = Some(input);
            self
        }
        /// <p>The date and time of the last provisioned throughput decrease for this table.</p>
        pub fn set_last_decrease_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_decrease_date_time = input;
            self
        }
        /// <p>The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn number_of_decreases_today(mut self, input: i64) -> Self {
            self.number_of_decreases_today = Some(input);
            self
        }
        /// <p>The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_number_of_decreases_today(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_decreases_today = input;
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent <code>ReadCapacityUnits</code> per second.</p>
        pub fn read_capacity_units(mut self, input: i64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent <code>ReadCapacityUnits</code> per second.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn write_capacity_units(mut self, input: i64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughputDescription`](crate::model::ProvisionedThroughputDescription)
        pub fn build(self) -> crate::model::ProvisionedThroughputDescription {
            crate::model::ProvisionedThroughputDescription {
                last_increase_date_time: self.last_increase_date_time,
                last_decrease_date_time: self.last_decrease_date_time,
                number_of_decreases_today: self.number_of_decreases_today,
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
            }
        }
    }
}
impl ProvisionedThroughputDescription {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughputDescription`](crate::model::ProvisionedThroughputDescription)
    pub fn builder() -> crate::model::provisioned_throughput_description::Builder {
        crate::model::provisioned_throughput_description::Builder::default()
    }
}

/// <p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Projection {
    /// <p>The set of attributes that are projected into the index:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul>
    pub projection_type: std::option::Option<crate::model::ProjectionType>,
    /// <p>Represents the non-key attribute names which will be projected into the index.</p>
    /// <p>For local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the local secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
    pub non_key_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Projection {
    /// <p>The set of attributes that are projected into the index:</p>
    /// <ul>
    /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
    /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
    /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
    /// </ul>
    pub fn projection_type(&self) -> std::option::Option<&crate::model::ProjectionType> {
        self.projection_type.as_ref()
    }
    /// <p>Represents the non-key attribute names which will be projected into the index.</p>
    /// <p>For local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the local secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
    pub fn non_key_attributes(&self) -> std::option::Option<&[std::string::String]> {
        self.non_key_attributes.as_deref()
    }
}
impl std::fmt::Debug for Projection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Projection");
        formatter.field("projection_type", &self.projection_type);
        formatter.field("non_key_attributes", &self.non_key_attributes);
        formatter.finish()
    }
}
/// See [`Projection`](crate::model::Projection)
pub mod projection {
    /// A builder for [`Projection`](crate::model::Projection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projection_type: std::option::Option<crate::model::ProjectionType>,
        pub(crate) non_key_attributes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The set of attributes that are projected into the index:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul>
        pub fn projection_type(mut self, input: crate::model::ProjectionType) -> Self {
            self.projection_type = Some(input);
            self
        }
        /// <p>The set of attributes that are projected into the index:</p>
        /// <ul>
        /// <li> <p> <code>KEYS_ONLY</code> - Only the index and primary keys are projected into the index.</p> </li>
        /// <li> <p> <code>INCLUDE</code> - In addition to the attributes described in <code>KEYS_ONLY</code>, the secondary index will include other non-key attributes that you specify.</p> </li>
        /// <li> <p> <code>ALL</code> - All of the table attributes are projected into the index.</p> </li>
        /// </ul>
        pub fn set_projection_type(
            mut self,
            input: std::option::Option<crate::model::ProjectionType>,
        ) -> Self {
            self.projection_type = input;
            self
        }
        /// Appends an item to `non_key_attributes`.
        ///
        /// To override the contents of this collection use [`set_non_key_attributes`](Self::set_non_key_attributes).
        ///
        /// <p>Represents the non-key attribute names which will be projected into the index.</p>
        /// <p>For local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the local secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
        pub fn non_key_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.non_key_attributes.unwrap_or_default();
            v.push(input.into());
            self.non_key_attributes = Some(v);
            self
        }
        /// <p>Represents the non-key attribute names which will be projected into the index.</p>
        /// <p>For local secondary indexes, the total count of <code>NonKeyAttributes</code> summed across all of the local secondary indexes, must not exceed 20. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.</p>
        pub fn set_non_key_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.non_key_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Projection`](crate::model::Projection)
        pub fn build(self) -> crate::model::Projection {
            crate::model::Projection {
                projection_type: self.projection_type,
                non_key_attributes: self.non_key_attributes,
            }
        }
    }
}
impl Projection {
    /// Creates a new builder-style object to manufacture [`Projection`](crate::model::Projection)
    pub fn builder() -> crate::model::projection::Builder {
        crate::model::projection::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectionType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Include,
    #[allow(missing_docs)] // documentation missing in model
    KeysOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectionType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ProjectionType::All,
            "INCLUDE" => ProjectionType::Include,
            "KEYS_ONLY" => ProjectionType::KeysOnly,
            other => ProjectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectionType::from(s))
    }
}
impl ProjectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectionType::All => "ALL",
            ProjectionType::Include => "INCLUDE",
            ProjectionType::KeysOnly => "KEYS_ONLY",
            ProjectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "INCLUDE", "KEYS_ONLY"]
    }
}
impl AsRef<str> for ProjectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents <i>a single element</i> of a key schema. A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.</p>
/// <p>A <code>KeySchemaElement</code> represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one <code>KeySchemaElement</code> (for the partition key). A composite primary key would require one <code>KeySchemaElement</code> for the partition key, and another <code>KeySchemaElement</code> for the sort key.</p>
/// <p>A <code>KeySchemaElement</code> must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySchemaElement {
    /// <p>The name of a key attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The role that this key attribute will assume:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_type: std::option::Option<crate::model::KeyType>,
}
impl KeySchemaElement {
    /// <p>The name of a key attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The role that this key attribute will assume:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_type(&self) -> std::option::Option<&crate::model::KeyType> {
        self.key_type.as_ref()
    }
}
impl std::fmt::Debug for KeySchemaElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySchemaElement");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("key_type", &self.key_type);
        formatter.finish()
    }
}
/// See [`KeySchemaElement`](crate::model::KeySchemaElement)
pub mod key_schema_element {
    /// A builder for [`KeySchemaElement`](crate::model::KeySchemaElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
    }
    impl Builder {
        /// <p>The name of a key attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of a key attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The role that this key attribute will assume:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// <p>The role that this key attribute will assume:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySchemaElement`](crate::model::KeySchemaElement)
        pub fn build(self) -> crate::model::KeySchemaElement {
            crate::model::KeySchemaElement {
                attribute_name: self.attribute_name,
                key_type: self.key_type,
            }
        }
    }
}
impl KeySchemaElement {
    /// Creates a new builder-style object to manufacture [`KeySchemaElement`](crate::model::KeySchemaElement)
    pub fn builder() -> crate::model::key_schema_element::Builder {
        crate::model::key_schema_element::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyType {
    #[allow(missing_docs)] // documentation missing in model
    Hash,
    #[allow(missing_docs)] // documentation missing in model
    Range,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyType {
    fn from(s: &str) -> Self {
        match s {
            "HASH" => KeyType::Hash,
            "RANGE" => KeyType::Range,
            other => KeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyType::from(s))
    }
}
impl KeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyType::Hash => "HASH",
            KeyType::Range => "RANGE",
            KeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HASH", "RANGE"]
    }
}
impl AsRef<str> for KeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the properties of a local secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalSecondaryIndexDescription {
    /// <p>Represents the name of the local secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
    /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub index_size_bytes: i64,
    /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub item_count: i64,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
    pub index_arn: std::option::Option<std::string::String>,
}
impl LocalSecondaryIndexDescription {
    /// <p>Represents the name of the local secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
    /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn index_size_bytes(&self) -> i64 {
        self.index_size_bytes
    }
    /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
    pub fn item_count(&self) -> i64 {
        self.item_count
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
    pub fn index_arn(&self) -> std::option::Option<&str> {
        self.index_arn.as_deref()
    }
}
impl std::fmt::Debug for LocalSecondaryIndexDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalSecondaryIndexDescription");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.field("index_size_bytes", &self.index_size_bytes);
        formatter.field("item_count", &self.item_count);
        formatter.field("index_arn", &self.index_arn);
        formatter.finish()
    }
}
/// See [`LocalSecondaryIndexDescription`](crate::model::LocalSecondaryIndexDescription)
pub mod local_secondary_index_description {
    /// A builder for [`LocalSecondaryIndexDescription`](crate::model::LocalSecondaryIndexDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
        pub(crate) index_size_bytes: std::option::Option<i64>,
        pub(crate) item_count: std::option::Option<i64>,
        pub(crate) index_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Represents the name of the local secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>Represents the name of the local secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn index_size_bytes(mut self, input: i64) -> Self {
            self.index_size_bytes = Some(input);
            self
        }
        /// <p>The total size of the specified index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_index_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.index_size_bytes = input;
            self
        }
        /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn item_count(mut self, input: i64) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of items in the specified index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i64>) -> Self {
            self.item_count = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
        pub fn index_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the index.</p>
        pub fn set_index_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalSecondaryIndexDescription`](crate::model::LocalSecondaryIndexDescription)
        pub fn build(self) -> crate::model::LocalSecondaryIndexDescription {
            crate::model::LocalSecondaryIndexDescription {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
                index_size_bytes: self.index_size_bytes.unwrap_or_default(),
                item_count: self.item_count.unwrap_or_default(),
                index_arn: self.index_arn,
            }
        }
    }
}
impl LocalSecondaryIndexDescription {
    /// Creates a new builder-style object to manufacture [`LocalSecondaryIndexDescription`](crate::model::LocalSecondaryIndexDescription)
    pub fn builder() -> crate::model::local_secondary_index_description::Builder {
        crate::model::local_secondary_index_description::Builder::default()
    }
}

/// <p>Contains the details for the read/write capacity mode.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingModeSummary {
    /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
    /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
    /// </ul>
    pub billing_mode: std::option::Option<crate::model::BillingMode>,
    /// <p>Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.</p>
    pub last_update_to_pay_per_request_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BillingModeSummary {
    /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
    /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
    /// </ul>
    pub fn billing_mode(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode.as_ref()
    }
    /// <p>Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.</p>
    pub fn last_update_to_pay_per_request_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_to_pay_per_request_date_time.as_ref()
    }
}
impl std::fmt::Debug for BillingModeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingModeSummary");
        formatter.field("billing_mode", &self.billing_mode);
        formatter.field(
            "last_update_to_pay_per_request_date_time",
            &self.last_update_to_pay_per_request_date_time,
        );
        formatter.finish()
    }
}
/// See [`BillingModeSummary`](crate::model::BillingModeSummary)
pub mod billing_mode_summary {
    /// A builder for [`BillingModeSummary`](crate::model::BillingModeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) billing_mode: std::option::Option<crate::model::BillingMode>,
        pub(crate) last_update_to_pay_per_request_date_time:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode = Some(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode = input;
            self
        }
        /// <p>Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.</p>
        pub fn last_update_to_pay_per_request_date_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_update_to_pay_per_request_date_time = Some(input);
            self
        }
        /// <p>Represents the time when <code>PAY_PER_REQUEST</code> was last set as the read/write capacity mode.</p>
        pub fn set_last_update_to_pay_per_request_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_to_pay_per_request_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingModeSummary`](crate::model::BillingModeSummary)
        pub fn build(self) -> crate::model::BillingModeSummary {
            crate::model::BillingModeSummary {
                billing_mode: self.billing_mode,
                last_update_to_pay_per_request_date_time: self
                    .last_update_to_pay_per_request_date_time,
            }
        }
    }
}
impl BillingModeSummary {
    /// Creates a new builder-style object to manufacture [`BillingModeSummary`](crate::model::BillingModeSummary)
    pub fn builder() -> crate::model::billing_mode_summary::Builder {
        crate::model::billing_mode_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BillingMode {
    #[allow(missing_docs)] // documentation missing in model
    PayPerRequest,
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BillingMode {
    fn from(s: &str) -> Self {
        match s {
            "PAY_PER_REQUEST" => BillingMode::PayPerRequest,
            "PROVISIONED" => BillingMode::Provisioned,
            other => BillingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BillingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BillingMode::from(s))
    }
}
impl BillingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BillingMode::PayPerRequest => "PAY_PER_REQUEST",
            BillingMode::Provisioned => "PROVISIONED",
            BillingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PAY_PER_REQUEST", "PROVISIONED"]
    }
}
impl AsRef<str> for BillingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an attribute for describing the key schema for the table and indexes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeDefinition {
    /// <p>A name for the attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The data type for the attribute, where:</p>
    /// <ul>
    /// <li> <p> <code>S</code> - the attribute is of type String</p> </li>
    /// <li> <p> <code>N</code> - the attribute is of type Number</p> </li>
    /// <li> <p> <code>B</code> - the attribute is of type Binary</p> </li>
    /// </ul>
    pub attribute_type: std::option::Option<crate::model::ScalarAttributeType>,
}
impl AttributeDefinition {
    /// <p>A name for the attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The data type for the attribute, where:</p>
    /// <ul>
    /// <li> <p> <code>S</code> - the attribute is of type String</p> </li>
    /// <li> <p> <code>N</code> - the attribute is of type Number</p> </li>
    /// <li> <p> <code>B</code> - the attribute is of type Binary</p> </li>
    /// </ul>
    pub fn attribute_type(&self) -> std::option::Option<&crate::model::ScalarAttributeType> {
        self.attribute_type.as_ref()
    }
}
impl std::fmt::Debug for AttributeDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeDefinition");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_type", &self.attribute_type);
        formatter.finish()
    }
}
/// See [`AttributeDefinition`](crate::model::AttributeDefinition)
pub mod attribute_definition {
    /// A builder for [`AttributeDefinition`](crate::model::AttributeDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_type: std::option::Option<crate::model::ScalarAttributeType>,
    }
    impl Builder {
        /// <p>A name for the attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>A name for the attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The data type for the attribute, where:</p>
        /// <ul>
        /// <li> <p> <code>S</code> - the attribute is of type String</p> </li>
        /// <li> <p> <code>N</code> - the attribute is of type Number</p> </li>
        /// <li> <p> <code>B</code> - the attribute is of type Binary</p> </li>
        /// </ul>
        pub fn attribute_type(mut self, input: crate::model::ScalarAttributeType) -> Self {
            self.attribute_type = Some(input);
            self
        }
        /// <p>The data type for the attribute, where:</p>
        /// <ul>
        /// <li> <p> <code>S</code> - the attribute is of type String</p> </li>
        /// <li> <p> <code>N</code> - the attribute is of type Number</p> </li>
        /// <li> <p> <code>B</code> - the attribute is of type Binary</p> </li>
        /// </ul>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::ScalarAttributeType>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeDefinition`](crate::model::AttributeDefinition)
        pub fn build(self) -> crate::model::AttributeDefinition {
            crate::model::AttributeDefinition {
                attribute_name: self.attribute_name,
                attribute_type: self.attribute_type,
            }
        }
    }
}
impl AttributeDefinition {
    /// Creates a new builder-style object to manufacture [`AttributeDefinition`](crate::model::AttributeDefinition)
    pub fn builder() -> crate::model::attribute_definition::Builder {
        crate::model::attribute_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalarAttributeType {
    #[allow(missing_docs)] // documentation missing in model
    B,
    #[allow(missing_docs)] // documentation missing in model
    N,
    #[allow(missing_docs)] // documentation missing in model
    S,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalarAttributeType {
    fn from(s: &str) -> Self {
        match s {
            "B" => ScalarAttributeType::B,
            "N" => ScalarAttributeType::N,
            "S" => ScalarAttributeType::S,
            other => ScalarAttributeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalarAttributeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalarAttributeType::from(s))
    }
}
impl ScalarAttributeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalarAttributeType::B => "B",
            ScalarAttributeType::N => "N",
            ScalarAttributeType::S => "S",
            ScalarAttributeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["B", "N", "S"]
    }
}
impl AsRef<str> for ScalarAttributeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents one of the following:</p>
/// <ul>
/// <li> <p>A new replica to be added to an existing regional table or global table. This request invokes the <code>CreateTableReplica</code> action in the destination Region.</p> </li>
/// <li> <p>New parameters for an existing replica. This request invokes the <code>UpdateTable</code> action in the destination Region.</p> </li>
/// <li> <p>An existing replica to be deleted. The request invokes the <code>DeleteTableReplica</code> action in the destination Region, deleting the replica and all if its items in the destination Region.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationGroupUpdate {
    /// <p>The parameters required for creating a replica for the table.</p>
    pub create: std::option::Option<crate::model::CreateReplicationGroupMemberAction>,
    /// <p>The parameters required for updating a replica for the table.</p>
    pub update: std::option::Option<crate::model::UpdateReplicationGroupMemberAction>,
    /// <p>The parameters required for deleting a replica for the table.</p>
    pub delete: std::option::Option<crate::model::DeleteReplicationGroupMemberAction>,
}
impl ReplicationGroupUpdate {
    /// <p>The parameters required for creating a replica for the table.</p>
    pub fn create(&self) -> std::option::Option<&crate::model::CreateReplicationGroupMemberAction> {
        self.create.as_ref()
    }
    /// <p>The parameters required for updating a replica for the table.</p>
    pub fn update(&self) -> std::option::Option<&crate::model::UpdateReplicationGroupMemberAction> {
        self.update.as_ref()
    }
    /// <p>The parameters required for deleting a replica for the table.</p>
    pub fn delete(&self) -> std::option::Option<&crate::model::DeleteReplicationGroupMemberAction> {
        self.delete.as_ref()
    }
}
impl std::fmt::Debug for ReplicationGroupUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationGroupUpdate");
        formatter.field("create", &self.create);
        formatter.field("update", &self.update);
        formatter.field("delete", &self.delete);
        formatter.finish()
    }
}
/// See [`ReplicationGroupUpdate`](crate::model::ReplicationGroupUpdate)
pub mod replication_group_update {
    /// A builder for [`ReplicationGroupUpdate`](crate::model::ReplicationGroupUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create: std::option::Option<crate::model::CreateReplicationGroupMemberAction>,
        pub(crate) update: std::option::Option<crate::model::UpdateReplicationGroupMemberAction>,
        pub(crate) delete: std::option::Option<crate::model::DeleteReplicationGroupMemberAction>,
    }
    impl Builder {
        /// <p>The parameters required for creating a replica for the table.</p>
        pub fn create(mut self, input: crate::model::CreateReplicationGroupMemberAction) -> Self {
            self.create = Some(input);
            self
        }
        /// <p>The parameters required for creating a replica for the table.</p>
        pub fn set_create(
            mut self,
            input: std::option::Option<crate::model::CreateReplicationGroupMemberAction>,
        ) -> Self {
            self.create = input;
            self
        }
        /// <p>The parameters required for updating a replica for the table.</p>
        pub fn update(mut self, input: crate::model::UpdateReplicationGroupMemberAction) -> Self {
            self.update = Some(input);
            self
        }
        /// <p>The parameters required for updating a replica for the table.</p>
        pub fn set_update(
            mut self,
            input: std::option::Option<crate::model::UpdateReplicationGroupMemberAction>,
        ) -> Self {
            self.update = input;
            self
        }
        /// <p>The parameters required for deleting a replica for the table.</p>
        pub fn delete(mut self, input: crate::model::DeleteReplicationGroupMemberAction) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>The parameters required for deleting a replica for the table.</p>
        pub fn set_delete(
            mut self,
            input: std::option::Option<crate::model::DeleteReplicationGroupMemberAction>,
        ) -> Self {
            self.delete = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationGroupUpdate`](crate::model::ReplicationGroupUpdate)
        pub fn build(self) -> crate::model::ReplicationGroupUpdate {
            crate::model::ReplicationGroupUpdate {
                create: self.create,
                update: self.update,
                delete: self.delete,
            }
        }
    }
}
impl ReplicationGroupUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicationGroupUpdate`](crate::model::ReplicationGroupUpdate)
    pub fn builder() -> crate::model::replication_group_update::Builder {
        crate::model::replication_group_update::Builder::default()
    }
}

/// <p>Represents a replica to be deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationGroupMemberAction {
    /// <p>The Region where the replica exists.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl DeleteReplicationGroupMemberAction {
    /// <p>The Region where the replica exists.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReplicationGroupMemberAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationGroupMemberAction");
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`DeleteReplicationGroupMemberAction`](crate::model::DeleteReplicationGroupMemberAction)
pub mod delete_replication_group_member_action {
    /// A builder for [`DeleteReplicationGroupMemberAction`](crate::model::DeleteReplicationGroupMemberAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Region where the replica exists.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the replica exists.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationGroupMemberAction`](crate::model::DeleteReplicationGroupMemberAction)
        pub fn build(self) -> crate::model::DeleteReplicationGroupMemberAction {
            crate::model::DeleteReplicationGroupMemberAction {
                region_name: self.region_name,
            }
        }
    }
}
impl DeleteReplicationGroupMemberAction {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationGroupMemberAction`](crate::model::DeleteReplicationGroupMemberAction)
    pub fn builder() -> crate::model::delete_replication_group_member_action::Builder {
        crate::model::delete_replication_group_member_action::Builder::default()
    }
}

/// <p>Represents a replica to be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReplicationGroupMemberAction {
    /// <p>The Region where the replica exists.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
    /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
    pub provisioned_throughput_override:
        std::option::Option<crate::model::ProvisionedThroughputOverride>,
    /// <p>Replica-specific global secondary index settings.</p>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub table_class_override: std::option::Option<crate::model::TableClass>,
}
impl UpdateReplicationGroupMemberAction {
    /// <p>The Region where the replica exists.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
    /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputOverride> {
        self.provisioned_throughput_override.as_ref()
    }
    /// <p>Replica-specific global secondary index settings.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndex]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub fn table_class_override(&self) -> std::option::Option<&crate::model::TableClass> {
        self.table_class_override.as_ref()
    }
}
impl std::fmt::Debug for UpdateReplicationGroupMemberAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReplicationGroupMemberAction");
        formatter.field("region_name", &self.region_name);
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field("table_class_override", &self.table_class_override);
        formatter.finish()
    }
}
/// See [`UpdateReplicationGroupMemberAction`](crate::model::UpdateReplicationGroupMemberAction)
pub mod update_replication_group_member_action {
    /// A builder for [`UpdateReplicationGroupMemberAction`](crate::model::UpdateReplicationGroupMemberAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughputOverride>,
        pub(crate) global_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
        pub(crate) table_class_override: std::option::Option<crate::model::TableClass>,
    }
    impl Builder {
        /// <p>The Region where the replica exists.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the replica exists.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key of the replica that should be used for KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughputOverride,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputOverride>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndex,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn table_class_override(mut self, input: crate::model::TableClass) -> Self {
            self.table_class_override = Some(input);
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn set_table_class_override(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.table_class_override = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReplicationGroupMemberAction`](crate::model::UpdateReplicationGroupMemberAction)
        pub fn build(self) -> crate::model::UpdateReplicationGroupMemberAction {
            crate::model::UpdateReplicationGroupMemberAction {
                region_name: self.region_name,
                kms_master_key_id: self.kms_master_key_id,
                provisioned_throughput_override: self.provisioned_throughput_override,
                global_secondary_indexes: self.global_secondary_indexes,
                table_class_override: self.table_class_override,
            }
        }
    }
}
impl UpdateReplicationGroupMemberAction {
    /// Creates a new builder-style object to manufacture [`UpdateReplicationGroupMemberAction`](crate::model::UpdateReplicationGroupMemberAction)
    pub fn builder() -> crate::model::update_replication_group_member_action::Builder {
        crate::model::update_replication_group_member_action::Builder::default()
    }
}

/// <p>Represents the properties of a replica global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndex {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read capacity settings.</p>
    pub provisioned_throughput_override:
        std::option::Option<crate::model::ProvisionedThroughputOverride>,
}
impl ReplicaGlobalSecondaryIndex {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read capacity settings.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputOverride> {
        self.provisioned_throughput_override.as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndex");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndex`](crate::model::ReplicaGlobalSecondaryIndex)
pub mod replica_global_secondary_index {
    /// A builder for [`ReplicaGlobalSecondaryIndex`](crate::model::ReplicaGlobalSecondaryIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughputOverride>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read capacity settings.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughputOverride,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read capacity settings.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputOverride>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndex`](crate::model::ReplicaGlobalSecondaryIndex)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndex {
            crate::model::ReplicaGlobalSecondaryIndex {
                index_name: self.index_name,
                provisioned_throughput_override: self.provisioned_throughput_override,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndex {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndex`](crate::model::ReplicaGlobalSecondaryIndex)
    pub fn builder() -> crate::model::replica_global_secondary_index::Builder {
        crate::model::replica_global_secondary_index::Builder::default()
    }
}

/// <p>Represents a replica to be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationGroupMemberAction {
    /// <p>The Region where the new replica will be created.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The KMS key that should be used for KMS encryption in the new replica. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
    /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
    pub provisioned_throughput_override:
        std::option::Option<crate::model::ProvisionedThroughputOverride>,
    /// <p>Replica-specific global secondary index settings.</p>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub table_class_override: std::option::Option<crate::model::TableClass>,
}
impl CreateReplicationGroupMemberAction {
    /// <p>The Region where the new replica will be created.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The KMS key that should be used for KMS encryption in the new replica. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
    /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughputOverride> {
        self.provisioned_throughput_override.as_ref()
    }
    /// <p>Replica-specific global secondary index settings.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndex]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub fn table_class_override(&self) -> std::option::Option<&crate::model::TableClass> {
        self.table_class_override.as_ref()
    }
}
impl std::fmt::Debug for CreateReplicationGroupMemberAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationGroupMemberAction");
        formatter.field("region_name", &self.region_name);
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field("table_class_override", &self.table_class_override);
        formatter.finish()
    }
}
/// See [`CreateReplicationGroupMemberAction`](crate::model::CreateReplicationGroupMemberAction)
pub mod create_replication_group_member_action {
    /// A builder for [`CreateReplicationGroupMemberAction`](crate::model::CreateReplicationGroupMemberAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughputOverride>,
        pub(crate) global_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
        pub(crate) table_class_override: std::option::Option<crate::model::TableClass>,
    }
    impl Builder {
        /// <p>The Region where the new replica will be created.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the new replica will be created.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The KMS key that should be used for KMS encryption in the new replica. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key that should be used for KMS encryption in the new replica. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB KMS key <code>alias/aws/dynamodb</code>.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughputOverride,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Replica-specific provisioned throughput. If not specified, uses the source table's provisioned throughput settings.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughputOverride>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndex,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>Replica-specific global secondary index settings.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndex>>,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn table_class_override(mut self, input: crate::model::TableClass) -> Self {
            self.table_class_override = Some(input);
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn set_table_class_override(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.table_class_override = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationGroupMemberAction`](crate::model::CreateReplicationGroupMemberAction)
        pub fn build(self) -> crate::model::CreateReplicationGroupMemberAction {
            crate::model::CreateReplicationGroupMemberAction {
                region_name: self.region_name,
                kms_master_key_id: self.kms_master_key_id,
                provisioned_throughput_override: self.provisioned_throughput_override,
                global_secondary_indexes: self.global_secondary_indexes,
                table_class_override: self.table_class_override,
            }
        }
    }
}
impl CreateReplicationGroupMemberAction {
    /// Creates a new builder-style object to manufacture [`CreateReplicationGroupMemberAction`](crate::model::CreateReplicationGroupMemberAction)
    pub fn builder() -> crate::model::create_replication_group_member_action::Builder {
        crate::model::create_replication_group_member_action::Builder::default()
    }
}

/// <p>Represents the settings used to enable server-side encryption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseSpecification {
    /// <p>Indicates whether server-side encryption is done using an Amazon Web Services managed key or an Amazon Web Services owned key. If enabled (true), server-side encryption type is set to <code>KMS</code> and an Amazon Web Services managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to Amazon Web Services owned key.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>Server-side encryption type. The only supported value is:</p>
    /// <ul>
    /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
    /// </ul>
    pub sse_type: std::option::Option<crate::model::SseType>,
    /// <p>The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code>.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
}
impl SseSpecification {
    /// <p>Indicates whether server-side encryption is done using an Amazon Web Services managed key or an Amazon Web Services owned key. If enabled (true), server-side encryption type is set to <code>KMS</code> and an Amazon Web Services managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to Amazon Web Services owned key.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>Server-side encryption type. The only supported value is:</p>
    /// <ul>
    /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
    /// </ul>
    pub fn sse_type(&self) -> std::option::Option<&crate::model::SseType> {
        self.sse_type.as_ref()
    }
    /// <p>The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code>.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
}
impl std::fmt::Debug for SseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseSpecification");
        formatter.field("enabled", &self.enabled);
        formatter.field("sse_type", &self.sse_type);
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.finish()
    }
}
/// See [`SseSpecification`](crate::model::SseSpecification)
pub mod sse_specification {
    /// A builder for [`SseSpecification`](crate::model::SseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) sse_type: std::option::Option<crate::model::SseType>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether server-side encryption is done using an Amazon Web Services managed key or an Amazon Web Services owned key. If enabled (true), server-side encryption type is set to <code>KMS</code> and an Amazon Web Services managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to Amazon Web Services owned key.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether server-side encryption is done using an Amazon Web Services managed key or an Amazon Web Services owned key. If enabled (true), server-side encryption type is set to <code>KMS</code> and an Amazon Web Services managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to Amazon Web Services owned key.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Server-side encryption type. The only supported value is:</p>
        /// <ul>
        /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
        /// </ul>
        pub fn sse_type(mut self, input: crate::model::SseType) -> Self {
            self.sse_type = Some(input);
            self
        }
        /// <p>Server-side encryption type. The only supported value is:</p>
        /// <ul>
        /// <li> <p> <code>KMS</code> - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).</p> </li>
        /// </ul>
        pub fn set_sse_type(mut self, input: std::option::Option<crate::model::SseType>) -> Self {
            self.sse_type = input;
            self
        }
        /// <p>The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code>.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key <code>alias/aws/dynamodb</code>.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SseSpecification`](crate::model::SseSpecification)
        pub fn build(self) -> crate::model::SseSpecification {
            crate::model::SseSpecification {
                enabled: self.enabled,
                sse_type: self.sse_type,
                kms_master_key_id: self.kms_master_key_id,
            }
        }
    }
}
impl SseSpecification {
    /// Creates a new builder-style object to manufacture [`SseSpecification`](crate::model::SseSpecification)
    pub fn builder() -> crate::model::sse_specification::Builder {
        crate::model::sse_specification::Builder::default()
    }
}

/// <p>Represents one of the following:</p>
/// <ul>
/// <li> <p>A new global secondary index to be added to an existing table.</p> </li>
/// <li> <p>New provisioned throughput parameters for an existing global secondary index.</p> </li>
/// <li> <p>An existing global secondary index to be removed from an existing table.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSecondaryIndexUpdate {
    /// <p>The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.</p>
    pub update: std::option::Option<crate::model::UpdateGlobalSecondaryIndexAction>,
    /// <p>The parameters required for creating a global secondary index on an existing table:</p>
    /// <ul>
    /// <li> <p> <code>IndexName </code> </p> </li>
    /// <li> <p> <code>KeySchema </code> </p> </li>
    /// <li> <p> <code>AttributeDefinitions </code> </p> </li>
    /// <li> <p> <code>Projection </code> </p> </li>
    /// <li> <p> <code>ProvisionedThroughput </code> </p> </li>
    /// </ul>
    pub create: std::option::Option<crate::model::CreateGlobalSecondaryIndexAction>,
    /// <p>The name of an existing global secondary index to be removed.</p>
    pub delete: std::option::Option<crate::model::DeleteGlobalSecondaryIndexAction>,
}
impl GlobalSecondaryIndexUpdate {
    /// <p>The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.</p>
    pub fn update(&self) -> std::option::Option<&crate::model::UpdateGlobalSecondaryIndexAction> {
        self.update.as_ref()
    }
    /// <p>The parameters required for creating a global secondary index on an existing table:</p>
    /// <ul>
    /// <li> <p> <code>IndexName </code> </p> </li>
    /// <li> <p> <code>KeySchema </code> </p> </li>
    /// <li> <p> <code>AttributeDefinitions </code> </p> </li>
    /// <li> <p> <code>Projection </code> </p> </li>
    /// <li> <p> <code>ProvisionedThroughput </code> </p> </li>
    /// </ul>
    pub fn create(&self) -> std::option::Option<&crate::model::CreateGlobalSecondaryIndexAction> {
        self.create.as_ref()
    }
    /// <p>The name of an existing global secondary index to be removed.</p>
    pub fn delete(&self) -> std::option::Option<&crate::model::DeleteGlobalSecondaryIndexAction> {
        self.delete.as_ref()
    }
}
impl std::fmt::Debug for GlobalSecondaryIndexUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSecondaryIndexUpdate");
        formatter.field("update", &self.update);
        formatter.field("create", &self.create);
        formatter.field("delete", &self.delete);
        formatter.finish()
    }
}
/// See [`GlobalSecondaryIndexUpdate`](crate::model::GlobalSecondaryIndexUpdate)
pub mod global_secondary_index_update {
    /// A builder for [`GlobalSecondaryIndexUpdate`](crate::model::GlobalSecondaryIndexUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update: std::option::Option<crate::model::UpdateGlobalSecondaryIndexAction>,
        pub(crate) create: std::option::Option<crate::model::CreateGlobalSecondaryIndexAction>,
        pub(crate) delete: std::option::Option<crate::model::DeleteGlobalSecondaryIndexAction>,
    }
    impl Builder {
        /// <p>The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.</p>
        pub fn update(mut self, input: crate::model::UpdateGlobalSecondaryIndexAction) -> Self {
            self.update = Some(input);
            self
        }
        /// <p>The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.</p>
        pub fn set_update(
            mut self,
            input: std::option::Option<crate::model::UpdateGlobalSecondaryIndexAction>,
        ) -> Self {
            self.update = input;
            self
        }
        /// <p>The parameters required for creating a global secondary index on an existing table:</p>
        /// <ul>
        /// <li> <p> <code>IndexName </code> </p> </li>
        /// <li> <p> <code>KeySchema </code> </p> </li>
        /// <li> <p> <code>AttributeDefinitions </code> </p> </li>
        /// <li> <p> <code>Projection </code> </p> </li>
        /// <li> <p> <code>ProvisionedThroughput </code> </p> </li>
        /// </ul>
        pub fn create(mut self, input: crate::model::CreateGlobalSecondaryIndexAction) -> Self {
            self.create = Some(input);
            self
        }
        /// <p>The parameters required for creating a global secondary index on an existing table:</p>
        /// <ul>
        /// <li> <p> <code>IndexName </code> </p> </li>
        /// <li> <p> <code>KeySchema </code> </p> </li>
        /// <li> <p> <code>AttributeDefinitions </code> </p> </li>
        /// <li> <p> <code>Projection </code> </p> </li>
        /// <li> <p> <code>ProvisionedThroughput </code> </p> </li>
        /// </ul>
        pub fn set_create(
            mut self,
            input: std::option::Option<crate::model::CreateGlobalSecondaryIndexAction>,
        ) -> Self {
            self.create = input;
            self
        }
        /// <p>The name of an existing global secondary index to be removed.</p>
        pub fn delete(mut self, input: crate::model::DeleteGlobalSecondaryIndexAction) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>The name of an existing global secondary index to be removed.</p>
        pub fn set_delete(
            mut self,
            input: std::option::Option<crate::model::DeleteGlobalSecondaryIndexAction>,
        ) -> Self {
            self.delete = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSecondaryIndexUpdate`](crate::model::GlobalSecondaryIndexUpdate)
        pub fn build(self) -> crate::model::GlobalSecondaryIndexUpdate {
            crate::model::GlobalSecondaryIndexUpdate {
                update: self.update,
                create: self.create,
                delete: self.delete,
            }
        }
    }
}
impl GlobalSecondaryIndexUpdate {
    /// Creates a new builder-style object to manufacture [`GlobalSecondaryIndexUpdate`](crate::model::GlobalSecondaryIndexUpdate)
    pub fn builder() -> crate::model::global_secondary_index_update::Builder {
        crate::model::global_secondary_index_update::Builder::default()
    }
}

/// <p>Represents a global secondary index to be deleted from an existing table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be deleted.</p>
    pub index_name: std::option::Option<std::string::String>,
}
impl DeleteGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be deleted.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteGlobalSecondaryIndexAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalSecondaryIndexAction");
        formatter.field("index_name", &self.index_name);
        formatter.finish()
    }
}
/// See [`DeleteGlobalSecondaryIndexAction`](crate::model::DeleteGlobalSecondaryIndexAction)
pub mod delete_global_secondary_index_action {
    /// A builder for [`DeleteGlobalSecondaryIndexAction`](crate::model::DeleteGlobalSecondaryIndexAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the global secondary index to be deleted.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index to be deleted.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalSecondaryIndexAction`](crate::model::DeleteGlobalSecondaryIndexAction)
        pub fn build(self) -> crate::model::DeleteGlobalSecondaryIndexAction {
            crate::model::DeleteGlobalSecondaryIndexAction {
                index_name: self.index_name,
            }
        }
    }
}
impl DeleteGlobalSecondaryIndexAction {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalSecondaryIndexAction`](crate::model::DeleteGlobalSecondaryIndexAction)
    pub fn builder() -> crate::model::delete_global_secondary_index_action::Builder {
        crate::model::delete_global_secondary_index_action::Builder::default()
    }
}

/// <p>Represents a new global secondary index to be added to an existing table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be created.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The key schema for the global secondary index.</p>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>
    pub projection: std::option::Option<crate::model::Projection>,
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
}
impl CreateGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be created.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The key schema for the global secondary index.</p>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
}
impl std::fmt::Debug for CreateGlobalSecondaryIndexAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalSecondaryIndexAction");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.finish()
    }
}
/// See [`CreateGlobalSecondaryIndexAction`](crate::model::CreateGlobalSecondaryIndexAction)
pub mod create_global_secondary_index_action {
    /// A builder for [`CreateGlobalSecondaryIndexAction`](crate::model::CreateGlobalSecondaryIndexAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    }
    impl Builder {
        /// <p>The name of the global secondary index to be created.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index to be created.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The key schema for the global secondary index.</p>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The key schema for the global secondary index.</p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.</p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalSecondaryIndexAction`](crate::model::CreateGlobalSecondaryIndexAction)
        pub fn build(self) -> crate::model::CreateGlobalSecondaryIndexAction {
            crate::model::CreateGlobalSecondaryIndexAction {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
                provisioned_throughput: self.provisioned_throughput,
            }
        }
    }
}
impl CreateGlobalSecondaryIndexAction {
    /// Creates a new builder-style object to manufacture [`CreateGlobalSecondaryIndexAction`](crate::model::CreateGlobalSecondaryIndexAction)
    pub fn builder() -> crate::model::create_global_secondary_index_action::Builder {
        crate::model::create_global_secondary_index_action::Builder::default()
    }
}

/// <p>Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the <code>UpdateTable</code> operation.</p>
/// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedThroughput {
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
    pub read_capacity_units: std::option::Option<i64>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
    pub write_capacity_units: std::option::Option<i64>,
}
impl ProvisionedThroughput {
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<i64> {
        self.read_capacity_units
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<i64> {
        self.write_capacity_units
    }
}
impl std::fmt::Debug for ProvisionedThroughput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedThroughput");
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.finish()
    }
}
/// See [`ProvisionedThroughput`](crate::model::ProvisionedThroughput)
pub mod provisioned_throughput {
    /// A builder for [`ProvisionedThroughput`](crate::model::ProvisionedThroughput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_capacity_units: std::option::Option<i64>,
        pub(crate) write_capacity_units: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
        pub fn read_capacity_units(mut self, input: i64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
        pub fn write_capacity_units(mut self, input: i64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<i64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedThroughput`](crate::model::ProvisionedThroughput)
        pub fn build(self) -> crate::model::ProvisionedThroughput {
            crate::model::ProvisionedThroughput {
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
            }
        }
    }
}
impl ProvisionedThroughput {
    /// Creates a new builder-style object to manufacture [`ProvisionedThroughput`](crate::model::ProvisionedThroughput)
    pub fn builder() -> crate::model::provisioned_throughput::Builder {
        crate::model::provisioned_throughput::Builder::default()
    }
}

/// <p>Represents the new provisioned throughput settings to be applied to a global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be updated.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
}
impl UpdateGlobalSecondaryIndexAction {
    /// <p>The name of the global secondary index to be updated.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
}
impl std::fmt::Debug for UpdateGlobalSecondaryIndexAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalSecondaryIndexAction");
        formatter.field("index_name", &self.index_name);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.finish()
    }
}
/// See [`UpdateGlobalSecondaryIndexAction`](crate::model::UpdateGlobalSecondaryIndexAction)
pub mod update_global_secondary_index_action {
    /// A builder for [`UpdateGlobalSecondaryIndexAction`](crate::model::UpdateGlobalSecondaryIndexAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    }
    impl Builder {
        /// <p>The name of the global secondary index to be updated.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index to be updated.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalSecondaryIndexAction`](crate::model::UpdateGlobalSecondaryIndexAction)
        pub fn build(self) -> crate::model::UpdateGlobalSecondaryIndexAction {
            crate::model::UpdateGlobalSecondaryIndexAction {
                index_name: self.index_name,
                provisioned_throughput: self.provisioned_throughput,
            }
        }
    }
}
impl UpdateGlobalSecondaryIndexAction {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalSecondaryIndexAction`](crate::model::UpdateGlobalSecondaryIndexAction)
    pub fn builder() -> crate::model::update_global_secondary_index_action::Builder {
        crate::model::update_global_secondary_index_action::Builder::default()
    }
}

/// <p>Information about item collections, if any, that were affected by the operation. <code>ItemCollectionMetrics</code> is only returned if the request asked for it. If the table does not have any local secondary indexes, this information is not returned in the response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemCollectionMetrics {
    /// <p>The partition key value of the item collection. This value is the same as the partition key value of the item.</p>
    pub item_collection_key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p>
    pub size_estimate_range_gb: std::option::Option<std::vec::Vec<f64>>,
}
impl ItemCollectionMetrics {
    /// <p>The partition key value of the item collection. This value is the same as the partition key value of the item.</p>
    pub fn item_collection_key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item_collection_key.as_ref()
    }
    /// <p>An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p>
    pub fn size_estimate_range_gb(&self) -> std::option::Option<&[f64]> {
        self.size_estimate_range_gb.as_deref()
    }
}
impl std::fmt::Debug for ItemCollectionMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemCollectionMetrics");
        formatter.field("item_collection_key", &self.item_collection_key);
        formatter.field("size_estimate_range_gb", &self.size_estimate_range_gb);
        formatter.finish()
    }
}
/// See [`ItemCollectionMetrics`](crate::model::ItemCollectionMetrics)
pub mod item_collection_metrics {
    /// A builder for [`ItemCollectionMetrics`](crate::model::ItemCollectionMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item_collection_key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) size_estimate_range_gb: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// Adds a key-value pair to `item_collection_key`.
        ///
        /// To override the contents of this collection use [`set_item_collection_key`](Self::set_item_collection_key).
        ///
        /// <p>The partition key value of the item collection. This value is the same as the partition key value of the item.</p>
        pub fn item_collection_key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item_collection_key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item_collection_key = Some(hash_map);
            self
        }
        /// <p>The partition key value of the item collection. This value is the same as the partition key value of the item.</p>
        pub fn set_item_collection_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item_collection_key = input;
            self
        }
        /// Appends an item to `size_estimate_range_gb`.
        ///
        /// To override the contents of this collection use [`set_size_estimate_range_gb`](Self::set_size_estimate_range_gb).
        ///
        /// <p>An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p>
        pub fn size_estimate_range_gb(mut self, input: f64) -> Self {
            let mut v = self.size_estimate_range_gb.unwrap_or_default();
            v.push(input);
            self.size_estimate_range_gb = Some(v);
            self
        }
        /// <p>An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.</p>
        pub fn set_size_estimate_range_gb(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.size_estimate_range_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemCollectionMetrics`](crate::model::ItemCollectionMetrics)
        pub fn build(self) -> crate::model::ItemCollectionMetrics {
            crate::model::ItemCollectionMetrics {
                item_collection_key: self.item_collection_key,
                size_estimate_range_gb: self.size_estimate_range_gb,
            }
        }
    }
}
impl ItemCollectionMetrics {
    /// Creates a new builder-style object to manufacture [`ItemCollectionMetrics`](crate::model::ItemCollectionMetrics)
    pub fn builder() -> crate::model::item_collection_metrics::Builder {
        crate::model::item_collection_metrics::Builder::default()
    }
}

/// <p>Represents the data for an attribute.</p>
/// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AttributeValue {
    /// <p>An attribute of type Binary. For example:</p>
    /// <p> <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code> </p>
    B(aws_smithy_types::Blob),
    /// <p>An attribute of type Boolean. For example:</p>
    /// <p> <code>"BOOL": true</code> </p>
    Bool(bool),
    /// <p>An attribute of type Binary Set. For example:</p>
    /// <p> <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code> </p>
    Bs(std::vec::Vec<aws_smithy_types::Blob>),
    /// <p>An attribute of type List. For example:</p>
    /// <p> <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code> </p>
    L(std::vec::Vec<crate::model::AttributeValue>),
    /// <p>An attribute of type Map. For example:</p>
    /// <p> <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code> </p>
    M(std::collections::HashMap<std::string::String, crate::model::AttributeValue>),
    /// <p>An attribute of type Number. For example:</p>
    /// <p> <code>"N": "123.45"</code> </p>
    /// <p>Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.</p>
    N(std::string::String),
    /// <p>An attribute of type Number Set. For example:</p>
    /// <p> <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code> </p>
    /// <p>Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.</p>
    Ns(std::vec::Vec<std::string::String>),
    /// <p>An attribute of type Null. For example:</p>
    /// <p> <code>"NULL": true</code> </p>
    Null(bool),
    /// <p>An attribute of type String. For example:</p>
    /// <p> <code>"S": "Hello"</code> </p>
    S(std::string::String),
    /// <p>An attribute of type String Set. For example:</p>
    /// <p> <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code> </p>
    Ss(std::vec::Vec<std::string::String>),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AttributeValue {
    /// Tries to convert the enum instance into [`B`](crate::model::AttributeValue::B), extracting the inner [`Blob`](aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_b(&self) -> std::result::Result<&aws_smithy_types::Blob, &Self> {
        if let AttributeValue::B(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`B`](crate::model::AttributeValue::B).
    pub fn is_b(&self) -> bool {
        self.as_b().is_ok()
    }
    /// Tries to convert the enum instance into [`Bool`](crate::model::AttributeValue::Bool), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bool(&self) -> std::result::Result<&bool, &Self> {
        if let AttributeValue::Bool(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Bool`](crate::model::AttributeValue::Bool).
    pub fn is_bool(&self) -> bool {
        self.as_bool().is_ok()
    }
    /// Tries to convert the enum instance into [`Bs`](crate::model::AttributeValue::Bs), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bs(&self) -> std::result::Result<&std::vec::Vec<aws_smithy_types::Blob>, &Self> {
        if let AttributeValue::Bs(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Bs`](crate::model::AttributeValue::Bs).
    pub fn is_bs(&self) -> bool {
        self.as_bs().is_ok()
    }
    /// Tries to convert the enum instance into [`L`](crate::model::AttributeValue::L), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_l(&self) -> std::result::Result<&std::vec::Vec<crate::model::AttributeValue>, &Self> {
        if let AttributeValue::L(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`L`](crate::model::AttributeValue::L).
    pub fn is_l(&self) -> bool {
        self.as_l().is_ok()
    }
    /// Tries to convert the enum instance into [`M`](crate::model::AttributeValue::M), extracting the inner [`HashMap`](std::collections::HashMap).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_m(
        &self,
    ) -> std::result::Result<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        &Self,
    > {
        if let AttributeValue::M(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`M`](crate::model::AttributeValue::M).
    pub fn is_m(&self) -> bool {
        self.as_m().is_ok()
    }
    /// Tries to convert the enum instance into [`N`](crate::model::AttributeValue::N), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_n(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AttributeValue::N(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`N`](crate::model::AttributeValue::N).
    pub fn is_n(&self) -> bool {
        self.as_n().is_ok()
    }
    /// Tries to convert the enum instance into [`Ns`](crate::model::AttributeValue::Ns), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ns(&self) -> std::result::Result<&std::vec::Vec<std::string::String>, &Self> {
        if let AttributeValue::Ns(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Ns`](crate::model::AttributeValue::Ns).
    pub fn is_ns(&self) -> bool {
        self.as_ns().is_ok()
    }
    /// Tries to convert the enum instance into [`Null`](crate::model::AttributeValue::Null), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_null(&self) -> std::result::Result<&bool, &Self> {
        if let AttributeValue::Null(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Null`](crate::model::AttributeValue::Null).
    pub fn is_null(&self) -> bool {
        self.as_null().is_ok()
    }
    /// Tries to convert the enum instance into [`S`](crate::model::AttributeValue::S), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AttributeValue::S(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`S`](crate::model::AttributeValue::S).
    pub fn is_s(&self) -> bool {
        self.as_s().is_ok()
    }
    /// Tries to convert the enum instance into [`Ss`](crate::model::AttributeValue::Ss), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_ss(&self) -> std::result::Result<&std::vec::Vec<std::string::String>, &Self> {
        if let AttributeValue::Ss(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Ss`](crate::model::AttributeValue::Ss).
    pub fn is_ss(&self) -> bool {
        self.as_ss().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is only returned if the request asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConsumedCapacity {
    /// <p>The name of the table that was affected by the operation.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The total number of capacity units consumed by the operation.</p>
    pub capacity_units: std::option::Option<f64>,
    /// <p>The total number of read capacity units consumed by the operation.</p>
    pub read_capacity_units: std::option::Option<f64>,
    /// <p>The total number of write capacity units consumed by the operation.</p>
    pub write_capacity_units: std::option::Option<f64>,
    /// <p>The amount of throughput consumed on the table affected by the operation.</p>
    pub table: std::option::Option<crate::model::Capacity>,
    /// <p>The amount of throughput consumed on each local index affected by the operation.</p>
    pub local_secondary_indexes:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Capacity>>,
    /// <p>The amount of throughput consumed on each global index affected by the operation.</p>
    pub global_secondary_indexes:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Capacity>>,
}
impl ConsumedCapacity {
    /// <p>The name of the table that was affected by the operation.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The total number of capacity units consumed by the operation.</p>
    pub fn capacity_units(&self) -> std::option::Option<f64> {
        self.capacity_units
    }
    /// <p>The total number of read capacity units consumed by the operation.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<f64> {
        self.read_capacity_units
    }
    /// <p>The total number of write capacity units consumed by the operation.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<f64> {
        self.write_capacity_units
    }
    /// <p>The amount of throughput consumed on the table affected by the operation.</p>
    pub fn table(&self) -> std::option::Option<&crate::model::Capacity> {
        self.table.as_ref()
    }
    /// <p>The amount of throughput consumed on each local index affected by the operation.</p>
    pub fn local_secondary_indexes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Capacity>>
    {
        self.local_secondary_indexes.as_ref()
    }
    /// <p>The amount of throughput consumed on each global index affected by the operation.</p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Capacity>>
    {
        self.global_secondary_indexes.as_ref()
    }
}
impl std::fmt::Debug for ConsumedCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConsumedCapacity");
        formatter.field("table_name", &self.table_name);
        formatter.field("capacity_units", &self.capacity_units);
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.field("table", &self.table);
        formatter.field("local_secondary_indexes", &self.local_secondary_indexes);
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.finish()
    }
}
/// See [`ConsumedCapacity`](crate::model::ConsumedCapacity)
pub mod consumed_capacity {
    /// A builder for [`ConsumedCapacity`](crate::model::ConsumedCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) capacity_units: std::option::Option<f64>,
        pub(crate) read_capacity_units: std::option::Option<f64>,
        pub(crate) write_capacity_units: std::option::Option<f64>,
        pub(crate) table: std::option::Option<crate::model::Capacity>,
        pub(crate) local_secondary_indexes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Capacity>,
        >,
        pub(crate) global_secondary_indexes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Capacity>,
        >,
    }
    impl Builder {
        /// <p>The name of the table that was affected by the operation.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table that was affected by the operation.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The total number of capacity units consumed by the operation.</p>
        pub fn capacity_units(mut self, input: f64) -> Self {
            self.capacity_units = Some(input);
            self
        }
        /// <p>The total number of capacity units consumed by the operation.</p>
        pub fn set_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.capacity_units = input;
            self
        }
        /// <p>The total number of read capacity units consumed by the operation.</p>
        pub fn read_capacity_units(mut self, input: f64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The total number of read capacity units consumed by the operation.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The total number of write capacity units consumed by the operation.</p>
        pub fn write_capacity_units(mut self, input: f64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The total number of write capacity units consumed by the operation.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// <p>The amount of throughput consumed on the table affected by the operation.</p>
        pub fn table(mut self, input: crate::model::Capacity) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>The amount of throughput consumed on the table affected by the operation.</p>
        pub fn set_table(mut self, input: std::option::Option<crate::model::Capacity>) -> Self {
            self.table = input;
            self
        }
        /// Adds a key-value pair to `local_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>The amount of throughput consumed on each local index affected by the operation.</p>
        pub fn local_secondary_indexes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Capacity,
        ) -> Self {
            let mut hash_map = self.local_secondary_indexes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.local_secondary_indexes = Some(hash_map);
            self
        }
        /// <p>The amount of throughput consumed on each local index affected by the operation.</p>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Capacity>,
            >,
        ) -> Self {
            self.local_secondary_indexes = input;
            self
        }
        /// Adds a key-value pair to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>The amount of throughput consumed on each global index affected by the operation.</p>
        pub fn global_secondary_indexes(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Capacity,
        ) -> Self {
            let mut hash_map = self.global_secondary_indexes.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.global_secondary_indexes = Some(hash_map);
            self
        }
        /// <p>The amount of throughput consumed on each global index affected by the operation.</p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Capacity>,
            >,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// Consumes the builder and constructs a [`ConsumedCapacity`](crate::model::ConsumedCapacity)
        pub fn build(self) -> crate::model::ConsumedCapacity {
            crate::model::ConsumedCapacity {
                table_name: self.table_name,
                capacity_units: self.capacity_units,
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
                table: self.table,
                local_secondary_indexes: self.local_secondary_indexes,
                global_secondary_indexes: self.global_secondary_indexes,
            }
        }
    }
}
impl ConsumedCapacity {
    /// Creates a new builder-style object to manufacture [`ConsumedCapacity`](crate::model::ConsumedCapacity)
    pub fn builder() -> crate::model::consumed_capacity::Builder {
        crate::model::consumed_capacity::Builder::default()
    }
}

/// <p>Represents the amount of provisioned throughput capacity consumed on a table or an index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Capacity {
    /// <p>The total number of read capacity units consumed on a table or an index.</p>
    pub read_capacity_units: std::option::Option<f64>,
    /// <p>The total number of write capacity units consumed on a table or an index.</p>
    pub write_capacity_units: std::option::Option<f64>,
    /// <p>The total number of capacity units consumed on a table or an index.</p>
    pub capacity_units: std::option::Option<f64>,
}
impl Capacity {
    /// <p>The total number of read capacity units consumed on a table or an index.</p>
    pub fn read_capacity_units(&self) -> std::option::Option<f64> {
        self.read_capacity_units
    }
    /// <p>The total number of write capacity units consumed on a table or an index.</p>
    pub fn write_capacity_units(&self) -> std::option::Option<f64> {
        self.write_capacity_units
    }
    /// <p>The total number of capacity units consumed on a table or an index.</p>
    pub fn capacity_units(&self) -> std::option::Option<f64> {
        self.capacity_units
    }
}
impl std::fmt::Debug for Capacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Capacity");
        formatter.field("read_capacity_units", &self.read_capacity_units);
        formatter.field("write_capacity_units", &self.write_capacity_units);
        formatter.field("capacity_units", &self.capacity_units);
        formatter.finish()
    }
}
/// See [`Capacity`](crate::model::Capacity)
pub mod capacity {
    /// A builder for [`Capacity`](crate::model::Capacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) read_capacity_units: std::option::Option<f64>,
        pub(crate) write_capacity_units: std::option::Option<f64>,
        pub(crate) capacity_units: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The total number of read capacity units consumed on a table or an index.</p>
        pub fn read_capacity_units(mut self, input: f64) -> Self {
            self.read_capacity_units = Some(input);
            self
        }
        /// <p>The total number of read capacity units consumed on a table or an index.</p>
        pub fn set_read_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.read_capacity_units = input;
            self
        }
        /// <p>The total number of write capacity units consumed on a table or an index.</p>
        pub fn write_capacity_units(mut self, input: f64) -> Self {
            self.write_capacity_units = Some(input);
            self
        }
        /// <p>The total number of write capacity units consumed on a table or an index.</p>
        pub fn set_write_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.write_capacity_units = input;
            self
        }
        /// <p>The total number of capacity units consumed on a table or an index.</p>
        pub fn capacity_units(mut self, input: f64) -> Self {
            self.capacity_units = Some(input);
            self
        }
        /// <p>The total number of capacity units consumed on a table or an index.</p>
        pub fn set_capacity_units(mut self, input: std::option::Option<f64>) -> Self {
            self.capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`Capacity`](crate::model::Capacity)
        pub fn build(self) -> crate::model::Capacity {
            crate::model::Capacity {
                read_capacity_units: self.read_capacity_units,
                write_capacity_units: self.write_capacity_units,
                capacity_units: self.capacity_units,
            }
        }
    }
}
impl Capacity {
    /// Creates a new builder-style object to manufacture [`Capacity`](crate::model::Capacity)
    pub fn builder() -> crate::model::capacity::Builder {
        crate::model::capacity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReturnItemCollectionMetrics {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Size,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReturnItemCollectionMetrics {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ReturnItemCollectionMetrics::None,
            "SIZE" => ReturnItemCollectionMetrics::Size,
            other => ReturnItemCollectionMetrics::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReturnItemCollectionMetrics {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReturnItemCollectionMetrics::from(s))
    }
}
impl ReturnItemCollectionMetrics {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReturnItemCollectionMetrics::None => "NONE",
            ReturnItemCollectionMetrics::Size => "SIZE",
            ReturnItemCollectionMetrics::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SIZE"]
    }
}
impl AsRef<str> for ReturnItemCollectionMetrics {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Determines the level of detail about either provisioned or on-demand throughput
/// consumption that is returned in the response:</p>
/// <ul>
/// <li>
/// <p>
/// <code>INDEXES</code> - The response includes the aggregate
/// <code>ConsumedCapacity</code> for the operation, together with
/// <code>ConsumedCapacity</code> for each table and secondary index that was
/// accessed.</p>
/// <p>Note that some operations, such as <code>GetItem</code> and
/// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
/// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
/// information for table(s).</p>
/// </li>
/// <li>
/// <p>
/// <code>TOTAL</code> - The response includes only the aggregate
/// <code>ConsumedCapacity</code> for the operation.</p>
/// </li>
/// <li>
/// <p>
/// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
/// response.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReturnConsumedCapacity {
    #[allow(missing_docs)] // documentation missing in model
    Indexes,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Total,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReturnConsumedCapacity {
    fn from(s: &str) -> Self {
        match s {
            "INDEXES" => ReturnConsumedCapacity::Indexes,
            "NONE" => ReturnConsumedCapacity::None,
            "TOTAL" => ReturnConsumedCapacity::Total,
            other => ReturnConsumedCapacity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReturnConsumedCapacity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReturnConsumedCapacity::from(s))
    }
}
impl ReturnConsumedCapacity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReturnConsumedCapacity::Indexes => "INDEXES",
            ReturnConsumedCapacity::None => "NONE",
            ReturnConsumedCapacity::Total => "TOTAL",
            ReturnConsumedCapacity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INDEXES", "NONE", "TOTAL"]
    }
}
impl AsRef<str> for ReturnConsumedCapacity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReturnValue {
    #[allow(missing_docs)] // documentation missing in model
    AllNew,
    #[allow(missing_docs)] // documentation missing in model
    AllOld,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    UpdatedNew,
    #[allow(missing_docs)] // documentation missing in model
    UpdatedOld,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReturnValue {
    fn from(s: &str) -> Self {
        match s {
            "ALL_NEW" => ReturnValue::AllNew,
            "ALL_OLD" => ReturnValue::AllOld,
            "NONE" => ReturnValue::None,
            "UPDATED_NEW" => ReturnValue::UpdatedNew,
            "UPDATED_OLD" => ReturnValue::UpdatedOld,
            other => ReturnValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReturnValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReturnValue::from(s))
    }
}
impl ReturnValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReturnValue::AllNew => "ALL_NEW",
            ReturnValue::AllOld => "ALL_OLD",
            ReturnValue::None => "NONE",
            ReturnValue::UpdatedNew => "UPDATED_NEW",
            ReturnValue::UpdatedOld => "UPDATED_OLD",
            ReturnValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_NEW", "ALL_OLD", "NONE", "UPDATED_NEW", "UPDATED_OLD"]
    }
}
impl AsRef<str> for ReturnValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConditionalOperator {
    #[allow(missing_docs)] // documentation missing in model
    And,
    #[allow(missing_docs)] // documentation missing in model
    Or,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConditionalOperator {
    fn from(s: &str) -> Self {
        match s {
            "AND" => ConditionalOperator::And,
            "OR" => ConditionalOperator::Or,
            other => ConditionalOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConditionalOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConditionalOperator::from(s))
    }
}
impl ConditionalOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConditionalOperator::And => "AND",
            ConditionalOperator::Or => "OR",
            ConditionalOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AND", "OR"]
    }
}
impl AsRef<str> for ConditionalOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a condition to be compared with an attribute value. This condition can be used with <code>DeleteItem</code>, <code>PutItem</code>, or <code>UpdateItem</code> operations; if the comparison evaluates to true, the operation succeeds; if not, the operation fails. You can use <code>ExpectedAttributeValue</code> in one of two different ways:</p>
/// <ul>
/// <li> <p>Use <code>AttributeValueList</code> to specify one or more values to compare against an attribute. Use <code>ComparisonOperator</code> to specify how you want to perform the comparison. If the comparison evaluates to true, then the conditional operation succeeds.</p> </li>
/// <li> <p>Use <code>Value</code> to specify a value that DynamoDB will compare against an attribute. If the values match, then <code>ExpectedAttributeValue</code> evaluates to true and the conditional operation succeeds. Optionally, you can also set <code>Exists</code> to false, indicating that you <i>do not</i> expect to find the attribute value in the table. In this case, the conditional operation succeeds only if the comparison evaluates to false.</p> </li>
/// </ul>
/// <p> <code>Value</code> and <code>Exists</code> are incompatible with <code>AttributeValueList</code> and <code>ComparisonOperator</code>. Note that if you use both sets of parameters at once, DynamoDB will return a <code>ValidationException</code> exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpectedAttributeValue {
    /// <p>Represents the data for the expected attribute.</p>
    /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub value: std::option::Option<crate::model::AttributeValue>,
    /// <p>Causes DynamoDB to evaluate the value before attempting a conditional operation:</p>
    /// <ul>
    /// <li> <p>If <code>Exists</code> is <code>true</code>, DynamoDB will check to see if that attribute value already exists in the table. If it is found, then the operation succeeds. If it is not found, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
    /// <li> <p>If <code>Exists</code> is <code>false</code>, DynamoDB assumes that the attribute value does not exist in the table. If in fact the value does not exist, then the assumption is valid and the operation succeeds. If the value is found, despite the assumption that it does not exist, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
    /// </ul>
    /// <p>The default setting for <code>Exists</code> is <code>true</code>. If you supply a <code>Value</code> all by itself, DynamoDB assumes the attribute exists: You don't have to set <code>Exists</code> to <code>true</code>, because it is implied.</p>
    /// <p>DynamoDB returns a <code>ValidationException</code> if:</p>
    /// <ul>
    /// <li> <p> <code>Exists</code> is <code>true</code> but there is no <code>Value</code> to check. (You expect a value to exist, but don't specify what that value is.)</p> </li>
    /// <li> <p> <code>Exists</code> is <code>false</code> but you also provide a <code>Value</code>. (You cannot expect an attribute to have a value, while also expecting it not to exist.)</p> </li>
    /// </ul>
    pub exists: std::option::Option<bool>,
    /// <p>A comparator for evaluating attributes in the <code>AttributeValueList</code>. For example, equals, greater than, less than, etc.</p>
    /// <p>The following comparison operators are available:</p>
    /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
    /// <p>The following are descriptions of each comparison operator.</p>
    /// <ul>
    /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
    /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
    /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
    /// </ul>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
    /// <p>For type Number, value comparisons are numeric.</p>
    /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
    /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
    /// <p>For information on specifying data types in JSON, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html">JSON Data Format</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub attribute_value_list: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
}
impl ExpectedAttributeValue {
    /// <p>Represents the data for the expected attribute.</p>
    /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::AttributeValue> {
        self.value.as_ref()
    }
    /// <p>Causes DynamoDB to evaluate the value before attempting a conditional operation:</p>
    /// <ul>
    /// <li> <p>If <code>Exists</code> is <code>true</code>, DynamoDB will check to see if that attribute value already exists in the table. If it is found, then the operation succeeds. If it is not found, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
    /// <li> <p>If <code>Exists</code> is <code>false</code>, DynamoDB assumes that the attribute value does not exist in the table. If in fact the value does not exist, then the assumption is valid and the operation succeeds. If the value is found, despite the assumption that it does not exist, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
    /// </ul>
    /// <p>The default setting for <code>Exists</code> is <code>true</code>. If you supply a <code>Value</code> all by itself, DynamoDB assumes the attribute exists: You don't have to set <code>Exists</code> to <code>true</code>, because it is implied.</p>
    /// <p>DynamoDB returns a <code>ValidationException</code> if:</p>
    /// <ul>
    /// <li> <p> <code>Exists</code> is <code>true</code> but there is no <code>Value</code> to check. (You expect a value to exist, but don't specify what that value is.)</p> </li>
    /// <li> <p> <code>Exists</code> is <code>false</code> but you also provide a <code>Value</code>. (You cannot expect an attribute to have a value, while also expecting it not to exist.)</p> </li>
    /// </ul>
    pub fn exists(&self) -> std::option::Option<bool> {
        self.exists
    }
    /// <p>A comparator for evaluating attributes in the <code>AttributeValueList</code>. For example, equals, greater than, less than, etc.</p>
    /// <p>The following comparison operators are available:</p>
    /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
    /// <p>The following are descriptions of each comparison operator.</p>
    /// <ul>
    /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
    /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
    /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
    /// </ul>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
    /// <p>For type Number, value comparisons are numeric.</p>
    /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
    /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
    /// <p>For information on specifying data types in JSON, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html">JSON Data Format</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn attribute_value_list(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.attribute_value_list.as_deref()
    }
}
impl std::fmt::Debug for ExpectedAttributeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpectedAttributeValue");
        formatter.field("value", &self.value);
        formatter.field("exists", &self.exists);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("attribute_value_list", &self.attribute_value_list);
        formatter.finish()
    }
}
/// See [`ExpectedAttributeValue`](crate::model::ExpectedAttributeValue)
pub mod expected_attribute_value {
    /// A builder for [`ExpectedAttributeValue`](crate::model::ExpectedAttributeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::AttributeValue>,
        pub(crate) exists: std::option::Option<bool>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) attribute_value_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    }
    impl Builder {
        /// <p>Represents the data for the expected attribute.</p>
        /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn value(mut self, input: crate::model::AttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Represents the data for the expected attribute.</p>
        /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>Causes DynamoDB to evaluate the value before attempting a conditional operation:</p>
        /// <ul>
        /// <li> <p>If <code>Exists</code> is <code>true</code>, DynamoDB will check to see if that attribute value already exists in the table. If it is found, then the operation succeeds. If it is not found, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
        /// <li> <p>If <code>Exists</code> is <code>false</code>, DynamoDB assumes that the attribute value does not exist in the table. If in fact the value does not exist, then the assumption is valid and the operation succeeds. If the value is found, despite the assumption that it does not exist, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
        /// </ul>
        /// <p>The default setting for <code>Exists</code> is <code>true</code>. If you supply a <code>Value</code> all by itself, DynamoDB assumes the attribute exists: You don't have to set <code>Exists</code> to <code>true</code>, because it is implied.</p>
        /// <p>DynamoDB returns a <code>ValidationException</code> if:</p>
        /// <ul>
        /// <li> <p> <code>Exists</code> is <code>true</code> but there is no <code>Value</code> to check. (You expect a value to exist, but don't specify what that value is.)</p> </li>
        /// <li> <p> <code>Exists</code> is <code>false</code> but you also provide a <code>Value</code>. (You cannot expect an attribute to have a value, while also expecting it not to exist.)</p> </li>
        /// </ul>
        pub fn exists(mut self, input: bool) -> Self {
            self.exists = Some(input);
            self
        }
        /// <p>Causes DynamoDB to evaluate the value before attempting a conditional operation:</p>
        /// <ul>
        /// <li> <p>If <code>Exists</code> is <code>true</code>, DynamoDB will check to see if that attribute value already exists in the table. If it is found, then the operation succeeds. If it is not found, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
        /// <li> <p>If <code>Exists</code> is <code>false</code>, DynamoDB assumes that the attribute value does not exist in the table. If in fact the value does not exist, then the assumption is valid and the operation succeeds. If the value is found, despite the assumption that it does not exist, the operation fails with a <code>ConditionCheckFailedException</code>.</p> </li>
        /// </ul>
        /// <p>The default setting for <code>Exists</code> is <code>true</code>. If you supply a <code>Value</code> all by itself, DynamoDB assumes the attribute exists: You don't have to set <code>Exists</code> to <code>true</code>, because it is implied.</p>
        /// <p>DynamoDB returns a <code>ValidationException</code> if:</p>
        /// <ul>
        /// <li> <p> <code>Exists</code> is <code>true</code> but there is no <code>Value</code> to check. (You expect a value to exist, but don't specify what that value is.)</p> </li>
        /// <li> <p> <code>Exists</code> is <code>false</code> but you also provide a <code>Value</code>. (You cannot expect an attribute to have a value, while also expecting it not to exist.)</p> </li>
        /// </ul>
        pub fn set_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.exists = input;
            self
        }
        /// <p>A comparator for evaluating attributes in the <code>AttributeValueList</code>. For example, equals, greater than, less than, etc.</p>
        /// <p>The following comparison operators are available:</p>
        /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
        /// <p>The following are descriptions of each comparison operator.</p>
        /// <ul>
        /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
        /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
        /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
        /// </ul>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>A comparator for evaluating attributes in the <code>AttributeValueList</code>. For example, equals, greater than, less than, etc.</p>
        /// <p>The following comparison operators are available:</p>
        /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
        /// <p>The following are descriptions of each comparison operator.</p>
        /// <ul>
        /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
        /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
        /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
        /// </ul>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// Appends an item to `attribute_value_list`.
        ///
        /// To override the contents of this collection use [`set_attribute_value_list`](Self::set_attribute_value_list).
        ///
        /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
        /// <p>For type Number, value comparisons are numeric.</p>
        /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
        /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
        /// <p>For information on specifying data types in JSON, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html">JSON Data Format</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attribute_value_list(mut self, input: crate::model::AttributeValue) -> Self {
            let mut v = self.attribute_value_list.unwrap_or_default();
            v.push(input);
            self.attribute_value_list = Some(v);
            self
        }
        /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
        /// <p>For type Number, value comparisons are numeric.</p>
        /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
        /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
        /// <p>For information on specifying data types in JSON, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html">JSON Data Format</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attribute_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.attribute_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpectedAttributeValue`](crate::model::ExpectedAttributeValue)
        pub fn build(self) -> crate::model::ExpectedAttributeValue {
            crate::model::ExpectedAttributeValue {
                value: self.value,
                exists: self.exists,
                comparison_operator: self.comparison_operator,
                attribute_value_list: self.attribute_value_list,
            }
        }
    }
}
impl ExpectedAttributeValue {
    /// Creates a new builder-style object to manufacture [`ExpectedAttributeValue`](crate::model::ExpectedAttributeValue)
    pub fn builder() -> crate::model::expected_attribute_value::Builder {
        crate::model::expected_attribute_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    BeginsWith,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Le,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    NotContains,
    #[allow(missing_docs)] // documentation missing in model
    NotNull,
    #[allow(missing_docs)] // documentation missing in model
    Null,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "BEGINS_WITH" => ComparisonOperator::BeginsWith,
            "BETWEEN" => ComparisonOperator::Between,
            "CONTAINS" => ComparisonOperator::Contains,
            "EQ" => ComparisonOperator::Eq,
            "GE" => ComparisonOperator::Ge,
            "GT" => ComparisonOperator::Gt,
            "IN" => ComparisonOperator::In,
            "LE" => ComparisonOperator::Le,
            "LT" => ComparisonOperator::Lt,
            "NE" => ComparisonOperator::Ne,
            "NOT_CONTAINS" => ComparisonOperator::NotContains,
            "NOT_NULL" => ComparisonOperator::NotNull,
            "NULL" => ComparisonOperator::Null,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::BeginsWith => "BEGINS_WITH",
            ComparisonOperator::Between => "BETWEEN",
            ComparisonOperator::Contains => "CONTAINS",
            ComparisonOperator::Eq => "EQ",
            ComparisonOperator::Ge => "GE",
            ComparisonOperator::Gt => "GT",
            ComparisonOperator::In => "IN",
            ComparisonOperator::Le => "LE",
            ComparisonOperator::Lt => "LT",
            ComparisonOperator::Ne => "NE",
            ComparisonOperator::NotContains => "NOT_CONTAINS",
            ComparisonOperator::NotNull => "NOT_NULL",
            ComparisonOperator::Null => "NULL",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BEGINS_WITH",
            "BETWEEN",
            "CONTAINS",
            "EQ",
            "GE",
            "GT",
            "IN",
            "LE",
            "LT",
            "NE",
            "NOT_CONTAINS",
            "NOT_NULL",
            "NULL",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>For the <code>UpdateItem</code> operation, represents the attributes to be modified, the action to perform on each, and the new value for each.</p> <note>
/// <p>You cannot use <code>UpdateItem</code> to update any primary key attributes. Instead, you will need to delete the item, and then use <code>PutItem</code> to create a new item with new attributes.</p>
/// </note>
/// <p>Attribute values cannot be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests with empty values will be rejected with a <code>ValidationException</code> exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeValueUpdate {
    /// <p>Represents the data for an attribute.</p>
    /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub value: std::option::Option<crate::model::AttributeValue>,
    /// <p>Specifies how to perform the update. Valid values are <code>PUT</code> (default), <code>DELETE</code>, and <code>ADD</code>. The behavior depends on whether the specified primary key already exists in the table.</p>
    /// <p> <b>If an item with the specified <i>Key</i> is found in the table:</b> </p>
    /// <ul>
    /// <li> <p> <code>PUT</code> - Adds the specified attribute to the item. If the attribute already exists, it is replaced by the new value. </p> </li>
    /// <li> <p> <code>DELETE</code> - If no value is specified, the attribute and its value are removed from the item. The data type of the specified value must match the existing value's data type.</p> <p>If a <i>set</i> of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specified <code>[a,c]</code>, then the final attribute value would be <code>[b]</code>. Specifying an empty set is an error.</p> </li>
    /// <li> <p> <code>ADD</code> - If the attribute does not already exist, then the attribute and its values are added to the item. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
    /// <ul>
    /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then the <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
    /// <p> If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses 0 as the initial value.</p>
    /// <p>In addition, if you use <code>ADD</code> to update an existing item, and intend to increment or decrement an attribute value which does not yet exist, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update does not yet have an attribute named <i>itemcount</i>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway, even though it currently does not exist. DynamoDB will create the <i>itemcount</i> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <i>itemcount</i> attribute in the item, with a value of <code>3</code>.</p>
    /// </note> </li>
    /// <li> <p>If the existing data type is a set, and if the <code>Value</code> is also a set, then the <code>Value</code> is added to the existing set. (This is a <i>set</i> operation, not mathematical addition.) For example, if the attribute value was the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value would be <code>[1,2,3]</code>. An error occurs if an Add action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings. The same holds true for number sets and binary sets.</p> </li>
    /// </ul> <p>This action is only valid for an existing attribute whose data type is number or is a set. Do not use <code>ADD</code> for any other data types.</p> </li>
    /// </ul>
    /// <p> <b>If no item with the specified <i>Key</i> is found:</b> </p>
    /// <ul>
    /// <li> <p> <code>PUT</code> - DynamoDB creates a new item with the specified primary key, and then adds the attribute. </p> </li>
    /// <li> <p> <code>DELETE</code> - Nothing happens; there is no attribute to delete.</p> </li>
    /// <li> <p> <code>ADD</code> - DynamoDB creates an item with the supplied primary key and number (or set of numbers) for the attribute value. The only data types allowed are number and number set; no other data types can be specified.</p> </li>
    /// </ul>
    pub action: std::option::Option<crate::model::AttributeAction>,
}
impl AttributeValueUpdate {
    /// <p>Represents the data for an attribute.</p>
    /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub fn value(&self) -> std::option::Option<&crate::model::AttributeValue> {
        self.value.as_ref()
    }
    /// <p>Specifies how to perform the update. Valid values are <code>PUT</code> (default), <code>DELETE</code>, and <code>ADD</code>. The behavior depends on whether the specified primary key already exists in the table.</p>
    /// <p> <b>If an item with the specified <i>Key</i> is found in the table:</b> </p>
    /// <ul>
    /// <li> <p> <code>PUT</code> - Adds the specified attribute to the item. If the attribute already exists, it is replaced by the new value. </p> </li>
    /// <li> <p> <code>DELETE</code> - If no value is specified, the attribute and its value are removed from the item. The data type of the specified value must match the existing value's data type.</p> <p>If a <i>set</i> of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specified <code>[a,c]</code>, then the final attribute value would be <code>[b]</code>. Specifying an empty set is an error.</p> </li>
    /// <li> <p> <code>ADD</code> - If the attribute does not already exist, then the attribute and its values are added to the item. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
    /// <ul>
    /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then the <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
    /// <p> If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses 0 as the initial value.</p>
    /// <p>In addition, if you use <code>ADD</code> to update an existing item, and intend to increment or decrement an attribute value which does not yet exist, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update does not yet have an attribute named <i>itemcount</i>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway, even though it currently does not exist. DynamoDB will create the <i>itemcount</i> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <i>itemcount</i> attribute in the item, with a value of <code>3</code>.</p>
    /// </note> </li>
    /// <li> <p>If the existing data type is a set, and if the <code>Value</code> is also a set, then the <code>Value</code> is added to the existing set. (This is a <i>set</i> operation, not mathematical addition.) For example, if the attribute value was the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value would be <code>[1,2,3]</code>. An error occurs if an Add action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings. The same holds true for number sets and binary sets.</p> </li>
    /// </ul> <p>This action is only valid for an existing attribute whose data type is number or is a set. Do not use <code>ADD</code> for any other data types.</p> </li>
    /// </ul>
    /// <p> <b>If no item with the specified <i>Key</i> is found:</b> </p>
    /// <ul>
    /// <li> <p> <code>PUT</code> - DynamoDB creates a new item with the specified primary key, and then adds the attribute. </p> </li>
    /// <li> <p> <code>DELETE</code> - Nothing happens; there is no attribute to delete.</p> </li>
    /// <li> <p> <code>ADD</code> - DynamoDB creates an item with the supplied primary key and number (or set of numbers) for the attribute value. The only data types allowed are number and number set; no other data types can be specified.</p> </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::AttributeAction> {
        self.action.as_ref()
    }
}
impl std::fmt::Debug for AttributeValueUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeValueUpdate");
        formatter.field("value", &self.value);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`AttributeValueUpdate`](crate::model::AttributeValueUpdate)
pub mod attribute_value_update {
    /// A builder for [`AttributeValueUpdate`](crate::model::AttributeValueUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::AttributeValue>,
        pub(crate) action: std::option::Option<crate::model::AttributeAction>,
    }
    impl Builder {
        /// <p>Represents the data for an attribute.</p>
        /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn value(mut self, input: crate::model::AttributeValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Represents the data for an attribute.</p>
        /// <p>Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::AttributeValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>Specifies how to perform the update. Valid values are <code>PUT</code> (default), <code>DELETE</code>, and <code>ADD</code>. The behavior depends on whether the specified primary key already exists in the table.</p>
        /// <p> <b>If an item with the specified <i>Key</i> is found in the table:</b> </p>
        /// <ul>
        /// <li> <p> <code>PUT</code> - Adds the specified attribute to the item. If the attribute already exists, it is replaced by the new value. </p> </li>
        /// <li> <p> <code>DELETE</code> - If no value is specified, the attribute and its value are removed from the item. The data type of the specified value must match the existing value's data type.</p> <p>If a <i>set</i> of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specified <code>[a,c]</code>, then the final attribute value would be <code>[b]</code>. Specifying an empty set is an error.</p> </li>
        /// <li> <p> <code>ADD</code> - If the attribute does not already exist, then the attribute and its values are added to the item. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then the <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
        /// <p> If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses 0 as the initial value.</p>
        /// <p>In addition, if you use <code>ADD</code> to update an existing item, and intend to increment or decrement an attribute value which does not yet exist, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update does not yet have an attribute named <i>itemcount</i>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway, even though it currently does not exist. DynamoDB will create the <i>itemcount</i> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <i>itemcount</i> attribute in the item, with a value of <code>3</code>.</p>
        /// </note> </li>
        /// <li> <p>If the existing data type is a set, and if the <code>Value</code> is also a set, then the <code>Value</code> is added to the existing set. (This is a <i>set</i> operation, not mathematical addition.) For example, if the attribute value was the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value would be <code>[1,2,3]</code>. An error occurs if an Add action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings. The same holds true for number sets and binary sets.</p> </li>
        /// </ul> <p>This action is only valid for an existing attribute whose data type is number or is a set. Do not use <code>ADD</code> for any other data types.</p> </li>
        /// </ul>
        /// <p> <b>If no item with the specified <i>Key</i> is found:</b> </p>
        /// <ul>
        /// <li> <p> <code>PUT</code> - DynamoDB creates a new item with the specified primary key, and then adds the attribute. </p> </li>
        /// <li> <p> <code>DELETE</code> - Nothing happens; there is no attribute to delete.</p> </li>
        /// <li> <p> <code>ADD</code> - DynamoDB creates an item with the supplied primary key and number (or set of numbers) for the attribute value. The only data types allowed are number and number set; no other data types can be specified.</p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::AttributeAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies how to perform the update. Valid values are <code>PUT</code> (default), <code>DELETE</code>, and <code>ADD</code>. The behavior depends on whether the specified primary key already exists in the table.</p>
        /// <p> <b>If an item with the specified <i>Key</i> is found in the table:</b> </p>
        /// <ul>
        /// <li> <p> <code>PUT</code> - Adds the specified attribute to the item. If the attribute already exists, it is replaced by the new value. </p> </li>
        /// <li> <p> <code>DELETE</code> - If no value is specified, the attribute and its value are removed from the item. The data type of the specified value must match the existing value's data type.</p> <p>If a <i>set</i> of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set <code>[a,b,c]</code> and the <code>DELETE</code> action specified <code>[a,c]</code>, then the final attribute value would be <code>[b]</code>. Specifying an empty set is an error.</p> </li>
        /// <li> <p> <code>ADD</code> - If the attribute does not already exist, then the attribute and its values are added to the item. If the attribute does exist, then the behavior of <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li> <p>If the existing attribute is a number, and if <code>Value</code> is also a number, then the <code>Value</code> is mathematically added to the existing attribute. If <code>Value</code> is a negative number, then it is subtracted from the existing attribute.</p> <note>
        /// <p> If you use <code>ADD</code> to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses 0 as the initial value.</p>
        /// <p>In addition, if you use <code>ADD</code> to update an existing item, and intend to increment or decrement an attribute value which does not yet exist, DynamoDB uses <code>0</code> as the initial value. For example, suppose that the item you want to update does not yet have an attribute named <i>itemcount</i>, but you decide to <code>ADD</code> the number <code>3</code> to this attribute anyway, even though it currently does not exist. DynamoDB will create the <i>itemcount</i> attribute, set its initial value to <code>0</code>, and finally add <code>3</code> to it. The result will be a new <i>itemcount</i> attribute in the item, with a value of <code>3</code>.</p>
        /// </note> </li>
        /// <li> <p>If the existing data type is a set, and if the <code>Value</code> is also a set, then the <code>Value</code> is added to the existing set. (This is a <i>set</i> operation, not mathematical addition.) For example, if the attribute value was the set <code>[1,2]</code>, and the <code>ADD</code> action specified <code>[3]</code>, then the final attribute value would be <code>[1,2,3]</code>. An error occurs if an Add action is specified for a set attribute and the attribute type specified does not match the existing set type. </p> <p>Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the <code>Value</code> must also be a set of strings. The same holds true for number sets and binary sets.</p> </li>
        /// </ul> <p>This action is only valid for an existing attribute whose data type is number or is a set. Do not use <code>ADD</code> for any other data types.</p> </li>
        /// </ul>
        /// <p> <b>If no item with the specified <i>Key</i> is found:</b> </p>
        /// <ul>
        /// <li> <p> <code>PUT</code> - DynamoDB creates a new item with the specified primary key, and then adds the attribute. </p> </li>
        /// <li> <p> <code>DELETE</code> - Nothing happens; there is no attribute to delete.</p> </li>
        /// <li> <p> <code>ADD</code> - DynamoDB creates an item with the supplied primary key and number (or set of numbers) for the attribute value. The only data types allowed are number and number set; no other data types can be specified.</p> </li>
        /// </ul>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::AttributeAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeValueUpdate`](crate::model::AttributeValueUpdate)
        pub fn build(self) -> crate::model::AttributeValueUpdate {
            crate::model::AttributeValueUpdate {
                value: self.value,
                action: self.action,
            }
        }
    }
}
impl AttributeValueUpdate {
    /// Creates a new builder-style object to manufacture [`AttributeValueUpdate`](crate::model::AttributeValueUpdate)
    pub fn builder() -> crate::model::attribute_value_update::Builder {
        crate::model::attribute_value_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AttributeAction {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AttributeAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => AttributeAction::Add,
            "DELETE" => AttributeAction::Delete,
            "PUT" => AttributeAction::Put,
            other => AttributeAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AttributeAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AttributeAction::from(s))
    }
}
impl AttributeAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AttributeAction::Add => "ADD",
            AttributeAction::Delete => "DELETE",
            AttributeAction::Put => "PUT",
            AttributeAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "DELETE", "PUT"]
    }
}
impl AsRef<str> for AttributeAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the properties of a replica.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaSettingsDescription {
    /// <p>The Region name of the replica.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The current state of the Region:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The Region is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The Region is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The Region is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The Region is ready for use.</p> </li>
    /// </ul>
    pub replica_status: std::option::Option<crate::model::ReplicaStatus>,
    /// <p>The read/write capacity mode of the replica.</p>
    pub replica_billing_mode_summary: std::option::Option<crate::model::BillingModeSummary>,
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub replica_provisioned_read_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for a global table replica's read capacity units.</p>
    pub replica_provisioned_read_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub replica_provisioned_write_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for a global table replica's write capacity units.</p>
    pub replica_provisioned_write_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>Replica global secondary index settings for the global table.</p>
    pub replica_global_secondary_index_settings: std::option::Option<
        std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsDescription>,
    >,
    /// <p>Contains details of the table class.</p>
    pub replica_table_class_summary: std::option::Option<crate::model::TableClassSummary>,
}
impl ReplicaSettingsDescription {
    /// <p>The Region name of the replica.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The current state of the Region:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The Region is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The Region is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The Region is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The Region is ready for use.</p> </li>
    /// </ul>
    pub fn replica_status(&self) -> std::option::Option<&crate::model::ReplicaStatus> {
        self.replica_status.as_ref()
    }
    /// <p>The read/write capacity mode of the replica.</p>
    pub fn replica_billing_mode_summary(
        &self,
    ) -> std::option::Option<&crate::model::BillingModeSummary> {
        self.replica_billing_mode_summary.as_ref()
    }
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub fn replica_provisioned_read_capacity_units(&self) -> std::option::Option<i64> {
        self.replica_provisioned_read_capacity_units
    }
    /// <p>Auto scaling settings for a global table replica's read capacity units.</p>
    pub fn replica_provisioned_read_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.replica_provisioned_read_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn replica_provisioned_write_capacity_units(&self) -> std::option::Option<i64> {
        self.replica_provisioned_write_capacity_units
    }
    /// <p>Auto scaling settings for a global table replica's write capacity units.</p>
    pub fn replica_provisioned_write_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.replica_provisioned_write_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>Replica global secondary index settings for the global table.</p>
    pub fn replica_global_secondary_index_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndexSettingsDescription]> {
        self.replica_global_secondary_index_settings.as_deref()
    }
    /// <p>Contains details of the table class.</p>
    pub fn replica_table_class_summary(
        &self,
    ) -> std::option::Option<&crate::model::TableClassSummary> {
        self.replica_table_class_summary.as_ref()
    }
}
impl std::fmt::Debug for ReplicaSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaSettingsDescription");
        formatter.field("region_name", &self.region_name);
        formatter.field("replica_status", &self.replica_status);
        formatter.field(
            "replica_billing_mode_summary",
            &self.replica_billing_mode_summary,
        );
        formatter.field(
            "replica_provisioned_read_capacity_units",
            &self.replica_provisioned_read_capacity_units,
        );
        formatter.field(
            "replica_provisioned_read_capacity_auto_scaling_settings",
            &self.replica_provisioned_read_capacity_auto_scaling_settings,
        );
        formatter.field(
            "replica_provisioned_write_capacity_units",
            &self.replica_provisioned_write_capacity_units,
        );
        formatter.field(
            "replica_provisioned_write_capacity_auto_scaling_settings",
            &self.replica_provisioned_write_capacity_auto_scaling_settings,
        );
        formatter.field(
            "replica_global_secondary_index_settings",
            &self.replica_global_secondary_index_settings,
        );
        formatter.field(
            "replica_table_class_summary",
            &self.replica_table_class_summary,
        );
        formatter.finish()
    }
}
/// See [`ReplicaSettingsDescription`](crate::model::ReplicaSettingsDescription)
pub mod replica_settings_description {
    /// A builder for [`ReplicaSettingsDescription`](crate::model::ReplicaSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) replica_status: std::option::Option<crate::model::ReplicaStatus>,
        pub(crate) replica_billing_mode_summary:
            std::option::Option<crate::model::BillingModeSummary>,
        pub(crate) replica_provisioned_read_capacity_units: std::option::Option<i64>,
        pub(crate) replica_provisioned_read_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) replica_provisioned_write_capacity_units: std::option::Option<i64>,
        pub(crate) replica_provisioned_write_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) replica_global_secondary_index_settings: std::option::Option<
            std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsDescription>,
        >,
        pub(crate) replica_table_class_summary:
            std::option::Option<crate::model::TableClassSummary>,
    }
    impl Builder {
        /// <p>The Region name of the replica.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region name of the replica.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The current state of the Region:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The Region is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The Region is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The Region is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The Region is ready for use.</p> </li>
        /// </ul>
        pub fn replica_status(mut self, input: crate::model::ReplicaStatus) -> Self {
            self.replica_status = Some(input);
            self
        }
        /// <p>The current state of the Region:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The Region is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The Region is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The Region is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The Region is ready for use.</p> </li>
        /// </ul>
        pub fn set_replica_status(
            mut self,
            input: std::option::Option<crate::model::ReplicaStatus>,
        ) -> Self {
            self.replica_status = input;
            self
        }
        /// <p>The read/write capacity mode of the replica.</p>
        pub fn replica_billing_mode_summary(
            mut self,
            input: crate::model::BillingModeSummary,
        ) -> Self {
            self.replica_billing_mode_summary = Some(input);
            self
        }
        /// <p>The read/write capacity mode of the replica.</p>
        pub fn set_replica_billing_mode_summary(
            mut self,
            input: std::option::Option<crate::model::BillingModeSummary>,
        ) -> Self {
            self.replica_billing_mode_summary = input;
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn replica_provisioned_read_capacity_units(mut self, input: i64) -> Self {
            self.replica_provisioned_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn set_replica_provisioned_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.replica_provisioned_read_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for a global table replica's read capacity units.</p>
        pub fn replica_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Auto scaling settings for a global table replica's read capacity units.</p>
        pub fn set_replica_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn replica_provisioned_write_capacity_units(mut self, input: i64) -> Self {
            self.replica_provisioned_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_replica_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.replica_provisioned_write_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for a global table replica's write capacity units.</p>
        pub fn replica_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.replica_provisioned_write_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Auto scaling settings for a global table replica's write capacity units.</p>
        pub fn set_replica_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.replica_provisioned_write_capacity_auto_scaling_settings = input;
            self
        }
        /// Appends an item to `replica_global_secondary_index_settings`.
        ///
        /// To override the contents of this collection use [`set_replica_global_secondary_index_settings`](Self::set_replica_global_secondary_index_settings).
        ///
        /// <p>Replica global secondary index settings for the global table.</p>
        pub fn replica_global_secondary_index_settings(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndexSettingsDescription,
        ) -> Self {
            let mut v = self
                .replica_global_secondary_index_settings
                .unwrap_or_default();
            v.push(input);
            self.replica_global_secondary_index_settings = Some(v);
            self
        }
        /// <p>Replica global secondary index settings for the global table.</p>
        pub fn set_replica_global_secondary_index_settings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsDescription>,
            >,
        ) -> Self {
            self.replica_global_secondary_index_settings = input;
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn replica_table_class_summary(
            mut self,
            input: crate::model::TableClassSummary,
        ) -> Self {
            self.replica_table_class_summary = Some(input);
            self
        }
        /// <p>Contains details of the table class.</p>
        pub fn set_replica_table_class_summary(
            mut self,
            input: std::option::Option<crate::model::TableClassSummary>,
        ) -> Self {
            self.replica_table_class_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaSettingsDescription`](crate::model::ReplicaSettingsDescription)
        pub fn build(self) -> crate::model::ReplicaSettingsDescription {
            crate::model::ReplicaSettingsDescription {
                region_name: self.region_name,
                replica_status: self.replica_status,
                replica_billing_mode_summary: self.replica_billing_mode_summary,
                replica_provisioned_read_capacity_units: self
                    .replica_provisioned_read_capacity_units,
                replica_provisioned_read_capacity_auto_scaling_settings: self
                    .replica_provisioned_read_capacity_auto_scaling_settings,
                replica_provisioned_write_capacity_units: self
                    .replica_provisioned_write_capacity_units,
                replica_provisioned_write_capacity_auto_scaling_settings: self
                    .replica_provisioned_write_capacity_auto_scaling_settings,
                replica_global_secondary_index_settings: self
                    .replica_global_secondary_index_settings,
                replica_table_class_summary: self.replica_table_class_summary,
            }
        }
    }
}
impl ReplicaSettingsDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaSettingsDescription`](crate::model::ReplicaSettingsDescription)
    pub fn builder() -> crate::model::replica_settings_description::Builder {
        crate::model::replica_settings_description::Builder::default()
    }
}

/// <p>Represents the properties of a global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndexSettingsDescription {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p> The current status of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The global secondary index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The global secondary index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The global secondary index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The global secondary index is ready for use.</p> </li>
    /// </ul>
    pub index_status: std::option::Option<crate::model::IndexStatus>,
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub provisioned_read_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for a global secondary index replica's read capacity units.</p>
    pub provisioned_read_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub provisioned_write_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for a global secondary index replica's write capacity units.</p>
    pub provisioned_write_capacity_auto_scaling_settings:
        std::option::Option<crate::model::AutoScalingSettingsDescription>,
}
impl ReplicaGlobalSecondaryIndexSettingsDescription {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p> The current status of the global secondary index:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The global secondary index is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The global secondary index is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The global secondary index is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The global secondary index is ready for use.</p> </li>
    /// </ul>
    pub fn index_status(&self) -> std::option::Option<&crate::model::IndexStatus> {
        self.index_status.as_ref()
    }
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub fn provisioned_read_capacity_units(&self) -> std::option::Option<i64> {
        self.provisioned_read_capacity_units
    }
    /// <p>Auto scaling settings for a global secondary index replica's read capacity units.</p>
    pub fn provisioned_read_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.provisioned_read_capacity_auto_scaling_settings
            .as_ref()
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub fn provisioned_write_capacity_units(&self) -> std::option::Option<i64> {
        self.provisioned_write_capacity_units
    }
    /// <p>Auto scaling settings for a global secondary index replica's write capacity units.</p>
    pub fn provisioned_write_capacity_auto_scaling_settings(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsDescription> {
        self.provisioned_write_capacity_auto_scaling_settings
            .as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndexSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndexSettingsDescription");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_status", &self.index_status);
        formatter.field(
            "provisioned_read_capacity_units",
            &self.provisioned_read_capacity_units,
        );
        formatter.field(
            "provisioned_read_capacity_auto_scaling_settings",
            &self.provisioned_read_capacity_auto_scaling_settings,
        );
        formatter.field(
            "provisioned_write_capacity_units",
            &self.provisioned_write_capacity_units,
        );
        formatter.field(
            "provisioned_write_capacity_auto_scaling_settings",
            &self.provisioned_write_capacity_auto_scaling_settings,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndexSettingsDescription`](crate::model::ReplicaGlobalSecondaryIndexSettingsDescription)
pub mod replica_global_secondary_index_settings_description {
    /// A builder for [`ReplicaGlobalSecondaryIndexSettingsDescription`](crate::model::ReplicaGlobalSecondaryIndexSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_status: std::option::Option<crate::model::IndexStatus>,
        pub(crate) provisioned_read_capacity_units: std::option::Option<i64>,
        pub(crate) provisioned_read_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
        pub(crate) provisioned_write_capacity_units: std::option::Option<i64>,
        pub(crate) provisioned_write_capacity_auto_scaling_settings:
            std::option::Option<crate::model::AutoScalingSettingsDescription>,
    }
    impl Builder {
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p> The current status of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The global secondary index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The global secondary index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The global secondary index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The global secondary index is ready for use.</p> </li>
        /// </ul>
        pub fn index_status(mut self, input: crate::model::IndexStatus) -> Self {
            self.index_status = Some(input);
            self
        }
        /// <p> The current status of the global secondary index:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The global secondary index is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The global secondary index is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The global secondary index is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The global secondary index is ready for use.</p> </li>
        /// </ul>
        pub fn set_index_status(
            mut self,
            input: std::option::Option<crate::model::IndexStatus>,
        ) -> Self {
            self.index_status = input;
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn provisioned_read_capacity_units(mut self, input: i64) -> Self {
            self.provisioned_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn set_provisioned_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.provisioned_read_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for a global secondary index replica's read capacity units.</p>
        pub fn provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Auto scaling settings for a global secondary index replica's read capacity units.</p>
        pub fn set_provisioned_read_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn provisioned_write_capacity_units(mut self, input: i64) -> Self {
            self.provisioned_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn set_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.provisioned_write_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for a global secondary index replica's write capacity units.</p>
        pub fn provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: crate::model::AutoScalingSettingsDescription,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings = Some(input);
            self
        }
        /// <p>Auto scaling settings for a global secondary index replica's write capacity units.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_settings(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsDescription>,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndexSettingsDescription`](crate::model::ReplicaGlobalSecondaryIndexSettingsDescription)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndexSettingsDescription {
            crate::model::ReplicaGlobalSecondaryIndexSettingsDescription {
                index_name: self.index_name,
                index_status: self.index_status,
                provisioned_read_capacity_units: self.provisioned_read_capacity_units,
                provisioned_read_capacity_auto_scaling_settings: self
                    .provisioned_read_capacity_auto_scaling_settings,
                provisioned_write_capacity_units: self.provisioned_write_capacity_units,
                provisioned_write_capacity_auto_scaling_settings: self
                    .provisioned_write_capacity_auto_scaling_settings,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndexSettingsDescription {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndexSettingsDescription`](crate::model::ReplicaGlobalSecondaryIndexSettingsDescription)
    pub fn builder() -> crate::model::replica_global_secondary_index_settings_description::Builder {
        crate::model::replica_global_secondary_index_settings_description::Builder::default()
    }
}

/// <p>Represents the settings for a global table in a Region that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaSettingsUpdate {
    /// <p>The Region of the replica to be added.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub replica_provisioned_read_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for managing a global table replica's read capacity units.</p>
    pub replica_provisioned_read_capacity_auto_scaling_settings_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
    pub replica_global_secondary_index_settings_update:
        std::option::Option<std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate>>,
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub replica_table_class: std::option::Option<crate::model::TableClass>,
}
impl ReplicaSettingsUpdate {
    /// <p>The Region of the replica to be added.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
    pub fn replica_provisioned_read_capacity_units(&self) -> std::option::Option<i64> {
        self.replica_provisioned_read_capacity_units
    }
    /// <p>Auto scaling settings for managing a global table replica's read capacity units.</p>
    pub fn replica_provisioned_read_capacity_auto_scaling_settings_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.replica_provisioned_read_capacity_auto_scaling_settings_update
            .as_ref()
    }
    /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
    pub fn replica_global_secondary_index_settings_update(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate]> {
        self.replica_global_secondary_index_settings_update
            .as_deref()
    }
    /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
    pub fn replica_table_class(&self) -> std::option::Option<&crate::model::TableClass> {
        self.replica_table_class.as_ref()
    }
}
impl std::fmt::Debug for ReplicaSettingsUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaSettingsUpdate");
        formatter.field("region_name", &self.region_name);
        formatter.field(
            "replica_provisioned_read_capacity_units",
            &self.replica_provisioned_read_capacity_units,
        );
        formatter.field(
            "replica_provisioned_read_capacity_auto_scaling_settings_update",
            &self.replica_provisioned_read_capacity_auto_scaling_settings_update,
        );
        formatter.field(
            "replica_global_secondary_index_settings_update",
            &self.replica_global_secondary_index_settings_update,
        );
        formatter.field("replica_table_class", &self.replica_table_class);
        formatter.finish()
    }
}
/// See [`ReplicaSettingsUpdate`](crate::model::ReplicaSettingsUpdate)
pub mod replica_settings_update {
    /// A builder for [`ReplicaSettingsUpdate`](crate::model::ReplicaSettingsUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) replica_provisioned_read_capacity_units: std::option::Option<i64>,
        pub(crate) replica_provisioned_read_capacity_auto_scaling_settings_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        pub(crate) replica_global_secondary_index_settings_update: std::option::Option<
            std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate>,
        >,
        pub(crate) replica_table_class: std::option::Option<crate::model::TableClass>,
    }
    impl Builder {
        /// <p>The Region of the replica to be added.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region of the replica to be added.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn replica_provisioned_read_capacity_units(mut self, input: i64) -> Self {
            self.replica_provisioned_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput">Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>. </p>
        pub fn set_replica_provisioned_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.replica_provisioned_read_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for managing a global table replica's read capacity units.</p>
        pub fn replica_provisioned_read_capacity_auto_scaling_settings_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings_update = Some(input);
            self
        }
        /// <p>Auto scaling settings for managing a global table replica's read capacity units.</p>
        pub fn set_replica_provisioned_read_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.replica_provisioned_read_capacity_auto_scaling_settings_update = input;
            self
        }
        /// Appends an item to `replica_global_secondary_index_settings_update`.
        ///
        /// To override the contents of this collection use [`set_replica_global_secondary_index_settings_update`](Self::set_replica_global_secondary_index_settings_update).
        ///
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn replica_global_secondary_index_settings_update(
            mut self,
            input: crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate,
        ) -> Self {
            let mut v = self
                .replica_global_secondary_index_settings_update
                .unwrap_or_default();
            v.push(input);
            self.replica_global_secondary_index_settings_update = Some(v);
            self
        }
        /// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
        pub fn set_replica_global_secondary_index_settings_update(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate>,
            >,
        ) -> Self {
            self.replica_global_secondary_index_settings_update = input;
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn replica_table_class(mut self, input: crate::model::TableClass) -> Self {
            self.replica_table_class = Some(input);
            self
        }
        /// <p>Replica-specific table class. If not specified, uses the source table's table class.</p>
        pub fn set_replica_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.replica_table_class = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaSettingsUpdate`](crate::model::ReplicaSettingsUpdate)
        pub fn build(self) -> crate::model::ReplicaSettingsUpdate {
            crate::model::ReplicaSettingsUpdate {
                region_name: self.region_name,
                replica_provisioned_read_capacity_units: self
                    .replica_provisioned_read_capacity_units,
                replica_provisioned_read_capacity_auto_scaling_settings_update: self
                    .replica_provisioned_read_capacity_auto_scaling_settings_update,
                replica_global_secondary_index_settings_update: self
                    .replica_global_secondary_index_settings_update,
                replica_table_class: self.replica_table_class,
            }
        }
    }
}
impl ReplicaSettingsUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicaSettingsUpdate`](crate::model::ReplicaSettingsUpdate)
    pub fn builder() -> crate::model::replica_settings_update::Builder {
        crate::model::replica_settings_update::Builder::default()
    }
}

/// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaGlobalSecondaryIndexSettingsUpdate {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub provisioned_read_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for managing a global secondary index replica's read capacity units.</p>
    pub provisioned_read_capacity_auto_scaling_settings_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
}
impl ReplicaGlobalSecondaryIndexSettingsUpdate {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
    pub fn provisioned_read_capacity_units(&self) -> std::option::Option<i64> {
        self.provisioned_read_capacity_units
    }
    /// <p>Auto scaling settings for managing a global secondary index replica's read capacity units.</p>
    pub fn provisioned_read_capacity_auto_scaling_settings_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.provisioned_read_capacity_auto_scaling_settings_update
            .as_ref()
    }
}
impl std::fmt::Debug for ReplicaGlobalSecondaryIndexSettingsUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaGlobalSecondaryIndexSettingsUpdate");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_read_capacity_units",
            &self.provisioned_read_capacity_units,
        );
        formatter.field(
            "provisioned_read_capacity_auto_scaling_settings_update",
            &self.provisioned_read_capacity_auto_scaling_settings_update,
        );
        formatter.finish()
    }
}
/// See [`ReplicaGlobalSecondaryIndexSettingsUpdate`](crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate)
pub mod replica_global_secondary_index_settings_update {
    /// A builder for [`ReplicaGlobalSecondaryIndexSettingsUpdate`](crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_read_capacity_units: std::option::Option<i64>,
        pub(crate) provisioned_read_capacity_auto_scaling_settings_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    }
    impl Builder {
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn provisioned_read_capacity_units(mut self, input: i64) -> Self {
            self.provisioned_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of strongly consistent reads consumed per second before DynamoDB returns a <code>ThrottlingException</code>.</p>
        pub fn set_provisioned_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.provisioned_read_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for managing a global secondary index replica's read capacity units.</p>
        pub fn provisioned_read_capacity_auto_scaling_settings_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings_update = Some(input);
            self
        }
        /// <p>Auto scaling settings for managing a global secondary index replica's read capacity units.</p>
        pub fn set_provisioned_read_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.provisioned_read_capacity_auto_scaling_settings_update = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaGlobalSecondaryIndexSettingsUpdate`](crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate)
        pub fn build(self) -> crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate {
            crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate {
                index_name: self.index_name,
                provisioned_read_capacity_units: self.provisioned_read_capacity_units,
                provisioned_read_capacity_auto_scaling_settings_update: self
                    .provisioned_read_capacity_auto_scaling_settings_update,
            }
        }
    }
}
impl ReplicaGlobalSecondaryIndexSettingsUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicaGlobalSecondaryIndexSettingsUpdate`](crate::model::ReplicaGlobalSecondaryIndexSettingsUpdate)
    pub fn builder() -> crate::model::replica_global_secondary_index_settings_update::Builder {
        crate::model::replica_global_secondary_index_settings_update::Builder::default()
    }
}

/// <p>Represents the settings of a global secondary index for a global table that will be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalTableGlobalSecondaryIndexSettingsUpdate {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
    pub provisioned_write_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for managing a global secondary index's write capacity units.</p>
    pub provisioned_write_capacity_auto_scaling_settings_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
}
impl GlobalTableGlobalSecondaryIndexSettingsUpdate {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
    pub fn provisioned_write_capacity_units(&self) -> std::option::Option<i64> {
        self.provisioned_write_capacity_units
    }
    /// <p>Auto scaling settings for managing a global secondary index's write capacity units.</p>
    pub fn provisioned_write_capacity_auto_scaling_settings_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.provisioned_write_capacity_auto_scaling_settings_update
            .as_ref()
    }
}
impl std::fmt::Debug for GlobalTableGlobalSecondaryIndexSettingsUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalTableGlobalSecondaryIndexSettingsUpdate");
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "provisioned_write_capacity_units",
            &self.provisioned_write_capacity_units,
        );
        formatter.field(
            "provisioned_write_capacity_auto_scaling_settings_update",
            &self.provisioned_write_capacity_auto_scaling_settings_update,
        );
        formatter.finish()
    }
}
/// See [`GlobalTableGlobalSecondaryIndexSettingsUpdate`](crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate)
pub mod global_table_global_secondary_index_settings_update {
    /// A builder for [`GlobalTableGlobalSecondaryIndexSettingsUpdate`](crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_write_capacity_units: std::option::Option<i64>,
        pub(crate) provisioned_write_capacity_auto_scaling_settings_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    }
    impl Builder {
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
        pub fn provisioned_write_capacity_units(mut self, input: i64) -> Self {
            self.provisioned_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code> </p>
        pub fn set_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.provisioned_write_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for managing a global secondary index's write capacity units.</p>
        pub fn provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings_update = Some(input);
            self
        }
        /// <p>Auto scaling settings for managing a global secondary index's write capacity units.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_settings_update = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalTableGlobalSecondaryIndexSettingsUpdate`](crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate)
        pub fn build(self) -> crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate {
            crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate {
                index_name: self.index_name,
                provisioned_write_capacity_units: self.provisioned_write_capacity_units,
                provisioned_write_capacity_auto_scaling_settings_update: self
                    .provisioned_write_capacity_auto_scaling_settings_update,
            }
        }
    }
}
impl GlobalTableGlobalSecondaryIndexSettingsUpdate {
    /// Creates a new builder-style object to manufacture [`GlobalTableGlobalSecondaryIndexSettingsUpdate`](crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate)
    pub fn builder() -> crate::model::global_table_global_secondary_index_settings_update::Builder {
        crate::model::global_table_global_secondary_index_settings_update::Builder::default()
    }
}

/// <p>Contains details about the global table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalTableDescription {
    /// <p>The Regions where the global table has replicas.</p>
    pub replication_group: std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
    /// <p>The unique identifier of the global table.</p>
    pub global_table_arn: std::option::Option<std::string::String>,
    /// <p>The creation time of the global table.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the global table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The global table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The global table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The global table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The global table is ready for use.</p> </li>
    /// </ul>
    pub global_table_status: std::option::Option<crate::model::GlobalTableStatus>,
    /// <p>The global table name.</p>
    pub global_table_name: std::option::Option<std::string::String>,
}
impl GlobalTableDescription {
    /// <p>The Regions where the global table has replicas.</p>
    pub fn replication_group(&self) -> std::option::Option<&[crate::model::ReplicaDescription]> {
        self.replication_group.as_deref()
    }
    /// <p>The unique identifier of the global table.</p>
    pub fn global_table_arn(&self) -> std::option::Option<&str> {
        self.global_table_arn.as_deref()
    }
    /// <p>The creation time of the global table.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The current state of the global table:</p>
    /// <ul>
    /// <li> <p> <code>CREATING</code> - The global table is being created.</p> </li>
    /// <li> <p> <code>UPDATING</code> - The global table is being updated.</p> </li>
    /// <li> <p> <code>DELETING</code> - The global table is being deleted.</p> </li>
    /// <li> <p> <code>ACTIVE</code> - The global table is ready for use.</p> </li>
    /// </ul>
    pub fn global_table_status(&self) -> std::option::Option<&crate::model::GlobalTableStatus> {
        self.global_table_status.as_ref()
    }
    /// <p>The global table name.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
}
impl std::fmt::Debug for GlobalTableDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalTableDescription");
        formatter.field("replication_group", &self.replication_group);
        formatter.field("global_table_arn", &self.global_table_arn);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("global_table_status", &self.global_table_status);
        formatter.field("global_table_name", &self.global_table_name);
        formatter.finish()
    }
}
/// See [`GlobalTableDescription`](crate::model::GlobalTableDescription)
pub mod global_table_description {
    /// A builder for [`GlobalTableDescription`](crate::model::GlobalTableDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_group:
            std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
        pub(crate) global_table_arn: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) global_table_status: std::option::Option<crate::model::GlobalTableStatus>,
        pub(crate) global_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replication_group`.
        ///
        /// To override the contents of this collection use [`set_replication_group`](Self::set_replication_group).
        ///
        /// <p>The Regions where the global table has replicas.</p>
        pub fn replication_group(mut self, input: crate::model::ReplicaDescription) -> Self {
            let mut v = self.replication_group.unwrap_or_default();
            v.push(input);
            self.replication_group = Some(v);
            self
        }
        /// <p>The Regions where the global table has replicas.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaDescription>>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// <p>The unique identifier of the global table.</p>
        pub fn global_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the global table.</p>
        pub fn set_global_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_arn = input;
            self
        }
        /// <p>The creation time of the global table.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The creation time of the global table.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The current state of the global table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The global table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The global table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The global table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The global table is ready for use.</p> </li>
        /// </ul>
        pub fn global_table_status(mut self, input: crate::model::GlobalTableStatus) -> Self {
            self.global_table_status = Some(input);
            self
        }
        /// <p>The current state of the global table:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code> - The global table is being created.</p> </li>
        /// <li> <p> <code>UPDATING</code> - The global table is being updated.</p> </li>
        /// <li> <p> <code>DELETING</code> - The global table is being deleted.</p> </li>
        /// <li> <p> <code>ACTIVE</code> - The global table is ready for use.</p> </li>
        /// </ul>
        pub fn set_global_table_status(
            mut self,
            input: std::option::Option<crate::model::GlobalTableStatus>,
        ) -> Self {
            self.global_table_status = input;
            self
        }
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalTableDescription`](crate::model::GlobalTableDescription)
        pub fn build(self) -> crate::model::GlobalTableDescription {
            crate::model::GlobalTableDescription {
                replication_group: self.replication_group,
                global_table_arn: self.global_table_arn,
                creation_date_time: self.creation_date_time,
                global_table_status: self.global_table_status,
                global_table_name: self.global_table_name,
            }
        }
    }
}
impl GlobalTableDescription {
    /// Creates a new builder-style object to manufacture [`GlobalTableDescription`](crate::model::GlobalTableDescription)
    pub fn builder() -> crate::model::global_table_description::Builder {
        crate::model::global_table_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GlobalTableStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GlobalTableStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => GlobalTableStatus::Active,
            "CREATING" => GlobalTableStatus::Creating,
            "DELETING" => GlobalTableStatus::Deleting,
            "UPDATING" => GlobalTableStatus::Updating,
            other => GlobalTableStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GlobalTableStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GlobalTableStatus::from(s))
    }
}
impl GlobalTableStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GlobalTableStatus::Active => "ACTIVE",
            GlobalTableStatus::Creating => "CREATING",
            GlobalTableStatus::Deleting => "DELETING",
            GlobalTableStatus::Updating => "UPDATING",
            GlobalTableStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for GlobalTableStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents one of the following:</p>
/// <ul>
/// <li> <p>A new replica to be added to an existing global table.</p> </li>
/// <li> <p>New parameters for an existing replica.</p> </li>
/// <li> <p>An existing replica to be removed from an existing global table.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaUpdate {
    /// <p>The parameters required for creating a replica on an existing global table.</p>
    pub create: std::option::Option<crate::model::CreateReplicaAction>,
    /// <p>The name of the existing replica to be removed.</p>
    pub delete: std::option::Option<crate::model::DeleteReplicaAction>,
}
impl ReplicaUpdate {
    /// <p>The parameters required for creating a replica on an existing global table.</p>
    pub fn create(&self) -> std::option::Option<&crate::model::CreateReplicaAction> {
        self.create.as_ref()
    }
    /// <p>The name of the existing replica to be removed.</p>
    pub fn delete(&self) -> std::option::Option<&crate::model::DeleteReplicaAction> {
        self.delete.as_ref()
    }
}
impl std::fmt::Debug for ReplicaUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaUpdate");
        formatter.field("create", &self.create);
        formatter.field("delete", &self.delete);
        formatter.finish()
    }
}
/// See [`ReplicaUpdate`](crate::model::ReplicaUpdate)
pub mod replica_update {
    /// A builder for [`ReplicaUpdate`](crate::model::ReplicaUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create: std::option::Option<crate::model::CreateReplicaAction>,
        pub(crate) delete: std::option::Option<crate::model::DeleteReplicaAction>,
    }
    impl Builder {
        /// <p>The parameters required for creating a replica on an existing global table.</p>
        pub fn create(mut self, input: crate::model::CreateReplicaAction) -> Self {
            self.create = Some(input);
            self
        }
        /// <p>The parameters required for creating a replica on an existing global table.</p>
        pub fn set_create(
            mut self,
            input: std::option::Option<crate::model::CreateReplicaAction>,
        ) -> Self {
            self.create = input;
            self
        }
        /// <p>The name of the existing replica to be removed.</p>
        pub fn delete(mut self, input: crate::model::DeleteReplicaAction) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>The name of the existing replica to be removed.</p>
        pub fn set_delete(
            mut self,
            input: std::option::Option<crate::model::DeleteReplicaAction>,
        ) -> Self {
            self.delete = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaUpdate`](crate::model::ReplicaUpdate)
        pub fn build(self) -> crate::model::ReplicaUpdate {
            crate::model::ReplicaUpdate {
                create: self.create,
                delete: self.delete,
            }
        }
    }
}
impl ReplicaUpdate {
    /// Creates a new builder-style object to manufacture [`ReplicaUpdate`](crate::model::ReplicaUpdate)
    pub fn builder() -> crate::model::replica_update::Builder {
        crate::model::replica_update::Builder::default()
    }
}

/// <p>Represents a replica to be removed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicaAction {
    /// <p>The Region of the replica to be removed.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl DeleteReplicaAction {
    /// <p>The Region of the replica to be removed.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteReplicaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicaAction");
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`DeleteReplicaAction`](crate::model::DeleteReplicaAction)
pub mod delete_replica_action {
    /// A builder for [`DeleteReplicaAction`](crate::model::DeleteReplicaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Region of the replica to be removed.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region of the replica to be removed.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicaAction`](crate::model::DeleteReplicaAction)
        pub fn build(self) -> crate::model::DeleteReplicaAction {
            crate::model::DeleteReplicaAction {
                region_name: self.region_name,
            }
        }
    }
}
impl DeleteReplicaAction {
    /// Creates a new builder-style object to manufacture [`DeleteReplicaAction`](crate::model::DeleteReplicaAction)
    pub fn builder() -> crate::model::delete_replica_action::Builder {
        crate::model::delete_replica_action::Builder::default()
    }
}

/// <p>Represents a replica to be added.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicaAction {
    /// <p>The Region of the replica to be added.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl CreateReplicaAction {
    /// <p>The Region of the replica to be added.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for CreateReplicaAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicaAction");
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`CreateReplicaAction`](crate::model::CreateReplicaAction)
pub mod create_replica_action {
    /// A builder for [`CreateReplicaAction`](crate::model::CreateReplicaAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Region of the replica to be added.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region of the replica to be added.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicaAction`](crate::model::CreateReplicaAction)
        pub fn build(self) -> crate::model::CreateReplicaAction {
            crate::model::CreateReplicaAction {
                region_name: self.region_name,
            }
        }
    }
}
impl CreateReplicaAction {
    /// Creates a new builder-style object to manufacture [`CreateReplicaAction`](crate::model::CreateReplicaAction)
    pub fn builder() -> crate::model::create_replica_action::Builder {
        crate::model::create_replica_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContributorInsightsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContributorInsightsStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ContributorInsightsStatus::Disabled,
            "DISABLING" => ContributorInsightsStatus::Disabling,
            "ENABLED" => ContributorInsightsStatus::Enabled,
            "ENABLING" => ContributorInsightsStatus::Enabling,
            "FAILED" => ContributorInsightsStatus::Failed,
            other => ContributorInsightsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContributorInsightsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContributorInsightsStatus::from(s))
    }
}
impl ContributorInsightsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContributorInsightsStatus::Disabled => "DISABLED",
            ContributorInsightsStatus::Disabling => "DISABLING",
            ContributorInsightsStatus::Enabled => "ENABLED",
            ContributorInsightsStatus::Enabling => "ENABLING",
            ContributorInsightsStatus::Failed => "FAILED",
            ContributorInsightsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING", "FAILED"]
    }
}
impl AsRef<str> for ContributorInsightsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContributorInsightsAction {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContributorInsightsAction {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE" => ContributorInsightsAction::Disable,
            "ENABLE" => ContributorInsightsAction::Enable,
            other => ContributorInsightsAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContributorInsightsAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContributorInsightsAction::from(s))
    }
}
impl ContributorInsightsAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContributorInsightsAction::Disable => "DISABLE",
            ContributorInsightsAction::Enable => "ENABLE",
            ContributorInsightsAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE", "ENABLE"]
    }
}
impl AsRef<str> for ContributorInsightsAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the continuous backups and point in time recovery settings on the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuousBackupsDescription {
    /// <p> <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED</p>
    pub continuous_backups_status: std::option::Option<crate::model::ContinuousBackupsStatus>,
    /// <p>The description of the point in time recovery settings applied to the table.</p>
    pub point_in_time_recovery_description:
        std::option::Option<crate::model::PointInTimeRecoveryDescription>,
}
impl ContinuousBackupsDescription {
    /// <p> <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED</p>
    pub fn continuous_backups_status(
        &self,
    ) -> std::option::Option<&crate::model::ContinuousBackupsStatus> {
        self.continuous_backups_status.as_ref()
    }
    /// <p>The description of the point in time recovery settings applied to the table.</p>
    pub fn point_in_time_recovery_description(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecoveryDescription> {
        self.point_in_time_recovery_description.as_ref()
    }
}
impl std::fmt::Debug for ContinuousBackupsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuousBackupsDescription");
        formatter.field("continuous_backups_status", &self.continuous_backups_status);
        formatter.field(
            "point_in_time_recovery_description",
            &self.point_in_time_recovery_description,
        );
        formatter.finish()
    }
}
/// See [`ContinuousBackupsDescription`](crate::model::ContinuousBackupsDescription)
pub mod continuous_backups_description {
    /// A builder for [`ContinuousBackupsDescription`](crate::model::ContinuousBackupsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continuous_backups_status:
            std::option::Option<crate::model::ContinuousBackupsStatus>,
        pub(crate) point_in_time_recovery_description:
            std::option::Option<crate::model::PointInTimeRecoveryDescription>,
    }
    impl Builder {
        /// <p> <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED</p>
        pub fn continuous_backups_status(
            mut self,
            input: crate::model::ContinuousBackupsStatus,
        ) -> Self {
            self.continuous_backups_status = Some(input);
            self
        }
        /// <p> <code>ContinuousBackupsStatus</code> can be one of the following states: ENABLED, DISABLED</p>
        pub fn set_continuous_backups_status(
            mut self,
            input: std::option::Option<crate::model::ContinuousBackupsStatus>,
        ) -> Self {
            self.continuous_backups_status = input;
            self
        }
        /// <p>The description of the point in time recovery settings applied to the table.</p>
        pub fn point_in_time_recovery_description(
            mut self,
            input: crate::model::PointInTimeRecoveryDescription,
        ) -> Self {
            self.point_in_time_recovery_description = Some(input);
            self
        }
        /// <p>The description of the point in time recovery settings applied to the table.</p>
        pub fn set_point_in_time_recovery_description(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoveryDescription>,
        ) -> Self {
            self.point_in_time_recovery_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ContinuousBackupsDescription`](crate::model::ContinuousBackupsDescription)
        pub fn build(self) -> crate::model::ContinuousBackupsDescription {
            crate::model::ContinuousBackupsDescription {
                continuous_backups_status: self.continuous_backups_status,
                point_in_time_recovery_description: self.point_in_time_recovery_description,
            }
        }
    }
}
impl ContinuousBackupsDescription {
    /// Creates a new builder-style object to manufacture [`ContinuousBackupsDescription`](crate::model::ContinuousBackupsDescription)
    pub fn builder() -> crate::model::continuous_backups_description::Builder {
        crate::model::continuous_backups_description::Builder::default()
    }
}

/// <p>The description of the point in time settings applied to the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRecoveryDescription {
    /// <p>The current state of point in time recovery:</p>
    /// <ul>
    /// <li> <p> <code>ENABLING</code> - Point in time recovery is being enabled.</p> </li>
    /// <li> <p> <code>ENABLED</code> - Point in time recovery is enabled.</p> </li>
    /// <li> <p> <code>DISABLED</code> - Point in time recovery is disabled.</p> </li>
    /// </ul>
    pub point_in_time_recovery_status: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
    /// <p>Specifies the earliest point in time you can restore your table to. You can restore your table to any point in time during the last 35 days. </p>
    pub earliest_restorable_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
    pub latest_restorable_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PointInTimeRecoveryDescription {
    /// <p>The current state of point in time recovery:</p>
    /// <ul>
    /// <li> <p> <code>ENABLING</code> - Point in time recovery is being enabled.</p> </li>
    /// <li> <p> <code>ENABLED</code> - Point in time recovery is enabled.</p> </li>
    /// <li> <p> <code>DISABLED</code> - Point in time recovery is disabled.</p> </li>
    /// </ul>
    pub fn point_in_time_recovery_status(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecoveryStatus> {
        self.point_in_time_recovery_status.as_ref()
    }
    /// <p>Specifies the earliest point in time you can restore your table to. You can restore your table to any point in time during the last 35 days. </p>
    pub fn earliest_restorable_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earliest_restorable_date_time.as_ref()
    }
    /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
    pub fn latest_restorable_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_restorable_date_time.as_ref()
    }
}
impl std::fmt::Debug for PointInTimeRecoveryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRecoveryDescription");
        formatter.field(
            "point_in_time_recovery_status",
            &self.point_in_time_recovery_status,
        );
        formatter.field(
            "earliest_restorable_date_time",
            &self.earliest_restorable_date_time,
        );
        formatter.field(
            "latest_restorable_date_time",
            &self.latest_restorable_date_time,
        );
        formatter.finish()
    }
}
/// See [`PointInTimeRecoveryDescription`](crate::model::PointInTimeRecoveryDescription)
pub mod point_in_time_recovery_description {
    /// A builder for [`PointInTimeRecoveryDescription`](crate::model::PointInTimeRecoveryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) point_in_time_recovery_status:
            std::option::Option<crate::model::PointInTimeRecoveryStatus>,
        pub(crate) earliest_restorable_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_restorable_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The current state of point in time recovery:</p>
        /// <ul>
        /// <li> <p> <code>ENABLING</code> - Point in time recovery is being enabled.</p> </li>
        /// <li> <p> <code>ENABLED</code> - Point in time recovery is enabled.</p> </li>
        /// <li> <p> <code>DISABLED</code> - Point in time recovery is disabled.</p> </li>
        /// </ul>
        pub fn point_in_time_recovery_status(
            mut self,
            input: crate::model::PointInTimeRecoveryStatus,
        ) -> Self {
            self.point_in_time_recovery_status = Some(input);
            self
        }
        /// <p>The current state of point in time recovery:</p>
        /// <ul>
        /// <li> <p> <code>ENABLING</code> - Point in time recovery is being enabled.</p> </li>
        /// <li> <p> <code>ENABLED</code> - Point in time recovery is enabled.</p> </li>
        /// <li> <p> <code>DISABLED</code> - Point in time recovery is disabled.</p> </li>
        /// </ul>
        pub fn set_point_in_time_recovery_status(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoveryStatus>,
        ) -> Self {
            self.point_in_time_recovery_status = input;
            self
        }
        /// <p>Specifies the earliest point in time you can restore your table to. You can restore your table to any point in time during the last 35 days. </p>
        pub fn earliest_restorable_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earliest_restorable_date_time = Some(input);
            self
        }
        /// <p>Specifies the earliest point in time you can restore your table to. You can restore your table to any point in time during the last 35 days. </p>
        pub fn set_earliest_restorable_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earliest_restorable_date_time = input;
            self
        }
        /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
        pub fn latest_restorable_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_restorable_date_time = Some(input);
            self
        }
        /// <p> <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. </p>
        pub fn set_latest_restorable_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_restorable_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRecoveryDescription`](crate::model::PointInTimeRecoveryDescription)
        pub fn build(self) -> crate::model::PointInTimeRecoveryDescription {
            crate::model::PointInTimeRecoveryDescription {
                point_in_time_recovery_status: self.point_in_time_recovery_status,
                earliest_restorable_date_time: self.earliest_restorable_date_time,
                latest_restorable_date_time: self.latest_restorable_date_time,
            }
        }
    }
}
impl PointInTimeRecoveryDescription {
    /// Creates a new builder-style object to manufacture [`PointInTimeRecoveryDescription`](crate::model::PointInTimeRecoveryDescription)
    pub fn builder() -> crate::model::point_in_time_recovery_description::Builder {
        crate::model::point_in_time_recovery_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PointInTimeRecoveryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PointInTimeRecoveryStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => PointInTimeRecoveryStatus::Disabled,
            "ENABLED" => PointInTimeRecoveryStatus::Enabled,
            other => PointInTimeRecoveryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PointInTimeRecoveryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PointInTimeRecoveryStatus::from(s))
    }
}
impl PointInTimeRecoveryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PointInTimeRecoveryStatus::Disabled => "DISABLED",
            PointInTimeRecoveryStatus::Enabled => "ENABLED",
            PointInTimeRecoveryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for PointInTimeRecoveryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContinuousBackupsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContinuousBackupsStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ContinuousBackupsStatus::Disabled,
            "ENABLED" => ContinuousBackupsStatus::Enabled,
            other => ContinuousBackupsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContinuousBackupsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContinuousBackupsStatus::from(s))
    }
}
impl ContinuousBackupsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContinuousBackupsStatus::Disabled => "DISABLED",
            ContinuousBackupsStatus::Enabled => "ENABLED",
            ContinuousBackupsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ContinuousBackupsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the settings used to enable point in time recovery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRecoverySpecification {
    /// <p>Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.</p>
    pub point_in_time_recovery_enabled: std::option::Option<bool>,
}
impl PointInTimeRecoverySpecification {
    /// <p>Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.</p>
    pub fn point_in_time_recovery_enabled(&self) -> std::option::Option<bool> {
        self.point_in_time_recovery_enabled
    }
}
impl std::fmt::Debug for PointInTimeRecoverySpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRecoverySpecification");
        formatter.field(
            "point_in_time_recovery_enabled",
            &self.point_in_time_recovery_enabled,
        );
        formatter.finish()
    }
}
/// See [`PointInTimeRecoverySpecification`](crate::model::PointInTimeRecoverySpecification)
pub mod point_in_time_recovery_specification {
    /// A builder for [`PointInTimeRecoverySpecification`](crate::model::PointInTimeRecoverySpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) point_in_time_recovery_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.</p>
        pub fn point_in_time_recovery_enabled(mut self, input: bool) -> Self {
            self.point_in_time_recovery_enabled = Some(input);
            self
        }
        /// <p>Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.</p>
        pub fn set_point_in_time_recovery_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.point_in_time_recovery_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRecoverySpecification`](crate::model::PointInTimeRecoverySpecification)
        pub fn build(self) -> crate::model::PointInTimeRecoverySpecification {
            crate::model::PointInTimeRecoverySpecification {
                point_in_time_recovery_enabled: self.point_in_time_recovery_enabled,
            }
        }
    }
}
impl PointInTimeRecoverySpecification {
    /// Creates a new builder-style object to manufacture [`PointInTimeRecoverySpecification`](crate::model::PointInTimeRecoverySpecification)
    pub fn builder() -> crate::model::point_in_time_recovery_specification::Builder {
        crate::model::point_in_time_recovery_specification::Builder::default()
    }
}

/// <p>An ordered list of errors for each item in the request which caused the transaction to get cancelled. The values of the list are ordered according to the ordering of the <code>TransactWriteItems</code> request parameter. If no error occurred for the associated item an error with a Null code and Null message will be present. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancellationReason {
    /// <p>Item in the request which caused the transaction to get cancelled.</p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Status code for the result of the cancelled transaction.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>Cancellation reason message description.</p>
    pub message: std::option::Option<std::string::String>,
}
impl CancellationReason {
    /// <p>Item in the request which caused the transaction to get cancelled.</p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
    /// <p>Status code for the result of the cancelled transaction.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>Cancellation reason message description.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for CancellationReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancellationReason");
        formatter.field("item", &self.item);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`CancellationReason`](crate::model::CancellationReason)
pub mod cancellation_reason {
    /// A builder for [`CancellationReason`](crate::model::CancellationReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>Item in the request which caused the transaction to get cancelled.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item = Some(hash_map);
            self
        }
        /// <p>Item in the request which caused the transaction to get cancelled.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// <p>Status code for the result of the cancelled transaction.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>Status code for the result of the cancelled transaction.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>Cancellation reason message description.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Cancellation reason message description.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CancellationReason`](crate::model::CancellationReason)
        pub fn build(self) -> crate::model::CancellationReason {
            crate::model::CancellationReason {
                item: self.item,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl CancellationReason {
    /// Creates a new builder-style object to manufacture [`CancellationReason`](crate::model::CancellationReason)
    pub fn builder() -> crate::model::cancellation_reason::Builder {
        crate::model::cancellation_reason::Builder::default()
    }
}

/// <p>A list of requests that can perform update, put, delete, or check operations on multiple items in one or more tables atomically.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactWriteItem {
    /// <p>A request to perform a check item operation.</p>
    pub condition_check: std::option::Option<crate::model::ConditionCheck>,
    /// <p>A request to perform a <code>PutItem</code> operation.</p>
    pub put: std::option::Option<crate::model::Put>,
    /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
    pub delete: std::option::Option<crate::model::Delete>,
    /// <p>A request to perform an <code>UpdateItem</code> operation.</p>
    pub update: std::option::Option<crate::model::Update>,
}
impl TransactWriteItem {
    /// <p>A request to perform a check item operation.</p>
    pub fn condition_check(&self) -> std::option::Option<&crate::model::ConditionCheck> {
        self.condition_check.as_ref()
    }
    /// <p>A request to perform a <code>PutItem</code> operation.</p>
    pub fn put(&self) -> std::option::Option<&crate::model::Put> {
        self.put.as_ref()
    }
    /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
    pub fn delete(&self) -> std::option::Option<&crate::model::Delete> {
        self.delete.as_ref()
    }
    /// <p>A request to perform an <code>UpdateItem</code> operation.</p>
    pub fn update(&self) -> std::option::Option<&crate::model::Update> {
        self.update.as_ref()
    }
}
impl std::fmt::Debug for TransactWriteItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactWriteItem");
        formatter.field("condition_check", &self.condition_check);
        formatter.field("put", &self.put);
        formatter.field("delete", &self.delete);
        formatter.field("update", &self.update);
        formatter.finish()
    }
}
/// See [`TransactWriteItem`](crate::model::TransactWriteItem)
pub mod transact_write_item {
    /// A builder for [`TransactWriteItem`](crate::model::TransactWriteItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition_check: std::option::Option<crate::model::ConditionCheck>,
        pub(crate) put: std::option::Option<crate::model::Put>,
        pub(crate) delete: std::option::Option<crate::model::Delete>,
        pub(crate) update: std::option::Option<crate::model::Update>,
    }
    impl Builder {
        /// <p>A request to perform a check item operation.</p>
        pub fn condition_check(mut self, input: crate::model::ConditionCheck) -> Self {
            self.condition_check = Some(input);
            self
        }
        /// <p>A request to perform a check item operation.</p>
        pub fn set_condition_check(
            mut self,
            input: std::option::Option<crate::model::ConditionCheck>,
        ) -> Self {
            self.condition_check = input;
            self
        }
        /// <p>A request to perform a <code>PutItem</code> operation.</p>
        pub fn put(mut self, input: crate::model::Put) -> Self {
            self.put = Some(input);
            self
        }
        /// <p>A request to perform a <code>PutItem</code> operation.</p>
        pub fn set_put(mut self, input: std::option::Option<crate::model::Put>) -> Self {
            self.put = input;
            self
        }
        /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
        pub fn delete(mut self, input: crate::model::Delete) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
        pub fn set_delete(mut self, input: std::option::Option<crate::model::Delete>) -> Self {
            self.delete = input;
            self
        }
        /// <p>A request to perform an <code>UpdateItem</code> operation.</p>
        pub fn update(mut self, input: crate::model::Update) -> Self {
            self.update = Some(input);
            self
        }
        /// <p>A request to perform an <code>UpdateItem</code> operation.</p>
        pub fn set_update(mut self, input: std::option::Option<crate::model::Update>) -> Self {
            self.update = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactWriteItem`](crate::model::TransactWriteItem)
        pub fn build(self) -> crate::model::TransactWriteItem {
            crate::model::TransactWriteItem {
                condition_check: self.condition_check,
                put: self.put,
                delete: self.delete,
                update: self.update,
            }
        }
    }
}
impl TransactWriteItem {
    /// Creates a new builder-style object to manufacture [`TransactWriteItem`](crate::model::TransactWriteItem)
    pub fn builder() -> crate::model::transact_write_item::Builder {
        crate::model::transact_write_item::Builder::default()
    }
}

/// <p>Represents a request to perform an <code>UpdateItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Update {
    /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.</p>
    pub update_expression: std::option::Option<std::string::String>,
    /// <p>Name of the table for the <code>UpdateItem</code> request.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.</p>
    pub return_values_on_condition_check_failure:
        std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
}
impl Update {
    /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.</p>
    pub fn update_expression(&self) -> std::option::Option<&str> {
        self.update_expression.as_deref()
    }
    /// <p>Name of the table for the <code>UpdateItem</code> request.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.</p>
    pub fn return_values_on_condition_check_failure(
        &self,
    ) -> std::option::Option<&crate::model::ReturnValuesOnConditionCheckFailure> {
        self.return_values_on_condition_check_failure.as_ref()
    }
}
impl std::fmt::Debug for Update {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Update");
        formatter.field("key", &self.key);
        formatter.field("update_expression", &self.update_expression);
        formatter.field("table_name", &self.table_name);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.field(
            "return_values_on_condition_check_failure",
            &self.return_values_on_condition_check_failure,
        );
        formatter.finish()
    }
}
/// See [`Update`](crate::model::Update)
pub mod update {
    /// A builder for [`Update`](crate::model::Update)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) update_expression: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_values_on_condition_check_failure:
            std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
    }
    impl Builder {
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.</p>
        pub fn update_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_expression = Some(input.into());
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.</p>
        pub fn set_update_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_expression = input;
            self
        }
        /// <p>Name of the table for the <code>UpdateItem</code> request.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table for the <code>UpdateItem</code> request.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.</p>
        pub fn return_values_on_condition_check_failure(
            mut self,
            input: crate::model::ReturnValuesOnConditionCheckFailure,
        ) -> Self {
            self.return_values_on_condition_check_failure = Some(input);
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Update</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.</p>
        pub fn set_return_values_on_condition_check_failure(
            mut self,
            input: std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
        ) -> Self {
            self.return_values_on_condition_check_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`Update`](crate::model::Update)
        pub fn build(self) -> crate::model::Update {
            crate::model::Update {
                key: self.key,
                update_expression: self.update_expression,
                table_name: self.table_name,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
                return_values_on_condition_check_failure: self
                    .return_values_on_condition_check_failure,
            }
        }
    }
}
impl Update {
    /// Creates a new builder-style object to manufacture [`Update`](crate::model::Update)
    pub fn builder() -> crate::model::update::Builder {
        crate::model::update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReturnValuesOnConditionCheckFailure {
    #[allow(missing_docs)] // documentation missing in model
    AllOld,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReturnValuesOnConditionCheckFailure {
    fn from(s: &str) -> Self {
        match s {
            "ALL_OLD" => ReturnValuesOnConditionCheckFailure::AllOld,
            "NONE" => ReturnValuesOnConditionCheckFailure::None,
            other => ReturnValuesOnConditionCheckFailure::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReturnValuesOnConditionCheckFailure {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReturnValuesOnConditionCheckFailure::from(s))
    }
}
impl ReturnValuesOnConditionCheckFailure {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReturnValuesOnConditionCheckFailure::AllOld => "ALL_OLD",
            ReturnValuesOnConditionCheckFailure::None => "NONE",
            ReturnValuesOnConditionCheckFailure::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_OLD", "NONE"]
    }
}
impl AsRef<str> for ReturnValuesOnConditionCheckFailure {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a request to perform a <code>DeleteItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Delete {
    /// <p>The primary key of the item to be deleted. Each element consists of an attribute name and a value for that attribute.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Name of the table in which the item to be deleted resides.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A condition that must be satisfied in order for a conditional delete to succeed.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Delete</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub return_values_on_condition_check_failure:
        std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
}
impl Delete {
    /// <p>The primary key of the item to be deleted. Each element consists of an attribute name and a value for that attribute.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>Name of the table in which the item to be deleted resides.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A condition that must be satisfied in order for a conditional delete to succeed.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Delete</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub fn return_values_on_condition_check_failure(
        &self,
    ) -> std::option::Option<&crate::model::ReturnValuesOnConditionCheckFailure> {
        self.return_values_on_condition_check_failure.as_ref()
    }
}
impl std::fmt::Debug for Delete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Delete");
        formatter.field("key", &self.key);
        formatter.field("table_name", &self.table_name);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.field(
            "return_values_on_condition_check_failure",
            &self.return_values_on_condition_check_failure,
        );
        formatter.finish()
    }
}
/// See [`Delete`](crate::model::Delete)
pub mod delete {
    /// A builder for [`Delete`](crate::model::Delete)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_values_on_condition_check_failure:
            std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
    }
    impl Builder {
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be deleted. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item to be deleted. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>Name of the table in which the item to be deleted resides.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table in which the item to be deleted resides.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional delete to succeed.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional delete to succeed.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Delete</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn return_values_on_condition_check_failure(
            mut self,
            input: crate::model::ReturnValuesOnConditionCheckFailure,
        ) -> Self {
            self.return_values_on_condition_check_failure = Some(input);
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Delete</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn set_return_values_on_condition_check_failure(
            mut self,
            input: std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
        ) -> Self {
            self.return_values_on_condition_check_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`Delete`](crate::model::Delete)
        pub fn build(self) -> crate::model::Delete {
            crate::model::Delete {
                key: self.key,
                table_name: self.table_name,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
                return_values_on_condition_check_failure: self
                    .return_values_on_condition_check_failure,
            }
        }
    }
}
impl Delete {
    /// Creates a new builder-style object to manufacture [`Delete`](crate::model::Delete)
    pub fn builder() -> crate::model::delete::Builder {
        crate::model::delete::Builder::default()
    }
}

/// <p>Represents a request to perform a <code>PutItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Put {
    /// <p>A map of attribute name to attribute values, representing the primary key of the item to be written by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema. </p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Name of the table in which to write the item.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub return_values_on_condition_check_failure:
        std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
}
impl Put {
    /// <p>A map of attribute name to attribute values, representing the primary key of the item to be written by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema. </p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
    /// <p>Name of the table in which to write the item.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub fn return_values_on_condition_check_failure(
        &self,
    ) -> std::option::Option<&crate::model::ReturnValuesOnConditionCheckFailure> {
        self.return_values_on_condition_check_failure.as_ref()
    }
}
impl std::fmt::Debug for Put {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Put");
        formatter.field("item", &self.item);
        formatter.field("table_name", &self.table_name);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.field(
            "return_values_on_condition_check_failure",
            &self.return_values_on_condition_check_failure,
        );
        formatter.finish()
    }
}
/// See [`Put`](crate::model::Put)
pub mod put {
    /// A builder for [`Put`](crate::model::Put)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_values_on_condition_check_failure:
            std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
    }
    impl Builder {
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute name to attribute values, representing the primary key of the item to be written by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema. </p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item = Some(hash_map);
            self
        }
        /// <p>A map of attribute name to attribute values, representing the primary key of the item to be written by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema. </p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// <p>Name of the table in which to write the item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table in which to write the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn return_values_on_condition_check_failure(
            mut self,
            input: crate::model::ReturnValuesOnConditionCheckFailure,
        ) -> Self {
            self.return_values_on_condition_check_failure = Some(input);
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>Put</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn set_return_values_on_condition_check_failure(
            mut self,
            input: std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
        ) -> Self {
            self.return_values_on_condition_check_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`Put`](crate::model::Put)
        pub fn build(self) -> crate::model::Put {
            crate::model::Put {
                item: self.item,
                table_name: self.table_name,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
                return_values_on_condition_check_failure: self
                    .return_values_on_condition_check_failure,
            }
        }
    }
}
impl Put {
    /// Creates a new builder-style object to manufacture [`Put`](crate::model::Put)
    pub fn builder() -> crate::model::put::Builder {
        crate::model::put::Builder::default()
    }
}

/// <p>Represents a request to perform a check that an item exists or to check the condition of specific attributes of the item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionCheck {
    /// <p>The primary key of the item to be checked. Each element consists of an attribute name and a value for that attribute.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Name of the table for the check item request.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>ConditionCheck</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub return_values_on_condition_check_failure:
        std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
}
impl ConditionCheck {
    /// <p>The primary key of the item to be checked. Each element consists of an attribute name and a value for that attribute.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>Name of the table for the check item request.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
    /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>ConditionCheck</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
    pub fn return_values_on_condition_check_failure(
        &self,
    ) -> std::option::Option<&crate::model::ReturnValuesOnConditionCheckFailure> {
        self.return_values_on_condition_check_failure.as_ref()
    }
}
impl std::fmt::Debug for ConditionCheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionCheck");
        formatter.field("key", &self.key);
        formatter.field("table_name", &self.table_name);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.field(
            "return_values_on_condition_check_failure",
            &self.return_values_on_condition_check_failure,
        );
        formatter.finish()
    }
}
/// See [`ConditionCheck`](crate::model::ConditionCheck)
pub mod condition_check {
    /// A builder for [`ConditionCheck`](crate::model::ConditionCheck)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_values_on_condition_check_failure:
            std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
    }
    impl Builder {
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be checked. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item to be checked. Each element consists of an attribute name and a value for that attribute.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>Name of the table for the check item request.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table for the check item request.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to succeed.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>ConditionCheck</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn return_values_on_condition_check_failure(
            mut self,
            input: crate::model::ReturnValuesOnConditionCheckFailure,
        ) -> Self {
            self.return_values_on_condition_check_failure = Some(input);
            self
        }
        /// <p>Use <code>ReturnValuesOnConditionCheckFailure</code> to get the item attributes if the <code>ConditionCheck</code> condition fails. For <code>ReturnValuesOnConditionCheckFailure</code>, the valid values are: NONE and ALL_OLD.</p>
        pub fn set_return_values_on_condition_check_failure(
            mut self,
            input: std::option::Option<crate::model::ReturnValuesOnConditionCheckFailure>,
        ) -> Self {
            self.return_values_on_condition_check_failure = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionCheck`](crate::model::ConditionCheck)
        pub fn build(self) -> crate::model::ConditionCheck {
            crate::model::ConditionCheck {
                key: self.key,
                table_name: self.table_name,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
                return_values_on_condition_check_failure: self
                    .return_values_on_condition_check_failure,
            }
        }
    }
}
impl ConditionCheck {
    /// Creates a new builder-style object to manufacture [`ConditionCheck`](crate::model::ConditionCheck)
    pub fn builder() -> crate::model::condition_check::Builder {
        crate::model::condition_check::Builder::default()
    }
}

/// <p>Details for the requested item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemResponse {
    /// <p>Map of attribute data consisting of the data type and attribute value.</p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl ItemResponse {
    /// <p>Map of attribute data consisting of the data type and attribute value.</p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
}
impl std::fmt::Debug for ItemResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemResponse");
        formatter.field("item", &self.item);
        formatter.finish()
    }
}
/// See [`ItemResponse`](crate::model::ItemResponse)
pub mod item_response {
    /// A builder for [`ItemResponse`](crate::model::ItemResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>Map of attribute data consisting of the data type and attribute value.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item = Some(hash_map);
            self
        }
        /// <p>Map of attribute data consisting of the data type and attribute value.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemResponse`](crate::model::ItemResponse)
        pub fn build(self) -> crate::model::ItemResponse {
            crate::model::ItemResponse { item: self.item }
        }
    }
}
impl ItemResponse {
    /// Creates a new builder-style object to manufacture [`ItemResponse`](crate::model::ItemResponse)
    pub fn builder() -> crate::model::item_response::Builder {
        crate::model::item_response::Builder::default()
    }
}

/// <p>Specifies an item to be retrieved as part of the transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactGetItem {
    /// <p>Contains the primary key that identifies the item to get, together with the name of the table that contains the item, and optionally the specific attributes of the item to retrieve.</p>
    pub get: std::option::Option<crate::model::Get>,
}
impl TransactGetItem {
    /// <p>Contains the primary key that identifies the item to get, together with the name of the table that contains the item, and optionally the specific attributes of the item to retrieve.</p>
    pub fn get(&self) -> std::option::Option<&crate::model::Get> {
        self.get.as_ref()
    }
}
impl std::fmt::Debug for TransactGetItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactGetItem");
        formatter.field("get", &self.get);
        formatter.finish()
    }
}
/// See [`TransactGetItem`](crate::model::TransactGetItem)
pub mod transact_get_item {
    /// A builder for [`TransactGetItem`](crate::model::TransactGetItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) get: std::option::Option<crate::model::Get>,
    }
    impl Builder {
        /// <p>Contains the primary key that identifies the item to get, together with the name of the table that contains the item, and optionally the specific attributes of the item to retrieve.</p>
        pub fn get(mut self, input: crate::model::Get) -> Self {
            self.get = Some(input);
            self
        }
        /// <p>Contains the primary key that identifies the item to get, together with the name of the table that contains the item, and optionally the specific attributes of the item to retrieve.</p>
        pub fn set_get(mut self, input: std::option::Option<crate::model::Get>) -> Self {
            self.get = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactGetItem`](crate::model::TransactGetItem)
        pub fn build(self) -> crate::model::TransactGetItem {
            crate::model::TransactGetItem { get: self.get }
        }
    }
}
impl TransactGetItem {
    /// Creates a new builder-style object to manufacture [`TransactGetItem`](crate::model::TransactGetItem)
    pub fn builder() -> crate::model::transact_get_item::Builder {
        crate::model::transact_get_item::Builder::default()
    }
}

/// <p>Specifies an item and related attribute values to retrieve in a <code>TransactGetItem</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Get {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to retrieve.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The name of the table from which to retrieve the specified item.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes in the expression must be separated by commas. If no attribute names are specified, then all attributes of the specified item are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
    pub projection_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in the ProjectionExpression parameter.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Get {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to retrieve.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>The name of the table from which to retrieve the specified item.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes in the expression must be separated by commas. If no attribute names are specified, then all attributes of the specified item are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
    pub fn projection_expression(&self) -> std::option::Option<&str> {
        self.projection_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in the ProjectionExpression parameter.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
}
impl std::fmt::Debug for Get {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Get");
        formatter.field("key", &self.key);
        formatter.field("table_name", &self.table_name);
        formatter.field("projection_expression", &self.projection_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.finish()
    }
}
/// See [`Get`](crate::model::Get)
pub mod get {
    /// A builder for [`Get`](crate::model::Get)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) projection_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to retrieve.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.key = Some(hash_map);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to retrieve.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The name of the table from which to retrieve the specified item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table from which to retrieve the specified item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes in the expression must be separated by commas. If no attribute names are specified, then all attributes of the specified item are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.projection_expression = Some(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes in the expression must be separated by commas. If no attribute names are specified, then all attributes of the specified item are returned. If any of the requested attributes are not found, they do not appear in the result.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.projection_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in the ProjectionExpression parameter.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in the ProjectionExpression parameter.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`Get`](crate::model::Get)
        pub fn build(self) -> crate::model::Get {
            crate::model::Get {
                key: self.key,
                table_name: self.table_name,
                projection_expression: self.projection_expression,
                expression_attribute_names: self.expression_attribute_names,
            }
        }
    }
}
impl Get {
    /// Creates a new builder-style object to manufacture [`Get`](crate::model::Get)
    pub fn builder() -> crate::model::get::Builder {
        crate::model::get::Builder::default()
    }
}

/// <p>Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single DynamoDB table. </p>
/// <p>Amazon Web Services-assigned tag names and values are automatically assigned the <code>aws:</code> prefix, which the user cannot assign. Amazon Web Services-assigned tag names do not count towards the tag limit of 50. User-assigned tag names have the prefix <code>user:</code> in the Cost Allocation Report. You cannot backdate the application of a tag.</p>
/// <p>For an overview on tagging DynamoDB resources, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag. Tag values are case-sensitive and can be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Represents the selection criteria for a <code>Query</code> or <code>Scan</code> operation:</p>
/// <ul>
/// <li> <p>For a <code>Query</code> operation, <code>Condition</code> is used for specifying the <code>KeyConditions</code> to use when querying a table or an index. For <code>KeyConditions</code>, only the following comparison operators are supported:</p> <p> <code>EQ | LE | LT | GE | GT | BEGINS_WITH | BETWEEN</code> </p> <p> <code>Condition</code> is also used in a <code>QueryFilter</code>, which evaluates the query results and returns only the desired values.</p> </li>
/// <li> <p>For a <code>Scan</code> operation, <code>Condition</code> is used in a <code>ScanFilter</code>, which evaluates the scan results and returns only the desired values.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
    /// <p>For type Number, value comparisons are numeric.</p>
    /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
    /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
    pub attribute_value_list: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    /// <p>A comparator for evaluating attributes. For example, equals, greater than, less than, etc.</p>
    /// <p>The following comparison operators are available:</p>
    /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
    /// <p>The following are descriptions of each comparison operator.</p>
    /// <ul>
    /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
    /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
    /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
    /// </ul>
    /// <p>For usage examples of <code>AttributeValueList</code> and <code>ComparisonOperator</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
}
impl Condition {
    /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
    /// <p>For type Number, value comparisons are numeric.</p>
    /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
    /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
    pub fn attribute_value_list(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.attribute_value_list.as_deref()
    }
    /// <p>A comparator for evaluating attributes. For example, equals, greater than, less than, etc.</p>
    /// <p>The following comparison operators are available:</p>
    /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
    /// <p>The following are descriptions of each comparison operator.</p>
    /// <ul>
    /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
    /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
    /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
    /// </note> </li>
    /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
    /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
    /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
    /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
    /// </ul>
    /// <p>For usage examples of <code>AttributeValueList</code> and <code>ComparisonOperator</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("attribute_value_list", &self.attribute_value_list);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_value_list:
            std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    }
    impl Builder {
        /// Appends an item to `attribute_value_list`.
        ///
        /// To override the contents of this collection use [`set_attribute_value_list`](Self::set_attribute_value_list).
        ///
        /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
        /// <p>For type Number, value comparisons are numeric.</p>
        /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
        /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
        pub fn attribute_value_list(mut self, input: crate::model::AttributeValue) -> Self {
            let mut v = self.attribute_value_list.unwrap_or_default();
            v.push(input);
            self.attribute_value_list = Some(v);
            self
        }
        /// <p>One or more values to evaluate against the supplied attribute. The number of values in the list depends on the <code>ComparisonOperator</code> being used.</p>
        /// <p>For type Number, value comparisons are numeric.</p>
        /// <p>String value comparisons for greater than, equals, or less than are based on ASCII character code values. For example, <code>a</code> is greater than <code>A</code>, and <code>a</code> is greater than <code>B</code>. For a list of code values, see <a href="http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters">http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters</a>.</p>
        /// <p>For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares binary values.</p>
        pub fn set_attribute_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.attribute_value_list = input;
            self
        }
        /// <p>A comparator for evaluating attributes. For example, equals, greater than, less than, etc.</p>
        /// <p>The following comparison operators are available:</p>
        /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
        /// <p>The following are descriptions of each comparison operator.</p>
        /// <ul>
        /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
        /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
        /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
        /// </ul>
        /// <p>For usage examples of <code>AttributeValueList</code> and <code>ComparisonOperator</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>A comparator for evaluating attributes. For example, equals, greater than, less than, etc.</p>
        /// <p>The following comparison operators are available:</p>
        /// <p> <code>EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH | IN | BETWEEN</code> </p>
        /// <p>The following are descriptions of each comparison operator.</p>
        /// <ul>
        /// <li> <p> <code>EQ</code> : Equal. <code>EQ</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NE</code> : Not equal. <code>NE</code> is supported for all data types, including lists and maps.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, Binary, String Set, Number Set, or Binary Set. If an item contains an <code>AttributeValue</code> of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not equal <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LE</code> : Less than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>LT</code> : Less than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GE</code> : Greater than or equal. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>GT</code> : Greater than. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not equal <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code>.</p> <p></p> </li>
        /// <li> <p> <code>NOT_NULL</code> : The attribute exists. <code>NOT_NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the existence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NOT_NULL</code>, the result is a Boolean <code>true</code>. This result is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NOT_NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>NULL</code> : The attribute does not exist. <code>NULL</code> is supported for all data types, including lists and maps.</p> <note>
        /// <p>This operator tests for the nonexistence of an attribute, not its data type. If the data type of attribute "<code>a</code>" is null, and you evaluate it using <code>NULL</code>, the result is a Boolean <code>false</code>. This is because the attribute "<code>a</code>" exists; its data type is not relevant to the <code>NULL</code> comparison operator.</p>
        /// </note> </li>
        /// <li> <p> <code>CONTAINS</code> : Checks for a subsequence, or value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is of type String, then the operator checks for a substring match. If the target attribute of the comparison is of type Binary, then the operator looks for a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it finds an exact match with any member of the set.</p> <p>CONTAINS is supported for lists: When evaluating "<code>a CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>NOT_CONTAINS</code> : Checks for absence of a subsequence, or absence of a value in a set.</p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> element of type String, Number, or Binary (not a set type). If the target attribute of the comparison is a String, then the operator checks for the absence of a substring match. If the target attribute of the comparison is Binary, then the operator checks for the absence of a subsequence of the target that matches the input. If the target attribute of the comparison is a set ("<code>SS</code>", "<code>NS</code>", or "<code>BS</code>"), then the operator evaluates to true if it <i>does not</i> find an exact match with any member of the set.</p> <p>NOT_CONTAINS is supported for lists: When evaluating "<code>a NOT CONTAINS b</code>", "<code>a</code>" can be a list; however, "<code>b</code>" cannot be a set, a map, or a list.</p> </li>
        /// <li> <p> <code>BEGINS_WITH</code> : Checks for a prefix. </p> <p> <code>AttributeValueList</code> can contain only one <code>AttributeValue</code> of type String or Binary (not a Number or a set type). The target attribute of the comparison must be of type String or Binary (not a Number or a set type).</p> <p></p> </li>
        /// <li> <p> <code>IN</code> : Checks for matching elements in a list.</p> <p> <code>AttributeValueList</code> can contain one or more <code>AttributeValue</code> elements of type String, Number, or Binary. These attributes are compared against an existing attribute of an item. If any elements of the input are equal to the item attribute, the expression evaluates to true.</p> </li>
        /// <li> <p> <code>BETWEEN</code> : Greater than or equal to the first value, and less than or equal to the second value. </p> <p> <code>AttributeValueList</code> must contain two <code>AttributeValue</code> elements of the same type, either String, Number, or Binary (not a set type). A target attribute matches if the target value is greater than, or equal to, the first element and less than, or equal to, the second element. If an item contains an <code>AttributeValue</code> element of a different type than the one provided in the request, the value does not match. For example, <code>{"S":"6"}</code> does not compare to <code>{"N":"6"}</code>. Also, <code>{"N":"6"}</code> does not compare to <code>{"NS":["6", "2", "1"]}</code> </p> </li>
        /// </ul>
        /// <p>For usage examples of <code>AttributeValueList</code> and <code>ComparisonOperator</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                attribute_value_list: self.attribute_value_list,
                comparison_operator: self.comparison_operator,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Select {
    #[allow(missing_docs)] // documentation missing in model
    AllAttributes,
    #[allow(missing_docs)] // documentation missing in model
    AllProjectedAttributes,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    SpecificAttributes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Select {
    fn from(s: &str) -> Self {
        match s {
            "ALL_ATTRIBUTES" => Select::AllAttributes,
            "ALL_PROJECTED_ATTRIBUTES" => Select::AllProjectedAttributes,
            "COUNT" => Select::Count,
            "SPECIFIC_ATTRIBUTES" => Select::SpecificAttributes,
            other => Select::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Select {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Select::from(s))
    }
}
impl Select {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Select::AllAttributes => "ALL_ATTRIBUTES",
            Select::AllProjectedAttributes => "ALL_PROJECTED_ATTRIBUTES",
            Select::Count => "COUNT",
            Select::SpecificAttributes => "SPECIFIC_ATTRIBUTES",
            Select::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL_ATTRIBUTES",
            "ALL_PROJECTED_ATTRIBUTES",
            "COUNT",
            "SPECIFIC_ATTRIBUTES",
        ]
    }
}
impl AsRef<str> for Select {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the properties of a local secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalSecondaryIndex {
    /// <p>The name of the local secondary index. The name must be unique among all other indexes on this table.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
}
impl LocalSecondaryIndex {
    /// <p>The name of the local secondary index. The name must be unique among all other indexes on this table.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
}
impl std::fmt::Debug for LocalSecondaryIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalSecondaryIndex");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.finish()
    }
}
/// See [`LocalSecondaryIndex`](crate::model::LocalSecondaryIndex)
pub mod local_secondary_index {
    /// A builder for [`LocalSecondaryIndex`](crate::model::LocalSecondaryIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
    }
    impl Builder {
        /// <p>The name of the local secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the local secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalSecondaryIndex`](crate::model::LocalSecondaryIndex)
        pub fn build(self) -> crate::model::LocalSecondaryIndex {
            crate::model::LocalSecondaryIndex {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
            }
        }
    }
}
impl LocalSecondaryIndex {
    /// Creates a new builder-style object to manufacture [`LocalSecondaryIndex`](crate::model::LocalSecondaryIndex)
    pub fn builder() -> crate::model::local_secondary_index::Builder {
        crate::model::local_secondary_index::Builder::default()
    }
}

/// <p>Represents the properties of a global secondary index.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSecondaryIndex {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
}
impl GlobalSecondaryIndex {
    /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
    /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
}
impl std::fmt::Debug for GlobalSecondaryIndex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSecondaryIndex");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.finish()
    }
}
/// See [`GlobalSecondaryIndex`](crate::model::GlobalSecondaryIndex)
pub mod global_secondary_index {
    /// A builder for [`GlobalSecondaryIndex`](crate::model::GlobalSecondaryIndex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    }
    impl Builder {
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index. The name must be unique among all other indexes on this table.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSecondaryIndex`](crate::model::GlobalSecondaryIndex)
        pub fn build(self) -> crate::model::GlobalSecondaryIndex {
            crate::model::GlobalSecondaryIndex {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
                provisioned_throughput: self.provisioned_throughput,
            }
        }
    }
}
impl GlobalSecondaryIndex {
    /// Creates a new builder-style object to manufacture [`GlobalSecondaryIndex`](crate::model::GlobalSecondaryIndex)
    pub fn builder() -> crate::model::global_secondary_index::Builder {
        crate::model::global_secondary_index::Builder::default()
    }
}

/// <p>Represents the properties of a global table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalTable {
    /// <p>The global table name.</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>The Regions where the global table has replicas.</p>
    pub replication_group: std::option::Option<std::vec::Vec<crate::model::Replica>>,
}
impl GlobalTable {
    /// <p>The global table name.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>The Regions where the global table has replicas.</p>
    pub fn replication_group(&self) -> std::option::Option<&[crate::model::Replica]> {
        self.replication_group.as_deref()
    }
}
impl std::fmt::Debug for GlobalTable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalTable");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}
/// See [`GlobalTable`](crate::model::GlobalTable)
pub mod global_table {
    /// A builder for [`GlobalTable`](crate::model::GlobalTable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) replication_group: std::option::Option<std::vec::Vec<crate::model::Replica>>,
    }
    impl Builder {
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Appends an item to `replication_group`.
        ///
        /// To override the contents of this collection use [`set_replication_group`](Self::set_replication_group).
        ///
        /// <p>The Regions where the global table has replicas.</p>
        pub fn replication_group(mut self, input: crate::model::Replica) -> Self {
            let mut v = self.replication_group.unwrap_or_default();
            v.push(input);
            self.replication_group = Some(v);
            self
        }
        /// <p>The Regions where the global table has replicas.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Replica>>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalTable`](crate::model::GlobalTable)
        pub fn build(self) -> crate::model::GlobalTable {
            crate::model::GlobalTable {
                global_table_name: self.global_table_name,
                replication_group: self.replication_group,
            }
        }
    }
}
impl GlobalTable {
    /// Creates a new builder-style object to manufacture [`GlobalTable`](crate::model::GlobalTable)
    pub fn builder() -> crate::model::global_table::Builder {
        crate::model::global_table::Builder::default()
    }
}

/// <p>Represents the properties of a replica.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Replica {
    /// <p>The Region where the replica needs to be created.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl Replica {
    /// <p>The Region where the replica needs to be created.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for Replica {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Replica");
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`Replica`](crate::model::Replica)
pub mod replica {
    /// A builder for [`Replica`](crate::model::Replica)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Region where the replica needs to be created.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The Region where the replica needs to be created.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Replica`](crate::model::Replica)
        pub fn build(self) -> crate::model::Replica {
            crate::model::Replica {
                region_name: self.region_name,
            }
        }
    }
}
impl Replica {
    /// Creates a new builder-style object to manufacture [`Replica`](crate::model::Replica)
    pub fn builder() -> crate::model::replica::Builder {
        crate::model::replica::Builder::default()
    }
}

/// <p>Summary information about an export task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSummary {
    /// <p>The Amazon Resource Name (ARN) of the export.</p>
    pub export_arn: std::option::Option<std::string::String>,
    /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
}
impl ExportSummary {
    /// <p>The Amazon Resource Name (ARN) of the export.</p>
    pub fn export_arn(&self) -> std::option::Option<&str> {
        self.export_arn.as_deref()
    }
    /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
}
impl std::fmt::Debug for ExportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSummary");
        formatter.field("export_arn", &self.export_arn);
        formatter.field("export_status", &self.export_status);
        formatter.finish()
    }
}
/// See [`ExportSummary`](crate::model::ExportSummary)
pub mod export_summary {
    /// A builder for [`ExportSummary`](crate::model::ExportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_arn: std::option::Option<std::string::String>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the export.</p>
        pub fn export_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export.</p>
        pub fn set_export_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_arn = input;
            self
        }
        /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSummary`](crate::model::ExportSummary)
        pub fn build(self) -> crate::model::ExportSummary {
            crate::model::ExportSummary {
                export_arn: self.export_arn,
                export_status: self.export_status,
            }
        }
    }
}
impl ExportSummary {
    /// Creates a new builder-style object to manufacture [`ExportSummary`](crate::model::ExportSummary)
    pub fn builder() -> crate::model::export_summary::Builder {
        crate::model::export_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ExportStatus::Completed,
            "FAILED" => ExportStatus::Failed,
            "IN_PROGRESS" => ExportStatus::InProgress,
            other => ExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportStatus::from(s))
    }
}
impl ExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportStatus::Completed => "COMPLETED",
            ExportStatus::Failed => "FAILED",
            ExportStatus::InProgress => "IN_PROGRESS",
            ExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for ExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a Contributor Insights summary entry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContributorInsightsSummary {
    /// <p>Name of the table associated with the summary.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Name of the index associated with the summary, if any.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Describes the current status for contributor insights for the given table and index, if applicable.</p>
    pub contributor_insights_status: std::option::Option<crate::model::ContributorInsightsStatus>,
}
impl ContributorInsightsSummary {
    /// <p>Name of the table associated with the summary.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Name of the index associated with the summary, if any.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Describes the current status for contributor insights for the given table and index, if applicable.</p>
    pub fn contributor_insights_status(
        &self,
    ) -> std::option::Option<&crate::model::ContributorInsightsStatus> {
        self.contributor_insights_status.as_ref()
    }
}
impl std::fmt::Debug for ContributorInsightsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContributorInsightsSummary");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "contributor_insights_status",
            &self.contributor_insights_status,
        );
        formatter.finish()
    }
}
/// See [`ContributorInsightsSummary`](crate::model::ContributorInsightsSummary)
pub mod contributor_insights_summary {
    /// A builder for [`ContributorInsightsSummary`](crate::model::ContributorInsightsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) contributor_insights_status:
            std::option::Option<crate::model::ContributorInsightsStatus>,
    }
    impl Builder {
        /// <p>Name of the table associated with the summary.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table associated with the summary.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Name of the index associated with the summary, if any.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>Name of the index associated with the summary, if any.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Describes the current status for contributor insights for the given table and index, if applicable.</p>
        pub fn contributor_insights_status(
            mut self,
            input: crate::model::ContributorInsightsStatus,
        ) -> Self {
            self.contributor_insights_status = Some(input);
            self
        }
        /// <p>Describes the current status for contributor insights for the given table and index, if applicable.</p>
        pub fn set_contributor_insights_status(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsStatus>,
        ) -> Self {
            self.contributor_insights_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ContributorInsightsSummary`](crate::model::ContributorInsightsSummary)
        pub fn build(self) -> crate::model::ContributorInsightsSummary {
            crate::model::ContributorInsightsSummary {
                table_name: self.table_name,
                index_name: self.index_name,
                contributor_insights_status: self.contributor_insights_status,
            }
        }
    }
}
impl ContributorInsightsSummary {
    /// Creates a new builder-style object to manufacture [`ContributorInsightsSummary`](crate::model::ContributorInsightsSummary)
    pub fn builder() -> crate::model::contributor_insights_summary::Builder {
        crate::model::contributor_insights_summary::Builder::default()
    }
}

/// <p>Contains details for the backup.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupSummary {
    /// <p>Name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the table.</p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>ARN associated with the table.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>ARN associated with the backup.</p>
    pub backup_arn: std::option::Option<std::string::String>,
    /// <p>Name of the specified backup.</p>
    pub backup_name: std::option::Option<std::string::String>,
    /// <p>Time at which the backup was created.</p>
    pub backup_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
    pub backup_expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED.</p>
    pub backup_status: std::option::Option<crate::model::BackupStatus>,
    /// <p>BackupType:</p>
    /// <ul>
    /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
    /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
    /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
    /// </ul>
    pub backup_type: std::option::Option<crate::model::BackupType>,
    /// <p>Size of the backup in bytes.</p>
    pub backup_size_bytes: std::option::Option<i64>,
}
impl BackupSummary {
    /// <p>Name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Unique identifier for the table.</p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>ARN associated with the table.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>ARN associated with the backup.</p>
    pub fn backup_arn(&self) -> std::option::Option<&str> {
        self.backup_arn.as_deref()
    }
    /// <p>Name of the specified backup.</p>
    pub fn backup_name(&self) -> std::option::Option<&str> {
        self.backup_name.as_deref()
    }
    /// <p>Time at which the backup was created.</p>
    pub fn backup_creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.backup_creation_date_time.as_ref()
    }
    /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
    pub fn backup_expiry_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.backup_expiry_date_time.as_ref()
    }
    /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED.</p>
    pub fn backup_status(&self) -> std::option::Option<&crate::model::BackupStatus> {
        self.backup_status.as_ref()
    }
    /// <p>BackupType:</p>
    /// <ul>
    /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
    /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
    /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
    /// </ul>
    pub fn backup_type(&self) -> std::option::Option<&crate::model::BackupType> {
        self.backup_type.as_ref()
    }
    /// <p>Size of the backup in bytes.</p>
    pub fn backup_size_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_bytes
    }
}
impl std::fmt::Debug for BackupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupSummary");
        formatter.field("table_name", &self.table_name);
        formatter.field("table_id", &self.table_id);
        formatter.field("table_arn", &self.table_arn);
        formatter.field("backup_arn", &self.backup_arn);
        formatter.field("backup_name", &self.backup_name);
        formatter.field("backup_creation_date_time", &self.backup_creation_date_time);
        formatter.field("backup_expiry_date_time", &self.backup_expiry_date_time);
        formatter.field("backup_status", &self.backup_status);
        formatter.field("backup_type", &self.backup_type);
        formatter.field("backup_size_bytes", &self.backup_size_bytes);
        formatter.finish()
    }
}
/// See [`BackupSummary`](crate::model::BackupSummary)
pub mod backup_summary {
    /// A builder for [`BackupSummary`](crate::model::BackupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) backup_arn: std::option::Option<std::string::String>,
        pub(crate) backup_name: std::option::Option<std::string::String>,
        pub(crate) backup_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_status: std::option::Option<crate::model::BackupStatus>,
        pub(crate) backup_type: std::option::Option<crate::model::BackupType>,
        pub(crate) backup_size_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Unique identifier for the table.</p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the table.</p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>ARN associated with the table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>ARN associated with the table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>ARN associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>ARN associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// <p>Name of the specified backup.</p>
        pub fn backup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_name = Some(input.into());
            self
        }
        /// <p>Name of the specified backup.</p>
        pub fn set_backup_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_name = input;
            self
        }
        /// <p>Time at which the backup was created.</p>
        pub fn backup_creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.backup_creation_date_time = Some(input);
            self
        }
        /// <p>Time at which the backup was created.</p>
        pub fn set_backup_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.backup_creation_date_time = input;
            self
        }
        /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
        pub fn backup_expiry_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.backup_expiry_date_time = Some(input);
            self
        }
        /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
        pub fn set_backup_expiry_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.backup_expiry_date_time = input;
            self
        }
        /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED.</p>
        pub fn backup_status(mut self, input: crate::model::BackupStatus) -> Self {
            self.backup_status = Some(input);
            self
        }
        /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED.</p>
        pub fn set_backup_status(
            mut self,
            input: std::option::Option<crate::model::BackupStatus>,
        ) -> Self {
            self.backup_status = input;
            self
        }
        /// <p>BackupType:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
        /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
        /// </ul>
        pub fn backup_type(mut self, input: crate::model::BackupType) -> Self {
            self.backup_type = Some(input);
            self
        }
        /// <p>BackupType:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
        /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
        /// </ul>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupType>,
        ) -> Self {
            self.backup_type = input;
            self
        }
        /// <p>Size of the backup in bytes.</p>
        pub fn backup_size_bytes(mut self, input: i64) -> Self {
            self.backup_size_bytes = Some(input);
            self
        }
        /// <p>Size of the backup in bytes.</p>
        pub fn set_backup_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupSummary`](crate::model::BackupSummary)
        pub fn build(self) -> crate::model::BackupSummary {
            crate::model::BackupSummary {
                table_name: self.table_name,
                table_id: self.table_id,
                table_arn: self.table_arn,
                backup_arn: self.backup_arn,
                backup_name: self.backup_name,
                backup_creation_date_time: self.backup_creation_date_time,
                backup_expiry_date_time: self.backup_expiry_date_time,
                backup_status: self.backup_status,
                backup_type: self.backup_type,
                backup_size_bytes: self.backup_size_bytes,
            }
        }
    }
}
impl BackupSummary {
    /// Creates a new builder-style object to manufacture [`BackupSummary`](crate::model::BackupSummary)
    pub fn builder() -> crate::model::backup_summary::Builder {
        crate::model::backup_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupType {
    #[allow(missing_docs)] // documentation missing in model
    AwsBackup,
    #[allow(missing_docs)] // documentation missing in model
    System,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_BACKUP" => BackupType::AwsBackup,
            "SYSTEM" => BackupType::System,
            "USER" => BackupType::User,
            other => BackupType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupType::from(s))
    }
}
impl BackupType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupType::AwsBackup => "AWS_BACKUP",
            BackupType::System => "SYSTEM",
            BackupType::User => "USER",
            BackupType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_BACKUP", "SYSTEM", "USER"]
    }
}
impl AsRef<str> for BackupType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => BackupStatus::Available,
            "CREATING" => BackupStatus::Creating,
            "DELETED" => BackupStatus::Deleted,
            other => BackupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupStatus::from(s))
    }
}
impl BackupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupStatus::Available => "AVAILABLE",
            BackupStatus::Creating => "CREATING",
            BackupStatus::Deleted => "DELETED",
            BackupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "DELETED"]
    }
}
impl AsRef<str> for BackupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackupTypeFilter {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    AwsBackup,
    #[allow(missing_docs)] // documentation missing in model
    System,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackupTypeFilter {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => BackupTypeFilter::All,
            "AWS_BACKUP" => BackupTypeFilter::AwsBackup,
            "SYSTEM" => BackupTypeFilter::System,
            "USER" => BackupTypeFilter::User,
            other => BackupTypeFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackupTypeFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackupTypeFilter::from(s))
    }
}
impl BackupTypeFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackupTypeFilter::All => "ALL",
            BackupTypeFilter::AwsBackup => "AWS_BACKUP",
            BackupTypeFilter::System => "SYSTEM",
            BackupTypeFilter::User => "USER",
            BackupTypeFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "AWS_BACKUP", "SYSTEM", "USER"]
    }
}
impl AsRef<str> for BackupTypeFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the properties of the exported table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportDescription {
    /// <p>The Amazon Resource Name (ARN) of the table export.</p>
    pub export_arn: std::option::Option<std::string::String>,
    /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>The time at which the export task began.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the export task completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the manifest file for the export task.</p>
    pub export_manifest: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the table that was exported.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Unique ID of the table that was exported.</p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>Point in time from which table data was exported.</p>
    pub export_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The client token that was provided for the export task. A client token makes calls to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket containing the export.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the bucket containing the export.</p>
    pub s3_bucket_owner: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
    /// <p>Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
    /// <ul>
    /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
    /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
    /// </ul>
    pub s3_sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
    /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).</p>
    pub s3_sse_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Status code for the result of the failed export.</p>
    pub failure_code: std::option::Option<std::string::String>,
    /// <p>Export failure reason description.</p>
    pub failure_message: std::option::Option<std::string::String>,
    /// <p>The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
    pub export_format: std::option::Option<crate::model::ExportFormat>,
    /// <p>The billable size of the table export.</p>
    pub billed_size_bytes: std::option::Option<i64>,
    /// <p>The number of items exported.</p>
    pub item_count: std::option::Option<i64>,
}
impl ExportDescription {
    /// <p>The Amazon Resource Name (ARN) of the table export.</p>
    pub fn export_arn(&self) -> std::option::Option<&str> {
        self.export_arn.as_deref()
    }
    /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>The time at which the export task began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time at which the export task completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The name of the manifest file for the export task.</p>
    pub fn export_manifest(&self) -> std::option::Option<&str> {
        self.export_manifest.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the table that was exported.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Unique ID of the table that was exported.</p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>Point in time from which table data was exported.</p>
    pub fn export_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.export_time.as_ref()
    }
    /// <p>The client token that was provided for the export task. A client token makes calls to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket containing the export.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the bucket containing the export.</p>
    pub fn s3_bucket_owner(&self) -> std::option::Option<&str> {
        self.s3_bucket_owner.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
    /// <p>Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
    /// <ul>
    /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
    /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
    /// </ul>
    pub fn s3_sse_algorithm(&self) -> std::option::Option<&crate::model::S3SseAlgorithm> {
        self.s3_sse_algorithm.as_ref()
    }
    /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).</p>
    pub fn s3_sse_kms_key_id(&self) -> std::option::Option<&str> {
        self.s3_sse_kms_key_id.as_deref()
    }
    /// <p>Status code for the result of the failed export.</p>
    pub fn failure_code(&self) -> std::option::Option<&str> {
        self.failure_code.as_deref()
    }
    /// <p>Export failure reason description.</p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
    /// <p>The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
    pub fn export_format(&self) -> std::option::Option<&crate::model::ExportFormat> {
        self.export_format.as_ref()
    }
    /// <p>The billable size of the table export.</p>
    pub fn billed_size_bytes(&self) -> std::option::Option<i64> {
        self.billed_size_bytes
    }
    /// <p>The number of items exported.</p>
    pub fn item_count(&self) -> std::option::Option<i64> {
        self.item_count
    }
}
impl std::fmt::Debug for ExportDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportDescription");
        formatter.field("export_arn", &self.export_arn);
        formatter.field("export_status", &self.export_status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("export_manifest", &self.export_manifest);
        formatter.field("table_arn", &self.table_arn);
        formatter.field("table_id", &self.table_id);
        formatter.field("export_time", &self.export_time);
        formatter.field("client_token", &self.client_token);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_bucket_owner", &self.s3_bucket_owner);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.field("s3_sse_algorithm", &self.s3_sse_algorithm);
        formatter.field("s3_sse_kms_key_id", &self.s3_sse_kms_key_id);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_message", &self.failure_message);
        formatter.field("export_format", &self.export_format);
        formatter.field("billed_size_bytes", &self.billed_size_bytes);
        formatter.field("item_count", &self.item_count);
        formatter.finish()
    }
}
/// See [`ExportDescription`](crate::model::ExportDescription)
pub mod export_description {
    /// A builder for [`ExportDescription`](crate::model::ExportDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_arn: std::option::Option<std::string::String>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) export_manifest: std::option::Option<std::string::String>,
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) export_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
        pub(crate) s3_sse_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<std::string::String>,
        pub(crate) failure_message: std::option::Option<std::string::String>,
        pub(crate) export_format: std::option::Option<crate::model::ExportFormat>,
        pub(crate) billed_size_bytes: std::option::Option<i64>,
        pub(crate) item_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the table export.</p>
        pub fn export_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the table export.</p>
        pub fn set_export_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_arn = input;
            self
        }
        /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>The time at which the export task began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time at which the export task began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time at which the export task completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time at which the export task completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The name of the manifest file for the export task.</p>
        pub fn export_manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_manifest = Some(input.into());
            self
        }
        /// <p>The name of the manifest file for the export task.</p>
        pub fn set_export_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_manifest = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the table that was exported.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the table that was exported.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>Unique ID of the table that was exported.</p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>Unique ID of the table that was exported.</p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>Point in time from which table data was exported.</p>
        pub fn export_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.export_time = Some(input);
            self
        }
        /// <p>Point in time from which table data was exported.</p>
        pub fn set_export_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.export_time = input;
            self
        }
        /// <p>The client token that was provided for the export task. A client token makes calls to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client token that was provided for the export task. A client token makes calls to <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple identical calls have the same effect as one single call.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket containing the export.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket containing the export.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket containing the export.</p>
        pub fn s3_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_owner = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket containing the export.</p>
        pub fn set_s3_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_owner = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// <p>Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
        /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
        /// </ul>
        pub fn s3_sse_algorithm(mut self, input: crate::model::S3SseAlgorithm) -> Self {
            self.s3_sse_algorithm = Some(input);
            self
        }
        /// <p>Type of encryption used on the bucket where export data is stored. Valid values for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li> <p> <code>AES256</code> - server-side encryption with Amazon S3 managed keys</p> </li>
        /// <li> <p> <code>KMS</code> - server-side encryption with KMS managed keys</p> </li>
        /// </ul>
        pub fn set_s3_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3SseAlgorithm>,
        ) -> Self {
            self.s3_sse_algorithm = input;
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).</p>
        pub fn s3_sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_sse_kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).</p>
        pub fn set_s3_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_sse_kms_key_id = input;
            self
        }
        /// <p>Status code for the result of the failed export.</p>
        pub fn failure_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_code = Some(input.into());
            self
        }
        /// <p>Status code for the result of the failed export.</p>
        pub fn set_failure_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Export failure reason description.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>Export failure reason description.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// <p>The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn export_format(mut self, input: crate::model::ExportFormat) -> Self {
            self.export_format = Some(input);
            self
        }
        /// <p>The format of the exported data. Valid values for <code>ExportFormat</code> are <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn set_export_format(
            mut self,
            input: std::option::Option<crate::model::ExportFormat>,
        ) -> Self {
            self.export_format = input;
            self
        }
        /// <p>The billable size of the table export.</p>
        pub fn billed_size_bytes(mut self, input: i64) -> Self {
            self.billed_size_bytes = Some(input);
            self
        }
        /// <p>The billable size of the table export.</p>
        pub fn set_billed_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.billed_size_bytes = input;
            self
        }
        /// <p>The number of items exported.</p>
        pub fn item_count(mut self, input: i64) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>The number of items exported.</p>
        pub fn set_item_count(mut self, input: std::option::Option<i64>) -> Self {
            self.item_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportDescription`](crate::model::ExportDescription)
        pub fn build(self) -> crate::model::ExportDescription {
            crate::model::ExportDescription {
                export_arn: self.export_arn,
                export_status: self.export_status,
                start_time: self.start_time,
                end_time: self.end_time,
                export_manifest: self.export_manifest,
                table_arn: self.table_arn,
                table_id: self.table_id,
                export_time: self.export_time,
                client_token: self.client_token,
                s3_bucket: self.s3_bucket,
                s3_bucket_owner: self.s3_bucket_owner,
                s3_prefix: self.s3_prefix,
                s3_sse_algorithm: self.s3_sse_algorithm,
                s3_sse_kms_key_id: self.s3_sse_kms_key_id,
                failure_code: self.failure_code,
                failure_message: self.failure_message,
                export_format: self.export_format,
                billed_size_bytes: self.billed_size_bytes,
                item_count: self.item_count,
            }
        }
    }
}
impl ExportDescription {
    /// Creates a new builder-style object to manufacture [`ExportDescription`](crate::model::ExportDescription)
    pub fn builder() -> crate::model::export_description::Builder {
        crate::model::export_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportFormat {
    #[allow(missing_docs)] // documentation missing in model
    DynamodbJson,
    #[allow(missing_docs)] // documentation missing in model
    Ion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportFormat {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMODB_JSON" => ExportFormat::DynamodbJson,
            "ION" => ExportFormat::Ion,
            other => ExportFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportFormat::from(s))
    }
}
impl ExportFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportFormat::DynamodbJson => "DYNAMODB_JSON",
            ExportFormat::Ion => "ION",
            ExportFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMODB_JSON", "ION"]
    }
}
impl AsRef<str> for ExportFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3SseAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3SseAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => S3SseAlgorithm::Aes256,
            "KMS" => S3SseAlgorithm::Kms,
            other => S3SseAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3SseAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3SseAlgorithm::from(s))
    }
}
impl S3SseAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3SseAlgorithm::Aes256 => "AES256",
            S3SseAlgorithm::Kms => "KMS",
            S3SseAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "KMS"]
    }
}
impl AsRef<str> for S3SseAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Represents a PartiQL statment that uses parameters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParameterizedStatement {
    /// <p> A PartiQL statment that uses parameters. </p>
    pub statement: std::option::Option<std::string::String>,
    /// <p> The parameter values. </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
}
impl ParameterizedStatement {
    /// <p> A PartiQL statment that uses parameters. </p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
    /// <p> The parameter values. </p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ParameterizedStatement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParameterizedStatement");
        formatter.field("statement", &self.statement);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ParameterizedStatement`](crate::model::ParameterizedStatement)
pub mod parameterized_statement {
    /// A builder for [`ParameterizedStatement`](crate::model::ParameterizedStatement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    }
    impl Builder {
        /// <p> A PartiQL statment that uses parameters. </p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p> A PartiQL statment that uses parameters. </p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p> The parameter values. </p>
        pub fn parameters(mut self, input: crate::model::AttributeValue) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p> The parameter values. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ParameterizedStatement`](crate::model::ParameterizedStatement)
        pub fn build(self) -> crate::model::ParameterizedStatement {
            crate::model::ParameterizedStatement {
                statement: self.statement,
                parameters: self.parameters,
            }
        }
    }
}
impl ParameterizedStatement {
    /// Creates a new builder-style object to manufacture [`ParameterizedStatement`](crate::model::ParameterizedStatement)
    pub fn builder() -> crate::model::parameterized_statement::Builder {
        crate::model::parameterized_statement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DestinationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    EnableFailed,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DestinationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DestinationStatus::Active,
            "DISABLED" => DestinationStatus::Disabled,
            "DISABLING" => DestinationStatus::Disabling,
            "ENABLE_FAILED" => DestinationStatus::EnableFailed,
            "ENABLING" => DestinationStatus::Enabling,
            other => DestinationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DestinationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DestinationStatus::from(s))
    }
}
impl DestinationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DestinationStatus::Active => "ACTIVE",
            DestinationStatus::Disabled => "DISABLED",
            DestinationStatus::Disabling => "DISABLING",
            DestinationStatus::EnableFailed => "ENABLE_FAILED",
            DestinationStatus::Enabling => "ENABLING",
            DestinationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DISABLED",
            "DISABLING",
            "ENABLE_FAILED",
            "ENABLING",
        ]
    }
}
impl AsRef<str> for DestinationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The description of the Time to Live (TTL) status on the specified table. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeToLiveDescription {
    /// <p> The TTL status for the table.</p>
    pub time_to_live_status: std::option::Option<crate::model::TimeToLiveStatus>,
    /// <p> The name of the TTL attribute for items in the table.</p>
    pub attribute_name: std::option::Option<std::string::String>,
}
impl TimeToLiveDescription {
    /// <p> The TTL status for the table.</p>
    pub fn time_to_live_status(&self) -> std::option::Option<&crate::model::TimeToLiveStatus> {
        self.time_to_live_status.as_ref()
    }
    /// <p> The name of the TTL attribute for items in the table.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
}
impl std::fmt::Debug for TimeToLiveDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeToLiveDescription");
        formatter.field("time_to_live_status", &self.time_to_live_status);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.finish()
    }
}
/// See [`TimeToLiveDescription`](crate::model::TimeToLiveDescription)
pub mod time_to_live_description {
    /// A builder for [`TimeToLiveDescription`](crate::model::TimeToLiveDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live_status: std::option::Option<crate::model::TimeToLiveStatus>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The TTL status for the table.</p>
        pub fn time_to_live_status(mut self, input: crate::model::TimeToLiveStatus) -> Self {
            self.time_to_live_status = Some(input);
            self
        }
        /// <p> The TTL status for the table.</p>
        pub fn set_time_to_live_status(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveStatus>,
        ) -> Self {
            self.time_to_live_status = input;
            self
        }
        /// <p> The name of the TTL attribute for items in the table.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p> The name of the TTL attribute for items in the table.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeToLiveDescription`](crate::model::TimeToLiveDescription)
        pub fn build(self) -> crate::model::TimeToLiveDescription {
            crate::model::TimeToLiveDescription {
                time_to_live_status: self.time_to_live_status,
                attribute_name: self.attribute_name,
            }
        }
    }
}
impl TimeToLiveDescription {
    /// Creates a new builder-style object to manufacture [`TimeToLiveDescription`](crate::model::TimeToLiveDescription)
    pub fn builder() -> crate::model::time_to_live_description::Builder {
        crate::model::time_to_live_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeToLiveStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeToLiveStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => TimeToLiveStatus::Disabled,
            "DISABLING" => TimeToLiveStatus::Disabling,
            "ENABLED" => TimeToLiveStatus::Enabled,
            "ENABLING" => TimeToLiveStatus::Enabling,
            other => TimeToLiveStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeToLiveStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeToLiveStatus::from(s))
    }
}
impl TimeToLiveStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeToLiveStatus::Disabled => "DISABLED",
            TimeToLiveStatus::Disabling => "DISABLING",
            TimeToLiveStatus::Enabled => "ENABLED",
            TimeToLiveStatus::Enabling => "ENABLING",
            TimeToLiveStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING"]
    }
}
impl AsRef<str> for TimeToLiveStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a Kinesis data stream destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisDataStreamDestination {
    /// <p>The ARN for a specific Kinesis data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The current status of replication.</p>
    pub destination_status: std::option::Option<crate::model::DestinationStatus>,
    /// <p>The human-readable string that corresponds to the replica status.</p>
    pub destination_status_description: std::option::Option<std::string::String>,
}
impl KinesisDataStreamDestination {
    /// <p>The ARN for a specific Kinesis data stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The current status of replication.</p>
    pub fn destination_status(&self) -> std::option::Option<&crate::model::DestinationStatus> {
        self.destination_status.as_ref()
    }
    /// <p>The human-readable string that corresponds to the replica status.</p>
    pub fn destination_status_description(&self) -> std::option::Option<&str> {
        self.destination_status_description.as_deref()
    }
}
impl std::fmt::Debug for KinesisDataStreamDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisDataStreamDestination");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("destination_status", &self.destination_status);
        formatter.field(
            "destination_status_description",
            &self.destination_status_description,
        );
        formatter.finish()
    }
}
/// See [`KinesisDataStreamDestination`](crate::model::KinesisDataStreamDestination)
pub mod kinesis_data_stream_destination {
    /// A builder for [`KinesisDataStreamDestination`](crate::model::KinesisDataStreamDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) destination_status: std::option::Option<crate::model::DestinationStatus>,
        pub(crate) destination_status_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for a specific Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN for a specific Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The current status of replication.</p>
        pub fn destination_status(mut self, input: crate::model::DestinationStatus) -> Self {
            self.destination_status = Some(input);
            self
        }
        /// <p>The current status of replication.</p>
        pub fn set_destination_status(
            mut self,
            input: std::option::Option<crate::model::DestinationStatus>,
        ) -> Self {
            self.destination_status = input;
            self
        }
        /// <p>The human-readable string that corresponds to the replica status.</p>
        pub fn destination_status_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_status_description = Some(input.into());
            self
        }
        /// <p>The human-readable string that corresponds to the replica status.</p>
        pub fn set_destination_status_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_status_description = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisDataStreamDestination`](crate::model::KinesisDataStreamDestination)
        pub fn build(self) -> crate::model::KinesisDataStreamDestination {
            crate::model::KinesisDataStreamDestination {
                stream_arn: self.stream_arn,
                destination_status: self.destination_status,
                destination_status_description: self.destination_status_description,
            }
        }
    }
}
impl KinesisDataStreamDestination {
    /// Creates a new builder-style object to manufacture [`KinesisDataStreamDestination`](crate::model::KinesisDataStreamDestination)
    pub fn builder() -> crate::model::kinesis_data_stream_destination::Builder {
        crate::model::kinesis_data_stream_destination::Builder::default()
    }
}

/// <p>An endpoint information details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>IP address of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>Endpoint cache time to live (TTL) value.</p>
    pub cache_period_in_minutes: i64,
}
impl Endpoint {
    /// <p>IP address of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>Endpoint cache time to live (TTL) value.</p>
    pub fn cache_period_in_minutes(&self) -> i64 {
        self.cache_period_in_minutes
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("cache_period_in_minutes", &self.cache_period_in_minutes);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) cache_period_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>IP address of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>IP address of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>Endpoint cache time to live (TTL) value.</p>
        pub fn cache_period_in_minutes(mut self, input: i64) -> Self {
            self.cache_period_in_minutes = Some(input);
            self
        }
        /// <p>Endpoint cache time to live (TTL) value.</p>
        pub fn set_cache_period_in_minutes(mut self, input: std::option::Option<i64>) -> Self {
            self.cache_period_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                cache_period_in_minutes: self.cache_period_in_minutes.unwrap_or_default(),
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>Represents a failure a contributor insights operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureException {
    /// <p>Exception name.</p>
    pub exception_name: std::option::Option<std::string::String>,
    /// <p>Description of the failure.</p>
    pub exception_description: std::option::Option<std::string::String>,
}
impl FailureException {
    /// <p>Exception name.</p>
    pub fn exception_name(&self) -> std::option::Option<&str> {
        self.exception_name.as_deref()
    }
    /// <p>Description of the failure.</p>
    pub fn exception_description(&self) -> std::option::Option<&str> {
        self.exception_description.as_deref()
    }
}
impl std::fmt::Debug for FailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureException");
        formatter.field("exception_name", &self.exception_name);
        formatter.field("exception_description", &self.exception_description);
        formatter.finish()
    }
}
/// See [`FailureException`](crate::model::FailureException)
pub mod failure_exception {
    /// A builder for [`FailureException`](crate::model::FailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exception_name: std::option::Option<std::string::String>,
        pub(crate) exception_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Exception name.</p>
        pub fn exception_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_name = Some(input.into());
            self
        }
        /// <p>Exception name.</p>
        pub fn set_exception_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_name = input;
            self
        }
        /// <p>Description of the failure.</p>
        pub fn exception_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_description = Some(input.into());
            self
        }
        /// <p>Description of the failure.</p>
        pub fn set_exception_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_description = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureException`](crate::model::FailureException)
        pub fn build(self) -> crate::model::FailureException {
            crate::model::FailureException {
                exception_name: self.exception_name,
                exception_description: self.exception_description,
            }
        }
    }
}
impl FailureException {
    /// Creates a new builder-style object to manufacture [`FailureException`](crate::model::FailureException)
    pub fn builder() -> crate::model::failure_exception::Builder {
        crate::model::failure_exception::Builder::default()
    }
}

/// <p>Contains the description of the backup created for the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupDescription {
    /// <p>Contains the details of the backup created for the table. </p>
    pub backup_details: std::option::Option<crate::model::BackupDetails>,
    /// <p>Contains the details of the table when the backup was created. </p>
    pub source_table_details: std::option::Option<crate::model::SourceTableDetails>,
    /// <p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.</p>
    pub source_table_feature_details: std::option::Option<crate::model::SourceTableFeatureDetails>,
}
impl BackupDescription {
    /// <p>Contains the details of the backup created for the table. </p>
    pub fn backup_details(&self) -> std::option::Option<&crate::model::BackupDetails> {
        self.backup_details.as_ref()
    }
    /// <p>Contains the details of the table when the backup was created. </p>
    pub fn source_table_details(&self) -> std::option::Option<&crate::model::SourceTableDetails> {
        self.source_table_details.as_ref()
    }
    /// <p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.</p>
    pub fn source_table_feature_details(
        &self,
    ) -> std::option::Option<&crate::model::SourceTableFeatureDetails> {
        self.source_table_feature_details.as_ref()
    }
}
impl std::fmt::Debug for BackupDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupDescription");
        formatter.field("backup_details", &self.backup_details);
        formatter.field("source_table_details", &self.source_table_details);
        formatter.field(
            "source_table_feature_details",
            &self.source_table_feature_details,
        );
        formatter.finish()
    }
}
/// See [`BackupDescription`](crate::model::BackupDescription)
pub mod backup_description {
    /// A builder for [`BackupDescription`](crate::model::BackupDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_details: std::option::Option<crate::model::BackupDetails>,
        pub(crate) source_table_details: std::option::Option<crate::model::SourceTableDetails>,
        pub(crate) source_table_feature_details:
            std::option::Option<crate::model::SourceTableFeatureDetails>,
    }
    impl Builder {
        /// <p>Contains the details of the backup created for the table. </p>
        pub fn backup_details(mut self, input: crate::model::BackupDetails) -> Self {
            self.backup_details = Some(input);
            self
        }
        /// <p>Contains the details of the backup created for the table. </p>
        pub fn set_backup_details(
            mut self,
            input: std::option::Option<crate::model::BackupDetails>,
        ) -> Self {
            self.backup_details = input;
            self
        }
        /// <p>Contains the details of the table when the backup was created. </p>
        pub fn source_table_details(mut self, input: crate::model::SourceTableDetails) -> Self {
            self.source_table_details = Some(input);
            self
        }
        /// <p>Contains the details of the table when the backup was created. </p>
        pub fn set_source_table_details(
            mut self,
            input: std::option::Option<crate::model::SourceTableDetails>,
        ) -> Self {
            self.source_table_details = input;
            self
        }
        /// <p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.</p>
        pub fn source_table_feature_details(
            mut self,
            input: crate::model::SourceTableFeatureDetails,
        ) -> Self {
            self.source_table_feature_details = Some(input);
            self
        }
        /// <p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.</p>
        pub fn set_source_table_feature_details(
            mut self,
            input: std::option::Option<crate::model::SourceTableFeatureDetails>,
        ) -> Self {
            self.source_table_feature_details = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupDescription`](crate::model::BackupDescription)
        pub fn build(self) -> crate::model::BackupDescription {
            crate::model::BackupDescription {
                backup_details: self.backup_details,
                source_table_details: self.source_table_details,
                source_table_feature_details: self.source_table_feature_details,
            }
        }
    }
}
impl BackupDescription {
    /// Creates a new builder-style object to manufacture [`BackupDescription`](crate::model::BackupDescription)
    pub fn builder() -> crate::model::backup_description::Builder {
        crate::model::backup_description::Builder::default()
    }
}

/// <p>Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceTableFeatureDetails {
    /// <p>Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup. </p>
    pub local_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexInfo>>,
    /// <p>Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup. </p>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexInfo>>,
    /// <p>Stream settings on the table when the backup was created.</p>
    pub stream_description: std::option::Option<crate::model::StreamSpecification>,
    /// <p>Time to Live settings on the table when the backup was created.</p>
    pub time_to_live_description: std::option::Option<crate::model::TimeToLiveDescription>,
    /// <p>The description of the server-side encryption status on the table when the backup was created.</p>
    pub sse_description: std::option::Option<crate::model::SseDescription>,
}
impl SourceTableFeatureDetails {
    /// <p>Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup. </p>
    pub fn local_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::LocalSecondaryIndexInfo]> {
        self.local_secondary_indexes.as_deref()
    }
    /// <p>Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup. </p>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndexInfo]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>Stream settings on the table when the backup was created.</p>
    pub fn stream_description(&self) -> std::option::Option<&crate::model::StreamSpecification> {
        self.stream_description.as_ref()
    }
    /// <p>Time to Live settings on the table when the backup was created.</p>
    pub fn time_to_live_description(
        &self,
    ) -> std::option::Option<&crate::model::TimeToLiveDescription> {
        self.time_to_live_description.as_ref()
    }
    /// <p>The description of the server-side encryption status on the table when the backup was created.</p>
    pub fn sse_description(&self) -> std::option::Option<&crate::model::SseDescription> {
        self.sse_description.as_ref()
    }
}
impl std::fmt::Debug for SourceTableFeatureDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceTableFeatureDetails");
        formatter.field("local_secondary_indexes", &self.local_secondary_indexes);
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field("stream_description", &self.stream_description);
        formatter.field("time_to_live_description", &self.time_to_live_description);
        formatter.field("sse_description", &self.sse_description);
        formatter.finish()
    }
}
/// See [`SourceTableFeatureDetails`](crate::model::SourceTableFeatureDetails)
pub mod source_table_feature_details {
    /// A builder for [`SourceTableFeatureDetails`](crate::model::SourceTableFeatureDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexInfo>>,
        pub(crate) global_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexInfo>>,
        pub(crate) stream_description: std::option::Option<crate::model::StreamSpecification>,
        pub(crate) time_to_live_description:
            std::option::Option<crate::model::TimeToLiveDescription>,
        pub(crate) sse_description: std::option::Option<crate::model::SseDescription>,
    }
    impl Builder {
        /// Appends an item to `local_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup. </p>
        pub fn local_secondary_indexes(
            mut self,
            input: crate::model::LocalSecondaryIndexInfo,
        ) -> Self {
            let mut v = self.local_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.local_secondary_indexes = Some(v);
            self
        }
        /// <p>Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup. </p>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndexInfo>>,
        ) -> Self {
            self.local_secondary_indexes = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup. </p>
        pub fn global_secondary_indexes(
            mut self,
            input: crate::model::GlobalSecondaryIndexInfo,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input);
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup. </p>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexInfo>>,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>Stream settings on the table when the backup was created.</p>
        pub fn stream_description(mut self, input: crate::model::StreamSpecification) -> Self {
            self.stream_description = Some(input);
            self
        }
        /// <p>Stream settings on the table when the backup was created.</p>
        pub fn set_stream_description(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.stream_description = input;
            self
        }
        /// <p>Time to Live settings on the table when the backup was created.</p>
        pub fn time_to_live_description(
            mut self,
            input: crate::model::TimeToLiveDescription,
        ) -> Self {
            self.time_to_live_description = Some(input);
            self
        }
        /// <p>Time to Live settings on the table when the backup was created.</p>
        pub fn set_time_to_live_description(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveDescription>,
        ) -> Self {
            self.time_to_live_description = input;
            self
        }
        /// <p>The description of the server-side encryption status on the table when the backup was created.</p>
        pub fn sse_description(mut self, input: crate::model::SseDescription) -> Self {
            self.sse_description = Some(input);
            self
        }
        /// <p>The description of the server-side encryption status on the table when the backup was created.</p>
        pub fn set_sse_description(
            mut self,
            input: std::option::Option<crate::model::SseDescription>,
        ) -> Self {
            self.sse_description = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceTableFeatureDetails`](crate::model::SourceTableFeatureDetails)
        pub fn build(self) -> crate::model::SourceTableFeatureDetails {
            crate::model::SourceTableFeatureDetails {
                local_secondary_indexes: self.local_secondary_indexes,
                global_secondary_indexes: self.global_secondary_indexes,
                stream_description: self.stream_description,
                time_to_live_description: self.time_to_live_description,
                sse_description: self.sse_description,
            }
        }
    }
}
impl SourceTableFeatureDetails {
    /// Creates a new builder-style object to manufacture [`SourceTableFeatureDetails`](crate::model::SourceTableFeatureDetails)
    pub fn builder() -> crate::model::source_table_feature_details::Builder {
        crate::model::source_table_feature_details::Builder::default()
    }
}

/// <p>Represents the properties of a global secondary index for the table when the backup was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalSecondaryIndexInfo {
    /// <p>The name of the global secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
    /// <p>Represents the provisioned throughput settings for the specified global secondary index. </p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
}
impl GlobalSecondaryIndexInfo {
    /// <p>The name of the global secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
    /// <p>Represents the provisioned throughput settings for the specified global secondary index. </p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
}
impl std::fmt::Debug for GlobalSecondaryIndexInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalSecondaryIndexInfo");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.finish()
    }
}
/// See [`GlobalSecondaryIndexInfo`](crate::model::GlobalSecondaryIndexInfo)
pub mod global_secondary_index_info {
    /// A builder for [`GlobalSecondaryIndexInfo`](crate::model::GlobalSecondaryIndexInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    }
    impl Builder {
        /// <p>The name of the global secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index. </p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for the specified global secondary index. </p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalSecondaryIndexInfo`](crate::model::GlobalSecondaryIndexInfo)
        pub fn build(self) -> crate::model::GlobalSecondaryIndexInfo {
            crate::model::GlobalSecondaryIndexInfo {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
                provisioned_throughput: self.provisioned_throughput,
            }
        }
    }
}
impl GlobalSecondaryIndexInfo {
    /// Creates a new builder-style object to manufacture [`GlobalSecondaryIndexInfo`](crate::model::GlobalSecondaryIndexInfo)
    pub fn builder() -> crate::model::global_secondary_index_info::Builder {
        crate::model::global_secondary_index_info::Builder::default()
    }
}

/// <p>Represents the properties of a local secondary index for the table when the backup was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalSecondaryIndexInfo {
    /// <p>Represents the name of the local secondary index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The complete key schema for a local secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub projection: std::option::Option<crate::model::Projection>,
}
impl LocalSecondaryIndexInfo {
    /// <p>Represents the name of the local secondary index.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The complete key schema for a local secondary index, which consists of one or more pairs of attribute names and key types:</p>
    /// <ul>
    /// <li> <p> <code>HASH</code> - partition key</p> </li>
    /// <li> <p> <code>RANGE</code> - sort key</p> </li>
    /// </ul> <note>
    /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
    /// </note>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
    pub fn projection(&self) -> std::option::Option<&crate::model::Projection> {
        self.projection.as_ref()
    }
}
impl std::fmt::Debug for LocalSecondaryIndexInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalSecondaryIndexInfo");
        formatter.field("index_name", &self.index_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("projection", &self.projection);
        formatter.finish()
    }
}
/// See [`LocalSecondaryIndexInfo`](crate::model::LocalSecondaryIndexInfo)
pub mod local_secondary_index_info {
    /// A builder for [`LocalSecondaryIndexInfo`](crate::model::LocalSecondaryIndexInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) projection: std::option::Option<crate::model::Projection>,
    }
    impl Builder {
        /// <p>Represents the name of the local secondary index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>Represents the name of the local secondary index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>The complete key schema for a local secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>The complete key schema for a local secondary index, which consists of one or more pairs of attribute names and key types:</p>
        /// <ul>
        /// <li> <p> <code>HASH</code> - partition key</p> </li>
        /// <li> <p> <code>RANGE</code> - sort key</p> </li>
        /// </ul> <note>
        /// <p>The partition key of an item is also known as its <i>hash attribute</i>. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.</p>
        /// </note>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn projection(mut self, input: crate::model::Projection) -> Self {
            self.projection = Some(input);
            self
        }
        /// <p>Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. </p>
        pub fn set_projection(
            mut self,
            input: std::option::Option<crate::model::Projection>,
        ) -> Self {
            self.projection = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalSecondaryIndexInfo`](crate::model::LocalSecondaryIndexInfo)
        pub fn build(self) -> crate::model::LocalSecondaryIndexInfo {
            crate::model::LocalSecondaryIndexInfo {
                index_name: self.index_name,
                key_schema: self.key_schema,
                projection: self.projection,
            }
        }
    }
}
impl LocalSecondaryIndexInfo {
    /// Creates a new builder-style object to manufacture [`LocalSecondaryIndexInfo`](crate::model::LocalSecondaryIndexInfo)
    pub fn builder() -> crate::model::local_secondary_index_info::Builder {
        crate::model::local_secondary_index_info::Builder::default()
    }
}

/// <p>Contains the details of the table when the backup was created. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceTableDetails {
    /// <p>The name of the table for which the backup was created. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the table for which the backup was created. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>ARN of the table for which backup was created. </p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Size of the table in bytes. Note that this is an approximate value.</p>
    pub table_size_bytes: i64,
    /// <p>Schema of the table. </p>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>Time when the source table was created. </p>
    pub table_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Read IOPs and Write IOPS on the table when the backup was created.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    /// <p>Number of items in the table. Note that this is an approximate value. </p>
    pub item_count: std::option::Option<i64>,
    /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
    /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
    /// </ul>
    pub billing_mode: std::option::Option<crate::model::BillingMode>,
}
impl SourceTableDetails {
    /// <p>The name of the table for which the backup was created. </p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Unique identifier for the table for which the backup was created. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>ARN of the table for which backup was created. </p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Size of the table in bytes. Note that this is an approximate value.</p>
    pub fn table_size_bytes(&self) -> i64 {
        self.table_size_bytes
    }
    /// <p>Schema of the table. </p>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>Time when the source table was created. </p>
    pub fn table_creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.table_creation_date_time.as_ref()
    }
    /// <p>Read IOPs and Write IOPS on the table when the backup was created.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
    /// <p>Number of items in the table. Note that this is an approximate value. </p>
    pub fn item_count(&self) -> std::option::Option<i64> {
        self.item_count
    }
    /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
    /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
    /// </ul>
    pub fn billing_mode(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode.as_ref()
    }
}
impl std::fmt::Debug for SourceTableDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceTableDetails");
        formatter.field("table_name", &self.table_name);
        formatter.field("table_id", &self.table_id);
        formatter.field("table_arn", &self.table_arn);
        formatter.field("table_size_bytes", &self.table_size_bytes);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("table_creation_date_time", &self.table_creation_date_time);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.field("item_count", &self.item_count);
        formatter.field("billing_mode", &self.billing_mode);
        formatter.finish()
    }
}
/// See [`SourceTableDetails`](crate::model::SourceTableDetails)
pub mod source_table_details {
    /// A builder for [`SourceTableDetails`](crate::model::SourceTableDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) table_size_bytes: std::option::Option<i64>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) table_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
        pub(crate) item_count: std::option::Option<i64>,
        pub(crate) billing_mode: std::option::Option<crate::model::BillingMode>,
    }
    impl Builder {
        /// <p>The name of the table for which the backup was created. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table for which the backup was created. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Unique identifier for the table for which the backup was created. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the table for which the backup was created. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>ARN of the table for which backup was created. </p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>ARN of the table for which backup was created. </p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>Size of the table in bytes. Note that this is an approximate value.</p>
        pub fn table_size_bytes(mut self, input: i64) -> Self {
            self.table_size_bytes = Some(input);
            self
        }
        /// <p>Size of the table in bytes. Note that this is an approximate value.</p>
        pub fn set_table_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.table_size_bytes = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>Schema of the table. </p>
        pub fn key_schema(mut self, input: crate::model::KeySchemaElement) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input);
            self.key_schema = Some(v);
            self
        }
        /// <p>Schema of the table. </p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// <p>Time when the source table was created. </p>
        pub fn table_creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.table_creation_date_time = Some(input);
            self
        }
        /// <p>Time when the source table was created. </p>
        pub fn set_table_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.table_creation_date_time = input;
            self
        }
        /// <p>Read IOPs and Write IOPS on the table when the backup was created.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Read IOPs and Write IOPS on the table when the backup was created.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// <p>Number of items in the table. Note that this is an approximate value. </p>
        pub fn item_count(mut self, input: i64) -> Self {
            self.item_count = Some(input);
            self
        }
        /// <p>Number of items in the table. Note that this is an approximate value. </p>
        pub fn set_item_count(mut self, input: std::option::Option<i64>) -> Self {
            self.item_count = input;
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode = Some(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li> <p> <code>PROVISIONED</code> - Sets the read/write capacity mode to <code>PROVISIONED</code>. We recommend using <code>PROVISIONED</code> for predictable workloads.</p> </li>
        /// <li> <p> <code>PAY_PER_REQUEST</code> - Sets the read/write capacity mode to <code>PAY_PER_REQUEST</code>. We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads. </p> </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceTableDetails`](crate::model::SourceTableDetails)
        pub fn build(self) -> crate::model::SourceTableDetails {
            crate::model::SourceTableDetails {
                table_name: self.table_name,
                table_id: self.table_id,
                table_arn: self.table_arn,
                table_size_bytes: self.table_size_bytes.unwrap_or_default(),
                key_schema: self.key_schema,
                table_creation_date_time: self.table_creation_date_time,
                provisioned_throughput: self.provisioned_throughput,
                item_count: self.item_count,
                billing_mode: self.billing_mode,
            }
        }
    }
}
impl SourceTableDetails {
    /// Creates a new builder-style object to manufacture [`SourceTableDetails`](crate::model::SourceTableDetails)
    pub fn builder() -> crate::model::source_table_details::Builder {
        crate::model::source_table_details::Builder::default()
    }
}

/// <p>Contains the details of the backup created for the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupDetails {
    /// <p>ARN associated with the backup.</p>
    pub backup_arn: std::option::Option<std::string::String>,
    /// <p>Name of the requested backup.</p>
    pub backup_name: std::option::Option<std::string::String>,
    /// <p>Size of the backup in bytes.</p>
    pub backup_size_bytes: std::option::Option<i64>,
    /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED. </p>
    pub backup_status: std::option::Option<crate::model::BackupStatus>,
    /// <p>BackupType:</p>
    /// <ul>
    /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
    /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
    /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
    /// </ul>
    pub backup_type: std::option::Option<crate::model::BackupType>,
    /// <p>Time at which the backup was created. This is the request time of the backup. </p>
    pub backup_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
    pub backup_expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BackupDetails {
    /// <p>ARN associated with the backup.</p>
    pub fn backup_arn(&self) -> std::option::Option<&str> {
        self.backup_arn.as_deref()
    }
    /// <p>Name of the requested backup.</p>
    pub fn backup_name(&self) -> std::option::Option<&str> {
        self.backup_name.as_deref()
    }
    /// <p>Size of the backup in bytes.</p>
    pub fn backup_size_bytes(&self) -> std::option::Option<i64> {
        self.backup_size_bytes
    }
    /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED. </p>
    pub fn backup_status(&self) -> std::option::Option<&crate::model::BackupStatus> {
        self.backup_status.as_ref()
    }
    /// <p>BackupType:</p>
    /// <ul>
    /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
    /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
    /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
    /// </ul>
    pub fn backup_type(&self) -> std::option::Option<&crate::model::BackupType> {
        self.backup_type.as_ref()
    }
    /// <p>Time at which the backup was created. This is the request time of the backup. </p>
    pub fn backup_creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.backup_creation_date_time.as_ref()
    }
    /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
    pub fn backup_expiry_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.backup_expiry_date_time.as_ref()
    }
}
impl std::fmt::Debug for BackupDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupDetails");
        formatter.field("backup_arn", &self.backup_arn);
        formatter.field("backup_name", &self.backup_name);
        formatter.field("backup_size_bytes", &self.backup_size_bytes);
        formatter.field("backup_status", &self.backup_status);
        formatter.field("backup_type", &self.backup_type);
        formatter.field("backup_creation_date_time", &self.backup_creation_date_time);
        formatter.field("backup_expiry_date_time", &self.backup_expiry_date_time);
        formatter.finish()
    }
}
/// See [`BackupDetails`](crate::model::BackupDetails)
pub mod backup_details {
    /// A builder for [`BackupDetails`](crate::model::BackupDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_arn: std::option::Option<std::string::String>,
        pub(crate) backup_name: std::option::Option<std::string::String>,
        pub(crate) backup_size_bytes: std::option::Option<i64>,
        pub(crate) backup_status: std::option::Option<crate::model::BackupStatus>,
        pub(crate) backup_type: std::option::Option<crate::model::BackupType>,
        pub(crate) backup_creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backup_expiry_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>ARN associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>ARN associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// <p>Name of the requested backup.</p>
        pub fn backup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_name = Some(input.into());
            self
        }
        /// <p>Name of the requested backup.</p>
        pub fn set_backup_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_name = input;
            self
        }
        /// <p>Size of the backup in bytes.</p>
        pub fn backup_size_bytes(mut self, input: i64) -> Self {
            self.backup_size_bytes = Some(input);
            self
        }
        /// <p>Size of the backup in bytes.</p>
        pub fn set_backup_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.backup_size_bytes = input;
            self
        }
        /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED. </p>
        pub fn backup_status(mut self, input: crate::model::BackupStatus) -> Self {
            self.backup_status = Some(input);
            self
        }
        /// <p>Backup can be in one of the following states: CREATING, ACTIVE, DELETED. </p>
        pub fn set_backup_status(
            mut self,
            input: std::option::Option<crate::model::BackupStatus>,
        ) -> Self {
            self.backup_status = input;
            self
        }
        /// <p>BackupType:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
        /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
        /// </ul>
        pub fn backup_type(mut self, input: crate::model::BackupType) -> Self {
            self.backup_type = Some(input);
            self
        }
        /// <p>BackupType:</p>
        /// <ul>
        /// <li> <p> <code>USER</code> - You create and manage these using the on-demand backup feature.</p> </li>
        /// <li> <p> <code>SYSTEM</code> - If you delete a table with point-in-time recovery enabled, a <code>SYSTEM</code> backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion. </p> </li>
        /// <li> <p> <code>AWS_BACKUP</code> - On-demand backup created by you from Backup service.</p> </li>
        /// </ul>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupType>,
        ) -> Self {
            self.backup_type = input;
            self
        }
        /// <p>Time at which the backup was created. This is the request time of the backup. </p>
        pub fn backup_creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.backup_creation_date_time = Some(input);
            self
        }
        /// <p>Time at which the backup was created. This is the request time of the backup. </p>
        pub fn set_backup_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.backup_creation_date_time = input;
            self
        }
        /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
        pub fn backup_expiry_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.backup_expiry_date_time = Some(input);
            self
        }
        /// <p>Time at which the automatic on-demand backup created by DynamoDB will expire. This <code>SYSTEM</code> on-demand backup expires automatically 35 days after its creation.</p>
        pub fn set_backup_expiry_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.backup_expiry_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupDetails`](crate::model::BackupDetails)
        pub fn build(self) -> crate::model::BackupDetails {
            crate::model::BackupDetails {
                backup_arn: self.backup_arn,
                backup_name: self.backup_name,
                backup_size_bytes: self.backup_size_bytes,
                backup_status: self.backup_status,
                backup_type: self.backup_type,
                backup_creation_date_time: self.backup_creation_date_time,
                backup_expiry_date_time: self.backup_expiry_date_time,
            }
        }
    }
}
impl BackupDetails {
    /// Creates a new builder-style object to manufacture [`BackupDetails`](crate::model::BackupDetails)
    pub fn builder() -> crate::model::backup_details::Builder {
        crate::model::backup_details::Builder::default()
    }
}

/// <p>Represents an operation to perform - either <code>DeleteItem</code> or <code>PutItem</code>. You can only request one of these operations, not both, in a single <code>WriteRequest</code>. If you do need to perform both of these operations, you need to provide two separate <code>WriteRequest</code> objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteRequest {
    /// <p>A request to perform a <code>PutItem</code> operation.</p>
    pub put_request: std::option::Option<crate::model::PutRequest>,
    /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
    pub delete_request: std::option::Option<crate::model::DeleteRequest>,
}
impl WriteRequest {
    /// <p>A request to perform a <code>PutItem</code> operation.</p>
    pub fn put_request(&self) -> std::option::Option<&crate::model::PutRequest> {
        self.put_request.as_ref()
    }
    /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
    pub fn delete_request(&self) -> std::option::Option<&crate::model::DeleteRequest> {
        self.delete_request.as_ref()
    }
}
impl std::fmt::Debug for WriteRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteRequest");
        formatter.field("put_request", &self.put_request);
        formatter.field("delete_request", &self.delete_request);
        formatter.finish()
    }
}
/// See [`WriteRequest`](crate::model::WriteRequest)
pub mod write_request {
    /// A builder for [`WriteRequest`](crate::model::WriteRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) put_request: std::option::Option<crate::model::PutRequest>,
        pub(crate) delete_request: std::option::Option<crate::model::DeleteRequest>,
    }
    impl Builder {
        /// <p>A request to perform a <code>PutItem</code> operation.</p>
        pub fn put_request(mut self, input: crate::model::PutRequest) -> Self {
            self.put_request = Some(input);
            self
        }
        /// <p>A request to perform a <code>PutItem</code> operation.</p>
        pub fn set_put_request(
            mut self,
            input: std::option::Option<crate::model::PutRequest>,
        ) -> Self {
            self.put_request = input;
            self
        }
        /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
        pub fn delete_request(mut self, input: crate::model::DeleteRequest) -> Self {
            self.delete_request = Some(input);
            self
        }
        /// <p>A request to perform a <code>DeleteItem</code> operation.</p>
        pub fn set_delete_request(
            mut self,
            input: std::option::Option<crate::model::DeleteRequest>,
        ) -> Self {
            self.delete_request = input;
            self
        }
        /// Consumes the builder and constructs a [`WriteRequest`](crate::model::WriteRequest)
        pub fn build(self) -> crate::model::WriteRequest {
            crate::model::WriteRequest {
                put_request: self.put_request,
                delete_request: self.delete_request,
            }
        }
    }
}
impl WriteRequest {
    /// Creates a new builder-style object to manufacture [`WriteRequest`](crate::model::WriteRequest)
    pub fn builder() -> crate::model::write_request::Builder {
        crate::model::write_request::Builder::default()
    }
}

/// <p>Represents a request to perform a <code>DeleteItem</code> operation on an item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRequest {
    /// <p>A map of attribute name to attribute values, representing the primary key of the item to delete. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl DeleteRequest {
    /// <p>A map of attribute name to attribute values, representing the primary key of the item to delete. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
}
impl std::fmt::Debug for DeleteRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRequest");
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`DeleteRequest`](crate::model::DeleteRequest)
pub mod delete_request {
    /// A builder for [`DeleteRequest`](crate::model::DeleteRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute name to attribute values, representing the primary key of the item to delete. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.key = Some(hash_map);
            self
        }
        /// <p>A map of attribute name to attribute values, representing the primary key of the item to delete. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRequest`](crate::model::DeleteRequest)
        pub fn build(self) -> crate::model::DeleteRequest {
            crate::model::DeleteRequest { key: self.key }
        }
    }
}
impl DeleteRequest {
    /// Creates a new builder-style object to manufacture [`DeleteRequest`](crate::model::DeleteRequest)
    pub fn builder() -> crate::model::delete_request::Builder {
        crate::model::delete_request::Builder::default()
    }
}

/// <p>Represents a request to perform a <code>PutItem</code> operation on an item.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRequest {
    /// <p>A map of attribute name to attribute values, representing the primary key of an item to be processed by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema.</p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl PutRequest {
    /// <p>A map of attribute name to attribute values, representing the primary key of an item to be processed by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema.</p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
}
impl std::fmt::Debug for PutRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRequest");
        formatter.field("item", &self.item);
        formatter.finish()
    }
}
/// See [`PutRequest`](crate::model::PutRequest)
pub mod put_request {
    /// A builder for [`PutRequest`](crate::model::PutRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute name to attribute values, representing the primary key of an item to be processed by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item = Some(hash_map);
            self
        }
        /// <p>A map of attribute name to attribute values, representing the primary key of an item to be processed by <code>PutItem</code>. All of the table's primary key attributes must be specified, and their data types must match those of the table's key schema. If any attributes are present in the item that are part of an index key schema for the table, their types must match the index key schema.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRequest`](crate::model::PutRequest)
        pub fn build(self) -> crate::model::PutRequest {
            crate::model::PutRequest { item: self.item }
        }
    }
}
impl PutRequest {
    /// Creates a new builder-style object to manufacture [`PutRequest`](crate::model::PutRequest)
    pub fn builder() -> crate::model::put_request::Builder {
        crate::model::put_request::Builder::default()
    }
}

/// <p>Represents a set of primary keys and, for each key, the attributes to retrieve from the table.</p>
/// <p>For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you only need to provide the partition key. For a composite primary key, you must provide <i>both</i> the partition key and the sort key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeysAndAttributes {
    /// <p>The primary key attribute values that define the items and the attributes associated with the items.</p>
    pub keys: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, crate::model::AttributeValue>>,
    >,
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
    pub consistent_read: std::option::Option<bool>,
    /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub projection_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
    /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
    /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li> <p> <code>Percentile</code> </p> </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li> <p> <code>#P = :val</code> </p> </li>
    /// </ul> <note>
    /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl KeysAndAttributes {
    /// <p>The primary key attribute values that define the items and the attributes associated with the items.</p>
    pub fn keys(
        &self,
    ) -> std::option::Option<
        &[std::collections::HashMap<std::string::String, crate::model::AttributeValue>],
    > {
        self.keys.as_deref()
    }
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn attributes_to_get(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes_to_get.as_deref()
    }
    /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
    /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn projection_expression(&self) -> std::option::Option<&str> {
        self.projection_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
    /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
    /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li> <p> <code>Percentile</code> </p> </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li> <p> <code>#P = :val</code> </p> </li>
    /// </ul> <note>
    /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
}
impl std::fmt::Debug for KeysAndAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeysAndAttributes");
        formatter.field("keys", &self.keys);
        formatter.field("attributes_to_get", &self.attributes_to_get);
        formatter.field("consistent_read", &self.consistent_read);
        formatter.field("projection_expression", &self.projection_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.finish()
    }
}
/// See [`KeysAndAttributes`](crate::model::KeysAndAttributes)
pub mod keys_and_attributes {
    /// A builder for [`KeysAndAttributes`](crate::model::KeysAndAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keys: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
        pub(crate) attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) consistent_read: std::option::Option<bool>,
        pub(crate) projection_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The primary key attribute values that define the items and the attributes associated with the items.</p>
        pub fn keys(
            mut self,
            input: std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        ) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input);
            self.keys = Some(v);
            self
        }
        /// <p>The primary key attribute values that define the items and the attributes associated with the items.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Appends an item to `attributes_to_get`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes_to_get.unwrap_or_default();
            v.push(input.into());
            self.attributes_to_get = Some(v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes_to_get = input;
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.projection_expression = Some(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.projection_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p>To access an attribute whose name conflicts with a DynamoDB reserved word.</p> </li>
        /// <li> <p>To create a placeholder for repeating occurrences of an attribute name in an expression.</p> </li>
        /// <li> <p>To prevent special characters in an attribute name from being misinterpreted in an expression.</p> </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li> <p> <code>Percentile</code> </p> </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li> <p> <code>{"#P":"Percentile"}</code> </p> </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li> <p> <code>#P = :val</code> </p> </li>
        /// </ul> <note>
        /// <p>Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`KeysAndAttributes`](crate::model::KeysAndAttributes)
        pub fn build(self) -> crate::model::KeysAndAttributes {
            crate::model::KeysAndAttributes {
                keys: self.keys,
                attributes_to_get: self.attributes_to_get,
                consistent_read: self.consistent_read,
                projection_expression: self.projection_expression,
                expression_attribute_names: self.expression_attribute_names,
            }
        }
    }
}
impl KeysAndAttributes {
    /// Creates a new builder-style object to manufacture [`KeysAndAttributes`](crate::model::KeysAndAttributes)
    pub fn builder() -> crate::model::keys_and_attributes::Builder {
        crate::model::keys_and_attributes::Builder::default()
    }
}

/// <p> A PartiQL batch statement response.. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStatementResponse {
    /// <p> The error associated with a failed PartiQL batch statement. </p>
    pub error: std::option::Option<crate::model::BatchStatementError>,
    /// <p> The table name associated with a failed PartiQL batch statement. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p> A DynamoDB item associated with a BatchStatementResponse </p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl BatchStatementResponse {
    /// <p> The error associated with a failed PartiQL batch statement. </p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchStatementError> {
        self.error.as_ref()
    }
    /// <p> The table name associated with a failed PartiQL batch statement. </p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p> A DynamoDB item associated with a BatchStatementResponse </p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
}
impl std::fmt::Debug for BatchStatementResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStatementResponse");
        formatter.field("error", &self.error);
        formatter.field("table_name", &self.table_name);
        formatter.field("item", &self.item);
        formatter.finish()
    }
}
/// See [`BatchStatementResponse`](crate::model::BatchStatementResponse)
pub mod batch_statement_response {
    /// A builder for [`BatchStatementResponse`](crate::model::BatchStatementResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error: std::option::Option<crate::model::BatchStatementError>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// <p> The error associated with a failed PartiQL batch statement. </p>
        pub fn error(mut self, input: crate::model::BatchStatementError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p> The error associated with a failed PartiQL batch statement. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchStatementError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p> The table name associated with a failed PartiQL batch statement. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p> The table name associated with a failed PartiQL batch statement. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p> A DynamoDB item associated with a BatchStatementResponse </p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::AttributeValue,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.item = Some(hash_map);
            self
        }
        /// <p> A DynamoDB item associated with a BatchStatementResponse </p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStatementResponse`](crate::model::BatchStatementResponse)
        pub fn build(self) -> crate::model::BatchStatementResponse {
            crate::model::BatchStatementResponse {
                error: self.error,
                table_name: self.table_name,
                item: self.item,
            }
        }
    }
}
impl BatchStatementResponse {
    /// Creates a new builder-style object to manufacture [`BatchStatementResponse`](crate::model::BatchStatementResponse)
    pub fn builder() -> crate::model::batch_statement_response::Builder {
        crate::model::batch_statement_response::Builder::default()
    }
}

/// <p> An error associated with a statement in a PartiQL batch that was run. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStatementError {
    /// <p> The error code associated with the failed PartiQL batch statement. </p>
    pub code: std::option::Option<crate::model::BatchStatementErrorCodeEnum>,
    /// <p> The error message associated with the PartiQL batch resposne. </p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchStatementError {
    /// <p> The error code associated with the failed PartiQL batch statement. </p>
    pub fn code(&self) -> std::option::Option<&crate::model::BatchStatementErrorCodeEnum> {
        self.code.as_ref()
    }
    /// <p> The error message associated with the PartiQL batch resposne. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStatementError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchStatementError`](crate::model::BatchStatementError)
pub mod batch_statement_error {
    /// A builder for [`BatchStatementError`](crate::model::BatchStatementError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::BatchStatementErrorCodeEnum>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The error code associated with the failed PartiQL batch statement. </p>
        pub fn code(mut self, input: crate::model::BatchStatementErrorCodeEnum) -> Self {
            self.code = Some(input);
            self
        }
        /// <p> The error code associated with the failed PartiQL batch statement. </p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::BatchStatementErrorCodeEnum>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p> The error message associated with the PartiQL batch resposne. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> The error message associated with the PartiQL batch resposne. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStatementError`](crate::model::BatchStatementError)
        pub fn build(self) -> crate::model::BatchStatementError {
            crate::model::BatchStatementError {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BatchStatementError {
    /// Creates a new builder-style object to manufacture [`BatchStatementError`](crate::model::BatchStatementError)
    pub fn builder() -> crate::model::batch_statement_error::Builder {
        crate::model::batch_statement_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchStatementErrorCodeEnum {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    ConditionalCheckFailed,
    #[allow(missing_docs)] // documentation missing in model
    DuplicateItem,
    #[allow(missing_docs)] // documentation missing in model
    InternalServerError,
    #[allow(missing_docs)] // documentation missing in model
    ItemCollectionSizeLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ProvisionedThroughputExceeded,
    #[allow(missing_docs)] // documentation missing in model
    RequestLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingError,
    #[allow(missing_docs)] // documentation missing in model
    TransactionConflict,
    #[allow(missing_docs)] // documentation missing in model
    ValidationError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchStatementErrorCodeEnum {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => BatchStatementErrorCodeEnum::AccessDenied,
            "ConditionalCheckFailed" => BatchStatementErrorCodeEnum::ConditionalCheckFailed,
            "DuplicateItem" => BatchStatementErrorCodeEnum::DuplicateItem,
            "InternalServerError" => BatchStatementErrorCodeEnum::InternalServerError,
            "ItemCollectionSizeLimitExceeded" => {
                BatchStatementErrorCodeEnum::ItemCollectionSizeLimitExceeded
            }
            "ProvisionedThroughputExceeded" => {
                BatchStatementErrorCodeEnum::ProvisionedThroughputExceeded
            }
            "RequestLimitExceeded" => BatchStatementErrorCodeEnum::RequestLimitExceeded,
            "ResourceNotFound" => BatchStatementErrorCodeEnum::ResourceNotFound,
            "ThrottlingError" => BatchStatementErrorCodeEnum::ThrottlingError,
            "TransactionConflict" => BatchStatementErrorCodeEnum::TransactionConflict,
            "ValidationError" => BatchStatementErrorCodeEnum::ValidationError,
            other => BatchStatementErrorCodeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchStatementErrorCodeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchStatementErrorCodeEnum::from(s))
    }
}
impl BatchStatementErrorCodeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchStatementErrorCodeEnum::AccessDenied => "AccessDenied",
            BatchStatementErrorCodeEnum::ConditionalCheckFailed => "ConditionalCheckFailed",
            BatchStatementErrorCodeEnum::DuplicateItem => "DuplicateItem",
            BatchStatementErrorCodeEnum::InternalServerError => "InternalServerError",
            BatchStatementErrorCodeEnum::ItemCollectionSizeLimitExceeded => {
                "ItemCollectionSizeLimitExceeded"
            }
            BatchStatementErrorCodeEnum::ProvisionedThroughputExceeded => {
                "ProvisionedThroughputExceeded"
            }
            BatchStatementErrorCodeEnum::RequestLimitExceeded => "RequestLimitExceeded",
            BatchStatementErrorCodeEnum::ResourceNotFound => "ResourceNotFound",
            BatchStatementErrorCodeEnum::ThrottlingError => "ThrottlingError",
            BatchStatementErrorCodeEnum::TransactionConflict => "TransactionConflict",
            BatchStatementErrorCodeEnum::ValidationError => "ValidationError",
            BatchStatementErrorCodeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "ConditionalCheckFailed",
            "DuplicateItem",
            "InternalServerError",
            "ItemCollectionSizeLimitExceeded",
            "ProvisionedThroughputExceeded",
            "RequestLimitExceeded",
            "ResourceNotFound",
            "ThrottlingError",
            "TransactionConflict",
            "ValidationError",
        ]
    }
}
impl AsRef<str> for BatchStatementErrorCodeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A PartiQL batch statement request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStatementRequest {
    /// <p> A valid PartiQL statement. </p>
    pub statement: std::option::Option<std::string::String>,
    /// <p> The parameters associated with a PartiQL statement in the batch request. </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    /// <p> The read consistency of the PartiQL batch request. </p>
    pub consistent_read: std::option::Option<bool>,
}
impl BatchStatementRequest {
    /// <p> A valid PartiQL statement. </p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
    /// <p> The parameters associated with a PartiQL statement in the batch request. </p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.parameters.as_deref()
    }
    /// <p> The read consistency of the PartiQL batch request. </p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
}
impl std::fmt::Debug for BatchStatementRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStatementRequest");
        formatter.field("statement", &self.statement);
        formatter.field("parameters", &self.parameters);
        formatter.field("consistent_read", &self.consistent_read);
        formatter.finish()
    }
}
/// See [`BatchStatementRequest`](crate::model::BatchStatementRequest)
pub mod batch_statement_request {
    /// A builder for [`BatchStatementRequest`](crate::model::BatchStatementRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        pub(crate) consistent_read: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> A valid PartiQL statement. </p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p> A valid PartiQL statement. </p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p> The parameters associated with a PartiQL statement in the batch request. </p>
        pub fn parameters(mut self, input: crate::model::AttributeValue) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p> The parameters associated with a PartiQL statement in the batch request. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p> The read consistency of the PartiQL batch request. </p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p> The read consistency of the PartiQL batch request. </p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStatementRequest`](crate::model::BatchStatementRequest)
        pub fn build(self) -> crate::model::BatchStatementRequest {
            crate::model::BatchStatementRequest {
                statement: self.statement,
                parameters: self.parameters,
                consistent_read: self.consistent_read,
            }
        }
    }
}
impl BatchStatementRequest {
    /// Creates a new builder-style object to manufacture [`BatchStatementRequest`](crate::model::BatchStatementRequest)
    pub fn builder() -> crate::model::batch_statement_request::Builder {
        crate::model::batch_statement_request::Builder::default()
    }
}
