// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTimeToLiveOutput {
    /// <p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>
    pub time_to_live_specification: std::option::Option<crate::model::TimeToLiveSpecification>,
}
impl UpdateTimeToLiveOutput {
    /// <p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>
    pub fn time_to_live_specification(
        &self,
    ) -> std::option::Option<&crate::model::TimeToLiveSpecification> {
        self.time_to_live_specification.as_ref()
    }
}
impl std::fmt::Debug for UpdateTimeToLiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTimeToLiveOutput");
        formatter.field(
            "time_to_live_specification",
            &self.time_to_live_specification,
        );
        formatter.finish()
    }
}
/// See [`UpdateTimeToLiveOutput`](crate::output::UpdateTimeToLiveOutput)
pub mod update_time_to_live_output {
    /// A builder for [`UpdateTimeToLiveOutput`](crate::output::UpdateTimeToLiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live_specification:
            std::option::Option<crate::model::TimeToLiveSpecification>,
    }
    impl Builder {
        /// <p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>
        pub fn time_to_live_specification(
            mut self,
            input: crate::model::TimeToLiveSpecification,
        ) -> Self {
            self.time_to_live_specification = Some(input);
            self
        }
        /// <p>Represents the output of an <code>UpdateTimeToLive</code> operation.</p>
        pub fn set_time_to_live_specification(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveSpecification>,
        ) -> Self {
            self.time_to_live_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTimeToLiveOutput`](crate::output::UpdateTimeToLiveOutput)
        pub fn build(self) -> crate::output::UpdateTimeToLiveOutput {
            crate::output::UpdateTimeToLiveOutput {
                time_to_live_specification: self.time_to_live_specification,
            }
        }
    }
}
impl UpdateTimeToLiveOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTimeToLiveOutput`](crate::output::UpdateTimeToLiveOutput)
    pub fn builder() -> crate::output::update_time_to_live_output::Builder {
        crate::output::update_time_to_live_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableReplicaAutoScalingOutput {
    /// <p>Returns information about the auto scaling settings of a table with replicas.</p>
    pub table_auto_scaling_description:
        std::option::Option<crate::model::TableAutoScalingDescription>,
}
impl UpdateTableReplicaAutoScalingOutput {
    /// <p>Returns information about the auto scaling settings of a table with replicas.</p>
    pub fn table_auto_scaling_description(
        &self,
    ) -> std::option::Option<&crate::model::TableAutoScalingDescription> {
        self.table_auto_scaling_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateTableReplicaAutoScalingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableReplicaAutoScalingOutput");
        formatter.field(
            "table_auto_scaling_description",
            &self.table_auto_scaling_description,
        );
        formatter.finish()
    }
}
/// See [`UpdateTableReplicaAutoScalingOutput`](crate::output::UpdateTableReplicaAutoScalingOutput)
pub mod update_table_replica_auto_scaling_output {
    /// A builder for [`UpdateTableReplicaAutoScalingOutput`](crate::output::UpdateTableReplicaAutoScalingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_auto_scaling_description:
            std::option::Option<crate::model::TableAutoScalingDescription>,
    }
    impl Builder {
        /// <p>Returns information about the auto scaling settings of a table with replicas.</p>
        pub fn table_auto_scaling_description(
            mut self,
            input: crate::model::TableAutoScalingDescription,
        ) -> Self {
            self.table_auto_scaling_description = Some(input);
            self
        }
        /// <p>Returns information about the auto scaling settings of a table with replicas.</p>
        pub fn set_table_auto_scaling_description(
            mut self,
            input: std::option::Option<crate::model::TableAutoScalingDescription>,
        ) -> Self {
            self.table_auto_scaling_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableReplicaAutoScalingOutput`](crate::output::UpdateTableReplicaAutoScalingOutput)
        pub fn build(self) -> crate::output::UpdateTableReplicaAutoScalingOutput {
            crate::output::UpdateTableReplicaAutoScalingOutput {
                table_auto_scaling_description: self.table_auto_scaling_description,
            }
        }
    }
}
impl UpdateTableReplicaAutoScalingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTableReplicaAutoScalingOutput`](crate::output::UpdateTableReplicaAutoScalingOutput)
    pub fn builder() -> crate::output::update_table_replica_auto_scaling_output::Builder {
        crate::output::update_table_replica_auto_scaling_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>UpdateTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableOutput {
    /// <p>Represents the properties of the table.</p>
    pub table_description: std::option::Option<crate::model::TableDescription>,
}
impl UpdateTableOutput {
    /// <p>Represents the properties of the table.</p>
    pub fn table_description(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableOutput");
        formatter.field("table_description", &self.table_description);
        formatter.finish()
    }
}
/// See [`UpdateTableOutput`](crate::output::UpdateTableOutput)
pub mod update_table_output {
    /// A builder for [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_description: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>Represents the properties of the table.</p>
        pub fn table_description(mut self, input: crate::model::TableDescription) -> Self {
            self.table_description = Some(input);
            self
        }
        /// <p>Represents the properties of the table.</p>
        pub fn set_table_description(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableOutput`](crate::output::UpdateTableOutput)
        pub fn build(self) -> crate::output::UpdateTableOutput {
            crate::output::UpdateTableOutput {
                table_description: self.table_description,
            }
        }
    }
}
impl UpdateTableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    pub fn builder() -> crate::output::update_table_output::Builder {
        crate::output::update_table_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>UpdateItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateItemOutput {
    /// <p>A map of attribute values as they appear before or after the <code>UpdateItem</code>
    /// operation, as determined by the <code>ReturnValues</code> parameter.</p>
    /// <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was
    /// specified as something other than <code>NONE</code> in the request. Each element
    /// represents one attribute.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>UpdateItem</code> operation. The data
    /// returned includes the total provisioned throughput consumed, along with statistics for
    /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
    /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
    /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only
    /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
    /// table does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub item_collection_metrics: std::option::Option<crate::model::ItemCollectionMetrics>,
}
impl UpdateItemOutput {
    /// <p>A map of attribute values as they appear before or after the <code>UpdateItem</code>
    /// operation, as determined by the <code>ReturnValues</code> parameter.</p>
    /// <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was
    /// specified as something other than <code>NONE</code> in the request. Each element
    /// represents one attribute.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The capacity units consumed by the <code>UpdateItem</code> operation. The data
    /// returned includes the total provisioned throughput consumed, along with statistics for
    /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
    /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
    /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only
    /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
    /// table does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub fn item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ItemCollectionMetrics> {
        self.item_collection_metrics.as_ref()
    }
}
impl std::fmt::Debug for UpdateItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateItemOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("item_collection_metrics", &self.item_collection_metrics);
        formatter.finish()
    }
}
/// See [`UpdateItemOutput`](crate::output::UpdateItemOutput)
pub mod update_item_output {
    /// A builder for [`UpdateItemOutput`](crate::output::UpdateItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
        pub(crate) item_collection_metrics:
            std::option::Option<crate::model::ItemCollectionMetrics>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attribute values as they appear before or after the <code>UpdateItem</code>
        /// operation, as determined by the <code>ReturnValues</code> parameter.</p>
        /// <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was
        /// specified as something other than <code>NONE</code> in the request. Each element
        /// represents one attribute.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of attribute values as they appear before or after the <code>UpdateItem</code>
        /// operation, as determined by the <code>ReturnValues</code> parameter.</p>
        /// <p>The <code>Attributes</code> map is only present if <code>ReturnValues</code> was
        /// specified as something other than <code>NONE</code> in the request. Each element
        /// represents one attribute.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The capacity units consumed by the <code>UpdateItem</code> operation. The data
        /// returned includes the total provisioned throughput consumed, along with statistics for
        /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
        /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
        /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>UpdateItem</code> operation. The data
        /// returned includes the total provisioned throughput consumed, along with statistics for
        /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
        /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
        /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only
        /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
        /// table does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn item_collection_metrics(
            mut self,
            input: crate::model::ItemCollectionMetrics,
        ) -> Self {
            self.item_collection_metrics = Some(input);
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>UpdateItem</code> operation. <code>ItemCollectionMetrics</code> is only
        /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
        /// table does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn set_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ItemCollectionMetrics>,
        ) -> Self {
            self.item_collection_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateItemOutput`](crate::output::UpdateItemOutput)
        pub fn build(self) -> crate::output::UpdateItemOutput {
            crate::output::UpdateItemOutput {
                attributes: self.attributes,
                consumed_capacity: self.consumed_capacity,
                item_collection_metrics: self.item_collection_metrics,
            }
        }
    }
}
impl UpdateItemOutput {
    /// Creates a new builder-style object to manufacture [`UpdateItemOutput`](crate::output::UpdateItemOutput)
    pub fn builder() -> crate::output::update_item_output::Builder {
        crate::output::update_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalTableSettingsOutput {
    /// <p>The name of the global table.</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>The Region-specific settings for the global table.</p>
    pub replica_settings:
        std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
}
impl UpdateGlobalTableSettingsOutput {
    /// <p>The name of the global table.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>The Region-specific settings for the global table.</p>
    pub fn replica_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaSettingsDescription]> {
        self.replica_settings.as_deref()
    }
}
impl std::fmt::Debug for UpdateGlobalTableSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalTableSettingsOutput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("replica_settings", &self.replica_settings);
        formatter.finish()
    }
}
/// See [`UpdateGlobalTableSettingsOutput`](crate::output::UpdateGlobalTableSettingsOutput)
pub mod update_global_table_settings_output {
    /// A builder for [`UpdateGlobalTableSettingsOutput`](crate::output::UpdateGlobalTableSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) replica_settings:
            std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
    }
    impl Builder {
        /// <p>The name of the global table.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Appends an item to `replica_settings`.
        ///
        /// To override the contents of this collection use [`set_replica_settings`](Self::set_replica_settings).
        ///
        /// <p>The Region-specific settings for the global table.</p>
        pub fn replica_settings(
            mut self,
            input: impl Into<crate::model::ReplicaSettingsDescription>,
        ) -> Self {
            let mut v = self.replica_settings.unwrap_or_default();
            v.push(input.into());
            self.replica_settings = Some(v);
            self
        }
        /// <p>The Region-specific settings for the global table.</p>
        pub fn set_replica_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
        ) -> Self {
            self.replica_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalTableSettingsOutput`](crate::output::UpdateGlobalTableSettingsOutput)
        pub fn build(self) -> crate::output::UpdateGlobalTableSettingsOutput {
            crate::output::UpdateGlobalTableSettingsOutput {
                global_table_name: self.global_table_name,
                replica_settings: self.replica_settings,
            }
        }
    }
}
impl UpdateGlobalTableSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableSettingsOutput`](crate::output::UpdateGlobalTableSettingsOutput)
    pub fn builder() -> crate::output::update_global_table_settings_output::Builder {
        crate::output::update_global_table_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub global_table_description: std::option::Option<crate::model::GlobalTableDescription>,
}
impl UpdateGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub fn global_table_description(
        &self,
    ) -> std::option::Option<&crate::model::GlobalTableDescription> {
        self.global_table_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateGlobalTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalTableOutput");
        formatter.field("global_table_description", &self.global_table_description);
        formatter.finish()
    }
}
/// See [`UpdateGlobalTableOutput`](crate::output::UpdateGlobalTableOutput)
pub mod update_global_table_output {
    /// A builder for [`UpdateGlobalTableOutput`](crate::output::UpdateGlobalTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_description:
            std::option::Option<crate::model::GlobalTableDescription>,
    }
    impl Builder {
        /// <p>Contains the details of the global table.</p>
        pub fn global_table_description(
            mut self,
            input: crate::model::GlobalTableDescription,
        ) -> Self {
            self.global_table_description = Some(input);
            self
        }
        /// <p>Contains the details of the global table.</p>
        pub fn set_global_table_description(
            mut self,
            input: std::option::Option<crate::model::GlobalTableDescription>,
        ) -> Self {
            self.global_table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalTableOutput`](crate::output::UpdateGlobalTableOutput)
        pub fn build(self) -> crate::output::UpdateGlobalTableOutput {
            crate::output::UpdateGlobalTableOutput {
                global_table_description: self.global_table_description,
            }
        }
    }
}
impl UpdateGlobalTableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableOutput`](crate::output::UpdateGlobalTableOutput)
    pub fn builder() -> crate::output::update_global_table_output::Builder {
        crate::output::update_global_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContributorInsightsOutput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the global secondary index, if applicable.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The status of contributor insights</p>
    pub contributor_insights_status: std::option::Option<crate::model::ContributorInsightsStatus>,
}
impl UpdateContributorInsightsOutput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the global secondary index, if applicable.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The status of contributor insights</p>
    pub fn contributor_insights_status(
        &self,
    ) -> std::option::Option<&crate::model::ContributorInsightsStatus> {
        self.contributor_insights_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateContributorInsightsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContributorInsightsOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "contributor_insights_status",
            &self.contributor_insights_status,
        );
        formatter.finish()
    }
}
/// See [`UpdateContributorInsightsOutput`](crate::output::UpdateContributorInsightsOutput)
pub mod update_contributor_insights_output {
    /// A builder for [`UpdateContributorInsightsOutput`](crate::output::UpdateContributorInsightsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) contributor_insights_status:
            std::option::Option<crate::model::ContributorInsightsStatus>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the global secondary index, if applicable.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The status of contributor insights</p>
        pub fn contributor_insights_status(
            mut self,
            input: crate::model::ContributorInsightsStatus,
        ) -> Self {
            self.contributor_insights_status = Some(input);
            self
        }
        /// <p>The status of contributor insights</p>
        pub fn set_contributor_insights_status(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsStatus>,
        ) -> Self {
            self.contributor_insights_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContributorInsightsOutput`](crate::output::UpdateContributorInsightsOutput)
        pub fn build(self) -> crate::output::UpdateContributorInsightsOutput {
            crate::output::UpdateContributorInsightsOutput {
                table_name: self.table_name,
                index_name: self.index_name,
                contributor_insights_status: self.contributor_insights_status,
            }
        }
    }
}
impl UpdateContributorInsightsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContributorInsightsOutput`](crate::output::UpdateContributorInsightsOutput)
    pub fn builder() -> crate::output::update_contributor_insights_output::Builder {
        crate::output::update_contributor_insights_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContinuousBackupsOutput {
    /// <p>Represents the continuous backups and point in time recovery settings on the
    /// table.</p>
    pub continuous_backups_description:
        std::option::Option<crate::model::ContinuousBackupsDescription>,
}
impl UpdateContinuousBackupsOutput {
    /// <p>Represents the continuous backups and point in time recovery settings on the
    /// table.</p>
    pub fn continuous_backups_description(
        &self,
    ) -> std::option::Option<&crate::model::ContinuousBackupsDescription> {
        self.continuous_backups_description.as_ref()
    }
}
impl std::fmt::Debug for UpdateContinuousBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContinuousBackupsOutput");
        formatter.field(
            "continuous_backups_description",
            &self.continuous_backups_description,
        );
        formatter.finish()
    }
}
/// See [`UpdateContinuousBackupsOutput`](crate::output::UpdateContinuousBackupsOutput)
pub mod update_continuous_backups_output {
    /// A builder for [`UpdateContinuousBackupsOutput`](crate::output::UpdateContinuousBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continuous_backups_description:
            std::option::Option<crate::model::ContinuousBackupsDescription>,
    }
    impl Builder {
        /// <p>Represents the continuous backups and point in time recovery settings on the
        /// table.</p>
        pub fn continuous_backups_description(
            mut self,
            input: crate::model::ContinuousBackupsDescription,
        ) -> Self {
            self.continuous_backups_description = Some(input);
            self
        }
        /// <p>Represents the continuous backups and point in time recovery settings on the
        /// table.</p>
        pub fn set_continuous_backups_description(
            mut self,
            input: std::option::Option<crate::model::ContinuousBackupsDescription>,
        ) -> Self {
            self.continuous_backups_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContinuousBackupsOutput`](crate::output::UpdateContinuousBackupsOutput)
        pub fn build(self) -> crate::output::UpdateContinuousBackupsOutput {
            crate::output::UpdateContinuousBackupsOutput {
                continuous_backups_description: self.continuous_backups_description,
            }
        }
    }
}
impl UpdateContinuousBackupsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContinuousBackupsOutput`](crate::output::UpdateContinuousBackupsOutput)
    pub fn builder() -> crate::output::update_continuous_backups_output::Builder {
        crate::output::update_continuous_backups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactWriteItemsOutput {
    /// <p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation.
    /// The values of the list are ordered according to the ordering of the
    /// <code>TransactItems</code> request parameter. </p>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    /// <p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each
    /// table, information about any item collections that were affected by individual
    /// <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code>
    /// operations. </p>
    pub item_collection_metrics: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ItemCollectionMetrics>,
        >,
    >,
}
impl TransactWriteItemsOutput {
    /// <p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation.
    /// The values of the list are ordered according to the ordering of the
    /// <code>TransactItems</code> request parameter. </p>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
    /// <p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each
    /// table, information about any item collections that were affected by individual
    /// <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code>
    /// operations. </p>
    pub fn item_collection_metrics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ItemCollectionMetrics>,
        >,
    > {
        self.item_collection_metrics.as_ref()
    }
}
impl std::fmt::Debug for TransactWriteItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactWriteItemsOutput");
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("item_collection_metrics", &self.item_collection_metrics);
        formatter.finish()
    }
}
/// See [`TransactWriteItemsOutput`](crate::output::TransactWriteItemsOutput)
pub mod transact_write_items_output {
    /// A builder for [`TransactWriteItemsOutput`](crate::output::TransactWriteItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        pub(crate) item_collection_metrics: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ItemCollectionMetrics>,
            >,
        >,
    }
    impl Builder {
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation.
        /// The values of the list are ordered according to the ordering of the
        /// <code>TransactItems</code> request parameter. </p>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>The capacity units consumed by the entire <code>TransactWriteItems</code> operation.
        /// The values of the list are ordered according to the ordering of the
        /// <code>TransactItems</code> request parameter. </p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Adds a key-value pair to `item_collection_metrics`.
        ///
        /// To override the contents of this collection use [`set_item_collection_metrics`](Self::set_item_collection_metrics).
        ///
        /// <p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each
        /// table, information about any item collections that were affected by individual
        /// <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code>
        /// operations. </p>
        pub fn item_collection_metrics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ItemCollectionMetrics>>,
        ) -> Self {
            let mut hash_map = self.item_collection_metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item_collection_metrics = Some(hash_map);
            self
        }
        /// <p>A list of tables that were processed by <code>TransactWriteItems</code> and, for each
        /// table, information about any item collections that were affected by individual
        /// <code>UpdateItem</code>, <code>PutItem</code>, or <code>DeleteItem</code>
        /// operations. </p>
        pub fn set_item_collection_metrics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ItemCollectionMetrics>,
                >,
            >,
        ) -> Self {
            self.item_collection_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactWriteItemsOutput`](crate::output::TransactWriteItemsOutput)
        pub fn build(self) -> crate::output::TransactWriteItemsOutput {
            crate::output::TransactWriteItemsOutput {
                consumed_capacity: self.consumed_capacity,
                item_collection_metrics: self.item_collection_metrics,
            }
        }
    }
}
impl TransactWriteItemsOutput {
    /// Creates a new builder-style object to manufacture [`TransactWriteItemsOutput`](crate::output::TransactWriteItemsOutput)
    pub fn builder() -> crate::output::transact_write_items_output::Builder {
        crate::output::transact_write_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactGetItemsOutput {
    /// <p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this
    /// is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by
    /// <code>TransactGetItem</code> objects in the <i>TransactItems</i>
    /// parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units
    /// consumed by the <code>TransactGetItems</code> call in that table.</p>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    /// <p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which
    /// corresponds to the <code>TransactGetItem</code> object in the same position in the
    /// <i>TransactItems</i> array. Each <code>ItemResponse</code> object
    /// contains a Map of the name-value pairs that are the projected attributes of the
    /// requested item.</p>
    /// <p>If a requested item could not be retrieved, the corresponding
    /// <code>ItemResponse</code> object is Null, or if the requested item has no projected
    /// attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
}
impl TransactGetItemsOutput {
    /// <p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this
    /// is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by
    /// <code>TransactGetItem</code> objects in the <i>TransactItems</i>
    /// parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units
    /// consumed by the <code>TransactGetItems</code> call in that table.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
    /// <p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which
    /// corresponds to the <code>TransactGetItem</code> object in the same position in the
    /// <i>TransactItems</i> array. Each <code>ItemResponse</code> object
    /// contains a Map of the name-value pairs that are the projected attributes of the
    /// requested item.</p>
    /// <p>If a requested item could not be retrieved, the corresponding
    /// <code>ItemResponse</code> object is Null, or if the requested item has no projected
    /// attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::ItemResponse]> {
        self.responses.as_deref()
    }
}
impl std::fmt::Debug for TransactGetItemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactGetItemsOutput");
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("responses", &self.responses);
        formatter.finish()
    }
}
/// See [`TransactGetItemsOutput`](crate::output::TransactGetItemsOutput)
pub mod transact_get_items_output {
    /// A builder for [`TransactGetItemsOutput`](crate::output::TransactGetItemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        pub(crate) responses: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
    }
    impl Builder {
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this
        /// is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by
        /// <code>TransactGetItem</code> objects in the <i>TransactItems</i>
        /// parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units
        /// consumed by the <code>TransactGetItems</code> call in that table.</p>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>If the <i>ReturnConsumedCapacity</i> value was <code>TOTAL</code>, this
        /// is an array of <code>ConsumedCapacity</code> objects, one for each table addressed by
        /// <code>TransactGetItem</code> objects in the <i>TransactItems</i>
        /// parameter. These <code>ConsumedCapacity</code> objects report the read-capacity units
        /// consumed by the <code>TransactGetItems</code> call in that table.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which
        /// corresponds to the <code>TransactGetItem</code> object in the same position in the
        /// <i>TransactItems</i> array. Each <code>ItemResponse</code> object
        /// contains a Map of the name-value pairs that are the projected attributes of the
        /// requested item.</p>
        /// <p>If a requested item could not be retrieved, the corresponding
        /// <code>ItemResponse</code> object is Null, or if the requested item has no projected
        /// attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>
        pub fn responses(mut self, input: impl Into<crate::model::ItemResponse>) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>An ordered array of up to 25 <code>ItemResponse</code> objects, each of which
        /// corresponds to the <code>TransactGetItem</code> object in the same position in the
        /// <i>TransactItems</i> array. Each <code>ItemResponse</code> object
        /// contains a Map of the name-value pairs that are the projected attributes of the
        /// requested item.</p>
        /// <p>If a requested item could not be retrieved, the corresponding
        /// <code>ItemResponse</code> object is Null, or if the requested item has no projected
        /// attributes, the corresponding <code>ItemResponse</code> object is an empty Map. </p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactGetItemsOutput`](crate::output::TransactGetItemsOutput)
        pub fn build(self) -> crate::output::TransactGetItemsOutput {
            crate::output::TransactGetItemsOutput {
                consumed_capacity: self.consumed_capacity,
                responses: self.responses,
            }
        }
    }
}
impl TransactGetItemsOutput {
    /// Creates a new builder-style object to manufacture [`TransactGetItemsOutput`](crate::output::TransactGetItemsOutput)
    pub fn builder() -> crate::output::transact_get_items_output::Builder {
        crate::output::transact_get_items_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>Scan</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanOutput {
    /// <p>An array of item attributes that match the scan criteria. Each element in this array
    /// consists of an attribute name and the value for that attribute.</p>
    pub items: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, crate::model::AttributeValue>>,
    >,
    /// <p>The number of items in the response.</p>
    /// <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the
    /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
    /// the number of matching items before the filter was applied.</p>
    /// <p>If you did not use a filter in the request, then <code>Count</code> is the same as
    /// <code>ScannedCount</code>.</p>
    pub count: i32,
    /// <p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high
    /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
    /// indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
    /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
    /// as <code>Count</code>.</p>
    pub scanned_count: i32,
    /// <p>The primary key of the item where the operation stopped, inclusive of the previous
    /// result set. Use this value to start a new operation, excluding this value in the new
    /// request.</p>
    /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
    /// processed and there is no more data to be retrieved.</p>
    /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
    /// is more data in the result set. The only way to know when you have reached the end of
    /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    pub last_evaluated_key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>Scan</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
}
impl ScanOutput {
    /// <p>An array of item attributes that match the scan criteria. Each element in this array
    /// consists of an attribute name and the value for that attribute.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<
        &[std::collections::HashMap<std::string::String, crate::model::AttributeValue>],
    > {
        self.items.as_deref()
    }
    /// <p>The number of items in the response.</p>
    /// <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the
    /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
    /// the number of matching items before the filter was applied.</p>
    /// <p>If you did not use a filter in the request, then <code>Count</code> is the same as
    /// <code>ScannedCount</code>.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
    /// <p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high
    /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
    /// indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
    /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
    /// as <code>Count</code>.</p>
    pub fn scanned_count(&self) -> i32 {
        self.scanned_count
    }
    /// <p>The primary key of the item where the operation stopped, inclusive of the previous
    /// result set. Use this value to start a new operation, excluding this value in the new
    /// request.</p>
    /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
    /// processed and there is no more data to be retrieved.</p>
    /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
    /// is more data in the result set. The only way to know when you have reached the end of
    /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    pub fn last_evaluated_key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.last_evaluated_key.as_ref()
    }
    /// <p>The capacity units consumed by the <code>Scan</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for ScanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanOutput");
        formatter.field("items", &self.items);
        formatter.field("count", &self.count);
        formatter.field("scanned_count", &self.scanned_count);
        formatter.field("last_evaluated_key", &self.last_evaluated_key);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`ScanOutput`](crate::output::ScanOutput)
pub mod scan_output {
    /// A builder for [`ScanOutput`](crate::output::ScanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) scanned_count: std::option::Option<i32>,
        pub(crate) last_evaluated_key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of item attributes that match the scan criteria. Each element in this array
        /// consists of an attribute name and the value for that attribute.</p>
        pub fn items(
            mut self,
            input: impl Into<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of item attributes that match the scan criteria. Each element in this array
        /// consists of an attribute name and the value for that attribute.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The number of items in the response.</p>
        /// <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the
        /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
        /// the number of matching items before the filter was applied.</p>
        /// <p>If you did not use a filter in the request, then <code>Count</code> is the same as
        /// <code>ScannedCount</code>.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of items in the response.</p>
        /// <p>If you set <code>ScanFilter</code> in the request, then <code>Count</code> is the
        /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
        /// the number of matching items before the filter was applied.</p>
        /// <p>If you did not use a filter in the request, then <code>Count</code> is the same as
        /// <code>ScannedCount</code>.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high
        /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
        /// indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
        /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
        /// as <code>Count</code>.</p>
        pub fn scanned_count(mut self, input: i32) -> Self {
            self.scanned_count = Some(input);
            self
        }
        /// <p>The number of items evaluated, before any <code>ScanFilter</code> is applied. A high
        /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
        /// indicates an inefficient <code>Scan</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
        /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
        /// as <code>Count</code>.</p>
        pub fn set_scanned_count(mut self, input: std::option::Option<i32>) -> Self {
            self.scanned_count = input;
            self
        }
        /// Adds a key-value pair to `last_evaluated_key`.
        ///
        /// To override the contents of this collection use [`set_last_evaluated_key`](Self::set_last_evaluated_key).
        ///
        /// <p>The primary key of the item where the operation stopped, inclusive of the previous
        /// result set. Use this value to start a new operation, excluding this value in the new
        /// request.</p>
        /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
        /// processed and there is no more data to be retrieved.</p>
        /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
        /// is more data in the result set. The only way to know when you have reached the end of
        /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
        pub fn last_evaluated_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.last_evaluated_key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.last_evaluated_key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item where the operation stopped, inclusive of the previous
        /// result set. Use this value to start a new operation, excluding this value in the new
        /// request.</p>
        /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
        /// processed and there is no more data to be retrieved.</p>
        /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
        /// is more data in the result set. The only way to know when you have reached the end of
        /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
        pub fn set_last_evaluated_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.last_evaluated_key = input;
            self
        }
        /// <p>The capacity units consumed by the <code>Scan</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>Scan</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanOutput`](crate::output::ScanOutput)
        pub fn build(self) -> crate::output::ScanOutput {
            crate::output::ScanOutput {
                items: self.items,
                count: self.count.unwrap_or_default(),
                scanned_count: self.scanned_count.unwrap_or_default(),
                last_evaluated_key: self.last_evaluated_key,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl ScanOutput {
    /// Creates a new builder-style object to manufacture [`ScanOutput`](crate::output::ScanOutput)
    pub fn builder() -> crate::output::scan_output::Builder {
        crate::output::scan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableToPointInTimeOutput {
    /// <p>Represents the properties of a table.</p>
    pub table_description: std::option::Option<crate::model::TableDescription>,
}
impl RestoreTableToPointInTimeOutput {
    /// <p>Represents the properties of a table.</p>
    pub fn table_description(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table_description.as_ref()
    }
}
impl std::fmt::Debug for RestoreTableToPointInTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableToPointInTimeOutput");
        formatter.field("table_description", &self.table_description);
        formatter.finish()
    }
}
/// See [`RestoreTableToPointInTimeOutput`](crate::output::RestoreTableToPointInTimeOutput)
pub mod restore_table_to_point_in_time_output {
    /// A builder for [`RestoreTableToPointInTimeOutput`](crate::output::RestoreTableToPointInTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_description: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>Represents the properties of a table.</p>
        pub fn table_description(mut self, input: crate::model::TableDescription) -> Self {
            self.table_description = Some(input);
            self
        }
        /// <p>Represents the properties of a table.</p>
        pub fn set_table_description(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableToPointInTimeOutput`](crate::output::RestoreTableToPointInTimeOutput)
        pub fn build(self) -> crate::output::RestoreTableToPointInTimeOutput {
            crate::output::RestoreTableToPointInTimeOutput {
                table_description: self.table_description,
            }
        }
    }
}
impl RestoreTableToPointInTimeOutput {
    /// Creates a new builder-style object to manufacture [`RestoreTableToPointInTimeOutput`](crate::output::RestoreTableToPointInTimeOutput)
    pub fn builder() -> crate::output::restore_table_to_point_in_time_output::Builder {
        crate::output::restore_table_to_point_in_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableFromBackupOutput {
    /// <p>The description of the table created from an existing backup.</p>
    pub table_description: std::option::Option<crate::model::TableDescription>,
}
impl RestoreTableFromBackupOutput {
    /// <p>The description of the table created from an existing backup.</p>
    pub fn table_description(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table_description.as_ref()
    }
}
impl std::fmt::Debug for RestoreTableFromBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableFromBackupOutput");
        formatter.field("table_description", &self.table_description);
        formatter.finish()
    }
}
/// See [`RestoreTableFromBackupOutput`](crate::output::RestoreTableFromBackupOutput)
pub mod restore_table_from_backup_output {
    /// A builder for [`RestoreTableFromBackupOutput`](crate::output::RestoreTableFromBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_description: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>The description of the table created from an existing backup.</p>
        pub fn table_description(mut self, input: crate::model::TableDescription) -> Self {
            self.table_description = Some(input);
            self
        }
        /// <p>The description of the table created from an existing backup.</p>
        pub fn set_table_description(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableFromBackupOutput`](crate::output::RestoreTableFromBackupOutput)
        pub fn build(self) -> crate::output::RestoreTableFromBackupOutput {
            crate::output::RestoreTableFromBackupOutput {
                table_description: self.table_description,
            }
        }
    }
}
impl RestoreTableFromBackupOutput {
    /// Creates a new builder-style object to manufacture [`RestoreTableFromBackupOutput`](crate::output::RestoreTableFromBackupOutput)
    pub fn builder() -> crate::output::restore_table_from_backup_output::Builder {
        crate::output::restore_table_from_backup_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>Query</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryOutput {
    /// <p>An array of item attributes that match the query criteria. Each element in this array
    /// consists of an attribute name and the value for that attribute.</p>
    pub items: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, crate::model::AttributeValue>>,
    >,
    /// <p>The number of items in the response.</p>
    /// <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the
    /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
    /// the number of matching items before the filter was applied.</p>
    /// <p>If you did not use a filter in the request, then <code>Count</code> and
    /// <code>ScannedCount</code> are the same.</p>
    pub count: i32,
    /// <p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
    /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
    /// indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
    /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
    /// as <code>Count</code>.</p>
    pub scanned_count: i32,
    /// <p>The primary key of the item where the operation stopped, inclusive of the previous
    /// result set. Use this value to start a new operation, excluding this value in the new
    /// request.</p>
    /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
    /// processed and there is no more data to be retrieved.</p>
    /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
    /// is more data in the result set. The only way to know when you have reached the end of
    /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    pub last_evaluated_key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>Query</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
}
impl QueryOutput {
    /// <p>An array of item attributes that match the query criteria. Each element in this array
    /// consists of an attribute name and the value for that attribute.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<
        &[std::collections::HashMap<std::string::String, crate::model::AttributeValue>],
    > {
        self.items.as_deref()
    }
    /// <p>The number of items in the response.</p>
    /// <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the
    /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
    /// the number of matching items before the filter was applied.</p>
    /// <p>If you did not use a filter in the request, then <code>Count</code> and
    /// <code>ScannedCount</code> are the same.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
    /// <p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
    /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
    /// indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
    /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
    /// as <code>Count</code>.</p>
    pub fn scanned_count(&self) -> i32 {
        self.scanned_count
    }
    /// <p>The primary key of the item where the operation stopped, inclusive of the previous
    /// result set. Use this value to start a new operation, excluding this value in the new
    /// request.</p>
    /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
    /// processed and there is no more data to be retrieved.</p>
    /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
    /// is more data in the result set. The only way to know when you have reached the end of
    /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
    pub fn last_evaluated_key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.last_evaluated_key.as_ref()
    }
    /// <p>The capacity units consumed by the <code>Query</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for QueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryOutput");
        formatter.field("items", &self.items);
        formatter.field("count", &self.count);
        formatter.field("scanned_count", &self.scanned_count);
        formatter.field("last_evaluated_key", &self.last_evaluated_key);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`QueryOutput`](crate::output::QueryOutput)
pub mod query_output {
    /// A builder for [`QueryOutput`](crate::output::QueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) scanned_count: std::option::Option<i32>,
        pub(crate) last_evaluated_key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>An array of item attributes that match the query criteria. Each element in this array
        /// consists of an attribute name and the value for that attribute.</p>
        pub fn items(
            mut self,
            input: impl Into<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>An array of item attributes that match the query criteria. Each element in this array
        /// consists of an attribute name and the value for that attribute.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The number of items in the response.</p>
        /// <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the
        /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
        /// the number of matching items before the filter was applied.</p>
        /// <p>If you did not use a filter in the request, then <code>Count</code> and
        /// <code>ScannedCount</code> are the same.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of items in the response.</p>
        /// <p>If you used a <code>QueryFilter</code> in the request, then <code>Count</code> is the
        /// number of items returned after the filter was applied, and <code>ScannedCount</code> is
        /// the number of matching items before the filter was applied.</p>
        /// <p>If you did not use a filter in the request, then <code>Count</code> and
        /// <code>ScannedCount</code> are the same.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
        /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
        /// indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
        /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
        /// as <code>Count</code>.</p>
        pub fn scanned_count(mut self, input: i32) -> Self {
            self.scanned_count = Some(input);
            self
        }
        /// <p>The number of items evaluated, before any <code>QueryFilter</code> is applied. A high
        /// <code>ScannedCount</code> value with few, or no, <code>Count</code> results
        /// indicates an inefficient <code>Query</code> operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count">Count and
        /// ScannedCount</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>If you did not use a filter in the request, then <code>ScannedCount</code> is the same
        /// as <code>Count</code>.</p>
        pub fn set_scanned_count(mut self, input: std::option::Option<i32>) -> Self {
            self.scanned_count = input;
            self
        }
        /// Adds a key-value pair to `last_evaluated_key`.
        ///
        /// To override the contents of this collection use [`set_last_evaluated_key`](Self::set_last_evaluated_key).
        ///
        /// <p>The primary key of the item where the operation stopped, inclusive of the previous
        /// result set. Use this value to start a new operation, excluding this value in the new
        /// request.</p>
        /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
        /// processed and there is no more data to be retrieved.</p>
        /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
        /// is more data in the result set. The only way to know when you have reached the end of
        /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
        pub fn last_evaluated_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.last_evaluated_key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.last_evaluated_key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item where the operation stopped, inclusive of the previous
        /// result set. Use this value to start a new operation, excluding this value in the new
        /// request.</p>
        /// <p>If <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been
        /// processed and there is no more data to be retrieved.</p>
        /// <p>If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there
        /// is more data in the result set. The only way to know when you have reached the end of
        /// the result set is when <code>LastEvaluatedKey</code> is empty.</p>
        pub fn set_last_evaluated_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.last_evaluated_key = input;
            self
        }
        /// <p>The capacity units consumed by the <code>Query</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>Query</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryOutput`](crate::output::QueryOutput)
        pub fn build(self) -> crate::output::QueryOutput {
            crate::output::QueryOutput {
                items: self.items,
                count: self.count.unwrap_or_default(),
                scanned_count: self.scanned_count.unwrap_or_default(),
                last_evaluated_key: self.last_evaluated_key,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl QueryOutput {
    /// Creates a new builder-style object to manufacture [`QueryOutput`](crate::output::QueryOutput)
    pub fn builder() -> crate::output::query_output::Builder {
        crate::output::query_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>PutItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutItemOutput {
    /// <p>The attribute values as they appeared before the <code>PutItem</code> operation, but
    /// only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request.
    /// Each element consists of an attribute name and an attribute value.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>PutItem</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned
    /// if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table
    /// does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub item_collection_metrics: std::option::Option<crate::model::ItemCollectionMetrics>,
}
impl PutItemOutput {
    /// <p>The attribute values as they appeared before the <code>PutItem</code> operation, but
    /// only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request.
    /// Each element consists of an attribute name and an attribute value.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The capacity units consumed by the <code>PutItem</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned
    /// if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table
    /// does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub fn item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ItemCollectionMetrics> {
        self.item_collection_metrics.as_ref()
    }
}
impl std::fmt::Debug for PutItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutItemOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("item_collection_metrics", &self.item_collection_metrics);
        formatter.finish()
    }
}
/// See [`PutItemOutput`](crate::output::PutItemOutput)
pub mod put_item_output {
    /// A builder for [`PutItemOutput`](crate::output::PutItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
        pub(crate) item_collection_metrics:
            std::option::Option<crate::model::ItemCollectionMetrics>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attribute values as they appeared before the <code>PutItem</code> operation, but
        /// only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request.
        /// Each element consists of an attribute name and an attribute value.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attribute values as they appeared before the <code>PutItem</code> operation, but
        /// only if <code>ReturnValues</code> is specified as <code>ALL_OLD</code> in the request.
        /// Each element consists of an attribute name and an attribute value.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The capacity units consumed by the <code>PutItem</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>PutItem</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned
        /// if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table
        /// does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn item_collection_metrics(
            mut self,
            input: crate::model::ItemCollectionMetrics,
        ) -> Self {
            self.item_collection_metrics = Some(input);
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>PutItem</code> operation. <code>ItemCollectionMetrics</code> is only returned
        /// if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the table
        /// does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn set_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ItemCollectionMetrics>,
        ) -> Self {
            self.item_collection_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`PutItemOutput`](crate::output::PutItemOutput)
        pub fn build(self) -> crate::output::PutItemOutput {
            crate::output::PutItemOutput {
                attributes: self.attributes,
                consumed_capacity: self.consumed_capacity,
                item_collection_metrics: self.item_collection_metrics,
            }
        }
    }
}
impl PutItemOutput {
    /// Creates a new builder-style object to manufacture [`PutItemOutput`](crate::output::PutItemOutput)
    pub fn builder() -> crate::output::put_item_output::Builder {
        crate::output::put_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOfResourceOutput {
    /// <p>The tags currently associated with the Amazon DynamoDB resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If this value is returned, there are additional results to be displayed. To retrieve
    /// them, call ListTagsOfResource again, with NextToken set to this value.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsOfResourceOutput {
    /// <p>The tags currently associated with the Amazon DynamoDB resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If this value is returned, there are additional results to be displayed. To retrieve
    /// them, call ListTagsOfResource again, with NextToken set to this value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsOfResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOfResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsOfResourceOutput`](crate::output::ListTagsOfResourceOutput)
pub mod list_tags_of_resource_output {
    /// A builder for [`ListTagsOfResourceOutput`](crate::output::ListTagsOfResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags currently associated with the Amazon DynamoDB resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags currently associated with the Amazon DynamoDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If this value is returned, there are additional results to be displayed. To retrieve
        /// them, call ListTagsOfResource again, with NextToken set to this value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If this value is returned, there are additional results to be displayed. To retrieve
        /// them, call ListTagsOfResource again, with NextToken set to this value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOfResourceOutput`](crate::output::ListTagsOfResourceOutput)
        pub fn build(self) -> crate::output::ListTagsOfResourceOutput {
            crate::output::ListTagsOfResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsOfResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOfResourceOutput`](crate::output::ListTagsOfResourceOutput)
    pub fn builder() -> crate::output::list_tags_of_resource_output::Builder {
        crate::output::list_tags_of_resource_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>ListTables</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesOutput {
    /// <p>The names of the tables associated with the current account at the current endpoint.
    /// The maximum size of this array is 100.</p>
    /// <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this
    /// value as the <code>ExclusiveStartTableName</code> parameter in a subsequent
    /// <code>ListTables</code> request and obtain the next page of results.</p>
    pub table_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the last table in the current page of results. Use this value as the
    /// <code>ExclusiveStartTableName</code> in a new request to obtain the next page of
    /// results, until all the table names are returned.</p>
    /// <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response,
    /// this means that there are no more table names to be retrieved.</p>
    pub last_evaluated_table_name: std::option::Option<std::string::String>,
}
impl ListTablesOutput {
    /// <p>The names of the tables associated with the current account at the current endpoint.
    /// The maximum size of this array is 100.</p>
    /// <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this
    /// value as the <code>ExclusiveStartTableName</code> parameter in a subsequent
    /// <code>ListTables</code> request and obtain the next page of results.</p>
    pub fn table_names(&self) -> std::option::Option<&[std::string::String]> {
        self.table_names.as_deref()
    }
    /// <p>The name of the last table in the current page of results. Use this value as the
    /// <code>ExclusiveStartTableName</code> in a new request to obtain the next page of
    /// results, until all the table names are returned.</p>
    /// <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response,
    /// this means that there are no more table names to be retrieved.</p>
    pub fn last_evaluated_table_name(&self) -> std::option::Option<&str> {
        self.last_evaluated_table_name.as_deref()
    }
}
impl std::fmt::Debug for ListTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesOutput");
        formatter.field("table_names", &self.table_names);
        formatter.field("last_evaluated_table_name", &self.last_evaluated_table_name);
        formatter.finish()
    }
}
/// See [`ListTablesOutput`](crate::output::ListTablesOutput)
pub mod list_tables_output {
    /// A builder for [`ListTablesOutput`](crate::output::ListTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_evaluated_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `table_names`.
        ///
        /// To override the contents of this collection use [`set_table_names`](Self::set_table_names).
        ///
        /// <p>The names of the tables associated with the current account at the current endpoint.
        /// The maximum size of this array is 100.</p>
        /// <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this
        /// value as the <code>ExclusiveStartTableName</code> parameter in a subsequent
        /// <code>ListTables</code> request and obtain the next page of results.</p>
        pub fn table_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.table_names.unwrap_or_default();
            v.push(input.into());
            self.table_names = Some(v);
            self
        }
        /// <p>The names of the tables associated with the current account at the current endpoint.
        /// The maximum size of this array is 100.</p>
        /// <p>If <code>LastEvaluatedTableName</code> also appears in the output, you can use this
        /// value as the <code>ExclusiveStartTableName</code> parameter in a subsequent
        /// <code>ListTables</code> request and obtain the next page of results.</p>
        pub fn set_table_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.table_names = input;
            self
        }
        /// <p>The name of the last table in the current page of results. Use this value as the
        /// <code>ExclusiveStartTableName</code> in a new request to obtain the next page of
        /// results, until all the table names are returned.</p>
        /// <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response,
        /// this means that there are no more table names to be retrieved.</p>
        pub fn last_evaluated_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_evaluated_table_name = Some(input.into());
            self
        }
        /// <p>The name of the last table in the current page of results. Use this value as the
        /// <code>ExclusiveStartTableName</code> in a new request to obtain the next page of
        /// results, until all the table names are returned.</p>
        /// <p>If you do not receive a <code>LastEvaluatedTableName</code> value in the response,
        /// this means that there are no more table names to be retrieved.</p>
        pub fn set_last_evaluated_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_evaluated_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesOutput`](crate::output::ListTablesOutput)
        pub fn build(self) -> crate::output::ListTablesOutput {
            crate::output::ListTablesOutput {
                table_names: self.table_names,
                last_evaluated_table_name: self.last_evaluated_table_name,
            }
        }
    }
}
impl ListTablesOutput {
    /// Creates a new builder-style object to manufacture [`ListTablesOutput`](crate::output::ListTablesOutput)
    pub fn builder() -> crate::output::list_tables_output::Builder {
        crate::output::list_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGlobalTablesOutput {
    /// <p>List of global table names.</p>
    pub global_tables: std::option::Option<std::vec::Vec<crate::model::GlobalTable>>,
    /// <p>Last evaluated global table name.</p>
    pub last_evaluated_global_table_name: std::option::Option<std::string::String>,
}
impl ListGlobalTablesOutput {
    /// <p>List of global table names.</p>
    pub fn global_tables(&self) -> std::option::Option<&[crate::model::GlobalTable]> {
        self.global_tables.as_deref()
    }
    /// <p>Last evaluated global table name.</p>
    pub fn last_evaluated_global_table_name(&self) -> std::option::Option<&str> {
        self.last_evaluated_global_table_name.as_deref()
    }
}
impl std::fmt::Debug for ListGlobalTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGlobalTablesOutput");
        formatter.field("global_tables", &self.global_tables);
        formatter.field(
            "last_evaluated_global_table_name",
            &self.last_evaluated_global_table_name,
        );
        formatter.finish()
    }
}
/// See [`ListGlobalTablesOutput`](crate::output::ListGlobalTablesOutput)
pub mod list_global_tables_output {
    /// A builder for [`ListGlobalTablesOutput`](crate::output::ListGlobalTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_tables: std::option::Option<std::vec::Vec<crate::model::GlobalTable>>,
        pub(crate) last_evaluated_global_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `global_tables`.
        ///
        /// To override the contents of this collection use [`set_global_tables`](Self::set_global_tables).
        ///
        /// <p>List of global table names.</p>
        pub fn global_tables(mut self, input: impl Into<crate::model::GlobalTable>) -> Self {
            let mut v = self.global_tables.unwrap_or_default();
            v.push(input.into());
            self.global_tables = Some(v);
            self
        }
        /// <p>List of global table names.</p>
        pub fn set_global_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalTable>>,
        ) -> Self {
            self.global_tables = input;
            self
        }
        /// <p>Last evaluated global table name.</p>
        pub fn last_evaluated_global_table_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_evaluated_global_table_name = Some(input.into());
            self
        }
        /// <p>Last evaluated global table name.</p>
        pub fn set_last_evaluated_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_evaluated_global_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGlobalTablesOutput`](crate::output::ListGlobalTablesOutput)
        pub fn build(self) -> crate::output::ListGlobalTablesOutput {
            crate::output::ListGlobalTablesOutput {
                global_tables: self.global_tables,
                last_evaluated_global_table_name: self.last_evaluated_global_table_name,
            }
        }
    }
}
impl ListGlobalTablesOutput {
    /// Creates a new builder-style object to manufacture [`ListGlobalTablesOutput`](crate::output::ListGlobalTablesOutput)
    pub fn builder() -> crate::output::list_global_tables_output::Builder {
        crate::output::list_global_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExportsOutput {
    /// <p>A list of <code>ExportSummary</code> objects.</p>
    pub export_summaries: std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
    /// <p>If this value is returned, there are additional results to be displayed. To retrieve
    /// them, call <code>ListExports</code> again, with <code>NextToken</code> set to this
    /// value.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExportsOutput {
    /// <p>A list of <code>ExportSummary</code> objects.</p>
    pub fn export_summaries(&self) -> std::option::Option<&[crate::model::ExportSummary]> {
        self.export_summaries.as_deref()
    }
    /// <p>If this value is returned, there are additional results to be displayed. To retrieve
    /// them, call <code>ListExports</code> again, with <code>NextToken</code> set to this
    /// value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExportsOutput");
        formatter.field("export_summaries", &self.export_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExportsOutput`](crate::output::ListExportsOutput)
pub mod list_exports_output {
    /// A builder for [`ListExportsOutput`](crate::output::ListExportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_summaries:
            std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `export_summaries`.
        ///
        /// To override the contents of this collection use [`set_export_summaries`](Self::set_export_summaries).
        ///
        /// <p>A list of <code>ExportSummary</code> objects.</p>
        pub fn export_summaries(mut self, input: impl Into<crate::model::ExportSummary>) -> Self {
            let mut v = self.export_summaries.unwrap_or_default();
            v.push(input.into());
            self.export_summaries = Some(v);
            self
        }
        /// <p>A list of <code>ExportSummary</code> objects.</p>
        pub fn set_export_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
        ) -> Self {
            self.export_summaries = input;
            self
        }
        /// <p>If this value is returned, there are additional results to be displayed. To retrieve
        /// them, call <code>ListExports</code> again, with <code>NextToken</code> set to this
        /// value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If this value is returned, there are additional results to be displayed. To retrieve
        /// them, call <code>ListExports</code> again, with <code>NextToken</code> set to this
        /// value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExportsOutput`](crate::output::ListExportsOutput)
        pub fn build(self) -> crate::output::ListExportsOutput {
            crate::output::ListExportsOutput {
                export_summaries: self.export_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExportsOutput {
    /// Creates a new builder-style object to manufacture [`ListExportsOutput`](crate::output::ListExportsOutput)
    pub fn builder() -> crate::output::list_exports_output::Builder {
        crate::output::list_exports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContributorInsightsOutput {
    /// <p>A list of ContributorInsightsSummary.</p>
    pub contributor_insights_summaries:
        std::option::Option<std::vec::Vec<crate::model::ContributorInsightsSummary>>,
    /// <p>A token to go to the next page if there is one.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContributorInsightsOutput {
    /// <p>A list of ContributorInsightsSummary.</p>
    pub fn contributor_insights_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ContributorInsightsSummary]> {
        self.contributor_insights_summaries.as_deref()
    }
    /// <p>A token to go to the next page if there is one.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContributorInsightsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContributorInsightsOutput");
        formatter.field(
            "contributor_insights_summaries",
            &self.contributor_insights_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListContributorInsightsOutput`](crate::output::ListContributorInsightsOutput)
pub mod list_contributor_insights_output {
    /// A builder for [`ListContributorInsightsOutput`](crate::output::ListContributorInsightsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contributor_insights_summaries:
            std::option::Option<std::vec::Vec<crate::model::ContributorInsightsSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `contributor_insights_summaries`.
        ///
        /// To override the contents of this collection use [`set_contributor_insights_summaries`](Self::set_contributor_insights_summaries).
        ///
        /// <p>A list of ContributorInsightsSummary.</p>
        pub fn contributor_insights_summaries(
            mut self,
            input: impl Into<crate::model::ContributorInsightsSummary>,
        ) -> Self {
            let mut v = self.contributor_insights_summaries.unwrap_or_default();
            v.push(input.into());
            self.contributor_insights_summaries = Some(v);
            self
        }
        /// <p>A list of ContributorInsightsSummary.</p>
        pub fn set_contributor_insights_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContributorInsightsSummary>>,
        ) -> Self {
            self.contributor_insights_summaries = input;
            self
        }
        /// <p>A token to go to the next page if there is one.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to go to the next page if there is one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContributorInsightsOutput`](crate::output::ListContributorInsightsOutput)
        pub fn build(self) -> crate::output::ListContributorInsightsOutput {
            crate::output::ListContributorInsightsOutput {
                contributor_insights_summaries: self.contributor_insights_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListContributorInsightsOutput {
    /// Creates a new builder-style object to manufacture [`ListContributorInsightsOutput`](crate::output::ListContributorInsightsOutput)
    pub fn builder() -> crate::output::list_contributor_insights_output::Builder {
        crate::output::list_contributor_insights_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupsOutput {
    /// <p>List of <code>BackupSummary</code> objects.</p>
    pub backup_summaries: std::option::Option<std::vec::Vec<crate::model::BackupSummary>>,
    /// <p> The ARN of the backup last evaluated when the current page of results was returned,
    /// inclusive of the current page of results. This value may be specified as the
    /// <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in
    /// order to fetch the next page of results. </p>
    /// <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has
    /// been processed and there are no more results to be retrieved. </p>
    /// <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate
    /// that there is more data to be returned. All results are guaranteed to have been returned
    /// if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>
    pub last_evaluated_backup_arn: std::option::Option<std::string::String>,
}
impl ListBackupsOutput {
    /// <p>List of <code>BackupSummary</code> objects.</p>
    pub fn backup_summaries(&self) -> std::option::Option<&[crate::model::BackupSummary]> {
        self.backup_summaries.as_deref()
    }
    /// <p> The ARN of the backup last evaluated when the current page of results was returned,
    /// inclusive of the current page of results. This value may be specified as the
    /// <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in
    /// order to fetch the next page of results. </p>
    /// <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has
    /// been processed and there are no more results to be retrieved. </p>
    /// <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate
    /// that there is more data to be returned. All results are guaranteed to have been returned
    /// if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>
    pub fn last_evaluated_backup_arn(&self) -> std::option::Option<&str> {
        self.last_evaluated_backup_arn.as_deref()
    }
}
impl std::fmt::Debug for ListBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupsOutput");
        formatter.field("backup_summaries", &self.backup_summaries);
        formatter.field("last_evaluated_backup_arn", &self.last_evaluated_backup_arn);
        formatter.finish()
    }
}
/// See [`ListBackupsOutput`](crate::output::ListBackupsOutput)
pub mod list_backups_output {
    /// A builder for [`ListBackupsOutput`](crate::output::ListBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_summaries:
            std::option::Option<std::vec::Vec<crate::model::BackupSummary>>,
        pub(crate) last_evaluated_backup_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `backup_summaries`.
        ///
        /// To override the contents of this collection use [`set_backup_summaries`](Self::set_backup_summaries).
        ///
        /// <p>List of <code>BackupSummary</code> objects.</p>
        pub fn backup_summaries(mut self, input: impl Into<crate::model::BackupSummary>) -> Self {
            let mut v = self.backup_summaries.unwrap_or_default();
            v.push(input.into());
            self.backup_summaries = Some(v);
            self
        }
        /// <p>List of <code>BackupSummary</code> objects.</p>
        pub fn set_backup_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackupSummary>>,
        ) -> Self {
            self.backup_summaries = input;
            self
        }
        /// <p> The ARN of the backup last evaluated when the current page of results was returned,
        /// inclusive of the current page of results. This value may be specified as the
        /// <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in
        /// order to fetch the next page of results. </p>
        /// <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has
        /// been processed and there are no more results to be retrieved. </p>
        /// <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate
        /// that there is more data to be returned. All results are guaranteed to have been returned
        /// if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>
        pub fn last_evaluated_backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_evaluated_backup_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the backup last evaluated when the current page of results was returned,
        /// inclusive of the current page of results. This value may be specified as the
        /// <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in
        /// order to fetch the next page of results. </p>
        /// <p> If <code>LastEvaluatedBackupArn</code> is empty, then the last page of results has
        /// been processed and there are no more results to be retrieved. </p>
        /// <p> If <code>LastEvaluatedBackupArn</code> is not empty, this may or may not indicate
        /// that there is more data to be returned. All results are guaranteed to have been returned
        /// if and only if no value for <code>LastEvaluatedBackupArn</code> is returned. </p>
        pub fn set_last_evaluated_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_evaluated_backup_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupsOutput`](crate::output::ListBackupsOutput)
        pub fn build(self) -> crate::output::ListBackupsOutput {
            crate::output::ListBackupsOutput {
                backup_summaries: self.backup_summaries,
                last_evaluated_backup_arn: self.last_evaluated_backup_arn,
            }
        }
    }
}
impl ListBackupsOutput {
    /// Creates a new builder-style object to manufacture [`ListBackupsOutput`](crate::output::ListBackupsOutput)
    pub fn builder() -> crate::output::list_backups_output::Builder {
        crate::output::list_backups_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetItemOutput {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, as specified by
    /// <code>ProjectionExpression</code>.</p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>GetItem</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
}
impl GetItemOutput {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, as specified by
    /// <code>ProjectionExpression</code>.</p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
    /// <p>The capacity units consumed by the <code>GetItem</code> operation. The data returned
    /// includes the total provisioned throughput consumed, along with statistics for the table
    /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
    /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for GetItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetItemOutput");
        formatter.field("item", &self.item);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`GetItemOutput`](crate::output::GetItemOutput)
pub mod get_item_output {
    /// A builder for [`GetItemOutput`](crate::output::GetItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    }
    impl Builder {
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, as specified by
        /// <code>ProjectionExpression</code>.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item = Some(hash_map);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, as specified by
        /// <code>ProjectionExpression</code>.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// <p>The capacity units consumed by the <code>GetItem</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>GetItem</code> operation. The data returned
        /// includes the total provisioned throughput consumed, along with statistics for the table
        /// and any indexes involved in the operation. <code>ConsumedCapacity</code> is only
        /// returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`GetItemOutput`](crate::output::GetItemOutput)
        pub fn build(self) -> crate::output::GetItemOutput {
            crate::output::GetItemOutput {
                item: self.item,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl GetItemOutput {
    /// Creates a new builder-style object to manufacture [`GetItemOutput`](crate::output::GetItemOutput)
    pub fn builder() -> crate::output::get_item_output::Builder {
        crate::output::get_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTableToPointInTimeOutput {
    /// <p>Contains a description of the table export.</p>
    pub export_description: std::option::Option<crate::model::ExportDescription>,
}
impl ExportTableToPointInTimeOutput {
    /// <p>Contains a description of the table export.</p>
    pub fn export_description(&self) -> std::option::Option<&crate::model::ExportDescription> {
        self.export_description.as_ref()
    }
}
impl std::fmt::Debug for ExportTableToPointInTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTableToPointInTimeOutput");
        formatter.field("export_description", &self.export_description);
        formatter.finish()
    }
}
/// See [`ExportTableToPointInTimeOutput`](crate::output::ExportTableToPointInTimeOutput)
pub mod export_table_to_point_in_time_output {
    /// A builder for [`ExportTableToPointInTimeOutput`](crate::output::ExportTableToPointInTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_description: std::option::Option<crate::model::ExportDescription>,
    }
    impl Builder {
        /// <p>Contains a description of the table export.</p>
        pub fn export_description(mut self, input: crate::model::ExportDescription) -> Self {
            self.export_description = Some(input);
            self
        }
        /// <p>Contains a description of the table export.</p>
        pub fn set_export_description(
            mut self,
            input: std::option::Option<crate::model::ExportDescription>,
        ) -> Self {
            self.export_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTableToPointInTimeOutput`](crate::output::ExportTableToPointInTimeOutput)
        pub fn build(self) -> crate::output::ExportTableToPointInTimeOutput {
            crate::output::ExportTableToPointInTimeOutput {
                export_description: self.export_description,
            }
        }
    }
}
impl ExportTableToPointInTimeOutput {
    /// Creates a new builder-style object to manufacture [`ExportTableToPointInTimeOutput`](crate::output::ExportTableToPointInTimeOutput)
    pub fn builder() -> crate::output::export_table_to_point_in_time_output::Builder {
        crate::output::export_table_to_point_in_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteTransactionOutput {
    /// <p>The response to a PartiQL transaction.</p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
    /// <p>The capacity units consumed by the entire operation. The values of the list are
    /// ordered according to the ordering of the statements.</p>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
}
impl ExecuteTransactionOutput {
    /// <p>The response to a PartiQL transaction.</p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::ItemResponse]> {
        self.responses.as_deref()
    }
    /// <p>The capacity units consumed by the entire operation. The values of the list are
    /// ordered according to the ordering of the statements.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
}
impl std::fmt::Debug for ExecuteTransactionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteTransactionOutput");
        formatter.field("responses", &self.responses);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`ExecuteTransactionOutput`](crate::output::ExecuteTransactionOutput)
pub mod execute_transaction_output {
    /// A builder for [`ExecuteTransactionOutput`](crate::output::ExecuteTransactionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) responses: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    }
    impl Builder {
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>The response to a PartiQL transaction.</p>
        pub fn responses(mut self, input: impl Into<crate::model::ItemResponse>) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>The response to a PartiQL transaction.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ItemResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>The capacity units consumed by the entire operation. The values of the list are
        /// ordered according to the ordering of the statements.</p>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>The capacity units consumed by the entire operation. The values of the list are
        /// ordered according to the ordering of the statements.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteTransactionOutput`](crate::output::ExecuteTransactionOutput)
        pub fn build(self) -> crate::output::ExecuteTransactionOutput {
            crate::output::ExecuteTransactionOutput {
                responses: self.responses,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl ExecuteTransactionOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteTransactionOutput`](crate::output::ExecuteTransactionOutput)
    pub fn builder() -> crate::output::execute_transaction_output::Builder {
        crate::output::execute_transaction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementOutput {
    /// <p>If a read operation was used, this property will contain the result of the read
    /// operation; a map of attribute names and their values. For the write operations this
    /// value will be empty.</p>
    pub items: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, crate::model::AttributeValue>>,
    >,
    /// <p>If the response of a read request exceeds the response payload limit DynamoDB will set
    /// this value in the response. If set, you can use that this value in the subsequent
    /// request to get the remaining results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The capacity units consumed by an operation. The data returned includes the total
    /// provisioned throughput consumed, along with statistics for the table and any indexes
    /// involved in the operation. <code>ConsumedCapacity</code> is only returned if the request
    /// asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
}
impl ExecuteStatementOutput {
    /// <p>If a read operation was used, this property will contain the result of the read
    /// operation; a map of attribute names and their values. For the write operations this
    /// value will be empty.</p>
    pub fn items(
        &self,
    ) -> std::option::Option<
        &[std::collections::HashMap<std::string::String, crate::model::AttributeValue>],
    > {
        self.items.as_deref()
    }
    /// <p>If the response of a read request exceeds the response payload limit DynamoDB will set
    /// this value in the response. If set, you can use that this value in the subsequent
    /// request to get the remaining results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The capacity units consumed by an operation. The data returned includes the total
    /// provisioned throughput consumed, along with statistics for the table and any indexes
    /// involved in the operation. <code>ConsumedCapacity</code> is only returned if the request
    /// asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for ExecuteStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
pub mod execute_statement_output {
    /// A builder for [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>If a read operation was used, this property will contain the result of the read
        /// operation; a map of attribute names and their values. For the write operations this
        /// value will be empty.</p>
        pub fn items(
            mut self,
            input: impl Into<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>If a read operation was used, this property will contain the result of the read
        /// operation; a map of attribute names and their values. For the write operations this
        /// value will be empty.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>If the response of a read request exceeds the response payload limit DynamoDB will set
        /// this value in the response. If set, you can use that this value in the subsequent
        /// request to get the remaining results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response of a read request exceeds the response payload limit DynamoDB will set
        /// this value in the response. If set, you can use that this value in the subsequent
        /// request to get the remaining results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The capacity units consumed by an operation. The data returned includes the total
        /// provisioned throughput consumed, along with statistics for the table and any indexes
        /// involved in the operation. <code>ConsumedCapacity</code> is only returned if the request
        /// asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by an operation. The data returned includes the total
        /// provisioned throughput consumed, along with statistics for the table and any indexes
        /// involved in the operation. <code>ConsumedCapacity</code> is only returned if the request
        /// asked for it. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Throughput</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
        pub fn build(self) -> crate::output::ExecuteStatementOutput {
            crate::output::ExecuteStatementOutput {
                items: self.items,
                next_token: self.next_token,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl ExecuteStatementOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
    pub fn builder() -> crate::output::execute_statement_output::Builder {
        crate::output::execute_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableKinesisStreamingDestinationOutput {
    /// <p>The name of the table being modified.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The ARN for the specific Kinesis data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the replication.</p>
    pub destination_status: std::option::Option<crate::model::DestinationStatus>,
}
impl EnableKinesisStreamingDestinationOutput {
    /// <p>The name of the table being modified.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The ARN for the specific Kinesis data stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The current status of the replication.</p>
    pub fn destination_status(&self) -> std::option::Option<&crate::model::DestinationStatus> {
        self.destination_status.as_ref()
    }
}
impl std::fmt::Debug for EnableKinesisStreamingDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableKinesisStreamingDestinationOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("destination_status", &self.destination_status);
        formatter.finish()
    }
}
/// See [`EnableKinesisStreamingDestinationOutput`](crate::output::EnableKinesisStreamingDestinationOutput)
pub mod enable_kinesis_streaming_destination_output {
    /// A builder for [`EnableKinesisStreamingDestinationOutput`](crate::output::EnableKinesisStreamingDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) destination_status: std::option::Option<crate::model::DestinationStatus>,
    }
    impl Builder {
        /// <p>The name of the table being modified.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table being modified.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The ARN for the specific Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the specific Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The current status of the replication.</p>
        pub fn destination_status(mut self, input: crate::model::DestinationStatus) -> Self {
            self.destination_status = Some(input);
            self
        }
        /// <p>The current status of the replication.</p>
        pub fn set_destination_status(
            mut self,
            input: std::option::Option<crate::model::DestinationStatus>,
        ) -> Self {
            self.destination_status = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableKinesisStreamingDestinationOutput`](crate::output::EnableKinesisStreamingDestinationOutput)
        pub fn build(self) -> crate::output::EnableKinesisStreamingDestinationOutput {
            crate::output::EnableKinesisStreamingDestinationOutput {
                table_name: self.table_name,
                stream_arn: self.stream_arn,
                destination_status: self.destination_status,
            }
        }
    }
}
impl EnableKinesisStreamingDestinationOutput {
    /// Creates a new builder-style object to manufacture [`EnableKinesisStreamingDestinationOutput`](crate::output::EnableKinesisStreamingDestinationOutput)
    pub fn builder() -> crate::output::enable_kinesis_streaming_destination_output::Builder {
        crate::output::enable_kinesis_streaming_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableKinesisStreamingDestinationOutput {
    /// <p>The name of the table being modified.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The ARN for the specific Kinesis data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the replication.</p>
    pub destination_status: std::option::Option<crate::model::DestinationStatus>,
}
impl DisableKinesisStreamingDestinationOutput {
    /// <p>The name of the table being modified.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The ARN for the specific Kinesis data stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The current status of the replication.</p>
    pub fn destination_status(&self) -> std::option::Option<&crate::model::DestinationStatus> {
        self.destination_status.as_ref()
    }
}
impl std::fmt::Debug for DisableKinesisStreamingDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableKinesisStreamingDestinationOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("destination_status", &self.destination_status);
        formatter.finish()
    }
}
/// See [`DisableKinesisStreamingDestinationOutput`](crate::output::DisableKinesisStreamingDestinationOutput)
pub mod disable_kinesis_streaming_destination_output {
    /// A builder for [`DisableKinesisStreamingDestinationOutput`](crate::output::DisableKinesisStreamingDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) destination_status: std::option::Option<crate::model::DestinationStatus>,
    }
    impl Builder {
        /// <p>The name of the table being modified.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table being modified.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The ARN for the specific Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the specific Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The current status of the replication.</p>
        pub fn destination_status(mut self, input: crate::model::DestinationStatus) -> Self {
            self.destination_status = Some(input);
            self
        }
        /// <p>The current status of the replication.</p>
        pub fn set_destination_status(
            mut self,
            input: std::option::Option<crate::model::DestinationStatus>,
        ) -> Self {
            self.destination_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableKinesisStreamingDestinationOutput`](crate::output::DisableKinesisStreamingDestinationOutput)
        pub fn build(self) -> crate::output::DisableKinesisStreamingDestinationOutput {
            crate::output::DisableKinesisStreamingDestinationOutput {
                table_name: self.table_name,
                stream_arn: self.stream_arn,
                destination_status: self.destination_status,
            }
        }
    }
}
impl DisableKinesisStreamingDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DisableKinesisStreamingDestinationOutput`](crate::output::DisableKinesisStreamingDestinationOutput)
    pub fn builder() -> crate::output::disable_kinesis_streaming_destination_output::Builder {
        crate::output::disable_kinesis_streaming_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTimeToLiveOutput {
    /// <p></p>
    pub time_to_live_description: std::option::Option<crate::model::TimeToLiveDescription>,
}
impl DescribeTimeToLiveOutput {
    /// <p></p>
    pub fn time_to_live_description(
        &self,
    ) -> std::option::Option<&crate::model::TimeToLiveDescription> {
        self.time_to_live_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeTimeToLiveOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTimeToLiveOutput");
        formatter.field("time_to_live_description", &self.time_to_live_description);
        formatter.finish()
    }
}
/// See [`DescribeTimeToLiveOutput`](crate::output::DescribeTimeToLiveOutput)
pub mod describe_time_to_live_output {
    /// A builder for [`DescribeTimeToLiveOutput`](crate::output::DescribeTimeToLiveOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live_description:
            std::option::Option<crate::model::TimeToLiveDescription>,
    }
    impl Builder {
        /// <p></p>
        pub fn time_to_live_description(
            mut self,
            input: crate::model::TimeToLiveDescription,
        ) -> Self {
            self.time_to_live_description = Some(input);
            self
        }
        /// <p></p>
        pub fn set_time_to_live_description(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveDescription>,
        ) -> Self {
            self.time_to_live_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTimeToLiveOutput`](crate::output::DescribeTimeToLiveOutput)
        pub fn build(self) -> crate::output::DescribeTimeToLiveOutput {
            crate::output::DescribeTimeToLiveOutput {
                time_to_live_description: self.time_to_live_description,
            }
        }
    }
}
impl DescribeTimeToLiveOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTimeToLiveOutput`](crate::output::DescribeTimeToLiveOutput)
    pub fn builder() -> crate::output::describe_time_to_live_output::Builder {
        crate::output::describe_time_to_live_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableReplicaAutoScalingOutput {
    /// <p>Represents the auto scaling properties of the table.</p>
    pub table_auto_scaling_description:
        std::option::Option<crate::model::TableAutoScalingDescription>,
}
impl DescribeTableReplicaAutoScalingOutput {
    /// <p>Represents the auto scaling properties of the table.</p>
    pub fn table_auto_scaling_description(
        &self,
    ) -> std::option::Option<&crate::model::TableAutoScalingDescription> {
        self.table_auto_scaling_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeTableReplicaAutoScalingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableReplicaAutoScalingOutput");
        formatter.field(
            "table_auto_scaling_description",
            &self.table_auto_scaling_description,
        );
        formatter.finish()
    }
}
/// See [`DescribeTableReplicaAutoScalingOutput`](crate::output::DescribeTableReplicaAutoScalingOutput)
pub mod describe_table_replica_auto_scaling_output {
    /// A builder for [`DescribeTableReplicaAutoScalingOutput`](crate::output::DescribeTableReplicaAutoScalingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_auto_scaling_description:
            std::option::Option<crate::model::TableAutoScalingDescription>,
    }
    impl Builder {
        /// <p>Represents the auto scaling properties of the table.</p>
        pub fn table_auto_scaling_description(
            mut self,
            input: crate::model::TableAutoScalingDescription,
        ) -> Self {
            self.table_auto_scaling_description = Some(input);
            self
        }
        /// <p>Represents the auto scaling properties of the table.</p>
        pub fn set_table_auto_scaling_description(
            mut self,
            input: std::option::Option<crate::model::TableAutoScalingDescription>,
        ) -> Self {
            self.table_auto_scaling_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableReplicaAutoScalingOutput`](crate::output::DescribeTableReplicaAutoScalingOutput)
        pub fn build(self) -> crate::output::DescribeTableReplicaAutoScalingOutput {
            crate::output::DescribeTableReplicaAutoScalingOutput {
                table_auto_scaling_description: self.table_auto_scaling_description,
            }
        }
    }
}
impl DescribeTableReplicaAutoScalingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTableReplicaAutoScalingOutput`](crate::output::DescribeTableReplicaAutoScalingOutput)
    pub fn builder() -> crate::output::describe_table_replica_auto_scaling_output::Builder {
        crate::output::describe_table_replica_auto_scaling_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableOutput {
    /// <p>The properties of the table.</p>
    pub table: std::option::Option<crate::model::TableDescription>,
}
impl DescribeTableOutput {
    /// <p>The properties of the table.</p>
    pub fn table(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table.as_ref()
    }
}
impl std::fmt::Debug for DescribeTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableOutput");
        formatter.field("table", &self.table);
        formatter.finish()
    }
}
/// See [`DescribeTableOutput`](crate::output::DescribeTableOutput)
pub mod describe_table_output {
    /// A builder for [`DescribeTableOutput`](crate::output::DescribeTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>The properties of the table.</p>
        pub fn table(mut self, input: crate::model::TableDescription) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>The properties of the table.</p>
        pub fn set_table(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableOutput`](crate::output::DescribeTableOutput)
        pub fn build(self) -> crate::output::DescribeTableOutput {
            crate::output::DescribeTableOutput { table: self.table }
        }
    }
}
impl DescribeTableOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTableOutput`](crate::output::DescribeTableOutput)
    pub fn builder() -> crate::output::describe_table_output::Builder {
        crate::output::describe_table_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeLimits</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLimitsOutput {
    /// <p>The maximum total read capacity units that your account allows you to provision across
    /// all of your tables in this Region.</p>
    pub account_max_read_capacity_units: std::option::Option<i64>,
    /// <p>The maximum total write capacity units that your account allows you to provision
    /// across all of your tables in this Region.</p>
    pub account_max_write_capacity_units: std::option::Option<i64>,
    /// <p>The maximum read capacity units that your account allows you to provision for a new
    /// table that you are creating in this Region, including the read capacity units
    /// provisioned for its global secondary indexes (GSIs).</p>
    pub table_max_read_capacity_units: std::option::Option<i64>,
    /// <p>The maximum write capacity units that your account allows you to provision for a new
    /// table that you are creating in this Region, including the write capacity units
    /// provisioned for its global secondary indexes (GSIs).</p>
    pub table_max_write_capacity_units: std::option::Option<i64>,
}
impl DescribeLimitsOutput {
    /// <p>The maximum total read capacity units that your account allows you to provision across
    /// all of your tables in this Region.</p>
    pub fn account_max_read_capacity_units(&self) -> std::option::Option<i64> {
        self.account_max_read_capacity_units
    }
    /// <p>The maximum total write capacity units that your account allows you to provision
    /// across all of your tables in this Region.</p>
    pub fn account_max_write_capacity_units(&self) -> std::option::Option<i64> {
        self.account_max_write_capacity_units
    }
    /// <p>The maximum read capacity units that your account allows you to provision for a new
    /// table that you are creating in this Region, including the read capacity units
    /// provisioned for its global secondary indexes (GSIs).</p>
    pub fn table_max_read_capacity_units(&self) -> std::option::Option<i64> {
        self.table_max_read_capacity_units
    }
    /// <p>The maximum write capacity units that your account allows you to provision for a new
    /// table that you are creating in this Region, including the write capacity units
    /// provisioned for its global secondary indexes (GSIs).</p>
    pub fn table_max_write_capacity_units(&self) -> std::option::Option<i64> {
        self.table_max_write_capacity_units
    }
}
impl std::fmt::Debug for DescribeLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLimitsOutput");
        formatter.field(
            "account_max_read_capacity_units",
            &self.account_max_read_capacity_units,
        );
        formatter.field(
            "account_max_write_capacity_units",
            &self.account_max_write_capacity_units,
        );
        formatter.field(
            "table_max_read_capacity_units",
            &self.table_max_read_capacity_units,
        );
        formatter.field(
            "table_max_write_capacity_units",
            &self.table_max_write_capacity_units,
        );
        formatter.finish()
    }
}
/// See [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
pub mod describe_limits_output {
    /// A builder for [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_max_read_capacity_units: std::option::Option<i64>,
        pub(crate) account_max_write_capacity_units: std::option::Option<i64>,
        pub(crate) table_max_read_capacity_units: std::option::Option<i64>,
        pub(crate) table_max_write_capacity_units: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The maximum total read capacity units that your account allows you to provision across
        /// all of your tables in this Region.</p>
        pub fn account_max_read_capacity_units(mut self, input: i64) -> Self {
            self.account_max_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum total read capacity units that your account allows you to provision across
        /// all of your tables in this Region.</p>
        pub fn set_account_max_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.account_max_read_capacity_units = input;
            self
        }
        /// <p>The maximum total write capacity units that your account allows you to provision
        /// across all of your tables in this Region.</p>
        pub fn account_max_write_capacity_units(mut self, input: i64) -> Self {
            self.account_max_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum total write capacity units that your account allows you to provision
        /// across all of your tables in this Region.</p>
        pub fn set_account_max_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.account_max_write_capacity_units = input;
            self
        }
        /// <p>The maximum read capacity units that your account allows you to provision for a new
        /// table that you are creating in this Region, including the read capacity units
        /// provisioned for its global secondary indexes (GSIs).</p>
        pub fn table_max_read_capacity_units(mut self, input: i64) -> Self {
            self.table_max_read_capacity_units = Some(input);
            self
        }
        /// <p>The maximum read capacity units that your account allows you to provision for a new
        /// table that you are creating in this Region, including the read capacity units
        /// provisioned for its global secondary indexes (GSIs).</p>
        pub fn set_table_max_read_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.table_max_read_capacity_units = input;
            self
        }
        /// <p>The maximum write capacity units that your account allows you to provision for a new
        /// table that you are creating in this Region, including the write capacity units
        /// provisioned for its global secondary indexes (GSIs).</p>
        pub fn table_max_write_capacity_units(mut self, input: i64) -> Self {
            self.table_max_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum write capacity units that your account allows you to provision for a new
        /// table that you are creating in this Region, including the write capacity units
        /// provisioned for its global secondary indexes (GSIs).</p>
        pub fn set_table_max_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.table_max_write_capacity_units = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
        pub fn build(self) -> crate::output::DescribeLimitsOutput {
            crate::output::DescribeLimitsOutput {
                account_max_read_capacity_units: self.account_max_read_capacity_units,
                account_max_write_capacity_units: self.account_max_write_capacity_units,
                table_max_read_capacity_units: self.table_max_read_capacity_units,
                table_max_write_capacity_units: self.table_max_write_capacity_units,
            }
        }
    }
}
impl DescribeLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLimitsOutput`](crate::output::DescribeLimitsOutput)
    pub fn builder() -> crate::output::describe_limits_output::Builder {
        crate::output::describe_limits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKinesisStreamingDestinationOutput {
    /// <p>The name of the table being described.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The list of replica structures for the table being described.</p>
    pub kinesis_data_stream_destinations:
        std::option::Option<std::vec::Vec<crate::model::KinesisDataStreamDestination>>,
}
impl DescribeKinesisStreamingDestinationOutput {
    /// <p>The name of the table being described.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The list of replica structures for the table being described.</p>
    pub fn kinesis_data_stream_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::KinesisDataStreamDestination]> {
        self.kinesis_data_stream_destinations.as_deref()
    }
}
impl std::fmt::Debug for DescribeKinesisStreamingDestinationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKinesisStreamingDestinationOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field(
            "kinesis_data_stream_destinations",
            &self.kinesis_data_stream_destinations,
        );
        formatter.finish()
    }
}
/// See [`DescribeKinesisStreamingDestinationOutput`](crate::output::DescribeKinesisStreamingDestinationOutput)
pub mod describe_kinesis_streaming_destination_output {
    /// A builder for [`DescribeKinesisStreamingDestinationOutput`](crate::output::DescribeKinesisStreamingDestinationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) kinesis_data_stream_destinations:
            std::option::Option<std::vec::Vec<crate::model::KinesisDataStreamDestination>>,
    }
    impl Builder {
        /// <p>The name of the table being described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table being described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `kinesis_data_stream_destinations`.
        ///
        /// To override the contents of this collection use [`set_kinesis_data_stream_destinations`](Self::set_kinesis_data_stream_destinations).
        ///
        /// <p>The list of replica structures for the table being described.</p>
        pub fn kinesis_data_stream_destinations(
            mut self,
            input: impl Into<crate::model::KinesisDataStreamDestination>,
        ) -> Self {
            let mut v = self.kinesis_data_stream_destinations.unwrap_or_default();
            v.push(input.into());
            self.kinesis_data_stream_destinations = Some(v);
            self
        }
        /// <p>The list of replica structures for the table being described.</p>
        pub fn set_kinesis_data_stream_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KinesisDataStreamDestination>>,
        ) -> Self {
            self.kinesis_data_stream_destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKinesisStreamingDestinationOutput`](crate::output::DescribeKinesisStreamingDestinationOutput)
        pub fn build(self) -> crate::output::DescribeKinesisStreamingDestinationOutput {
            crate::output::DescribeKinesisStreamingDestinationOutput {
                table_name: self.table_name,
                kinesis_data_stream_destinations: self.kinesis_data_stream_destinations,
            }
        }
    }
}
impl DescribeKinesisStreamingDestinationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeKinesisStreamingDestinationOutput`](crate::output::DescribeKinesisStreamingDestinationOutput)
    pub fn builder() -> crate::output::describe_kinesis_streaming_destination_output::Builder {
        crate::output::describe_kinesis_streaming_destination_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalTableSettingsOutput {
    /// <p>The name of the global table.</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>The Region-specific settings for the global table.</p>
    pub replica_settings:
        std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
}
impl DescribeGlobalTableSettingsOutput {
    /// <p>The name of the global table.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>The Region-specific settings for the global table.</p>
    pub fn replica_settings(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaSettingsDescription]> {
        self.replica_settings.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalTableSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalTableSettingsOutput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("replica_settings", &self.replica_settings);
        formatter.finish()
    }
}
/// See [`DescribeGlobalTableSettingsOutput`](crate::output::DescribeGlobalTableSettingsOutput)
pub mod describe_global_table_settings_output {
    /// A builder for [`DescribeGlobalTableSettingsOutput`](crate::output::DescribeGlobalTableSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) replica_settings:
            std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
    }
    impl Builder {
        /// <p>The name of the global table.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Appends an item to `replica_settings`.
        ///
        /// To override the contents of this collection use [`set_replica_settings`](Self::set_replica_settings).
        ///
        /// <p>The Region-specific settings for the global table.</p>
        pub fn replica_settings(
            mut self,
            input: impl Into<crate::model::ReplicaSettingsDescription>,
        ) -> Self {
            let mut v = self.replica_settings.unwrap_or_default();
            v.push(input.into());
            self.replica_settings = Some(v);
            self
        }
        /// <p>The Region-specific settings for the global table.</p>
        pub fn set_replica_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsDescription>>,
        ) -> Self {
            self.replica_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalTableSettingsOutput`](crate::output::DescribeGlobalTableSettingsOutput)
        pub fn build(self) -> crate::output::DescribeGlobalTableSettingsOutput {
            crate::output::DescribeGlobalTableSettingsOutput {
                global_table_name: self.global_table_name,
                replica_settings: self.replica_settings,
            }
        }
    }
}
impl DescribeGlobalTableSettingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableSettingsOutput`](crate::output::DescribeGlobalTableSettingsOutput)
    pub fn builder() -> crate::output::describe_global_table_settings_output::Builder {
        crate::output::describe_global_table_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub global_table_description: std::option::Option<crate::model::GlobalTableDescription>,
}
impl DescribeGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub fn global_table_description(
        &self,
    ) -> std::option::Option<&crate::model::GlobalTableDescription> {
        self.global_table_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeGlobalTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalTableOutput");
        formatter.field("global_table_description", &self.global_table_description);
        formatter.finish()
    }
}
/// See [`DescribeGlobalTableOutput`](crate::output::DescribeGlobalTableOutput)
pub mod describe_global_table_output {
    /// A builder for [`DescribeGlobalTableOutput`](crate::output::DescribeGlobalTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_description:
            std::option::Option<crate::model::GlobalTableDescription>,
    }
    impl Builder {
        /// <p>Contains the details of the global table.</p>
        pub fn global_table_description(
            mut self,
            input: crate::model::GlobalTableDescription,
        ) -> Self {
            self.global_table_description = Some(input);
            self
        }
        /// <p>Contains the details of the global table.</p>
        pub fn set_global_table_description(
            mut self,
            input: std::option::Option<crate::model::GlobalTableDescription>,
        ) -> Self {
            self.global_table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalTableOutput`](crate::output::DescribeGlobalTableOutput)
        pub fn build(self) -> crate::output::DescribeGlobalTableOutput {
            crate::output::DescribeGlobalTableOutput {
                global_table_description: self.global_table_description,
            }
        }
    }
}
impl DescribeGlobalTableOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableOutput`](crate::output::DescribeGlobalTableOutput)
    pub fn builder() -> crate::output::describe_global_table_output::Builder {
        crate::output::describe_global_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportOutput {
    /// <p>Represents the properties of the export.</p>
    pub export_description: std::option::Option<crate::model::ExportDescription>,
}
impl DescribeExportOutput {
    /// <p>Represents the properties of the export.</p>
    pub fn export_description(&self) -> std::option::Option<&crate::model::ExportDescription> {
        self.export_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportOutput");
        formatter.field("export_description", &self.export_description);
        formatter.finish()
    }
}
/// See [`DescribeExportOutput`](crate::output::DescribeExportOutput)
pub mod describe_export_output {
    /// A builder for [`DescribeExportOutput`](crate::output::DescribeExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_description: std::option::Option<crate::model::ExportDescription>,
    }
    impl Builder {
        /// <p>Represents the properties of the export.</p>
        pub fn export_description(mut self, input: crate::model::ExportDescription) -> Self {
            self.export_description = Some(input);
            self
        }
        /// <p>Represents the properties of the export.</p>
        pub fn set_export_description(
            mut self,
            input: std::option::Option<crate::model::ExportDescription>,
        ) -> Self {
            self.export_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportOutput`](crate::output::DescribeExportOutput)
        pub fn build(self) -> crate::output::DescribeExportOutput {
            crate::output::DescribeExportOutput {
                export_description: self.export_description,
            }
        }
    }
}
impl DescribeExportOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExportOutput`](crate::output::DescribeExportOutput)
    pub fn builder() -> crate::output::describe_export_output::Builder {
        crate::output::describe_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointsOutput {
    /// <p>List of endpoints.</p>
    pub endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
}
impl DescribeEndpointsOutput {
    /// <p>List of endpoints.</p>
    pub fn endpoints(&self) -> std::option::Option<&[crate::model::Endpoint]> {
        self.endpoints.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointsOutput");
        formatter.field("endpoints", &self.endpoints);
        formatter.finish()
    }
}
/// See [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
pub mod describe_endpoints_output {
    /// A builder for [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
    }
    impl Builder {
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>List of endpoints.</p>
        pub fn endpoints(mut self, input: impl Into<crate::model::Endpoint>) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input.into());
            self.endpoints = Some(v);
            self
        }
        /// <p>List of endpoints.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
        pub fn build(self) -> crate::output::DescribeEndpointsOutput {
            crate::output::DescribeEndpointsOutput {
                endpoints: self.endpoints,
            }
        }
    }
}
impl DescribeEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
    pub fn builder() -> crate::output::describe_endpoints_output::Builder {
        crate::output::describe_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContributorInsightsOutput {
    /// <p>The name of the table being described.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the global secondary index being described.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>List of names of the associated contributor insights rules.</p>
    pub contributor_insights_rule_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Current status of contributor insights.</p>
    pub contributor_insights_status: std::option::Option<crate::model::ContributorInsightsStatus>,
    /// <p>Timestamp of the last time the status was changed.</p>
    pub last_update_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns information about the last failure that was encountered.</p>
    /// <p>The most common exceptions for a FAILED status are:</p>
    /// <ul>
    /// <li>
    /// <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
    /// rule limit reached. Please disable Contributor Insights for other tables/indexes
    /// OR disable Contributor Insights rules before retrying.</p>
    /// </li>
    /// <li>
    /// <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be
    /// modified due to insufficient permissions.</p>
    /// </li>
    /// <li>
    /// <p>AccessDeniedException - Failed to create service-linked role for Contributor
    /// Insights due to insufficient permissions.</p>
    /// </li>
    /// <li>
    /// <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights
    /// rules. Please retry request.</p>
    /// </li>
    /// </ul>
    pub failure_exception: std::option::Option<crate::model::FailureException>,
}
impl DescribeContributorInsightsOutput {
    /// <p>The name of the table being described.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the global secondary index being described.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>List of names of the associated contributor insights rules.</p>
    pub fn contributor_insights_rule_list(&self) -> std::option::Option<&[std::string::String]> {
        self.contributor_insights_rule_list.as_deref()
    }
    /// <p>Current status of contributor insights.</p>
    pub fn contributor_insights_status(
        &self,
    ) -> std::option::Option<&crate::model::ContributorInsightsStatus> {
        self.contributor_insights_status.as_ref()
    }
    /// <p>Timestamp of the last time the status was changed.</p>
    pub fn last_update_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_date_time.as_ref()
    }
    /// <p>Returns information about the last failure that was encountered.</p>
    /// <p>The most common exceptions for a FAILED status are:</p>
    /// <ul>
    /// <li>
    /// <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
    /// rule limit reached. Please disable Contributor Insights for other tables/indexes
    /// OR disable Contributor Insights rules before retrying.</p>
    /// </li>
    /// <li>
    /// <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be
    /// modified due to insufficient permissions.</p>
    /// </li>
    /// <li>
    /// <p>AccessDeniedException - Failed to create service-linked role for Contributor
    /// Insights due to insufficient permissions.</p>
    /// </li>
    /// <li>
    /// <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights
    /// rules. Please retry request.</p>
    /// </li>
    /// </ul>
    pub fn failure_exception(&self) -> std::option::Option<&crate::model::FailureException> {
        self.failure_exception.as_ref()
    }
}
impl std::fmt::Debug for DescribeContributorInsightsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContributorInsightsOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "contributor_insights_rule_list",
            &self.contributor_insights_rule_list,
        );
        formatter.field(
            "contributor_insights_status",
            &self.contributor_insights_status,
        );
        formatter.field("last_update_date_time", &self.last_update_date_time);
        formatter.field("failure_exception", &self.failure_exception);
        formatter.finish()
    }
}
/// See [`DescribeContributorInsightsOutput`](crate::output::DescribeContributorInsightsOutput)
pub mod describe_contributor_insights_output {
    /// A builder for [`DescribeContributorInsightsOutput`](crate::output::DescribeContributorInsightsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) contributor_insights_rule_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) contributor_insights_status:
            std::option::Option<crate::model::ContributorInsightsStatus>,
        pub(crate) last_update_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_exception: std::option::Option<crate::model::FailureException>,
    }
    impl Builder {
        /// <p>The name of the table being described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table being described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the global secondary index being described.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index being described.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `contributor_insights_rule_list`.
        ///
        /// To override the contents of this collection use [`set_contributor_insights_rule_list`](Self::set_contributor_insights_rule_list).
        ///
        /// <p>List of names of the associated contributor insights rules.</p>
        pub fn contributor_insights_rule_list(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.contributor_insights_rule_list.unwrap_or_default();
            v.push(input.into());
            self.contributor_insights_rule_list = Some(v);
            self
        }
        /// <p>List of names of the associated contributor insights rules.</p>
        pub fn set_contributor_insights_rule_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.contributor_insights_rule_list = input;
            self
        }
        /// <p>Current status of contributor insights.</p>
        pub fn contributor_insights_status(
            mut self,
            input: crate::model::ContributorInsightsStatus,
        ) -> Self {
            self.contributor_insights_status = Some(input);
            self
        }
        /// <p>Current status of contributor insights.</p>
        pub fn set_contributor_insights_status(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsStatus>,
        ) -> Self {
            self.contributor_insights_status = input;
            self
        }
        /// <p>Timestamp of the last time the status was changed.</p>
        pub fn last_update_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_date_time = Some(input);
            self
        }
        /// <p>Timestamp of the last time the status was changed.</p>
        pub fn set_last_update_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_date_time = input;
            self
        }
        /// <p>Returns information about the last failure that was encountered.</p>
        /// <p>The most common exceptions for a FAILED status are:</p>
        /// <ul>
        /// <li>
        /// <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
        /// rule limit reached. Please disable Contributor Insights for other tables/indexes
        /// OR disable Contributor Insights rules before retrying.</p>
        /// </li>
        /// <li>
        /// <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be
        /// modified due to insufficient permissions.</p>
        /// </li>
        /// <li>
        /// <p>AccessDeniedException - Failed to create service-linked role for Contributor
        /// Insights due to insufficient permissions.</p>
        /// </li>
        /// <li>
        /// <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights
        /// rules. Please retry request.</p>
        /// </li>
        /// </ul>
        pub fn failure_exception(mut self, input: crate::model::FailureException) -> Self {
            self.failure_exception = Some(input);
            self
        }
        /// <p>Returns information about the last failure that was encountered.</p>
        /// <p>The most common exceptions for a FAILED status are:</p>
        /// <ul>
        /// <li>
        /// <p>LimitExceededException - Per-account Amazon CloudWatch Contributor Insights
        /// rule limit reached. Please disable Contributor Insights for other tables/indexes
        /// OR disable Contributor Insights rules before retrying.</p>
        /// </li>
        /// <li>
        /// <p>AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be
        /// modified due to insufficient permissions.</p>
        /// </li>
        /// <li>
        /// <p>AccessDeniedException - Failed to create service-linked role for Contributor
        /// Insights due to insufficient permissions.</p>
        /// </li>
        /// <li>
        /// <p>InternalServerError - Failed to create Amazon CloudWatch Contributor Insights
        /// rules. Please retry request.</p>
        /// </li>
        /// </ul>
        pub fn set_failure_exception(
            mut self,
            input: std::option::Option<crate::model::FailureException>,
        ) -> Self {
            self.failure_exception = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContributorInsightsOutput`](crate::output::DescribeContributorInsightsOutput)
        pub fn build(self) -> crate::output::DescribeContributorInsightsOutput {
            crate::output::DescribeContributorInsightsOutput {
                table_name: self.table_name,
                index_name: self.index_name,
                contributor_insights_rule_list: self.contributor_insights_rule_list,
                contributor_insights_status: self.contributor_insights_status,
                last_update_date_time: self.last_update_date_time,
                failure_exception: self.failure_exception,
            }
        }
    }
}
impl DescribeContributorInsightsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeContributorInsightsOutput`](crate::output::DescribeContributorInsightsOutput)
    pub fn builder() -> crate::output::describe_contributor_insights_output::Builder {
        crate::output::describe_contributor_insights_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContinuousBackupsOutput {
    /// <p>Represents the continuous backups and point in time recovery settings on the
    /// table.</p>
    pub continuous_backups_description:
        std::option::Option<crate::model::ContinuousBackupsDescription>,
}
impl DescribeContinuousBackupsOutput {
    /// <p>Represents the continuous backups and point in time recovery settings on the
    /// table.</p>
    pub fn continuous_backups_description(
        &self,
    ) -> std::option::Option<&crate::model::ContinuousBackupsDescription> {
        self.continuous_backups_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeContinuousBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContinuousBackupsOutput");
        formatter.field(
            "continuous_backups_description",
            &self.continuous_backups_description,
        );
        formatter.finish()
    }
}
/// See [`DescribeContinuousBackupsOutput`](crate::output::DescribeContinuousBackupsOutput)
pub mod describe_continuous_backups_output {
    /// A builder for [`DescribeContinuousBackupsOutput`](crate::output::DescribeContinuousBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continuous_backups_description:
            std::option::Option<crate::model::ContinuousBackupsDescription>,
    }
    impl Builder {
        /// <p>Represents the continuous backups and point in time recovery settings on the
        /// table.</p>
        pub fn continuous_backups_description(
            mut self,
            input: crate::model::ContinuousBackupsDescription,
        ) -> Self {
            self.continuous_backups_description = Some(input);
            self
        }
        /// <p>Represents the continuous backups and point in time recovery settings on the
        /// table.</p>
        pub fn set_continuous_backups_description(
            mut self,
            input: std::option::Option<crate::model::ContinuousBackupsDescription>,
        ) -> Self {
            self.continuous_backups_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContinuousBackupsOutput`](crate::output::DescribeContinuousBackupsOutput)
        pub fn build(self) -> crate::output::DescribeContinuousBackupsOutput {
            crate::output::DescribeContinuousBackupsOutput {
                continuous_backups_description: self.continuous_backups_description,
            }
        }
    }
}
impl DescribeContinuousBackupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeContinuousBackupsOutput`](crate::output::DescribeContinuousBackupsOutput)
    pub fn builder() -> crate::output::describe_continuous_backups_output::Builder {
        crate::output::describe_continuous_backups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupOutput {
    /// <p>Contains the description of the backup created for the table.</p>
    pub backup_description: std::option::Option<crate::model::BackupDescription>,
}
impl DescribeBackupOutput {
    /// <p>Contains the description of the backup created for the table.</p>
    pub fn backup_description(&self) -> std::option::Option<&crate::model::BackupDescription> {
        self.backup_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupOutput");
        formatter.field("backup_description", &self.backup_description);
        formatter.finish()
    }
}
/// See [`DescribeBackupOutput`](crate::output::DescribeBackupOutput)
pub mod describe_backup_output {
    /// A builder for [`DescribeBackupOutput`](crate::output::DescribeBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_description: std::option::Option<crate::model::BackupDescription>,
    }
    impl Builder {
        /// <p>Contains the description of the backup created for the table.</p>
        pub fn backup_description(mut self, input: crate::model::BackupDescription) -> Self {
            self.backup_description = Some(input);
            self
        }
        /// <p>Contains the description of the backup created for the table.</p>
        pub fn set_backup_description(
            mut self,
            input: std::option::Option<crate::model::BackupDescription>,
        ) -> Self {
            self.backup_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupOutput`](crate::output::DescribeBackupOutput)
        pub fn build(self) -> crate::output::DescribeBackupOutput {
            crate::output::DescribeBackupOutput {
                backup_description: self.backup_description,
            }
        }
    }
}
impl DescribeBackupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupOutput`](crate::output::DescribeBackupOutput)
    pub fn builder() -> crate::output::describe_backup_output::Builder {
        crate::output::describe_backup_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableOutput {
    /// <p>Represents the properties of a table.</p>
    pub table_description: std::option::Option<crate::model::TableDescription>,
}
impl DeleteTableOutput {
    /// <p>Represents the properties of a table.</p>
    pub fn table_description(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table_description.as_ref()
    }
}
impl std::fmt::Debug for DeleteTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableOutput");
        formatter.field("table_description", &self.table_description);
        formatter.finish()
    }
}
/// See [`DeleteTableOutput`](crate::output::DeleteTableOutput)
pub mod delete_table_output {
    /// A builder for [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_description: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>Represents the properties of a table.</p>
        pub fn table_description(mut self, input: crate::model::TableDescription) -> Self {
            self.table_description = Some(input);
            self
        }
        /// <p>Represents the properties of a table.</p>
        pub fn set_table_description(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTableOutput`](crate::output::DeleteTableOutput)
        pub fn build(self) -> crate::output::DeleteTableOutput {
            crate::output::DeleteTableOutput {
                table_description: self.table_description,
            }
        }
    }
}
impl DeleteTableOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    pub fn builder() -> crate::output::delete_table_output::Builder {
        crate::output::delete_table_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteItemOutput {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the item
    /// as it appeared before the <code>DeleteItem</code> operation. This map appears in the
    /// response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the
    /// request.</p>
    pub attributes: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>The capacity units consumed by the <code>DeleteItem</code> operation. The data
    /// returned includes the total provisioned throughput consumed, along with statistics for
    /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
    /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
    /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only
    /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
    /// table does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub item_collection_metrics: std::option::Option<crate::model::ItemCollectionMetrics>,
}
impl DeleteItemOutput {
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the item
    /// as it appeared before the <code>DeleteItem</code> operation. This map appears in the
    /// response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the
    /// request.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.attributes.as_ref()
    }
    /// <p>The capacity units consumed by the <code>DeleteItem</code> operation. The data
    /// returned includes the total provisioned throughput consumed, along with statistics for
    /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
    /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
    /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&crate::model::ConsumedCapacity> {
        self.consumed_capacity.as_ref()
    }
    /// <p>Information about item collections, if any, that were affected by the
    /// <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only
    /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
    /// table does not have any local secondary indexes, this information is not returned in the
    /// response.</p>
    /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
    /// gigabytes. This value is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on that table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub fn item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ItemCollectionMetrics> {
        self.item_collection_metrics.as_ref()
    }
}
impl std::fmt::Debug for DeleteItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteItemOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.field("item_collection_metrics", &self.item_collection_metrics);
        formatter.finish()
    }
}
/// See [`DeleteItemOutput`](crate::output::DeleteItemOutput)
pub mod delete_item_output {
    /// A builder for [`DeleteItemOutput`](crate::output::DeleteItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consumed_capacity: std::option::Option<crate::model::ConsumedCapacity>,
        pub(crate) item_collection_metrics:
            std::option::Option<crate::model::ItemCollectionMetrics>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the item
        /// as it appeared before the <code>DeleteItem</code> operation. This map appears in the
        /// response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the
        /// request.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the item
        /// as it appeared before the <code>DeleteItem</code> operation. This map appears in the
        /// response only if <code>ReturnValues</code> was specified as <code>ALL_OLD</code> in the
        /// request.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The capacity units consumed by the <code>DeleteItem</code> operation. The data
        /// returned includes the total provisioned throughput consumed, along with statistics for
        /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
        /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
        /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn consumed_capacity(mut self, input: crate::model::ConsumedCapacity) -> Self {
            self.consumed_capacity = Some(input);
            self
        }
        /// <p>The capacity units consumed by the <code>DeleteItem</code> operation. The data
        /// returned includes the total provisioned throughput consumed, along with statistics for
        /// the table and any indexes involved in the operation. <code>ConsumedCapacity</code> is
        /// only returned if the <code>ReturnConsumedCapacity</code> parameter was specified. For
        /// more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html">Provisioned Mode</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ConsumedCapacity>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only
        /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
        /// table does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn item_collection_metrics(
            mut self,
            input: crate::model::ItemCollectionMetrics,
        ) -> Self {
            self.item_collection_metrics = Some(input);
            self
        }
        /// <p>Information about item collections, if any, that were affected by the
        /// <code>DeleteItem</code> operation. <code>ItemCollectionMetrics</code> is only
        /// returned if the <code>ReturnItemCollectionMetrics</code> parameter was specified. If the
        /// table does not have any local secondary indexes, this information is not returned in the
        /// response.</p>
        /// <p>Each <code>ItemCollectionMetrics</code> element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size, in
        /// gigabytes. This value is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on that table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn set_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ItemCollectionMetrics>,
        ) -> Self {
            self.item_collection_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteItemOutput`](crate::output::DeleteItemOutput)
        pub fn build(self) -> crate::output::DeleteItemOutput {
            crate::output::DeleteItemOutput {
                attributes: self.attributes,
                consumed_capacity: self.consumed_capacity,
                item_collection_metrics: self.item_collection_metrics,
            }
        }
    }
}
impl DeleteItemOutput {
    /// Creates a new builder-style object to manufacture [`DeleteItemOutput`](crate::output::DeleteItemOutput)
    pub fn builder() -> crate::output::delete_item_output::Builder {
        crate::output::delete_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupOutput {
    /// <p>Contains the description of the backup created for the table.</p>
    pub backup_description: std::option::Option<crate::model::BackupDescription>,
}
impl DeleteBackupOutput {
    /// <p>Contains the description of the backup created for the table.</p>
    pub fn backup_description(&self) -> std::option::Option<&crate::model::BackupDescription> {
        self.backup_description.as_ref()
    }
}
impl std::fmt::Debug for DeleteBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupOutput");
        formatter.field("backup_description", &self.backup_description);
        formatter.finish()
    }
}
/// See [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
pub mod delete_backup_output {
    /// A builder for [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_description: std::option::Option<crate::model::BackupDescription>,
    }
    impl Builder {
        /// <p>Contains the description of the backup created for the table.</p>
        pub fn backup_description(mut self, input: crate::model::BackupDescription) -> Self {
            self.backup_description = Some(input);
            self
        }
        /// <p>Contains the description of the backup created for the table.</p>
        pub fn set_backup_description(
            mut self,
            input: std::option::Option<crate::model::BackupDescription>,
        ) -> Self {
            self.backup_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
        pub fn build(self) -> crate::output::DeleteBackupOutput {
            crate::output::DeleteBackupOutput {
                backup_description: self.backup_description,
            }
        }
    }
}
impl DeleteBackupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBackupOutput`](crate::output::DeleteBackupOutput)
    pub fn builder() -> crate::output::delete_backup_output::Builder {
        crate::output::delete_backup_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>CreateTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTableOutput {
    /// <p>Represents the properties of the table.</p>
    pub table_description: std::option::Option<crate::model::TableDescription>,
}
impl CreateTableOutput {
    /// <p>Represents the properties of the table.</p>
    pub fn table_description(&self) -> std::option::Option<&crate::model::TableDescription> {
        self.table_description.as_ref()
    }
}
impl std::fmt::Debug for CreateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTableOutput");
        formatter.field("table_description", &self.table_description);
        formatter.finish()
    }
}
/// See [`CreateTableOutput`](crate::output::CreateTableOutput)
pub mod create_table_output {
    /// A builder for [`CreateTableOutput`](crate::output::CreateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_description: std::option::Option<crate::model::TableDescription>,
    }
    impl Builder {
        /// <p>Represents the properties of the table.</p>
        pub fn table_description(mut self, input: crate::model::TableDescription) -> Self {
            self.table_description = Some(input);
            self
        }
        /// <p>Represents the properties of the table.</p>
        pub fn set_table_description(
            mut self,
            input: std::option::Option<crate::model::TableDescription>,
        ) -> Self {
            self.table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTableOutput`](crate::output::CreateTableOutput)
        pub fn build(self) -> crate::output::CreateTableOutput {
            crate::output::CreateTableOutput {
                table_description: self.table_description,
            }
        }
    }
}
impl CreateTableOutput {
    /// Creates a new builder-style object to manufacture [`CreateTableOutput`](crate::output::CreateTableOutput)
    pub fn builder() -> crate::output::create_table_output::Builder {
        crate::output::create_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub global_table_description: std::option::Option<crate::model::GlobalTableDescription>,
}
impl CreateGlobalTableOutput {
    /// <p>Contains the details of the global table.</p>
    pub fn global_table_description(
        &self,
    ) -> std::option::Option<&crate::model::GlobalTableDescription> {
        self.global_table_description.as_ref()
    }
}
impl std::fmt::Debug for CreateGlobalTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalTableOutput");
        formatter.field("global_table_description", &self.global_table_description);
        formatter.finish()
    }
}
/// See [`CreateGlobalTableOutput`](crate::output::CreateGlobalTableOutput)
pub mod create_global_table_output {
    /// A builder for [`CreateGlobalTableOutput`](crate::output::CreateGlobalTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_description:
            std::option::Option<crate::model::GlobalTableDescription>,
    }
    impl Builder {
        /// <p>Contains the details of the global table.</p>
        pub fn global_table_description(
            mut self,
            input: crate::model::GlobalTableDescription,
        ) -> Self {
            self.global_table_description = Some(input);
            self
        }
        /// <p>Contains the details of the global table.</p>
        pub fn set_global_table_description(
            mut self,
            input: std::option::Option<crate::model::GlobalTableDescription>,
        ) -> Self {
            self.global_table_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalTableOutput`](crate::output::CreateGlobalTableOutput)
        pub fn build(self) -> crate::output::CreateGlobalTableOutput {
            crate::output::CreateGlobalTableOutput {
                global_table_description: self.global_table_description,
            }
        }
    }
}
impl CreateGlobalTableOutput {
    /// Creates a new builder-style object to manufacture [`CreateGlobalTableOutput`](crate::output::CreateGlobalTableOutput)
    pub fn builder() -> crate::output::create_global_table_output::Builder {
        crate::output::create_global_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupOutput {
    /// <p>Contains the details of the backup created for the table.</p>
    pub backup_details: std::option::Option<crate::model::BackupDetails>,
}
impl CreateBackupOutput {
    /// <p>Contains the details of the backup created for the table.</p>
    pub fn backup_details(&self) -> std::option::Option<&crate::model::BackupDetails> {
        self.backup_details.as_ref()
    }
}
impl std::fmt::Debug for CreateBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupOutput");
        formatter.field("backup_details", &self.backup_details);
        formatter.finish()
    }
}
/// See [`CreateBackupOutput`](crate::output::CreateBackupOutput)
pub mod create_backup_output {
    /// A builder for [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_details: std::option::Option<crate::model::BackupDetails>,
    }
    impl Builder {
        /// <p>Contains the details of the backup created for the table.</p>
        pub fn backup_details(mut self, input: crate::model::BackupDetails) -> Self {
            self.backup_details = Some(input);
            self
        }
        /// <p>Contains the details of the backup created for the table.</p>
        pub fn set_backup_details(
            mut self,
            input: std::option::Option<crate::model::BackupDetails>,
        ) -> Self {
            self.backup_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupOutput`](crate::output::CreateBackupOutput)
        pub fn build(self) -> crate::output::CreateBackupOutput {
            crate::output::CreateBackupOutput {
                backup_details: self.backup_details,
            }
        }
    }
}
impl CreateBackupOutput {
    /// Creates a new builder-style object to manufacture [`CreateBackupOutput`](crate::output::CreateBackupOutput)
    pub fn builder() -> crate::output::create_backup_output::Builder {
        crate::output::create_backup_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchWriteItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteItemOutput {
    /// <p>A map of tables and requests against those tables that were not processed. The
    /// <code>UnprocessedItems</code> value is in the same form as
    /// <code>RequestItems</code>, so you can provide this value directly to a subsequent
    /// <code>BatchGetItem</code> operation. For more information, see
    /// <code>RequestItems</code> in the Request Parameters section.</p>
    /// <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table,
    /// a list of operations to perform (<code>DeleteRequest</code> or
    /// <code>PutRequest</code>).</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
    /// specified item. The item to be deleted is identified by a <code>Key</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Key</code> - A map of primary key attribute values that uniquely
    /// identify the item. Each entry in this map consists of an attribute name
    /// and an attribute value.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
    /// specified item. The item to be put is identified by an <code>Item</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Item</code> - A map of attributes and their values. Each entry in
    /// this map consists of an attribute name and an attribute value. Attribute
    /// values must not be null; string and binary type attributes must have
    /// lengths greater than zero; and set type attributes must not be empty.
    /// Requests that contain empty values will be rejected with a
    /// <code>ValidationException</code> exception.</p>
    /// <p>If you specify any attributes that are part of an index key, then the
    /// data types for those attributes must match those of the schema in the
    /// table's attribute definition.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If there are no unprocessed items remaining, the response contains an empty
    /// <code>UnprocessedItems</code> map.</p>
    pub unprocessed_items: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::WriteRequest>>,
    >,
    /// <p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each
    /// table, information about any item collections that were affected by individual
    /// <code>DeleteItem</code> or <code>PutItem</code> operations.</p>
    /// <p>Each entry consists of the following subelements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size,
    /// expressed in GB. This is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on the table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub item_collection_metrics: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ItemCollectionMetrics>,
        >,
    >,
    /// <p>The capacity units consumed by the entire <code>BatchWriteItem</code>
    /// operation.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TableName</code> - The table that consumed the provisioned
    /// throughput.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
    /// </li>
    /// </ul>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
}
impl BatchWriteItemOutput {
    /// <p>A map of tables and requests against those tables that were not processed. The
    /// <code>UnprocessedItems</code> value is in the same form as
    /// <code>RequestItems</code>, so you can provide this value directly to a subsequent
    /// <code>BatchGetItem</code> operation. For more information, see
    /// <code>RequestItems</code> in the Request Parameters section.</p>
    /// <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table,
    /// a list of operations to perform (<code>DeleteRequest</code> or
    /// <code>PutRequest</code>).</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
    /// specified item. The item to be deleted is identified by a <code>Key</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Key</code> - A map of primary key attribute values that uniquely
    /// identify the item. Each entry in this map consists of an attribute name
    /// and an attribute value.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
    /// specified item. The item to be put is identified by an <code>Item</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Item</code> - A map of attributes and their values. Each entry in
    /// this map consists of an attribute name and an attribute value. Attribute
    /// values must not be null; string and binary type attributes must have
    /// lengths greater than zero; and set type attributes must not be empty.
    /// Requests that contain empty values will be rejected with a
    /// <code>ValidationException</code> exception.</p>
    /// <p>If you specify any attributes that are part of an index key, then the
    /// data types for those attributes must match those of the schema in the
    /// table's attribute definition.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>If there are no unprocessed items remaining, the response contains an empty
    /// <code>UnprocessedItems</code> map.</p>
    pub fn unprocessed_items(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::WriteRequest>>,
    > {
        self.unprocessed_items.as_ref()
    }
    /// <p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each
    /// table, information about any item collections that were affected by individual
    /// <code>DeleteItem</code> or <code>PutItem</code> operations.</p>
    /// <p>Each entry consists of the following subelements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
    /// This is the same as the partition key value of the item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size,
    /// expressed in GB. This is a two-element array containing a lower bound and an
    /// upper bound for the estimate. The estimate includes the size of all the items in
    /// the table, plus the size of all attributes projected into all of the local
    /// secondary indexes on the table. Use this estimate to measure whether a local
    /// secondary index is approaching its size limit.</p>
    /// <p>The estimate is subject to change over time; therefore, do not rely on the
    /// precision or accuracy of the estimate.</p>
    /// </li>
    /// </ul>
    pub fn item_collection_metrics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<crate::model::ItemCollectionMetrics>,
        >,
    > {
        self.item_collection_metrics.as_ref()
    }
    /// <p>The capacity units consumed by the entire <code>BatchWriteItem</code>
    /// operation.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TableName</code> - The table that consumed the provisioned
    /// throughput.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
    /// </li>
    /// </ul>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
}
impl std::fmt::Debug for BatchWriteItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteItemOutput");
        formatter.field("unprocessed_items", &self.unprocessed_items);
        formatter.field("item_collection_metrics", &self.item_collection_metrics);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`BatchWriteItemOutput`](crate::output::BatchWriteItemOutput)
pub mod batch_write_item_output {
    /// A builder for [`BatchWriteItemOutput`](crate::output::BatchWriteItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unprocessed_items: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::WriteRequest>,
            >,
        >,
        pub(crate) item_collection_metrics: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ItemCollectionMetrics>,
            >,
        >,
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    }
    impl Builder {
        /// Adds a key-value pair to `unprocessed_items`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_items`](Self::set_unprocessed_items).
        ///
        /// <p>A map of tables and requests against those tables that were not processed. The
        /// <code>UnprocessedItems</code> value is in the same form as
        /// <code>RequestItems</code>, so you can provide this value directly to a subsequent
        /// <code>BatchGetItem</code> operation. For more information, see
        /// <code>RequestItems</code> in the Request Parameters section.</p>
        /// <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table,
        /// a list of operations to perform (<code>DeleteRequest</code> or
        /// <code>PutRequest</code>).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
        /// specified item. The item to be deleted is identified by a <code>Key</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely
        /// identify the item. Each entry in this map consists of an attribute name
        /// and an attribute value.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
        /// specified item. The item to be put is identified by an <code>Item</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values will be rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the
        /// data types for those attributes must match those of the schema in the
        /// table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>If there are no unprocessed items remaining, the response contains an empty
        /// <code>UnprocessedItems</code> map.</p>
        pub fn unprocessed_items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::WriteRequest>>,
        ) -> Self {
            let mut hash_map = self.unprocessed_items.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unprocessed_items = Some(hash_map);
            self
        }
        /// <p>A map of tables and requests against those tables that were not processed. The
        /// <code>UnprocessedItems</code> value is in the same form as
        /// <code>RequestItems</code>, so you can provide this value directly to a subsequent
        /// <code>BatchGetItem</code> operation. For more information, see
        /// <code>RequestItems</code> in the Request Parameters section.</p>
        /// <p>Each <code>UnprocessedItems</code> entry consists of a table name and, for that table,
        /// a list of operations to perform (<code>DeleteRequest</code> or
        /// <code>PutRequest</code>).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
        /// specified item. The item to be deleted is identified by a <code>Key</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely
        /// identify the item. Each entry in this map consists of an attribute name
        /// and an attribute value.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
        /// specified item. The item to be put is identified by an <code>Item</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values will be rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the
        /// data types for those attributes must match those of the schema in the
        /// table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>If there are no unprocessed items remaining, the response contains an empty
        /// <code>UnprocessedItems</code> map.</p>
        pub fn set_unprocessed_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::WriteRequest>,
                >,
            >,
        ) -> Self {
            self.unprocessed_items = input;
            self
        }
        /// Adds a key-value pair to `item_collection_metrics`.
        ///
        /// To override the contents of this collection use [`set_item_collection_metrics`](Self::set_item_collection_metrics).
        ///
        /// <p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each
        /// table, information about any item collections that were affected by individual
        /// <code>DeleteItem</code> or <code>PutItem</code> operations.</p>
        /// <p>Each entry consists of the following subelements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size,
        /// expressed in GB. This is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on the table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn item_collection_metrics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ItemCollectionMetrics>>,
        ) -> Self {
            let mut hash_map = self.item_collection_metrics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item_collection_metrics = Some(hash_map);
            self
        }
        /// <p>A list of tables that were processed by <code>BatchWriteItem</code> and, for each
        /// table, information about any item collections that were affected by individual
        /// <code>DeleteItem</code> or <code>PutItem</code> operations.</p>
        /// <p>Each entry consists of the following subelements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ItemCollectionKey</code> - The partition key value of the item collection.
        /// This is the same as the partition key value of the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SizeEstimateRangeGB</code> - An estimate of item collection size,
        /// expressed in GB. This is a two-element array containing a lower bound and an
        /// upper bound for the estimate. The estimate includes the size of all the items in
        /// the table, plus the size of all attributes projected into all of the local
        /// secondary indexes on the table. Use this estimate to measure whether a local
        /// secondary index is approaching its size limit.</p>
        /// <p>The estimate is subject to change over time; therefore, do not rely on the
        /// precision or accuracy of the estimate.</p>
        /// </li>
        /// </ul>
        pub fn set_item_collection_metrics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ItemCollectionMetrics>,
                >,
            >,
        ) -> Self {
            self.item_collection_metrics = input;
            self
        }
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>The capacity units consumed by the entire <code>BatchWriteItem</code>
        /// operation.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TableName</code> - The table that consumed the provisioned
        /// throughput.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
        /// </li>
        /// </ul>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>The capacity units consumed by the entire <code>BatchWriteItem</code>
        /// operation.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TableName</code> - The table that consumed the provisioned
        /// throughput.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
        /// </li>
        /// </ul>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteItemOutput`](crate::output::BatchWriteItemOutput)
        pub fn build(self) -> crate::output::BatchWriteItemOutput {
            crate::output::BatchWriteItemOutput {
                unprocessed_items: self.unprocessed_items,
                item_collection_metrics: self.item_collection_metrics,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl BatchWriteItemOutput {
    /// Creates a new builder-style object to manufacture [`BatchWriteItemOutput`](crate::output::BatchWriteItemOutput)
    pub fn builder() -> crate::output::batch_write_item_output::Builder {
        crate::output::batch_write_item_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>BatchGetItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetItemOutput {
    /// <p>A map of table name to a list of items. Each object in <code>Responses</code> consists
    /// of a table name, along with a map of attribute data consisting of the data type and
    /// attribute value.</p>
    pub responses: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
    >,
    /// <p>A map of tables and their respective keys that were not processed with the current
    /// response. The <code>UnprocessedKeys</code> value is in the same form as
    /// <code>RequestItems</code>, so the value can be provided directly to a subsequent
    /// <code>BatchGetItem</code> operation. For more information, see
    /// <code>RequestItems</code> in the Request Parameters section.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Keys</code> - An array of primary key attribute values that define
    /// specific items in the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProjectionExpression</code> - One or more attributes to be retrieved from
    /// the table or index. By default, all attributes are returned. If a requested
    /// attribute is not found, it does not appear in the result.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConsistentRead</code> - The consistency of a read operation. If set to
    /// <code>true</code>, then a strongly consistent read is used; otherwise, an
    /// eventually consistent read is used.</p>
    /// </li>
    /// </ul>
    /// <p>If there are no unprocessed keys remaining, the response contains an empty
    /// <code>UnprocessedKeys</code> map.</p>
    pub unprocessed_keys: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
    >,
    /// <p>The read capacity units consumed by the entire <code>BatchGetItem</code>
    /// operation.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TableName</code> - The table that consumed the provisioned
    /// throughput.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
    /// </li>
    /// </ul>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
}
impl BatchGetItemOutput {
    /// <p>A map of table name to a list of items. Each object in <code>Responses</code> consists
    /// of a table name, along with a map of attribute data consisting of the data type and
    /// attribute value.</p>
    pub fn responses(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::vec::Vec<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        >,
    > {
        self.responses.as_ref()
    }
    /// <p>A map of tables and their respective keys that were not processed with the current
    /// response. The <code>UnprocessedKeys</code> value is in the same form as
    /// <code>RequestItems</code>, so the value can be provided directly to a subsequent
    /// <code>BatchGetItem</code> operation. For more information, see
    /// <code>RequestItems</code> in the Request Parameters section.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Keys</code> - An array of primary key attribute values that define
    /// specific items in the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProjectionExpression</code> - One or more attributes to be retrieved from
    /// the table or index. By default, all attributes are returned. If a requested
    /// attribute is not found, it does not appear in the result.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConsistentRead</code> - The consistency of a read operation. If set to
    /// <code>true</code>, then a strongly consistent read is used; otherwise, an
    /// eventually consistent read is used.</p>
    /// </li>
    /// </ul>
    /// <p>If there are no unprocessed keys remaining, the response contains an empty
    /// <code>UnprocessedKeys</code> map.</p>
    pub fn unprocessed_keys(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
    > {
        self.unprocessed_keys.as_ref()
    }
    /// <p>The read capacity units consumed by the entire <code>BatchGetItem</code>
    /// operation.</p>
    /// <p>Each element consists of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TableName</code> - The table that consumed the provisioned
    /// throughput.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
    /// </li>
    /// </ul>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
}
impl std::fmt::Debug for BatchGetItemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetItemOutput");
        formatter.field("responses", &self.responses);
        formatter.field("unprocessed_keys", &self.unprocessed_keys);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`BatchGetItemOutput`](crate::output::BatchGetItemOutput)
pub mod batch_get_item_output {
    /// A builder for [`BatchGetItemOutput`](crate::output::BatchGetItemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) responses: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        >,
        pub(crate) unprocessed_keys: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
        >,
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    }
    impl Builder {
        /// Adds a key-value pair to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>A map of table name to a list of items. Each object in <code>Responses</code> consists
        /// of a table name, along with a map of attribute data consisting of the data type and
        /// attribute value.</p>
        pub fn responses(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<
                std::vec::Vec<
                    std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
                >,
            >,
        ) -> Self {
            let mut hash_map = self.responses.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.responses = Some(hash_map);
            self
        }
        /// <p>A map of table name to a list of items. Each object in <code>Responses</code> consists
        /// of a table name, along with a map of attribute data consisting of the data type and
        /// attribute value.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<
                        std::collections::HashMap<
                            std::string::String,
                            crate::model::AttributeValue,
                        >,
                    >,
                >,
            >,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Adds a key-value pair to `unprocessed_keys`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_keys`](Self::set_unprocessed_keys).
        ///
        /// <p>A map of tables and their respective keys that were not processed with the current
        /// response. The <code>UnprocessedKeys</code> value is in the same form as
        /// <code>RequestItems</code>, so the value can be provided directly to a subsequent
        /// <code>BatchGetItem</code> operation. For more information, see
        /// <code>RequestItems</code> in the Request Parameters section.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define
        /// specific items in the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - One or more attributes to be retrieved from
        /// the table or index. By default, all attributes are returned. If a requested
        /// attribute is not found, it does not appear in the result.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - The consistency of a read operation. If set to
        /// <code>true</code>, then a strongly consistent read is used; otherwise, an
        /// eventually consistent read is used.</p>
        /// </li>
        /// </ul>
        /// <p>If there are no unprocessed keys remaining, the response contains an empty
        /// <code>UnprocessedKeys</code> map.</p>
        pub fn unprocessed_keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::KeysAndAttributes>,
        ) -> Self {
            let mut hash_map = self.unprocessed_keys.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.unprocessed_keys = Some(hash_map);
            self
        }
        /// <p>A map of tables and their respective keys that were not processed with the current
        /// response. The <code>UnprocessedKeys</code> value is in the same form as
        /// <code>RequestItems</code>, so the value can be provided directly to a subsequent
        /// <code>BatchGetItem</code> operation. For more information, see
        /// <code>RequestItems</code> in the Request Parameters section.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define
        /// specific items in the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - One or more attributes to be retrieved from
        /// the table or index. By default, all attributes are returned. If a requested
        /// attribute is not found, it does not appear in the result.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - The consistency of a read operation. If set to
        /// <code>true</code>, then a strongly consistent read is used; otherwise, an
        /// eventually consistent read is used.</p>
        /// </li>
        /// </ul>
        /// <p>If there are no unprocessed keys remaining, the response contains an empty
        /// <code>UnprocessedKeys</code> map.</p>
        pub fn set_unprocessed_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
            >,
        ) -> Self {
            self.unprocessed_keys = input;
            self
        }
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>The read capacity units consumed by the entire <code>BatchGetItem</code>
        /// operation.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TableName</code> - The table that consumed the provisioned
        /// throughput.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
        /// </li>
        /// </ul>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>The read capacity units consumed by the entire <code>BatchGetItem</code>
        /// operation.</p>
        /// <p>Each element consists of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TableName</code> - The table that consumed the provisioned
        /// throughput.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CapacityUnits</code> - The total number of capacity units consumed.</p>
        /// </li>
        /// </ul>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetItemOutput`](crate::output::BatchGetItemOutput)
        pub fn build(self) -> crate::output::BatchGetItemOutput {
            crate::output::BatchGetItemOutput {
                responses: self.responses,
                unprocessed_keys: self.unprocessed_keys,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl BatchGetItemOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetItemOutput`](crate::output::BatchGetItemOutput)
    pub fn builder() -> crate::output::batch_get_item_output::Builder {
        crate::output::batch_get_item_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementOutput {
    /// <p>The response to each PartiQL statement in the batch.</p>
    pub responses: std::option::Option<std::vec::Vec<crate::model::BatchStatementResponse>>,
    /// <p>The capacity units consumed by the entire operation. The values of the list are
    /// ordered according to the ordering of the statements.</p>
    pub consumed_capacity: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
}
impl BatchExecuteStatementOutput {
    /// <p>The response to each PartiQL statement in the batch.</p>
    pub fn responses(&self) -> std::option::Option<&[crate::model::BatchStatementResponse]> {
        self.responses.as_deref()
    }
    /// <p>The capacity units consumed by the entire operation. The values of the list are
    /// ordered according to the ordering of the statements.</p>
    pub fn consumed_capacity(&self) -> std::option::Option<&[crate::model::ConsumedCapacity]> {
        self.consumed_capacity.as_deref()
    }
}
impl std::fmt::Debug for BatchExecuteStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementOutput");
        formatter.field("responses", &self.responses);
        formatter.field("consumed_capacity", &self.consumed_capacity);
        formatter.finish()
    }
}
/// See [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
pub mod batch_execute_statement_output {
    /// A builder for [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) responses:
            std::option::Option<std::vec::Vec<crate::model::BatchStatementResponse>>,
        pub(crate) consumed_capacity:
            std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
    }
    impl Builder {
        /// Appends an item to `responses`.
        ///
        /// To override the contents of this collection use [`set_responses`](Self::set_responses).
        ///
        /// <p>The response to each PartiQL statement in the batch.</p>
        pub fn responses(mut self, input: impl Into<crate::model::BatchStatementResponse>) -> Self {
            let mut v = self.responses.unwrap_or_default();
            v.push(input.into());
            self.responses = Some(v);
            self
        }
        /// <p>The response to each PartiQL statement in the batch.</p>
        pub fn set_responses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchStatementResponse>>,
        ) -> Self {
            self.responses = input;
            self
        }
        /// Appends an item to `consumed_capacity`.
        ///
        /// To override the contents of this collection use [`set_consumed_capacity`](Self::set_consumed_capacity).
        ///
        /// <p>The capacity units consumed by the entire operation. The values of the list are
        /// ordered according to the ordering of the statements.</p>
        pub fn consumed_capacity(
            mut self,
            input: impl Into<crate::model::ConsumedCapacity>,
        ) -> Self {
            let mut v = self.consumed_capacity.unwrap_or_default();
            v.push(input.into());
            self.consumed_capacity = Some(v);
            self
        }
        /// <p>The capacity units consumed by the entire operation. The values of the list are
        /// ordered according to the ordering of the statements.</p>
        pub fn set_consumed_capacity(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedCapacity>>,
        ) -> Self {
            self.consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
        pub fn build(self) -> crate::output::BatchExecuteStatementOutput {
            crate::output::BatchExecuteStatementOutput {
                responses: self.responses,
                consumed_capacity: self.consumed_capacity,
            }
        }
    }
}
impl BatchExecuteStatementOutput {
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
    pub fn builder() -> crate::output::batch_execute_statement_output::Builder {
        crate::output::batch_execute_statement_output::Builder::default()
    }
}
