// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
pub mod batch_execute_statement_input {
    /// A builder for [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statements:
            std::option::Option<std::vec::Vec<crate::model::BatchStatementRequest>>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>The list of PartiQL statements representing the batch to run.</p>
        pub fn statements(mut self, input: impl Into<crate::model::BatchStatementRequest>) -> Self {
            let mut v = self.statements.unwrap_or_default();
            v.push(input.into());
            self.statements = Some(v);
            self
        }
        /// <p>The list of PartiQL statements representing the batch to run.</p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchStatementRequest>>,
        ) -> Self {
            self.statements = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchExecuteStatementInput {
                statements: self.statements,
                return_consumed_capacity: self.return_consumed_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationOutputAlias = crate::operation::BatchExecuteStatement;
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`BatchExecuteStatement`](crate::operation::BatchExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchExecuteStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.BatchExecuteStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_execute_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchExecuteStatement",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    pub fn builder() -> crate::input::batch_execute_statement_input::Builder {
        crate::input::batch_execute_statement_input::Builder::default()
    }
}

/// See [`BatchGetItemInput`](crate::input::BatchGetItemInput)
pub mod batch_get_item_input {
    /// A builder for [`BatchGetItemInput`](crate::input::BatchGetItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_items: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
        >,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
    }
    impl Builder {
        /// Adds a key-value pair to `request_items`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a map that describes one or more
        /// items to retrieve from that table. Each table name can be used only once per
        /// <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read
        /// is used; if <code>false</code> (the default), an eventually consistent read is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for
        /// attribute names in the <code>ProjectionExpression</code> parameter. The
        /// following are some use cases for using
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name
        /// in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being
        /// misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to
        /// dereference an attribute name. For example, consider the following attribute
        /// name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be
        /// used directly in an expression. (For the complete list of reserved words, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
        /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>).
        /// To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this
        /// example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character
        /// are <i>expression attribute values</i>, which are placeholders
        /// for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define
        /// specific items in the table. For each primary key, you must provide
        /// <i>all</i> of the key attributes. For example, with a simple
        /// primary key, you only need to provide the partition key value. For a composite
        /// key, you must provide <i>both</i> the partition key value and the
        /// sort key value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - A string that identifies one or more
        /// attributes to retrieve from the table. These attributes can include scalars,
        /// sets, or elements of a JSON document. The attributes in the expression must be
        /// separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any
        /// of the requested attributes are not found, they do not appear in the
        /// result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AttributesToGet</code> - This is a legacy parameter. Use
        /// <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>. </p>
        ///
        /// </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::KeysAndAttributes>,
        ) -> Self {
            let mut hash_map = self.request_items.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_items = Some(hash_map);
            self
        }
        /// <p>A map of one or more table names and, for each table, a map that describes one or more
        /// items to retrieve from that table. Each table name can be used only once per
        /// <code>BatchGetItem</code> request.</p>
        /// <p>Each element in the map of items to retrieve consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read
        /// is used; if <code>false</code> (the default), an eventually consistent read is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for
        /// attribute names in the <code>ProjectionExpression</code> parameter. The
        /// following are some use cases for using
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name
        /// in an expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being
        /// misinterpreted in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to
        /// dereference an attribute name. For example, consider the following attribute
        /// name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be
        /// used directly in an expression. (For the complete list of reserved words, see
        /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
        /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>).
        /// To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this
        /// example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character
        /// are <i>expression attribute values</i>, which are placeholders
        /// for the actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Keys</code> - An array of primary key attribute values that define
        /// specific items in the table. For each primary key, you must provide
        /// <i>all</i> of the key attributes. For example, with a simple
        /// primary key, you only need to provide the partition key value. For a composite
        /// key, you must provide <i>both</i> the partition key value and the
        /// sort key value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProjectionExpression</code> - A string that identifies one or more
        /// attributes to retrieve from the table. These attributes can include scalars,
        /// sets, or elements of a JSON document. The attributes in the expression must be
        /// separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any
        /// of the requested attributes are not found, they do not appear in the
        /// result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AttributesToGet</code> - This is a legacy parameter. Use
        /// <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>. </p>
        ///
        /// </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
            >,
        ) -> Self {
            self.request_items = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetItemInput`](crate::input::BatchGetItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetItemInput {
                request_items: self.request_items,
                return_consumed_capacity: self.return_consumed_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetItemInputOperationOutputAlias = crate::operation::BatchGetItem;
#[doc(hidden)]
pub type BatchGetItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetItemInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetItem`](crate::operation::BatchGetItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.BatchGetItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_batch_get_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetItem",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetItemInput`](crate::input::BatchGetItemInput)
    pub fn builder() -> crate::input::batch_get_item_input::Builder {
        crate::input::batch_get_item_input::Builder::default()
    }
}

/// See [`BatchWriteItemInput`](crate::input::BatchWriteItemInput)
pub mod batch_write_item_input {
    /// A builder for [`BatchWriteItemInput`](crate::input::BatchWriteItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_items: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::WriteRequest>,
            >,
        >,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) return_item_collection_metrics:
            std::option::Option<crate::model::ReturnItemCollectionMetrics>,
    }
    impl Builder {
        /// Adds a key-value pair to `request_items`.
        ///
        /// To override the contents of this collection use [`set_request_items`](Self::set_request_items).
        ///
        /// <p>A map of one or more table names and, for each table, a list of operations to be
        /// performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the
        /// map consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
        /// specified item. The item to be deleted is identified by a <code>Key</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely
        /// identify the item. Each entry in this map consists of an attribute name
        /// and an attribute value. For each primary key, you must provide
        /// <i>all</i> of the key attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition
        /// key. For a composite primary key, you must provide values for
        /// <i>both</i> the partition key and the sort key.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
        /// specified item. The item to be put is identified by an <code>Item</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values are rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the
        /// data types for those attributes must match those of the schema in the
        /// table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn request_items(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::WriteRequest>>,
        ) -> Self {
            let mut hash_map = self.request_items.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_items = Some(hash_map);
            self
        }
        /// <p>A map of one or more table names and, for each table, a list of operations to be
        /// performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the
        /// map consists of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
        /// specified item. The item to be deleted is identified by a <code>Key</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Key</code> - A map of primary key attribute values that uniquely
        /// identify the item. Each entry in this map consists of an attribute name
        /// and an attribute value. For each primary key, you must provide
        /// <i>all</i> of the key attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition
        /// key. For a composite primary key, you must provide values for
        /// <i>both</i> the partition key and the sort key.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
        /// specified item. The item to be put is identified by an <code>Item</code>
        /// subelement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Item</code> - A map of attributes and their values. Each entry in
        /// this map consists of an attribute name and an attribute value. Attribute
        /// values must not be null; string and binary type attributes must have
        /// lengths greater than zero; and set type attributes must not be empty.
        /// Requests that contain empty values are rejected with a
        /// <code>ValidationException</code> exception.</p>
        /// <p>If you specify any attributes that are part of an index key, then the
        /// data types for those attributes must match those of the schema in the
        /// table's attribute definition.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_request_items(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::WriteRequest>,
                >,
            >,
        ) -> Self {
            self.request_items = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.return_item_collection_metrics = Some(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.return_item_collection_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchWriteItemInput`](crate::input::BatchWriteItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchWriteItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchWriteItemInput {
                request_items: self.request_items,
                return_consumed_capacity: self.return_consumed_capacity,
                return_item_collection_metrics: self.return_item_collection_metrics,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchWriteItemInputOperationOutputAlias = crate::operation::BatchWriteItem;
#[doc(hidden)]
pub type BatchWriteItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchWriteItemInput {
    /// Consumes the builder and constructs an Operation<[`BatchWriteItem`](crate::operation::BatchWriteItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchWriteItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchWriteItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchWriteItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchWriteItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.BatchWriteItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_write_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchWriteItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchWriteItem",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchWriteItemInput`](crate::input::BatchWriteItemInput)
    pub fn builder() -> crate::input::batch_write_item_input::Builder {
        crate::input::batch_write_item_input::Builder::default()
    }
}

/// See [`CreateBackupInput`](crate::input::CreateBackupInput)
pub mod create_backup_input {
    /// A builder for [`CreateBackupInput`](crate::input::CreateBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) backup_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn backup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_name = Some(input.into());
            self
        }
        /// <p>Specified name for the backup.</p>
        pub fn set_backup_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBackupInput`](crate::input::CreateBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBackupInput {
                table_name: self.table_name,
                backup_name: self.backup_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBackupInputOperationOutputAlias = crate::operation::CreateBackup;
#[doc(hidden)]
pub type CreateBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBackupInput {
    /// Consumes the builder and constructs an Operation<[`CreateBackup`](crate::operation::CreateBackup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.CreateBackup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBackup",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBackupInput`](crate::input::CreateBackupInput)
    pub fn builder() -> crate::input::create_backup_input::Builder {
        crate::input::create_backup_input::Builder::default()
    }
}

/// See [`CreateGlobalTableInput`](crate::input::CreateGlobalTableInput)
pub mod create_global_table_input {
    /// A builder for [`CreateGlobalTableInput`](crate::input::CreateGlobalTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) replication_group: std::option::Option<std::vec::Vec<crate::model::Replica>>,
    }
    impl Builder {
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Appends an item to `replication_group`.
        ///
        /// To override the contents of this collection use [`set_replication_group`](Self::set_replication_group).
        ///
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn replication_group(mut self, input: impl Into<crate::model::Replica>) -> Self {
            let mut v = self.replication_group.unwrap_or_default();
            v.push(input.into());
            self.replication_group = Some(v);
            self
        }
        /// <p>The Regions where the global table needs to be created.</p>
        pub fn set_replication_group(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Replica>>,
        ) -> Self {
            self.replication_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalTableInput`](crate::input::CreateGlobalTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGlobalTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGlobalTableInput {
                global_table_name: self.global_table_name,
                replication_group: self.replication_group,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGlobalTableInputOperationOutputAlias = crate::operation::CreateGlobalTable;
#[doc(hidden)]
pub type CreateGlobalTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGlobalTableInput {
    /// Consumes the builder and constructs an Operation<[`CreateGlobalTable`](crate::operation::CreateGlobalTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGlobalTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGlobalTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGlobalTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGlobalTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.CreateGlobalTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_global_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGlobalTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGlobalTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGlobalTableInput`](crate::input::CreateGlobalTableInput)
    pub fn builder() -> crate::input::create_global_table_input::Builder {
        crate::input::create_global_table_input::Builder::default()
    }
}

/// See [`CreateTableInput`](crate::input::CreateTableInput)
pub mod create_table_input {
    /// A builder for [`CreateTableInput`](crate::input::CreateTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_definitions:
            std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) local_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        pub(crate) global_secondary_indexes:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        pub(crate) billing_mode: std::option::Option<crate::model::BillingMode>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
        pub(crate) stream_specification: std::option::Option<crate::model::StreamSpecification>,
        pub(crate) sse_specification: std::option::Option<crate::model::SseSpecification>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) table_class: std::option::Option<crate::model::TableClass>,
    }
    impl Builder {
        /// Appends an item to `attribute_definitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn attribute_definitions(
            mut self,
            input: impl Into<crate::model::AttributeDefinition>,
        ) -> Self {
            let mut v = self.attribute_definitions.unwrap_or_default();
            v.push(input.into());
            self.attribute_definitions = Some(v);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.attribute_definitions = input;
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to create.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `key_schema`.
        ///
        /// To override the contents of this collection use [`set_key_schema`](Self::set_key_schema).
        ///
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The
        /// attributes in <code>KeySchema</code> must also be defined in the
        /// <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data
        /// Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AttributeName</code> - The name of this key attribute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HASH</code> - partition key</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RANGE</code> - sort key</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The partition key of an item is also known as its <i>hash
        /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage
        /// of an internal hash function to evenly distribute data items across partitions,
        /// based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>.
        /// The term "range attribute" derives from the way DynamoDB stores items with the same
        /// partition key physically close together, in sorted order by the sort key
        /// value.</p>
        /// </note>
        ///
        /// <p>For a simple primary key (partition key), you must provide exactly one element with a
        /// <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
        /// elements, in this order: The first element must have a <code>KeyType</code> of
        /// <code>HASH</code>, and the second element must have a <code>KeyType</code> of
        /// <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn key_schema(mut self, input: impl Into<crate::model::KeySchemaElement>) -> Self {
            let mut v = self.key_schema.unwrap_or_default();
            v.push(input.into());
            self.key_schema = Some(v);
            self
        }
        /// <p>Specifies the attributes that make up the primary key for a table or an index. The
        /// attributes in <code>KeySchema</code> must also be defined in the
        /// <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data
        /// Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AttributeName</code> - The name of this key attribute.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeyType</code> - The role that the key attribute will assume:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HASH</code> - partition key</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RANGE</code> - sort key</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The partition key of an item is also known as its <i>hash
        /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage
        /// of an internal hash function to evenly distribute data items across partitions,
        /// based on their partition key values.</p>
        /// <p>The sort key of an item is also known as its <i>range attribute</i>.
        /// The term "range attribute" derives from the way DynamoDB stores items with the same
        /// partition key physically close together, in sorted order by the sort key
        /// value.</p>
        /// </note>
        ///
        /// <p>For a simple primary key (partition key), you must provide exactly one element with a
        /// <code>KeyType</code> of <code>HASH</code>.</p>
        /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
        /// elements, in this order: The first element must have a <code>KeyType</code> of
        /// <code>HASH</code>, and the second element must have a <code>KeyType</code> of
        /// <code>RANGE</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_key_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.key_schema = input;
            self
        }
        /// Appends an item to `local_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_indexes`](Self::set_local_secondary_indexes).
        ///
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table.
        /// Each index is scoped to a given partition key value. There is a 10 GB size limit per
        /// partition key value; otherwise, the size of a local secondary index is
        /// unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the local secondary index. Must be unique
        /// only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the local secondary index.
        /// The key schema must begin with the same partition key as the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies attributes that are copied (projected) from
        /// the table into the index. These are in addition to the primary key attributes
        /// and index key attributes, which are automatically projected. Each attribute
        /// specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are
        /// projected into the index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected
        /// into the index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
        /// names that are projected into the secondary index. The total count of
        /// attributes provided in <code>NonKeyAttributes</code>, summed across all
        /// of the secondary indexes, must not exceed 100. If you project the same
        /// attribute into two different indexes, this counts as two distinct
        /// attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn local_secondary_indexes(
            mut self,
            input: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            let mut v = self.local_secondary_indexes.unwrap_or_default();
            v.push(input.into());
            self.local_secondary_indexes = Some(v);
            self
        }
        /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table.
        /// Each index is scoped to a given partition key value. There is a 10 GB size limit per
        /// partition key value; otherwise, the size of a local secondary index is
        /// unconstrained.</p>
        /// <p>Each local secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the local secondary index. Must be unique
        /// only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the local secondary index.
        /// The key schema must begin with the same partition key as the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies attributes that are copied (projected) from
        /// the table into the index. These are in addition to the primary key attributes
        /// and index key attributes, which are automatically projected. Each attribute
        /// specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are
        /// projected into the index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected
        /// into the index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
        /// names that are projected into the secondary index. The total count of
        /// attributes provided in <code>NonKeyAttributes</code>, summed across all
        /// of the secondary indexes, must not exceed 100. If you project the same
        /// attribute into two different indexes, this counts as two distinct
        /// attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_local_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.local_secondary_indexes = input;
            self
        }
        /// Appends an item to `global_secondary_indexes`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_indexes`](Self::set_global_secondary_indexes).
        ///
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table.
        /// Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the global secondary index. Must be unique
        /// only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the global secondary
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies attributes that are copied (projected) from
        /// the table into the index. These are in addition to the primary key attributes
        /// and index key attributes, which are automatically projected. Each attribute
        /// specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are
        /// projected into the index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected
        /// into the index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
        /// names that are projected into the secondary index. The total count of
        /// attributes provided in <code>NonKeyAttributes</code>, summed across all
        /// of the secondary indexes, must not exceed 100. If you project the same
        /// attribute into two different indexes, this counts as two distinct
        /// attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the
        /// global secondary index, consisting of read and write capacity units.</p>
        /// </li>
        /// </ul>
        pub fn global_secondary_indexes(
            mut self,
            input: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            let mut v = self.global_secondary_indexes.unwrap_or_default();
            v.push(input.into());
            self.global_secondary_indexes = Some(v);
            self
        }
        /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table.
        /// Each global secondary index in the array includes the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IndexName</code> - The name of the global secondary index. Must be unique
        /// only for this table.</p>
        /// <p></p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KeySchema</code> - Specifies the key schema for the global secondary
        /// index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Projection</code> - Specifies attributes that are copied (projected) from
        /// the table into the index. These are in addition to the primary key attributes
        /// and index key attributes, which are automatically projected. Each attribute
        /// specification is composed of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProjectionType</code> - One of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the index and primary keys are
        /// projected into the index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INCLUDE</code> - Only the specified table attributes are
        /// projected into the index. The list of projected attributes is in
        /// <code>NonKeyAttributes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All of the table attributes are projected
        /// into the index.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
        /// names that are projected into the secondary index. The total count of
        /// attributes provided in <code>NonKeyAttributes</code>, summed across all
        /// of the secondary indexes, must not exceed 100. If you project the same
        /// attribute into two different indexes, this counts as two distinct
        /// attributes when determining the total.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the
        /// global secondary index, consisting of read and write capacity units.</p>
        /// </li>
        /// </ul>
        pub fn set_global_secondary_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.global_secondary_indexes = input;
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage
        /// capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode = Some(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage
        /// capacity. This setting can be changed later.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode = input;
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The
        /// settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property.
        /// If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
        /// property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
        /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>Represents the provisioned throughput settings for a specified table or index. The
        /// settings can be modified using the <code>UpdateTable</code> operation.</p>
        /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property.
        /// If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
        /// property.</p>
        /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
        /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
        /// (true) or disabled (false).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StreamViewType</code> - When an item in the table is modified,
        /// <code>StreamViewType</code> determines what information is written to the
        /// table's stream. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item
        /// are written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was
        /// modified, is written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was
        /// modified, is written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images
        /// of the item are written to the stream.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn stream_specification(mut self, input: crate::model::StreamSpecification) -> Self {
            self.stream_specification = Some(input);
            self
        }
        /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
        /// (true) or disabled (false).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StreamViewType</code> - When an item in the table is modified,
        /// <code>StreamViewType</code> determines what information is written to the
        /// table's stream. Valid values for <code>StreamViewType</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item
        /// are written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was
        /// modified, is written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was
        /// modified, is written to the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images
        /// of the item are written to the stream.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.stream_specification = input;
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.sse_specification = Some(input);
            self
        }
        /// <p>Represents the settings used to enable server-side encryption.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.sse_specification = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging
        /// for DynamoDB</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging
        /// for DynamoDB</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and
        /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn table_class(mut self, input: crate::model::TableClass) -> Self {
            self.table_class = Some(input);
            self
        }
        /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and
        /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn set_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.table_class = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTableInput`](crate::input::CreateTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTableInput {
                attribute_definitions: self.attribute_definitions,
                table_name: self.table_name,
                key_schema: self.key_schema,
                local_secondary_indexes: self.local_secondary_indexes,
                global_secondary_indexes: self.global_secondary_indexes,
                billing_mode: self.billing_mode,
                provisioned_throughput: self.provisioned_throughput,
                stream_specification: self.stream_specification,
                sse_specification: self.sse_specification,
                tags: self.tags,
                table_class: self.table_class,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTableInputOperationOutputAlias = crate::operation::CreateTable;
#[doc(hidden)]
pub type CreateTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTableInput {
    /// Consumes the builder and constructs an Operation<[`CreateTable`](crate::operation::CreateTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.CreateTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTableInput`](crate::input::CreateTableInput)
    pub fn builder() -> crate::input::create_table_input::Builder {
        crate::input::create_table_input::Builder::default()
    }
}

/// See [`DeleteBackupInput`](crate::input::DeleteBackupInput)
pub mod delete_backup_input {
    /// A builder for [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>The ARN associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBackupInput`](crate::input::DeleteBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBackupInput {
                backup_arn: self.backup_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBackupInputOperationOutputAlias = crate::operation::DeleteBackup;
#[doc(hidden)]
pub type DeleteBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBackupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBackup`](crate::operation::DeleteBackup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DeleteBackup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBackup",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBackupInput`](crate::input::DeleteBackupInput)
    pub fn builder() -> crate::input::delete_backup_input::Builder {
        crate::input::delete_backup_input::Builder::default()
    }
}

/// See [`DeleteItemInput`](crate::input::DeleteItemInput)
pub mod delete_item_input {
    /// A builder for [`DeleteItemInput`](crate::input::DeleteItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) expected: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
        >,
        pub(crate) conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
        pub(crate) return_values: std::option::Option<crate::model::ReturnValue>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) return_item_collection_metrics:
            std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// <p>The name of the table from which to delete the item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table from which to delete the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
        /// primary key of the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.key = Some(hash_map);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
        /// primary key of the item to delete.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            let mut hash_map = self.expected.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expected = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.expected = input;
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.conditional_operator = Some(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.conditional_operator = input;
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
        /// before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
        /// however, <code>DeleteItem</code> does not recognize any values other than
        /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.return_values = Some(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
        /// before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
        /// however, <code>DeleteItem</code> does not recognize any values other than
        /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.return_values = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.return_item_collection_metrics = Some(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.return_item_collection_metrics = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code>
        /// to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code>
        /// to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteItemInput`](crate::input::DeleteItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteItemInput {
                table_name: self.table_name,
                key: self.key,
                expected: self.expected,
                conditional_operator: self.conditional_operator,
                return_values: self.return_values,
                return_consumed_capacity: self.return_consumed_capacity,
                return_item_collection_metrics: self.return_item_collection_metrics,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteItemInputOperationOutputAlias = crate::operation::DeleteItem;
#[doc(hidden)]
pub type DeleteItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteItemInput {
    /// Consumes the builder and constructs an Operation<[`DeleteItem`](crate::operation::DeleteItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DeleteItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteItem",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteItemInput`](crate::input::DeleteItemInput)
    pub fn builder() -> crate::input::delete_item_input::Builder {
        crate::input::delete_item_input::Builder::default()
    }
}

/// See [`DeleteTableInput`](crate::input::DeleteTableInput)
pub mod delete_table_input {
    /// A builder for [`DeleteTableInput`](crate::input::DeleteTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table to delete.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to delete.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTableInput`](crate::input::DeleteTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTableInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTableInputOperationOutputAlias = crate::operation::DeleteTable;
#[doc(hidden)]
pub type DeleteTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTableInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTable`](crate::operation::DeleteTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DeleteTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTableInput`](crate::input::DeleteTableInput)
    pub fn builder() -> crate::input::delete_table_input::Builder {
        crate::input::delete_table_input::Builder::default()
    }
}

/// See [`DescribeBackupInput`](crate::input::DescribeBackupInput)
pub mod describe_backup_input {
    /// A builder for [`DescribeBackupInput`](crate::input::DescribeBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupInput`](crate::input::DescribeBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBackupInput {
                backup_arn: self.backup_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBackupInputOperationOutputAlias = crate::operation::DescribeBackup;
#[doc(hidden)]
pub type DescribeBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBackupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBackup`](crate::operation::DescribeBackup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeBackup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_backup(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBackup",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBackupInput`](crate::input::DescribeBackupInput)
    pub fn builder() -> crate::input::describe_backup_input::Builder {
        crate::input::describe_backup_input::Builder::default()
    }
}

/// See [`DescribeContinuousBackupsInput`](crate::input::DescribeContinuousBackupsInput)
pub mod describe_continuous_backups_input {
    /// A builder for [`DescribeContinuousBackupsInput`](crate::input::DescribeContinuousBackupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the table for which the customer wants to check the continuous backups and
        /// point in time recovery settings.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>Name of the table for which the customer wants to check the continuous backups and
        /// point in time recovery settings.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContinuousBackupsInput`](crate::input::DescribeContinuousBackupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContinuousBackupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContinuousBackupsInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContinuousBackupsInputOperationOutputAlias =
    crate::operation::DescribeContinuousBackups;
#[doc(hidden)]
pub type DescribeContinuousBackupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeContinuousBackupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContinuousBackups`](crate::operation::DescribeContinuousBackups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContinuousBackups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContinuousBackupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContinuousBackupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContinuousBackupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeContinuousBackups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_continuous_backups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContinuousBackups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContinuousBackups",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContinuousBackupsInput`](crate::input::DescribeContinuousBackupsInput)
    pub fn builder() -> crate::input::describe_continuous_backups_input::Builder {
        crate::input::describe_continuous_backups_input::Builder::default()
    }
}

/// See [`DescribeContributorInsightsInput`](crate::input::DescribeContributorInsightsInput)
pub mod describe_contributor_insights_input {
    /// A builder for [`DescribeContributorInsightsInput`](crate::input::DescribeContributorInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the global secondary index to describe, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContributorInsightsInput`](crate::input::DescribeContributorInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContributorInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContributorInsightsInput {
                table_name: self.table_name,
                index_name: self.index_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContributorInsightsInputOperationOutputAlias =
    crate::operation::DescribeContributorInsights;
#[doc(hidden)]
pub type DescribeContributorInsightsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeContributorInsightsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContributorInsights`](crate::operation::DescribeContributorInsights)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContributorInsights,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContributorInsightsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContributorInsightsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContributorInsightsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeContributorInsights",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_contributor_insights(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContributorInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContributorInsights",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContributorInsightsInput`](crate::input::DescribeContributorInsightsInput)
    pub fn builder() -> crate::input::describe_contributor_insights_input::Builder {
        crate::input::describe_contributor_insights_input::Builder::default()
    }
}

/// See [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
pub mod describe_endpoints_input {
    /// A builder for [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointsInputOperationOutputAlias = crate::operation::DescribeEndpoints;
#[doc(hidden)]
pub type DescribeEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpoints`](crate::operation::DescribeEndpoints)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoints(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpoints",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    pub fn builder() -> crate::input::describe_endpoints_input::Builder {
        crate::input::describe_endpoints_input::Builder::default()
    }
}

/// See [`DescribeExportInput`](crate::input::DescribeExportInput)
pub mod describe_export_input {
    /// A builder for [`DescribeExportInput`](crate::input::DescribeExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn export_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
        pub fn set_export_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportInput`](crate::input::DescribeExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExportInput {
                export_arn: self.export_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExportInputOperationOutputAlias = crate::operation::DescribeExport;
#[doc(hidden)]
pub type DescribeExportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeExportInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExport`](crate::operation::DescribeExport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeExport",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_export(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExport",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExportInput`](crate::input::DescribeExportInput)
    pub fn builder() -> crate::input::describe_export_input::Builder {
        crate::input::describe_export_input::Builder::default()
    }
}

/// See [`DescribeGlobalTableInput`](crate::input::DescribeGlobalTableInput)
pub mod describe_global_table_input {
    /// A builder for [`DescribeGlobalTableInput`](crate::input::DescribeGlobalTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the global table.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalTableInput`](crate::input::DescribeGlobalTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalTableInput {
                global_table_name: self.global_table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalTableInputOperationOutputAlias = crate::operation::DescribeGlobalTable;
#[doc(hidden)]
pub type DescribeGlobalTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGlobalTableInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalTable`](crate::operation::DescribeGlobalTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeGlobalTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_global_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableInput`](crate::input::DescribeGlobalTableInput)
    pub fn builder() -> crate::input::describe_global_table_input::Builder {
        crate::input::describe_global_table_input::Builder::default()
    }
}

/// See [`DescribeGlobalTableSettingsInput`](crate::input::DescribeGlobalTableSettingsInput)
pub mod describe_global_table_settings_input {
    /// A builder for [`DescribeGlobalTableSettingsInput`](crate::input::DescribeGlobalTableSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the global table to describe.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table to describe.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalTableSettingsInput`](crate::input::DescribeGlobalTableSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGlobalTableSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGlobalTableSettingsInput {
                global_table_name: self.global_table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGlobalTableSettingsInputOperationOutputAlias =
    crate::operation::DescribeGlobalTableSettings;
#[doc(hidden)]
pub type DescribeGlobalTableSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeGlobalTableSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGlobalTableSettings`](crate::operation::DescribeGlobalTableSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGlobalTableSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeGlobalTableSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeGlobalTableSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeGlobalTableSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeGlobalTableSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_global_table_settings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGlobalTableSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGlobalTableSettings",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeGlobalTableSettingsInput`](crate::input::DescribeGlobalTableSettingsInput)
    pub fn builder() -> crate::input::describe_global_table_settings_input::Builder {
        crate::input::describe_global_table_settings_input::Builder::default()
    }
}

/// See [`DescribeKinesisStreamingDestinationInput`](crate::input::DescribeKinesisStreamingDestinationInput)
pub mod describe_kinesis_streaming_destination_input {
    /// A builder for [`DescribeKinesisStreamingDestinationInput`](crate::input::DescribeKinesisStreamingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table being described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table being described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeKinesisStreamingDestinationInput`](crate::input::DescribeKinesisStreamingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeKinesisStreamingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeKinesisStreamingDestinationInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeKinesisStreamingDestinationInputOperationOutputAlias =
    crate::operation::DescribeKinesisStreamingDestination;
#[doc(hidden)]
pub type DescribeKinesisStreamingDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeKinesisStreamingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeKinesisStreamingDestination`](crate::operation::DescribeKinesisStreamingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeKinesisStreamingDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeKinesisStreamingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeKinesisStreamingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeKinesisStreamingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeKinesisStreamingDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_kinesis_streaming_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeKinesisStreamingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeKinesisStreamingDestination",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeKinesisStreamingDestinationInput`](crate::input::DescribeKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::describe_kinesis_streaming_destination_input::Builder {
        crate::input::describe_kinesis_streaming_destination_input::Builder::default()
    }
}

/// See [`DescribeLimitsInput`](crate::input::DescribeLimitsInput)
pub mod describe_limits_input {
    /// A builder for [`DescribeLimitsInput`](crate::input::DescribeLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeLimitsInput`](crate::input::DescribeLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLimitsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeLimitsInputOperationOutputAlias = crate::operation::DescribeLimits;
#[doc(hidden)]
pub type DescribeLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLimits`](crate::operation::DescribeLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeLimits",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_limits(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLimits",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLimitsInput`](crate::input::DescribeLimitsInput)
    pub fn builder() -> crate::input::describe_limits_input::Builder {
        crate::input::describe_limits_input::Builder::default()
    }
}

/// See [`DescribeTableInput`](crate::input::DescribeTableInput)
pub mod describe_table_input {
    /// A builder for [`DescribeTableInput`](crate::input::DescribeTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table to describe.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to describe.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableInput`](crate::input::DescribeTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableInputOperationOutputAlias = crate::operation::DescribeTable;
#[doc(hidden)]
pub type DescribeTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTableInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTable`](crate::operation::DescribeTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableInput`](crate::input::DescribeTableInput)
    pub fn builder() -> crate::input::describe_table_input::Builder {
        crate::input::describe_table_input::Builder::default()
    }
}

/// See [`DescribeTableReplicaAutoScalingInput`](crate::input::DescribeTableReplicaAutoScalingInput)
pub mod describe_table_replica_auto_scaling_input {
    /// A builder for [`DescribeTableReplicaAutoScalingInput`](crate::input::DescribeTableReplicaAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableReplicaAutoScalingInput`](crate::input::DescribeTableReplicaAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableReplicaAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableReplicaAutoScalingInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableReplicaAutoScalingInputOperationOutputAlias =
    crate::operation::DescribeTableReplicaAutoScaling;
#[doc(hidden)]
pub type DescribeTableReplicaAutoScalingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTableReplicaAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTableReplicaAutoScaling`](crate::operation::DescribeTableReplicaAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTableReplicaAutoScaling,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableReplicaAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableReplicaAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableReplicaAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeTableReplicaAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_table_replica_auto_scaling(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTableReplicaAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTableReplicaAutoScaling",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableReplicaAutoScalingInput`](crate::input::DescribeTableReplicaAutoScalingInput)
    pub fn builder() -> crate::input::describe_table_replica_auto_scaling_input::Builder {
        crate::input::describe_table_replica_auto_scaling_input::Builder::default()
    }
}

/// See [`DescribeTimeToLiveInput`](crate::input::DescribeTimeToLiveInput)
pub mod describe_time_to_live_input {
    /// A builder for [`DescribeTimeToLiveInput`](crate::input::DescribeTimeToLiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table to be described.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to be described.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTimeToLiveInput`](crate::input::DescribeTimeToLiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTimeToLiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTimeToLiveInput {
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTimeToLiveInputOperationOutputAlias = crate::operation::DescribeTimeToLive;
#[doc(hidden)]
pub type DescribeTimeToLiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTimeToLiveInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTimeToLive`](crate::operation::DescribeTimeToLive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTimeToLive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTimeToLiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTimeToLiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTimeToLiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DescribeTimeToLive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_time_to_live(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTimeToLive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTimeToLive",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTimeToLiveInput`](crate::input::DescribeTimeToLiveInput)
    pub fn builder() -> crate::input::describe_time_to_live_input::Builder {
        crate::input::describe_time_to_live_input::Builder::default()
    }
}

/// See [`DisableKinesisStreamingDestinationInput`](crate::input::DisableKinesisStreamingDestinationInput)
pub mod disable_kinesis_streaming_destination_input {
    /// A builder for [`DisableKinesisStreamingDestinationInput`](crate::input::DisableKinesisStreamingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableKinesisStreamingDestinationInput`](crate::input::DisableKinesisStreamingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableKinesisStreamingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableKinesisStreamingDestinationInput {
                table_name: self.table_name,
                stream_arn: self.stream_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableKinesisStreamingDestinationInputOperationOutputAlias =
    crate::operation::DisableKinesisStreamingDestination;
#[doc(hidden)]
pub type DisableKinesisStreamingDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableKinesisStreamingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DisableKinesisStreamingDestination`](crate::operation::DisableKinesisStreamingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableKinesisStreamingDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableKinesisStreamingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableKinesisStreamingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableKinesisStreamingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.DisableKinesisStreamingDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_kinesis_streaming_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableKinesisStreamingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableKinesisStreamingDestination",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableKinesisStreamingDestinationInput`](crate::input::DisableKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::disable_kinesis_streaming_destination_input::Builder {
        crate::input::disable_kinesis_streaming_destination_input::Builder::default()
    }
}

/// See [`EnableKinesisStreamingDestinationInput`](crate::input::EnableKinesisStreamingDestinationInput)
pub mod enable_kinesis_streaming_destination_input {
    /// A builder for [`EnableKinesisStreamingDestinationInput`](crate::input::EnableKinesisStreamingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) stream_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DynamoDB table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The ARN for a Kinesis data stream.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableKinesisStreamingDestinationInput`](crate::input::EnableKinesisStreamingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableKinesisStreamingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableKinesisStreamingDestinationInput {
                table_name: self.table_name,
                stream_arn: self.stream_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableKinesisStreamingDestinationInputOperationOutputAlias =
    crate::operation::EnableKinesisStreamingDestination;
#[doc(hidden)]
pub type EnableKinesisStreamingDestinationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableKinesisStreamingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`EnableKinesisStreamingDestination`](crate::operation::EnableKinesisStreamingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableKinesisStreamingDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableKinesisStreamingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableKinesisStreamingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableKinesisStreamingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.EnableKinesisStreamingDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_kinesis_streaming_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableKinesisStreamingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableKinesisStreamingDestination",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableKinesisStreamingDestinationInput`](crate::input::EnableKinesisStreamingDestinationInput)
    pub fn builder() -> crate::input::enable_kinesis_streaming_destination_input::Builder {
        crate::input::enable_kinesis_streaming_destination_input::Builder::default()
    }
}

/// See [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
pub mod execute_statement_input {
    /// A builder for [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        pub(crate) consistent_read: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
    }
    impl Builder {
        /// <p>The PartiQL statement representing the operation to run.</p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p>The PartiQL statement representing the operation to run.</p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the PartiQL statement, if any.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::AttributeValue>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>The parameters for the PartiQL statement, if any.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly
        /// consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly
        /// consistent read is used; otherwise, an eventually consistent read is used.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
        /// statement response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
        /// statement response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteStatementInput {
                statement: self.statement,
                parameters: self.parameters,
                consistent_read: self.consistent_read,
                next_token: self.next_token,
                return_consumed_capacity: self.return_consumed_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteStatementInputOperationOutputAlias = crate::operation::ExecuteStatement;
#[doc(hidden)]
pub type ExecuteStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteStatement`](crate::operation::ExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ExecuteStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_statement(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteStatement",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    pub fn builder() -> crate::input::execute_statement_input::Builder {
        crate::input::execute_statement_input::Builder::default()
    }
}

/// See [`ExecuteTransactionInput`](crate::input::ExecuteTransactionInput)
pub mod execute_transaction_input {
    /// A builder for [`ExecuteTransactionInput`](crate::input::ExecuteTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transact_statements:
            std::option::Option<std::vec::Vec<crate::model::ParameterizedStatement>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `transact_statements`.
        ///
        /// To override the contents of this collection use [`set_transact_statements`](Self::set_transact_statements).
        ///
        /// <p>The list of PartiQL statements representing the transaction to run.</p>
        pub fn transact_statements(
            mut self,
            input: impl Into<crate::model::ParameterizedStatement>,
        ) -> Self {
            let mut v = self.transact_statements.unwrap_or_default();
            v.push(input.into());
            self.transact_statements = Some(v);
            self
        }
        /// <p>The list of PartiQL statements representing the transaction to run.</p>
        pub fn set_transact_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterizedStatement>>,
        ) -> Self {
            self.transact_statements = input;
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
        /// statement response.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
        /// statement response.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is
        /// returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is
        /// returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteTransactionInput`](crate::input::ExecuteTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteTransactionInput {
                transact_statements: self.transact_statements,
                client_request_token: self.client_request_token,
                return_consumed_capacity: self.return_consumed_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteTransactionInputOperationOutputAlias = crate::operation::ExecuteTransaction;
#[doc(hidden)]
pub type ExecuteTransactionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteTransactionInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteTransaction`](crate::operation::ExecuteTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteTransaction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ExecuteTransaction",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteTransaction",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteTransactionInput`](crate::input::ExecuteTransactionInput)
    pub fn builder() -> crate::input::execute_transaction_input::Builder {
        crate::input::execute_transaction_input::Builder::default()
    }
}

/// See [`ExportTableToPointInTimeInput`](crate::input::ExportTableToPointInTimeInput)
pub mod export_table_to_point_in_time_input {
    /// A builder for [`ExportTableToPointInTimeInput`](crate::input::ExportTableToPointInTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) export_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
        pub(crate) s3_sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
        pub(crate) s3_sse_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) export_format: std::option::Option<crate::model::ExportFormat>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot
        /// of the table's state at this point in time.</p>
        pub fn export_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.export_time = Some(input);
            self
        }
        /// <p>Time in the past from which to export table data. The table export will be a snapshot
        /// of the table's state at this point in time.</p>
        pub fn set_export_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.export_time = input;
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to
        /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
        /// identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is completed.
        /// After 8 hours, any request with the same client token is treated as a new request. Do
        /// not resubmit the same request with the same client token for more than 8 hours, or the
        /// result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 8-hour idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Providing a <code>ClientToken</code> makes the call to
        /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
        /// identical calls have the same effect as one single call.</p>
        /// <p>A client token is valid for 8 hours after the first request that uses it is completed.
        /// After 8 hours, any request with the same client token is treated as a new request. Do
        /// not resubmit the same request with the same client token for more than 8 hours, or the
        /// result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 8-hour idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be
        /// stored in.</p>
        pub fn s3_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_owner = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be
        /// stored in.</p>
        pub fn set_s3_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_owner = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
        /// snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
        /// snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
        /// for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AES256</code> - server-side encryption with Amazon S3 managed
        /// keys</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code> - server-side encryption with KMS managed
        /// keys</p>
        /// </li>
        /// </ul>
        pub fn s3_sse_algorithm(mut self, input: crate::model::S3SseAlgorithm) -> Self {
            self.s3_sse_algorithm = Some(input);
            self
        }
        /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
        /// for <code>S3SseAlgorithm</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AES256</code> - server-side encryption with Amazon S3 managed
        /// keys</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KMS</code> - server-side encryption with KMS managed
        /// keys</p>
        /// </li>
        /// </ul>
        pub fn set_s3_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3SseAlgorithm>,
        ) -> Self {
            self.s3_sse_algorithm = input;
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where
        /// export data will be stored (if applicable).</p>
        pub fn s3_sse_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_sse_kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where
        /// export data will be stored (if applicable).</p>
        pub fn set_s3_sse_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_sse_kms_key_id = input;
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
        /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn export_format(mut self, input: crate::model::ExportFormat) -> Self {
            self.export_format = Some(input);
            self
        }
        /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
        /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
        pub fn set_export_format(
            mut self,
            input: std::option::Option<crate::model::ExportFormat>,
        ) -> Self {
            self.export_format = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTableToPointInTimeInput`](crate::input::ExportTableToPointInTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportTableToPointInTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportTableToPointInTimeInput {
                table_arn: self.table_arn,
                export_time: self.export_time,
                client_token: self.client_token,
                s3_bucket: self.s3_bucket,
                s3_bucket_owner: self.s3_bucket_owner,
                s3_prefix: self.s3_prefix,
                s3_sse_algorithm: self.s3_sse_algorithm,
                s3_sse_kms_key_id: self.s3_sse_kms_key_id,
                export_format: self.export_format,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportTableToPointInTimeInputOperationOutputAlias =
    crate::operation::ExportTableToPointInTime;
#[doc(hidden)]
pub type ExportTableToPointInTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExportTableToPointInTimeInput {
    /// Consumes the builder and constructs an Operation<[`ExportTableToPointInTime`](crate::operation::ExportTableToPointInTime)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportTableToPointInTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExportTableToPointInTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExportTableToPointInTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExportTableToPointInTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ExportTableToPointInTime",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_export_table_to_point_in_time(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportTableToPointInTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportTableToPointInTime",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExportTableToPointInTimeInput`](crate::input::ExportTableToPointInTimeInput)
    pub fn builder() -> crate::input::export_table_to_point_in_time_input::Builder {
        crate::input::export_table_to_point_in_time_input::Builder::default()
    }
}

/// See [`GetItemInput`](crate::input::GetItemInput)
pub mod get_item_input {
    /// A builder for [`GetItemInput`](crate::input::GetItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) consistent_read: std::option::Option<bool>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) projection_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the table containing the requested item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table containing the requested item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
        /// primary key of the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.key = Some(hash_map);
            self
        }
        /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
        /// primary key of the item to retrieve.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `attributes_to_get`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes_to_get.unwrap_or_default();
            v.push(input.into());
            self.attributes_to_get = Some(v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes_to_get = input;
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
        /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
        /// reads.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
        /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
        /// reads.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These
        /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
        /// the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the
        /// requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.projection_expression = Some(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These
        /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
        /// the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes are returned. If any of the
        /// requested attributes are not found, they do not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.projection_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetItemInput`](crate::input::GetItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetItemInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetItemInput {
                table_name: self.table_name,
                key: self.key,
                attributes_to_get: self.attributes_to_get,
                consistent_read: self.consistent_read,
                return_consumed_capacity: self.return_consumed_capacity,
                projection_expression: self.projection_expression,
                expression_attribute_names: self.expression_attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type GetItemInputOperationOutputAlias = crate::operation::GetItem;
#[doc(hidden)]
pub type GetItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetItemInput {
    /// Consumes the builder and constructs an Operation<[`GetItem`](crate::operation::GetItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.GetItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetItem::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetItem", "dynamodb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetItemInput`](crate::input::GetItemInput)
    pub fn builder() -> crate::input::get_item_input::Builder {
        crate::input::get_item_input::Builder::default()
    }
}

/// See [`ListBackupsInput`](crate::input::ListBackupsInput)
pub mod list_backups_input {
    /// A builder for [`ListBackupsInput`](crate::input::ListBackupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) time_range_lower_bound: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) time_range_upper_bound: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) exclusive_start_backup_arn: std::option::Option<std::string::String>,
        pub(crate) backup_type: std::option::Option<crate::model::BackupTypeFilter>,
    }
    impl Builder {
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>Maximum number of backups to return at once.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is
        /// inclusive.</p>
        pub fn time_range_lower_bound(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_range_lower_bound = Some(input);
            self
        }
        /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is
        /// inclusive.</p>
        pub fn set_time_range_lower_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_range_lower_bound = input;
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is
        /// exclusive. </p>
        pub fn time_range_upper_bound(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time_range_upper_bound = Some(input);
            self
        }
        /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is
        /// exclusive. </p>
        pub fn set_time_range_upper_bound(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.time_range_upper_bound = input;
            self
        }
        /// <p>
        /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
        /// evaluated when the current page of results was returned, inclusive of the current page
        /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
        /// new <code>ListBackups</code> operation in order to fetch the next page of results.
        /// </p>
        pub fn exclusive_start_backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.exclusive_start_backup_arn = Some(input.into());
            self
        }
        /// <p>
        /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
        /// evaluated when the current page of results was returned, inclusive of the current page
        /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
        /// new <code>ListBackups</code> operation in order to fetch the next page of results.
        /// </p>
        pub fn set_exclusive_start_backup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_backup_arn = input;
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>USER</code> - On-demand backup created by you.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
        /// </li>
        /// </ul>
        pub fn backup_type(mut self, input: crate::model::BackupTypeFilter) -> Self {
            self.backup_type = Some(input);
            self
        }
        /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
        /// <p>Where <code>BackupType</code> can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>USER</code> - On-demand backup created by you.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
        /// </li>
        /// </ul>
        pub fn set_backup_type(
            mut self,
            input: std::option::Option<crate::model::BackupTypeFilter>,
        ) -> Self {
            self.backup_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBackupsInput`](crate::input::ListBackupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBackupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBackupsInput {
                table_name: self.table_name,
                limit: self.limit,
                time_range_lower_bound: self.time_range_lower_bound,
                time_range_upper_bound: self.time_range_upper_bound,
                exclusive_start_backup_arn: self.exclusive_start_backup_arn,
                backup_type: self.backup_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBackupsInputOperationOutputAlias = crate::operation::ListBackups;
#[doc(hidden)]
pub type ListBackupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBackupsInput {
    /// Consumes the builder and constructs an Operation<[`ListBackups`](crate::operation::ListBackups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBackups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBackupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBackupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBackupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListBackups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_backups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBackups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBackups",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBackupsInput`](crate::input::ListBackupsInput)
    pub fn builder() -> crate::input::list_backups_input::Builder {
        crate::input::list_backups_input::Builder::default()
    }
}

/// See [`ListContributorInsightsInput`](crate::input::ListContributorInsightsInput)
pub mod list_contributor_insights_input {
    /// A builder for [`ListContributorInsightsInput`](crate::input::ListContributorInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to for the desired page, if there is one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContributorInsightsInput`](crate::input::ListContributorInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContributorInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContributorInsightsInput {
                table_name: self.table_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListContributorInsightsInputOperationOutputAlias =
    crate::operation::ListContributorInsights;
#[doc(hidden)]
pub type ListContributorInsightsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListContributorInsightsInput {
    /// Consumes the builder and constructs an Operation<[`ListContributorInsights`](crate::operation::ListContributorInsights)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContributorInsights,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContributorInsightsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContributorInsightsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContributorInsightsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListContributorInsights",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_contributor_insights(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContributorInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContributorInsights",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContributorInsightsInput`](crate::input::ListContributorInsightsInput)
    pub fn builder() -> crate::input::list_contributor_insights_input::Builder {
        crate::input::list_contributor_insights_input::Builder::default()
    }
}

/// See [`ListExportsInput`](crate::input::ListExportsInput)
pub mod list_exports_input {
    /// A builder for [`ListExportsInput`](crate::input::ListExportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
        pub fn set_table_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_arn = input;
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
        /// page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
        /// page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExportsInput`](crate::input::ListExportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExportsInput {
                table_arn: self.table_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExportsInputOperationOutputAlias = crate::operation::ListExports;
#[doc(hidden)]
pub type ListExportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListExportsInput {
    /// Consumes the builder and constructs an Operation<[`ListExports`](crate::operation::ListExports)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListExports",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_exports(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExports",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
}

/// See [`ListGlobalTablesInput`](crate::input::ListGlobalTablesInput)
pub mod list_global_tables_input {
    /// A builder for [`ListGlobalTablesInput`](crate::input::ListGlobalTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exclusive_start_global_table_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) region_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn exclusive_start_global_table_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.exclusive_start_global_table_name = Some(input.into());
            self
        }
        /// <p>The first global table name that this operation will evaluate.</p>
        pub fn set_exclusive_start_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_global_table_name = input;
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified
        /// DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the
        /// operation and returns the table names collected up to that point, with a table name in
        /// the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the
        /// <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of table names to return, if the parameter is not specified
        /// DynamoDB defaults to 100.</p>
        /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the
        /// operation and returns the table names collected up to that point, with a table name in
        /// the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the
        /// <code>ExclusiveStartGlobalTableName</code> parameter.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>Lists the global tables in a specific Region.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGlobalTablesInput`](crate::input::ListGlobalTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGlobalTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGlobalTablesInput {
                exclusive_start_global_table_name: self.exclusive_start_global_table_name,
                limit: self.limit,
                region_name: self.region_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGlobalTablesInputOperationOutputAlias = crate::operation::ListGlobalTables;
#[doc(hidden)]
pub type ListGlobalTablesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGlobalTablesInput {
    /// Consumes the builder and constructs an Operation<[`ListGlobalTables`](crate::operation::ListGlobalTables)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGlobalTables,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGlobalTablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGlobalTablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGlobalTablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListGlobalTables",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_global_tables(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGlobalTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGlobalTables",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGlobalTablesInput`](crate::input::ListGlobalTablesInput)
    pub fn builder() -> crate::input::list_global_tables_input::Builder {
        crate::input::list_global_tables_input::Builder::default()
    }
}

/// See [`ListTablesInput`](crate::input::ListTablesInput)
pub mod list_tables_input {
    /// A builder for [`ListTablesInput`](crate::input::ListTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exclusive_start_table_name: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The first table name that this operation will evaluate. Use the value that was
        /// returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you
        /// can obtain the next page of results.</p>
        pub fn exclusive_start_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.exclusive_start_table_name = Some(input.into());
            self
        }
        /// <p>The first table name that this operation will evaluate. Use the value that was
        /// returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you
        /// can obtain the next page of results.</p>
        pub fn set_exclusive_start_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exclusive_start_table_name = input;
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the
        /// limit is 100.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>A maximum number of table names to return. If this parameter is not specified, the
        /// limit is 100.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesInput`](crate::input::ListTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTablesInput {
                exclusive_start_table_name: self.exclusive_start_table_name,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTablesInputOperationOutputAlias = crate::operation::ListTables;
#[doc(hidden)]
pub type ListTablesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTablesInput {
    /// Consumes the builder and constructs an Operation<[`ListTables`](crate::operation::ListTables)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTables,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListTables",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tables(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTables",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTablesInput`](crate::input::ListTablesInput)
    pub fn builder() -> crate::input::list_tables_input::Builder {
        crate::input::list_tables_input::Builder::default()
    }
}

/// See [`ListTagsOfResourceInput`](crate::input::ListTagsOfResourceInput)
pub mod list_tags_of_resource_input {
    /// A builder for [`ListTagsOfResourceInput`](crate::input::ListTagsOfResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource
        /// Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to ListTagOfResource. When provided in this manner, this API fetches the next page
        /// of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An optional string that, if supplied, must be copied from the output of a previous
        /// call to ListTagOfResource. When provided in this manner, this API fetches the next page
        /// of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOfResourceInput`](crate::input::ListTagsOfResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsOfResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsOfResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsOfResourceInputOperationOutputAlias = crate::operation::ListTagsOfResource;
#[doc(hidden)]
pub type ListTagsOfResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsOfResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsOfResource`](crate::operation::ListTagsOfResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsOfResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsOfResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsOfResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsOfResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.ListTagsOfResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_of_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsOfResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsOfResource",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsOfResourceInput`](crate::input::ListTagsOfResourceInput)
    pub fn builder() -> crate::input::list_tags_of_resource_input::Builder {
        crate::input::list_tags_of_resource_input::Builder::default()
    }
}

/// See [`PutItemInput`](crate::input::PutItemInput)
pub mod put_item_input {
    /// A builder for [`PutItemInput`](crate::input::PutItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) item: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) expected: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
        >,
        pub(crate) return_values: std::option::Option<crate::model::ReturnValue>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) return_item_collection_metrics:
            std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        pub(crate) conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// <p>The name of the table to contain the item.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to contain the item.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `item`.
        ///
        /// To override the contents of this collection use [`set_item`](Self::set_item).
        ///
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key
        /// attributes are required; you can optionally provide other attribute name-value pairs for
        /// the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple
        /// primary key, you only need to provide a value for the partition key. For a composite
        /// primary key, you must provide both values for both the partition key and the sort
        /// key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for
        /// those attributes must match those of the schema in the table's attribute
        /// definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String
        /// and Binary must have a length greater than zero if the attribute is used as a key
        /// attribute for a table or index.</p>
        ///
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code>
        /// object.</p>
        pub fn item(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.item.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.item = Some(hash_map);
            self
        }
        /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key
        /// attributes are required; you can optionally provide other attribute name-value pairs for
        /// the item.</p>
        /// <p>You must provide all of the attributes for the primary key. For example, with a simple
        /// primary key, you only need to provide a value for the partition key. For a composite
        /// primary key, you must provide both values for both the partition key and the sort
        /// key.</p>
        /// <p>If you specify any attributes that are part of an index key, then the data types for
        /// those attributes must match those of the schema in the table's attribute
        /// definition.</p>
        /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String
        /// and Binary must have a length greater than zero if the attribute is used as a key
        /// attribute for a table or index.</p>
        ///
        /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code>
        /// object.</p>
        pub fn set_item(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.item = input;
            self
        }
        /// Adds a key-value pair to `expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            let mut hash_map = self.expected.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expected = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.expected = input;
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
        /// before they were updated with the <code>PutItem</code> request. For
        /// <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value
        /// pair, then the content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <p>The values returned are strongly consistent.</p>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
        /// however, <code>PutItem</code> does not recognize any values other than
        /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.return_values = Some(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
        /// before they were updated with the <code>PutItem</code> request. For
        /// <code>PutItem</code>, the valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value
        /// pair, then the content of the old item is returned.</p>
        /// </li>
        /// </ul>
        /// <p>The values returned are strongly consistent.</p>
        /// <note>
        /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
        /// however, <code>PutItem</code> does not recognize any values other than
        /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
        /// </note>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.return_values = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.return_item_collection_metrics = Some(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.return_item_collection_metrics = input;
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.conditional_operator = Some(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.conditional_operator = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code>
        /// operation to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code>
        /// operation to succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`PutItemInput`](crate::input::PutItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutItemInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutItemInput {
                table_name: self.table_name,
                item: self.item,
                expected: self.expected,
                return_values: self.return_values,
                return_consumed_capacity: self.return_consumed_capacity,
                return_item_collection_metrics: self.return_item_collection_metrics,
                conditional_operator: self.conditional_operator,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
            })
        }
    }
}
#[doc(hidden)]
pub type PutItemInputOperationOutputAlias = crate::operation::PutItem;
#[doc(hidden)]
pub type PutItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutItemInput {
    /// Consumes the builder and constructs an Operation<[`PutItem`](crate::operation::PutItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.PutItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutItem::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutItem", "dynamodb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutItemInput`](crate::input::PutItemInput)
    pub fn builder() -> crate::input::put_item_input::Builder {
        crate::input::put_item_input::Builder::default()
    }
}

/// See [`QueryInput`](crate::input::QueryInput)
pub mod query_input {
    /// A builder for [`QueryInput`](crate::input::QueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) select: std::option::Option<crate::model::Select>,
        pub(crate) attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) consistent_read: std::option::Option<bool>,
        pub(crate) key_conditions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Condition>,
        >,
        pub(crate) query_filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Condition>,
        >,
        pub(crate) conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
        pub(crate) scan_index_forward: std::option::Option<bool>,
        pub(crate) exclusive_start_key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) projection_expression: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) key_condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// <p>The name of the table containing the requested items.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table containing the requested items.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global
        /// secondary index on the table. Note that if you use the <code>IndexName</code> parameter,
        /// you must also provide <code>TableName.</code>
        /// </p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of an index to query. This index can be any local secondary index or global
        /// secondary index on the table. Note that if you use the <code>IndexName</code> parameter,
        /// you must also provide <code>TableName.</code>
        /// </p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
        /// specific item attributes, the count of matching items, or in the case of an index, some
        /// or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the index
        /// is configured to project all attributes, this return value is equivalent to
        /// specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to specifying
        /// <code>AttributesToGet</code> without specifying any value for
        /// <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation will read only the index and not
        /// the table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request attributes
        /// that are projected into the index. Global secondary index queries cannot fetch
        /// attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
        /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
        /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
        /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
        /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
        /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
        /// value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, input: crate::model::Select) -> Self {
            self.select = Some(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
        /// specific item attributes, the count of matching items, or in the case of an index, some
        /// or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the index
        /// is configured to project all attributes, this return value is equivalent to
        /// specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to specifying
        /// <code>AttributesToGet</code> without specifying any value for
        /// <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation will read only the index and not
        /// the table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request attributes
        /// that are projected into the index. Global secondary index queries cannot fetch
        /// attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
        /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
        /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
        /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
        /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
        /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
        /// value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.select = input;
            self
        }
        /// Appends an item to `attributes_to_get`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes_to_get.unwrap_or_default();
            v.push(input.into());
            self.attributes_to_get = Some(v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes_to_get = input;
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching
        /// items). If DynamoDB processes the number of items up to the limit while processing the
        /// results, it stops the operation and returns the matching values up to that point, and a
        /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching
        /// items). If DynamoDB processes the number of items up to the limit while processing the
        /// results, it stops the operation and returns the matching values up to that point, and a
        /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
        /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
        /// reads.</p>
        /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query
        /// a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you
        /// will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
        /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
        /// reads.</p>
        /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query
        /// a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you
        /// will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// Adds a key-value pair to `key_conditions`.
        ///
        /// To override the contents of this collection use [`set_key_conditions`](Self::set_key_conditions).
        ///
        /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn key_conditions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            let mut hash_map = self.key_conditions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.key_conditions = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_key_conditions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.key_conditions = input;
            self
        }
        /// Adds a key-value pair to `query_filter`.
        ///
        /// To override the contents of this collection use [`set_query_filter`](Self::set_query_filter).
        ///
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn query_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            let mut hash_map = self.query_filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.query_filter = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_query_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.query_filter = input;
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.conditional_operator = Some(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.conditional_operator = input;
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal
        /// is performed in ascending order; if <code>false</code>, the traversal is performed in
        /// descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the
        /// sort key data type is Number, the results are stored in numeric order. For type String,
        /// the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each
        /// byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in
        /// the order in which they are stored (by sort key value). This is the default behavior. If
        /// <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in
        /// reverse order by sort key value, and then returns the results to the client.</p>
        pub fn scan_index_forward(mut self, input: bool) -> Self {
            self.scan_index_forward = Some(input);
            self
        }
        /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal
        /// is performed in ascending order; if <code>false</code>, the traversal is performed in
        /// descending order. </p>
        /// <p>Items with the same partition key value are stored in sorted order by sort key. If the
        /// sort key data type is Number, the results are stored in numeric order. For type String,
        /// the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each
        /// byte of the binary data as unsigned.</p>
        /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in
        /// the order in which they are stored (by sort key value). This is the default behavior. If
        /// <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in
        /// reverse order by sort key value, and then returns the results to the client.</p>
        pub fn set_scan_index_forward(mut self, input: std::option::Option<bool>) -> Self {
            self.scan_index_forward = input;
            self
        }
        /// Adds a key-value pair to `exclusive_start_key`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value
        /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
        /// set data types are allowed.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.exclusive_start_key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.exclusive_start_key = Some(hash_map);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value
        /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
        /// set data types are allowed.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.exclusive_start_key = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These
        /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
        /// the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of
        /// the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.projection_expression = Some(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the table. These
        /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
        /// the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of
        /// the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.projection_expression = input;
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code>
        /// operation, but before the data is returned to you. Items that do not satisfy the
        /// <code>FilterExpression</code> criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a
        /// filter expression based on a partition key or a sort key.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
        /// the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code>
        /// operation, but before the data is returned to you. Items that do not satisfy the
        /// <code>FilterExpression</code> criteria are not returned.</p>
        /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a
        /// filter expression based on a partition key or a sort key.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
        /// the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the
        /// <code>Query</code> action.</p>
        ///
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single sort
        /// key value. This allows <code>Query</code> to retrieve one item with a given partition
        /// key value and sort key value, or several items that have the same partition key value
        /// but different sort key values.</p>
        ///
        /// <p>The partition key equality test is required, and must be specified in the following
        /// format:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <i>=</i>
        /// <code>:partitionkeyval</code>
        /// </p>
        ///
        /// <p>If you also want to provide a condition for the sort key, it must be combined using
        /// <code>AND</code> with the condition for the sort key. Following is an example, using
        /// the <b>=</b> comparison operator for the sort key:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <code>=</code>
        /// <code>:partitionkeyval</code>
        /// <code>AND</code>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code>
        /// </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>></code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>>= </code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than or equal
        /// to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>BETWEEN</code>
        /// <code>:sortkeyval1</code>
        /// <code>AND</code>
        /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal
        /// to <code>:sortkeyval1</code>, and less than or equal to
        /// <code>:sortkeyval2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>begins_with (</code>
        /// <code>sortKeyName</code>, <code>:sortkeyval</code>
        /// <code>)</code> - true if the sort key value begins with a particular operand.
        /// (You cannot use this function with a sort key that is of type Number.) Note that
        /// the function name <code>begins_with</code> is case-sensitive.</p>
        ///
        /// </li>
        /// </ul>
        ///
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
        /// <code>:partitionval</code> and <code>:sortval</code> with actual values at
        /// runtime.</p>
        ///
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace
        /// the names of the partition key and sort key with placeholder tokens. This option might
        /// be necessary if an attribute name conflicts with a DynamoDB reserved word. For example,
        /// the following <code>KeyConditionExpression</code> parameter causes an error because
        /// <i>Size</i> is a reserved word:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Size = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the
        /// attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as
        /// follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#S = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
        /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        ///
        /// <p>For more information on <code>ExpressionAttributeNames</code> and
        /// <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
        /// Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        pub fn key_condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_condition_expression = Some(input.into());
            self
        }
        /// <p>The condition that specifies the key values for items to be retrieved by the
        /// <code>Query</code> action.</p>
        ///
        /// <p>The condition must perform an equality test on a single partition key value.</p>
        /// <p>The condition can optionally perform one of several comparison tests on a single sort
        /// key value. This allows <code>Query</code> to retrieve one item with a given partition
        /// key value and sort key value, or several items that have the same partition key value
        /// but different sort key values.</p>
        ///
        /// <p>The partition key equality test is required, and must be specified in the following
        /// format:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <i>=</i>
        /// <code>:partitionkeyval</code>
        /// </p>
        ///
        /// <p>If you also want to provide a condition for the sort key, it must be combined using
        /// <code>AND</code> with the condition for the sort key. Following is an example, using
        /// the <b>=</b> comparison operator for the sort key:</p>
        ///
        /// <p>
        /// <code>partitionKeyName</code>
        /// <code>=</code>
        /// <code>:partitionkeyval</code>
        /// <code>AND</code>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code>
        /// </p>
        /// <p>Valid comparisons for the sort key condition are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code><=</code>
        /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>></code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than
        /// <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>>= </code>
        /// <code>:sortkeyval</code> - true if the sort key value is greater than or equal
        /// to <code>:sortkeyval</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sortKeyName</code>
        /// <code>BETWEEN</code>
        /// <code>:sortkeyval1</code>
        /// <code>AND</code>
        /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal
        /// to <code>:sortkeyval1</code>, and less than or equal to
        /// <code>:sortkeyval2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>begins_with (</code>
        /// <code>sortKeyName</code>, <code>:sortkeyval</code>
        /// <code>)</code> - true if the sort key value begins with a particular operand.
        /// (You cannot use this function with a sort key that is of type Number.) Note that
        /// the function name <code>begins_with</code> is case-sensitive.</p>
        ///
        /// </li>
        /// </ul>
        ///
        /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
        /// <code>:partitionval</code> and <code>:sortval</code> with actual values at
        /// runtime.</p>
        ///
        /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace
        /// the names of the partition key and sort key with placeholder tokens. This option might
        /// be necessary if an attribute name conflicts with a DynamoDB reserved word. For example,
        /// the following <code>KeyConditionExpression</code> parameter causes an error because
        /// <i>Size</i> is a reserved word:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Size = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the
        /// attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as
        /// follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#S = :myval</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
        /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
        ///
        /// <p>For more information on <code>ExpressionAttributeNames</code> and
        /// <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
        /// Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB
        /// Developer Guide</i>.</p>
        pub fn set_key_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryInput`](crate::input::QueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::QueryInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::QueryInput {
                table_name: self.table_name,
                index_name: self.index_name,
                select: self.select,
                attributes_to_get: self.attributes_to_get,
                limit: self.limit,
                consistent_read: self.consistent_read,
                key_conditions: self.key_conditions,
                query_filter: self.query_filter,
                conditional_operator: self.conditional_operator,
                scan_index_forward: self.scan_index_forward,
                exclusive_start_key: self.exclusive_start_key,
                return_consumed_capacity: self.return_consumed_capacity,
                projection_expression: self.projection_expression,
                filter_expression: self.filter_expression,
                key_condition_expression: self.key_condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
            })
        }
    }
}
#[doc(hidden)]
pub type QueryInputOperationOutputAlias = crate::operation::Query;
#[doc(hidden)]
pub type QueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl QueryInput {
    /// Consumes the builder and constructs an Operation<[`Query`](crate::operation::Query)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Query,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::QueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::QueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::QueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.Query",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Query::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Query", "dynamodb",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`QueryInput`](crate::input::QueryInput)
    pub fn builder() -> crate::input::query_input::Builder {
        crate::input::query_input::Builder::default()
    }
}

/// See [`RestoreTableFromBackupInput`](crate::input::RestoreTableFromBackupInput)
pub mod restore_table_from_backup_input {
    /// A builder for [`RestoreTableFromBackupInput`](crate::input::RestoreTableFromBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_table_name: std::option::Option<std::string::String>,
        pub(crate) backup_arn: std::option::Option<std::string::String>,
        pub(crate) billing_mode_override: std::option::Option<crate::model::BillingMode>,
        pub(crate) global_secondary_index_override:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        pub(crate) local_secondary_index_override:
            std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughput>,
        pub(crate) sse_specification_override: std::option::Option<crate::model::SseSpecification>,
    }
    impl Builder {
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_table_name = Some(input.into());
            self
        }
        /// <p>The name of the new table to which the backup must be restored.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_table_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn backup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
        pub fn set_backup_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.backup_arn = input;
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode_override = Some(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode_override = input;
            self
        }
        /// Appends an item to `global_secondary_index_override`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            input: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            let mut v = self.global_secondary_index_override.unwrap_or_default();
            v.push(input.into());
            self.global_secondary_index_override = Some(v);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.global_secondary_index_override = input;
            self
        }
        /// Appends an item to `local_secondary_index_override`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            input: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            let mut v = self.local_secondary_index_override.unwrap_or_default();
            v.push(input.into());
            self.local_secondary_index_override = Some(v);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.local_secondary_index_override = input;
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, input: crate::model::SseSpecification) -> Self {
            self.sse_specification_override = Some(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.sse_specification_override = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableFromBackupInput`](crate::input::RestoreTableFromBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreTableFromBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreTableFromBackupInput {
                target_table_name: self.target_table_name,
                backup_arn: self.backup_arn,
                billing_mode_override: self.billing_mode_override,
                global_secondary_index_override: self.global_secondary_index_override,
                local_secondary_index_override: self.local_secondary_index_override,
                provisioned_throughput_override: self.provisioned_throughput_override,
                sse_specification_override: self.sse_specification_override,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreTableFromBackupInputOperationOutputAlias = crate::operation::RestoreTableFromBackup;
#[doc(hidden)]
pub type RestoreTableFromBackupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreTableFromBackupInput {
    /// Consumes the builder and constructs an Operation<[`RestoreTableFromBackup`](crate::operation::RestoreTableFromBackup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreTableFromBackup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreTableFromBackupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreTableFromBackupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreTableFromBackupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.RestoreTableFromBackup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_table_from_backup(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreTableFromBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreTableFromBackup",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreTableFromBackupInput`](crate::input::RestoreTableFromBackupInput)
    pub fn builder() -> crate::input::restore_table_from_backup_input::Builder {
        crate::input::restore_table_from_backup_input::Builder::default()
    }
}

/// See [`RestoreTableToPointInTimeInput`](crate::input::RestoreTableToPointInTimeInput)
pub mod restore_table_to_point_in_time_input {
    /// A builder for [`RestoreTableToPointInTimeInput`](crate::input::RestoreTableToPointInTimeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_table_arn: std::option::Option<std::string::String>,
        pub(crate) source_table_name: std::option::Option<std::string::String>,
        pub(crate) target_table_name: std::option::Option<std::string::String>,
        pub(crate) use_latest_restorable_time: std::option::Option<bool>,
        pub(crate) restore_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) billing_mode_override: std::option::Option<crate::model::BillingMode>,
        pub(crate) global_secondary_index_override:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        pub(crate) local_secondary_index_override:
            std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        pub(crate) provisioned_throughput_override:
            std::option::Option<crate::model::ProvisionedThroughput>,
        pub(crate) sse_specification_override: std::option::Option<crate::model::SseSpecification>,
    }
    impl Builder {
        /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn source_table_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table_arn = Some(input.into());
            self
        }
        /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name
        /// (ARN).</p>
        pub fn set_source_table_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_table_arn = input;
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn source_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table_name = Some(input.into());
            self
        }
        /// <p>Name of the source table that is being restored.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_table_name = input;
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn target_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_table_name = Some(input.into());
            self
        }
        /// <p>The name of the new table to which it must be restored to.</p>
        pub fn set_target_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_table_name = input;
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
        /// is typically 5 minutes before the current time. </p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.use_latest_restorable_time = Some(input);
            self
        }
        /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
        /// is typically 5 minutes before the current time. </p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.use_latest_restorable_time = input;
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn restore_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.restore_date_time = Some(input);
            self
        }
        /// <p>Time in the past to restore the table to.</p>
        pub fn set_restore_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.restore_date_time = input;
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn billing_mode_override(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode_override = Some(input);
            self
        }
        /// <p>The billing mode of the restored table.</p>
        pub fn set_billing_mode_override(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode_override = input;
            self
        }
        /// Appends an item to `global_secondary_index_override`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_override`](Self::set_global_secondary_index_override).
        ///
        /// <p>List of global secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn global_secondary_index_override(
            mut self,
            input: impl Into<crate::model::GlobalSecondaryIndex>,
        ) -> Self {
            let mut v = self.global_secondary_index_override.unwrap_or_default();
            v.push(input.into());
            self.global_secondary_index_override = Some(v);
            self
        }
        /// <p>List of global secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn set_global_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
        ) -> Self {
            self.global_secondary_index_override = input;
            self
        }
        /// Appends an item to `local_secondary_index_override`.
        ///
        /// To override the contents of this collection use [`set_local_secondary_index_override`](Self::set_local_secondary_index_override).
        ///
        /// <p>List of local secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn local_secondary_index_override(
            mut self,
            input: impl Into<crate::model::LocalSecondaryIndex>,
        ) -> Self {
            let mut v = self.local_secondary_index_override.unwrap_or_default();
            v.push(input.into());
            self.local_secondary_index_override = Some(v);
            self
        }
        /// <p>List of local secondary indexes for the restored table. The indexes provided should
        /// match existing secondary indexes. You can choose to exclude some or all of the indexes
        /// at the time of restore.</p>
        pub fn set_local_secondary_index_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
        ) -> Self {
            self.local_secondary_index_override = input;
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn provisioned_throughput_override(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput_override = Some(input);
            self
        }
        /// <p>Provisioned throughput settings for the restored table.</p>
        pub fn set_provisioned_throughput_override(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput_override = input;
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn sse_specification_override(mut self, input: crate::model::SseSpecification) -> Self {
            self.sse_specification_override = Some(input);
            self
        }
        /// <p>The new server-side encryption settings for the restored table.</p>
        pub fn set_sse_specification_override(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.sse_specification_override = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableToPointInTimeInput`](crate::input::RestoreTableToPointInTimeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestoreTableToPointInTimeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestoreTableToPointInTimeInput {
                source_table_arn: self.source_table_arn,
                source_table_name: self.source_table_name,
                target_table_name: self.target_table_name,
                use_latest_restorable_time: self.use_latest_restorable_time,
                restore_date_time: self.restore_date_time,
                billing_mode_override: self.billing_mode_override,
                global_secondary_index_override: self.global_secondary_index_override,
                local_secondary_index_override: self.local_secondary_index_override,
                provisioned_throughput_override: self.provisioned_throughput_override,
                sse_specification_override: self.sse_specification_override,
            })
        }
    }
}
#[doc(hidden)]
pub type RestoreTableToPointInTimeInputOperationOutputAlias =
    crate::operation::RestoreTableToPointInTime;
#[doc(hidden)]
pub type RestoreTableToPointInTimeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RestoreTableToPointInTimeInput {
    /// Consumes the builder and constructs an Operation<[`RestoreTableToPointInTime`](crate::operation::RestoreTableToPointInTime)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestoreTableToPointInTime,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RestoreTableToPointInTimeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RestoreTableToPointInTimeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RestoreTableToPointInTimeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.RestoreTableToPointInTime",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_restore_table_to_point_in_time(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestoreTableToPointInTime::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestoreTableToPointInTime",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RestoreTableToPointInTimeInput`](crate::input::RestoreTableToPointInTimeInput)
    pub fn builder() -> crate::input::restore_table_to_point_in_time_input::Builder {
        crate::input::restore_table_to_point_in_time_input::Builder::default()
    }
}

/// See [`ScanInput`](crate::input::ScanInput)
pub mod scan_input {
    /// A builder for [`ScanInput`](crate::input::ScanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) select: std::option::Option<crate::model::Select>,
        pub(crate) scan_filter: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Condition>,
        >,
        pub(crate) conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
        pub(crate) exclusive_start_key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) total_segments: std::option::Option<i32>,
        pub(crate) segment: std::option::Option<i32>,
        pub(crate) projection_expression: std::option::Option<std::string::String>,
        pub(crate) filter_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) consistent_read: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the table containing the requested items; or, if you provide
        /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table containing the requested items; or, if you provide
        /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or
        /// global secondary index. Note that if you use the <code>IndexName</code> parameter, you
        /// must also provide <code>TableName</code>.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of a secondary index to scan. This index can be any local secondary index or
        /// global secondary index. Note that if you use the <code>IndexName</code> parameter, you
        /// must also provide <code>TableName</code>.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `attributes_to_get`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_get`](Self::set_attributes_to_get).
        ///
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn attributes_to_get(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attributes_to_get.unwrap_or_default();
            v.push(input.into());
            self.attributes_to_get = Some(v);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_attributes_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attributes_to_get = input;
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching
        /// items). If DynamoDB processes the number of items up to the limit while processing the
        /// results, it stops the operation and returns the matching values up to that point, and a
        /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of items to evaluate (not necessarily the number of matching
        /// items). If DynamoDB processes the number of items up to the limit while processing the
        /// results, it stops the operation and returns the matching values up to that point, and a
        /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
        /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
        /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
        /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
        /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
        /// specific item attributes, the count of matching items, or in the case of an index, some
        /// or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the index
        /// is configured to project all attributes, this return value is equivalent to
        /// specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to specifying
        /// <code>AttributesToGet</code> without specifying any value for
        /// <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation reads only the index and not the
        /// table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request attributes
        /// that are projected into the index. Global secondary index queries cannot fetch
        /// attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
        /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
        /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
        /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
        /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
        /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
        /// value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn select(mut self, input: crate::model::Select) -> Self {
            self.select = Some(input);
            self
        }
        /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
        /// specific item attributes, the count of matching items, or in the case of an index, some
        /// or all of the attributes projected into the index.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
        /// specified table or index. If you query a local secondary index, then for each
        /// matching item in the index, DynamoDB fetches the entire item from the parent
        /// table. If the index is configured to project all item attributes, then all of
        /// the data can be obtained from the local secondary index, and no fetching is
        /// required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
        /// Retrieves all attributes that have been projected into the index. If the index
        /// is configured to project all attributes, this return value is equivalent to
        /// specifying <code>ALL_ATTRIBUTES</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COUNT</code> - Returns the number of matching items, rather than the
        /// matching items themselves.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
        /// <code>AttributesToGet</code>. This return value is equivalent to specifying
        /// <code>AttributesToGet</code> without specifying any value for
        /// <code>Select</code>.</p>
        /// <p>If you query or scan a local secondary index and request only attributes that
        /// are projected into that index, the operation reads only the index and not the
        /// table. If any of the requested attributes are not projected into the local
        /// secondary index, DynamoDB fetches each of these attributes from the parent
        /// table. This extra fetching incurs additional throughput cost and latency.</p>
        /// <p>If you query or scan a global secondary index, you can only request attributes
        /// that are projected into the index. Global secondary index queries cannot fetch
        /// attributes from the parent table.</p>
        /// </li>
        /// </ul>
        /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
        /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
        /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
        /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
        /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
        /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
        /// <code>Select</code>.)</p>
        /// <note>
        /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
        /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
        /// value for <code>Select</code> will return an error.</p>
        /// </note>
        pub fn set_select(mut self, input: std::option::Option<crate::model::Select>) -> Self {
            self.select = input;
            self
        }
        /// Adds a key-value pair to `scan_filter`.
        ///
        /// To override the contents of this collection use [`set_scan_filter`](Self::set_scan_filter).
        ///
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn scan_filter(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            let mut hash_map = self.scan_filter.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.scan_filter = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_scan_filter(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.scan_filter = input;
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.conditional_operator = Some(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.conditional_operator = input;
            self
        }
        /// Adds a key-value pair to `exclusive_start_key`.
        ///
        /// To override the contents of this collection use [`set_exclusive_start_key`](Self::set_exclusive_start_key).
        ///
        /// <p>The primary key of the first item that this operation will evaluate. Use the value
        /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No
        /// set data types are allowed.</p>
        /// <p>In a parallel scan, a <code>Scan</code> request that includes
        /// <code>ExclusiveStartKey</code> must specify the same segment whose previous
        /// <code>Scan</code> returned the corresponding value of
        /// <code>LastEvaluatedKey</code>.</p>
        pub fn exclusive_start_key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.exclusive_start_key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.exclusive_start_key = Some(hash_map);
            self
        }
        /// <p>The primary key of the first item that this operation will evaluate. Use the value
        /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
        /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No
        /// set data types are allowed.</p>
        /// <p>In a parallel scan, a <code>Scan</code> request that includes
        /// <code>ExclusiveStartKey</code> must specify the same segment whose previous
        /// <code>Scan</code> returned the corresponding value of
        /// <code>LastEvaluatedKey</code>.</p>
        pub fn set_exclusive_start_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.exclusive_start_key = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the
        /// total number of segments into which the <code>Scan</code> operation will be divided. The
        /// value of <code>TotalSegments</code> corresponds to the number of application workers
        /// that will perform the parallel scan. For example, if you want to use four application
        /// threads to scan a table or an index, specify a <code>TotalSegments</code> value of
        /// 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less
        /// than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the
        /// <code>Scan</code> operation will be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify
        /// <code>Segment</code>.</p>
        pub fn total_segments(mut self, input: i32) -> Self {
            self.total_segments = Some(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the
        /// total number of segments into which the <code>Scan</code> operation will be divided. The
        /// value of <code>TotalSegments</code> corresponds to the number of application workers
        /// that will perform the parallel scan. For example, if you want to use four application
        /// threads to scan a table or an index, specify a <code>TotalSegments</code> value of
        /// 4.</p>
        /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less
        /// than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the
        /// <code>Scan</code> operation will be sequential rather than parallel.</p>
        /// <p>If you specify <code>TotalSegments</code>, you must also specify
        /// <code>Segment</code>.</p>
        pub fn set_total_segments(mut self, input: std::option::Option<i32>) -> Self {
            self.total_segments = input;
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an
        /// individual segment to be scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want
        /// to use four application threads to scan a table or an index, then the first thread
        /// specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so
        /// on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code>
        /// request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a
        /// subsequent <code>Scan</code> operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than
        /// the value provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide
        /// <code>TotalSegments</code>.</p>
        pub fn segment(mut self, input: i32) -> Self {
            self.segment = Some(input);
            self
        }
        /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an
        /// individual segment to be scanned by an application worker.</p>
        /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want
        /// to use four application threads to scan a table or an index, then the first thread
        /// specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so
        /// on.</p>
        /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code>
        /// request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a
        /// subsequent <code>Scan</code> operation.</p>
        /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than
        /// the value provided for <code>TotalSegments</code>.</p>
        /// <p>If you provide <code>Segment</code>, you must also provide
        /// <code>TotalSegments</code>.</p>
        pub fn set_segment(mut self, input: std::option::Option<i32>) -> Self {
            self.segment = input;
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table
        /// or index. These attributes can include scalars, sets, or elements of a JSON document.
        /// The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of
        /// the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn projection_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.projection_expression = Some(input.into());
            self
        }
        /// <p>A string that identifies one or more attributes to retrieve from the specified table
        /// or index. These attributes can include scalars, sets, or elements of a JSON document.
        /// The attributes in the expression must be separated by commas.</p>
        /// <p>If no attribute names are specified, then all attributes will be returned. If any of
        /// the requested attributes are not found, they will not appear in the result.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_projection_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.projection_expression = input;
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code>
        /// operation, but before the data is returned to you. Items that do not satisfy the
        /// <code>FilterExpression</code> criteria are not returned.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
        /// the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn filter_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_expression = Some(input.into());
            self
        }
        /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code>
        /// operation, but before the data is returned to you. Items that do not satisfy the
        /// <code>FilterExpression</code> criteria are not returned.</p>
        /// <note>
        /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
        /// the process of filtering does not consume any additional read capacity units.</p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
        /// Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_filter_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>). To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned
        /// from <code>Scan</code> might not contain the results from other recently
        /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
        /// <code>DeleteItem</code>).</p>
        /// </li>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write
        /// operations that completed before the <code>Scan</code> began are guaranteed to
        /// be contained in the <code>Scan</code> response.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary
        /// indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to
        /// true, you will receive a <code>ValidationException</code>.</p>
        pub fn consistent_read(mut self, input: bool) -> Self {
            self.consistent_read = Some(input);
            self
        }
        /// <p>A Boolean value that determines the read consistency model during the scan:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned
        /// from <code>Scan</code> might not contain the results from other recently
        /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
        /// <code>DeleteItem</code>).</p>
        /// </li>
        /// <li>
        /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write
        /// operations that completed before the <code>Scan</code> began are guaranteed to
        /// be contained in the <code>Scan</code> response.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
        /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary
        /// indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to
        /// true, you will receive a <code>ValidationException</code>.</p>
        pub fn set_consistent_read(mut self, input: std::option::Option<bool>) -> Self {
            self.consistent_read = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanInput`](crate::input::ScanInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ScanInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ScanInput {
                table_name: self.table_name,
                index_name: self.index_name,
                attributes_to_get: self.attributes_to_get,
                limit: self.limit,
                select: self.select,
                scan_filter: self.scan_filter,
                conditional_operator: self.conditional_operator,
                exclusive_start_key: self.exclusive_start_key,
                return_consumed_capacity: self.return_consumed_capacity,
                total_segments: self.total_segments,
                segment: self.segment,
                projection_expression: self.projection_expression,
                filter_expression: self.filter_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
                consistent_read: self.consistent_read,
            })
        }
    }
}
#[doc(hidden)]
pub type ScanInputOperationOutputAlias = crate::operation::Scan;
#[doc(hidden)]
pub type ScanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ScanInput {
    /// Consumes the builder and constructs an Operation<[`Scan`](crate::operation::Scan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Scan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ScanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ScanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ScanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.Scan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_scan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(request, crate::operation::Scan::new())
            .with_metadata(aws_smithy_http::operation::Metadata::new(
                "Scan", "dynamodb",
            ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ScanInput`](crate::input::ScanInput)
    pub fn builder() -> crate::input::scan_input::Builder {
        crate::input::scan_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is
        /// an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is
        /// an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TransactGetItemsInput`](crate::input::TransactGetItemsInput)
pub mod transact_get_items_input {
    /// A builder for [`TransactGetItemsInput`](crate::input::TransactGetItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transact_items:
            std::option::Option<std::vec::Vec<crate::model::TransactGetItem>>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
    }
    impl Builder {
        /// Appends an item to `transact_items`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which
        /// contains a <code>Get</code> structure.</p>
        pub fn transact_items(mut self, input: impl Into<crate::model::TransactGetItem>) -> Self {
            let mut v = self.transact_items.unwrap_or_default();
            v.push(input.into());
            self.transact_items = Some(v);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which
        /// contains a <code>Get</code> structure.</p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactGetItem>>,
        ) -> Self {
            self.transact_items = input;
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and
        /// a value of <code>NONE</code> prevents that information from being returned. No other
        /// value is valid.</p>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and
        /// a value of <code>NONE</code> prevents that information from being returned. No other
        /// value is valid.</p>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactGetItemsInput`](crate::input::TransactGetItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TransactGetItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TransactGetItemsInput {
                transact_items: self.transact_items,
                return_consumed_capacity: self.return_consumed_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type TransactGetItemsInputOperationOutputAlias = crate::operation::TransactGetItems;
#[doc(hidden)]
pub type TransactGetItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TransactGetItemsInput {
    /// Consumes the builder and constructs an Operation<[`TransactGetItems`](crate::operation::TransactGetItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TransactGetItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TransactGetItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TransactGetItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TransactGetItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.TransactGetItems",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_transact_get_items(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TransactGetItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TransactGetItems",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TransactGetItemsInput`](crate::input::TransactGetItemsInput)
    pub fn builder() -> crate::input::transact_get_items_input::Builder {
        crate::input::transact_get_items_input::Builder::default()
    }
}

/// See [`TransactWriteItemsInput`](crate::input::TransactWriteItemsInput)
pub mod transact_write_items_input {
    /// A builder for [`TransactWriteItemsInput`](crate::input::TransactWriteItemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transact_items:
            std::option::Option<std::vec::Vec<crate::model::TransactWriteItem>>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) return_item_collection_metrics:
            std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transact_items`.
        ///
        /// To override the contents of this collection use [`set_transact_items`](Self::set_transact_items).
        ///
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
        /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
        /// <code>Delete</code> object. These can operate on items in different tables, but the
        /// tables must reside in the same Amazon Web Services account and Region, and no two of them
        /// can operate on the same item. </p>
        pub fn transact_items(mut self, input: impl Into<crate::model::TransactWriteItem>) -> Self {
            let mut v = self.transact_items.unwrap_or_default();
            v.push(input.into());
            self.transact_items = Some(v);
            self
        }
        /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
        /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
        /// <code>Delete</code> object. These can operate on items in different tables, but the
        /// tables must reside in the same Amazon Web Services account and Region, and no two of them
        /// can operate on the same item. </p>
        pub fn set_transact_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransactWriteItem>>,
        ) -> Self {
            self.transact_items = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections (if any), that were modified
        /// during the operation and are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned. </p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.return_item_collection_metrics = Some(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections (if any), that were modified
        /// during the operation and are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned. </p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.return_item_collection_metrics = input;
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to
        /// <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls
        /// have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same
        /// result on the server (no side effects), the responses to the calls might not be the
        /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
        /// <code>TransactWriteItems</code> call returns the amount of write capacity units
        /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
        /// the same client token return the number of read capacity units consumed in reading the
        /// item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is
        /// completed. After 10 minutes, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 10
        /// minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 10-minute idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Providing a <code>ClientRequestToken</code> makes the call to
        /// <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls
        /// have the same effect as one single call.</p>
        /// <p>Although multiple identical calls using the same client request token produce the same
        /// result on the server (no side effects), the responses to the calls might not be the
        /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
        /// <code>TransactWriteItems</code> call returns the amount of write capacity units
        /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
        /// the same client token return the number of read capacity units consumed in reading the
        /// item.</p>
        /// <p>A client request token is valid for 10 minutes after the first request that uses it is
        /// completed. After 10 minutes, any request with the same client token is treated as a new
        /// request. Do not resubmit the same request with the same client token for more than 10
        /// minutes, or the result might not be idempotent.</p>
        /// <p>If you submit a request with the same client token but a change in other parameters
        /// within the 10-minute idempotency window, DynamoDB returns an
        /// <code>IdempotentParameterMismatch</code> exception.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`TransactWriteItemsInput`](crate::input::TransactWriteItemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TransactWriteItemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TransactWriteItemsInput {
                transact_items: self.transact_items,
                return_consumed_capacity: self.return_consumed_capacity,
                return_item_collection_metrics: self.return_item_collection_metrics,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type TransactWriteItemsInputOperationOutputAlias = crate::operation::TransactWriteItems;
#[doc(hidden)]
pub type TransactWriteItemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TransactWriteItemsInput {
    /// Consumes the builder and constructs an Operation<[`TransactWriteItems`](crate::operation::TransactWriteItems)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TransactWriteItems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TransactWriteItemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TransactWriteItemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TransactWriteItemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.TransactWriteItems",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_transact_write_items(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TransactWriteItems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TransactWriteItems",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TransactWriteItemsInput`](crate::input::TransactWriteItemsInput)
    pub fn builder() -> crate::input::transact_write_items_input::Builder {
        crate::input::transact_write_items_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
        /// Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
        /// will be removed from the DynamoDB resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
        /// will be removed from the DynamoDB resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateContinuousBackupsInput`](crate::input::UpdateContinuousBackupsInput)
pub mod update_continuous_backups_input {
    /// A builder for [`UpdateContinuousBackupsInput`](crate::input::UpdateContinuousBackupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) point_in_time_recovery_specification:
            std::option::Option<crate::model::PointInTimeRecoverySpecification>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn point_in_time_recovery_specification(
            mut self,
            input: crate::model::PointInTimeRecoverySpecification,
        ) -> Self {
            self.point_in_time_recovery_specification = Some(input);
            self
        }
        /// <p>Represents the settings used to enable point in time recovery.</p>
        pub fn set_point_in_time_recovery_specification(
            mut self,
            input: std::option::Option<crate::model::PointInTimeRecoverySpecification>,
        ) -> Self {
            self.point_in_time_recovery_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContinuousBackupsInput`](crate::input::UpdateContinuousBackupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContinuousBackupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContinuousBackupsInput {
                table_name: self.table_name,
                point_in_time_recovery_specification: self.point_in_time_recovery_specification,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContinuousBackupsInputOperationOutputAlias =
    crate::operation::UpdateContinuousBackups;
#[doc(hidden)]
pub type UpdateContinuousBackupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateContinuousBackupsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContinuousBackups`](crate::operation::UpdateContinuousBackups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContinuousBackups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContinuousBackupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContinuousBackupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContinuousBackupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateContinuousBackups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_continuous_backups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContinuousBackups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContinuousBackups",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContinuousBackupsInput`](crate::input::UpdateContinuousBackupsInput)
    pub fn builder() -> crate::input::update_continuous_backups_input::Builder {
        crate::input::update_continuous_backups_input::Builder::default()
    }
}

/// See [`UpdateContributorInsightsInput`](crate::input::UpdateContributorInsightsInput)
pub mod update_contributor_insights_input {
    /// A builder for [`UpdateContributorInsightsInput`](crate::input::UpdateContributorInsightsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) contributor_insights_action:
            std::option::Option<crate::model::ContributorInsightsAction>,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The global secondary index name, if applicable.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn contributor_insights_action(
            mut self,
            input: crate::model::ContributorInsightsAction,
        ) -> Self {
            self.contributor_insights_action = Some(input);
            self
        }
        /// <p>Represents the contributor insights action.</p>
        pub fn set_contributor_insights_action(
            mut self,
            input: std::option::Option<crate::model::ContributorInsightsAction>,
        ) -> Self {
            self.contributor_insights_action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContributorInsightsInput`](crate::input::UpdateContributorInsightsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContributorInsightsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContributorInsightsInput {
                table_name: self.table_name,
                index_name: self.index_name,
                contributor_insights_action: self.contributor_insights_action,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContributorInsightsInputOperationOutputAlias =
    crate::operation::UpdateContributorInsights;
#[doc(hidden)]
pub type UpdateContributorInsightsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateContributorInsightsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContributorInsights`](crate::operation::UpdateContributorInsights)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContributorInsights,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContributorInsightsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContributorInsightsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContributorInsightsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateContributorInsights",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_contributor_insights(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContributorInsights::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContributorInsights",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContributorInsightsInput`](crate::input::UpdateContributorInsightsInput)
    pub fn builder() -> crate::input::update_contributor_insights_input::Builder {
        crate::input::update_contributor_insights_input::Builder::default()
    }
}

/// See [`UpdateGlobalTableInput`](crate::input::UpdateGlobalTableInput)
pub mod update_global_table_input {
    /// A builder for [`UpdateGlobalTableInput`](crate::input::UpdateGlobalTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) replica_updates: std::option::Option<std::vec::Vec<crate::model::ReplicaUpdate>>,
    }
    impl Builder {
        /// <p>The global table name.</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The global table name.</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// Appends an item to `replica_updates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn replica_updates(mut self, input: impl Into<crate::model::ReplicaUpdate>) -> Self {
            let mut v = self.replica_updates.unwrap_or_default();
            v.push(input.into());
            self.replica_updates = Some(v);
            self
        }
        /// <p>A list of Regions that should be added or removed from the global table.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaUpdate>>,
        ) -> Self {
            self.replica_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalTableInput`](crate::input::UpdateGlobalTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGlobalTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGlobalTableInput {
                global_table_name: self.global_table_name,
                replica_updates: self.replica_updates,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGlobalTableInputOperationOutputAlias = crate::operation::UpdateGlobalTable;
#[doc(hidden)]
pub type UpdateGlobalTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGlobalTableInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGlobalTable`](crate::operation::UpdateGlobalTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGlobalTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGlobalTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGlobalTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGlobalTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateGlobalTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_global_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGlobalTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGlobalTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableInput`](crate::input::UpdateGlobalTableInput)
    pub fn builder() -> crate::input::update_global_table_input::Builder {
        crate::input::update_global_table_input::Builder::default()
    }
}

/// See [`UpdateGlobalTableSettingsInput`](crate::input::UpdateGlobalTableSettingsInput)
pub mod update_global_table_settings_input {
    /// A builder for [`UpdateGlobalTableSettingsInput`](crate::input::UpdateGlobalTableSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_table_name: std::option::Option<std::string::String>,
        pub(crate) global_table_billing_mode: std::option::Option<crate::model::BillingMode>,
        pub(crate) global_table_provisioned_write_capacity_units: std::option::Option<i64>,
        pub(crate) global_table_provisioned_write_capacity_auto_scaling_settings_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        pub(crate) global_table_global_secondary_index_settings_update: std::option::Option<
            std::vec::Vec<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
        >,
        pub(crate) replica_settings_update:
            std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsUpdate>>,
    }
    impl Builder {
        /// <p>The name of the global table</p>
        pub fn global_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table</p>
        pub fn set_global_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_table_name = input;
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not
        /// specified, the global table defaults to <code>PROVISIONED</code> capacity billing
        /// mode.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn global_table_billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.global_table_billing_mode = Some(input);
            self
        }
        /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not
        /// specified, the global table defaults to <code>PROVISIONED</code> capacity billing
        /// mode.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn set_global_table_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.global_table_billing_mode = input;
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a
        /// <code>ThrottlingException.</code>
        /// </p>
        pub fn global_table_provisioned_write_capacity_units(mut self, input: i64) -> Self {
            self.global_table_provisioned_write_capacity_units = Some(input);
            self
        }
        /// <p>The maximum number of writes consumed per second before DynamoDB returns a
        /// <code>ThrottlingException.</code>
        /// </p>
        pub fn set_global_table_provisioned_write_capacity_units(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.global_table_provisioned_write_capacity_units = input;
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global
        /// table.</p>
        pub fn global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.global_table_provisioned_write_capacity_auto_scaling_settings_update = Some(input);
            self
        }
        /// <p>Auto scaling settings for managing provisioned write capacity for the global
        /// table.</p>
        pub fn set_global_table_provisioned_write_capacity_auto_scaling_settings_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.global_table_provisioned_write_capacity_auto_scaling_settings_update = input;
            self
        }
        /// Appends an item to `global_table_global_secondary_index_settings_update`.
        ///
        /// To override the contents of this collection use [`set_global_table_global_secondary_index_settings_update`](Self::set_global_table_global_secondary_index_settings_update).
        ///
        /// <p>Represents the settings of a global secondary index for a global table that will be
        /// modified.</p>
        pub fn global_table_global_secondary_index_settings_update(
            mut self,
            input: impl Into<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
        ) -> Self {
            let mut v = self
                .global_table_global_secondary_index_settings_update
                .unwrap_or_default();
            v.push(input.into());
            self.global_table_global_secondary_index_settings_update = Some(v);
            self
        }
        /// <p>Represents the settings of a global secondary index for a global table that will be
        /// modified.</p>
        pub fn set_global_table_global_secondary_index_settings_update(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
            >,
        ) -> Self {
            self.global_table_global_secondary_index_settings_update = input;
            self
        }
        /// Appends an item to `replica_settings_update`.
        ///
        /// To override the contents of this collection use [`set_replica_settings_update`](Self::set_replica_settings_update).
        ///
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn replica_settings_update(
            mut self,
            input: impl Into<crate::model::ReplicaSettingsUpdate>,
        ) -> Self {
            let mut v = self.replica_settings_update.unwrap_or_default();
            v.push(input.into());
            self.replica_settings_update = Some(v);
            self
        }
        /// <p>Represents the settings for a global table in a Region that will be modified.</p>
        pub fn set_replica_settings_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsUpdate>>,
        ) -> Self {
            self.replica_settings_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGlobalTableSettingsInput`](crate::input::UpdateGlobalTableSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGlobalTableSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGlobalTableSettingsInput {
                global_table_name: self.global_table_name,
                global_table_billing_mode: self.global_table_billing_mode,
                global_table_provisioned_write_capacity_units: self
                    .global_table_provisioned_write_capacity_units,
                global_table_provisioned_write_capacity_auto_scaling_settings_update: self
                    .global_table_provisioned_write_capacity_auto_scaling_settings_update,
                global_table_global_secondary_index_settings_update: self
                    .global_table_global_secondary_index_settings_update,
                replica_settings_update: self.replica_settings_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGlobalTableSettingsInputOperationOutputAlias =
    crate::operation::UpdateGlobalTableSettings;
#[doc(hidden)]
pub type UpdateGlobalTableSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGlobalTableSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGlobalTableSettings`](crate::operation::UpdateGlobalTableSettings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGlobalTableSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGlobalTableSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGlobalTableSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGlobalTableSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateGlobalTableSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_global_table_settings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGlobalTableSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGlobalTableSettings",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGlobalTableSettingsInput`](crate::input::UpdateGlobalTableSettingsInput)
    pub fn builder() -> crate::input::update_global_table_settings_input::Builder {
        crate::input::update_global_table_settings_input::Builder::default()
    }
}

/// See [`UpdateItemInput`](crate::input::UpdateItemInput)
pub mod update_item_input {
    /// A builder for [`UpdateItemInput`](crate::input::UpdateItemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
        pub(crate) attribute_updates: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
        >,
        pub(crate) expected: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
        >,
        pub(crate) conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
        pub(crate) return_values: std::option::Option<crate::model::ReturnValue>,
        pub(crate) return_consumed_capacity:
            std::option::Option<crate::model::ReturnConsumedCapacity>,
        pub(crate) return_item_collection_metrics:
            std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        pub(crate) update_expression: std::option::Option<std::string::String>,
        pub(crate) condition_expression: std::option::Option<std::string::String>,
        pub(crate) expression_attribute_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expression_attribute_values: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
        >,
    }
    impl Builder {
        /// <p>The name of the table containing the item to update.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table containing the item to update.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Adds a key-value pair to `key`.
        ///
        /// To override the contents of this collection use [`set_key`](Self::set_key).
        ///
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name
        /// and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn key(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.key.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.key = Some(hash_map);
            self
        }
        /// <p>The primary key of the item to be updated. Each element consists of an attribute name
        /// and a value for that attribute.</p>
        /// <p>For the primary key, you must provide all of the attributes. For example, with a
        /// simple primary key, you only need to provide a value for the partition key. For a
        /// composite primary key, you must provide values for both the partition key and the sort
        /// key.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `attribute_updates`.
        ///
        /// To override the contents of this collection use [`set_attribute_updates`](Self::set_attribute_updates).
        ///
        /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn attribute_updates(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValueUpdate>,
        ) -> Self {
            let mut hash_map = self.attribute_updates.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attribute_updates = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_attribute_updates(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
            >,
        ) -> Self {
            self.attribute_updates = input;
            self
        }
        /// Adds a key-value pair to `expected`.
        ///
        /// To override the contents of this collection use [`set_expected`](Self::set_expected).
        ///
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expected(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ExpectedAttributeValue>,
        ) -> Self {
            let mut hash_map = self.expected.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expected = Some(hash_map);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expected(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ExpectedAttributeValue,
                >,
            >,
        ) -> Self {
            self.expected = input;
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn conditional_operator(mut self, input: crate::model::ConditionalOperator) -> Self {
            self.conditional_operator = Some(input);
            self
        }
        /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_conditional_operator(
            mut self,
            input: std::option::Option<crate::model::ConditionalOperator>,
        ) -> Self {
            self.conditional_operator = input;
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
        /// before or after they are updated. For <code>UpdateItem</code>, the valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they
        /// appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared
        /// before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear
        /// after the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear
        /// after the UpdateItem operation.</p>
        /// </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the
        /// small network and processing overhead of receiving a larger response. No read capacity
        /// units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn return_values(mut self, input: crate::model::ReturnValue) -> Self {
            self.return_values = Some(input);
            self
        }
        /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
        /// before or after they are updated. For <code>UpdateItem</code>, the valid values
        /// are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
        /// value is <code>NONE</code>, then nothing is returned. (This setting is the
        /// default for <code>ReturnValues</code>.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they
        /// appeared before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared
        /// before the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear
        /// after the UpdateItem operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear
        /// after the UpdateItem operation.</p>
        /// </li>
        /// </ul>
        /// <p>There is no additional cost associated with requesting a return value aside from the
        /// small network and processing overhead of receiving a larger response. No read capacity
        /// units are consumed.</p>
        /// <p>The values returned are strongly consistent.</p>
        pub fn set_return_values(
            mut self,
            input: std::option::Option<crate::model::ReturnValue>,
        ) -> Self {
            self.return_values = input;
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn return_consumed_capacity(
            mut self,
            input: crate::model::ReturnConsumedCapacity,
        ) -> Self {
            self.return_consumed_capacity = Some(input);
            self
        }
        /// <p>Determines the level of detail about either provisioned or on-demand throughput
        /// consumption that is returned in the response:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INDEXES</code> - The response includes the aggregate
        /// <code>ConsumedCapacity</code> for the operation, together with
        /// <code>ConsumedCapacity</code> for each table and secondary index that was
        /// accessed.</p>
        /// <p>Note that some operations, such as <code>GetItem</code> and
        /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
        /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
        /// information for table(s).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOTAL</code> - The response includes only the aggregate
        /// <code>ConsumedCapacity</code> for the operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
        /// response.</p>
        /// </li>
        /// </ul>
        pub fn set_return_consumed_capacity(
            mut self,
            input: std::option::Option<crate::model::ReturnConsumedCapacity>,
        ) -> Self {
            self.return_consumed_capacity = input;
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn return_item_collection_metrics(
            mut self,
            input: crate::model::ReturnItemCollectionMetrics,
        ) -> Self {
            self.return_item_collection_metrics = Some(input);
            self
        }
        /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
        /// the response includes statistics about item collections, if any, that were modified
        /// during the operation are returned in the response. If set to <code>NONE</code> (the
        /// default), no statistics are returned.</p>
        pub fn set_return_item_collection_metrics(
            mut self,
            input: std::option::Option<crate::model::ReturnItemCollectionMetrics>,
        ) -> Self {
            self.return_item_collection_metrics = input;
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be
        /// performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
        /// these attributes already exist, they are replaced by the new values. You can
        /// also use <code>SET</code> to add or subtract from an attribute that is of type
        /// Number. For example: <code>SET myNum = myNum + :val</code>
        /// </p>
        /// <p>
        /// <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>if_not_exists (path, operand)</code> - if the item does not
        /// contain an attribute at the specified path, then
        /// <code>if_not_exists</code> evaluates to operand; otherwise, it
        /// evaluates to path. You can use this function to avoid overwriting an
        /// attribute that may already be present in the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>list_append (operand, operand)</code> - evaluates to a list with a
        /// new element added to it. You can append the new element to the start or
        /// the end of the list by reversing the order of the operands.</p>
        /// </li>
        /// </ul>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Adds the specified value to the item, if the attribute does
        /// not already exist. If the attribute does exist, then the behavior of
        /// <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li>
        /// <p>If the existing attribute is a number, and if <code>Value</code> is
        /// also a number, then <code>Value</code> is mathematically added to the
        /// existing attribute. If <code>Value</code> is a negative number, then it
        /// is subtracted from the existing attribute.</p>
        /// <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number
        /// value for an item that doesn't exist before the update, DynamoDB
        /// uses <code>0</code> as the initial value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to
        /// increment or decrement an attribute value that doesn't exist before
        /// the update, DynamoDB uses <code>0</code> as the initial value. For
        /// example, suppose that the item you want to update doesn't have an
        /// attribute named <code>itemcount</code>, but you decide to
        /// <code>ADD</code> the number <code>3</code> to this attribute
        /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
        /// set its initial value to <code>0</code>, and finally add
        /// <code>3</code> to it. The result will be a new
        /// <code>itemcount</code> attribute in the item, with a value of
        /// <code>3</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>If the existing data type is a set and if <code>Value</code> is also a
        /// set, then <code>Value</code> is added to the existing set. For example,
        /// if the attribute value is the set <code>[1,2]</code>, and the
        /// <code>ADD</code> action specified <code>[3]</code>, then the final
        /// attribute value is <code>[1,2,3]</code>. An error occurs if an
        /// <code>ADD</code> action is specified for a set attribute and the
        /// attribute type specified does not match the existing set type. </p>
        /// <p>Both sets must have the same primitive data type. For example, if the
        /// existing data type is a set of strings, the <code>Value</code> must also
        /// be a set of strings.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In
        /// addition, <code>ADD</code> can only be used on top-level attributes, not
        /// nested attributes.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code> - Deletes an element from a set.</p>
        /// <p>If a set of values is specified, then those values are subtracted from the old
        /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and
        /// the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final
        /// attribute value is <code>[b]</code>. Specifying an empty set is an error.</p>
        /// <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition,
        /// <code>DELETE</code> can only be used on top-level attributes, not nested
        /// attributes.</p>
        /// </important>
        ///
        /// </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET
        /// a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
        /// </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
        /// Items and Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn update_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_expression = Some(input.into());
            self
        }
        /// <p>An expression that defines one or more attributes to be updated, the action to be
        /// performed on them, and new values for them.</p>
        /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
        /// these attributes already exist, they are replaced by the new values. You can
        /// also use <code>SET</code> to add or subtract from an attribute that is of type
        /// Number. For example: <code>SET myNum = myNum + :val</code>
        /// </p>
        /// <p>
        /// <code>SET</code> supports the following functions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>if_not_exists (path, operand)</code> - if the item does not
        /// contain an attribute at the specified path, then
        /// <code>if_not_exists</code> evaluates to operand; otherwise, it
        /// evaluates to path. You can use this function to avoid overwriting an
        /// attribute that may already be present in the item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>list_append (operand, operand)</code> - evaluates to a list with a
        /// new element added to it. You can append the new element to the start or
        /// the end of the list by reversing the order of the operands.</p>
        /// </li>
        /// </ul>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Adds the specified value to the item, if the attribute does
        /// not already exist. If the attribute does exist, then the behavior of
        /// <code>ADD</code> depends on the data type of the attribute:</p>
        /// <ul>
        /// <li>
        /// <p>If the existing attribute is a number, and if <code>Value</code> is
        /// also a number, then <code>Value</code> is mathematically added to the
        /// existing attribute. If <code>Value</code> is a negative number, then it
        /// is subtracted from the existing attribute.</p>
        /// <note>
        /// <p>If you use <code>ADD</code> to increment or decrement a number
        /// value for an item that doesn't exist before the update, DynamoDB
        /// uses <code>0</code> as the initial value.</p>
        /// <p>Similarly, if you use <code>ADD</code> for an existing item to
        /// increment or decrement an attribute value that doesn't exist before
        /// the update, DynamoDB uses <code>0</code> as the initial value. For
        /// example, suppose that the item you want to update doesn't have an
        /// attribute named <code>itemcount</code>, but you decide to
        /// <code>ADD</code> the number <code>3</code> to this attribute
        /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
        /// set its initial value to <code>0</code>, and finally add
        /// <code>3</code> to it. The result will be a new
        /// <code>itemcount</code> attribute in the item, with a value of
        /// <code>3</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>If the existing data type is a set and if <code>Value</code> is also a
        /// set, then <code>Value</code> is added to the existing set. For example,
        /// if the attribute value is the set <code>[1,2]</code>, and the
        /// <code>ADD</code> action specified <code>[3]</code>, then the final
        /// attribute value is <code>[1,2,3]</code>. An error occurs if an
        /// <code>ADD</code> action is specified for a set attribute and the
        /// attribute type specified does not match the existing set type. </p>
        /// <p>Both sets must have the same primitive data type. For example, if the
        /// existing data type is a set of strings, the <code>Value</code> must also
        /// be a set of strings.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>The <code>ADD</code> action only supports Number and set data types. In
        /// addition, <code>ADD</code> can only be used on top-level attributes, not
        /// nested attributes.</p>
        /// </important>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE</code> - Deletes an element from a set.</p>
        /// <p>If a set of values is specified, then those values are subtracted from the old
        /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and
        /// the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final
        /// attribute value is <code>[b]</code>. Specifying an empty set is an error.</p>
        /// <important>
        /// <p>The <code>DELETE</code> action only supports set data types. In addition,
        /// <code>DELETE</code> can only be used on top-level attributes, not nested
        /// attributes.</p>
        /// </important>
        ///
        /// </li>
        /// </ul>
        /// <p>You can have many actions in a single expression, such as the following: <code>SET
        /// a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
        /// </p>
        /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
        /// Items and Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_update_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_expression = input;
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn condition_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.condition_expression = Some(input.into());
            self
        }
        /// <p>A condition that must be satisfied in order for a conditional update to
        /// succeed.</p>
        /// <p>An expression can contain any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
        /// contains | begins_with | size</code>
        /// </p>
        /// <p>These function names are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Comparison operators: <code>= | <> |
        /// < | > | <= | >= |
        /// BETWEEN | IN </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> Logical operators: <code>AND | OR | NOT</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_condition_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.condition_expression = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_names`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_names`](Self::set_expression_attribute_names).
        ///
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.) To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_names = Some(hash_map);
            self
        }
        /// <p>One or more substitution tokens for attribute names in an expression. The following
        /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
        /// word.</p>
        /// </li>
        /// <li>
        /// <p>To create a placeholder for repeating occurrences of an attribute name in an
        /// expression.</p>
        /// </li>
        /// <li>
        /// <p>To prevent special characters in an attribute name from being misinterpreted
        /// in an expression.</p>
        /// </li>
        /// </ul>
        /// <p>Use the <b>#</b> character in an expression to dereference
        /// an attribute name. For example, consider the following attribute name:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Percentile</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
        /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.) To work around this, you could specify the following for
        /// <code>ExpressionAttributeNames</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>{"#P":"Percentile"}</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>You could then use this substitution in an expression, as in this example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#P = :val</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Tokens that begin with the <b>:</b> character are
        /// <i>expression attribute values</i>, which are placeholders for the
        /// actual value at runtime.</p>
        /// </note>
        /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.expression_attribute_names = input;
            self
        }
        /// Adds a key-value pair to `expression_attribute_values`.
        ///
        /// To override the contents of this collection use [`set_expression_attribute_values`](Self::set_expression_attribute_values).
        ///
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn expression_attribute_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::AttributeValue>,
        ) -> Self {
            let mut hash_map = self.expression_attribute_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.expression_attribute_values = Some(hash_map);
            self
        }
        /// <p>One or more values that can be substituted in an expression.</p>
        /// <p>Use the <b>:</b> (colon) character in an expression to
        /// dereference an attribute value. For example, suppose that you wanted to check whether
        /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
        /// <p>
        /// <code>Available | Backordered | Discontinued</code>
        /// </p>
        /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
        /// follows:</p>
        /// <p>
        /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
        /// ":disc":{"S":"Discontinued"} }</code>
        /// </p>
        /// <p>You could then use these values in an expression, such as this:</p>
        /// <p>
        /// <code>ProductStatus IN (:avail, :back, :disc)</code>
        /// </p>
        /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>.</p>
        pub fn set_expression_attribute_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
            >,
        ) -> Self {
            self.expression_attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateItemInput`](crate::input::UpdateItemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateItemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateItemInput {
                table_name: self.table_name,
                key: self.key,
                attribute_updates: self.attribute_updates,
                expected: self.expected,
                conditional_operator: self.conditional_operator,
                return_values: self.return_values,
                return_consumed_capacity: self.return_consumed_capacity,
                return_item_collection_metrics: self.return_item_collection_metrics,
                update_expression: self.update_expression,
                condition_expression: self.condition_expression,
                expression_attribute_names: self.expression_attribute_names,
                expression_attribute_values: self.expression_attribute_values,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateItemInputOperationOutputAlias = crate::operation::UpdateItem;
#[doc(hidden)]
pub type UpdateItemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateItemInput {
    /// Consumes the builder and constructs an Operation<[`UpdateItem`](crate::operation::UpdateItem)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateItem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateItemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateItemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateItemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateItem",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_item(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateItem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateItem",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateItemInput`](crate::input::UpdateItemInput)
    pub fn builder() -> crate::input::update_item_input::Builder {
        crate::input::update_item_input::Builder::default()
    }
}

/// See [`UpdateTableInput`](crate::input::UpdateTableInput)
pub mod update_table_input {
    /// A builder for [`UpdateTableInput`](crate::input::UpdateTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_definitions:
            std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) billing_mode: std::option::Option<crate::model::BillingMode>,
        pub(crate) provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
        pub(crate) global_secondary_index_updates:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexUpdate>>,
        pub(crate) stream_specification: std::option::Option<crate::model::StreamSpecification>,
        pub(crate) sse_specification: std::option::Option<crate::model::SseSpecification>,
        pub(crate) replica_updates:
            std::option::Option<std::vec::Vec<crate::model::ReplicationGroupUpdate>>,
        pub(crate) table_class: std::option::Option<crate::model::TableClass>,
    }
    impl Builder {
        /// Appends an item to `attribute_definitions`.
        ///
        /// To override the contents of this collection use [`set_attribute_definitions`](Self::set_attribute_definitions).
        ///
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you
        /// are adding a new global secondary index to the table, <code>AttributeDefinitions</code>
        /// must include the key element(s) of the new index.</p>
        pub fn attribute_definitions(
            mut self,
            input: impl Into<crate::model::AttributeDefinition>,
        ) -> Self {
            let mut v = self.attribute_definitions.unwrap_or_default();
            v.push(input.into());
            self.attribute_definitions = Some(v);
            self
        }
        /// <p>An array of attributes that describe the key schema for the table and indexes. If you
        /// are adding a new global secondary index to the table, <code>AttributeDefinitions</code>
        /// must include the key element(s) of the new index.</p>
        pub fn set_attribute_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
        ) -> Self {
            self.attribute_definitions = input;
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage
        /// capacity. When switching from pay-per-request to provisioned capacity, initial
        /// provisioned capacity values must be set. The initial provisioned capacity values are
        /// estimated based on the consumed read and write capacity of your table and global
        /// secondary indexes over the past 30 minutes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn billing_mode(mut self, input: crate::model::BillingMode) -> Self {
            self.billing_mode = Some(input);
            self
        }
        /// <p>Controls how you are charged for read and write throughput and how you manage
        /// capacity. When switching from pay-per-request to provisioned capacity, initial
        /// provisioned capacity values must be set. The initial provisioned capacity values are
        /// estimated based on the consumed read and write capacity of your table and global
        /// secondary indexes over the past 30 minutes.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
        /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
        /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
        /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
        /// </li>
        /// </ul>
        pub fn set_billing_mode(
            mut self,
            input: std::option::Option<crate::model::BillingMode>,
        ) -> Self {
            self.billing_mode = input;
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn provisioned_throughput(
            mut self,
            input: crate::model::ProvisionedThroughput,
        ) -> Self {
            self.provisioned_throughput = Some(input);
            self
        }
        /// <p>The new provisioned throughput settings for the specified table or index.</p>
        pub fn set_provisioned_throughput(
            mut self,
            input: std::option::Option<crate::model::ProvisionedThroughput>,
        ) -> Self {
            self.provisioned_throughput = input;
            self
        }
        /// Appends an item to `global_secondary_index_updates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>An array of one or more global secondary indexes for the table. For each index in the
        /// array, you can request one action:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Create</code> - add a new global secondary index to the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Update</code> - modify the provisioned throughput settings of an existing
        /// global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delete</code> - remove a global secondary index from the table.</p>
        /// </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code>
        /// operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
        /// Secondary Indexes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>. </p>
        pub fn global_secondary_index_updates(
            mut self,
            input: impl Into<crate::model::GlobalSecondaryIndexUpdate>,
        ) -> Self {
            let mut v = self.global_secondary_index_updates.unwrap_or_default();
            v.push(input.into());
            self.global_secondary_index_updates = Some(v);
            self
        }
        /// <p>An array of one or more global secondary indexes for the table. For each index in the
        /// array, you can request one action:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Create</code> - add a new global secondary index to the table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Update</code> - modify the provisioned throughput settings of an existing
        /// global secondary index.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delete</code> - remove a global secondary index from the table.</p>
        /// </li>
        /// </ul>
        /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code>
        /// operation.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
        /// Secondary Indexes</a> in the <i>Amazon DynamoDB Developer
        /// Guide</i>. </p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexUpdate>>,
        ) -> Self {
            self.global_secondary_index_updates = input;
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p>
        /// <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on
        /// a table that already has a stream, or if you try to disable a stream on a table that
        /// doesn't have a stream.</p>
        /// </note>
        pub fn stream_specification(mut self, input: crate::model::StreamSpecification) -> Self {
            self.stream_specification = Some(input);
            self
        }
        /// <p>Represents the DynamoDB Streams configuration for the table.</p>
        /// <note>
        /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on
        /// a table that already has a stream, or if you try to disable a stream on a table that
        /// doesn't have a stream.</p>
        /// </note>
        pub fn set_stream_specification(
            mut self,
            input: std::option::Option<crate::model::StreamSpecification>,
        ) -> Self {
            self.stream_specification = input;
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn sse_specification(mut self, input: crate::model::SseSpecification) -> Self {
            self.sse_specification = Some(input);
            self
        }
        /// <p>The new server-side encryption settings for the specified table.</p>
        pub fn set_sse_specification(
            mut self,
            input: std::option::Option<crate::model::SseSpecification>,
        ) -> Self {
            self.sse_specification = input;
            self
        }
        /// Appends an item to `replica_updates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
        /// <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version
        /// 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn replica_updates(
            mut self,
            input: impl Into<crate::model::ReplicationGroupUpdate>,
        ) -> Self {
            let mut v = self.replica_updates.unwrap_or_default();
            v.push(input.into());
            self.replica_updates = Some(v);
            self
        }
        /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
        /// <note>
        /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version
        /// 2019.11.21</a> of global tables.</p>
        /// </note>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationGroupUpdate>>,
        ) -> Self {
            self.replica_updates = input;
            self
        }
        /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and
        /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn table_class(mut self, input: crate::model::TableClass) -> Self {
            self.table_class = Some(input);
            self
        }
        /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and
        /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
        pub fn set_table_class(
            mut self,
            input: std::option::Option<crate::model::TableClass>,
        ) -> Self {
            self.table_class = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableInput`](crate::input::UpdateTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTableInput {
                attribute_definitions: self.attribute_definitions,
                table_name: self.table_name,
                billing_mode: self.billing_mode,
                provisioned_throughput: self.provisioned_throughput,
                global_secondary_index_updates: self.global_secondary_index_updates,
                stream_specification: self.stream_specification,
                sse_specification: self.sse_specification,
                replica_updates: self.replica_updates,
                table_class: self.table_class,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTableInputOperationOutputAlias = crate::operation::UpdateTable;
#[doc(hidden)]
pub type UpdateTableInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTableInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTable`](crate::operation::UpdateTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTable,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_table(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTable",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTableInput`](crate::input::UpdateTableInput)
    pub fn builder() -> crate::input::update_table_input::Builder {
        crate::input::update_table_input::Builder::default()
    }
}

/// See [`UpdateTableReplicaAutoScalingInput`](crate::input::UpdateTableReplicaAutoScalingInput)
pub mod update_table_replica_auto_scaling_input {
    /// A builder for [`UpdateTableReplicaAutoScalingInput`](crate::input::UpdateTableReplicaAutoScalingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_secondary_index_updates:
            std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexAutoScalingUpdate>>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) provisioned_write_capacity_auto_scaling_update:
            std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        pub(crate) replica_updates:
            std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingUpdate>>,
    }
    impl Builder {
        /// Appends an item to `global_secondary_index_updates`.
        ///
        /// To override the contents of this collection use [`set_global_secondary_index_updates`](Self::set_global_secondary_index_updates).
        ///
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to
        /// be updated.</p>
        pub fn global_secondary_index_updates(
            mut self,
            input: impl Into<crate::model::GlobalSecondaryIndexAutoScalingUpdate>,
        ) -> Self {
            let mut v = self.global_secondary_index_updates.unwrap_or_default();
            v.push(input.into());
            self.global_secondary_index_updates = Some(v);
            self
        }
        /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to
        /// be updated.</p>
        pub fn set_global_secondary_index_updates(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::GlobalSecondaryIndexAutoScalingUpdate>,
            >,
        ) -> Self {
            self.global_secondary_index_updates = input;
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the global table to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global
        /// secondary index.</p>
        pub fn provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: crate::model::AutoScalingSettingsUpdate,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_update = Some(input);
            self
        }
        /// <p>Represents the auto scaling settings to be modified for a global table or global
        /// secondary index.</p>
        pub fn set_provisioned_write_capacity_auto_scaling_update(
            mut self,
            input: std::option::Option<crate::model::AutoScalingSettingsUpdate>,
        ) -> Self {
            self.provisioned_write_capacity_auto_scaling_update = input;
            self
        }
        /// Appends an item to `replica_updates`.
        ///
        /// To override the contents of this collection use [`set_replica_updates`](Self::set_replica_updates).
        ///
        /// <p>Represents the auto scaling settings of replicas of the table that will be
        /// modified.</p>
        pub fn replica_updates(
            mut self,
            input: impl Into<crate::model::ReplicaAutoScalingUpdate>,
        ) -> Self {
            let mut v = self.replica_updates.unwrap_or_default();
            v.push(input.into());
            self.replica_updates = Some(v);
            self
        }
        /// <p>Represents the auto scaling settings of replicas of the table that will be
        /// modified.</p>
        pub fn set_replica_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingUpdate>>,
        ) -> Self {
            self.replica_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTableReplicaAutoScalingInput`](crate::input::UpdateTableReplicaAutoScalingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTableReplicaAutoScalingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTableReplicaAutoScalingInput {
                global_secondary_index_updates: self.global_secondary_index_updates,
                table_name: self.table_name,
                provisioned_write_capacity_auto_scaling_update: self
                    .provisioned_write_capacity_auto_scaling_update,
                replica_updates: self.replica_updates,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTableReplicaAutoScalingInputOperationOutputAlias =
    crate::operation::UpdateTableReplicaAutoScaling;
#[doc(hidden)]
pub type UpdateTableReplicaAutoScalingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTableReplicaAutoScalingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTableReplicaAutoScaling`](crate::operation::UpdateTableReplicaAutoScaling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTableReplicaAutoScaling,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTableReplicaAutoScalingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTableReplicaAutoScalingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTableReplicaAutoScalingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateTableReplicaAutoScaling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_table_replica_auto_scaling(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTableReplicaAutoScaling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTableReplicaAutoScaling",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTableReplicaAutoScalingInput`](crate::input::UpdateTableReplicaAutoScalingInput)
    pub fn builder() -> crate::input::update_table_replica_auto_scaling_input::Builder {
        crate::input::update_table_replica_auto_scaling_input::Builder::default()
    }
}

/// See [`UpdateTimeToLiveInput`](crate::input::UpdateTimeToLiveInput)
pub mod update_time_to_live_input {
    /// A builder for [`UpdateTimeToLiveInput`](crate::input::UpdateTimeToLiveInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) time_to_live_specification:
            std::option::Option<crate::model::TimeToLiveSpecification>,
    }
    impl Builder {
        /// <p>The name of the table to be configured.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to be configured.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified
        /// table.</p>
        pub fn time_to_live_specification(
            mut self,
            input: crate::model::TimeToLiveSpecification,
        ) -> Self {
            self.time_to_live_specification = Some(input);
            self
        }
        /// <p>Represents the settings used to enable or disable Time to Live for the specified
        /// table.</p>
        pub fn set_time_to_live_specification(
            mut self,
            input: std::option::Option<crate::model::TimeToLiveSpecification>,
        ) -> Self {
            self.time_to_live_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTimeToLiveInput`](crate::input::UpdateTimeToLiveInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTimeToLiveInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTimeToLiveInput {
                table_name: self.table_name,
                time_to_live_specification: self.time_to_live_specification,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTimeToLiveInputOperationOutputAlias = crate::operation::UpdateTimeToLive;
#[doc(hidden)]
pub type UpdateTimeToLiveInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTimeToLiveInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTimeToLive`](crate::operation::UpdateTimeToLive)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTimeToLive,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTimeToLiveInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTimeToLiveInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTimeToLiveInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "DynamoDB_20120810.UpdateTimeToLive",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_time_to_live(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTimeToLive::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTimeToLive",
            "dynamodb",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTimeToLiveInput`](crate::input::UpdateTimeToLiveInput)
    pub fn builder() -> crate::input::update_time_to_live_input::Builder {
        crate::input::update_time_to_live_input::Builder::default()
    }
}

/// <p>Represents the input of an <code>UpdateTimeToLive</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTimeToLiveInput {
    /// <p>The name of the table to be configured.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Represents the settings used to enable or disable Time to Live for the specified
    /// table.</p>
    pub time_to_live_specification: std::option::Option<crate::model::TimeToLiveSpecification>,
}
impl UpdateTimeToLiveInput {
    /// <p>The name of the table to be configured.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Represents the settings used to enable or disable Time to Live for the specified
    /// table.</p>
    pub fn time_to_live_specification(
        &self,
    ) -> std::option::Option<&crate::model::TimeToLiveSpecification> {
        self.time_to_live_specification.as_ref()
    }
}
impl std::fmt::Debug for UpdateTimeToLiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTimeToLiveInput");
        formatter.field("table_name", &self.table_name);
        formatter.field(
            "time_to_live_specification",
            &self.time_to_live_specification,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableReplicaAutoScalingInput {
    /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to
    /// be updated.</p>
    pub global_secondary_index_updates:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexAutoScalingUpdate>>,
    /// <p>The name of the global table to be updated.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Represents the auto scaling settings to be modified for a global table or global
    /// secondary index.</p>
    pub provisioned_write_capacity_auto_scaling_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    /// <p>Represents the auto scaling settings of replicas of the table that will be
    /// modified.</p>
    pub replica_updates: std::option::Option<std::vec::Vec<crate::model::ReplicaAutoScalingUpdate>>,
}
impl UpdateTableReplicaAutoScalingInput {
    /// <p>Represents the auto scaling settings of the global secondary indexes of the replica to
    /// be updated.</p>
    pub fn global_secondary_index_updates(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndexAutoScalingUpdate]> {
        self.global_secondary_index_updates.as_deref()
    }
    /// <p>The name of the global table to be updated.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Represents the auto scaling settings to be modified for a global table or global
    /// secondary index.</p>
    pub fn provisioned_write_capacity_auto_scaling_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.provisioned_write_capacity_auto_scaling_update.as_ref()
    }
    /// <p>Represents the auto scaling settings of replicas of the table that will be
    /// modified.</p>
    pub fn replica_updates(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaAutoScalingUpdate]> {
        self.replica_updates.as_deref()
    }
}
impl std::fmt::Debug for UpdateTableReplicaAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableReplicaAutoScalingInput");
        formatter.field(
            "global_secondary_index_updates",
            &self.global_secondary_index_updates,
        );
        formatter.field("table_name", &self.table_name);
        formatter.field(
            "provisioned_write_capacity_auto_scaling_update",
            &self.provisioned_write_capacity_auto_scaling_update,
        );
        formatter.field("replica_updates", &self.replica_updates);
        formatter.finish()
    }
}

/// <p>Represents the input of an <code>UpdateTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableInput {
    /// <p>An array of attributes that describe the key schema for the table and indexes. If you
    /// are adding a new global secondary index to the table, <code>AttributeDefinitions</code>
    /// must include the key element(s) of the new index.</p>
    pub attribute_definitions:
        std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
    /// <p>The name of the table to be updated.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Controls how you are charged for read and write throughput and how you manage
    /// capacity. When switching from pay-per-request to provisioned capacity, initial
    /// provisioned capacity values must be set. The initial provisioned capacity values are
    /// estimated based on the consumed read and write capacity of your table and global
    /// secondary indexes over the past 30 minutes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub billing_mode: std::option::Option<crate::model::BillingMode>,
    /// <p>The new provisioned throughput settings for the specified table or index.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    /// <p>An array of one or more global secondary indexes for the table. For each index in the
    /// array, you can request one action:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Create</code> - add a new global secondary index to the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Update</code> - modify the provisioned throughput settings of an existing
    /// global secondary index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delete</code> - remove a global secondary index from the table.</p>
    /// </li>
    /// </ul>
    /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code>
    /// operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
    /// Secondary Indexes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>. </p>
    pub global_secondary_index_updates:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndexUpdate>>,
    /// <p>Represents the DynamoDB Streams configuration for the table.</p>
    /// <note>
    /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on
    /// a table that already has a stream, or if you try to disable a stream on a table that
    /// doesn't have a stream.</p>
    /// </note>
    pub stream_specification: std::option::Option<crate::model::StreamSpecification>,
    /// <p>The new server-side encryption settings for the specified table.</p>
    pub sse_specification: std::option::Option<crate::model::SseSpecification>,
    /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
    /// <note>
    /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version
    /// 2019.11.21</a> of global tables.</p>
    /// </note>
    pub replica_updates: std::option::Option<std::vec::Vec<crate::model::ReplicationGroupUpdate>>,
    /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and
    /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub table_class: std::option::Option<crate::model::TableClass>,
}
impl UpdateTableInput {
    /// <p>An array of attributes that describe the key schema for the table and indexes. If you
    /// are adding a new global secondary index to the table, <code>AttributeDefinitions</code>
    /// must include the key element(s) of the new index.</p>
    pub fn attribute_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeDefinition]> {
        self.attribute_definitions.as_deref()
    }
    /// <p>The name of the table to be updated.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Controls how you are charged for read and write throughput and how you manage
    /// capacity. When switching from pay-per-request to provisioned capacity, initial
    /// provisioned capacity values must be set. The initial provisioned capacity values are
    /// estimated based on the consumed read and write capacity of your table and global
    /// secondary indexes over the past 30 minutes.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub fn billing_mode(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode.as_ref()
    }
    /// <p>The new provisioned throughput settings for the specified table or index.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
    /// <p>An array of one or more global secondary indexes for the table. For each index in the
    /// array, you can request one action:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Create</code> - add a new global secondary index to the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Update</code> - modify the provisioned throughput settings of an existing
    /// global secondary index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delete</code> - remove a global secondary index from the table.</p>
    /// </li>
    /// </ul>
    /// <p>You can create or delete only one global secondary index per <code>UpdateTable</code>
    /// operation.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
    /// Secondary Indexes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>. </p>
    pub fn global_secondary_index_updates(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndexUpdate]> {
        self.global_secondary_index_updates.as_deref()
    }
    /// <p>Represents the DynamoDB Streams configuration for the table.</p>
    /// <note>
    /// <p>You receive a <code>ResourceInUseException</code> if you try to enable a stream on
    /// a table that already has a stream, or if you try to disable a stream on a table that
    /// doesn't have a stream.</p>
    /// </note>
    pub fn stream_specification(&self) -> std::option::Option<&crate::model::StreamSpecification> {
        self.stream_specification.as_ref()
    }
    /// <p>The new server-side encryption settings for the specified table.</p>
    pub fn sse_specification(&self) -> std::option::Option<&crate::model::SseSpecification> {
        self.sse_specification.as_ref()
    }
    /// <p>A list of replica update actions (create, delete, or update) for the table.</p>
    /// <note>
    /// <p>This property only applies to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version
    /// 2019.11.21</a> of global tables.</p>
    /// </note>
    pub fn replica_updates(&self) -> std::option::Option<&[crate::model::ReplicationGroupUpdate]> {
        self.replica_updates.as_deref()
    }
    /// <p>The table class of the table to be updated. Valid values are <code>STANDARD</code> and
    /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub fn table_class(&self) -> std::option::Option<&crate::model::TableClass> {
        self.table_class.as_ref()
    }
}
impl std::fmt::Debug for UpdateTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableInput");
        formatter.field("attribute_definitions", &self.attribute_definitions);
        formatter.field("table_name", &self.table_name);
        formatter.field("billing_mode", &self.billing_mode);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.field(
            "global_secondary_index_updates",
            &self.global_secondary_index_updates,
        );
        formatter.field("stream_specification", &self.stream_specification);
        formatter.field("sse_specification", &self.sse_specification);
        formatter.field("replica_updates", &self.replica_updates);
        formatter.field("table_class", &self.table_class);
        formatter.finish()
    }
}

/// <p>Represents the input of an <code>UpdateItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateItemInput {
    /// <p>The name of the table containing the item to update.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The primary key of the item to be updated. Each element consists of an attribute name
    /// and a value for that attribute.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub attribute_updates: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
    >,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expected: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
    /// before or after they are updated. For <code>UpdateItem</code>, the valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they
    /// appeared before the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared
    /// before the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear
    /// after the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear
    /// after the UpdateItem operation.</p>
    /// </li>
    /// </ul>
    /// <p>There is no additional cost associated with requesting a return value aside from the
    /// small network and processing overhead of receiving a larger response. No read capacity
    /// units are consumed.</p>
    /// <p>The values returned are strongly consistent.</p>
    pub return_values: std::option::Option<crate::model::ReturnValue>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub return_item_collection_metrics:
        std::option::Option<crate::model::ReturnItemCollectionMetrics>,
    /// <p>An expression that defines one or more attributes to be updated, the action to be
    /// performed on them, and new values for them.</p>
    /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
    /// these attributes already exist, they are replaced by the new values. You can
    /// also use <code>SET</code> to add or subtract from an attribute that is of type
    /// Number. For example: <code>SET myNum = myNum + :val</code>
    /// </p>
    /// <p>
    /// <code>SET</code> supports the following functions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>if_not_exists (path, operand)</code> - if the item does not
    /// contain an attribute at the specified path, then
    /// <code>if_not_exists</code> evaluates to operand; otherwise, it
    /// evaluates to path. You can use this function to avoid overwriting an
    /// attribute that may already be present in the item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>list_append (operand, operand)</code> - evaluates to a list with a
    /// new element added to it. You can append the new element to the start or
    /// the end of the list by reversing the order of the operands.</p>
    /// </li>
    /// </ul>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ADD</code> - Adds the specified value to the item, if the attribute does
    /// not already exist. If the attribute does exist, then the behavior of
    /// <code>ADD</code> depends on the data type of the attribute:</p>
    /// <ul>
    /// <li>
    /// <p>If the existing attribute is a number, and if <code>Value</code> is
    /// also a number, then <code>Value</code> is mathematically added to the
    /// existing attribute. If <code>Value</code> is a negative number, then it
    /// is subtracted from the existing attribute.</p>
    /// <note>
    /// <p>If you use <code>ADD</code> to increment or decrement a number
    /// value for an item that doesn't exist before the update, DynamoDB
    /// uses <code>0</code> as the initial value.</p>
    /// <p>Similarly, if you use <code>ADD</code> for an existing item to
    /// increment or decrement an attribute value that doesn't exist before
    /// the update, DynamoDB uses <code>0</code> as the initial value. For
    /// example, suppose that the item you want to update doesn't have an
    /// attribute named <code>itemcount</code>, but you decide to
    /// <code>ADD</code> the number <code>3</code> to this attribute
    /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
    /// set its initial value to <code>0</code>, and finally add
    /// <code>3</code> to it. The result will be a new
    /// <code>itemcount</code> attribute in the item, with a value of
    /// <code>3</code>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>If the existing data type is a set and if <code>Value</code> is also a
    /// set, then <code>Value</code> is added to the existing set. For example,
    /// if the attribute value is the set <code>[1,2]</code>, and the
    /// <code>ADD</code> action specified <code>[3]</code>, then the final
    /// attribute value is <code>[1,2,3]</code>. An error occurs if an
    /// <code>ADD</code> action is specified for a set attribute and the
    /// attribute type specified does not match the existing set type. </p>
    /// <p>Both sets must have the same primitive data type. For example, if the
    /// existing data type is a set of strings, the <code>Value</code> must also
    /// be a set of strings.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>The <code>ADD</code> action only supports Number and set data types. In
    /// addition, <code>ADD</code> can only be used on top-level attributes, not
    /// nested attributes.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE</code> - Deletes an element from a set.</p>
    /// <p>If a set of values is specified, then those values are subtracted from the old
    /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and
    /// the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final
    /// attribute value is <code>[b]</code>. Specifying an empty set is an error.</p>
    /// <important>
    /// <p>The <code>DELETE</code> action only supports set data types. In addition,
    /// <code>DELETE</code> can only be used on top-level attributes, not nested
    /// attributes.</p>
    /// </important>
    ///
    /// </li>
    /// </ul>
    /// <p>You can have many actions in a single expression, such as the following: <code>SET
    /// a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
    /// </p>
    /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
    /// Items and Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub update_expression: std::option::Option<std::string::String>,
    /// <p>A condition that must be satisfied in order for a conditional update to
    /// succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.) To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl UpdateItemInput {
    /// <p>The name of the table containing the item to update.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The primary key of the item to be updated. Each element consists of an attribute name
    /// and a value for that attribute.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>UpdateExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html">AttributeUpdates</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn attribute_updates(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValueUpdate>,
    > {
        self.attribute_updates.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expected(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    > {
        self.expected.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn conditional_operator(&self) -> std::option::Option<&crate::model::ConditionalOperator> {
        self.conditional_operator.as_ref()
    }
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appear
    /// before or after they are updated. For <code>UpdateItem</code>, the valid values
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - Returns all of the attributes of the item, as they
    /// appeared before the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_OLD</code> - Returns only the updated attributes, as they appeared
    /// before the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_NEW</code> - Returns all of the attributes of the item, as they appear
    /// after the UpdateItem operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATED_NEW</code> - Returns only the updated attributes, as they appear
    /// after the UpdateItem operation.</p>
    /// </li>
    /// </ul>
    /// <p>There is no additional cost associated with requesting a return value aside from the
    /// small network and processing overhead of receiving a larger response. No read capacity
    /// units are consumed.</p>
    /// <p>The values returned are strongly consistent.</p>
    pub fn return_values(&self) -> std::option::Option<&crate::model::ReturnValue> {
        self.return_values.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub fn return_item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ReturnItemCollectionMetrics> {
        self.return_item_collection_metrics.as_ref()
    }
    /// <p>An expression that defines one or more attributes to be updated, the action to be
    /// performed on them, and new values for them.</p>
    /// <p>The following action values are available for <code>UpdateExpression</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SET</code> - Adds one or more attributes and values to an item. If any of
    /// these attributes already exist, they are replaced by the new values. You can
    /// also use <code>SET</code> to add or subtract from an attribute that is of type
    /// Number. For example: <code>SET myNum = myNum + :val</code>
    /// </p>
    /// <p>
    /// <code>SET</code> supports the following functions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>if_not_exists (path, operand)</code> - if the item does not
    /// contain an attribute at the specified path, then
    /// <code>if_not_exists</code> evaluates to operand; otherwise, it
    /// evaluates to path. You can use this function to avoid overwriting an
    /// attribute that may already be present in the item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>list_append (operand, operand)</code> - evaluates to a list with a
    /// new element added to it. You can append the new element to the start or
    /// the end of the list by reversing the order of the operands.</p>
    /// </li>
    /// </ul>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REMOVE</code> - Removes one or more attributes from an item.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ADD</code> - Adds the specified value to the item, if the attribute does
    /// not already exist. If the attribute does exist, then the behavior of
    /// <code>ADD</code> depends on the data type of the attribute:</p>
    /// <ul>
    /// <li>
    /// <p>If the existing attribute is a number, and if <code>Value</code> is
    /// also a number, then <code>Value</code> is mathematically added to the
    /// existing attribute. If <code>Value</code> is a negative number, then it
    /// is subtracted from the existing attribute.</p>
    /// <note>
    /// <p>If you use <code>ADD</code> to increment or decrement a number
    /// value for an item that doesn't exist before the update, DynamoDB
    /// uses <code>0</code> as the initial value.</p>
    /// <p>Similarly, if you use <code>ADD</code> for an existing item to
    /// increment or decrement an attribute value that doesn't exist before
    /// the update, DynamoDB uses <code>0</code> as the initial value. For
    /// example, suppose that the item you want to update doesn't have an
    /// attribute named <code>itemcount</code>, but you decide to
    /// <code>ADD</code> the number <code>3</code> to this attribute
    /// anyway. DynamoDB will create the <code>itemcount</code> attribute,
    /// set its initial value to <code>0</code>, and finally add
    /// <code>3</code> to it. The result will be a new
    /// <code>itemcount</code> attribute in the item, with a value of
    /// <code>3</code>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>If the existing data type is a set and if <code>Value</code> is also a
    /// set, then <code>Value</code> is added to the existing set. For example,
    /// if the attribute value is the set <code>[1,2]</code>, and the
    /// <code>ADD</code> action specified <code>[3]</code>, then the final
    /// attribute value is <code>[1,2,3]</code>. An error occurs if an
    /// <code>ADD</code> action is specified for a set attribute and the
    /// attribute type specified does not match the existing set type. </p>
    /// <p>Both sets must have the same primitive data type. For example, if the
    /// existing data type is a set of strings, the <code>Value</code> must also
    /// be a set of strings.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>The <code>ADD</code> action only supports Number and set data types. In
    /// addition, <code>ADD</code> can only be used on top-level attributes, not
    /// nested attributes.</p>
    /// </important>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE</code> - Deletes an element from a set.</p>
    /// <p>If a set of values is specified, then those values are subtracted from the old
    /// set. For example, if the attribute value was the set <code>[a,b,c]</code> and
    /// the <code>DELETE</code> action specifies <code>[a,c]</code>, then the final
    /// attribute value is <code>[b]</code>. Specifying an empty set is an error.</p>
    /// <important>
    /// <p>The <code>DELETE</code> action only supports set data types. In addition,
    /// <code>DELETE</code> can only be used on top-level attributes, not nested
    /// attributes.</p>
    /// </important>
    ///
    /// </li>
    /// </ul>
    /// <p>You can have many actions in a single expression, such as the following: <code>SET
    /// a=:value1, b=:value2 DELETE :value3, :value4, :value5</code>
    /// </p>
    /// <p>For more information on update expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html">Modifying
    /// Items and Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn update_expression(&self) -> std::option::Option<&str> {
        self.update_expression.as_deref()
    }
    /// <p>A condition that must be satisfied in order for a conditional update to
    /// succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.) To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
}
impl std::fmt::Debug for UpdateItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateItemInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("key", &self.key);
        formatter.field("attribute_updates", &self.attribute_updates);
        formatter.field("expected", &self.expected);
        formatter.field("conditional_operator", &self.conditional_operator);
        formatter.field("return_values", &self.return_values);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field(
            "return_item_collection_metrics",
            &self.return_item_collection_metrics,
        );
        formatter.field("update_expression", &self.update_expression);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalTableSettingsInput {
    /// <p>The name of the global table</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not
    /// specified, the global table defaults to <code>PROVISIONED</code> capacity billing
    /// mode.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub global_table_billing_mode: std::option::Option<crate::model::BillingMode>,
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a
    /// <code>ThrottlingException.</code>
    /// </p>
    pub global_table_provisioned_write_capacity_units: std::option::Option<i64>,
    /// <p>Auto scaling settings for managing provisioned write capacity for the global
    /// table.</p>
    pub global_table_provisioned_write_capacity_auto_scaling_settings_update:
        std::option::Option<crate::model::AutoScalingSettingsUpdate>,
    /// <p>Represents the settings of a global secondary index for a global table that will be
    /// modified.</p>
    pub global_table_global_secondary_index_settings_update: std::option::Option<
        std::vec::Vec<crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate>,
    >,
    /// <p>Represents the settings for a global table in a Region that will be modified.</p>
    pub replica_settings_update:
        std::option::Option<std::vec::Vec<crate::model::ReplicaSettingsUpdate>>,
}
impl UpdateGlobalTableSettingsInput {
    /// <p>The name of the global table</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not
    /// specified, the global table defaults to <code>PROVISIONED</code> capacity billing
    /// mode.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub fn global_table_billing_mode(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.global_table_billing_mode.as_ref()
    }
    /// <p>The maximum number of writes consumed per second before DynamoDB returns a
    /// <code>ThrottlingException.</code>
    /// </p>
    pub fn global_table_provisioned_write_capacity_units(&self) -> std::option::Option<i64> {
        self.global_table_provisioned_write_capacity_units
    }
    /// <p>Auto scaling settings for managing provisioned write capacity for the global
    /// table.</p>
    pub fn global_table_provisioned_write_capacity_auto_scaling_settings_update(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingSettingsUpdate> {
        self.global_table_provisioned_write_capacity_auto_scaling_settings_update
            .as_ref()
    }
    /// <p>Represents the settings of a global secondary index for a global table that will be
    /// modified.</p>
    pub fn global_table_global_secondary_index_settings_update(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalTableGlobalSecondaryIndexSettingsUpdate]> {
        self.global_table_global_secondary_index_settings_update
            .as_deref()
    }
    /// <p>Represents the settings for a global table in a Region that will be modified.</p>
    pub fn replica_settings_update(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicaSettingsUpdate]> {
        self.replica_settings_update.as_deref()
    }
}
impl std::fmt::Debug for UpdateGlobalTableSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalTableSettingsInput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("global_table_billing_mode", &self.global_table_billing_mode);
        formatter.field(
            "global_table_provisioned_write_capacity_units",
            &self.global_table_provisioned_write_capacity_units,
        );
        formatter.field(
            "global_table_provisioned_write_capacity_auto_scaling_settings_update",
            &self.global_table_provisioned_write_capacity_auto_scaling_settings_update,
        );
        formatter.field(
            "global_table_global_secondary_index_settings_update",
            &self.global_table_global_secondary_index_settings_update,
        );
        formatter.field("replica_settings_update", &self.replica_settings_update);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGlobalTableInput {
    /// <p>The global table name.</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>A list of Regions that should be added or removed from the global table.</p>
    pub replica_updates: std::option::Option<std::vec::Vec<crate::model::ReplicaUpdate>>,
}
impl UpdateGlobalTableInput {
    /// <p>The global table name.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>A list of Regions that should be added or removed from the global table.</p>
    pub fn replica_updates(&self) -> std::option::Option<&[crate::model::ReplicaUpdate]> {
        self.replica_updates.as_deref()
    }
}
impl std::fmt::Debug for UpdateGlobalTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGlobalTableInput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("replica_updates", &self.replica_updates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContributorInsightsInput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The global secondary index name, if applicable.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Represents the contributor insights action.</p>
    pub contributor_insights_action: std::option::Option<crate::model::ContributorInsightsAction>,
}
impl UpdateContributorInsightsInput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The global secondary index name, if applicable.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Represents the contributor insights action.</p>
    pub fn contributor_insights_action(
        &self,
    ) -> std::option::Option<&crate::model::ContributorInsightsAction> {
        self.contributor_insights_action.as_ref()
    }
}
impl std::fmt::Debug for UpdateContributorInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContributorInsightsInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field(
            "contributor_insights_action",
            &self.contributor_insights_action,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContinuousBackupsInput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Represents the settings used to enable point in time recovery.</p>
    pub point_in_time_recovery_specification:
        std::option::Option<crate::model::PointInTimeRecoverySpecification>,
}
impl UpdateContinuousBackupsInput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Represents the settings used to enable point in time recovery.</p>
    pub fn point_in_time_recovery_specification(
        &self,
    ) -> std::option::Option<&crate::model::PointInTimeRecoverySpecification> {
        self.point_in_time_recovery_specification.as_ref()
    }
}
impl std::fmt::Debug for UpdateContinuousBackupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContinuousBackupsInput");
        formatter.field("table_name", &self.table_name);
        formatter.field(
            "point_in_time_recovery_specification",
            &self.point_in_time_recovery_specification,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
    /// Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
    /// will be removed from the DynamoDB resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The DynamoDB resource that the tags will be removed from. This value is an Amazon
    /// Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys. Existing tags of the resource whose keys are members of this list
    /// will be removed from the DynamoDB resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactWriteItemsInput {
    /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
    /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
    /// <code>Delete</code> object. These can operate on items in different tables, but the
    /// tables must reside in the same Amazon Web Services account and Region, and no two of them
    /// can operate on the same item. </p>
    pub transact_items: std::option::Option<std::vec::Vec<crate::model::TransactWriteItem>>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections (if any), that were modified
    /// during the operation and are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned. </p>
    pub return_item_collection_metrics:
        std::option::Option<crate::model::ReturnItemCollectionMetrics>,
    /// <p>Providing a <code>ClientRequestToken</code> makes the call to
    /// <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls
    /// have the same effect as one single call.</p>
    /// <p>Although multiple identical calls using the same client request token produce the same
    /// result on the server (no side effects), the responses to the calls might not be the
    /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
    /// <code>TransactWriteItems</code> call returns the amount of write capacity units
    /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
    /// the same client token return the number of read capacity units consumed in reading the
    /// item.</p>
    /// <p>A client request token is valid for 10 minutes after the first request that uses it is
    /// completed. After 10 minutes, any request with the same client token is treated as a new
    /// request. Do not resubmit the same request with the same client token for more than 10
    /// minutes, or the result might not be idempotent.</p>
    /// <p>If you submit a request with the same client token but a change in other parameters
    /// within the 10-minute idempotency window, DynamoDB returns an
    /// <code>IdempotentParameterMismatch</code> exception.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl TransactWriteItemsInput {
    /// <p>An ordered array of up to 25 <code>TransactWriteItem</code> objects, each of which
    /// contains a <code>ConditionCheck</code>, <code>Put</code>, <code>Update</code>, or
    /// <code>Delete</code> object. These can operate on items in different tables, but the
    /// tables must reside in the same Amazon Web Services account and Region, and no two of them
    /// can operate on the same item. </p>
    pub fn transact_items(&self) -> std::option::Option<&[crate::model::TransactWriteItem]> {
        self.transact_items.as_deref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections (if any), that were modified
    /// during the operation and are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned. </p>
    pub fn return_item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ReturnItemCollectionMetrics> {
        self.return_item_collection_metrics.as_ref()
    }
    /// <p>Providing a <code>ClientRequestToken</code> makes the call to
    /// <code>TransactWriteItems</code> idempotent, meaning that multiple identical calls
    /// have the same effect as one single call.</p>
    /// <p>Although multiple identical calls using the same client request token produce the same
    /// result on the server (no side effects), the responses to the calls might not be the
    /// same. If the <code>ReturnConsumedCapacity></code> parameter is set, then the initial
    /// <code>TransactWriteItems</code> call returns the amount of write capacity units
    /// consumed in making the changes. Subsequent <code>TransactWriteItems</code> calls with
    /// the same client token return the number of read capacity units consumed in reading the
    /// item.</p>
    /// <p>A client request token is valid for 10 minutes after the first request that uses it is
    /// completed. After 10 minutes, any request with the same client token is treated as a new
    /// request. Do not resubmit the same request with the same client token for more than 10
    /// minutes, or the result might not be idempotent.</p>
    /// <p>If you submit a request with the same client token but a change in other parameters
    /// within the 10-minute idempotency window, DynamoDB returns an
    /// <code>IdempotentParameterMismatch</code> exception.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for TransactWriteItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactWriteItemsInput");
        formatter.field("transact_items", &self.transact_items);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field(
            "return_item_collection_metrics",
            &self.return_item_collection_metrics,
        );
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransactGetItemsInput {
    /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which
    /// contains a <code>Get</code> structure.</p>
    pub transact_items: std::option::Option<std::vec::Vec<crate::model::TransactGetItem>>,
    /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and
    /// a value of <code>NONE</code> prevents that information from being returned. No other
    /// value is valid.</p>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
}
impl TransactGetItemsInput {
    /// <p>An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which
    /// contains a <code>Get</code> structure.</p>
    pub fn transact_items(&self) -> std::option::Option<&[crate::model::TransactGetItem]> {
        self.transact_items.as_deref()
    }
    /// <p>A value of <code>TOTAL</code> causes consumed capacity information to be returned, and
    /// a value of <code>NONE</code> prevents that information from being returned. No other
    /// value is valid.</p>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for TransactGetItemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransactGetItemsInput");
        formatter.field("transact_items", &self.transact_items);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is
    /// an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>Identifies the Amazon DynamoDB resource to which tags should be added. This value is
    /// an Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to be assigned to the Amazon DynamoDB resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>Scan</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanInput {
    /// <p>The name of the table containing the requested items; or, if you provide
    /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of a secondary index to scan. This index can be any local secondary index or
    /// global secondary index. Note that if you use the <code>IndexName</code> parameter, you
    /// must also provide <code>TableName</code>.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to evaluate (not necessarily the number of matching
    /// items). If DynamoDB processes the number of items up to the limit while processing the
    /// results, it stops the operation and returns the matching values up to that point, and a
    /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
    /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
    /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
    /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
    /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
    /// specific item attributes, the count of matching items, or in the case of an index, some
    /// or all of the attributes projected into the index.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
    /// specified table or index. If you query a local secondary index, then for each
    /// matching item in the index, DynamoDB fetches the entire item from the parent
    /// table. If the index is configured to project all item attributes, then all of
    /// the data can be obtained from the local secondary index, and no fetching is
    /// required.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
    /// Retrieves all attributes that have been projected into the index. If the index
    /// is configured to project all attributes, this return value is equivalent to
    /// specifying <code>ALL_ATTRIBUTES</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COUNT</code> - Returns the number of matching items, rather than the
    /// matching items themselves.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
    /// <code>AttributesToGet</code>. This return value is equivalent to specifying
    /// <code>AttributesToGet</code> without specifying any value for
    /// <code>Select</code>.</p>
    /// <p>If you query or scan a local secondary index and request only attributes that
    /// are projected into that index, the operation reads only the index and not the
    /// table. If any of the requested attributes are not projected into the local
    /// secondary index, DynamoDB fetches each of these attributes from the parent
    /// table. This extra fetching incurs additional throughput cost and latency.</p>
    /// <p>If you query or scan a global secondary index, you can only request attributes
    /// that are projected into the index. Global secondary index queries cannot fetch
    /// attributes from the parent table.</p>
    /// </li>
    /// </ul>
    /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
    /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
    /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
    /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
    /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
    /// <code>Select</code>.)</p>
    /// <note>
    /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
    /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
    /// value for <code>Select</code> will return an error.</p>
    /// </note>
    pub select: std::option::Option<crate::model::Select>,
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub scan_filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Condition>,
    >,
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
    /// <p>The primary key of the first item that this operation will evaluate. Use the value
    /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
    /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No
    /// set data types are allowed.</p>
    /// <p>In a parallel scan, a <code>Scan</code> request that includes
    /// <code>ExclusiveStartKey</code> must specify the same segment whose previous
    /// <code>Scan</code> returned the corresponding value of
    /// <code>LastEvaluatedKey</code>.</p>
    pub exclusive_start_key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the
    /// total number of segments into which the <code>Scan</code> operation will be divided. The
    /// value of <code>TotalSegments</code> corresponds to the number of application workers
    /// that will perform the parallel scan. For example, if you want to use four application
    /// threads to scan a table or an index, specify a <code>TotalSegments</code> value of
    /// 4.</p>
    /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less
    /// than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the
    /// <code>Scan</code> operation will be sequential rather than parallel.</p>
    /// <p>If you specify <code>TotalSegments</code>, you must also specify
    /// <code>Segment</code>.</p>
    pub total_segments: std::option::Option<i32>,
    /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an
    /// individual segment to be scanned by an application worker.</p>
    /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want
    /// to use four application threads to scan a table or an index, then the first thread
    /// specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so
    /// on.</p>
    /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code>
    /// request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a
    /// subsequent <code>Scan</code> operation.</p>
    /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than
    /// the value provided for <code>TotalSegments</code>.</p>
    /// <p>If you provide <code>Segment</code>, you must also provide
    /// <code>TotalSegments</code>.</p>
    pub segment: std::option::Option<i32>,
    /// <p>A string that identifies one or more attributes to retrieve from the specified table
    /// or index. These attributes can include scalars, sets, or elements of a JSON document.
    /// The attributes in the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of
    /// the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub projection_expression: std::option::Option<std::string::String>,
    /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code>
    /// operation, but before the data is returned to you. Items that do not satisfy the
    /// <code>FilterExpression</code> criteria are not returned.</p>
    /// <note>
    /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
    /// the process of filtering does not consume any additional read capacity units.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
    /// Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>A Boolean value that determines the read consistency model during the scan:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned
    /// from <code>Scan</code> might not contain the results from other recently
    /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
    /// <code>DeleteItem</code>).</p>
    /// </li>
    /// <li>
    /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write
    /// operations that completed before the <code>Scan</code> began are guaranteed to
    /// be contained in the <code>Scan</code> response.</p>
    /// </li>
    /// </ul>
    /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
    /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary
    /// indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to
    /// true, you will receive a <code>ValidationException</code>.</p>
    pub consistent_read: std::option::Option<bool>,
}
impl ScanInput {
    /// <p>The name of the table containing the requested items; or, if you provide
    /// <code>IndexName</code>, the name of the table to which that index belongs.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of a secondary index to scan. This index can be any local secondary index or
    /// global secondary index. Note that if you use the <code>IndexName</code> parameter, you
    /// must also provide <code>TableName</code>.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn attributes_to_get(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes_to_get.as_deref()
    }
    /// <p>The maximum number of items to evaluate (not necessarily the number of matching
    /// items). If DynamoDB processes the number of items up to the limit while processing the
    /// results, it stops the operation and returns the matching values up to that point, and a
    /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
    /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
    /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
    /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
    /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Working with Queries</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
    /// specific item attributes, the count of matching items, or in the case of an index, some
    /// or all of the attributes projected into the index.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
    /// specified table or index. If you query a local secondary index, then for each
    /// matching item in the index, DynamoDB fetches the entire item from the parent
    /// table. If the index is configured to project all item attributes, then all of
    /// the data can be obtained from the local secondary index, and no fetching is
    /// required.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
    /// Retrieves all attributes that have been projected into the index. If the index
    /// is configured to project all attributes, this return value is equivalent to
    /// specifying <code>ALL_ATTRIBUTES</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COUNT</code> - Returns the number of matching items, rather than the
    /// matching items themselves.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
    /// <code>AttributesToGet</code>. This return value is equivalent to specifying
    /// <code>AttributesToGet</code> without specifying any value for
    /// <code>Select</code>.</p>
    /// <p>If you query or scan a local secondary index and request only attributes that
    /// are projected into that index, the operation reads only the index and not the
    /// table. If any of the requested attributes are not projected into the local
    /// secondary index, DynamoDB fetches each of these attributes from the parent
    /// table. This extra fetching incurs additional throughput cost and latency.</p>
    /// <p>If you query or scan a global secondary index, you can only request attributes
    /// that are projected into the index. Global secondary index queries cannot fetch
    /// attributes from the parent table.</p>
    /// </li>
    /// </ul>
    /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
    /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
    /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
    /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
    /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
    /// <code>Select</code>.)</p>
    /// <note>
    /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
    /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
    /// value for <code>Select</code> will return an error.</p>
    /// </note>
    pub fn select(&self) -> std::option::Option<&crate::model::Select> {
        self.select.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html">ScanFilter</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn scan_filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Condition>>
    {
        self.scan_filter.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn conditional_operator(&self) -> std::option::Option<&crate::model::ConditionalOperator> {
        self.conditional_operator.as_ref()
    }
    /// <p>The primary key of the first item that this operation will evaluate. Use the value
    /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
    /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number or Binary. No
    /// set data types are allowed.</p>
    /// <p>In a parallel scan, a <code>Scan</code> request that includes
    /// <code>ExclusiveStartKey</code> must specify the same segment whose previous
    /// <code>Scan</code> returned the corresponding value of
    /// <code>LastEvaluatedKey</code>.</p>
    pub fn exclusive_start_key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.exclusive_start_key.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>For a parallel <code>Scan</code> request, <code>TotalSegments</code> represents the
    /// total number of segments into which the <code>Scan</code> operation will be divided. The
    /// value of <code>TotalSegments</code> corresponds to the number of application workers
    /// that will perform the parallel scan. For example, if you want to use four application
    /// threads to scan a table or an index, specify a <code>TotalSegments</code> value of
    /// 4.</p>
    /// <p>The value for <code>TotalSegments</code> must be greater than or equal to 1, and less
    /// than or equal to 1000000. If you specify a <code>TotalSegments</code> value of 1, the
    /// <code>Scan</code> operation will be sequential rather than parallel.</p>
    /// <p>If you specify <code>TotalSegments</code>, you must also specify
    /// <code>Segment</code>.</p>
    pub fn total_segments(&self) -> std::option::Option<i32> {
        self.total_segments
    }
    /// <p>For a parallel <code>Scan</code> request, <code>Segment</code> identifies an
    /// individual segment to be scanned by an application worker.</p>
    /// <p>Segment IDs are zero-based, so the first segment is always 0. For example, if you want
    /// to use four application threads to scan a table or an index, then the first thread
    /// specifies a <code>Segment</code> value of 0, the second thread specifies 1, and so
    /// on.</p>
    /// <p>The value of <code>LastEvaluatedKey</code> returned from a parallel <code>Scan</code>
    /// request must be used as <code>ExclusiveStartKey</code> with the same segment ID in a
    /// subsequent <code>Scan</code> operation.</p>
    /// <p>The value for <code>Segment</code> must be greater than or equal to 0, and less than
    /// the value provided for <code>TotalSegments</code>.</p>
    /// <p>If you provide <code>Segment</code>, you must also provide
    /// <code>TotalSegments</code>.</p>
    pub fn segment(&self) -> std::option::Option<i32> {
        self.segment
    }
    /// <p>A string that identifies one or more attributes to retrieve from the specified table
    /// or index. These attributes can include scalars, sets, or elements of a JSON document.
    /// The attributes in the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of
    /// the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn projection_expression(&self) -> std::option::Option<&str> {
        self.projection_expression.as_deref()
    }
    /// <p>A string that contains conditions that DynamoDB applies after the <code>Scan</code>
    /// operation, but before the data is returned to you. Items that do not satisfy the
    /// <code>FilterExpression</code> criteria are not returned.</p>
    /// <note>
    /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
    /// the process of filtering does not consume any additional read capacity units.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
    /// Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <code>ProductStatus</code> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
    /// <p>A Boolean value that determines the read consistency model during the scan:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>ConsistentRead</code> is <code>false</code>, then the data returned
    /// from <code>Scan</code> might not contain the results from other recently
    /// completed write operations (<code>PutItem</code>, <code>UpdateItem</code>, or
    /// <code>DeleteItem</code>).</p>
    /// </li>
    /// <li>
    /// <p>If <code>ConsistentRead</code> is <code>true</code>, then all of the write
    /// operations that completed before the <code>Scan</code> began are guaranteed to
    /// be contained in the <code>Scan</code> response.</p>
    /// </li>
    /// </ul>
    /// <p>The default setting for <code>ConsistentRead</code> is <code>false</code>.</p>
    /// <p>The <code>ConsistentRead</code> parameter is not supported on global secondary
    /// indexes. If you scan a global secondary index with <code>ConsistentRead</code> set to
    /// true, you will receive a <code>ValidationException</code>.</p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
}
impl std::fmt::Debug for ScanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field("attributes_to_get", &self.attributes_to_get);
        formatter.field("limit", &self.limit);
        formatter.field("select", &self.select);
        formatter.field("scan_filter", &self.scan_filter);
        formatter.field("conditional_operator", &self.conditional_operator);
        formatter.field("exclusive_start_key", &self.exclusive_start_key);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field("total_segments", &self.total_segments);
        formatter.field("segment", &self.segment);
        formatter.field("projection_expression", &self.projection_expression);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.field("consistent_read", &self.consistent_read);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableToPointInTimeInput {
    /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name
    /// (ARN).</p>
    pub source_table_arn: std::option::Option<std::string::String>,
    /// <p>Name of the source table that is being restored.</p>
    pub source_table_name: std::option::Option<std::string::String>,
    /// <p>The name of the new table to which it must be restored to.</p>
    pub target_table_name: std::option::Option<std::string::String>,
    /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
    /// is typically 5 minutes before the current time. </p>
    pub use_latest_restorable_time: std::option::Option<bool>,
    /// <p>Time in the past to restore the table to.</p>
    pub restore_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The billing mode of the restored table.</p>
    pub billing_mode_override: std::option::Option<crate::model::BillingMode>,
    /// <p>List of global secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub global_secondary_index_override:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
    /// <p>List of local secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub local_secondary_index_override:
        std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
    /// <p>Provisioned throughput settings for the restored table.</p>
    pub provisioned_throughput_override: std::option::Option<crate::model::ProvisionedThroughput>,
    /// <p>The new server-side encryption settings for the restored table.</p>
    pub sse_specification_override: std::option::Option<crate::model::SseSpecification>,
}
impl RestoreTableToPointInTimeInput {
    /// <p>The DynamoDB table that will be restored. This value is an Amazon Resource Name
    /// (ARN).</p>
    pub fn source_table_arn(&self) -> std::option::Option<&str> {
        self.source_table_arn.as_deref()
    }
    /// <p>Name of the source table that is being restored.</p>
    pub fn source_table_name(&self) -> std::option::Option<&str> {
        self.source_table_name.as_deref()
    }
    /// <p>The name of the new table to which it must be restored to.</p>
    pub fn target_table_name(&self) -> std::option::Option<&str> {
        self.target_table_name.as_deref()
    }
    /// <p>Restore the table to the latest possible time. <code>LatestRestorableDateTime</code>
    /// is typically 5 minutes before the current time. </p>
    pub fn use_latest_restorable_time(&self) -> std::option::Option<bool> {
        self.use_latest_restorable_time
    }
    /// <p>Time in the past to restore the table to.</p>
    pub fn restore_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.restore_date_time.as_ref()
    }
    /// <p>The billing mode of the restored table.</p>
    pub fn billing_mode_override(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode_override.as_ref()
    }
    /// <p>List of global secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub fn global_secondary_index_override(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndex]> {
        self.global_secondary_index_override.as_deref()
    }
    /// <p>List of local secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub fn local_secondary_index_override(
        &self,
    ) -> std::option::Option<&[crate::model::LocalSecondaryIndex]> {
        self.local_secondary_index_override.as_deref()
    }
    /// <p>Provisioned throughput settings for the restored table.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput_override.as_ref()
    }
    /// <p>The new server-side encryption settings for the restored table.</p>
    pub fn sse_specification_override(
        &self,
    ) -> std::option::Option<&crate::model::SseSpecification> {
        self.sse_specification_override.as_ref()
    }
}
impl std::fmt::Debug for RestoreTableToPointInTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableToPointInTimeInput");
        formatter.field("source_table_arn", &self.source_table_arn);
        formatter.field("source_table_name", &self.source_table_name);
        formatter.field("target_table_name", &self.target_table_name);
        formatter.field(
            "use_latest_restorable_time",
            &self.use_latest_restorable_time,
        );
        formatter.field("restore_date_time", &self.restore_date_time);
        formatter.field("billing_mode_override", &self.billing_mode_override);
        formatter.field(
            "global_secondary_index_override",
            &self.global_secondary_index_override,
        );
        formatter.field(
            "local_secondary_index_override",
            &self.local_secondary_index_override,
        );
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.field(
            "sse_specification_override",
            &self.sse_specification_override,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableFromBackupInput {
    /// <p>The name of the new table to which the backup must be restored.</p>
    pub target_table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    pub backup_arn: std::option::Option<std::string::String>,
    /// <p>The billing mode of the restored table.</p>
    pub billing_mode_override: std::option::Option<crate::model::BillingMode>,
    /// <p>List of global secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub global_secondary_index_override:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
    /// <p>List of local secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub local_secondary_index_override:
        std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
    /// <p>Provisioned throughput settings for the restored table.</p>
    pub provisioned_throughput_override: std::option::Option<crate::model::ProvisionedThroughput>,
    /// <p>The new server-side encryption settings for the restored table.</p>
    pub sse_specification_override: std::option::Option<crate::model::SseSpecification>,
}
impl RestoreTableFromBackupInput {
    /// <p>The name of the new table to which the backup must be restored.</p>
    pub fn target_table_name(&self) -> std::option::Option<&str> {
        self.target_table_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    pub fn backup_arn(&self) -> std::option::Option<&str> {
        self.backup_arn.as_deref()
    }
    /// <p>The billing mode of the restored table.</p>
    pub fn billing_mode_override(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode_override.as_ref()
    }
    /// <p>List of global secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub fn global_secondary_index_override(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndex]> {
        self.global_secondary_index_override.as_deref()
    }
    /// <p>List of local secondary indexes for the restored table. The indexes provided should
    /// match existing secondary indexes. You can choose to exclude some or all of the indexes
    /// at the time of restore.</p>
    pub fn local_secondary_index_override(
        &self,
    ) -> std::option::Option<&[crate::model::LocalSecondaryIndex]> {
        self.local_secondary_index_override.as_deref()
    }
    /// <p>Provisioned throughput settings for the restored table.</p>
    pub fn provisioned_throughput_override(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput_override.as_ref()
    }
    /// <p>The new server-side encryption settings for the restored table.</p>
    pub fn sse_specification_override(
        &self,
    ) -> std::option::Option<&crate::model::SseSpecification> {
        self.sse_specification_override.as_ref()
    }
}
impl std::fmt::Debug for RestoreTableFromBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableFromBackupInput");
        formatter.field("target_table_name", &self.target_table_name);
        formatter.field("backup_arn", &self.backup_arn);
        formatter.field("billing_mode_override", &self.billing_mode_override);
        formatter.field(
            "global_secondary_index_override",
            &self.global_secondary_index_override,
        );
        formatter.field(
            "local_secondary_index_override",
            &self.local_secondary_index_override,
        );
        formatter.field(
            "provisioned_throughput_override",
            &self.provisioned_throughput_override,
        );
        formatter.field(
            "sse_specification_override",
            &self.sse_specification_override,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>Query</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryInput {
    /// <p>The name of the table containing the requested items.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of an index to query. This index can be any local secondary index or global
    /// secondary index on the table. Note that if you use the <code>IndexName</code> parameter,
    /// you must also provide <code>TableName.</code>
    /// </p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
    /// specific item attributes, the count of matching items, or in the case of an index, some
    /// or all of the attributes projected into the index.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
    /// specified table or index. If you query a local secondary index, then for each
    /// matching item in the index, DynamoDB fetches the entire item from the parent
    /// table. If the index is configured to project all item attributes, then all of
    /// the data can be obtained from the local secondary index, and no fetching is
    /// required.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
    /// Retrieves all attributes that have been projected into the index. If the index
    /// is configured to project all attributes, this return value is equivalent to
    /// specifying <code>ALL_ATTRIBUTES</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COUNT</code> - Returns the number of matching items, rather than the
    /// matching items themselves.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
    /// <code>AttributesToGet</code>. This return value is equivalent to specifying
    /// <code>AttributesToGet</code> without specifying any value for
    /// <code>Select</code>.</p>
    /// <p>If you query or scan a local secondary index and request only attributes that
    /// are projected into that index, the operation will read only the index and not
    /// the table. If any of the requested attributes are not projected into the local
    /// secondary index, DynamoDB fetches each of these attributes from the parent
    /// table. This extra fetching incurs additional throughput cost and latency.</p>
    /// <p>If you query or scan a global secondary index, you can only request attributes
    /// that are projected into the index. Global secondary index queries cannot fetch
    /// attributes from the parent table.</p>
    /// </li>
    /// </ul>
    /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
    /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
    /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
    /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
    /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
    /// <code>Select</code>.)</p>
    /// <note>
    /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
    /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
    /// value for <code>Select</code> will return an error.</p>
    /// </note>
    pub select: std::option::Option<crate::model::Select>,
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to evaluate (not necessarily the number of matching
    /// items). If DynamoDB processes the number of items up to the limit while processing the
    /// results, it stops the operation and returns the matching values up to that point, and a
    /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
    /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
    /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
    /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
    /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
    /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
    /// reads.</p>
    /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query
    /// a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you
    /// will receive a <code>ValidationException</code>.</p>
    pub consistent_read: std::option::Option<bool>,
    /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub key_conditions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Condition>,
    >,
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub query_filter: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Condition>,
    >,
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
    /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal
    /// is performed in ascending order; if <code>false</code>, the traversal is performed in
    /// descending order. </p>
    /// <p>Items with the same partition key value are stored in sorted order by sort key. If the
    /// sort key data type is Number, the results are stored in numeric order. For type String,
    /// the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each
    /// byte of the binary data as unsigned.</p>
    /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in
    /// the order in which they are stored (by sort key value). This is the default behavior. If
    /// <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in
    /// reverse order by sort key value, and then returns the results to the client.</p>
    pub scan_index_forward: std::option::Option<bool>,
    /// <p>The primary key of the first item that this operation will evaluate. Use the value
    /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
    /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
    /// set data types are allowed.</p>
    pub exclusive_start_key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>A string that identifies one or more attributes to retrieve from the table. These
    /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
    /// the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of
    /// the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub projection_expression: std::option::Option<std::string::String>,
    /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code>
    /// operation, but before the data is returned to you. Items that do not satisfy the
    /// <code>FilterExpression</code> criteria are not returned.</p>
    /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a
    /// filter expression based on a partition key or a sort key.</p>
    /// <note>
    /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
    /// the process of filtering does not consume any additional read capacity units.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
    /// Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub filter_expression: std::option::Option<std::string::String>,
    /// <p>The condition that specifies the key values for items to be retrieved by the
    /// <code>Query</code> action.</p>
    ///
    /// <p>The condition must perform an equality test on a single partition key value.</p>
    /// <p>The condition can optionally perform one of several comparison tests on a single sort
    /// key value. This allows <code>Query</code> to retrieve one item with a given partition
    /// key value and sort key value, or several items that have the same partition key value
    /// but different sort key values.</p>
    ///
    /// <p>The partition key equality test is required, and must be specified in the following
    /// format:</p>
    ///
    /// <p>
    /// <code>partitionKeyName</code>
    /// <i>=</i>
    /// <code>:partitionkeyval</code>
    /// </p>
    ///
    /// <p>If you also want to provide a condition for the sort key, it must be combined using
    /// <code>AND</code> with the condition for the sort key. Following is an example, using
    /// the <b>=</b> comparison operator for the sort key:</p>
    ///
    /// <p>
    /// <code>partitionKeyName</code>
    /// <code>=</code>
    /// <code>:partitionkeyval</code>
    /// <code>AND</code>
    /// <code>sortKeyName</code>
    /// <code>=</code>
    /// <code>:sortkeyval</code>
    /// </p>
    /// <p>Valid comparisons for the sort key condition are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>=</code>
    /// <code>:sortkeyval</code> - true if the sort key value is equal to
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code><</code>
    /// <code>:sortkeyval</code> - true if the sort key value is less than
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code><=</code>
    /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>></code>
    /// <code>:sortkeyval</code> - true if the sort key value is greater than
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>>= </code>
    /// <code>:sortkeyval</code> - true if the sort key value is greater than or equal
    /// to <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>BETWEEN</code>
    /// <code>:sortkeyval1</code>
    /// <code>AND</code>
    /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal
    /// to <code>:sortkeyval1</code>, and less than or equal to
    /// <code>:sortkeyval2</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>begins_with (</code>
    /// <code>sortKeyName</code>, <code>:sortkeyval</code>
    /// <code>)</code> - true if the sort key value begins with a particular operand.
    /// (You cannot use this function with a sort key that is of type Number.) Note that
    /// the function name <code>begins_with</code> is case-sensitive.</p>
    ///
    /// </li>
    /// </ul>
    ///
    /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
    /// <code>:partitionval</code> and <code>:sortval</code> with actual values at
    /// runtime.</p>
    ///
    /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace
    /// the names of the partition key and sort key with placeholder tokens. This option might
    /// be necessary if an attribute name conflicts with a DynamoDB reserved word. For example,
    /// the following <code>KeyConditionExpression</code> parameter causes an error because
    /// <i>Size</i> is a reserved word:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Size = :myval</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the
    /// attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#S = :myval</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
    /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///
    /// <p>For more information on <code>ExpressionAttributeNames</code> and
    /// <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
    /// Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    pub key_condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl QueryInput {
    /// <p>The name of the table containing the requested items.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of an index to query. This index can be any local secondary index or global
    /// secondary index on the table. Note that if you use the <code>IndexName</code> parameter,
    /// you must also provide <code>TableName.</code>
    /// </p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The attributes to be returned in the result. You can retrieve all item attributes,
    /// specific item attributes, the count of matching items, or in the case of an index, some
    /// or all of the attributes projected into the index.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the
    /// specified table or index. If you query a local secondary index, then for each
    /// matching item in the index, DynamoDB fetches the entire item from the parent
    /// table. If the index is configured to project all item attributes, then all of
    /// the data can be obtained from the local secondary index, and no fetching is
    /// required.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index.
    /// Retrieves all attributes that have been projected into the index. If the index
    /// is configured to project all attributes, this return value is equivalent to
    /// specifying <code>ALL_ATTRIBUTES</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COUNT</code> - Returns the number of matching items, rather than the
    /// matching items themselves.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in
    /// <code>AttributesToGet</code>. This return value is equivalent to specifying
    /// <code>AttributesToGet</code> without specifying any value for
    /// <code>Select</code>.</p>
    /// <p>If you query or scan a local secondary index and request only attributes that
    /// are projected into that index, the operation will read only the index and not
    /// the table. If any of the requested attributes are not projected into the local
    /// secondary index, DynamoDB fetches each of these attributes from the parent
    /// table. This extra fetching incurs additional throughput cost and latency.</p>
    /// <p>If you query or scan a global secondary index, you can only request attributes
    /// that are projected into the index. Global secondary index queries cannot fetch
    /// attributes from the parent table.</p>
    /// </li>
    /// </ul>
    /// <p>If neither <code>Select</code> nor <code>AttributesToGet</code> are specified,
    /// DynamoDB defaults to <code>ALL_ATTRIBUTES</code> when accessing a table, and
    /// <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an index. You cannot use both
    /// <code>Select</code> and <code>AttributesToGet</code> together in a single request,
    /// unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
    /// usage is equivalent to specifying <code>AttributesToGet</code> without any value for
    /// <code>Select</code>.)</p>
    /// <note>
    /// <p>If you use the <code>ProjectionExpression</code> parameter, then the value for
    /// <code>Select</code> can only be <code>SPECIFIC_ATTRIBUTES</code>. Any other
    /// value for <code>Select</code> will return an error.</p>
    /// </note>
    pub fn select(&self) -> std::option::Option<&crate::model::Select> {
        self.select.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn attributes_to_get(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes_to_get.as_deref()
    }
    /// <p>The maximum number of items to evaluate (not necessarily the number of matching
    /// items). If DynamoDB processes the number of items up to the limit while processing the
    /// results, it stops the operation and returns the matching values up to that point, and a
    /// key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that you can
    /// pick up where you left off. Also, if the processed dataset size exceeds 1 MB before
    /// DynamoDB reaches this limit, it stops the operation and returns the matching values up
    /// to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
    /// operation to continue the operation. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
    /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
    /// reads.</p>
    /// <p>Strongly consistent reads are not supported on global secondary indexes. If you query
    /// a global secondary index with <code>ConsistentRead</code> set to <code>true</code>, you
    /// will receive a <code>ValidationException</code>.</p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
    /// <p>This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html">KeyConditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn key_conditions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Condition>>
    {
        self.key_conditions.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html">QueryFilter</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn query_filter(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::Condition>>
    {
        self.query_filter.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>FilterExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn conditional_operator(&self) -> std::option::Option<&crate::model::ConditionalOperator> {
        self.conditional_operator.as_ref()
    }
    /// <p>Specifies the order for index traversal: If <code>true</code> (default), the traversal
    /// is performed in ascending order; if <code>false</code>, the traversal is performed in
    /// descending order. </p>
    /// <p>Items with the same partition key value are stored in sorted order by sort key. If the
    /// sort key data type is Number, the results are stored in numeric order. For type String,
    /// the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each
    /// byte of the binary data as unsigned.</p>
    /// <p>If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in
    /// the order in which they are stored (by sort key value). This is the default behavior. If
    /// <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in
    /// reverse order by sort key value, and then returns the results to the client.</p>
    pub fn scan_index_forward(&self) -> std::option::Option<bool> {
        self.scan_index_forward
    }
    /// <p>The primary key of the first item that this operation will evaluate. Use the value
    /// that was returned for <code>LastEvaluatedKey</code> in the previous operation.</p>
    /// <p>The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No
    /// set data types are allowed.</p>
    pub fn exclusive_start_key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.exclusive_start_key.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>A string that identifies one or more attributes to retrieve from the table. These
    /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
    /// the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes will be returned. If any of
    /// the requested attributes are not found, they will not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn projection_expression(&self) -> std::option::Option<&str> {
        self.projection_expression.as_deref()
    }
    /// <p>A string that contains conditions that DynamoDB applies after the <code>Query</code>
    /// operation, but before the data is returned to you. Items that do not satisfy the
    /// <code>FilterExpression</code> criteria are not returned.</p>
    /// <p>A <code>FilterExpression</code> does not allow key attributes. You cannot define a
    /// filter expression based on a partition key or a sort key.</p>
    /// <note>
    /// <p>A <code>FilterExpression</code> is applied after the items have already been read;
    /// the process of filtering does not consume any additional read capacity units.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
    /// Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn filter_expression(&self) -> std::option::Option<&str> {
        self.filter_expression.as_deref()
    }
    /// <p>The condition that specifies the key values for items to be retrieved by the
    /// <code>Query</code> action.</p>
    ///
    /// <p>The condition must perform an equality test on a single partition key value.</p>
    /// <p>The condition can optionally perform one of several comparison tests on a single sort
    /// key value. This allows <code>Query</code> to retrieve one item with a given partition
    /// key value and sort key value, or several items that have the same partition key value
    /// but different sort key values.</p>
    ///
    /// <p>The partition key equality test is required, and must be specified in the following
    /// format:</p>
    ///
    /// <p>
    /// <code>partitionKeyName</code>
    /// <i>=</i>
    /// <code>:partitionkeyval</code>
    /// </p>
    ///
    /// <p>If you also want to provide a condition for the sort key, it must be combined using
    /// <code>AND</code> with the condition for the sort key. Following is an example, using
    /// the <b>=</b> comparison operator for the sort key:</p>
    ///
    /// <p>
    /// <code>partitionKeyName</code>
    /// <code>=</code>
    /// <code>:partitionkeyval</code>
    /// <code>AND</code>
    /// <code>sortKeyName</code>
    /// <code>=</code>
    /// <code>:sortkeyval</code>
    /// </p>
    /// <p>Valid comparisons for the sort key condition are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>=</code>
    /// <code>:sortkeyval</code> - true if the sort key value is equal to
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code><</code>
    /// <code>:sortkeyval</code> - true if the sort key value is less than
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code><=</code>
    /// <code>:sortkeyval</code> - true if the sort key value is less than or equal to
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>></code>
    /// <code>:sortkeyval</code> - true if the sort key value is greater than
    /// <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>>= </code>
    /// <code>:sortkeyval</code> - true if the sort key value is greater than or equal
    /// to <code>:sortkeyval</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sortKeyName</code>
    /// <code>BETWEEN</code>
    /// <code>:sortkeyval1</code>
    /// <code>AND</code>
    /// <code>:sortkeyval2</code> - true if the sort key value is greater than or equal
    /// to <code>:sortkeyval1</code>, and less than or equal to
    /// <code>:sortkeyval2</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>begins_with (</code>
    /// <code>sortKeyName</code>, <code>:sortkeyval</code>
    /// <code>)</code> - true if the sort key value begins with a particular operand.
    /// (You cannot use this function with a sort key that is of type Number.) Note that
    /// the function name <code>begins_with</code> is case-sensitive.</p>
    ///
    /// </li>
    /// </ul>
    ///
    /// <p>Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
    /// <code>:partitionval</code> and <code>:sortval</code> with actual values at
    /// runtime.</p>
    ///
    /// <p>You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace
    /// the names of the partition key and sort key with placeholder tokens. This option might
    /// be necessary if an attribute name conflicts with a DynamoDB reserved word. For example,
    /// the following <code>KeyConditionExpression</code> parameter causes an error because
    /// <i>Size</i> is a reserved word:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Size = :myval</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>To work around this, define a placeholder (such a <code>#S</code>) to represent the
    /// attribute name <i>Size</i>. <code>KeyConditionExpression</code> then is as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#S = :myval</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For a list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
    /// in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    ///
    /// <p>For more information on <code>ExpressionAttributeNames</code> and
    /// <code>ExpressionAttributeValues</code>, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
    /// Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    pub fn key_condition_expression(&self) -> std::option::Option<&str> {
        self.key_condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Specifying Conditions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
}
impl std::fmt::Debug for QueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.field("select", &self.select);
        formatter.field("attributes_to_get", &self.attributes_to_get);
        formatter.field("limit", &self.limit);
        formatter.field("consistent_read", &self.consistent_read);
        formatter.field("key_conditions", &self.key_conditions);
        formatter.field("query_filter", &self.query_filter);
        formatter.field("conditional_operator", &self.conditional_operator);
        formatter.field("scan_index_forward", &self.scan_index_forward);
        formatter.field("exclusive_start_key", &self.exclusive_start_key);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field("projection_expression", &self.projection_expression);
        formatter.field("filter_expression", &self.filter_expression);
        formatter.field("key_condition_expression", &self.key_condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>PutItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutItemInput {
    /// <p>The name of the table to contain the item.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key
    /// attributes are required; you can optionally provide other attribute name-value pairs for
    /// the item.</p>
    /// <p>You must provide all of the attributes for the primary key. For example, with a simple
    /// primary key, you only need to provide a value for the partition key. For a composite
    /// primary key, you must provide both values for both the partition key and the sort
    /// key.</p>
    /// <p>If you specify any attributes that are part of an index key, then the data types for
    /// those attributes must match those of the schema in the table's attribute
    /// definition.</p>
    /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String
    /// and Binary must have a length greater than zero if the attribute is used as a key
    /// attribute for a table or index.</p>
    ///
    /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code>
    /// object.</p>
    pub item: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expected: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    >,
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
    /// before they were updated with the <code>PutItem</code> request. For
    /// <code>PutItem</code>, the valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value
    /// pair, then the content of the old item is returned.</p>
    /// </li>
    /// </ul>
    /// <p>The values returned are strongly consistent.</p>
    /// <note>
    /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
    /// however, <code>PutItem</code> does not recognize any values other than
    /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
    /// </note>
    pub return_values: std::option::Option<crate::model::ReturnValue>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub return_item_collection_metrics:
        std::option::Option<crate::model::ReturnItemCollectionMetrics>,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
    /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code>
    /// operation to succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl PutItemInput {
    /// <p>The name of the table to contain the item.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A map of attribute name/value pairs, one for each attribute. Only the primary key
    /// attributes are required; you can optionally provide other attribute name-value pairs for
    /// the item.</p>
    /// <p>You must provide all of the attributes for the primary key. For example, with a simple
    /// primary key, you only need to provide a value for the partition key. For a composite
    /// primary key, you must provide both values for both the partition key and the sort
    /// key.</p>
    /// <p>If you specify any attributes that are part of an index key, then the data types for
    /// those attributes must match those of the schema in the table's attribute
    /// definition.</p>
    /// <p>Empty String and Binary attribute values are allowed. Attribute values of type String
    /// and Binary must have a length greater than zero if the attribute is used as a key
    /// attribute for a table or index.</p>
    ///
    /// <p>For more information about primary keys, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html#HowItWorks.CoreComponents.PrimaryKey">Primary Key</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    /// <p>Each element in the <code>Item</code> map is an <code>AttributeValue</code>
    /// object.</p>
    pub fn item(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.item.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expected(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    > {
        self.expected.as_ref()
    }
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
    /// before they were updated with the <code>PutItem</code> request. For
    /// <code>PutItem</code>, the valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value
    /// pair, then the content of the old item is returned.</p>
    /// </li>
    /// </ul>
    /// <p>The values returned are strongly consistent.</p>
    /// <note>
    /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
    /// however, <code>PutItem</code> does not recognize any values other than
    /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
    /// </note>
    pub fn return_values(&self) -> std::option::Option<&crate::model::ReturnValue> {
        self.return_values.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub fn return_item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ReturnItemCollectionMetrics> {
        self.return_item_collection_metrics.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn conditional_operator(&self) -> std::option::Option<&crate::model::ConditionalOperator> {
        self.conditional_operator.as_ref()
    }
    /// <p>A condition that must be satisfied in order for a conditional <code>PutItem</code>
    /// operation to succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information on condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
}
impl std::fmt::Debug for PutItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutItemInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("item", &self.item);
        formatter.field("expected", &self.expected);
        formatter.field("return_values", &self.return_values);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field(
            "return_item_collection_metrics",
            &self.return_item_collection_metrics,
        );
        formatter.field("conditional_operator", &self.conditional_operator);
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOfResourceInput {
    /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource
    /// Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An optional string that, if supplied, must be copied from the output of a previous
    /// call to ListTagOfResource. When provided in this manner, this API fetches the next page
    /// of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsOfResourceInput {
    /// <p>The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource
    /// Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An optional string that, if supplied, must be copied from the output of a previous
    /// call to ListTagOfResource. When provided in this manner, this API fetches the next page
    /// of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsOfResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOfResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>ListTables</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesInput {
    /// <p>The first table name that this operation will evaluate. Use the value that was
    /// returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you
    /// can obtain the next page of results.</p>
    pub exclusive_start_table_name: std::option::Option<std::string::String>,
    /// <p>A maximum number of table names to return. If this parameter is not specified, the
    /// limit is 100.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTablesInput {
    /// <p>The first table name that this operation will evaluate. Use the value that was
    /// returned for <code>LastEvaluatedTableName</code> in a previous operation, so that you
    /// can obtain the next page of results.</p>
    pub fn exclusive_start_table_name(&self) -> std::option::Option<&str> {
        self.exclusive_start_table_name.as_deref()
    }
    /// <p>A maximum number of table names to return. If this parameter is not specified, the
    /// limit is 100.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesInput");
        formatter.field(
            "exclusive_start_table_name",
            &self.exclusive_start_table_name,
        );
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGlobalTablesInput {
    /// <p>The first global table name that this operation will evaluate.</p>
    pub exclusive_start_global_table_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of table names to return, if the parameter is not specified
    /// DynamoDB defaults to 100.</p>
    /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the
    /// operation and returns the table names collected up to that point, with a table name in
    /// the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the
    /// <code>ExclusiveStartGlobalTableName</code> parameter.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Lists the global tables in a specific Region.</p>
    pub region_name: std::option::Option<std::string::String>,
}
impl ListGlobalTablesInput {
    /// <p>The first global table name that this operation will evaluate.</p>
    pub fn exclusive_start_global_table_name(&self) -> std::option::Option<&str> {
        self.exclusive_start_global_table_name.as_deref()
    }
    /// <p>The maximum number of table names to return, if the parameter is not specified
    /// DynamoDB defaults to 100.</p>
    /// <p>If the number of global tables DynamoDB finds reaches this limit, it stops the
    /// operation and returns the table names collected up to that point, with a table name in
    /// the <code>LastEvaluatedGlobalTableName</code> to apply in a subsequent operation to the
    /// <code>ExclusiveStartGlobalTableName</code> parameter.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Lists the global tables in a specific Region.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
}
impl std::fmt::Debug for ListGlobalTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGlobalTablesInput");
        formatter.field(
            "exclusive_start_global_table_name",
            &self.exclusive_start_global_table_name,
        );
        formatter.field("limit", &self.limit);
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExportsInput {
    /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional string that, if supplied, must be copied from the output of a previous
    /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
    /// page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExportsInput {
    /// <p>The Amazon Resource Name (ARN) associated with the exported table.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional string that, if supplied, must be copied from the output of a previous
    /// call to <code>ListExports</code>. When provided in this manner, the API fetches the next
    /// page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExportsInput");
        formatter.field("table_arn", &self.table_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContributorInsightsInput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A token to for the desired page, if there is one.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return per page.</p>
    pub max_results: i32,
}
impl ListContributorInsightsInput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A token to for the desired page, if there is one.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return per page.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListContributorInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContributorInsightsInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBackupsInput {
    /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Maximum number of backups to return at once.</p>
    pub limit: std::option::Option<i32>,
    /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is
    /// inclusive.</p>
    pub time_range_lower_bound: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is
    /// exclusive. </p>
    pub time_range_upper_bound: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>
    /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
    /// evaluated when the current page of results was returned, inclusive of the current page
    /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
    /// new <code>ListBackups</code> operation in order to fetch the next page of results.
    /// </p>
    pub exclusive_start_backup_arn: std::option::Option<std::string::String>,
    /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
    /// <p>Where <code>BackupType</code> can be:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>USER</code> - On-demand backup created by you.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
    /// </li>
    /// </ul>
    pub backup_type: std::option::Option<crate::model::BackupTypeFilter>,
}
impl ListBackupsInput {
    /// <p>The backups from the table specified by <code>TableName</code> are listed. </p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Maximum number of backups to return at once.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is
    /// inclusive.</p>
    pub fn time_range_lower_bound(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_range_lower_bound.as_ref()
    }
    /// <p>Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is
    /// exclusive. </p>
    pub fn time_range_upper_bound(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time_range_upper_bound.as_ref()
    }
    /// <p>
    /// <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last
    /// evaluated when the current page of results was returned, inclusive of the current page
    /// of results. This value may be specified as the <code>ExclusiveStartBackupArn</code> of a
    /// new <code>ListBackups</code> operation in order to fetch the next page of results.
    /// </p>
    pub fn exclusive_start_backup_arn(&self) -> std::option::Option<&str> {
        self.exclusive_start_backup_arn.as_deref()
    }
    /// <p>The backups from the table specified by <code>BackupType</code> are listed.</p>
    /// <p>Where <code>BackupType</code> can be:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>USER</code> - On-demand backup created by you.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).</p>
    /// </li>
    /// </ul>
    pub fn backup_type(&self) -> std::option::Option<&crate::model::BackupTypeFilter> {
        self.backup_type.as_ref()
    }
}
impl std::fmt::Debug for ListBackupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBackupsInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("limit", &self.limit);
        formatter.field("time_range_lower_bound", &self.time_range_lower_bound);
        formatter.field("time_range_upper_bound", &self.time_range_upper_bound);
        formatter.field(
            "exclusive_start_backup_arn",
            &self.exclusive_start_backup_arn,
        );
        formatter.field("backup_type", &self.backup_type);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetItemInput {
    /// <p>The name of the table containing the requested item.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
    /// primary key of the item to retrieve.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub attributes_to_get: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
    /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
    /// reads.</p>
    pub consistent_read: std::option::Option<bool>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>A string that identifies one or more attributes to retrieve from the table. These
    /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
    /// the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes are returned. If any of the
    /// requested attributes are not found, they do not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub projection_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetItemInput {
    /// <p>The name of the table containing the requested item.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
    /// primary key of the item to retrieve.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn attributes_to_get(&self) -> std::option::Option<&[std::string::String]> {
        self.attributes_to_get.as_deref()
    }
    /// <p>Determines the read consistency model: If set to <code>true</code>, then the operation
    /// uses strongly consistent reads; otherwise, the operation uses eventually consistent
    /// reads.</p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>A string that identifies one or more attributes to retrieve from the table. These
    /// attributes can include scalars, sets, or elements of a JSON document. The attributes in
    /// the expression must be separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes are returned. If any of the
    /// requested attributes are not found, they do not appear in the result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn projection_expression(&self) -> std::option::Option<&str> {
        self.projection_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
}
impl std::fmt::Debug for GetItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetItemInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("key", &self.key);
        formatter.field("attributes_to_get", &self.attributes_to_get);
        formatter.field("consistent_read", &self.consistent_read);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field("projection_expression", &self.projection_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTableToPointInTimeInput {
    /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
    pub table_arn: std::option::Option<std::string::String>,
    /// <p>Time in the past from which to export table data. The table export will be a snapshot
    /// of the table's state at this point in time.</p>
    pub export_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Providing a <code>ClientToken</code> makes the call to
    /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
    /// identical calls have the same effect as one single call.</p>
    /// <p>A client token is valid for 8 hours after the first request that uses it is completed.
    /// After 8 hours, any request with the same client token is treated as a new request. Do
    /// not resubmit the same request with the same client token for more than 8 hours, or the
    /// result might not be idempotent.</p>
    /// <p>If you submit a request with the same client token but a change in other parameters
    /// within the 8-hour idempotency window, DynamoDB returns an
    /// <code>IdempotentParameterMismatch</code> exception.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be
    /// stored in.</p>
    pub s3_bucket_owner: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
    /// snapshot.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
    /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
    /// for <code>S3SseAlgorithm</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AES256</code> - server-side encryption with Amazon S3 managed
    /// keys</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code> - server-side encryption with KMS managed
    /// keys</p>
    /// </li>
    /// </ul>
    pub s3_sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
    /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where
    /// export data will be stored (if applicable).</p>
    pub s3_sse_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
    /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
    pub export_format: std::option::Option<crate::model::ExportFormat>,
}
impl ExportTableToPointInTimeInput {
    /// <p>The Amazon Resource Name (ARN) associated with the table to export.</p>
    pub fn table_arn(&self) -> std::option::Option<&str> {
        self.table_arn.as_deref()
    }
    /// <p>Time in the past from which to export table data. The table export will be a snapshot
    /// of the table's state at this point in time.</p>
    pub fn export_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.export_time.as_ref()
    }
    /// <p>Providing a <code>ClientToken</code> makes the call to
    /// <code>ExportTableToPointInTimeInput</code> idempotent, meaning that multiple
    /// identical calls have the same effect as one single call.</p>
    /// <p>A client token is valid for 8 hours after the first request that uses it is completed.
    /// After 8 hours, any request with the same client token is treated as a new request. Do
    /// not resubmit the same request with the same client token for more than 8 hours, or the
    /// result might not be idempotent.</p>
    /// <p>If you submit a request with the same client token but a change in other parameters
    /// within the 8-hour idempotency window, DynamoDB returns an
    /// <code>IdempotentParameterMismatch</code> exception.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The ID of the Amazon Web Services account that owns the bucket the export will be
    /// stored in.</p>
    pub fn s3_bucket_owner(&self) -> std::option::Option<&str> {
        self.s3_bucket_owner.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix to use as the file name and path of the exported
    /// snapshot.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
    /// <p>Type of encryption used on the bucket where export data will be stored. Valid values
    /// for <code>S3SseAlgorithm</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AES256</code> - server-side encryption with Amazon S3 managed
    /// keys</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KMS</code> - server-side encryption with KMS managed
    /// keys</p>
    /// </li>
    /// </ul>
    pub fn s3_sse_algorithm(&self) -> std::option::Option<&crate::model::S3SseAlgorithm> {
        self.s3_sse_algorithm.as_ref()
    }
    /// <p>The ID of the KMS managed key used to encrypt the S3 bucket where
    /// export data will be stored (if applicable).</p>
    pub fn s3_sse_kms_key_id(&self) -> std::option::Option<&str> {
        self.s3_sse_kms_key_id.as_deref()
    }
    /// <p>The format for the exported data. Valid values for <code>ExportFormat</code> are
    /// <code>DYNAMODB_JSON</code> or <code>ION</code>.</p>
    pub fn export_format(&self) -> std::option::Option<&crate::model::ExportFormat> {
        self.export_format.as_ref()
    }
}
impl std::fmt::Debug for ExportTableToPointInTimeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTableToPointInTimeInput");
        formatter.field("table_arn", &self.table_arn);
        formatter.field("export_time", &self.export_time);
        formatter.field("client_token", &self.client_token);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_bucket_owner", &self.s3_bucket_owner);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.field("s3_sse_algorithm", &self.s3_sse_algorithm);
        formatter.field("s3_sse_kms_key_id", &self.s3_sse_kms_key_id);
        formatter.field("export_format", &self.export_format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteTransactionInput {
    /// <p>The list of PartiQL statements representing the transaction to run.</p>
    pub transact_statements:
        std::option::Option<std::vec::Vec<crate::model::ParameterizedStatement>>,
    /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
    /// statement response.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is
    /// returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
}
impl ExecuteTransactionInput {
    /// <p>The list of PartiQL statements representing the transaction to run.</p>
    pub fn transact_statements(
        &self,
    ) -> std::option::Option<&[crate::model::ParameterizedStatement]> {
        self.transact_statements.as_deref()
    }
    /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
    /// statement response.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput consumption that is
    /// returned in the response. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactGetItems.html">TransactGetItems</a> and <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_TransactWriteItems.html">TransactWriteItems</a>.</p>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for ExecuteTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteTransactionInput");
        formatter.field("transact_statements", &self.transact_statements);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementInput {
    /// <p>The PartiQL statement representing the operation to run.</p>
    pub statement: std::option::Option<std::string::String>,
    /// <p>The parameters for the PartiQL statement, if any.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::AttributeValue>>,
    /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly
    /// consistent read is used; otherwise, an eventually consistent read is used.</p>
    pub consistent_read: std::option::Option<bool>,
    /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
    /// statement response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
}
impl ExecuteStatementInput {
    /// <p>The PartiQL statement representing the operation to run.</p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
    /// <p>The parameters for the PartiQL statement, if any.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::AttributeValue]> {
        self.parameters.as_deref()
    }
    /// <p>The consistency of a read operation. If set to <code>true</code>, then a strongly
    /// consistent read is used; otherwise, an eventually consistent read is used.</p>
    pub fn consistent_read(&self) -> std::option::Option<bool> {
        self.consistent_read
    }
    /// <p>Set this value to get remaining results, if <code>NextToken</code> was returned in the
    /// statement response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for ExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementInput");
        formatter.field("statement", &self.statement);
        formatter.field("parameters", &self.parameters);
        formatter.field("consistent_read", &self.consistent_read);
        formatter.field("next_token", &self.next_token);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableKinesisStreamingDestinationInput {
    /// <p>The name of the DynamoDB table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The ARN for a Kinesis data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl EnableKinesisStreamingDestinationInput {
    /// <p>The name of the DynamoDB table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The ARN for a Kinesis data stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl std::fmt::Debug for EnableKinesisStreamingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableKinesisStreamingDestinationInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableKinesisStreamingDestinationInput {
    /// <p>The name of the DynamoDB table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The ARN for a Kinesis data stream.</p>
    pub stream_arn: std::option::Option<std::string::String>,
}
impl DisableKinesisStreamingDestinationInput {
    /// <p>The name of the DynamoDB table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The ARN for a Kinesis data stream.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl std::fmt::Debug for DisableKinesisStreamingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableKinesisStreamingDestinationInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("stream_arn", &self.stream_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTimeToLiveInput {
    /// <p>The name of the table to be described.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DescribeTimeToLiveInput {
    /// <p>The name of the table to be described.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeTimeToLiveInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTimeToLiveInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableReplicaAutoScalingInput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DescribeTableReplicaAutoScalingInput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeTableReplicaAutoScalingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableReplicaAutoScalingInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableInput {
    /// <p>The name of the table to describe.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DescribeTableInput {
    /// <p>The name of the table to describe.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DescribeLimits</code> operation. Has no
/// content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLimitsInput {}
impl std::fmt::Debug for DescribeLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLimitsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeKinesisStreamingDestinationInput {
    /// <p>The name of the table being described.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DescribeKinesisStreamingDestinationInput {
    /// <p>The name of the table being described.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeKinesisStreamingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeKinesisStreamingDestinationInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalTableSettingsInput {
    /// <p>The name of the global table to describe.</p>
    pub global_table_name: std::option::Option<std::string::String>,
}
impl DescribeGlobalTableSettingsInput {
    /// <p>The name of the global table to describe.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalTableSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalTableSettingsInput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalTableInput {
    /// <p>The name of the global table.</p>
    pub global_table_name: std::option::Option<std::string::String>,
}
impl DescribeGlobalTableInput {
    /// <p>The name of the global table.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalTableInput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportInput {
    /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
    pub export_arn: std::option::Option<std::string::String>,
}
impl DescribeExportInput {
    /// <p>The Amazon Resource Name (ARN) associated with the export.</p>
    pub fn export_arn(&self) -> std::option::Option<&str> {
        self.export_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportInput");
        formatter.field("export_arn", &self.export_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointsInput {}
impl std::fmt::Debug for DescribeEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContributorInsightsInput {
    /// <p>The name of the table to describe.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the global secondary index to describe, if applicable.</p>
    pub index_name: std::option::Option<std::string::String>,
}
impl DescribeContributorInsightsInput {
    /// <p>The name of the table to describe.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the global secondary index to describe, if applicable.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeContributorInsightsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContributorInsightsInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("index_name", &self.index_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContinuousBackupsInput {
    /// <p>Name of the table for which the customer wants to check the continuous backups and
    /// point in time recovery settings.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DescribeContinuousBackupsInput {
    /// <p>Name of the table for which the customer wants to check the continuous backups and
    /// point in time recovery settings.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeContinuousBackupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContinuousBackupsInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupInput {
    /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    pub backup_arn: std::option::Option<std::string::String>,
}
impl DescribeBackupInput {
    /// <p>The Amazon Resource Name (ARN) associated with the backup.</p>
    pub fn backup_arn(&self) -> std::option::Option<&str> {
        self.backup_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupInput");
        formatter.field("backup_arn", &self.backup_arn);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableInput {
    /// <p>The name of the table to delete.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl DeleteTableInput {
    /// <p>The name of the table to delete.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableInput");
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteItemInput {
    /// <p>The name of the table from which to delete the item.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
    /// primary key of the item to delete.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub key: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expected: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    >,
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub conditional_operator: std::option::Option<crate::model::ConditionalOperator>,
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
    /// before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
    /// however, <code>DeleteItem</code> does not recognize any values other than
    /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
    /// </note>
    pub return_values: std::option::Option<crate::model::ReturnValue>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub return_item_collection_metrics:
        std::option::Option<crate::model::ReturnItemCollectionMetrics>,
    /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code>
    /// to succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub condition_expression: std::option::Option<std::string::String>,
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub expression_attribute_values: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    >,
}
impl DeleteItemInput {
    /// <p>The name of the table from which to delete the item.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A map of attribute names to <code>AttributeValue</code> objects, representing the
    /// primary key of the item to delete.</p>
    /// <p>For the primary key, you must provide all of the attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition key. For a
    /// composite primary key, you must provide values for both the partition key and the sort
    /// key.</p>
    pub fn key(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.key.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html">Expected</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expected(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ExpectedAttributeValue>,
    > {
        self.expected.as_ref()
    }
    /// <p>This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html">ConditionalOperator</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn conditional_operator(&self) -> std::option::Option<&crate::model::ConditionalOperator> {
        self.conditional_operator.as_ref()
    }
    /// <p>Use <code>ReturnValues</code> if you want to get the item attributes as they appeared
    /// before they were deleted. For <code>DeleteItem</code>, the valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its
    /// value is <code>NONE</code>, then nothing is returned. (This setting is the
    /// default for <code>ReturnValues</code>.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL_OLD</code> - The content of the old item is returned.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>ReturnValues</code> parameter is used by several DynamoDB operations;
    /// however, <code>DeleteItem</code> does not recognize any values other than
    /// <code>NONE</code> or <code>ALL_OLD</code>.</p>
    /// </note>
    pub fn return_values(&self) -> std::option::Option<&crate::model::ReturnValue> {
        self.return_values.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub fn return_item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ReturnItemCollectionMetrics> {
        self.return_item_collection_metrics.as_ref()
    }
    /// <p>A condition that must be satisfied in order for a conditional <code>DeleteItem</code>
    /// to succeed.</p>
    /// <p>An expression can contain any of the following:</p>
    /// <ul>
    /// <li>
    /// <p>Functions: <code>attribute_exists | attribute_not_exists | attribute_type |
    /// contains | begins_with | size</code>
    /// </p>
    /// <p>These function names are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Comparison operators: <code>= | <> |
    /// < | > | <= | >= |
    /// BETWEEN | IN </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> Logical operators: <code>AND | OR | NOT</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information about condition expressions, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn condition_expression(&self) -> std::option::Option<&str> {
        self.condition_expression.as_deref()
    }
    /// <p>One or more substitution tokens for attribute names in an expression. The following
    /// are some use cases for using <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name in an
    /// expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being misinterpreted
    /// in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to dereference
    /// an attribute name. For example, consider the following attribute name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be used
    /// directly in an expression. (For the complete list of reserved words, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>). To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character are
    /// <i>expression attribute values</i>, which are placeholders for the
    /// actual value at runtime.</p>
    /// </note>
    /// <p>For more information on expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.expression_attribute_names.as_ref()
    }
    /// <p>One or more values that can be substituted in an expression.</p>
    /// <p>Use the <b>:</b> (colon) character in an expression to
    /// dereference an attribute value. For example, suppose that you wanted to check whether
    /// the value of the <i>ProductStatus</i> attribute was one of the following: </p>
    /// <p>
    /// <code>Available | Backordered | Discontinued</code>
    /// </p>
    /// <p>You would first need to specify <code>ExpressionAttributeValues</code> as
    /// follows:</p>
    /// <p>
    /// <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"},
    /// ":disc":{"S":"Discontinued"} }</code>
    /// </p>
    /// <p>You could then use these values in an expression, such as this:</p>
    /// <p>
    /// <code>ProductStatus IN (:avail, :back, :disc)</code>
    /// </p>
    /// <p>For more information on expression attribute values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html">Condition Expressions</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn expression_attribute_values(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::AttributeValue>,
    > {
        self.expression_attribute_values.as_ref()
    }
}
impl std::fmt::Debug for DeleteItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteItemInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("key", &self.key);
        formatter.field("expected", &self.expected);
        formatter.field("conditional_operator", &self.conditional_operator);
        formatter.field("return_values", &self.return_values);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field(
            "return_item_collection_metrics",
            &self.return_item_collection_metrics,
        );
        formatter.field("condition_expression", &self.condition_expression);
        formatter.field(
            "expression_attribute_names",
            &self.expression_attribute_names,
        );
        formatter.field(
            "expression_attribute_values",
            &self.expression_attribute_values,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBackupInput {
    /// <p>The ARN associated with the backup.</p>
    pub backup_arn: std::option::Option<std::string::String>,
}
impl DeleteBackupInput {
    /// <p>The ARN associated with the backup.</p>
    pub fn backup_arn(&self) -> std::option::Option<&str> {
        self.backup_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBackupInput");
        formatter.field("backup_arn", &self.backup_arn);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateTable</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTableInput {
    /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
    pub attribute_definitions:
        std::option::Option<std::vec::Vec<crate::model::AttributeDefinition>>,
    /// <p>The name of the table to create.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Specifies the attributes that make up the primary key for a table or an index. The
    /// attributes in <code>KeySchema</code> must also be defined in the
    /// <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data
    /// Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AttributeName</code> - The name of this key attribute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeyType</code> - The role that the key attribute will assume:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HASH</code> - partition key</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RANGE</code> - sort key</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The partition key of an item is also known as its <i>hash
    /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage
    /// of an internal hash function to evenly distribute data items across partitions,
    /// based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>.
    /// The term "range attribute" derives from the way DynamoDB stores items with the same
    /// partition key physically close together, in sorted order by the sort key
    /// value.</p>
    /// </note>
    ///
    /// <p>For a simple primary key (partition key), you must provide exactly one element with a
    /// <code>KeyType</code> of <code>HASH</code>.</p>
    /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
    /// elements, in this order: The first element must have a <code>KeyType</code> of
    /// <code>HASH</code>, and the second element must have a <code>KeyType</code> of
    /// <code>RANGE</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub key_schema: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table.
    /// Each index is scoped to a given partition key value. There is a 10 GB size limit per
    /// partition key value; otherwise, the size of a local secondary index is
    /// unconstrained.</p>
    /// <p>Each local secondary index in the array includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IndexName</code> - The name of the local secondary index. Must be unique
    /// only for this table.</p>
    /// <p></p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeySchema</code> - Specifies the key schema for the local secondary index.
    /// The key schema must begin with the same partition key as the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Projection</code> - Specifies attributes that are copied (projected) from
    /// the table into the index. These are in addition to the primary key attributes
    /// and index key attributes, which are automatically projected. Each attribute
    /// specification is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the index and primary keys are
    /// projected into the index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCLUDE</code> - Only the specified table attributes are
    /// projected into the index. The list of projected attributes is in
    /// <code>NonKeyAttributes</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All of the table attributes are projected
    /// into the index.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
    /// names that are projected into the secondary index. The total count of
    /// attributes provided in <code>NonKeyAttributes</code>, summed across all
    /// of the secondary indexes, must not exceed 100. If you project the same
    /// attribute into two different indexes, this counts as two distinct
    /// attributes when determining the total.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub local_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::LocalSecondaryIndex>>,
    /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table.
    /// Each global secondary index in the array includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IndexName</code> - The name of the global secondary index. Must be unique
    /// only for this table.</p>
    /// <p></p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeySchema</code> - Specifies the key schema for the global secondary
    /// index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Projection</code> - Specifies attributes that are copied (projected) from
    /// the table into the index. These are in addition to the primary key attributes
    /// and index key attributes, which are automatically projected. Each attribute
    /// specification is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the index and primary keys are
    /// projected into the index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCLUDE</code> - Only the specified table attributes are
    /// projected into the index. The list of projected attributes is in
    /// <code>NonKeyAttributes</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All of the table attributes are projected
    /// into the index.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
    /// names that are projected into the secondary index. The total count of
    /// attributes provided in <code>NonKeyAttributes</code>, summed across all
    /// of the secondary indexes, must not exceed 100. If you project the same
    /// attribute into two different indexes, this counts as two distinct
    /// attributes when determining the total.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the
    /// global secondary index, consisting of read and write capacity units.</p>
    /// </li>
    /// </ul>
    pub global_secondary_indexes:
        std::option::Option<std::vec::Vec<crate::model::GlobalSecondaryIndex>>,
    /// <p>Controls how you are charged for read and write throughput and how you manage
    /// capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub billing_mode: std::option::Option<crate::model::BillingMode>,
    /// <p>Represents the provisioned throughput settings for a specified table or index. The
    /// settings can be modified using the <code>UpdateTable</code> operation.</p>
    /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property.
    /// If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
    /// property.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
    /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub provisioned_throughput: std::option::Option<crate::model::ProvisionedThroughput>,
    /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
    /// (true) or disabled (false).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>StreamViewType</code> - When an item in the table is modified,
    /// <code>StreamViewType</code> determines what information is written to the
    /// table's stream. Valid values for <code>StreamViewType</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item
    /// are written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was
    /// modified, is written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was
    /// modified, is written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images
    /// of the item are written to the stream.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub stream_specification: std::option::Option<crate::model::StreamSpecification>,
    /// <p>Represents the settings used to enable server-side encryption.</p>
    pub sse_specification: std::option::Option<crate::model::SseSpecification>,
    /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging
    /// for DynamoDB</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and
    /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub table_class: std::option::Option<crate::model::TableClass>,
}
impl CreateTableInput {
    /// <p>An array of attributes that describe the key schema for the table and indexes.</p>
    pub fn attribute_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::AttributeDefinition]> {
        self.attribute_definitions.as_deref()
    }
    /// <p>The name of the table to create.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Specifies the attributes that make up the primary key for a table or an index. The
    /// attributes in <code>KeySchema</code> must also be defined in the
    /// <code>AttributeDefinitions</code> array. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html">Data
    /// Model</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
    /// <p>Each <code>KeySchemaElement</code> in the array is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AttributeName</code> - The name of this key attribute.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeyType</code> - The role that the key attribute will assume:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HASH</code> - partition key</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RANGE</code> - sort key</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The partition key of an item is also known as its <i>hash
    /// attribute</i>. The term "hash attribute" derives from the DynamoDB usage
    /// of an internal hash function to evenly distribute data items across partitions,
    /// based on their partition key values.</p>
    /// <p>The sort key of an item is also known as its <i>range attribute</i>.
    /// The term "range attribute" derives from the way DynamoDB stores items with the same
    /// partition key physically close together, in sorted order by the sort key
    /// value.</p>
    /// </note>
    ///
    /// <p>For a simple primary key (partition key), you must provide exactly one element with a
    /// <code>KeyType</code> of <code>HASH</code>.</p>
    /// <p>For a composite primary key (partition key and sort key), you must provide exactly two
    /// elements, in this order: The first element must have a <code>KeyType</code> of
    /// <code>HASH</code>, and the second element must have a <code>KeyType</code> of
    /// <code>RANGE</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key">Working with Tables</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn key_schema(&self) -> std::option::Option<&[crate::model::KeySchemaElement]> {
        self.key_schema.as_deref()
    }
    /// <p>One or more local secondary indexes (the maximum is 5) to be created on the table.
    /// Each index is scoped to a given partition key value. There is a 10 GB size limit per
    /// partition key value; otherwise, the size of a local secondary index is
    /// unconstrained.</p>
    /// <p>Each local secondary index in the array includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IndexName</code> - The name of the local secondary index. Must be unique
    /// only for this table.</p>
    /// <p></p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeySchema</code> - Specifies the key schema for the local secondary index.
    /// The key schema must begin with the same partition key as the table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Projection</code> - Specifies attributes that are copied (projected) from
    /// the table into the index. These are in addition to the primary key attributes
    /// and index key attributes, which are automatically projected. Each attribute
    /// specification is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the index and primary keys are
    /// projected into the index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCLUDE</code> - Only the specified table attributes are
    /// projected into the index. The list of projected attributes is in
    /// <code>NonKeyAttributes</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All of the table attributes are projected
    /// into the index.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
    /// names that are projected into the secondary index. The total count of
    /// attributes provided in <code>NonKeyAttributes</code>, summed across all
    /// of the secondary indexes, must not exceed 100. If you project the same
    /// attribute into two different indexes, this counts as two distinct
    /// attributes when determining the total.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn local_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::LocalSecondaryIndex]> {
        self.local_secondary_indexes.as_deref()
    }
    /// <p>One or more global secondary indexes (the maximum is 20) to be created on the table.
    /// Each global secondary index in the array includes the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IndexName</code> - The name of the global secondary index. Must be unique
    /// only for this table.</p>
    /// <p></p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KeySchema</code> - Specifies the key schema for the global secondary
    /// index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Projection</code> - Specifies attributes that are copied (projected) from
    /// the table into the index. These are in addition to the primary key attributes
    /// and index key attributes, which are automatically projected. Each attribute
    /// specification is composed of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ProjectionType</code> - One of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the index and primary keys are
    /// projected into the index.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INCLUDE</code> - Only the specified table attributes are
    /// projected into the index. The list of projected attributes is in
    /// <code>NonKeyAttributes</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALL</code> - All of the table attributes are projected
    /// into the index.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NonKeyAttributes</code> - A list of one or more non-key attribute
    /// names that are projected into the secondary index. The total count of
    /// attributes provided in <code>NonKeyAttributes</code>, summed across all
    /// of the secondary indexes, must not exceed 100. If you project the same
    /// attribute into two different indexes, this counts as two distinct
    /// attributes when determining the total.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProvisionedThroughput</code> - The provisioned throughput settings for the
    /// global secondary index, consisting of read and write capacity units.</p>
    /// </li>
    /// </ul>
    pub fn global_secondary_indexes(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalSecondaryIndex]> {
        self.global_secondary_indexes.as_deref()
    }
    /// <p>Controls how you are charged for read and write throughput and how you manage
    /// capacity. This setting can be changed later.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for
    /// predictable workloads. <code>PROVISIONED</code> sets the billing mode to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual">Provisioned Mode</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code>
    /// for unpredictable workloads. <code>PAY_PER_REQUEST</code> sets the billing mode
    /// to <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand">On-Demand Mode</a>. </p>
    /// </li>
    /// </ul>
    pub fn billing_mode(&self) -> std::option::Option<&crate::model::BillingMode> {
        self.billing_mode.as_ref()
    }
    /// <p>Represents the provisioned throughput settings for a specified table or index. The
    /// settings can be modified using the <code>UpdateTable</code> operation.</p>
    /// <p> If you set BillingMode as <code>PROVISIONED</code>, you must specify this property.
    /// If you set BillingMode as <code>PAY_PER_REQUEST</code>, you cannot specify this
    /// property.</p>
    /// <p>For current minimum and maximum provisioned throughput values, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service,
    /// Account, and Table Quotas</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>.</p>
    pub fn provisioned_throughput(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionedThroughput> {
        self.provisioned_throughput.as_ref()
    }
    /// <p>The settings for DynamoDB Streams on the table. These settings consist of:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>StreamEnabled</code> - Indicates whether DynamoDB Streams is to be enabled
    /// (true) or disabled (false).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>StreamViewType</code> - When an item in the table is modified,
    /// <code>StreamViewType</code> determines what information is written to the
    /// table's stream. Valid values for <code>StreamViewType</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>KEYS_ONLY</code> - Only the key attributes of the modified item
    /// are written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_IMAGE</code> - The entire item, as it appears after it was
    /// modified, is written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OLD_IMAGE</code> - The entire item, as it appeared before it was
    /// modified, is written to the stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NEW_AND_OLD_IMAGES</code> - Both the new and the old item images
    /// of the item are written to the stream.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn stream_specification(&self) -> std::option::Option<&crate::model::StreamSpecification> {
        self.stream_specification.as_ref()
    }
    /// <p>Represents the settings used to enable server-side encryption.</p>
    pub fn sse_specification(&self) -> std::option::Option<&crate::model::SseSpecification> {
        self.sse_specification.as_ref()
    }
    /// <p>A list of key-value pairs to label the table. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging
    /// for DynamoDB</a>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The table class of the new table. Valid values are <code>STANDARD</code> and
    /// <code>STANDARD_INFREQUENT_ACCESS</code>.</p>
    pub fn table_class(&self) -> std::option::Option<&crate::model::TableClass> {
        self.table_class.as_ref()
    }
}
impl std::fmt::Debug for CreateTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTableInput");
        formatter.field("attribute_definitions", &self.attribute_definitions);
        formatter.field("table_name", &self.table_name);
        formatter.field("key_schema", &self.key_schema);
        formatter.field("local_secondary_indexes", &self.local_secondary_indexes);
        formatter.field("global_secondary_indexes", &self.global_secondary_indexes);
        formatter.field("billing_mode", &self.billing_mode);
        formatter.field("provisioned_throughput", &self.provisioned_throughput);
        formatter.field("stream_specification", &self.stream_specification);
        formatter.field("sse_specification", &self.sse_specification);
        formatter.field("tags", &self.tags);
        formatter.field("table_class", &self.table_class);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalTableInput {
    /// <p>The global table name.</p>
    pub global_table_name: std::option::Option<std::string::String>,
    /// <p>The Regions where the global table needs to be created.</p>
    pub replication_group: std::option::Option<std::vec::Vec<crate::model::Replica>>,
}
impl CreateGlobalTableInput {
    /// <p>The global table name.</p>
    pub fn global_table_name(&self) -> std::option::Option<&str> {
        self.global_table_name.as_deref()
    }
    /// <p>The Regions where the global table needs to be created.</p>
    pub fn replication_group(&self) -> std::option::Option<&[crate::model::Replica]> {
        self.replication_group.as_deref()
    }
}
impl std::fmt::Debug for CreateGlobalTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalTableInput");
        formatter.field("global_table_name", &self.global_table_name);
        formatter.field("replication_group", &self.replication_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBackupInput {
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>Specified name for the backup.</p>
    pub backup_name: std::option::Option<std::string::String>,
}
impl CreateBackupInput {
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>Specified name for the backup.</p>
    pub fn backup_name(&self) -> std::option::Option<&str> {
        self.backup_name.as_deref()
    }
}
impl std::fmt::Debug for CreateBackupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBackupInput");
        formatter.field("table_name", &self.table_name);
        formatter.field("backup_name", &self.backup_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchWriteItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchWriteItemInput {
    /// <p>A map of one or more table names and, for each table, a list of operations to be
    /// performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the
    /// map consists of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
    /// specified item. The item to be deleted is identified by a <code>Key</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Key</code> - A map of primary key attribute values that uniquely
    /// identify the item. Each entry in this map consists of an attribute name
    /// and an attribute value. For each primary key, you must provide
    /// <i>all</i> of the key attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition
    /// key. For a composite primary key, you must provide values for
    /// <i>both</i> the partition key and the sort key.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
    /// specified item. The item to be put is identified by an <code>Item</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Item</code> - A map of attributes and their values. Each entry in
    /// this map consists of an attribute name and an attribute value. Attribute
    /// values must not be null; string and binary type attributes must have
    /// lengths greater than zero; and set type attributes must not be empty.
    /// Requests that contain empty values are rejected with a
    /// <code>ValidationException</code> exception.</p>
    /// <p>If you specify any attributes that are part of an index key, then the
    /// data types for those attributes must match those of the schema in the
    /// table's attribute definition.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub request_items: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::WriteRequest>>,
    >,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub return_item_collection_metrics:
        std::option::Option<crate::model::ReturnItemCollectionMetrics>,
}
impl BatchWriteItemInput {
    /// <p>A map of one or more table names and, for each table, a list of operations to be
    /// performed (<code>DeleteRequest</code> or <code>PutRequest</code>). Each element in the
    /// map consists of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the
    /// specified item. The item to be deleted is identified by a <code>Key</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Key</code> - A map of primary key attribute values that uniquely
    /// identify the item. Each entry in this map consists of an attribute name
    /// and an attribute value. For each primary key, you must provide
    /// <i>all</i> of the key attributes. For example, with a
    /// simple primary key, you only need to provide a value for the partition
    /// key. For a composite primary key, you must provide values for
    /// <i>both</i> the partition key and the sort key.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the
    /// specified item. The item to be put is identified by an <code>Item</code>
    /// subelement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Item</code> - A map of attributes and their values. Each entry in
    /// this map consists of an attribute name and an attribute value. Attribute
    /// values must not be null; string and binary type attributes must have
    /// lengths greater than zero; and set type attributes must not be empty.
    /// Requests that contain empty values are rejected with a
    /// <code>ValidationException</code> exception.</p>
    /// <p>If you specify any attributes that are part of an index key, then the
    /// data types for those attributes must match those of the schema in the
    /// table's attribute definition.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn request_items(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::WriteRequest>>,
    > {
        self.request_items.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
    /// <p>Determines whether item collection metrics are returned. If set to <code>SIZE</code>,
    /// the response includes statistics about item collections, if any, that were modified
    /// during the operation are returned in the response. If set to <code>NONE</code> (the
    /// default), no statistics are returned.</p>
    pub fn return_item_collection_metrics(
        &self,
    ) -> std::option::Option<&crate::model::ReturnItemCollectionMetrics> {
        self.return_item_collection_metrics.as_ref()
    }
}
impl std::fmt::Debug for BatchWriteItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchWriteItemInput");
        formatter.field("request_items", &self.request_items);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.field(
            "return_item_collection_metrics",
            &self.return_item_collection_metrics,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>BatchGetItem</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetItemInput {
    /// <p>A map of one or more table names and, for each table, a map that describes one or more
    /// items to retrieve from that table. Each table name can be used only once per
    /// <code>BatchGetItem</code> request.</p>
    /// <p>Each element in the map of items to retrieve consists of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read
    /// is used; if <code>false</code> (the default), an eventually consistent read is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for
    /// attribute names in the <code>ProjectionExpression</code> parameter. The
    /// following are some use cases for using
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name
    /// in an expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being
    /// misinterpreted in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to
    /// dereference an attribute name. For example, consider the following attribute
    /// name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be
    /// used directly in an expression. (For the complete list of reserved words, see
    /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
    /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>).
    /// To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this
    /// example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character
    /// are <i>expression attribute values</i>, which are placeholders
    /// for the actual value at runtime.</p>
    /// </note>
    /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Keys</code> - An array of primary key attribute values that define
    /// specific items in the table. For each primary key, you must provide
    /// <i>all</i> of the key attributes. For example, with a simple
    /// primary key, you only need to provide the partition key value. For a composite
    /// key, you must provide <i>both</i> the partition key value and the
    /// sort key value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProjectionExpression</code> - A string that identifies one or more
    /// attributes to retrieve from the table. These attributes can include scalars,
    /// sets, or elements of a JSON document. The attributes in the expression must be
    /// separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes are returned. If any
    /// of the requested attributes are not found, they do not appear in the
    /// result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AttributesToGet</code> - This is a legacy parameter. Use
    /// <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>. </p>
    ///
    /// </li>
    /// </ul>
    pub request_items: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
    >,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
}
impl BatchGetItemInput {
    /// <p>A map of one or more table names and, for each table, a map that describes one or more
    /// items to retrieve from that table. Each table name can be used only once per
    /// <code>BatchGetItem</code> request.</p>
    /// <p>Each element in the map of items to retrieve consists of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConsistentRead</code> - If <code>true</code>, a strongly consistent read
    /// is used; if <code>false</code> (the default), an eventually consistent read is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ExpressionAttributeNames</code> - One or more substitution tokens for
    /// attribute names in the <code>ProjectionExpression</code> parameter. The
    /// following are some use cases for using
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>To access an attribute whose name conflicts with a DynamoDB reserved
    /// word.</p>
    /// </li>
    /// <li>
    /// <p>To create a placeholder for repeating occurrences of an attribute name
    /// in an expression.</p>
    /// </li>
    /// <li>
    /// <p>To prevent special characters in an attribute name from being
    /// misinterpreted in an expression.</p>
    /// </li>
    /// </ul>
    /// <p>Use the <b>#</b> character in an expression to
    /// dereference an attribute name. For example, consider the following attribute
    /// name:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Percentile</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The name of this attribute conflicts with a reserved word, so it cannot be
    /// used directly in an expression. (For the complete list of reserved words, see
    /// <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
    /// Words</a> in the <i>Amazon DynamoDB Developer Guide</i>).
    /// To work around this, you could specify the following for
    /// <code>ExpressionAttributeNames</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>{"#P":"Percentile"}</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>You could then use this substitution in an expression, as in this
    /// example:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#P = :val</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Tokens that begin with the <b>:</b> character
    /// are <i>expression attribute values</i>, which are placeholders
    /// for the actual value at runtime.</p>
    /// </note>
    /// <p>For more information about expression attribute names, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Keys</code> - An array of primary key attribute values that define
    /// specific items in the table. For each primary key, you must provide
    /// <i>all</i> of the key attributes. For example, with a simple
    /// primary key, you only need to provide the partition key value. For a composite
    /// key, you must provide <i>both</i> the partition key value and the
    /// sort key value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProjectionExpression</code> - A string that identifies one or more
    /// attributes to retrieve from the table. These attributes can include scalars,
    /// sets, or elements of a JSON document. The attributes in the expression must be
    /// separated by commas.</p>
    /// <p>If no attribute names are specified, then all attributes are returned. If any
    /// of the requested attributes are not found, they do not appear in the
    /// result.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html">Accessing Item Attributes</a> in the <i>Amazon DynamoDB
    /// Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AttributesToGet</code> - This is a legacy parameter. Use
    /// <code>ProjectionExpression</code> instead. For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html">AttributesToGet</a> in the <i>Amazon DynamoDB Developer
    /// Guide</i>. </p>
    ///
    /// </li>
    /// </ul>
    pub fn request_items(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::KeysAndAttributes>,
    > {
        self.request_items.as_ref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for BatchGetItemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetItemInput");
        formatter.field("request_items", &self.request_items);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementInput {
    /// <p>The list of PartiQL statements representing the batch to run.</p>
    pub statements: std::option::Option<std::vec::Vec<crate::model::BatchStatementRequest>>,
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub return_consumed_capacity: std::option::Option<crate::model::ReturnConsumedCapacity>,
}
impl BatchExecuteStatementInput {
    /// <p>The list of PartiQL statements representing the batch to run.</p>
    pub fn statements(&self) -> std::option::Option<&[crate::model::BatchStatementRequest]> {
        self.statements.as_deref()
    }
    /// <p>Determines the level of detail about either provisioned or on-demand throughput
    /// consumption that is returned in the response:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INDEXES</code> - The response includes the aggregate
    /// <code>ConsumedCapacity</code> for the operation, together with
    /// <code>ConsumedCapacity</code> for each table and secondary index that was
    /// accessed.</p>
    /// <p>Note that some operations, such as <code>GetItem</code> and
    /// <code>BatchGetItem</code>, do not access any indexes at all. In these cases,
    /// specifying <code>INDEXES</code> will only return <code>ConsumedCapacity</code>
    /// information for table(s).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOTAL</code> - The response includes only the aggregate
    /// <code>ConsumedCapacity</code> for the operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code> - No <code>ConsumedCapacity</code> details are included in the
    /// response.</p>
    /// </li>
    /// </ul>
    pub fn return_consumed_capacity(
        &self,
    ) -> std::option::Option<&crate::model::ReturnConsumedCapacity> {
        self.return_consumed_capacity.as_ref()
    }
}
impl std::fmt::Debug for BatchExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementInput");
        formatter.field("statements", &self.statements);
        formatter.field("return_consumed_capacity", &self.return_consumed_capacity);
        formatter.finish()
    }
}
